# -*- warn-indent:false;  -*-

# line 1 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"

# line 661 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"


# THIS IS A GENERATED FILE, DO NOT EDIT DIRECTLY
# This file was generated from lib/regexp_parser/scanner/scanner.rl

class Regexp::Scanner
  # General scanner error (catch all)
  class ScannerError < StandardError; end

  # Base for all scanner validation errors
  class ValidationError < StandardError
    def initialize(reason)
      super reason
    end
  end

  # Unexpected end of pattern
  class PrematureEndError < ScannerError
    def initialize(where = '')
      super "Premature end of pattern at #{where}"
    end
  end

  # Invalid sequence format. Used for escape sequences, mainly.
  class InvalidSequenceError < ValidationError
    def initialize(what = 'sequence', where = '')
      super "Invalid #{what} at #{where}"
    end
  end

  # Invalid group. Used for named groups.
  class InvalidGroupError < ValidationError
    def initialize(what, reason)
      super "Invalid #{what}, #{reason}."
    end
  end

  # Invalid groupOption. Used for inline options.
  class InvalidGroupOption < ValidationError
    def initialize(option, text)
      super "Invalid group option #{option} in #{text}"
    end
  end

  # Invalid back reference. Used for name a number refs/calls.
  class InvalidBackrefError < ValidationError
    def initialize(what, reason)
      super "Invalid back reference #{what}, #{reason}"
    end
  end

  # The property name was not recognized by the scanner.
  class UnknownUnicodePropertyError < ValidationError
    def initialize(name)
      super "Unknown unicode character property name #{name}"
    end
  end

  # Scans the given regular expression text, or Regexp object and collects the
  # emitted token into an array that gets returned at the end. If a block is
  # given, it gets called for each emitted token.
  #
  # This method may raise errors if a syntax error is encountered.
  # --------------------------------------------------------------------------
  def self.scan(input_object, &block)
    new.scan(input_object, &block)
  end

  def scan(input_object, &block)
    self.literal = nil
    stack = []

    if input_object.is_a?(Regexp)
      input = input_object.source
      self.free_spacing = (input_object.options & Regexp::EXTENDED != 0)
    else
      input = input_object
      self.free_spacing = false
    end
    self.spacing_stack = [{:free_spacing => free_spacing, :depth => 0}]

    data  = input.unpack("c*") if input.is_a?(String)
    eof   = data.length

    self.tokens = []
    self.block  = block_given? ? block : nil

    self.set_depth = 0
    self.group_depth = 0
    self.conditional_stack = []

    
# line 98 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
class << self
	attr_accessor :_re_scanner_trans_keys
	private :_re_scanner_trans_keys, :_re_scanner_trans_keys=
end
self._re_scanner_trans_keys = [
	0, 0, -128, -65, -128, -65, 
	-128, -65, -128, -65, -128, 
	-65, -128, -65, 10, 10, 
	41, 41, 39, 122, 33, 122, 
	48, 122, 39, 60, 39, 
	122, 48, 57, 39, 57, 
	48, 57, 39, 57, 39, 122, 
	43, 122, 48, 57, 48, 
	62, 48, 57, 43, 62, 
	43, 122, 44, 125, 48, 125, 
	123, 123, 9, 122, 9, 
	125, 9, 122, -128, -65, 
	-128, -65, 38, 38, 45, 122, 
	45, 122, 93, 93, 94, 
	120, 97, 120, 108, 115, 
	110, 112, 117, 117, 109, 109, 
	58, 58, 93, 93, 104, 
	104, 97, 97, 99, 99, 
	105, 105, 105, 105, 108, 108, 
	97, 97, 110, 110, 107, 
	107, 110, 110, 116, 116, 
	114, 114, 108, 108, 105, 105, 
	103, 103, 105, 105, 116, 
	116, 114, 114, 97, 97, 
	112, 112, 104, 104, 111, 111, 
	119, 119, 101, 101, 114, 
	114, 114, 117, 105, 105, 
	110, 110, 110, 110, 99, 99, 
	112, 112, 97, 97, 99, 
	99, 101, 101, 112, 112, 
	112, 112, 111, 111, 114, 114, 
	100, 100, 100, 100, 65, 
	122, 61, 61, 93, 93, 
	45, 45, 92, 92, 92, 92, 
	45, 45, 92, 92, 92, 
	92, 48, 123, 48, 102, 
	48, 102, 48, 102, 48, 102, 
	9, 125, 9, 125, 9, 
	125, 9, 125, 9, 125, 
	9, 125, 48, 123, 41, 41, 
	39, 122, 41, 57, 48, 
	122, -62, 127, -62, -33, 
	-32, -17, -16, -12, 1, 127, 
	1, 127, 9, 32, 33, 
	126, 10, 126, 63, 63, 
	33, 126, 33, 126, 43, 63, 
	43, 63, 43, 63, 65, 
	122, 43, 63, 68, 119, 
	80, 112, -62, 125, -128, -65, 
	-128, -65, -128, -65, 38, 
	38, 38, 93, 46, 61, 
	48, 122, 36, 125, 48, 55, 
	48, 55, 77, 77, 45, 
	45, 0, 0, 67, 99, 
	45, 45, 0, 0, 92, 92, 
	48, 102, 39, 60, 39, 
	122, 49, 57, 41, 57, 
	48, 122, 0
]

class << self
	attr_accessor :_re_scanner_key_spans
	private :_re_scanner_key_spans, :_re_scanner_key_spans=
end
self._re_scanner_key_spans = [
	0, 64, 64, 64, 64, 64, 64, 1, 
	1, 84, 90, 75, 22, 84, 10, 19, 
	10, 19, 84, 80, 10, 15, 10, 20, 
	80, 82, 78, 1, 114, 117, 114, 64, 
	64, 1, 78, 78, 1, 27, 24, 8, 
	3, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 4, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 58, 1, 1, 
	1, 1, 1, 1, 1, 1, 76, 55, 
	55, 55, 55, 117, 117, 117, 117, 117, 
	117, 76, 1, 84, 17, 75, 190, 30, 
	16, 5, 127, 127, 24, 94, 117, 1, 
	94, 94, 21, 21, 21, 58, 21, 52, 
	33, 188, 64, 64, 64, 1, 56, 16, 
	75, 90, 8, 8, 1, 1, 0, 33, 
	1, 0, 1, 55, 22, 84, 9, 17, 
	75
]

class << self
	attr_accessor :_re_scanner_index_offsets
	private :_re_scanner_index_offsets, :_re_scanner_index_offsets=
end
self._re_scanner_index_offsets = [
	0, 0, 65, 130, 195, 260, 325, 390, 
	392, 394, 479, 570, 646, 669, 754, 765, 
	785, 796, 816, 901, 982, 993, 1009, 1020, 
	1041, 1122, 1205, 1284, 1286, 1401, 1519, 1634, 
	1699, 1764, 1766, 1845, 1924, 1926, 1954, 1979, 
	1988, 1992, 1994, 1996, 1998, 2000, 2002, 2004, 
	2006, 2008, 2010, 2012, 2014, 2016, 2018, 2020, 
	2022, 2024, 2026, 2028, 2030, 2032, 2034, 2036, 
	2038, 2040, 2042, 2044, 2046, 2048, 2050, 2055, 
	2057, 2059, 2061, 2063, 2065, 2067, 2069, 2071, 
	2073, 2075, 2077, 2079, 2081, 2083, 2142, 2144, 
	2146, 2148, 2150, 2152, 2154, 2156, 2158, 2235, 
	2291, 2347, 2403, 2459, 2577, 2695, 2813, 2931, 
	3049, 3167, 3244, 3246, 3331, 3349, 3425, 3616, 
	3647, 3664, 3670, 3798, 3926, 3951, 4046, 4164, 
	4166, 4261, 4356, 4378, 4400, 4422, 4481, 4503, 
	4556, 4590, 4779, 4844, 4909, 4974, 4976, 5033, 
	5050, 5126, 5217, 5226, 5235, 5237, 5239, 5240, 
	5274, 5276, 5277, 5279, 5335, 5358, 5443, 5453, 
	5471
]

class << self
	attr_accessor :_re_scanner_indicies
	private :_re_scanner_indicies, :_re_scanner_indicies=
end
self._re_scanner_indicies = [
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 0, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 0, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 0, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 0, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 0, 9, 8, 
	12, 11, 13, 10, 10, 10, 10, 10, 
	10, 10, 10, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 10, 10, 10, 
	10, 10, 10, 10, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 10, 10, 
	10, 10, 14, 10, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 10, 15, 
	10, 10, 10, 10, 10, 10, 10, 10, 
	10, 10, 10, 10, 10, 10, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	10, 10, 10, 15, 13, 10, 10, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 10, 10, 10, 10, 16, 10, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 10, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 10, 10, 10, 10, 
	13, 10, 10, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 10, 10, 10, 
	10, 16, 10, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 10, 18, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 19, 17, 20, 17, 17, 
	17, 21, 17, 22, 17, 17, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	17, 17, 17, 17, 17, 17, 17, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 17, 17, 17, 17, 23, 17, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 17, 24, 24, 24, 24, 24, 24, 
	24, 24, 24, 24, 17, 20, 17, 17, 
	17, 17, 17, 17, 17, 17, 24, 24, 
	24, 24, 24, 24, 24, 24, 24, 24, 
	17, 24, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 17, 20, 17, 17, 17, 
	21, 17, 21, 17, 17, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 17, 
	20, 17, 17, 17, 21, 17, 21, 17, 
	17, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 17, 17, 17, 17, 17, 
	17, 17, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 17, 17, 17, 17, 
	23, 17, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 23, 23, 23, 23, 
	23, 23, 23, 23, 17, 26, 17, 27, 
	17, 17, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 17, 17, 17, 17, 
	20, 17, 17, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 17, 17, 17, 
	17, 28, 17, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 17, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	17, 29, 29, 29, 29, 29, 29, 29, 
	29, 29, 29, 17, 17, 17, 17, 20, 
	17, 29, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 17, 26, 17, 26, 17, 
	17, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 17, 17, 17, 17, 20, 
	17, 26, 17, 26, 17, 17, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	17, 17, 17, 17, 20, 17, 17, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 17, 17, 17, 17, 28, 17, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 17, 32, 31, 31, 31, 33, 33, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 34, 31, 32, 32, 32, 
	32, 32, 32, 32, 32, 32, 32, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 34, 31, 35, 36, 37, 37, 
	37, 37, 37, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 37, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 37, 37, 36, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 36, 
	36, 36, 37, 36, 36, 36, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	36, 36, 36, 38, 37, 36, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	36, 37, 37, 37, 37, 37, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	37, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 37, 37, 36, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 36, 36, 36, 37, 36, 36, 
	36, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 36, 36, 36, 36, 37, 
	36, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 36, 36, 39, 36, 37, 
	37, 37, 37, 37, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 37, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 37, 37, 36, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	36, 36, 36, 37, 36, 36, 36, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 36, 36, 36, 36, 37, 36, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 36, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 40, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 40, 44, 43, 47, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 46, 46, 46, 46, 
	46, 46, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 46, 47, 48, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 46, 46, 46, 46, 46, 
	46, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 46, 49, 46, 50, 46, 
	46, 51, 52, 53, 54, 46, 46, 55, 
	46, 46, 46, 46, 56, 46, 46, 46, 
	57, 46, 46, 58, 46, 59, 46, 60, 
	61, 46, 51, 52, 53, 54, 46, 46, 
	55, 46, 46, 46, 46, 56, 46, 46, 
	46, 57, 46, 46, 58, 46, 59, 46, 
	60, 61, 46, 62, 46, 46, 46, 46, 
	46, 46, 63, 46, 64, 46, 65, 46, 
	66, 46, 67, 46, 68, 46, 69, 46, 
	70, 46, 67, 46, 71, 46, 72, 46, 
	67, 46, 73, 46, 74, 46, 75, 46, 
	67, 46, 76, 46, 77, 46, 78, 46, 
	67, 46, 79, 46, 80, 46, 81, 46, 
	67, 46, 82, 46, 83, 46, 84, 46, 
	67, 46, 85, 46, 86, 46, 87, 46, 
	67, 46, 88, 46, 46, 89, 46, 90, 
	46, 81, 46, 91, 46, 81, 46, 92, 
	46, 93, 46, 94, 46, 67, 46, 95, 
	46, 86, 46, 96, 46, 97, 46, 67, 
	46, 54, 46, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 46, 46, 46, 
	46, 46, 46, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 46, 99, 46, 
	100, 46, 101, 36, 103, 102, 105, 102, 
	106, 36, 108, 107, 110, 107, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	36, 36, 36, 36, 36, 36, 36, 111, 
	111, 111, 111, 111, 111, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 111, 
	111, 111, 111, 111, 111, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 112, 36, 113, 113, 113, 113, 113, 
	113, 113, 113, 113, 113, 36, 36, 36, 
	36, 36, 36, 36, 113, 113, 113, 113, 
	113, 113, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 113, 113, 113, 113, 
	113, 113, 36, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 36, 36, 36, 
	36, 36, 36, 36, 114, 114, 114, 114, 
	114, 114, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 114, 114, 114, 114, 
	114, 114, 36, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 36, 36, 36, 
	36, 36, 36, 36, 115, 115, 115, 115, 
	115, 115, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 115, 115, 115, 115, 
	115, 115, 36, 116, 116, 116, 116, 116, 
	116, 116, 116, 116, 116, 36, 36, 36, 
	36, 36, 36, 36, 116, 116, 116, 116, 
	116, 116, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 116, 116, 116, 116, 
	116, 116, 36, 112, 112, 112, 112, 112, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 112, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 36, 36, 36, 36, 
	36, 36, 36, 117, 117, 117, 117, 117, 
	117, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 117, 117, 117, 117, 117, 
	117, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 115, 
	36, 112, 112, 112, 112, 112, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	112, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 36, 36, 36, 36, 36, 36, 
	36, 118, 118, 118, 118, 118, 118, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 118, 118, 118, 118, 118, 118, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 115, 36, 112, 
	112, 112, 112, 112, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 112, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	36, 36, 36, 36, 36, 36, 36, 119, 
	119, 119, 119, 119, 119, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 119, 
	119, 119, 119, 119, 119, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 115, 36, 112, 112, 112, 
	112, 112, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 112, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 120, 120, 120, 120, 
	120, 120, 120, 120, 120, 120, 36, 36, 
	36, 36, 36, 36, 36, 120, 120, 120, 
	120, 120, 120, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 120, 120, 120, 
	120, 120, 120, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 115, 36, 112, 112, 112, 112, 112, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 112, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 121, 121, 121, 121, 121, 121, 
	121, 121, 121, 121, 36, 36, 36, 36, 
	36, 36, 36, 121, 121, 121, 121, 121, 
	121, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 121, 121, 121, 121, 121, 
	121, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 115, 
	36, 112, 112, 112, 112, 112, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	112, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 115, 36, 123, 
	123, 123, 123, 123, 123, 123, 123, 123, 
	123, 122, 122, 122, 122, 122, 122, 122, 
	123, 123, 123, 123, 123, 123, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 122, 
	123, 123, 123, 123, 123, 123, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 122, 
	122, 122, 36, 122, 125, 124, 126, 124, 
	124, 124, 124, 124, 124, 124, 124, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 124, 124, 124, 124, 124, 124, 124, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 124, 124, 124, 124, 127, 124, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 124, 125, 124, 124, 124, 124, 
	124, 124, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 124, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 124, 
	124, 124, 124, 126, 124, 124, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	124, 124, 124, 124, 129, 124, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	124, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 130, 131, 
	131, 131, 131, 131, 131, 131, 131, 131, 
	131, 131, 131, 131, 131, 131, 131, 132, 
	132, 132, 132, 132, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	134, 134, 134, 134, 134, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 135, 
	136, 136, 137, 138, 136, 136, 136, 139, 
	140, 141, 142, 136, 136, 143, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 144, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 145, 146, 31, 147, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 33, 148, 31, 136, 133, 31, 
	130, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 149, 131, 
	131, 131, 131, 131, 131, 131, 131, 131, 
	131, 131, 131, 131, 131, 131, 131, 149, 
	132, 132, 132, 132, 132, 149, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 149, 149, 149, 149, 
	149, 149, 149, 149, 133, 149, 133, 133, 
	133, 133, 133, 133, 133, 133, 134, 134, 
	134, 134, 134, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 133, 133, 133, 
	133, 133, 133, 133, 133, 135, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 133, 150, 135, 135, 
	135, 135, 135, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 135, 150, 136, 
	136, 136, 149, 136, 136, 136, 149, 149, 
	149, 149, 136, 136, 149, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 149, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 149, 149, 149, 149, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 149, 149, 149, 136, 149, 9, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 137, 137, 137, 
	8, 137, 137, 137, 8, 8, 8, 8, 
	137, 137, 8, 137, 137, 137, 137, 137, 
	137, 137, 137, 137, 137, 137, 137, 137, 
	137, 137, 137, 8, 137, 137, 137, 137, 
	137, 137, 137, 137, 137, 137, 137, 137, 
	137, 137, 137, 137, 137, 137, 137, 137, 
	137, 137, 137, 137, 137, 137, 137, 8, 
	8, 8, 8, 137, 137, 137, 137, 137, 
	137, 137, 137, 137, 137, 137, 137, 137, 
	137, 137, 137, 137, 137, 137, 137, 137, 
	137, 137, 137, 137, 137, 137, 137, 8, 
	8, 8, 137, 8, 152, 151, 15, 154, 
	11, 154, 154, 154, 14, 155, 153, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 13, 
	154, 156, 15, 13, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 13, 154, 153, 154, 153, 
	154, 154, 154, 153, 153, 153, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 157, 154, 
	153, 153, 153, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 154, 154, 154, 154, 154, 154, 
	154, 154, 153, 154, 159, 158, 158, 158, 
	158, 158, 158, 158, 158, 158, 158, 158, 
	158, 158, 158, 158, 158, 158, 158, 158, 
	159, 158, 161, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 161, 160, 
	163, 162, 162, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 162, 162, 162, 162, 
	162, 162, 162, 162, 163, 162, 165, 165, 
	164, 164, 164, 164, 165, 164, 164, 164, 
	166, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 165, 
	164, 164, 164, 164, 164, 164, 164, 165, 
	164, 164, 164, 164, 167, 164, 164, 164, 
	167, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 165, 
	164, 169, 168, 168, 168, 168, 168, 168, 
	168, 168, 168, 168, 168, 168, 168, 168, 
	168, 168, 168, 168, 168, 169, 168, 170, 
	36, 36, 36, 170, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 170, 170, 36, 
	36, 36, 170, 170, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 170, 
	36, 36, 36, 170, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 170, 36, 
	36, 36, 170, 36, 171, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 171, 36, 172, 172, 
	172, 172, 172, 172, 172, 172, 172, 172, 
	172, 172, 172, 172, 172, 172, 172, 172, 
	172, 172, 172, 172, 172, 172, 172, 172, 
	172, 172, 172, 172, 173, 173, 173, 173, 
	173, 173, 173, 173, 173, 173, 173, 173, 
	173, 173, 173, 173, 174, 174, 174, 174, 
	174, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	175, 41, 176, 41, 175, 175, 175, 175, 
	41, 177, 175, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 175, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 178, 
	179, 180, 181, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 175, 
	175, 175, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 182, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 182, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 183, 183, 183, 
	183, 183, 183, 183, 183, 182, 184, 182, 
	186, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 185, 
	185, 185, 185, 185, 185, 185, 185, 187, 
	185, 190, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 191, 189, 189, 
	192, 189, 194, 194, 194, 194, 194, 194, 
	194, 194, 194, 194, 193, 193, 193, 193, 
	193, 193, 193, 194, 194, 194, 193, 193, 
	193, 194, 193, 193, 193, 194, 193, 194, 
	193, 193, 193, 193, 194, 193, 193, 193, 
	193, 193, 194, 193, 194, 193, 193, 193, 
	193, 193, 193, 193, 193, 194, 193, 193, 
	193, 194, 193, 193, 193, 194, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 194, 193, 196, 195, 
	195, 195, 196, 196, 196, 196, 195, 195, 
	196, 195, 197, 198, 198, 198, 198, 198, 
	198, 198, 199, 199, 195, 195, 195, 195, 
	195, 196, 195, 36, 36, 200, 201, 195, 
	195, 36, 201, 195, 195, 36, 195, 202, 
	195, 195, 203, 195, 201, 201, 195, 195, 
	195, 201, 201, 195, 36, 196, 196, 196, 
	196, 195, 195, 204, 204, 101, 201, 204, 
	204, 36, 201, 195, 195, 36, 195, 195, 
	204, 195, 203, 195, 204, 201, 204, 205, 
	204, 201, 206, 195, 36, 196, 196, 196, 
	195, 208, 208, 208, 208, 208, 208, 208, 
	208, 207, 210, 210, 210, 210, 210, 210, 
	210, 210, 209, 212, 102, 214, 213, 102, 
	216, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	217, 107, 219, 218, 107, 110, 107, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 221, 221, 221, 221, 221, 221, 221, 
	222, 222, 222, 222, 222, 222, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 221, 221, 
	222, 222, 222, 222, 222, 222, 221, 224, 
	223, 223, 223, 223, 223, 225, 223, 223, 
	223, 226, 226, 226, 226, 226, 226, 226, 
	226, 226, 223, 223, 227, 223, 126, 228, 
	228, 228, 228, 228, 228, 228, 228, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 228, 228, 228, 228, 228, 228, 228, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 228, 228, 228, 228, 127, 228, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 127, 127, 127, 127, 127, 127, 
	127, 127, 228, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 228, 125, 228, 228, 
	228, 228, 228, 228, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 228, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 228, 228, 228, 228, 126, 228, 228, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 228, 228, 228, 228, 129, 228, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 129, 129, 129, 129, 129, 129, 
	129, 129, 228, 0
]

class << self
	attr_accessor :_re_scanner_trans_targs
	private :_re_scanner_trans_targs, :_re_scanner_trans_targs=
end
self._re_scanner_trans_targs = [
	110, 111, 3, 112, 5, 6, 113, 110, 
	7, 110, 110, 8, 110, 110, 9, 110, 
	11, 110, 13, 19, 110, 14, 16, 18, 
	15, 17, 20, 22, 24, 21, 23, 0, 
	26, 25, 126, 28, 0, 29, 30, 128, 
	129, 129, 31, 129, 129, 129, 129, 35, 
	36, 129, 38, 39, 50, 54, 58, 62, 
	66, 70, 75, 79, 81, 84, 40, 47, 
	41, 45, 42, 43, 44, 129, 46, 48, 
	49, 51, 52, 53, 55, 56, 57, 59, 
	60, 61, 63, 64, 65, 67, 68, 69, 
	71, 73, 72, 74, 76, 77, 78, 80, 
	82, 83, 86, 87, 129, 89, 137, 140, 
	137, 142, 92, 137, 143, 137, 145, 95, 
	98, 96, 97, 137, 99, 100, 101, 102, 
	103, 104, 137, 147, 148, 148, 106, 107, 
	108, 109, 1, 2, 4, 114, 115, 116, 
	117, 118, 110, 119, 110, 122, 123, 110, 
	124, 110, 125, 110, 110, 110, 110, 110, 
	120, 110, 121, 110, 10, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 12, 
	110, 110, 127, 27, 130, 131, 132, 129, 
	133, 134, 135, 129, 129, 129, 129, 32, 
	129, 129, 33, 129, 129, 129, 34, 37, 
	85, 136, 136, 137, 137, 138, 138, 137, 
	88, 137, 91, 137, 137, 94, 105, 137, 
	139, 137, 137, 137, 141, 137, 90, 137, 
	144, 146, 137, 93, 137, 137, 137, 148, 
	149, 150, 151, 152, 148
]

class << self
	attr_accessor :_re_scanner_trans_actions
	private :_re_scanner_trans_actions, :_re_scanner_trans_actions=
end
self._re_scanner_trans_actions = [
	1, 2, 0, 2, 0, 0, 2, 3, 
	0, 4, 5, 6, 7, 8, 0, 9, 
	0, 10, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 12, 
	0, 0, 0, 0, 0, 0, 0, 14, 
	15, 16, 0, 17, 18, 19, 20, 0, 
	0, 21, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 22, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 23, 0, 24, 0, 
	25, 0, 0, 26, 0, 27, 0, 0, 
	0, 0, 0, 28, 0, 0, 0, 0, 
	0, 0, 29, 0, 30, 31, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 34, 35, 36, 37, 0, 0, 38, 
	0, 39, 34, 40, 41, 42, 43, 44, 
	45, 46, 0, 47, 0, 48, 49, 50, 
	51, 52, 53, 54, 55, 56, 57, 0, 
	58, 59, 61, 0, 0, 34, 34, 62, 
	0, 34, 63, 64, 65, 66, 67, 0, 
	68, 69, 0, 70, 71, 72, 0, 0, 
	0, 73, 74, 75, 76, 77, 78, 79, 
	0, 80, 0, 81, 82, 0, 0, 83, 
	0, 84, 85, 86, 34, 87, 0, 88, 
	34, 0, 89, 0, 90, 91, 92, 93, 
	34, 34, 34, 34, 94
]

class << self
	attr_accessor :_re_scanner_to_state_actions
	private :_re_scanner_to_state_actions, :_re_scanner_to_state_actions=
end
self._re_scanner_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 32, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 60, 
	60, 60, 0, 0, 0, 0, 0, 0, 
	60, 60, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 60, 0, 0, 0, 
	0
]

class << self
	attr_accessor :_re_scanner_from_state_actions
	private :_re_scanner_from_state_actions, :_re_scanner_from_state_actions=
end
self._re_scanner_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 33, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 33, 
	33, 33, 0, 0, 0, 0, 0, 0, 
	33, 33, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 33, 0, 0, 0, 
	0
]

class << self
	attr_accessor :_re_scanner_eof_actions
	private :_re_scanner_eof_actions, :_re_scanner_eof_actions=
end
self._re_scanner_eof_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 12, 12, 13, 13, 13, 13, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	12, 12, 0, 12, 12, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 12, 0, 0, 0, 0, 0, 0, 
	0, 12, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0
]

class << self
	attr_accessor :_re_scanner_eof_trans
	private :_re_scanner_eof_trans, :_re_scanner_eof_trans=
end
self._re_scanner_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 8, 
	11, 11, 11, 11, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 0, 0, 0, 0, 0, 0, 41, 
	41, 44, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	0, 0, 105, 0, 0, 110, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 125, 125, 125, 125, 0, 150, 
	150, 150, 150, 151, 151, 150, 150, 152, 
	154, 154, 159, 161, 163, 165, 169, 0, 
	0, 0, 183, 183, 183, 183, 186, 189, 
	0, 0, 208, 210, 212, 212, 212, 216, 
	216, 216, 216, 221, 0, 229, 229, 229, 
	229
]

class << self
	attr_accessor :re_scanner_start
end
self.re_scanner_start = 110;
class << self
	attr_accessor :re_scanner_first_final
end
self.re_scanner_first_final = 110;
class << self
	attr_accessor :re_scanner_error
end
self.re_scanner_error = 0;

class << self
	attr_accessor :re_scanner_en_char_type
end
self.re_scanner_en_char_type = 127;
class << self
	attr_accessor :re_scanner_en_unicode_property
end
self.re_scanner_en_unicode_property = 128;
class << self
	attr_accessor :re_scanner_en_character_set
end
self.re_scanner_en_character_set = 129;
class << self
	attr_accessor :re_scanner_en_set_escape_sequence
end
self.re_scanner_en_set_escape_sequence = 136;
class << self
	attr_accessor :re_scanner_en_escape_sequence
end
self.re_scanner_en_escape_sequence = 137;
class << self
	attr_accessor :re_scanner_en_conditional_expression
end
self.re_scanner_en_conditional_expression = 148;
class << self
	attr_accessor :re_scanner_en_main
end
self.re_scanner_en_main = 110;


# line 753 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
    
# line 1144 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
begin
	p ||= 0
	pe ||= data.length
	cs = re_scanner_start
	top = 0
	ts = nil
	te = nil
	act = 0
end

# line 754 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
    
# line 1157 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _re_scanner_from_state_actions[cs] 
	when 33 then
# line 1 "NONE"
		begin
ts = p
		end
# line 1185 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
	end
	_keys = cs << 1
	_inds = _re_scanner_index_offsets[cs]
	_slen = _re_scanner_key_spans[cs]
	_wide = data[p].ord
	_trans = if (   _slen > 0 && 
			_re_scanner_trans_keys[_keys] <= _wide && 
			_wide <= _re_scanner_trans_keys[_keys + 1] 
		    ) then
			_re_scanner_indicies[ _inds + _wide - _re_scanner_trans_keys[_keys] ] 
		 else 
			_re_scanner_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	cs = _re_scanner_trans_targs[_trans]
	if _re_scanner_trans_actions[_trans] != 0
	case _re_scanner_trans_actions[_trans]
	when 12 then
# line 131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
	when 36 then
# line 143 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1 		end
	when 6 then
# line 144 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
	when 34 then
# line 1 "NONE"
		begin
te = p+1
		end
	when 61 then
# line 12 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/char_type.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te, 1).first
      when '\d'; emit(:type, :digit,      text, ts - 1, te)
      when '\D'; emit(:type, :nondigit,   text, ts - 1, te)
      when '\h'; emit(:type, :hex,        text, ts - 1, te)
      when '\H'; emit(:type, :nonhex,     text, ts - 1, te)
      when '\s'; emit(:type, :space,      text, ts - 1, te)
      when '\S'; emit(:type, :nonspace,   text, ts - 1, te)
      when '\w'; emit(:type, :word,       text, ts - 1, te)
      when '\W'; emit(:type, :nonword,    text, ts - 1, te)
      when '\R'; emit(:type, :linebreak,  text, ts - 1, te)
      when '\X'; emit(:type, :xgrapheme,  text, ts - 1, te)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 14 then
# line 16 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/property.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te, 1).first
      type = (text[1] == 'P') ^ (text[3] == '^') ? :nonproperty : :property

      name = data[ts+2..te-2].pack('c*').gsub(/[\^\s_\-]/, '').downcase

      token = self.class.short_prop_map[name] || self.class.long_prop_map[name]
      raise UnknownUnicodePropertyError.new(name) unless token

      self.emit(type, token.to_sym, text, ts-1, te)

      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 18 then
# line 171 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, '-', ts, te)
      emit(:set, :intersection, '&&', ts, te)
     end
		end
	when 66 then
# line 176 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te).first
      if tokens.last[1] == :open
        emit(:set, :negate, text, ts, te)
      else
        emit(:literal, :literal, text, ts, te)
      end
     end
		end
	when 68 then
# line 197 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :intersection, *text(data, ts, te))
     end
		end
	when 64 then
# line 201 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 136
		_goto_level = _again
		next
	end

     end
		end
	when 62 then
# line 231 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:literal, :literal, *text(data, ts, te))
     end
		end
	when 16 then
# line 239 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      char, *rest = *text(data, ts, te)
      char.force_encoding('utf-8') if char.respond_to?(:force_encoding)
      emit(:literal, :literal, char, *rest)
     end
		end
	when 69 then
# line 185 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = text(data, ts, te).first
      # ranges cant start with a subset or intersection/negation/range operator
      if tokens.last[0] == :set
        emit(:literal, :literal, text, ts, te)
      else
        emit(:set, :range, text, ts, te)
      end
     end
		end
	when 72 then
# line 205 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 129
		_goto_level = _again
		next
	end

     end
		end
	when 67 then
# line 239 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      char, *rest = *text(data, ts, te)
      char.force_encoding('utf-8') if char.respond_to?(:force_encoding)
      emit(:literal, :literal, char, *rest)
     end
		end
	when 17 then
# line 185 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = text(data, ts, te).first
      # ranges cant start with a subset or intersection/negation/range operator
      if tokens.last[0] == :set
        emit(:literal, :literal, text, ts, te)
      else
        emit(:set, :range, text, ts, te)
      end
     end
		end
	when 20 then
# line 205 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 129
		_goto_level = _again
		next
	end

     end
		end
	when 15 then
# line 239 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      char, *rest = *text(data, ts, te)
      char.force_encoding('utf-8') if char.respond_to?(:force_encoding)
      emit(:literal, :literal, char, *rest)
     end
		end
	when 74 then
# line 249 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 73 then
# line 254 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = 129;
      	begin
		stack[top] = cs
		top+= 1
		cs = 137
		_goto_level = _again
		next
	end

     end
		end
	when 79 then
# line 265 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te, 1).first
      emit(:backref, :number, text, ts-1, te)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 85 then
# line 271 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :octal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 76 then
# line 276 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te, 1).first
      when '\.';  emit(:escape, :dot,               text, ts-1, te)
      when '\|';  emit(:escape, :alternation,       text, ts-1, te)
      when '\^';  emit(:escape, :bol,               text, ts-1, te)
      when '\$';  emit(:escape, :eol,               text, ts-1, te)
      when '\?';  emit(:escape, :zero_or_one,       text, ts-1, te)
      when '\*';  emit(:escape, :zero_or_more,      text, ts-1, te)
      when '\+';  emit(:escape, :one_or_more,       text, ts-1, te)
      when '\(';  emit(:escape, :group_open,        text, ts-1, te)
      when '\)';  emit(:escape, :group_close,       text, ts-1, te)
      when '\{';  emit(:escape, :interval_open,     text, ts-1, te)
      when '\}';  emit(:escape, :interval_close,    text, ts-1, te)
      when '\[';  emit(:escape, :set_open,          text, ts-1, te)
      when '\]';  emit(:escape, :set_close,         text, ts-1, te)
      when "\\\\";
        emit(:escape, :backslash, text, ts-1, te)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 82 then
# line 297 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      # \b is emitted as backspace only when inside a character set, otherwise
      # it is a word boundary anchor. A syntax might "normalize" it if needed.
      case text = text(data, ts, te, 1).first
      when '\a'; emit(:escape, :bell,           text, ts-1, te)
      when '\b'; emit(:escape, :backspace,      text, ts-1, te)
      when '\e'; emit(:escape, :escape,         text, ts-1, te)
      when '\f'; emit(:escape, :form_feed,      text, ts-1, te)
      when '\n'; emit(:escape, :newline,        text, ts-1, te)
      when '\r'; emit(:escape, :carriage,       text, ts-1, te)
      when '\t'; emit(:escape, :tab,            text, ts-1, te)
      when '\v'; emit(:escape, :vertical_tab,   text, ts-1, te)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 28 then
# line 313 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te, 1).first
      if text[2].chr == '{'
        emit(:escape, :codepoint_list, text, ts-1, te)
      else
        emit(:escape, :codepoint,      text, ts-1, te)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 92 then
# line 323 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :hex, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 24 then
# line 332 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 26 then
# line 337 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 80 then
# line 342 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set? ? 129 : 110));
      	begin
		stack[top] = cs
		top+= 1
		cs = 127
		_goto_level = _again
		next
	end

     end
		end
	when 81 then
# line 348 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set? ? 129 : 110));
      	begin
		stack[top] = cs
		top+= 1
		cs = 128
		_goto_level = _again
		next
	end

     end
		end
	when 75 then
# line 354 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 84 then
# line 271 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :octal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 91 then
# line 323 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :hex, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 87 then
# line 332 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 89 then
# line 337 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 83 then
# line 1 "NONE"
		begin
	case act
	when 18 then
	begin begin p = ((te))-1; end

      text = text(data, ts, te, 1).first
      emit(:backref, :number, text, ts-1, te)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
	when 19 then
	begin begin p = ((te))-1; end

      emit(:escape, :octal, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
end 
			end
	when 31 then
# line 364 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te-1).first
      emit(:conditional, :condition, text, ts, te-1)
      emit(:conditional, :condition_close, ')', te-1, te)
     end
		end
	when 93 then
# line 370 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 110
		_goto_level = _again
		next
	end

     end
		end
	when 94 then
# line 370 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 110
		_goto_level = _again
		next
	end

     end
		end
	when 30 then
# line 370 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 110
		_goto_level = _again
		next
	end

     end
		end
	when 38 then
# line 383 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:meta, :dot, *text(data, ts, te))
     end
		end
	when 41 then
# line 387 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if conditional_stack.last == group_depth
        emit(:conditional, :separator, *text(data, ts, te))
      else
        emit(:meta, :alternation, *text(data, ts, te))
      end
     end
		end
	when 40 then
# line 397 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :bol, *text(data, ts, te))
     end
		end
	when 35 then
# line 401 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :eol, *text(data, ts, te))
     end
		end
	when 57 then
# line 405 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:keep, :mark, *text(data, ts, te))
     end
		end
	when 56 then
# line 409 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '\\A'; emit(:anchor, :bos,                text, ts, te)
      when '\\z'; emit(:anchor, :eos,                text, ts, te)
      when '\\Z'; emit(:anchor, :eos_ob_eol,         text, ts, te)
      when '\\b'; emit(:anchor, :word_boundary,      text, ts, te)
      when '\\B'; emit(:anchor, :nonword_boundary,   text, ts, te)
      when '\\G'; emit(:anchor, :match_start,        text, ts, te)
      end
     end
		end
	when 47 then
# line 431 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te).first

      conditional_stack << group_depth

      emit(:conditional, :open, text[0..-2], ts, te-1)
      emit(:conditional, :condition_open, '(', te-1, te)
      	begin
		stack[top] = cs
		top+= 1
		cs = 148
		_goto_level = _again
		next
	end

     end
		end
	when 48 then
# line 462 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te).first
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        raise InvalidGroupOption.new($1 || "-#{$2}", text)
      end
      emit_options(text, ts, te)
     end
		end
	when 9 then
# line 476 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '(?=';  emit(:assertion, :lookahead,    text, ts, te)
      when '(?!';  emit(:assertion, :nlookahead,   text, ts, te)
      when '(?<='; emit(:assertion, :lookbehind,   text, ts, te)
      when '(?<!'; emit(:assertion, :nlookbehind,  text, ts, te)
      end
     end
		end
	when 8 then
# line 493 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '(?:';  emit(:group, :passive,      text, ts, te)
      when '(?>';  emit(:group, :atomic,       text, ts, te)
      when '(?~';  emit(:group, :absence,      text, ts, te)

      when /^\(\?(?:<>|'')/
        validation_error(:group, 'named group', 'name is empty')

      when /^\(\?<\w*>/
        emit(:group, :named_ab,  text, ts, te)

      when /^\(\?'\w*'/
        emit(:group, :named_sq,  text, ts, te)

      end
     end
		end
	when 11 then
# line 534 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when /^\\([gk])(<>|'')/ # angle brackets
        validation_error(:backref, 'ref/call', 'ref ID is empty')

      when /^\\([gk])<[^\d+-]\w*>/ # angle-brackets
        if $1 == 'k'
          emit(:backref, :name_ref_ab, text, ts, te)
        else
          emit(:backref, :name_call_ab, text, ts, te)
        end

      when /^\\([gk])'[^\d+-]\w*'/ #single quotes
        if $1 == 'k'
          emit(:backref, :name_ref_sq, text, ts, te)
        else
          emit(:backref, :name_call_sq, text, ts, te)
        end

      when /^\\([gk])<\d+>/ # angle-brackets
        if $1 == 'k'
          emit(:backref, :number_ref_ab, text, ts, te)
        else
          emit(:backref, :number_call_ab, text, ts, te)
        end

      when /^\\([gk])'\d+'/ # single quotes
        if $1 == 'k'
          emit(:backref, :number_ref_sq, text, ts, te)
        else
          emit(:backref, :number_call_sq, text, ts, te)
        end

      when /^\\(?:g<\+|g<-|(k)<-)\d+>/ # angle-brackets
        if $1 == 'k'
          emit(:backref, :number_rel_ref_ab, text, ts, te)
        else
          emit(:backref, :number_rel_call_ab, text, ts, te)
        end

      when /^\\(?:g'\+|g'-|(k)'-)\d+'/ # single quotes
        if $1 == 'k'
          emit(:backref, :number_rel_ref_sq, text, ts, te)
        else
          emit(:backref, :number_rel_call_sq, text, ts, te)
        end

      when /^\\k<[^\d+\-]\w*[+\-]\d+>/ # angle-brackets
        emit(:backref, :name_recursion_ref_ab, text, ts, te)

      when /^\\k'[^\d+\-]\w*[+\-]\d+'/ # single-quotes
        emit(:backref, :name_recursion_ref_sq, text, ts, te)

      when /^\\([gk])<[+\-]?\d+[+\-]\d+>/ # angle-brackets
        emit(:backref, :number_recursion_ref_ab, text, ts, te)

      when /^\\([gk])'[+\-]?\d+[+\-]\d+'/ # single-quotes
        emit(:backref, :number_recursion_ref_sq, text, ts, te)

      end
     end
		end
	when 54 then
# line 599 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '?' ;  emit(:quantifier, :zero_or_one,            text, ts, te)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text, ts, te)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text, ts, te)
      end
     end
		end
	when 50 then
# line 607 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '*' ;  emit(:quantifier, :zero_or_more,            text, ts, te)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text, ts, te)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text, ts, te)
      end
     end
		end
	when 52 then
# line 615 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = text(data, ts, te).first
      when '+' ;  emit(:quantifier, :one_or_more,            text, ts, te)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text, ts, te)
      when '++';  emit(:quantifier, :one_or_more_possessive, text, ts, te)
      end
     end
		end
	when 59 then
# line 623 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:quantifier, :interval, *text(data, ts, te))
     end
		end
	when 4 then
# line 633 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if free_spacing
        emit(:free_space, :comment, *text(data, ts, te))
      else
        append_literal(data, ts, te)
      end
     end
		end
	when 46 then
# line 462 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = text(data, ts, te).first
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        raise InvalidGroupOption.new($1 || "-#{$2}", text)
      end
      emit_options(text, ts, te)
     end
		end
	when 44 then
# line 511 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = text(data, ts, te).first
      emit(:group, :capture, text, ts, te)
     end
		end
	when 53 then
# line 599 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = text(data, ts, te).first
      when '?' ;  emit(:quantifier, :zero_or_one,            text, ts, te)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text, ts, te)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text, ts, te)
      end
     end
		end
	when 49 then
# line 607 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = text(data, ts, te).first
      when '*' ;  emit(:quantifier, :zero_or_more,            text, ts, te)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text, ts, te)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text, ts, te)
      end
     end
		end
	when 51 then
# line 615 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = text(data, ts, te).first
      when '+' ;  emit(:quantifier, :one_or_more,            text, ts, te)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text, ts, te)
      when '++';  emit(:quantifier, :one_or_more_possessive, text, ts, te)
      end
     end
		end
	when 58 then
# line 623 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:quantifier, :interval, *text(data, ts, te))
     end
		end
	when 55 then
# line 629 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 137
		_goto_level = _again
		next
	end

     end
		end
	when 43 then
# line 641 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if free_spacing
        emit(:free_space, :whitespace, *text(data, ts, te))
      else
        append_literal(data, ts, te)
      end
     end
		end
	when 42 then
# line 656 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      append_literal(data, ts, te)
     end
		end
	when 5 then
# line 462 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = text(data, ts, te).first
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        raise InvalidGroupOption.new($1 || "-#{$2}", text)
      end
      emit_options(text, ts, te)
     end
		end
	when 10 then
# line 629 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 137
		_goto_level = _again
		next
	end

     end
		end
	when 3 then
# line 656 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      append_literal(data, ts, te)
     end
		end
	when 1 then
# line 1 "NONE"
		begin
	case act
	when 0 then
	begin	begin
		cs = 0
		_goto_level = _again
		next
	end
end
	when 54 then
	begin begin p = ((te))-1; end

      append_literal(data, ts, te)
    end
end 
			end
	when 71 then
# line 131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 205 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 129
		_goto_level = _again
		next
	end

     end
		end
	when 19 then
# line 131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 205 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 129
		_goto_level = _again
		next
	end

     end
		end
	when 90 then
# line 131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 323 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :hex, *text(data, ts, te, 1))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 86 then
# line 131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 332 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 88 then
# line 131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 337 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 25 then
# line 131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 332 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 27 then
# line 131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 337 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 29 then
# line 137 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    validation_error(:sequence, 'sequence', text)
  		end
# line 328 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 7 then
# line 144 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 447 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:group, :comment, *text(data, ts, te))
     end
		end
	when 37 then
# line 144 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 516 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if conditional_stack.last == group_depth + 1
        conditional_stack.pop
        emit(:conditional, :close, *text(data, ts, te))
      else
        if spacing_stack.length > 1 &&
           spacing_stack.last[:depth] == group_depth + 1
          spacing_stack.pop
          self.free_spacing = spacing_stack.last[:free_spacing]
        end

        emit(:group, :close, *text(data, ts, te))
      end
     end
		end
	when 39 then
# line 145 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   + 1 		end
# line 422 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :open, *text(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 129
		_goto_level = _again
		next
	end

     end
		end
	when 65 then
# line 146 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 152 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :close, *text(data, ts, te))
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 110
		_goto_level = _again
		next
	end

      end
     end
		end
	when 70 then
# line 146 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 161 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, copy(data, ts..te-2), ts, te - 1)
      emit(:set, :close, copy(data, ts+1..te-1), ts + 1, te)
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 110
		_goto_level = _again
		next
	end

      end
     end
		end
	when 22 then
# line 146 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 210 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = text(data, ts, te).first

      type = :posixclass
      class_name = text[2..-3]
      if class_name[0].chr == '^'
        class_name = class_name[1..-1]
        type = :nonposixclass
      end

      emit(type, class_name.to_sym, text, ts, te)
     end
		end
	when 21 then
# line 146 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 223 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :collation, *text(data, ts, te))
     end
		end
	when 23 then
# line 146 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 227 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :equivalent, *text(data, ts, te))
     end
		end
	when 63 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 145 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   + 1 		end
	when 78 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 265 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
act = 18;		end
	when 77 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 271 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
act = 19;		end
	when 2 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 656 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
act = 54;		end
	when 45 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 144 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 143 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1 		end
# line 2563 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
	end
	end
	end
	if _goto_level <= _again
	case _re_scanner_to_state_actions[cs] 
	when 60 then
# line 1 "NONE"
		begin
ts = nil;		end
	when 32 then
# line 1 "NONE"
		begin
ts = nil;		end
# line 1 "NONE"
		begin
act = 0
		end
# line 2581 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
	end

	if cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _re_scanner_eof_trans[cs] > 0
		_trans = _re_scanner_eof_trans[cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	  case _re_scanner_eof_actions[cs]
	when 13 then
# line 8 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/property.rl"
		begin

    raise PrematureEndError.new('unicode property')
  		end
	when 12 then
# line 131 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"
		begin

    text = ts ? copy(data, ts-1..-1) : data.pack('c*')
    raise PrematureEndError.new( text )
  		end
# line 2615 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner.rb"
	  end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 755 "/Users/jannoschmuller/code/regexp_parser/lib/regexp_parser/scanner/scanner.rl"

    # to avoid "warning: assigned but unused variable - testEof"
    testEof = testEof

    if cs == re_scanner_error
      text = ts ? copy(data, ts-1..-1) : data.pack('c*')
      raise ScannerError.new("Scan error at '#{text}'")
    end

    raise PrematureEndError.new("(missing group closing paranthesis) "+
          "[#{group_depth}]") if in_group?
    raise PrematureEndError.new("(missing set closing bracket) "+
          "[#{set_depth}]") if in_set?

    # when the entire expression is a literal run
    emit_literal if literal

    tokens
  end

  # lazy-load property maps when first needed
  require 'yaml'
  PROP_MAPS_DIR = File.expand_path('../scanner/properties', __FILE__)

  def self.short_prop_map
    @short_prop_map ||= YAML.load_file("#{PROP_MAPS_DIR}/short.yml")
  end

  def self.long_prop_map
    @long_prop_map ||= YAML.load_file("#{PROP_MAPS_DIR}/long.yml")
  end

  # Emits an array with the details of the scanned pattern
  def emit(type, token, text, ts, te)
    #puts "EMIT: type: #{type}, token: #{token}, text: #{text}, ts: #{ts}, te: #{te}"

    emit_literal if literal

    if block
      block.call type, token, text, ts, te
    end

    tokens << [type, token, text, ts, te]
  end

  private

  attr_accessor :tokens, :literal, :block, :free_spacing, :spacing_stack,
                :group_depth, :set_depth, :conditional_stack

  def in_group?
    group_depth > 0
  end

  def in_set?
    set_depth > 0
  end

  # Copy from ts to te from data as text
  def copy(data, range)
    data[range].pack('c*')
  end

  # Copy from ts to te from data as text, returning an array with the text
  #  and the offsets used to copy it.
  def text(data, ts, te, soff = 0)
    [copy(data, ts-soff..te-1), ts-soff, te]
  end

  # Appends one or more characters to the literal buffer, to be emitted later
  # by a call to emit_literal. Contents can be a mix of ASCII and UTF-8.
  def append_literal(data, ts, te)
    self.literal = literal || []
    literal << text(data, ts, te)
  end

  # Emits the literal run collected by calls to the append_literal method,
  # using the total start (ts) and end (te) offsets of the run.
  def emit_literal
    ts, te = literal.first[1], literal.last[2]
    text = literal.map {|t| t[0]}.join

    text.force_encoding('utf-8') if text.respond_to?(:force_encoding)

    self.literal = nil
    emit(:literal, :literal, text, ts, te)
  end

  def emit_options(text, ts, te)
    token = nil

    # Ruby allows things like '(?-xxxx)' or '(?xx-xx--xx-:abc)'.
    text =~ /\(\?([mixdau]*)(-(?:[mix]*))*(:)?/
    positive, negative, group_local = $1, $2, $3

    if positive.include?('x')
      self.free_spacing = true
    end

    # If the x appears in both, treat it like ruby does, the second cancels
    # the first.
    if negative && negative.include?('x')
      self.free_spacing = false
    end

    if group_local
      spacing_stack << {:free_spacing => free_spacing, :depth => group_depth}
      token = :options
    else
      # switch for parent group level
      spacing_stack.last[:free_spacing] = free_spacing
      token = :options_switch
    end

    emit(:group, token, text, ts, te)
  end

  def emit_meta_control_sequence(data, ts, te, token)
    if data.last < 0x00 || data.last > 0x7F
      validation_error(:sequence, 'escape', token.to_s)
    end
    emit(:escape, token, *text(data, ts, te, 1))
  end

  # Centralizes and unifies the handling of validation related
  # errors.
  def validation_error(type, what, reason)
    case type
    when :group
      error = InvalidGroupError.new(what, reason)
    when :backref
      error = InvalidBackrefError.new(what, reason)
    when :sequence
      error = InvalidSequenceError.new(what, reason)
    end

    raise error # unless @@config.validation_ignore
  end
end # module Regexp::Scanner
