from cryptography.hazmat.primitives.ciphers import BlockCipherAlgorithm, CipherAlgorithm
from cryptography.hazmat.primitives.ciphers.modes import ModeWithNonce

class AES(BlockCipherAlgorithm, CipherAlgorithm):
    def __init__(self, key: bytes) -> None: ...
    @property
    def block_size(self) -> int: ...
    @property
    def key_size(self) -> int: ...
    @property
    def name(self) -> str: ...

class ARC4(CipherAlgorithm):
    def __init__(self, key: bytes) -> None: ...
    @property
    def key_size(self) -> int: ...
    @property
    def name(self) -> str: ...

class Blowfish(BlockCipherAlgorithm, CipherAlgorithm):
    def __init__(self, key: bytes) -> None: ...
    @property
    def block_size(self) -> int: ...
    @property
    def key_size(self) -> int: ...
    @property
    def name(self) -> str: ...

class Camelia(BlockCipherAlgorithm, CipherAlgorithm):
    def __init__(self, key: bytes) -> None: ...
    @property
    def block_size(self) -> int: ...
    @property
    def key_size(self) -> int: ...
    @property
    def name(self) -> str: ...

class CAST5(BlockCipherAlgorithm, CipherAlgorithm):
    def __init__(self, key: bytes) -> None: ...
    @property
    def block_size(self) -> int: ...
    @property
    def key_size(self) -> int: ...
    @property
    def name(self) -> str: ...

class ChaCha20(CipherAlgorithm, ModeWithNonce):
    def __init__(self, key: bytes, nonce: bytes) -> None: ...
    @property
    def key_size(self) -> int: ...
    @property
    def name(self) -> str: ...
    @property
    def nonce(self) -> bytes: ...

class IDEA(CipherAlgorithm):
    def __init__(self, key: bytes) -> None: ...
    @property
    def key_size(self) -> int: ...
    @property
    def name(self) -> str: ...

class SEED(BlockCipherAlgorithm, CipherAlgorithm):
    def __init__(self, key: bytes) -> None: ...
    @property
    def block_size(self) -> int: ...
    @property
    def key_size(self) -> int: ...
    @property
    def name(self) -> str: ...

class TripleDES(BlockCipherAlgorithm, CipherAlgorithm):
    def __init__(self, key: bytes) -> None: ...
    @property
    def block_size(self) -> int: ...
    @property
    def key_size(self) -> int: ...
    @property
    def name(self) -> str: ...
