# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class BackupStorageConfig(Resource):
    """The backup storage config.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :param e_tag: Optional ETag.
    :type e_tag: str
    :param storage_model_type: Storage model type. Possible values include:
     'Invalid', 'GeoRedundant', 'LocallyRedundant'
    :type storage_model_type: str or :class:`StorageModelType
     <azure.mgmt.recoveryservices.models.StorageModelType>`
    :param storage_type: Storage type. Possible values include: 'Invalid',
     'GeoRedundant', 'LocallyRedundant'
    :type storage_type: str or :class:`StorageType
     <azure.mgmt.recoveryservices.models.StorageType>`
    :param storage_type_state: Locked or Unlocked. Once a machine is
     registered against a resource, the storageTypeState is always Locked.
     Possible values include: 'Invalid', 'Locked', 'Unlocked'
    :type storage_type_state: str or :class:`StorageTypeState
     <azure.mgmt.recoveryservices.models.StorageTypeState>`
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'storage_model_type': {'key': 'properties.storageModelType', 'type': 'str'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'storage_type_state': {'key': 'properties.storageTypeState', 'type': 'str'},
    }

    def __init__(self, e_tag=None, storage_model_type=None, storage_type=None, storage_type_state=None):
        super(BackupStorageConfig, self).__init__(e_tag=e_tag)
        self.storage_model_type = storage_model_type
        self.storage_type = storage_type
        self.storage_type_state = storage_type_state
