Fast XML Parser is a javascript library to parse XML into JS Object, JSON or to build XML from JS Object without losing any information.

The aim of this library is to provide fast error free solution to deal with XML in javascript.

## Setup

To use XML parser in your node js project
```bash
$ npm install fast-xml-parser
```

To use it as CLI to parse a XML file
```bash
$ npm install -g fast-xml-parser
```

To use it in Browser
1. Include it in a `script` tag from some [CDN](https://cdnjs.com/libraries/fast-xml-parser)

## How to use

<small>This documentation is based on how you can use FXP(fast-xml-parser) in node js.</small>

```js
const parser = require('fast-xml-parser');
const fs = require('fs');

const xmlDataStr = fs.readFileSync("./sample.xml").toString();
let jsonObj = parser.parse(xmlDataStr);
```

[> Next: Options to parse XML](./2.XMLparseOptions.md)