'use strict';
var path = require('path');
module.exports = {
  target: 'web',
  resolve: {
    modules: ['/usr/lib/nodejs', '.'],
  },
  resolveLoader: {
    modules: ['/usr/lib/nodejs'],
  },
  output: {
    libraryTarget: 'umd'
  },
  module: {
    rules: [
      {
        test: /\.js$/,
        loader: 'babel-loader',
        options: {
          presets: [ 'es2015' ],
          plugins: ['add-module-exports'] 
        }
      }
    ]
  },
  externals: {
    'd3-color': {
      commonjs: 'd3-color',
      commonjs2: 'd3-color',
      amd: 'd3-color',
      root: '_'
    },
    'd3-interpolate': {
      commonjs: 'd3-interpolate',
      commonjs2: 'd3-interpolate',
      amd: 'd3-interpolate',
      root: '_'
    },
    'd3-ease': {
      commonjs: 'd3-ease',
      commonjs2: 'd3-ease',
      amd: 'd3-ease',
      root: '_'
    },
    'd3-dispatch': {
      commonjs: 'd3-dispatch',
      commonjs2: 'd3-dispatch',
      amd: 'd3-dispatch',
      root: '_'
    },
    'd3-selection': {
      commonjs: 'd3-selection',
      commonjs2: 'd3-selection',
      amd: 'd3-selection',
      root: '_'
    },
    'd3-timer': {
      commonjs: 'd3-timer',
      commonjs2: 'd3-timer',
      amd: 'd3-timer',
      root: '_'
    }
  }
};
