/* ==========================================
 * JGraphT : a free Java graph-theory library
 * ==========================================
 *
 * Project Info:  http://jgrapht.sourceforge.net/
 * Project Lead:  Barak Naveh (http://sourceforge.net/users/barak_naveh)
 *
 * (C) Copyright 2003-2004, by Barak Naveh and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
/* ----------------------
 * JGraphAdapterDemo.java
 * ----------------------
 * (C) Copyright 2003, by Barak Naveh and Contributors.
 *
 * Original Author:  Barak Naveh
 * Contributor(s):   -
 *
 * $Id: JGraphAdapterDemo.java,v 1.15 2005/04/26 06:46:34 perfecthash Exp $
 *
 * Changes
 * -------
 * 03-Aug-2003 : Initial revision (BN);
 * 07-Nov-2003 : Adaptation to JGraph 3.0 (BN);
 *
 */
package org._3pq.jgrapht.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

import javax.swing.JApplet;
import javax.swing.JFrame;

import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.ListenableGraph;
import org._3pq.jgrapht.ext.JGraphModelAdapter;
import org._3pq.jgrapht.graph.DefaultListenableGraph;
import org._3pq.jgrapht.graph.DirectedMultigraph;

import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

/**
 * A demo applet that shows how to use JGraph to visualize JGraphT graphs.
 *
 * @author Barak Naveh
 *
 * @since Aug 3, 2003
 */
public class JGraphAdapterDemo extends JApplet {
    private static final long      serialVersionUID = 3256444702936019250L;
    private static final Color     DEFAULT_BG_COLOR = Color.decode( "#FAFBFF" );
    private static final Dimension DEFAULT_SIZE     = new Dimension( 530, 320 );

    //
    private JGraphModelAdapter m_jgAdapter;

    /**
     * An alternative starting point for this demo, to also allow running this
     * applet as an application.
     *
     * @param args ignored.
     */
    public static void main( String[] args ) {
        JGraphAdapterDemo applet = new JGraphAdapterDemo(  );
        applet.init(  );

        JFrame frame = new JFrame(  );
        frame.getContentPane(  ).add( applet );
        frame.setTitle( "JGraphT Adapter to JGraph Demo" );
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
        frame.pack(  );
        frame.setVisible( true );
    }


    /**
     * {@inheritDoc}
     */
    public void init(  ) {
        // create a JGraphT graph
        ListenableGraph g = new ListenableDirectedMultigraph(  );

        // create a visualization using JGraph, via an adapter
        m_jgAdapter = new JGraphModelAdapter( g );

        JGraph jgraph = new JGraph( m_jgAdapter );

        adjustDisplaySettings( jgraph );
        getContentPane(  ).add( jgraph );
        resize( DEFAULT_SIZE );

        Object v1 = "v1";
        Object v2 = "v2";
        Object v3 = "v3";
        Object v4 = "v4";

        // add some sample data (graph manipulated via JGraphT)
        g.addVertex( v1 );
        g.addVertex( v2 );
        g.addVertex( v3 );
        g.addVertex( v4 );

        g.addEdge( v1, v2 );
        g.addEdge( v2, v3 );
        g.addEdge( v3, v1 );
        g.addEdge( v4, v3 );

        // position vertices nicely within JGraph component
        positionVertexAt( v1, 130, 40 );
        positionVertexAt( v2, 60, 200 );
        positionVertexAt( v3, 310, 230 );
        positionVertexAt( v4, 380, 70 );

        // that's all there is to it!...
    }


    private void adjustDisplaySettings( JGraph jg ) {
        jg.setPreferredSize( DEFAULT_SIZE );

        Color  c        = DEFAULT_BG_COLOR;
        String colorStr = null;

        try {
            colorStr = getParameter( "bgcolor" );
        }
         catch( Exception e ) {}

        if( colorStr != null ) {
            c = Color.decode( colorStr );
        }

        jg.setBackground( c );
    }


    private void positionVertexAt( Object vertex, int x, int y ) {
        DefaultGraphCell cell   = m_jgAdapter.getVertexCell( vertex );
        AttributeMap     attr   = cell.getAttributes(  );
        Rectangle2D      bounds = GraphConstants.getBounds( attr );

        Rectangle2D      newBounds =
            new Rectangle2D.Double( x, y, bounds.getWidth(  ),
                bounds.getHeight(  ) );

        GraphConstants.setBounds( attr, newBounds );

        AttributeMap cellAttr = new AttributeMap(  );
        cellAttr.put( cell, attr );
        m_jgAdapter.edit( cellAttr, null, null, null );
    }

    /**
     * a listenable directed multigraph that allows loops and parallel edges.
     */
    private static class ListenableDirectedMultigraph
        extends DefaultListenableGraph implements DirectedGraph {
        private static final long serialVersionUID = 1L;

        ListenableDirectedMultigraph(  ) {
            super( new DirectedMultigraph(  ) );
        }
    }
}
