/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.loader;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertFalse;
import static org.testng.AssertJUnit.assertTrue;

import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
/**
 * Unit test for JDBCCacheLoaderConfigTest
 *
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
@Test(groups = {"functional"})
public class JDBCCacheLoaderConfigTest
{
   private AdjListJDBCCacheLoaderConfig cacheLoaderConfig;

   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      cacheLoaderConfig = new AdjListJDBCCacheLoaderConfig();
   }

   public void testSetGetConnectionFactory()
   {
      cacheLoaderConfig.setConnectionFactoryClass("com.acme.Paradise");
      assertEquals("com.acme.Paradise", cacheLoaderConfig.getConnectionFactoryClass());
   }

   public void testEqualsHashCode()
   {
      cacheLoaderConfig.setConnectionFactoryClass("com.acme.Paradise");
      AdjListJDBCCacheLoaderConfig other = new AdjListJDBCCacheLoaderConfig();
      other.setConnectionFactoryClass("com.acme.Paradise");
      assertTrue(cacheLoaderConfig.equals(other));
      assertEquals(cacheLoaderConfig.hashCode(), other.hashCode());

      other.setConnectionFactoryClass("com.ibm.flaming.Gala");
      assertFalse(cacheLoaderConfig.equals(other));
   }
}
