/*
#define UNICODE_DERIVED_INCB_MASK                          0x00000003
#define UNICODE_DERIVED_INCB_CONSONANT                     0x00000001
#define UNICODE_DERIVED_INCB_EXTEND                        0x00000002
#define UNICODE_DERIVED_INCB_LINKER                        0x00000003
*/
static const uint8_t InCB_rangetab[][2]={
	{0x0300 & 0xFF, 0x034e & 0xFF},
	{0x0350 & 0xFF, 0x036f & 0xFF},
	{0x0483 & 0xFF, 0x0487 & 0xFF},
	{0x0591 & 0xFF, 0x05bd & 0xFF},
	{0x05bf & 0xFF, 0x05bf & 0xFF},
	{0x05c1 & 0xFF, 0x05c2 & 0xFF},
	{0x05c4 & 0xFF, 0x05c5 & 0xFF},
	{0x05c7 & 0xFF, 0x05c7 & 0xFF},
	{0x0610 & 0xFF, 0x061a & 0xFF},
	{0x064b & 0xFF, 0x065f & 0xFF},
	{0x0670 & 0xFF, 0x0670 & 0xFF},
	{0x06d6 & 0xFF, 0x06dc & 0xFF},
	{0x06df & 0xFF, 0x06e4 & 0xFF},
	{0x06e7 & 0xFF, 0x06e8 & 0xFF},
	{0x06ea & 0xFF, 0x06ed & 0xFF},
	{0x0711 & 0xFF, 0x0711 & 0xFF},
	{0x0730 & 0xFF, 0x074a & 0xFF},
	{0x07eb & 0xFF, 0x07f3 & 0xFF},
	{0x07fd & 0xFF, 0x07fd & 0xFF},
	{0x0816 & 0xFF, 0x0819 & 0xFF},
	{0x081b & 0xFF, 0x0823 & 0xFF},
	{0x0825 & 0xFF, 0x0827 & 0xFF},
	{0x0829 & 0xFF, 0x082d & 0xFF},
	{0x0859 & 0xFF, 0x085b & 0xFF},
	{0x0898 & 0xFF, 0x089f & 0xFF},
	{0x08ca & 0xFF, 0x08e1 & 0xFF},
	{0x08e3 & 0xFF, 0x08ff & 0xFF},
	{0x0915 & 0xFF, 0x0939 & 0xFF},
	{0x093c & 0xFF, 0x093c & 0xFF},
	{0x094d & 0xFF, 0x094d & 0xFF},
	{0x0951 & 0xFF, 0x0954 & 0xFF},
	{0x0958 & 0xFF, 0x095f & 0xFF},
	{0x0978 & 0xFF, 0x097f & 0xFF},
	{0x0995 & 0xFF, 0x09a8 & 0xFF},
	{0x09aa & 0xFF, 0x09b0 & 0xFF},
	{0x09b2 & 0xFF, 0x09b2 & 0xFF},
	{0x09b6 & 0xFF, 0x09b9 & 0xFF},
	{0x09bc & 0xFF, 0x09bc & 0xFF},
	{0x09cd & 0xFF, 0x09cd & 0xFF},
	{0x09dc & 0xFF, 0x09dd & 0xFF},
	{0x09df & 0xFF, 0x09df & 0xFF},
	{0x09f0 & 0xFF, 0x09f1 & 0xFF},
	{0x09fe & 0xFF, 0x09fe & 0xFF},
	{0x0a3c & 0xFF, 0x0a3c & 0xFF},
	{0x0a95 & 0xFF, 0x0aa8 & 0xFF},
	{0x0aaa & 0xFF, 0x0ab0 & 0xFF},
	{0x0ab2 & 0xFF, 0x0ab3 & 0xFF},
	{0x0ab5 & 0xFF, 0x0ab9 & 0xFF},
	{0x0abc & 0xFF, 0x0abc & 0xFF},
	{0x0acd & 0xFF, 0x0acd & 0xFF},
	{0x0af9 & 0xFF, 0x0af9 & 0xFF},
	{0x0b15 & 0xFF, 0x0b28 & 0xFF},
	{0x0b2a & 0xFF, 0x0b30 & 0xFF},
	{0x0b32 & 0xFF, 0x0b33 & 0xFF},
	{0x0b35 & 0xFF, 0x0b39 & 0xFF},
	{0x0b3c & 0xFF, 0x0b3c & 0xFF},
	{0x0b4d & 0xFF, 0x0b4d & 0xFF},
	{0x0b5c & 0xFF, 0x0b5d & 0xFF},
	{0x0b5f & 0xFF, 0x0b5f & 0xFF},
	{0x0b71 & 0xFF, 0x0b71 & 0xFF},
	{0x0c15 & 0xFF, 0x0c28 & 0xFF},
	{0x0c2a & 0xFF, 0x0c39 & 0xFF},
	{0x0c3c & 0xFF, 0x0c3c & 0xFF},
	{0x0c4d & 0xFF, 0x0c4d & 0xFF},
	{0x0c55 & 0xFF, 0x0c56 & 0xFF},
	{0x0c58 & 0xFF, 0x0c5a & 0xFF},
	{0x0cbc & 0xFF, 0x0cbc & 0xFF},
	{0x0d15 & 0xFF, 0x0d3a & 0xFF},
	{0x0d3b & 0xFF, 0x0d3c & 0xFF},
	{0x0d4d & 0xFF, 0x0d4d & 0xFF},
	{0x0e38 & 0xFF, 0x0e3a & 0xFF},
	{0x0e48 & 0xFF, 0x0e4b & 0xFF},
	{0x0eb8 & 0xFF, 0x0eba & 0xFF},
	{0x0ec8 & 0xFF, 0x0ecb & 0xFF},
	{0x0f18 & 0xFF, 0x0f19 & 0xFF},
	{0x0f35 & 0xFF, 0x0f35 & 0xFF},
	{0x0f37 & 0xFF, 0x0f37 & 0xFF},
	{0x0f39 & 0xFF, 0x0f39 & 0xFF},
	{0x0f71 & 0xFF, 0x0f72 & 0xFF},
	{0x0f74 & 0xFF, 0x0f74 & 0xFF},
	{0x0f7a & 0xFF, 0x0f7d & 0xFF},
	{0x0f80 & 0xFF, 0x0f80 & 0xFF},
	{0x0f82 & 0xFF, 0x0f84 & 0xFF},
	{0x0f86 & 0xFF, 0x0f87 & 0xFF},
	{0x0fc6 & 0xFF, 0x0fc6 & 0xFF},
	{0x1037 & 0xFF, 0x1037 & 0xFF},
	{0x1039 & 0xFF, 0x103a & 0xFF},
	{0x108d & 0xFF, 0x108d & 0xFF},
	{0x135d & 0xFF, 0x135f & 0xFF},
	{0x1714 & 0xFF, 0x1714 & 0xFF},
	{0x17d2 & 0xFF, 0x17d2 & 0xFF},
	{0x17dd & 0xFF, 0x17dd & 0xFF},
	{0x18a9 & 0xFF, 0x18a9 & 0xFF},
	{0x1939 & 0xFF, 0x193b & 0xFF},
	{0x1a17 & 0xFF, 0x1a18 & 0xFF},
	{0x1a60 & 0xFF, 0x1a60 & 0xFF},
	{0x1a75 & 0xFF, 0x1a7c & 0xFF},
	{0x1a7f & 0xFF, 0x1a7f & 0xFF},
	{0x1ab0 & 0xFF, 0x1abd & 0xFF},
	{0x1abf & 0xFF, 0x1ace & 0xFF},
	{0x1b34 & 0xFF, 0x1b34 & 0xFF},
	{0x1b6b & 0xFF, 0x1b73 & 0xFF},
	{0x1bab & 0xFF, 0x1bab & 0xFF},
	{0x1be6 & 0xFF, 0x1be6 & 0xFF},
	{0x1c37 & 0xFF, 0x1c37 & 0xFF},
	{0x1cd0 & 0xFF, 0x1cd2 & 0xFF},
	{0x1cd4 & 0xFF, 0x1ce0 & 0xFF},
	{0x1ce2 & 0xFF, 0x1ce8 & 0xFF},
	{0x1ced & 0xFF, 0x1ced & 0xFF},
	{0x1cf4 & 0xFF, 0x1cf4 & 0xFF},
	{0x1cf8 & 0xFF, 0x1cf9 & 0xFF},
	{0x1dc0 & 0xFF, 0x1dff & 0xFF},
	{0x200d & 0xFF, 0x200d & 0xFF},
	{0x20d0 & 0xFF, 0x20dc & 0xFF},
	{0x20e1 & 0xFF, 0x20e1 & 0xFF},
	{0x20e5 & 0xFF, 0x20f0 & 0xFF},
	{0x2cef & 0xFF, 0x2cf1 & 0xFF},
	{0x2d7f & 0xFF, 0x2d7f & 0xFF},
	{0x2de0 & 0xFF, 0x2dff & 0xFF},
	{0x302a & 0xFF, 0x302f & 0xFF},
	{0x3099 & 0xFF, 0x309a & 0xFF},
	{0xa66f & 0xFF, 0xa66f & 0xFF},
	{0xa674 & 0xFF, 0xa67d & 0xFF},
	{0xa69e & 0xFF, 0xa69f & 0xFF},
	{0xa6f0 & 0xFF, 0xa6f1 & 0xFF},
	{0xa82c & 0xFF, 0xa82c & 0xFF},
	{0xa8e0 & 0xFF, 0xa8f1 & 0xFF},
	{0xa92b & 0xFF, 0xa92d & 0xFF},
	{0xa9b3 & 0xFF, 0xa9b3 & 0xFF},
	{0xaab0 & 0xFF, 0xaab0 & 0xFF},
	{0xaab2 & 0xFF, 0xaab4 & 0xFF},
	{0xaab7 & 0xFF, 0xaab8 & 0xFF},
	{0xaabe & 0xFF, 0xaabf & 0xFF},
	{0xaac1 & 0xFF, 0xaac1 & 0xFF},
	{0xaaf6 & 0xFF, 0xaaf6 & 0xFF},
	{0xabed & 0xFF, 0xabed & 0xFF},
	{0xfb1e & 0xFF, 0xfb1e & 0xFF},
	{0xfe20 & 0xFF, 0xfe2f & 0xFF},
	{0x101fd & 0xFF, 0x101fd & 0xFF},
	{0x102e0 & 0xFF, 0x102e0 & 0xFF},
	{0x10376 & 0xFF, 0x1037a & 0xFF},
	{0x10a0d & 0xFF, 0x10a0d & 0xFF},
	{0x10a0f & 0xFF, 0x10a0f & 0xFF},
	{0x10a38 & 0xFF, 0x10a3a & 0xFF},
	{0x10a3f & 0xFF, 0x10a3f & 0xFF},
	{0x10ae5 & 0xFF, 0x10ae6 & 0xFF},
	{0x10d24 & 0xFF, 0x10d27 & 0xFF},
	{0x10eab & 0xFF, 0x10eac & 0xFF},
	{0x10efd & 0xFF, 0x10eff & 0xFF},
	{0x10f46 & 0xFF, 0x10f50 & 0xFF},
	{0x10f82 & 0xFF, 0x10f85 & 0xFF},
	{0x11070 & 0xFF, 0x11070 & 0xFF},
	{0x1107f & 0xFF, 0x1107f & 0xFF},
	{0x110ba & 0xFF, 0x110ba & 0xFF},
	{0x11100 & 0xFF, 0x11102 & 0xFF},
	{0x11133 & 0xFF, 0x11134 & 0xFF},
	{0x11173 & 0xFF, 0x11173 & 0xFF},
	{0x111ca & 0xFF, 0x111ca & 0xFF},
	{0x11236 & 0xFF, 0x11236 & 0xFF},
	{0x112e9 & 0xFF, 0x112ea & 0xFF},
	{0x1133b & 0xFF, 0x1133c & 0xFF},
	{0x11366 & 0xFF, 0x1136c & 0xFF},
	{0x11370 & 0xFF, 0x11374 & 0xFF},
	{0x11446 & 0xFF, 0x11446 & 0xFF},
	{0x1145e & 0xFF, 0x1145e & 0xFF},
	{0x114c3 & 0xFF, 0x114c3 & 0xFF},
	{0x115c0 & 0xFF, 0x115c0 & 0xFF},
	{0x116b7 & 0xFF, 0x116b7 & 0xFF},
	{0x1172b & 0xFF, 0x1172b & 0xFF},
	{0x1183a & 0xFF, 0x1183a & 0xFF},
	{0x1193e & 0xFF, 0x1193e & 0xFF},
	{0x11943 & 0xFF, 0x11943 & 0xFF},
	{0x11a34 & 0xFF, 0x11a34 & 0xFF},
	{0x11a47 & 0xFF, 0x11a47 & 0xFF},
	{0x11a99 & 0xFF, 0x11a99 & 0xFF},
	{0x11d42 & 0xFF, 0x11d42 & 0xFF},
	{0x11d44 & 0xFF, 0x11d45 & 0xFF},
	{0x11d97 & 0xFF, 0x11d97 & 0xFF},
	{0x11f42 & 0xFF, 0x11f42 & 0xFF},
	{0x16af0 & 0xFF, 0x16af4 & 0xFF},
	{0x16b30 & 0xFF, 0x16b36 & 0xFF},
	{0x1bc9e & 0xFF, 0x1bc9e & 0xFF},
	{0x1d165 & 0xFF, 0x1d165 & 0xFF},
	{0x1d167 & 0xFF, 0x1d169 & 0xFF},
	{0x1d16e & 0xFF, 0x1d172 & 0xFF},
	{0x1d17b & 0xFF, 0x1d182 & 0xFF},
	{0x1d185 & 0xFF, 0x1d18b & 0xFF},
	{0x1d1aa & 0xFF, 0x1d1ad & 0xFF},
	{0x1d242 & 0xFF, 0x1d244 & 0xFF},
	{0x1e000 & 0xFF, 0x1e006 & 0xFF},
	{0x1e008 & 0xFF, 0x1e018 & 0xFF},
	{0x1e01b & 0xFF, 0x1e021 & 0xFF},
	{0x1e023 & 0xFF, 0x1e024 & 0xFF},
	{0x1e026 & 0xFF, 0x1e02a & 0xFF},
	{0x1e08f & 0xFF, 0x1e08f & 0xFF},
	{0x1e130 & 0xFF, 0x1e136 & 0xFF},
	{0x1e2ae & 0xFF, 0x1e2ae & 0xFF},
	{0x1e2ec & 0xFF, 0x1e2ef & 0xFF},
	{0x1e4ec & 0xFF, 0x1e4ef & 0xFF},
	{0x1e8d0 & 0xFF, 0x1e8d6 & 0xFF},
	{0x1e944 & 0xFF, 0x1e94a & 0xFF}};

static const uint8_t InCB_classtab[]={
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_LINKER,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_LINKER,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_LINKER,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_LINKER,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_LINKER,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_CONSONANT,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_LINKER,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND,
	UNICODE_DERIVED_INCB_EXTEND};

static const size_t InCB_starting_indextab[]={
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	19,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	32,
	44,
	45,
	48,
	166,
	168,
	169,
	170,
	171,
	251,
	254,
	257,
	258,
	259,
	266,
	269,
	270,
	271,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	285,
	287,
	362,
	363,
	444,
	465,
	466,
	480,
	481,
	482,
	484,
	488,
	489
};

static const char32_t InCB_starting_pagetab[]={
	0,
	2,
	3,
	8,
	15,
	19,
	27,
	43,
	51,
	60,
	67,
	70,
	74,
	85,
	88,
	89,
	92,
	93,
	94,
	100,
	104,
	111,
	112,
	116,
	117,
	119,
	121,
	125,
	127,
	129,
	135,
	136,
	137,
	138,
	139,
	140,
	141,
	146,
	147,
	149,
	151,
	154,
	158,
	160,
	163,
	166,
	167,
	168,
	169,
	170,
	172,
	175,
	178,
	179,
	180,
	181,
	182,
	188,
	189,
	195,
	196,
	198,
	199,
	200
};

static const uint8_t Alphabetic_rangetab[][2]={
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00aa & 0xFF, 0x00aa & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00ba & 0xFF, 0x00ba & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0100 & 0xFF, 0x01ff & 0xFF},
	{0x0200 & 0xFF, 0x02c1 & 0xFF},
	{0x02c6 & 0xFF, 0x02d1 & 0xFF},
	{0x02e0 & 0xFF, 0x02e4 & 0xFF},
	{0x02ec & 0xFF, 0x02ec & 0xFF},
	{0x02ee & 0xFF, 0x02ee & 0xFF},
	{0x0345 & 0xFF, 0x0345 & 0xFF},
	{0x0370 & 0xFF, 0x0374 & 0xFF},
	{0x0376 & 0xFF, 0x0377 & 0xFF},
	{0x037a & 0xFF, 0x037d & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x0386 & 0xFF},
	{0x0388 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03f5 & 0xFF},
	{0x03f7 & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x0481 & 0xFF},
	{0x048a & 0xFF, 0x04ff & 0xFF},
	{0x0500 & 0xFF, 0x052f & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x0559 & 0xFF, 0x0559 & 0xFF},
	{0x0560 & 0xFF, 0x0588 & 0xFF},
	{0x05b0 & 0xFF, 0x05bd & 0xFF},
	{0x05bf & 0xFF, 0x05bf & 0xFF},
	{0x05c1 & 0xFF, 0x05c2 & 0xFF},
	{0x05c4 & 0xFF, 0x05c5 & 0xFF},
	{0x05c7 & 0xFF, 0x05c7 & 0xFF},
	{0x05d0 & 0xFF, 0x05ea & 0xFF},
	{0x05ef & 0xFF, 0x05f2 & 0xFF},
	{0x0610 & 0xFF, 0x061a & 0xFF},
	{0x0620 & 0xFF, 0x0657 & 0xFF},
	{0x0659 & 0xFF, 0x065f & 0xFF},
	{0x066e & 0xFF, 0x06d3 & 0xFF},
	{0x06d5 & 0xFF, 0x06dc & 0xFF},
	{0x06e1 & 0xFF, 0x06e8 & 0xFF},
	{0x06ed & 0xFF, 0x06ef & 0xFF},
	{0x06fa & 0xFF, 0x06fc & 0xFF},
	{0x06ff & 0xFF, 0x06ff & 0xFF},
	{0x0710 & 0xFF, 0x073f & 0xFF},
	{0x074d & 0xFF, 0x07b1 & 0xFF},
	{0x07ca & 0xFF, 0x07ea & 0xFF},
	{0x07f4 & 0xFF, 0x07f5 & 0xFF},
	{0x07fa & 0xFF, 0x07fa & 0xFF},
	{0x0800 & 0xFF, 0x0817 & 0xFF},
	{0x081a & 0xFF, 0x082c & 0xFF},
	{0x0840 & 0xFF, 0x0858 & 0xFF},
	{0x0860 & 0xFF, 0x086a & 0xFF},
	{0x0870 & 0xFF, 0x0887 & 0xFF},
	{0x0889 & 0xFF, 0x088e & 0xFF},
	{0x08a0 & 0xFF, 0x08c9 & 0xFF},
	{0x08d4 & 0xFF, 0x08df & 0xFF},
	{0x08e3 & 0xFF, 0x08e9 & 0xFF},
	{0x08f0 & 0xFF, 0x08ff & 0xFF},
	{0x0900 & 0xFF, 0x093b & 0xFF},
	{0x093d & 0xFF, 0x094c & 0xFF},
	{0x094e & 0xFF, 0x0950 & 0xFF},
	{0x0955 & 0xFF, 0x0963 & 0xFF},
	{0x0971 & 0xFF, 0x0983 & 0xFF},
	{0x0985 & 0xFF, 0x098c & 0xFF},
	{0x098f & 0xFF, 0x0990 & 0xFF},
	{0x0993 & 0xFF, 0x09a8 & 0xFF},
	{0x09aa & 0xFF, 0x09b0 & 0xFF},
	{0x09b2 & 0xFF, 0x09b2 & 0xFF},
	{0x09b6 & 0xFF, 0x09b9 & 0xFF},
	{0x09bd & 0xFF, 0x09c4 & 0xFF},
	{0x09c7 & 0xFF, 0x09c8 & 0xFF},
	{0x09cb & 0xFF, 0x09cc & 0xFF},
	{0x09ce & 0xFF, 0x09ce & 0xFF},
	{0x09d7 & 0xFF, 0x09d7 & 0xFF},
	{0x09dc & 0xFF, 0x09dd & 0xFF},
	{0x09df & 0xFF, 0x09e3 & 0xFF},
	{0x09f0 & 0xFF, 0x09f1 & 0xFF},
	{0x09fc & 0xFF, 0x09fc & 0xFF},
	{0x0a01 & 0xFF, 0x0a03 & 0xFF},
	{0x0a05 & 0xFF, 0x0a0a & 0xFF},
	{0x0a0f & 0xFF, 0x0a10 & 0xFF},
	{0x0a13 & 0xFF, 0x0a28 & 0xFF},
	{0x0a2a & 0xFF, 0x0a30 & 0xFF},
	{0x0a32 & 0xFF, 0x0a33 & 0xFF},
	{0x0a35 & 0xFF, 0x0a36 & 0xFF},
	{0x0a38 & 0xFF, 0x0a39 & 0xFF},
	{0x0a3e & 0xFF, 0x0a42 & 0xFF},
	{0x0a47 & 0xFF, 0x0a48 & 0xFF},
	{0x0a4b & 0xFF, 0x0a4c & 0xFF},
	{0x0a51 & 0xFF, 0x0a51 & 0xFF},
	{0x0a59 & 0xFF, 0x0a5c & 0xFF},
	{0x0a5e & 0xFF, 0x0a5e & 0xFF},
	{0x0a70 & 0xFF, 0x0a75 & 0xFF},
	{0x0a81 & 0xFF, 0x0a83 & 0xFF},
	{0x0a85 & 0xFF, 0x0a8d & 0xFF},
	{0x0a8f & 0xFF, 0x0a91 & 0xFF},
	{0x0a93 & 0xFF, 0x0aa8 & 0xFF},
	{0x0aaa & 0xFF, 0x0ab0 & 0xFF},
	{0x0ab2 & 0xFF, 0x0ab3 & 0xFF},
	{0x0ab5 & 0xFF, 0x0ab9 & 0xFF},
	{0x0abd & 0xFF, 0x0ac5 & 0xFF},
	{0x0ac7 & 0xFF, 0x0ac9 & 0xFF},
	{0x0acb & 0xFF, 0x0acc & 0xFF},
	{0x0ad0 & 0xFF, 0x0ad0 & 0xFF},
	{0x0ae0 & 0xFF, 0x0ae3 & 0xFF},
	{0x0af9 & 0xFF, 0x0afc & 0xFF},
	{0x0b01 & 0xFF, 0x0b03 & 0xFF},
	{0x0b05 & 0xFF, 0x0b0c & 0xFF},
	{0x0b0f & 0xFF, 0x0b10 & 0xFF},
	{0x0b13 & 0xFF, 0x0b28 & 0xFF},
	{0x0b2a & 0xFF, 0x0b30 & 0xFF},
	{0x0b32 & 0xFF, 0x0b33 & 0xFF},
	{0x0b35 & 0xFF, 0x0b39 & 0xFF},
	{0x0b3d & 0xFF, 0x0b44 & 0xFF},
	{0x0b47 & 0xFF, 0x0b48 & 0xFF},
	{0x0b4b & 0xFF, 0x0b4c & 0xFF},
	{0x0b56 & 0xFF, 0x0b57 & 0xFF},
	{0x0b5c & 0xFF, 0x0b5d & 0xFF},
	{0x0b5f & 0xFF, 0x0b63 & 0xFF},
	{0x0b71 & 0xFF, 0x0b71 & 0xFF},
	{0x0b82 & 0xFF, 0x0b83 & 0xFF},
	{0x0b85 & 0xFF, 0x0b8a & 0xFF},
	{0x0b8e & 0xFF, 0x0b90 & 0xFF},
	{0x0b92 & 0xFF, 0x0b95 & 0xFF},
	{0x0b99 & 0xFF, 0x0b9a & 0xFF},
	{0x0b9c & 0xFF, 0x0b9c & 0xFF},
	{0x0b9e & 0xFF, 0x0b9f & 0xFF},
	{0x0ba3 & 0xFF, 0x0ba4 & 0xFF},
	{0x0ba8 & 0xFF, 0x0baa & 0xFF},
	{0x0bae & 0xFF, 0x0bb9 & 0xFF},
	{0x0bbe & 0xFF, 0x0bc2 & 0xFF},
	{0x0bc6 & 0xFF, 0x0bc8 & 0xFF},
	{0x0bca & 0xFF, 0x0bcc & 0xFF},
	{0x0bd0 & 0xFF, 0x0bd0 & 0xFF},
	{0x0bd7 & 0xFF, 0x0bd7 & 0xFF},
	{0x0c00 & 0xFF, 0x0c0c & 0xFF},
	{0x0c0e & 0xFF, 0x0c10 & 0xFF},
	{0x0c12 & 0xFF, 0x0c28 & 0xFF},
	{0x0c2a & 0xFF, 0x0c39 & 0xFF},
	{0x0c3d & 0xFF, 0x0c44 & 0xFF},
	{0x0c46 & 0xFF, 0x0c48 & 0xFF},
	{0x0c4a & 0xFF, 0x0c4c & 0xFF},
	{0x0c55 & 0xFF, 0x0c56 & 0xFF},
	{0x0c58 & 0xFF, 0x0c5a & 0xFF},
	{0x0c5d & 0xFF, 0x0c5d & 0xFF},
	{0x0c60 & 0xFF, 0x0c63 & 0xFF},
	{0x0c80 & 0xFF, 0x0c83 & 0xFF},
	{0x0c85 & 0xFF, 0x0c8c & 0xFF},
	{0x0c8e & 0xFF, 0x0c90 & 0xFF},
	{0x0c92 & 0xFF, 0x0ca8 & 0xFF},
	{0x0caa & 0xFF, 0x0cb3 & 0xFF},
	{0x0cb5 & 0xFF, 0x0cb9 & 0xFF},
	{0x0cbd & 0xFF, 0x0cc4 & 0xFF},
	{0x0cc6 & 0xFF, 0x0cc8 & 0xFF},
	{0x0cca & 0xFF, 0x0ccc & 0xFF},
	{0x0cd5 & 0xFF, 0x0cd6 & 0xFF},
	{0x0cdd & 0xFF, 0x0cde & 0xFF},
	{0x0ce0 & 0xFF, 0x0ce3 & 0xFF},
	{0x0cf1 & 0xFF, 0x0cf3 & 0xFF},
	{0x0d00 & 0xFF, 0x0d0c & 0xFF},
	{0x0d0e & 0xFF, 0x0d10 & 0xFF},
	{0x0d12 & 0xFF, 0x0d3a & 0xFF},
	{0x0d3d & 0xFF, 0x0d44 & 0xFF},
	{0x0d46 & 0xFF, 0x0d48 & 0xFF},
	{0x0d4a & 0xFF, 0x0d4c & 0xFF},
	{0x0d4e & 0xFF, 0x0d4e & 0xFF},
	{0x0d54 & 0xFF, 0x0d57 & 0xFF},
	{0x0d5f & 0xFF, 0x0d63 & 0xFF},
	{0x0d7a & 0xFF, 0x0d7f & 0xFF},
	{0x0d81 & 0xFF, 0x0d83 & 0xFF},
	{0x0d85 & 0xFF, 0x0d96 & 0xFF},
	{0x0d9a & 0xFF, 0x0db1 & 0xFF},
	{0x0db3 & 0xFF, 0x0dbb & 0xFF},
	{0x0dbd & 0xFF, 0x0dbd & 0xFF},
	{0x0dc0 & 0xFF, 0x0dc6 & 0xFF},
	{0x0dcf & 0xFF, 0x0dd4 & 0xFF},
	{0x0dd6 & 0xFF, 0x0dd6 & 0xFF},
	{0x0dd8 & 0xFF, 0x0ddf & 0xFF},
	{0x0df2 & 0xFF, 0x0df3 & 0xFF},
	{0x0e01 & 0xFF, 0x0e3a & 0xFF},
	{0x0e40 & 0xFF, 0x0e46 & 0xFF},
	{0x0e4d & 0xFF, 0x0e4d & 0xFF},
	{0x0e81 & 0xFF, 0x0e82 & 0xFF},
	{0x0e84 & 0xFF, 0x0e84 & 0xFF},
	{0x0e86 & 0xFF, 0x0e8a & 0xFF},
	{0x0e8c & 0xFF, 0x0ea3 & 0xFF},
	{0x0ea5 & 0xFF, 0x0ea5 & 0xFF},
	{0x0ea7 & 0xFF, 0x0eb9 & 0xFF},
	{0x0ebb & 0xFF, 0x0ebd & 0xFF},
	{0x0ec0 & 0xFF, 0x0ec4 & 0xFF},
	{0x0ec6 & 0xFF, 0x0ec6 & 0xFF},
	{0x0ecd & 0xFF, 0x0ecd & 0xFF},
	{0x0edc & 0xFF, 0x0edf & 0xFF},
	{0x0f00 & 0xFF, 0x0f00 & 0xFF},
	{0x0f40 & 0xFF, 0x0f47 & 0xFF},
	{0x0f49 & 0xFF, 0x0f6c & 0xFF},
	{0x0f71 & 0xFF, 0x0f83 & 0xFF},
	{0x0f88 & 0xFF, 0x0f97 & 0xFF},
	{0x0f99 & 0xFF, 0x0fbc & 0xFF},
	{0x1000 & 0xFF, 0x1036 & 0xFF},
	{0x1038 & 0xFF, 0x1038 & 0xFF},
	{0x103b & 0xFF, 0x103f & 0xFF},
	{0x1050 & 0xFF, 0x108f & 0xFF},
	{0x109a & 0xFF, 0x109d & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x10d0 & 0xFF, 0x10fa & 0xFF},
	{0x10fc & 0xFF, 0x10ff & 0xFF},
	{0x1100 & 0xFF, 0x11ff & 0xFF},
	{0x1200 & 0xFF, 0x1248 & 0xFF},
	{0x124a & 0xFF, 0x124d & 0xFF},
	{0x1250 & 0xFF, 0x1256 & 0xFF},
	{0x1258 & 0xFF, 0x1258 & 0xFF},
	{0x125a & 0xFF, 0x125d & 0xFF},
	{0x1260 & 0xFF, 0x1288 & 0xFF},
	{0x128a & 0xFF, 0x128d & 0xFF},
	{0x1290 & 0xFF, 0x12b0 & 0xFF},
	{0x12b2 & 0xFF, 0x12b5 & 0xFF},
	{0x12b8 & 0xFF, 0x12be & 0xFF},
	{0x12c0 & 0xFF, 0x12c0 & 0xFF},
	{0x12c2 & 0xFF, 0x12c5 & 0xFF},
	{0x12c8 & 0xFF, 0x12d6 & 0xFF},
	{0x12d8 & 0xFF, 0x12ff & 0xFF},
	{0x1300 & 0xFF, 0x1310 & 0xFF},
	{0x1312 & 0xFF, 0x1315 & 0xFF},
	{0x1318 & 0xFF, 0x135a & 0xFF},
	{0x1380 & 0xFF, 0x138f & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1401 & 0xFF, 0x14ff & 0xFF},
	{0x1500 & 0xFF, 0x15ff & 0xFF},
	{0x1600 & 0xFF, 0x166c & 0xFF},
	{0x166f & 0xFF, 0x167f & 0xFF},
	{0x1681 & 0xFF, 0x169a & 0xFF},
	{0x16a0 & 0xFF, 0x16ea & 0xFF},
	{0x16ee & 0xFF, 0x16f8 & 0xFF},
	{0x1700 & 0xFF, 0x1713 & 0xFF},
	{0x171f & 0xFF, 0x1733 & 0xFF},
	{0x1740 & 0xFF, 0x1753 & 0xFF},
	{0x1760 & 0xFF, 0x176c & 0xFF},
	{0x176e & 0xFF, 0x1770 & 0xFF},
	{0x1772 & 0xFF, 0x1773 & 0xFF},
	{0x1780 & 0xFF, 0x17b3 & 0xFF},
	{0x17b6 & 0xFF, 0x17c8 & 0xFF},
	{0x17d7 & 0xFF, 0x17d7 & 0xFF},
	{0x17dc & 0xFF, 0x17dc & 0xFF},
	{0x1820 & 0xFF, 0x1878 & 0xFF},
	{0x1880 & 0xFF, 0x18aa & 0xFF},
	{0x18b0 & 0xFF, 0x18f5 & 0xFF},
	{0x1900 & 0xFF, 0x191e & 0xFF},
	{0x1920 & 0xFF, 0x192b & 0xFF},
	{0x1930 & 0xFF, 0x1938 & 0xFF},
	{0x1950 & 0xFF, 0x196d & 0xFF},
	{0x1970 & 0xFF, 0x1974 & 0xFF},
	{0x1980 & 0xFF, 0x19ab & 0xFF},
	{0x19b0 & 0xFF, 0x19c9 & 0xFF},
	{0x1a00 & 0xFF, 0x1a1b & 0xFF},
	{0x1a20 & 0xFF, 0x1a5e & 0xFF},
	{0x1a61 & 0xFF, 0x1a74 & 0xFF},
	{0x1aa7 & 0xFF, 0x1aa7 & 0xFF},
	{0x1abf & 0xFF, 0x1ac0 & 0xFF},
	{0x1acc & 0xFF, 0x1ace & 0xFF},
	{0x1b00 & 0xFF, 0x1b33 & 0xFF},
	{0x1b35 & 0xFF, 0x1b43 & 0xFF},
	{0x1b45 & 0xFF, 0x1b4c & 0xFF},
	{0x1b80 & 0xFF, 0x1ba9 & 0xFF},
	{0x1bac & 0xFF, 0x1baf & 0xFF},
	{0x1bba & 0xFF, 0x1be5 & 0xFF},
	{0x1be7 & 0xFF, 0x1bf1 & 0xFF},
	{0x1c00 & 0xFF, 0x1c36 & 0xFF},
	{0x1c4d & 0xFF, 0x1c4f & 0xFF},
	{0x1c5a & 0xFF, 0x1c7d & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1ce9 & 0xFF, 0x1cec & 0xFF},
	{0x1cee & 0xFF, 0x1cf3 & 0xFF},
	{0x1cf5 & 0xFF, 0x1cf6 & 0xFF},
	{0x1cfa & 0xFF, 0x1cfa & 0xFF},
	{0x1d00 & 0xFF, 0x1dbf & 0xFF},
	{0x1de7 & 0xFF, 0x1df4 & 0xFF},
	{0x1e00 & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f15 & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f20 & 0xFF, 0x1f45 & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fbc & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fcc & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe0 & 0xFF, 0x1fec & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ffc & 0xFF},
	{0x2071 & 0xFF, 0x2071 & 0xFF},
	{0x207f & 0xFF, 0x207f & 0xFF},
	{0x2090 & 0xFF, 0x209c & 0xFF},
	{0x2102 & 0xFF, 0x2102 & 0xFF},
	{0x2107 & 0xFF, 0x2107 & 0xFF},
	{0x210a & 0xFF, 0x2113 & 0xFF},
	{0x2115 & 0xFF, 0x2115 & 0xFF},
	{0x2119 & 0xFF, 0x211d & 0xFF},
	{0x2124 & 0xFF, 0x2124 & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x2128 & 0xFF, 0x2128 & 0xFF},
	{0x212a & 0xFF, 0x212d & 0xFF},
	{0x212f & 0xFF, 0x2139 & 0xFF},
	{0x213c & 0xFF, 0x213f & 0xFF},
	{0x2145 & 0xFF, 0x2149 & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2160 & 0xFF, 0x2188 & 0xFF},
	{0x24b6 & 0xFF, 0x24e9 & 0xFF},
	{0x2c00 & 0xFF, 0x2ce4 & 0xFF},
	{0x2ceb & 0xFF, 0x2cee & 0xFF},
	{0x2cf2 & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0x2d30 & 0xFF, 0x2d67 & 0xFF},
	{0x2d6f & 0xFF, 0x2d6f & 0xFF},
	{0x2d80 & 0xFF, 0x2d96 & 0xFF},
	{0x2da0 & 0xFF, 0x2da6 & 0xFF},
	{0x2da8 & 0xFF, 0x2dae & 0xFF},
	{0x2db0 & 0xFF, 0x2db6 & 0xFF},
	{0x2db8 & 0xFF, 0x2dbe & 0xFF},
	{0x2dc0 & 0xFF, 0x2dc6 & 0xFF},
	{0x2dc8 & 0xFF, 0x2dce & 0xFF},
	{0x2dd0 & 0xFF, 0x2dd6 & 0xFF},
	{0x2dd8 & 0xFF, 0x2dde & 0xFF},
	{0x2de0 & 0xFF, 0x2dff & 0xFF},
	{0x2e2f & 0xFF, 0x2e2f & 0xFF},
	{0x3005 & 0xFF, 0x3007 & 0xFF},
	{0x3021 & 0xFF, 0x3029 & 0xFF},
	{0x3031 & 0xFF, 0x3035 & 0xFF},
	{0x3038 & 0xFF, 0x303c & 0xFF},
	{0x3041 & 0xFF, 0x3096 & 0xFF},
	{0x309d & 0xFF, 0x309f & 0xFF},
	{0x30a1 & 0xFF, 0x30fa & 0xFF},
	{0x30fc & 0xFF, 0x30ff & 0xFF},
	{0x3105 & 0xFF, 0x312f & 0xFF},
	{0x3131 & 0xFF, 0x318e & 0xFF},
	{0x31a0 & 0xFF, 0x31bf & 0xFF},
	{0x31f0 & 0xFF, 0x31ff & 0xFF},
	{0x3400 & 0xFF, 0x34ff & 0xFF},
	{0x3500 & 0xFF, 0x35ff & 0xFF},
	{0x3600 & 0xFF, 0x36ff & 0xFF},
	{0x3700 & 0xFF, 0x37ff & 0xFF},
	{0x3800 & 0xFF, 0x38ff & 0xFF},
	{0x3900 & 0xFF, 0x39ff & 0xFF},
	{0x3a00 & 0xFF, 0x3aff & 0xFF},
	{0x3b00 & 0xFF, 0x3bff & 0xFF},
	{0x3c00 & 0xFF, 0x3cff & 0xFF},
	{0x3d00 & 0xFF, 0x3dff & 0xFF},
	{0x3e00 & 0xFF, 0x3eff & 0xFF},
	{0x3f00 & 0xFF, 0x3fff & 0xFF},
	{0x4000 & 0xFF, 0x40ff & 0xFF},
	{0x4100 & 0xFF, 0x41ff & 0xFF},
	{0x4200 & 0xFF, 0x42ff & 0xFF},
	{0x4300 & 0xFF, 0x43ff & 0xFF},
	{0x4400 & 0xFF, 0x44ff & 0xFF},
	{0x4500 & 0xFF, 0x45ff & 0xFF},
	{0x4600 & 0xFF, 0x46ff & 0xFF},
	{0x4700 & 0xFF, 0x47ff & 0xFF},
	{0x4800 & 0xFF, 0x48ff & 0xFF},
	{0x4900 & 0xFF, 0x49ff & 0xFF},
	{0x4a00 & 0xFF, 0x4aff & 0xFF},
	{0x4b00 & 0xFF, 0x4bff & 0xFF},
	{0x4c00 & 0xFF, 0x4cff & 0xFF},
	{0x4d00 & 0xFF, 0x4dbf & 0xFF},
	{0x4e00 & 0xFF, 0x4eff & 0xFF},
	{0x4f00 & 0xFF, 0x4fff & 0xFF},
	{0x5000 & 0xFF, 0x50ff & 0xFF},
	{0x5100 & 0xFF, 0x51ff & 0xFF},
	{0x5200 & 0xFF, 0x52ff & 0xFF},
	{0x5300 & 0xFF, 0x53ff & 0xFF},
	{0x5400 & 0xFF, 0x54ff & 0xFF},
	{0x5500 & 0xFF, 0x55ff & 0xFF},
	{0x5600 & 0xFF, 0x56ff & 0xFF},
	{0x5700 & 0xFF, 0x57ff & 0xFF},
	{0x5800 & 0xFF, 0x58ff & 0xFF},
	{0x5900 & 0xFF, 0x59ff & 0xFF},
	{0x5a00 & 0xFF, 0x5aff & 0xFF},
	{0x5b00 & 0xFF, 0x5bff & 0xFF},
	{0x5c00 & 0xFF, 0x5cff & 0xFF},
	{0x5d00 & 0xFF, 0x5dff & 0xFF},
	{0x5e00 & 0xFF, 0x5eff & 0xFF},
	{0x5f00 & 0xFF, 0x5fff & 0xFF},
	{0x6000 & 0xFF, 0x60ff & 0xFF},
	{0x6100 & 0xFF, 0x61ff & 0xFF},
	{0x6200 & 0xFF, 0x62ff & 0xFF},
	{0x6300 & 0xFF, 0x63ff & 0xFF},
	{0x6400 & 0xFF, 0x64ff & 0xFF},
	{0x6500 & 0xFF, 0x65ff & 0xFF},
	{0x6600 & 0xFF, 0x66ff & 0xFF},
	{0x6700 & 0xFF, 0x67ff & 0xFF},
	{0x6800 & 0xFF, 0x68ff & 0xFF},
	{0x6900 & 0xFF, 0x69ff & 0xFF},
	{0x6a00 & 0xFF, 0x6aff & 0xFF},
	{0x6b00 & 0xFF, 0x6bff & 0xFF},
	{0x6c00 & 0xFF, 0x6cff & 0xFF},
	{0x6d00 & 0xFF, 0x6dff & 0xFF},
	{0x6e00 & 0xFF, 0x6eff & 0xFF},
	{0x6f00 & 0xFF, 0x6fff & 0xFF},
	{0x7000 & 0xFF, 0x70ff & 0xFF},
	{0x7100 & 0xFF, 0x71ff & 0xFF},
	{0x7200 & 0xFF, 0x72ff & 0xFF},
	{0x7300 & 0xFF, 0x73ff & 0xFF},
	{0x7400 & 0xFF, 0x74ff & 0xFF},
	{0x7500 & 0xFF, 0x75ff & 0xFF},
	{0x7600 & 0xFF, 0x76ff & 0xFF},
	{0x7700 & 0xFF, 0x77ff & 0xFF},
	{0x7800 & 0xFF, 0x78ff & 0xFF},
	{0x7900 & 0xFF, 0x79ff & 0xFF},
	{0x7a00 & 0xFF, 0x7aff & 0xFF},
	{0x7b00 & 0xFF, 0x7bff & 0xFF},
	{0x7c00 & 0xFF, 0x7cff & 0xFF},
	{0x7d00 & 0xFF, 0x7dff & 0xFF},
	{0x7e00 & 0xFF, 0x7eff & 0xFF},
	{0x7f00 & 0xFF, 0x7fff & 0xFF},
	{0x8000 & 0xFF, 0x80ff & 0xFF},
	{0x8100 & 0xFF, 0x81ff & 0xFF},
	{0x8200 & 0xFF, 0x82ff & 0xFF},
	{0x8300 & 0xFF, 0x83ff & 0xFF},
	{0x8400 & 0xFF, 0x84ff & 0xFF},
	{0x8500 & 0xFF, 0x85ff & 0xFF},
	{0x8600 & 0xFF, 0x86ff & 0xFF},
	{0x8700 & 0xFF, 0x87ff & 0xFF},
	{0x8800 & 0xFF, 0x88ff & 0xFF},
	{0x8900 & 0xFF, 0x89ff & 0xFF},
	{0x8a00 & 0xFF, 0x8aff & 0xFF},
	{0x8b00 & 0xFF, 0x8bff & 0xFF},
	{0x8c00 & 0xFF, 0x8cff & 0xFF},
	{0x8d00 & 0xFF, 0x8dff & 0xFF},
	{0x8e00 & 0xFF, 0x8eff & 0xFF},
	{0x8f00 & 0xFF, 0x8fff & 0xFF},
	{0x9000 & 0xFF, 0x90ff & 0xFF},
	{0x9100 & 0xFF, 0x91ff & 0xFF},
	{0x9200 & 0xFF, 0x92ff & 0xFF},
	{0x9300 & 0xFF, 0x93ff & 0xFF},
	{0x9400 & 0xFF, 0x94ff & 0xFF},
	{0x9500 & 0xFF, 0x95ff & 0xFF},
	{0x9600 & 0xFF, 0x96ff & 0xFF},
	{0x9700 & 0xFF, 0x97ff & 0xFF},
	{0x9800 & 0xFF, 0x98ff & 0xFF},
	{0x9900 & 0xFF, 0x99ff & 0xFF},
	{0x9a00 & 0xFF, 0x9aff & 0xFF},
	{0x9b00 & 0xFF, 0x9bff & 0xFF},
	{0x9c00 & 0xFF, 0x9cff & 0xFF},
	{0x9d00 & 0xFF, 0x9dff & 0xFF},
	{0x9e00 & 0xFF, 0x9eff & 0xFF},
	{0x9f00 & 0xFF, 0x9fff & 0xFF},
	{0xa000 & 0xFF, 0xa0ff & 0xFF},
	{0xa100 & 0xFF, 0xa1ff & 0xFF},
	{0xa200 & 0xFF, 0xa2ff & 0xFF},
	{0xa300 & 0xFF, 0xa3ff & 0xFF},
	{0xa400 & 0xFF, 0xa48c & 0xFF},
	{0xa4d0 & 0xFF, 0xa4fd & 0xFF},
	{0xa500 & 0xFF, 0xa5ff & 0xFF},
	{0xa600 & 0xFF, 0xa60c & 0xFF},
	{0xa610 & 0xFF, 0xa61f & 0xFF},
	{0xa62a & 0xFF, 0xa62b & 0xFF},
	{0xa640 & 0xFF, 0xa66e & 0xFF},
	{0xa674 & 0xFF, 0xa67b & 0xFF},
	{0xa67f & 0xFF, 0xa6ef & 0xFF},
	{0xa717 & 0xFF, 0xa71f & 0xFF},
	{0xa722 & 0xFF, 0xa788 & 0xFF},
	{0xa78b & 0xFF, 0xa7ca & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d3 & 0xFF, 0xa7d3 & 0xFF},
	{0xa7d5 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f2 & 0xFF, 0xa7ff & 0xFF},
	{0xa800 & 0xFF, 0xa805 & 0xFF},
	{0xa807 & 0xFF, 0xa827 & 0xFF},
	{0xa840 & 0xFF, 0xa873 & 0xFF},
	{0xa880 & 0xFF, 0xa8c3 & 0xFF},
	{0xa8c5 & 0xFF, 0xa8c5 & 0xFF},
	{0xa8f2 & 0xFF, 0xa8f7 & 0xFF},
	{0xa8fb & 0xFF, 0xa8fb & 0xFF},
	{0xa8fd & 0xFF, 0xa8ff & 0xFF},
	{0xa90a & 0xFF, 0xa92a & 0xFF},
	{0xa930 & 0xFF, 0xa952 & 0xFF},
	{0xa960 & 0xFF, 0xa97c & 0xFF},
	{0xa980 & 0xFF, 0xa9b2 & 0xFF},
	{0xa9b4 & 0xFF, 0xa9bf & 0xFF},
	{0xa9cf & 0xFF, 0xa9cf & 0xFF},
	{0xa9e0 & 0xFF, 0xa9ef & 0xFF},
	{0xa9fa & 0xFF, 0xa9fe & 0xFF},
	{0xaa00 & 0xFF, 0xaa36 & 0xFF},
	{0xaa40 & 0xFF, 0xaa4d & 0xFF},
	{0xaa60 & 0xFF, 0xaa76 & 0xFF},
	{0xaa7a & 0xFF, 0xaabe & 0xFF},
	{0xaac0 & 0xFF, 0xaac0 & 0xFF},
	{0xaac2 & 0xFF, 0xaac2 & 0xFF},
	{0xaadb & 0xFF, 0xaadd & 0xFF},
	{0xaae0 & 0xFF, 0xaaef & 0xFF},
	{0xaaf2 & 0xFF, 0xaaf5 & 0xFF},
	{0xab01 & 0xFF, 0xab06 & 0xFF},
	{0xab09 & 0xFF, 0xab0e & 0xFF},
	{0xab11 & 0xFF, 0xab16 & 0xFF},
	{0xab20 & 0xFF, 0xab26 & 0xFF},
	{0xab28 & 0xFF, 0xab2e & 0xFF},
	{0xab30 & 0xFF, 0xab5a & 0xFF},
	{0xab5c & 0xFF, 0xab69 & 0xFF},
	{0xab70 & 0xFF, 0xabea & 0xFF},
	{0xac00 & 0xFF, 0xacff & 0xFF},
	{0xad00 & 0xFF, 0xadff & 0xFF},
	{0xae00 & 0xFF, 0xaeff & 0xFF},
	{0xaf00 & 0xFF, 0xafff & 0xFF},
	{0xb000 & 0xFF, 0xb0ff & 0xFF},
	{0xb100 & 0xFF, 0xb1ff & 0xFF},
	{0xb200 & 0xFF, 0xb2ff & 0xFF},
	{0xb300 & 0xFF, 0xb3ff & 0xFF},
	{0xb400 & 0xFF, 0xb4ff & 0xFF},
	{0xb500 & 0xFF, 0xb5ff & 0xFF},
	{0xb600 & 0xFF, 0xb6ff & 0xFF},
	{0xb700 & 0xFF, 0xb7ff & 0xFF},
	{0xb800 & 0xFF, 0xb8ff & 0xFF},
	{0xb900 & 0xFF, 0xb9ff & 0xFF},
	{0xba00 & 0xFF, 0xbaff & 0xFF},
	{0xbb00 & 0xFF, 0xbbff & 0xFF},
	{0xbc00 & 0xFF, 0xbcff & 0xFF},
	{0xbd00 & 0xFF, 0xbdff & 0xFF},
	{0xbe00 & 0xFF, 0xbeff & 0xFF},
	{0xbf00 & 0xFF, 0xbfff & 0xFF},
	{0xc000 & 0xFF, 0xc0ff & 0xFF},
	{0xc100 & 0xFF, 0xc1ff & 0xFF},
	{0xc200 & 0xFF, 0xc2ff & 0xFF},
	{0xc300 & 0xFF, 0xc3ff & 0xFF},
	{0xc400 & 0xFF, 0xc4ff & 0xFF},
	{0xc500 & 0xFF, 0xc5ff & 0xFF},
	{0xc600 & 0xFF, 0xc6ff & 0xFF},
	{0xc700 & 0xFF, 0xc7ff & 0xFF},
	{0xc800 & 0xFF, 0xc8ff & 0xFF},
	{0xc900 & 0xFF, 0xc9ff & 0xFF},
	{0xca00 & 0xFF, 0xcaff & 0xFF},
	{0xcb00 & 0xFF, 0xcbff & 0xFF},
	{0xcc00 & 0xFF, 0xccff & 0xFF},
	{0xcd00 & 0xFF, 0xcdff & 0xFF},
	{0xce00 & 0xFF, 0xceff & 0xFF},
	{0xcf00 & 0xFF, 0xcfff & 0xFF},
	{0xd000 & 0xFF, 0xd0ff & 0xFF},
	{0xd100 & 0xFF, 0xd1ff & 0xFF},
	{0xd200 & 0xFF, 0xd2ff & 0xFF},
	{0xd300 & 0xFF, 0xd3ff & 0xFF},
	{0xd400 & 0xFF, 0xd4ff & 0xFF},
	{0xd500 & 0xFF, 0xd5ff & 0xFF},
	{0xd600 & 0xFF, 0xd6ff & 0xFF},
	{0xd700 & 0xFF, 0xd7a3 & 0xFF},
	{0xd7b0 & 0xFF, 0xd7c6 & 0xFF},
	{0xd7cb & 0xFF, 0xd7fb & 0xFF},
	{0xf900 & 0xFF, 0xf9ff & 0xFF},
	{0xfa00 & 0xFF, 0xfa6d & 0xFF},
	{0xfa70 & 0xFF, 0xfad9 & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xfb1d & 0xFF, 0xfb28 & 0xFF},
	{0xfb2a & 0xFF, 0xfb36 & 0xFF},
	{0xfb38 & 0xFF, 0xfb3c & 0xFF},
	{0xfb3e & 0xFF, 0xfb3e & 0xFF},
	{0xfb40 & 0xFF, 0xfb41 & 0xFF},
	{0xfb43 & 0xFF, 0xfb44 & 0xFF},
	{0xfb46 & 0xFF, 0xfbb1 & 0xFF},
	{0xfbd3 & 0xFF, 0xfbff & 0xFF},
	{0xfc00 & 0xFF, 0xfcff & 0xFF},
	{0xfd00 & 0xFF, 0xfd3d & 0xFF},
	{0xfd50 & 0xFF, 0xfd8f & 0xFF},
	{0xfd92 & 0xFF, 0xfdc7 & 0xFF},
	{0xfdf0 & 0xFF, 0xfdfb & 0xFF},
	{0xfe70 & 0xFF, 0xfe74 & 0xFF},
	{0xfe76 & 0xFF, 0xfefc & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0xff66 & 0xFF, 0xffbe & 0xFF},
	{0xffc2 & 0xFF, 0xffc7 & 0xFF},
	{0xffca & 0xFF, 0xffcf & 0xFF},
	{0xffd2 & 0xFF, 0xffd7 & 0xFF},
	{0xffda & 0xFF, 0xffdc & 0xFF},
	{0x10000 & 0xFF, 0x1000b & 0xFF},
	{0x1000d & 0xFF, 0x10026 & 0xFF},
	{0x10028 & 0xFF, 0x1003a & 0xFF},
	{0x1003c & 0xFF, 0x1003d & 0xFF},
	{0x1003f & 0xFF, 0x1004d & 0xFF},
	{0x10050 & 0xFF, 0x1005d & 0xFF},
	{0x10080 & 0xFF, 0x100fa & 0xFF},
	{0x10140 & 0xFF, 0x10174 & 0xFF},
	{0x10280 & 0xFF, 0x1029c & 0xFF},
	{0x102a0 & 0xFF, 0x102d0 & 0xFF},
	{0x10300 & 0xFF, 0x1031f & 0xFF},
	{0x1032d & 0xFF, 0x1034a & 0xFF},
	{0x10350 & 0xFF, 0x1037a & 0xFF},
	{0x10380 & 0xFF, 0x1039d & 0xFF},
	{0x103a0 & 0xFF, 0x103c3 & 0xFF},
	{0x103c8 & 0xFF, 0x103cf & 0xFF},
	{0x103d1 & 0xFF, 0x103d5 & 0xFF},
	{0x10400 & 0xFF, 0x1049d & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10500 & 0xFF, 0x10527 & 0xFF},
	{0x10530 & 0xFF, 0x10563 & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10600 & 0xFF, 0x106ff & 0xFF},
	{0x10700 & 0xFF, 0x10736 & 0xFF},
	{0x10740 & 0xFF, 0x10755 & 0xFF},
	{0x10760 & 0xFF, 0x10767 & 0xFF},
	{0x10780 & 0xFF, 0x10785 & 0xFF},
	{0x10787 & 0xFF, 0x107b0 & 0xFF},
	{0x107b2 & 0xFF, 0x107ba & 0xFF},
	{0x10800 & 0xFF, 0x10805 & 0xFF},
	{0x10808 & 0xFF, 0x10808 & 0xFF},
	{0x1080a & 0xFF, 0x10835 & 0xFF},
	{0x10837 & 0xFF, 0x10838 & 0xFF},
	{0x1083c & 0xFF, 0x1083c & 0xFF},
	{0x1083f & 0xFF, 0x10855 & 0xFF},
	{0x10860 & 0xFF, 0x10876 & 0xFF},
	{0x10880 & 0xFF, 0x1089e & 0xFF},
	{0x108e0 & 0xFF, 0x108f2 & 0xFF},
	{0x108f4 & 0xFF, 0x108f5 & 0xFF},
	{0x10900 & 0xFF, 0x10915 & 0xFF},
	{0x10920 & 0xFF, 0x10939 & 0xFF},
	{0x10980 & 0xFF, 0x109b7 & 0xFF},
	{0x109be & 0xFF, 0x109bf & 0xFF},
	{0x10a00 & 0xFF, 0x10a03 & 0xFF},
	{0x10a05 & 0xFF, 0x10a06 & 0xFF},
	{0x10a0c & 0xFF, 0x10a13 & 0xFF},
	{0x10a15 & 0xFF, 0x10a17 & 0xFF},
	{0x10a19 & 0xFF, 0x10a35 & 0xFF},
	{0x10a60 & 0xFF, 0x10a7c & 0xFF},
	{0x10a80 & 0xFF, 0x10a9c & 0xFF},
	{0x10ac0 & 0xFF, 0x10ac7 & 0xFF},
	{0x10ac9 & 0xFF, 0x10ae4 & 0xFF},
	{0x10b00 & 0xFF, 0x10b35 & 0xFF},
	{0x10b40 & 0xFF, 0x10b55 & 0xFF},
	{0x10b60 & 0xFF, 0x10b72 & 0xFF},
	{0x10b80 & 0xFF, 0x10b91 & 0xFF},
	{0x10c00 & 0xFF, 0x10c48 & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x10d00 & 0xFF, 0x10d27 & 0xFF},
	{0x10e80 & 0xFF, 0x10ea9 & 0xFF},
	{0x10eab & 0xFF, 0x10eac & 0xFF},
	{0x10eb0 & 0xFF, 0x10eb1 & 0xFF},
	{0x10f00 & 0xFF, 0x10f1c & 0xFF},
	{0x10f27 & 0xFF, 0x10f27 & 0xFF},
	{0x10f30 & 0xFF, 0x10f45 & 0xFF},
	{0x10f70 & 0xFF, 0x10f81 & 0xFF},
	{0x10fb0 & 0xFF, 0x10fc4 & 0xFF},
	{0x10fe0 & 0xFF, 0x10ff6 & 0xFF},
	{0x11000 & 0xFF, 0x11045 & 0xFF},
	{0x11071 & 0xFF, 0x11075 & 0xFF},
	{0x11080 & 0xFF, 0x110b8 & 0xFF},
	{0x110c2 & 0xFF, 0x110c2 & 0xFF},
	{0x110d0 & 0xFF, 0x110e8 & 0xFF},
	{0x11100 & 0xFF, 0x11132 & 0xFF},
	{0x11144 & 0xFF, 0x11147 & 0xFF},
	{0x11150 & 0xFF, 0x11172 & 0xFF},
	{0x11176 & 0xFF, 0x11176 & 0xFF},
	{0x11180 & 0xFF, 0x111bf & 0xFF},
	{0x111c1 & 0xFF, 0x111c4 & 0xFF},
	{0x111ce & 0xFF, 0x111cf & 0xFF},
	{0x111da & 0xFF, 0x111da & 0xFF},
	{0x111dc & 0xFF, 0x111dc & 0xFF},
	{0x11200 & 0xFF, 0x11211 & 0xFF},
	{0x11213 & 0xFF, 0x11234 & 0xFF},
	{0x11237 & 0xFF, 0x11237 & 0xFF},
	{0x1123e & 0xFF, 0x11241 & 0xFF},
	{0x11280 & 0xFF, 0x11286 & 0xFF},
	{0x11288 & 0xFF, 0x11288 & 0xFF},
	{0x1128a & 0xFF, 0x1128d & 0xFF},
	{0x1128f & 0xFF, 0x1129d & 0xFF},
	{0x1129f & 0xFF, 0x112a8 & 0xFF},
	{0x112b0 & 0xFF, 0x112e8 & 0xFF},
	{0x11300 & 0xFF, 0x11303 & 0xFF},
	{0x11305 & 0xFF, 0x1130c & 0xFF},
	{0x1130f & 0xFF, 0x11310 & 0xFF},
	{0x11313 & 0xFF, 0x11328 & 0xFF},
	{0x1132a & 0xFF, 0x11330 & 0xFF},
	{0x11332 & 0xFF, 0x11333 & 0xFF},
	{0x11335 & 0xFF, 0x11339 & 0xFF},
	{0x1133d & 0xFF, 0x11344 & 0xFF},
	{0x11347 & 0xFF, 0x11348 & 0xFF},
	{0x1134b & 0xFF, 0x1134c & 0xFF},
	{0x11350 & 0xFF, 0x11350 & 0xFF},
	{0x11357 & 0xFF, 0x11357 & 0xFF},
	{0x1135d & 0xFF, 0x11363 & 0xFF},
	{0x11400 & 0xFF, 0x11441 & 0xFF},
	{0x11443 & 0xFF, 0x11445 & 0xFF},
	{0x11447 & 0xFF, 0x1144a & 0xFF},
	{0x1145f & 0xFF, 0x11461 & 0xFF},
	{0x11480 & 0xFF, 0x114c1 & 0xFF},
	{0x114c4 & 0xFF, 0x114c5 & 0xFF},
	{0x114c7 & 0xFF, 0x114c7 & 0xFF},
	{0x11580 & 0xFF, 0x115b5 & 0xFF},
	{0x115b8 & 0xFF, 0x115be & 0xFF},
	{0x115d8 & 0xFF, 0x115dd & 0xFF},
	{0x11600 & 0xFF, 0x1163e & 0xFF},
	{0x11640 & 0xFF, 0x11640 & 0xFF},
	{0x11644 & 0xFF, 0x11644 & 0xFF},
	{0x11680 & 0xFF, 0x116b5 & 0xFF},
	{0x116b8 & 0xFF, 0x116b8 & 0xFF},
	{0x11700 & 0xFF, 0x1171a & 0xFF},
	{0x1171d & 0xFF, 0x1172a & 0xFF},
	{0x11740 & 0xFF, 0x11746 & 0xFF},
	{0x11800 & 0xFF, 0x11838 & 0xFF},
	{0x118a0 & 0xFF, 0x118df & 0xFF},
	{0x118ff & 0xFF, 0x118ff & 0xFF},
	{0x11900 & 0xFF, 0x11906 & 0xFF},
	{0x11909 & 0xFF, 0x11909 & 0xFF},
	{0x1190c & 0xFF, 0x11913 & 0xFF},
	{0x11915 & 0xFF, 0x11916 & 0xFF},
	{0x11918 & 0xFF, 0x11935 & 0xFF},
	{0x11937 & 0xFF, 0x11938 & 0xFF},
	{0x1193b & 0xFF, 0x1193c & 0xFF},
	{0x1193f & 0xFF, 0x11942 & 0xFF},
	{0x119a0 & 0xFF, 0x119a7 & 0xFF},
	{0x119aa & 0xFF, 0x119d7 & 0xFF},
	{0x119da & 0xFF, 0x119df & 0xFF},
	{0x119e1 & 0xFF, 0x119e1 & 0xFF},
	{0x119e3 & 0xFF, 0x119e4 & 0xFF},
	{0x11a00 & 0xFF, 0x11a32 & 0xFF},
	{0x11a35 & 0xFF, 0x11a3e & 0xFF},
	{0x11a50 & 0xFF, 0x11a97 & 0xFF},
	{0x11a9d & 0xFF, 0x11a9d & 0xFF},
	{0x11ab0 & 0xFF, 0x11af8 & 0xFF},
	{0x11c00 & 0xFF, 0x11c08 & 0xFF},
	{0x11c0a & 0xFF, 0x11c36 & 0xFF},
	{0x11c38 & 0xFF, 0x11c3e & 0xFF},
	{0x11c40 & 0xFF, 0x11c40 & 0xFF},
	{0x11c72 & 0xFF, 0x11c8f & 0xFF},
	{0x11c92 & 0xFF, 0x11ca7 & 0xFF},
	{0x11ca9 & 0xFF, 0x11cb6 & 0xFF},
	{0x11d00 & 0xFF, 0x11d06 & 0xFF},
	{0x11d08 & 0xFF, 0x11d09 & 0xFF},
	{0x11d0b & 0xFF, 0x11d36 & 0xFF},
	{0x11d3a & 0xFF, 0x11d3a & 0xFF},
	{0x11d3c & 0xFF, 0x11d3d & 0xFF},
	{0x11d3f & 0xFF, 0x11d41 & 0xFF},
	{0x11d43 & 0xFF, 0x11d43 & 0xFF},
	{0x11d46 & 0xFF, 0x11d47 & 0xFF},
	{0x11d60 & 0xFF, 0x11d65 & 0xFF},
	{0x11d67 & 0xFF, 0x11d68 & 0xFF},
	{0x11d6a & 0xFF, 0x11d8e & 0xFF},
	{0x11d90 & 0xFF, 0x11d91 & 0xFF},
	{0x11d93 & 0xFF, 0x11d96 & 0xFF},
	{0x11d98 & 0xFF, 0x11d98 & 0xFF},
	{0x11ee0 & 0xFF, 0x11ef6 & 0xFF},
	{0x11f00 & 0xFF, 0x11f10 & 0xFF},
	{0x11f12 & 0xFF, 0x11f3a & 0xFF},
	{0x11f3e & 0xFF, 0x11f40 & 0xFF},
	{0x11fb0 & 0xFF, 0x11fb0 & 0xFF},
	{0x12000 & 0xFF, 0x120ff & 0xFF},
	{0x12100 & 0xFF, 0x121ff & 0xFF},
	{0x12200 & 0xFF, 0x122ff & 0xFF},
	{0x12300 & 0xFF, 0x12399 & 0xFF},
	{0x12400 & 0xFF, 0x1246e & 0xFF},
	{0x12480 & 0xFF, 0x124ff & 0xFF},
	{0x12500 & 0xFF, 0x12543 & 0xFF},
	{0x12f90 & 0xFF, 0x12ff0 & 0xFF},
	{0x13000 & 0xFF, 0x130ff & 0xFF},
	{0x13100 & 0xFF, 0x131ff & 0xFF},
	{0x13200 & 0xFF, 0x132ff & 0xFF},
	{0x13300 & 0xFF, 0x133ff & 0xFF},
	{0x13400 & 0xFF, 0x1342f & 0xFF},
	{0x13441 & 0xFF, 0x13446 & 0xFF},
	{0x14400 & 0xFF, 0x144ff & 0xFF},
	{0x14500 & 0xFF, 0x145ff & 0xFF},
	{0x14600 & 0xFF, 0x14646 & 0xFF},
	{0x16800 & 0xFF, 0x168ff & 0xFF},
	{0x16900 & 0xFF, 0x169ff & 0xFF},
	{0x16a00 & 0xFF, 0x16a38 & 0xFF},
	{0x16a40 & 0xFF, 0x16a5e & 0xFF},
	{0x16a70 & 0xFF, 0x16abe & 0xFF},
	{0x16ad0 & 0xFF, 0x16aed & 0xFF},
	{0x16b00 & 0xFF, 0x16b2f & 0xFF},
	{0x16b40 & 0xFF, 0x16b43 & 0xFF},
	{0x16b63 & 0xFF, 0x16b77 & 0xFF},
	{0x16b7d & 0xFF, 0x16b8f & 0xFF},
	{0x16e40 & 0xFF, 0x16e7f & 0xFF},
	{0x16f00 & 0xFF, 0x16f4a & 0xFF},
	{0x16f4f & 0xFF, 0x16f87 & 0xFF},
	{0x16f8f & 0xFF, 0x16f9f & 0xFF},
	{0x16fe0 & 0xFF, 0x16fe1 & 0xFF},
	{0x16fe3 & 0xFF, 0x16fe3 & 0xFF},
	{0x16ff0 & 0xFF, 0x16ff1 & 0xFF},
	{0x17000 & 0xFF, 0x170ff & 0xFF},
	{0x17100 & 0xFF, 0x171ff & 0xFF},
	{0x17200 & 0xFF, 0x172ff & 0xFF},
	{0x17300 & 0xFF, 0x173ff & 0xFF},
	{0x17400 & 0xFF, 0x174ff & 0xFF},
	{0x17500 & 0xFF, 0x175ff & 0xFF},
	{0x17600 & 0xFF, 0x176ff & 0xFF},
	{0x17700 & 0xFF, 0x177ff & 0xFF},
	{0x17800 & 0xFF, 0x178ff & 0xFF},
	{0x17900 & 0xFF, 0x179ff & 0xFF},
	{0x17a00 & 0xFF, 0x17aff & 0xFF},
	{0x17b00 & 0xFF, 0x17bff & 0xFF},
	{0x17c00 & 0xFF, 0x17cff & 0xFF},
	{0x17d00 & 0xFF, 0x17dff & 0xFF},
	{0x17e00 & 0xFF, 0x17eff & 0xFF},
	{0x17f00 & 0xFF, 0x17fff & 0xFF},
	{0x18000 & 0xFF, 0x180ff & 0xFF},
	{0x18100 & 0xFF, 0x181ff & 0xFF},
	{0x18200 & 0xFF, 0x182ff & 0xFF},
	{0x18300 & 0xFF, 0x183ff & 0xFF},
	{0x18400 & 0xFF, 0x184ff & 0xFF},
	{0x18500 & 0xFF, 0x185ff & 0xFF},
	{0x18600 & 0xFF, 0x186ff & 0xFF},
	{0x18700 & 0xFF, 0x187f7 & 0xFF},
	{0x18800 & 0xFF, 0x188ff & 0xFF},
	{0x18900 & 0xFF, 0x189ff & 0xFF},
	{0x18a00 & 0xFF, 0x18aff & 0xFF},
	{0x18b00 & 0xFF, 0x18bff & 0xFF},
	{0x18c00 & 0xFF, 0x18cd5 & 0xFF},
	{0x18d00 & 0xFF, 0x18d08 & 0xFF},
	{0x1aff0 & 0xFF, 0x1aff3 & 0xFF},
	{0x1aff5 & 0xFF, 0x1affb & 0xFF},
	{0x1affd & 0xFF, 0x1affe & 0xFF},
	{0x1b000 & 0xFF, 0x1b0ff & 0xFF},
	{0x1b100 & 0xFF, 0x1b122 & 0xFF},
	{0x1b132 & 0xFF, 0x1b132 & 0xFF},
	{0x1b150 & 0xFF, 0x1b152 & 0xFF},
	{0x1b155 & 0xFF, 0x1b155 & 0xFF},
	{0x1b164 & 0xFF, 0x1b167 & 0xFF},
	{0x1b170 & 0xFF, 0x1b1ff & 0xFF},
	{0x1b200 & 0xFF, 0x1b2fb & 0xFF},
	{0x1bc00 & 0xFF, 0x1bc6a & 0xFF},
	{0x1bc70 & 0xFF, 0x1bc7c & 0xFF},
	{0x1bc80 & 0xFF, 0x1bc88 & 0xFF},
	{0x1bc90 & 0xFF, 0x1bc99 & 0xFF},
	{0x1bc9e & 0xFF, 0x1bc9e & 0xFF},
	{0x1d400 & 0xFF, 0x1d454 & 0xFF},
	{0x1d456 & 0xFF, 0x1d49c & 0xFF},
	{0x1d49e & 0xFF, 0x1d49f & 0xFF},
	{0x1d4a2 & 0xFF, 0x1d4a2 & 0xFF},
	{0x1d4a5 & 0xFF, 0x1d4a6 & 0xFF},
	{0x1d4a9 & 0xFF, 0x1d4ac & 0xFF},
	{0x1d4ae & 0xFF, 0x1d4b9 & 0xFF},
	{0x1d4bb & 0xFF, 0x1d4bb & 0xFF},
	{0x1d4bd & 0xFF, 0x1d4c3 & 0xFF},
	{0x1d4c5 & 0xFF, 0x1d4ff & 0xFF},
	{0x1d500 & 0xFF, 0x1d505 & 0xFF},
	{0x1d507 & 0xFF, 0x1d50a & 0xFF},
	{0x1d50d & 0xFF, 0x1d514 & 0xFF},
	{0x1d516 & 0xFF, 0x1d51c & 0xFF},
	{0x1d51e & 0xFF, 0x1d539 & 0xFF},
	{0x1d53b & 0xFF, 0x1d53e & 0xFF},
	{0x1d540 & 0xFF, 0x1d544 & 0xFF},
	{0x1d546 & 0xFF, 0x1d546 & 0xFF},
	{0x1d54a & 0xFF, 0x1d550 & 0xFF},
	{0x1d552 & 0xFF, 0x1d5ff & 0xFF},
	{0x1d600 & 0xFF, 0x1d6a5 & 0xFF},
	{0x1d6a8 & 0xFF, 0x1d6c0 & 0xFF},
	{0x1d6c2 & 0xFF, 0x1d6da & 0xFF},
	{0x1d6dc & 0xFF, 0x1d6fa & 0xFF},
	{0x1d6fc & 0xFF, 0x1d6ff & 0xFF},
	{0x1d700 & 0xFF, 0x1d714 & 0xFF},
	{0x1d716 & 0xFF, 0x1d734 & 0xFF},
	{0x1d736 & 0xFF, 0x1d74e & 0xFF},
	{0x1d750 & 0xFF, 0x1d76e & 0xFF},
	{0x1d770 & 0xFF, 0x1d788 & 0xFF},
	{0x1d78a & 0xFF, 0x1d7a8 & 0xFF},
	{0x1d7aa & 0xFF, 0x1d7c2 & 0xFF},
	{0x1d7c4 & 0xFF, 0x1d7cb & 0xFF},
	{0x1df00 & 0xFF, 0x1df1e & 0xFF},
	{0x1df25 & 0xFF, 0x1df2a & 0xFF},
	{0x1e000 & 0xFF, 0x1e006 & 0xFF},
	{0x1e008 & 0xFF, 0x1e018 & 0xFF},
	{0x1e01b & 0xFF, 0x1e021 & 0xFF},
	{0x1e023 & 0xFF, 0x1e024 & 0xFF},
	{0x1e026 & 0xFF, 0x1e02a & 0xFF},
	{0x1e030 & 0xFF, 0x1e06d & 0xFF},
	{0x1e08f & 0xFF, 0x1e08f & 0xFF},
	{0x1e100 & 0xFF, 0x1e12c & 0xFF},
	{0x1e137 & 0xFF, 0x1e13d & 0xFF},
	{0x1e14e & 0xFF, 0x1e14e & 0xFF},
	{0x1e290 & 0xFF, 0x1e2ad & 0xFF},
	{0x1e2c0 & 0xFF, 0x1e2eb & 0xFF},
	{0x1e4d0 & 0xFF, 0x1e4eb & 0xFF},
	{0x1e7e0 & 0xFF, 0x1e7e6 & 0xFF},
	{0x1e7e8 & 0xFF, 0x1e7eb & 0xFF},
	{0x1e7ed & 0xFF, 0x1e7ee & 0xFF},
	{0x1e7f0 & 0xFF, 0x1e7fe & 0xFF},
	{0x1e800 & 0xFF, 0x1e8c4 & 0xFF},
	{0x1e900 & 0xFF, 0x1e943 & 0xFF},
	{0x1e947 & 0xFF, 0x1e947 & 0xFF},
	{0x1e94b & 0xFF, 0x1e94b & 0xFF},
	{0x1ee00 & 0xFF, 0x1ee03 & 0xFF},
	{0x1ee05 & 0xFF, 0x1ee1f & 0xFF},
	{0x1ee21 & 0xFF, 0x1ee22 & 0xFF},
	{0x1ee24 & 0xFF, 0x1ee24 & 0xFF},
	{0x1ee27 & 0xFF, 0x1ee27 & 0xFF},
	{0x1ee29 & 0xFF, 0x1ee32 & 0xFF},
	{0x1ee34 & 0xFF, 0x1ee37 & 0xFF},
	{0x1ee39 & 0xFF, 0x1ee39 & 0xFF},
	{0x1ee3b & 0xFF, 0x1ee3b & 0xFF},
	{0x1ee42 & 0xFF, 0x1ee42 & 0xFF},
	{0x1ee47 & 0xFF, 0x1ee47 & 0xFF},
	{0x1ee49 & 0xFF, 0x1ee49 & 0xFF},
	{0x1ee4b & 0xFF, 0x1ee4b & 0xFF},
	{0x1ee4d & 0xFF, 0x1ee4f & 0xFF},
	{0x1ee51 & 0xFF, 0x1ee52 & 0xFF},
	{0x1ee54 & 0xFF, 0x1ee54 & 0xFF},
	{0x1ee57 & 0xFF, 0x1ee57 & 0xFF},
	{0x1ee59 & 0xFF, 0x1ee59 & 0xFF},
	{0x1ee5b & 0xFF, 0x1ee5b & 0xFF},
	{0x1ee5d & 0xFF, 0x1ee5d & 0xFF},
	{0x1ee5f & 0xFF, 0x1ee5f & 0xFF},
	{0x1ee61 & 0xFF, 0x1ee62 & 0xFF},
	{0x1ee64 & 0xFF, 0x1ee64 & 0xFF},
	{0x1ee67 & 0xFF, 0x1ee6a & 0xFF},
	{0x1ee6c & 0xFF, 0x1ee72 & 0xFF},
	{0x1ee74 & 0xFF, 0x1ee77 & 0xFF},
	{0x1ee79 & 0xFF, 0x1ee7c & 0xFF},
	{0x1ee7e & 0xFF, 0x1ee7e & 0xFF},
	{0x1ee80 & 0xFF, 0x1ee89 & 0xFF},
	{0x1ee8b & 0xFF, 0x1ee9b & 0xFF},
	{0x1eea1 & 0xFF, 0x1eea3 & 0xFF},
	{0x1eea5 & 0xFF, 0x1eea9 & 0xFF},
	{0x1eeab & 0xFF, 0x1eebb & 0xFF},
	{0x1f130 & 0xFF, 0x1f149 & 0xFF},
	{0x1f150 & 0xFF, 0x1f169 & 0xFF},
	{0x1f170 & 0xFF, 0x1f189 & 0xFF},
	{0x20000 & 0xFF, 0x200ff & 0xFF},
	{0x20100 & 0xFF, 0x201ff & 0xFF},
	{0x20200 & 0xFF, 0x202ff & 0xFF},
	{0x20300 & 0xFF, 0x203ff & 0xFF},
	{0x20400 & 0xFF, 0x204ff & 0xFF},
	{0x20500 & 0xFF, 0x205ff & 0xFF},
	{0x20600 & 0xFF, 0x206ff & 0xFF},
	{0x20700 & 0xFF, 0x207ff & 0xFF},
	{0x20800 & 0xFF, 0x208ff & 0xFF},
	{0x20900 & 0xFF, 0x209ff & 0xFF},
	{0x20a00 & 0xFF, 0x20aff & 0xFF},
	{0x20b00 & 0xFF, 0x20bff & 0xFF},
	{0x20c00 & 0xFF, 0x20cff & 0xFF},
	{0x20d00 & 0xFF, 0x20dff & 0xFF},
	{0x20e00 & 0xFF, 0x20eff & 0xFF},
	{0x20f00 & 0xFF, 0x20fff & 0xFF},
	{0x21000 & 0xFF, 0x210ff & 0xFF},
	{0x21100 & 0xFF, 0x211ff & 0xFF},
	{0x21200 & 0xFF, 0x212ff & 0xFF},
	{0x21300 & 0xFF, 0x213ff & 0xFF},
	{0x21400 & 0xFF, 0x214ff & 0xFF},
	{0x21500 & 0xFF, 0x215ff & 0xFF},
	{0x21600 & 0xFF, 0x216ff & 0xFF},
	{0x21700 & 0xFF, 0x217ff & 0xFF},
	{0x21800 & 0xFF, 0x218ff & 0xFF},
	{0x21900 & 0xFF, 0x219ff & 0xFF},
	{0x21a00 & 0xFF, 0x21aff & 0xFF},
	{0x21b00 & 0xFF, 0x21bff & 0xFF},
	{0x21c00 & 0xFF, 0x21cff & 0xFF},
	{0x21d00 & 0xFF, 0x21dff & 0xFF},
	{0x21e00 & 0xFF, 0x21eff & 0xFF},
	{0x21f00 & 0xFF, 0x21fff & 0xFF},
	{0x22000 & 0xFF, 0x220ff & 0xFF},
	{0x22100 & 0xFF, 0x221ff & 0xFF},
	{0x22200 & 0xFF, 0x222ff & 0xFF},
	{0x22300 & 0xFF, 0x223ff & 0xFF},
	{0x22400 & 0xFF, 0x224ff & 0xFF},
	{0x22500 & 0xFF, 0x225ff & 0xFF},
	{0x22600 & 0xFF, 0x226ff & 0xFF},
	{0x22700 & 0xFF, 0x227ff & 0xFF},
	{0x22800 & 0xFF, 0x228ff & 0xFF},
	{0x22900 & 0xFF, 0x229ff & 0xFF},
	{0x22a00 & 0xFF, 0x22aff & 0xFF},
	{0x22b00 & 0xFF, 0x22bff & 0xFF},
	{0x22c00 & 0xFF, 0x22cff & 0xFF},
	{0x22d00 & 0xFF, 0x22dff & 0xFF},
	{0x22e00 & 0xFF, 0x22eff & 0xFF},
	{0x22f00 & 0xFF, 0x22fff & 0xFF},
	{0x23000 & 0xFF, 0x230ff & 0xFF},
	{0x23100 & 0xFF, 0x231ff & 0xFF},
	{0x23200 & 0xFF, 0x232ff & 0xFF},
	{0x23300 & 0xFF, 0x233ff & 0xFF},
	{0x23400 & 0xFF, 0x234ff & 0xFF},
	{0x23500 & 0xFF, 0x235ff & 0xFF},
	{0x23600 & 0xFF, 0x236ff & 0xFF},
	{0x23700 & 0xFF, 0x237ff & 0xFF},
	{0x23800 & 0xFF, 0x238ff & 0xFF},
	{0x23900 & 0xFF, 0x239ff & 0xFF},
	{0x23a00 & 0xFF, 0x23aff & 0xFF},
	{0x23b00 & 0xFF, 0x23bff & 0xFF},
	{0x23c00 & 0xFF, 0x23cff & 0xFF},
	{0x23d00 & 0xFF, 0x23dff & 0xFF},
	{0x23e00 & 0xFF, 0x23eff & 0xFF},
	{0x23f00 & 0xFF, 0x23fff & 0xFF},
	{0x24000 & 0xFF, 0x240ff & 0xFF},
	{0x24100 & 0xFF, 0x241ff & 0xFF},
	{0x24200 & 0xFF, 0x242ff & 0xFF},
	{0x24300 & 0xFF, 0x243ff & 0xFF},
	{0x24400 & 0xFF, 0x244ff & 0xFF},
	{0x24500 & 0xFF, 0x245ff & 0xFF},
	{0x24600 & 0xFF, 0x246ff & 0xFF},
	{0x24700 & 0xFF, 0x247ff & 0xFF},
	{0x24800 & 0xFF, 0x248ff & 0xFF},
	{0x24900 & 0xFF, 0x249ff & 0xFF},
	{0x24a00 & 0xFF, 0x24aff & 0xFF},
	{0x24b00 & 0xFF, 0x24bff & 0xFF},
	{0x24c00 & 0xFF, 0x24cff & 0xFF},
	{0x24d00 & 0xFF, 0x24dff & 0xFF},
	{0x24e00 & 0xFF, 0x24eff & 0xFF},
	{0x24f00 & 0xFF, 0x24fff & 0xFF},
	{0x25000 & 0xFF, 0x250ff & 0xFF},
	{0x25100 & 0xFF, 0x251ff & 0xFF},
	{0x25200 & 0xFF, 0x252ff & 0xFF},
	{0x25300 & 0xFF, 0x253ff & 0xFF},
	{0x25400 & 0xFF, 0x254ff & 0xFF},
	{0x25500 & 0xFF, 0x255ff & 0xFF},
	{0x25600 & 0xFF, 0x256ff & 0xFF},
	{0x25700 & 0xFF, 0x257ff & 0xFF},
	{0x25800 & 0xFF, 0x258ff & 0xFF},
	{0x25900 & 0xFF, 0x259ff & 0xFF},
	{0x25a00 & 0xFF, 0x25aff & 0xFF},
	{0x25b00 & 0xFF, 0x25bff & 0xFF},
	{0x25c00 & 0xFF, 0x25cff & 0xFF},
	{0x25d00 & 0xFF, 0x25dff & 0xFF},
	{0x25e00 & 0xFF, 0x25eff & 0xFF},
	{0x25f00 & 0xFF, 0x25fff & 0xFF},
	{0x26000 & 0xFF, 0x260ff & 0xFF},
	{0x26100 & 0xFF, 0x261ff & 0xFF},
	{0x26200 & 0xFF, 0x262ff & 0xFF},
	{0x26300 & 0xFF, 0x263ff & 0xFF},
	{0x26400 & 0xFF, 0x264ff & 0xFF},
	{0x26500 & 0xFF, 0x265ff & 0xFF},
	{0x26600 & 0xFF, 0x266ff & 0xFF},
	{0x26700 & 0xFF, 0x267ff & 0xFF},
	{0x26800 & 0xFF, 0x268ff & 0xFF},
	{0x26900 & 0xFF, 0x269ff & 0xFF},
	{0x26a00 & 0xFF, 0x26aff & 0xFF},
	{0x26b00 & 0xFF, 0x26bff & 0xFF},
	{0x26c00 & 0xFF, 0x26cff & 0xFF},
	{0x26d00 & 0xFF, 0x26dff & 0xFF},
	{0x26e00 & 0xFF, 0x26eff & 0xFF},
	{0x26f00 & 0xFF, 0x26fff & 0xFF},
	{0x27000 & 0xFF, 0x270ff & 0xFF},
	{0x27100 & 0xFF, 0x271ff & 0xFF},
	{0x27200 & 0xFF, 0x272ff & 0xFF},
	{0x27300 & 0xFF, 0x273ff & 0xFF},
	{0x27400 & 0xFF, 0x274ff & 0xFF},
	{0x27500 & 0xFF, 0x275ff & 0xFF},
	{0x27600 & 0xFF, 0x276ff & 0xFF},
	{0x27700 & 0xFF, 0x277ff & 0xFF},
	{0x27800 & 0xFF, 0x278ff & 0xFF},
	{0x27900 & 0xFF, 0x279ff & 0xFF},
	{0x27a00 & 0xFF, 0x27aff & 0xFF},
	{0x27b00 & 0xFF, 0x27bff & 0xFF},
	{0x27c00 & 0xFF, 0x27cff & 0xFF},
	{0x27d00 & 0xFF, 0x27dff & 0xFF},
	{0x27e00 & 0xFF, 0x27eff & 0xFF},
	{0x27f00 & 0xFF, 0x27fff & 0xFF},
	{0x28000 & 0xFF, 0x280ff & 0xFF},
	{0x28100 & 0xFF, 0x281ff & 0xFF},
	{0x28200 & 0xFF, 0x282ff & 0xFF},
	{0x28300 & 0xFF, 0x283ff & 0xFF},
	{0x28400 & 0xFF, 0x284ff & 0xFF},
	{0x28500 & 0xFF, 0x285ff & 0xFF},
	{0x28600 & 0xFF, 0x286ff & 0xFF},
	{0x28700 & 0xFF, 0x287ff & 0xFF},
	{0x28800 & 0xFF, 0x288ff & 0xFF},
	{0x28900 & 0xFF, 0x289ff & 0xFF},
	{0x28a00 & 0xFF, 0x28aff & 0xFF},
	{0x28b00 & 0xFF, 0x28bff & 0xFF},
	{0x28c00 & 0xFF, 0x28cff & 0xFF},
	{0x28d00 & 0xFF, 0x28dff & 0xFF},
	{0x28e00 & 0xFF, 0x28eff & 0xFF},
	{0x28f00 & 0xFF, 0x28fff & 0xFF},
	{0x29000 & 0xFF, 0x290ff & 0xFF},
	{0x29100 & 0xFF, 0x291ff & 0xFF},
	{0x29200 & 0xFF, 0x292ff & 0xFF},
	{0x29300 & 0xFF, 0x293ff & 0xFF},
	{0x29400 & 0xFF, 0x294ff & 0xFF},
	{0x29500 & 0xFF, 0x295ff & 0xFF},
	{0x29600 & 0xFF, 0x296ff & 0xFF},
	{0x29700 & 0xFF, 0x297ff & 0xFF},
	{0x29800 & 0xFF, 0x298ff & 0xFF},
	{0x29900 & 0xFF, 0x299ff & 0xFF},
	{0x29a00 & 0xFF, 0x29aff & 0xFF},
	{0x29b00 & 0xFF, 0x29bff & 0xFF},
	{0x29c00 & 0xFF, 0x29cff & 0xFF},
	{0x29d00 & 0xFF, 0x29dff & 0xFF},
	{0x29e00 & 0xFF, 0x29eff & 0xFF},
	{0x29f00 & 0xFF, 0x29fff & 0xFF},
	{0x2a000 & 0xFF, 0x2a0ff & 0xFF},
	{0x2a100 & 0xFF, 0x2a1ff & 0xFF},
	{0x2a200 & 0xFF, 0x2a2ff & 0xFF},
	{0x2a300 & 0xFF, 0x2a3ff & 0xFF},
	{0x2a400 & 0xFF, 0x2a4ff & 0xFF},
	{0x2a500 & 0xFF, 0x2a5ff & 0xFF},
	{0x2a600 & 0xFF, 0x2a6df & 0xFF},
	{0x2a700 & 0xFF, 0x2a7ff & 0xFF},
	{0x2a800 & 0xFF, 0x2a8ff & 0xFF},
	{0x2a900 & 0xFF, 0x2a9ff & 0xFF},
	{0x2aa00 & 0xFF, 0x2aaff & 0xFF},
	{0x2ab00 & 0xFF, 0x2abff & 0xFF},
	{0x2ac00 & 0xFF, 0x2acff & 0xFF},
	{0x2ad00 & 0xFF, 0x2adff & 0xFF},
	{0x2ae00 & 0xFF, 0x2aeff & 0xFF},
	{0x2af00 & 0xFF, 0x2afff & 0xFF},
	{0x2b000 & 0xFF, 0x2b0ff & 0xFF},
	{0x2b100 & 0xFF, 0x2b1ff & 0xFF},
	{0x2b200 & 0xFF, 0x2b2ff & 0xFF},
	{0x2b300 & 0xFF, 0x2b3ff & 0xFF},
	{0x2b400 & 0xFF, 0x2b4ff & 0xFF},
	{0x2b500 & 0xFF, 0x2b5ff & 0xFF},
	{0x2b600 & 0xFF, 0x2b6ff & 0xFF},
	{0x2b700 & 0xFF, 0x2b739 & 0xFF},
	{0x2b740 & 0xFF, 0x2b7ff & 0xFF},
	{0x2b800 & 0xFF, 0x2b81d & 0xFF},
	{0x2b820 & 0xFF, 0x2b8ff & 0xFF},
	{0x2b900 & 0xFF, 0x2b9ff & 0xFF},
	{0x2ba00 & 0xFF, 0x2baff & 0xFF},
	{0x2bb00 & 0xFF, 0x2bbff & 0xFF},
	{0x2bc00 & 0xFF, 0x2bcff & 0xFF},
	{0x2bd00 & 0xFF, 0x2bdff & 0xFF},
	{0x2be00 & 0xFF, 0x2beff & 0xFF},
	{0x2bf00 & 0xFF, 0x2bfff & 0xFF},
	{0x2c000 & 0xFF, 0x2c0ff & 0xFF},
	{0x2c100 & 0xFF, 0x2c1ff & 0xFF},
	{0x2c200 & 0xFF, 0x2c2ff & 0xFF},
	{0x2c300 & 0xFF, 0x2c3ff & 0xFF},
	{0x2c400 & 0xFF, 0x2c4ff & 0xFF},
	{0x2c500 & 0xFF, 0x2c5ff & 0xFF},
	{0x2c600 & 0xFF, 0x2c6ff & 0xFF},
	{0x2c700 & 0xFF, 0x2c7ff & 0xFF},
	{0x2c800 & 0xFF, 0x2c8ff & 0xFF},
	{0x2c900 & 0xFF, 0x2c9ff & 0xFF},
	{0x2ca00 & 0xFF, 0x2caff & 0xFF},
	{0x2cb00 & 0xFF, 0x2cbff & 0xFF},
	{0x2cc00 & 0xFF, 0x2ccff & 0xFF},
	{0x2cd00 & 0xFF, 0x2cdff & 0xFF},
	{0x2ce00 & 0xFF, 0x2cea1 & 0xFF},
	{0x2ceb0 & 0xFF, 0x2ceff & 0xFF},
	{0x2cf00 & 0xFF, 0x2cfff & 0xFF},
	{0x2d000 & 0xFF, 0x2d0ff & 0xFF},
	{0x2d100 & 0xFF, 0x2d1ff & 0xFF},
	{0x2d200 & 0xFF, 0x2d2ff & 0xFF},
	{0x2d300 & 0xFF, 0x2d3ff & 0xFF},
	{0x2d400 & 0xFF, 0x2d4ff & 0xFF},
	{0x2d500 & 0xFF, 0x2d5ff & 0xFF},
	{0x2d600 & 0xFF, 0x2d6ff & 0xFF},
	{0x2d700 & 0xFF, 0x2d7ff & 0xFF},
	{0x2d800 & 0xFF, 0x2d8ff & 0xFF},
	{0x2d900 & 0xFF, 0x2d9ff & 0xFF},
	{0x2da00 & 0xFF, 0x2daff & 0xFF},
	{0x2db00 & 0xFF, 0x2dbff & 0xFF},
	{0x2dc00 & 0xFF, 0x2dcff & 0xFF},
	{0x2dd00 & 0xFF, 0x2ddff & 0xFF},
	{0x2de00 & 0xFF, 0x2deff & 0xFF},
	{0x2df00 & 0xFF, 0x2dfff & 0xFF},
	{0x2e000 & 0xFF, 0x2e0ff & 0xFF},
	{0x2e100 & 0xFF, 0x2e1ff & 0xFF},
	{0x2e200 & 0xFF, 0x2e2ff & 0xFF},
	{0x2e300 & 0xFF, 0x2e3ff & 0xFF},
	{0x2e400 & 0xFF, 0x2e4ff & 0xFF},
	{0x2e500 & 0xFF, 0x2e5ff & 0xFF},
	{0x2e600 & 0xFF, 0x2e6ff & 0xFF},
	{0x2e700 & 0xFF, 0x2e7ff & 0xFF},
	{0x2e800 & 0xFF, 0x2e8ff & 0xFF},
	{0x2e900 & 0xFF, 0x2e9ff & 0xFF},
	{0x2ea00 & 0xFF, 0x2eaff & 0xFF},
	{0x2eb00 & 0xFF, 0x2ebe0 & 0xFF},
	{0x2ebf0 & 0xFF, 0x2ebff & 0xFF},
	{0x2ec00 & 0xFF, 0x2ecff & 0xFF},
	{0x2ed00 & 0xFF, 0x2edff & 0xFF},
	{0x2ee00 & 0xFF, 0x2ee5d & 0xFF},
	{0x2f800 & 0xFF, 0x2f8ff & 0xFF},
	{0x2f900 & 0xFF, 0x2f9ff & 0xFF},
	{0x2fa00 & 0xFF, 0x2fa1d & 0xFF},
	{0x30000 & 0xFF, 0x300ff & 0xFF},
	{0x30100 & 0xFF, 0x301ff & 0xFF},
	{0x30200 & 0xFF, 0x302ff & 0xFF},
	{0x30300 & 0xFF, 0x303ff & 0xFF},
	{0x30400 & 0xFF, 0x304ff & 0xFF},
	{0x30500 & 0xFF, 0x305ff & 0xFF},
	{0x30600 & 0xFF, 0x306ff & 0xFF},
	{0x30700 & 0xFF, 0x307ff & 0xFF},
	{0x30800 & 0xFF, 0x308ff & 0xFF},
	{0x30900 & 0xFF, 0x309ff & 0xFF},
	{0x30a00 & 0xFF, 0x30aff & 0xFF},
	{0x30b00 & 0xFF, 0x30bff & 0xFF},
	{0x30c00 & 0xFF, 0x30cff & 0xFF},
	{0x30d00 & 0xFF, 0x30dff & 0xFF},
	{0x30e00 & 0xFF, 0x30eff & 0xFF},
	{0x30f00 & 0xFF, 0x30fff & 0xFF},
	{0x31000 & 0xFF, 0x310ff & 0xFF},
	{0x31100 & 0xFF, 0x311ff & 0xFF},
	{0x31200 & 0xFF, 0x312ff & 0xFF},
	{0x31300 & 0xFF, 0x3134a & 0xFF},
	{0x31350 & 0xFF, 0x313ff & 0xFF},
	{0x31400 & 0xFF, 0x314ff & 0xFF},
	{0x31500 & 0xFF, 0x315ff & 0xFF},
	{0x31600 & 0xFF, 0x316ff & 0xFF},
	{0x31700 & 0xFF, 0x317ff & 0xFF},
	{0x31800 & 0xFF, 0x318ff & 0xFF},
	{0x31900 & 0xFF, 0x319ff & 0xFF},
	{0x31a00 & 0xFF, 0x31aff & 0xFF},
	{0x31b00 & 0xFF, 0x31bff & 0xFF},
	{0x31c00 & 0xFF, 0x31cff & 0xFF},
	{0x31d00 & 0xFF, 0x31dff & 0xFF},
	{0x31e00 & 0xFF, 0x31eff & 0xFF},
	{0x31f00 & 0xFF, 0x31fff & 0xFF},
	{0x32000 & 0xFF, 0x320ff & 0xFF},
	{0x32100 & 0xFF, 0x321ff & 0xFF},
	{0x32200 & 0xFF, 0x322ff & 0xFF},
	{0x32300 & 0xFF, 0x323af & 0xFF}};

static const size_t Alphabetic_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	30,
	31,
	32,
	33,
	36,
	44,
	45,
	46,
	48,
	49,
	52,
	53,
	54,
	55,
	56,
	57,
	58,
	59,
	60,
	61,
	62,
	63,
	64,
	65,
	66,
	67,
	68,
	69,
	70,
	71,
	72,
	73,
	74,
	75,
	76,
	77,
	78,
	79,
	80,
	81,
	82,
	83,
	84,
	85,
	86,
	87,
	88,
	89,
	90,
	91,
	92,
	93,
	94,
	95,
	96,
	97,
	98,
	99,
	100,
	101,
	102,
	103,
	104,
	105,
	106,
	107,
	108,
	109,
	110,
	111,
	112,
	113,
	114,
	115,
	116,
	117,
	118,
	119,
	120,
	121,
	122,
	123,
	124,
	125,
	126,
	127,
	128,
	129,
	130,
	131,
	132,
	133,
	134,
	135,
	136,
	137,
	138,
	139,
	140,
	141,
	142,
	143,
	144,
	145,
	146,
	147,
	148,
	149,
	150,
	151,
	152,
	153,
	154,
	155,
	156,
	157,
	158,
	159,
	160,
	161,
	162,
	163,
	164,
	165,
	166,
	167,
	168,
	169,
	170,
	171,
	172,
	173,
	174,
	175,
	176,
	177,
	178,
	179,
	180,
	181,
	182,
	183,
	184,
	185,
	186,
	187,
	188,
	189,
	190,
	191,
	192,
	193,
	194,
	195,
	196,
	197,
	198,
	199,
	200,
	201,
	202,
	203,
	204,
	205,
	206,
	207,
	208,
	209,
	210,
	211,
	212,
	213,
	214,
	215,
	249,
	250,
	251,
	252,
	253,
	254,
	255,
	256,
	257,
	258,
	259,
	260,
	261,
	262,
	263,
	264,
	265,
	266,
	267,
	268,
	269,
	270,
	271,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	284,
	285,
	286,
	287,
	288,
	289,
	290,
	291,
	292,
	293,
	303,
	304,
	305,
	306,
	307,
	308,
	324,
	325,
	326,
	360,
	361,
	362,
	363,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	431,
	432,
	433,
	434,
	444,
	468,
	469,
	470,
	471,
	479,
	480,
	481,
	482,
	484,
	487,
	488,
	489,
	494,
	497,
	512,
	513,
	514,
	515,
	516,
	517,
	518,
	519,
	520,
	521,
	522,
	523,
	524,
	525,
	526,
	527,
	528,
	529,
	530,
	531,
	532,
	533,
	534,
	535,
	536,
	537,
	538,
	539,
	540,
	541,
	542,
	543,
	544,
	545,
	546,
	547,
	548,
	549,
	550,
	551,
	552,
	553,
	554,
	555,
	556,
	557,
	558,
	559,
	560,
	561,
	562,
	563,
	564,
	565,
	566,
	567,
	568,
	569,
	570,
	571,
	572,
	573,
	574,
	575,
	576,
	577,
	578,
	579,
	580,
	581,
	582,
	583,
	584,
	585,
	586,
	587,
	588,
	589,
	590,
	591,
	592,
	593,
	594,
	595,
	596,
	597,
	598,
	599,
	600,
	601,
	602,
	603,
	604,
	605,
	606,
	607,
	608,
	609,
	610,
	611,
	612,
	613,
	614,
	615,
	616,
	617,
	618,
	619,
	620,
	621,
	622,
	623,
	624,
	625,
	626,
	627,
	628,
	629,
	630,
	631,
	632,
	633,
	634,
	635,
	636,
	637,
	638,
	639,
	640,
	641,
	642,
	643,
	644,
	645,
	646,
	647,
	648,
	649,
	650,
	651,
	652,
	653,
	654,
	655,
	656,
	657,
	658,
	659,
	660,
	661,
	662,
	663,
	664,
	665,
	666,
	667,
	668,
	669,
	670,
	671,
	672,
	673,
	674,
	675,
	676,
	677,
	678,
	679,
	680,
	681,
	682,
	683,
	684,
	685,
	686,
	687,
	688,
	689,
	690,
	691,
	692,
	693,
	694,
	695,
	696,
	697,
	698,
	699,
	700,
	701,
	702,
	703,
	704,
	705,
	706,
	707,
	708,
	709,
	710,
	711,
	712,
	713,
	714,
	715,
	716,
	717,
	718,
	719,
	720,
	721,
	722,
	723,
	724,
	725,
	726,
	727,
	728,
	729,
	730,
	731,
	732,
	733,
	734,
	735,
	736,
	737,
	738,
	739,
	740,
	741,
	742,
	743,
	744,
	745,
	746,
	747,
	748,
	749,
	750,
	760,
	761,
	762,
	768,
	769,
	770,
	771,
	772,
	773,
	774,
	775,
	776,
	777,
	778,
	779,
	780,
	781,
	782,
	783,
	784,
	785,
	786,
	787,
	788,
	789,
	790,
	791,
	792,
	793,
	794,
	795,
	796,
	797,
	798,
	799,
	800,
	801,
	802,
	803
};

static const char32_t Alphabetic_starting_pagetab[]={
	0,
	8,
	9,
	14,
	25,
	27,
	38,
	47,
	52,
	62,
	82,
	110,
	139,
	163,
	183,
	197,
	203,
	213,
	214,
	228,
	234,
	235,
	236,
	241,
	251,
	254,
	261,
	267,
	274,
	284,
	286,
	287,
	306,
	309,
	323,
	324,
	327,
	342,
	343,
	351,
	355,
	356,
	357,
	358,
	359,
	360,
	361,
	362,
	363,
	364,
	365,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	398,
	399,
	400,
	401,
	402,
	403,
	404,
	405,
	406,
	407,
	408,
	409,
	410,
	411,
	412,
	413,
	414,
	415,
	416,
	417,
	418,
	419,
	420,
	421,
	422,
	423,
	424,
	425,
	426,
	427,
	428,
	429,
	430,
	431,
	432,
	433,
	434,
	435,
	436,
	437,
	438,
	439,
	440,
	441,
	442,
	443,
	444,
	445,
	446,
	447,
	448,
	449,
	450,
	451,
	452,
	453,
	454,
	455,
	456,
	457,
	458,
	459,
	460,
	461,
	462,
	463,
	464,
	465,
	466,
	467,
	469,
	470,
	476,
	483,
	491,
	499,
	508,
	516,
	517,
	518,
	519,
	520,
	521,
	522,
	523,
	524,
	525,
	526,
	527,
	528,
	529,
	530,
	531,
	532,
	533,
	534,
	535,
	536,
	537,
	538,
	539,
	540,
	541,
	542,
	543,
	544,
	545,
	546,
	547,
	548,
	549,
	550,
	551,
	552,
	553,
	554,
	555,
	556,
	557,
	558,
	559,
	562,
	563,
	565,
	575,
	576,
	580,
	582,
	589,
	596,
	597,
	599,
	606,
	609,
	619,
	620,
	626,
	636,
	640,
	649,
	653,
	656,
	657,
	660,
	666,
	671,
	680,
	690,
	703,
	710,
	713,
	718,
	721,
	724,
	737,
	742,
	749,
	763,
	764,
	768,
	769,
	770,
	771,
	772,
	774,
	775,
	776,
	777,
	778,
	779,
	780,
	782,
	783,
	784,
	785,
	786,
	787,
	791,
	795,
	796,
	802,
	803,
	804,
	805,
	806,
	807,
	808,
	809,
	810,
	811,
	812,
	813,
	814,
	815,
	816,
	817,
	818,
	819,
	820,
	821,
	822,
	823,
	824,
	825,
	826,
	827,
	828,
	829,
	830,
	831,
	832,
	835,
	836,
	842,
	843,
	848,
	858,
	868,
	873,
	881,
	883,
	890,
	893,
	895,
	896,
	900,
	901,
	904,
	937,
	940,
	941,
	942,
	943,
	944,
	945,
	946,
	947,
	948,
	949,
	950,
	951,
	952,
	953,
	954,
	955,
	956,
	957,
	958,
	959,
	960,
	961,
	962,
	963,
	964,
	965,
	966,
	967,
	968,
	969,
	970,
	971,
	972,
	973,
	974,
	975,
	976,
	977,
	978,
	979,
	980,
	981,
	982,
	983,
	984,
	985,
	986,
	987,
	988,
	989,
	990,
	991,
	992,
	993,
	994,
	995,
	996,
	997,
	998,
	999,
	1000,
	1001,
	1002,
	1003,
	1004,
	1005,
	1006,
	1007,
	1008,
	1009,
	1010,
	1011,
	1012,
	1013,
	1014,
	1015,
	1016,
	1017,
	1018,
	1019,
	1020,
	1021,
	1022,
	1023,
	1024,
	1025,
	1026,
	1027,
	1028,
	1029,
	1030,
	1031,
	1032,
	1033,
	1034,
	1035,
	1036,
	1037,
	1038,
	1039,
	1040,
	1041,
	1042,
	1043,
	1044,
	1045,
	1046,
	1047,
	1048,
	1049,
	1050,
	1051,
	1052,
	1053,
	1054,
	1055,
	1056,
	1057,
	1058,
	1059,
	1060,
	1061,
	1062,
	1063,
	1064,
	1065,
	1066,
	1067,
	1068,
	1069,
	1070,
	1071,
	1072,
	1073,
	1074,
	1075,
	1076,
	1077,
	1078,
	1079,
	1080,
	1081,
	1082,
	1083,
	1084,
	1085,
	1086,
	1087,
	1088,
	1089,
	1090,
	1091,
	1092,
	1093,
	1094,
	1095,
	1096,
	1097,
	1098,
	1099,
	1100,
	1101,
	1102,
	1103,
	1104,
	1105,
	1106,
	1107,
	1108,
	1109,
	1110,
	1111,
	1112,
	1113,
	1114,
	1115,
	1116,
	1117,
	1118,
	1119,
	1120,
	1121,
	1122,
	1123,
	1125,
	1127,
	1128,
	1129,
	1130,
	1131,
	1132,
	1133,
	1134,
	1135,
	1136,
	1137,
	1138,
	1139,
	1140,
	1141,
	1142,
	1143,
	1144,
	1145,
	1146,
	1147,
	1148,
	1150,
	1151,
	1152,
	1153,
	1154,
	1155,
	1156,
	1157,
	1158,
	1159,
	1160,
	1161,
	1162,
	1163,
	1164,
	1165,
	1166,
	1167,
	1168,
	1169,
	1170,
	1171,
	1172,
	1173,
	1174,
	1175,
	1176,
	1177,
	1178,
	1180,
	1181,
	1182,
	1183,
	1184,
	1185,
	1186,
	1187,
	1188,
	1189,
	1190,
	1191,
	1192,
	1193,
	1194,
	1195,
	1196,
	1197,
	1198,
	1199,
	1200,
	1201,
	1202,
	1203,
	1204,
	1205,
	1207,
	1208,
	1209,
	1210,
	1211,
	1212,
	1213,
	1214,
	1215,
	1216,
	1217,
	1218,
	1219,
	1220,
	1221,
	1222
};

static const uint8_t Case_Ignorable_rangetab[][2]={
	{0x0027 & 0xFF, 0x0027 & 0xFF},
	{0x002e & 0xFF, 0x002e & 0xFF},
	{0x003a & 0xFF, 0x003a & 0xFF},
	{0x005e & 0xFF, 0x005e & 0xFF},
	{0x0060 & 0xFF, 0x0060 & 0xFF},
	{0x00a8 & 0xFF, 0x00a8 & 0xFF},
	{0x00ad & 0xFF, 0x00ad & 0xFF},
	{0x00af & 0xFF, 0x00af & 0xFF},
	{0x00b4 & 0xFF, 0x00b4 & 0xFF},
	{0x00b7 & 0xFF, 0x00b8 & 0xFF},
	{0x02b0 & 0xFF, 0x02ff & 0xFF},
	{0x0300 & 0xFF, 0x036f & 0xFF},
	{0x0374 & 0xFF, 0x0375 & 0xFF},
	{0x037a & 0xFF, 0x037a & 0xFF},
	{0x0384 & 0xFF, 0x0385 & 0xFF},
	{0x0387 & 0xFF, 0x0387 & 0xFF},
	{0x0483 & 0xFF, 0x0489 & 0xFF},
	{0x0559 & 0xFF, 0x0559 & 0xFF},
	{0x055f & 0xFF, 0x055f & 0xFF},
	{0x0591 & 0xFF, 0x05bd & 0xFF},
	{0x05bf & 0xFF, 0x05bf & 0xFF},
	{0x05c1 & 0xFF, 0x05c2 & 0xFF},
	{0x05c4 & 0xFF, 0x05c5 & 0xFF},
	{0x05c7 & 0xFF, 0x05c7 & 0xFF},
	{0x05f4 & 0xFF, 0x05f4 & 0xFF},
	{0x0600 & 0xFF, 0x0605 & 0xFF},
	{0x0610 & 0xFF, 0x061a & 0xFF},
	{0x061c & 0xFF, 0x061c & 0xFF},
	{0x0640 & 0xFF, 0x0640 & 0xFF},
	{0x064b & 0xFF, 0x065f & 0xFF},
	{0x0670 & 0xFF, 0x0670 & 0xFF},
	{0x06d6 & 0xFF, 0x06dd & 0xFF},
	{0x06df & 0xFF, 0x06e8 & 0xFF},
	{0x06ea & 0xFF, 0x06ed & 0xFF},
	{0x070f & 0xFF, 0x070f & 0xFF},
	{0x0711 & 0xFF, 0x0711 & 0xFF},
	{0x0730 & 0xFF, 0x074a & 0xFF},
	{0x07a6 & 0xFF, 0x07b0 & 0xFF},
	{0x07eb & 0xFF, 0x07f5 & 0xFF},
	{0x07fa & 0xFF, 0x07fa & 0xFF},
	{0x07fd & 0xFF, 0x07fd & 0xFF},
	{0x0816 & 0xFF, 0x082d & 0xFF},
	{0x0859 & 0xFF, 0x085b & 0xFF},
	{0x0888 & 0xFF, 0x0888 & 0xFF},
	{0x0890 & 0xFF, 0x0891 & 0xFF},
	{0x0898 & 0xFF, 0x089f & 0xFF},
	{0x08c9 & 0xFF, 0x08ff & 0xFF},
	{0x0900 & 0xFF, 0x0902 & 0xFF},
	{0x093a & 0xFF, 0x093a & 0xFF},
	{0x093c & 0xFF, 0x093c & 0xFF},
	{0x0941 & 0xFF, 0x0948 & 0xFF},
	{0x094d & 0xFF, 0x094d & 0xFF},
	{0x0951 & 0xFF, 0x0957 & 0xFF},
	{0x0962 & 0xFF, 0x0963 & 0xFF},
	{0x0971 & 0xFF, 0x0971 & 0xFF},
	{0x0981 & 0xFF, 0x0981 & 0xFF},
	{0x09bc & 0xFF, 0x09bc & 0xFF},
	{0x09c1 & 0xFF, 0x09c4 & 0xFF},
	{0x09cd & 0xFF, 0x09cd & 0xFF},
	{0x09e2 & 0xFF, 0x09e3 & 0xFF},
	{0x09fe & 0xFF, 0x09fe & 0xFF},
	{0x0a01 & 0xFF, 0x0a02 & 0xFF},
	{0x0a3c & 0xFF, 0x0a3c & 0xFF},
	{0x0a41 & 0xFF, 0x0a42 & 0xFF},
	{0x0a47 & 0xFF, 0x0a48 & 0xFF},
	{0x0a4b & 0xFF, 0x0a4d & 0xFF},
	{0x0a51 & 0xFF, 0x0a51 & 0xFF},
	{0x0a70 & 0xFF, 0x0a71 & 0xFF},
	{0x0a75 & 0xFF, 0x0a75 & 0xFF},
	{0x0a81 & 0xFF, 0x0a82 & 0xFF},
	{0x0abc & 0xFF, 0x0abc & 0xFF},
	{0x0ac1 & 0xFF, 0x0ac5 & 0xFF},
	{0x0ac7 & 0xFF, 0x0ac8 & 0xFF},
	{0x0acd & 0xFF, 0x0acd & 0xFF},
	{0x0ae2 & 0xFF, 0x0ae3 & 0xFF},
	{0x0afa & 0xFF, 0x0aff & 0xFF},
	{0x0b01 & 0xFF, 0x0b01 & 0xFF},
	{0x0b3c & 0xFF, 0x0b3c & 0xFF},
	{0x0b3f & 0xFF, 0x0b3f & 0xFF},
	{0x0b41 & 0xFF, 0x0b44 & 0xFF},
	{0x0b4d & 0xFF, 0x0b4d & 0xFF},
	{0x0b55 & 0xFF, 0x0b56 & 0xFF},
	{0x0b62 & 0xFF, 0x0b63 & 0xFF},
	{0x0b82 & 0xFF, 0x0b82 & 0xFF},
	{0x0bc0 & 0xFF, 0x0bc0 & 0xFF},
	{0x0bcd & 0xFF, 0x0bcd & 0xFF},
	{0x0c00 & 0xFF, 0x0c00 & 0xFF},
	{0x0c04 & 0xFF, 0x0c04 & 0xFF},
	{0x0c3c & 0xFF, 0x0c3c & 0xFF},
	{0x0c3e & 0xFF, 0x0c40 & 0xFF},
	{0x0c46 & 0xFF, 0x0c48 & 0xFF},
	{0x0c4a & 0xFF, 0x0c4d & 0xFF},
	{0x0c55 & 0xFF, 0x0c56 & 0xFF},
	{0x0c62 & 0xFF, 0x0c63 & 0xFF},
	{0x0c81 & 0xFF, 0x0c81 & 0xFF},
	{0x0cbc & 0xFF, 0x0cbc & 0xFF},
	{0x0cbf & 0xFF, 0x0cbf & 0xFF},
	{0x0cc6 & 0xFF, 0x0cc6 & 0xFF},
	{0x0ccc & 0xFF, 0x0ccd & 0xFF},
	{0x0ce2 & 0xFF, 0x0ce3 & 0xFF},
	{0x0d00 & 0xFF, 0x0d01 & 0xFF},
	{0x0d3b & 0xFF, 0x0d3c & 0xFF},
	{0x0d41 & 0xFF, 0x0d44 & 0xFF},
	{0x0d4d & 0xFF, 0x0d4d & 0xFF},
	{0x0d62 & 0xFF, 0x0d63 & 0xFF},
	{0x0d81 & 0xFF, 0x0d81 & 0xFF},
	{0x0dca & 0xFF, 0x0dca & 0xFF},
	{0x0dd2 & 0xFF, 0x0dd4 & 0xFF},
	{0x0dd6 & 0xFF, 0x0dd6 & 0xFF},
	{0x0e31 & 0xFF, 0x0e31 & 0xFF},
	{0x0e34 & 0xFF, 0x0e3a & 0xFF},
	{0x0e46 & 0xFF, 0x0e4e & 0xFF},
	{0x0eb1 & 0xFF, 0x0eb1 & 0xFF},
	{0x0eb4 & 0xFF, 0x0ebc & 0xFF},
	{0x0ec6 & 0xFF, 0x0ec6 & 0xFF},
	{0x0ec8 & 0xFF, 0x0ece & 0xFF},
	{0x0f18 & 0xFF, 0x0f19 & 0xFF},
	{0x0f35 & 0xFF, 0x0f35 & 0xFF},
	{0x0f37 & 0xFF, 0x0f37 & 0xFF},
	{0x0f39 & 0xFF, 0x0f39 & 0xFF},
	{0x0f71 & 0xFF, 0x0f7e & 0xFF},
	{0x0f80 & 0xFF, 0x0f84 & 0xFF},
	{0x0f86 & 0xFF, 0x0f87 & 0xFF},
	{0x0f8d & 0xFF, 0x0f97 & 0xFF},
	{0x0f99 & 0xFF, 0x0fbc & 0xFF},
	{0x0fc6 & 0xFF, 0x0fc6 & 0xFF},
	{0x102d & 0xFF, 0x1030 & 0xFF},
	{0x1032 & 0xFF, 0x1037 & 0xFF},
	{0x1039 & 0xFF, 0x103a & 0xFF},
	{0x103d & 0xFF, 0x103e & 0xFF},
	{0x1058 & 0xFF, 0x1059 & 0xFF},
	{0x105e & 0xFF, 0x1060 & 0xFF},
	{0x1071 & 0xFF, 0x1074 & 0xFF},
	{0x1082 & 0xFF, 0x1082 & 0xFF},
	{0x1085 & 0xFF, 0x1086 & 0xFF},
	{0x108d & 0xFF, 0x108d & 0xFF},
	{0x109d & 0xFF, 0x109d & 0xFF},
	{0x10fc & 0xFF, 0x10fc & 0xFF},
	{0x135d & 0xFF, 0x135f & 0xFF},
	{0x1712 & 0xFF, 0x1714 & 0xFF},
	{0x1732 & 0xFF, 0x1733 & 0xFF},
	{0x1752 & 0xFF, 0x1753 & 0xFF},
	{0x1772 & 0xFF, 0x1773 & 0xFF},
	{0x17b4 & 0xFF, 0x17b5 & 0xFF},
	{0x17b7 & 0xFF, 0x17bd & 0xFF},
	{0x17c6 & 0xFF, 0x17c6 & 0xFF},
	{0x17c9 & 0xFF, 0x17d3 & 0xFF},
	{0x17d7 & 0xFF, 0x17d7 & 0xFF},
	{0x17dd & 0xFF, 0x17dd & 0xFF},
	{0x180b & 0xFF, 0x180f & 0xFF},
	{0x1843 & 0xFF, 0x1843 & 0xFF},
	{0x1885 & 0xFF, 0x1886 & 0xFF},
	{0x18a9 & 0xFF, 0x18a9 & 0xFF},
	{0x1920 & 0xFF, 0x1922 & 0xFF},
	{0x1927 & 0xFF, 0x1928 & 0xFF},
	{0x1932 & 0xFF, 0x1932 & 0xFF},
	{0x1939 & 0xFF, 0x193b & 0xFF},
	{0x1a17 & 0xFF, 0x1a18 & 0xFF},
	{0x1a1b & 0xFF, 0x1a1b & 0xFF},
	{0x1a56 & 0xFF, 0x1a56 & 0xFF},
	{0x1a58 & 0xFF, 0x1a5e & 0xFF},
	{0x1a60 & 0xFF, 0x1a60 & 0xFF},
	{0x1a62 & 0xFF, 0x1a62 & 0xFF},
	{0x1a65 & 0xFF, 0x1a6c & 0xFF},
	{0x1a73 & 0xFF, 0x1a7c & 0xFF},
	{0x1a7f & 0xFF, 0x1a7f & 0xFF},
	{0x1aa7 & 0xFF, 0x1aa7 & 0xFF},
	{0x1ab0 & 0xFF, 0x1ace & 0xFF},
	{0x1b00 & 0xFF, 0x1b03 & 0xFF},
	{0x1b34 & 0xFF, 0x1b34 & 0xFF},
	{0x1b36 & 0xFF, 0x1b3a & 0xFF},
	{0x1b3c & 0xFF, 0x1b3c & 0xFF},
	{0x1b42 & 0xFF, 0x1b42 & 0xFF},
	{0x1b6b & 0xFF, 0x1b73 & 0xFF},
	{0x1b80 & 0xFF, 0x1b81 & 0xFF},
	{0x1ba2 & 0xFF, 0x1ba5 & 0xFF},
	{0x1ba8 & 0xFF, 0x1ba9 & 0xFF},
	{0x1bab & 0xFF, 0x1bad & 0xFF},
	{0x1be6 & 0xFF, 0x1be6 & 0xFF},
	{0x1be8 & 0xFF, 0x1be9 & 0xFF},
	{0x1bed & 0xFF, 0x1bed & 0xFF},
	{0x1bef & 0xFF, 0x1bf1 & 0xFF},
	{0x1c2c & 0xFF, 0x1c33 & 0xFF},
	{0x1c36 & 0xFF, 0x1c37 & 0xFF},
	{0x1c78 & 0xFF, 0x1c7d & 0xFF},
	{0x1cd0 & 0xFF, 0x1cd2 & 0xFF},
	{0x1cd4 & 0xFF, 0x1ce0 & 0xFF},
	{0x1ce2 & 0xFF, 0x1ce8 & 0xFF},
	{0x1ced & 0xFF, 0x1ced & 0xFF},
	{0x1cf4 & 0xFF, 0x1cf4 & 0xFF},
	{0x1cf8 & 0xFF, 0x1cf9 & 0xFF},
	{0x1d2c & 0xFF, 0x1d6a & 0xFF},
	{0x1d78 & 0xFF, 0x1d78 & 0xFF},
	{0x1d9b & 0xFF, 0x1dff & 0xFF},
	{0x1fbd & 0xFF, 0x1fbd & 0xFF},
	{0x1fbf & 0xFF, 0x1fc1 & 0xFF},
	{0x1fcd & 0xFF, 0x1fcf & 0xFF},
	{0x1fdd & 0xFF, 0x1fdf & 0xFF},
	{0x1fed & 0xFF, 0x1fef & 0xFF},
	{0x1ffd & 0xFF, 0x1ffe & 0xFF},
	{0x200b & 0xFF, 0x200f & 0xFF},
	{0x2018 & 0xFF, 0x2019 & 0xFF},
	{0x2024 & 0xFF, 0x2024 & 0xFF},
	{0x2027 & 0xFF, 0x2027 & 0xFF},
	{0x202a & 0xFF, 0x202e & 0xFF},
	{0x2060 & 0xFF, 0x2064 & 0xFF},
	{0x2066 & 0xFF, 0x206f & 0xFF},
	{0x2071 & 0xFF, 0x2071 & 0xFF},
	{0x207f & 0xFF, 0x207f & 0xFF},
	{0x2090 & 0xFF, 0x209c & 0xFF},
	{0x20d0 & 0xFF, 0x20f0 & 0xFF},
	{0x2c7c & 0xFF, 0x2c7d & 0xFF},
	{0x2cef & 0xFF, 0x2cf1 & 0xFF},
	{0x2d6f & 0xFF, 0x2d6f & 0xFF},
	{0x2d7f & 0xFF, 0x2d7f & 0xFF},
	{0x2de0 & 0xFF, 0x2dff & 0xFF},
	{0x2e2f & 0xFF, 0x2e2f & 0xFF},
	{0x3005 & 0xFF, 0x3005 & 0xFF},
	{0x302a & 0xFF, 0x302d & 0xFF},
	{0x3031 & 0xFF, 0x3035 & 0xFF},
	{0x303b & 0xFF, 0x303b & 0xFF},
	{0x3099 & 0xFF, 0x309e & 0xFF},
	{0x30fc & 0xFF, 0x30fe & 0xFF},
	{0xa015 & 0xFF, 0xa015 & 0xFF},
	{0xa4f8 & 0xFF, 0xa4fd & 0xFF},
	{0xa60c & 0xFF, 0xa60c & 0xFF},
	{0xa66f & 0xFF, 0xa672 & 0xFF},
	{0xa674 & 0xFF, 0xa67d & 0xFF},
	{0xa67f & 0xFF, 0xa67f & 0xFF},
	{0xa69c & 0xFF, 0xa69f & 0xFF},
	{0xa6f0 & 0xFF, 0xa6f1 & 0xFF},
	{0xa700 & 0xFF, 0xa721 & 0xFF},
	{0xa770 & 0xFF, 0xa770 & 0xFF},
	{0xa788 & 0xFF, 0xa78a & 0xFF},
	{0xa7f2 & 0xFF, 0xa7f4 & 0xFF},
	{0xa7f8 & 0xFF, 0xa7f9 & 0xFF},
	{0xa802 & 0xFF, 0xa802 & 0xFF},
	{0xa806 & 0xFF, 0xa806 & 0xFF},
	{0xa80b & 0xFF, 0xa80b & 0xFF},
	{0xa825 & 0xFF, 0xa826 & 0xFF},
	{0xa82c & 0xFF, 0xa82c & 0xFF},
	{0xa8c4 & 0xFF, 0xa8c5 & 0xFF},
	{0xa8e0 & 0xFF, 0xa8f1 & 0xFF},
	{0xa8ff & 0xFF, 0xa8ff & 0xFF},
	{0xa926 & 0xFF, 0xa92d & 0xFF},
	{0xa947 & 0xFF, 0xa951 & 0xFF},
	{0xa980 & 0xFF, 0xa982 & 0xFF},
	{0xa9b3 & 0xFF, 0xa9b3 & 0xFF},
	{0xa9b6 & 0xFF, 0xa9b9 & 0xFF},
	{0xa9bc & 0xFF, 0xa9bd & 0xFF},
	{0xa9cf & 0xFF, 0xa9cf & 0xFF},
	{0xa9e5 & 0xFF, 0xa9e6 & 0xFF},
	{0xaa29 & 0xFF, 0xaa2e & 0xFF},
	{0xaa31 & 0xFF, 0xaa32 & 0xFF},
	{0xaa35 & 0xFF, 0xaa36 & 0xFF},
	{0xaa43 & 0xFF, 0xaa43 & 0xFF},
	{0xaa4c & 0xFF, 0xaa4c & 0xFF},
	{0xaa70 & 0xFF, 0xaa70 & 0xFF},
	{0xaa7c & 0xFF, 0xaa7c & 0xFF},
	{0xaab0 & 0xFF, 0xaab0 & 0xFF},
	{0xaab2 & 0xFF, 0xaab4 & 0xFF},
	{0xaab7 & 0xFF, 0xaab8 & 0xFF},
	{0xaabe & 0xFF, 0xaabf & 0xFF},
	{0xaac1 & 0xFF, 0xaac1 & 0xFF},
	{0xaadd & 0xFF, 0xaadd & 0xFF},
	{0xaaec & 0xFF, 0xaaed & 0xFF},
	{0xaaf3 & 0xFF, 0xaaf4 & 0xFF},
	{0xaaf6 & 0xFF, 0xaaf6 & 0xFF},
	{0xab5b & 0xFF, 0xab5f & 0xFF},
	{0xab69 & 0xFF, 0xab6b & 0xFF},
	{0xabe5 & 0xFF, 0xabe5 & 0xFF},
	{0xabe8 & 0xFF, 0xabe8 & 0xFF},
	{0xabed & 0xFF, 0xabed & 0xFF},
	{0xfb1e & 0xFF, 0xfb1e & 0xFF},
	{0xfbb2 & 0xFF, 0xfbc2 & 0xFF},
	{0xfe00 & 0xFF, 0xfe0f & 0xFF},
	{0xfe13 & 0xFF, 0xfe13 & 0xFF},
	{0xfe20 & 0xFF, 0xfe2f & 0xFF},
	{0xfe52 & 0xFF, 0xfe52 & 0xFF},
	{0xfe55 & 0xFF, 0xfe55 & 0xFF},
	{0xfeff & 0xFF, 0xfeff & 0xFF},
	{0xff07 & 0xFF, 0xff07 & 0xFF},
	{0xff0e & 0xFF, 0xff0e & 0xFF},
	{0xff1a & 0xFF, 0xff1a & 0xFF},
	{0xff3e & 0xFF, 0xff3e & 0xFF},
	{0xff40 & 0xFF, 0xff40 & 0xFF},
	{0xff70 & 0xFF, 0xff70 & 0xFF},
	{0xff9e & 0xFF, 0xff9f & 0xFF},
	{0xffe3 & 0xFF, 0xffe3 & 0xFF},
	{0xfff9 & 0xFF, 0xfffb & 0xFF},
	{0x101fd & 0xFF, 0x101fd & 0xFF},
	{0x102e0 & 0xFF, 0x102e0 & 0xFF},
	{0x10376 & 0xFF, 0x1037a & 0xFF},
	{0x10780 & 0xFF, 0x10785 & 0xFF},
	{0x10787 & 0xFF, 0x107b0 & 0xFF},
	{0x107b2 & 0xFF, 0x107ba & 0xFF},
	{0x10a01 & 0xFF, 0x10a03 & 0xFF},
	{0x10a05 & 0xFF, 0x10a06 & 0xFF},
	{0x10a0c & 0xFF, 0x10a0f & 0xFF},
	{0x10a38 & 0xFF, 0x10a3a & 0xFF},
	{0x10a3f & 0xFF, 0x10a3f & 0xFF},
	{0x10ae5 & 0xFF, 0x10ae6 & 0xFF},
	{0x10d24 & 0xFF, 0x10d27 & 0xFF},
	{0x10eab & 0xFF, 0x10eac & 0xFF},
	{0x10efd & 0xFF, 0x10eff & 0xFF},
	{0x10f46 & 0xFF, 0x10f50 & 0xFF},
	{0x10f82 & 0xFF, 0x10f85 & 0xFF},
	{0x11001 & 0xFF, 0x11001 & 0xFF},
	{0x11038 & 0xFF, 0x11046 & 0xFF},
	{0x11070 & 0xFF, 0x11070 & 0xFF},
	{0x11073 & 0xFF, 0x11074 & 0xFF},
	{0x1107f & 0xFF, 0x11081 & 0xFF},
	{0x110b3 & 0xFF, 0x110b6 & 0xFF},
	{0x110b9 & 0xFF, 0x110ba & 0xFF},
	{0x110bd & 0xFF, 0x110bd & 0xFF},
	{0x110c2 & 0xFF, 0x110c2 & 0xFF},
	{0x110cd & 0xFF, 0x110cd & 0xFF},
	{0x11100 & 0xFF, 0x11102 & 0xFF},
	{0x11127 & 0xFF, 0x1112b & 0xFF},
	{0x1112d & 0xFF, 0x11134 & 0xFF},
	{0x11173 & 0xFF, 0x11173 & 0xFF},
	{0x11180 & 0xFF, 0x11181 & 0xFF},
	{0x111b6 & 0xFF, 0x111be & 0xFF},
	{0x111c9 & 0xFF, 0x111cc & 0xFF},
	{0x111cf & 0xFF, 0x111cf & 0xFF},
	{0x1122f & 0xFF, 0x11231 & 0xFF},
	{0x11234 & 0xFF, 0x11234 & 0xFF},
	{0x11236 & 0xFF, 0x11237 & 0xFF},
	{0x1123e & 0xFF, 0x1123e & 0xFF},
	{0x11241 & 0xFF, 0x11241 & 0xFF},
	{0x112df & 0xFF, 0x112df & 0xFF},
	{0x112e3 & 0xFF, 0x112ea & 0xFF},
	{0x11300 & 0xFF, 0x11301 & 0xFF},
	{0x1133b & 0xFF, 0x1133c & 0xFF},
	{0x11340 & 0xFF, 0x11340 & 0xFF},
	{0x11366 & 0xFF, 0x1136c & 0xFF},
	{0x11370 & 0xFF, 0x11374 & 0xFF},
	{0x11438 & 0xFF, 0x1143f & 0xFF},
	{0x11442 & 0xFF, 0x11444 & 0xFF},
	{0x11446 & 0xFF, 0x11446 & 0xFF},
	{0x1145e & 0xFF, 0x1145e & 0xFF},
	{0x114b3 & 0xFF, 0x114b8 & 0xFF},
	{0x114ba & 0xFF, 0x114ba & 0xFF},
	{0x114bf & 0xFF, 0x114c0 & 0xFF},
	{0x114c2 & 0xFF, 0x114c3 & 0xFF},
	{0x115b2 & 0xFF, 0x115b5 & 0xFF},
	{0x115bc & 0xFF, 0x115bd & 0xFF},
	{0x115bf & 0xFF, 0x115c0 & 0xFF},
	{0x115dc & 0xFF, 0x115dd & 0xFF},
	{0x11633 & 0xFF, 0x1163a & 0xFF},
	{0x1163d & 0xFF, 0x1163d & 0xFF},
	{0x1163f & 0xFF, 0x11640 & 0xFF},
	{0x116ab & 0xFF, 0x116ab & 0xFF},
	{0x116ad & 0xFF, 0x116ad & 0xFF},
	{0x116b0 & 0xFF, 0x116b5 & 0xFF},
	{0x116b7 & 0xFF, 0x116b7 & 0xFF},
	{0x1171d & 0xFF, 0x1171f & 0xFF},
	{0x11722 & 0xFF, 0x11725 & 0xFF},
	{0x11727 & 0xFF, 0x1172b & 0xFF},
	{0x1182f & 0xFF, 0x11837 & 0xFF},
	{0x11839 & 0xFF, 0x1183a & 0xFF},
	{0x1193b & 0xFF, 0x1193c & 0xFF},
	{0x1193e & 0xFF, 0x1193e & 0xFF},
	{0x11943 & 0xFF, 0x11943 & 0xFF},
	{0x119d4 & 0xFF, 0x119d7 & 0xFF},
	{0x119da & 0xFF, 0x119db & 0xFF},
	{0x119e0 & 0xFF, 0x119e0 & 0xFF},
	{0x11a01 & 0xFF, 0x11a0a & 0xFF},
	{0x11a33 & 0xFF, 0x11a38 & 0xFF},
	{0x11a3b & 0xFF, 0x11a3e & 0xFF},
	{0x11a47 & 0xFF, 0x11a47 & 0xFF},
	{0x11a51 & 0xFF, 0x11a56 & 0xFF},
	{0x11a59 & 0xFF, 0x11a5b & 0xFF},
	{0x11a8a & 0xFF, 0x11a96 & 0xFF},
	{0x11a98 & 0xFF, 0x11a99 & 0xFF},
	{0x11c30 & 0xFF, 0x11c36 & 0xFF},
	{0x11c38 & 0xFF, 0x11c3d & 0xFF},
	{0x11c3f & 0xFF, 0x11c3f & 0xFF},
	{0x11c92 & 0xFF, 0x11ca7 & 0xFF},
	{0x11caa & 0xFF, 0x11cb0 & 0xFF},
	{0x11cb2 & 0xFF, 0x11cb3 & 0xFF},
	{0x11cb5 & 0xFF, 0x11cb6 & 0xFF},
	{0x11d31 & 0xFF, 0x11d36 & 0xFF},
	{0x11d3a & 0xFF, 0x11d3a & 0xFF},
	{0x11d3c & 0xFF, 0x11d3d & 0xFF},
	{0x11d3f & 0xFF, 0x11d45 & 0xFF},
	{0x11d47 & 0xFF, 0x11d47 & 0xFF},
	{0x11d90 & 0xFF, 0x11d91 & 0xFF},
	{0x11d95 & 0xFF, 0x11d95 & 0xFF},
	{0x11d97 & 0xFF, 0x11d97 & 0xFF},
	{0x11ef3 & 0xFF, 0x11ef4 & 0xFF},
	{0x11f00 & 0xFF, 0x11f01 & 0xFF},
	{0x11f36 & 0xFF, 0x11f3a & 0xFF},
	{0x11f40 & 0xFF, 0x11f40 & 0xFF},
	{0x11f42 & 0xFF, 0x11f42 & 0xFF},
	{0x13430 & 0xFF, 0x13440 & 0xFF},
	{0x13447 & 0xFF, 0x13455 & 0xFF},
	{0x16af0 & 0xFF, 0x16af4 & 0xFF},
	{0x16b30 & 0xFF, 0x16b36 & 0xFF},
	{0x16b40 & 0xFF, 0x16b43 & 0xFF},
	{0x16f4f & 0xFF, 0x16f4f & 0xFF},
	{0x16f8f & 0xFF, 0x16f9f & 0xFF},
	{0x16fe0 & 0xFF, 0x16fe1 & 0xFF},
	{0x16fe3 & 0xFF, 0x16fe4 & 0xFF},
	{0x1aff0 & 0xFF, 0x1aff3 & 0xFF},
	{0x1aff5 & 0xFF, 0x1affb & 0xFF},
	{0x1affd & 0xFF, 0x1affe & 0xFF},
	{0x1bc9d & 0xFF, 0x1bc9e & 0xFF},
	{0x1bca0 & 0xFF, 0x1bca3 & 0xFF},
	{0x1cf00 & 0xFF, 0x1cf2d & 0xFF},
	{0x1cf30 & 0xFF, 0x1cf46 & 0xFF},
	{0x1d167 & 0xFF, 0x1d169 & 0xFF},
	{0x1d173 & 0xFF, 0x1d182 & 0xFF},
	{0x1d185 & 0xFF, 0x1d18b & 0xFF},
	{0x1d1aa & 0xFF, 0x1d1ad & 0xFF},
	{0x1d242 & 0xFF, 0x1d244 & 0xFF},
	{0x1da00 & 0xFF, 0x1da36 & 0xFF},
	{0x1da3b & 0xFF, 0x1da6c & 0xFF},
	{0x1da75 & 0xFF, 0x1da75 & 0xFF},
	{0x1da84 & 0xFF, 0x1da84 & 0xFF},
	{0x1da9b & 0xFF, 0x1da9f & 0xFF},
	{0x1daa1 & 0xFF, 0x1daaf & 0xFF},
	{0x1e000 & 0xFF, 0x1e006 & 0xFF},
	{0x1e008 & 0xFF, 0x1e018 & 0xFF},
	{0x1e01b & 0xFF, 0x1e021 & 0xFF},
	{0x1e023 & 0xFF, 0x1e024 & 0xFF},
	{0x1e026 & 0xFF, 0x1e02a & 0xFF},
	{0x1e030 & 0xFF, 0x1e06d & 0xFF},
	{0x1e08f & 0xFF, 0x1e08f & 0xFF},
	{0x1e130 & 0xFF, 0x1e13d & 0xFF},
	{0x1e2ae & 0xFF, 0x1e2ae & 0xFF},
	{0x1e2ec & 0xFF, 0x1e2ef & 0xFF},
	{0x1e4eb & 0xFF, 0x1e4ef & 0xFF},
	{0x1e8d0 & 0xFF, 0x1e8d6 & 0xFF},
	{0x1e944 & 0xFF, 0x1e94b & 0xFF},
	{0x1f3fb & 0xFF, 0x1f3ff & 0xFF},
	{0xe0001 & 0xFF, 0xe0001 & 0xFF},
	{0xe0020 & 0xFF, 0xe007f & 0xFF},
	{0xe0100 & 0xFF, 0xe01ef & 0xFF}};

static const size_t Case_Ignorable_starting_indextab[]={
	0,
	2,
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	19,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	31,
	32,
	44,
	45,
	46,
	48,
	160,
	164,
	166,
	167,
	168,
	169,
	170,
	171,
	251,
	254,
	255,
	257,
	258,
	259,
	263,
	266,
	269,
	270,
	271,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	284,
	285,
	286,
	287,
	308,
	362,
	363,
	367,
	431,
	444,
	463,
	465,
	466,
	474,
	480,
	481,
	482,
	484,
	488,
	489,
	499,
	3584,
	3585
};

static const char32_t Case_Ignorable_starting_pagetab[]={
	0,
	10,
	11,
	16,
	17,
	25,
	34,
	41,
	47,
	61,
	76,
	86,
	100,
	109,
	116,
	126,
	138,
	139,
	149,
	153,
	157,
	168,
	182,
	191,
	194,
	200,
	211,
	213,
	216,
	217,
	223,
	224,
	225,
	231,
	236,
	244,
	252,
	268,
	273,
	275,
	281,
	290,
	291,
	292,
	293,
	296,
	302,
	303,
	305,
	307,
	317,
	325,
	332,
	337,
	345,
	349,
	356,
	359,
	361,
	367,
	375,
	382,
	390,
	391,
	395,
	397,
	398,
	400,
	404,
	407,
	409,
	411,
	415,
	416,
	422,
	429,
	430,
	432,
	433,
	434,
	435,
	436,
	438
};

static const uint8_t Cased_rangetab[][2]={
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00aa & 0xFF, 0x00aa & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00ba & 0xFF, 0x00ba & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0100 & 0xFF, 0x01ba & 0xFF},
	{0x01bc & 0xFF, 0x01bf & 0xFF},
	{0x01c4 & 0xFF, 0x01ff & 0xFF},
	{0x0200 & 0xFF, 0x0293 & 0xFF},
	{0x0295 & 0xFF, 0x02b8 & 0xFF},
	{0x02c0 & 0xFF, 0x02c1 & 0xFF},
	{0x02e0 & 0xFF, 0x02e4 & 0xFF},
	{0x0345 & 0xFF, 0x0345 & 0xFF},
	{0x0370 & 0xFF, 0x0373 & 0xFF},
	{0x0376 & 0xFF, 0x0377 & 0xFF},
	{0x037a & 0xFF, 0x037d & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x0386 & 0xFF},
	{0x0388 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03f5 & 0xFF},
	{0x03f7 & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x0481 & 0xFF},
	{0x048a & 0xFF, 0x04ff & 0xFF},
	{0x0500 & 0xFF, 0x052f & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x0560 & 0xFF, 0x0588 & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x10d0 & 0xFF, 0x10fa & 0xFF},
	{0x10fc & 0xFF, 0x10ff & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1d00 & 0xFF, 0x1dbf & 0xFF},
	{0x1e00 & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f15 & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f20 & 0xFF, 0x1f45 & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fbc & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fcc & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe0 & 0xFF, 0x1fec & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ffc & 0xFF},
	{0x2071 & 0xFF, 0x2071 & 0xFF},
	{0x207f & 0xFF, 0x207f & 0xFF},
	{0x2090 & 0xFF, 0x209c & 0xFF},
	{0x2102 & 0xFF, 0x2102 & 0xFF},
	{0x2107 & 0xFF, 0x2107 & 0xFF},
	{0x210a & 0xFF, 0x2113 & 0xFF},
	{0x2115 & 0xFF, 0x2115 & 0xFF},
	{0x2119 & 0xFF, 0x211d & 0xFF},
	{0x2124 & 0xFF, 0x2124 & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x2128 & 0xFF, 0x2128 & 0xFF},
	{0x212a & 0xFF, 0x212d & 0xFF},
	{0x212f & 0xFF, 0x2134 & 0xFF},
	{0x2139 & 0xFF, 0x2139 & 0xFF},
	{0x213c & 0xFF, 0x213f & 0xFF},
	{0x2145 & 0xFF, 0x2149 & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2160 & 0xFF, 0x217f & 0xFF},
	{0x2183 & 0xFF, 0x2184 & 0xFF},
	{0x24b6 & 0xFF, 0x24e9 & 0xFF},
	{0x2c00 & 0xFF, 0x2ce4 & 0xFF},
	{0x2ceb & 0xFF, 0x2cee & 0xFF},
	{0x2cf2 & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0xa640 & 0xFF, 0xa66d & 0xFF},
	{0xa680 & 0xFF, 0xa69d & 0xFF},
	{0xa722 & 0xFF, 0xa787 & 0xFF},
	{0xa78b & 0xFF, 0xa78e & 0xFF},
	{0xa790 & 0xFF, 0xa7ca & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d3 & 0xFF, 0xa7d3 & 0xFF},
	{0xa7d5 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f2 & 0xFF, 0xa7f6 & 0xFF},
	{0xa7f8 & 0xFF, 0xa7fa & 0xFF},
	{0xab30 & 0xFF, 0xab5a & 0xFF},
	{0xab5c & 0xFF, 0xab69 & 0xFF},
	{0xab70 & 0xFF, 0xabbf & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0x10400 & 0xFF, 0x1044f & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10780 & 0xFF, 0x10780 & 0xFF},
	{0x10783 & 0xFF, 0x10785 & 0xFF},
	{0x10787 & 0xFF, 0x107b0 & 0xFF},
	{0x107b2 & 0xFF, 0x107ba & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x118a0 & 0xFF, 0x118df & 0xFF},
	{0x16e40 & 0xFF, 0x16e7f & 0xFF},
	{0x1d400 & 0xFF, 0x1d454 & 0xFF},
	{0x1d456 & 0xFF, 0x1d49c & 0xFF},
	{0x1d49e & 0xFF, 0x1d49f & 0xFF},
	{0x1d4a2 & 0xFF, 0x1d4a2 & 0xFF},
	{0x1d4a5 & 0xFF, 0x1d4a6 & 0xFF},
	{0x1d4a9 & 0xFF, 0x1d4ac & 0xFF},
	{0x1d4ae & 0xFF, 0x1d4b9 & 0xFF},
	{0x1d4bb & 0xFF, 0x1d4bb & 0xFF},
	{0x1d4bd & 0xFF, 0x1d4c3 & 0xFF},
	{0x1d4c5 & 0xFF, 0x1d4ff & 0xFF},
	{0x1d500 & 0xFF, 0x1d505 & 0xFF},
	{0x1d507 & 0xFF, 0x1d50a & 0xFF},
	{0x1d50d & 0xFF, 0x1d514 & 0xFF},
	{0x1d516 & 0xFF, 0x1d51c & 0xFF},
	{0x1d51e & 0xFF, 0x1d539 & 0xFF},
	{0x1d53b & 0xFF, 0x1d53e & 0xFF},
	{0x1d540 & 0xFF, 0x1d544 & 0xFF},
	{0x1d546 & 0xFF, 0x1d546 & 0xFF},
	{0x1d54a & 0xFF, 0x1d550 & 0xFF},
	{0x1d552 & 0xFF, 0x1d5ff & 0xFF},
	{0x1d600 & 0xFF, 0x1d6a5 & 0xFF},
	{0x1d6a8 & 0xFF, 0x1d6c0 & 0xFF},
	{0x1d6c2 & 0xFF, 0x1d6da & 0xFF},
	{0x1d6dc & 0xFF, 0x1d6fa & 0xFF},
	{0x1d6fc & 0xFF, 0x1d6ff & 0xFF},
	{0x1d700 & 0xFF, 0x1d714 & 0xFF},
	{0x1d716 & 0xFF, 0x1d734 & 0xFF},
	{0x1d736 & 0xFF, 0x1d74e & 0xFF},
	{0x1d750 & 0xFF, 0x1d76e & 0xFF},
	{0x1d770 & 0xFF, 0x1d788 & 0xFF},
	{0x1d78a & 0xFF, 0x1d7a8 & 0xFF},
	{0x1d7aa & 0xFF, 0x1d7c2 & 0xFF},
	{0x1d7c4 & 0xFF, 0x1d7cb & 0xFF},
	{0x1df00 & 0xFF, 0x1df09 & 0xFF},
	{0x1df0b & 0xFF, 0x1df1e & 0xFF},
	{0x1df25 & 0xFF, 0x1df2a & 0xFF},
	{0x1e030 & 0xFF, 0x1e06d & 0xFF},
	{0x1e900 & 0xFF, 0x1e943 & 0xFF},
	{0x1f130 & 0xFF, 0x1f149 & 0xFF},
	{0x1f150 & 0xFF, 0x1f169 & 0xFF},
	{0x1f170 & 0xFF, 0x1f189 & 0xFF}};

static const size_t Cased_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	16,
	19,
	28,
	29,
	30,
	31,
	32,
	33,
	36,
	44,
	45,
	166,
	167,
	171,
	251,
	255,
	260,
	261,
	263,
	268,
	280,
	366,
	468,
	469,
	470,
	471,
	479,
	480,
	489,
	497
};

static const char32_t Cased_starting_pagetab[]={
	0,
	8,
	11,
	15,
	26,
	28,
	31,
	36,
	38,
	41,
	42,
	43,
	62,
	65,
	81,
	82,
	85,
	88,
	90,
	98,
	101,
	103,
	105,
	108,
	116,
	120,
	122,
	123,
	124,
	134,
	144,
	149,
	157,
	160,
	161,
	162
};

static const uint8_t Changes_When_Casefolded_rangetab[][2]={
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00df & 0xFF},
	{0x0100 & 0xFF, 0x0100 & 0xFF},
	{0x0102 & 0xFF, 0x0102 & 0xFF},
	{0x0104 & 0xFF, 0x0104 & 0xFF},
	{0x0106 & 0xFF, 0x0106 & 0xFF},
	{0x0108 & 0xFF, 0x0108 & 0xFF},
	{0x010a & 0xFF, 0x010a & 0xFF},
	{0x010c & 0xFF, 0x010c & 0xFF},
	{0x010e & 0xFF, 0x010e & 0xFF},
	{0x0110 & 0xFF, 0x0110 & 0xFF},
	{0x0112 & 0xFF, 0x0112 & 0xFF},
	{0x0114 & 0xFF, 0x0114 & 0xFF},
	{0x0116 & 0xFF, 0x0116 & 0xFF},
	{0x0118 & 0xFF, 0x0118 & 0xFF},
	{0x011a & 0xFF, 0x011a & 0xFF},
	{0x011c & 0xFF, 0x011c & 0xFF},
	{0x011e & 0xFF, 0x011e & 0xFF},
	{0x0120 & 0xFF, 0x0120 & 0xFF},
	{0x0122 & 0xFF, 0x0122 & 0xFF},
	{0x0124 & 0xFF, 0x0124 & 0xFF},
	{0x0126 & 0xFF, 0x0126 & 0xFF},
	{0x0128 & 0xFF, 0x0128 & 0xFF},
	{0x012a & 0xFF, 0x012a & 0xFF},
	{0x012c & 0xFF, 0x012c & 0xFF},
	{0x012e & 0xFF, 0x012e & 0xFF},
	{0x0130 & 0xFF, 0x0130 & 0xFF},
	{0x0132 & 0xFF, 0x0132 & 0xFF},
	{0x0134 & 0xFF, 0x0134 & 0xFF},
	{0x0136 & 0xFF, 0x0136 & 0xFF},
	{0x0139 & 0xFF, 0x0139 & 0xFF},
	{0x013b & 0xFF, 0x013b & 0xFF},
	{0x013d & 0xFF, 0x013d & 0xFF},
	{0x013f & 0xFF, 0x013f & 0xFF},
	{0x0141 & 0xFF, 0x0141 & 0xFF},
	{0x0143 & 0xFF, 0x0143 & 0xFF},
	{0x0145 & 0xFF, 0x0145 & 0xFF},
	{0x0147 & 0xFF, 0x0147 & 0xFF},
	{0x0149 & 0xFF, 0x014a & 0xFF},
	{0x014c & 0xFF, 0x014c & 0xFF},
	{0x014e & 0xFF, 0x014e & 0xFF},
	{0x0150 & 0xFF, 0x0150 & 0xFF},
	{0x0152 & 0xFF, 0x0152 & 0xFF},
	{0x0154 & 0xFF, 0x0154 & 0xFF},
	{0x0156 & 0xFF, 0x0156 & 0xFF},
	{0x0158 & 0xFF, 0x0158 & 0xFF},
	{0x015a & 0xFF, 0x015a & 0xFF},
	{0x015c & 0xFF, 0x015c & 0xFF},
	{0x015e & 0xFF, 0x015e & 0xFF},
	{0x0160 & 0xFF, 0x0160 & 0xFF},
	{0x0162 & 0xFF, 0x0162 & 0xFF},
	{0x0164 & 0xFF, 0x0164 & 0xFF},
	{0x0166 & 0xFF, 0x0166 & 0xFF},
	{0x0168 & 0xFF, 0x0168 & 0xFF},
	{0x016a & 0xFF, 0x016a & 0xFF},
	{0x016c & 0xFF, 0x016c & 0xFF},
	{0x016e & 0xFF, 0x016e & 0xFF},
	{0x0170 & 0xFF, 0x0170 & 0xFF},
	{0x0172 & 0xFF, 0x0172 & 0xFF},
	{0x0174 & 0xFF, 0x0174 & 0xFF},
	{0x0176 & 0xFF, 0x0176 & 0xFF},
	{0x0178 & 0xFF, 0x0179 & 0xFF},
	{0x017b & 0xFF, 0x017b & 0xFF},
	{0x017d & 0xFF, 0x017d & 0xFF},
	{0x017f & 0xFF, 0x017f & 0xFF},
	{0x0181 & 0xFF, 0x0182 & 0xFF},
	{0x0184 & 0xFF, 0x0184 & 0xFF},
	{0x0186 & 0xFF, 0x0187 & 0xFF},
	{0x0189 & 0xFF, 0x018b & 0xFF},
	{0x018e & 0xFF, 0x0191 & 0xFF},
	{0x0193 & 0xFF, 0x0194 & 0xFF},
	{0x0196 & 0xFF, 0x0198 & 0xFF},
	{0x019c & 0xFF, 0x019d & 0xFF},
	{0x019f & 0xFF, 0x01a0 & 0xFF},
	{0x01a2 & 0xFF, 0x01a2 & 0xFF},
	{0x01a4 & 0xFF, 0x01a4 & 0xFF},
	{0x01a6 & 0xFF, 0x01a7 & 0xFF},
	{0x01a9 & 0xFF, 0x01a9 & 0xFF},
	{0x01ac & 0xFF, 0x01ac & 0xFF},
	{0x01ae & 0xFF, 0x01af & 0xFF},
	{0x01b1 & 0xFF, 0x01b3 & 0xFF},
	{0x01b5 & 0xFF, 0x01b5 & 0xFF},
	{0x01b7 & 0xFF, 0x01b8 & 0xFF},
	{0x01bc & 0xFF, 0x01bc & 0xFF},
	{0x01c4 & 0xFF, 0x01c5 & 0xFF},
	{0x01c7 & 0xFF, 0x01c8 & 0xFF},
	{0x01ca & 0xFF, 0x01cb & 0xFF},
	{0x01cd & 0xFF, 0x01cd & 0xFF},
	{0x01cf & 0xFF, 0x01cf & 0xFF},
	{0x01d1 & 0xFF, 0x01d1 & 0xFF},
	{0x01d3 & 0xFF, 0x01d3 & 0xFF},
	{0x01d5 & 0xFF, 0x01d5 & 0xFF},
	{0x01d7 & 0xFF, 0x01d7 & 0xFF},
	{0x01d9 & 0xFF, 0x01d9 & 0xFF},
	{0x01db & 0xFF, 0x01db & 0xFF},
	{0x01de & 0xFF, 0x01de & 0xFF},
	{0x01e0 & 0xFF, 0x01e0 & 0xFF},
	{0x01e2 & 0xFF, 0x01e2 & 0xFF},
	{0x01e4 & 0xFF, 0x01e4 & 0xFF},
	{0x01e6 & 0xFF, 0x01e6 & 0xFF},
	{0x01e8 & 0xFF, 0x01e8 & 0xFF},
	{0x01ea & 0xFF, 0x01ea & 0xFF},
	{0x01ec & 0xFF, 0x01ec & 0xFF},
	{0x01ee & 0xFF, 0x01ee & 0xFF},
	{0x01f1 & 0xFF, 0x01f2 & 0xFF},
	{0x01f4 & 0xFF, 0x01f4 & 0xFF},
	{0x01f6 & 0xFF, 0x01f8 & 0xFF},
	{0x01fa & 0xFF, 0x01fa & 0xFF},
	{0x01fc & 0xFF, 0x01fc & 0xFF},
	{0x01fe & 0xFF, 0x01fe & 0xFF},
	{0x0200 & 0xFF, 0x0200 & 0xFF},
	{0x0202 & 0xFF, 0x0202 & 0xFF},
	{0x0204 & 0xFF, 0x0204 & 0xFF},
	{0x0206 & 0xFF, 0x0206 & 0xFF},
	{0x0208 & 0xFF, 0x0208 & 0xFF},
	{0x020a & 0xFF, 0x020a & 0xFF},
	{0x020c & 0xFF, 0x020c & 0xFF},
	{0x020e & 0xFF, 0x020e & 0xFF},
	{0x0210 & 0xFF, 0x0210 & 0xFF},
	{0x0212 & 0xFF, 0x0212 & 0xFF},
	{0x0214 & 0xFF, 0x0214 & 0xFF},
	{0x0216 & 0xFF, 0x0216 & 0xFF},
	{0x0218 & 0xFF, 0x0218 & 0xFF},
	{0x021a & 0xFF, 0x021a & 0xFF},
	{0x021c & 0xFF, 0x021c & 0xFF},
	{0x021e & 0xFF, 0x021e & 0xFF},
	{0x0220 & 0xFF, 0x0220 & 0xFF},
	{0x0222 & 0xFF, 0x0222 & 0xFF},
	{0x0224 & 0xFF, 0x0224 & 0xFF},
	{0x0226 & 0xFF, 0x0226 & 0xFF},
	{0x0228 & 0xFF, 0x0228 & 0xFF},
	{0x022a & 0xFF, 0x022a & 0xFF},
	{0x022c & 0xFF, 0x022c & 0xFF},
	{0x022e & 0xFF, 0x022e & 0xFF},
	{0x0230 & 0xFF, 0x0230 & 0xFF},
	{0x0232 & 0xFF, 0x0232 & 0xFF},
	{0x023a & 0xFF, 0x023b & 0xFF},
	{0x023d & 0xFF, 0x023e & 0xFF},
	{0x0241 & 0xFF, 0x0241 & 0xFF},
	{0x0243 & 0xFF, 0x0246 & 0xFF},
	{0x0248 & 0xFF, 0x0248 & 0xFF},
	{0x024a & 0xFF, 0x024a & 0xFF},
	{0x024c & 0xFF, 0x024c & 0xFF},
	{0x024e & 0xFF, 0x024e & 0xFF},
	{0x0345 & 0xFF, 0x0345 & 0xFF},
	{0x0370 & 0xFF, 0x0370 & 0xFF},
	{0x0372 & 0xFF, 0x0372 & 0xFF},
	{0x0376 & 0xFF, 0x0376 & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x0386 & 0xFF},
	{0x0388 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x038f & 0xFF},
	{0x0391 & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03ab & 0xFF},
	{0x03c2 & 0xFF, 0x03c2 & 0xFF},
	{0x03cf & 0xFF, 0x03d1 & 0xFF},
	{0x03d5 & 0xFF, 0x03d6 & 0xFF},
	{0x03d8 & 0xFF, 0x03d8 & 0xFF},
	{0x03da & 0xFF, 0x03da & 0xFF},
	{0x03dc & 0xFF, 0x03dc & 0xFF},
	{0x03de & 0xFF, 0x03de & 0xFF},
	{0x03e0 & 0xFF, 0x03e0 & 0xFF},
	{0x03e2 & 0xFF, 0x03e2 & 0xFF},
	{0x03e4 & 0xFF, 0x03e4 & 0xFF},
	{0x03e6 & 0xFF, 0x03e6 & 0xFF},
	{0x03e8 & 0xFF, 0x03e8 & 0xFF},
	{0x03ea & 0xFF, 0x03ea & 0xFF},
	{0x03ec & 0xFF, 0x03ec & 0xFF},
	{0x03ee & 0xFF, 0x03ee & 0xFF},
	{0x03f0 & 0xFF, 0x03f1 & 0xFF},
	{0x03f4 & 0xFF, 0x03f5 & 0xFF},
	{0x03f7 & 0xFF, 0x03f7 & 0xFF},
	{0x03f9 & 0xFF, 0x03fa & 0xFF},
	{0x03fd & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x042f & 0xFF},
	{0x0460 & 0xFF, 0x0460 & 0xFF},
	{0x0462 & 0xFF, 0x0462 & 0xFF},
	{0x0464 & 0xFF, 0x0464 & 0xFF},
	{0x0466 & 0xFF, 0x0466 & 0xFF},
	{0x0468 & 0xFF, 0x0468 & 0xFF},
	{0x046a & 0xFF, 0x046a & 0xFF},
	{0x046c & 0xFF, 0x046c & 0xFF},
	{0x046e & 0xFF, 0x046e & 0xFF},
	{0x0470 & 0xFF, 0x0470 & 0xFF},
	{0x0472 & 0xFF, 0x0472 & 0xFF},
	{0x0474 & 0xFF, 0x0474 & 0xFF},
	{0x0476 & 0xFF, 0x0476 & 0xFF},
	{0x0478 & 0xFF, 0x0478 & 0xFF},
	{0x047a & 0xFF, 0x047a & 0xFF},
	{0x047c & 0xFF, 0x047c & 0xFF},
	{0x047e & 0xFF, 0x047e & 0xFF},
	{0x0480 & 0xFF, 0x0480 & 0xFF},
	{0x048a & 0xFF, 0x048a & 0xFF},
	{0x048c & 0xFF, 0x048c & 0xFF},
	{0x048e & 0xFF, 0x048e & 0xFF},
	{0x0490 & 0xFF, 0x0490 & 0xFF},
	{0x0492 & 0xFF, 0x0492 & 0xFF},
	{0x0494 & 0xFF, 0x0494 & 0xFF},
	{0x0496 & 0xFF, 0x0496 & 0xFF},
	{0x0498 & 0xFF, 0x0498 & 0xFF},
	{0x049a & 0xFF, 0x049a & 0xFF},
	{0x049c & 0xFF, 0x049c & 0xFF},
	{0x049e & 0xFF, 0x049e & 0xFF},
	{0x04a0 & 0xFF, 0x04a0 & 0xFF},
	{0x04a2 & 0xFF, 0x04a2 & 0xFF},
	{0x04a4 & 0xFF, 0x04a4 & 0xFF},
	{0x04a6 & 0xFF, 0x04a6 & 0xFF},
	{0x04a8 & 0xFF, 0x04a8 & 0xFF},
	{0x04aa & 0xFF, 0x04aa & 0xFF},
	{0x04ac & 0xFF, 0x04ac & 0xFF},
	{0x04ae & 0xFF, 0x04ae & 0xFF},
	{0x04b0 & 0xFF, 0x04b0 & 0xFF},
	{0x04b2 & 0xFF, 0x04b2 & 0xFF},
	{0x04b4 & 0xFF, 0x04b4 & 0xFF},
	{0x04b6 & 0xFF, 0x04b6 & 0xFF},
	{0x04b8 & 0xFF, 0x04b8 & 0xFF},
	{0x04ba & 0xFF, 0x04ba & 0xFF},
	{0x04bc & 0xFF, 0x04bc & 0xFF},
	{0x04be & 0xFF, 0x04be & 0xFF},
	{0x04c0 & 0xFF, 0x04c1 & 0xFF},
	{0x04c3 & 0xFF, 0x04c3 & 0xFF},
	{0x04c5 & 0xFF, 0x04c5 & 0xFF},
	{0x04c7 & 0xFF, 0x04c7 & 0xFF},
	{0x04c9 & 0xFF, 0x04c9 & 0xFF},
	{0x04cb & 0xFF, 0x04cb & 0xFF},
	{0x04cd & 0xFF, 0x04cd & 0xFF},
	{0x04d0 & 0xFF, 0x04d0 & 0xFF},
	{0x04d2 & 0xFF, 0x04d2 & 0xFF},
	{0x04d4 & 0xFF, 0x04d4 & 0xFF},
	{0x04d6 & 0xFF, 0x04d6 & 0xFF},
	{0x04d8 & 0xFF, 0x04d8 & 0xFF},
	{0x04da & 0xFF, 0x04da & 0xFF},
	{0x04dc & 0xFF, 0x04dc & 0xFF},
	{0x04de & 0xFF, 0x04de & 0xFF},
	{0x04e0 & 0xFF, 0x04e0 & 0xFF},
	{0x04e2 & 0xFF, 0x04e2 & 0xFF},
	{0x04e4 & 0xFF, 0x04e4 & 0xFF},
	{0x04e6 & 0xFF, 0x04e6 & 0xFF},
	{0x04e8 & 0xFF, 0x04e8 & 0xFF},
	{0x04ea & 0xFF, 0x04ea & 0xFF},
	{0x04ec & 0xFF, 0x04ec & 0xFF},
	{0x04ee & 0xFF, 0x04ee & 0xFF},
	{0x04f0 & 0xFF, 0x04f0 & 0xFF},
	{0x04f2 & 0xFF, 0x04f2 & 0xFF},
	{0x04f4 & 0xFF, 0x04f4 & 0xFF},
	{0x04f6 & 0xFF, 0x04f6 & 0xFF},
	{0x04f8 & 0xFF, 0x04f8 & 0xFF},
	{0x04fa & 0xFF, 0x04fa & 0xFF},
	{0x04fc & 0xFF, 0x04fc & 0xFF},
	{0x04fe & 0xFF, 0x04fe & 0xFF},
	{0x0500 & 0xFF, 0x0500 & 0xFF},
	{0x0502 & 0xFF, 0x0502 & 0xFF},
	{0x0504 & 0xFF, 0x0504 & 0xFF},
	{0x0506 & 0xFF, 0x0506 & 0xFF},
	{0x0508 & 0xFF, 0x0508 & 0xFF},
	{0x050a & 0xFF, 0x050a & 0xFF},
	{0x050c & 0xFF, 0x050c & 0xFF},
	{0x050e & 0xFF, 0x050e & 0xFF},
	{0x0510 & 0xFF, 0x0510 & 0xFF},
	{0x0512 & 0xFF, 0x0512 & 0xFF},
	{0x0514 & 0xFF, 0x0514 & 0xFF},
	{0x0516 & 0xFF, 0x0516 & 0xFF},
	{0x0518 & 0xFF, 0x0518 & 0xFF},
	{0x051a & 0xFF, 0x051a & 0xFF},
	{0x051c & 0xFF, 0x051c & 0xFF},
	{0x051e & 0xFF, 0x051e & 0xFF},
	{0x0520 & 0xFF, 0x0520 & 0xFF},
	{0x0522 & 0xFF, 0x0522 & 0xFF},
	{0x0524 & 0xFF, 0x0524 & 0xFF},
	{0x0526 & 0xFF, 0x0526 & 0xFF},
	{0x0528 & 0xFF, 0x0528 & 0xFF},
	{0x052a & 0xFF, 0x052a & 0xFF},
	{0x052c & 0xFF, 0x052c & 0xFF},
	{0x052e & 0xFF, 0x052e & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x0587 & 0xFF, 0x0587 & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1e00 & 0xFF, 0x1e00 & 0xFF},
	{0x1e02 & 0xFF, 0x1e02 & 0xFF},
	{0x1e04 & 0xFF, 0x1e04 & 0xFF},
	{0x1e06 & 0xFF, 0x1e06 & 0xFF},
	{0x1e08 & 0xFF, 0x1e08 & 0xFF},
	{0x1e0a & 0xFF, 0x1e0a & 0xFF},
	{0x1e0c & 0xFF, 0x1e0c & 0xFF},
	{0x1e0e & 0xFF, 0x1e0e & 0xFF},
	{0x1e10 & 0xFF, 0x1e10 & 0xFF},
	{0x1e12 & 0xFF, 0x1e12 & 0xFF},
	{0x1e14 & 0xFF, 0x1e14 & 0xFF},
	{0x1e16 & 0xFF, 0x1e16 & 0xFF},
	{0x1e18 & 0xFF, 0x1e18 & 0xFF},
	{0x1e1a & 0xFF, 0x1e1a & 0xFF},
	{0x1e1c & 0xFF, 0x1e1c & 0xFF},
	{0x1e1e & 0xFF, 0x1e1e & 0xFF},
	{0x1e20 & 0xFF, 0x1e20 & 0xFF},
	{0x1e22 & 0xFF, 0x1e22 & 0xFF},
	{0x1e24 & 0xFF, 0x1e24 & 0xFF},
	{0x1e26 & 0xFF, 0x1e26 & 0xFF},
	{0x1e28 & 0xFF, 0x1e28 & 0xFF},
	{0x1e2a & 0xFF, 0x1e2a & 0xFF},
	{0x1e2c & 0xFF, 0x1e2c & 0xFF},
	{0x1e2e & 0xFF, 0x1e2e & 0xFF},
	{0x1e30 & 0xFF, 0x1e30 & 0xFF},
	{0x1e32 & 0xFF, 0x1e32 & 0xFF},
	{0x1e34 & 0xFF, 0x1e34 & 0xFF},
	{0x1e36 & 0xFF, 0x1e36 & 0xFF},
	{0x1e38 & 0xFF, 0x1e38 & 0xFF},
	{0x1e3a & 0xFF, 0x1e3a & 0xFF},
	{0x1e3c & 0xFF, 0x1e3c & 0xFF},
	{0x1e3e & 0xFF, 0x1e3e & 0xFF},
	{0x1e40 & 0xFF, 0x1e40 & 0xFF},
	{0x1e42 & 0xFF, 0x1e42 & 0xFF},
	{0x1e44 & 0xFF, 0x1e44 & 0xFF},
	{0x1e46 & 0xFF, 0x1e46 & 0xFF},
	{0x1e48 & 0xFF, 0x1e48 & 0xFF},
	{0x1e4a & 0xFF, 0x1e4a & 0xFF},
	{0x1e4c & 0xFF, 0x1e4c & 0xFF},
	{0x1e4e & 0xFF, 0x1e4e & 0xFF},
	{0x1e50 & 0xFF, 0x1e50 & 0xFF},
	{0x1e52 & 0xFF, 0x1e52 & 0xFF},
	{0x1e54 & 0xFF, 0x1e54 & 0xFF},
	{0x1e56 & 0xFF, 0x1e56 & 0xFF},
	{0x1e58 & 0xFF, 0x1e58 & 0xFF},
	{0x1e5a & 0xFF, 0x1e5a & 0xFF},
	{0x1e5c & 0xFF, 0x1e5c & 0xFF},
	{0x1e5e & 0xFF, 0x1e5e & 0xFF},
	{0x1e60 & 0xFF, 0x1e60 & 0xFF},
	{0x1e62 & 0xFF, 0x1e62 & 0xFF},
	{0x1e64 & 0xFF, 0x1e64 & 0xFF},
	{0x1e66 & 0xFF, 0x1e66 & 0xFF},
	{0x1e68 & 0xFF, 0x1e68 & 0xFF},
	{0x1e6a & 0xFF, 0x1e6a & 0xFF},
	{0x1e6c & 0xFF, 0x1e6c & 0xFF},
	{0x1e6e & 0xFF, 0x1e6e & 0xFF},
	{0x1e70 & 0xFF, 0x1e70 & 0xFF},
	{0x1e72 & 0xFF, 0x1e72 & 0xFF},
	{0x1e74 & 0xFF, 0x1e74 & 0xFF},
	{0x1e76 & 0xFF, 0x1e76 & 0xFF},
	{0x1e78 & 0xFF, 0x1e78 & 0xFF},
	{0x1e7a & 0xFF, 0x1e7a & 0xFF},
	{0x1e7c & 0xFF, 0x1e7c & 0xFF},
	{0x1e7e & 0xFF, 0x1e7e & 0xFF},
	{0x1e80 & 0xFF, 0x1e80 & 0xFF},
	{0x1e82 & 0xFF, 0x1e82 & 0xFF},
	{0x1e84 & 0xFF, 0x1e84 & 0xFF},
	{0x1e86 & 0xFF, 0x1e86 & 0xFF},
	{0x1e88 & 0xFF, 0x1e88 & 0xFF},
	{0x1e8a & 0xFF, 0x1e8a & 0xFF},
	{0x1e8c & 0xFF, 0x1e8c & 0xFF},
	{0x1e8e & 0xFF, 0x1e8e & 0xFF},
	{0x1e90 & 0xFF, 0x1e90 & 0xFF},
	{0x1e92 & 0xFF, 0x1e92 & 0xFF},
	{0x1e94 & 0xFF, 0x1e94 & 0xFF},
	{0x1e9a & 0xFF, 0x1e9b & 0xFF},
	{0x1e9e & 0xFF, 0x1e9e & 0xFF},
	{0x1ea0 & 0xFF, 0x1ea0 & 0xFF},
	{0x1ea2 & 0xFF, 0x1ea2 & 0xFF},
	{0x1ea4 & 0xFF, 0x1ea4 & 0xFF},
	{0x1ea6 & 0xFF, 0x1ea6 & 0xFF},
	{0x1ea8 & 0xFF, 0x1ea8 & 0xFF},
	{0x1eaa & 0xFF, 0x1eaa & 0xFF},
	{0x1eac & 0xFF, 0x1eac & 0xFF},
	{0x1eae & 0xFF, 0x1eae & 0xFF},
	{0x1eb0 & 0xFF, 0x1eb0 & 0xFF},
	{0x1eb2 & 0xFF, 0x1eb2 & 0xFF},
	{0x1eb4 & 0xFF, 0x1eb4 & 0xFF},
	{0x1eb6 & 0xFF, 0x1eb6 & 0xFF},
	{0x1eb8 & 0xFF, 0x1eb8 & 0xFF},
	{0x1eba & 0xFF, 0x1eba & 0xFF},
	{0x1ebc & 0xFF, 0x1ebc & 0xFF},
	{0x1ebe & 0xFF, 0x1ebe & 0xFF},
	{0x1ec0 & 0xFF, 0x1ec0 & 0xFF},
	{0x1ec2 & 0xFF, 0x1ec2 & 0xFF},
	{0x1ec4 & 0xFF, 0x1ec4 & 0xFF},
	{0x1ec6 & 0xFF, 0x1ec6 & 0xFF},
	{0x1ec8 & 0xFF, 0x1ec8 & 0xFF},
	{0x1eca & 0xFF, 0x1eca & 0xFF},
	{0x1ecc & 0xFF, 0x1ecc & 0xFF},
	{0x1ece & 0xFF, 0x1ece & 0xFF},
	{0x1ed0 & 0xFF, 0x1ed0 & 0xFF},
	{0x1ed2 & 0xFF, 0x1ed2 & 0xFF},
	{0x1ed4 & 0xFF, 0x1ed4 & 0xFF},
	{0x1ed6 & 0xFF, 0x1ed6 & 0xFF},
	{0x1ed8 & 0xFF, 0x1ed8 & 0xFF},
	{0x1eda & 0xFF, 0x1eda & 0xFF},
	{0x1edc & 0xFF, 0x1edc & 0xFF},
	{0x1ede & 0xFF, 0x1ede & 0xFF},
	{0x1ee0 & 0xFF, 0x1ee0 & 0xFF},
	{0x1ee2 & 0xFF, 0x1ee2 & 0xFF},
	{0x1ee4 & 0xFF, 0x1ee4 & 0xFF},
	{0x1ee6 & 0xFF, 0x1ee6 & 0xFF},
	{0x1ee8 & 0xFF, 0x1ee8 & 0xFF},
	{0x1eea & 0xFF, 0x1eea & 0xFF},
	{0x1eec & 0xFF, 0x1eec & 0xFF},
	{0x1eee & 0xFF, 0x1eee & 0xFF},
	{0x1ef0 & 0xFF, 0x1ef0 & 0xFF},
	{0x1ef2 & 0xFF, 0x1ef2 & 0xFF},
	{0x1ef4 & 0xFF, 0x1ef4 & 0xFF},
	{0x1ef6 & 0xFF, 0x1ef6 & 0xFF},
	{0x1ef8 & 0xFF, 0x1ef8 & 0xFF},
	{0x1efa & 0xFF, 0x1efa & 0xFF},
	{0x1efc & 0xFF, 0x1efc & 0xFF},
	{0x1efe & 0xFF, 0x1efe & 0xFF},
	{0x1f08 & 0xFF, 0x1f0f & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f28 & 0xFF, 0x1f2f & 0xFF},
	{0x1f38 & 0xFF, 0x1f3f & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f5f & 0xFF},
	{0x1f68 & 0xFF, 0x1f6f & 0xFF},
	{0x1f80 & 0xFF, 0x1faf & 0xFF},
	{0x1fb2 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb7 & 0xFF, 0x1fbc & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc7 & 0xFF, 0x1fcc & 0xFF},
	{0x1fd8 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe8 & 0xFF, 0x1fec & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff7 & 0xFF, 0x1ffc & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x212a & 0xFF, 0x212b & 0xFF},
	{0x2132 & 0xFF, 0x2132 & 0xFF},
	{0x2160 & 0xFF, 0x216f & 0xFF},
	{0x2183 & 0xFF, 0x2183 & 0xFF},
	{0x24b6 & 0xFF, 0x24cf & 0xFF},
	{0x2c00 & 0xFF, 0x2c2f & 0xFF},
	{0x2c60 & 0xFF, 0x2c60 & 0xFF},
	{0x2c62 & 0xFF, 0x2c64 & 0xFF},
	{0x2c67 & 0xFF, 0x2c67 & 0xFF},
	{0x2c69 & 0xFF, 0x2c69 & 0xFF},
	{0x2c6b & 0xFF, 0x2c6b & 0xFF},
	{0x2c6d & 0xFF, 0x2c70 & 0xFF},
	{0x2c72 & 0xFF, 0x2c72 & 0xFF},
	{0x2c75 & 0xFF, 0x2c75 & 0xFF},
	{0x2c7e & 0xFF, 0x2c80 & 0xFF},
	{0x2c82 & 0xFF, 0x2c82 & 0xFF},
	{0x2c84 & 0xFF, 0x2c84 & 0xFF},
	{0x2c86 & 0xFF, 0x2c86 & 0xFF},
	{0x2c88 & 0xFF, 0x2c88 & 0xFF},
	{0x2c8a & 0xFF, 0x2c8a & 0xFF},
	{0x2c8c & 0xFF, 0x2c8c & 0xFF},
	{0x2c8e & 0xFF, 0x2c8e & 0xFF},
	{0x2c90 & 0xFF, 0x2c90 & 0xFF},
	{0x2c92 & 0xFF, 0x2c92 & 0xFF},
	{0x2c94 & 0xFF, 0x2c94 & 0xFF},
	{0x2c96 & 0xFF, 0x2c96 & 0xFF},
	{0x2c98 & 0xFF, 0x2c98 & 0xFF},
	{0x2c9a & 0xFF, 0x2c9a & 0xFF},
	{0x2c9c & 0xFF, 0x2c9c & 0xFF},
	{0x2c9e & 0xFF, 0x2c9e & 0xFF},
	{0x2ca0 & 0xFF, 0x2ca0 & 0xFF},
	{0x2ca2 & 0xFF, 0x2ca2 & 0xFF},
	{0x2ca4 & 0xFF, 0x2ca4 & 0xFF},
	{0x2ca6 & 0xFF, 0x2ca6 & 0xFF},
	{0x2ca8 & 0xFF, 0x2ca8 & 0xFF},
	{0x2caa & 0xFF, 0x2caa & 0xFF},
	{0x2cac & 0xFF, 0x2cac & 0xFF},
	{0x2cae & 0xFF, 0x2cae & 0xFF},
	{0x2cb0 & 0xFF, 0x2cb0 & 0xFF},
	{0x2cb2 & 0xFF, 0x2cb2 & 0xFF},
	{0x2cb4 & 0xFF, 0x2cb4 & 0xFF},
	{0x2cb6 & 0xFF, 0x2cb6 & 0xFF},
	{0x2cb8 & 0xFF, 0x2cb8 & 0xFF},
	{0x2cba & 0xFF, 0x2cba & 0xFF},
	{0x2cbc & 0xFF, 0x2cbc & 0xFF},
	{0x2cbe & 0xFF, 0x2cbe & 0xFF},
	{0x2cc0 & 0xFF, 0x2cc0 & 0xFF},
	{0x2cc2 & 0xFF, 0x2cc2 & 0xFF},
	{0x2cc4 & 0xFF, 0x2cc4 & 0xFF},
	{0x2cc6 & 0xFF, 0x2cc6 & 0xFF},
	{0x2cc8 & 0xFF, 0x2cc8 & 0xFF},
	{0x2cca & 0xFF, 0x2cca & 0xFF},
	{0x2ccc & 0xFF, 0x2ccc & 0xFF},
	{0x2cce & 0xFF, 0x2cce & 0xFF},
	{0x2cd0 & 0xFF, 0x2cd0 & 0xFF},
	{0x2cd2 & 0xFF, 0x2cd2 & 0xFF},
	{0x2cd4 & 0xFF, 0x2cd4 & 0xFF},
	{0x2cd6 & 0xFF, 0x2cd6 & 0xFF},
	{0x2cd8 & 0xFF, 0x2cd8 & 0xFF},
	{0x2cda & 0xFF, 0x2cda & 0xFF},
	{0x2cdc & 0xFF, 0x2cdc & 0xFF},
	{0x2cde & 0xFF, 0x2cde & 0xFF},
	{0x2ce0 & 0xFF, 0x2ce0 & 0xFF},
	{0x2ce2 & 0xFF, 0x2ce2 & 0xFF},
	{0x2ceb & 0xFF, 0x2ceb & 0xFF},
	{0x2ced & 0xFF, 0x2ced & 0xFF},
	{0x2cf2 & 0xFF, 0x2cf2 & 0xFF},
	{0xa640 & 0xFF, 0xa640 & 0xFF},
	{0xa642 & 0xFF, 0xa642 & 0xFF},
	{0xa644 & 0xFF, 0xa644 & 0xFF},
	{0xa646 & 0xFF, 0xa646 & 0xFF},
	{0xa648 & 0xFF, 0xa648 & 0xFF},
	{0xa64a & 0xFF, 0xa64a & 0xFF},
	{0xa64c & 0xFF, 0xa64c & 0xFF},
	{0xa64e & 0xFF, 0xa64e & 0xFF},
	{0xa650 & 0xFF, 0xa650 & 0xFF},
	{0xa652 & 0xFF, 0xa652 & 0xFF},
	{0xa654 & 0xFF, 0xa654 & 0xFF},
	{0xa656 & 0xFF, 0xa656 & 0xFF},
	{0xa658 & 0xFF, 0xa658 & 0xFF},
	{0xa65a & 0xFF, 0xa65a & 0xFF},
	{0xa65c & 0xFF, 0xa65c & 0xFF},
	{0xa65e & 0xFF, 0xa65e & 0xFF},
	{0xa660 & 0xFF, 0xa660 & 0xFF},
	{0xa662 & 0xFF, 0xa662 & 0xFF},
	{0xa664 & 0xFF, 0xa664 & 0xFF},
	{0xa666 & 0xFF, 0xa666 & 0xFF},
	{0xa668 & 0xFF, 0xa668 & 0xFF},
	{0xa66a & 0xFF, 0xa66a & 0xFF},
	{0xa66c & 0xFF, 0xa66c & 0xFF},
	{0xa680 & 0xFF, 0xa680 & 0xFF},
	{0xa682 & 0xFF, 0xa682 & 0xFF},
	{0xa684 & 0xFF, 0xa684 & 0xFF},
	{0xa686 & 0xFF, 0xa686 & 0xFF},
	{0xa688 & 0xFF, 0xa688 & 0xFF},
	{0xa68a & 0xFF, 0xa68a & 0xFF},
	{0xa68c & 0xFF, 0xa68c & 0xFF},
	{0xa68e & 0xFF, 0xa68e & 0xFF},
	{0xa690 & 0xFF, 0xa690 & 0xFF},
	{0xa692 & 0xFF, 0xa692 & 0xFF},
	{0xa694 & 0xFF, 0xa694 & 0xFF},
	{0xa696 & 0xFF, 0xa696 & 0xFF},
	{0xa698 & 0xFF, 0xa698 & 0xFF},
	{0xa69a & 0xFF, 0xa69a & 0xFF},
	{0xa722 & 0xFF, 0xa722 & 0xFF},
	{0xa724 & 0xFF, 0xa724 & 0xFF},
	{0xa726 & 0xFF, 0xa726 & 0xFF},
	{0xa728 & 0xFF, 0xa728 & 0xFF},
	{0xa72a & 0xFF, 0xa72a & 0xFF},
	{0xa72c & 0xFF, 0xa72c & 0xFF},
	{0xa72e & 0xFF, 0xa72e & 0xFF},
	{0xa732 & 0xFF, 0xa732 & 0xFF},
	{0xa734 & 0xFF, 0xa734 & 0xFF},
	{0xa736 & 0xFF, 0xa736 & 0xFF},
	{0xa738 & 0xFF, 0xa738 & 0xFF},
	{0xa73a & 0xFF, 0xa73a & 0xFF},
	{0xa73c & 0xFF, 0xa73c & 0xFF},
	{0xa73e & 0xFF, 0xa73e & 0xFF},
	{0xa740 & 0xFF, 0xa740 & 0xFF},
	{0xa742 & 0xFF, 0xa742 & 0xFF},
	{0xa744 & 0xFF, 0xa744 & 0xFF},
	{0xa746 & 0xFF, 0xa746 & 0xFF},
	{0xa748 & 0xFF, 0xa748 & 0xFF},
	{0xa74a & 0xFF, 0xa74a & 0xFF},
	{0xa74c & 0xFF, 0xa74c & 0xFF},
	{0xa74e & 0xFF, 0xa74e & 0xFF},
	{0xa750 & 0xFF, 0xa750 & 0xFF},
	{0xa752 & 0xFF, 0xa752 & 0xFF},
	{0xa754 & 0xFF, 0xa754 & 0xFF},
	{0xa756 & 0xFF, 0xa756 & 0xFF},
	{0xa758 & 0xFF, 0xa758 & 0xFF},
	{0xa75a & 0xFF, 0xa75a & 0xFF},
	{0xa75c & 0xFF, 0xa75c & 0xFF},
	{0xa75e & 0xFF, 0xa75e & 0xFF},
	{0xa760 & 0xFF, 0xa760 & 0xFF},
	{0xa762 & 0xFF, 0xa762 & 0xFF},
	{0xa764 & 0xFF, 0xa764 & 0xFF},
	{0xa766 & 0xFF, 0xa766 & 0xFF},
	{0xa768 & 0xFF, 0xa768 & 0xFF},
	{0xa76a & 0xFF, 0xa76a & 0xFF},
	{0xa76c & 0xFF, 0xa76c & 0xFF},
	{0xa76e & 0xFF, 0xa76e & 0xFF},
	{0xa779 & 0xFF, 0xa779 & 0xFF},
	{0xa77b & 0xFF, 0xa77b & 0xFF},
	{0xa77d & 0xFF, 0xa77e & 0xFF},
	{0xa780 & 0xFF, 0xa780 & 0xFF},
	{0xa782 & 0xFF, 0xa782 & 0xFF},
	{0xa784 & 0xFF, 0xa784 & 0xFF},
	{0xa786 & 0xFF, 0xa786 & 0xFF},
	{0xa78b & 0xFF, 0xa78b & 0xFF},
	{0xa78d & 0xFF, 0xa78d & 0xFF},
	{0xa790 & 0xFF, 0xa790 & 0xFF},
	{0xa792 & 0xFF, 0xa792 & 0xFF},
	{0xa796 & 0xFF, 0xa796 & 0xFF},
	{0xa798 & 0xFF, 0xa798 & 0xFF},
	{0xa79a & 0xFF, 0xa79a & 0xFF},
	{0xa79c & 0xFF, 0xa79c & 0xFF},
	{0xa79e & 0xFF, 0xa79e & 0xFF},
	{0xa7a0 & 0xFF, 0xa7a0 & 0xFF},
	{0xa7a2 & 0xFF, 0xa7a2 & 0xFF},
	{0xa7a4 & 0xFF, 0xa7a4 & 0xFF},
	{0xa7a6 & 0xFF, 0xa7a6 & 0xFF},
	{0xa7a8 & 0xFF, 0xa7a8 & 0xFF},
	{0xa7aa & 0xFF, 0xa7ae & 0xFF},
	{0xa7b0 & 0xFF, 0xa7b4 & 0xFF},
	{0xa7b6 & 0xFF, 0xa7b6 & 0xFF},
	{0xa7b8 & 0xFF, 0xa7b8 & 0xFF},
	{0xa7ba & 0xFF, 0xa7ba & 0xFF},
	{0xa7bc & 0xFF, 0xa7bc & 0xFF},
	{0xa7be & 0xFF, 0xa7be & 0xFF},
	{0xa7c0 & 0xFF, 0xa7c0 & 0xFF},
	{0xa7c2 & 0xFF, 0xa7c2 & 0xFF},
	{0xa7c4 & 0xFF, 0xa7c7 & 0xFF},
	{0xa7c9 & 0xFF, 0xa7c9 & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d0 & 0xFF},
	{0xa7d6 & 0xFF, 0xa7d6 & 0xFF},
	{0xa7d8 & 0xFF, 0xa7d8 & 0xFF},
	{0xa7f5 & 0xFF, 0xa7f5 & 0xFF},
	{0xab70 & 0xFF, 0xabbf & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0x10400 & 0xFF, 0x10427 & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x118a0 & 0xFF, 0x118bf & 0xFF},
	{0x16e40 & 0xFF, 0x16e5f & 0xFF},
	{0x1e900 & 0xFF, 0x1e921 & 0xFF}};

static const size_t Changes_When_Casefolded_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	16,
	19,
	28,
	30,
	31,
	33,
	36,
	44,
	166,
	167,
	171,
	251,
	255,
	260,
	261,
	268,
	280,
	366,
	489
};

static const char32_t Changes_When_Casefolded_starting_pagetab[]={
	0,
	4,
	112,
	146,
	177,
	253,
	279,
	282,
	283,
	286,
	411,
	430,
	435,
	436,
	498,
	535,
	609,
	610,
	612,
	613,
	615,
	619,
	620,
	621,
	622
};

static const uint8_t Changes_When_Casemapped_rangetab[][2]={
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0100 & 0xFF, 0x0137 & 0xFF},
	{0x0139 & 0xFF, 0x018c & 0xFF},
	{0x018e & 0xFF, 0x019a & 0xFF},
	{0x019c & 0xFF, 0x01a9 & 0xFF},
	{0x01ac & 0xFF, 0x01b9 & 0xFF},
	{0x01bc & 0xFF, 0x01bd & 0xFF},
	{0x01bf & 0xFF, 0x01bf & 0xFF},
	{0x01c4 & 0xFF, 0x01ff & 0xFF},
	{0x0200 & 0xFF, 0x0220 & 0xFF},
	{0x0222 & 0xFF, 0x0233 & 0xFF},
	{0x023a & 0xFF, 0x0254 & 0xFF},
	{0x0256 & 0xFF, 0x0257 & 0xFF},
	{0x0259 & 0xFF, 0x0259 & 0xFF},
	{0x025b & 0xFF, 0x025c & 0xFF},
	{0x0260 & 0xFF, 0x0261 & 0xFF},
	{0x0263 & 0xFF, 0x0263 & 0xFF},
	{0x0265 & 0xFF, 0x0266 & 0xFF},
	{0x0268 & 0xFF, 0x026c & 0xFF},
	{0x026f & 0xFF, 0x026f & 0xFF},
	{0x0271 & 0xFF, 0x0272 & 0xFF},
	{0x0275 & 0xFF, 0x0275 & 0xFF},
	{0x027d & 0xFF, 0x027d & 0xFF},
	{0x0280 & 0xFF, 0x0280 & 0xFF},
	{0x0282 & 0xFF, 0x0283 & 0xFF},
	{0x0287 & 0xFF, 0x028c & 0xFF},
	{0x0292 & 0xFF, 0x0292 & 0xFF},
	{0x029d & 0xFF, 0x029e & 0xFF},
	{0x0345 & 0xFF, 0x0345 & 0xFF},
	{0x0370 & 0xFF, 0x0373 & 0xFF},
	{0x0376 & 0xFF, 0x0377 & 0xFF},
	{0x037b & 0xFF, 0x037d & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x0386 & 0xFF},
	{0x0388 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03d1 & 0xFF},
	{0x03d5 & 0xFF, 0x03f5 & 0xFF},
	{0x03f7 & 0xFF, 0x03fb & 0xFF},
	{0x03fd & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x0481 & 0xFF},
	{0x048a & 0xFF, 0x04ff & 0xFF},
	{0x0500 & 0xFF, 0x052f & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x0561 & 0xFF, 0x0587 & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x10d0 & 0xFF, 0x10fa & 0xFF},
	{0x10fd & 0xFF, 0x10ff & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1d79 & 0xFF, 0x1d79 & 0xFF},
	{0x1d7d & 0xFF, 0x1d7d & 0xFF},
	{0x1d8e & 0xFF, 0x1d8e & 0xFF},
	{0x1e00 & 0xFF, 0x1e9b & 0xFF},
	{0x1e9e & 0xFF, 0x1e9e & 0xFF},
	{0x1ea0 & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f15 & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f20 & 0xFF, 0x1f45 & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fbc & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fcc & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe0 & 0xFF, 0x1fec & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ffc & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x212a & 0xFF, 0x212b & 0xFF},
	{0x2132 & 0xFF, 0x2132 & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2160 & 0xFF, 0x217f & 0xFF},
	{0x2183 & 0xFF, 0x2184 & 0xFF},
	{0x24b6 & 0xFF, 0x24e9 & 0xFF},
	{0x2c00 & 0xFF, 0x2c70 & 0xFF},
	{0x2c72 & 0xFF, 0x2c73 & 0xFF},
	{0x2c75 & 0xFF, 0x2c76 & 0xFF},
	{0x2c7e & 0xFF, 0x2ce3 & 0xFF},
	{0x2ceb & 0xFF, 0x2cee & 0xFF},
	{0x2cf2 & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0xa640 & 0xFF, 0xa66d & 0xFF},
	{0xa680 & 0xFF, 0xa69b & 0xFF},
	{0xa722 & 0xFF, 0xa72f & 0xFF},
	{0xa732 & 0xFF, 0xa76f & 0xFF},
	{0xa779 & 0xFF, 0xa787 & 0xFF},
	{0xa78b & 0xFF, 0xa78d & 0xFF},
	{0xa790 & 0xFF, 0xa794 & 0xFF},
	{0xa796 & 0xFF, 0xa7ae & 0xFF},
	{0xa7b0 & 0xFF, 0xa7ca & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d6 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f5 & 0xFF, 0xa7f6 & 0xFF},
	{0xab53 & 0xFF, 0xab53 & 0xFF},
	{0xab70 & 0xFF, 0xabbf & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0x10400 & 0xFF, 0x1044f & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x118a0 & 0xFF, 0x118df & 0xFF},
	{0x16e40 & 0xFF, 0x16e7f & 0xFF},
	{0x1e900 & 0xFF, 0x1e943 & 0xFF}};

static const size_t Changes_When_Casemapped_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	16,
	19,
	28,
	29,
	30,
	31,
	33,
	36,
	44,
	45,
	166,
	167,
	171,
	251,
	255,
	260,
	261,
	268,
	280,
	366,
	489
};

static const char32_t Changes_When_Casemapped_starting_pagetab[]={
	0,
	6,
	14,
	33,
	46,
	48,
	51,
	56,
	58,
	61,
	64,
	67,
	86,
	92,
	93,
	99,
	102,
	104,
	114,
	116,
	118,
	120,
	123,
	131,
	133,
	134,
	135
};

static const uint8_t Changes_When_Lowercased_rangetab[][2]={
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00de & 0xFF},
	{0x0100 & 0xFF, 0x0100 & 0xFF},
	{0x0102 & 0xFF, 0x0102 & 0xFF},
	{0x0104 & 0xFF, 0x0104 & 0xFF},
	{0x0106 & 0xFF, 0x0106 & 0xFF},
	{0x0108 & 0xFF, 0x0108 & 0xFF},
	{0x010a & 0xFF, 0x010a & 0xFF},
	{0x010c & 0xFF, 0x010c & 0xFF},
	{0x010e & 0xFF, 0x010e & 0xFF},
	{0x0110 & 0xFF, 0x0110 & 0xFF},
	{0x0112 & 0xFF, 0x0112 & 0xFF},
	{0x0114 & 0xFF, 0x0114 & 0xFF},
	{0x0116 & 0xFF, 0x0116 & 0xFF},
	{0x0118 & 0xFF, 0x0118 & 0xFF},
	{0x011a & 0xFF, 0x011a & 0xFF},
	{0x011c & 0xFF, 0x011c & 0xFF},
	{0x011e & 0xFF, 0x011e & 0xFF},
	{0x0120 & 0xFF, 0x0120 & 0xFF},
	{0x0122 & 0xFF, 0x0122 & 0xFF},
	{0x0124 & 0xFF, 0x0124 & 0xFF},
	{0x0126 & 0xFF, 0x0126 & 0xFF},
	{0x0128 & 0xFF, 0x0128 & 0xFF},
	{0x012a & 0xFF, 0x012a & 0xFF},
	{0x012c & 0xFF, 0x012c & 0xFF},
	{0x012e & 0xFF, 0x012e & 0xFF},
	{0x0130 & 0xFF, 0x0130 & 0xFF},
	{0x0132 & 0xFF, 0x0132 & 0xFF},
	{0x0134 & 0xFF, 0x0134 & 0xFF},
	{0x0136 & 0xFF, 0x0136 & 0xFF},
	{0x0139 & 0xFF, 0x0139 & 0xFF},
	{0x013b & 0xFF, 0x013b & 0xFF},
	{0x013d & 0xFF, 0x013d & 0xFF},
	{0x013f & 0xFF, 0x013f & 0xFF},
	{0x0141 & 0xFF, 0x0141 & 0xFF},
	{0x0143 & 0xFF, 0x0143 & 0xFF},
	{0x0145 & 0xFF, 0x0145 & 0xFF},
	{0x0147 & 0xFF, 0x0147 & 0xFF},
	{0x014a & 0xFF, 0x014a & 0xFF},
	{0x014c & 0xFF, 0x014c & 0xFF},
	{0x014e & 0xFF, 0x014e & 0xFF},
	{0x0150 & 0xFF, 0x0150 & 0xFF},
	{0x0152 & 0xFF, 0x0152 & 0xFF},
	{0x0154 & 0xFF, 0x0154 & 0xFF},
	{0x0156 & 0xFF, 0x0156 & 0xFF},
	{0x0158 & 0xFF, 0x0158 & 0xFF},
	{0x015a & 0xFF, 0x015a & 0xFF},
	{0x015c & 0xFF, 0x015c & 0xFF},
	{0x015e & 0xFF, 0x015e & 0xFF},
	{0x0160 & 0xFF, 0x0160 & 0xFF},
	{0x0162 & 0xFF, 0x0162 & 0xFF},
	{0x0164 & 0xFF, 0x0164 & 0xFF},
	{0x0166 & 0xFF, 0x0166 & 0xFF},
	{0x0168 & 0xFF, 0x0168 & 0xFF},
	{0x016a & 0xFF, 0x016a & 0xFF},
	{0x016c & 0xFF, 0x016c & 0xFF},
	{0x016e & 0xFF, 0x016e & 0xFF},
	{0x0170 & 0xFF, 0x0170 & 0xFF},
	{0x0172 & 0xFF, 0x0172 & 0xFF},
	{0x0174 & 0xFF, 0x0174 & 0xFF},
	{0x0176 & 0xFF, 0x0176 & 0xFF},
	{0x0178 & 0xFF, 0x0179 & 0xFF},
	{0x017b & 0xFF, 0x017b & 0xFF},
	{0x017d & 0xFF, 0x017d & 0xFF},
	{0x0181 & 0xFF, 0x0182 & 0xFF},
	{0x0184 & 0xFF, 0x0184 & 0xFF},
	{0x0186 & 0xFF, 0x0187 & 0xFF},
	{0x0189 & 0xFF, 0x018b & 0xFF},
	{0x018e & 0xFF, 0x0191 & 0xFF},
	{0x0193 & 0xFF, 0x0194 & 0xFF},
	{0x0196 & 0xFF, 0x0198 & 0xFF},
	{0x019c & 0xFF, 0x019d & 0xFF},
	{0x019f & 0xFF, 0x01a0 & 0xFF},
	{0x01a2 & 0xFF, 0x01a2 & 0xFF},
	{0x01a4 & 0xFF, 0x01a4 & 0xFF},
	{0x01a6 & 0xFF, 0x01a7 & 0xFF},
	{0x01a9 & 0xFF, 0x01a9 & 0xFF},
	{0x01ac & 0xFF, 0x01ac & 0xFF},
	{0x01ae & 0xFF, 0x01af & 0xFF},
	{0x01b1 & 0xFF, 0x01b3 & 0xFF},
	{0x01b5 & 0xFF, 0x01b5 & 0xFF},
	{0x01b7 & 0xFF, 0x01b8 & 0xFF},
	{0x01bc & 0xFF, 0x01bc & 0xFF},
	{0x01c4 & 0xFF, 0x01c5 & 0xFF},
	{0x01c7 & 0xFF, 0x01c8 & 0xFF},
	{0x01ca & 0xFF, 0x01cb & 0xFF},
	{0x01cd & 0xFF, 0x01cd & 0xFF},
	{0x01cf & 0xFF, 0x01cf & 0xFF},
	{0x01d1 & 0xFF, 0x01d1 & 0xFF},
	{0x01d3 & 0xFF, 0x01d3 & 0xFF},
	{0x01d5 & 0xFF, 0x01d5 & 0xFF},
	{0x01d7 & 0xFF, 0x01d7 & 0xFF},
	{0x01d9 & 0xFF, 0x01d9 & 0xFF},
	{0x01db & 0xFF, 0x01db & 0xFF},
	{0x01de & 0xFF, 0x01de & 0xFF},
	{0x01e0 & 0xFF, 0x01e0 & 0xFF},
	{0x01e2 & 0xFF, 0x01e2 & 0xFF},
	{0x01e4 & 0xFF, 0x01e4 & 0xFF},
	{0x01e6 & 0xFF, 0x01e6 & 0xFF},
	{0x01e8 & 0xFF, 0x01e8 & 0xFF},
	{0x01ea & 0xFF, 0x01ea & 0xFF},
	{0x01ec & 0xFF, 0x01ec & 0xFF},
	{0x01ee & 0xFF, 0x01ee & 0xFF},
	{0x01f1 & 0xFF, 0x01f2 & 0xFF},
	{0x01f4 & 0xFF, 0x01f4 & 0xFF},
	{0x01f6 & 0xFF, 0x01f8 & 0xFF},
	{0x01fa & 0xFF, 0x01fa & 0xFF},
	{0x01fc & 0xFF, 0x01fc & 0xFF},
	{0x01fe & 0xFF, 0x01fe & 0xFF},
	{0x0200 & 0xFF, 0x0200 & 0xFF},
	{0x0202 & 0xFF, 0x0202 & 0xFF},
	{0x0204 & 0xFF, 0x0204 & 0xFF},
	{0x0206 & 0xFF, 0x0206 & 0xFF},
	{0x0208 & 0xFF, 0x0208 & 0xFF},
	{0x020a & 0xFF, 0x020a & 0xFF},
	{0x020c & 0xFF, 0x020c & 0xFF},
	{0x020e & 0xFF, 0x020e & 0xFF},
	{0x0210 & 0xFF, 0x0210 & 0xFF},
	{0x0212 & 0xFF, 0x0212 & 0xFF},
	{0x0214 & 0xFF, 0x0214 & 0xFF},
	{0x0216 & 0xFF, 0x0216 & 0xFF},
	{0x0218 & 0xFF, 0x0218 & 0xFF},
	{0x021a & 0xFF, 0x021a & 0xFF},
	{0x021c & 0xFF, 0x021c & 0xFF},
	{0x021e & 0xFF, 0x021e & 0xFF},
	{0x0220 & 0xFF, 0x0220 & 0xFF},
	{0x0222 & 0xFF, 0x0222 & 0xFF},
	{0x0224 & 0xFF, 0x0224 & 0xFF},
	{0x0226 & 0xFF, 0x0226 & 0xFF},
	{0x0228 & 0xFF, 0x0228 & 0xFF},
	{0x022a & 0xFF, 0x022a & 0xFF},
	{0x022c & 0xFF, 0x022c & 0xFF},
	{0x022e & 0xFF, 0x022e & 0xFF},
	{0x0230 & 0xFF, 0x0230 & 0xFF},
	{0x0232 & 0xFF, 0x0232 & 0xFF},
	{0x023a & 0xFF, 0x023b & 0xFF},
	{0x023d & 0xFF, 0x023e & 0xFF},
	{0x0241 & 0xFF, 0x0241 & 0xFF},
	{0x0243 & 0xFF, 0x0246 & 0xFF},
	{0x0248 & 0xFF, 0x0248 & 0xFF},
	{0x024a & 0xFF, 0x024a & 0xFF},
	{0x024c & 0xFF, 0x024c & 0xFF},
	{0x024e & 0xFF, 0x024e & 0xFF},
	{0x0370 & 0xFF, 0x0370 & 0xFF},
	{0x0372 & 0xFF, 0x0372 & 0xFF},
	{0x0376 & 0xFF, 0x0376 & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x0386 & 0xFF},
	{0x0388 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x038f & 0xFF},
	{0x0391 & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03ab & 0xFF},
	{0x03cf & 0xFF, 0x03cf & 0xFF},
	{0x03d8 & 0xFF, 0x03d8 & 0xFF},
	{0x03da & 0xFF, 0x03da & 0xFF},
	{0x03dc & 0xFF, 0x03dc & 0xFF},
	{0x03de & 0xFF, 0x03de & 0xFF},
	{0x03e0 & 0xFF, 0x03e0 & 0xFF},
	{0x03e2 & 0xFF, 0x03e2 & 0xFF},
	{0x03e4 & 0xFF, 0x03e4 & 0xFF},
	{0x03e6 & 0xFF, 0x03e6 & 0xFF},
	{0x03e8 & 0xFF, 0x03e8 & 0xFF},
	{0x03ea & 0xFF, 0x03ea & 0xFF},
	{0x03ec & 0xFF, 0x03ec & 0xFF},
	{0x03ee & 0xFF, 0x03ee & 0xFF},
	{0x03f4 & 0xFF, 0x03f4 & 0xFF},
	{0x03f7 & 0xFF, 0x03f7 & 0xFF},
	{0x03f9 & 0xFF, 0x03fa & 0xFF},
	{0x03fd & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x042f & 0xFF},
	{0x0460 & 0xFF, 0x0460 & 0xFF},
	{0x0462 & 0xFF, 0x0462 & 0xFF},
	{0x0464 & 0xFF, 0x0464 & 0xFF},
	{0x0466 & 0xFF, 0x0466 & 0xFF},
	{0x0468 & 0xFF, 0x0468 & 0xFF},
	{0x046a & 0xFF, 0x046a & 0xFF},
	{0x046c & 0xFF, 0x046c & 0xFF},
	{0x046e & 0xFF, 0x046e & 0xFF},
	{0x0470 & 0xFF, 0x0470 & 0xFF},
	{0x0472 & 0xFF, 0x0472 & 0xFF},
	{0x0474 & 0xFF, 0x0474 & 0xFF},
	{0x0476 & 0xFF, 0x0476 & 0xFF},
	{0x0478 & 0xFF, 0x0478 & 0xFF},
	{0x047a & 0xFF, 0x047a & 0xFF},
	{0x047c & 0xFF, 0x047c & 0xFF},
	{0x047e & 0xFF, 0x047e & 0xFF},
	{0x0480 & 0xFF, 0x0480 & 0xFF},
	{0x048a & 0xFF, 0x048a & 0xFF},
	{0x048c & 0xFF, 0x048c & 0xFF},
	{0x048e & 0xFF, 0x048e & 0xFF},
	{0x0490 & 0xFF, 0x0490 & 0xFF},
	{0x0492 & 0xFF, 0x0492 & 0xFF},
	{0x0494 & 0xFF, 0x0494 & 0xFF},
	{0x0496 & 0xFF, 0x0496 & 0xFF},
	{0x0498 & 0xFF, 0x0498 & 0xFF},
	{0x049a & 0xFF, 0x049a & 0xFF},
	{0x049c & 0xFF, 0x049c & 0xFF},
	{0x049e & 0xFF, 0x049e & 0xFF},
	{0x04a0 & 0xFF, 0x04a0 & 0xFF},
	{0x04a2 & 0xFF, 0x04a2 & 0xFF},
	{0x04a4 & 0xFF, 0x04a4 & 0xFF},
	{0x04a6 & 0xFF, 0x04a6 & 0xFF},
	{0x04a8 & 0xFF, 0x04a8 & 0xFF},
	{0x04aa & 0xFF, 0x04aa & 0xFF},
	{0x04ac & 0xFF, 0x04ac & 0xFF},
	{0x04ae & 0xFF, 0x04ae & 0xFF},
	{0x04b0 & 0xFF, 0x04b0 & 0xFF},
	{0x04b2 & 0xFF, 0x04b2 & 0xFF},
	{0x04b4 & 0xFF, 0x04b4 & 0xFF},
	{0x04b6 & 0xFF, 0x04b6 & 0xFF},
	{0x04b8 & 0xFF, 0x04b8 & 0xFF},
	{0x04ba & 0xFF, 0x04ba & 0xFF},
	{0x04bc & 0xFF, 0x04bc & 0xFF},
	{0x04be & 0xFF, 0x04be & 0xFF},
	{0x04c0 & 0xFF, 0x04c1 & 0xFF},
	{0x04c3 & 0xFF, 0x04c3 & 0xFF},
	{0x04c5 & 0xFF, 0x04c5 & 0xFF},
	{0x04c7 & 0xFF, 0x04c7 & 0xFF},
	{0x04c9 & 0xFF, 0x04c9 & 0xFF},
	{0x04cb & 0xFF, 0x04cb & 0xFF},
	{0x04cd & 0xFF, 0x04cd & 0xFF},
	{0x04d0 & 0xFF, 0x04d0 & 0xFF},
	{0x04d2 & 0xFF, 0x04d2 & 0xFF},
	{0x04d4 & 0xFF, 0x04d4 & 0xFF},
	{0x04d6 & 0xFF, 0x04d6 & 0xFF},
	{0x04d8 & 0xFF, 0x04d8 & 0xFF},
	{0x04da & 0xFF, 0x04da & 0xFF},
	{0x04dc & 0xFF, 0x04dc & 0xFF},
	{0x04de & 0xFF, 0x04de & 0xFF},
	{0x04e0 & 0xFF, 0x04e0 & 0xFF},
	{0x04e2 & 0xFF, 0x04e2 & 0xFF},
	{0x04e4 & 0xFF, 0x04e4 & 0xFF},
	{0x04e6 & 0xFF, 0x04e6 & 0xFF},
	{0x04e8 & 0xFF, 0x04e8 & 0xFF},
	{0x04ea & 0xFF, 0x04ea & 0xFF},
	{0x04ec & 0xFF, 0x04ec & 0xFF},
	{0x04ee & 0xFF, 0x04ee & 0xFF},
	{0x04f0 & 0xFF, 0x04f0 & 0xFF},
	{0x04f2 & 0xFF, 0x04f2 & 0xFF},
	{0x04f4 & 0xFF, 0x04f4 & 0xFF},
	{0x04f6 & 0xFF, 0x04f6 & 0xFF},
	{0x04f8 & 0xFF, 0x04f8 & 0xFF},
	{0x04fa & 0xFF, 0x04fa & 0xFF},
	{0x04fc & 0xFF, 0x04fc & 0xFF},
	{0x04fe & 0xFF, 0x04fe & 0xFF},
	{0x0500 & 0xFF, 0x0500 & 0xFF},
	{0x0502 & 0xFF, 0x0502 & 0xFF},
	{0x0504 & 0xFF, 0x0504 & 0xFF},
	{0x0506 & 0xFF, 0x0506 & 0xFF},
	{0x0508 & 0xFF, 0x0508 & 0xFF},
	{0x050a & 0xFF, 0x050a & 0xFF},
	{0x050c & 0xFF, 0x050c & 0xFF},
	{0x050e & 0xFF, 0x050e & 0xFF},
	{0x0510 & 0xFF, 0x0510 & 0xFF},
	{0x0512 & 0xFF, 0x0512 & 0xFF},
	{0x0514 & 0xFF, 0x0514 & 0xFF},
	{0x0516 & 0xFF, 0x0516 & 0xFF},
	{0x0518 & 0xFF, 0x0518 & 0xFF},
	{0x051a & 0xFF, 0x051a & 0xFF},
	{0x051c & 0xFF, 0x051c & 0xFF},
	{0x051e & 0xFF, 0x051e & 0xFF},
	{0x0520 & 0xFF, 0x0520 & 0xFF},
	{0x0522 & 0xFF, 0x0522 & 0xFF},
	{0x0524 & 0xFF, 0x0524 & 0xFF},
	{0x0526 & 0xFF, 0x0526 & 0xFF},
	{0x0528 & 0xFF, 0x0528 & 0xFF},
	{0x052a & 0xFF, 0x052a & 0xFF},
	{0x052c & 0xFF, 0x052c & 0xFF},
	{0x052e & 0xFF, 0x052e & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1e00 & 0xFF, 0x1e00 & 0xFF},
	{0x1e02 & 0xFF, 0x1e02 & 0xFF},
	{0x1e04 & 0xFF, 0x1e04 & 0xFF},
	{0x1e06 & 0xFF, 0x1e06 & 0xFF},
	{0x1e08 & 0xFF, 0x1e08 & 0xFF},
	{0x1e0a & 0xFF, 0x1e0a & 0xFF},
	{0x1e0c & 0xFF, 0x1e0c & 0xFF},
	{0x1e0e & 0xFF, 0x1e0e & 0xFF},
	{0x1e10 & 0xFF, 0x1e10 & 0xFF},
	{0x1e12 & 0xFF, 0x1e12 & 0xFF},
	{0x1e14 & 0xFF, 0x1e14 & 0xFF},
	{0x1e16 & 0xFF, 0x1e16 & 0xFF},
	{0x1e18 & 0xFF, 0x1e18 & 0xFF},
	{0x1e1a & 0xFF, 0x1e1a & 0xFF},
	{0x1e1c & 0xFF, 0x1e1c & 0xFF},
	{0x1e1e & 0xFF, 0x1e1e & 0xFF},
	{0x1e20 & 0xFF, 0x1e20 & 0xFF},
	{0x1e22 & 0xFF, 0x1e22 & 0xFF},
	{0x1e24 & 0xFF, 0x1e24 & 0xFF},
	{0x1e26 & 0xFF, 0x1e26 & 0xFF},
	{0x1e28 & 0xFF, 0x1e28 & 0xFF},
	{0x1e2a & 0xFF, 0x1e2a & 0xFF},
	{0x1e2c & 0xFF, 0x1e2c & 0xFF},
	{0x1e2e & 0xFF, 0x1e2e & 0xFF},
	{0x1e30 & 0xFF, 0x1e30 & 0xFF},
	{0x1e32 & 0xFF, 0x1e32 & 0xFF},
	{0x1e34 & 0xFF, 0x1e34 & 0xFF},
	{0x1e36 & 0xFF, 0x1e36 & 0xFF},
	{0x1e38 & 0xFF, 0x1e38 & 0xFF},
	{0x1e3a & 0xFF, 0x1e3a & 0xFF},
	{0x1e3c & 0xFF, 0x1e3c & 0xFF},
	{0x1e3e & 0xFF, 0x1e3e & 0xFF},
	{0x1e40 & 0xFF, 0x1e40 & 0xFF},
	{0x1e42 & 0xFF, 0x1e42 & 0xFF},
	{0x1e44 & 0xFF, 0x1e44 & 0xFF},
	{0x1e46 & 0xFF, 0x1e46 & 0xFF},
	{0x1e48 & 0xFF, 0x1e48 & 0xFF},
	{0x1e4a & 0xFF, 0x1e4a & 0xFF},
	{0x1e4c & 0xFF, 0x1e4c & 0xFF},
	{0x1e4e & 0xFF, 0x1e4e & 0xFF},
	{0x1e50 & 0xFF, 0x1e50 & 0xFF},
	{0x1e52 & 0xFF, 0x1e52 & 0xFF},
	{0x1e54 & 0xFF, 0x1e54 & 0xFF},
	{0x1e56 & 0xFF, 0x1e56 & 0xFF},
	{0x1e58 & 0xFF, 0x1e58 & 0xFF},
	{0x1e5a & 0xFF, 0x1e5a & 0xFF},
	{0x1e5c & 0xFF, 0x1e5c & 0xFF},
	{0x1e5e & 0xFF, 0x1e5e & 0xFF},
	{0x1e60 & 0xFF, 0x1e60 & 0xFF},
	{0x1e62 & 0xFF, 0x1e62 & 0xFF},
	{0x1e64 & 0xFF, 0x1e64 & 0xFF},
	{0x1e66 & 0xFF, 0x1e66 & 0xFF},
	{0x1e68 & 0xFF, 0x1e68 & 0xFF},
	{0x1e6a & 0xFF, 0x1e6a & 0xFF},
	{0x1e6c & 0xFF, 0x1e6c & 0xFF},
	{0x1e6e & 0xFF, 0x1e6e & 0xFF},
	{0x1e70 & 0xFF, 0x1e70 & 0xFF},
	{0x1e72 & 0xFF, 0x1e72 & 0xFF},
	{0x1e74 & 0xFF, 0x1e74 & 0xFF},
	{0x1e76 & 0xFF, 0x1e76 & 0xFF},
	{0x1e78 & 0xFF, 0x1e78 & 0xFF},
	{0x1e7a & 0xFF, 0x1e7a & 0xFF},
	{0x1e7c & 0xFF, 0x1e7c & 0xFF},
	{0x1e7e & 0xFF, 0x1e7e & 0xFF},
	{0x1e80 & 0xFF, 0x1e80 & 0xFF},
	{0x1e82 & 0xFF, 0x1e82 & 0xFF},
	{0x1e84 & 0xFF, 0x1e84 & 0xFF},
	{0x1e86 & 0xFF, 0x1e86 & 0xFF},
	{0x1e88 & 0xFF, 0x1e88 & 0xFF},
	{0x1e8a & 0xFF, 0x1e8a & 0xFF},
	{0x1e8c & 0xFF, 0x1e8c & 0xFF},
	{0x1e8e & 0xFF, 0x1e8e & 0xFF},
	{0x1e90 & 0xFF, 0x1e90 & 0xFF},
	{0x1e92 & 0xFF, 0x1e92 & 0xFF},
	{0x1e94 & 0xFF, 0x1e94 & 0xFF},
	{0x1e9e & 0xFF, 0x1e9e & 0xFF},
	{0x1ea0 & 0xFF, 0x1ea0 & 0xFF},
	{0x1ea2 & 0xFF, 0x1ea2 & 0xFF},
	{0x1ea4 & 0xFF, 0x1ea4 & 0xFF},
	{0x1ea6 & 0xFF, 0x1ea6 & 0xFF},
	{0x1ea8 & 0xFF, 0x1ea8 & 0xFF},
	{0x1eaa & 0xFF, 0x1eaa & 0xFF},
	{0x1eac & 0xFF, 0x1eac & 0xFF},
	{0x1eae & 0xFF, 0x1eae & 0xFF},
	{0x1eb0 & 0xFF, 0x1eb0 & 0xFF},
	{0x1eb2 & 0xFF, 0x1eb2 & 0xFF},
	{0x1eb4 & 0xFF, 0x1eb4 & 0xFF},
	{0x1eb6 & 0xFF, 0x1eb6 & 0xFF},
	{0x1eb8 & 0xFF, 0x1eb8 & 0xFF},
	{0x1eba & 0xFF, 0x1eba & 0xFF},
	{0x1ebc & 0xFF, 0x1ebc & 0xFF},
	{0x1ebe & 0xFF, 0x1ebe & 0xFF},
	{0x1ec0 & 0xFF, 0x1ec0 & 0xFF},
	{0x1ec2 & 0xFF, 0x1ec2 & 0xFF},
	{0x1ec4 & 0xFF, 0x1ec4 & 0xFF},
	{0x1ec6 & 0xFF, 0x1ec6 & 0xFF},
	{0x1ec8 & 0xFF, 0x1ec8 & 0xFF},
	{0x1eca & 0xFF, 0x1eca & 0xFF},
	{0x1ecc & 0xFF, 0x1ecc & 0xFF},
	{0x1ece & 0xFF, 0x1ece & 0xFF},
	{0x1ed0 & 0xFF, 0x1ed0 & 0xFF},
	{0x1ed2 & 0xFF, 0x1ed2 & 0xFF},
	{0x1ed4 & 0xFF, 0x1ed4 & 0xFF},
	{0x1ed6 & 0xFF, 0x1ed6 & 0xFF},
	{0x1ed8 & 0xFF, 0x1ed8 & 0xFF},
	{0x1eda & 0xFF, 0x1eda & 0xFF},
	{0x1edc & 0xFF, 0x1edc & 0xFF},
	{0x1ede & 0xFF, 0x1ede & 0xFF},
	{0x1ee0 & 0xFF, 0x1ee0 & 0xFF},
	{0x1ee2 & 0xFF, 0x1ee2 & 0xFF},
	{0x1ee4 & 0xFF, 0x1ee4 & 0xFF},
	{0x1ee6 & 0xFF, 0x1ee6 & 0xFF},
	{0x1ee8 & 0xFF, 0x1ee8 & 0xFF},
	{0x1eea & 0xFF, 0x1eea & 0xFF},
	{0x1eec & 0xFF, 0x1eec & 0xFF},
	{0x1eee & 0xFF, 0x1eee & 0xFF},
	{0x1ef0 & 0xFF, 0x1ef0 & 0xFF},
	{0x1ef2 & 0xFF, 0x1ef2 & 0xFF},
	{0x1ef4 & 0xFF, 0x1ef4 & 0xFF},
	{0x1ef6 & 0xFF, 0x1ef6 & 0xFF},
	{0x1ef8 & 0xFF, 0x1ef8 & 0xFF},
	{0x1efa & 0xFF, 0x1efa & 0xFF},
	{0x1efc & 0xFF, 0x1efc & 0xFF},
	{0x1efe & 0xFF, 0x1efe & 0xFF},
	{0x1f08 & 0xFF, 0x1f0f & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f28 & 0xFF, 0x1f2f & 0xFF},
	{0x1f38 & 0xFF, 0x1f3f & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f5f & 0xFF},
	{0x1f68 & 0xFF, 0x1f6f & 0xFF},
	{0x1f88 & 0xFF, 0x1f8f & 0xFF},
	{0x1f98 & 0xFF, 0x1f9f & 0xFF},
	{0x1fa8 & 0xFF, 0x1faf & 0xFF},
	{0x1fb8 & 0xFF, 0x1fbc & 0xFF},
	{0x1fc8 & 0xFF, 0x1fcc & 0xFF},
	{0x1fd8 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe8 & 0xFF, 0x1fec & 0xFF},
	{0x1ff8 & 0xFF, 0x1ffc & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x212a & 0xFF, 0x212b & 0xFF},
	{0x2132 & 0xFF, 0x2132 & 0xFF},
	{0x2160 & 0xFF, 0x216f & 0xFF},
	{0x2183 & 0xFF, 0x2183 & 0xFF},
	{0x24b6 & 0xFF, 0x24cf & 0xFF},
	{0x2c00 & 0xFF, 0x2c2f & 0xFF},
	{0x2c60 & 0xFF, 0x2c60 & 0xFF},
	{0x2c62 & 0xFF, 0x2c64 & 0xFF},
	{0x2c67 & 0xFF, 0x2c67 & 0xFF},
	{0x2c69 & 0xFF, 0x2c69 & 0xFF},
	{0x2c6b & 0xFF, 0x2c6b & 0xFF},
	{0x2c6d & 0xFF, 0x2c70 & 0xFF},
	{0x2c72 & 0xFF, 0x2c72 & 0xFF},
	{0x2c75 & 0xFF, 0x2c75 & 0xFF},
	{0x2c7e & 0xFF, 0x2c80 & 0xFF},
	{0x2c82 & 0xFF, 0x2c82 & 0xFF},
	{0x2c84 & 0xFF, 0x2c84 & 0xFF},
	{0x2c86 & 0xFF, 0x2c86 & 0xFF},
	{0x2c88 & 0xFF, 0x2c88 & 0xFF},
	{0x2c8a & 0xFF, 0x2c8a & 0xFF},
	{0x2c8c & 0xFF, 0x2c8c & 0xFF},
	{0x2c8e & 0xFF, 0x2c8e & 0xFF},
	{0x2c90 & 0xFF, 0x2c90 & 0xFF},
	{0x2c92 & 0xFF, 0x2c92 & 0xFF},
	{0x2c94 & 0xFF, 0x2c94 & 0xFF},
	{0x2c96 & 0xFF, 0x2c96 & 0xFF},
	{0x2c98 & 0xFF, 0x2c98 & 0xFF},
	{0x2c9a & 0xFF, 0x2c9a & 0xFF},
	{0x2c9c & 0xFF, 0x2c9c & 0xFF},
	{0x2c9e & 0xFF, 0x2c9e & 0xFF},
	{0x2ca0 & 0xFF, 0x2ca0 & 0xFF},
	{0x2ca2 & 0xFF, 0x2ca2 & 0xFF},
	{0x2ca4 & 0xFF, 0x2ca4 & 0xFF},
	{0x2ca6 & 0xFF, 0x2ca6 & 0xFF},
	{0x2ca8 & 0xFF, 0x2ca8 & 0xFF},
	{0x2caa & 0xFF, 0x2caa & 0xFF},
	{0x2cac & 0xFF, 0x2cac & 0xFF},
	{0x2cae & 0xFF, 0x2cae & 0xFF},
	{0x2cb0 & 0xFF, 0x2cb0 & 0xFF},
	{0x2cb2 & 0xFF, 0x2cb2 & 0xFF},
	{0x2cb4 & 0xFF, 0x2cb4 & 0xFF},
	{0x2cb6 & 0xFF, 0x2cb6 & 0xFF},
	{0x2cb8 & 0xFF, 0x2cb8 & 0xFF},
	{0x2cba & 0xFF, 0x2cba & 0xFF},
	{0x2cbc & 0xFF, 0x2cbc & 0xFF},
	{0x2cbe & 0xFF, 0x2cbe & 0xFF},
	{0x2cc0 & 0xFF, 0x2cc0 & 0xFF},
	{0x2cc2 & 0xFF, 0x2cc2 & 0xFF},
	{0x2cc4 & 0xFF, 0x2cc4 & 0xFF},
	{0x2cc6 & 0xFF, 0x2cc6 & 0xFF},
	{0x2cc8 & 0xFF, 0x2cc8 & 0xFF},
	{0x2cca & 0xFF, 0x2cca & 0xFF},
	{0x2ccc & 0xFF, 0x2ccc & 0xFF},
	{0x2cce & 0xFF, 0x2cce & 0xFF},
	{0x2cd0 & 0xFF, 0x2cd0 & 0xFF},
	{0x2cd2 & 0xFF, 0x2cd2 & 0xFF},
	{0x2cd4 & 0xFF, 0x2cd4 & 0xFF},
	{0x2cd6 & 0xFF, 0x2cd6 & 0xFF},
	{0x2cd8 & 0xFF, 0x2cd8 & 0xFF},
	{0x2cda & 0xFF, 0x2cda & 0xFF},
	{0x2cdc & 0xFF, 0x2cdc & 0xFF},
	{0x2cde & 0xFF, 0x2cde & 0xFF},
	{0x2ce0 & 0xFF, 0x2ce0 & 0xFF},
	{0x2ce2 & 0xFF, 0x2ce2 & 0xFF},
	{0x2ceb & 0xFF, 0x2ceb & 0xFF},
	{0x2ced & 0xFF, 0x2ced & 0xFF},
	{0x2cf2 & 0xFF, 0x2cf2 & 0xFF},
	{0xa640 & 0xFF, 0xa640 & 0xFF},
	{0xa642 & 0xFF, 0xa642 & 0xFF},
	{0xa644 & 0xFF, 0xa644 & 0xFF},
	{0xa646 & 0xFF, 0xa646 & 0xFF},
	{0xa648 & 0xFF, 0xa648 & 0xFF},
	{0xa64a & 0xFF, 0xa64a & 0xFF},
	{0xa64c & 0xFF, 0xa64c & 0xFF},
	{0xa64e & 0xFF, 0xa64e & 0xFF},
	{0xa650 & 0xFF, 0xa650 & 0xFF},
	{0xa652 & 0xFF, 0xa652 & 0xFF},
	{0xa654 & 0xFF, 0xa654 & 0xFF},
	{0xa656 & 0xFF, 0xa656 & 0xFF},
	{0xa658 & 0xFF, 0xa658 & 0xFF},
	{0xa65a & 0xFF, 0xa65a & 0xFF},
	{0xa65c & 0xFF, 0xa65c & 0xFF},
	{0xa65e & 0xFF, 0xa65e & 0xFF},
	{0xa660 & 0xFF, 0xa660 & 0xFF},
	{0xa662 & 0xFF, 0xa662 & 0xFF},
	{0xa664 & 0xFF, 0xa664 & 0xFF},
	{0xa666 & 0xFF, 0xa666 & 0xFF},
	{0xa668 & 0xFF, 0xa668 & 0xFF},
	{0xa66a & 0xFF, 0xa66a & 0xFF},
	{0xa66c & 0xFF, 0xa66c & 0xFF},
	{0xa680 & 0xFF, 0xa680 & 0xFF},
	{0xa682 & 0xFF, 0xa682 & 0xFF},
	{0xa684 & 0xFF, 0xa684 & 0xFF},
	{0xa686 & 0xFF, 0xa686 & 0xFF},
	{0xa688 & 0xFF, 0xa688 & 0xFF},
	{0xa68a & 0xFF, 0xa68a & 0xFF},
	{0xa68c & 0xFF, 0xa68c & 0xFF},
	{0xa68e & 0xFF, 0xa68e & 0xFF},
	{0xa690 & 0xFF, 0xa690 & 0xFF},
	{0xa692 & 0xFF, 0xa692 & 0xFF},
	{0xa694 & 0xFF, 0xa694 & 0xFF},
	{0xa696 & 0xFF, 0xa696 & 0xFF},
	{0xa698 & 0xFF, 0xa698 & 0xFF},
	{0xa69a & 0xFF, 0xa69a & 0xFF},
	{0xa722 & 0xFF, 0xa722 & 0xFF},
	{0xa724 & 0xFF, 0xa724 & 0xFF},
	{0xa726 & 0xFF, 0xa726 & 0xFF},
	{0xa728 & 0xFF, 0xa728 & 0xFF},
	{0xa72a & 0xFF, 0xa72a & 0xFF},
	{0xa72c & 0xFF, 0xa72c & 0xFF},
	{0xa72e & 0xFF, 0xa72e & 0xFF},
	{0xa732 & 0xFF, 0xa732 & 0xFF},
	{0xa734 & 0xFF, 0xa734 & 0xFF},
	{0xa736 & 0xFF, 0xa736 & 0xFF},
	{0xa738 & 0xFF, 0xa738 & 0xFF},
	{0xa73a & 0xFF, 0xa73a & 0xFF},
	{0xa73c & 0xFF, 0xa73c & 0xFF},
	{0xa73e & 0xFF, 0xa73e & 0xFF},
	{0xa740 & 0xFF, 0xa740 & 0xFF},
	{0xa742 & 0xFF, 0xa742 & 0xFF},
	{0xa744 & 0xFF, 0xa744 & 0xFF},
	{0xa746 & 0xFF, 0xa746 & 0xFF},
	{0xa748 & 0xFF, 0xa748 & 0xFF},
	{0xa74a & 0xFF, 0xa74a & 0xFF},
	{0xa74c & 0xFF, 0xa74c & 0xFF},
	{0xa74e & 0xFF, 0xa74e & 0xFF},
	{0xa750 & 0xFF, 0xa750 & 0xFF},
	{0xa752 & 0xFF, 0xa752 & 0xFF},
	{0xa754 & 0xFF, 0xa754 & 0xFF},
	{0xa756 & 0xFF, 0xa756 & 0xFF},
	{0xa758 & 0xFF, 0xa758 & 0xFF},
	{0xa75a & 0xFF, 0xa75a & 0xFF},
	{0xa75c & 0xFF, 0xa75c & 0xFF},
	{0xa75e & 0xFF, 0xa75e & 0xFF},
	{0xa760 & 0xFF, 0xa760 & 0xFF},
	{0xa762 & 0xFF, 0xa762 & 0xFF},
	{0xa764 & 0xFF, 0xa764 & 0xFF},
	{0xa766 & 0xFF, 0xa766 & 0xFF},
	{0xa768 & 0xFF, 0xa768 & 0xFF},
	{0xa76a & 0xFF, 0xa76a & 0xFF},
	{0xa76c & 0xFF, 0xa76c & 0xFF},
	{0xa76e & 0xFF, 0xa76e & 0xFF},
	{0xa779 & 0xFF, 0xa779 & 0xFF},
	{0xa77b & 0xFF, 0xa77b & 0xFF},
	{0xa77d & 0xFF, 0xa77e & 0xFF},
	{0xa780 & 0xFF, 0xa780 & 0xFF},
	{0xa782 & 0xFF, 0xa782 & 0xFF},
	{0xa784 & 0xFF, 0xa784 & 0xFF},
	{0xa786 & 0xFF, 0xa786 & 0xFF},
	{0xa78b & 0xFF, 0xa78b & 0xFF},
	{0xa78d & 0xFF, 0xa78d & 0xFF},
	{0xa790 & 0xFF, 0xa790 & 0xFF},
	{0xa792 & 0xFF, 0xa792 & 0xFF},
	{0xa796 & 0xFF, 0xa796 & 0xFF},
	{0xa798 & 0xFF, 0xa798 & 0xFF},
	{0xa79a & 0xFF, 0xa79a & 0xFF},
	{0xa79c & 0xFF, 0xa79c & 0xFF},
	{0xa79e & 0xFF, 0xa79e & 0xFF},
	{0xa7a0 & 0xFF, 0xa7a0 & 0xFF},
	{0xa7a2 & 0xFF, 0xa7a2 & 0xFF},
	{0xa7a4 & 0xFF, 0xa7a4 & 0xFF},
	{0xa7a6 & 0xFF, 0xa7a6 & 0xFF},
	{0xa7a8 & 0xFF, 0xa7a8 & 0xFF},
	{0xa7aa & 0xFF, 0xa7ae & 0xFF},
	{0xa7b0 & 0xFF, 0xa7b4 & 0xFF},
	{0xa7b6 & 0xFF, 0xa7b6 & 0xFF},
	{0xa7b8 & 0xFF, 0xa7b8 & 0xFF},
	{0xa7ba & 0xFF, 0xa7ba & 0xFF},
	{0xa7bc & 0xFF, 0xa7bc & 0xFF},
	{0xa7be & 0xFF, 0xa7be & 0xFF},
	{0xa7c0 & 0xFF, 0xa7c0 & 0xFF},
	{0xa7c2 & 0xFF, 0xa7c2 & 0xFF},
	{0xa7c4 & 0xFF, 0xa7c7 & 0xFF},
	{0xa7c9 & 0xFF, 0xa7c9 & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d0 & 0xFF},
	{0xa7d6 & 0xFF, 0xa7d6 & 0xFF},
	{0xa7d8 & 0xFF, 0xa7d8 & 0xFF},
	{0xa7f5 & 0xFF, 0xa7f5 & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0x10400 & 0xFF, 0x10427 & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x118a0 & 0xFF, 0x118bf & 0xFF},
	{0x16e40 & 0xFF, 0x16e5f & 0xFF},
	{0x1e900 & 0xFF, 0x1e921 & 0xFF}};

static const size_t Changes_When_Lowercased_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	16,
	19,
	28,
	30,
	31,
	33,
	36,
	44,
	166,
	167,
	255,
	260,
	261,
	268,
	280,
	366,
	489
};

static const char32_t Changes_When_Lowercased_starting_pagetab[]={
	0,
	3,
	110,
	144,
	171,
	247,
	272,
	275,
	276,
	278,
	402,
	420,
	425,
	426,
	488,
	525,
	599,
	600,
	602,
	606,
	607,
	608,
	609
};

static const uint8_t Changes_When_Titlecased_rangetab[][2]={
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00df & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0101 & 0xFF, 0x0101 & 0xFF},
	{0x0103 & 0xFF, 0x0103 & 0xFF},
	{0x0105 & 0xFF, 0x0105 & 0xFF},
	{0x0107 & 0xFF, 0x0107 & 0xFF},
	{0x0109 & 0xFF, 0x0109 & 0xFF},
	{0x010b & 0xFF, 0x010b & 0xFF},
	{0x010d & 0xFF, 0x010d & 0xFF},
	{0x010f & 0xFF, 0x010f & 0xFF},
	{0x0111 & 0xFF, 0x0111 & 0xFF},
	{0x0113 & 0xFF, 0x0113 & 0xFF},
	{0x0115 & 0xFF, 0x0115 & 0xFF},
	{0x0117 & 0xFF, 0x0117 & 0xFF},
	{0x0119 & 0xFF, 0x0119 & 0xFF},
	{0x011b & 0xFF, 0x011b & 0xFF},
	{0x011d & 0xFF, 0x011d & 0xFF},
	{0x011f & 0xFF, 0x011f & 0xFF},
	{0x0121 & 0xFF, 0x0121 & 0xFF},
	{0x0123 & 0xFF, 0x0123 & 0xFF},
	{0x0125 & 0xFF, 0x0125 & 0xFF},
	{0x0127 & 0xFF, 0x0127 & 0xFF},
	{0x0129 & 0xFF, 0x0129 & 0xFF},
	{0x012b & 0xFF, 0x012b & 0xFF},
	{0x012d & 0xFF, 0x012d & 0xFF},
	{0x012f & 0xFF, 0x012f & 0xFF},
	{0x0131 & 0xFF, 0x0131 & 0xFF},
	{0x0133 & 0xFF, 0x0133 & 0xFF},
	{0x0135 & 0xFF, 0x0135 & 0xFF},
	{0x0137 & 0xFF, 0x0137 & 0xFF},
	{0x013a & 0xFF, 0x013a & 0xFF},
	{0x013c & 0xFF, 0x013c & 0xFF},
	{0x013e & 0xFF, 0x013e & 0xFF},
	{0x0140 & 0xFF, 0x0140 & 0xFF},
	{0x0142 & 0xFF, 0x0142 & 0xFF},
	{0x0144 & 0xFF, 0x0144 & 0xFF},
	{0x0146 & 0xFF, 0x0146 & 0xFF},
	{0x0148 & 0xFF, 0x0149 & 0xFF},
	{0x014b & 0xFF, 0x014b & 0xFF},
	{0x014d & 0xFF, 0x014d & 0xFF},
	{0x014f & 0xFF, 0x014f & 0xFF},
	{0x0151 & 0xFF, 0x0151 & 0xFF},
	{0x0153 & 0xFF, 0x0153 & 0xFF},
	{0x0155 & 0xFF, 0x0155 & 0xFF},
	{0x0157 & 0xFF, 0x0157 & 0xFF},
	{0x0159 & 0xFF, 0x0159 & 0xFF},
	{0x015b & 0xFF, 0x015b & 0xFF},
	{0x015d & 0xFF, 0x015d & 0xFF},
	{0x015f & 0xFF, 0x015f & 0xFF},
	{0x0161 & 0xFF, 0x0161 & 0xFF},
	{0x0163 & 0xFF, 0x0163 & 0xFF},
	{0x0165 & 0xFF, 0x0165 & 0xFF},
	{0x0167 & 0xFF, 0x0167 & 0xFF},
	{0x0169 & 0xFF, 0x0169 & 0xFF},
	{0x016b & 0xFF, 0x016b & 0xFF},
	{0x016d & 0xFF, 0x016d & 0xFF},
	{0x016f & 0xFF, 0x016f & 0xFF},
	{0x0171 & 0xFF, 0x0171 & 0xFF},
	{0x0173 & 0xFF, 0x0173 & 0xFF},
	{0x0175 & 0xFF, 0x0175 & 0xFF},
	{0x0177 & 0xFF, 0x0177 & 0xFF},
	{0x017a & 0xFF, 0x017a & 0xFF},
	{0x017c & 0xFF, 0x017c & 0xFF},
	{0x017e & 0xFF, 0x0180 & 0xFF},
	{0x0183 & 0xFF, 0x0183 & 0xFF},
	{0x0185 & 0xFF, 0x0185 & 0xFF},
	{0x0188 & 0xFF, 0x0188 & 0xFF},
	{0x018c & 0xFF, 0x018c & 0xFF},
	{0x0192 & 0xFF, 0x0192 & 0xFF},
	{0x0195 & 0xFF, 0x0195 & 0xFF},
	{0x0199 & 0xFF, 0x019a & 0xFF},
	{0x019e & 0xFF, 0x019e & 0xFF},
	{0x01a1 & 0xFF, 0x01a1 & 0xFF},
	{0x01a3 & 0xFF, 0x01a3 & 0xFF},
	{0x01a5 & 0xFF, 0x01a5 & 0xFF},
	{0x01a8 & 0xFF, 0x01a8 & 0xFF},
	{0x01ad & 0xFF, 0x01ad & 0xFF},
	{0x01b0 & 0xFF, 0x01b0 & 0xFF},
	{0x01b4 & 0xFF, 0x01b4 & 0xFF},
	{0x01b6 & 0xFF, 0x01b6 & 0xFF},
	{0x01b9 & 0xFF, 0x01b9 & 0xFF},
	{0x01bd & 0xFF, 0x01bd & 0xFF},
	{0x01bf & 0xFF, 0x01bf & 0xFF},
	{0x01c4 & 0xFF, 0x01c4 & 0xFF},
	{0x01c6 & 0xFF, 0x01c7 & 0xFF},
	{0x01c9 & 0xFF, 0x01ca & 0xFF},
	{0x01cc & 0xFF, 0x01cc & 0xFF},
	{0x01ce & 0xFF, 0x01ce & 0xFF},
	{0x01d0 & 0xFF, 0x01d0 & 0xFF},
	{0x01d2 & 0xFF, 0x01d2 & 0xFF},
	{0x01d4 & 0xFF, 0x01d4 & 0xFF},
	{0x01d6 & 0xFF, 0x01d6 & 0xFF},
	{0x01d8 & 0xFF, 0x01d8 & 0xFF},
	{0x01da & 0xFF, 0x01da & 0xFF},
	{0x01dc & 0xFF, 0x01dd & 0xFF},
	{0x01df & 0xFF, 0x01df & 0xFF},
	{0x01e1 & 0xFF, 0x01e1 & 0xFF},
	{0x01e3 & 0xFF, 0x01e3 & 0xFF},
	{0x01e5 & 0xFF, 0x01e5 & 0xFF},
	{0x01e7 & 0xFF, 0x01e7 & 0xFF},
	{0x01e9 & 0xFF, 0x01e9 & 0xFF},
	{0x01eb & 0xFF, 0x01eb & 0xFF},
	{0x01ed & 0xFF, 0x01ed & 0xFF},
	{0x01ef & 0xFF, 0x01f1 & 0xFF},
	{0x01f3 & 0xFF, 0x01f3 & 0xFF},
	{0x01f5 & 0xFF, 0x01f5 & 0xFF},
	{0x01f9 & 0xFF, 0x01f9 & 0xFF},
	{0x01fb & 0xFF, 0x01fb & 0xFF},
	{0x01fd & 0xFF, 0x01fd & 0xFF},
	{0x01ff & 0xFF, 0x01ff & 0xFF},
	{0x0201 & 0xFF, 0x0201 & 0xFF},
	{0x0203 & 0xFF, 0x0203 & 0xFF},
	{0x0205 & 0xFF, 0x0205 & 0xFF},
	{0x0207 & 0xFF, 0x0207 & 0xFF},
	{0x0209 & 0xFF, 0x0209 & 0xFF},
	{0x020b & 0xFF, 0x020b & 0xFF},
	{0x020d & 0xFF, 0x020d & 0xFF},
	{0x020f & 0xFF, 0x020f & 0xFF},
	{0x0211 & 0xFF, 0x0211 & 0xFF},
	{0x0213 & 0xFF, 0x0213 & 0xFF},
	{0x0215 & 0xFF, 0x0215 & 0xFF},
	{0x0217 & 0xFF, 0x0217 & 0xFF},
	{0x0219 & 0xFF, 0x0219 & 0xFF},
	{0x021b & 0xFF, 0x021b & 0xFF},
	{0x021d & 0xFF, 0x021d & 0xFF},
	{0x021f & 0xFF, 0x021f & 0xFF},
	{0x0223 & 0xFF, 0x0223 & 0xFF},
	{0x0225 & 0xFF, 0x0225 & 0xFF},
	{0x0227 & 0xFF, 0x0227 & 0xFF},
	{0x0229 & 0xFF, 0x0229 & 0xFF},
	{0x022b & 0xFF, 0x022b & 0xFF},
	{0x022d & 0xFF, 0x022d & 0xFF},
	{0x022f & 0xFF, 0x022f & 0xFF},
	{0x0231 & 0xFF, 0x0231 & 0xFF},
	{0x0233 & 0xFF, 0x0233 & 0xFF},
	{0x023c & 0xFF, 0x023c & 0xFF},
	{0x023f & 0xFF, 0x0240 & 0xFF},
	{0x0242 & 0xFF, 0x0242 & 0xFF},
	{0x0247 & 0xFF, 0x0247 & 0xFF},
	{0x0249 & 0xFF, 0x0249 & 0xFF},
	{0x024b & 0xFF, 0x024b & 0xFF},
	{0x024d & 0xFF, 0x024d & 0xFF},
	{0x024f & 0xFF, 0x0254 & 0xFF},
	{0x0256 & 0xFF, 0x0257 & 0xFF},
	{0x0259 & 0xFF, 0x0259 & 0xFF},
	{0x025b & 0xFF, 0x025c & 0xFF},
	{0x0260 & 0xFF, 0x0261 & 0xFF},
	{0x0263 & 0xFF, 0x0263 & 0xFF},
	{0x0265 & 0xFF, 0x0266 & 0xFF},
	{0x0268 & 0xFF, 0x026c & 0xFF},
	{0x026f & 0xFF, 0x026f & 0xFF},
	{0x0271 & 0xFF, 0x0272 & 0xFF},
	{0x0275 & 0xFF, 0x0275 & 0xFF},
	{0x027d & 0xFF, 0x027d & 0xFF},
	{0x0280 & 0xFF, 0x0280 & 0xFF},
	{0x0282 & 0xFF, 0x0283 & 0xFF},
	{0x0287 & 0xFF, 0x028c & 0xFF},
	{0x0292 & 0xFF, 0x0292 & 0xFF},
	{0x029d & 0xFF, 0x029e & 0xFF},
	{0x0345 & 0xFF, 0x0345 & 0xFF},
	{0x0371 & 0xFF, 0x0371 & 0xFF},
	{0x0373 & 0xFF, 0x0373 & 0xFF},
	{0x0377 & 0xFF, 0x0377 & 0xFF},
	{0x037b & 0xFF, 0x037d & 0xFF},
	{0x0390 & 0xFF, 0x0390 & 0xFF},
	{0x03ac & 0xFF, 0x03ce & 0xFF},
	{0x03d0 & 0xFF, 0x03d1 & 0xFF},
	{0x03d5 & 0xFF, 0x03d7 & 0xFF},
	{0x03d9 & 0xFF, 0x03d9 & 0xFF},
	{0x03db & 0xFF, 0x03db & 0xFF},
	{0x03dd & 0xFF, 0x03dd & 0xFF},
	{0x03df & 0xFF, 0x03df & 0xFF},
	{0x03e1 & 0xFF, 0x03e1 & 0xFF},
	{0x03e3 & 0xFF, 0x03e3 & 0xFF},
	{0x03e5 & 0xFF, 0x03e5 & 0xFF},
	{0x03e7 & 0xFF, 0x03e7 & 0xFF},
	{0x03e9 & 0xFF, 0x03e9 & 0xFF},
	{0x03eb & 0xFF, 0x03eb & 0xFF},
	{0x03ed & 0xFF, 0x03ed & 0xFF},
	{0x03ef & 0xFF, 0x03f3 & 0xFF},
	{0x03f5 & 0xFF, 0x03f5 & 0xFF},
	{0x03f8 & 0xFF, 0x03f8 & 0xFF},
	{0x03fb & 0xFF, 0x03fb & 0xFF},
	{0x0430 & 0xFF, 0x045f & 0xFF},
	{0x0461 & 0xFF, 0x0461 & 0xFF},
	{0x0463 & 0xFF, 0x0463 & 0xFF},
	{0x0465 & 0xFF, 0x0465 & 0xFF},
	{0x0467 & 0xFF, 0x0467 & 0xFF},
	{0x0469 & 0xFF, 0x0469 & 0xFF},
	{0x046b & 0xFF, 0x046b & 0xFF},
	{0x046d & 0xFF, 0x046d & 0xFF},
	{0x046f & 0xFF, 0x046f & 0xFF},
	{0x0471 & 0xFF, 0x0471 & 0xFF},
	{0x0473 & 0xFF, 0x0473 & 0xFF},
	{0x0475 & 0xFF, 0x0475 & 0xFF},
	{0x0477 & 0xFF, 0x0477 & 0xFF},
	{0x0479 & 0xFF, 0x0479 & 0xFF},
	{0x047b & 0xFF, 0x047b & 0xFF},
	{0x047d & 0xFF, 0x047d & 0xFF},
	{0x047f & 0xFF, 0x047f & 0xFF},
	{0x0481 & 0xFF, 0x0481 & 0xFF},
	{0x048b & 0xFF, 0x048b & 0xFF},
	{0x048d & 0xFF, 0x048d & 0xFF},
	{0x048f & 0xFF, 0x048f & 0xFF},
	{0x0491 & 0xFF, 0x0491 & 0xFF},
	{0x0493 & 0xFF, 0x0493 & 0xFF},
	{0x0495 & 0xFF, 0x0495 & 0xFF},
	{0x0497 & 0xFF, 0x0497 & 0xFF},
	{0x0499 & 0xFF, 0x0499 & 0xFF},
	{0x049b & 0xFF, 0x049b & 0xFF},
	{0x049d & 0xFF, 0x049d & 0xFF},
	{0x049f & 0xFF, 0x049f & 0xFF},
	{0x04a1 & 0xFF, 0x04a1 & 0xFF},
	{0x04a3 & 0xFF, 0x04a3 & 0xFF},
	{0x04a5 & 0xFF, 0x04a5 & 0xFF},
	{0x04a7 & 0xFF, 0x04a7 & 0xFF},
	{0x04a9 & 0xFF, 0x04a9 & 0xFF},
	{0x04ab & 0xFF, 0x04ab & 0xFF},
	{0x04ad & 0xFF, 0x04ad & 0xFF},
	{0x04af & 0xFF, 0x04af & 0xFF},
	{0x04b1 & 0xFF, 0x04b1 & 0xFF},
	{0x04b3 & 0xFF, 0x04b3 & 0xFF},
	{0x04b5 & 0xFF, 0x04b5 & 0xFF},
	{0x04b7 & 0xFF, 0x04b7 & 0xFF},
	{0x04b9 & 0xFF, 0x04b9 & 0xFF},
	{0x04bb & 0xFF, 0x04bb & 0xFF},
	{0x04bd & 0xFF, 0x04bd & 0xFF},
	{0x04bf & 0xFF, 0x04bf & 0xFF},
	{0x04c2 & 0xFF, 0x04c2 & 0xFF},
	{0x04c4 & 0xFF, 0x04c4 & 0xFF},
	{0x04c6 & 0xFF, 0x04c6 & 0xFF},
	{0x04c8 & 0xFF, 0x04c8 & 0xFF},
	{0x04ca & 0xFF, 0x04ca & 0xFF},
	{0x04cc & 0xFF, 0x04cc & 0xFF},
	{0x04ce & 0xFF, 0x04cf & 0xFF},
	{0x04d1 & 0xFF, 0x04d1 & 0xFF},
	{0x04d3 & 0xFF, 0x04d3 & 0xFF},
	{0x04d5 & 0xFF, 0x04d5 & 0xFF},
	{0x04d7 & 0xFF, 0x04d7 & 0xFF},
	{0x04d9 & 0xFF, 0x04d9 & 0xFF},
	{0x04db & 0xFF, 0x04db & 0xFF},
	{0x04dd & 0xFF, 0x04dd & 0xFF},
	{0x04df & 0xFF, 0x04df & 0xFF},
	{0x04e1 & 0xFF, 0x04e1 & 0xFF},
	{0x04e3 & 0xFF, 0x04e3 & 0xFF},
	{0x04e5 & 0xFF, 0x04e5 & 0xFF},
	{0x04e7 & 0xFF, 0x04e7 & 0xFF},
	{0x04e9 & 0xFF, 0x04e9 & 0xFF},
	{0x04eb & 0xFF, 0x04eb & 0xFF},
	{0x04ed & 0xFF, 0x04ed & 0xFF},
	{0x04ef & 0xFF, 0x04ef & 0xFF},
	{0x04f1 & 0xFF, 0x04f1 & 0xFF},
	{0x04f3 & 0xFF, 0x04f3 & 0xFF},
	{0x04f5 & 0xFF, 0x04f5 & 0xFF},
	{0x04f7 & 0xFF, 0x04f7 & 0xFF},
	{0x04f9 & 0xFF, 0x04f9 & 0xFF},
	{0x04fb & 0xFF, 0x04fb & 0xFF},
	{0x04fd & 0xFF, 0x04fd & 0xFF},
	{0x04ff & 0xFF, 0x04ff & 0xFF},
	{0x0501 & 0xFF, 0x0501 & 0xFF},
	{0x0503 & 0xFF, 0x0503 & 0xFF},
	{0x0505 & 0xFF, 0x0505 & 0xFF},
	{0x0507 & 0xFF, 0x0507 & 0xFF},
	{0x0509 & 0xFF, 0x0509 & 0xFF},
	{0x050b & 0xFF, 0x050b & 0xFF},
	{0x050d & 0xFF, 0x050d & 0xFF},
	{0x050f & 0xFF, 0x050f & 0xFF},
	{0x0511 & 0xFF, 0x0511 & 0xFF},
	{0x0513 & 0xFF, 0x0513 & 0xFF},
	{0x0515 & 0xFF, 0x0515 & 0xFF},
	{0x0517 & 0xFF, 0x0517 & 0xFF},
	{0x0519 & 0xFF, 0x0519 & 0xFF},
	{0x051b & 0xFF, 0x051b & 0xFF},
	{0x051d & 0xFF, 0x051d & 0xFF},
	{0x051f & 0xFF, 0x051f & 0xFF},
	{0x0521 & 0xFF, 0x0521 & 0xFF},
	{0x0523 & 0xFF, 0x0523 & 0xFF},
	{0x0525 & 0xFF, 0x0525 & 0xFF},
	{0x0527 & 0xFF, 0x0527 & 0xFF},
	{0x0529 & 0xFF, 0x0529 & 0xFF},
	{0x052b & 0xFF, 0x052b & 0xFF},
	{0x052d & 0xFF, 0x052d & 0xFF},
	{0x052f & 0xFF, 0x052f & 0xFF},
	{0x0561 & 0xFF, 0x0587 & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1d79 & 0xFF, 0x1d79 & 0xFF},
	{0x1d7d & 0xFF, 0x1d7d & 0xFF},
	{0x1d8e & 0xFF, 0x1d8e & 0xFF},
	{0x1e01 & 0xFF, 0x1e01 & 0xFF},
	{0x1e03 & 0xFF, 0x1e03 & 0xFF},
	{0x1e05 & 0xFF, 0x1e05 & 0xFF},
	{0x1e07 & 0xFF, 0x1e07 & 0xFF},
	{0x1e09 & 0xFF, 0x1e09 & 0xFF},
	{0x1e0b & 0xFF, 0x1e0b & 0xFF},
	{0x1e0d & 0xFF, 0x1e0d & 0xFF},
	{0x1e0f & 0xFF, 0x1e0f & 0xFF},
	{0x1e11 & 0xFF, 0x1e11 & 0xFF},
	{0x1e13 & 0xFF, 0x1e13 & 0xFF},
	{0x1e15 & 0xFF, 0x1e15 & 0xFF},
	{0x1e17 & 0xFF, 0x1e17 & 0xFF},
	{0x1e19 & 0xFF, 0x1e19 & 0xFF},
	{0x1e1b & 0xFF, 0x1e1b & 0xFF},
	{0x1e1d & 0xFF, 0x1e1d & 0xFF},
	{0x1e1f & 0xFF, 0x1e1f & 0xFF},
	{0x1e21 & 0xFF, 0x1e21 & 0xFF},
	{0x1e23 & 0xFF, 0x1e23 & 0xFF},
	{0x1e25 & 0xFF, 0x1e25 & 0xFF},
	{0x1e27 & 0xFF, 0x1e27 & 0xFF},
	{0x1e29 & 0xFF, 0x1e29 & 0xFF},
	{0x1e2b & 0xFF, 0x1e2b & 0xFF},
	{0x1e2d & 0xFF, 0x1e2d & 0xFF},
	{0x1e2f & 0xFF, 0x1e2f & 0xFF},
	{0x1e31 & 0xFF, 0x1e31 & 0xFF},
	{0x1e33 & 0xFF, 0x1e33 & 0xFF},
	{0x1e35 & 0xFF, 0x1e35 & 0xFF},
	{0x1e37 & 0xFF, 0x1e37 & 0xFF},
	{0x1e39 & 0xFF, 0x1e39 & 0xFF},
	{0x1e3b & 0xFF, 0x1e3b & 0xFF},
	{0x1e3d & 0xFF, 0x1e3d & 0xFF},
	{0x1e3f & 0xFF, 0x1e3f & 0xFF},
	{0x1e41 & 0xFF, 0x1e41 & 0xFF},
	{0x1e43 & 0xFF, 0x1e43 & 0xFF},
	{0x1e45 & 0xFF, 0x1e45 & 0xFF},
	{0x1e47 & 0xFF, 0x1e47 & 0xFF},
	{0x1e49 & 0xFF, 0x1e49 & 0xFF},
	{0x1e4b & 0xFF, 0x1e4b & 0xFF},
	{0x1e4d & 0xFF, 0x1e4d & 0xFF},
	{0x1e4f & 0xFF, 0x1e4f & 0xFF},
	{0x1e51 & 0xFF, 0x1e51 & 0xFF},
	{0x1e53 & 0xFF, 0x1e53 & 0xFF},
	{0x1e55 & 0xFF, 0x1e55 & 0xFF},
	{0x1e57 & 0xFF, 0x1e57 & 0xFF},
	{0x1e59 & 0xFF, 0x1e59 & 0xFF},
	{0x1e5b & 0xFF, 0x1e5b & 0xFF},
	{0x1e5d & 0xFF, 0x1e5d & 0xFF},
	{0x1e5f & 0xFF, 0x1e5f & 0xFF},
	{0x1e61 & 0xFF, 0x1e61 & 0xFF},
	{0x1e63 & 0xFF, 0x1e63 & 0xFF},
	{0x1e65 & 0xFF, 0x1e65 & 0xFF},
	{0x1e67 & 0xFF, 0x1e67 & 0xFF},
	{0x1e69 & 0xFF, 0x1e69 & 0xFF},
	{0x1e6b & 0xFF, 0x1e6b & 0xFF},
	{0x1e6d & 0xFF, 0x1e6d & 0xFF},
	{0x1e6f & 0xFF, 0x1e6f & 0xFF},
	{0x1e71 & 0xFF, 0x1e71 & 0xFF},
	{0x1e73 & 0xFF, 0x1e73 & 0xFF},
	{0x1e75 & 0xFF, 0x1e75 & 0xFF},
	{0x1e77 & 0xFF, 0x1e77 & 0xFF},
	{0x1e79 & 0xFF, 0x1e79 & 0xFF},
	{0x1e7b & 0xFF, 0x1e7b & 0xFF},
	{0x1e7d & 0xFF, 0x1e7d & 0xFF},
	{0x1e7f & 0xFF, 0x1e7f & 0xFF},
	{0x1e81 & 0xFF, 0x1e81 & 0xFF},
	{0x1e83 & 0xFF, 0x1e83 & 0xFF},
	{0x1e85 & 0xFF, 0x1e85 & 0xFF},
	{0x1e87 & 0xFF, 0x1e87 & 0xFF},
	{0x1e89 & 0xFF, 0x1e89 & 0xFF},
	{0x1e8b & 0xFF, 0x1e8b & 0xFF},
	{0x1e8d & 0xFF, 0x1e8d & 0xFF},
	{0x1e8f & 0xFF, 0x1e8f & 0xFF},
	{0x1e91 & 0xFF, 0x1e91 & 0xFF},
	{0x1e93 & 0xFF, 0x1e93 & 0xFF},
	{0x1e95 & 0xFF, 0x1e9b & 0xFF},
	{0x1ea1 & 0xFF, 0x1ea1 & 0xFF},
	{0x1ea3 & 0xFF, 0x1ea3 & 0xFF},
	{0x1ea5 & 0xFF, 0x1ea5 & 0xFF},
	{0x1ea7 & 0xFF, 0x1ea7 & 0xFF},
	{0x1ea9 & 0xFF, 0x1ea9 & 0xFF},
	{0x1eab & 0xFF, 0x1eab & 0xFF},
	{0x1ead & 0xFF, 0x1ead & 0xFF},
	{0x1eaf & 0xFF, 0x1eaf & 0xFF},
	{0x1eb1 & 0xFF, 0x1eb1 & 0xFF},
	{0x1eb3 & 0xFF, 0x1eb3 & 0xFF},
	{0x1eb5 & 0xFF, 0x1eb5 & 0xFF},
	{0x1eb7 & 0xFF, 0x1eb7 & 0xFF},
	{0x1eb9 & 0xFF, 0x1eb9 & 0xFF},
	{0x1ebb & 0xFF, 0x1ebb & 0xFF},
	{0x1ebd & 0xFF, 0x1ebd & 0xFF},
	{0x1ebf & 0xFF, 0x1ebf & 0xFF},
	{0x1ec1 & 0xFF, 0x1ec1 & 0xFF},
	{0x1ec3 & 0xFF, 0x1ec3 & 0xFF},
	{0x1ec5 & 0xFF, 0x1ec5 & 0xFF},
	{0x1ec7 & 0xFF, 0x1ec7 & 0xFF},
	{0x1ec9 & 0xFF, 0x1ec9 & 0xFF},
	{0x1ecb & 0xFF, 0x1ecb & 0xFF},
	{0x1ecd & 0xFF, 0x1ecd & 0xFF},
	{0x1ecf & 0xFF, 0x1ecf & 0xFF},
	{0x1ed1 & 0xFF, 0x1ed1 & 0xFF},
	{0x1ed3 & 0xFF, 0x1ed3 & 0xFF},
	{0x1ed5 & 0xFF, 0x1ed5 & 0xFF},
	{0x1ed7 & 0xFF, 0x1ed7 & 0xFF},
	{0x1ed9 & 0xFF, 0x1ed9 & 0xFF},
	{0x1edb & 0xFF, 0x1edb & 0xFF},
	{0x1edd & 0xFF, 0x1edd & 0xFF},
	{0x1edf & 0xFF, 0x1edf & 0xFF},
	{0x1ee1 & 0xFF, 0x1ee1 & 0xFF},
	{0x1ee3 & 0xFF, 0x1ee3 & 0xFF},
	{0x1ee5 & 0xFF, 0x1ee5 & 0xFF},
	{0x1ee7 & 0xFF, 0x1ee7 & 0xFF},
	{0x1ee9 & 0xFF, 0x1ee9 & 0xFF},
	{0x1eeb & 0xFF, 0x1eeb & 0xFF},
	{0x1eed & 0xFF, 0x1eed & 0xFF},
	{0x1eef & 0xFF, 0x1eef & 0xFF},
	{0x1ef1 & 0xFF, 0x1ef1 & 0xFF},
	{0x1ef3 & 0xFF, 0x1ef3 & 0xFF},
	{0x1ef5 & 0xFF, 0x1ef5 & 0xFF},
	{0x1ef7 & 0xFF, 0x1ef7 & 0xFF},
	{0x1ef9 & 0xFF, 0x1ef9 & 0xFF},
	{0x1efb & 0xFF, 0x1efb & 0xFF},
	{0x1efd & 0xFF, 0x1efd & 0xFF},
	{0x1eff & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f07 & 0xFF},
	{0x1f10 & 0xFF, 0x1f15 & 0xFF},
	{0x1f20 & 0xFF, 0x1f27 & 0xFF},
	{0x1f30 & 0xFF, 0x1f37 & 0xFF},
	{0x1f40 & 0xFF, 0x1f45 & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f60 & 0xFF, 0x1f67 & 0xFF},
	{0x1f70 & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1f87 & 0xFF},
	{0x1f90 & 0xFF, 0x1f97 & 0xFF},
	{0x1fa0 & 0xFF, 0x1fa7 & 0xFF},
	{0x1fb0 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fb7 & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fc7 & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fd7 & 0xFF},
	{0x1fe0 & 0xFF, 0x1fe7 & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ff7 & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2170 & 0xFF, 0x217f & 0xFF},
	{0x2184 & 0xFF, 0x2184 & 0xFF},
	{0x24d0 & 0xFF, 0x24e9 & 0xFF},
	{0x2c30 & 0xFF, 0x2c5f & 0xFF},
	{0x2c61 & 0xFF, 0x2c61 & 0xFF},
	{0x2c65 & 0xFF, 0x2c66 & 0xFF},
	{0x2c68 & 0xFF, 0x2c68 & 0xFF},
	{0x2c6a & 0xFF, 0x2c6a & 0xFF},
	{0x2c6c & 0xFF, 0x2c6c & 0xFF},
	{0x2c73 & 0xFF, 0x2c73 & 0xFF},
	{0x2c76 & 0xFF, 0x2c76 & 0xFF},
	{0x2c81 & 0xFF, 0x2c81 & 0xFF},
	{0x2c83 & 0xFF, 0x2c83 & 0xFF},
	{0x2c85 & 0xFF, 0x2c85 & 0xFF},
	{0x2c87 & 0xFF, 0x2c87 & 0xFF},
	{0x2c89 & 0xFF, 0x2c89 & 0xFF},
	{0x2c8b & 0xFF, 0x2c8b & 0xFF},
	{0x2c8d & 0xFF, 0x2c8d & 0xFF},
	{0x2c8f & 0xFF, 0x2c8f & 0xFF},
	{0x2c91 & 0xFF, 0x2c91 & 0xFF},
	{0x2c93 & 0xFF, 0x2c93 & 0xFF},
	{0x2c95 & 0xFF, 0x2c95 & 0xFF},
	{0x2c97 & 0xFF, 0x2c97 & 0xFF},
	{0x2c99 & 0xFF, 0x2c99 & 0xFF},
	{0x2c9b & 0xFF, 0x2c9b & 0xFF},
	{0x2c9d & 0xFF, 0x2c9d & 0xFF},
	{0x2c9f & 0xFF, 0x2c9f & 0xFF},
	{0x2ca1 & 0xFF, 0x2ca1 & 0xFF},
	{0x2ca3 & 0xFF, 0x2ca3 & 0xFF},
	{0x2ca5 & 0xFF, 0x2ca5 & 0xFF},
	{0x2ca7 & 0xFF, 0x2ca7 & 0xFF},
	{0x2ca9 & 0xFF, 0x2ca9 & 0xFF},
	{0x2cab & 0xFF, 0x2cab & 0xFF},
	{0x2cad & 0xFF, 0x2cad & 0xFF},
	{0x2caf & 0xFF, 0x2caf & 0xFF},
	{0x2cb1 & 0xFF, 0x2cb1 & 0xFF},
	{0x2cb3 & 0xFF, 0x2cb3 & 0xFF},
	{0x2cb5 & 0xFF, 0x2cb5 & 0xFF},
	{0x2cb7 & 0xFF, 0x2cb7 & 0xFF},
	{0x2cb9 & 0xFF, 0x2cb9 & 0xFF},
	{0x2cbb & 0xFF, 0x2cbb & 0xFF},
	{0x2cbd & 0xFF, 0x2cbd & 0xFF},
	{0x2cbf & 0xFF, 0x2cbf & 0xFF},
	{0x2cc1 & 0xFF, 0x2cc1 & 0xFF},
	{0x2cc3 & 0xFF, 0x2cc3 & 0xFF},
	{0x2cc5 & 0xFF, 0x2cc5 & 0xFF},
	{0x2cc7 & 0xFF, 0x2cc7 & 0xFF},
	{0x2cc9 & 0xFF, 0x2cc9 & 0xFF},
	{0x2ccb & 0xFF, 0x2ccb & 0xFF},
	{0x2ccd & 0xFF, 0x2ccd & 0xFF},
	{0x2ccf & 0xFF, 0x2ccf & 0xFF},
	{0x2cd1 & 0xFF, 0x2cd1 & 0xFF},
	{0x2cd3 & 0xFF, 0x2cd3 & 0xFF},
	{0x2cd5 & 0xFF, 0x2cd5 & 0xFF},
	{0x2cd7 & 0xFF, 0x2cd7 & 0xFF},
	{0x2cd9 & 0xFF, 0x2cd9 & 0xFF},
	{0x2cdb & 0xFF, 0x2cdb & 0xFF},
	{0x2cdd & 0xFF, 0x2cdd & 0xFF},
	{0x2cdf & 0xFF, 0x2cdf & 0xFF},
	{0x2ce1 & 0xFF, 0x2ce1 & 0xFF},
	{0x2ce3 & 0xFF, 0x2ce3 & 0xFF},
	{0x2cec & 0xFF, 0x2cec & 0xFF},
	{0x2cee & 0xFF, 0x2cee & 0xFF},
	{0x2cf3 & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0xa641 & 0xFF, 0xa641 & 0xFF},
	{0xa643 & 0xFF, 0xa643 & 0xFF},
	{0xa645 & 0xFF, 0xa645 & 0xFF},
	{0xa647 & 0xFF, 0xa647 & 0xFF},
	{0xa649 & 0xFF, 0xa649 & 0xFF},
	{0xa64b & 0xFF, 0xa64b & 0xFF},
	{0xa64d & 0xFF, 0xa64d & 0xFF},
	{0xa64f & 0xFF, 0xa64f & 0xFF},
	{0xa651 & 0xFF, 0xa651 & 0xFF},
	{0xa653 & 0xFF, 0xa653 & 0xFF},
	{0xa655 & 0xFF, 0xa655 & 0xFF},
	{0xa657 & 0xFF, 0xa657 & 0xFF},
	{0xa659 & 0xFF, 0xa659 & 0xFF},
	{0xa65b & 0xFF, 0xa65b & 0xFF},
	{0xa65d & 0xFF, 0xa65d & 0xFF},
	{0xa65f & 0xFF, 0xa65f & 0xFF},
	{0xa661 & 0xFF, 0xa661 & 0xFF},
	{0xa663 & 0xFF, 0xa663 & 0xFF},
	{0xa665 & 0xFF, 0xa665 & 0xFF},
	{0xa667 & 0xFF, 0xa667 & 0xFF},
	{0xa669 & 0xFF, 0xa669 & 0xFF},
	{0xa66b & 0xFF, 0xa66b & 0xFF},
	{0xa66d & 0xFF, 0xa66d & 0xFF},
	{0xa681 & 0xFF, 0xa681 & 0xFF},
	{0xa683 & 0xFF, 0xa683 & 0xFF},
	{0xa685 & 0xFF, 0xa685 & 0xFF},
	{0xa687 & 0xFF, 0xa687 & 0xFF},
	{0xa689 & 0xFF, 0xa689 & 0xFF},
	{0xa68b & 0xFF, 0xa68b & 0xFF},
	{0xa68d & 0xFF, 0xa68d & 0xFF},
	{0xa68f & 0xFF, 0xa68f & 0xFF},
	{0xa691 & 0xFF, 0xa691 & 0xFF},
	{0xa693 & 0xFF, 0xa693 & 0xFF},
	{0xa695 & 0xFF, 0xa695 & 0xFF},
	{0xa697 & 0xFF, 0xa697 & 0xFF},
	{0xa699 & 0xFF, 0xa699 & 0xFF},
	{0xa69b & 0xFF, 0xa69b & 0xFF},
	{0xa723 & 0xFF, 0xa723 & 0xFF},
	{0xa725 & 0xFF, 0xa725 & 0xFF},
	{0xa727 & 0xFF, 0xa727 & 0xFF},
	{0xa729 & 0xFF, 0xa729 & 0xFF},
	{0xa72b & 0xFF, 0xa72b & 0xFF},
	{0xa72d & 0xFF, 0xa72d & 0xFF},
	{0xa72f & 0xFF, 0xa72f & 0xFF},
	{0xa733 & 0xFF, 0xa733 & 0xFF},
	{0xa735 & 0xFF, 0xa735 & 0xFF},
	{0xa737 & 0xFF, 0xa737 & 0xFF},
	{0xa739 & 0xFF, 0xa739 & 0xFF},
	{0xa73b & 0xFF, 0xa73b & 0xFF},
	{0xa73d & 0xFF, 0xa73d & 0xFF},
	{0xa73f & 0xFF, 0xa73f & 0xFF},
	{0xa741 & 0xFF, 0xa741 & 0xFF},
	{0xa743 & 0xFF, 0xa743 & 0xFF},
	{0xa745 & 0xFF, 0xa745 & 0xFF},
	{0xa747 & 0xFF, 0xa747 & 0xFF},
	{0xa749 & 0xFF, 0xa749 & 0xFF},
	{0xa74b & 0xFF, 0xa74b & 0xFF},
	{0xa74d & 0xFF, 0xa74d & 0xFF},
	{0xa74f & 0xFF, 0xa74f & 0xFF},
	{0xa751 & 0xFF, 0xa751 & 0xFF},
	{0xa753 & 0xFF, 0xa753 & 0xFF},
	{0xa755 & 0xFF, 0xa755 & 0xFF},
	{0xa757 & 0xFF, 0xa757 & 0xFF},
	{0xa759 & 0xFF, 0xa759 & 0xFF},
	{0xa75b & 0xFF, 0xa75b & 0xFF},
	{0xa75d & 0xFF, 0xa75d & 0xFF},
	{0xa75f & 0xFF, 0xa75f & 0xFF},
	{0xa761 & 0xFF, 0xa761 & 0xFF},
	{0xa763 & 0xFF, 0xa763 & 0xFF},
	{0xa765 & 0xFF, 0xa765 & 0xFF},
	{0xa767 & 0xFF, 0xa767 & 0xFF},
	{0xa769 & 0xFF, 0xa769 & 0xFF},
	{0xa76b & 0xFF, 0xa76b & 0xFF},
	{0xa76d & 0xFF, 0xa76d & 0xFF},
	{0xa76f & 0xFF, 0xa76f & 0xFF},
	{0xa77a & 0xFF, 0xa77a & 0xFF},
	{0xa77c & 0xFF, 0xa77c & 0xFF},
	{0xa77f & 0xFF, 0xa77f & 0xFF},
	{0xa781 & 0xFF, 0xa781 & 0xFF},
	{0xa783 & 0xFF, 0xa783 & 0xFF},
	{0xa785 & 0xFF, 0xa785 & 0xFF},
	{0xa787 & 0xFF, 0xa787 & 0xFF},
	{0xa78c & 0xFF, 0xa78c & 0xFF},
	{0xa791 & 0xFF, 0xa791 & 0xFF},
	{0xa793 & 0xFF, 0xa794 & 0xFF},
	{0xa797 & 0xFF, 0xa797 & 0xFF},
	{0xa799 & 0xFF, 0xa799 & 0xFF},
	{0xa79b & 0xFF, 0xa79b & 0xFF},
	{0xa79d & 0xFF, 0xa79d & 0xFF},
	{0xa79f & 0xFF, 0xa79f & 0xFF},
	{0xa7a1 & 0xFF, 0xa7a1 & 0xFF},
	{0xa7a3 & 0xFF, 0xa7a3 & 0xFF},
	{0xa7a5 & 0xFF, 0xa7a5 & 0xFF},
	{0xa7a7 & 0xFF, 0xa7a7 & 0xFF},
	{0xa7a9 & 0xFF, 0xa7a9 & 0xFF},
	{0xa7b5 & 0xFF, 0xa7b5 & 0xFF},
	{0xa7b7 & 0xFF, 0xa7b7 & 0xFF},
	{0xa7b9 & 0xFF, 0xa7b9 & 0xFF},
	{0xa7bb & 0xFF, 0xa7bb & 0xFF},
	{0xa7bd & 0xFF, 0xa7bd & 0xFF},
	{0xa7bf & 0xFF, 0xa7bf & 0xFF},
	{0xa7c1 & 0xFF, 0xa7c1 & 0xFF},
	{0xa7c3 & 0xFF, 0xa7c3 & 0xFF},
	{0xa7c8 & 0xFF, 0xa7c8 & 0xFF},
	{0xa7ca & 0xFF, 0xa7ca & 0xFF},
	{0xa7d1 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d7 & 0xFF, 0xa7d7 & 0xFF},
	{0xa7d9 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f6 & 0xFF, 0xa7f6 & 0xFF},
	{0xab53 & 0xFF, 0xab53 & 0xFF},
	{0xab70 & 0xFF, 0xabbf & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0x10428 & 0xFF, 0x1044f & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x118c0 & 0xFF, 0x118df & 0xFF},
	{0x16e60 & 0xFF, 0x16e7f & 0xFF},
	{0x1e922 & 0xFF, 0x1e943 & 0xFF}};

static const size_t Changes_When_Titlecased_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	19,
	28,
	29,
	30,
	31,
	33,
	36,
	44,
	45,
	166,
	167,
	171,
	251,
	255,
	260,
	261,
	268,
	280,
	366,
	489
};

static const char32_t Changes_When_Titlecased_starting_pagetab[]={
	0,
	4,
	112,
	161,
	185,
	261,
	286,
	287,
	288,
	291,
	414,
	435,
	438,
	439,
	500,
	503,
	540,
	612,
	614,
	616,
	617,
	619,
	623,
	624,
	625,
	626
};

static const uint8_t Changes_When_Uppercased_rangetab[][2]={
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00df & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0101 & 0xFF, 0x0101 & 0xFF},
	{0x0103 & 0xFF, 0x0103 & 0xFF},
	{0x0105 & 0xFF, 0x0105 & 0xFF},
	{0x0107 & 0xFF, 0x0107 & 0xFF},
	{0x0109 & 0xFF, 0x0109 & 0xFF},
	{0x010b & 0xFF, 0x010b & 0xFF},
	{0x010d & 0xFF, 0x010d & 0xFF},
	{0x010f & 0xFF, 0x010f & 0xFF},
	{0x0111 & 0xFF, 0x0111 & 0xFF},
	{0x0113 & 0xFF, 0x0113 & 0xFF},
	{0x0115 & 0xFF, 0x0115 & 0xFF},
	{0x0117 & 0xFF, 0x0117 & 0xFF},
	{0x0119 & 0xFF, 0x0119 & 0xFF},
	{0x011b & 0xFF, 0x011b & 0xFF},
	{0x011d & 0xFF, 0x011d & 0xFF},
	{0x011f & 0xFF, 0x011f & 0xFF},
	{0x0121 & 0xFF, 0x0121 & 0xFF},
	{0x0123 & 0xFF, 0x0123 & 0xFF},
	{0x0125 & 0xFF, 0x0125 & 0xFF},
	{0x0127 & 0xFF, 0x0127 & 0xFF},
	{0x0129 & 0xFF, 0x0129 & 0xFF},
	{0x012b & 0xFF, 0x012b & 0xFF},
	{0x012d & 0xFF, 0x012d & 0xFF},
	{0x012f & 0xFF, 0x012f & 0xFF},
	{0x0131 & 0xFF, 0x0131 & 0xFF},
	{0x0133 & 0xFF, 0x0133 & 0xFF},
	{0x0135 & 0xFF, 0x0135 & 0xFF},
	{0x0137 & 0xFF, 0x0137 & 0xFF},
	{0x013a & 0xFF, 0x013a & 0xFF},
	{0x013c & 0xFF, 0x013c & 0xFF},
	{0x013e & 0xFF, 0x013e & 0xFF},
	{0x0140 & 0xFF, 0x0140 & 0xFF},
	{0x0142 & 0xFF, 0x0142 & 0xFF},
	{0x0144 & 0xFF, 0x0144 & 0xFF},
	{0x0146 & 0xFF, 0x0146 & 0xFF},
	{0x0148 & 0xFF, 0x0149 & 0xFF},
	{0x014b & 0xFF, 0x014b & 0xFF},
	{0x014d & 0xFF, 0x014d & 0xFF},
	{0x014f & 0xFF, 0x014f & 0xFF},
	{0x0151 & 0xFF, 0x0151 & 0xFF},
	{0x0153 & 0xFF, 0x0153 & 0xFF},
	{0x0155 & 0xFF, 0x0155 & 0xFF},
	{0x0157 & 0xFF, 0x0157 & 0xFF},
	{0x0159 & 0xFF, 0x0159 & 0xFF},
	{0x015b & 0xFF, 0x015b & 0xFF},
	{0x015d & 0xFF, 0x015d & 0xFF},
	{0x015f & 0xFF, 0x015f & 0xFF},
	{0x0161 & 0xFF, 0x0161 & 0xFF},
	{0x0163 & 0xFF, 0x0163 & 0xFF},
	{0x0165 & 0xFF, 0x0165 & 0xFF},
	{0x0167 & 0xFF, 0x0167 & 0xFF},
	{0x0169 & 0xFF, 0x0169 & 0xFF},
	{0x016b & 0xFF, 0x016b & 0xFF},
	{0x016d & 0xFF, 0x016d & 0xFF},
	{0x016f & 0xFF, 0x016f & 0xFF},
	{0x0171 & 0xFF, 0x0171 & 0xFF},
	{0x0173 & 0xFF, 0x0173 & 0xFF},
	{0x0175 & 0xFF, 0x0175 & 0xFF},
	{0x0177 & 0xFF, 0x0177 & 0xFF},
	{0x017a & 0xFF, 0x017a & 0xFF},
	{0x017c & 0xFF, 0x017c & 0xFF},
	{0x017e & 0xFF, 0x0180 & 0xFF},
	{0x0183 & 0xFF, 0x0183 & 0xFF},
	{0x0185 & 0xFF, 0x0185 & 0xFF},
	{0x0188 & 0xFF, 0x0188 & 0xFF},
	{0x018c & 0xFF, 0x018c & 0xFF},
	{0x0192 & 0xFF, 0x0192 & 0xFF},
	{0x0195 & 0xFF, 0x0195 & 0xFF},
	{0x0199 & 0xFF, 0x019a & 0xFF},
	{0x019e & 0xFF, 0x019e & 0xFF},
	{0x01a1 & 0xFF, 0x01a1 & 0xFF},
	{0x01a3 & 0xFF, 0x01a3 & 0xFF},
	{0x01a5 & 0xFF, 0x01a5 & 0xFF},
	{0x01a8 & 0xFF, 0x01a8 & 0xFF},
	{0x01ad & 0xFF, 0x01ad & 0xFF},
	{0x01b0 & 0xFF, 0x01b0 & 0xFF},
	{0x01b4 & 0xFF, 0x01b4 & 0xFF},
	{0x01b6 & 0xFF, 0x01b6 & 0xFF},
	{0x01b9 & 0xFF, 0x01b9 & 0xFF},
	{0x01bd & 0xFF, 0x01bd & 0xFF},
	{0x01bf & 0xFF, 0x01bf & 0xFF},
	{0x01c5 & 0xFF, 0x01c6 & 0xFF},
	{0x01c8 & 0xFF, 0x01c9 & 0xFF},
	{0x01cb & 0xFF, 0x01cc & 0xFF},
	{0x01ce & 0xFF, 0x01ce & 0xFF},
	{0x01d0 & 0xFF, 0x01d0 & 0xFF},
	{0x01d2 & 0xFF, 0x01d2 & 0xFF},
	{0x01d4 & 0xFF, 0x01d4 & 0xFF},
	{0x01d6 & 0xFF, 0x01d6 & 0xFF},
	{0x01d8 & 0xFF, 0x01d8 & 0xFF},
	{0x01da & 0xFF, 0x01da & 0xFF},
	{0x01dc & 0xFF, 0x01dd & 0xFF},
	{0x01df & 0xFF, 0x01df & 0xFF},
	{0x01e1 & 0xFF, 0x01e1 & 0xFF},
	{0x01e3 & 0xFF, 0x01e3 & 0xFF},
	{0x01e5 & 0xFF, 0x01e5 & 0xFF},
	{0x01e7 & 0xFF, 0x01e7 & 0xFF},
	{0x01e9 & 0xFF, 0x01e9 & 0xFF},
	{0x01eb & 0xFF, 0x01eb & 0xFF},
	{0x01ed & 0xFF, 0x01ed & 0xFF},
	{0x01ef & 0xFF, 0x01f0 & 0xFF},
	{0x01f2 & 0xFF, 0x01f3 & 0xFF},
	{0x01f5 & 0xFF, 0x01f5 & 0xFF},
	{0x01f9 & 0xFF, 0x01f9 & 0xFF},
	{0x01fb & 0xFF, 0x01fb & 0xFF},
	{0x01fd & 0xFF, 0x01fd & 0xFF},
	{0x01ff & 0xFF, 0x01ff & 0xFF},
	{0x0201 & 0xFF, 0x0201 & 0xFF},
	{0x0203 & 0xFF, 0x0203 & 0xFF},
	{0x0205 & 0xFF, 0x0205 & 0xFF},
	{0x0207 & 0xFF, 0x0207 & 0xFF},
	{0x0209 & 0xFF, 0x0209 & 0xFF},
	{0x020b & 0xFF, 0x020b & 0xFF},
	{0x020d & 0xFF, 0x020d & 0xFF},
	{0x020f & 0xFF, 0x020f & 0xFF},
	{0x0211 & 0xFF, 0x0211 & 0xFF},
	{0x0213 & 0xFF, 0x0213 & 0xFF},
	{0x0215 & 0xFF, 0x0215 & 0xFF},
	{0x0217 & 0xFF, 0x0217 & 0xFF},
	{0x0219 & 0xFF, 0x0219 & 0xFF},
	{0x021b & 0xFF, 0x021b & 0xFF},
	{0x021d & 0xFF, 0x021d & 0xFF},
	{0x021f & 0xFF, 0x021f & 0xFF},
	{0x0223 & 0xFF, 0x0223 & 0xFF},
	{0x0225 & 0xFF, 0x0225 & 0xFF},
	{0x0227 & 0xFF, 0x0227 & 0xFF},
	{0x0229 & 0xFF, 0x0229 & 0xFF},
	{0x022b & 0xFF, 0x022b & 0xFF},
	{0x022d & 0xFF, 0x022d & 0xFF},
	{0x022f & 0xFF, 0x022f & 0xFF},
	{0x0231 & 0xFF, 0x0231 & 0xFF},
	{0x0233 & 0xFF, 0x0233 & 0xFF},
	{0x023c & 0xFF, 0x023c & 0xFF},
	{0x023f & 0xFF, 0x0240 & 0xFF},
	{0x0242 & 0xFF, 0x0242 & 0xFF},
	{0x0247 & 0xFF, 0x0247 & 0xFF},
	{0x0249 & 0xFF, 0x0249 & 0xFF},
	{0x024b & 0xFF, 0x024b & 0xFF},
	{0x024d & 0xFF, 0x024d & 0xFF},
	{0x024f & 0xFF, 0x0254 & 0xFF},
	{0x0256 & 0xFF, 0x0257 & 0xFF},
	{0x0259 & 0xFF, 0x0259 & 0xFF},
	{0x025b & 0xFF, 0x025c & 0xFF},
	{0x0260 & 0xFF, 0x0261 & 0xFF},
	{0x0263 & 0xFF, 0x0263 & 0xFF},
	{0x0265 & 0xFF, 0x0266 & 0xFF},
	{0x0268 & 0xFF, 0x026c & 0xFF},
	{0x026f & 0xFF, 0x026f & 0xFF},
	{0x0271 & 0xFF, 0x0272 & 0xFF},
	{0x0275 & 0xFF, 0x0275 & 0xFF},
	{0x027d & 0xFF, 0x027d & 0xFF},
	{0x0280 & 0xFF, 0x0280 & 0xFF},
	{0x0282 & 0xFF, 0x0283 & 0xFF},
	{0x0287 & 0xFF, 0x028c & 0xFF},
	{0x0292 & 0xFF, 0x0292 & 0xFF},
	{0x029d & 0xFF, 0x029e & 0xFF},
	{0x0345 & 0xFF, 0x0345 & 0xFF},
	{0x0371 & 0xFF, 0x0371 & 0xFF},
	{0x0373 & 0xFF, 0x0373 & 0xFF},
	{0x0377 & 0xFF, 0x0377 & 0xFF},
	{0x037b & 0xFF, 0x037d & 0xFF},
	{0x0390 & 0xFF, 0x0390 & 0xFF},
	{0x03ac & 0xFF, 0x03ce & 0xFF},
	{0x03d0 & 0xFF, 0x03d1 & 0xFF},
	{0x03d5 & 0xFF, 0x03d7 & 0xFF},
	{0x03d9 & 0xFF, 0x03d9 & 0xFF},
	{0x03db & 0xFF, 0x03db & 0xFF},
	{0x03dd & 0xFF, 0x03dd & 0xFF},
	{0x03df & 0xFF, 0x03df & 0xFF},
	{0x03e1 & 0xFF, 0x03e1 & 0xFF},
	{0x03e3 & 0xFF, 0x03e3 & 0xFF},
	{0x03e5 & 0xFF, 0x03e5 & 0xFF},
	{0x03e7 & 0xFF, 0x03e7 & 0xFF},
	{0x03e9 & 0xFF, 0x03e9 & 0xFF},
	{0x03eb & 0xFF, 0x03eb & 0xFF},
	{0x03ed & 0xFF, 0x03ed & 0xFF},
	{0x03ef & 0xFF, 0x03f3 & 0xFF},
	{0x03f5 & 0xFF, 0x03f5 & 0xFF},
	{0x03f8 & 0xFF, 0x03f8 & 0xFF},
	{0x03fb & 0xFF, 0x03fb & 0xFF},
	{0x0430 & 0xFF, 0x045f & 0xFF},
	{0x0461 & 0xFF, 0x0461 & 0xFF},
	{0x0463 & 0xFF, 0x0463 & 0xFF},
	{0x0465 & 0xFF, 0x0465 & 0xFF},
	{0x0467 & 0xFF, 0x0467 & 0xFF},
	{0x0469 & 0xFF, 0x0469 & 0xFF},
	{0x046b & 0xFF, 0x046b & 0xFF},
	{0x046d & 0xFF, 0x046d & 0xFF},
	{0x046f & 0xFF, 0x046f & 0xFF},
	{0x0471 & 0xFF, 0x0471 & 0xFF},
	{0x0473 & 0xFF, 0x0473 & 0xFF},
	{0x0475 & 0xFF, 0x0475 & 0xFF},
	{0x0477 & 0xFF, 0x0477 & 0xFF},
	{0x0479 & 0xFF, 0x0479 & 0xFF},
	{0x047b & 0xFF, 0x047b & 0xFF},
	{0x047d & 0xFF, 0x047d & 0xFF},
	{0x047f & 0xFF, 0x047f & 0xFF},
	{0x0481 & 0xFF, 0x0481 & 0xFF},
	{0x048b & 0xFF, 0x048b & 0xFF},
	{0x048d & 0xFF, 0x048d & 0xFF},
	{0x048f & 0xFF, 0x048f & 0xFF},
	{0x0491 & 0xFF, 0x0491 & 0xFF},
	{0x0493 & 0xFF, 0x0493 & 0xFF},
	{0x0495 & 0xFF, 0x0495 & 0xFF},
	{0x0497 & 0xFF, 0x0497 & 0xFF},
	{0x0499 & 0xFF, 0x0499 & 0xFF},
	{0x049b & 0xFF, 0x049b & 0xFF},
	{0x049d & 0xFF, 0x049d & 0xFF},
	{0x049f & 0xFF, 0x049f & 0xFF},
	{0x04a1 & 0xFF, 0x04a1 & 0xFF},
	{0x04a3 & 0xFF, 0x04a3 & 0xFF},
	{0x04a5 & 0xFF, 0x04a5 & 0xFF},
	{0x04a7 & 0xFF, 0x04a7 & 0xFF},
	{0x04a9 & 0xFF, 0x04a9 & 0xFF},
	{0x04ab & 0xFF, 0x04ab & 0xFF},
	{0x04ad & 0xFF, 0x04ad & 0xFF},
	{0x04af & 0xFF, 0x04af & 0xFF},
	{0x04b1 & 0xFF, 0x04b1 & 0xFF},
	{0x04b3 & 0xFF, 0x04b3 & 0xFF},
	{0x04b5 & 0xFF, 0x04b5 & 0xFF},
	{0x04b7 & 0xFF, 0x04b7 & 0xFF},
	{0x04b9 & 0xFF, 0x04b9 & 0xFF},
	{0x04bb & 0xFF, 0x04bb & 0xFF},
	{0x04bd & 0xFF, 0x04bd & 0xFF},
	{0x04bf & 0xFF, 0x04bf & 0xFF},
	{0x04c2 & 0xFF, 0x04c2 & 0xFF},
	{0x04c4 & 0xFF, 0x04c4 & 0xFF},
	{0x04c6 & 0xFF, 0x04c6 & 0xFF},
	{0x04c8 & 0xFF, 0x04c8 & 0xFF},
	{0x04ca & 0xFF, 0x04ca & 0xFF},
	{0x04cc & 0xFF, 0x04cc & 0xFF},
	{0x04ce & 0xFF, 0x04cf & 0xFF},
	{0x04d1 & 0xFF, 0x04d1 & 0xFF},
	{0x04d3 & 0xFF, 0x04d3 & 0xFF},
	{0x04d5 & 0xFF, 0x04d5 & 0xFF},
	{0x04d7 & 0xFF, 0x04d7 & 0xFF},
	{0x04d9 & 0xFF, 0x04d9 & 0xFF},
	{0x04db & 0xFF, 0x04db & 0xFF},
	{0x04dd & 0xFF, 0x04dd & 0xFF},
	{0x04df & 0xFF, 0x04df & 0xFF},
	{0x04e1 & 0xFF, 0x04e1 & 0xFF},
	{0x04e3 & 0xFF, 0x04e3 & 0xFF},
	{0x04e5 & 0xFF, 0x04e5 & 0xFF},
	{0x04e7 & 0xFF, 0x04e7 & 0xFF},
	{0x04e9 & 0xFF, 0x04e9 & 0xFF},
	{0x04eb & 0xFF, 0x04eb & 0xFF},
	{0x04ed & 0xFF, 0x04ed & 0xFF},
	{0x04ef & 0xFF, 0x04ef & 0xFF},
	{0x04f1 & 0xFF, 0x04f1 & 0xFF},
	{0x04f3 & 0xFF, 0x04f3 & 0xFF},
	{0x04f5 & 0xFF, 0x04f5 & 0xFF},
	{0x04f7 & 0xFF, 0x04f7 & 0xFF},
	{0x04f9 & 0xFF, 0x04f9 & 0xFF},
	{0x04fb & 0xFF, 0x04fb & 0xFF},
	{0x04fd & 0xFF, 0x04fd & 0xFF},
	{0x04ff & 0xFF, 0x04ff & 0xFF},
	{0x0501 & 0xFF, 0x0501 & 0xFF},
	{0x0503 & 0xFF, 0x0503 & 0xFF},
	{0x0505 & 0xFF, 0x0505 & 0xFF},
	{0x0507 & 0xFF, 0x0507 & 0xFF},
	{0x0509 & 0xFF, 0x0509 & 0xFF},
	{0x050b & 0xFF, 0x050b & 0xFF},
	{0x050d & 0xFF, 0x050d & 0xFF},
	{0x050f & 0xFF, 0x050f & 0xFF},
	{0x0511 & 0xFF, 0x0511 & 0xFF},
	{0x0513 & 0xFF, 0x0513 & 0xFF},
	{0x0515 & 0xFF, 0x0515 & 0xFF},
	{0x0517 & 0xFF, 0x0517 & 0xFF},
	{0x0519 & 0xFF, 0x0519 & 0xFF},
	{0x051b & 0xFF, 0x051b & 0xFF},
	{0x051d & 0xFF, 0x051d & 0xFF},
	{0x051f & 0xFF, 0x051f & 0xFF},
	{0x0521 & 0xFF, 0x0521 & 0xFF},
	{0x0523 & 0xFF, 0x0523 & 0xFF},
	{0x0525 & 0xFF, 0x0525 & 0xFF},
	{0x0527 & 0xFF, 0x0527 & 0xFF},
	{0x0529 & 0xFF, 0x0529 & 0xFF},
	{0x052b & 0xFF, 0x052b & 0xFF},
	{0x052d & 0xFF, 0x052d & 0xFF},
	{0x052f & 0xFF, 0x052f & 0xFF},
	{0x0561 & 0xFF, 0x0587 & 0xFF},
	{0x10d0 & 0xFF, 0x10fa & 0xFF},
	{0x10fd & 0xFF, 0x10ff & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1d79 & 0xFF, 0x1d79 & 0xFF},
	{0x1d7d & 0xFF, 0x1d7d & 0xFF},
	{0x1d8e & 0xFF, 0x1d8e & 0xFF},
	{0x1e01 & 0xFF, 0x1e01 & 0xFF},
	{0x1e03 & 0xFF, 0x1e03 & 0xFF},
	{0x1e05 & 0xFF, 0x1e05 & 0xFF},
	{0x1e07 & 0xFF, 0x1e07 & 0xFF},
	{0x1e09 & 0xFF, 0x1e09 & 0xFF},
	{0x1e0b & 0xFF, 0x1e0b & 0xFF},
	{0x1e0d & 0xFF, 0x1e0d & 0xFF},
	{0x1e0f & 0xFF, 0x1e0f & 0xFF},
	{0x1e11 & 0xFF, 0x1e11 & 0xFF},
	{0x1e13 & 0xFF, 0x1e13 & 0xFF},
	{0x1e15 & 0xFF, 0x1e15 & 0xFF},
	{0x1e17 & 0xFF, 0x1e17 & 0xFF},
	{0x1e19 & 0xFF, 0x1e19 & 0xFF},
	{0x1e1b & 0xFF, 0x1e1b & 0xFF},
	{0x1e1d & 0xFF, 0x1e1d & 0xFF},
	{0x1e1f & 0xFF, 0x1e1f & 0xFF},
	{0x1e21 & 0xFF, 0x1e21 & 0xFF},
	{0x1e23 & 0xFF, 0x1e23 & 0xFF},
	{0x1e25 & 0xFF, 0x1e25 & 0xFF},
	{0x1e27 & 0xFF, 0x1e27 & 0xFF},
	{0x1e29 & 0xFF, 0x1e29 & 0xFF},
	{0x1e2b & 0xFF, 0x1e2b & 0xFF},
	{0x1e2d & 0xFF, 0x1e2d & 0xFF},
	{0x1e2f & 0xFF, 0x1e2f & 0xFF},
	{0x1e31 & 0xFF, 0x1e31 & 0xFF},
	{0x1e33 & 0xFF, 0x1e33 & 0xFF},
	{0x1e35 & 0xFF, 0x1e35 & 0xFF},
	{0x1e37 & 0xFF, 0x1e37 & 0xFF},
	{0x1e39 & 0xFF, 0x1e39 & 0xFF},
	{0x1e3b & 0xFF, 0x1e3b & 0xFF},
	{0x1e3d & 0xFF, 0x1e3d & 0xFF},
	{0x1e3f & 0xFF, 0x1e3f & 0xFF},
	{0x1e41 & 0xFF, 0x1e41 & 0xFF},
	{0x1e43 & 0xFF, 0x1e43 & 0xFF},
	{0x1e45 & 0xFF, 0x1e45 & 0xFF},
	{0x1e47 & 0xFF, 0x1e47 & 0xFF},
	{0x1e49 & 0xFF, 0x1e49 & 0xFF},
	{0x1e4b & 0xFF, 0x1e4b & 0xFF},
	{0x1e4d & 0xFF, 0x1e4d & 0xFF},
	{0x1e4f & 0xFF, 0x1e4f & 0xFF},
	{0x1e51 & 0xFF, 0x1e51 & 0xFF},
	{0x1e53 & 0xFF, 0x1e53 & 0xFF},
	{0x1e55 & 0xFF, 0x1e55 & 0xFF},
	{0x1e57 & 0xFF, 0x1e57 & 0xFF},
	{0x1e59 & 0xFF, 0x1e59 & 0xFF},
	{0x1e5b & 0xFF, 0x1e5b & 0xFF},
	{0x1e5d & 0xFF, 0x1e5d & 0xFF},
	{0x1e5f & 0xFF, 0x1e5f & 0xFF},
	{0x1e61 & 0xFF, 0x1e61 & 0xFF},
	{0x1e63 & 0xFF, 0x1e63 & 0xFF},
	{0x1e65 & 0xFF, 0x1e65 & 0xFF},
	{0x1e67 & 0xFF, 0x1e67 & 0xFF},
	{0x1e69 & 0xFF, 0x1e69 & 0xFF},
	{0x1e6b & 0xFF, 0x1e6b & 0xFF},
	{0x1e6d & 0xFF, 0x1e6d & 0xFF},
	{0x1e6f & 0xFF, 0x1e6f & 0xFF},
	{0x1e71 & 0xFF, 0x1e71 & 0xFF},
	{0x1e73 & 0xFF, 0x1e73 & 0xFF},
	{0x1e75 & 0xFF, 0x1e75 & 0xFF},
	{0x1e77 & 0xFF, 0x1e77 & 0xFF},
	{0x1e79 & 0xFF, 0x1e79 & 0xFF},
	{0x1e7b & 0xFF, 0x1e7b & 0xFF},
	{0x1e7d & 0xFF, 0x1e7d & 0xFF},
	{0x1e7f & 0xFF, 0x1e7f & 0xFF},
	{0x1e81 & 0xFF, 0x1e81 & 0xFF},
	{0x1e83 & 0xFF, 0x1e83 & 0xFF},
	{0x1e85 & 0xFF, 0x1e85 & 0xFF},
	{0x1e87 & 0xFF, 0x1e87 & 0xFF},
	{0x1e89 & 0xFF, 0x1e89 & 0xFF},
	{0x1e8b & 0xFF, 0x1e8b & 0xFF},
	{0x1e8d & 0xFF, 0x1e8d & 0xFF},
	{0x1e8f & 0xFF, 0x1e8f & 0xFF},
	{0x1e91 & 0xFF, 0x1e91 & 0xFF},
	{0x1e93 & 0xFF, 0x1e93 & 0xFF},
	{0x1e95 & 0xFF, 0x1e9b & 0xFF},
	{0x1ea1 & 0xFF, 0x1ea1 & 0xFF},
	{0x1ea3 & 0xFF, 0x1ea3 & 0xFF},
	{0x1ea5 & 0xFF, 0x1ea5 & 0xFF},
	{0x1ea7 & 0xFF, 0x1ea7 & 0xFF},
	{0x1ea9 & 0xFF, 0x1ea9 & 0xFF},
	{0x1eab & 0xFF, 0x1eab & 0xFF},
	{0x1ead & 0xFF, 0x1ead & 0xFF},
	{0x1eaf & 0xFF, 0x1eaf & 0xFF},
	{0x1eb1 & 0xFF, 0x1eb1 & 0xFF},
	{0x1eb3 & 0xFF, 0x1eb3 & 0xFF},
	{0x1eb5 & 0xFF, 0x1eb5 & 0xFF},
	{0x1eb7 & 0xFF, 0x1eb7 & 0xFF},
	{0x1eb9 & 0xFF, 0x1eb9 & 0xFF},
	{0x1ebb & 0xFF, 0x1ebb & 0xFF},
	{0x1ebd & 0xFF, 0x1ebd & 0xFF},
	{0x1ebf & 0xFF, 0x1ebf & 0xFF},
	{0x1ec1 & 0xFF, 0x1ec1 & 0xFF},
	{0x1ec3 & 0xFF, 0x1ec3 & 0xFF},
	{0x1ec5 & 0xFF, 0x1ec5 & 0xFF},
	{0x1ec7 & 0xFF, 0x1ec7 & 0xFF},
	{0x1ec9 & 0xFF, 0x1ec9 & 0xFF},
	{0x1ecb & 0xFF, 0x1ecb & 0xFF},
	{0x1ecd & 0xFF, 0x1ecd & 0xFF},
	{0x1ecf & 0xFF, 0x1ecf & 0xFF},
	{0x1ed1 & 0xFF, 0x1ed1 & 0xFF},
	{0x1ed3 & 0xFF, 0x1ed3 & 0xFF},
	{0x1ed5 & 0xFF, 0x1ed5 & 0xFF},
	{0x1ed7 & 0xFF, 0x1ed7 & 0xFF},
	{0x1ed9 & 0xFF, 0x1ed9 & 0xFF},
	{0x1edb & 0xFF, 0x1edb & 0xFF},
	{0x1edd & 0xFF, 0x1edd & 0xFF},
	{0x1edf & 0xFF, 0x1edf & 0xFF},
	{0x1ee1 & 0xFF, 0x1ee1 & 0xFF},
	{0x1ee3 & 0xFF, 0x1ee3 & 0xFF},
	{0x1ee5 & 0xFF, 0x1ee5 & 0xFF},
	{0x1ee7 & 0xFF, 0x1ee7 & 0xFF},
	{0x1ee9 & 0xFF, 0x1ee9 & 0xFF},
	{0x1eeb & 0xFF, 0x1eeb & 0xFF},
	{0x1eed & 0xFF, 0x1eed & 0xFF},
	{0x1eef & 0xFF, 0x1eef & 0xFF},
	{0x1ef1 & 0xFF, 0x1ef1 & 0xFF},
	{0x1ef3 & 0xFF, 0x1ef3 & 0xFF},
	{0x1ef5 & 0xFF, 0x1ef5 & 0xFF},
	{0x1ef7 & 0xFF, 0x1ef7 & 0xFF},
	{0x1ef9 & 0xFF, 0x1ef9 & 0xFF},
	{0x1efb & 0xFF, 0x1efb & 0xFF},
	{0x1efd & 0xFF, 0x1efd & 0xFF},
	{0x1eff & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f07 & 0xFF},
	{0x1f10 & 0xFF, 0x1f15 & 0xFF},
	{0x1f20 & 0xFF, 0x1f27 & 0xFF},
	{0x1f30 & 0xFF, 0x1f37 & 0xFF},
	{0x1f40 & 0xFF, 0x1f45 & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f60 & 0xFF, 0x1f67 & 0xFF},
	{0x1f70 & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fb7 & 0xFF},
	{0x1fbc & 0xFF, 0x1fbc & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fc7 & 0xFF},
	{0x1fcc & 0xFF, 0x1fcc & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fd7 & 0xFF},
	{0x1fe0 & 0xFF, 0x1fe7 & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ff7 & 0xFF},
	{0x1ffc & 0xFF, 0x1ffc & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2170 & 0xFF, 0x217f & 0xFF},
	{0x2184 & 0xFF, 0x2184 & 0xFF},
	{0x24d0 & 0xFF, 0x24e9 & 0xFF},
	{0x2c30 & 0xFF, 0x2c5f & 0xFF},
	{0x2c61 & 0xFF, 0x2c61 & 0xFF},
	{0x2c65 & 0xFF, 0x2c66 & 0xFF},
	{0x2c68 & 0xFF, 0x2c68 & 0xFF},
	{0x2c6a & 0xFF, 0x2c6a & 0xFF},
	{0x2c6c & 0xFF, 0x2c6c & 0xFF},
	{0x2c73 & 0xFF, 0x2c73 & 0xFF},
	{0x2c76 & 0xFF, 0x2c76 & 0xFF},
	{0x2c81 & 0xFF, 0x2c81 & 0xFF},
	{0x2c83 & 0xFF, 0x2c83 & 0xFF},
	{0x2c85 & 0xFF, 0x2c85 & 0xFF},
	{0x2c87 & 0xFF, 0x2c87 & 0xFF},
	{0x2c89 & 0xFF, 0x2c89 & 0xFF},
	{0x2c8b & 0xFF, 0x2c8b & 0xFF},
	{0x2c8d & 0xFF, 0x2c8d & 0xFF},
	{0x2c8f & 0xFF, 0x2c8f & 0xFF},
	{0x2c91 & 0xFF, 0x2c91 & 0xFF},
	{0x2c93 & 0xFF, 0x2c93 & 0xFF},
	{0x2c95 & 0xFF, 0x2c95 & 0xFF},
	{0x2c97 & 0xFF, 0x2c97 & 0xFF},
	{0x2c99 & 0xFF, 0x2c99 & 0xFF},
	{0x2c9b & 0xFF, 0x2c9b & 0xFF},
	{0x2c9d & 0xFF, 0x2c9d & 0xFF},
	{0x2c9f & 0xFF, 0x2c9f & 0xFF},
	{0x2ca1 & 0xFF, 0x2ca1 & 0xFF},
	{0x2ca3 & 0xFF, 0x2ca3 & 0xFF},
	{0x2ca5 & 0xFF, 0x2ca5 & 0xFF},
	{0x2ca7 & 0xFF, 0x2ca7 & 0xFF},
	{0x2ca9 & 0xFF, 0x2ca9 & 0xFF},
	{0x2cab & 0xFF, 0x2cab & 0xFF},
	{0x2cad & 0xFF, 0x2cad & 0xFF},
	{0x2caf & 0xFF, 0x2caf & 0xFF},
	{0x2cb1 & 0xFF, 0x2cb1 & 0xFF},
	{0x2cb3 & 0xFF, 0x2cb3 & 0xFF},
	{0x2cb5 & 0xFF, 0x2cb5 & 0xFF},
	{0x2cb7 & 0xFF, 0x2cb7 & 0xFF},
	{0x2cb9 & 0xFF, 0x2cb9 & 0xFF},
	{0x2cbb & 0xFF, 0x2cbb & 0xFF},
	{0x2cbd & 0xFF, 0x2cbd & 0xFF},
	{0x2cbf & 0xFF, 0x2cbf & 0xFF},
	{0x2cc1 & 0xFF, 0x2cc1 & 0xFF},
	{0x2cc3 & 0xFF, 0x2cc3 & 0xFF},
	{0x2cc5 & 0xFF, 0x2cc5 & 0xFF},
	{0x2cc7 & 0xFF, 0x2cc7 & 0xFF},
	{0x2cc9 & 0xFF, 0x2cc9 & 0xFF},
	{0x2ccb & 0xFF, 0x2ccb & 0xFF},
	{0x2ccd & 0xFF, 0x2ccd & 0xFF},
	{0x2ccf & 0xFF, 0x2ccf & 0xFF},
	{0x2cd1 & 0xFF, 0x2cd1 & 0xFF},
	{0x2cd3 & 0xFF, 0x2cd3 & 0xFF},
	{0x2cd5 & 0xFF, 0x2cd5 & 0xFF},
	{0x2cd7 & 0xFF, 0x2cd7 & 0xFF},
	{0x2cd9 & 0xFF, 0x2cd9 & 0xFF},
	{0x2cdb & 0xFF, 0x2cdb & 0xFF},
	{0x2cdd & 0xFF, 0x2cdd & 0xFF},
	{0x2cdf & 0xFF, 0x2cdf & 0xFF},
	{0x2ce1 & 0xFF, 0x2ce1 & 0xFF},
	{0x2ce3 & 0xFF, 0x2ce3 & 0xFF},
	{0x2cec & 0xFF, 0x2cec & 0xFF},
	{0x2cee & 0xFF, 0x2cee & 0xFF},
	{0x2cf3 & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0xa641 & 0xFF, 0xa641 & 0xFF},
	{0xa643 & 0xFF, 0xa643 & 0xFF},
	{0xa645 & 0xFF, 0xa645 & 0xFF},
	{0xa647 & 0xFF, 0xa647 & 0xFF},
	{0xa649 & 0xFF, 0xa649 & 0xFF},
	{0xa64b & 0xFF, 0xa64b & 0xFF},
	{0xa64d & 0xFF, 0xa64d & 0xFF},
	{0xa64f & 0xFF, 0xa64f & 0xFF},
	{0xa651 & 0xFF, 0xa651 & 0xFF},
	{0xa653 & 0xFF, 0xa653 & 0xFF},
	{0xa655 & 0xFF, 0xa655 & 0xFF},
	{0xa657 & 0xFF, 0xa657 & 0xFF},
	{0xa659 & 0xFF, 0xa659 & 0xFF},
	{0xa65b & 0xFF, 0xa65b & 0xFF},
	{0xa65d & 0xFF, 0xa65d & 0xFF},
	{0xa65f & 0xFF, 0xa65f & 0xFF},
	{0xa661 & 0xFF, 0xa661 & 0xFF},
	{0xa663 & 0xFF, 0xa663 & 0xFF},
	{0xa665 & 0xFF, 0xa665 & 0xFF},
	{0xa667 & 0xFF, 0xa667 & 0xFF},
	{0xa669 & 0xFF, 0xa669 & 0xFF},
	{0xa66b & 0xFF, 0xa66b & 0xFF},
	{0xa66d & 0xFF, 0xa66d & 0xFF},
	{0xa681 & 0xFF, 0xa681 & 0xFF},
	{0xa683 & 0xFF, 0xa683 & 0xFF},
	{0xa685 & 0xFF, 0xa685 & 0xFF},
	{0xa687 & 0xFF, 0xa687 & 0xFF},
	{0xa689 & 0xFF, 0xa689 & 0xFF},
	{0xa68b & 0xFF, 0xa68b & 0xFF},
	{0xa68d & 0xFF, 0xa68d & 0xFF},
	{0xa68f & 0xFF, 0xa68f & 0xFF},
	{0xa691 & 0xFF, 0xa691 & 0xFF},
	{0xa693 & 0xFF, 0xa693 & 0xFF},
	{0xa695 & 0xFF, 0xa695 & 0xFF},
	{0xa697 & 0xFF, 0xa697 & 0xFF},
	{0xa699 & 0xFF, 0xa699 & 0xFF},
	{0xa69b & 0xFF, 0xa69b & 0xFF},
	{0xa723 & 0xFF, 0xa723 & 0xFF},
	{0xa725 & 0xFF, 0xa725 & 0xFF},
	{0xa727 & 0xFF, 0xa727 & 0xFF},
	{0xa729 & 0xFF, 0xa729 & 0xFF},
	{0xa72b & 0xFF, 0xa72b & 0xFF},
	{0xa72d & 0xFF, 0xa72d & 0xFF},
	{0xa72f & 0xFF, 0xa72f & 0xFF},
	{0xa733 & 0xFF, 0xa733 & 0xFF},
	{0xa735 & 0xFF, 0xa735 & 0xFF},
	{0xa737 & 0xFF, 0xa737 & 0xFF},
	{0xa739 & 0xFF, 0xa739 & 0xFF},
	{0xa73b & 0xFF, 0xa73b & 0xFF},
	{0xa73d & 0xFF, 0xa73d & 0xFF},
	{0xa73f & 0xFF, 0xa73f & 0xFF},
	{0xa741 & 0xFF, 0xa741 & 0xFF},
	{0xa743 & 0xFF, 0xa743 & 0xFF},
	{0xa745 & 0xFF, 0xa745 & 0xFF},
	{0xa747 & 0xFF, 0xa747 & 0xFF},
	{0xa749 & 0xFF, 0xa749 & 0xFF},
	{0xa74b & 0xFF, 0xa74b & 0xFF},
	{0xa74d & 0xFF, 0xa74d & 0xFF},
	{0xa74f & 0xFF, 0xa74f & 0xFF},
	{0xa751 & 0xFF, 0xa751 & 0xFF},
	{0xa753 & 0xFF, 0xa753 & 0xFF},
	{0xa755 & 0xFF, 0xa755 & 0xFF},
	{0xa757 & 0xFF, 0xa757 & 0xFF},
	{0xa759 & 0xFF, 0xa759 & 0xFF},
	{0xa75b & 0xFF, 0xa75b & 0xFF},
	{0xa75d & 0xFF, 0xa75d & 0xFF},
	{0xa75f & 0xFF, 0xa75f & 0xFF},
	{0xa761 & 0xFF, 0xa761 & 0xFF},
	{0xa763 & 0xFF, 0xa763 & 0xFF},
	{0xa765 & 0xFF, 0xa765 & 0xFF},
	{0xa767 & 0xFF, 0xa767 & 0xFF},
	{0xa769 & 0xFF, 0xa769 & 0xFF},
	{0xa76b & 0xFF, 0xa76b & 0xFF},
	{0xa76d & 0xFF, 0xa76d & 0xFF},
	{0xa76f & 0xFF, 0xa76f & 0xFF},
	{0xa77a & 0xFF, 0xa77a & 0xFF},
	{0xa77c & 0xFF, 0xa77c & 0xFF},
	{0xa77f & 0xFF, 0xa77f & 0xFF},
	{0xa781 & 0xFF, 0xa781 & 0xFF},
	{0xa783 & 0xFF, 0xa783 & 0xFF},
	{0xa785 & 0xFF, 0xa785 & 0xFF},
	{0xa787 & 0xFF, 0xa787 & 0xFF},
	{0xa78c & 0xFF, 0xa78c & 0xFF},
	{0xa791 & 0xFF, 0xa791 & 0xFF},
	{0xa793 & 0xFF, 0xa794 & 0xFF},
	{0xa797 & 0xFF, 0xa797 & 0xFF},
	{0xa799 & 0xFF, 0xa799 & 0xFF},
	{0xa79b & 0xFF, 0xa79b & 0xFF},
	{0xa79d & 0xFF, 0xa79d & 0xFF},
	{0xa79f & 0xFF, 0xa79f & 0xFF},
	{0xa7a1 & 0xFF, 0xa7a1 & 0xFF},
	{0xa7a3 & 0xFF, 0xa7a3 & 0xFF},
	{0xa7a5 & 0xFF, 0xa7a5 & 0xFF},
	{0xa7a7 & 0xFF, 0xa7a7 & 0xFF},
	{0xa7a9 & 0xFF, 0xa7a9 & 0xFF},
	{0xa7b5 & 0xFF, 0xa7b5 & 0xFF},
	{0xa7b7 & 0xFF, 0xa7b7 & 0xFF},
	{0xa7b9 & 0xFF, 0xa7b9 & 0xFF},
	{0xa7bb & 0xFF, 0xa7bb & 0xFF},
	{0xa7bd & 0xFF, 0xa7bd & 0xFF},
	{0xa7bf & 0xFF, 0xa7bf & 0xFF},
	{0xa7c1 & 0xFF, 0xa7c1 & 0xFF},
	{0xa7c3 & 0xFF, 0xa7c3 & 0xFF},
	{0xa7c8 & 0xFF, 0xa7c8 & 0xFF},
	{0xa7ca & 0xFF, 0xa7ca & 0xFF},
	{0xa7d1 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d7 & 0xFF, 0xa7d7 & 0xFF},
	{0xa7d9 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f6 & 0xFF, 0xa7f6 & 0xFF},
	{0xab53 & 0xFF, 0xab53 & 0xFF},
	{0xab70 & 0xFF, 0xabbf & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0x10428 & 0xFF, 0x1044f & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x118c0 & 0xFF, 0x118df & 0xFF},
	{0x16e60 & 0xFF, 0x16e7f & 0xFF},
	{0x1e922 & 0xFF, 0x1e943 & 0xFF}};

static const size_t Changes_When_Uppercased_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	16,
	19,
	28,
	29,
	30,
	31,
	33,
	36,
	44,
	45,
	166,
	167,
	171,
	251,
	255,
	260,
	261,
	268,
	280,
	366,
	489
};

static const char32_t Changes_When_Uppercased_starting_pagetab[]={
	0,
	4,
	111,
	160,
	184,
	260,
	285,
	287,
	288,
	289,
	292,
	415,
	436,
	439,
	440,
	501,
	504,
	541,
	613,
	615,
	617,
	618,
	620,
	624,
	625,
	626,
	627
};

static const uint8_t Default_Ignorable_Code_Point_rangetab[][2]={
	{0x00ad & 0xFF, 0x00ad & 0xFF},
	{0x034f & 0xFF, 0x034f & 0xFF},
	{0x061c & 0xFF, 0x061c & 0xFF},
	{0x115f & 0xFF, 0x1160 & 0xFF},
	{0x17b4 & 0xFF, 0x17b5 & 0xFF},
	{0x180b & 0xFF, 0x180f & 0xFF},
	{0x200b & 0xFF, 0x200f & 0xFF},
	{0x202a & 0xFF, 0x202e & 0xFF},
	{0x2060 & 0xFF, 0x206f & 0xFF},
	{0x3164 & 0xFF, 0x3164 & 0xFF},
	{0xfe00 & 0xFF, 0xfe0f & 0xFF},
	{0xfeff & 0xFF, 0xfeff & 0xFF},
	{0xffa0 & 0xFF, 0xffa0 & 0xFF},
	{0xfff0 & 0xFF, 0xfff8 & 0xFF},
	{0x1bca0 & 0xFF, 0x1bca3 & 0xFF},
	{0x1d173 & 0xFF, 0x1d17a & 0xFF},
	{0xe0000 & 0xFF, 0xe00ff & 0xFF},
	{0xe0100 & 0xFF, 0xe01ff & 0xFF},
	{0xe0200 & 0xFF, 0xe02ff & 0xFF},
	{0xe0300 & 0xFF, 0xe03ff & 0xFF},
	{0xe0400 & 0xFF, 0xe04ff & 0xFF},
	{0xe0500 & 0xFF, 0xe05ff & 0xFF},
	{0xe0600 & 0xFF, 0xe06ff & 0xFF},
	{0xe0700 & 0xFF, 0xe07ff & 0xFF},
	{0xe0800 & 0xFF, 0xe08ff & 0xFF},
	{0xe0900 & 0xFF, 0xe09ff & 0xFF},
	{0xe0a00 & 0xFF, 0xe0aff & 0xFF},
	{0xe0b00 & 0xFF, 0xe0bff & 0xFF},
	{0xe0c00 & 0xFF, 0xe0cff & 0xFF},
	{0xe0d00 & 0xFF, 0xe0dff & 0xFF},
	{0xe0e00 & 0xFF, 0xe0eff & 0xFF},
	{0xe0f00 & 0xFF, 0xe0fff & 0xFF}};

static const size_t Default_Ignorable_Code_Point_starting_indextab[]={
	0,
	3,
	6,
	17,
	23,
	24,
	32,
	49,
	254,
	255,
	444,
	465,
	3584,
	3585,
	3586,
	3587,
	3588,
	3589,
	3590,
	3591,
	3592,
	3593,
	3594,
	3595,
	3596,
	3597,
	3598,
	3599
};

static const char32_t Default_Ignorable_Code_Point_starting_pagetab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	6,
	9,
	10,
	12,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	30,
	31
};

static const uint8_t Grapheme_Base_rangetab[][2]={
	{0x0020 & 0xFF, 0x007e & 0xFF},
	{0x00a0 & 0xFF, 0x00ac & 0xFF},
	{0x00ae & 0xFF, 0x00ff & 0xFF},
	{0x0100 & 0xFF, 0x01ff & 0xFF},
	{0x0200 & 0xFF, 0x02ff & 0xFF},
	{0x0370 & 0xFF, 0x0377 & 0xFF},
	{0x037a & 0xFF, 0x037f & 0xFF},
	{0x0384 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x0482 & 0xFF},
	{0x048a & 0xFF, 0x04ff & 0xFF},
	{0x0500 & 0xFF, 0x052f & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x0559 & 0xFF, 0x058a & 0xFF},
	{0x058d & 0xFF, 0x058f & 0xFF},
	{0x05be & 0xFF, 0x05be & 0xFF},
	{0x05c0 & 0xFF, 0x05c0 & 0xFF},
	{0x05c3 & 0xFF, 0x05c3 & 0xFF},
	{0x05c6 & 0xFF, 0x05c6 & 0xFF},
	{0x05d0 & 0xFF, 0x05ea & 0xFF},
	{0x05ef & 0xFF, 0x05f4 & 0xFF},
	{0x0606 & 0xFF, 0x060f & 0xFF},
	{0x061b & 0xFF, 0x061b & 0xFF},
	{0x061d & 0xFF, 0x064a & 0xFF},
	{0x0660 & 0xFF, 0x066f & 0xFF},
	{0x0671 & 0xFF, 0x06d5 & 0xFF},
	{0x06de & 0xFF, 0x06de & 0xFF},
	{0x06e5 & 0xFF, 0x06e6 & 0xFF},
	{0x06e9 & 0xFF, 0x06e9 & 0xFF},
	{0x06ee & 0xFF, 0x06ff & 0xFF},
	{0x0700 & 0xFF, 0x070d & 0xFF},
	{0x0710 & 0xFF, 0x0710 & 0xFF},
	{0x0712 & 0xFF, 0x072f & 0xFF},
	{0x074d & 0xFF, 0x07a5 & 0xFF},
	{0x07b1 & 0xFF, 0x07b1 & 0xFF},
	{0x07c0 & 0xFF, 0x07ea & 0xFF},
	{0x07f4 & 0xFF, 0x07fa & 0xFF},
	{0x07fe & 0xFF, 0x07ff & 0xFF},
	{0x0800 & 0xFF, 0x0815 & 0xFF},
	{0x081a & 0xFF, 0x081a & 0xFF},
	{0x0824 & 0xFF, 0x0824 & 0xFF},
	{0x0828 & 0xFF, 0x0828 & 0xFF},
	{0x0830 & 0xFF, 0x083e & 0xFF},
	{0x0840 & 0xFF, 0x0858 & 0xFF},
	{0x085e & 0xFF, 0x085e & 0xFF},
	{0x0860 & 0xFF, 0x086a & 0xFF},
	{0x0870 & 0xFF, 0x088e & 0xFF},
	{0x08a0 & 0xFF, 0x08c9 & 0xFF},
	{0x0903 & 0xFF, 0x0939 & 0xFF},
	{0x093b & 0xFF, 0x093b & 0xFF},
	{0x093d & 0xFF, 0x0940 & 0xFF},
	{0x0949 & 0xFF, 0x094c & 0xFF},
	{0x094e & 0xFF, 0x0950 & 0xFF},
	{0x0958 & 0xFF, 0x0961 & 0xFF},
	{0x0964 & 0xFF, 0x0980 & 0xFF},
	{0x0982 & 0xFF, 0x0983 & 0xFF},
	{0x0985 & 0xFF, 0x098c & 0xFF},
	{0x098f & 0xFF, 0x0990 & 0xFF},
	{0x0993 & 0xFF, 0x09a8 & 0xFF},
	{0x09aa & 0xFF, 0x09b0 & 0xFF},
	{0x09b2 & 0xFF, 0x09b2 & 0xFF},
	{0x09b6 & 0xFF, 0x09b9 & 0xFF},
	{0x09bd & 0xFF, 0x09bd & 0xFF},
	{0x09bf & 0xFF, 0x09c0 & 0xFF},
	{0x09c7 & 0xFF, 0x09c8 & 0xFF},
	{0x09cb & 0xFF, 0x09cc & 0xFF},
	{0x09ce & 0xFF, 0x09ce & 0xFF},
	{0x09dc & 0xFF, 0x09dd & 0xFF},
	{0x09df & 0xFF, 0x09e1 & 0xFF},
	{0x09e6 & 0xFF, 0x09fd & 0xFF},
	{0x0a03 & 0xFF, 0x0a03 & 0xFF},
	{0x0a05 & 0xFF, 0x0a0a & 0xFF},
	{0x0a0f & 0xFF, 0x0a10 & 0xFF},
	{0x0a13 & 0xFF, 0x0a28 & 0xFF},
	{0x0a2a & 0xFF, 0x0a30 & 0xFF},
	{0x0a32 & 0xFF, 0x0a33 & 0xFF},
	{0x0a35 & 0xFF, 0x0a36 & 0xFF},
	{0x0a38 & 0xFF, 0x0a39 & 0xFF},
	{0x0a3e & 0xFF, 0x0a40 & 0xFF},
	{0x0a59 & 0xFF, 0x0a5c & 0xFF},
	{0x0a5e & 0xFF, 0x0a5e & 0xFF},
	{0x0a66 & 0xFF, 0x0a6f & 0xFF},
	{0x0a72 & 0xFF, 0x0a74 & 0xFF},
	{0x0a76 & 0xFF, 0x0a76 & 0xFF},
	{0x0a83 & 0xFF, 0x0a83 & 0xFF},
	{0x0a85 & 0xFF, 0x0a8d & 0xFF},
	{0x0a8f & 0xFF, 0x0a91 & 0xFF},
	{0x0a93 & 0xFF, 0x0aa8 & 0xFF},
	{0x0aaa & 0xFF, 0x0ab0 & 0xFF},
	{0x0ab2 & 0xFF, 0x0ab3 & 0xFF},
	{0x0ab5 & 0xFF, 0x0ab9 & 0xFF},
	{0x0abd & 0xFF, 0x0ac0 & 0xFF},
	{0x0ac9 & 0xFF, 0x0ac9 & 0xFF},
	{0x0acb & 0xFF, 0x0acc & 0xFF},
	{0x0ad0 & 0xFF, 0x0ad0 & 0xFF},
	{0x0ae0 & 0xFF, 0x0ae1 & 0xFF},
	{0x0ae6 & 0xFF, 0x0af1 & 0xFF},
	{0x0af9 & 0xFF, 0x0af9 & 0xFF},
	{0x0b02 & 0xFF, 0x0b03 & 0xFF},
	{0x0b05 & 0xFF, 0x0b0c & 0xFF},
	{0x0b0f & 0xFF, 0x0b10 & 0xFF},
	{0x0b13 & 0xFF, 0x0b28 & 0xFF},
	{0x0b2a & 0xFF, 0x0b30 & 0xFF},
	{0x0b32 & 0xFF, 0x0b33 & 0xFF},
	{0x0b35 & 0xFF, 0x0b39 & 0xFF},
	{0x0b3d & 0xFF, 0x0b3d & 0xFF},
	{0x0b40 & 0xFF, 0x0b40 & 0xFF},
	{0x0b47 & 0xFF, 0x0b48 & 0xFF},
	{0x0b4b & 0xFF, 0x0b4c & 0xFF},
	{0x0b5c & 0xFF, 0x0b5d & 0xFF},
	{0x0b5f & 0xFF, 0x0b61 & 0xFF},
	{0x0b66 & 0xFF, 0x0b77 & 0xFF},
	{0x0b83 & 0xFF, 0x0b83 & 0xFF},
	{0x0b85 & 0xFF, 0x0b8a & 0xFF},
	{0x0b8e & 0xFF, 0x0b90 & 0xFF},
	{0x0b92 & 0xFF, 0x0b95 & 0xFF},
	{0x0b99 & 0xFF, 0x0b9a & 0xFF},
	{0x0b9c & 0xFF, 0x0b9c & 0xFF},
	{0x0b9e & 0xFF, 0x0b9f & 0xFF},
	{0x0ba3 & 0xFF, 0x0ba4 & 0xFF},
	{0x0ba8 & 0xFF, 0x0baa & 0xFF},
	{0x0bae & 0xFF, 0x0bb9 & 0xFF},
	{0x0bbf & 0xFF, 0x0bbf & 0xFF},
	{0x0bc1 & 0xFF, 0x0bc2 & 0xFF},
	{0x0bc6 & 0xFF, 0x0bc8 & 0xFF},
	{0x0bca & 0xFF, 0x0bcc & 0xFF},
	{0x0bd0 & 0xFF, 0x0bd0 & 0xFF},
	{0x0be6 & 0xFF, 0x0bfa & 0xFF},
	{0x0c01 & 0xFF, 0x0c03 & 0xFF},
	{0x0c05 & 0xFF, 0x0c0c & 0xFF},
	{0x0c0e & 0xFF, 0x0c10 & 0xFF},
	{0x0c12 & 0xFF, 0x0c28 & 0xFF},
	{0x0c2a & 0xFF, 0x0c39 & 0xFF},
	{0x0c3d & 0xFF, 0x0c3d & 0xFF},
	{0x0c41 & 0xFF, 0x0c44 & 0xFF},
	{0x0c58 & 0xFF, 0x0c5a & 0xFF},
	{0x0c5d & 0xFF, 0x0c5d & 0xFF},
	{0x0c60 & 0xFF, 0x0c61 & 0xFF},
	{0x0c66 & 0xFF, 0x0c6f & 0xFF},
	{0x0c77 & 0xFF, 0x0c80 & 0xFF},
	{0x0c82 & 0xFF, 0x0c8c & 0xFF},
	{0x0c8e & 0xFF, 0x0c90 & 0xFF},
	{0x0c92 & 0xFF, 0x0ca8 & 0xFF},
	{0x0caa & 0xFF, 0x0cb3 & 0xFF},
	{0x0cb5 & 0xFF, 0x0cb9 & 0xFF},
	{0x0cbd & 0xFF, 0x0cbe & 0xFF},
	{0x0cc0 & 0xFF, 0x0cc1 & 0xFF},
	{0x0cc3 & 0xFF, 0x0cc4 & 0xFF},
	{0x0cc7 & 0xFF, 0x0cc8 & 0xFF},
	{0x0cca & 0xFF, 0x0ccb & 0xFF},
	{0x0cdd & 0xFF, 0x0cde & 0xFF},
	{0x0ce0 & 0xFF, 0x0ce1 & 0xFF},
	{0x0ce6 & 0xFF, 0x0cef & 0xFF},
	{0x0cf1 & 0xFF, 0x0cf3 & 0xFF},
	{0x0d02 & 0xFF, 0x0d0c & 0xFF},
	{0x0d0e & 0xFF, 0x0d10 & 0xFF},
	{0x0d12 & 0xFF, 0x0d3a & 0xFF},
	{0x0d3d & 0xFF, 0x0d3d & 0xFF},
	{0x0d3f & 0xFF, 0x0d40 & 0xFF},
	{0x0d46 & 0xFF, 0x0d48 & 0xFF},
	{0x0d4a & 0xFF, 0x0d4c & 0xFF},
	{0x0d4e & 0xFF, 0x0d4f & 0xFF},
	{0x0d54 & 0xFF, 0x0d56 & 0xFF},
	{0x0d58 & 0xFF, 0x0d61 & 0xFF},
	{0x0d66 & 0xFF, 0x0d7f & 0xFF},
	{0x0d82 & 0xFF, 0x0d83 & 0xFF},
	{0x0d85 & 0xFF, 0x0d96 & 0xFF},
	{0x0d9a & 0xFF, 0x0db1 & 0xFF},
	{0x0db3 & 0xFF, 0x0dbb & 0xFF},
	{0x0dbd & 0xFF, 0x0dbd & 0xFF},
	{0x0dc0 & 0xFF, 0x0dc6 & 0xFF},
	{0x0dd0 & 0xFF, 0x0dd1 & 0xFF},
	{0x0dd8 & 0xFF, 0x0dde & 0xFF},
	{0x0de6 & 0xFF, 0x0def & 0xFF},
	{0x0df2 & 0xFF, 0x0df4 & 0xFF},
	{0x0e01 & 0xFF, 0x0e30 & 0xFF},
	{0x0e32 & 0xFF, 0x0e33 & 0xFF},
	{0x0e3f & 0xFF, 0x0e46 & 0xFF},
	{0x0e4f & 0xFF, 0x0e5b & 0xFF},
	{0x0e81 & 0xFF, 0x0e82 & 0xFF},
	{0x0e84 & 0xFF, 0x0e84 & 0xFF},
	{0x0e86 & 0xFF, 0x0e8a & 0xFF},
	{0x0e8c & 0xFF, 0x0ea3 & 0xFF},
	{0x0ea5 & 0xFF, 0x0ea5 & 0xFF},
	{0x0ea7 & 0xFF, 0x0eb0 & 0xFF},
	{0x0eb2 & 0xFF, 0x0eb3 & 0xFF},
	{0x0ebd & 0xFF, 0x0ebd & 0xFF},
	{0x0ec0 & 0xFF, 0x0ec4 & 0xFF},
	{0x0ec6 & 0xFF, 0x0ec6 & 0xFF},
	{0x0ed0 & 0xFF, 0x0ed9 & 0xFF},
	{0x0edc & 0xFF, 0x0edf & 0xFF},
	{0x0f00 & 0xFF, 0x0f17 & 0xFF},
	{0x0f1a & 0xFF, 0x0f34 & 0xFF},
	{0x0f36 & 0xFF, 0x0f36 & 0xFF},
	{0x0f38 & 0xFF, 0x0f38 & 0xFF},
	{0x0f3a & 0xFF, 0x0f47 & 0xFF},
	{0x0f49 & 0xFF, 0x0f6c & 0xFF},
	{0x0f7f & 0xFF, 0x0f7f & 0xFF},
	{0x0f85 & 0xFF, 0x0f85 & 0xFF},
	{0x0f88 & 0xFF, 0x0f8c & 0xFF},
	{0x0fbe & 0xFF, 0x0fc5 & 0xFF},
	{0x0fc7 & 0xFF, 0x0fcc & 0xFF},
	{0x0fce & 0xFF, 0x0fda & 0xFF},
	{0x1000 & 0xFF, 0x102c & 0xFF},
	{0x1031 & 0xFF, 0x1031 & 0xFF},
	{0x1038 & 0xFF, 0x1038 & 0xFF},
	{0x103b & 0xFF, 0x103c & 0xFF},
	{0x103f & 0xFF, 0x1057 & 0xFF},
	{0x105a & 0xFF, 0x105d & 0xFF},
	{0x1061 & 0xFF, 0x1070 & 0xFF},
	{0x1075 & 0xFF, 0x1081 & 0xFF},
	{0x1083 & 0xFF, 0x1084 & 0xFF},
	{0x1087 & 0xFF, 0x108c & 0xFF},
	{0x108e & 0xFF, 0x109c & 0xFF},
	{0x109e & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x10d0 & 0xFF, 0x10ff & 0xFF},
	{0x1100 & 0xFF, 0x11ff & 0xFF},
	{0x1200 & 0xFF, 0x1248 & 0xFF},
	{0x124a & 0xFF, 0x124d & 0xFF},
	{0x1250 & 0xFF, 0x1256 & 0xFF},
	{0x1258 & 0xFF, 0x1258 & 0xFF},
	{0x125a & 0xFF, 0x125d & 0xFF},
	{0x1260 & 0xFF, 0x1288 & 0xFF},
	{0x128a & 0xFF, 0x128d & 0xFF},
	{0x1290 & 0xFF, 0x12b0 & 0xFF},
	{0x12b2 & 0xFF, 0x12b5 & 0xFF},
	{0x12b8 & 0xFF, 0x12be & 0xFF},
	{0x12c0 & 0xFF, 0x12c0 & 0xFF},
	{0x12c2 & 0xFF, 0x12c5 & 0xFF},
	{0x12c8 & 0xFF, 0x12d6 & 0xFF},
	{0x12d8 & 0xFF, 0x12ff & 0xFF},
	{0x1300 & 0xFF, 0x1310 & 0xFF},
	{0x1312 & 0xFF, 0x1315 & 0xFF},
	{0x1318 & 0xFF, 0x135a & 0xFF},
	{0x1360 & 0xFF, 0x137c & 0xFF},
	{0x1380 & 0xFF, 0x1399 & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1400 & 0xFF, 0x14ff & 0xFF},
	{0x1500 & 0xFF, 0x15ff & 0xFF},
	{0x1600 & 0xFF, 0x169c & 0xFF},
	{0x16a0 & 0xFF, 0x16f8 & 0xFF},
	{0x1700 & 0xFF, 0x1711 & 0xFF},
	{0x1715 & 0xFF, 0x1715 & 0xFF},
	{0x171f & 0xFF, 0x1731 & 0xFF},
	{0x1734 & 0xFF, 0x1736 & 0xFF},
	{0x1740 & 0xFF, 0x1751 & 0xFF},
	{0x1760 & 0xFF, 0x176c & 0xFF},
	{0x176e & 0xFF, 0x1770 & 0xFF},
	{0x1780 & 0xFF, 0x17b3 & 0xFF},
	{0x17b6 & 0xFF, 0x17b6 & 0xFF},
	{0x17be & 0xFF, 0x17c5 & 0xFF},
	{0x17c7 & 0xFF, 0x17c8 & 0xFF},
	{0x17d4 & 0xFF, 0x17dc & 0xFF},
	{0x17e0 & 0xFF, 0x17e9 & 0xFF},
	{0x17f0 & 0xFF, 0x17f9 & 0xFF},
	{0x1800 & 0xFF, 0x180a & 0xFF},
	{0x1810 & 0xFF, 0x1819 & 0xFF},
	{0x1820 & 0xFF, 0x1878 & 0xFF},
	{0x1880 & 0xFF, 0x1884 & 0xFF},
	{0x1887 & 0xFF, 0x18a8 & 0xFF},
	{0x18aa & 0xFF, 0x18aa & 0xFF},
	{0x18b0 & 0xFF, 0x18f5 & 0xFF},
	{0x1900 & 0xFF, 0x191e & 0xFF},
	{0x1923 & 0xFF, 0x1926 & 0xFF},
	{0x1929 & 0xFF, 0x192b & 0xFF},
	{0x1930 & 0xFF, 0x1931 & 0xFF},
	{0x1933 & 0xFF, 0x1938 & 0xFF},
	{0x1940 & 0xFF, 0x1940 & 0xFF},
	{0x1944 & 0xFF, 0x196d & 0xFF},
	{0x1970 & 0xFF, 0x1974 & 0xFF},
	{0x1980 & 0xFF, 0x19ab & 0xFF},
	{0x19b0 & 0xFF, 0x19c9 & 0xFF},
	{0x19d0 & 0xFF, 0x19da & 0xFF},
	{0x19de & 0xFF, 0x19ff & 0xFF},
	{0x1a00 & 0xFF, 0x1a16 & 0xFF},
	{0x1a19 & 0xFF, 0x1a1a & 0xFF},
	{0x1a1e & 0xFF, 0x1a55 & 0xFF},
	{0x1a57 & 0xFF, 0x1a57 & 0xFF},
	{0x1a61 & 0xFF, 0x1a61 & 0xFF},
	{0x1a63 & 0xFF, 0x1a64 & 0xFF},
	{0x1a6d & 0xFF, 0x1a72 & 0xFF},
	{0x1a80 & 0xFF, 0x1a89 & 0xFF},
	{0x1a90 & 0xFF, 0x1a99 & 0xFF},
	{0x1aa0 & 0xFF, 0x1aad & 0xFF},
	{0x1b04 & 0xFF, 0x1b33 & 0xFF},
	{0x1b3b & 0xFF, 0x1b3b & 0xFF},
	{0x1b3d & 0xFF, 0x1b41 & 0xFF},
	{0x1b43 & 0xFF, 0x1b4c & 0xFF},
	{0x1b50 & 0xFF, 0x1b6a & 0xFF},
	{0x1b74 & 0xFF, 0x1b7e & 0xFF},
	{0x1b82 & 0xFF, 0x1ba1 & 0xFF},
	{0x1ba6 & 0xFF, 0x1ba7 & 0xFF},
	{0x1baa & 0xFF, 0x1baa & 0xFF},
	{0x1bae & 0xFF, 0x1be5 & 0xFF},
	{0x1be7 & 0xFF, 0x1be7 & 0xFF},
	{0x1bea & 0xFF, 0x1bec & 0xFF},
	{0x1bee & 0xFF, 0x1bee & 0xFF},
	{0x1bf2 & 0xFF, 0x1bf3 & 0xFF},
	{0x1bfc & 0xFF, 0x1bff & 0xFF},
	{0x1c00 & 0xFF, 0x1c2b & 0xFF},
	{0x1c34 & 0xFF, 0x1c35 & 0xFF},
	{0x1c3b & 0xFF, 0x1c49 & 0xFF},
	{0x1c4d & 0xFF, 0x1c88 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cc7 & 0xFF},
	{0x1cd3 & 0xFF, 0x1cd3 & 0xFF},
	{0x1ce1 & 0xFF, 0x1ce1 & 0xFF},
	{0x1ce9 & 0xFF, 0x1cec & 0xFF},
	{0x1cee & 0xFF, 0x1cf3 & 0xFF},
	{0x1cf5 & 0xFF, 0x1cf7 & 0xFF},
	{0x1cfa & 0xFF, 0x1cfa & 0xFF},
	{0x1d00 & 0xFF, 0x1dbf & 0xFF},
	{0x1e00 & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f15 & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f20 & 0xFF, 0x1f45 & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fdb & 0xFF},
	{0x1fdd & 0xFF, 0x1fef & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ffe & 0xFF},
	{0x2000 & 0xFF, 0x200a & 0xFF},
	{0x2010 & 0xFF, 0x2027 & 0xFF},
	{0x202f & 0xFF, 0x205f & 0xFF},
	{0x2070 & 0xFF, 0x2071 & 0xFF},
	{0x2074 & 0xFF, 0x208e & 0xFF},
	{0x2090 & 0xFF, 0x209c & 0xFF},
	{0x20a0 & 0xFF, 0x20c0 & 0xFF},
	{0x2100 & 0xFF, 0x218b & 0xFF},
	{0x2190 & 0xFF, 0x21ff & 0xFF},
	{0x2200 & 0xFF, 0x22ff & 0xFF},
	{0x2300 & 0xFF, 0x23ff & 0xFF},
	{0x2400 & 0xFF, 0x2426 & 0xFF},
	{0x2440 & 0xFF, 0x244a & 0xFF},
	{0x2460 & 0xFF, 0x24ff & 0xFF},
	{0x2500 & 0xFF, 0x25ff & 0xFF},
	{0x2600 & 0xFF, 0x26ff & 0xFF},
	{0x2700 & 0xFF, 0x27ff & 0xFF},
	{0x2800 & 0xFF, 0x28ff & 0xFF},
	{0x2900 & 0xFF, 0x29ff & 0xFF},
	{0x2a00 & 0xFF, 0x2aff & 0xFF},
	{0x2b00 & 0xFF, 0x2b73 & 0xFF},
	{0x2b76 & 0xFF, 0x2b95 & 0xFF},
	{0x2b97 & 0xFF, 0x2bff & 0xFF},
	{0x2c00 & 0xFF, 0x2cee & 0xFF},
	{0x2cf2 & 0xFF, 0x2cf3 & 0xFF},
	{0x2cf9 & 0xFF, 0x2cff & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0x2d30 & 0xFF, 0x2d67 & 0xFF},
	{0x2d6f & 0xFF, 0x2d70 & 0xFF},
	{0x2d80 & 0xFF, 0x2d96 & 0xFF},
	{0x2da0 & 0xFF, 0x2da6 & 0xFF},
	{0x2da8 & 0xFF, 0x2dae & 0xFF},
	{0x2db0 & 0xFF, 0x2db6 & 0xFF},
	{0x2db8 & 0xFF, 0x2dbe & 0xFF},
	{0x2dc0 & 0xFF, 0x2dc6 & 0xFF},
	{0x2dc8 & 0xFF, 0x2dce & 0xFF},
	{0x2dd0 & 0xFF, 0x2dd6 & 0xFF},
	{0x2dd8 & 0xFF, 0x2dde & 0xFF},
	{0x2e00 & 0xFF, 0x2e5d & 0xFF},
	{0x2e80 & 0xFF, 0x2e99 & 0xFF},
	{0x2e9b & 0xFF, 0x2ef3 & 0xFF},
	{0x2f00 & 0xFF, 0x2fd5 & 0xFF},
	{0x2ff0 & 0xFF, 0x2fff & 0xFF},
	{0x3000 & 0xFF, 0x3029 & 0xFF},
	{0x3030 & 0xFF, 0x303f & 0xFF},
	{0x3041 & 0xFF, 0x3096 & 0xFF},
	{0x309b & 0xFF, 0x30ff & 0xFF},
	{0x3105 & 0xFF, 0x312f & 0xFF},
	{0x3131 & 0xFF, 0x318e & 0xFF},
	{0x3190 & 0xFF, 0x31e3 & 0xFF},
	{0x31ef & 0xFF, 0x31ff & 0xFF},
	{0x3200 & 0xFF, 0x321e & 0xFF},
	{0x3220 & 0xFF, 0x32ff & 0xFF},
	{0x3300 & 0xFF, 0x33ff & 0xFF},
	{0x3400 & 0xFF, 0x34ff & 0xFF},
	{0x3500 & 0xFF, 0x35ff & 0xFF},
	{0x3600 & 0xFF, 0x36ff & 0xFF},
	{0x3700 & 0xFF, 0x37ff & 0xFF},
	{0x3800 & 0xFF, 0x38ff & 0xFF},
	{0x3900 & 0xFF, 0x39ff & 0xFF},
	{0x3a00 & 0xFF, 0x3aff & 0xFF},
	{0x3b00 & 0xFF, 0x3bff & 0xFF},
	{0x3c00 & 0xFF, 0x3cff & 0xFF},
	{0x3d00 & 0xFF, 0x3dff & 0xFF},
	{0x3e00 & 0xFF, 0x3eff & 0xFF},
	{0x3f00 & 0xFF, 0x3fff & 0xFF},
	{0x4000 & 0xFF, 0x40ff & 0xFF},
	{0x4100 & 0xFF, 0x41ff & 0xFF},
	{0x4200 & 0xFF, 0x42ff & 0xFF},
	{0x4300 & 0xFF, 0x43ff & 0xFF},
	{0x4400 & 0xFF, 0x44ff & 0xFF},
	{0x4500 & 0xFF, 0x45ff & 0xFF},
	{0x4600 & 0xFF, 0x46ff & 0xFF},
	{0x4700 & 0xFF, 0x47ff & 0xFF},
	{0x4800 & 0xFF, 0x48ff & 0xFF},
	{0x4900 & 0xFF, 0x49ff & 0xFF},
	{0x4a00 & 0xFF, 0x4aff & 0xFF},
	{0x4b00 & 0xFF, 0x4bff & 0xFF},
	{0x4c00 & 0xFF, 0x4cff & 0xFF},
	{0x4d00 & 0xFF, 0x4dff & 0xFF},
	{0x4e00 & 0xFF, 0x4eff & 0xFF},
	{0x4f00 & 0xFF, 0x4fff & 0xFF},
	{0x5000 & 0xFF, 0x50ff & 0xFF},
	{0x5100 & 0xFF, 0x51ff & 0xFF},
	{0x5200 & 0xFF, 0x52ff & 0xFF},
	{0x5300 & 0xFF, 0x53ff & 0xFF},
	{0x5400 & 0xFF, 0x54ff & 0xFF},
	{0x5500 & 0xFF, 0x55ff & 0xFF},
	{0x5600 & 0xFF, 0x56ff & 0xFF},
	{0x5700 & 0xFF, 0x57ff & 0xFF},
	{0x5800 & 0xFF, 0x58ff & 0xFF},
	{0x5900 & 0xFF, 0x59ff & 0xFF},
	{0x5a00 & 0xFF, 0x5aff & 0xFF},
	{0x5b00 & 0xFF, 0x5bff & 0xFF},
	{0x5c00 & 0xFF, 0x5cff & 0xFF},
	{0x5d00 & 0xFF, 0x5dff & 0xFF},
	{0x5e00 & 0xFF, 0x5eff & 0xFF},
	{0x5f00 & 0xFF, 0x5fff & 0xFF},
	{0x6000 & 0xFF, 0x60ff & 0xFF},
	{0x6100 & 0xFF, 0x61ff & 0xFF},
	{0x6200 & 0xFF, 0x62ff & 0xFF},
	{0x6300 & 0xFF, 0x63ff & 0xFF},
	{0x6400 & 0xFF, 0x64ff & 0xFF},
	{0x6500 & 0xFF, 0x65ff & 0xFF},
	{0x6600 & 0xFF, 0x66ff & 0xFF},
	{0x6700 & 0xFF, 0x67ff & 0xFF},
	{0x6800 & 0xFF, 0x68ff & 0xFF},
	{0x6900 & 0xFF, 0x69ff & 0xFF},
	{0x6a00 & 0xFF, 0x6aff & 0xFF},
	{0x6b00 & 0xFF, 0x6bff & 0xFF},
	{0x6c00 & 0xFF, 0x6cff & 0xFF},
	{0x6d00 & 0xFF, 0x6dff & 0xFF},
	{0x6e00 & 0xFF, 0x6eff & 0xFF},
	{0x6f00 & 0xFF, 0x6fff & 0xFF},
	{0x7000 & 0xFF, 0x70ff & 0xFF},
	{0x7100 & 0xFF, 0x71ff & 0xFF},
	{0x7200 & 0xFF, 0x72ff & 0xFF},
	{0x7300 & 0xFF, 0x73ff & 0xFF},
	{0x7400 & 0xFF, 0x74ff & 0xFF},
	{0x7500 & 0xFF, 0x75ff & 0xFF},
	{0x7600 & 0xFF, 0x76ff & 0xFF},
	{0x7700 & 0xFF, 0x77ff & 0xFF},
	{0x7800 & 0xFF, 0x78ff & 0xFF},
	{0x7900 & 0xFF, 0x79ff & 0xFF},
	{0x7a00 & 0xFF, 0x7aff & 0xFF},
	{0x7b00 & 0xFF, 0x7bff & 0xFF},
	{0x7c00 & 0xFF, 0x7cff & 0xFF},
	{0x7d00 & 0xFF, 0x7dff & 0xFF},
	{0x7e00 & 0xFF, 0x7eff & 0xFF},
	{0x7f00 & 0xFF, 0x7fff & 0xFF},
	{0x8000 & 0xFF, 0x80ff & 0xFF},
	{0x8100 & 0xFF, 0x81ff & 0xFF},
	{0x8200 & 0xFF, 0x82ff & 0xFF},
	{0x8300 & 0xFF, 0x83ff & 0xFF},
	{0x8400 & 0xFF, 0x84ff & 0xFF},
	{0x8500 & 0xFF, 0x85ff & 0xFF},
	{0x8600 & 0xFF, 0x86ff & 0xFF},
	{0x8700 & 0xFF, 0x87ff & 0xFF},
	{0x8800 & 0xFF, 0x88ff & 0xFF},
	{0x8900 & 0xFF, 0x89ff & 0xFF},
	{0x8a00 & 0xFF, 0x8aff & 0xFF},
	{0x8b00 & 0xFF, 0x8bff & 0xFF},
	{0x8c00 & 0xFF, 0x8cff & 0xFF},
	{0x8d00 & 0xFF, 0x8dff & 0xFF},
	{0x8e00 & 0xFF, 0x8eff & 0xFF},
	{0x8f00 & 0xFF, 0x8fff & 0xFF},
	{0x9000 & 0xFF, 0x90ff & 0xFF},
	{0x9100 & 0xFF, 0x91ff & 0xFF},
	{0x9200 & 0xFF, 0x92ff & 0xFF},
	{0x9300 & 0xFF, 0x93ff & 0xFF},
	{0x9400 & 0xFF, 0x94ff & 0xFF},
	{0x9500 & 0xFF, 0x95ff & 0xFF},
	{0x9600 & 0xFF, 0x96ff & 0xFF},
	{0x9700 & 0xFF, 0x97ff & 0xFF},
	{0x9800 & 0xFF, 0x98ff & 0xFF},
	{0x9900 & 0xFF, 0x99ff & 0xFF},
	{0x9a00 & 0xFF, 0x9aff & 0xFF},
	{0x9b00 & 0xFF, 0x9bff & 0xFF},
	{0x9c00 & 0xFF, 0x9cff & 0xFF},
	{0x9d00 & 0xFF, 0x9dff & 0xFF},
	{0x9e00 & 0xFF, 0x9eff & 0xFF},
	{0x9f00 & 0xFF, 0x9fff & 0xFF},
	{0xa000 & 0xFF, 0xa0ff & 0xFF},
	{0xa100 & 0xFF, 0xa1ff & 0xFF},
	{0xa200 & 0xFF, 0xa2ff & 0xFF},
	{0xa300 & 0xFF, 0xa3ff & 0xFF},
	{0xa400 & 0xFF, 0xa48c & 0xFF},
	{0xa490 & 0xFF, 0xa4c6 & 0xFF},
	{0xa4d0 & 0xFF, 0xa4ff & 0xFF},
	{0xa500 & 0xFF, 0xa5ff & 0xFF},
	{0xa600 & 0xFF, 0xa62b & 0xFF},
	{0xa640 & 0xFF, 0xa66e & 0xFF},
	{0xa673 & 0xFF, 0xa673 & 0xFF},
	{0xa67e & 0xFF, 0xa69d & 0xFF},
	{0xa6a0 & 0xFF, 0xa6ef & 0xFF},
	{0xa6f2 & 0xFF, 0xa6f7 & 0xFF},
	{0xa700 & 0xFF, 0xa7ca & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d3 & 0xFF, 0xa7d3 & 0xFF},
	{0xa7d5 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f2 & 0xFF, 0xa7ff & 0xFF},
	{0xa800 & 0xFF, 0xa801 & 0xFF},
	{0xa803 & 0xFF, 0xa805 & 0xFF},
	{0xa807 & 0xFF, 0xa80a & 0xFF},
	{0xa80c & 0xFF, 0xa824 & 0xFF},
	{0xa827 & 0xFF, 0xa82b & 0xFF},
	{0xa830 & 0xFF, 0xa839 & 0xFF},
	{0xa840 & 0xFF, 0xa877 & 0xFF},
	{0xa880 & 0xFF, 0xa8c3 & 0xFF},
	{0xa8ce & 0xFF, 0xa8d9 & 0xFF},
	{0xa8f2 & 0xFF, 0xa8fe & 0xFF},
	{0xa900 & 0xFF, 0xa925 & 0xFF},
	{0xa92e & 0xFF, 0xa946 & 0xFF},
	{0xa952 & 0xFF, 0xa953 & 0xFF},
	{0xa95f & 0xFF, 0xa97c & 0xFF},
	{0xa983 & 0xFF, 0xa9b2 & 0xFF},
	{0xa9b4 & 0xFF, 0xa9b5 & 0xFF},
	{0xa9ba & 0xFF, 0xa9bb & 0xFF},
	{0xa9be & 0xFF, 0xa9cd & 0xFF},
	{0xa9cf & 0xFF, 0xa9d9 & 0xFF},
	{0xa9de & 0xFF, 0xa9e4 & 0xFF},
	{0xa9e6 & 0xFF, 0xa9fe & 0xFF},
	{0xaa00 & 0xFF, 0xaa28 & 0xFF},
	{0xaa2f & 0xFF, 0xaa30 & 0xFF},
	{0xaa33 & 0xFF, 0xaa34 & 0xFF},
	{0xaa40 & 0xFF, 0xaa42 & 0xFF},
	{0xaa44 & 0xFF, 0xaa4b & 0xFF},
	{0xaa4d & 0xFF, 0xaa4d & 0xFF},
	{0xaa50 & 0xFF, 0xaa59 & 0xFF},
	{0xaa5c & 0xFF, 0xaa7b & 0xFF},
	{0xaa7d & 0xFF, 0xaaaf & 0xFF},
	{0xaab1 & 0xFF, 0xaab1 & 0xFF},
	{0xaab5 & 0xFF, 0xaab6 & 0xFF},
	{0xaab9 & 0xFF, 0xaabd & 0xFF},
	{0xaac0 & 0xFF, 0xaac0 & 0xFF},
	{0xaac2 & 0xFF, 0xaac2 & 0xFF},
	{0xaadb & 0xFF, 0xaaeb & 0xFF},
	{0xaaee & 0xFF, 0xaaf5 & 0xFF},
	{0xab01 & 0xFF, 0xab06 & 0xFF},
	{0xab09 & 0xFF, 0xab0e & 0xFF},
	{0xab11 & 0xFF, 0xab16 & 0xFF},
	{0xab20 & 0xFF, 0xab26 & 0xFF},
	{0xab28 & 0xFF, 0xab2e & 0xFF},
	{0xab30 & 0xFF, 0xab6b & 0xFF},
	{0xab70 & 0xFF, 0xabe4 & 0xFF},
	{0xabe6 & 0xFF, 0xabe7 & 0xFF},
	{0xabe9 & 0xFF, 0xabec & 0xFF},
	{0xabf0 & 0xFF, 0xabf9 & 0xFF},
	{0xac00 & 0xFF, 0xacff & 0xFF},
	{0xad00 & 0xFF, 0xadff & 0xFF},
	{0xae00 & 0xFF, 0xaeff & 0xFF},
	{0xaf00 & 0xFF, 0xafff & 0xFF},
	{0xb000 & 0xFF, 0xb0ff & 0xFF},
	{0xb100 & 0xFF, 0xb1ff & 0xFF},
	{0xb200 & 0xFF, 0xb2ff & 0xFF},
	{0xb300 & 0xFF, 0xb3ff & 0xFF},
	{0xb400 & 0xFF, 0xb4ff & 0xFF},
	{0xb500 & 0xFF, 0xb5ff & 0xFF},
	{0xb600 & 0xFF, 0xb6ff & 0xFF},
	{0xb700 & 0xFF, 0xb7ff & 0xFF},
	{0xb800 & 0xFF, 0xb8ff & 0xFF},
	{0xb900 & 0xFF, 0xb9ff & 0xFF},
	{0xba00 & 0xFF, 0xbaff & 0xFF},
	{0xbb00 & 0xFF, 0xbbff & 0xFF},
	{0xbc00 & 0xFF, 0xbcff & 0xFF},
	{0xbd00 & 0xFF, 0xbdff & 0xFF},
	{0xbe00 & 0xFF, 0xbeff & 0xFF},
	{0xbf00 & 0xFF, 0xbfff & 0xFF},
	{0xc000 & 0xFF, 0xc0ff & 0xFF},
	{0xc100 & 0xFF, 0xc1ff & 0xFF},
	{0xc200 & 0xFF, 0xc2ff & 0xFF},
	{0xc300 & 0xFF, 0xc3ff & 0xFF},
	{0xc400 & 0xFF, 0xc4ff & 0xFF},
	{0xc500 & 0xFF, 0xc5ff & 0xFF},
	{0xc600 & 0xFF, 0xc6ff & 0xFF},
	{0xc700 & 0xFF, 0xc7ff & 0xFF},
	{0xc800 & 0xFF, 0xc8ff & 0xFF},
	{0xc900 & 0xFF, 0xc9ff & 0xFF},
	{0xca00 & 0xFF, 0xcaff & 0xFF},
	{0xcb00 & 0xFF, 0xcbff & 0xFF},
	{0xcc00 & 0xFF, 0xccff & 0xFF},
	{0xcd00 & 0xFF, 0xcdff & 0xFF},
	{0xce00 & 0xFF, 0xceff & 0xFF},
	{0xcf00 & 0xFF, 0xcfff & 0xFF},
	{0xd000 & 0xFF, 0xd0ff & 0xFF},
	{0xd100 & 0xFF, 0xd1ff & 0xFF},
	{0xd200 & 0xFF, 0xd2ff & 0xFF},
	{0xd300 & 0xFF, 0xd3ff & 0xFF},
	{0xd400 & 0xFF, 0xd4ff & 0xFF},
	{0xd500 & 0xFF, 0xd5ff & 0xFF},
	{0xd600 & 0xFF, 0xd6ff & 0xFF},
	{0xd700 & 0xFF, 0xd7a3 & 0xFF},
	{0xd7b0 & 0xFF, 0xd7c6 & 0xFF},
	{0xd7cb & 0xFF, 0xd7fb & 0xFF},
	{0xf900 & 0xFF, 0xf9ff & 0xFF},
	{0xfa00 & 0xFF, 0xfa6d & 0xFF},
	{0xfa70 & 0xFF, 0xfad9 & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xfb1d & 0xFF, 0xfb1d & 0xFF},
	{0xfb1f & 0xFF, 0xfb36 & 0xFF},
	{0xfb38 & 0xFF, 0xfb3c & 0xFF},
	{0xfb3e & 0xFF, 0xfb3e & 0xFF},
	{0xfb40 & 0xFF, 0xfb41 & 0xFF},
	{0xfb43 & 0xFF, 0xfb44 & 0xFF},
	{0xfb46 & 0xFF, 0xfbc2 & 0xFF},
	{0xfbd3 & 0xFF, 0xfbff & 0xFF},
	{0xfc00 & 0xFF, 0xfcff & 0xFF},
	{0xfd00 & 0xFF, 0xfd8f & 0xFF},
	{0xfd92 & 0xFF, 0xfdc7 & 0xFF},
	{0xfdcf & 0xFF, 0xfdcf & 0xFF},
	{0xfdf0 & 0xFF, 0xfdff & 0xFF},
	{0xfe10 & 0xFF, 0xfe19 & 0xFF},
	{0xfe30 & 0xFF, 0xfe52 & 0xFF},
	{0xfe54 & 0xFF, 0xfe66 & 0xFF},
	{0xfe68 & 0xFF, 0xfe6b & 0xFF},
	{0xfe70 & 0xFF, 0xfe74 & 0xFF},
	{0xfe76 & 0xFF, 0xfefc & 0xFF},
	{0xff01 & 0xFF, 0xff9d & 0xFF},
	{0xffa0 & 0xFF, 0xffbe & 0xFF},
	{0xffc2 & 0xFF, 0xffc7 & 0xFF},
	{0xffca & 0xFF, 0xffcf & 0xFF},
	{0xffd2 & 0xFF, 0xffd7 & 0xFF},
	{0xffda & 0xFF, 0xffdc & 0xFF},
	{0xffe0 & 0xFF, 0xffe6 & 0xFF},
	{0xffe8 & 0xFF, 0xffee & 0xFF},
	{0xfffc & 0xFF, 0xfffd & 0xFF},
	{0x10000 & 0xFF, 0x1000b & 0xFF},
	{0x1000d & 0xFF, 0x10026 & 0xFF},
	{0x10028 & 0xFF, 0x1003a & 0xFF},
	{0x1003c & 0xFF, 0x1003d & 0xFF},
	{0x1003f & 0xFF, 0x1004d & 0xFF},
	{0x10050 & 0xFF, 0x1005d & 0xFF},
	{0x10080 & 0xFF, 0x100fa & 0xFF},
	{0x10100 & 0xFF, 0x10102 & 0xFF},
	{0x10107 & 0xFF, 0x10133 & 0xFF},
	{0x10137 & 0xFF, 0x1018e & 0xFF},
	{0x10190 & 0xFF, 0x1019c & 0xFF},
	{0x101a0 & 0xFF, 0x101a0 & 0xFF},
	{0x101d0 & 0xFF, 0x101fc & 0xFF},
	{0x10280 & 0xFF, 0x1029c & 0xFF},
	{0x102a0 & 0xFF, 0x102d0 & 0xFF},
	{0x102e1 & 0xFF, 0x102fb & 0xFF},
	{0x10300 & 0xFF, 0x10323 & 0xFF},
	{0x1032d & 0xFF, 0x1034a & 0xFF},
	{0x10350 & 0xFF, 0x10375 & 0xFF},
	{0x10380 & 0xFF, 0x1039d & 0xFF},
	{0x1039f & 0xFF, 0x103c3 & 0xFF},
	{0x103c8 & 0xFF, 0x103d5 & 0xFF},
	{0x10400 & 0xFF, 0x1049d & 0xFF},
	{0x104a0 & 0xFF, 0x104a9 & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10500 & 0xFF, 0x10527 & 0xFF},
	{0x10530 & 0xFF, 0x10563 & 0xFF},
	{0x1056f & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10600 & 0xFF, 0x106ff & 0xFF},
	{0x10700 & 0xFF, 0x10736 & 0xFF},
	{0x10740 & 0xFF, 0x10755 & 0xFF},
	{0x10760 & 0xFF, 0x10767 & 0xFF},
	{0x10780 & 0xFF, 0x10785 & 0xFF},
	{0x10787 & 0xFF, 0x107b0 & 0xFF},
	{0x107b2 & 0xFF, 0x107ba & 0xFF},
	{0x10800 & 0xFF, 0x10805 & 0xFF},
	{0x10808 & 0xFF, 0x10808 & 0xFF},
	{0x1080a & 0xFF, 0x10835 & 0xFF},
	{0x10837 & 0xFF, 0x10838 & 0xFF},
	{0x1083c & 0xFF, 0x1083c & 0xFF},
	{0x1083f & 0xFF, 0x10855 & 0xFF},
	{0x10857 & 0xFF, 0x1089e & 0xFF},
	{0x108a7 & 0xFF, 0x108af & 0xFF},
	{0x108e0 & 0xFF, 0x108f2 & 0xFF},
	{0x108f4 & 0xFF, 0x108f5 & 0xFF},
	{0x108fb & 0xFF, 0x108ff & 0xFF},
	{0x10900 & 0xFF, 0x1091b & 0xFF},
	{0x1091f & 0xFF, 0x10939 & 0xFF},
	{0x1093f & 0xFF, 0x1093f & 0xFF},
	{0x10980 & 0xFF, 0x109b7 & 0xFF},
	{0x109bc & 0xFF, 0x109cf & 0xFF},
	{0x109d2 & 0xFF, 0x109ff & 0xFF},
	{0x10a00 & 0xFF, 0x10a00 & 0xFF},
	{0x10a10 & 0xFF, 0x10a13 & 0xFF},
	{0x10a15 & 0xFF, 0x10a17 & 0xFF},
	{0x10a19 & 0xFF, 0x10a35 & 0xFF},
	{0x10a40 & 0xFF, 0x10a48 & 0xFF},
	{0x10a50 & 0xFF, 0x10a58 & 0xFF},
	{0x10a60 & 0xFF, 0x10a9f & 0xFF},
	{0x10ac0 & 0xFF, 0x10ae4 & 0xFF},
	{0x10aeb & 0xFF, 0x10af6 & 0xFF},
	{0x10b00 & 0xFF, 0x10b35 & 0xFF},
	{0x10b39 & 0xFF, 0x10b55 & 0xFF},
	{0x10b58 & 0xFF, 0x10b72 & 0xFF},
	{0x10b78 & 0xFF, 0x10b91 & 0xFF},
	{0x10b99 & 0xFF, 0x10b9c & 0xFF},
	{0x10ba9 & 0xFF, 0x10baf & 0xFF},
	{0x10c00 & 0xFF, 0x10c48 & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x10cfa & 0xFF, 0x10cff & 0xFF},
	{0x10d00 & 0xFF, 0x10d23 & 0xFF},
	{0x10d30 & 0xFF, 0x10d39 & 0xFF},
	{0x10e60 & 0xFF, 0x10e7e & 0xFF},
	{0x10e80 & 0xFF, 0x10ea9 & 0xFF},
	{0x10ead & 0xFF, 0x10ead & 0xFF},
	{0x10eb0 & 0xFF, 0x10eb1 & 0xFF},
	{0x10f00 & 0xFF, 0x10f27 & 0xFF},
	{0x10f30 & 0xFF, 0x10f45 & 0xFF},
	{0x10f51 & 0xFF, 0x10f59 & 0xFF},
	{0x10f70 & 0xFF, 0x10f81 & 0xFF},
	{0x10f86 & 0xFF, 0x10f89 & 0xFF},
	{0x10fb0 & 0xFF, 0x10fcb & 0xFF},
	{0x10fe0 & 0xFF, 0x10ff6 & 0xFF},
	{0x11000 & 0xFF, 0x11000 & 0xFF},
	{0x11002 & 0xFF, 0x11037 & 0xFF},
	{0x11047 & 0xFF, 0x1104d & 0xFF},
	{0x11052 & 0xFF, 0x1106f & 0xFF},
	{0x11071 & 0xFF, 0x11072 & 0xFF},
	{0x11075 & 0xFF, 0x11075 & 0xFF},
	{0x11082 & 0xFF, 0x110b2 & 0xFF},
	{0x110b7 & 0xFF, 0x110b8 & 0xFF},
	{0x110bb & 0xFF, 0x110bc & 0xFF},
	{0x110be & 0xFF, 0x110c1 & 0xFF},
	{0x110d0 & 0xFF, 0x110e8 & 0xFF},
	{0x110f0 & 0xFF, 0x110f9 & 0xFF},
	{0x11103 & 0xFF, 0x11126 & 0xFF},
	{0x1112c & 0xFF, 0x1112c & 0xFF},
	{0x11136 & 0xFF, 0x11147 & 0xFF},
	{0x11150 & 0xFF, 0x11172 & 0xFF},
	{0x11174 & 0xFF, 0x11176 & 0xFF},
	{0x11182 & 0xFF, 0x111b5 & 0xFF},
	{0x111bf & 0xFF, 0x111c8 & 0xFF},
	{0x111cd & 0xFF, 0x111ce & 0xFF},
	{0x111d0 & 0xFF, 0x111df & 0xFF},
	{0x111e1 & 0xFF, 0x111f4 & 0xFF},
	{0x11200 & 0xFF, 0x11211 & 0xFF},
	{0x11213 & 0xFF, 0x1122e & 0xFF},
	{0x11232 & 0xFF, 0x11233 & 0xFF},
	{0x11235 & 0xFF, 0x11235 & 0xFF},
	{0x11238 & 0xFF, 0x1123d & 0xFF},
	{0x1123f & 0xFF, 0x11240 & 0xFF},
	{0x11280 & 0xFF, 0x11286 & 0xFF},
	{0x11288 & 0xFF, 0x11288 & 0xFF},
	{0x1128a & 0xFF, 0x1128d & 0xFF},
	{0x1128f & 0xFF, 0x1129d & 0xFF},
	{0x1129f & 0xFF, 0x112a9 & 0xFF},
	{0x112b0 & 0xFF, 0x112de & 0xFF},
	{0x112e0 & 0xFF, 0x112e2 & 0xFF},
	{0x112f0 & 0xFF, 0x112f9 & 0xFF},
	{0x11302 & 0xFF, 0x11303 & 0xFF},
	{0x11305 & 0xFF, 0x1130c & 0xFF},
	{0x1130f & 0xFF, 0x11310 & 0xFF},
	{0x11313 & 0xFF, 0x11328 & 0xFF},
	{0x1132a & 0xFF, 0x11330 & 0xFF},
	{0x11332 & 0xFF, 0x11333 & 0xFF},
	{0x11335 & 0xFF, 0x11339 & 0xFF},
	{0x1133d & 0xFF, 0x1133d & 0xFF},
	{0x1133f & 0xFF, 0x1133f & 0xFF},
	{0x11341 & 0xFF, 0x11344 & 0xFF},
	{0x11347 & 0xFF, 0x11348 & 0xFF},
	{0x1134b & 0xFF, 0x1134d & 0xFF},
	{0x11350 & 0xFF, 0x11350 & 0xFF},
	{0x1135d & 0xFF, 0x11363 & 0xFF},
	{0x11400 & 0xFF, 0x11437 & 0xFF},
	{0x11440 & 0xFF, 0x11441 & 0xFF},
	{0x11445 & 0xFF, 0x11445 & 0xFF},
	{0x11447 & 0xFF, 0x1145b & 0xFF},
	{0x1145d & 0xFF, 0x1145d & 0xFF},
	{0x1145f & 0xFF, 0x11461 & 0xFF},
	{0x11480 & 0xFF, 0x114af & 0xFF},
	{0x114b1 & 0xFF, 0x114b2 & 0xFF},
	{0x114b9 & 0xFF, 0x114b9 & 0xFF},
	{0x114bb & 0xFF, 0x114bc & 0xFF},
	{0x114be & 0xFF, 0x114be & 0xFF},
	{0x114c1 & 0xFF, 0x114c1 & 0xFF},
	{0x114c4 & 0xFF, 0x114c7 & 0xFF},
	{0x114d0 & 0xFF, 0x114d9 & 0xFF},
	{0x11580 & 0xFF, 0x115ae & 0xFF},
	{0x115b0 & 0xFF, 0x115b1 & 0xFF},
	{0x115b8 & 0xFF, 0x115bb & 0xFF},
	{0x115be & 0xFF, 0x115be & 0xFF},
	{0x115c1 & 0xFF, 0x115db & 0xFF},
	{0x11600 & 0xFF, 0x11632 & 0xFF},
	{0x1163b & 0xFF, 0x1163c & 0xFF},
	{0x1163e & 0xFF, 0x1163e & 0xFF},
	{0x11641 & 0xFF, 0x11644 & 0xFF},
	{0x11650 & 0xFF, 0x11659 & 0xFF},
	{0x11660 & 0xFF, 0x1166c & 0xFF},
	{0x11680 & 0xFF, 0x116aa & 0xFF},
	{0x116ac & 0xFF, 0x116ac & 0xFF},
	{0x116ae & 0xFF, 0x116af & 0xFF},
	{0x116b6 & 0xFF, 0x116b6 & 0xFF},
	{0x116b8 & 0xFF, 0x116b9 & 0xFF},
	{0x116c0 & 0xFF, 0x116c9 & 0xFF},
	{0x11700 & 0xFF, 0x1171a & 0xFF},
	{0x11720 & 0xFF, 0x11721 & 0xFF},
	{0x11726 & 0xFF, 0x11726 & 0xFF},
	{0x11730 & 0xFF, 0x11746 & 0xFF},
	{0x11800 & 0xFF, 0x1182e & 0xFF},
	{0x11838 & 0xFF, 0x11838 & 0xFF},
	{0x1183b & 0xFF, 0x1183b & 0xFF},
	{0x118a0 & 0xFF, 0x118f2 & 0xFF},
	{0x118ff & 0xFF, 0x118ff & 0xFF},
	{0x11900 & 0xFF, 0x11906 & 0xFF},
	{0x11909 & 0xFF, 0x11909 & 0xFF},
	{0x1190c & 0xFF, 0x11913 & 0xFF},
	{0x11915 & 0xFF, 0x11916 & 0xFF},
	{0x11918 & 0xFF, 0x1192f & 0xFF},
	{0x11931 & 0xFF, 0x11935 & 0xFF},
	{0x11937 & 0xFF, 0x11938 & 0xFF},
	{0x1193d & 0xFF, 0x1193d & 0xFF},
	{0x1193f & 0xFF, 0x11942 & 0xFF},
	{0x11944 & 0xFF, 0x11946 & 0xFF},
	{0x11950 & 0xFF, 0x11959 & 0xFF},
	{0x119a0 & 0xFF, 0x119a7 & 0xFF},
	{0x119aa & 0xFF, 0x119d3 & 0xFF},
	{0x119dc & 0xFF, 0x119df & 0xFF},
	{0x119e1 & 0xFF, 0x119e4 & 0xFF},
	{0x11a00 & 0xFF, 0x11a00 & 0xFF},
	{0x11a0b & 0xFF, 0x11a32 & 0xFF},
	{0x11a39 & 0xFF, 0x11a3a & 0xFF},
	{0x11a3f & 0xFF, 0x11a46 & 0xFF},
	{0x11a50 & 0xFF, 0x11a50 & 0xFF},
	{0x11a57 & 0xFF, 0x11a58 & 0xFF},
	{0x11a5c & 0xFF, 0x11a89 & 0xFF},
	{0x11a97 & 0xFF, 0x11a97 & 0xFF},
	{0x11a9a & 0xFF, 0x11aa2 & 0xFF},
	{0x11ab0 & 0xFF, 0x11af8 & 0xFF},
	{0x11b00 & 0xFF, 0x11b09 & 0xFF},
	{0x11c00 & 0xFF, 0x11c08 & 0xFF},
	{0x11c0a & 0xFF, 0x11c2f & 0xFF},
	{0x11c3e & 0xFF, 0x11c3e & 0xFF},
	{0x11c40 & 0xFF, 0x11c45 & 0xFF},
	{0x11c50 & 0xFF, 0x11c6c & 0xFF},
	{0x11c70 & 0xFF, 0x11c8f & 0xFF},
	{0x11ca9 & 0xFF, 0x11ca9 & 0xFF},
	{0x11cb1 & 0xFF, 0x11cb1 & 0xFF},
	{0x11cb4 & 0xFF, 0x11cb4 & 0xFF},
	{0x11d00 & 0xFF, 0x11d06 & 0xFF},
	{0x11d08 & 0xFF, 0x11d09 & 0xFF},
	{0x11d0b & 0xFF, 0x11d30 & 0xFF},
	{0x11d46 & 0xFF, 0x11d46 & 0xFF},
	{0x11d50 & 0xFF, 0x11d59 & 0xFF},
	{0x11d60 & 0xFF, 0x11d65 & 0xFF},
	{0x11d67 & 0xFF, 0x11d68 & 0xFF},
	{0x11d6a & 0xFF, 0x11d8e & 0xFF},
	{0x11d93 & 0xFF, 0x11d94 & 0xFF},
	{0x11d96 & 0xFF, 0x11d96 & 0xFF},
	{0x11d98 & 0xFF, 0x11d98 & 0xFF},
	{0x11da0 & 0xFF, 0x11da9 & 0xFF},
	{0x11ee0 & 0xFF, 0x11ef2 & 0xFF},
	{0x11ef5 & 0xFF, 0x11ef8 & 0xFF},
	{0x11f02 & 0xFF, 0x11f10 & 0xFF},
	{0x11f12 & 0xFF, 0x11f35 & 0xFF},
	{0x11f3e & 0xFF, 0x11f3f & 0xFF},
	{0x11f41 & 0xFF, 0x11f41 & 0xFF},
	{0x11f43 & 0xFF, 0x11f59 & 0xFF},
	{0x11fb0 & 0xFF, 0x11fb0 & 0xFF},
	{0x11fc0 & 0xFF, 0x11ff1 & 0xFF},
	{0x11fff & 0xFF, 0x11fff & 0xFF},
	{0x12000 & 0xFF, 0x120ff & 0xFF},
	{0x12100 & 0xFF, 0x121ff & 0xFF},
	{0x12200 & 0xFF, 0x122ff & 0xFF},
	{0x12300 & 0xFF, 0x12399 & 0xFF},
	{0x12400 & 0xFF, 0x1246e & 0xFF},
	{0x12470 & 0xFF, 0x12474 & 0xFF},
	{0x12480 & 0xFF, 0x124ff & 0xFF},
	{0x12500 & 0xFF, 0x12543 & 0xFF},
	{0x12f90 & 0xFF, 0x12ff2 & 0xFF},
	{0x13000 & 0xFF, 0x130ff & 0xFF},
	{0x13100 & 0xFF, 0x131ff & 0xFF},
	{0x13200 & 0xFF, 0x132ff & 0xFF},
	{0x13300 & 0xFF, 0x133ff & 0xFF},
	{0x13400 & 0xFF, 0x1342f & 0xFF},
	{0x13441 & 0xFF, 0x13446 & 0xFF},
	{0x14400 & 0xFF, 0x144ff & 0xFF},
	{0x14500 & 0xFF, 0x145ff & 0xFF},
	{0x14600 & 0xFF, 0x14646 & 0xFF},
	{0x16800 & 0xFF, 0x168ff & 0xFF},
	{0x16900 & 0xFF, 0x169ff & 0xFF},
	{0x16a00 & 0xFF, 0x16a38 & 0xFF},
	{0x16a40 & 0xFF, 0x16a5e & 0xFF},
	{0x16a60 & 0xFF, 0x16a69 & 0xFF},
	{0x16a6e & 0xFF, 0x16abe & 0xFF},
	{0x16ac0 & 0xFF, 0x16ac9 & 0xFF},
	{0x16ad0 & 0xFF, 0x16aed & 0xFF},
	{0x16af5 & 0xFF, 0x16af5 & 0xFF},
	{0x16b00 & 0xFF, 0x16b2f & 0xFF},
	{0x16b37 & 0xFF, 0x16b45 & 0xFF},
	{0x16b50 & 0xFF, 0x16b59 & 0xFF},
	{0x16b5b & 0xFF, 0x16b61 & 0xFF},
	{0x16b63 & 0xFF, 0x16b77 & 0xFF},
	{0x16b7d & 0xFF, 0x16b8f & 0xFF},
	{0x16e40 & 0xFF, 0x16e9a & 0xFF},
	{0x16f00 & 0xFF, 0x16f4a & 0xFF},
	{0x16f50 & 0xFF, 0x16f87 & 0xFF},
	{0x16f93 & 0xFF, 0x16f9f & 0xFF},
	{0x16fe0 & 0xFF, 0x16fe3 & 0xFF},
	{0x16ff0 & 0xFF, 0x16ff1 & 0xFF},
	{0x17000 & 0xFF, 0x170ff & 0xFF},
	{0x17100 & 0xFF, 0x171ff & 0xFF},
	{0x17200 & 0xFF, 0x172ff & 0xFF},
	{0x17300 & 0xFF, 0x173ff & 0xFF},
	{0x17400 & 0xFF, 0x174ff & 0xFF},
	{0x17500 & 0xFF, 0x175ff & 0xFF},
	{0x17600 & 0xFF, 0x176ff & 0xFF},
	{0x17700 & 0xFF, 0x177ff & 0xFF},
	{0x17800 & 0xFF, 0x178ff & 0xFF},
	{0x17900 & 0xFF, 0x179ff & 0xFF},
	{0x17a00 & 0xFF, 0x17aff & 0xFF},
	{0x17b00 & 0xFF, 0x17bff & 0xFF},
	{0x17c00 & 0xFF, 0x17cff & 0xFF},
	{0x17d00 & 0xFF, 0x17dff & 0xFF},
	{0x17e00 & 0xFF, 0x17eff & 0xFF},
	{0x17f00 & 0xFF, 0x17fff & 0xFF},
	{0x18000 & 0xFF, 0x180ff & 0xFF},
	{0x18100 & 0xFF, 0x181ff & 0xFF},
	{0x18200 & 0xFF, 0x182ff & 0xFF},
	{0x18300 & 0xFF, 0x183ff & 0xFF},
	{0x18400 & 0xFF, 0x184ff & 0xFF},
	{0x18500 & 0xFF, 0x185ff & 0xFF},
	{0x18600 & 0xFF, 0x186ff & 0xFF},
	{0x18700 & 0xFF, 0x187f7 & 0xFF},
	{0x18800 & 0xFF, 0x188ff & 0xFF},
	{0x18900 & 0xFF, 0x189ff & 0xFF},
	{0x18a00 & 0xFF, 0x18aff & 0xFF},
	{0x18b00 & 0xFF, 0x18bff & 0xFF},
	{0x18c00 & 0xFF, 0x18cd5 & 0xFF},
	{0x18d00 & 0xFF, 0x18d08 & 0xFF},
	{0x1aff0 & 0xFF, 0x1aff3 & 0xFF},
	{0x1aff5 & 0xFF, 0x1affb & 0xFF},
	{0x1affd & 0xFF, 0x1affe & 0xFF},
	{0x1b000 & 0xFF, 0x1b0ff & 0xFF},
	{0x1b100 & 0xFF, 0x1b122 & 0xFF},
	{0x1b132 & 0xFF, 0x1b132 & 0xFF},
	{0x1b150 & 0xFF, 0x1b152 & 0xFF},
	{0x1b155 & 0xFF, 0x1b155 & 0xFF},
	{0x1b164 & 0xFF, 0x1b167 & 0xFF},
	{0x1b170 & 0xFF, 0x1b1ff & 0xFF},
	{0x1b200 & 0xFF, 0x1b2fb & 0xFF},
	{0x1bc00 & 0xFF, 0x1bc6a & 0xFF},
	{0x1bc70 & 0xFF, 0x1bc7c & 0xFF},
	{0x1bc80 & 0xFF, 0x1bc88 & 0xFF},
	{0x1bc90 & 0xFF, 0x1bc99 & 0xFF},
	{0x1bc9c & 0xFF, 0x1bc9c & 0xFF},
	{0x1bc9f & 0xFF, 0x1bc9f & 0xFF},
	{0x1cf50 & 0xFF, 0x1cfc3 & 0xFF},
	{0x1d000 & 0xFF, 0x1d0f5 & 0xFF},
	{0x1d100 & 0xFF, 0x1d126 & 0xFF},
	{0x1d129 & 0xFF, 0x1d164 & 0xFF},
	{0x1d166 & 0xFF, 0x1d166 & 0xFF},
	{0x1d16a & 0xFF, 0x1d16d & 0xFF},
	{0x1d183 & 0xFF, 0x1d184 & 0xFF},
	{0x1d18c & 0xFF, 0x1d1a9 & 0xFF},
	{0x1d1ae & 0xFF, 0x1d1ea & 0xFF},
	{0x1d200 & 0xFF, 0x1d241 & 0xFF},
	{0x1d245 & 0xFF, 0x1d245 & 0xFF},
	{0x1d2c0 & 0xFF, 0x1d2d3 & 0xFF},
	{0x1d2e0 & 0xFF, 0x1d2f3 & 0xFF},
	{0x1d300 & 0xFF, 0x1d356 & 0xFF},
	{0x1d360 & 0xFF, 0x1d378 & 0xFF},
	{0x1d400 & 0xFF, 0x1d454 & 0xFF},
	{0x1d456 & 0xFF, 0x1d49c & 0xFF},
	{0x1d49e & 0xFF, 0x1d49f & 0xFF},
	{0x1d4a2 & 0xFF, 0x1d4a2 & 0xFF},
	{0x1d4a5 & 0xFF, 0x1d4a6 & 0xFF},
	{0x1d4a9 & 0xFF, 0x1d4ac & 0xFF},
	{0x1d4ae & 0xFF, 0x1d4b9 & 0xFF},
	{0x1d4bb & 0xFF, 0x1d4bb & 0xFF},
	{0x1d4bd & 0xFF, 0x1d4c3 & 0xFF},
	{0x1d4c5 & 0xFF, 0x1d4ff & 0xFF},
	{0x1d500 & 0xFF, 0x1d505 & 0xFF},
	{0x1d507 & 0xFF, 0x1d50a & 0xFF},
	{0x1d50d & 0xFF, 0x1d514 & 0xFF},
	{0x1d516 & 0xFF, 0x1d51c & 0xFF},
	{0x1d51e & 0xFF, 0x1d539 & 0xFF},
	{0x1d53b & 0xFF, 0x1d53e & 0xFF},
	{0x1d540 & 0xFF, 0x1d544 & 0xFF},
	{0x1d546 & 0xFF, 0x1d546 & 0xFF},
	{0x1d54a & 0xFF, 0x1d550 & 0xFF},
	{0x1d552 & 0xFF, 0x1d5ff & 0xFF},
	{0x1d600 & 0xFF, 0x1d6a5 & 0xFF},
	{0x1d6a8 & 0xFF, 0x1d6ff & 0xFF},
	{0x1d700 & 0xFF, 0x1d7cb & 0xFF},
	{0x1d7ce & 0xFF, 0x1d7ff & 0xFF},
	{0x1d800 & 0xFF, 0x1d8ff & 0xFF},
	{0x1d900 & 0xFF, 0x1d9ff & 0xFF},
	{0x1da37 & 0xFF, 0x1da3a & 0xFF},
	{0x1da6d & 0xFF, 0x1da74 & 0xFF},
	{0x1da76 & 0xFF, 0x1da83 & 0xFF},
	{0x1da85 & 0xFF, 0x1da8b & 0xFF},
	{0x1df00 & 0xFF, 0x1df1e & 0xFF},
	{0x1df25 & 0xFF, 0x1df2a & 0xFF},
	{0x1e030 & 0xFF, 0x1e06d & 0xFF},
	{0x1e100 & 0xFF, 0x1e12c & 0xFF},
	{0x1e137 & 0xFF, 0x1e13d & 0xFF},
	{0x1e140 & 0xFF, 0x1e149 & 0xFF},
	{0x1e14e & 0xFF, 0x1e14f & 0xFF},
	{0x1e290 & 0xFF, 0x1e2ad & 0xFF},
	{0x1e2c0 & 0xFF, 0x1e2eb & 0xFF},
	{0x1e2f0 & 0xFF, 0x1e2f9 & 0xFF},
	{0x1e2ff & 0xFF, 0x1e2ff & 0xFF},
	{0x1e4d0 & 0xFF, 0x1e4eb & 0xFF},
	{0x1e4f0 & 0xFF, 0x1e4f9 & 0xFF},
	{0x1e7e0 & 0xFF, 0x1e7e6 & 0xFF},
	{0x1e7e8 & 0xFF, 0x1e7eb & 0xFF},
	{0x1e7ed & 0xFF, 0x1e7ee & 0xFF},
	{0x1e7f0 & 0xFF, 0x1e7fe & 0xFF},
	{0x1e800 & 0xFF, 0x1e8c4 & 0xFF},
	{0x1e8c7 & 0xFF, 0x1e8cf & 0xFF},
	{0x1e900 & 0xFF, 0x1e943 & 0xFF},
	{0x1e94b & 0xFF, 0x1e94b & 0xFF},
	{0x1e950 & 0xFF, 0x1e959 & 0xFF},
	{0x1e95e & 0xFF, 0x1e95f & 0xFF},
	{0x1ec71 & 0xFF, 0x1ecb4 & 0xFF},
	{0x1ed01 & 0xFF, 0x1ed3d & 0xFF},
	{0x1ee00 & 0xFF, 0x1ee03 & 0xFF},
	{0x1ee05 & 0xFF, 0x1ee1f & 0xFF},
	{0x1ee21 & 0xFF, 0x1ee22 & 0xFF},
	{0x1ee24 & 0xFF, 0x1ee24 & 0xFF},
	{0x1ee27 & 0xFF, 0x1ee27 & 0xFF},
	{0x1ee29 & 0xFF, 0x1ee32 & 0xFF},
	{0x1ee34 & 0xFF, 0x1ee37 & 0xFF},
	{0x1ee39 & 0xFF, 0x1ee39 & 0xFF},
	{0x1ee3b & 0xFF, 0x1ee3b & 0xFF},
	{0x1ee42 & 0xFF, 0x1ee42 & 0xFF},
	{0x1ee47 & 0xFF, 0x1ee47 & 0xFF},
	{0x1ee49 & 0xFF, 0x1ee49 & 0xFF},
	{0x1ee4b & 0xFF, 0x1ee4b & 0xFF},
	{0x1ee4d & 0xFF, 0x1ee4f & 0xFF},
	{0x1ee51 & 0xFF, 0x1ee52 & 0xFF},
	{0x1ee54 & 0xFF, 0x1ee54 & 0xFF},
	{0x1ee57 & 0xFF, 0x1ee57 & 0xFF},
	{0x1ee59 & 0xFF, 0x1ee59 & 0xFF},
	{0x1ee5b & 0xFF, 0x1ee5b & 0xFF},
	{0x1ee5d & 0xFF, 0x1ee5d & 0xFF},
	{0x1ee5f & 0xFF, 0x1ee5f & 0xFF},
	{0x1ee61 & 0xFF, 0x1ee62 & 0xFF},
	{0x1ee64 & 0xFF, 0x1ee64 & 0xFF},
	{0x1ee67 & 0xFF, 0x1ee6a & 0xFF},
	{0x1ee6c & 0xFF, 0x1ee72 & 0xFF},
	{0x1ee74 & 0xFF, 0x1ee77 & 0xFF},
	{0x1ee79 & 0xFF, 0x1ee7c & 0xFF},
	{0x1ee7e & 0xFF, 0x1ee7e & 0xFF},
	{0x1ee80 & 0xFF, 0x1ee89 & 0xFF},
	{0x1ee8b & 0xFF, 0x1ee9b & 0xFF},
	{0x1eea1 & 0xFF, 0x1eea3 & 0xFF},
	{0x1eea5 & 0xFF, 0x1eea9 & 0xFF},
	{0x1eeab & 0xFF, 0x1eebb & 0xFF},
	{0x1eef0 & 0xFF, 0x1eef1 & 0xFF},
	{0x1f000 & 0xFF, 0x1f02b & 0xFF},
	{0x1f030 & 0xFF, 0x1f093 & 0xFF},
	{0x1f0a0 & 0xFF, 0x1f0ae & 0xFF},
	{0x1f0b1 & 0xFF, 0x1f0bf & 0xFF},
	{0x1f0c1 & 0xFF, 0x1f0cf & 0xFF},
	{0x1f0d1 & 0xFF, 0x1f0f5 & 0xFF},
	{0x1f100 & 0xFF, 0x1f1ad & 0xFF},
	{0x1f1e6 & 0xFF, 0x1f1ff & 0xFF},
	{0x1f200 & 0xFF, 0x1f202 & 0xFF},
	{0x1f210 & 0xFF, 0x1f23b & 0xFF},
	{0x1f240 & 0xFF, 0x1f248 & 0xFF},
	{0x1f250 & 0xFF, 0x1f251 & 0xFF},
	{0x1f260 & 0xFF, 0x1f265 & 0xFF},
	{0x1f300 & 0xFF, 0x1f3ff & 0xFF},
	{0x1f400 & 0xFF, 0x1f4ff & 0xFF},
	{0x1f500 & 0xFF, 0x1f5ff & 0xFF},
	{0x1f600 & 0xFF, 0x1f6d7 & 0xFF},
	{0x1f6dc & 0xFF, 0x1f6ec & 0xFF},
	{0x1f6f0 & 0xFF, 0x1f6fc & 0xFF},
	{0x1f700 & 0xFF, 0x1f776 & 0xFF},
	{0x1f77b & 0xFF, 0x1f7d9 & 0xFF},
	{0x1f7e0 & 0xFF, 0x1f7eb & 0xFF},
	{0x1f7f0 & 0xFF, 0x1f7f0 & 0xFF},
	{0x1f800 & 0xFF, 0x1f80b & 0xFF},
	{0x1f810 & 0xFF, 0x1f847 & 0xFF},
	{0x1f850 & 0xFF, 0x1f859 & 0xFF},
	{0x1f860 & 0xFF, 0x1f887 & 0xFF},
	{0x1f890 & 0xFF, 0x1f8ad & 0xFF},
	{0x1f8b0 & 0xFF, 0x1f8b1 & 0xFF},
	{0x1f900 & 0xFF, 0x1f9ff & 0xFF},
	{0x1fa00 & 0xFF, 0x1fa53 & 0xFF},
	{0x1fa60 & 0xFF, 0x1fa6d & 0xFF},
	{0x1fa70 & 0xFF, 0x1fa7c & 0xFF},
	{0x1fa80 & 0xFF, 0x1fa88 & 0xFF},
	{0x1fa90 & 0xFF, 0x1fabd & 0xFF},
	{0x1fabf & 0xFF, 0x1fac5 & 0xFF},
	{0x1face & 0xFF, 0x1fadb & 0xFF},
	{0x1fae0 & 0xFF, 0x1fae8 & 0xFF},
	{0x1faf0 & 0xFF, 0x1faf8 & 0xFF},
	{0x1fb00 & 0xFF, 0x1fb92 & 0xFF},
	{0x1fb94 & 0xFF, 0x1fbca & 0xFF},
	{0x1fbf0 & 0xFF, 0x1fbf9 & 0xFF},
	{0x20000 & 0xFF, 0x200ff & 0xFF},
	{0x20100 & 0xFF, 0x201ff & 0xFF},
	{0x20200 & 0xFF, 0x202ff & 0xFF},
	{0x20300 & 0xFF, 0x203ff & 0xFF},
	{0x20400 & 0xFF, 0x204ff & 0xFF},
	{0x20500 & 0xFF, 0x205ff & 0xFF},
	{0x20600 & 0xFF, 0x206ff & 0xFF},
	{0x20700 & 0xFF, 0x207ff & 0xFF},
	{0x20800 & 0xFF, 0x208ff & 0xFF},
	{0x20900 & 0xFF, 0x209ff & 0xFF},
	{0x20a00 & 0xFF, 0x20aff & 0xFF},
	{0x20b00 & 0xFF, 0x20bff & 0xFF},
	{0x20c00 & 0xFF, 0x20cff & 0xFF},
	{0x20d00 & 0xFF, 0x20dff & 0xFF},
	{0x20e00 & 0xFF, 0x20eff & 0xFF},
	{0x20f00 & 0xFF, 0x20fff & 0xFF},
	{0x21000 & 0xFF, 0x210ff & 0xFF},
	{0x21100 & 0xFF, 0x211ff & 0xFF},
	{0x21200 & 0xFF, 0x212ff & 0xFF},
	{0x21300 & 0xFF, 0x213ff & 0xFF},
	{0x21400 & 0xFF, 0x214ff & 0xFF},
	{0x21500 & 0xFF, 0x215ff & 0xFF},
	{0x21600 & 0xFF, 0x216ff & 0xFF},
	{0x21700 & 0xFF, 0x217ff & 0xFF},
	{0x21800 & 0xFF, 0x218ff & 0xFF},
	{0x21900 & 0xFF, 0x219ff & 0xFF},
	{0x21a00 & 0xFF, 0x21aff & 0xFF},
	{0x21b00 & 0xFF, 0x21bff & 0xFF},
	{0x21c00 & 0xFF, 0x21cff & 0xFF},
	{0x21d00 & 0xFF, 0x21dff & 0xFF},
	{0x21e00 & 0xFF, 0x21eff & 0xFF},
	{0x21f00 & 0xFF, 0x21fff & 0xFF},
	{0x22000 & 0xFF, 0x220ff & 0xFF},
	{0x22100 & 0xFF, 0x221ff & 0xFF},
	{0x22200 & 0xFF, 0x222ff & 0xFF},
	{0x22300 & 0xFF, 0x223ff & 0xFF},
	{0x22400 & 0xFF, 0x224ff & 0xFF},
	{0x22500 & 0xFF, 0x225ff & 0xFF},
	{0x22600 & 0xFF, 0x226ff & 0xFF},
	{0x22700 & 0xFF, 0x227ff & 0xFF},
	{0x22800 & 0xFF, 0x228ff & 0xFF},
	{0x22900 & 0xFF, 0x229ff & 0xFF},
	{0x22a00 & 0xFF, 0x22aff & 0xFF},
	{0x22b00 & 0xFF, 0x22bff & 0xFF},
	{0x22c00 & 0xFF, 0x22cff & 0xFF},
	{0x22d00 & 0xFF, 0x22dff & 0xFF},
	{0x22e00 & 0xFF, 0x22eff & 0xFF},
	{0x22f00 & 0xFF, 0x22fff & 0xFF},
	{0x23000 & 0xFF, 0x230ff & 0xFF},
	{0x23100 & 0xFF, 0x231ff & 0xFF},
	{0x23200 & 0xFF, 0x232ff & 0xFF},
	{0x23300 & 0xFF, 0x233ff & 0xFF},
	{0x23400 & 0xFF, 0x234ff & 0xFF},
	{0x23500 & 0xFF, 0x235ff & 0xFF},
	{0x23600 & 0xFF, 0x236ff & 0xFF},
	{0x23700 & 0xFF, 0x237ff & 0xFF},
	{0x23800 & 0xFF, 0x238ff & 0xFF},
	{0x23900 & 0xFF, 0x239ff & 0xFF},
	{0x23a00 & 0xFF, 0x23aff & 0xFF},
	{0x23b00 & 0xFF, 0x23bff & 0xFF},
	{0x23c00 & 0xFF, 0x23cff & 0xFF},
	{0x23d00 & 0xFF, 0x23dff & 0xFF},
	{0x23e00 & 0xFF, 0x23eff & 0xFF},
	{0x23f00 & 0xFF, 0x23fff & 0xFF},
	{0x24000 & 0xFF, 0x240ff & 0xFF},
	{0x24100 & 0xFF, 0x241ff & 0xFF},
	{0x24200 & 0xFF, 0x242ff & 0xFF},
	{0x24300 & 0xFF, 0x243ff & 0xFF},
	{0x24400 & 0xFF, 0x244ff & 0xFF},
	{0x24500 & 0xFF, 0x245ff & 0xFF},
	{0x24600 & 0xFF, 0x246ff & 0xFF},
	{0x24700 & 0xFF, 0x247ff & 0xFF},
	{0x24800 & 0xFF, 0x248ff & 0xFF},
	{0x24900 & 0xFF, 0x249ff & 0xFF},
	{0x24a00 & 0xFF, 0x24aff & 0xFF},
	{0x24b00 & 0xFF, 0x24bff & 0xFF},
	{0x24c00 & 0xFF, 0x24cff & 0xFF},
	{0x24d00 & 0xFF, 0x24dff & 0xFF},
	{0x24e00 & 0xFF, 0x24eff & 0xFF},
	{0x24f00 & 0xFF, 0x24fff & 0xFF},
	{0x25000 & 0xFF, 0x250ff & 0xFF},
	{0x25100 & 0xFF, 0x251ff & 0xFF},
	{0x25200 & 0xFF, 0x252ff & 0xFF},
	{0x25300 & 0xFF, 0x253ff & 0xFF},
	{0x25400 & 0xFF, 0x254ff & 0xFF},
	{0x25500 & 0xFF, 0x255ff & 0xFF},
	{0x25600 & 0xFF, 0x256ff & 0xFF},
	{0x25700 & 0xFF, 0x257ff & 0xFF},
	{0x25800 & 0xFF, 0x258ff & 0xFF},
	{0x25900 & 0xFF, 0x259ff & 0xFF},
	{0x25a00 & 0xFF, 0x25aff & 0xFF},
	{0x25b00 & 0xFF, 0x25bff & 0xFF},
	{0x25c00 & 0xFF, 0x25cff & 0xFF},
	{0x25d00 & 0xFF, 0x25dff & 0xFF},
	{0x25e00 & 0xFF, 0x25eff & 0xFF},
	{0x25f00 & 0xFF, 0x25fff & 0xFF},
	{0x26000 & 0xFF, 0x260ff & 0xFF},
	{0x26100 & 0xFF, 0x261ff & 0xFF},
	{0x26200 & 0xFF, 0x262ff & 0xFF},
	{0x26300 & 0xFF, 0x263ff & 0xFF},
	{0x26400 & 0xFF, 0x264ff & 0xFF},
	{0x26500 & 0xFF, 0x265ff & 0xFF},
	{0x26600 & 0xFF, 0x266ff & 0xFF},
	{0x26700 & 0xFF, 0x267ff & 0xFF},
	{0x26800 & 0xFF, 0x268ff & 0xFF},
	{0x26900 & 0xFF, 0x269ff & 0xFF},
	{0x26a00 & 0xFF, 0x26aff & 0xFF},
	{0x26b00 & 0xFF, 0x26bff & 0xFF},
	{0x26c00 & 0xFF, 0x26cff & 0xFF},
	{0x26d00 & 0xFF, 0x26dff & 0xFF},
	{0x26e00 & 0xFF, 0x26eff & 0xFF},
	{0x26f00 & 0xFF, 0x26fff & 0xFF},
	{0x27000 & 0xFF, 0x270ff & 0xFF},
	{0x27100 & 0xFF, 0x271ff & 0xFF},
	{0x27200 & 0xFF, 0x272ff & 0xFF},
	{0x27300 & 0xFF, 0x273ff & 0xFF},
	{0x27400 & 0xFF, 0x274ff & 0xFF},
	{0x27500 & 0xFF, 0x275ff & 0xFF},
	{0x27600 & 0xFF, 0x276ff & 0xFF},
	{0x27700 & 0xFF, 0x277ff & 0xFF},
	{0x27800 & 0xFF, 0x278ff & 0xFF},
	{0x27900 & 0xFF, 0x279ff & 0xFF},
	{0x27a00 & 0xFF, 0x27aff & 0xFF},
	{0x27b00 & 0xFF, 0x27bff & 0xFF},
	{0x27c00 & 0xFF, 0x27cff & 0xFF},
	{0x27d00 & 0xFF, 0x27dff & 0xFF},
	{0x27e00 & 0xFF, 0x27eff & 0xFF},
	{0x27f00 & 0xFF, 0x27fff & 0xFF},
	{0x28000 & 0xFF, 0x280ff & 0xFF},
	{0x28100 & 0xFF, 0x281ff & 0xFF},
	{0x28200 & 0xFF, 0x282ff & 0xFF},
	{0x28300 & 0xFF, 0x283ff & 0xFF},
	{0x28400 & 0xFF, 0x284ff & 0xFF},
	{0x28500 & 0xFF, 0x285ff & 0xFF},
	{0x28600 & 0xFF, 0x286ff & 0xFF},
	{0x28700 & 0xFF, 0x287ff & 0xFF},
	{0x28800 & 0xFF, 0x288ff & 0xFF},
	{0x28900 & 0xFF, 0x289ff & 0xFF},
	{0x28a00 & 0xFF, 0x28aff & 0xFF},
	{0x28b00 & 0xFF, 0x28bff & 0xFF},
	{0x28c00 & 0xFF, 0x28cff & 0xFF},
	{0x28d00 & 0xFF, 0x28dff & 0xFF},
	{0x28e00 & 0xFF, 0x28eff & 0xFF},
	{0x28f00 & 0xFF, 0x28fff & 0xFF},
	{0x29000 & 0xFF, 0x290ff & 0xFF},
	{0x29100 & 0xFF, 0x291ff & 0xFF},
	{0x29200 & 0xFF, 0x292ff & 0xFF},
	{0x29300 & 0xFF, 0x293ff & 0xFF},
	{0x29400 & 0xFF, 0x294ff & 0xFF},
	{0x29500 & 0xFF, 0x295ff & 0xFF},
	{0x29600 & 0xFF, 0x296ff & 0xFF},
	{0x29700 & 0xFF, 0x297ff & 0xFF},
	{0x29800 & 0xFF, 0x298ff & 0xFF},
	{0x29900 & 0xFF, 0x299ff & 0xFF},
	{0x29a00 & 0xFF, 0x29aff & 0xFF},
	{0x29b00 & 0xFF, 0x29bff & 0xFF},
	{0x29c00 & 0xFF, 0x29cff & 0xFF},
	{0x29d00 & 0xFF, 0x29dff & 0xFF},
	{0x29e00 & 0xFF, 0x29eff & 0xFF},
	{0x29f00 & 0xFF, 0x29fff & 0xFF},
	{0x2a000 & 0xFF, 0x2a0ff & 0xFF},
	{0x2a100 & 0xFF, 0x2a1ff & 0xFF},
	{0x2a200 & 0xFF, 0x2a2ff & 0xFF},
	{0x2a300 & 0xFF, 0x2a3ff & 0xFF},
	{0x2a400 & 0xFF, 0x2a4ff & 0xFF},
	{0x2a500 & 0xFF, 0x2a5ff & 0xFF},
	{0x2a600 & 0xFF, 0x2a6df & 0xFF},
	{0x2a700 & 0xFF, 0x2a7ff & 0xFF},
	{0x2a800 & 0xFF, 0x2a8ff & 0xFF},
	{0x2a900 & 0xFF, 0x2a9ff & 0xFF},
	{0x2aa00 & 0xFF, 0x2aaff & 0xFF},
	{0x2ab00 & 0xFF, 0x2abff & 0xFF},
	{0x2ac00 & 0xFF, 0x2acff & 0xFF},
	{0x2ad00 & 0xFF, 0x2adff & 0xFF},
	{0x2ae00 & 0xFF, 0x2aeff & 0xFF},
	{0x2af00 & 0xFF, 0x2afff & 0xFF},
	{0x2b000 & 0xFF, 0x2b0ff & 0xFF},
	{0x2b100 & 0xFF, 0x2b1ff & 0xFF},
	{0x2b200 & 0xFF, 0x2b2ff & 0xFF},
	{0x2b300 & 0xFF, 0x2b3ff & 0xFF},
	{0x2b400 & 0xFF, 0x2b4ff & 0xFF},
	{0x2b500 & 0xFF, 0x2b5ff & 0xFF},
	{0x2b600 & 0xFF, 0x2b6ff & 0xFF},
	{0x2b700 & 0xFF, 0x2b739 & 0xFF},
	{0x2b740 & 0xFF, 0x2b7ff & 0xFF},
	{0x2b800 & 0xFF, 0x2b81d & 0xFF},
	{0x2b820 & 0xFF, 0x2b8ff & 0xFF},
	{0x2b900 & 0xFF, 0x2b9ff & 0xFF},
	{0x2ba00 & 0xFF, 0x2baff & 0xFF},
	{0x2bb00 & 0xFF, 0x2bbff & 0xFF},
	{0x2bc00 & 0xFF, 0x2bcff & 0xFF},
	{0x2bd00 & 0xFF, 0x2bdff & 0xFF},
	{0x2be00 & 0xFF, 0x2beff & 0xFF},
	{0x2bf00 & 0xFF, 0x2bfff & 0xFF},
	{0x2c000 & 0xFF, 0x2c0ff & 0xFF},
	{0x2c100 & 0xFF, 0x2c1ff & 0xFF},
	{0x2c200 & 0xFF, 0x2c2ff & 0xFF},
	{0x2c300 & 0xFF, 0x2c3ff & 0xFF},
	{0x2c400 & 0xFF, 0x2c4ff & 0xFF},
	{0x2c500 & 0xFF, 0x2c5ff & 0xFF},
	{0x2c600 & 0xFF, 0x2c6ff & 0xFF},
	{0x2c700 & 0xFF, 0x2c7ff & 0xFF},
	{0x2c800 & 0xFF, 0x2c8ff & 0xFF},
	{0x2c900 & 0xFF, 0x2c9ff & 0xFF},
	{0x2ca00 & 0xFF, 0x2caff & 0xFF},
	{0x2cb00 & 0xFF, 0x2cbff & 0xFF},
	{0x2cc00 & 0xFF, 0x2ccff & 0xFF},
	{0x2cd00 & 0xFF, 0x2cdff & 0xFF},
	{0x2ce00 & 0xFF, 0x2cea1 & 0xFF},
	{0x2ceb0 & 0xFF, 0x2ceff & 0xFF},
	{0x2cf00 & 0xFF, 0x2cfff & 0xFF},
	{0x2d000 & 0xFF, 0x2d0ff & 0xFF},
	{0x2d100 & 0xFF, 0x2d1ff & 0xFF},
	{0x2d200 & 0xFF, 0x2d2ff & 0xFF},
	{0x2d300 & 0xFF, 0x2d3ff & 0xFF},
	{0x2d400 & 0xFF, 0x2d4ff & 0xFF},
	{0x2d500 & 0xFF, 0x2d5ff & 0xFF},
	{0x2d600 & 0xFF, 0x2d6ff & 0xFF},
	{0x2d700 & 0xFF, 0x2d7ff & 0xFF},
	{0x2d800 & 0xFF, 0x2d8ff & 0xFF},
	{0x2d900 & 0xFF, 0x2d9ff & 0xFF},
	{0x2da00 & 0xFF, 0x2daff & 0xFF},
	{0x2db00 & 0xFF, 0x2dbff & 0xFF},
	{0x2dc00 & 0xFF, 0x2dcff & 0xFF},
	{0x2dd00 & 0xFF, 0x2ddff & 0xFF},
	{0x2de00 & 0xFF, 0x2deff & 0xFF},
	{0x2df00 & 0xFF, 0x2dfff & 0xFF},
	{0x2e000 & 0xFF, 0x2e0ff & 0xFF},
	{0x2e100 & 0xFF, 0x2e1ff & 0xFF},
	{0x2e200 & 0xFF, 0x2e2ff & 0xFF},
	{0x2e300 & 0xFF, 0x2e3ff & 0xFF},
	{0x2e400 & 0xFF, 0x2e4ff & 0xFF},
	{0x2e500 & 0xFF, 0x2e5ff & 0xFF},
	{0x2e600 & 0xFF, 0x2e6ff & 0xFF},
	{0x2e700 & 0xFF, 0x2e7ff & 0xFF},
	{0x2e800 & 0xFF, 0x2e8ff & 0xFF},
	{0x2e900 & 0xFF, 0x2e9ff & 0xFF},
	{0x2ea00 & 0xFF, 0x2eaff & 0xFF},
	{0x2eb00 & 0xFF, 0x2ebe0 & 0xFF},
	{0x2ebf0 & 0xFF, 0x2ebff & 0xFF},
	{0x2ec00 & 0xFF, 0x2ecff & 0xFF},
	{0x2ed00 & 0xFF, 0x2edff & 0xFF},
	{0x2ee00 & 0xFF, 0x2ee5d & 0xFF},
	{0x2f800 & 0xFF, 0x2f8ff & 0xFF},
	{0x2f900 & 0xFF, 0x2f9ff & 0xFF},
	{0x2fa00 & 0xFF, 0x2fa1d & 0xFF},
	{0x30000 & 0xFF, 0x300ff & 0xFF},
	{0x30100 & 0xFF, 0x301ff & 0xFF},
	{0x30200 & 0xFF, 0x302ff & 0xFF},
	{0x30300 & 0xFF, 0x303ff & 0xFF},
	{0x30400 & 0xFF, 0x304ff & 0xFF},
	{0x30500 & 0xFF, 0x305ff & 0xFF},
	{0x30600 & 0xFF, 0x306ff & 0xFF},
	{0x30700 & 0xFF, 0x307ff & 0xFF},
	{0x30800 & 0xFF, 0x308ff & 0xFF},
	{0x30900 & 0xFF, 0x309ff & 0xFF},
	{0x30a00 & 0xFF, 0x30aff & 0xFF},
	{0x30b00 & 0xFF, 0x30bff & 0xFF},
	{0x30c00 & 0xFF, 0x30cff & 0xFF},
	{0x30d00 & 0xFF, 0x30dff & 0xFF},
	{0x30e00 & 0xFF, 0x30eff & 0xFF},
	{0x30f00 & 0xFF, 0x30fff & 0xFF},
	{0x31000 & 0xFF, 0x310ff & 0xFF},
	{0x31100 & 0xFF, 0x311ff & 0xFF},
	{0x31200 & 0xFF, 0x312ff & 0xFF},
	{0x31300 & 0xFF, 0x3134a & 0xFF},
	{0x31350 & 0xFF, 0x313ff & 0xFF},
	{0x31400 & 0xFF, 0x314ff & 0xFF},
	{0x31500 & 0xFF, 0x315ff & 0xFF},
	{0x31600 & 0xFF, 0x316ff & 0xFF},
	{0x31700 & 0xFF, 0x317ff & 0xFF},
	{0x31800 & 0xFF, 0x318ff & 0xFF},
	{0x31900 & 0xFF, 0x319ff & 0xFF},
	{0x31a00 & 0xFF, 0x31aff & 0xFF},
	{0x31b00 & 0xFF, 0x31bff & 0xFF},
	{0x31c00 & 0xFF, 0x31cff & 0xFF},
	{0x31d00 & 0xFF, 0x31dff & 0xFF},
	{0x31e00 & 0xFF, 0x31eff & 0xFF},
	{0x31f00 & 0xFF, 0x31fff & 0xFF},
	{0x32000 & 0xFF, 0x320ff & 0xFF},
	{0x32100 & 0xFF, 0x321ff & 0xFF},
	{0x32200 & 0xFF, 0x322ff & 0xFF},
	{0x32300 & 0xFF, 0x323af & 0xFF}};

static const size_t Grapheme_Base_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	30,
	31,
	32,
	33,
	34,
	35,
	36,
	37,
	38,
	39,
	40,
	41,
	42,
	43,
	44,
	45,
	46,
	47,
	48,
	49,
	50,
	51,
	52,
	53,
	54,
	55,
	56,
	57,
	58,
	59,
	60,
	61,
	62,
	63,
	64,
	65,
	66,
	67,
	68,
	69,
	70,
	71,
	72,
	73,
	74,
	75,
	76,
	77,
	78,
	79,
	80,
	81,
	82,
	83,
	84,
	85,
	86,
	87,
	88,
	89,
	90,
	91,
	92,
	93,
	94,
	95,
	96,
	97,
	98,
	99,
	100,
	101,
	102,
	103,
	104,
	105,
	106,
	107,
	108,
	109,
	110,
	111,
	112,
	113,
	114,
	115,
	116,
	117,
	118,
	119,
	120,
	121,
	122,
	123,
	124,
	125,
	126,
	127,
	128,
	129,
	130,
	131,
	132,
	133,
	134,
	135,
	136,
	137,
	138,
	139,
	140,
	141,
	142,
	143,
	144,
	145,
	146,
	147,
	148,
	149,
	150,
	151,
	152,
	153,
	154,
	155,
	156,
	157,
	158,
	159,
	160,
	161,
	162,
	163,
	164,
	165,
	166,
	167,
	168,
	169,
	170,
	171,
	172,
	173,
	174,
	175,
	176,
	177,
	178,
	179,
	180,
	181,
	182,
	183,
	184,
	185,
	186,
	187,
	188,
	189,
	190,
	191,
	192,
	193,
	194,
	195,
	196,
	197,
	198,
	199,
	200,
	201,
	202,
	203,
	204,
	205,
	206,
	207,
	208,
	209,
	210,
	211,
	212,
	213,
	214,
	215,
	249,
	250,
	251,
	252,
	253,
	254,
	255,
	256,
	257,
	258,
	259,
	260,
	261,
	262,
	263,
	264,
	265,
	266,
	267,
	268,
	269,
	270,
	271,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	283,
	284,
	285,
	286,
	287,
	288,
	289,
	290,
	291,
	292,
	293,
	303,
	304,
	305,
	306,
	307,
	308,
	324,
	325,
	326,
	360,
	361,
	362,
	363,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	431,
	432,
	433,
	434,
	444,
	463,
	464,
	465,
	466,
	467,
	468,
	469,
	470,
	471,
	472,
	473,
	474,
	479,
	480,
	481,
	482,
	484,
	487,
	488,
	489,
	492,
	493,
	494,
	496,
	497,
	498,
	499,
	500,
	501,
	502,
	503,
	504,
	505,
	506,
	507,
	512,
	513,
	514,
	515,
	516,
	517,
	518,
	519,
	520,
	521,
	522,
	523,
	524,
	525,
	526,
	527,
	528,
	529,
	530,
	531,
	532,
	533,
	534,
	535,
	536,
	537,
	538,
	539,
	540,
	541,
	542,
	543,
	544,
	545,
	546,
	547,
	548,
	549,
	550,
	551,
	552,
	553,
	554,
	555,
	556,
	557,
	558,
	559,
	560,
	561,
	562,
	563,
	564,
	565,
	566,
	567,
	568,
	569,
	570,
	571,
	572,
	573,
	574,
	575,
	576,
	577,
	578,
	579,
	580,
	581,
	582,
	583,
	584,
	585,
	586,
	587,
	588,
	589,
	590,
	591,
	592,
	593,
	594,
	595,
	596,
	597,
	598,
	599,
	600,
	601,
	602,
	603,
	604,
	605,
	606,
	607,
	608,
	609,
	610,
	611,
	612,
	613,
	614,
	615,
	616,
	617,
	618,
	619,
	620,
	621,
	622,
	623,
	624,
	625,
	626,
	627,
	628,
	629,
	630,
	631,
	632,
	633,
	634,
	635,
	636,
	637,
	638,
	639,
	640,
	641,
	642,
	643,
	644,
	645,
	646,
	647,
	648,
	649,
	650,
	651,
	652,
	653,
	654,
	655,
	656,
	657,
	658,
	659,
	660,
	661,
	662,
	663,
	664,
	665,
	666,
	667,
	668,
	669,
	670,
	671,
	672,
	673,
	674,
	675,
	676,
	677,
	678,
	679,
	680,
	681,
	682,
	683,
	684,
	685,
	686,
	687,
	688,
	689,
	690,
	691,
	692,
	693,
	694,
	695,
	696,
	697,
	698,
	699,
	700,
	701,
	702,
	703,
	704,
	705,
	706,
	707,
	708,
	709,
	710,
	711,
	712,
	713,
	714,
	715,
	716,
	717,
	718,
	719,
	720,
	721,
	722,
	723,
	724,
	725,
	726,
	727,
	728,
	729,
	730,
	731,
	732,
	733,
	734,
	735,
	736,
	737,
	738,
	739,
	740,
	741,
	742,
	743,
	744,
	745,
	746,
	747,
	748,
	749,
	750,
	760,
	761,
	762,
	768,
	769,
	770,
	771,
	772,
	773,
	774,
	775,
	776,
	777,
	778,
	779,
	780,
	781,
	782,
	783,
	784,
	785,
	786,
	787,
	788,
	789,
	790,
	791,
	792,
	793,
	794,
	795,
	796,
	797,
	798,
	799,
	800,
	801,
	802,
	803
};

static const char32_t Grapheme_Base_starting_pagetab[]={
	0,
	3,
	4,
	5,
	11,
	13,
	23,
	32,
	40,
	50,
	72,
	100,
	130,
	156,
	177,
	193,
	205,
	220,
	221,
	235,
	242,
	243,
	244,
	246,
	260,
	267,
	279,
	289,
	304,
	316,
	317,
	318,
	334,
	341,
	343,
	344,
	345,
	348,
	349,
	350,
	351,
	352,
	353,
	354,
	357,
	360,
	374,
	377,
	379,
	383,
	387,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	398,
	399,
	400,
	401,
	402,
	403,
	404,
	405,
	406,
	407,
	408,
	409,
	410,
	411,
	412,
	413,
	414,
	415,
	416,
	417,
	418,
	419,
	420,
	421,
	422,
	423,
	424,
	425,
	426,
	427,
	428,
	429,
	430,
	431,
	432,
	433,
	434,
	435,
	436,
	437,
	438,
	439,
	440,
	441,
	442,
	443,
	444,
	445,
	446,
	447,
	448,
	449,
	450,
	451,
	452,
	453,
	454,
	455,
	456,
	457,
	458,
	459,
	460,
	461,
	462,
	463,
	464,
	465,
	466,
	467,
	468,
	469,
	470,
	471,
	472,
	473,
	474,
	475,
	476,
	477,
	478,
	479,
	480,
	481,
	482,
	483,
	484,
	485,
	486,
	487,
	488,
	489,
	490,
	491,
	492,
	493,
	494,
	495,
	496,
	497,
	498,
	499,
	500,
	501,
	502,
	505,
	506,
	512,
	517,
	527,
	538,
	554,
	564,
	565,
	566,
	567,
	568,
	569,
	570,
	571,
	572,
	573,
	574,
	575,
	576,
	577,
	578,
	579,
	580,
	581,
	582,
	583,
	584,
	585,
	586,
	587,
	588,
	589,
	590,
	591,
	592,
	593,
	594,
	595,
	596,
	597,
	598,
	599,
	600,
	601,
	602,
	603,
	604,
	605,
	606,
	607,
	610,
	611,
	613,
	623,
	624,
	628,
	634,
	643,
	650,
	656,
	659,
	665,
	669,
	679,
	680,
	686,
	697,
	703,
	712,
	718,
	722,
	724,
	728,
	735,
	747,
	757,
	771,
	785,
	799,
	804,
	816,
	820,
	825,
	840,
	850,
	851,
	860,
	872,
	874,
	882,
	883,
	884,
	885,
	886,
	889,
	890,
	891,
	892,
	893,
	894,
	895,
	897,
	898,
	899,
	900,
	901,
	902,
	909,
	915,
	916,
	921,
	922,
	923,
	924,
	925,
	926,
	927,
	928,
	929,
	930,
	931,
	932,
	933,
	934,
	935,
	936,
	937,
	938,
	939,
	940,
	941,
	942,
	943,
	944,
	945,
	946,
	947,
	948,
	949,
	950,
	951,
	954,
	955,
	961,
	962,
	968,
	969,
	970,
	977,
	981,
	983,
	993,
	1003,
	1005,
	1007,
	1008,
	1009,
	1013,
	1015,
	1016,
	1020,
	1024,
	1026,
	1030,
	1032,
	1036,
	1037,
	1038,
	1072,
	1078,
	1080,
	1085,
	1086,
	1087,
	1088,
	1091,
	1095,
	1101,
	1102,
	1111,
	1114,
	1115,
	1116,
	1117,
	1118,
	1119,
	1120,
	1121,
	1122,
	1123,
	1124,
	1125,
	1126,
	1127,
	1128,
	1129,
	1130,
	1131,
	1132,
	1133,
	1134,
	1135,
	1136,
	1137,
	1138,
	1139,
	1140,
	1141,
	1142,
	1143,
	1144,
	1145,
	1146,
	1147,
	1148,
	1149,
	1150,
	1151,
	1152,
	1153,
	1154,
	1155,
	1156,
	1157,
	1158,
	1159,
	1160,
	1161,
	1162,
	1163,
	1164,
	1165,
	1166,
	1167,
	1168,
	1169,
	1170,
	1171,
	1172,
	1173,
	1174,
	1175,
	1176,
	1177,
	1178,
	1179,
	1180,
	1181,
	1182,
	1183,
	1184,
	1185,
	1186,
	1187,
	1188,
	1189,
	1190,
	1191,
	1192,
	1193,
	1194,
	1195,
	1196,
	1197,
	1198,
	1199,
	1200,
	1201,
	1202,
	1203,
	1204,
	1205,
	1206,
	1207,
	1208,
	1209,
	1210,
	1211,
	1212,
	1213,
	1214,
	1215,
	1216,
	1217,
	1218,
	1219,
	1220,
	1221,
	1222,
	1223,
	1224,
	1225,
	1226,
	1227,
	1228,
	1229,
	1230,
	1231,
	1232,
	1233,
	1234,
	1235,
	1236,
	1237,
	1238,
	1239,
	1240,
	1241,
	1242,
	1243,
	1244,
	1245,
	1246,
	1247,
	1248,
	1249,
	1250,
	1251,
	1252,
	1253,
	1254,
	1255,
	1256,
	1257,
	1258,
	1259,
	1260,
	1261,
	1262,
	1263,
	1264,
	1265,
	1266,
	1267,
	1268,
	1269,
	1270,
	1271,
	1272,
	1273,
	1274,
	1275,
	1276,
	1277,
	1278,
	1279,
	1280,
	1281,
	1282,
	1283,
	1284,
	1285,
	1286,
	1287,
	1288,
	1289,
	1290,
	1291,
	1292,
	1293,
	1294,
	1295,
	1296,
	1297,
	1299,
	1301,
	1302,
	1303,
	1304,
	1305,
	1306,
	1307,
	1308,
	1309,
	1310,
	1311,
	1312,
	1313,
	1314,
	1315,
	1316,
	1317,
	1318,
	1319,
	1320,
	1321,
	1322,
	1324,
	1325,
	1326,
	1327,
	1328,
	1329,
	1330,
	1331,
	1332,
	1333,
	1334,
	1335,
	1336,
	1337,
	1338,
	1339,
	1340,
	1341,
	1342,
	1343,
	1344,
	1345,
	1346,
	1347,
	1348,
	1349,
	1350,
	1351,
	1352,
	1354,
	1355,
	1356,
	1357,
	1358,
	1359,
	1360,
	1361,
	1362,
	1363,
	1364,
	1365,
	1366,
	1367,
	1368,
	1369,
	1370,
	1371,
	1372,
	1373,
	1374,
	1375,
	1376,
	1377,
	1378,
	1379,
	1381,
	1382,
	1383,
	1384,
	1385,
	1386,
	1387,
	1388,
	1389,
	1390,
	1391,
	1392,
	1393,
	1394,
	1395,
	1396
};

static const uint8_t Grapheme_Extend_rangetab[][2]={
	{0x0300 & 0xFF, 0x036f & 0xFF},
	{0x0483 & 0xFF, 0x0489 & 0xFF},
	{0x0591 & 0xFF, 0x05bd & 0xFF},
	{0x05bf & 0xFF, 0x05bf & 0xFF},
	{0x05c1 & 0xFF, 0x05c2 & 0xFF},
	{0x05c4 & 0xFF, 0x05c5 & 0xFF},
	{0x05c7 & 0xFF, 0x05c7 & 0xFF},
	{0x0610 & 0xFF, 0x061a & 0xFF},
	{0x064b & 0xFF, 0x065f & 0xFF},
	{0x0670 & 0xFF, 0x0670 & 0xFF},
	{0x06d6 & 0xFF, 0x06dc & 0xFF},
	{0x06df & 0xFF, 0x06e4 & 0xFF},
	{0x06e7 & 0xFF, 0x06e8 & 0xFF},
	{0x06ea & 0xFF, 0x06ed & 0xFF},
	{0x0711 & 0xFF, 0x0711 & 0xFF},
	{0x0730 & 0xFF, 0x074a & 0xFF},
	{0x07a6 & 0xFF, 0x07b0 & 0xFF},
	{0x07eb & 0xFF, 0x07f3 & 0xFF},
	{0x07fd & 0xFF, 0x07fd & 0xFF},
	{0x0816 & 0xFF, 0x0819 & 0xFF},
	{0x081b & 0xFF, 0x0823 & 0xFF},
	{0x0825 & 0xFF, 0x0827 & 0xFF},
	{0x0829 & 0xFF, 0x082d & 0xFF},
	{0x0859 & 0xFF, 0x085b & 0xFF},
	{0x0898 & 0xFF, 0x089f & 0xFF},
	{0x08ca & 0xFF, 0x08e1 & 0xFF},
	{0x08e3 & 0xFF, 0x08ff & 0xFF},
	{0x0900 & 0xFF, 0x0902 & 0xFF},
	{0x093a & 0xFF, 0x093a & 0xFF},
	{0x093c & 0xFF, 0x093c & 0xFF},
	{0x0941 & 0xFF, 0x0948 & 0xFF},
	{0x094d & 0xFF, 0x094d & 0xFF},
	{0x0951 & 0xFF, 0x0957 & 0xFF},
	{0x0962 & 0xFF, 0x0963 & 0xFF},
	{0x0981 & 0xFF, 0x0981 & 0xFF},
	{0x09bc & 0xFF, 0x09bc & 0xFF},
	{0x09be & 0xFF, 0x09be & 0xFF},
	{0x09c1 & 0xFF, 0x09c4 & 0xFF},
	{0x09cd & 0xFF, 0x09cd & 0xFF},
	{0x09d7 & 0xFF, 0x09d7 & 0xFF},
	{0x09e2 & 0xFF, 0x09e3 & 0xFF},
	{0x09fe & 0xFF, 0x09fe & 0xFF},
	{0x0a01 & 0xFF, 0x0a02 & 0xFF},
	{0x0a3c & 0xFF, 0x0a3c & 0xFF},
	{0x0a41 & 0xFF, 0x0a42 & 0xFF},
	{0x0a47 & 0xFF, 0x0a48 & 0xFF},
	{0x0a4b & 0xFF, 0x0a4d & 0xFF},
	{0x0a51 & 0xFF, 0x0a51 & 0xFF},
	{0x0a70 & 0xFF, 0x0a71 & 0xFF},
	{0x0a75 & 0xFF, 0x0a75 & 0xFF},
	{0x0a81 & 0xFF, 0x0a82 & 0xFF},
	{0x0abc & 0xFF, 0x0abc & 0xFF},
	{0x0ac1 & 0xFF, 0x0ac5 & 0xFF},
	{0x0ac7 & 0xFF, 0x0ac8 & 0xFF},
	{0x0acd & 0xFF, 0x0acd & 0xFF},
	{0x0ae2 & 0xFF, 0x0ae3 & 0xFF},
	{0x0afa & 0xFF, 0x0aff & 0xFF},
	{0x0b01 & 0xFF, 0x0b01 & 0xFF},
	{0x0b3c & 0xFF, 0x0b3c & 0xFF},
	{0x0b3e & 0xFF, 0x0b3f & 0xFF},
	{0x0b41 & 0xFF, 0x0b44 & 0xFF},
	{0x0b4d & 0xFF, 0x0b4d & 0xFF},
	{0x0b55 & 0xFF, 0x0b57 & 0xFF},
	{0x0b62 & 0xFF, 0x0b63 & 0xFF},
	{0x0b82 & 0xFF, 0x0b82 & 0xFF},
	{0x0bbe & 0xFF, 0x0bbe & 0xFF},
	{0x0bc0 & 0xFF, 0x0bc0 & 0xFF},
	{0x0bcd & 0xFF, 0x0bcd & 0xFF},
	{0x0bd7 & 0xFF, 0x0bd7 & 0xFF},
	{0x0c00 & 0xFF, 0x0c00 & 0xFF},
	{0x0c04 & 0xFF, 0x0c04 & 0xFF},
	{0x0c3c & 0xFF, 0x0c3c & 0xFF},
	{0x0c3e & 0xFF, 0x0c40 & 0xFF},
	{0x0c46 & 0xFF, 0x0c48 & 0xFF},
	{0x0c4a & 0xFF, 0x0c4d & 0xFF},
	{0x0c55 & 0xFF, 0x0c56 & 0xFF},
	{0x0c62 & 0xFF, 0x0c63 & 0xFF},
	{0x0c81 & 0xFF, 0x0c81 & 0xFF},
	{0x0cbc & 0xFF, 0x0cbc & 0xFF},
	{0x0cbf & 0xFF, 0x0cbf & 0xFF},
	{0x0cc2 & 0xFF, 0x0cc2 & 0xFF},
	{0x0cc6 & 0xFF, 0x0cc6 & 0xFF},
	{0x0ccc & 0xFF, 0x0ccd & 0xFF},
	{0x0cd5 & 0xFF, 0x0cd6 & 0xFF},
	{0x0ce2 & 0xFF, 0x0ce3 & 0xFF},
	{0x0d00 & 0xFF, 0x0d01 & 0xFF},
	{0x0d3b & 0xFF, 0x0d3c & 0xFF},
	{0x0d3e & 0xFF, 0x0d3e & 0xFF},
	{0x0d41 & 0xFF, 0x0d44 & 0xFF},
	{0x0d4d & 0xFF, 0x0d4d & 0xFF},
	{0x0d57 & 0xFF, 0x0d57 & 0xFF},
	{0x0d62 & 0xFF, 0x0d63 & 0xFF},
	{0x0d81 & 0xFF, 0x0d81 & 0xFF},
	{0x0dca & 0xFF, 0x0dca & 0xFF},
	{0x0dcf & 0xFF, 0x0dcf & 0xFF},
	{0x0dd2 & 0xFF, 0x0dd4 & 0xFF},
	{0x0dd6 & 0xFF, 0x0dd6 & 0xFF},
	{0x0ddf & 0xFF, 0x0ddf & 0xFF},
	{0x0e31 & 0xFF, 0x0e31 & 0xFF},
	{0x0e34 & 0xFF, 0x0e3a & 0xFF},
	{0x0e47 & 0xFF, 0x0e4e & 0xFF},
	{0x0eb1 & 0xFF, 0x0eb1 & 0xFF},
	{0x0eb4 & 0xFF, 0x0ebc & 0xFF},
	{0x0ec8 & 0xFF, 0x0ece & 0xFF},
	{0x0f18 & 0xFF, 0x0f19 & 0xFF},
	{0x0f35 & 0xFF, 0x0f35 & 0xFF},
	{0x0f37 & 0xFF, 0x0f37 & 0xFF},
	{0x0f39 & 0xFF, 0x0f39 & 0xFF},
	{0x0f71 & 0xFF, 0x0f7e & 0xFF},
	{0x0f80 & 0xFF, 0x0f84 & 0xFF},
	{0x0f86 & 0xFF, 0x0f87 & 0xFF},
	{0x0f8d & 0xFF, 0x0f97 & 0xFF},
	{0x0f99 & 0xFF, 0x0fbc & 0xFF},
	{0x0fc6 & 0xFF, 0x0fc6 & 0xFF},
	{0x102d & 0xFF, 0x1030 & 0xFF},
	{0x1032 & 0xFF, 0x1037 & 0xFF},
	{0x1039 & 0xFF, 0x103a & 0xFF},
	{0x103d & 0xFF, 0x103e & 0xFF},
	{0x1058 & 0xFF, 0x1059 & 0xFF},
	{0x105e & 0xFF, 0x1060 & 0xFF},
	{0x1071 & 0xFF, 0x1074 & 0xFF},
	{0x1082 & 0xFF, 0x1082 & 0xFF},
	{0x1085 & 0xFF, 0x1086 & 0xFF},
	{0x108d & 0xFF, 0x108d & 0xFF},
	{0x109d & 0xFF, 0x109d & 0xFF},
	{0x135d & 0xFF, 0x135f & 0xFF},
	{0x1712 & 0xFF, 0x1714 & 0xFF},
	{0x1732 & 0xFF, 0x1733 & 0xFF},
	{0x1752 & 0xFF, 0x1753 & 0xFF},
	{0x1772 & 0xFF, 0x1773 & 0xFF},
	{0x17b4 & 0xFF, 0x17b5 & 0xFF},
	{0x17b7 & 0xFF, 0x17bd & 0xFF},
	{0x17c6 & 0xFF, 0x17c6 & 0xFF},
	{0x17c9 & 0xFF, 0x17d3 & 0xFF},
	{0x17dd & 0xFF, 0x17dd & 0xFF},
	{0x180b & 0xFF, 0x180d & 0xFF},
	{0x180f & 0xFF, 0x180f & 0xFF},
	{0x1885 & 0xFF, 0x1886 & 0xFF},
	{0x18a9 & 0xFF, 0x18a9 & 0xFF},
	{0x1920 & 0xFF, 0x1922 & 0xFF},
	{0x1927 & 0xFF, 0x1928 & 0xFF},
	{0x1932 & 0xFF, 0x1932 & 0xFF},
	{0x1939 & 0xFF, 0x193b & 0xFF},
	{0x1a17 & 0xFF, 0x1a18 & 0xFF},
	{0x1a1b & 0xFF, 0x1a1b & 0xFF},
	{0x1a56 & 0xFF, 0x1a56 & 0xFF},
	{0x1a58 & 0xFF, 0x1a5e & 0xFF},
	{0x1a60 & 0xFF, 0x1a60 & 0xFF},
	{0x1a62 & 0xFF, 0x1a62 & 0xFF},
	{0x1a65 & 0xFF, 0x1a6c & 0xFF},
	{0x1a73 & 0xFF, 0x1a7c & 0xFF},
	{0x1a7f & 0xFF, 0x1a7f & 0xFF},
	{0x1ab0 & 0xFF, 0x1ace & 0xFF},
	{0x1b00 & 0xFF, 0x1b03 & 0xFF},
	{0x1b34 & 0xFF, 0x1b3a & 0xFF},
	{0x1b3c & 0xFF, 0x1b3c & 0xFF},
	{0x1b42 & 0xFF, 0x1b42 & 0xFF},
	{0x1b6b & 0xFF, 0x1b73 & 0xFF},
	{0x1b80 & 0xFF, 0x1b81 & 0xFF},
	{0x1ba2 & 0xFF, 0x1ba5 & 0xFF},
	{0x1ba8 & 0xFF, 0x1ba9 & 0xFF},
	{0x1bab & 0xFF, 0x1bad & 0xFF},
	{0x1be6 & 0xFF, 0x1be6 & 0xFF},
	{0x1be8 & 0xFF, 0x1be9 & 0xFF},
	{0x1bed & 0xFF, 0x1bed & 0xFF},
	{0x1bef & 0xFF, 0x1bf1 & 0xFF},
	{0x1c2c & 0xFF, 0x1c33 & 0xFF},
	{0x1c36 & 0xFF, 0x1c37 & 0xFF},
	{0x1cd0 & 0xFF, 0x1cd2 & 0xFF},
	{0x1cd4 & 0xFF, 0x1ce0 & 0xFF},
	{0x1ce2 & 0xFF, 0x1ce8 & 0xFF},
	{0x1ced & 0xFF, 0x1ced & 0xFF},
	{0x1cf4 & 0xFF, 0x1cf4 & 0xFF},
	{0x1cf8 & 0xFF, 0x1cf9 & 0xFF},
	{0x1dc0 & 0xFF, 0x1dff & 0xFF},
	{0x200c & 0xFF, 0x200c & 0xFF},
	{0x20d0 & 0xFF, 0x20f0 & 0xFF},
	{0x2cef & 0xFF, 0x2cf1 & 0xFF},
	{0x2d7f & 0xFF, 0x2d7f & 0xFF},
	{0x2de0 & 0xFF, 0x2dff & 0xFF},
	{0x302a & 0xFF, 0x302f & 0xFF},
	{0x3099 & 0xFF, 0x309a & 0xFF},
	{0xa66f & 0xFF, 0xa672 & 0xFF},
	{0xa674 & 0xFF, 0xa67d & 0xFF},
	{0xa69e & 0xFF, 0xa69f & 0xFF},
	{0xa6f0 & 0xFF, 0xa6f1 & 0xFF},
	{0xa802 & 0xFF, 0xa802 & 0xFF},
	{0xa806 & 0xFF, 0xa806 & 0xFF},
	{0xa80b & 0xFF, 0xa80b & 0xFF},
	{0xa825 & 0xFF, 0xa826 & 0xFF},
	{0xa82c & 0xFF, 0xa82c & 0xFF},
	{0xa8c4 & 0xFF, 0xa8c5 & 0xFF},
	{0xa8e0 & 0xFF, 0xa8f1 & 0xFF},
	{0xa8ff & 0xFF, 0xa8ff & 0xFF},
	{0xa926 & 0xFF, 0xa92d & 0xFF},
	{0xa947 & 0xFF, 0xa951 & 0xFF},
	{0xa980 & 0xFF, 0xa982 & 0xFF},
	{0xa9b3 & 0xFF, 0xa9b3 & 0xFF},
	{0xa9b6 & 0xFF, 0xa9b9 & 0xFF},
	{0xa9bc & 0xFF, 0xa9bd & 0xFF},
	{0xa9e5 & 0xFF, 0xa9e5 & 0xFF},
	{0xaa29 & 0xFF, 0xaa2e & 0xFF},
	{0xaa31 & 0xFF, 0xaa32 & 0xFF},
	{0xaa35 & 0xFF, 0xaa36 & 0xFF},
	{0xaa43 & 0xFF, 0xaa43 & 0xFF},
	{0xaa4c & 0xFF, 0xaa4c & 0xFF},
	{0xaa7c & 0xFF, 0xaa7c & 0xFF},
	{0xaab0 & 0xFF, 0xaab0 & 0xFF},
	{0xaab2 & 0xFF, 0xaab4 & 0xFF},
	{0xaab7 & 0xFF, 0xaab8 & 0xFF},
	{0xaabe & 0xFF, 0xaabf & 0xFF},
	{0xaac1 & 0xFF, 0xaac1 & 0xFF},
	{0xaaec & 0xFF, 0xaaed & 0xFF},
	{0xaaf6 & 0xFF, 0xaaf6 & 0xFF},
	{0xabe5 & 0xFF, 0xabe5 & 0xFF},
	{0xabe8 & 0xFF, 0xabe8 & 0xFF},
	{0xabed & 0xFF, 0xabed & 0xFF},
	{0xfb1e & 0xFF, 0xfb1e & 0xFF},
	{0xfe00 & 0xFF, 0xfe0f & 0xFF},
	{0xfe20 & 0xFF, 0xfe2f & 0xFF},
	{0xff9e & 0xFF, 0xff9f & 0xFF},
	{0x101fd & 0xFF, 0x101fd & 0xFF},
	{0x102e0 & 0xFF, 0x102e0 & 0xFF},
	{0x10376 & 0xFF, 0x1037a & 0xFF},
	{0x10a01 & 0xFF, 0x10a03 & 0xFF},
	{0x10a05 & 0xFF, 0x10a06 & 0xFF},
	{0x10a0c & 0xFF, 0x10a0f & 0xFF},
	{0x10a38 & 0xFF, 0x10a3a & 0xFF},
	{0x10a3f & 0xFF, 0x10a3f & 0xFF},
	{0x10ae5 & 0xFF, 0x10ae6 & 0xFF},
	{0x10d24 & 0xFF, 0x10d27 & 0xFF},
	{0x10eab & 0xFF, 0x10eac & 0xFF},
	{0x10efd & 0xFF, 0x10eff & 0xFF},
	{0x10f46 & 0xFF, 0x10f50 & 0xFF},
	{0x10f82 & 0xFF, 0x10f85 & 0xFF},
	{0x11001 & 0xFF, 0x11001 & 0xFF},
	{0x11038 & 0xFF, 0x11046 & 0xFF},
	{0x11070 & 0xFF, 0x11070 & 0xFF},
	{0x11073 & 0xFF, 0x11074 & 0xFF},
	{0x1107f & 0xFF, 0x11081 & 0xFF},
	{0x110b3 & 0xFF, 0x110b6 & 0xFF},
	{0x110b9 & 0xFF, 0x110ba & 0xFF},
	{0x110c2 & 0xFF, 0x110c2 & 0xFF},
	{0x11100 & 0xFF, 0x11102 & 0xFF},
	{0x11127 & 0xFF, 0x1112b & 0xFF},
	{0x1112d & 0xFF, 0x11134 & 0xFF},
	{0x11173 & 0xFF, 0x11173 & 0xFF},
	{0x11180 & 0xFF, 0x11181 & 0xFF},
	{0x111b6 & 0xFF, 0x111be & 0xFF},
	{0x111c9 & 0xFF, 0x111cc & 0xFF},
	{0x111cf & 0xFF, 0x111cf & 0xFF},
	{0x1122f & 0xFF, 0x11231 & 0xFF},
	{0x11234 & 0xFF, 0x11234 & 0xFF},
	{0x11236 & 0xFF, 0x11237 & 0xFF},
	{0x1123e & 0xFF, 0x1123e & 0xFF},
	{0x11241 & 0xFF, 0x11241 & 0xFF},
	{0x112df & 0xFF, 0x112df & 0xFF},
	{0x112e3 & 0xFF, 0x112ea & 0xFF},
	{0x11300 & 0xFF, 0x11301 & 0xFF},
	{0x1133b & 0xFF, 0x1133c & 0xFF},
	{0x1133e & 0xFF, 0x1133e & 0xFF},
	{0x11340 & 0xFF, 0x11340 & 0xFF},
	{0x11357 & 0xFF, 0x11357 & 0xFF},
	{0x11366 & 0xFF, 0x1136c & 0xFF},
	{0x11370 & 0xFF, 0x11374 & 0xFF},
	{0x11438 & 0xFF, 0x1143f & 0xFF},
	{0x11442 & 0xFF, 0x11444 & 0xFF},
	{0x11446 & 0xFF, 0x11446 & 0xFF},
	{0x1145e & 0xFF, 0x1145e & 0xFF},
	{0x114b0 & 0xFF, 0x114b0 & 0xFF},
	{0x114b3 & 0xFF, 0x114b8 & 0xFF},
	{0x114ba & 0xFF, 0x114ba & 0xFF},
	{0x114bd & 0xFF, 0x114bd & 0xFF},
	{0x114bf & 0xFF, 0x114c0 & 0xFF},
	{0x114c2 & 0xFF, 0x114c3 & 0xFF},
	{0x115af & 0xFF, 0x115af & 0xFF},
	{0x115b2 & 0xFF, 0x115b5 & 0xFF},
	{0x115bc & 0xFF, 0x115bd & 0xFF},
	{0x115bf & 0xFF, 0x115c0 & 0xFF},
	{0x115dc & 0xFF, 0x115dd & 0xFF},
	{0x11633 & 0xFF, 0x1163a & 0xFF},
	{0x1163d & 0xFF, 0x1163d & 0xFF},
	{0x1163f & 0xFF, 0x11640 & 0xFF},
	{0x116ab & 0xFF, 0x116ab & 0xFF},
	{0x116ad & 0xFF, 0x116ad & 0xFF},
	{0x116b0 & 0xFF, 0x116b5 & 0xFF},
	{0x116b7 & 0xFF, 0x116b7 & 0xFF},
	{0x1171d & 0xFF, 0x1171f & 0xFF},
	{0x11722 & 0xFF, 0x11725 & 0xFF},
	{0x11727 & 0xFF, 0x1172b & 0xFF},
	{0x1182f & 0xFF, 0x11837 & 0xFF},
	{0x11839 & 0xFF, 0x1183a & 0xFF},
	{0x11930 & 0xFF, 0x11930 & 0xFF},
	{0x1193b & 0xFF, 0x1193c & 0xFF},
	{0x1193e & 0xFF, 0x1193e & 0xFF},
	{0x11943 & 0xFF, 0x11943 & 0xFF},
	{0x119d4 & 0xFF, 0x119d7 & 0xFF},
	{0x119da & 0xFF, 0x119db & 0xFF},
	{0x119e0 & 0xFF, 0x119e0 & 0xFF},
	{0x11a01 & 0xFF, 0x11a0a & 0xFF},
	{0x11a33 & 0xFF, 0x11a38 & 0xFF},
	{0x11a3b & 0xFF, 0x11a3e & 0xFF},
	{0x11a47 & 0xFF, 0x11a47 & 0xFF},
	{0x11a51 & 0xFF, 0x11a56 & 0xFF},
	{0x11a59 & 0xFF, 0x11a5b & 0xFF},
	{0x11a8a & 0xFF, 0x11a96 & 0xFF},
	{0x11a98 & 0xFF, 0x11a99 & 0xFF},
	{0x11c30 & 0xFF, 0x11c36 & 0xFF},
	{0x11c38 & 0xFF, 0x11c3d & 0xFF},
	{0x11c3f & 0xFF, 0x11c3f & 0xFF},
	{0x11c92 & 0xFF, 0x11ca7 & 0xFF},
	{0x11caa & 0xFF, 0x11cb0 & 0xFF},
	{0x11cb2 & 0xFF, 0x11cb3 & 0xFF},
	{0x11cb5 & 0xFF, 0x11cb6 & 0xFF},
	{0x11d31 & 0xFF, 0x11d36 & 0xFF},
	{0x11d3a & 0xFF, 0x11d3a & 0xFF},
	{0x11d3c & 0xFF, 0x11d3d & 0xFF},
	{0x11d3f & 0xFF, 0x11d45 & 0xFF},
	{0x11d47 & 0xFF, 0x11d47 & 0xFF},
	{0x11d90 & 0xFF, 0x11d91 & 0xFF},
	{0x11d95 & 0xFF, 0x11d95 & 0xFF},
	{0x11d97 & 0xFF, 0x11d97 & 0xFF},
	{0x11ef3 & 0xFF, 0x11ef4 & 0xFF},
	{0x11f00 & 0xFF, 0x11f01 & 0xFF},
	{0x11f36 & 0xFF, 0x11f3a & 0xFF},
	{0x11f40 & 0xFF, 0x11f40 & 0xFF},
	{0x11f42 & 0xFF, 0x11f42 & 0xFF},
	{0x13440 & 0xFF, 0x13440 & 0xFF},
	{0x13447 & 0xFF, 0x13455 & 0xFF},
	{0x16af0 & 0xFF, 0x16af4 & 0xFF},
	{0x16b30 & 0xFF, 0x16b36 & 0xFF},
	{0x16f4f & 0xFF, 0x16f4f & 0xFF},
	{0x16f8f & 0xFF, 0x16f92 & 0xFF},
	{0x16fe4 & 0xFF, 0x16fe4 & 0xFF},
	{0x1bc9d & 0xFF, 0x1bc9e & 0xFF},
	{0x1cf00 & 0xFF, 0x1cf2d & 0xFF},
	{0x1cf30 & 0xFF, 0x1cf46 & 0xFF},
	{0x1d165 & 0xFF, 0x1d165 & 0xFF},
	{0x1d167 & 0xFF, 0x1d169 & 0xFF},
	{0x1d16e & 0xFF, 0x1d172 & 0xFF},
	{0x1d17b & 0xFF, 0x1d182 & 0xFF},
	{0x1d185 & 0xFF, 0x1d18b & 0xFF},
	{0x1d1aa & 0xFF, 0x1d1ad & 0xFF},
	{0x1d242 & 0xFF, 0x1d244 & 0xFF},
	{0x1da00 & 0xFF, 0x1da36 & 0xFF},
	{0x1da3b & 0xFF, 0x1da6c & 0xFF},
	{0x1da75 & 0xFF, 0x1da75 & 0xFF},
	{0x1da84 & 0xFF, 0x1da84 & 0xFF},
	{0x1da9b & 0xFF, 0x1da9f & 0xFF},
	{0x1daa1 & 0xFF, 0x1daaf & 0xFF},
	{0x1e000 & 0xFF, 0x1e006 & 0xFF},
	{0x1e008 & 0xFF, 0x1e018 & 0xFF},
	{0x1e01b & 0xFF, 0x1e021 & 0xFF},
	{0x1e023 & 0xFF, 0x1e024 & 0xFF},
	{0x1e026 & 0xFF, 0x1e02a & 0xFF},
	{0x1e08f & 0xFF, 0x1e08f & 0xFF},
	{0x1e130 & 0xFF, 0x1e136 & 0xFF},
	{0x1e2ae & 0xFF, 0x1e2ae & 0xFF},
	{0x1e2ec & 0xFF, 0x1e2ef & 0xFF},
	{0x1e4ec & 0xFF, 0x1e4ef & 0xFF},
	{0x1e8d0 & 0xFF, 0x1e8d6 & 0xFF},
	{0x1e944 & 0xFF, 0x1e94a & 0xFF},
	{0xe0020 & 0xFF, 0xe007f & 0xFF},
	{0xe0100 & 0xFF, 0xe01ef & 0xFF}};

static const size_t Grapheme_Extend_starting_indextab[]={
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	19,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	32,
	44,
	45,
	48,
	166,
	168,
	169,
	170,
	171,
	251,
	254,
	255,
	257,
	258,
	259,
	266,
	269,
	270,
	271,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	284,
	285,
	286,
	287,
	308,
	362,
	363,
	367,
	444,
	463,
	465,
	466,
	474,
	480,
	481,
	482,
	484,
	488,
	489,
	3584,
	3585
};

static const char32_t Grapheme_Extend_starting_pagetab[]={
	0,
	1,
	2,
	7,
	14,
	19,
	27,
	42,
	57,
	69,
	85,
	98,
	104,
	114,
	125,
	126,
	135,
	139,
	143,
	153,
	166,
	174,
	175,
	177,
	178,
	180,
	182,
	186,
	194,
	201,
	214,
	217,
	218,
	220,
	221,
	222,
	223,
	224,
	230,
	231,
	233,
	235,
	243,
	251,
	258,
	265,
	275,
	280,
	287,
	290,
	292,
	299,
	307,
	314,
	322,
	323,
	327,
	329,
	330,
	331,
	334,
	335,
	337,
	343,
	344,
	350,
	356,
	357,
	359,
	360,
	361,
	362,
	363
};

static const uint8_t Grapheme_Link_rangetab[][2]={
	{0x094d & 0xFF, 0x094d & 0xFF},
	{0x09cd & 0xFF, 0x09cd & 0xFF},
	{0x0a4d & 0xFF, 0x0a4d & 0xFF},
	{0x0acd & 0xFF, 0x0acd & 0xFF},
	{0x0b4d & 0xFF, 0x0b4d & 0xFF},
	{0x0bcd & 0xFF, 0x0bcd & 0xFF},
	{0x0c4d & 0xFF, 0x0c4d & 0xFF},
	{0x0ccd & 0xFF, 0x0ccd & 0xFF},
	{0x0d3b & 0xFF, 0x0d3c & 0xFF},
	{0x0d4d & 0xFF, 0x0d4d & 0xFF},
	{0x0dca & 0xFF, 0x0dca & 0xFF},
	{0x0e3a & 0xFF, 0x0e3a & 0xFF},
	{0x0eba & 0xFF, 0x0eba & 0xFF},
	{0x0f84 & 0xFF, 0x0f84 & 0xFF},
	{0x1039 & 0xFF, 0x103a & 0xFF},
	{0x1714 & 0xFF, 0x1715 & 0xFF},
	{0x1734 & 0xFF, 0x1734 & 0xFF},
	{0x17d2 & 0xFF, 0x17d2 & 0xFF},
	{0x1a60 & 0xFF, 0x1a60 & 0xFF},
	{0x1b44 & 0xFF, 0x1b44 & 0xFF},
	{0x1baa & 0xFF, 0x1bab & 0xFF},
	{0x1bf2 & 0xFF, 0x1bf3 & 0xFF},
	{0x2d7f & 0xFF, 0x2d7f & 0xFF},
	{0xa806 & 0xFF, 0xa806 & 0xFF},
	{0xa82c & 0xFF, 0xa82c & 0xFF},
	{0xa8c4 & 0xFF, 0xa8c4 & 0xFF},
	{0xa953 & 0xFF, 0xa953 & 0xFF},
	{0xa9c0 & 0xFF, 0xa9c0 & 0xFF},
	{0xaaf6 & 0xFF, 0xaaf6 & 0xFF},
	{0xabed & 0xFF, 0xabed & 0xFF},
	{0x10a3f & 0xFF, 0x10a3f & 0xFF},
	{0x11046 & 0xFF, 0x11046 & 0xFF},
	{0x11070 & 0xFF, 0x11070 & 0xFF},
	{0x1107f & 0xFF, 0x1107f & 0xFF},
	{0x110b9 & 0xFF, 0x110b9 & 0xFF},
	{0x11133 & 0xFF, 0x11134 & 0xFF},
	{0x111c0 & 0xFF, 0x111c0 & 0xFF},
	{0x11235 & 0xFF, 0x11235 & 0xFF},
	{0x112ea & 0xFF, 0x112ea & 0xFF},
	{0x1134d & 0xFF, 0x1134d & 0xFF},
	{0x11442 & 0xFF, 0x11442 & 0xFF},
	{0x114c2 & 0xFF, 0x114c2 & 0xFF},
	{0x115bf & 0xFF, 0x115bf & 0xFF},
	{0x1163f & 0xFF, 0x1163f & 0xFF},
	{0x116b6 & 0xFF, 0x116b6 & 0xFF},
	{0x1172b & 0xFF, 0x1172b & 0xFF},
	{0x11839 & 0xFF, 0x11839 & 0xFF},
	{0x1193d & 0xFF, 0x1193e & 0xFF},
	{0x119e0 & 0xFF, 0x119e0 & 0xFF},
	{0x11a34 & 0xFF, 0x11a34 & 0xFF},
	{0x11a47 & 0xFF, 0x11a47 & 0xFF},
	{0x11a99 & 0xFF, 0x11a99 & 0xFF},
	{0x11c3f & 0xFF, 0x11c3f & 0xFF},
	{0x11d44 & 0xFF, 0x11d45 & 0xFF},
	{0x11d97 & 0xFF, 0x11d97 & 0xFF},
	{0x11f41 & 0xFF, 0x11f42 & 0xFF}};

static const size_t Grapheme_Link_starting_indextab[]={
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	23,
	26,
	27,
	45,
	168,
	169,
	170,
	171,
	266,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	284,
	285,
	287
};

static const char32_t Grapheme_Link_starting_pagetab[]={
	0,
	2,
	4,
	6,
	8,
	11,
	13,
	14,
	15,
	18,
	19,
	22,
	23,
	26,
	28,
	29,
	30,
	31,
	35,
	37,
	39,
	40,
	42,
	43,
	45,
	46,
	47,
	49,
	52,
	53,
	55
};

static const uint8_t ID_Continue_rangetab[][2]={
	{0x0030 & 0xFF, 0x0039 & 0xFF},
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x005f & 0xFF, 0x005f & 0xFF},
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00aa & 0xFF, 0x00aa & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00b7 & 0xFF, 0x00b7 & 0xFF},
	{0x00ba & 0xFF, 0x00ba & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0100 & 0xFF, 0x01ff & 0xFF},
	{0x0200 & 0xFF, 0x02c1 & 0xFF},
	{0x02c6 & 0xFF, 0x02d1 & 0xFF},
	{0x02e0 & 0xFF, 0x02e4 & 0xFF},
	{0x02ec & 0xFF, 0x02ec & 0xFF},
	{0x02ee & 0xFF, 0x02ee & 0xFF},
	{0x0300 & 0xFF, 0x0374 & 0xFF},
	{0x0376 & 0xFF, 0x0377 & 0xFF},
	{0x037a & 0xFF, 0x037d & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03f5 & 0xFF},
	{0x03f7 & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x0481 & 0xFF},
	{0x0483 & 0xFF, 0x0487 & 0xFF},
	{0x048a & 0xFF, 0x04ff & 0xFF},
	{0x0500 & 0xFF, 0x052f & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x0559 & 0xFF, 0x0559 & 0xFF},
	{0x0560 & 0xFF, 0x0588 & 0xFF},
	{0x0591 & 0xFF, 0x05bd & 0xFF},
	{0x05bf & 0xFF, 0x05bf & 0xFF},
	{0x05c1 & 0xFF, 0x05c2 & 0xFF},
	{0x05c4 & 0xFF, 0x05c5 & 0xFF},
	{0x05c7 & 0xFF, 0x05c7 & 0xFF},
	{0x05d0 & 0xFF, 0x05ea & 0xFF},
	{0x05ef & 0xFF, 0x05f2 & 0xFF},
	{0x0610 & 0xFF, 0x061a & 0xFF},
	{0x0620 & 0xFF, 0x0669 & 0xFF},
	{0x066e & 0xFF, 0x06d3 & 0xFF},
	{0x06d5 & 0xFF, 0x06dc & 0xFF},
	{0x06df & 0xFF, 0x06e8 & 0xFF},
	{0x06ea & 0xFF, 0x06fc & 0xFF},
	{0x06ff & 0xFF, 0x06ff & 0xFF},
	{0x0710 & 0xFF, 0x074a & 0xFF},
	{0x074d & 0xFF, 0x07b1 & 0xFF},
	{0x07c0 & 0xFF, 0x07f5 & 0xFF},
	{0x07fa & 0xFF, 0x07fa & 0xFF},
	{0x07fd & 0xFF, 0x07fd & 0xFF},
	{0x0800 & 0xFF, 0x082d & 0xFF},
	{0x0840 & 0xFF, 0x085b & 0xFF},
	{0x0860 & 0xFF, 0x086a & 0xFF},
	{0x0870 & 0xFF, 0x0887 & 0xFF},
	{0x0889 & 0xFF, 0x088e & 0xFF},
	{0x0898 & 0xFF, 0x08e1 & 0xFF},
	{0x08e3 & 0xFF, 0x08ff & 0xFF},
	{0x0900 & 0xFF, 0x0963 & 0xFF},
	{0x0966 & 0xFF, 0x096f & 0xFF},
	{0x0971 & 0xFF, 0x0983 & 0xFF},
	{0x0985 & 0xFF, 0x098c & 0xFF},
	{0x098f & 0xFF, 0x0990 & 0xFF},
	{0x0993 & 0xFF, 0x09a8 & 0xFF},
	{0x09aa & 0xFF, 0x09b0 & 0xFF},
	{0x09b2 & 0xFF, 0x09b2 & 0xFF},
	{0x09b6 & 0xFF, 0x09b9 & 0xFF},
	{0x09bc & 0xFF, 0x09c4 & 0xFF},
	{0x09c7 & 0xFF, 0x09c8 & 0xFF},
	{0x09cb & 0xFF, 0x09ce & 0xFF},
	{0x09d7 & 0xFF, 0x09d7 & 0xFF},
	{0x09dc & 0xFF, 0x09dd & 0xFF},
	{0x09df & 0xFF, 0x09e3 & 0xFF},
	{0x09e6 & 0xFF, 0x09f1 & 0xFF},
	{0x09fc & 0xFF, 0x09fc & 0xFF},
	{0x09fe & 0xFF, 0x09fe & 0xFF},
	{0x0a01 & 0xFF, 0x0a03 & 0xFF},
	{0x0a05 & 0xFF, 0x0a0a & 0xFF},
	{0x0a0f & 0xFF, 0x0a10 & 0xFF},
	{0x0a13 & 0xFF, 0x0a28 & 0xFF},
	{0x0a2a & 0xFF, 0x0a30 & 0xFF},
	{0x0a32 & 0xFF, 0x0a33 & 0xFF},
	{0x0a35 & 0xFF, 0x0a36 & 0xFF},
	{0x0a38 & 0xFF, 0x0a39 & 0xFF},
	{0x0a3c & 0xFF, 0x0a3c & 0xFF},
	{0x0a3e & 0xFF, 0x0a42 & 0xFF},
	{0x0a47 & 0xFF, 0x0a48 & 0xFF},
	{0x0a4b & 0xFF, 0x0a4d & 0xFF},
	{0x0a51 & 0xFF, 0x0a51 & 0xFF},
	{0x0a59 & 0xFF, 0x0a5c & 0xFF},
	{0x0a5e & 0xFF, 0x0a5e & 0xFF},
	{0x0a66 & 0xFF, 0x0a75 & 0xFF},
	{0x0a81 & 0xFF, 0x0a83 & 0xFF},
	{0x0a85 & 0xFF, 0x0a8d & 0xFF},
	{0x0a8f & 0xFF, 0x0a91 & 0xFF},
	{0x0a93 & 0xFF, 0x0aa8 & 0xFF},
	{0x0aaa & 0xFF, 0x0ab0 & 0xFF},
	{0x0ab2 & 0xFF, 0x0ab3 & 0xFF},
	{0x0ab5 & 0xFF, 0x0ab9 & 0xFF},
	{0x0abc & 0xFF, 0x0ac5 & 0xFF},
	{0x0ac7 & 0xFF, 0x0ac9 & 0xFF},
	{0x0acb & 0xFF, 0x0acd & 0xFF},
	{0x0ad0 & 0xFF, 0x0ad0 & 0xFF},
	{0x0ae0 & 0xFF, 0x0ae3 & 0xFF},
	{0x0ae6 & 0xFF, 0x0aef & 0xFF},
	{0x0af9 & 0xFF, 0x0aff & 0xFF},
	{0x0b01 & 0xFF, 0x0b03 & 0xFF},
	{0x0b05 & 0xFF, 0x0b0c & 0xFF},
	{0x0b0f & 0xFF, 0x0b10 & 0xFF},
	{0x0b13 & 0xFF, 0x0b28 & 0xFF},
	{0x0b2a & 0xFF, 0x0b30 & 0xFF},
	{0x0b32 & 0xFF, 0x0b33 & 0xFF},
	{0x0b35 & 0xFF, 0x0b39 & 0xFF},
	{0x0b3c & 0xFF, 0x0b44 & 0xFF},
	{0x0b47 & 0xFF, 0x0b48 & 0xFF},
	{0x0b4b & 0xFF, 0x0b4d & 0xFF},
	{0x0b55 & 0xFF, 0x0b57 & 0xFF},
	{0x0b5c & 0xFF, 0x0b5d & 0xFF},
	{0x0b5f & 0xFF, 0x0b63 & 0xFF},
	{0x0b66 & 0xFF, 0x0b6f & 0xFF},
	{0x0b71 & 0xFF, 0x0b71 & 0xFF},
	{0x0b82 & 0xFF, 0x0b83 & 0xFF},
	{0x0b85 & 0xFF, 0x0b8a & 0xFF},
	{0x0b8e & 0xFF, 0x0b90 & 0xFF},
	{0x0b92 & 0xFF, 0x0b95 & 0xFF},
	{0x0b99 & 0xFF, 0x0b9a & 0xFF},
	{0x0b9c & 0xFF, 0x0b9c & 0xFF},
	{0x0b9e & 0xFF, 0x0b9f & 0xFF},
	{0x0ba3 & 0xFF, 0x0ba4 & 0xFF},
	{0x0ba8 & 0xFF, 0x0baa & 0xFF},
	{0x0bae & 0xFF, 0x0bb9 & 0xFF},
	{0x0bbe & 0xFF, 0x0bc2 & 0xFF},
	{0x0bc6 & 0xFF, 0x0bc8 & 0xFF},
	{0x0bca & 0xFF, 0x0bcd & 0xFF},
	{0x0bd0 & 0xFF, 0x0bd0 & 0xFF},
	{0x0bd7 & 0xFF, 0x0bd7 & 0xFF},
	{0x0be6 & 0xFF, 0x0bef & 0xFF},
	{0x0c00 & 0xFF, 0x0c0c & 0xFF},
	{0x0c0e & 0xFF, 0x0c10 & 0xFF},
	{0x0c12 & 0xFF, 0x0c28 & 0xFF},
	{0x0c2a & 0xFF, 0x0c39 & 0xFF},
	{0x0c3c & 0xFF, 0x0c44 & 0xFF},
	{0x0c46 & 0xFF, 0x0c48 & 0xFF},
	{0x0c4a & 0xFF, 0x0c4d & 0xFF},
	{0x0c55 & 0xFF, 0x0c56 & 0xFF},
	{0x0c58 & 0xFF, 0x0c5a & 0xFF},
	{0x0c5d & 0xFF, 0x0c5d & 0xFF},
	{0x0c60 & 0xFF, 0x0c63 & 0xFF},
	{0x0c66 & 0xFF, 0x0c6f & 0xFF},
	{0x0c80 & 0xFF, 0x0c83 & 0xFF},
	{0x0c85 & 0xFF, 0x0c8c & 0xFF},
	{0x0c8e & 0xFF, 0x0c90 & 0xFF},
	{0x0c92 & 0xFF, 0x0ca8 & 0xFF},
	{0x0caa & 0xFF, 0x0cb3 & 0xFF},
	{0x0cb5 & 0xFF, 0x0cb9 & 0xFF},
	{0x0cbc & 0xFF, 0x0cc4 & 0xFF},
	{0x0cc6 & 0xFF, 0x0cc8 & 0xFF},
	{0x0cca & 0xFF, 0x0ccd & 0xFF},
	{0x0cd5 & 0xFF, 0x0cd6 & 0xFF},
	{0x0cdd & 0xFF, 0x0cde & 0xFF},
	{0x0ce0 & 0xFF, 0x0ce3 & 0xFF},
	{0x0ce6 & 0xFF, 0x0cef & 0xFF},
	{0x0cf1 & 0xFF, 0x0cf3 & 0xFF},
	{0x0d00 & 0xFF, 0x0d0c & 0xFF},
	{0x0d0e & 0xFF, 0x0d10 & 0xFF},
	{0x0d12 & 0xFF, 0x0d44 & 0xFF},
	{0x0d46 & 0xFF, 0x0d48 & 0xFF},
	{0x0d4a & 0xFF, 0x0d4e & 0xFF},
	{0x0d54 & 0xFF, 0x0d57 & 0xFF},
	{0x0d5f & 0xFF, 0x0d63 & 0xFF},
	{0x0d66 & 0xFF, 0x0d6f & 0xFF},
	{0x0d7a & 0xFF, 0x0d7f & 0xFF},
	{0x0d81 & 0xFF, 0x0d83 & 0xFF},
	{0x0d85 & 0xFF, 0x0d96 & 0xFF},
	{0x0d9a & 0xFF, 0x0db1 & 0xFF},
	{0x0db3 & 0xFF, 0x0dbb & 0xFF},
	{0x0dbd & 0xFF, 0x0dbd & 0xFF},
	{0x0dc0 & 0xFF, 0x0dc6 & 0xFF},
	{0x0dca & 0xFF, 0x0dca & 0xFF},
	{0x0dcf & 0xFF, 0x0dd4 & 0xFF},
	{0x0dd6 & 0xFF, 0x0dd6 & 0xFF},
	{0x0dd8 & 0xFF, 0x0ddf & 0xFF},
	{0x0de6 & 0xFF, 0x0def & 0xFF},
	{0x0df2 & 0xFF, 0x0df3 & 0xFF},
	{0x0e01 & 0xFF, 0x0e3a & 0xFF},
	{0x0e40 & 0xFF, 0x0e4e & 0xFF},
	{0x0e50 & 0xFF, 0x0e59 & 0xFF},
	{0x0e81 & 0xFF, 0x0e82 & 0xFF},
	{0x0e84 & 0xFF, 0x0e84 & 0xFF},
	{0x0e86 & 0xFF, 0x0e8a & 0xFF},
	{0x0e8c & 0xFF, 0x0ea3 & 0xFF},
	{0x0ea5 & 0xFF, 0x0ea5 & 0xFF},
	{0x0ea7 & 0xFF, 0x0ebd & 0xFF},
	{0x0ec0 & 0xFF, 0x0ec4 & 0xFF},
	{0x0ec6 & 0xFF, 0x0ec6 & 0xFF},
	{0x0ec8 & 0xFF, 0x0ece & 0xFF},
	{0x0ed0 & 0xFF, 0x0ed9 & 0xFF},
	{0x0edc & 0xFF, 0x0edf & 0xFF},
	{0x0f00 & 0xFF, 0x0f00 & 0xFF},
	{0x0f18 & 0xFF, 0x0f19 & 0xFF},
	{0x0f20 & 0xFF, 0x0f29 & 0xFF},
	{0x0f35 & 0xFF, 0x0f35 & 0xFF},
	{0x0f37 & 0xFF, 0x0f37 & 0xFF},
	{0x0f39 & 0xFF, 0x0f39 & 0xFF},
	{0x0f3e & 0xFF, 0x0f47 & 0xFF},
	{0x0f49 & 0xFF, 0x0f6c & 0xFF},
	{0x0f71 & 0xFF, 0x0f84 & 0xFF},
	{0x0f86 & 0xFF, 0x0f97 & 0xFF},
	{0x0f99 & 0xFF, 0x0fbc & 0xFF},
	{0x0fc6 & 0xFF, 0x0fc6 & 0xFF},
	{0x1000 & 0xFF, 0x1049 & 0xFF},
	{0x1050 & 0xFF, 0x109d & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x10d0 & 0xFF, 0x10fa & 0xFF},
	{0x10fc & 0xFF, 0x10ff & 0xFF},
	{0x1100 & 0xFF, 0x11ff & 0xFF},
	{0x1200 & 0xFF, 0x1248 & 0xFF},
	{0x124a & 0xFF, 0x124d & 0xFF},
	{0x1250 & 0xFF, 0x1256 & 0xFF},
	{0x1258 & 0xFF, 0x1258 & 0xFF},
	{0x125a & 0xFF, 0x125d & 0xFF},
	{0x1260 & 0xFF, 0x1288 & 0xFF},
	{0x128a & 0xFF, 0x128d & 0xFF},
	{0x1290 & 0xFF, 0x12b0 & 0xFF},
	{0x12b2 & 0xFF, 0x12b5 & 0xFF},
	{0x12b8 & 0xFF, 0x12be & 0xFF},
	{0x12c0 & 0xFF, 0x12c0 & 0xFF},
	{0x12c2 & 0xFF, 0x12c5 & 0xFF},
	{0x12c8 & 0xFF, 0x12d6 & 0xFF},
	{0x12d8 & 0xFF, 0x12ff & 0xFF},
	{0x1300 & 0xFF, 0x1310 & 0xFF},
	{0x1312 & 0xFF, 0x1315 & 0xFF},
	{0x1318 & 0xFF, 0x135a & 0xFF},
	{0x135d & 0xFF, 0x135f & 0xFF},
	{0x1369 & 0xFF, 0x1371 & 0xFF},
	{0x1380 & 0xFF, 0x138f & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1401 & 0xFF, 0x14ff & 0xFF},
	{0x1500 & 0xFF, 0x15ff & 0xFF},
	{0x1600 & 0xFF, 0x166c & 0xFF},
	{0x166f & 0xFF, 0x167f & 0xFF},
	{0x1681 & 0xFF, 0x169a & 0xFF},
	{0x16a0 & 0xFF, 0x16ea & 0xFF},
	{0x16ee & 0xFF, 0x16f8 & 0xFF},
	{0x1700 & 0xFF, 0x1715 & 0xFF},
	{0x171f & 0xFF, 0x1734 & 0xFF},
	{0x1740 & 0xFF, 0x1753 & 0xFF},
	{0x1760 & 0xFF, 0x176c & 0xFF},
	{0x176e & 0xFF, 0x1770 & 0xFF},
	{0x1772 & 0xFF, 0x1773 & 0xFF},
	{0x1780 & 0xFF, 0x17d3 & 0xFF},
	{0x17d7 & 0xFF, 0x17d7 & 0xFF},
	{0x17dc & 0xFF, 0x17dd & 0xFF},
	{0x17e0 & 0xFF, 0x17e9 & 0xFF},
	{0x180b & 0xFF, 0x180d & 0xFF},
	{0x180f & 0xFF, 0x1819 & 0xFF},
	{0x1820 & 0xFF, 0x1878 & 0xFF},
	{0x1880 & 0xFF, 0x18aa & 0xFF},
	{0x18b0 & 0xFF, 0x18f5 & 0xFF},
	{0x1900 & 0xFF, 0x191e & 0xFF},
	{0x1920 & 0xFF, 0x192b & 0xFF},
	{0x1930 & 0xFF, 0x193b & 0xFF},
	{0x1946 & 0xFF, 0x196d & 0xFF},
	{0x1970 & 0xFF, 0x1974 & 0xFF},
	{0x1980 & 0xFF, 0x19ab & 0xFF},
	{0x19b0 & 0xFF, 0x19c9 & 0xFF},
	{0x19d0 & 0xFF, 0x19da & 0xFF},
	{0x1a00 & 0xFF, 0x1a1b & 0xFF},
	{0x1a20 & 0xFF, 0x1a5e & 0xFF},
	{0x1a60 & 0xFF, 0x1a7c & 0xFF},
	{0x1a7f & 0xFF, 0x1a89 & 0xFF},
	{0x1a90 & 0xFF, 0x1a99 & 0xFF},
	{0x1aa7 & 0xFF, 0x1aa7 & 0xFF},
	{0x1ab0 & 0xFF, 0x1abd & 0xFF},
	{0x1abf & 0xFF, 0x1ace & 0xFF},
	{0x1b00 & 0xFF, 0x1b4c & 0xFF},
	{0x1b50 & 0xFF, 0x1b59 & 0xFF},
	{0x1b6b & 0xFF, 0x1b73 & 0xFF},
	{0x1b80 & 0xFF, 0x1bf3 & 0xFF},
	{0x1c00 & 0xFF, 0x1c37 & 0xFF},
	{0x1c40 & 0xFF, 0x1c49 & 0xFF},
	{0x1c4d & 0xFF, 0x1c7d & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1cd0 & 0xFF, 0x1cd2 & 0xFF},
	{0x1cd4 & 0xFF, 0x1cfa & 0xFF},
	{0x1d00 & 0xFF, 0x1dff & 0xFF},
	{0x1e00 & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f15 & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f20 & 0xFF, 0x1f45 & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fbc & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fcc & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe0 & 0xFF, 0x1fec & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ffc & 0xFF},
	{0x200c & 0xFF, 0x200d & 0xFF},
	{0x203f & 0xFF, 0x2040 & 0xFF},
	{0x2054 & 0xFF, 0x2054 & 0xFF},
	{0x2071 & 0xFF, 0x2071 & 0xFF},
	{0x207f & 0xFF, 0x207f & 0xFF},
	{0x2090 & 0xFF, 0x209c & 0xFF},
	{0x20d0 & 0xFF, 0x20dc & 0xFF},
	{0x20e1 & 0xFF, 0x20e1 & 0xFF},
	{0x20e5 & 0xFF, 0x20f0 & 0xFF},
	{0x2102 & 0xFF, 0x2102 & 0xFF},
	{0x2107 & 0xFF, 0x2107 & 0xFF},
	{0x210a & 0xFF, 0x2113 & 0xFF},
	{0x2115 & 0xFF, 0x2115 & 0xFF},
	{0x2118 & 0xFF, 0x211d & 0xFF},
	{0x2124 & 0xFF, 0x2124 & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x2128 & 0xFF, 0x2128 & 0xFF},
	{0x212a & 0xFF, 0x2139 & 0xFF},
	{0x213c & 0xFF, 0x213f & 0xFF},
	{0x2145 & 0xFF, 0x2149 & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2160 & 0xFF, 0x2188 & 0xFF},
	{0x2c00 & 0xFF, 0x2ce4 & 0xFF},
	{0x2ceb & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0x2d30 & 0xFF, 0x2d67 & 0xFF},
	{0x2d6f & 0xFF, 0x2d6f & 0xFF},
	{0x2d7f & 0xFF, 0x2d96 & 0xFF},
	{0x2da0 & 0xFF, 0x2da6 & 0xFF},
	{0x2da8 & 0xFF, 0x2dae & 0xFF},
	{0x2db0 & 0xFF, 0x2db6 & 0xFF},
	{0x2db8 & 0xFF, 0x2dbe & 0xFF},
	{0x2dc0 & 0xFF, 0x2dc6 & 0xFF},
	{0x2dc8 & 0xFF, 0x2dce & 0xFF},
	{0x2dd0 & 0xFF, 0x2dd6 & 0xFF},
	{0x2dd8 & 0xFF, 0x2dde & 0xFF},
	{0x2de0 & 0xFF, 0x2dff & 0xFF},
	{0x3005 & 0xFF, 0x3007 & 0xFF},
	{0x3021 & 0xFF, 0x302f & 0xFF},
	{0x3031 & 0xFF, 0x3035 & 0xFF},
	{0x3038 & 0xFF, 0x303c & 0xFF},
	{0x3041 & 0xFF, 0x3096 & 0xFF},
	{0x3099 & 0xFF, 0x309f & 0xFF},
	{0x30a1 & 0xFF, 0x30ff & 0xFF},
	{0x3105 & 0xFF, 0x312f & 0xFF},
	{0x3131 & 0xFF, 0x318e & 0xFF},
	{0x31a0 & 0xFF, 0x31bf & 0xFF},
	{0x31f0 & 0xFF, 0x31ff & 0xFF},
	{0x3400 & 0xFF, 0x34ff & 0xFF},
	{0x3500 & 0xFF, 0x35ff & 0xFF},
	{0x3600 & 0xFF, 0x36ff & 0xFF},
	{0x3700 & 0xFF, 0x37ff & 0xFF},
	{0x3800 & 0xFF, 0x38ff & 0xFF},
	{0x3900 & 0xFF, 0x39ff & 0xFF},
	{0x3a00 & 0xFF, 0x3aff & 0xFF},
	{0x3b00 & 0xFF, 0x3bff & 0xFF},
	{0x3c00 & 0xFF, 0x3cff & 0xFF},
	{0x3d00 & 0xFF, 0x3dff & 0xFF},
	{0x3e00 & 0xFF, 0x3eff & 0xFF},
	{0x3f00 & 0xFF, 0x3fff & 0xFF},
	{0x4000 & 0xFF, 0x40ff & 0xFF},
	{0x4100 & 0xFF, 0x41ff & 0xFF},
	{0x4200 & 0xFF, 0x42ff & 0xFF},
	{0x4300 & 0xFF, 0x43ff & 0xFF},
	{0x4400 & 0xFF, 0x44ff & 0xFF},
	{0x4500 & 0xFF, 0x45ff & 0xFF},
	{0x4600 & 0xFF, 0x46ff & 0xFF},
	{0x4700 & 0xFF, 0x47ff & 0xFF},
	{0x4800 & 0xFF, 0x48ff & 0xFF},
	{0x4900 & 0xFF, 0x49ff & 0xFF},
	{0x4a00 & 0xFF, 0x4aff & 0xFF},
	{0x4b00 & 0xFF, 0x4bff & 0xFF},
	{0x4c00 & 0xFF, 0x4cff & 0xFF},
	{0x4d00 & 0xFF, 0x4dbf & 0xFF},
	{0x4e00 & 0xFF, 0x4eff & 0xFF},
	{0x4f00 & 0xFF, 0x4fff & 0xFF},
	{0x5000 & 0xFF, 0x50ff & 0xFF},
	{0x5100 & 0xFF, 0x51ff & 0xFF},
	{0x5200 & 0xFF, 0x52ff & 0xFF},
	{0x5300 & 0xFF, 0x53ff & 0xFF},
	{0x5400 & 0xFF, 0x54ff & 0xFF},
	{0x5500 & 0xFF, 0x55ff & 0xFF},
	{0x5600 & 0xFF, 0x56ff & 0xFF},
	{0x5700 & 0xFF, 0x57ff & 0xFF},
	{0x5800 & 0xFF, 0x58ff & 0xFF},
	{0x5900 & 0xFF, 0x59ff & 0xFF},
	{0x5a00 & 0xFF, 0x5aff & 0xFF},
	{0x5b00 & 0xFF, 0x5bff & 0xFF},
	{0x5c00 & 0xFF, 0x5cff & 0xFF},
	{0x5d00 & 0xFF, 0x5dff & 0xFF},
	{0x5e00 & 0xFF, 0x5eff & 0xFF},
	{0x5f00 & 0xFF, 0x5fff & 0xFF},
	{0x6000 & 0xFF, 0x60ff & 0xFF},
	{0x6100 & 0xFF, 0x61ff & 0xFF},
	{0x6200 & 0xFF, 0x62ff & 0xFF},
	{0x6300 & 0xFF, 0x63ff & 0xFF},
	{0x6400 & 0xFF, 0x64ff & 0xFF},
	{0x6500 & 0xFF, 0x65ff & 0xFF},
	{0x6600 & 0xFF, 0x66ff & 0xFF},
	{0x6700 & 0xFF, 0x67ff & 0xFF},
	{0x6800 & 0xFF, 0x68ff & 0xFF},
	{0x6900 & 0xFF, 0x69ff & 0xFF},
	{0x6a00 & 0xFF, 0x6aff & 0xFF},
	{0x6b00 & 0xFF, 0x6bff & 0xFF},
	{0x6c00 & 0xFF, 0x6cff & 0xFF},
	{0x6d00 & 0xFF, 0x6dff & 0xFF},
	{0x6e00 & 0xFF, 0x6eff & 0xFF},
	{0x6f00 & 0xFF, 0x6fff & 0xFF},
	{0x7000 & 0xFF, 0x70ff & 0xFF},
	{0x7100 & 0xFF, 0x71ff & 0xFF},
	{0x7200 & 0xFF, 0x72ff & 0xFF},
	{0x7300 & 0xFF, 0x73ff & 0xFF},
	{0x7400 & 0xFF, 0x74ff & 0xFF},
	{0x7500 & 0xFF, 0x75ff & 0xFF},
	{0x7600 & 0xFF, 0x76ff & 0xFF},
	{0x7700 & 0xFF, 0x77ff & 0xFF},
	{0x7800 & 0xFF, 0x78ff & 0xFF},
	{0x7900 & 0xFF, 0x79ff & 0xFF},
	{0x7a00 & 0xFF, 0x7aff & 0xFF},
	{0x7b00 & 0xFF, 0x7bff & 0xFF},
	{0x7c00 & 0xFF, 0x7cff & 0xFF},
	{0x7d00 & 0xFF, 0x7dff & 0xFF},
	{0x7e00 & 0xFF, 0x7eff & 0xFF},
	{0x7f00 & 0xFF, 0x7fff & 0xFF},
	{0x8000 & 0xFF, 0x80ff & 0xFF},
	{0x8100 & 0xFF, 0x81ff & 0xFF},
	{0x8200 & 0xFF, 0x82ff & 0xFF},
	{0x8300 & 0xFF, 0x83ff & 0xFF},
	{0x8400 & 0xFF, 0x84ff & 0xFF},
	{0x8500 & 0xFF, 0x85ff & 0xFF},
	{0x8600 & 0xFF, 0x86ff & 0xFF},
	{0x8700 & 0xFF, 0x87ff & 0xFF},
	{0x8800 & 0xFF, 0x88ff & 0xFF},
	{0x8900 & 0xFF, 0x89ff & 0xFF},
	{0x8a00 & 0xFF, 0x8aff & 0xFF},
	{0x8b00 & 0xFF, 0x8bff & 0xFF},
	{0x8c00 & 0xFF, 0x8cff & 0xFF},
	{0x8d00 & 0xFF, 0x8dff & 0xFF},
	{0x8e00 & 0xFF, 0x8eff & 0xFF},
	{0x8f00 & 0xFF, 0x8fff & 0xFF},
	{0x9000 & 0xFF, 0x90ff & 0xFF},
	{0x9100 & 0xFF, 0x91ff & 0xFF},
	{0x9200 & 0xFF, 0x92ff & 0xFF},
	{0x9300 & 0xFF, 0x93ff & 0xFF},
	{0x9400 & 0xFF, 0x94ff & 0xFF},
	{0x9500 & 0xFF, 0x95ff & 0xFF},
	{0x9600 & 0xFF, 0x96ff & 0xFF},
	{0x9700 & 0xFF, 0x97ff & 0xFF},
	{0x9800 & 0xFF, 0x98ff & 0xFF},
	{0x9900 & 0xFF, 0x99ff & 0xFF},
	{0x9a00 & 0xFF, 0x9aff & 0xFF},
	{0x9b00 & 0xFF, 0x9bff & 0xFF},
	{0x9c00 & 0xFF, 0x9cff & 0xFF},
	{0x9d00 & 0xFF, 0x9dff & 0xFF},
	{0x9e00 & 0xFF, 0x9eff & 0xFF},
	{0x9f00 & 0xFF, 0x9fff & 0xFF},
	{0xa000 & 0xFF, 0xa0ff & 0xFF},
	{0xa100 & 0xFF, 0xa1ff & 0xFF},
	{0xa200 & 0xFF, 0xa2ff & 0xFF},
	{0xa300 & 0xFF, 0xa3ff & 0xFF},
	{0xa400 & 0xFF, 0xa48c & 0xFF},
	{0xa4d0 & 0xFF, 0xa4fd & 0xFF},
	{0xa500 & 0xFF, 0xa5ff & 0xFF},
	{0xa600 & 0xFF, 0xa60c & 0xFF},
	{0xa610 & 0xFF, 0xa62b & 0xFF},
	{0xa640 & 0xFF, 0xa66f & 0xFF},
	{0xa674 & 0xFF, 0xa67d & 0xFF},
	{0xa67f & 0xFF, 0xa6f1 & 0xFF},
	{0xa717 & 0xFF, 0xa71f & 0xFF},
	{0xa722 & 0xFF, 0xa788 & 0xFF},
	{0xa78b & 0xFF, 0xa7ca & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d3 & 0xFF, 0xa7d3 & 0xFF},
	{0xa7d5 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f2 & 0xFF, 0xa7ff & 0xFF},
	{0xa800 & 0xFF, 0xa827 & 0xFF},
	{0xa82c & 0xFF, 0xa82c & 0xFF},
	{0xa840 & 0xFF, 0xa873 & 0xFF},
	{0xa880 & 0xFF, 0xa8c5 & 0xFF},
	{0xa8d0 & 0xFF, 0xa8d9 & 0xFF},
	{0xa8e0 & 0xFF, 0xa8f7 & 0xFF},
	{0xa8fb & 0xFF, 0xa8fb & 0xFF},
	{0xa8fd & 0xFF, 0xa8ff & 0xFF},
	{0xa900 & 0xFF, 0xa92d & 0xFF},
	{0xa930 & 0xFF, 0xa953 & 0xFF},
	{0xa960 & 0xFF, 0xa97c & 0xFF},
	{0xa980 & 0xFF, 0xa9c0 & 0xFF},
	{0xa9cf & 0xFF, 0xa9d9 & 0xFF},
	{0xa9e0 & 0xFF, 0xa9fe & 0xFF},
	{0xaa00 & 0xFF, 0xaa36 & 0xFF},
	{0xaa40 & 0xFF, 0xaa4d & 0xFF},
	{0xaa50 & 0xFF, 0xaa59 & 0xFF},
	{0xaa60 & 0xFF, 0xaa76 & 0xFF},
	{0xaa7a & 0xFF, 0xaac2 & 0xFF},
	{0xaadb & 0xFF, 0xaadd & 0xFF},
	{0xaae0 & 0xFF, 0xaaef & 0xFF},
	{0xaaf2 & 0xFF, 0xaaf6 & 0xFF},
	{0xab01 & 0xFF, 0xab06 & 0xFF},
	{0xab09 & 0xFF, 0xab0e & 0xFF},
	{0xab11 & 0xFF, 0xab16 & 0xFF},
	{0xab20 & 0xFF, 0xab26 & 0xFF},
	{0xab28 & 0xFF, 0xab2e & 0xFF},
	{0xab30 & 0xFF, 0xab5a & 0xFF},
	{0xab5c & 0xFF, 0xab69 & 0xFF},
	{0xab70 & 0xFF, 0xabea & 0xFF},
	{0xabec & 0xFF, 0xabed & 0xFF},
	{0xabf0 & 0xFF, 0xabf9 & 0xFF},
	{0xac00 & 0xFF, 0xacff & 0xFF},
	{0xad00 & 0xFF, 0xadff & 0xFF},
	{0xae00 & 0xFF, 0xaeff & 0xFF},
	{0xaf00 & 0xFF, 0xafff & 0xFF},
	{0xb000 & 0xFF, 0xb0ff & 0xFF},
	{0xb100 & 0xFF, 0xb1ff & 0xFF},
	{0xb200 & 0xFF, 0xb2ff & 0xFF},
	{0xb300 & 0xFF, 0xb3ff & 0xFF},
	{0xb400 & 0xFF, 0xb4ff & 0xFF},
	{0xb500 & 0xFF, 0xb5ff & 0xFF},
	{0xb600 & 0xFF, 0xb6ff & 0xFF},
	{0xb700 & 0xFF, 0xb7ff & 0xFF},
	{0xb800 & 0xFF, 0xb8ff & 0xFF},
	{0xb900 & 0xFF, 0xb9ff & 0xFF},
	{0xba00 & 0xFF, 0xbaff & 0xFF},
	{0xbb00 & 0xFF, 0xbbff & 0xFF},
	{0xbc00 & 0xFF, 0xbcff & 0xFF},
	{0xbd00 & 0xFF, 0xbdff & 0xFF},
	{0xbe00 & 0xFF, 0xbeff & 0xFF},
	{0xbf00 & 0xFF, 0xbfff & 0xFF},
	{0xc000 & 0xFF, 0xc0ff & 0xFF},
	{0xc100 & 0xFF, 0xc1ff & 0xFF},
	{0xc200 & 0xFF, 0xc2ff & 0xFF},
	{0xc300 & 0xFF, 0xc3ff & 0xFF},
	{0xc400 & 0xFF, 0xc4ff & 0xFF},
	{0xc500 & 0xFF, 0xc5ff & 0xFF},
	{0xc600 & 0xFF, 0xc6ff & 0xFF},
	{0xc700 & 0xFF, 0xc7ff & 0xFF},
	{0xc800 & 0xFF, 0xc8ff & 0xFF},
	{0xc900 & 0xFF, 0xc9ff & 0xFF},
	{0xca00 & 0xFF, 0xcaff & 0xFF},
	{0xcb00 & 0xFF, 0xcbff & 0xFF},
	{0xcc00 & 0xFF, 0xccff & 0xFF},
	{0xcd00 & 0xFF, 0xcdff & 0xFF},
	{0xce00 & 0xFF, 0xceff & 0xFF},
	{0xcf00 & 0xFF, 0xcfff & 0xFF},
	{0xd000 & 0xFF, 0xd0ff & 0xFF},
	{0xd100 & 0xFF, 0xd1ff & 0xFF},
	{0xd200 & 0xFF, 0xd2ff & 0xFF},
	{0xd300 & 0xFF, 0xd3ff & 0xFF},
	{0xd400 & 0xFF, 0xd4ff & 0xFF},
	{0xd500 & 0xFF, 0xd5ff & 0xFF},
	{0xd600 & 0xFF, 0xd6ff & 0xFF},
	{0xd700 & 0xFF, 0xd7a3 & 0xFF},
	{0xd7b0 & 0xFF, 0xd7c6 & 0xFF},
	{0xd7cb & 0xFF, 0xd7fb & 0xFF},
	{0xf900 & 0xFF, 0xf9ff & 0xFF},
	{0xfa00 & 0xFF, 0xfa6d & 0xFF},
	{0xfa70 & 0xFF, 0xfad9 & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xfb1d & 0xFF, 0xfb28 & 0xFF},
	{0xfb2a & 0xFF, 0xfb36 & 0xFF},
	{0xfb38 & 0xFF, 0xfb3c & 0xFF},
	{0xfb3e & 0xFF, 0xfb3e & 0xFF},
	{0xfb40 & 0xFF, 0xfb41 & 0xFF},
	{0xfb43 & 0xFF, 0xfb44 & 0xFF},
	{0xfb46 & 0xFF, 0xfbb1 & 0xFF},
	{0xfbd3 & 0xFF, 0xfbff & 0xFF},
	{0xfc00 & 0xFF, 0xfcff & 0xFF},
	{0xfd00 & 0xFF, 0xfd3d & 0xFF},
	{0xfd50 & 0xFF, 0xfd8f & 0xFF},
	{0xfd92 & 0xFF, 0xfdc7 & 0xFF},
	{0xfdf0 & 0xFF, 0xfdfb & 0xFF},
	{0xfe00 & 0xFF, 0xfe0f & 0xFF},
	{0xfe20 & 0xFF, 0xfe2f & 0xFF},
	{0xfe33 & 0xFF, 0xfe34 & 0xFF},
	{0xfe4d & 0xFF, 0xfe4f & 0xFF},
	{0xfe70 & 0xFF, 0xfe74 & 0xFF},
	{0xfe76 & 0xFF, 0xfefc & 0xFF},
	{0xff10 & 0xFF, 0xff19 & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0xff3f & 0xFF, 0xff3f & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0xff65 & 0xFF, 0xffbe & 0xFF},
	{0xffc2 & 0xFF, 0xffc7 & 0xFF},
	{0xffca & 0xFF, 0xffcf & 0xFF},
	{0xffd2 & 0xFF, 0xffd7 & 0xFF},
	{0xffda & 0xFF, 0xffdc & 0xFF},
	{0x10000 & 0xFF, 0x1000b & 0xFF},
	{0x1000d & 0xFF, 0x10026 & 0xFF},
	{0x10028 & 0xFF, 0x1003a & 0xFF},
	{0x1003c & 0xFF, 0x1003d & 0xFF},
	{0x1003f & 0xFF, 0x1004d & 0xFF},
	{0x10050 & 0xFF, 0x1005d & 0xFF},
	{0x10080 & 0xFF, 0x100fa & 0xFF},
	{0x10140 & 0xFF, 0x10174 & 0xFF},
	{0x101fd & 0xFF, 0x101fd & 0xFF},
	{0x10280 & 0xFF, 0x1029c & 0xFF},
	{0x102a0 & 0xFF, 0x102d0 & 0xFF},
	{0x102e0 & 0xFF, 0x102e0 & 0xFF},
	{0x10300 & 0xFF, 0x1031f & 0xFF},
	{0x1032d & 0xFF, 0x1034a & 0xFF},
	{0x10350 & 0xFF, 0x1037a & 0xFF},
	{0x10380 & 0xFF, 0x1039d & 0xFF},
	{0x103a0 & 0xFF, 0x103c3 & 0xFF},
	{0x103c8 & 0xFF, 0x103cf & 0xFF},
	{0x103d1 & 0xFF, 0x103d5 & 0xFF},
	{0x10400 & 0xFF, 0x1049d & 0xFF},
	{0x104a0 & 0xFF, 0x104a9 & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10500 & 0xFF, 0x10527 & 0xFF},
	{0x10530 & 0xFF, 0x10563 & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10600 & 0xFF, 0x106ff & 0xFF},
	{0x10700 & 0xFF, 0x10736 & 0xFF},
	{0x10740 & 0xFF, 0x10755 & 0xFF},
	{0x10760 & 0xFF, 0x10767 & 0xFF},
	{0x10780 & 0xFF, 0x10785 & 0xFF},
	{0x10787 & 0xFF, 0x107b0 & 0xFF},
	{0x107b2 & 0xFF, 0x107ba & 0xFF},
	{0x10800 & 0xFF, 0x10805 & 0xFF},
	{0x10808 & 0xFF, 0x10808 & 0xFF},
	{0x1080a & 0xFF, 0x10835 & 0xFF},
	{0x10837 & 0xFF, 0x10838 & 0xFF},
	{0x1083c & 0xFF, 0x1083c & 0xFF},
	{0x1083f & 0xFF, 0x10855 & 0xFF},
	{0x10860 & 0xFF, 0x10876 & 0xFF},
	{0x10880 & 0xFF, 0x1089e & 0xFF},
	{0x108e0 & 0xFF, 0x108f2 & 0xFF},
	{0x108f4 & 0xFF, 0x108f5 & 0xFF},
	{0x10900 & 0xFF, 0x10915 & 0xFF},
	{0x10920 & 0xFF, 0x10939 & 0xFF},
	{0x10980 & 0xFF, 0x109b7 & 0xFF},
	{0x109be & 0xFF, 0x109bf & 0xFF},
	{0x10a00 & 0xFF, 0x10a03 & 0xFF},
	{0x10a05 & 0xFF, 0x10a06 & 0xFF},
	{0x10a0c & 0xFF, 0x10a13 & 0xFF},
	{0x10a15 & 0xFF, 0x10a17 & 0xFF},
	{0x10a19 & 0xFF, 0x10a35 & 0xFF},
	{0x10a38 & 0xFF, 0x10a3a & 0xFF},
	{0x10a3f & 0xFF, 0x10a3f & 0xFF},
	{0x10a60 & 0xFF, 0x10a7c & 0xFF},
	{0x10a80 & 0xFF, 0x10a9c & 0xFF},
	{0x10ac0 & 0xFF, 0x10ac7 & 0xFF},
	{0x10ac9 & 0xFF, 0x10ae6 & 0xFF},
	{0x10b00 & 0xFF, 0x10b35 & 0xFF},
	{0x10b40 & 0xFF, 0x10b55 & 0xFF},
	{0x10b60 & 0xFF, 0x10b72 & 0xFF},
	{0x10b80 & 0xFF, 0x10b91 & 0xFF},
	{0x10c00 & 0xFF, 0x10c48 & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x10d00 & 0xFF, 0x10d27 & 0xFF},
	{0x10d30 & 0xFF, 0x10d39 & 0xFF},
	{0x10e80 & 0xFF, 0x10ea9 & 0xFF},
	{0x10eab & 0xFF, 0x10eac & 0xFF},
	{0x10eb0 & 0xFF, 0x10eb1 & 0xFF},
	{0x10efd & 0xFF, 0x10eff & 0xFF},
	{0x10f00 & 0xFF, 0x10f1c & 0xFF},
	{0x10f27 & 0xFF, 0x10f27 & 0xFF},
	{0x10f30 & 0xFF, 0x10f50 & 0xFF},
	{0x10f70 & 0xFF, 0x10f85 & 0xFF},
	{0x10fb0 & 0xFF, 0x10fc4 & 0xFF},
	{0x10fe0 & 0xFF, 0x10ff6 & 0xFF},
	{0x11000 & 0xFF, 0x11046 & 0xFF},
	{0x11066 & 0xFF, 0x11075 & 0xFF},
	{0x1107f & 0xFF, 0x110ba & 0xFF},
	{0x110c2 & 0xFF, 0x110c2 & 0xFF},
	{0x110d0 & 0xFF, 0x110e8 & 0xFF},
	{0x110f0 & 0xFF, 0x110f9 & 0xFF},
	{0x11100 & 0xFF, 0x11134 & 0xFF},
	{0x11136 & 0xFF, 0x1113f & 0xFF},
	{0x11144 & 0xFF, 0x11147 & 0xFF},
	{0x11150 & 0xFF, 0x11173 & 0xFF},
	{0x11176 & 0xFF, 0x11176 & 0xFF},
	{0x11180 & 0xFF, 0x111c4 & 0xFF},
	{0x111c9 & 0xFF, 0x111cc & 0xFF},
	{0x111ce & 0xFF, 0x111da & 0xFF},
	{0x111dc & 0xFF, 0x111dc & 0xFF},
	{0x11200 & 0xFF, 0x11211 & 0xFF},
	{0x11213 & 0xFF, 0x11237 & 0xFF},
	{0x1123e & 0xFF, 0x11241 & 0xFF},
	{0x11280 & 0xFF, 0x11286 & 0xFF},
	{0x11288 & 0xFF, 0x11288 & 0xFF},
	{0x1128a & 0xFF, 0x1128d & 0xFF},
	{0x1128f & 0xFF, 0x1129d & 0xFF},
	{0x1129f & 0xFF, 0x112a8 & 0xFF},
	{0x112b0 & 0xFF, 0x112ea & 0xFF},
	{0x112f0 & 0xFF, 0x112f9 & 0xFF},
	{0x11300 & 0xFF, 0x11303 & 0xFF},
	{0x11305 & 0xFF, 0x1130c & 0xFF},
	{0x1130f & 0xFF, 0x11310 & 0xFF},
	{0x11313 & 0xFF, 0x11328 & 0xFF},
	{0x1132a & 0xFF, 0x11330 & 0xFF},
	{0x11332 & 0xFF, 0x11333 & 0xFF},
	{0x11335 & 0xFF, 0x11339 & 0xFF},
	{0x1133b & 0xFF, 0x11344 & 0xFF},
	{0x11347 & 0xFF, 0x11348 & 0xFF},
	{0x1134b & 0xFF, 0x1134d & 0xFF},
	{0x11350 & 0xFF, 0x11350 & 0xFF},
	{0x11357 & 0xFF, 0x11357 & 0xFF},
	{0x1135d & 0xFF, 0x11363 & 0xFF},
	{0x11366 & 0xFF, 0x1136c & 0xFF},
	{0x11370 & 0xFF, 0x11374 & 0xFF},
	{0x11400 & 0xFF, 0x1144a & 0xFF},
	{0x11450 & 0xFF, 0x11459 & 0xFF},
	{0x1145e & 0xFF, 0x11461 & 0xFF},
	{0x11480 & 0xFF, 0x114c5 & 0xFF},
	{0x114c7 & 0xFF, 0x114c7 & 0xFF},
	{0x114d0 & 0xFF, 0x114d9 & 0xFF},
	{0x11580 & 0xFF, 0x115b5 & 0xFF},
	{0x115b8 & 0xFF, 0x115c0 & 0xFF},
	{0x115d8 & 0xFF, 0x115dd & 0xFF},
	{0x11600 & 0xFF, 0x11640 & 0xFF},
	{0x11644 & 0xFF, 0x11644 & 0xFF},
	{0x11650 & 0xFF, 0x11659 & 0xFF},
	{0x11680 & 0xFF, 0x116b8 & 0xFF},
	{0x116c0 & 0xFF, 0x116c9 & 0xFF},
	{0x11700 & 0xFF, 0x1171a & 0xFF},
	{0x1171d & 0xFF, 0x1172b & 0xFF},
	{0x11730 & 0xFF, 0x11739 & 0xFF},
	{0x11740 & 0xFF, 0x11746 & 0xFF},
	{0x11800 & 0xFF, 0x1183a & 0xFF},
	{0x118a0 & 0xFF, 0x118e9 & 0xFF},
	{0x118ff & 0xFF, 0x118ff & 0xFF},
	{0x11900 & 0xFF, 0x11906 & 0xFF},
	{0x11909 & 0xFF, 0x11909 & 0xFF},
	{0x1190c & 0xFF, 0x11913 & 0xFF},
	{0x11915 & 0xFF, 0x11916 & 0xFF},
	{0x11918 & 0xFF, 0x11935 & 0xFF},
	{0x11937 & 0xFF, 0x11938 & 0xFF},
	{0x1193b & 0xFF, 0x11943 & 0xFF},
	{0x11950 & 0xFF, 0x11959 & 0xFF},
	{0x119a0 & 0xFF, 0x119a7 & 0xFF},
	{0x119aa & 0xFF, 0x119d7 & 0xFF},
	{0x119da & 0xFF, 0x119e1 & 0xFF},
	{0x119e3 & 0xFF, 0x119e4 & 0xFF},
	{0x11a00 & 0xFF, 0x11a3e & 0xFF},
	{0x11a47 & 0xFF, 0x11a47 & 0xFF},
	{0x11a50 & 0xFF, 0x11a99 & 0xFF},
	{0x11a9d & 0xFF, 0x11a9d & 0xFF},
	{0x11ab0 & 0xFF, 0x11af8 & 0xFF},
	{0x11c00 & 0xFF, 0x11c08 & 0xFF},
	{0x11c0a & 0xFF, 0x11c36 & 0xFF},
	{0x11c38 & 0xFF, 0x11c40 & 0xFF},
	{0x11c50 & 0xFF, 0x11c59 & 0xFF},
	{0x11c72 & 0xFF, 0x11c8f & 0xFF},
	{0x11c92 & 0xFF, 0x11ca7 & 0xFF},
	{0x11ca9 & 0xFF, 0x11cb6 & 0xFF},
	{0x11d00 & 0xFF, 0x11d06 & 0xFF},
	{0x11d08 & 0xFF, 0x11d09 & 0xFF},
	{0x11d0b & 0xFF, 0x11d36 & 0xFF},
	{0x11d3a & 0xFF, 0x11d3a & 0xFF},
	{0x11d3c & 0xFF, 0x11d3d & 0xFF},
	{0x11d3f & 0xFF, 0x11d47 & 0xFF},
	{0x11d50 & 0xFF, 0x11d59 & 0xFF},
	{0x11d60 & 0xFF, 0x11d65 & 0xFF},
	{0x11d67 & 0xFF, 0x11d68 & 0xFF},
	{0x11d6a & 0xFF, 0x11d8e & 0xFF},
	{0x11d90 & 0xFF, 0x11d91 & 0xFF},
	{0x11d93 & 0xFF, 0x11d98 & 0xFF},
	{0x11da0 & 0xFF, 0x11da9 & 0xFF},
	{0x11ee0 & 0xFF, 0x11ef6 & 0xFF},
	{0x11f00 & 0xFF, 0x11f10 & 0xFF},
	{0x11f12 & 0xFF, 0x11f3a & 0xFF},
	{0x11f3e & 0xFF, 0x11f42 & 0xFF},
	{0x11f50 & 0xFF, 0x11f59 & 0xFF},
	{0x11fb0 & 0xFF, 0x11fb0 & 0xFF},
	{0x12000 & 0xFF, 0x120ff & 0xFF},
	{0x12100 & 0xFF, 0x121ff & 0xFF},
	{0x12200 & 0xFF, 0x122ff & 0xFF},
	{0x12300 & 0xFF, 0x12399 & 0xFF},
	{0x12400 & 0xFF, 0x1246e & 0xFF},
	{0x12480 & 0xFF, 0x124ff & 0xFF},
	{0x12500 & 0xFF, 0x12543 & 0xFF},
	{0x12f90 & 0xFF, 0x12ff0 & 0xFF},
	{0x13000 & 0xFF, 0x130ff & 0xFF},
	{0x13100 & 0xFF, 0x131ff & 0xFF},
	{0x13200 & 0xFF, 0x132ff & 0xFF},
	{0x13300 & 0xFF, 0x133ff & 0xFF},
	{0x13400 & 0xFF, 0x1342f & 0xFF},
	{0x13440 & 0xFF, 0x13455 & 0xFF},
	{0x14400 & 0xFF, 0x144ff & 0xFF},
	{0x14500 & 0xFF, 0x145ff & 0xFF},
	{0x14600 & 0xFF, 0x14646 & 0xFF},
	{0x16800 & 0xFF, 0x168ff & 0xFF},
	{0x16900 & 0xFF, 0x169ff & 0xFF},
	{0x16a00 & 0xFF, 0x16a38 & 0xFF},
	{0x16a40 & 0xFF, 0x16a5e & 0xFF},
	{0x16a60 & 0xFF, 0x16a69 & 0xFF},
	{0x16a70 & 0xFF, 0x16abe & 0xFF},
	{0x16ac0 & 0xFF, 0x16ac9 & 0xFF},
	{0x16ad0 & 0xFF, 0x16aed & 0xFF},
	{0x16af0 & 0xFF, 0x16af4 & 0xFF},
	{0x16b00 & 0xFF, 0x16b36 & 0xFF},
	{0x16b40 & 0xFF, 0x16b43 & 0xFF},
	{0x16b50 & 0xFF, 0x16b59 & 0xFF},
	{0x16b63 & 0xFF, 0x16b77 & 0xFF},
	{0x16b7d & 0xFF, 0x16b8f & 0xFF},
	{0x16e40 & 0xFF, 0x16e7f & 0xFF},
	{0x16f00 & 0xFF, 0x16f4a & 0xFF},
	{0x16f4f & 0xFF, 0x16f87 & 0xFF},
	{0x16f8f & 0xFF, 0x16f9f & 0xFF},
	{0x16fe0 & 0xFF, 0x16fe1 & 0xFF},
	{0x16fe3 & 0xFF, 0x16fe4 & 0xFF},
	{0x16ff0 & 0xFF, 0x16ff1 & 0xFF},
	{0x17000 & 0xFF, 0x170ff & 0xFF},
	{0x17100 & 0xFF, 0x171ff & 0xFF},
	{0x17200 & 0xFF, 0x172ff & 0xFF},
	{0x17300 & 0xFF, 0x173ff & 0xFF},
	{0x17400 & 0xFF, 0x174ff & 0xFF},
	{0x17500 & 0xFF, 0x175ff & 0xFF},
	{0x17600 & 0xFF, 0x176ff & 0xFF},
	{0x17700 & 0xFF, 0x177ff & 0xFF},
	{0x17800 & 0xFF, 0x178ff & 0xFF},
	{0x17900 & 0xFF, 0x179ff & 0xFF},
	{0x17a00 & 0xFF, 0x17aff & 0xFF},
	{0x17b00 & 0xFF, 0x17bff & 0xFF},
	{0x17c00 & 0xFF, 0x17cff & 0xFF},
	{0x17d00 & 0xFF, 0x17dff & 0xFF},
	{0x17e00 & 0xFF, 0x17eff & 0xFF},
	{0x17f00 & 0xFF, 0x17fff & 0xFF},
	{0x18000 & 0xFF, 0x180ff & 0xFF},
	{0x18100 & 0xFF, 0x181ff & 0xFF},
	{0x18200 & 0xFF, 0x182ff & 0xFF},
	{0x18300 & 0xFF, 0x183ff & 0xFF},
	{0x18400 & 0xFF, 0x184ff & 0xFF},
	{0x18500 & 0xFF, 0x185ff & 0xFF},
	{0x18600 & 0xFF, 0x186ff & 0xFF},
	{0x18700 & 0xFF, 0x187f7 & 0xFF},
	{0x18800 & 0xFF, 0x188ff & 0xFF},
	{0x18900 & 0xFF, 0x189ff & 0xFF},
	{0x18a00 & 0xFF, 0x18aff & 0xFF},
	{0x18b00 & 0xFF, 0x18bff & 0xFF},
	{0x18c00 & 0xFF, 0x18cd5 & 0xFF},
	{0x18d00 & 0xFF, 0x18d08 & 0xFF},
	{0x1aff0 & 0xFF, 0x1aff3 & 0xFF},
	{0x1aff5 & 0xFF, 0x1affb & 0xFF},
	{0x1affd & 0xFF, 0x1affe & 0xFF},
	{0x1b000 & 0xFF, 0x1b0ff & 0xFF},
	{0x1b100 & 0xFF, 0x1b122 & 0xFF},
	{0x1b132 & 0xFF, 0x1b132 & 0xFF},
	{0x1b150 & 0xFF, 0x1b152 & 0xFF},
	{0x1b155 & 0xFF, 0x1b155 & 0xFF},
	{0x1b164 & 0xFF, 0x1b167 & 0xFF},
	{0x1b170 & 0xFF, 0x1b1ff & 0xFF},
	{0x1b200 & 0xFF, 0x1b2fb & 0xFF},
	{0x1bc00 & 0xFF, 0x1bc6a & 0xFF},
	{0x1bc70 & 0xFF, 0x1bc7c & 0xFF},
	{0x1bc80 & 0xFF, 0x1bc88 & 0xFF},
	{0x1bc90 & 0xFF, 0x1bc99 & 0xFF},
	{0x1bc9d & 0xFF, 0x1bc9e & 0xFF},
	{0x1cf00 & 0xFF, 0x1cf2d & 0xFF},
	{0x1cf30 & 0xFF, 0x1cf46 & 0xFF},
	{0x1d165 & 0xFF, 0x1d169 & 0xFF},
	{0x1d16d & 0xFF, 0x1d172 & 0xFF},
	{0x1d17b & 0xFF, 0x1d182 & 0xFF},
	{0x1d185 & 0xFF, 0x1d18b & 0xFF},
	{0x1d1aa & 0xFF, 0x1d1ad & 0xFF},
	{0x1d242 & 0xFF, 0x1d244 & 0xFF},
	{0x1d400 & 0xFF, 0x1d454 & 0xFF},
	{0x1d456 & 0xFF, 0x1d49c & 0xFF},
	{0x1d49e & 0xFF, 0x1d49f & 0xFF},
	{0x1d4a2 & 0xFF, 0x1d4a2 & 0xFF},
	{0x1d4a5 & 0xFF, 0x1d4a6 & 0xFF},
	{0x1d4a9 & 0xFF, 0x1d4ac & 0xFF},
	{0x1d4ae & 0xFF, 0x1d4b9 & 0xFF},
	{0x1d4bb & 0xFF, 0x1d4bb & 0xFF},
	{0x1d4bd & 0xFF, 0x1d4c3 & 0xFF},
	{0x1d4c5 & 0xFF, 0x1d4ff & 0xFF},
	{0x1d500 & 0xFF, 0x1d505 & 0xFF},
	{0x1d507 & 0xFF, 0x1d50a & 0xFF},
	{0x1d50d & 0xFF, 0x1d514 & 0xFF},
	{0x1d516 & 0xFF, 0x1d51c & 0xFF},
	{0x1d51e & 0xFF, 0x1d539 & 0xFF},
	{0x1d53b & 0xFF, 0x1d53e & 0xFF},
	{0x1d540 & 0xFF, 0x1d544 & 0xFF},
	{0x1d546 & 0xFF, 0x1d546 & 0xFF},
	{0x1d54a & 0xFF, 0x1d550 & 0xFF},
	{0x1d552 & 0xFF, 0x1d5ff & 0xFF},
	{0x1d600 & 0xFF, 0x1d6a5 & 0xFF},
	{0x1d6a8 & 0xFF, 0x1d6c0 & 0xFF},
	{0x1d6c2 & 0xFF, 0x1d6da & 0xFF},
	{0x1d6dc & 0xFF, 0x1d6fa & 0xFF},
	{0x1d6fc & 0xFF, 0x1d6ff & 0xFF},
	{0x1d700 & 0xFF, 0x1d714 & 0xFF},
	{0x1d716 & 0xFF, 0x1d734 & 0xFF},
	{0x1d736 & 0xFF, 0x1d74e & 0xFF},
	{0x1d750 & 0xFF, 0x1d76e & 0xFF},
	{0x1d770 & 0xFF, 0x1d788 & 0xFF},
	{0x1d78a & 0xFF, 0x1d7a8 & 0xFF},
	{0x1d7aa & 0xFF, 0x1d7c2 & 0xFF},
	{0x1d7c4 & 0xFF, 0x1d7cb & 0xFF},
	{0x1d7ce & 0xFF, 0x1d7ff & 0xFF},
	{0x1da00 & 0xFF, 0x1da36 & 0xFF},
	{0x1da3b & 0xFF, 0x1da6c & 0xFF},
	{0x1da75 & 0xFF, 0x1da75 & 0xFF},
	{0x1da84 & 0xFF, 0x1da84 & 0xFF},
	{0x1da9b & 0xFF, 0x1da9f & 0xFF},
	{0x1daa1 & 0xFF, 0x1daaf & 0xFF},
	{0x1df00 & 0xFF, 0x1df1e & 0xFF},
	{0x1df25 & 0xFF, 0x1df2a & 0xFF},
	{0x1e000 & 0xFF, 0x1e006 & 0xFF},
	{0x1e008 & 0xFF, 0x1e018 & 0xFF},
	{0x1e01b & 0xFF, 0x1e021 & 0xFF},
	{0x1e023 & 0xFF, 0x1e024 & 0xFF},
	{0x1e026 & 0xFF, 0x1e02a & 0xFF},
	{0x1e030 & 0xFF, 0x1e06d & 0xFF},
	{0x1e08f & 0xFF, 0x1e08f & 0xFF},
	{0x1e100 & 0xFF, 0x1e12c & 0xFF},
	{0x1e130 & 0xFF, 0x1e13d & 0xFF},
	{0x1e140 & 0xFF, 0x1e149 & 0xFF},
	{0x1e14e & 0xFF, 0x1e14e & 0xFF},
	{0x1e290 & 0xFF, 0x1e2ae & 0xFF},
	{0x1e2c0 & 0xFF, 0x1e2f9 & 0xFF},
	{0x1e4d0 & 0xFF, 0x1e4f9 & 0xFF},
	{0x1e7e0 & 0xFF, 0x1e7e6 & 0xFF},
	{0x1e7e8 & 0xFF, 0x1e7eb & 0xFF},
	{0x1e7ed & 0xFF, 0x1e7ee & 0xFF},
	{0x1e7f0 & 0xFF, 0x1e7fe & 0xFF},
	{0x1e800 & 0xFF, 0x1e8c4 & 0xFF},
	{0x1e8d0 & 0xFF, 0x1e8d6 & 0xFF},
	{0x1e900 & 0xFF, 0x1e94b & 0xFF},
	{0x1e950 & 0xFF, 0x1e959 & 0xFF},
	{0x1ee00 & 0xFF, 0x1ee03 & 0xFF},
	{0x1ee05 & 0xFF, 0x1ee1f & 0xFF},
	{0x1ee21 & 0xFF, 0x1ee22 & 0xFF},
	{0x1ee24 & 0xFF, 0x1ee24 & 0xFF},
	{0x1ee27 & 0xFF, 0x1ee27 & 0xFF},
	{0x1ee29 & 0xFF, 0x1ee32 & 0xFF},
	{0x1ee34 & 0xFF, 0x1ee37 & 0xFF},
	{0x1ee39 & 0xFF, 0x1ee39 & 0xFF},
	{0x1ee3b & 0xFF, 0x1ee3b & 0xFF},
	{0x1ee42 & 0xFF, 0x1ee42 & 0xFF},
	{0x1ee47 & 0xFF, 0x1ee47 & 0xFF},
	{0x1ee49 & 0xFF, 0x1ee49 & 0xFF},
	{0x1ee4b & 0xFF, 0x1ee4b & 0xFF},
	{0x1ee4d & 0xFF, 0x1ee4f & 0xFF},
	{0x1ee51 & 0xFF, 0x1ee52 & 0xFF},
	{0x1ee54 & 0xFF, 0x1ee54 & 0xFF},
	{0x1ee57 & 0xFF, 0x1ee57 & 0xFF},
	{0x1ee59 & 0xFF, 0x1ee59 & 0xFF},
	{0x1ee5b & 0xFF, 0x1ee5b & 0xFF},
	{0x1ee5d & 0xFF, 0x1ee5d & 0xFF},
	{0x1ee5f & 0xFF, 0x1ee5f & 0xFF},
	{0x1ee61 & 0xFF, 0x1ee62 & 0xFF},
	{0x1ee64 & 0xFF, 0x1ee64 & 0xFF},
	{0x1ee67 & 0xFF, 0x1ee6a & 0xFF},
	{0x1ee6c & 0xFF, 0x1ee72 & 0xFF},
	{0x1ee74 & 0xFF, 0x1ee77 & 0xFF},
	{0x1ee79 & 0xFF, 0x1ee7c & 0xFF},
	{0x1ee7e & 0xFF, 0x1ee7e & 0xFF},
	{0x1ee80 & 0xFF, 0x1ee89 & 0xFF},
	{0x1ee8b & 0xFF, 0x1ee9b & 0xFF},
	{0x1eea1 & 0xFF, 0x1eea3 & 0xFF},
	{0x1eea5 & 0xFF, 0x1eea9 & 0xFF},
	{0x1eeab & 0xFF, 0x1eebb & 0xFF},
	{0x1fbf0 & 0xFF, 0x1fbf9 & 0xFF},
	{0x20000 & 0xFF, 0x200ff & 0xFF},
	{0x20100 & 0xFF, 0x201ff & 0xFF},
	{0x20200 & 0xFF, 0x202ff & 0xFF},
	{0x20300 & 0xFF, 0x203ff & 0xFF},
	{0x20400 & 0xFF, 0x204ff & 0xFF},
	{0x20500 & 0xFF, 0x205ff & 0xFF},
	{0x20600 & 0xFF, 0x206ff & 0xFF},
	{0x20700 & 0xFF, 0x207ff & 0xFF},
	{0x20800 & 0xFF, 0x208ff & 0xFF},
	{0x20900 & 0xFF, 0x209ff & 0xFF},
	{0x20a00 & 0xFF, 0x20aff & 0xFF},
	{0x20b00 & 0xFF, 0x20bff & 0xFF},
	{0x20c00 & 0xFF, 0x20cff & 0xFF},
	{0x20d00 & 0xFF, 0x20dff & 0xFF},
	{0x20e00 & 0xFF, 0x20eff & 0xFF},
	{0x20f00 & 0xFF, 0x20fff & 0xFF},
	{0x21000 & 0xFF, 0x210ff & 0xFF},
	{0x21100 & 0xFF, 0x211ff & 0xFF},
	{0x21200 & 0xFF, 0x212ff & 0xFF},
	{0x21300 & 0xFF, 0x213ff & 0xFF},
	{0x21400 & 0xFF, 0x214ff & 0xFF},
	{0x21500 & 0xFF, 0x215ff & 0xFF},
	{0x21600 & 0xFF, 0x216ff & 0xFF},
	{0x21700 & 0xFF, 0x217ff & 0xFF},
	{0x21800 & 0xFF, 0x218ff & 0xFF},
	{0x21900 & 0xFF, 0x219ff & 0xFF},
	{0x21a00 & 0xFF, 0x21aff & 0xFF},
	{0x21b00 & 0xFF, 0x21bff & 0xFF},
	{0x21c00 & 0xFF, 0x21cff & 0xFF},
	{0x21d00 & 0xFF, 0x21dff & 0xFF},
	{0x21e00 & 0xFF, 0x21eff & 0xFF},
	{0x21f00 & 0xFF, 0x21fff & 0xFF},
	{0x22000 & 0xFF, 0x220ff & 0xFF},
	{0x22100 & 0xFF, 0x221ff & 0xFF},
	{0x22200 & 0xFF, 0x222ff & 0xFF},
	{0x22300 & 0xFF, 0x223ff & 0xFF},
	{0x22400 & 0xFF, 0x224ff & 0xFF},
	{0x22500 & 0xFF, 0x225ff & 0xFF},
	{0x22600 & 0xFF, 0x226ff & 0xFF},
	{0x22700 & 0xFF, 0x227ff & 0xFF},
	{0x22800 & 0xFF, 0x228ff & 0xFF},
	{0x22900 & 0xFF, 0x229ff & 0xFF},
	{0x22a00 & 0xFF, 0x22aff & 0xFF},
	{0x22b00 & 0xFF, 0x22bff & 0xFF},
	{0x22c00 & 0xFF, 0x22cff & 0xFF},
	{0x22d00 & 0xFF, 0x22dff & 0xFF},
	{0x22e00 & 0xFF, 0x22eff & 0xFF},
	{0x22f00 & 0xFF, 0x22fff & 0xFF},
	{0x23000 & 0xFF, 0x230ff & 0xFF},
	{0x23100 & 0xFF, 0x231ff & 0xFF},
	{0x23200 & 0xFF, 0x232ff & 0xFF},
	{0x23300 & 0xFF, 0x233ff & 0xFF},
	{0x23400 & 0xFF, 0x234ff & 0xFF},
	{0x23500 & 0xFF, 0x235ff & 0xFF},
	{0x23600 & 0xFF, 0x236ff & 0xFF},
	{0x23700 & 0xFF, 0x237ff & 0xFF},
	{0x23800 & 0xFF, 0x238ff & 0xFF},
	{0x23900 & 0xFF, 0x239ff & 0xFF},
	{0x23a00 & 0xFF, 0x23aff & 0xFF},
	{0x23b00 & 0xFF, 0x23bff & 0xFF},
	{0x23c00 & 0xFF, 0x23cff & 0xFF},
	{0x23d00 & 0xFF, 0x23dff & 0xFF},
	{0x23e00 & 0xFF, 0x23eff & 0xFF},
	{0x23f00 & 0xFF, 0x23fff & 0xFF},
	{0x24000 & 0xFF, 0x240ff & 0xFF},
	{0x24100 & 0xFF, 0x241ff & 0xFF},
	{0x24200 & 0xFF, 0x242ff & 0xFF},
	{0x24300 & 0xFF, 0x243ff & 0xFF},
	{0x24400 & 0xFF, 0x244ff & 0xFF},
	{0x24500 & 0xFF, 0x245ff & 0xFF},
	{0x24600 & 0xFF, 0x246ff & 0xFF},
	{0x24700 & 0xFF, 0x247ff & 0xFF},
	{0x24800 & 0xFF, 0x248ff & 0xFF},
	{0x24900 & 0xFF, 0x249ff & 0xFF},
	{0x24a00 & 0xFF, 0x24aff & 0xFF},
	{0x24b00 & 0xFF, 0x24bff & 0xFF},
	{0x24c00 & 0xFF, 0x24cff & 0xFF},
	{0x24d00 & 0xFF, 0x24dff & 0xFF},
	{0x24e00 & 0xFF, 0x24eff & 0xFF},
	{0x24f00 & 0xFF, 0x24fff & 0xFF},
	{0x25000 & 0xFF, 0x250ff & 0xFF},
	{0x25100 & 0xFF, 0x251ff & 0xFF},
	{0x25200 & 0xFF, 0x252ff & 0xFF},
	{0x25300 & 0xFF, 0x253ff & 0xFF},
	{0x25400 & 0xFF, 0x254ff & 0xFF},
	{0x25500 & 0xFF, 0x255ff & 0xFF},
	{0x25600 & 0xFF, 0x256ff & 0xFF},
	{0x25700 & 0xFF, 0x257ff & 0xFF},
	{0x25800 & 0xFF, 0x258ff & 0xFF},
	{0x25900 & 0xFF, 0x259ff & 0xFF},
	{0x25a00 & 0xFF, 0x25aff & 0xFF},
	{0x25b00 & 0xFF, 0x25bff & 0xFF},
	{0x25c00 & 0xFF, 0x25cff & 0xFF},
	{0x25d00 & 0xFF, 0x25dff & 0xFF},
	{0x25e00 & 0xFF, 0x25eff & 0xFF},
	{0x25f00 & 0xFF, 0x25fff & 0xFF},
	{0x26000 & 0xFF, 0x260ff & 0xFF},
	{0x26100 & 0xFF, 0x261ff & 0xFF},
	{0x26200 & 0xFF, 0x262ff & 0xFF},
	{0x26300 & 0xFF, 0x263ff & 0xFF},
	{0x26400 & 0xFF, 0x264ff & 0xFF},
	{0x26500 & 0xFF, 0x265ff & 0xFF},
	{0x26600 & 0xFF, 0x266ff & 0xFF},
	{0x26700 & 0xFF, 0x267ff & 0xFF},
	{0x26800 & 0xFF, 0x268ff & 0xFF},
	{0x26900 & 0xFF, 0x269ff & 0xFF},
	{0x26a00 & 0xFF, 0x26aff & 0xFF},
	{0x26b00 & 0xFF, 0x26bff & 0xFF},
	{0x26c00 & 0xFF, 0x26cff & 0xFF},
	{0x26d00 & 0xFF, 0x26dff & 0xFF},
	{0x26e00 & 0xFF, 0x26eff & 0xFF},
	{0x26f00 & 0xFF, 0x26fff & 0xFF},
	{0x27000 & 0xFF, 0x270ff & 0xFF},
	{0x27100 & 0xFF, 0x271ff & 0xFF},
	{0x27200 & 0xFF, 0x272ff & 0xFF},
	{0x27300 & 0xFF, 0x273ff & 0xFF},
	{0x27400 & 0xFF, 0x274ff & 0xFF},
	{0x27500 & 0xFF, 0x275ff & 0xFF},
	{0x27600 & 0xFF, 0x276ff & 0xFF},
	{0x27700 & 0xFF, 0x277ff & 0xFF},
	{0x27800 & 0xFF, 0x278ff & 0xFF},
	{0x27900 & 0xFF, 0x279ff & 0xFF},
	{0x27a00 & 0xFF, 0x27aff & 0xFF},
	{0x27b00 & 0xFF, 0x27bff & 0xFF},
	{0x27c00 & 0xFF, 0x27cff & 0xFF},
	{0x27d00 & 0xFF, 0x27dff & 0xFF},
	{0x27e00 & 0xFF, 0x27eff & 0xFF},
	{0x27f00 & 0xFF, 0x27fff & 0xFF},
	{0x28000 & 0xFF, 0x280ff & 0xFF},
	{0x28100 & 0xFF, 0x281ff & 0xFF},
	{0x28200 & 0xFF, 0x282ff & 0xFF},
	{0x28300 & 0xFF, 0x283ff & 0xFF},
	{0x28400 & 0xFF, 0x284ff & 0xFF},
	{0x28500 & 0xFF, 0x285ff & 0xFF},
	{0x28600 & 0xFF, 0x286ff & 0xFF},
	{0x28700 & 0xFF, 0x287ff & 0xFF},
	{0x28800 & 0xFF, 0x288ff & 0xFF},
	{0x28900 & 0xFF, 0x289ff & 0xFF},
	{0x28a00 & 0xFF, 0x28aff & 0xFF},
	{0x28b00 & 0xFF, 0x28bff & 0xFF},
	{0x28c00 & 0xFF, 0x28cff & 0xFF},
	{0x28d00 & 0xFF, 0x28dff & 0xFF},
	{0x28e00 & 0xFF, 0x28eff & 0xFF},
	{0x28f00 & 0xFF, 0x28fff & 0xFF},
	{0x29000 & 0xFF, 0x290ff & 0xFF},
	{0x29100 & 0xFF, 0x291ff & 0xFF},
	{0x29200 & 0xFF, 0x292ff & 0xFF},
	{0x29300 & 0xFF, 0x293ff & 0xFF},
	{0x29400 & 0xFF, 0x294ff & 0xFF},
	{0x29500 & 0xFF, 0x295ff & 0xFF},
	{0x29600 & 0xFF, 0x296ff & 0xFF},
	{0x29700 & 0xFF, 0x297ff & 0xFF},
	{0x29800 & 0xFF, 0x298ff & 0xFF},
	{0x29900 & 0xFF, 0x299ff & 0xFF},
	{0x29a00 & 0xFF, 0x29aff & 0xFF},
	{0x29b00 & 0xFF, 0x29bff & 0xFF},
	{0x29c00 & 0xFF, 0x29cff & 0xFF},
	{0x29d00 & 0xFF, 0x29dff & 0xFF},
	{0x29e00 & 0xFF, 0x29eff & 0xFF},
	{0x29f00 & 0xFF, 0x29fff & 0xFF},
	{0x2a000 & 0xFF, 0x2a0ff & 0xFF},
	{0x2a100 & 0xFF, 0x2a1ff & 0xFF},
	{0x2a200 & 0xFF, 0x2a2ff & 0xFF},
	{0x2a300 & 0xFF, 0x2a3ff & 0xFF},
	{0x2a400 & 0xFF, 0x2a4ff & 0xFF},
	{0x2a500 & 0xFF, 0x2a5ff & 0xFF},
	{0x2a600 & 0xFF, 0x2a6df & 0xFF},
	{0x2a700 & 0xFF, 0x2a7ff & 0xFF},
	{0x2a800 & 0xFF, 0x2a8ff & 0xFF},
	{0x2a900 & 0xFF, 0x2a9ff & 0xFF},
	{0x2aa00 & 0xFF, 0x2aaff & 0xFF},
	{0x2ab00 & 0xFF, 0x2abff & 0xFF},
	{0x2ac00 & 0xFF, 0x2acff & 0xFF},
	{0x2ad00 & 0xFF, 0x2adff & 0xFF},
	{0x2ae00 & 0xFF, 0x2aeff & 0xFF},
	{0x2af00 & 0xFF, 0x2afff & 0xFF},
	{0x2b000 & 0xFF, 0x2b0ff & 0xFF},
	{0x2b100 & 0xFF, 0x2b1ff & 0xFF},
	{0x2b200 & 0xFF, 0x2b2ff & 0xFF},
	{0x2b300 & 0xFF, 0x2b3ff & 0xFF},
	{0x2b400 & 0xFF, 0x2b4ff & 0xFF},
	{0x2b500 & 0xFF, 0x2b5ff & 0xFF},
	{0x2b600 & 0xFF, 0x2b6ff & 0xFF},
	{0x2b700 & 0xFF, 0x2b739 & 0xFF},
	{0x2b740 & 0xFF, 0x2b7ff & 0xFF},
	{0x2b800 & 0xFF, 0x2b81d & 0xFF},
	{0x2b820 & 0xFF, 0x2b8ff & 0xFF},
	{0x2b900 & 0xFF, 0x2b9ff & 0xFF},
	{0x2ba00 & 0xFF, 0x2baff & 0xFF},
	{0x2bb00 & 0xFF, 0x2bbff & 0xFF},
	{0x2bc00 & 0xFF, 0x2bcff & 0xFF},
	{0x2bd00 & 0xFF, 0x2bdff & 0xFF},
	{0x2be00 & 0xFF, 0x2beff & 0xFF},
	{0x2bf00 & 0xFF, 0x2bfff & 0xFF},
	{0x2c000 & 0xFF, 0x2c0ff & 0xFF},
	{0x2c100 & 0xFF, 0x2c1ff & 0xFF},
	{0x2c200 & 0xFF, 0x2c2ff & 0xFF},
	{0x2c300 & 0xFF, 0x2c3ff & 0xFF},
	{0x2c400 & 0xFF, 0x2c4ff & 0xFF},
	{0x2c500 & 0xFF, 0x2c5ff & 0xFF},
	{0x2c600 & 0xFF, 0x2c6ff & 0xFF},
	{0x2c700 & 0xFF, 0x2c7ff & 0xFF},
	{0x2c800 & 0xFF, 0x2c8ff & 0xFF},
	{0x2c900 & 0xFF, 0x2c9ff & 0xFF},
	{0x2ca00 & 0xFF, 0x2caff & 0xFF},
	{0x2cb00 & 0xFF, 0x2cbff & 0xFF},
	{0x2cc00 & 0xFF, 0x2ccff & 0xFF},
	{0x2cd00 & 0xFF, 0x2cdff & 0xFF},
	{0x2ce00 & 0xFF, 0x2cea1 & 0xFF},
	{0x2ceb0 & 0xFF, 0x2ceff & 0xFF},
	{0x2cf00 & 0xFF, 0x2cfff & 0xFF},
	{0x2d000 & 0xFF, 0x2d0ff & 0xFF},
	{0x2d100 & 0xFF, 0x2d1ff & 0xFF},
	{0x2d200 & 0xFF, 0x2d2ff & 0xFF},
	{0x2d300 & 0xFF, 0x2d3ff & 0xFF},
	{0x2d400 & 0xFF, 0x2d4ff & 0xFF},
	{0x2d500 & 0xFF, 0x2d5ff & 0xFF},
	{0x2d600 & 0xFF, 0x2d6ff & 0xFF},
	{0x2d700 & 0xFF, 0x2d7ff & 0xFF},
	{0x2d800 & 0xFF, 0x2d8ff & 0xFF},
	{0x2d900 & 0xFF, 0x2d9ff & 0xFF},
	{0x2da00 & 0xFF, 0x2daff & 0xFF},
	{0x2db00 & 0xFF, 0x2dbff & 0xFF},
	{0x2dc00 & 0xFF, 0x2dcff & 0xFF},
	{0x2dd00 & 0xFF, 0x2ddff & 0xFF},
	{0x2de00 & 0xFF, 0x2deff & 0xFF},
	{0x2df00 & 0xFF, 0x2dfff & 0xFF},
	{0x2e000 & 0xFF, 0x2e0ff & 0xFF},
	{0x2e100 & 0xFF, 0x2e1ff & 0xFF},
	{0x2e200 & 0xFF, 0x2e2ff & 0xFF},
	{0x2e300 & 0xFF, 0x2e3ff & 0xFF},
	{0x2e400 & 0xFF, 0x2e4ff & 0xFF},
	{0x2e500 & 0xFF, 0x2e5ff & 0xFF},
	{0x2e600 & 0xFF, 0x2e6ff & 0xFF},
	{0x2e700 & 0xFF, 0x2e7ff & 0xFF},
	{0x2e800 & 0xFF, 0x2e8ff & 0xFF},
	{0x2e900 & 0xFF, 0x2e9ff & 0xFF},
	{0x2ea00 & 0xFF, 0x2eaff & 0xFF},
	{0x2eb00 & 0xFF, 0x2ebe0 & 0xFF},
	{0x2ebf0 & 0xFF, 0x2ebff & 0xFF},
	{0x2ec00 & 0xFF, 0x2ecff & 0xFF},
	{0x2ed00 & 0xFF, 0x2edff & 0xFF},
	{0x2ee00 & 0xFF, 0x2ee5d & 0xFF},
	{0x2f800 & 0xFF, 0x2f8ff & 0xFF},
	{0x2f900 & 0xFF, 0x2f9ff & 0xFF},
	{0x2fa00 & 0xFF, 0x2fa1d & 0xFF},
	{0x30000 & 0xFF, 0x300ff & 0xFF},
	{0x30100 & 0xFF, 0x301ff & 0xFF},
	{0x30200 & 0xFF, 0x302ff & 0xFF},
	{0x30300 & 0xFF, 0x303ff & 0xFF},
	{0x30400 & 0xFF, 0x304ff & 0xFF},
	{0x30500 & 0xFF, 0x305ff & 0xFF},
	{0x30600 & 0xFF, 0x306ff & 0xFF},
	{0x30700 & 0xFF, 0x307ff & 0xFF},
	{0x30800 & 0xFF, 0x308ff & 0xFF},
	{0x30900 & 0xFF, 0x309ff & 0xFF},
	{0x30a00 & 0xFF, 0x30aff & 0xFF},
	{0x30b00 & 0xFF, 0x30bff & 0xFF},
	{0x30c00 & 0xFF, 0x30cff & 0xFF},
	{0x30d00 & 0xFF, 0x30dff & 0xFF},
	{0x30e00 & 0xFF, 0x30eff & 0xFF},
	{0x30f00 & 0xFF, 0x30fff & 0xFF},
	{0x31000 & 0xFF, 0x310ff & 0xFF},
	{0x31100 & 0xFF, 0x311ff & 0xFF},
	{0x31200 & 0xFF, 0x312ff & 0xFF},
	{0x31300 & 0xFF, 0x3134a & 0xFF},
	{0x31350 & 0xFF, 0x313ff & 0xFF},
	{0x31400 & 0xFF, 0x314ff & 0xFF},
	{0x31500 & 0xFF, 0x315ff & 0xFF},
	{0x31600 & 0xFF, 0x316ff & 0xFF},
	{0x31700 & 0xFF, 0x317ff & 0xFF},
	{0x31800 & 0xFF, 0x318ff & 0xFF},
	{0x31900 & 0xFF, 0x319ff & 0xFF},
	{0x31a00 & 0xFF, 0x31aff & 0xFF},
	{0x31b00 & 0xFF, 0x31bff & 0xFF},
	{0x31c00 & 0xFF, 0x31cff & 0xFF},
	{0x31d00 & 0xFF, 0x31dff & 0xFF},
	{0x31e00 & 0xFF, 0x31eff & 0xFF},
	{0x31f00 & 0xFF, 0x31fff & 0xFF},
	{0x32000 & 0xFF, 0x320ff & 0xFF},
	{0x32100 & 0xFF, 0x321ff & 0xFF},
	{0x32200 & 0xFF, 0x322ff & 0xFF},
	{0x32300 & 0xFF, 0x323af & 0xFF},
	{0xe0100 & 0xFF, 0xe01ef & 0xFF}};

static const size_t ID_Continue_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	30,
	31,
	32,
	33,
	44,
	45,
	48,
	49,
	52,
	53,
	54,
	55,
	56,
	57,
	58,
	59,
	60,
	61,
	62,
	63,
	64,
	65,
	66,
	67,
	68,
	69,
	70,
	71,
	72,
	73,
	74,
	75,
	76,
	77,
	78,
	79,
	80,
	81,
	82,
	83,
	84,
	85,
	86,
	87,
	88,
	89,
	90,
	91,
	92,
	93,
	94,
	95,
	96,
	97,
	98,
	99,
	100,
	101,
	102,
	103,
	104,
	105,
	106,
	107,
	108,
	109,
	110,
	111,
	112,
	113,
	114,
	115,
	116,
	117,
	118,
	119,
	120,
	121,
	122,
	123,
	124,
	125,
	126,
	127,
	128,
	129,
	130,
	131,
	132,
	133,
	134,
	135,
	136,
	137,
	138,
	139,
	140,
	141,
	142,
	143,
	144,
	145,
	146,
	147,
	148,
	149,
	150,
	151,
	152,
	153,
	154,
	155,
	156,
	157,
	158,
	159,
	160,
	161,
	162,
	163,
	164,
	165,
	166,
	167,
	168,
	169,
	170,
	171,
	172,
	173,
	174,
	175,
	176,
	177,
	178,
	179,
	180,
	181,
	182,
	183,
	184,
	185,
	186,
	187,
	188,
	189,
	190,
	191,
	192,
	193,
	194,
	195,
	196,
	197,
	198,
	199,
	200,
	201,
	202,
	203,
	204,
	205,
	206,
	207,
	208,
	209,
	210,
	211,
	212,
	213,
	214,
	215,
	249,
	250,
	251,
	252,
	253,
	254,
	255,
	256,
	257,
	258,
	259,
	260,
	261,
	262,
	263,
	264,
	265,
	266,
	267,
	268,
	269,
	270,
	271,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	284,
	285,
	286,
	287,
	288,
	289,
	290,
	291,
	292,
	293,
	303,
	304,
	305,
	306,
	307,
	308,
	324,
	325,
	326,
	360,
	361,
	362,
	363,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	431,
	432,
	433,
	434,
	444,
	463,
	465,
	466,
	468,
	469,
	470,
	471,
	474,
	479,
	480,
	481,
	482,
	484,
	487,
	488,
	489,
	494,
	507,
	512,
	513,
	514,
	515,
	516,
	517,
	518,
	519,
	520,
	521,
	522,
	523,
	524,
	525,
	526,
	527,
	528,
	529,
	530,
	531,
	532,
	533,
	534,
	535,
	536,
	537,
	538,
	539,
	540,
	541,
	542,
	543,
	544,
	545,
	546,
	547,
	548,
	549,
	550,
	551,
	552,
	553,
	554,
	555,
	556,
	557,
	558,
	559,
	560,
	561,
	562,
	563,
	564,
	565,
	566,
	567,
	568,
	569,
	570,
	571,
	572,
	573,
	574,
	575,
	576,
	577,
	578,
	579,
	580,
	581,
	582,
	583,
	584,
	585,
	586,
	587,
	588,
	589,
	590,
	591,
	592,
	593,
	594,
	595,
	596,
	597,
	598,
	599,
	600,
	601,
	602,
	603,
	604,
	605,
	606,
	607,
	608,
	609,
	610,
	611,
	612,
	613,
	614,
	615,
	616,
	617,
	618,
	619,
	620,
	621,
	622,
	623,
	624,
	625,
	626,
	627,
	628,
	629,
	630,
	631,
	632,
	633,
	634,
	635,
	636,
	637,
	638,
	639,
	640,
	641,
	642,
	643,
	644,
	645,
	646,
	647,
	648,
	649,
	650,
	651,
	652,
	653,
	654,
	655,
	656,
	657,
	658,
	659,
	660,
	661,
	662,
	663,
	664,
	665,
	666,
	667,
	668,
	669,
	670,
	671,
	672,
	673,
	674,
	675,
	676,
	677,
	678,
	679,
	680,
	681,
	682,
	683,
	684,
	685,
	686,
	687,
	688,
	689,
	690,
	691,
	692,
	693,
	694,
	695,
	696,
	697,
	698,
	699,
	700,
	701,
	702,
	703,
	704,
	705,
	706,
	707,
	708,
	709,
	710,
	711,
	712,
	713,
	714,
	715,
	716,
	717,
	718,
	719,
	720,
	721,
	722,
	723,
	724,
	725,
	726,
	727,
	728,
	729,
	730,
	731,
	732,
	733,
	734,
	735,
	736,
	737,
	738,
	739,
	740,
	741,
	742,
	743,
	744,
	745,
	746,
	747,
	748,
	749,
	750,
	760,
	761,
	762,
	768,
	769,
	770,
	771,
	772,
	773,
	774,
	775,
	776,
	777,
	778,
	779,
	780,
	781,
	782,
	783,
	784,
	785,
	786,
	787,
	788,
	789,
	790,
	791,
	792,
	793,
	794,
	795,
	796,
	797,
	798,
	799,
	800,
	801,
	802,
	803,
	3585
};

static const char32_t ID_Continue_starting_pagetab[]={
	0,
	11,
	12,
	17,
	26,
	29,
	40,
	47,
	52,
	59,
	77,
	107,
	138,
	164,
	185,
	199,
	211,
	218,
	219,
	233,
	241,
	242,
	243,
	248,
	258,
	263,
	271,
	279,
	283,
	291,
	292,
	293,
	312,
	321,
	334,
	336,
	351,
	358,
	362,
	363,
	364,
	365,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	398,
	399,
	400,
	401,
	402,
	403,
	404,
	405,
	406,
	407,
	408,
	409,
	410,
	411,
	412,
	413,
	414,
	415,
	416,
	417,
	418,
	419,
	420,
	421,
	422,
	423,
	424,
	425,
	426,
	427,
	428,
	429,
	430,
	431,
	432,
	433,
	434,
	435,
	436,
	437,
	438,
	439,
	440,
	441,
	442,
	443,
	444,
	445,
	446,
	447,
	448,
	449,
	450,
	451,
	452,
	453,
	454,
	455,
	456,
	457,
	458,
	459,
	460,
	461,
	462,
	463,
	464,
	465,
	466,
	467,
	468,
	469,
	470,
	471,
	472,
	473,
	474,
	476,
	477,
	482,
	489,
	497,
	503,
	511,
	521,
	522,
	523,
	524,
	525,
	526,
	527,
	528,
	529,
	530,
	531,
	532,
	533,
	534,
	535,
	536,
	537,
	538,
	539,
	540,
	541,
	542,
	543,
	544,
	545,
	546,
	547,
	548,
	549,
	550,
	551,
	552,
	553,
	554,
	555,
	556,
	557,
	558,
	559,
	560,
	561,
	562,
	563,
	564,
	567,
	568,
	570,
	580,
	581,
	585,
	591,
	600,
	607,
	609,
	612,
	619,
	623,
	633,
	634,
	640,
	650,
	654,
	665,
	669,
	672,
	674,
	678,
	684,
	690,
	699,
	709,
	724,
	730,
	733,
	738,
	742,
	745,
	757,
	762,
	769,
	782,
	783,
	788,
	789,
	790,
	791,
	792,
	794,
	795,
	796,
	797,
	798,
	799,
	800,
	802,
	803,
	804,
	805,
	806,
	807,
	814,
	819,
	820,
	826,
	827,
	828,
	829,
	830,
	831,
	832,
	833,
	834,
	835,
	836,
	837,
	838,
	839,
	840,
	841,
	842,
	843,
	844,
	845,
	846,
	847,
	848,
	849,
	850,
	851,
	852,
	853,
	854,
	855,
	856,
	859,
	860,
	866,
	867,
	872,
	874,
	879,
	880,
	890,
	900,
	905,
	914,
	920,
	922,
	929,
	933,
	935,
	936,
	940,
	942,
	944,
	977,
	978,
	979,
	980,
	981,
	982,
	983,
	984,
	985,
	986,
	987,
	988,
	989,
	990,
	991,
	992,
	993,
	994,
	995,
	996,
	997,
	998,
	999,
	1000,
	1001,
	1002,
	1003,
	1004,
	1005,
	1006,
	1007,
	1008,
	1009,
	1010,
	1011,
	1012,
	1013,
	1014,
	1015,
	1016,
	1017,
	1018,
	1019,
	1020,
	1021,
	1022,
	1023,
	1024,
	1025,
	1026,
	1027,
	1028,
	1029,
	1030,
	1031,
	1032,
	1033,
	1034,
	1035,
	1036,
	1037,
	1038,
	1039,
	1040,
	1041,
	1042,
	1043,
	1044,
	1045,
	1046,
	1047,
	1048,
	1049,
	1050,
	1051,
	1052,
	1053,
	1054,
	1055,
	1056,
	1057,
	1058,
	1059,
	1060,
	1061,
	1062,
	1063,
	1064,
	1065,
	1066,
	1067,
	1068,
	1069,
	1070,
	1071,
	1072,
	1073,
	1074,
	1075,
	1076,
	1077,
	1078,
	1079,
	1080,
	1081,
	1082,
	1083,
	1084,
	1085,
	1086,
	1087,
	1088,
	1089,
	1090,
	1091,
	1092,
	1093,
	1094,
	1095,
	1096,
	1097,
	1098,
	1099,
	1100,
	1101,
	1102,
	1103,
	1104,
	1105,
	1106,
	1107,
	1108,
	1109,
	1110,
	1111,
	1112,
	1113,
	1114,
	1115,
	1116,
	1117,
	1118,
	1119,
	1120,
	1121,
	1122,
	1123,
	1124,
	1125,
	1126,
	1127,
	1128,
	1129,
	1130,
	1131,
	1132,
	1133,
	1134,
	1135,
	1136,
	1137,
	1138,
	1139,
	1140,
	1141,
	1142,
	1143,
	1144,
	1145,
	1146,
	1147,
	1148,
	1149,
	1150,
	1151,
	1152,
	1153,
	1154,
	1155,
	1156,
	1157,
	1158,
	1159,
	1160,
	1161,
	1163,
	1165,
	1166,
	1167,
	1168,
	1169,
	1170,
	1171,
	1172,
	1173,
	1174,
	1175,
	1176,
	1177,
	1178,
	1179,
	1180,
	1181,
	1182,
	1183,
	1184,
	1185,
	1186,
	1188,
	1189,
	1190,
	1191,
	1192,
	1193,
	1194,
	1195,
	1196,
	1197,
	1198,
	1199,
	1200,
	1201,
	1202,
	1203,
	1204,
	1205,
	1206,
	1207,
	1208,
	1209,
	1210,
	1211,
	1212,
	1213,
	1214,
	1215,
	1216,
	1218,
	1219,
	1220,
	1221,
	1222,
	1223,
	1224,
	1225,
	1226,
	1227,
	1228,
	1229,
	1230,
	1231,
	1232,
	1233,
	1234,
	1235,
	1236,
	1237,
	1238,
	1239,
	1240,
	1241,
	1242,
	1243,
	1245,
	1246,
	1247,
	1248,
	1249,
	1250,
	1251,
	1252,
	1253,
	1254,
	1255,
	1256,
	1257,
	1258,
	1259,
	1260,
	1261
};

static const uint8_t ID_Start_rangetab[][2]={
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00aa & 0xFF, 0x00aa & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00ba & 0xFF, 0x00ba & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0100 & 0xFF, 0x01ff & 0xFF},
	{0x0200 & 0xFF, 0x02c1 & 0xFF},
	{0x02c6 & 0xFF, 0x02d1 & 0xFF},
	{0x02e0 & 0xFF, 0x02e4 & 0xFF},
	{0x02ec & 0xFF, 0x02ec & 0xFF},
	{0x02ee & 0xFF, 0x02ee & 0xFF},
	{0x0370 & 0xFF, 0x0374 & 0xFF},
	{0x0376 & 0xFF, 0x0377 & 0xFF},
	{0x037a & 0xFF, 0x037d & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x0386 & 0xFF},
	{0x0388 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03f5 & 0xFF},
	{0x03f7 & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x0481 & 0xFF},
	{0x048a & 0xFF, 0x04ff & 0xFF},
	{0x0500 & 0xFF, 0x052f & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x0559 & 0xFF, 0x0559 & 0xFF},
	{0x0560 & 0xFF, 0x0588 & 0xFF},
	{0x05d0 & 0xFF, 0x05ea & 0xFF},
	{0x05ef & 0xFF, 0x05f2 & 0xFF},
	{0x0620 & 0xFF, 0x064a & 0xFF},
	{0x066e & 0xFF, 0x066f & 0xFF},
	{0x0671 & 0xFF, 0x06d3 & 0xFF},
	{0x06d5 & 0xFF, 0x06d5 & 0xFF},
	{0x06e5 & 0xFF, 0x06e6 & 0xFF},
	{0x06ee & 0xFF, 0x06ef & 0xFF},
	{0x06fa & 0xFF, 0x06fc & 0xFF},
	{0x06ff & 0xFF, 0x06ff & 0xFF},
	{0x0710 & 0xFF, 0x0710 & 0xFF},
	{0x0712 & 0xFF, 0x072f & 0xFF},
	{0x074d & 0xFF, 0x07a5 & 0xFF},
	{0x07b1 & 0xFF, 0x07b1 & 0xFF},
	{0x07ca & 0xFF, 0x07ea & 0xFF},
	{0x07f4 & 0xFF, 0x07f5 & 0xFF},
	{0x07fa & 0xFF, 0x07fa & 0xFF},
	{0x0800 & 0xFF, 0x0815 & 0xFF},
	{0x081a & 0xFF, 0x081a & 0xFF},
	{0x0824 & 0xFF, 0x0824 & 0xFF},
	{0x0828 & 0xFF, 0x0828 & 0xFF},
	{0x0840 & 0xFF, 0x0858 & 0xFF},
	{0x0860 & 0xFF, 0x086a & 0xFF},
	{0x0870 & 0xFF, 0x0887 & 0xFF},
	{0x0889 & 0xFF, 0x088e & 0xFF},
	{0x08a0 & 0xFF, 0x08c9 & 0xFF},
	{0x0904 & 0xFF, 0x0939 & 0xFF},
	{0x093d & 0xFF, 0x093d & 0xFF},
	{0x0950 & 0xFF, 0x0950 & 0xFF},
	{0x0958 & 0xFF, 0x0961 & 0xFF},
	{0x0971 & 0xFF, 0x0980 & 0xFF},
	{0x0985 & 0xFF, 0x098c & 0xFF},
	{0x098f & 0xFF, 0x0990 & 0xFF},
	{0x0993 & 0xFF, 0x09a8 & 0xFF},
	{0x09aa & 0xFF, 0x09b0 & 0xFF},
	{0x09b2 & 0xFF, 0x09b2 & 0xFF},
	{0x09b6 & 0xFF, 0x09b9 & 0xFF},
	{0x09bd & 0xFF, 0x09bd & 0xFF},
	{0x09ce & 0xFF, 0x09ce & 0xFF},
	{0x09dc & 0xFF, 0x09dd & 0xFF},
	{0x09df & 0xFF, 0x09e1 & 0xFF},
	{0x09f0 & 0xFF, 0x09f1 & 0xFF},
	{0x09fc & 0xFF, 0x09fc & 0xFF},
	{0x0a05 & 0xFF, 0x0a0a & 0xFF},
	{0x0a0f & 0xFF, 0x0a10 & 0xFF},
	{0x0a13 & 0xFF, 0x0a28 & 0xFF},
	{0x0a2a & 0xFF, 0x0a30 & 0xFF},
	{0x0a32 & 0xFF, 0x0a33 & 0xFF},
	{0x0a35 & 0xFF, 0x0a36 & 0xFF},
	{0x0a38 & 0xFF, 0x0a39 & 0xFF},
	{0x0a59 & 0xFF, 0x0a5c & 0xFF},
	{0x0a5e & 0xFF, 0x0a5e & 0xFF},
	{0x0a72 & 0xFF, 0x0a74 & 0xFF},
	{0x0a85 & 0xFF, 0x0a8d & 0xFF},
	{0x0a8f & 0xFF, 0x0a91 & 0xFF},
	{0x0a93 & 0xFF, 0x0aa8 & 0xFF},
	{0x0aaa & 0xFF, 0x0ab0 & 0xFF},
	{0x0ab2 & 0xFF, 0x0ab3 & 0xFF},
	{0x0ab5 & 0xFF, 0x0ab9 & 0xFF},
	{0x0abd & 0xFF, 0x0abd & 0xFF},
	{0x0ad0 & 0xFF, 0x0ad0 & 0xFF},
	{0x0ae0 & 0xFF, 0x0ae1 & 0xFF},
	{0x0af9 & 0xFF, 0x0af9 & 0xFF},
	{0x0b05 & 0xFF, 0x0b0c & 0xFF},
	{0x0b0f & 0xFF, 0x0b10 & 0xFF},
	{0x0b13 & 0xFF, 0x0b28 & 0xFF},
	{0x0b2a & 0xFF, 0x0b30 & 0xFF},
	{0x0b32 & 0xFF, 0x0b33 & 0xFF},
	{0x0b35 & 0xFF, 0x0b39 & 0xFF},
	{0x0b3d & 0xFF, 0x0b3d & 0xFF},
	{0x0b5c & 0xFF, 0x0b5d & 0xFF},
	{0x0b5f & 0xFF, 0x0b61 & 0xFF},
	{0x0b71 & 0xFF, 0x0b71 & 0xFF},
	{0x0b83 & 0xFF, 0x0b83 & 0xFF},
	{0x0b85 & 0xFF, 0x0b8a & 0xFF},
	{0x0b8e & 0xFF, 0x0b90 & 0xFF},
	{0x0b92 & 0xFF, 0x0b95 & 0xFF},
	{0x0b99 & 0xFF, 0x0b9a & 0xFF},
	{0x0b9c & 0xFF, 0x0b9c & 0xFF},
	{0x0b9e & 0xFF, 0x0b9f & 0xFF},
	{0x0ba3 & 0xFF, 0x0ba4 & 0xFF},
	{0x0ba8 & 0xFF, 0x0baa & 0xFF},
	{0x0bae & 0xFF, 0x0bb9 & 0xFF},
	{0x0bd0 & 0xFF, 0x0bd0 & 0xFF},
	{0x0c05 & 0xFF, 0x0c0c & 0xFF},
	{0x0c0e & 0xFF, 0x0c10 & 0xFF},
	{0x0c12 & 0xFF, 0x0c28 & 0xFF},
	{0x0c2a & 0xFF, 0x0c39 & 0xFF},
	{0x0c3d & 0xFF, 0x0c3d & 0xFF},
	{0x0c58 & 0xFF, 0x0c5a & 0xFF},
	{0x0c5d & 0xFF, 0x0c5d & 0xFF},
	{0x0c60 & 0xFF, 0x0c61 & 0xFF},
	{0x0c80 & 0xFF, 0x0c80 & 0xFF},
	{0x0c85 & 0xFF, 0x0c8c & 0xFF},
	{0x0c8e & 0xFF, 0x0c90 & 0xFF},
	{0x0c92 & 0xFF, 0x0ca8 & 0xFF},
	{0x0caa & 0xFF, 0x0cb3 & 0xFF},
	{0x0cb5 & 0xFF, 0x0cb9 & 0xFF},
	{0x0cbd & 0xFF, 0x0cbd & 0xFF},
	{0x0cdd & 0xFF, 0x0cde & 0xFF},
	{0x0ce0 & 0xFF, 0x0ce1 & 0xFF},
	{0x0cf1 & 0xFF, 0x0cf2 & 0xFF},
	{0x0d04 & 0xFF, 0x0d0c & 0xFF},
	{0x0d0e & 0xFF, 0x0d10 & 0xFF},
	{0x0d12 & 0xFF, 0x0d3a & 0xFF},
	{0x0d3d & 0xFF, 0x0d3d & 0xFF},
	{0x0d4e & 0xFF, 0x0d4e & 0xFF},
	{0x0d54 & 0xFF, 0x0d56 & 0xFF},
	{0x0d5f & 0xFF, 0x0d61 & 0xFF},
	{0x0d7a & 0xFF, 0x0d7f & 0xFF},
	{0x0d85 & 0xFF, 0x0d96 & 0xFF},
	{0x0d9a & 0xFF, 0x0db1 & 0xFF},
	{0x0db3 & 0xFF, 0x0dbb & 0xFF},
	{0x0dbd & 0xFF, 0x0dbd & 0xFF},
	{0x0dc0 & 0xFF, 0x0dc6 & 0xFF},
	{0x0e01 & 0xFF, 0x0e30 & 0xFF},
	{0x0e32 & 0xFF, 0x0e33 & 0xFF},
	{0x0e40 & 0xFF, 0x0e46 & 0xFF},
	{0x0e81 & 0xFF, 0x0e82 & 0xFF},
	{0x0e84 & 0xFF, 0x0e84 & 0xFF},
	{0x0e86 & 0xFF, 0x0e8a & 0xFF},
	{0x0e8c & 0xFF, 0x0ea3 & 0xFF},
	{0x0ea5 & 0xFF, 0x0ea5 & 0xFF},
	{0x0ea7 & 0xFF, 0x0eb0 & 0xFF},
	{0x0eb2 & 0xFF, 0x0eb3 & 0xFF},
	{0x0ebd & 0xFF, 0x0ebd & 0xFF},
	{0x0ec0 & 0xFF, 0x0ec4 & 0xFF},
	{0x0ec6 & 0xFF, 0x0ec6 & 0xFF},
	{0x0edc & 0xFF, 0x0edf & 0xFF},
	{0x0f00 & 0xFF, 0x0f00 & 0xFF},
	{0x0f40 & 0xFF, 0x0f47 & 0xFF},
	{0x0f49 & 0xFF, 0x0f6c & 0xFF},
	{0x0f88 & 0xFF, 0x0f8c & 0xFF},
	{0x1000 & 0xFF, 0x102a & 0xFF},
	{0x103f & 0xFF, 0x103f & 0xFF},
	{0x1050 & 0xFF, 0x1055 & 0xFF},
	{0x105a & 0xFF, 0x105d & 0xFF},
	{0x1061 & 0xFF, 0x1061 & 0xFF},
	{0x1065 & 0xFF, 0x1066 & 0xFF},
	{0x106e & 0xFF, 0x1070 & 0xFF},
	{0x1075 & 0xFF, 0x1081 & 0xFF},
	{0x108e & 0xFF, 0x108e & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x10d0 & 0xFF, 0x10fa & 0xFF},
	{0x10fc & 0xFF, 0x10ff & 0xFF},
	{0x1100 & 0xFF, 0x11ff & 0xFF},
	{0x1200 & 0xFF, 0x1248 & 0xFF},
	{0x124a & 0xFF, 0x124d & 0xFF},
	{0x1250 & 0xFF, 0x1256 & 0xFF},
	{0x1258 & 0xFF, 0x1258 & 0xFF},
	{0x125a & 0xFF, 0x125d & 0xFF},
	{0x1260 & 0xFF, 0x1288 & 0xFF},
	{0x128a & 0xFF, 0x128d & 0xFF},
	{0x1290 & 0xFF, 0x12b0 & 0xFF},
	{0x12b2 & 0xFF, 0x12b5 & 0xFF},
	{0x12b8 & 0xFF, 0x12be & 0xFF},
	{0x12c0 & 0xFF, 0x12c0 & 0xFF},
	{0x12c2 & 0xFF, 0x12c5 & 0xFF},
	{0x12c8 & 0xFF, 0x12d6 & 0xFF},
	{0x12d8 & 0xFF, 0x12ff & 0xFF},
	{0x1300 & 0xFF, 0x1310 & 0xFF},
	{0x1312 & 0xFF, 0x1315 & 0xFF},
	{0x1318 & 0xFF, 0x135a & 0xFF},
	{0x1380 & 0xFF, 0x138f & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1401 & 0xFF, 0x14ff & 0xFF},
	{0x1500 & 0xFF, 0x15ff & 0xFF},
	{0x1600 & 0xFF, 0x166c & 0xFF},
	{0x166f & 0xFF, 0x167f & 0xFF},
	{0x1681 & 0xFF, 0x169a & 0xFF},
	{0x16a0 & 0xFF, 0x16ea & 0xFF},
	{0x16ee & 0xFF, 0x16f8 & 0xFF},
	{0x1700 & 0xFF, 0x1711 & 0xFF},
	{0x171f & 0xFF, 0x1731 & 0xFF},
	{0x1740 & 0xFF, 0x1751 & 0xFF},
	{0x1760 & 0xFF, 0x176c & 0xFF},
	{0x176e & 0xFF, 0x1770 & 0xFF},
	{0x1780 & 0xFF, 0x17b3 & 0xFF},
	{0x17d7 & 0xFF, 0x17d7 & 0xFF},
	{0x17dc & 0xFF, 0x17dc & 0xFF},
	{0x1820 & 0xFF, 0x1878 & 0xFF},
	{0x1880 & 0xFF, 0x18a8 & 0xFF},
	{0x18aa & 0xFF, 0x18aa & 0xFF},
	{0x18b0 & 0xFF, 0x18f5 & 0xFF},
	{0x1900 & 0xFF, 0x191e & 0xFF},
	{0x1950 & 0xFF, 0x196d & 0xFF},
	{0x1970 & 0xFF, 0x1974 & 0xFF},
	{0x1980 & 0xFF, 0x19ab & 0xFF},
	{0x19b0 & 0xFF, 0x19c9 & 0xFF},
	{0x1a00 & 0xFF, 0x1a16 & 0xFF},
	{0x1a20 & 0xFF, 0x1a54 & 0xFF},
	{0x1aa7 & 0xFF, 0x1aa7 & 0xFF},
	{0x1b05 & 0xFF, 0x1b33 & 0xFF},
	{0x1b45 & 0xFF, 0x1b4c & 0xFF},
	{0x1b83 & 0xFF, 0x1ba0 & 0xFF},
	{0x1bae & 0xFF, 0x1baf & 0xFF},
	{0x1bba & 0xFF, 0x1be5 & 0xFF},
	{0x1c00 & 0xFF, 0x1c23 & 0xFF},
	{0x1c4d & 0xFF, 0x1c4f & 0xFF},
	{0x1c5a & 0xFF, 0x1c7d & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1ce9 & 0xFF, 0x1cec & 0xFF},
	{0x1cee & 0xFF, 0x1cf3 & 0xFF},
	{0x1cf5 & 0xFF, 0x1cf6 & 0xFF},
	{0x1cfa & 0xFF, 0x1cfa & 0xFF},
	{0x1d00 & 0xFF, 0x1dbf & 0xFF},
	{0x1e00 & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f15 & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f20 & 0xFF, 0x1f45 & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fbc & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fcc & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe0 & 0xFF, 0x1fec & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ffc & 0xFF},
	{0x2071 & 0xFF, 0x2071 & 0xFF},
	{0x207f & 0xFF, 0x207f & 0xFF},
	{0x2090 & 0xFF, 0x209c & 0xFF},
	{0x2102 & 0xFF, 0x2102 & 0xFF},
	{0x2107 & 0xFF, 0x2107 & 0xFF},
	{0x210a & 0xFF, 0x2113 & 0xFF},
	{0x2115 & 0xFF, 0x2115 & 0xFF},
	{0x2118 & 0xFF, 0x211d & 0xFF},
	{0x2124 & 0xFF, 0x2124 & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x2128 & 0xFF, 0x2128 & 0xFF},
	{0x212a & 0xFF, 0x2139 & 0xFF},
	{0x213c & 0xFF, 0x213f & 0xFF},
	{0x2145 & 0xFF, 0x2149 & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2160 & 0xFF, 0x2188 & 0xFF},
	{0x2c00 & 0xFF, 0x2ce4 & 0xFF},
	{0x2ceb & 0xFF, 0x2cee & 0xFF},
	{0x2cf2 & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0x2d30 & 0xFF, 0x2d67 & 0xFF},
	{0x2d6f & 0xFF, 0x2d6f & 0xFF},
	{0x2d80 & 0xFF, 0x2d96 & 0xFF},
	{0x2da0 & 0xFF, 0x2da6 & 0xFF},
	{0x2da8 & 0xFF, 0x2dae & 0xFF},
	{0x2db0 & 0xFF, 0x2db6 & 0xFF},
	{0x2db8 & 0xFF, 0x2dbe & 0xFF},
	{0x2dc0 & 0xFF, 0x2dc6 & 0xFF},
	{0x2dc8 & 0xFF, 0x2dce & 0xFF},
	{0x2dd0 & 0xFF, 0x2dd6 & 0xFF},
	{0x2dd8 & 0xFF, 0x2dde & 0xFF},
	{0x3005 & 0xFF, 0x3007 & 0xFF},
	{0x3021 & 0xFF, 0x3029 & 0xFF},
	{0x3031 & 0xFF, 0x3035 & 0xFF},
	{0x3038 & 0xFF, 0x303c & 0xFF},
	{0x3041 & 0xFF, 0x3096 & 0xFF},
	{0x309b & 0xFF, 0x309f & 0xFF},
	{0x30a1 & 0xFF, 0x30fa & 0xFF},
	{0x30fc & 0xFF, 0x30ff & 0xFF},
	{0x3105 & 0xFF, 0x312f & 0xFF},
	{0x3131 & 0xFF, 0x318e & 0xFF},
	{0x31a0 & 0xFF, 0x31bf & 0xFF},
	{0x31f0 & 0xFF, 0x31ff & 0xFF},
	{0x3400 & 0xFF, 0x34ff & 0xFF},
	{0x3500 & 0xFF, 0x35ff & 0xFF},
	{0x3600 & 0xFF, 0x36ff & 0xFF},
	{0x3700 & 0xFF, 0x37ff & 0xFF},
	{0x3800 & 0xFF, 0x38ff & 0xFF},
	{0x3900 & 0xFF, 0x39ff & 0xFF},
	{0x3a00 & 0xFF, 0x3aff & 0xFF},
	{0x3b00 & 0xFF, 0x3bff & 0xFF},
	{0x3c00 & 0xFF, 0x3cff & 0xFF},
	{0x3d00 & 0xFF, 0x3dff & 0xFF},
	{0x3e00 & 0xFF, 0x3eff & 0xFF},
	{0x3f00 & 0xFF, 0x3fff & 0xFF},
	{0x4000 & 0xFF, 0x40ff & 0xFF},
	{0x4100 & 0xFF, 0x41ff & 0xFF},
	{0x4200 & 0xFF, 0x42ff & 0xFF},
	{0x4300 & 0xFF, 0x43ff & 0xFF},
	{0x4400 & 0xFF, 0x44ff & 0xFF},
	{0x4500 & 0xFF, 0x45ff & 0xFF},
	{0x4600 & 0xFF, 0x46ff & 0xFF},
	{0x4700 & 0xFF, 0x47ff & 0xFF},
	{0x4800 & 0xFF, 0x48ff & 0xFF},
	{0x4900 & 0xFF, 0x49ff & 0xFF},
	{0x4a00 & 0xFF, 0x4aff & 0xFF},
	{0x4b00 & 0xFF, 0x4bff & 0xFF},
	{0x4c00 & 0xFF, 0x4cff & 0xFF},
	{0x4d00 & 0xFF, 0x4dbf & 0xFF},
	{0x4e00 & 0xFF, 0x4eff & 0xFF},
	{0x4f00 & 0xFF, 0x4fff & 0xFF},
	{0x5000 & 0xFF, 0x50ff & 0xFF},
	{0x5100 & 0xFF, 0x51ff & 0xFF},
	{0x5200 & 0xFF, 0x52ff & 0xFF},
	{0x5300 & 0xFF, 0x53ff & 0xFF},
	{0x5400 & 0xFF, 0x54ff & 0xFF},
	{0x5500 & 0xFF, 0x55ff & 0xFF},
	{0x5600 & 0xFF, 0x56ff & 0xFF},
	{0x5700 & 0xFF, 0x57ff & 0xFF},
	{0x5800 & 0xFF, 0x58ff & 0xFF},
	{0x5900 & 0xFF, 0x59ff & 0xFF},
	{0x5a00 & 0xFF, 0x5aff & 0xFF},
	{0x5b00 & 0xFF, 0x5bff & 0xFF},
	{0x5c00 & 0xFF, 0x5cff & 0xFF},
	{0x5d00 & 0xFF, 0x5dff & 0xFF},
	{0x5e00 & 0xFF, 0x5eff & 0xFF},
	{0x5f00 & 0xFF, 0x5fff & 0xFF},
	{0x6000 & 0xFF, 0x60ff & 0xFF},
	{0x6100 & 0xFF, 0x61ff & 0xFF},
	{0x6200 & 0xFF, 0x62ff & 0xFF},
	{0x6300 & 0xFF, 0x63ff & 0xFF},
	{0x6400 & 0xFF, 0x64ff & 0xFF},
	{0x6500 & 0xFF, 0x65ff & 0xFF},
	{0x6600 & 0xFF, 0x66ff & 0xFF},
	{0x6700 & 0xFF, 0x67ff & 0xFF},
	{0x6800 & 0xFF, 0x68ff & 0xFF},
	{0x6900 & 0xFF, 0x69ff & 0xFF},
	{0x6a00 & 0xFF, 0x6aff & 0xFF},
	{0x6b00 & 0xFF, 0x6bff & 0xFF},
	{0x6c00 & 0xFF, 0x6cff & 0xFF},
	{0x6d00 & 0xFF, 0x6dff & 0xFF},
	{0x6e00 & 0xFF, 0x6eff & 0xFF},
	{0x6f00 & 0xFF, 0x6fff & 0xFF},
	{0x7000 & 0xFF, 0x70ff & 0xFF},
	{0x7100 & 0xFF, 0x71ff & 0xFF},
	{0x7200 & 0xFF, 0x72ff & 0xFF},
	{0x7300 & 0xFF, 0x73ff & 0xFF},
	{0x7400 & 0xFF, 0x74ff & 0xFF},
	{0x7500 & 0xFF, 0x75ff & 0xFF},
	{0x7600 & 0xFF, 0x76ff & 0xFF},
	{0x7700 & 0xFF, 0x77ff & 0xFF},
	{0x7800 & 0xFF, 0x78ff & 0xFF},
	{0x7900 & 0xFF, 0x79ff & 0xFF},
	{0x7a00 & 0xFF, 0x7aff & 0xFF},
	{0x7b00 & 0xFF, 0x7bff & 0xFF},
	{0x7c00 & 0xFF, 0x7cff & 0xFF},
	{0x7d00 & 0xFF, 0x7dff & 0xFF},
	{0x7e00 & 0xFF, 0x7eff & 0xFF},
	{0x7f00 & 0xFF, 0x7fff & 0xFF},
	{0x8000 & 0xFF, 0x80ff & 0xFF},
	{0x8100 & 0xFF, 0x81ff & 0xFF},
	{0x8200 & 0xFF, 0x82ff & 0xFF},
	{0x8300 & 0xFF, 0x83ff & 0xFF},
	{0x8400 & 0xFF, 0x84ff & 0xFF},
	{0x8500 & 0xFF, 0x85ff & 0xFF},
	{0x8600 & 0xFF, 0x86ff & 0xFF},
	{0x8700 & 0xFF, 0x87ff & 0xFF},
	{0x8800 & 0xFF, 0x88ff & 0xFF},
	{0x8900 & 0xFF, 0x89ff & 0xFF},
	{0x8a00 & 0xFF, 0x8aff & 0xFF},
	{0x8b00 & 0xFF, 0x8bff & 0xFF},
	{0x8c00 & 0xFF, 0x8cff & 0xFF},
	{0x8d00 & 0xFF, 0x8dff & 0xFF},
	{0x8e00 & 0xFF, 0x8eff & 0xFF},
	{0x8f00 & 0xFF, 0x8fff & 0xFF},
	{0x9000 & 0xFF, 0x90ff & 0xFF},
	{0x9100 & 0xFF, 0x91ff & 0xFF},
	{0x9200 & 0xFF, 0x92ff & 0xFF},
	{0x9300 & 0xFF, 0x93ff & 0xFF},
	{0x9400 & 0xFF, 0x94ff & 0xFF},
	{0x9500 & 0xFF, 0x95ff & 0xFF},
	{0x9600 & 0xFF, 0x96ff & 0xFF},
	{0x9700 & 0xFF, 0x97ff & 0xFF},
	{0x9800 & 0xFF, 0x98ff & 0xFF},
	{0x9900 & 0xFF, 0x99ff & 0xFF},
	{0x9a00 & 0xFF, 0x9aff & 0xFF},
	{0x9b00 & 0xFF, 0x9bff & 0xFF},
	{0x9c00 & 0xFF, 0x9cff & 0xFF},
	{0x9d00 & 0xFF, 0x9dff & 0xFF},
	{0x9e00 & 0xFF, 0x9eff & 0xFF},
	{0x9f00 & 0xFF, 0x9fff & 0xFF},
	{0xa000 & 0xFF, 0xa0ff & 0xFF},
	{0xa100 & 0xFF, 0xa1ff & 0xFF},
	{0xa200 & 0xFF, 0xa2ff & 0xFF},
	{0xa300 & 0xFF, 0xa3ff & 0xFF},
	{0xa400 & 0xFF, 0xa48c & 0xFF},
	{0xa4d0 & 0xFF, 0xa4fd & 0xFF},
	{0xa500 & 0xFF, 0xa5ff & 0xFF},
	{0xa600 & 0xFF, 0xa60c & 0xFF},
	{0xa610 & 0xFF, 0xa61f & 0xFF},
	{0xa62a & 0xFF, 0xa62b & 0xFF},
	{0xa640 & 0xFF, 0xa66e & 0xFF},
	{0xa67f & 0xFF, 0xa69d & 0xFF},
	{0xa6a0 & 0xFF, 0xa6ef & 0xFF},
	{0xa717 & 0xFF, 0xa71f & 0xFF},
	{0xa722 & 0xFF, 0xa788 & 0xFF},
	{0xa78b & 0xFF, 0xa7ca & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d3 & 0xFF, 0xa7d3 & 0xFF},
	{0xa7d5 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f2 & 0xFF, 0xa7ff & 0xFF},
	{0xa800 & 0xFF, 0xa801 & 0xFF},
	{0xa803 & 0xFF, 0xa805 & 0xFF},
	{0xa807 & 0xFF, 0xa80a & 0xFF},
	{0xa80c & 0xFF, 0xa822 & 0xFF},
	{0xa840 & 0xFF, 0xa873 & 0xFF},
	{0xa882 & 0xFF, 0xa8b3 & 0xFF},
	{0xa8f2 & 0xFF, 0xa8f7 & 0xFF},
	{0xa8fb & 0xFF, 0xa8fb & 0xFF},
	{0xa8fd & 0xFF, 0xa8fe & 0xFF},
	{0xa90a & 0xFF, 0xa925 & 0xFF},
	{0xa930 & 0xFF, 0xa946 & 0xFF},
	{0xa960 & 0xFF, 0xa97c & 0xFF},
	{0xa984 & 0xFF, 0xa9b2 & 0xFF},
	{0xa9cf & 0xFF, 0xa9cf & 0xFF},
	{0xa9e0 & 0xFF, 0xa9e4 & 0xFF},
	{0xa9e6 & 0xFF, 0xa9ef & 0xFF},
	{0xa9fa & 0xFF, 0xa9fe & 0xFF},
	{0xaa00 & 0xFF, 0xaa28 & 0xFF},
	{0xaa40 & 0xFF, 0xaa42 & 0xFF},
	{0xaa44 & 0xFF, 0xaa4b & 0xFF},
	{0xaa60 & 0xFF, 0xaa76 & 0xFF},
	{0xaa7a & 0xFF, 0xaa7a & 0xFF},
	{0xaa7e & 0xFF, 0xaaaf & 0xFF},
	{0xaab1 & 0xFF, 0xaab1 & 0xFF},
	{0xaab5 & 0xFF, 0xaab6 & 0xFF},
	{0xaab9 & 0xFF, 0xaabd & 0xFF},
	{0xaac0 & 0xFF, 0xaac0 & 0xFF},
	{0xaac2 & 0xFF, 0xaac2 & 0xFF},
	{0xaadb & 0xFF, 0xaadd & 0xFF},
	{0xaae0 & 0xFF, 0xaaea & 0xFF},
	{0xaaf2 & 0xFF, 0xaaf4 & 0xFF},
	{0xab01 & 0xFF, 0xab06 & 0xFF},
	{0xab09 & 0xFF, 0xab0e & 0xFF},
	{0xab11 & 0xFF, 0xab16 & 0xFF},
	{0xab20 & 0xFF, 0xab26 & 0xFF},
	{0xab28 & 0xFF, 0xab2e & 0xFF},
	{0xab30 & 0xFF, 0xab5a & 0xFF},
	{0xab5c & 0xFF, 0xab69 & 0xFF},
	{0xab70 & 0xFF, 0xabe2 & 0xFF},
	{0xac00 & 0xFF, 0xacff & 0xFF},
	{0xad00 & 0xFF, 0xadff & 0xFF},
	{0xae00 & 0xFF, 0xaeff & 0xFF},
	{0xaf00 & 0xFF, 0xafff & 0xFF},
	{0xb000 & 0xFF, 0xb0ff & 0xFF},
	{0xb100 & 0xFF, 0xb1ff & 0xFF},
	{0xb200 & 0xFF, 0xb2ff & 0xFF},
	{0xb300 & 0xFF, 0xb3ff & 0xFF},
	{0xb400 & 0xFF, 0xb4ff & 0xFF},
	{0xb500 & 0xFF, 0xb5ff & 0xFF},
	{0xb600 & 0xFF, 0xb6ff & 0xFF},
	{0xb700 & 0xFF, 0xb7ff & 0xFF},
	{0xb800 & 0xFF, 0xb8ff & 0xFF},
	{0xb900 & 0xFF, 0xb9ff & 0xFF},
	{0xba00 & 0xFF, 0xbaff & 0xFF},
	{0xbb00 & 0xFF, 0xbbff & 0xFF},
	{0xbc00 & 0xFF, 0xbcff & 0xFF},
	{0xbd00 & 0xFF, 0xbdff & 0xFF},
	{0xbe00 & 0xFF, 0xbeff & 0xFF},
	{0xbf00 & 0xFF, 0xbfff & 0xFF},
	{0xc000 & 0xFF, 0xc0ff & 0xFF},
	{0xc100 & 0xFF, 0xc1ff & 0xFF},
	{0xc200 & 0xFF, 0xc2ff & 0xFF},
	{0xc300 & 0xFF, 0xc3ff & 0xFF},
	{0xc400 & 0xFF, 0xc4ff & 0xFF},
	{0xc500 & 0xFF, 0xc5ff & 0xFF},
	{0xc600 & 0xFF, 0xc6ff & 0xFF},
	{0xc700 & 0xFF, 0xc7ff & 0xFF},
	{0xc800 & 0xFF, 0xc8ff & 0xFF},
	{0xc900 & 0xFF, 0xc9ff & 0xFF},
	{0xca00 & 0xFF, 0xcaff & 0xFF},
	{0xcb00 & 0xFF, 0xcbff & 0xFF},
	{0xcc00 & 0xFF, 0xccff & 0xFF},
	{0xcd00 & 0xFF, 0xcdff & 0xFF},
	{0xce00 & 0xFF, 0xceff & 0xFF},
	{0xcf00 & 0xFF, 0xcfff & 0xFF},
	{0xd000 & 0xFF, 0xd0ff & 0xFF},
	{0xd100 & 0xFF, 0xd1ff & 0xFF},
	{0xd200 & 0xFF, 0xd2ff & 0xFF},
	{0xd300 & 0xFF, 0xd3ff & 0xFF},
	{0xd400 & 0xFF, 0xd4ff & 0xFF},
	{0xd500 & 0xFF, 0xd5ff & 0xFF},
	{0xd600 & 0xFF, 0xd6ff & 0xFF},
	{0xd700 & 0xFF, 0xd7a3 & 0xFF},
	{0xd7b0 & 0xFF, 0xd7c6 & 0xFF},
	{0xd7cb & 0xFF, 0xd7fb & 0xFF},
	{0xf900 & 0xFF, 0xf9ff & 0xFF},
	{0xfa00 & 0xFF, 0xfa6d & 0xFF},
	{0xfa70 & 0xFF, 0xfad9 & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xfb1d & 0xFF, 0xfb1d & 0xFF},
	{0xfb1f & 0xFF, 0xfb28 & 0xFF},
	{0xfb2a & 0xFF, 0xfb36 & 0xFF},
	{0xfb38 & 0xFF, 0xfb3c & 0xFF},
	{0xfb3e & 0xFF, 0xfb3e & 0xFF},
	{0xfb40 & 0xFF, 0xfb41 & 0xFF},
	{0xfb43 & 0xFF, 0xfb44 & 0xFF},
	{0xfb46 & 0xFF, 0xfbb1 & 0xFF},
	{0xfbd3 & 0xFF, 0xfbff & 0xFF},
	{0xfc00 & 0xFF, 0xfcff & 0xFF},
	{0xfd00 & 0xFF, 0xfd3d & 0xFF},
	{0xfd50 & 0xFF, 0xfd8f & 0xFF},
	{0xfd92 & 0xFF, 0xfdc7 & 0xFF},
	{0xfdf0 & 0xFF, 0xfdfb & 0xFF},
	{0xfe70 & 0xFF, 0xfe74 & 0xFF},
	{0xfe76 & 0xFF, 0xfefc & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0xff66 & 0xFF, 0xffbe & 0xFF},
	{0xffc2 & 0xFF, 0xffc7 & 0xFF},
	{0xffca & 0xFF, 0xffcf & 0xFF},
	{0xffd2 & 0xFF, 0xffd7 & 0xFF},
	{0xffda & 0xFF, 0xffdc & 0xFF},
	{0x10000 & 0xFF, 0x1000b & 0xFF},
	{0x1000d & 0xFF, 0x10026 & 0xFF},
	{0x10028 & 0xFF, 0x1003a & 0xFF},
	{0x1003c & 0xFF, 0x1003d & 0xFF},
	{0x1003f & 0xFF, 0x1004d & 0xFF},
	{0x10050 & 0xFF, 0x1005d & 0xFF},
	{0x10080 & 0xFF, 0x100fa & 0xFF},
	{0x10140 & 0xFF, 0x10174 & 0xFF},
	{0x10280 & 0xFF, 0x1029c & 0xFF},
	{0x102a0 & 0xFF, 0x102d0 & 0xFF},
	{0x10300 & 0xFF, 0x1031f & 0xFF},
	{0x1032d & 0xFF, 0x1034a & 0xFF},
	{0x10350 & 0xFF, 0x10375 & 0xFF},
	{0x10380 & 0xFF, 0x1039d & 0xFF},
	{0x103a0 & 0xFF, 0x103c3 & 0xFF},
	{0x103c8 & 0xFF, 0x103cf & 0xFF},
	{0x103d1 & 0xFF, 0x103d5 & 0xFF},
	{0x10400 & 0xFF, 0x1049d & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10500 & 0xFF, 0x10527 & 0xFF},
	{0x10530 & 0xFF, 0x10563 & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10600 & 0xFF, 0x106ff & 0xFF},
	{0x10700 & 0xFF, 0x10736 & 0xFF},
	{0x10740 & 0xFF, 0x10755 & 0xFF},
	{0x10760 & 0xFF, 0x10767 & 0xFF},
	{0x10780 & 0xFF, 0x10785 & 0xFF},
	{0x10787 & 0xFF, 0x107b0 & 0xFF},
	{0x107b2 & 0xFF, 0x107ba & 0xFF},
	{0x10800 & 0xFF, 0x10805 & 0xFF},
	{0x10808 & 0xFF, 0x10808 & 0xFF},
	{0x1080a & 0xFF, 0x10835 & 0xFF},
	{0x10837 & 0xFF, 0x10838 & 0xFF},
	{0x1083c & 0xFF, 0x1083c & 0xFF},
	{0x1083f & 0xFF, 0x10855 & 0xFF},
	{0x10860 & 0xFF, 0x10876 & 0xFF},
	{0x10880 & 0xFF, 0x1089e & 0xFF},
	{0x108e0 & 0xFF, 0x108f2 & 0xFF},
	{0x108f4 & 0xFF, 0x108f5 & 0xFF},
	{0x10900 & 0xFF, 0x10915 & 0xFF},
	{0x10920 & 0xFF, 0x10939 & 0xFF},
	{0x10980 & 0xFF, 0x109b7 & 0xFF},
	{0x109be & 0xFF, 0x109bf & 0xFF},
	{0x10a00 & 0xFF, 0x10a00 & 0xFF},
	{0x10a10 & 0xFF, 0x10a13 & 0xFF},
	{0x10a15 & 0xFF, 0x10a17 & 0xFF},
	{0x10a19 & 0xFF, 0x10a35 & 0xFF},
	{0x10a60 & 0xFF, 0x10a7c & 0xFF},
	{0x10a80 & 0xFF, 0x10a9c & 0xFF},
	{0x10ac0 & 0xFF, 0x10ac7 & 0xFF},
	{0x10ac9 & 0xFF, 0x10ae4 & 0xFF},
	{0x10b00 & 0xFF, 0x10b35 & 0xFF},
	{0x10b40 & 0xFF, 0x10b55 & 0xFF},
	{0x10b60 & 0xFF, 0x10b72 & 0xFF},
	{0x10b80 & 0xFF, 0x10b91 & 0xFF},
	{0x10c00 & 0xFF, 0x10c48 & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x10d00 & 0xFF, 0x10d23 & 0xFF},
	{0x10e80 & 0xFF, 0x10ea9 & 0xFF},
	{0x10eb0 & 0xFF, 0x10eb1 & 0xFF},
	{0x10f00 & 0xFF, 0x10f1c & 0xFF},
	{0x10f27 & 0xFF, 0x10f27 & 0xFF},
	{0x10f30 & 0xFF, 0x10f45 & 0xFF},
	{0x10f70 & 0xFF, 0x10f81 & 0xFF},
	{0x10fb0 & 0xFF, 0x10fc4 & 0xFF},
	{0x10fe0 & 0xFF, 0x10ff6 & 0xFF},
	{0x11003 & 0xFF, 0x11037 & 0xFF},
	{0x11071 & 0xFF, 0x11072 & 0xFF},
	{0x11075 & 0xFF, 0x11075 & 0xFF},
	{0x11083 & 0xFF, 0x110af & 0xFF},
	{0x110d0 & 0xFF, 0x110e8 & 0xFF},
	{0x11103 & 0xFF, 0x11126 & 0xFF},
	{0x11144 & 0xFF, 0x11144 & 0xFF},
	{0x11147 & 0xFF, 0x11147 & 0xFF},
	{0x11150 & 0xFF, 0x11172 & 0xFF},
	{0x11176 & 0xFF, 0x11176 & 0xFF},
	{0x11183 & 0xFF, 0x111b2 & 0xFF},
	{0x111c1 & 0xFF, 0x111c4 & 0xFF},
	{0x111da & 0xFF, 0x111da & 0xFF},
	{0x111dc & 0xFF, 0x111dc & 0xFF},
	{0x11200 & 0xFF, 0x11211 & 0xFF},
	{0x11213 & 0xFF, 0x1122b & 0xFF},
	{0x1123f & 0xFF, 0x11240 & 0xFF},
	{0x11280 & 0xFF, 0x11286 & 0xFF},
	{0x11288 & 0xFF, 0x11288 & 0xFF},
	{0x1128a & 0xFF, 0x1128d & 0xFF},
	{0x1128f & 0xFF, 0x1129d & 0xFF},
	{0x1129f & 0xFF, 0x112a8 & 0xFF},
	{0x112b0 & 0xFF, 0x112de & 0xFF},
	{0x11305 & 0xFF, 0x1130c & 0xFF},
	{0x1130f & 0xFF, 0x11310 & 0xFF},
	{0x11313 & 0xFF, 0x11328 & 0xFF},
	{0x1132a & 0xFF, 0x11330 & 0xFF},
	{0x11332 & 0xFF, 0x11333 & 0xFF},
	{0x11335 & 0xFF, 0x11339 & 0xFF},
	{0x1133d & 0xFF, 0x1133d & 0xFF},
	{0x11350 & 0xFF, 0x11350 & 0xFF},
	{0x1135d & 0xFF, 0x11361 & 0xFF},
	{0x11400 & 0xFF, 0x11434 & 0xFF},
	{0x11447 & 0xFF, 0x1144a & 0xFF},
	{0x1145f & 0xFF, 0x11461 & 0xFF},
	{0x11480 & 0xFF, 0x114af & 0xFF},
	{0x114c4 & 0xFF, 0x114c5 & 0xFF},
	{0x114c7 & 0xFF, 0x114c7 & 0xFF},
	{0x11580 & 0xFF, 0x115ae & 0xFF},
	{0x115d8 & 0xFF, 0x115db & 0xFF},
	{0x11600 & 0xFF, 0x1162f & 0xFF},
	{0x11644 & 0xFF, 0x11644 & 0xFF},
	{0x11680 & 0xFF, 0x116aa & 0xFF},
	{0x116b8 & 0xFF, 0x116b8 & 0xFF},
	{0x11700 & 0xFF, 0x1171a & 0xFF},
	{0x11740 & 0xFF, 0x11746 & 0xFF},
	{0x11800 & 0xFF, 0x1182b & 0xFF},
	{0x118a0 & 0xFF, 0x118df & 0xFF},
	{0x118ff & 0xFF, 0x118ff & 0xFF},
	{0x11900 & 0xFF, 0x11906 & 0xFF},
	{0x11909 & 0xFF, 0x11909 & 0xFF},
	{0x1190c & 0xFF, 0x11913 & 0xFF},
	{0x11915 & 0xFF, 0x11916 & 0xFF},
	{0x11918 & 0xFF, 0x1192f & 0xFF},
	{0x1193f & 0xFF, 0x1193f & 0xFF},
	{0x11941 & 0xFF, 0x11941 & 0xFF},
	{0x119a0 & 0xFF, 0x119a7 & 0xFF},
	{0x119aa & 0xFF, 0x119d0 & 0xFF},
	{0x119e1 & 0xFF, 0x119e1 & 0xFF},
	{0x119e3 & 0xFF, 0x119e3 & 0xFF},
	{0x11a00 & 0xFF, 0x11a00 & 0xFF},
	{0x11a0b & 0xFF, 0x11a32 & 0xFF},
	{0x11a3a & 0xFF, 0x11a3a & 0xFF},
	{0x11a50 & 0xFF, 0x11a50 & 0xFF},
	{0x11a5c & 0xFF, 0x11a89 & 0xFF},
	{0x11a9d & 0xFF, 0x11a9d & 0xFF},
	{0x11ab0 & 0xFF, 0x11af8 & 0xFF},
	{0x11c00 & 0xFF, 0x11c08 & 0xFF},
	{0x11c0a & 0xFF, 0x11c2e & 0xFF},
	{0x11c40 & 0xFF, 0x11c40 & 0xFF},
	{0x11c72 & 0xFF, 0x11c8f & 0xFF},
	{0x11d00 & 0xFF, 0x11d06 & 0xFF},
	{0x11d08 & 0xFF, 0x11d09 & 0xFF},
	{0x11d0b & 0xFF, 0x11d30 & 0xFF},
	{0x11d46 & 0xFF, 0x11d46 & 0xFF},
	{0x11d60 & 0xFF, 0x11d65 & 0xFF},
	{0x11d67 & 0xFF, 0x11d68 & 0xFF},
	{0x11d6a & 0xFF, 0x11d89 & 0xFF},
	{0x11d98 & 0xFF, 0x11d98 & 0xFF},
	{0x11ee0 & 0xFF, 0x11ef2 & 0xFF},
	{0x11f02 & 0xFF, 0x11f02 & 0xFF},
	{0x11f04 & 0xFF, 0x11f10 & 0xFF},
	{0x11f12 & 0xFF, 0x11f33 & 0xFF},
	{0x11fb0 & 0xFF, 0x11fb0 & 0xFF},
	{0x12000 & 0xFF, 0x120ff & 0xFF},
	{0x12100 & 0xFF, 0x121ff & 0xFF},
	{0x12200 & 0xFF, 0x122ff & 0xFF},
	{0x12300 & 0xFF, 0x12399 & 0xFF},
	{0x12400 & 0xFF, 0x1246e & 0xFF},
	{0x12480 & 0xFF, 0x124ff & 0xFF},
	{0x12500 & 0xFF, 0x12543 & 0xFF},
	{0x12f90 & 0xFF, 0x12ff0 & 0xFF},
	{0x13000 & 0xFF, 0x130ff & 0xFF},
	{0x13100 & 0xFF, 0x131ff & 0xFF},
	{0x13200 & 0xFF, 0x132ff & 0xFF},
	{0x13300 & 0xFF, 0x133ff & 0xFF},
	{0x13400 & 0xFF, 0x1342f & 0xFF},
	{0x13441 & 0xFF, 0x13446 & 0xFF},
	{0x14400 & 0xFF, 0x144ff & 0xFF},
	{0x14500 & 0xFF, 0x145ff & 0xFF},
	{0x14600 & 0xFF, 0x14646 & 0xFF},
	{0x16800 & 0xFF, 0x168ff & 0xFF},
	{0x16900 & 0xFF, 0x169ff & 0xFF},
	{0x16a00 & 0xFF, 0x16a38 & 0xFF},
	{0x16a40 & 0xFF, 0x16a5e & 0xFF},
	{0x16a70 & 0xFF, 0x16abe & 0xFF},
	{0x16ad0 & 0xFF, 0x16aed & 0xFF},
	{0x16b00 & 0xFF, 0x16b2f & 0xFF},
	{0x16b40 & 0xFF, 0x16b43 & 0xFF},
	{0x16b63 & 0xFF, 0x16b77 & 0xFF},
	{0x16b7d & 0xFF, 0x16b8f & 0xFF},
	{0x16e40 & 0xFF, 0x16e7f & 0xFF},
	{0x16f00 & 0xFF, 0x16f4a & 0xFF},
	{0x16f50 & 0xFF, 0x16f50 & 0xFF},
	{0x16f93 & 0xFF, 0x16f9f & 0xFF},
	{0x16fe0 & 0xFF, 0x16fe1 & 0xFF},
	{0x16fe3 & 0xFF, 0x16fe3 & 0xFF},
	{0x17000 & 0xFF, 0x170ff & 0xFF},
	{0x17100 & 0xFF, 0x171ff & 0xFF},
	{0x17200 & 0xFF, 0x172ff & 0xFF},
	{0x17300 & 0xFF, 0x173ff & 0xFF},
	{0x17400 & 0xFF, 0x174ff & 0xFF},
	{0x17500 & 0xFF, 0x175ff & 0xFF},
	{0x17600 & 0xFF, 0x176ff & 0xFF},
	{0x17700 & 0xFF, 0x177ff & 0xFF},
	{0x17800 & 0xFF, 0x178ff & 0xFF},
	{0x17900 & 0xFF, 0x179ff & 0xFF},
	{0x17a00 & 0xFF, 0x17aff & 0xFF},
	{0x17b00 & 0xFF, 0x17bff & 0xFF},
	{0x17c00 & 0xFF, 0x17cff & 0xFF},
	{0x17d00 & 0xFF, 0x17dff & 0xFF},
	{0x17e00 & 0xFF, 0x17eff & 0xFF},
	{0x17f00 & 0xFF, 0x17fff & 0xFF},
	{0x18000 & 0xFF, 0x180ff & 0xFF},
	{0x18100 & 0xFF, 0x181ff & 0xFF},
	{0x18200 & 0xFF, 0x182ff & 0xFF},
	{0x18300 & 0xFF, 0x183ff & 0xFF},
	{0x18400 & 0xFF, 0x184ff & 0xFF},
	{0x18500 & 0xFF, 0x185ff & 0xFF},
	{0x18600 & 0xFF, 0x186ff & 0xFF},
	{0x18700 & 0xFF, 0x187f7 & 0xFF},
	{0x18800 & 0xFF, 0x188ff & 0xFF},
	{0x18900 & 0xFF, 0x189ff & 0xFF},
	{0x18a00 & 0xFF, 0x18aff & 0xFF},
	{0x18b00 & 0xFF, 0x18bff & 0xFF},
	{0x18c00 & 0xFF, 0x18cd5 & 0xFF},
	{0x18d00 & 0xFF, 0x18d08 & 0xFF},
	{0x1aff0 & 0xFF, 0x1aff3 & 0xFF},
	{0x1aff5 & 0xFF, 0x1affb & 0xFF},
	{0x1affd & 0xFF, 0x1affe & 0xFF},
	{0x1b000 & 0xFF, 0x1b0ff & 0xFF},
	{0x1b100 & 0xFF, 0x1b122 & 0xFF},
	{0x1b132 & 0xFF, 0x1b132 & 0xFF},
	{0x1b150 & 0xFF, 0x1b152 & 0xFF},
	{0x1b155 & 0xFF, 0x1b155 & 0xFF},
	{0x1b164 & 0xFF, 0x1b167 & 0xFF},
	{0x1b170 & 0xFF, 0x1b1ff & 0xFF},
	{0x1b200 & 0xFF, 0x1b2fb & 0xFF},
	{0x1bc00 & 0xFF, 0x1bc6a & 0xFF},
	{0x1bc70 & 0xFF, 0x1bc7c & 0xFF},
	{0x1bc80 & 0xFF, 0x1bc88 & 0xFF},
	{0x1bc90 & 0xFF, 0x1bc99 & 0xFF},
	{0x1d400 & 0xFF, 0x1d454 & 0xFF},
	{0x1d456 & 0xFF, 0x1d49c & 0xFF},
	{0x1d49e & 0xFF, 0x1d49f & 0xFF},
	{0x1d4a2 & 0xFF, 0x1d4a2 & 0xFF},
	{0x1d4a5 & 0xFF, 0x1d4a6 & 0xFF},
	{0x1d4a9 & 0xFF, 0x1d4ac & 0xFF},
	{0x1d4ae & 0xFF, 0x1d4b9 & 0xFF},
	{0x1d4bb & 0xFF, 0x1d4bb & 0xFF},
	{0x1d4bd & 0xFF, 0x1d4c3 & 0xFF},
	{0x1d4c5 & 0xFF, 0x1d4ff & 0xFF},
	{0x1d500 & 0xFF, 0x1d505 & 0xFF},
	{0x1d507 & 0xFF, 0x1d50a & 0xFF},
	{0x1d50d & 0xFF, 0x1d514 & 0xFF},
	{0x1d516 & 0xFF, 0x1d51c & 0xFF},
	{0x1d51e & 0xFF, 0x1d539 & 0xFF},
	{0x1d53b & 0xFF, 0x1d53e & 0xFF},
	{0x1d540 & 0xFF, 0x1d544 & 0xFF},
	{0x1d546 & 0xFF, 0x1d546 & 0xFF},
	{0x1d54a & 0xFF, 0x1d550 & 0xFF},
	{0x1d552 & 0xFF, 0x1d5ff & 0xFF},
	{0x1d600 & 0xFF, 0x1d6a5 & 0xFF},
	{0x1d6a8 & 0xFF, 0x1d6c0 & 0xFF},
	{0x1d6c2 & 0xFF, 0x1d6da & 0xFF},
	{0x1d6dc & 0xFF, 0x1d6fa & 0xFF},
	{0x1d6fc & 0xFF, 0x1d6ff & 0xFF},
	{0x1d700 & 0xFF, 0x1d714 & 0xFF},
	{0x1d716 & 0xFF, 0x1d734 & 0xFF},
	{0x1d736 & 0xFF, 0x1d74e & 0xFF},
	{0x1d750 & 0xFF, 0x1d76e & 0xFF},
	{0x1d770 & 0xFF, 0x1d788 & 0xFF},
	{0x1d78a & 0xFF, 0x1d7a8 & 0xFF},
	{0x1d7aa & 0xFF, 0x1d7c2 & 0xFF},
	{0x1d7c4 & 0xFF, 0x1d7cb & 0xFF},
	{0x1df00 & 0xFF, 0x1df1e & 0xFF},
	{0x1df25 & 0xFF, 0x1df2a & 0xFF},
	{0x1e030 & 0xFF, 0x1e06d & 0xFF},
	{0x1e100 & 0xFF, 0x1e12c & 0xFF},
	{0x1e137 & 0xFF, 0x1e13d & 0xFF},
	{0x1e14e & 0xFF, 0x1e14e & 0xFF},
	{0x1e290 & 0xFF, 0x1e2ad & 0xFF},
	{0x1e2c0 & 0xFF, 0x1e2eb & 0xFF},
	{0x1e4d0 & 0xFF, 0x1e4eb & 0xFF},
	{0x1e7e0 & 0xFF, 0x1e7e6 & 0xFF},
	{0x1e7e8 & 0xFF, 0x1e7eb & 0xFF},
	{0x1e7ed & 0xFF, 0x1e7ee & 0xFF},
	{0x1e7f0 & 0xFF, 0x1e7fe & 0xFF},
	{0x1e800 & 0xFF, 0x1e8c4 & 0xFF},
	{0x1e900 & 0xFF, 0x1e943 & 0xFF},
	{0x1e94b & 0xFF, 0x1e94b & 0xFF},
	{0x1ee00 & 0xFF, 0x1ee03 & 0xFF},
	{0x1ee05 & 0xFF, 0x1ee1f & 0xFF},
	{0x1ee21 & 0xFF, 0x1ee22 & 0xFF},
	{0x1ee24 & 0xFF, 0x1ee24 & 0xFF},
	{0x1ee27 & 0xFF, 0x1ee27 & 0xFF},
	{0x1ee29 & 0xFF, 0x1ee32 & 0xFF},
	{0x1ee34 & 0xFF, 0x1ee37 & 0xFF},
	{0x1ee39 & 0xFF, 0x1ee39 & 0xFF},
	{0x1ee3b & 0xFF, 0x1ee3b & 0xFF},
	{0x1ee42 & 0xFF, 0x1ee42 & 0xFF},
	{0x1ee47 & 0xFF, 0x1ee47 & 0xFF},
	{0x1ee49 & 0xFF, 0x1ee49 & 0xFF},
	{0x1ee4b & 0xFF, 0x1ee4b & 0xFF},
	{0x1ee4d & 0xFF, 0x1ee4f & 0xFF},
	{0x1ee51 & 0xFF, 0x1ee52 & 0xFF},
	{0x1ee54 & 0xFF, 0x1ee54 & 0xFF},
	{0x1ee57 & 0xFF, 0x1ee57 & 0xFF},
	{0x1ee59 & 0xFF, 0x1ee59 & 0xFF},
	{0x1ee5b & 0xFF, 0x1ee5b & 0xFF},
	{0x1ee5d & 0xFF, 0x1ee5d & 0xFF},
	{0x1ee5f & 0xFF, 0x1ee5f & 0xFF},
	{0x1ee61 & 0xFF, 0x1ee62 & 0xFF},
	{0x1ee64 & 0xFF, 0x1ee64 & 0xFF},
	{0x1ee67 & 0xFF, 0x1ee6a & 0xFF},
	{0x1ee6c & 0xFF, 0x1ee72 & 0xFF},
	{0x1ee74 & 0xFF, 0x1ee77 & 0xFF},
	{0x1ee79 & 0xFF, 0x1ee7c & 0xFF},
	{0x1ee7e & 0xFF, 0x1ee7e & 0xFF},
	{0x1ee80 & 0xFF, 0x1ee89 & 0xFF},
	{0x1ee8b & 0xFF, 0x1ee9b & 0xFF},
	{0x1eea1 & 0xFF, 0x1eea3 & 0xFF},
	{0x1eea5 & 0xFF, 0x1eea9 & 0xFF},
	{0x1eeab & 0xFF, 0x1eebb & 0xFF},
	{0x20000 & 0xFF, 0x200ff & 0xFF},
	{0x20100 & 0xFF, 0x201ff & 0xFF},
	{0x20200 & 0xFF, 0x202ff & 0xFF},
	{0x20300 & 0xFF, 0x203ff & 0xFF},
	{0x20400 & 0xFF, 0x204ff & 0xFF},
	{0x20500 & 0xFF, 0x205ff & 0xFF},
	{0x20600 & 0xFF, 0x206ff & 0xFF},
	{0x20700 & 0xFF, 0x207ff & 0xFF},
	{0x20800 & 0xFF, 0x208ff & 0xFF},
	{0x20900 & 0xFF, 0x209ff & 0xFF},
	{0x20a00 & 0xFF, 0x20aff & 0xFF},
	{0x20b00 & 0xFF, 0x20bff & 0xFF},
	{0x20c00 & 0xFF, 0x20cff & 0xFF},
	{0x20d00 & 0xFF, 0x20dff & 0xFF},
	{0x20e00 & 0xFF, 0x20eff & 0xFF},
	{0x20f00 & 0xFF, 0x20fff & 0xFF},
	{0x21000 & 0xFF, 0x210ff & 0xFF},
	{0x21100 & 0xFF, 0x211ff & 0xFF},
	{0x21200 & 0xFF, 0x212ff & 0xFF},
	{0x21300 & 0xFF, 0x213ff & 0xFF},
	{0x21400 & 0xFF, 0x214ff & 0xFF},
	{0x21500 & 0xFF, 0x215ff & 0xFF},
	{0x21600 & 0xFF, 0x216ff & 0xFF},
	{0x21700 & 0xFF, 0x217ff & 0xFF},
	{0x21800 & 0xFF, 0x218ff & 0xFF},
	{0x21900 & 0xFF, 0x219ff & 0xFF},
	{0x21a00 & 0xFF, 0x21aff & 0xFF},
	{0x21b00 & 0xFF, 0x21bff & 0xFF},
	{0x21c00 & 0xFF, 0x21cff & 0xFF},
	{0x21d00 & 0xFF, 0x21dff & 0xFF},
	{0x21e00 & 0xFF, 0x21eff & 0xFF},
	{0x21f00 & 0xFF, 0x21fff & 0xFF},
	{0x22000 & 0xFF, 0x220ff & 0xFF},
	{0x22100 & 0xFF, 0x221ff & 0xFF},
	{0x22200 & 0xFF, 0x222ff & 0xFF},
	{0x22300 & 0xFF, 0x223ff & 0xFF},
	{0x22400 & 0xFF, 0x224ff & 0xFF},
	{0x22500 & 0xFF, 0x225ff & 0xFF},
	{0x22600 & 0xFF, 0x226ff & 0xFF},
	{0x22700 & 0xFF, 0x227ff & 0xFF},
	{0x22800 & 0xFF, 0x228ff & 0xFF},
	{0x22900 & 0xFF, 0x229ff & 0xFF},
	{0x22a00 & 0xFF, 0x22aff & 0xFF},
	{0x22b00 & 0xFF, 0x22bff & 0xFF},
	{0x22c00 & 0xFF, 0x22cff & 0xFF},
	{0x22d00 & 0xFF, 0x22dff & 0xFF},
	{0x22e00 & 0xFF, 0x22eff & 0xFF},
	{0x22f00 & 0xFF, 0x22fff & 0xFF},
	{0x23000 & 0xFF, 0x230ff & 0xFF},
	{0x23100 & 0xFF, 0x231ff & 0xFF},
	{0x23200 & 0xFF, 0x232ff & 0xFF},
	{0x23300 & 0xFF, 0x233ff & 0xFF},
	{0x23400 & 0xFF, 0x234ff & 0xFF},
	{0x23500 & 0xFF, 0x235ff & 0xFF},
	{0x23600 & 0xFF, 0x236ff & 0xFF},
	{0x23700 & 0xFF, 0x237ff & 0xFF},
	{0x23800 & 0xFF, 0x238ff & 0xFF},
	{0x23900 & 0xFF, 0x239ff & 0xFF},
	{0x23a00 & 0xFF, 0x23aff & 0xFF},
	{0x23b00 & 0xFF, 0x23bff & 0xFF},
	{0x23c00 & 0xFF, 0x23cff & 0xFF},
	{0x23d00 & 0xFF, 0x23dff & 0xFF},
	{0x23e00 & 0xFF, 0x23eff & 0xFF},
	{0x23f00 & 0xFF, 0x23fff & 0xFF},
	{0x24000 & 0xFF, 0x240ff & 0xFF},
	{0x24100 & 0xFF, 0x241ff & 0xFF},
	{0x24200 & 0xFF, 0x242ff & 0xFF},
	{0x24300 & 0xFF, 0x243ff & 0xFF},
	{0x24400 & 0xFF, 0x244ff & 0xFF},
	{0x24500 & 0xFF, 0x245ff & 0xFF},
	{0x24600 & 0xFF, 0x246ff & 0xFF},
	{0x24700 & 0xFF, 0x247ff & 0xFF},
	{0x24800 & 0xFF, 0x248ff & 0xFF},
	{0x24900 & 0xFF, 0x249ff & 0xFF},
	{0x24a00 & 0xFF, 0x24aff & 0xFF},
	{0x24b00 & 0xFF, 0x24bff & 0xFF},
	{0x24c00 & 0xFF, 0x24cff & 0xFF},
	{0x24d00 & 0xFF, 0x24dff & 0xFF},
	{0x24e00 & 0xFF, 0x24eff & 0xFF},
	{0x24f00 & 0xFF, 0x24fff & 0xFF},
	{0x25000 & 0xFF, 0x250ff & 0xFF},
	{0x25100 & 0xFF, 0x251ff & 0xFF},
	{0x25200 & 0xFF, 0x252ff & 0xFF},
	{0x25300 & 0xFF, 0x253ff & 0xFF},
	{0x25400 & 0xFF, 0x254ff & 0xFF},
	{0x25500 & 0xFF, 0x255ff & 0xFF},
	{0x25600 & 0xFF, 0x256ff & 0xFF},
	{0x25700 & 0xFF, 0x257ff & 0xFF},
	{0x25800 & 0xFF, 0x258ff & 0xFF},
	{0x25900 & 0xFF, 0x259ff & 0xFF},
	{0x25a00 & 0xFF, 0x25aff & 0xFF},
	{0x25b00 & 0xFF, 0x25bff & 0xFF},
	{0x25c00 & 0xFF, 0x25cff & 0xFF},
	{0x25d00 & 0xFF, 0x25dff & 0xFF},
	{0x25e00 & 0xFF, 0x25eff & 0xFF},
	{0x25f00 & 0xFF, 0x25fff & 0xFF},
	{0x26000 & 0xFF, 0x260ff & 0xFF},
	{0x26100 & 0xFF, 0x261ff & 0xFF},
	{0x26200 & 0xFF, 0x262ff & 0xFF},
	{0x26300 & 0xFF, 0x263ff & 0xFF},
	{0x26400 & 0xFF, 0x264ff & 0xFF},
	{0x26500 & 0xFF, 0x265ff & 0xFF},
	{0x26600 & 0xFF, 0x266ff & 0xFF},
	{0x26700 & 0xFF, 0x267ff & 0xFF},
	{0x26800 & 0xFF, 0x268ff & 0xFF},
	{0x26900 & 0xFF, 0x269ff & 0xFF},
	{0x26a00 & 0xFF, 0x26aff & 0xFF},
	{0x26b00 & 0xFF, 0x26bff & 0xFF},
	{0x26c00 & 0xFF, 0x26cff & 0xFF},
	{0x26d00 & 0xFF, 0x26dff & 0xFF},
	{0x26e00 & 0xFF, 0x26eff & 0xFF},
	{0x26f00 & 0xFF, 0x26fff & 0xFF},
	{0x27000 & 0xFF, 0x270ff & 0xFF},
	{0x27100 & 0xFF, 0x271ff & 0xFF},
	{0x27200 & 0xFF, 0x272ff & 0xFF},
	{0x27300 & 0xFF, 0x273ff & 0xFF},
	{0x27400 & 0xFF, 0x274ff & 0xFF},
	{0x27500 & 0xFF, 0x275ff & 0xFF},
	{0x27600 & 0xFF, 0x276ff & 0xFF},
	{0x27700 & 0xFF, 0x277ff & 0xFF},
	{0x27800 & 0xFF, 0x278ff & 0xFF},
	{0x27900 & 0xFF, 0x279ff & 0xFF},
	{0x27a00 & 0xFF, 0x27aff & 0xFF},
	{0x27b00 & 0xFF, 0x27bff & 0xFF},
	{0x27c00 & 0xFF, 0x27cff & 0xFF},
	{0x27d00 & 0xFF, 0x27dff & 0xFF},
	{0x27e00 & 0xFF, 0x27eff & 0xFF},
	{0x27f00 & 0xFF, 0x27fff & 0xFF},
	{0x28000 & 0xFF, 0x280ff & 0xFF},
	{0x28100 & 0xFF, 0x281ff & 0xFF},
	{0x28200 & 0xFF, 0x282ff & 0xFF},
	{0x28300 & 0xFF, 0x283ff & 0xFF},
	{0x28400 & 0xFF, 0x284ff & 0xFF},
	{0x28500 & 0xFF, 0x285ff & 0xFF},
	{0x28600 & 0xFF, 0x286ff & 0xFF},
	{0x28700 & 0xFF, 0x287ff & 0xFF},
	{0x28800 & 0xFF, 0x288ff & 0xFF},
	{0x28900 & 0xFF, 0x289ff & 0xFF},
	{0x28a00 & 0xFF, 0x28aff & 0xFF},
	{0x28b00 & 0xFF, 0x28bff & 0xFF},
	{0x28c00 & 0xFF, 0x28cff & 0xFF},
	{0x28d00 & 0xFF, 0x28dff & 0xFF},
	{0x28e00 & 0xFF, 0x28eff & 0xFF},
	{0x28f00 & 0xFF, 0x28fff & 0xFF},
	{0x29000 & 0xFF, 0x290ff & 0xFF},
	{0x29100 & 0xFF, 0x291ff & 0xFF},
	{0x29200 & 0xFF, 0x292ff & 0xFF},
	{0x29300 & 0xFF, 0x293ff & 0xFF},
	{0x29400 & 0xFF, 0x294ff & 0xFF},
	{0x29500 & 0xFF, 0x295ff & 0xFF},
	{0x29600 & 0xFF, 0x296ff & 0xFF},
	{0x29700 & 0xFF, 0x297ff & 0xFF},
	{0x29800 & 0xFF, 0x298ff & 0xFF},
	{0x29900 & 0xFF, 0x299ff & 0xFF},
	{0x29a00 & 0xFF, 0x29aff & 0xFF},
	{0x29b00 & 0xFF, 0x29bff & 0xFF},
	{0x29c00 & 0xFF, 0x29cff & 0xFF},
	{0x29d00 & 0xFF, 0x29dff & 0xFF},
	{0x29e00 & 0xFF, 0x29eff & 0xFF},
	{0x29f00 & 0xFF, 0x29fff & 0xFF},
	{0x2a000 & 0xFF, 0x2a0ff & 0xFF},
	{0x2a100 & 0xFF, 0x2a1ff & 0xFF},
	{0x2a200 & 0xFF, 0x2a2ff & 0xFF},
	{0x2a300 & 0xFF, 0x2a3ff & 0xFF},
	{0x2a400 & 0xFF, 0x2a4ff & 0xFF},
	{0x2a500 & 0xFF, 0x2a5ff & 0xFF},
	{0x2a600 & 0xFF, 0x2a6df & 0xFF},
	{0x2a700 & 0xFF, 0x2a7ff & 0xFF},
	{0x2a800 & 0xFF, 0x2a8ff & 0xFF},
	{0x2a900 & 0xFF, 0x2a9ff & 0xFF},
	{0x2aa00 & 0xFF, 0x2aaff & 0xFF},
	{0x2ab00 & 0xFF, 0x2abff & 0xFF},
	{0x2ac00 & 0xFF, 0x2acff & 0xFF},
	{0x2ad00 & 0xFF, 0x2adff & 0xFF},
	{0x2ae00 & 0xFF, 0x2aeff & 0xFF},
	{0x2af00 & 0xFF, 0x2afff & 0xFF},
	{0x2b000 & 0xFF, 0x2b0ff & 0xFF},
	{0x2b100 & 0xFF, 0x2b1ff & 0xFF},
	{0x2b200 & 0xFF, 0x2b2ff & 0xFF},
	{0x2b300 & 0xFF, 0x2b3ff & 0xFF},
	{0x2b400 & 0xFF, 0x2b4ff & 0xFF},
	{0x2b500 & 0xFF, 0x2b5ff & 0xFF},
	{0x2b600 & 0xFF, 0x2b6ff & 0xFF},
	{0x2b700 & 0xFF, 0x2b739 & 0xFF},
	{0x2b740 & 0xFF, 0x2b7ff & 0xFF},
	{0x2b800 & 0xFF, 0x2b81d & 0xFF},
	{0x2b820 & 0xFF, 0x2b8ff & 0xFF},
	{0x2b900 & 0xFF, 0x2b9ff & 0xFF},
	{0x2ba00 & 0xFF, 0x2baff & 0xFF},
	{0x2bb00 & 0xFF, 0x2bbff & 0xFF},
	{0x2bc00 & 0xFF, 0x2bcff & 0xFF},
	{0x2bd00 & 0xFF, 0x2bdff & 0xFF},
	{0x2be00 & 0xFF, 0x2beff & 0xFF},
	{0x2bf00 & 0xFF, 0x2bfff & 0xFF},
	{0x2c000 & 0xFF, 0x2c0ff & 0xFF},
	{0x2c100 & 0xFF, 0x2c1ff & 0xFF},
	{0x2c200 & 0xFF, 0x2c2ff & 0xFF},
	{0x2c300 & 0xFF, 0x2c3ff & 0xFF},
	{0x2c400 & 0xFF, 0x2c4ff & 0xFF},
	{0x2c500 & 0xFF, 0x2c5ff & 0xFF},
	{0x2c600 & 0xFF, 0x2c6ff & 0xFF},
	{0x2c700 & 0xFF, 0x2c7ff & 0xFF},
	{0x2c800 & 0xFF, 0x2c8ff & 0xFF},
	{0x2c900 & 0xFF, 0x2c9ff & 0xFF},
	{0x2ca00 & 0xFF, 0x2caff & 0xFF},
	{0x2cb00 & 0xFF, 0x2cbff & 0xFF},
	{0x2cc00 & 0xFF, 0x2ccff & 0xFF},
	{0x2cd00 & 0xFF, 0x2cdff & 0xFF},
	{0x2ce00 & 0xFF, 0x2cea1 & 0xFF},
	{0x2ceb0 & 0xFF, 0x2ceff & 0xFF},
	{0x2cf00 & 0xFF, 0x2cfff & 0xFF},
	{0x2d000 & 0xFF, 0x2d0ff & 0xFF},
	{0x2d100 & 0xFF, 0x2d1ff & 0xFF},
	{0x2d200 & 0xFF, 0x2d2ff & 0xFF},
	{0x2d300 & 0xFF, 0x2d3ff & 0xFF},
	{0x2d400 & 0xFF, 0x2d4ff & 0xFF},
	{0x2d500 & 0xFF, 0x2d5ff & 0xFF},
	{0x2d600 & 0xFF, 0x2d6ff & 0xFF},
	{0x2d700 & 0xFF, 0x2d7ff & 0xFF},
	{0x2d800 & 0xFF, 0x2d8ff & 0xFF},
	{0x2d900 & 0xFF, 0x2d9ff & 0xFF},
	{0x2da00 & 0xFF, 0x2daff & 0xFF},
	{0x2db00 & 0xFF, 0x2dbff & 0xFF},
	{0x2dc00 & 0xFF, 0x2dcff & 0xFF},
	{0x2dd00 & 0xFF, 0x2ddff & 0xFF},
	{0x2de00 & 0xFF, 0x2deff & 0xFF},
	{0x2df00 & 0xFF, 0x2dfff & 0xFF},
	{0x2e000 & 0xFF, 0x2e0ff & 0xFF},
	{0x2e100 & 0xFF, 0x2e1ff & 0xFF},
	{0x2e200 & 0xFF, 0x2e2ff & 0xFF},
	{0x2e300 & 0xFF, 0x2e3ff & 0xFF},
	{0x2e400 & 0xFF, 0x2e4ff & 0xFF},
	{0x2e500 & 0xFF, 0x2e5ff & 0xFF},
	{0x2e600 & 0xFF, 0x2e6ff & 0xFF},
	{0x2e700 & 0xFF, 0x2e7ff & 0xFF},
	{0x2e800 & 0xFF, 0x2e8ff & 0xFF},
	{0x2e900 & 0xFF, 0x2e9ff & 0xFF},
	{0x2ea00 & 0xFF, 0x2eaff & 0xFF},
	{0x2eb00 & 0xFF, 0x2ebe0 & 0xFF},
	{0x2ebf0 & 0xFF, 0x2ebff & 0xFF},
	{0x2ec00 & 0xFF, 0x2ecff & 0xFF},
	{0x2ed00 & 0xFF, 0x2edff & 0xFF},
	{0x2ee00 & 0xFF, 0x2ee5d & 0xFF},
	{0x2f800 & 0xFF, 0x2f8ff & 0xFF},
	{0x2f900 & 0xFF, 0x2f9ff & 0xFF},
	{0x2fa00 & 0xFF, 0x2fa1d & 0xFF},
	{0x30000 & 0xFF, 0x300ff & 0xFF},
	{0x30100 & 0xFF, 0x301ff & 0xFF},
	{0x30200 & 0xFF, 0x302ff & 0xFF},
	{0x30300 & 0xFF, 0x303ff & 0xFF},
	{0x30400 & 0xFF, 0x304ff & 0xFF},
	{0x30500 & 0xFF, 0x305ff & 0xFF},
	{0x30600 & 0xFF, 0x306ff & 0xFF},
	{0x30700 & 0xFF, 0x307ff & 0xFF},
	{0x30800 & 0xFF, 0x308ff & 0xFF},
	{0x30900 & 0xFF, 0x309ff & 0xFF},
	{0x30a00 & 0xFF, 0x30aff & 0xFF},
	{0x30b00 & 0xFF, 0x30bff & 0xFF},
	{0x30c00 & 0xFF, 0x30cff & 0xFF},
	{0x30d00 & 0xFF, 0x30dff & 0xFF},
	{0x30e00 & 0xFF, 0x30eff & 0xFF},
	{0x30f00 & 0xFF, 0x30fff & 0xFF},
	{0x31000 & 0xFF, 0x310ff & 0xFF},
	{0x31100 & 0xFF, 0x311ff & 0xFF},
	{0x31200 & 0xFF, 0x312ff & 0xFF},
	{0x31300 & 0xFF, 0x3134a & 0xFF},
	{0x31350 & 0xFF, 0x313ff & 0xFF},
	{0x31400 & 0xFF, 0x314ff & 0xFF},
	{0x31500 & 0xFF, 0x315ff & 0xFF},
	{0x31600 & 0xFF, 0x316ff & 0xFF},
	{0x31700 & 0xFF, 0x317ff & 0xFF},
	{0x31800 & 0xFF, 0x318ff & 0xFF},
	{0x31900 & 0xFF, 0x319ff & 0xFF},
	{0x31a00 & 0xFF, 0x31aff & 0xFF},
	{0x31b00 & 0xFF, 0x31bff & 0xFF},
	{0x31c00 & 0xFF, 0x31cff & 0xFF},
	{0x31d00 & 0xFF, 0x31dff & 0xFF},
	{0x31e00 & 0xFF, 0x31eff & 0xFF},
	{0x31f00 & 0xFF, 0x31fff & 0xFF},
	{0x32000 & 0xFF, 0x320ff & 0xFF},
	{0x32100 & 0xFF, 0x321ff & 0xFF},
	{0x32200 & 0xFF, 0x322ff & 0xFF},
	{0x32300 & 0xFF, 0x323af & 0xFF}};

static const size_t ID_Start_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	30,
	31,
	32,
	33,
	44,
	45,
	48,
	49,
	52,
	53,
	54,
	55,
	56,
	57,
	58,
	59,
	60,
	61,
	62,
	63,
	64,
	65,
	66,
	67,
	68,
	69,
	70,
	71,
	72,
	73,
	74,
	75,
	76,
	77,
	78,
	79,
	80,
	81,
	82,
	83,
	84,
	85,
	86,
	87,
	88,
	89,
	90,
	91,
	92,
	93,
	94,
	95,
	96,
	97,
	98,
	99,
	100,
	101,
	102,
	103,
	104,
	105,
	106,
	107,
	108,
	109,
	110,
	111,
	112,
	113,
	114,
	115,
	116,
	117,
	118,
	119,
	120,
	121,
	122,
	123,
	124,
	125,
	126,
	127,
	128,
	129,
	130,
	131,
	132,
	133,
	134,
	135,
	136,
	137,
	138,
	139,
	140,
	141,
	142,
	143,
	144,
	145,
	146,
	147,
	148,
	149,
	150,
	151,
	152,
	153,
	154,
	155,
	156,
	157,
	158,
	159,
	160,
	161,
	162,
	163,
	164,
	165,
	166,
	167,
	168,
	169,
	170,
	171,
	172,
	173,
	174,
	175,
	176,
	177,
	178,
	179,
	180,
	181,
	182,
	183,
	184,
	185,
	186,
	187,
	188,
	189,
	190,
	191,
	192,
	193,
	194,
	195,
	196,
	197,
	198,
	199,
	200,
	201,
	202,
	203,
	204,
	205,
	206,
	207,
	208,
	209,
	210,
	211,
	212,
	213,
	214,
	215,
	249,
	250,
	251,
	252,
	253,
	254,
	255,
	256,
	257,
	258,
	259,
	260,
	261,
	262,
	263,
	264,
	265,
	266,
	267,
	268,
	269,
	270,
	271,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	284,
	285,
	286,
	287,
	288,
	289,
	290,
	291,
	292,
	293,
	303,
	304,
	305,
	306,
	307,
	308,
	324,
	325,
	326,
	360,
	361,
	362,
	363,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	431,
	432,
	433,
	434,
	444,
	468,
	469,
	470,
	471,
	479,
	480,
	481,
	482,
	484,
	487,
	488,
	489,
	494,
	512,
	513,
	514,
	515,
	516,
	517,
	518,
	519,
	520,
	521,
	522,
	523,
	524,
	525,
	526,
	527,
	528,
	529,
	530,
	531,
	532,
	533,
	534,
	535,
	536,
	537,
	538,
	539,
	540,
	541,
	542,
	543,
	544,
	545,
	546,
	547,
	548,
	549,
	550,
	551,
	552,
	553,
	554,
	555,
	556,
	557,
	558,
	559,
	560,
	561,
	562,
	563,
	564,
	565,
	566,
	567,
	568,
	569,
	570,
	571,
	572,
	573,
	574,
	575,
	576,
	577,
	578,
	579,
	580,
	581,
	582,
	583,
	584,
	585,
	586,
	587,
	588,
	589,
	590,
	591,
	592,
	593,
	594,
	595,
	596,
	597,
	598,
	599,
	600,
	601,
	602,
	603,
	604,
	605,
	606,
	607,
	608,
	609,
	610,
	611,
	612,
	613,
	614,
	615,
	616,
	617,
	618,
	619,
	620,
	621,
	622,
	623,
	624,
	625,
	626,
	627,
	628,
	629,
	630,
	631,
	632,
	633,
	634,
	635,
	636,
	637,
	638,
	639,
	640,
	641,
	642,
	643,
	644,
	645,
	646,
	647,
	648,
	649,
	650,
	651,
	652,
	653,
	654,
	655,
	656,
	657,
	658,
	659,
	660,
	661,
	662,
	663,
	664,
	665,
	666,
	667,
	668,
	669,
	670,
	671,
	672,
	673,
	674,
	675,
	676,
	677,
	678,
	679,
	680,
	681,
	682,
	683,
	684,
	685,
	686,
	687,
	688,
	689,
	690,
	691,
	692,
	693,
	694,
	695,
	696,
	697,
	698,
	699,
	700,
	701,
	702,
	703,
	704,
	705,
	706,
	707,
	708,
	709,
	710,
	711,
	712,
	713,
	714,
	715,
	716,
	717,
	718,
	719,
	720,
	721,
	722,
	723,
	724,
	725,
	726,
	727,
	728,
	729,
	730,
	731,
	732,
	733,
	734,
	735,
	736,
	737,
	738,
	739,
	740,
	741,
	742,
	743,
	744,
	745,
	746,
	747,
	748,
	749,
	750,
	760,
	761,
	762,
	768,
	769,
	770,
	771,
	772,
	773,
	774,
	775,
	776,
	777,
	778,
	779,
	780,
	781,
	782,
	783,
	784,
	785,
	786,
	787,
	788,
	789,
	790,
	791,
	792,
	793,
	794,
	795,
	796,
	797,
	798,
	799,
	800,
	801,
	802,
	803
};

static const char32_t ID_Start_starting_pagetab[]={
	0,
	8,
	9,
	14,
	24,
	26,
	32,
	40,
	47,
	56,
	73,
	93,
	114,
	132,
	145,
	159,
	163,
	177,
	178,
	192,
	198,
	199,
	200,
	205,
	213,
	217,
	222,
	225,
	230,
	240,
	241,
	242,
	261,
	264,
	277,
	280,
	294,
	302,
	306,
	307,
	308,
	309,
	310,
	311,
	312,
	313,
	314,
	315,
	316,
	317,
	318,
	319,
	320,
	321,
	322,
	323,
	324,
	325,
	326,
	327,
	328,
	329,
	330,
	331,
	332,
	333,
	334,
	335,
	336,
	337,
	338,
	339,
	340,
	341,
	342,
	343,
	344,
	345,
	346,
	347,
	348,
	349,
	350,
	351,
	352,
	353,
	354,
	355,
	356,
	357,
	358,
	359,
	360,
	361,
	362,
	363,
	364,
	365,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	398,
	399,
	400,
	401,
	402,
	403,
	404,
	405,
	406,
	407,
	408,
	409,
	410,
	411,
	412,
	413,
	414,
	415,
	416,
	417,
	418,
	420,
	421,
	427,
	434,
	443,
	451,
	465,
	473,
	474,
	475,
	476,
	477,
	478,
	479,
	480,
	481,
	482,
	483,
	484,
	485,
	486,
	487,
	488,
	489,
	490,
	491,
	492,
	493,
	494,
	495,
	496,
	497,
	498,
	499,
	500,
	501,
	502,
	503,
	504,
	505,
	506,
	507,
	508,
	509,
	510,
	511,
	512,
	513,
	514,
	515,
	516,
	519,
	520,
	522,
	533,
	534,
	538,
	540,
	547,
	554,
	555,
	557,
	564,
	567,
	577,
	578,
	584,
	594,
	598,
	606,
	610,
	613,
	614,
	616,
	622,
	627,
	636,
	645,
	654,
	660,
	662,
	666,
	668,
	671,
	682,
	689,
	693,
	701,
	702,
	706,
	707,
	708,
	709,
	710,
	712,
	713,
	714,
	715,
	716,
	717,
	718,
	720,
	721,
	722,
	723,
	724,
	725,
	729,
	733,
	734,
	739,
	740,
	741,
	742,
	743,
	744,
	745,
	746,
	747,
	748,
	749,
	750,
	751,
	752,
	753,
	754,
	755,
	756,
	757,
	758,
	759,
	760,
	761,
	762,
	763,
	764,
	765,
	766,
	767,
	768,
	769,
	772,
	773,
	779,
	780,
	784,
	794,
	804,
	809,
	817,
	819,
	820,
	823,
	825,
	826,
	830,
	831,
	833,
	866,
	867,
	868,
	869,
	870,
	871,
	872,
	873,
	874,
	875,
	876,
	877,
	878,
	879,
	880,
	881,
	882,
	883,
	884,
	885,
	886,
	887,
	888,
	889,
	890,
	891,
	892,
	893,
	894,
	895,
	896,
	897,
	898,
	899,
	900,
	901,
	902,
	903,
	904,
	905,
	906,
	907,
	908,
	909,
	910,
	911,
	912,
	913,
	914,
	915,
	916,
	917,
	918,
	919,
	920,
	921,
	922,
	923,
	924,
	925,
	926,
	927,
	928,
	929,
	930,
	931,
	932,
	933,
	934,
	935,
	936,
	937,
	938,
	939,
	940,
	941,
	942,
	943,
	944,
	945,
	946,
	947,
	948,
	949,
	950,
	951,
	952,
	953,
	954,
	955,
	956,
	957,
	958,
	959,
	960,
	961,
	962,
	963,
	964,
	965,
	966,
	967,
	968,
	969,
	970,
	971,
	972,
	973,
	974,
	975,
	976,
	977,
	978,
	979,
	980,
	981,
	982,
	983,
	984,
	985,
	986,
	987,
	988,
	989,
	990,
	991,
	992,
	993,
	994,
	995,
	996,
	997,
	998,
	999,
	1000,
	1001,
	1002,
	1003,
	1004,
	1005,
	1006,
	1007,
	1008,
	1009,
	1010,
	1011,
	1012,
	1013,
	1014,
	1015,
	1016,
	1017,
	1018,
	1019,
	1020,
	1021,
	1022,
	1023,
	1024,
	1025,
	1026,
	1027,
	1028,
	1029,
	1030,
	1031,
	1032,
	1033,
	1034,
	1035,
	1036,
	1037,
	1038,
	1039,
	1040,
	1041,
	1042,
	1043,
	1044,
	1045,
	1046,
	1047,
	1048,
	1049,
	1051,
	1053,
	1054,
	1055,
	1056,
	1057,
	1058,
	1059,
	1060,
	1061,
	1062,
	1063,
	1064,
	1065,
	1066,
	1067,
	1068,
	1069,
	1070,
	1071,
	1072,
	1073,
	1074,
	1076,
	1077,
	1078,
	1079,
	1080,
	1081,
	1082,
	1083,
	1084,
	1085,
	1086,
	1087,
	1088,
	1089,
	1090,
	1091,
	1092,
	1093,
	1094,
	1095,
	1096,
	1097,
	1098,
	1099,
	1100,
	1101,
	1102,
	1103,
	1104,
	1106,
	1107,
	1108,
	1109,
	1110,
	1111,
	1112,
	1113,
	1114,
	1115,
	1116,
	1117,
	1118,
	1119,
	1120,
	1121,
	1122,
	1123,
	1124,
	1125,
	1126,
	1127,
	1128,
	1129,
	1130,
	1131,
	1133,
	1134,
	1135,
	1136,
	1137,
	1138,
	1139,
	1140,
	1141,
	1142,
	1143,
	1144,
	1145,
	1146,
	1147,
	1148
};

static const uint8_t Lowercase_rangetab[][2]={
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00aa & 0xFF, 0x00aa & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00ba & 0xFF, 0x00ba & 0xFF},
	{0x00df & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0101 & 0xFF, 0x0101 & 0xFF},
	{0x0103 & 0xFF, 0x0103 & 0xFF},
	{0x0105 & 0xFF, 0x0105 & 0xFF},
	{0x0107 & 0xFF, 0x0107 & 0xFF},
	{0x0109 & 0xFF, 0x0109 & 0xFF},
	{0x010b & 0xFF, 0x010b & 0xFF},
	{0x010d & 0xFF, 0x010d & 0xFF},
	{0x010f & 0xFF, 0x010f & 0xFF},
	{0x0111 & 0xFF, 0x0111 & 0xFF},
	{0x0113 & 0xFF, 0x0113 & 0xFF},
	{0x0115 & 0xFF, 0x0115 & 0xFF},
	{0x0117 & 0xFF, 0x0117 & 0xFF},
	{0x0119 & 0xFF, 0x0119 & 0xFF},
	{0x011b & 0xFF, 0x011b & 0xFF},
	{0x011d & 0xFF, 0x011d & 0xFF},
	{0x011f & 0xFF, 0x011f & 0xFF},
	{0x0121 & 0xFF, 0x0121 & 0xFF},
	{0x0123 & 0xFF, 0x0123 & 0xFF},
	{0x0125 & 0xFF, 0x0125 & 0xFF},
	{0x0127 & 0xFF, 0x0127 & 0xFF},
	{0x0129 & 0xFF, 0x0129 & 0xFF},
	{0x012b & 0xFF, 0x012b & 0xFF},
	{0x012d & 0xFF, 0x012d & 0xFF},
	{0x012f & 0xFF, 0x012f & 0xFF},
	{0x0131 & 0xFF, 0x0131 & 0xFF},
	{0x0133 & 0xFF, 0x0133 & 0xFF},
	{0x0135 & 0xFF, 0x0135 & 0xFF},
	{0x0137 & 0xFF, 0x0138 & 0xFF},
	{0x013a & 0xFF, 0x013a & 0xFF},
	{0x013c & 0xFF, 0x013c & 0xFF},
	{0x013e & 0xFF, 0x013e & 0xFF},
	{0x0140 & 0xFF, 0x0140 & 0xFF},
	{0x0142 & 0xFF, 0x0142 & 0xFF},
	{0x0144 & 0xFF, 0x0144 & 0xFF},
	{0x0146 & 0xFF, 0x0146 & 0xFF},
	{0x0148 & 0xFF, 0x0149 & 0xFF},
	{0x014b & 0xFF, 0x014b & 0xFF},
	{0x014d & 0xFF, 0x014d & 0xFF},
	{0x014f & 0xFF, 0x014f & 0xFF},
	{0x0151 & 0xFF, 0x0151 & 0xFF},
	{0x0153 & 0xFF, 0x0153 & 0xFF},
	{0x0155 & 0xFF, 0x0155 & 0xFF},
	{0x0157 & 0xFF, 0x0157 & 0xFF},
	{0x0159 & 0xFF, 0x0159 & 0xFF},
	{0x015b & 0xFF, 0x015b & 0xFF},
	{0x015d & 0xFF, 0x015d & 0xFF},
	{0x015f & 0xFF, 0x015f & 0xFF},
	{0x0161 & 0xFF, 0x0161 & 0xFF},
	{0x0163 & 0xFF, 0x0163 & 0xFF},
	{0x0165 & 0xFF, 0x0165 & 0xFF},
	{0x0167 & 0xFF, 0x0167 & 0xFF},
	{0x0169 & 0xFF, 0x0169 & 0xFF},
	{0x016b & 0xFF, 0x016b & 0xFF},
	{0x016d & 0xFF, 0x016d & 0xFF},
	{0x016f & 0xFF, 0x016f & 0xFF},
	{0x0171 & 0xFF, 0x0171 & 0xFF},
	{0x0173 & 0xFF, 0x0173 & 0xFF},
	{0x0175 & 0xFF, 0x0175 & 0xFF},
	{0x0177 & 0xFF, 0x0177 & 0xFF},
	{0x017a & 0xFF, 0x017a & 0xFF},
	{0x017c & 0xFF, 0x017c & 0xFF},
	{0x017e & 0xFF, 0x0180 & 0xFF},
	{0x0183 & 0xFF, 0x0183 & 0xFF},
	{0x0185 & 0xFF, 0x0185 & 0xFF},
	{0x0188 & 0xFF, 0x0188 & 0xFF},
	{0x018c & 0xFF, 0x018d & 0xFF},
	{0x0192 & 0xFF, 0x0192 & 0xFF},
	{0x0195 & 0xFF, 0x0195 & 0xFF},
	{0x0199 & 0xFF, 0x019b & 0xFF},
	{0x019e & 0xFF, 0x019e & 0xFF},
	{0x01a1 & 0xFF, 0x01a1 & 0xFF},
	{0x01a3 & 0xFF, 0x01a3 & 0xFF},
	{0x01a5 & 0xFF, 0x01a5 & 0xFF},
	{0x01a8 & 0xFF, 0x01a8 & 0xFF},
	{0x01aa & 0xFF, 0x01ab & 0xFF},
	{0x01ad & 0xFF, 0x01ad & 0xFF},
	{0x01b0 & 0xFF, 0x01b0 & 0xFF},
	{0x01b4 & 0xFF, 0x01b4 & 0xFF},
	{0x01b6 & 0xFF, 0x01b6 & 0xFF},
	{0x01b9 & 0xFF, 0x01ba & 0xFF},
	{0x01bd & 0xFF, 0x01bf & 0xFF},
	{0x01c6 & 0xFF, 0x01c6 & 0xFF},
	{0x01c9 & 0xFF, 0x01c9 & 0xFF},
	{0x01cc & 0xFF, 0x01cc & 0xFF},
	{0x01ce & 0xFF, 0x01ce & 0xFF},
	{0x01d0 & 0xFF, 0x01d0 & 0xFF},
	{0x01d2 & 0xFF, 0x01d2 & 0xFF},
	{0x01d4 & 0xFF, 0x01d4 & 0xFF},
	{0x01d6 & 0xFF, 0x01d6 & 0xFF},
	{0x01d8 & 0xFF, 0x01d8 & 0xFF},
	{0x01da & 0xFF, 0x01da & 0xFF},
	{0x01dc & 0xFF, 0x01dd & 0xFF},
	{0x01df & 0xFF, 0x01df & 0xFF},
	{0x01e1 & 0xFF, 0x01e1 & 0xFF},
	{0x01e3 & 0xFF, 0x01e3 & 0xFF},
	{0x01e5 & 0xFF, 0x01e5 & 0xFF},
	{0x01e7 & 0xFF, 0x01e7 & 0xFF},
	{0x01e9 & 0xFF, 0x01e9 & 0xFF},
	{0x01eb & 0xFF, 0x01eb & 0xFF},
	{0x01ed & 0xFF, 0x01ed & 0xFF},
	{0x01ef & 0xFF, 0x01f0 & 0xFF},
	{0x01f3 & 0xFF, 0x01f3 & 0xFF},
	{0x01f5 & 0xFF, 0x01f5 & 0xFF},
	{0x01f9 & 0xFF, 0x01f9 & 0xFF},
	{0x01fb & 0xFF, 0x01fb & 0xFF},
	{0x01fd & 0xFF, 0x01fd & 0xFF},
	{0x01ff & 0xFF, 0x01ff & 0xFF},
	{0x0201 & 0xFF, 0x0201 & 0xFF},
	{0x0203 & 0xFF, 0x0203 & 0xFF},
	{0x0205 & 0xFF, 0x0205 & 0xFF},
	{0x0207 & 0xFF, 0x0207 & 0xFF},
	{0x0209 & 0xFF, 0x0209 & 0xFF},
	{0x020b & 0xFF, 0x020b & 0xFF},
	{0x020d & 0xFF, 0x020d & 0xFF},
	{0x020f & 0xFF, 0x020f & 0xFF},
	{0x0211 & 0xFF, 0x0211 & 0xFF},
	{0x0213 & 0xFF, 0x0213 & 0xFF},
	{0x0215 & 0xFF, 0x0215 & 0xFF},
	{0x0217 & 0xFF, 0x0217 & 0xFF},
	{0x0219 & 0xFF, 0x0219 & 0xFF},
	{0x021b & 0xFF, 0x021b & 0xFF},
	{0x021d & 0xFF, 0x021d & 0xFF},
	{0x021f & 0xFF, 0x021f & 0xFF},
	{0x0221 & 0xFF, 0x0221 & 0xFF},
	{0x0223 & 0xFF, 0x0223 & 0xFF},
	{0x0225 & 0xFF, 0x0225 & 0xFF},
	{0x0227 & 0xFF, 0x0227 & 0xFF},
	{0x0229 & 0xFF, 0x0229 & 0xFF},
	{0x022b & 0xFF, 0x022b & 0xFF},
	{0x022d & 0xFF, 0x022d & 0xFF},
	{0x022f & 0xFF, 0x022f & 0xFF},
	{0x0231 & 0xFF, 0x0231 & 0xFF},
	{0x0233 & 0xFF, 0x0239 & 0xFF},
	{0x023c & 0xFF, 0x023c & 0xFF},
	{0x023f & 0xFF, 0x0240 & 0xFF},
	{0x0242 & 0xFF, 0x0242 & 0xFF},
	{0x0247 & 0xFF, 0x0247 & 0xFF},
	{0x0249 & 0xFF, 0x0249 & 0xFF},
	{0x024b & 0xFF, 0x024b & 0xFF},
	{0x024d & 0xFF, 0x024d & 0xFF},
	{0x024f & 0xFF, 0x0293 & 0xFF},
	{0x0295 & 0xFF, 0x02b8 & 0xFF},
	{0x02c0 & 0xFF, 0x02c1 & 0xFF},
	{0x02e0 & 0xFF, 0x02e4 & 0xFF},
	{0x0345 & 0xFF, 0x0345 & 0xFF},
	{0x0371 & 0xFF, 0x0371 & 0xFF},
	{0x0373 & 0xFF, 0x0373 & 0xFF},
	{0x0377 & 0xFF, 0x0377 & 0xFF},
	{0x037a & 0xFF, 0x037d & 0xFF},
	{0x0390 & 0xFF, 0x0390 & 0xFF},
	{0x03ac & 0xFF, 0x03ce & 0xFF},
	{0x03d0 & 0xFF, 0x03d1 & 0xFF},
	{0x03d5 & 0xFF, 0x03d7 & 0xFF},
	{0x03d9 & 0xFF, 0x03d9 & 0xFF},
	{0x03db & 0xFF, 0x03db & 0xFF},
	{0x03dd & 0xFF, 0x03dd & 0xFF},
	{0x03df & 0xFF, 0x03df & 0xFF},
	{0x03e1 & 0xFF, 0x03e1 & 0xFF},
	{0x03e3 & 0xFF, 0x03e3 & 0xFF},
	{0x03e5 & 0xFF, 0x03e5 & 0xFF},
	{0x03e7 & 0xFF, 0x03e7 & 0xFF},
	{0x03e9 & 0xFF, 0x03e9 & 0xFF},
	{0x03eb & 0xFF, 0x03eb & 0xFF},
	{0x03ed & 0xFF, 0x03ed & 0xFF},
	{0x03ef & 0xFF, 0x03f3 & 0xFF},
	{0x03f5 & 0xFF, 0x03f5 & 0xFF},
	{0x03f8 & 0xFF, 0x03f8 & 0xFF},
	{0x03fb & 0xFF, 0x03fc & 0xFF},
	{0x0430 & 0xFF, 0x045f & 0xFF},
	{0x0461 & 0xFF, 0x0461 & 0xFF},
	{0x0463 & 0xFF, 0x0463 & 0xFF},
	{0x0465 & 0xFF, 0x0465 & 0xFF},
	{0x0467 & 0xFF, 0x0467 & 0xFF},
	{0x0469 & 0xFF, 0x0469 & 0xFF},
	{0x046b & 0xFF, 0x046b & 0xFF},
	{0x046d & 0xFF, 0x046d & 0xFF},
	{0x046f & 0xFF, 0x046f & 0xFF},
	{0x0471 & 0xFF, 0x0471 & 0xFF},
	{0x0473 & 0xFF, 0x0473 & 0xFF},
	{0x0475 & 0xFF, 0x0475 & 0xFF},
	{0x0477 & 0xFF, 0x0477 & 0xFF},
	{0x0479 & 0xFF, 0x0479 & 0xFF},
	{0x047b & 0xFF, 0x047b & 0xFF},
	{0x047d & 0xFF, 0x047d & 0xFF},
	{0x047f & 0xFF, 0x047f & 0xFF},
	{0x0481 & 0xFF, 0x0481 & 0xFF},
	{0x048b & 0xFF, 0x048b & 0xFF},
	{0x048d & 0xFF, 0x048d & 0xFF},
	{0x048f & 0xFF, 0x048f & 0xFF},
	{0x0491 & 0xFF, 0x0491 & 0xFF},
	{0x0493 & 0xFF, 0x0493 & 0xFF},
	{0x0495 & 0xFF, 0x0495 & 0xFF},
	{0x0497 & 0xFF, 0x0497 & 0xFF},
	{0x0499 & 0xFF, 0x0499 & 0xFF},
	{0x049b & 0xFF, 0x049b & 0xFF},
	{0x049d & 0xFF, 0x049d & 0xFF},
	{0x049f & 0xFF, 0x049f & 0xFF},
	{0x04a1 & 0xFF, 0x04a1 & 0xFF},
	{0x04a3 & 0xFF, 0x04a3 & 0xFF},
	{0x04a5 & 0xFF, 0x04a5 & 0xFF},
	{0x04a7 & 0xFF, 0x04a7 & 0xFF},
	{0x04a9 & 0xFF, 0x04a9 & 0xFF},
	{0x04ab & 0xFF, 0x04ab & 0xFF},
	{0x04ad & 0xFF, 0x04ad & 0xFF},
	{0x04af & 0xFF, 0x04af & 0xFF},
	{0x04b1 & 0xFF, 0x04b1 & 0xFF},
	{0x04b3 & 0xFF, 0x04b3 & 0xFF},
	{0x04b5 & 0xFF, 0x04b5 & 0xFF},
	{0x04b7 & 0xFF, 0x04b7 & 0xFF},
	{0x04b9 & 0xFF, 0x04b9 & 0xFF},
	{0x04bb & 0xFF, 0x04bb & 0xFF},
	{0x04bd & 0xFF, 0x04bd & 0xFF},
	{0x04bf & 0xFF, 0x04bf & 0xFF},
	{0x04c2 & 0xFF, 0x04c2 & 0xFF},
	{0x04c4 & 0xFF, 0x04c4 & 0xFF},
	{0x04c6 & 0xFF, 0x04c6 & 0xFF},
	{0x04c8 & 0xFF, 0x04c8 & 0xFF},
	{0x04ca & 0xFF, 0x04ca & 0xFF},
	{0x04cc & 0xFF, 0x04cc & 0xFF},
	{0x04ce & 0xFF, 0x04cf & 0xFF},
	{0x04d1 & 0xFF, 0x04d1 & 0xFF},
	{0x04d3 & 0xFF, 0x04d3 & 0xFF},
	{0x04d5 & 0xFF, 0x04d5 & 0xFF},
	{0x04d7 & 0xFF, 0x04d7 & 0xFF},
	{0x04d9 & 0xFF, 0x04d9 & 0xFF},
	{0x04db & 0xFF, 0x04db & 0xFF},
	{0x04dd & 0xFF, 0x04dd & 0xFF},
	{0x04df & 0xFF, 0x04df & 0xFF},
	{0x04e1 & 0xFF, 0x04e1 & 0xFF},
	{0x04e3 & 0xFF, 0x04e3 & 0xFF},
	{0x04e5 & 0xFF, 0x04e5 & 0xFF},
	{0x04e7 & 0xFF, 0x04e7 & 0xFF},
	{0x04e9 & 0xFF, 0x04e9 & 0xFF},
	{0x04eb & 0xFF, 0x04eb & 0xFF},
	{0x04ed & 0xFF, 0x04ed & 0xFF},
	{0x04ef & 0xFF, 0x04ef & 0xFF},
	{0x04f1 & 0xFF, 0x04f1 & 0xFF},
	{0x04f3 & 0xFF, 0x04f3 & 0xFF},
	{0x04f5 & 0xFF, 0x04f5 & 0xFF},
	{0x04f7 & 0xFF, 0x04f7 & 0xFF},
	{0x04f9 & 0xFF, 0x04f9 & 0xFF},
	{0x04fb & 0xFF, 0x04fb & 0xFF},
	{0x04fd & 0xFF, 0x04fd & 0xFF},
	{0x04ff & 0xFF, 0x04ff & 0xFF},
	{0x0501 & 0xFF, 0x0501 & 0xFF},
	{0x0503 & 0xFF, 0x0503 & 0xFF},
	{0x0505 & 0xFF, 0x0505 & 0xFF},
	{0x0507 & 0xFF, 0x0507 & 0xFF},
	{0x0509 & 0xFF, 0x0509 & 0xFF},
	{0x050b & 0xFF, 0x050b & 0xFF},
	{0x050d & 0xFF, 0x050d & 0xFF},
	{0x050f & 0xFF, 0x050f & 0xFF},
	{0x0511 & 0xFF, 0x0511 & 0xFF},
	{0x0513 & 0xFF, 0x0513 & 0xFF},
	{0x0515 & 0xFF, 0x0515 & 0xFF},
	{0x0517 & 0xFF, 0x0517 & 0xFF},
	{0x0519 & 0xFF, 0x0519 & 0xFF},
	{0x051b & 0xFF, 0x051b & 0xFF},
	{0x051d & 0xFF, 0x051d & 0xFF},
	{0x051f & 0xFF, 0x051f & 0xFF},
	{0x0521 & 0xFF, 0x0521 & 0xFF},
	{0x0523 & 0xFF, 0x0523 & 0xFF},
	{0x0525 & 0xFF, 0x0525 & 0xFF},
	{0x0527 & 0xFF, 0x0527 & 0xFF},
	{0x0529 & 0xFF, 0x0529 & 0xFF},
	{0x052b & 0xFF, 0x052b & 0xFF},
	{0x052d & 0xFF, 0x052d & 0xFF},
	{0x052f & 0xFF, 0x052f & 0xFF},
	{0x0560 & 0xFF, 0x0588 & 0xFF},
	{0x10d0 & 0xFF, 0x10fa & 0xFF},
	{0x10fc & 0xFF, 0x10ff & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1d00 & 0xFF, 0x1dbf & 0xFF},
	{0x1e01 & 0xFF, 0x1e01 & 0xFF},
	{0x1e03 & 0xFF, 0x1e03 & 0xFF},
	{0x1e05 & 0xFF, 0x1e05 & 0xFF},
	{0x1e07 & 0xFF, 0x1e07 & 0xFF},
	{0x1e09 & 0xFF, 0x1e09 & 0xFF},
	{0x1e0b & 0xFF, 0x1e0b & 0xFF},
	{0x1e0d & 0xFF, 0x1e0d & 0xFF},
	{0x1e0f & 0xFF, 0x1e0f & 0xFF},
	{0x1e11 & 0xFF, 0x1e11 & 0xFF},
	{0x1e13 & 0xFF, 0x1e13 & 0xFF},
	{0x1e15 & 0xFF, 0x1e15 & 0xFF},
	{0x1e17 & 0xFF, 0x1e17 & 0xFF},
	{0x1e19 & 0xFF, 0x1e19 & 0xFF},
	{0x1e1b & 0xFF, 0x1e1b & 0xFF},
	{0x1e1d & 0xFF, 0x1e1d & 0xFF},
	{0x1e1f & 0xFF, 0x1e1f & 0xFF},
	{0x1e21 & 0xFF, 0x1e21 & 0xFF},
	{0x1e23 & 0xFF, 0x1e23 & 0xFF},
	{0x1e25 & 0xFF, 0x1e25 & 0xFF},
	{0x1e27 & 0xFF, 0x1e27 & 0xFF},
	{0x1e29 & 0xFF, 0x1e29 & 0xFF},
	{0x1e2b & 0xFF, 0x1e2b & 0xFF},
	{0x1e2d & 0xFF, 0x1e2d & 0xFF},
	{0x1e2f & 0xFF, 0x1e2f & 0xFF},
	{0x1e31 & 0xFF, 0x1e31 & 0xFF},
	{0x1e33 & 0xFF, 0x1e33 & 0xFF},
	{0x1e35 & 0xFF, 0x1e35 & 0xFF},
	{0x1e37 & 0xFF, 0x1e37 & 0xFF},
	{0x1e39 & 0xFF, 0x1e39 & 0xFF},
	{0x1e3b & 0xFF, 0x1e3b & 0xFF},
	{0x1e3d & 0xFF, 0x1e3d & 0xFF},
	{0x1e3f & 0xFF, 0x1e3f & 0xFF},
	{0x1e41 & 0xFF, 0x1e41 & 0xFF},
	{0x1e43 & 0xFF, 0x1e43 & 0xFF},
	{0x1e45 & 0xFF, 0x1e45 & 0xFF},
	{0x1e47 & 0xFF, 0x1e47 & 0xFF},
	{0x1e49 & 0xFF, 0x1e49 & 0xFF},
	{0x1e4b & 0xFF, 0x1e4b & 0xFF},
	{0x1e4d & 0xFF, 0x1e4d & 0xFF},
	{0x1e4f & 0xFF, 0x1e4f & 0xFF},
	{0x1e51 & 0xFF, 0x1e51 & 0xFF},
	{0x1e53 & 0xFF, 0x1e53 & 0xFF},
	{0x1e55 & 0xFF, 0x1e55 & 0xFF},
	{0x1e57 & 0xFF, 0x1e57 & 0xFF},
	{0x1e59 & 0xFF, 0x1e59 & 0xFF},
	{0x1e5b & 0xFF, 0x1e5b & 0xFF},
	{0x1e5d & 0xFF, 0x1e5d & 0xFF},
	{0x1e5f & 0xFF, 0x1e5f & 0xFF},
	{0x1e61 & 0xFF, 0x1e61 & 0xFF},
	{0x1e63 & 0xFF, 0x1e63 & 0xFF},
	{0x1e65 & 0xFF, 0x1e65 & 0xFF},
	{0x1e67 & 0xFF, 0x1e67 & 0xFF},
	{0x1e69 & 0xFF, 0x1e69 & 0xFF},
	{0x1e6b & 0xFF, 0x1e6b & 0xFF},
	{0x1e6d & 0xFF, 0x1e6d & 0xFF},
	{0x1e6f & 0xFF, 0x1e6f & 0xFF},
	{0x1e71 & 0xFF, 0x1e71 & 0xFF},
	{0x1e73 & 0xFF, 0x1e73 & 0xFF},
	{0x1e75 & 0xFF, 0x1e75 & 0xFF},
	{0x1e77 & 0xFF, 0x1e77 & 0xFF},
	{0x1e79 & 0xFF, 0x1e79 & 0xFF},
	{0x1e7b & 0xFF, 0x1e7b & 0xFF},
	{0x1e7d & 0xFF, 0x1e7d & 0xFF},
	{0x1e7f & 0xFF, 0x1e7f & 0xFF},
	{0x1e81 & 0xFF, 0x1e81 & 0xFF},
	{0x1e83 & 0xFF, 0x1e83 & 0xFF},
	{0x1e85 & 0xFF, 0x1e85 & 0xFF},
	{0x1e87 & 0xFF, 0x1e87 & 0xFF},
	{0x1e89 & 0xFF, 0x1e89 & 0xFF},
	{0x1e8b & 0xFF, 0x1e8b & 0xFF},
	{0x1e8d & 0xFF, 0x1e8d & 0xFF},
	{0x1e8f & 0xFF, 0x1e8f & 0xFF},
	{0x1e91 & 0xFF, 0x1e91 & 0xFF},
	{0x1e93 & 0xFF, 0x1e93 & 0xFF},
	{0x1e95 & 0xFF, 0x1e9d & 0xFF},
	{0x1e9f & 0xFF, 0x1e9f & 0xFF},
	{0x1ea1 & 0xFF, 0x1ea1 & 0xFF},
	{0x1ea3 & 0xFF, 0x1ea3 & 0xFF},
	{0x1ea5 & 0xFF, 0x1ea5 & 0xFF},
	{0x1ea7 & 0xFF, 0x1ea7 & 0xFF},
	{0x1ea9 & 0xFF, 0x1ea9 & 0xFF},
	{0x1eab & 0xFF, 0x1eab & 0xFF},
	{0x1ead & 0xFF, 0x1ead & 0xFF},
	{0x1eaf & 0xFF, 0x1eaf & 0xFF},
	{0x1eb1 & 0xFF, 0x1eb1 & 0xFF},
	{0x1eb3 & 0xFF, 0x1eb3 & 0xFF},
	{0x1eb5 & 0xFF, 0x1eb5 & 0xFF},
	{0x1eb7 & 0xFF, 0x1eb7 & 0xFF},
	{0x1eb9 & 0xFF, 0x1eb9 & 0xFF},
	{0x1ebb & 0xFF, 0x1ebb & 0xFF},
	{0x1ebd & 0xFF, 0x1ebd & 0xFF},
	{0x1ebf & 0xFF, 0x1ebf & 0xFF},
	{0x1ec1 & 0xFF, 0x1ec1 & 0xFF},
	{0x1ec3 & 0xFF, 0x1ec3 & 0xFF},
	{0x1ec5 & 0xFF, 0x1ec5 & 0xFF},
	{0x1ec7 & 0xFF, 0x1ec7 & 0xFF},
	{0x1ec9 & 0xFF, 0x1ec9 & 0xFF},
	{0x1ecb & 0xFF, 0x1ecb & 0xFF},
	{0x1ecd & 0xFF, 0x1ecd & 0xFF},
	{0x1ecf & 0xFF, 0x1ecf & 0xFF},
	{0x1ed1 & 0xFF, 0x1ed1 & 0xFF},
	{0x1ed3 & 0xFF, 0x1ed3 & 0xFF},
	{0x1ed5 & 0xFF, 0x1ed5 & 0xFF},
	{0x1ed7 & 0xFF, 0x1ed7 & 0xFF},
	{0x1ed9 & 0xFF, 0x1ed9 & 0xFF},
	{0x1edb & 0xFF, 0x1edb & 0xFF},
	{0x1edd & 0xFF, 0x1edd & 0xFF},
	{0x1edf & 0xFF, 0x1edf & 0xFF},
	{0x1ee1 & 0xFF, 0x1ee1 & 0xFF},
	{0x1ee3 & 0xFF, 0x1ee3 & 0xFF},
	{0x1ee5 & 0xFF, 0x1ee5 & 0xFF},
	{0x1ee7 & 0xFF, 0x1ee7 & 0xFF},
	{0x1ee9 & 0xFF, 0x1ee9 & 0xFF},
	{0x1eeb & 0xFF, 0x1eeb & 0xFF},
	{0x1eed & 0xFF, 0x1eed & 0xFF},
	{0x1eef & 0xFF, 0x1eef & 0xFF},
	{0x1ef1 & 0xFF, 0x1ef1 & 0xFF},
	{0x1ef3 & 0xFF, 0x1ef3 & 0xFF},
	{0x1ef5 & 0xFF, 0x1ef5 & 0xFF},
	{0x1ef7 & 0xFF, 0x1ef7 & 0xFF},
	{0x1ef9 & 0xFF, 0x1ef9 & 0xFF},
	{0x1efb & 0xFF, 0x1efb & 0xFF},
	{0x1efd & 0xFF, 0x1efd & 0xFF},
	{0x1eff & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f07 & 0xFF},
	{0x1f10 & 0xFF, 0x1f15 & 0xFF},
	{0x1f20 & 0xFF, 0x1f27 & 0xFF},
	{0x1f30 & 0xFF, 0x1f37 & 0xFF},
	{0x1f40 & 0xFF, 0x1f45 & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f60 & 0xFF, 0x1f67 & 0xFF},
	{0x1f70 & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1f87 & 0xFF},
	{0x1f90 & 0xFF, 0x1f97 & 0xFF},
	{0x1fa0 & 0xFF, 0x1fa7 & 0xFF},
	{0x1fb0 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fb7 & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fc7 & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fd7 & 0xFF},
	{0x1fe0 & 0xFF, 0x1fe7 & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ff7 & 0xFF},
	{0x2071 & 0xFF, 0x2071 & 0xFF},
	{0x207f & 0xFF, 0x207f & 0xFF},
	{0x2090 & 0xFF, 0x209c & 0xFF},
	{0x210a & 0xFF, 0x210a & 0xFF},
	{0x210e & 0xFF, 0x210f & 0xFF},
	{0x2113 & 0xFF, 0x2113 & 0xFF},
	{0x212f & 0xFF, 0x212f & 0xFF},
	{0x2134 & 0xFF, 0x2134 & 0xFF},
	{0x2139 & 0xFF, 0x2139 & 0xFF},
	{0x213c & 0xFF, 0x213d & 0xFF},
	{0x2146 & 0xFF, 0x2149 & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2170 & 0xFF, 0x217f & 0xFF},
	{0x2184 & 0xFF, 0x2184 & 0xFF},
	{0x24d0 & 0xFF, 0x24e9 & 0xFF},
	{0x2c30 & 0xFF, 0x2c5f & 0xFF},
	{0x2c61 & 0xFF, 0x2c61 & 0xFF},
	{0x2c65 & 0xFF, 0x2c66 & 0xFF},
	{0x2c68 & 0xFF, 0x2c68 & 0xFF},
	{0x2c6a & 0xFF, 0x2c6a & 0xFF},
	{0x2c6c & 0xFF, 0x2c6c & 0xFF},
	{0x2c71 & 0xFF, 0x2c71 & 0xFF},
	{0x2c73 & 0xFF, 0x2c74 & 0xFF},
	{0x2c76 & 0xFF, 0x2c7d & 0xFF},
	{0x2c81 & 0xFF, 0x2c81 & 0xFF},
	{0x2c83 & 0xFF, 0x2c83 & 0xFF},
	{0x2c85 & 0xFF, 0x2c85 & 0xFF},
	{0x2c87 & 0xFF, 0x2c87 & 0xFF},
	{0x2c89 & 0xFF, 0x2c89 & 0xFF},
	{0x2c8b & 0xFF, 0x2c8b & 0xFF},
	{0x2c8d & 0xFF, 0x2c8d & 0xFF},
	{0x2c8f & 0xFF, 0x2c8f & 0xFF},
	{0x2c91 & 0xFF, 0x2c91 & 0xFF},
	{0x2c93 & 0xFF, 0x2c93 & 0xFF},
	{0x2c95 & 0xFF, 0x2c95 & 0xFF},
	{0x2c97 & 0xFF, 0x2c97 & 0xFF},
	{0x2c99 & 0xFF, 0x2c99 & 0xFF},
	{0x2c9b & 0xFF, 0x2c9b & 0xFF},
	{0x2c9d & 0xFF, 0x2c9d & 0xFF},
	{0x2c9f & 0xFF, 0x2c9f & 0xFF},
	{0x2ca1 & 0xFF, 0x2ca1 & 0xFF},
	{0x2ca3 & 0xFF, 0x2ca3 & 0xFF},
	{0x2ca5 & 0xFF, 0x2ca5 & 0xFF},
	{0x2ca7 & 0xFF, 0x2ca7 & 0xFF},
	{0x2ca9 & 0xFF, 0x2ca9 & 0xFF},
	{0x2cab & 0xFF, 0x2cab & 0xFF},
	{0x2cad & 0xFF, 0x2cad & 0xFF},
	{0x2caf & 0xFF, 0x2caf & 0xFF},
	{0x2cb1 & 0xFF, 0x2cb1 & 0xFF},
	{0x2cb3 & 0xFF, 0x2cb3 & 0xFF},
	{0x2cb5 & 0xFF, 0x2cb5 & 0xFF},
	{0x2cb7 & 0xFF, 0x2cb7 & 0xFF},
	{0x2cb9 & 0xFF, 0x2cb9 & 0xFF},
	{0x2cbb & 0xFF, 0x2cbb & 0xFF},
	{0x2cbd & 0xFF, 0x2cbd & 0xFF},
	{0x2cbf & 0xFF, 0x2cbf & 0xFF},
	{0x2cc1 & 0xFF, 0x2cc1 & 0xFF},
	{0x2cc3 & 0xFF, 0x2cc3 & 0xFF},
	{0x2cc5 & 0xFF, 0x2cc5 & 0xFF},
	{0x2cc7 & 0xFF, 0x2cc7 & 0xFF},
	{0x2cc9 & 0xFF, 0x2cc9 & 0xFF},
	{0x2ccb & 0xFF, 0x2ccb & 0xFF},
	{0x2ccd & 0xFF, 0x2ccd & 0xFF},
	{0x2ccf & 0xFF, 0x2ccf & 0xFF},
	{0x2cd1 & 0xFF, 0x2cd1 & 0xFF},
	{0x2cd3 & 0xFF, 0x2cd3 & 0xFF},
	{0x2cd5 & 0xFF, 0x2cd5 & 0xFF},
	{0x2cd7 & 0xFF, 0x2cd7 & 0xFF},
	{0x2cd9 & 0xFF, 0x2cd9 & 0xFF},
	{0x2cdb & 0xFF, 0x2cdb & 0xFF},
	{0x2cdd & 0xFF, 0x2cdd & 0xFF},
	{0x2cdf & 0xFF, 0x2cdf & 0xFF},
	{0x2ce1 & 0xFF, 0x2ce1 & 0xFF},
	{0x2ce3 & 0xFF, 0x2ce4 & 0xFF},
	{0x2cec & 0xFF, 0x2cec & 0xFF},
	{0x2cee & 0xFF, 0x2cee & 0xFF},
	{0x2cf3 & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0xa641 & 0xFF, 0xa641 & 0xFF},
	{0xa643 & 0xFF, 0xa643 & 0xFF},
	{0xa645 & 0xFF, 0xa645 & 0xFF},
	{0xa647 & 0xFF, 0xa647 & 0xFF},
	{0xa649 & 0xFF, 0xa649 & 0xFF},
	{0xa64b & 0xFF, 0xa64b & 0xFF},
	{0xa64d & 0xFF, 0xa64d & 0xFF},
	{0xa64f & 0xFF, 0xa64f & 0xFF},
	{0xa651 & 0xFF, 0xa651 & 0xFF},
	{0xa653 & 0xFF, 0xa653 & 0xFF},
	{0xa655 & 0xFF, 0xa655 & 0xFF},
	{0xa657 & 0xFF, 0xa657 & 0xFF},
	{0xa659 & 0xFF, 0xa659 & 0xFF},
	{0xa65b & 0xFF, 0xa65b & 0xFF},
	{0xa65d & 0xFF, 0xa65d & 0xFF},
	{0xa65f & 0xFF, 0xa65f & 0xFF},
	{0xa661 & 0xFF, 0xa661 & 0xFF},
	{0xa663 & 0xFF, 0xa663 & 0xFF},
	{0xa665 & 0xFF, 0xa665 & 0xFF},
	{0xa667 & 0xFF, 0xa667 & 0xFF},
	{0xa669 & 0xFF, 0xa669 & 0xFF},
	{0xa66b & 0xFF, 0xa66b & 0xFF},
	{0xa66d & 0xFF, 0xa66d & 0xFF},
	{0xa681 & 0xFF, 0xa681 & 0xFF},
	{0xa683 & 0xFF, 0xa683 & 0xFF},
	{0xa685 & 0xFF, 0xa685 & 0xFF},
	{0xa687 & 0xFF, 0xa687 & 0xFF},
	{0xa689 & 0xFF, 0xa689 & 0xFF},
	{0xa68b & 0xFF, 0xa68b & 0xFF},
	{0xa68d & 0xFF, 0xa68d & 0xFF},
	{0xa68f & 0xFF, 0xa68f & 0xFF},
	{0xa691 & 0xFF, 0xa691 & 0xFF},
	{0xa693 & 0xFF, 0xa693 & 0xFF},
	{0xa695 & 0xFF, 0xa695 & 0xFF},
	{0xa697 & 0xFF, 0xa697 & 0xFF},
	{0xa699 & 0xFF, 0xa699 & 0xFF},
	{0xa69b & 0xFF, 0xa69d & 0xFF},
	{0xa723 & 0xFF, 0xa723 & 0xFF},
	{0xa725 & 0xFF, 0xa725 & 0xFF},
	{0xa727 & 0xFF, 0xa727 & 0xFF},
	{0xa729 & 0xFF, 0xa729 & 0xFF},
	{0xa72b & 0xFF, 0xa72b & 0xFF},
	{0xa72d & 0xFF, 0xa72d & 0xFF},
	{0xa72f & 0xFF, 0xa731 & 0xFF},
	{0xa733 & 0xFF, 0xa733 & 0xFF},
	{0xa735 & 0xFF, 0xa735 & 0xFF},
	{0xa737 & 0xFF, 0xa737 & 0xFF},
	{0xa739 & 0xFF, 0xa739 & 0xFF},
	{0xa73b & 0xFF, 0xa73b & 0xFF},
	{0xa73d & 0xFF, 0xa73d & 0xFF},
	{0xa73f & 0xFF, 0xa73f & 0xFF},
	{0xa741 & 0xFF, 0xa741 & 0xFF},
	{0xa743 & 0xFF, 0xa743 & 0xFF},
	{0xa745 & 0xFF, 0xa745 & 0xFF},
	{0xa747 & 0xFF, 0xa747 & 0xFF},
	{0xa749 & 0xFF, 0xa749 & 0xFF},
	{0xa74b & 0xFF, 0xa74b & 0xFF},
	{0xa74d & 0xFF, 0xa74d & 0xFF},
	{0xa74f & 0xFF, 0xa74f & 0xFF},
	{0xa751 & 0xFF, 0xa751 & 0xFF},
	{0xa753 & 0xFF, 0xa753 & 0xFF},
	{0xa755 & 0xFF, 0xa755 & 0xFF},
	{0xa757 & 0xFF, 0xa757 & 0xFF},
	{0xa759 & 0xFF, 0xa759 & 0xFF},
	{0xa75b & 0xFF, 0xa75b & 0xFF},
	{0xa75d & 0xFF, 0xa75d & 0xFF},
	{0xa75f & 0xFF, 0xa75f & 0xFF},
	{0xa761 & 0xFF, 0xa761 & 0xFF},
	{0xa763 & 0xFF, 0xa763 & 0xFF},
	{0xa765 & 0xFF, 0xa765 & 0xFF},
	{0xa767 & 0xFF, 0xa767 & 0xFF},
	{0xa769 & 0xFF, 0xa769 & 0xFF},
	{0xa76b & 0xFF, 0xa76b & 0xFF},
	{0xa76d & 0xFF, 0xa76d & 0xFF},
	{0xa76f & 0xFF, 0xa778 & 0xFF},
	{0xa77a & 0xFF, 0xa77a & 0xFF},
	{0xa77c & 0xFF, 0xa77c & 0xFF},
	{0xa77f & 0xFF, 0xa77f & 0xFF},
	{0xa781 & 0xFF, 0xa781 & 0xFF},
	{0xa783 & 0xFF, 0xa783 & 0xFF},
	{0xa785 & 0xFF, 0xa785 & 0xFF},
	{0xa787 & 0xFF, 0xa787 & 0xFF},
	{0xa78c & 0xFF, 0xa78c & 0xFF},
	{0xa78e & 0xFF, 0xa78e & 0xFF},
	{0xa791 & 0xFF, 0xa791 & 0xFF},
	{0xa793 & 0xFF, 0xa795 & 0xFF},
	{0xa797 & 0xFF, 0xa797 & 0xFF},
	{0xa799 & 0xFF, 0xa799 & 0xFF},
	{0xa79b & 0xFF, 0xa79b & 0xFF},
	{0xa79d & 0xFF, 0xa79d & 0xFF},
	{0xa79f & 0xFF, 0xa79f & 0xFF},
	{0xa7a1 & 0xFF, 0xa7a1 & 0xFF},
	{0xa7a3 & 0xFF, 0xa7a3 & 0xFF},
	{0xa7a5 & 0xFF, 0xa7a5 & 0xFF},
	{0xa7a7 & 0xFF, 0xa7a7 & 0xFF},
	{0xa7a9 & 0xFF, 0xa7a9 & 0xFF},
	{0xa7af & 0xFF, 0xa7af & 0xFF},
	{0xa7b5 & 0xFF, 0xa7b5 & 0xFF},
	{0xa7b7 & 0xFF, 0xa7b7 & 0xFF},
	{0xa7b9 & 0xFF, 0xa7b9 & 0xFF},
	{0xa7bb & 0xFF, 0xa7bb & 0xFF},
	{0xa7bd & 0xFF, 0xa7bd & 0xFF},
	{0xa7bf & 0xFF, 0xa7bf & 0xFF},
	{0xa7c1 & 0xFF, 0xa7c1 & 0xFF},
	{0xa7c3 & 0xFF, 0xa7c3 & 0xFF},
	{0xa7c8 & 0xFF, 0xa7c8 & 0xFF},
	{0xa7ca & 0xFF, 0xa7ca & 0xFF},
	{0xa7d1 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d3 & 0xFF, 0xa7d3 & 0xFF},
	{0xa7d5 & 0xFF, 0xa7d5 & 0xFF},
	{0xa7d7 & 0xFF, 0xa7d7 & 0xFF},
	{0xa7d9 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f2 & 0xFF, 0xa7f4 & 0xFF},
	{0xa7f6 & 0xFF, 0xa7f6 & 0xFF},
	{0xa7f8 & 0xFF, 0xa7fa & 0xFF},
	{0xab30 & 0xFF, 0xab5a & 0xFF},
	{0xab5c & 0xFF, 0xab69 & 0xFF},
	{0xab70 & 0xFF, 0xabbf & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0x10428 & 0xFF, 0x1044f & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10780 & 0xFF, 0x10780 & 0xFF},
	{0x10783 & 0xFF, 0x10785 & 0xFF},
	{0x10787 & 0xFF, 0x107b0 & 0xFF},
	{0x107b2 & 0xFF, 0x107ba & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x118c0 & 0xFF, 0x118df & 0xFF},
	{0x16e60 & 0xFF, 0x16e7f & 0xFF},
	{0x1d41a & 0xFF, 0x1d433 & 0xFF},
	{0x1d44e & 0xFF, 0x1d454 & 0xFF},
	{0x1d456 & 0xFF, 0x1d467 & 0xFF},
	{0x1d482 & 0xFF, 0x1d49b & 0xFF},
	{0x1d4b6 & 0xFF, 0x1d4b9 & 0xFF},
	{0x1d4bb & 0xFF, 0x1d4bb & 0xFF},
	{0x1d4bd & 0xFF, 0x1d4c3 & 0xFF},
	{0x1d4c5 & 0xFF, 0x1d4cf & 0xFF},
	{0x1d4ea & 0xFF, 0x1d4ff & 0xFF},
	{0x1d500 & 0xFF, 0x1d503 & 0xFF},
	{0x1d51e & 0xFF, 0x1d537 & 0xFF},
	{0x1d552 & 0xFF, 0x1d56b & 0xFF},
	{0x1d586 & 0xFF, 0x1d59f & 0xFF},
	{0x1d5ba & 0xFF, 0x1d5d3 & 0xFF},
	{0x1d5ee & 0xFF, 0x1d5ff & 0xFF},
	{0x1d600 & 0xFF, 0x1d607 & 0xFF},
	{0x1d622 & 0xFF, 0x1d63b & 0xFF},
	{0x1d656 & 0xFF, 0x1d66f & 0xFF},
	{0x1d68a & 0xFF, 0x1d6a5 & 0xFF},
	{0x1d6c2 & 0xFF, 0x1d6da & 0xFF},
	{0x1d6dc & 0xFF, 0x1d6e1 & 0xFF},
	{0x1d6fc & 0xFF, 0x1d6ff & 0xFF},
	{0x1d700 & 0xFF, 0x1d714 & 0xFF},
	{0x1d716 & 0xFF, 0x1d71b & 0xFF},
	{0x1d736 & 0xFF, 0x1d74e & 0xFF},
	{0x1d750 & 0xFF, 0x1d755 & 0xFF},
	{0x1d770 & 0xFF, 0x1d788 & 0xFF},
	{0x1d78a & 0xFF, 0x1d78f & 0xFF},
	{0x1d7aa & 0xFF, 0x1d7c2 & 0xFF},
	{0x1d7c4 & 0xFF, 0x1d7c9 & 0xFF},
	{0x1d7cb & 0xFF, 0x1d7cb & 0xFF},
	{0x1df00 & 0xFF, 0x1df09 & 0xFF},
	{0x1df0b & 0xFF, 0x1df1e & 0xFF},
	{0x1df25 & 0xFF, 0x1df2a & 0xFF},
	{0x1e030 & 0xFF, 0x1e06d & 0xFF},
	{0x1e922 & 0xFF, 0x1e943 & 0xFF}};

static const size_t Lowercase_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	16,
	19,
	28,
	29,
	30,
	31,
	32,
	33,
	36,
	44,
	45,
	166,
	167,
	171,
	251,
	255,
	260,
	261,
	263,
	268,
	280,
	366,
	468,
	469,
	470,
	471,
	479,
	480,
	489
};

static const char32_t Lowercase_starting_pagetab[]={
	0,
	6,
	113,
	150,
	174,
	250,
	275,
	277,
	278,
	279,
	280,
	404,
	425,
	428,
	439,
	440,
	502,
	505,
	542,
	620,
	623,
	625,
	626,
	628,
	632,
	636,
	637,
	638,
	639,
	648,
	654,
	661,
	670,
	673,
	674
};

static const uint8_t Math_rangetab[][2]={
	{0x002b & 0xFF, 0x002b & 0xFF},
	{0x003c & 0xFF, 0x003e & 0xFF},
	{0x005e & 0xFF, 0x005e & 0xFF},
	{0x007c & 0xFF, 0x007c & 0xFF},
	{0x007e & 0xFF, 0x007e & 0xFF},
	{0x00ac & 0xFF, 0x00ac & 0xFF},
	{0x00b1 & 0xFF, 0x00b1 & 0xFF},
	{0x00d7 & 0xFF, 0x00d7 & 0xFF},
	{0x00f7 & 0xFF, 0x00f7 & 0xFF},
	{0x03d0 & 0xFF, 0x03d2 & 0xFF},
	{0x03d5 & 0xFF, 0x03d5 & 0xFF},
	{0x03f0 & 0xFF, 0x03f1 & 0xFF},
	{0x03f4 & 0xFF, 0x03f6 & 0xFF},
	{0x0606 & 0xFF, 0x0608 & 0xFF},
	{0x2016 & 0xFF, 0x2016 & 0xFF},
	{0x2032 & 0xFF, 0x2034 & 0xFF},
	{0x2040 & 0xFF, 0x2040 & 0xFF},
	{0x2044 & 0xFF, 0x2044 & 0xFF},
	{0x2052 & 0xFF, 0x2052 & 0xFF},
	{0x2061 & 0xFF, 0x2064 & 0xFF},
	{0x207a & 0xFF, 0x207e & 0xFF},
	{0x208a & 0xFF, 0x208e & 0xFF},
	{0x20d0 & 0xFF, 0x20dc & 0xFF},
	{0x20e1 & 0xFF, 0x20e1 & 0xFF},
	{0x20e5 & 0xFF, 0x20e6 & 0xFF},
	{0x20eb & 0xFF, 0x20ef & 0xFF},
	{0x2102 & 0xFF, 0x2102 & 0xFF},
	{0x2107 & 0xFF, 0x2107 & 0xFF},
	{0x210a & 0xFF, 0x2113 & 0xFF},
	{0x2115 & 0xFF, 0x2115 & 0xFF},
	{0x2118 & 0xFF, 0x211d & 0xFF},
	{0x2124 & 0xFF, 0x2124 & 0xFF},
	{0x2128 & 0xFF, 0x2129 & 0xFF},
	{0x212c & 0xFF, 0x212d & 0xFF},
	{0x212f & 0xFF, 0x2131 & 0xFF},
	{0x2133 & 0xFF, 0x2138 & 0xFF},
	{0x213c & 0xFF, 0x2149 & 0xFF},
	{0x214b & 0xFF, 0x214b & 0xFF},
	{0x2190 & 0xFF, 0x21a7 & 0xFF},
	{0x21a9 & 0xFF, 0x21ae & 0xFF},
	{0x21b0 & 0xFF, 0x21b1 & 0xFF},
	{0x21b6 & 0xFF, 0x21b7 & 0xFF},
	{0x21bc & 0xFF, 0x21db & 0xFF},
	{0x21dd & 0xFF, 0x21dd & 0xFF},
	{0x21e4 & 0xFF, 0x21e5 & 0xFF},
	{0x21f4 & 0xFF, 0x21ff & 0xFF},
	{0x2200 & 0xFF, 0x22ff & 0xFF},
	{0x2308 & 0xFF, 0x230b & 0xFF},
	{0x2320 & 0xFF, 0x2321 & 0xFF},
	{0x237c & 0xFF, 0x237c & 0xFF},
	{0x239b & 0xFF, 0x23b5 & 0xFF},
	{0x23b7 & 0xFF, 0x23b7 & 0xFF},
	{0x23d0 & 0xFF, 0x23d0 & 0xFF},
	{0x23dc & 0xFF, 0x23e2 & 0xFF},
	{0x25a0 & 0xFF, 0x25a1 & 0xFF},
	{0x25ae & 0xFF, 0x25b7 & 0xFF},
	{0x25bc & 0xFF, 0x25c1 & 0xFF},
	{0x25c6 & 0xFF, 0x25c7 & 0xFF},
	{0x25ca & 0xFF, 0x25cb & 0xFF},
	{0x25cf & 0xFF, 0x25d3 & 0xFF},
	{0x25e2 & 0xFF, 0x25e2 & 0xFF},
	{0x25e4 & 0xFF, 0x25e4 & 0xFF},
	{0x25e7 & 0xFF, 0x25ec & 0xFF},
	{0x25f8 & 0xFF, 0x25ff & 0xFF},
	{0x2605 & 0xFF, 0x2606 & 0xFF},
	{0x2640 & 0xFF, 0x2640 & 0xFF},
	{0x2642 & 0xFF, 0x2642 & 0xFF},
	{0x2660 & 0xFF, 0x2663 & 0xFF},
	{0x266d & 0xFF, 0x266f & 0xFF},
	{0x27c0 & 0xFF, 0x27ff & 0xFF},
	{0x2900 & 0xFF, 0x29ff & 0xFF},
	{0x2a00 & 0xFF, 0x2aff & 0xFF},
	{0x2b30 & 0xFF, 0x2b44 & 0xFF},
	{0x2b47 & 0xFF, 0x2b4c & 0xFF},
	{0xfb29 & 0xFF, 0xfb29 & 0xFF},
	{0xfe61 & 0xFF, 0xfe66 & 0xFF},
	{0xfe68 & 0xFF, 0xfe68 & 0xFF},
	{0xff0b & 0xFF, 0xff0b & 0xFF},
	{0xff1c & 0xFF, 0xff1e & 0xFF},
	{0xff3c & 0xFF, 0xff3c & 0xFF},
	{0xff3e & 0xFF, 0xff3e & 0xFF},
	{0xff5c & 0xFF, 0xff5c & 0xFF},
	{0xff5e & 0xFF, 0xff5e & 0xFF},
	{0xffe2 & 0xFF, 0xffe2 & 0xFF},
	{0xffe9 & 0xFF, 0xffec & 0xFF},
	{0x1d400 & 0xFF, 0x1d454 & 0xFF},
	{0x1d456 & 0xFF, 0x1d49c & 0xFF},
	{0x1d49e & 0xFF, 0x1d49f & 0xFF},
	{0x1d4a2 & 0xFF, 0x1d4a2 & 0xFF},
	{0x1d4a5 & 0xFF, 0x1d4a6 & 0xFF},
	{0x1d4a9 & 0xFF, 0x1d4ac & 0xFF},
	{0x1d4ae & 0xFF, 0x1d4b9 & 0xFF},
	{0x1d4bb & 0xFF, 0x1d4bb & 0xFF},
	{0x1d4bd & 0xFF, 0x1d4c3 & 0xFF},
	{0x1d4c5 & 0xFF, 0x1d4ff & 0xFF},
	{0x1d500 & 0xFF, 0x1d505 & 0xFF},
	{0x1d507 & 0xFF, 0x1d50a & 0xFF},
	{0x1d50d & 0xFF, 0x1d514 & 0xFF},
	{0x1d516 & 0xFF, 0x1d51c & 0xFF},
	{0x1d51e & 0xFF, 0x1d539 & 0xFF},
	{0x1d53b & 0xFF, 0x1d53e & 0xFF},
	{0x1d540 & 0xFF, 0x1d544 & 0xFF},
	{0x1d546 & 0xFF, 0x1d546 & 0xFF},
	{0x1d54a & 0xFF, 0x1d550 & 0xFF},
	{0x1d552 & 0xFF, 0x1d5ff & 0xFF},
	{0x1d600 & 0xFF, 0x1d6a5 & 0xFF},
	{0x1d6a8 & 0xFF, 0x1d6ff & 0xFF},
	{0x1d700 & 0xFF, 0x1d7cb & 0xFF},
	{0x1d7ce & 0xFF, 0x1d7ff & 0xFF},
	{0x1ee00 & 0xFF, 0x1ee03 & 0xFF},
	{0x1ee05 & 0xFF, 0x1ee1f & 0xFF},
	{0x1ee21 & 0xFF, 0x1ee22 & 0xFF},
	{0x1ee24 & 0xFF, 0x1ee24 & 0xFF},
	{0x1ee27 & 0xFF, 0x1ee27 & 0xFF},
	{0x1ee29 & 0xFF, 0x1ee32 & 0xFF},
	{0x1ee34 & 0xFF, 0x1ee37 & 0xFF},
	{0x1ee39 & 0xFF, 0x1ee39 & 0xFF},
	{0x1ee3b & 0xFF, 0x1ee3b & 0xFF},
	{0x1ee42 & 0xFF, 0x1ee42 & 0xFF},
	{0x1ee47 & 0xFF, 0x1ee47 & 0xFF},
	{0x1ee49 & 0xFF, 0x1ee49 & 0xFF},
	{0x1ee4b & 0xFF, 0x1ee4b & 0xFF},
	{0x1ee4d & 0xFF, 0x1ee4f & 0xFF},
	{0x1ee51 & 0xFF, 0x1ee52 & 0xFF},
	{0x1ee54 & 0xFF, 0x1ee54 & 0xFF},
	{0x1ee57 & 0xFF, 0x1ee57 & 0xFF},
	{0x1ee59 & 0xFF, 0x1ee59 & 0xFF},
	{0x1ee5b & 0xFF, 0x1ee5b & 0xFF},
	{0x1ee5d & 0xFF, 0x1ee5d & 0xFF},
	{0x1ee5f & 0xFF, 0x1ee5f & 0xFF},
	{0x1ee61 & 0xFF, 0x1ee62 & 0xFF},
	{0x1ee64 & 0xFF, 0x1ee64 & 0xFF},
	{0x1ee67 & 0xFF, 0x1ee6a & 0xFF},
	{0x1ee6c & 0xFF, 0x1ee72 & 0xFF},
	{0x1ee74 & 0xFF, 0x1ee77 & 0xFF},
	{0x1ee79 & 0xFF, 0x1ee7c & 0xFF},
	{0x1ee7e & 0xFF, 0x1ee7e & 0xFF},
	{0x1ee80 & 0xFF, 0x1ee89 & 0xFF},
	{0x1ee8b & 0xFF, 0x1ee9b & 0xFF},
	{0x1eea1 & 0xFF, 0x1eea3 & 0xFF},
	{0x1eea5 & 0xFF, 0x1eea9 & 0xFF},
	{0x1eeab & 0xFF, 0x1eebb & 0xFF},
	{0x1eef0 & 0xFF, 0x1eef1 & 0xFF}};

static const size_t Math_starting_indextab[]={
	0,
	3,
	6,
	32,
	33,
	34,
	35,
	37,
	38,
	39,
	41,
	42,
	43,
	251,
	254,
	255,
	468,
	469,
	470,
	471,
	494
};

static const char32_t Math_starting_pagetab[]={
	0,
	9,
	13,
	14,
	26,
	46,
	47,
	54,
	64,
	69,
	70,
	71,
	72,
	74,
	75,
	77,
	85,
	95,
	105,
	107,
	109
};

static const uint8_t Uppercase_rangetab[][2]={
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00de & 0xFF},
	{0x0100 & 0xFF, 0x0100 & 0xFF},
	{0x0102 & 0xFF, 0x0102 & 0xFF},
	{0x0104 & 0xFF, 0x0104 & 0xFF},
	{0x0106 & 0xFF, 0x0106 & 0xFF},
	{0x0108 & 0xFF, 0x0108 & 0xFF},
	{0x010a & 0xFF, 0x010a & 0xFF},
	{0x010c & 0xFF, 0x010c & 0xFF},
	{0x010e & 0xFF, 0x010e & 0xFF},
	{0x0110 & 0xFF, 0x0110 & 0xFF},
	{0x0112 & 0xFF, 0x0112 & 0xFF},
	{0x0114 & 0xFF, 0x0114 & 0xFF},
	{0x0116 & 0xFF, 0x0116 & 0xFF},
	{0x0118 & 0xFF, 0x0118 & 0xFF},
	{0x011a & 0xFF, 0x011a & 0xFF},
	{0x011c & 0xFF, 0x011c & 0xFF},
	{0x011e & 0xFF, 0x011e & 0xFF},
	{0x0120 & 0xFF, 0x0120 & 0xFF},
	{0x0122 & 0xFF, 0x0122 & 0xFF},
	{0x0124 & 0xFF, 0x0124 & 0xFF},
	{0x0126 & 0xFF, 0x0126 & 0xFF},
	{0x0128 & 0xFF, 0x0128 & 0xFF},
	{0x012a & 0xFF, 0x012a & 0xFF},
	{0x012c & 0xFF, 0x012c & 0xFF},
	{0x012e & 0xFF, 0x012e & 0xFF},
	{0x0130 & 0xFF, 0x0130 & 0xFF},
	{0x0132 & 0xFF, 0x0132 & 0xFF},
	{0x0134 & 0xFF, 0x0134 & 0xFF},
	{0x0136 & 0xFF, 0x0136 & 0xFF},
	{0x0139 & 0xFF, 0x0139 & 0xFF},
	{0x013b & 0xFF, 0x013b & 0xFF},
	{0x013d & 0xFF, 0x013d & 0xFF},
	{0x013f & 0xFF, 0x013f & 0xFF},
	{0x0141 & 0xFF, 0x0141 & 0xFF},
	{0x0143 & 0xFF, 0x0143 & 0xFF},
	{0x0145 & 0xFF, 0x0145 & 0xFF},
	{0x0147 & 0xFF, 0x0147 & 0xFF},
	{0x014a & 0xFF, 0x014a & 0xFF},
	{0x014c & 0xFF, 0x014c & 0xFF},
	{0x014e & 0xFF, 0x014e & 0xFF},
	{0x0150 & 0xFF, 0x0150 & 0xFF},
	{0x0152 & 0xFF, 0x0152 & 0xFF},
	{0x0154 & 0xFF, 0x0154 & 0xFF},
	{0x0156 & 0xFF, 0x0156 & 0xFF},
	{0x0158 & 0xFF, 0x0158 & 0xFF},
	{0x015a & 0xFF, 0x015a & 0xFF},
	{0x015c & 0xFF, 0x015c & 0xFF},
	{0x015e & 0xFF, 0x015e & 0xFF},
	{0x0160 & 0xFF, 0x0160 & 0xFF},
	{0x0162 & 0xFF, 0x0162 & 0xFF},
	{0x0164 & 0xFF, 0x0164 & 0xFF},
	{0x0166 & 0xFF, 0x0166 & 0xFF},
	{0x0168 & 0xFF, 0x0168 & 0xFF},
	{0x016a & 0xFF, 0x016a & 0xFF},
	{0x016c & 0xFF, 0x016c & 0xFF},
	{0x016e & 0xFF, 0x016e & 0xFF},
	{0x0170 & 0xFF, 0x0170 & 0xFF},
	{0x0172 & 0xFF, 0x0172 & 0xFF},
	{0x0174 & 0xFF, 0x0174 & 0xFF},
	{0x0176 & 0xFF, 0x0176 & 0xFF},
	{0x0178 & 0xFF, 0x0179 & 0xFF},
	{0x017b & 0xFF, 0x017b & 0xFF},
	{0x017d & 0xFF, 0x017d & 0xFF},
	{0x0181 & 0xFF, 0x0182 & 0xFF},
	{0x0184 & 0xFF, 0x0184 & 0xFF},
	{0x0186 & 0xFF, 0x0187 & 0xFF},
	{0x0189 & 0xFF, 0x018b & 0xFF},
	{0x018e & 0xFF, 0x0191 & 0xFF},
	{0x0193 & 0xFF, 0x0194 & 0xFF},
	{0x0196 & 0xFF, 0x0198 & 0xFF},
	{0x019c & 0xFF, 0x019d & 0xFF},
	{0x019f & 0xFF, 0x01a0 & 0xFF},
	{0x01a2 & 0xFF, 0x01a2 & 0xFF},
	{0x01a4 & 0xFF, 0x01a4 & 0xFF},
	{0x01a6 & 0xFF, 0x01a7 & 0xFF},
	{0x01a9 & 0xFF, 0x01a9 & 0xFF},
	{0x01ac & 0xFF, 0x01ac & 0xFF},
	{0x01ae & 0xFF, 0x01af & 0xFF},
	{0x01b1 & 0xFF, 0x01b3 & 0xFF},
	{0x01b5 & 0xFF, 0x01b5 & 0xFF},
	{0x01b7 & 0xFF, 0x01b8 & 0xFF},
	{0x01bc & 0xFF, 0x01bc & 0xFF},
	{0x01c4 & 0xFF, 0x01c4 & 0xFF},
	{0x01c7 & 0xFF, 0x01c7 & 0xFF},
	{0x01ca & 0xFF, 0x01ca & 0xFF},
	{0x01cd & 0xFF, 0x01cd & 0xFF},
	{0x01cf & 0xFF, 0x01cf & 0xFF},
	{0x01d1 & 0xFF, 0x01d1 & 0xFF},
	{0x01d3 & 0xFF, 0x01d3 & 0xFF},
	{0x01d5 & 0xFF, 0x01d5 & 0xFF},
	{0x01d7 & 0xFF, 0x01d7 & 0xFF},
	{0x01d9 & 0xFF, 0x01d9 & 0xFF},
	{0x01db & 0xFF, 0x01db & 0xFF},
	{0x01de & 0xFF, 0x01de & 0xFF},
	{0x01e0 & 0xFF, 0x01e0 & 0xFF},
	{0x01e2 & 0xFF, 0x01e2 & 0xFF},
	{0x01e4 & 0xFF, 0x01e4 & 0xFF},
	{0x01e6 & 0xFF, 0x01e6 & 0xFF},
	{0x01e8 & 0xFF, 0x01e8 & 0xFF},
	{0x01ea & 0xFF, 0x01ea & 0xFF},
	{0x01ec & 0xFF, 0x01ec & 0xFF},
	{0x01ee & 0xFF, 0x01ee & 0xFF},
	{0x01f1 & 0xFF, 0x01f1 & 0xFF},
	{0x01f4 & 0xFF, 0x01f4 & 0xFF},
	{0x01f6 & 0xFF, 0x01f8 & 0xFF},
	{0x01fa & 0xFF, 0x01fa & 0xFF},
	{0x01fc & 0xFF, 0x01fc & 0xFF},
	{0x01fe & 0xFF, 0x01fe & 0xFF},
	{0x0200 & 0xFF, 0x0200 & 0xFF},
	{0x0202 & 0xFF, 0x0202 & 0xFF},
	{0x0204 & 0xFF, 0x0204 & 0xFF},
	{0x0206 & 0xFF, 0x0206 & 0xFF},
	{0x0208 & 0xFF, 0x0208 & 0xFF},
	{0x020a & 0xFF, 0x020a & 0xFF},
	{0x020c & 0xFF, 0x020c & 0xFF},
	{0x020e & 0xFF, 0x020e & 0xFF},
	{0x0210 & 0xFF, 0x0210 & 0xFF},
	{0x0212 & 0xFF, 0x0212 & 0xFF},
	{0x0214 & 0xFF, 0x0214 & 0xFF},
	{0x0216 & 0xFF, 0x0216 & 0xFF},
	{0x0218 & 0xFF, 0x0218 & 0xFF},
	{0x021a & 0xFF, 0x021a & 0xFF},
	{0x021c & 0xFF, 0x021c & 0xFF},
	{0x021e & 0xFF, 0x021e & 0xFF},
	{0x0220 & 0xFF, 0x0220 & 0xFF},
	{0x0222 & 0xFF, 0x0222 & 0xFF},
	{0x0224 & 0xFF, 0x0224 & 0xFF},
	{0x0226 & 0xFF, 0x0226 & 0xFF},
	{0x0228 & 0xFF, 0x0228 & 0xFF},
	{0x022a & 0xFF, 0x022a & 0xFF},
	{0x022c & 0xFF, 0x022c & 0xFF},
	{0x022e & 0xFF, 0x022e & 0xFF},
	{0x0230 & 0xFF, 0x0230 & 0xFF},
	{0x0232 & 0xFF, 0x0232 & 0xFF},
	{0x023a & 0xFF, 0x023b & 0xFF},
	{0x023d & 0xFF, 0x023e & 0xFF},
	{0x0241 & 0xFF, 0x0241 & 0xFF},
	{0x0243 & 0xFF, 0x0246 & 0xFF},
	{0x0248 & 0xFF, 0x0248 & 0xFF},
	{0x024a & 0xFF, 0x024a & 0xFF},
	{0x024c & 0xFF, 0x024c & 0xFF},
	{0x024e & 0xFF, 0x024e & 0xFF},
	{0x0370 & 0xFF, 0x0370 & 0xFF},
	{0x0372 & 0xFF, 0x0372 & 0xFF},
	{0x0376 & 0xFF, 0x0376 & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x0386 & 0xFF},
	{0x0388 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x038f & 0xFF},
	{0x0391 & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03ab & 0xFF},
	{0x03cf & 0xFF, 0x03cf & 0xFF},
	{0x03d2 & 0xFF, 0x03d4 & 0xFF},
	{0x03d8 & 0xFF, 0x03d8 & 0xFF},
	{0x03da & 0xFF, 0x03da & 0xFF},
	{0x03dc & 0xFF, 0x03dc & 0xFF},
	{0x03de & 0xFF, 0x03de & 0xFF},
	{0x03e0 & 0xFF, 0x03e0 & 0xFF},
	{0x03e2 & 0xFF, 0x03e2 & 0xFF},
	{0x03e4 & 0xFF, 0x03e4 & 0xFF},
	{0x03e6 & 0xFF, 0x03e6 & 0xFF},
	{0x03e8 & 0xFF, 0x03e8 & 0xFF},
	{0x03ea & 0xFF, 0x03ea & 0xFF},
	{0x03ec & 0xFF, 0x03ec & 0xFF},
	{0x03ee & 0xFF, 0x03ee & 0xFF},
	{0x03f4 & 0xFF, 0x03f4 & 0xFF},
	{0x03f7 & 0xFF, 0x03f7 & 0xFF},
	{0x03f9 & 0xFF, 0x03fa & 0xFF},
	{0x03fd & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x042f & 0xFF},
	{0x0460 & 0xFF, 0x0460 & 0xFF},
	{0x0462 & 0xFF, 0x0462 & 0xFF},
	{0x0464 & 0xFF, 0x0464 & 0xFF},
	{0x0466 & 0xFF, 0x0466 & 0xFF},
	{0x0468 & 0xFF, 0x0468 & 0xFF},
	{0x046a & 0xFF, 0x046a & 0xFF},
	{0x046c & 0xFF, 0x046c & 0xFF},
	{0x046e & 0xFF, 0x046e & 0xFF},
	{0x0470 & 0xFF, 0x0470 & 0xFF},
	{0x0472 & 0xFF, 0x0472 & 0xFF},
	{0x0474 & 0xFF, 0x0474 & 0xFF},
	{0x0476 & 0xFF, 0x0476 & 0xFF},
	{0x0478 & 0xFF, 0x0478 & 0xFF},
	{0x047a & 0xFF, 0x047a & 0xFF},
	{0x047c & 0xFF, 0x047c & 0xFF},
	{0x047e & 0xFF, 0x047e & 0xFF},
	{0x0480 & 0xFF, 0x0480 & 0xFF},
	{0x048a & 0xFF, 0x048a & 0xFF},
	{0x048c & 0xFF, 0x048c & 0xFF},
	{0x048e & 0xFF, 0x048e & 0xFF},
	{0x0490 & 0xFF, 0x0490 & 0xFF},
	{0x0492 & 0xFF, 0x0492 & 0xFF},
	{0x0494 & 0xFF, 0x0494 & 0xFF},
	{0x0496 & 0xFF, 0x0496 & 0xFF},
	{0x0498 & 0xFF, 0x0498 & 0xFF},
	{0x049a & 0xFF, 0x049a & 0xFF},
	{0x049c & 0xFF, 0x049c & 0xFF},
	{0x049e & 0xFF, 0x049e & 0xFF},
	{0x04a0 & 0xFF, 0x04a0 & 0xFF},
	{0x04a2 & 0xFF, 0x04a2 & 0xFF},
	{0x04a4 & 0xFF, 0x04a4 & 0xFF},
	{0x04a6 & 0xFF, 0x04a6 & 0xFF},
	{0x04a8 & 0xFF, 0x04a8 & 0xFF},
	{0x04aa & 0xFF, 0x04aa & 0xFF},
	{0x04ac & 0xFF, 0x04ac & 0xFF},
	{0x04ae & 0xFF, 0x04ae & 0xFF},
	{0x04b0 & 0xFF, 0x04b0 & 0xFF},
	{0x04b2 & 0xFF, 0x04b2 & 0xFF},
	{0x04b4 & 0xFF, 0x04b4 & 0xFF},
	{0x04b6 & 0xFF, 0x04b6 & 0xFF},
	{0x04b8 & 0xFF, 0x04b8 & 0xFF},
	{0x04ba & 0xFF, 0x04ba & 0xFF},
	{0x04bc & 0xFF, 0x04bc & 0xFF},
	{0x04be & 0xFF, 0x04be & 0xFF},
	{0x04c0 & 0xFF, 0x04c1 & 0xFF},
	{0x04c3 & 0xFF, 0x04c3 & 0xFF},
	{0x04c5 & 0xFF, 0x04c5 & 0xFF},
	{0x04c7 & 0xFF, 0x04c7 & 0xFF},
	{0x04c9 & 0xFF, 0x04c9 & 0xFF},
	{0x04cb & 0xFF, 0x04cb & 0xFF},
	{0x04cd & 0xFF, 0x04cd & 0xFF},
	{0x04d0 & 0xFF, 0x04d0 & 0xFF},
	{0x04d2 & 0xFF, 0x04d2 & 0xFF},
	{0x04d4 & 0xFF, 0x04d4 & 0xFF},
	{0x04d6 & 0xFF, 0x04d6 & 0xFF},
	{0x04d8 & 0xFF, 0x04d8 & 0xFF},
	{0x04da & 0xFF, 0x04da & 0xFF},
	{0x04dc & 0xFF, 0x04dc & 0xFF},
	{0x04de & 0xFF, 0x04de & 0xFF},
	{0x04e0 & 0xFF, 0x04e0 & 0xFF},
	{0x04e2 & 0xFF, 0x04e2 & 0xFF},
	{0x04e4 & 0xFF, 0x04e4 & 0xFF},
	{0x04e6 & 0xFF, 0x04e6 & 0xFF},
	{0x04e8 & 0xFF, 0x04e8 & 0xFF},
	{0x04ea & 0xFF, 0x04ea & 0xFF},
	{0x04ec & 0xFF, 0x04ec & 0xFF},
	{0x04ee & 0xFF, 0x04ee & 0xFF},
	{0x04f0 & 0xFF, 0x04f0 & 0xFF},
	{0x04f2 & 0xFF, 0x04f2 & 0xFF},
	{0x04f4 & 0xFF, 0x04f4 & 0xFF},
	{0x04f6 & 0xFF, 0x04f6 & 0xFF},
	{0x04f8 & 0xFF, 0x04f8 & 0xFF},
	{0x04fa & 0xFF, 0x04fa & 0xFF},
	{0x04fc & 0xFF, 0x04fc & 0xFF},
	{0x04fe & 0xFF, 0x04fe & 0xFF},
	{0x0500 & 0xFF, 0x0500 & 0xFF},
	{0x0502 & 0xFF, 0x0502 & 0xFF},
	{0x0504 & 0xFF, 0x0504 & 0xFF},
	{0x0506 & 0xFF, 0x0506 & 0xFF},
	{0x0508 & 0xFF, 0x0508 & 0xFF},
	{0x050a & 0xFF, 0x050a & 0xFF},
	{0x050c & 0xFF, 0x050c & 0xFF},
	{0x050e & 0xFF, 0x050e & 0xFF},
	{0x0510 & 0xFF, 0x0510 & 0xFF},
	{0x0512 & 0xFF, 0x0512 & 0xFF},
	{0x0514 & 0xFF, 0x0514 & 0xFF},
	{0x0516 & 0xFF, 0x0516 & 0xFF},
	{0x0518 & 0xFF, 0x0518 & 0xFF},
	{0x051a & 0xFF, 0x051a & 0xFF},
	{0x051c & 0xFF, 0x051c & 0xFF},
	{0x051e & 0xFF, 0x051e & 0xFF},
	{0x0520 & 0xFF, 0x0520 & 0xFF},
	{0x0522 & 0xFF, 0x0522 & 0xFF},
	{0x0524 & 0xFF, 0x0524 & 0xFF},
	{0x0526 & 0xFF, 0x0526 & 0xFF},
	{0x0528 & 0xFF, 0x0528 & 0xFF},
	{0x052a & 0xFF, 0x052a & 0xFF},
	{0x052c & 0xFF, 0x052c & 0xFF},
	{0x052e & 0xFF, 0x052e & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1e00 & 0xFF, 0x1e00 & 0xFF},
	{0x1e02 & 0xFF, 0x1e02 & 0xFF},
	{0x1e04 & 0xFF, 0x1e04 & 0xFF},
	{0x1e06 & 0xFF, 0x1e06 & 0xFF},
	{0x1e08 & 0xFF, 0x1e08 & 0xFF},
	{0x1e0a & 0xFF, 0x1e0a & 0xFF},
	{0x1e0c & 0xFF, 0x1e0c & 0xFF},
	{0x1e0e & 0xFF, 0x1e0e & 0xFF},
	{0x1e10 & 0xFF, 0x1e10 & 0xFF},
	{0x1e12 & 0xFF, 0x1e12 & 0xFF},
	{0x1e14 & 0xFF, 0x1e14 & 0xFF},
	{0x1e16 & 0xFF, 0x1e16 & 0xFF},
	{0x1e18 & 0xFF, 0x1e18 & 0xFF},
	{0x1e1a & 0xFF, 0x1e1a & 0xFF},
	{0x1e1c & 0xFF, 0x1e1c & 0xFF},
	{0x1e1e & 0xFF, 0x1e1e & 0xFF},
	{0x1e20 & 0xFF, 0x1e20 & 0xFF},
	{0x1e22 & 0xFF, 0x1e22 & 0xFF},
	{0x1e24 & 0xFF, 0x1e24 & 0xFF},
	{0x1e26 & 0xFF, 0x1e26 & 0xFF},
	{0x1e28 & 0xFF, 0x1e28 & 0xFF},
	{0x1e2a & 0xFF, 0x1e2a & 0xFF},
	{0x1e2c & 0xFF, 0x1e2c & 0xFF},
	{0x1e2e & 0xFF, 0x1e2e & 0xFF},
	{0x1e30 & 0xFF, 0x1e30 & 0xFF},
	{0x1e32 & 0xFF, 0x1e32 & 0xFF},
	{0x1e34 & 0xFF, 0x1e34 & 0xFF},
	{0x1e36 & 0xFF, 0x1e36 & 0xFF},
	{0x1e38 & 0xFF, 0x1e38 & 0xFF},
	{0x1e3a & 0xFF, 0x1e3a & 0xFF},
	{0x1e3c & 0xFF, 0x1e3c & 0xFF},
	{0x1e3e & 0xFF, 0x1e3e & 0xFF},
	{0x1e40 & 0xFF, 0x1e40 & 0xFF},
	{0x1e42 & 0xFF, 0x1e42 & 0xFF},
	{0x1e44 & 0xFF, 0x1e44 & 0xFF},
	{0x1e46 & 0xFF, 0x1e46 & 0xFF},
	{0x1e48 & 0xFF, 0x1e48 & 0xFF},
	{0x1e4a & 0xFF, 0x1e4a & 0xFF},
	{0x1e4c & 0xFF, 0x1e4c & 0xFF},
	{0x1e4e & 0xFF, 0x1e4e & 0xFF},
	{0x1e50 & 0xFF, 0x1e50 & 0xFF},
	{0x1e52 & 0xFF, 0x1e52 & 0xFF},
	{0x1e54 & 0xFF, 0x1e54 & 0xFF},
	{0x1e56 & 0xFF, 0x1e56 & 0xFF},
	{0x1e58 & 0xFF, 0x1e58 & 0xFF},
	{0x1e5a & 0xFF, 0x1e5a & 0xFF},
	{0x1e5c & 0xFF, 0x1e5c & 0xFF},
	{0x1e5e & 0xFF, 0x1e5e & 0xFF},
	{0x1e60 & 0xFF, 0x1e60 & 0xFF},
	{0x1e62 & 0xFF, 0x1e62 & 0xFF},
	{0x1e64 & 0xFF, 0x1e64 & 0xFF},
	{0x1e66 & 0xFF, 0x1e66 & 0xFF},
	{0x1e68 & 0xFF, 0x1e68 & 0xFF},
	{0x1e6a & 0xFF, 0x1e6a & 0xFF},
	{0x1e6c & 0xFF, 0x1e6c & 0xFF},
	{0x1e6e & 0xFF, 0x1e6e & 0xFF},
	{0x1e70 & 0xFF, 0x1e70 & 0xFF},
	{0x1e72 & 0xFF, 0x1e72 & 0xFF},
	{0x1e74 & 0xFF, 0x1e74 & 0xFF},
	{0x1e76 & 0xFF, 0x1e76 & 0xFF},
	{0x1e78 & 0xFF, 0x1e78 & 0xFF},
	{0x1e7a & 0xFF, 0x1e7a & 0xFF},
	{0x1e7c & 0xFF, 0x1e7c & 0xFF},
	{0x1e7e & 0xFF, 0x1e7e & 0xFF},
	{0x1e80 & 0xFF, 0x1e80 & 0xFF},
	{0x1e82 & 0xFF, 0x1e82 & 0xFF},
	{0x1e84 & 0xFF, 0x1e84 & 0xFF},
	{0x1e86 & 0xFF, 0x1e86 & 0xFF},
	{0x1e88 & 0xFF, 0x1e88 & 0xFF},
	{0x1e8a & 0xFF, 0x1e8a & 0xFF},
	{0x1e8c & 0xFF, 0x1e8c & 0xFF},
	{0x1e8e & 0xFF, 0x1e8e & 0xFF},
	{0x1e90 & 0xFF, 0x1e90 & 0xFF},
	{0x1e92 & 0xFF, 0x1e92 & 0xFF},
	{0x1e94 & 0xFF, 0x1e94 & 0xFF},
	{0x1e9e & 0xFF, 0x1e9e & 0xFF},
	{0x1ea0 & 0xFF, 0x1ea0 & 0xFF},
	{0x1ea2 & 0xFF, 0x1ea2 & 0xFF},
	{0x1ea4 & 0xFF, 0x1ea4 & 0xFF},
	{0x1ea6 & 0xFF, 0x1ea6 & 0xFF},
	{0x1ea8 & 0xFF, 0x1ea8 & 0xFF},
	{0x1eaa & 0xFF, 0x1eaa & 0xFF},
	{0x1eac & 0xFF, 0x1eac & 0xFF},
	{0x1eae & 0xFF, 0x1eae & 0xFF},
	{0x1eb0 & 0xFF, 0x1eb0 & 0xFF},
	{0x1eb2 & 0xFF, 0x1eb2 & 0xFF},
	{0x1eb4 & 0xFF, 0x1eb4 & 0xFF},
	{0x1eb6 & 0xFF, 0x1eb6 & 0xFF},
	{0x1eb8 & 0xFF, 0x1eb8 & 0xFF},
	{0x1eba & 0xFF, 0x1eba & 0xFF},
	{0x1ebc & 0xFF, 0x1ebc & 0xFF},
	{0x1ebe & 0xFF, 0x1ebe & 0xFF},
	{0x1ec0 & 0xFF, 0x1ec0 & 0xFF},
	{0x1ec2 & 0xFF, 0x1ec2 & 0xFF},
	{0x1ec4 & 0xFF, 0x1ec4 & 0xFF},
	{0x1ec6 & 0xFF, 0x1ec6 & 0xFF},
	{0x1ec8 & 0xFF, 0x1ec8 & 0xFF},
	{0x1eca & 0xFF, 0x1eca & 0xFF},
	{0x1ecc & 0xFF, 0x1ecc & 0xFF},
	{0x1ece & 0xFF, 0x1ece & 0xFF},
	{0x1ed0 & 0xFF, 0x1ed0 & 0xFF},
	{0x1ed2 & 0xFF, 0x1ed2 & 0xFF},
	{0x1ed4 & 0xFF, 0x1ed4 & 0xFF},
	{0x1ed6 & 0xFF, 0x1ed6 & 0xFF},
	{0x1ed8 & 0xFF, 0x1ed8 & 0xFF},
	{0x1eda & 0xFF, 0x1eda & 0xFF},
	{0x1edc & 0xFF, 0x1edc & 0xFF},
	{0x1ede & 0xFF, 0x1ede & 0xFF},
	{0x1ee0 & 0xFF, 0x1ee0 & 0xFF},
	{0x1ee2 & 0xFF, 0x1ee2 & 0xFF},
	{0x1ee4 & 0xFF, 0x1ee4 & 0xFF},
	{0x1ee6 & 0xFF, 0x1ee6 & 0xFF},
	{0x1ee8 & 0xFF, 0x1ee8 & 0xFF},
	{0x1eea & 0xFF, 0x1eea & 0xFF},
	{0x1eec & 0xFF, 0x1eec & 0xFF},
	{0x1eee & 0xFF, 0x1eee & 0xFF},
	{0x1ef0 & 0xFF, 0x1ef0 & 0xFF},
	{0x1ef2 & 0xFF, 0x1ef2 & 0xFF},
	{0x1ef4 & 0xFF, 0x1ef4 & 0xFF},
	{0x1ef6 & 0xFF, 0x1ef6 & 0xFF},
	{0x1ef8 & 0xFF, 0x1ef8 & 0xFF},
	{0x1efa & 0xFF, 0x1efa & 0xFF},
	{0x1efc & 0xFF, 0x1efc & 0xFF},
	{0x1efe & 0xFF, 0x1efe & 0xFF},
	{0x1f08 & 0xFF, 0x1f0f & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f28 & 0xFF, 0x1f2f & 0xFF},
	{0x1f38 & 0xFF, 0x1f3f & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f5f & 0xFF},
	{0x1f68 & 0xFF, 0x1f6f & 0xFF},
	{0x1fb8 & 0xFF, 0x1fbb & 0xFF},
	{0x1fc8 & 0xFF, 0x1fcb & 0xFF},
	{0x1fd8 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe8 & 0xFF, 0x1fec & 0xFF},
	{0x1ff8 & 0xFF, 0x1ffb & 0xFF},
	{0x2102 & 0xFF, 0x2102 & 0xFF},
	{0x2107 & 0xFF, 0x2107 & 0xFF},
	{0x210b & 0xFF, 0x210d & 0xFF},
	{0x2110 & 0xFF, 0x2112 & 0xFF},
	{0x2115 & 0xFF, 0x2115 & 0xFF},
	{0x2119 & 0xFF, 0x211d & 0xFF},
	{0x2124 & 0xFF, 0x2124 & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x2128 & 0xFF, 0x2128 & 0xFF},
	{0x212a & 0xFF, 0x212d & 0xFF},
	{0x2130 & 0xFF, 0x2133 & 0xFF},
	{0x213e & 0xFF, 0x213f & 0xFF},
	{0x2145 & 0xFF, 0x2145 & 0xFF},
	{0x2160 & 0xFF, 0x216f & 0xFF},
	{0x2183 & 0xFF, 0x2183 & 0xFF},
	{0x24b6 & 0xFF, 0x24cf & 0xFF},
	{0x2c00 & 0xFF, 0x2c2f & 0xFF},
	{0x2c60 & 0xFF, 0x2c60 & 0xFF},
	{0x2c62 & 0xFF, 0x2c64 & 0xFF},
	{0x2c67 & 0xFF, 0x2c67 & 0xFF},
	{0x2c69 & 0xFF, 0x2c69 & 0xFF},
	{0x2c6b & 0xFF, 0x2c6b & 0xFF},
	{0x2c6d & 0xFF, 0x2c70 & 0xFF},
	{0x2c72 & 0xFF, 0x2c72 & 0xFF},
	{0x2c75 & 0xFF, 0x2c75 & 0xFF},
	{0x2c7e & 0xFF, 0x2c80 & 0xFF},
	{0x2c82 & 0xFF, 0x2c82 & 0xFF},
	{0x2c84 & 0xFF, 0x2c84 & 0xFF},
	{0x2c86 & 0xFF, 0x2c86 & 0xFF},
	{0x2c88 & 0xFF, 0x2c88 & 0xFF},
	{0x2c8a & 0xFF, 0x2c8a & 0xFF},
	{0x2c8c & 0xFF, 0x2c8c & 0xFF},
	{0x2c8e & 0xFF, 0x2c8e & 0xFF},
	{0x2c90 & 0xFF, 0x2c90 & 0xFF},
	{0x2c92 & 0xFF, 0x2c92 & 0xFF},
	{0x2c94 & 0xFF, 0x2c94 & 0xFF},
	{0x2c96 & 0xFF, 0x2c96 & 0xFF},
	{0x2c98 & 0xFF, 0x2c98 & 0xFF},
	{0x2c9a & 0xFF, 0x2c9a & 0xFF},
	{0x2c9c & 0xFF, 0x2c9c & 0xFF},
	{0x2c9e & 0xFF, 0x2c9e & 0xFF},
	{0x2ca0 & 0xFF, 0x2ca0 & 0xFF},
	{0x2ca2 & 0xFF, 0x2ca2 & 0xFF},
	{0x2ca4 & 0xFF, 0x2ca4 & 0xFF},
	{0x2ca6 & 0xFF, 0x2ca6 & 0xFF},
	{0x2ca8 & 0xFF, 0x2ca8 & 0xFF},
	{0x2caa & 0xFF, 0x2caa & 0xFF},
	{0x2cac & 0xFF, 0x2cac & 0xFF},
	{0x2cae & 0xFF, 0x2cae & 0xFF},
	{0x2cb0 & 0xFF, 0x2cb0 & 0xFF},
	{0x2cb2 & 0xFF, 0x2cb2 & 0xFF},
	{0x2cb4 & 0xFF, 0x2cb4 & 0xFF},
	{0x2cb6 & 0xFF, 0x2cb6 & 0xFF},
	{0x2cb8 & 0xFF, 0x2cb8 & 0xFF},
	{0x2cba & 0xFF, 0x2cba & 0xFF},
	{0x2cbc & 0xFF, 0x2cbc & 0xFF},
	{0x2cbe & 0xFF, 0x2cbe & 0xFF},
	{0x2cc0 & 0xFF, 0x2cc0 & 0xFF},
	{0x2cc2 & 0xFF, 0x2cc2 & 0xFF},
	{0x2cc4 & 0xFF, 0x2cc4 & 0xFF},
	{0x2cc6 & 0xFF, 0x2cc6 & 0xFF},
	{0x2cc8 & 0xFF, 0x2cc8 & 0xFF},
	{0x2cca & 0xFF, 0x2cca & 0xFF},
	{0x2ccc & 0xFF, 0x2ccc & 0xFF},
	{0x2cce & 0xFF, 0x2cce & 0xFF},
	{0x2cd0 & 0xFF, 0x2cd0 & 0xFF},
	{0x2cd2 & 0xFF, 0x2cd2 & 0xFF},
	{0x2cd4 & 0xFF, 0x2cd4 & 0xFF},
	{0x2cd6 & 0xFF, 0x2cd6 & 0xFF},
	{0x2cd8 & 0xFF, 0x2cd8 & 0xFF},
	{0x2cda & 0xFF, 0x2cda & 0xFF},
	{0x2cdc & 0xFF, 0x2cdc & 0xFF},
	{0x2cde & 0xFF, 0x2cde & 0xFF},
	{0x2ce0 & 0xFF, 0x2ce0 & 0xFF},
	{0x2ce2 & 0xFF, 0x2ce2 & 0xFF},
	{0x2ceb & 0xFF, 0x2ceb & 0xFF},
	{0x2ced & 0xFF, 0x2ced & 0xFF},
	{0x2cf2 & 0xFF, 0x2cf2 & 0xFF},
	{0xa640 & 0xFF, 0xa640 & 0xFF},
	{0xa642 & 0xFF, 0xa642 & 0xFF},
	{0xa644 & 0xFF, 0xa644 & 0xFF},
	{0xa646 & 0xFF, 0xa646 & 0xFF},
	{0xa648 & 0xFF, 0xa648 & 0xFF},
	{0xa64a & 0xFF, 0xa64a & 0xFF},
	{0xa64c & 0xFF, 0xa64c & 0xFF},
	{0xa64e & 0xFF, 0xa64e & 0xFF},
	{0xa650 & 0xFF, 0xa650 & 0xFF},
	{0xa652 & 0xFF, 0xa652 & 0xFF},
	{0xa654 & 0xFF, 0xa654 & 0xFF},
	{0xa656 & 0xFF, 0xa656 & 0xFF},
	{0xa658 & 0xFF, 0xa658 & 0xFF},
	{0xa65a & 0xFF, 0xa65a & 0xFF},
	{0xa65c & 0xFF, 0xa65c & 0xFF},
	{0xa65e & 0xFF, 0xa65e & 0xFF},
	{0xa660 & 0xFF, 0xa660 & 0xFF},
	{0xa662 & 0xFF, 0xa662 & 0xFF},
	{0xa664 & 0xFF, 0xa664 & 0xFF},
	{0xa666 & 0xFF, 0xa666 & 0xFF},
	{0xa668 & 0xFF, 0xa668 & 0xFF},
	{0xa66a & 0xFF, 0xa66a & 0xFF},
	{0xa66c & 0xFF, 0xa66c & 0xFF},
	{0xa680 & 0xFF, 0xa680 & 0xFF},
	{0xa682 & 0xFF, 0xa682 & 0xFF},
	{0xa684 & 0xFF, 0xa684 & 0xFF},
	{0xa686 & 0xFF, 0xa686 & 0xFF},
	{0xa688 & 0xFF, 0xa688 & 0xFF},
	{0xa68a & 0xFF, 0xa68a & 0xFF},
	{0xa68c & 0xFF, 0xa68c & 0xFF},
	{0xa68e & 0xFF, 0xa68e & 0xFF},
	{0xa690 & 0xFF, 0xa690 & 0xFF},
	{0xa692 & 0xFF, 0xa692 & 0xFF},
	{0xa694 & 0xFF, 0xa694 & 0xFF},
	{0xa696 & 0xFF, 0xa696 & 0xFF},
	{0xa698 & 0xFF, 0xa698 & 0xFF},
	{0xa69a & 0xFF, 0xa69a & 0xFF},
	{0xa722 & 0xFF, 0xa722 & 0xFF},
	{0xa724 & 0xFF, 0xa724 & 0xFF},
	{0xa726 & 0xFF, 0xa726 & 0xFF},
	{0xa728 & 0xFF, 0xa728 & 0xFF},
	{0xa72a & 0xFF, 0xa72a & 0xFF},
	{0xa72c & 0xFF, 0xa72c & 0xFF},
	{0xa72e & 0xFF, 0xa72e & 0xFF},
	{0xa732 & 0xFF, 0xa732 & 0xFF},
	{0xa734 & 0xFF, 0xa734 & 0xFF},
	{0xa736 & 0xFF, 0xa736 & 0xFF},
	{0xa738 & 0xFF, 0xa738 & 0xFF},
	{0xa73a & 0xFF, 0xa73a & 0xFF},
	{0xa73c & 0xFF, 0xa73c & 0xFF},
	{0xa73e & 0xFF, 0xa73e & 0xFF},
	{0xa740 & 0xFF, 0xa740 & 0xFF},
	{0xa742 & 0xFF, 0xa742 & 0xFF},
	{0xa744 & 0xFF, 0xa744 & 0xFF},
	{0xa746 & 0xFF, 0xa746 & 0xFF},
	{0xa748 & 0xFF, 0xa748 & 0xFF},
	{0xa74a & 0xFF, 0xa74a & 0xFF},
	{0xa74c & 0xFF, 0xa74c & 0xFF},
	{0xa74e & 0xFF, 0xa74e & 0xFF},
	{0xa750 & 0xFF, 0xa750 & 0xFF},
	{0xa752 & 0xFF, 0xa752 & 0xFF},
	{0xa754 & 0xFF, 0xa754 & 0xFF},
	{0xa756 & 0xFF, 0xa756 & 0xFF},
	{0xa758 & 0xFF, 0xa758 & 0xFF},
	{0xa75a & 0xFF, 0xa75a & 0xFF},
	{0xa75c & 0xFF, 0xa75c & 0xFF},
	{0xa75e & 0xFF, 0xa75e & 0xFF},
	{0xa760 & 0xFF, 0xa760 & 0xFF},
	{0xa762 & 0xFF, 0xa762 & 0xFF},
	{0xa764 & 0xFF, 0xa764 & 0xFF},
	{0xa766 & 0xFF, 0xa766 & 0xFF},
	{0xa768 & 0xFF, 0xa768 & 0xFF},
	{0xa76a & 0xFF, 0xa76a & 0xFF},
	{0xa76c & 0xFF, 0xa76c & 0xFF},
	{0xa76e & 0xFF, 0xa76e & 0xFF},
	{0xa779 & 0xFF, 0xa779 & 0xFF},
	{0xa77b & 0xFF, 0xa77b & 0xFF},
	{0xa77d & 0xFF, 0xa77e & 0xFF},
	{0xa780 & 0xFF, 0xa780 & 0xFF},
	{0xa782 & 0xFF, 0xa782 & 0xFF},
	{0xa784 & 0xFF, 0xa784 & 0xFF},
	{0xa786 & 0xFF, 0xa786 & 0xFF},
	{0xa78b & 0xFF, 0xa78b & 0xFF},
	{0xa78d & 0xFF, 0xa78d & 0xFF},
	{0xa790 & 0xFF, 0xa790 & 0xFF},
	{0xa792 & 0xFF, 0xa792 & 0xFF},
	{0xa796 & 0xFF, 0xa796 & 0xFF},
	{0xa798 & 0xFF, 0xa798 & 0xFF},
	{0xa79a & 0xFF, 0xa79a & 0xFF},
	{0xa79c & 0xFF, 0xa79c & 0xFF},
	{0xa79e & 0xFF, 0xa79e & 0xFF},
	{0xa7a0 & 0xFF, 0xa7a0 & 0xFF},
	{0xa7a2 & 0xFF, 0xa7a2 & 0xFF},
	{0xa7a4 & 0xFF, 0xa7a4 & 0xFF},
	{0xa7a6 & 0xFF, 0xa7a6 & 0xFF},
	{0xa7a8 & 0xFF, 0xa7a8 & 0xFF},
	{0xa7aa & 0xFF, 0xa7ae & 0xFF},
	{0xa7b0 & 0xFF, 0xa7b4 & 0xFF},
	{0xa7b6 & 0xFF, 0xa7b6 & 0xFF},
	{0xa7b8 & 0xFF, 0xa7b8 & 0xFF},
	{0xa7ba & 0xFF, 0xa7ba & 0xFF},
	{0xa7bc & 0xFF, 0xa7bc & 0xFF},
	{0xa7be & 0xFF, 0xa7be & 0xFF},
	{0xa7c0 & 0xFF, 0xa7c0 & 0xFF},
	{0xa7c2 & 0xFF, 0xa7c2 & 0xFF},
	{0xa7c4 & 0xFF, 0xa7c7 & 0xFF},
	{0xa7c9 & 0xFF, 0xa7c9 & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d0 & 0xFF},
	{0xa7d6 & 0xFF, 0xa7d6 & 0xFF},
	{0xa7d8 & 0xFF, 0xa7d8 & 0xFF},
	{0xa7f5 & 0xFF, 0xa7f5 & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0x10400 & 0xFF, 0x10427 & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x118a0 & 0xFF, 0x118bf & 0xFF},
	{0x16e40 & 0xFF, 0x16e5f & 0xFF},
	{0x1d400 & 0xFF, 0x1d419 & 0xFF},
	{0x1d434 & 0xFF, 0x1d44d & 0xFF},
	{0x1d468 & 0xFF, 0x1d481 & 0xFF},
	{0x1d49c & 0xFF, 0x1d49c & 0xFF},
	{0x1d49e & 0xFF, 0x1d49f & 0xFF},
	{0x1d4a2 & 0xFF, 0x1d4a2 & 0xFF},
	{0x1d4a5 & 0xFF, 0x1d4a6 & 0xFF},
	{0x1d4a9 & 0xFF, 0x1d4ac & 0xFF},
	{0x1d4ae & 0xFF, 0x1d4b5 & 0xFF},
	{0x1d4d0 & 0xFF, 0x1d4e9 & 0xFF},
	{0x1d504 & 0xFF, 0x1d505 & 0xFF},
	{0x1d507 & 0xFF, 0x1d50a & 0xFF},
	{0x1d50d & 0xFF, 0x1d514 & 0xFF},
	{0x1d516 & 0xFF, 0x1d51c & 0xFF},
	{0x1d538 & 0xFF, 0x1d539 & 0xFF},
	{0x1d53b & 0xFF, 0x1d53e & 0xFF},
	{0x1d540 & 0xFF, 0x1d544 & 0xFF},
	{0x1d546 & 0xFF, 0x1d546 & 0xFF},
	{0x1d54a & 0xFF, 0x1d550 & 0xFF},
	{0x1d56c & 0xFF, 0x1d585 & 0xFF},
	{0x1d5a0 & 0xFF, 0x1d5b9 & 0xFF},
	{0x1d5d4 & 0xFF, 0x1d5ed & 0xFF},
	{0x1d608 & 0xFF, 0x1d621 & 0xFF},
	{0x1d63c & 0xFF, 0x1d655 & 0xFF},
	{0x1d670 & 0xFF, 0x1d689 & 0xFF},
	{0x1d6a8 & 0xFF, 0x1d6c0 & 0xFF},
	{0x1d6e2 & 0xFF, 0x1d6fa & 0xFF},
	{0x1d71c & 0xFF, 0x1d734 & 0xFF},
	{0x1d756 & 0xFF, 0x1d76e & 0xFF},
	{0x1d790 & 0xFF, 0x1d7a8 & 0xFF},
	{0x1d7ca & 0xFF, 0x1d7ca & 0xFF},
	{0x1e900 & 0xFF, 0x1e921 & 0xFF},
	{0x1f130 & 0xFF, 0x1f149 & 0xFF},
	{0x1f150 & 0xFF, 0x1f169 & 0xFF},
	{0x1f170 & 0xFF, 0x1f189 & 0xFF}};

static const size_t Uppercase_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	16,
	19,
	28,
	30,
	31,
	33,
	36,
	44,
	166,
	167,
	255,
	260,
	261,
	268,
	280,
	366,
	468,
	469,
	470,
	471,
	489,
	497
};

static const char32_t Uppercase_starting_pagetab[]={
	0,
	3,
	110,
	144,
	172,
	248,
	273,
	276,
	277,
	279,
	403,
	418,
	433,
	434,
	496,
	533,
	607,
	608,
	610,
	614,
	615,
	616,
	617,
	627,
	639,
	644,
	648,
	649
};

static const uint8_t XID_Continue_rangetab[][2]={
	{0x0030 & 0xFF, 0x0039 & 0xFF},
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x005f & 0xFF, 0x005f & 0xFF},
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00aa & 0xFF, 0x00aa & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00b7 & 0xFF, 0x00b7 & 0xFF},
	{0x00ba & 0xFF, 0x00ba & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0100 & 0xFF, 0x01ff & 0xFF},
	{0x0200 & 0xFF, 0x02c1 & 0xFF},
	{0x02c6 & 0xFF, 0x02d1 & 0xFF},
	{0x02e0 & 0xFF, 0x02e4 & 0xFF},
	{0x02ec & 0xFF, 0x02ec & 0xFF},
	{0x02ee & 0xFF, 0x02ee & 0xFF},
	{0x0300 & 0xFF, 0x0374 & 0xFF},
	{0x0376 & 0xFF, 0x0377 & 0xFF},
	{0x037b & 0xFF, 0x037d & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03f5 & 0xFF},
	{0x03f7 & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x0481 & 0xFF},
	{0x0483 & 0xFF, 0x0487 & 0xFF},
	{0x048a & 0xFF, 0x04ff & 0xFF},
	{0x0500 & 0xFF, 0x052f & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x0559 & 0xFF, 0x0559 & 0xFF},
	{0x0560 & 0xFF, 0x0588 & 0xFF},
	{0x0591 & 0xFF, 0x05bd & 0xFF},
	{0x05bf & 0xFF, 0x05bf & 0xFF},
	{0x05c1 & 0xFF, 0x05c2 & 0xFF},
	{0x05c4 & 0xFF, 0x05c5 & 0xFF},
	{0x05c7 & 0xFF, 0x05c7 & 0xFF},
	{0x05d0 & 0xFF, 0x05ea & 0xFF},
	{0x05ef & 0xFF, 0x05f2 & 0xFF},
	{0x0610 & 0xFF, 0x061a & 0xFF},
	{0x0620 & 0xFF, 0x0669 & 0xFF},
	{0x066e & 0xFF, 0x06d3 & 0xFF},
	{0x06d5 & 0xFF, 0x06dc & 0xFF},
	{0x06df & 0xFF, 0x06e8 & 0xFF},
	{0x06ea & 0xFF, 0x06fc & 0xFF},
	{0x06ff & 0xFF, 0x06ff & 0xFF},
	{0x0710 & 0xFF, 0x074a & 0xFF},
	{0x074d & 0xFF, 0x07b1 & 0xFF},
	{0x07c0 & 0xFF, 0x07f5 & 0xFF},
	{0x07fa & 0xFF, 0x07fa & 0xFF},
	{0x07fd & 0xFF, 0x07fd & 0xFF},
	{0x0800 & 0xFF, 0x082d & 0xFF},
	{0x0840 & 0xFF, 0x085b & 0xFF},
	{0x0860 & 0xFF, 0x086a & 0xFF},
	{0x0870 & 0xFF, 0x0887 & 0xFF},
	{0x0889 & 0xFF, 0x088e & 0xFF},
	{0x0898 & 0xFF, 0x08e1 & 0xFF},
	{0x08e3 & 0xFF, 0x08ff & 0xFF},
	{0x0900 & 0xFF, 0x0963 & 0xFF},
	{0x0966 & 0xFF, 0x096f & 0xFF},
	{0x0971 & 0xFF, 0x0983 & 0xFF},
	{0x0985 & 0xFF, 0x098c & 0xFF},
	{0x098f & 0xFF, 0x0990 & 0xFF},
	{0x0993 & 0xFF, 0x09a8 & 0xFF},
	{0x09aa & 0xFF, 0x09b0 & 0xFF},
	{0x09b2 & 0xFF, 0x09b2 & 0xFF},
	{0x09b6 & 0xFF, 0x09b9 & 0xFF},
	{0x09bc & 0xFF, 0x09c4 & 0xFF},
	{0x09c7 & 0xFF, 0x09c8 & 0xFF},
	{0x09cb & 0xFF, 0x09ce & 0xFF},
	{0x09d7 & 0xFF, 0x09d7 & 0xFF},
	{0x09dc & 0xFF, 0x09dd & 0xFF},
	{0x09df & 0xFF, 0x09e3 & 0xFF},
	{0x09e6 & 0xFF, 0x09f1 & 0xFF},
	{0x09fc & 0xFF, 0x09fc & 0xFF},
	{0x09fe & 0xFF, 0x09fe & 0xFF},
	{0x0a01 & 0xFF, 0x0a03 & 0xFF},
	{0x0a05 & 0xFF, 0x0a0a & 0xFF},
	{0x0a0f & 0xFF, 0x0a10 & 0xFF},
	{0x0a13 & 0xFF, 0x0a28 & 0xFF},
	{0x0a2a & 0xFF, 0x0a30 & 0xFF},
	{0x0a32 & 0xFF, 0x0a33 & 0xFF},
	{0x0a35 & 0xFF, 0x0a36 & 0xFF},
	{0x0a38 & 0xFF, 0x0a39 & 0xFF},
	{0x0a3c & 0xFF, 0x0a3c & 0xFF},
	{0x0a3e & 0xFF, 0x0a42 & 0xFF},
	{0x0a47 & 0xFF, 0x0a48 & 0xFF},
	{0x0a4b & 0xFF, 0x0a4d & 0xFF},
	{0x0a51 & 0xFF, 0x0a51 & 0xFF},
	{0x0a59 & 0xFF, 0x0a5c & 0xFF},
	{0x0a5e & 0xFF, 0x0a5e & 0xFF},
	{0x0a66 & 0xFF, 0x0a75 & 0xFF},
	{0x0a81 & 0xFF, 0x0a83 & 0xFF},
	{0x0a85 & 0xFF, 0x0a8d & 0xFF},
	{0x0a8f & 0xFF, 0x0a91 & 0xFF},
	{0x0a93 & 0xFF, 0x0aa8 & 0xFF},
	{0x0aaa & 0xFF, 0x0ab0 & 0xFF},
	{0x0ab2 & 0xFF, 0x0ab3 & 0xFF},
	{0x0ab5 & 0xFF, 0x0ab9 & 0xFF},
	{0x0abc & 0xFF, 0x0ac5 & 0xFF},
	{0x0ac7 & 0xFF, 0x0ac9 & 0xFF},
	{0x0acb & 0xFF, 0x0acd & 0xFF},
	{0x0ad0 & 0xFF, 0x0ad0 & 0xFF},
	{0x0ae0 & 0xFF, 0x0ae3 & 0xFF},
	{0x0ae6 & 0xFF, 0x0aef & 0xFF},
	{0x0af9 & 0xFF, 0x0aff & 0xFF},
	{0x0b01 & 0xFF, 0x0b03 & 0xFF},
	{0x0b05 & 0xFF, 0x0b0c & 0xFF},
	{0x0b0f & 0xFF, 0x0b10 & 0xFF},
	{0x0b13 & 0xFF, 0x0b28 & 0xFF},
	{0x0b2a & 0xFF, 0x0b30 & 0xFF},
	{0x0b32 & 0xFF, 0x0b33 & 0xFF},
	{0x0b35 & 0xFF, 0x0b39 & 0xFF},
	{0x0b3c & 0xFF, 0x0b44 & 0xFF},
	{0x0b47 & 0xFF, 0x0b48 & 0xFF},
	{0x0b4b & 0xFF, 0x0b4d & 0xFF},
	{0x0b55 & 0xFF, 0x0b57 & 0xFF},
	{0x0b5c & 0xFF, 0x0b5d & 0xFF},
	{0x0b5f & 0xFF, 0x0b63 & 0xFF},
	{0x0b66 & 0xFF, 0x0b6f & 0xFF},
	{0x0b71 & 0xFF, 0x0b71 & 0xFF},
	{0x0b82 & 0xFF, 0x0b83 & 0xFF},
	{0x0b85 & 0xFF, 0x0b8a & 0xFF},
	{0x0b8e & 0xFF, 0x0b90 & 0xFF},
	{0x0b92 & 0xFF, 0x0b95 & 0xFF},
	{0x0b99 & 0xFF, 0x0b9a & 0xFF},
	{0x0b9c & 0xFF, 0x0b9c & 0xFF},
	{0x0b9e & 0xFF, 0x0b9f & 0xFF},
	{0x0ba3 & 0xFF, 0x0ba4 & 0xFF},
	{0x0ba8 & 0xFF, 0x0baa & 0xFF},
	{0x0bae & 0xFF, 0x0bb9 & 0xFF},
	{0x0bbe & 0xFF, 0x0bc2 & 0xFF},
	{0x0bc6 & 0xFF, 0x0bc8 & 0xFF},
	{0x0bca & 0xFF, 0x0bcd & 0xFF},
	{0x0bd0 & 0xFF, 0x0bd0 & 0xFF},
	{0x0bd7 & 0xFF, 0x0bd7 & 0xFF},
	{0x0be6 & 0xFF, 0x0bef & 0xFF},
	{0x0c00 & 0xFF, 0x0c0c & 0xFF},
	{0x0c0e & 0xFF, 0x0c10 & 0xFF},
	{0x0c12 & 0xFF, 0x0c28 & 0xFF},
	{0x0c2a & 0xFF, 0x0c39 & 0xFF},
	{0x0c3c & 0xFF, 0x0c44 & 0xFF},
	{0x0c46 & 0xFF, 0x0c48 & 0xFF},
	{0x0c4a & 0xFF, 0x0c4d & 0xFF},
	{0x0c55 & 0xFF, 0x0c56 & 0xFF},
	{0x0c58 & 0xFF, 0x0c5a & 0xFF},
	{0x0c5d & 0xFF, 0x0c5d & 0xFF},
	{0x0c60 & 0xFF, 0x0c63 & 0xFF},
	{0x0c66 & 0xFF, 0x0c6f & 0xFF},
	{0x0c80 & 0xFF, 0x0c83 & 0xFF},
	{0x0c85 & 0xFF, 0x0c8c & 0xFF},
	{0x0c8e & 0xFF, 0x0c90 & 0xFF},
	{0x0c92 & 0xFF, 0x0ca8 & 0xFF},
	{0x0caa & 0xFF, 0x0cb3 & 0xFF},
	{0x0cb5 & 0xFF, 0x0cb9 & 0xFF},
	{0x0cbc & 0xFF, 0x0cc4 & 0xFF},
	{0x0cc6 & 0xFF, 0x0cc8 & 0xFF},
	{0x0cca & 0xFF, 0x0ccd & 0xFF},
	{0x0cd5 & 0xFF, 0x0cd6 & 0xFF},
	{0x0cdd & 0xFF, 0x0cde & 0xFF},
	{0x0ce0 & 0xFF, 0x0ce3 & 0xFF},
	{0x0ce6 & 0xFF, 0x0cef & 0xFF},
	{0x0cf1 & 0xFF, 0x0cf3 & 0xFF},
	{0x0d00 & 0xFF, 0x0d0c & 0xFF},
	{0x0d0e & 0xFF, 0x0d10 & 0xFF},
	{0x0d12 & 0xFF, 0x0d44 & 0xFF},
	{0x0d46 & 0xFF, 0x0d48 & 0xFF},
	{0x0d4a & 0xFF, 0x0d4e & 0xFF},
	{0x0d54 & 0xFF, 0x0d57 & 0xFF},
	{0x0d5f & 0xFF, 0x0d63 & 0xFF},
	{0x0d66 & 0xFF, 0x0d6f & 0xFF},
	{0x0d7a & 0xFF, 0x0d7f & 0xFF},
	{0x0d81 & 0xFF, 0x0d83 & 0xFF},
	{0x0d85 & 0xFF, 0x0d96 & 0xFF},
	{0x0d9a & 0xFF, 0x0db1 & 0xFF},
	{0x0db3 & 0xFF, 0x0dbb & 0xFF},
	{0x0dbd & 0xFF, 0x0dbd & 0xFF},
	{0x0dc0 & 0xFF, 0x0dc6 & 0xFF},
	{0x0dca & 0xFF, 0x0dca & 0xFF},
	{0x0dcf & 0xFF, 0x0dd4 & 0xFF},
	{0x0dd6 & 0xFF, 0x0dd6 & 0xFF},
	{0x0dd8 & 0xFF, 0x0ddf & 0xFF},
	{0x0de6 & 0xFF, 0x0def & 0xFF},
	{0x0df2 & 0xFF, 0x0df3 & 0xFF},
	{0x0e01 & 0xFF, 0x0e3a & 0xFF},
	{0x0e40 & 0xFF, 0x0e4e & 0xFF},
	{0x0e50 & 0xFF, 0x0e59 & 0xFF},
	{0x0e81 & 0xFF, 0x0e82 & 0xFF},
	{0x0e84 & 0xFF, 0x0e84 & 0xFF},
	{0x0e86 & 0xFF, 0x0e8a & 0xFF},
	{0x0e8c & 0xFF, 0x0ea3 & 0xFF},
	{0x0ea5 & 0xFF, 0x0ea5 & 0xFF},
	{0x0ea7 & 0xFF, 0x0ebd & 0xFF},
	{0x0ec0 & 0xFF, 0x0ec4 & 0xFF},
	{0x0ec6 & 0xFF, 0x0ec6 & 0xFF},
	{0x0ec8 & 0xFF, 0x0ece & 0xFF},
	{0x0ed0 & 0xFF, 0x0ed9 & 0xFF},
	{0x0edc & 0xFF, 0x0edf & 0xFF},
	{0x0f00 & 0xFF, 0x0f00 & 0xFF},
	{0x0f18 & 0xFF, 0x0f19 & 0xFF},
	{0x0f20 & 0xFF, 0x0f29 & 0xFF},
	{0x0f35 & 0xFF, 0x0f35 & 0xFF},
	{0x0f37 & 0xFF, 0x0f37 & 0xFF},
	{0x0f39 & 0xFF, 0x0f39 & 0xFF},
	{0x0f3e & 0xFF, 0x0f47 & 0xFF},
	{0x0f49 & 0xFF, 0x0f6c & 0xFF},
	{0x0f71 & 0xFF, 0x0f84 & 0xFF},
	{0x0f86 & 0xFF, 0x0f97 & 0xFF},
	{0x0f99 & 0xFF, 0x0fbc & 0xFF},
	{0x0fc6 & 0xFF, 0x0fc6 & 0xFF},
	{0x1000 & 0xFF, 0x1049 & 0xFF},
	{0x1050 & 0xFF, 0x109d & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x10d0 & 0xFF, 0x10fa & 0xFF},
	{0x10fc & 0xFF, 0x10ff & 0xFF},
	{0x1100 & 0xFF, 0x11ff & 0xFF},
	{0x1200 & 0xFF, 0x1248 & 0xFF},
	{0x124a & 0xFF, 0x124d & 0xFF},
	{0x1250 & 0xFF, 0x1256 & 0xFF},
	{0x1258 & 0xFF, 0x1258 & 0xFF},
	{0x125a & 0xFF, 0x125d & 0xFF},
	{0x1260 & 0xFF, 0x1288 & 0xFF},
	{0x128a & 0xFF, 0x128d & 0xFF},
	{0x1290 & 0xFF, 0x12b0 & 0xFF},
	{0x12b2 & 0xFF, 0x12b5 & 0xFF},
	{0x12b8 & 0xFF, 0x12be & 0xFF},
	{0x12c0 & 0xFF, 0x12c0 & 0xFF},
	{0x12c2 & 0xFF, 0x12c5 & 0xFF},
	{0x12c8 & 0xFF, 0x12d6 & 0xFF},
	{0x12d8 & 0xFF, 0x12ff & 0xFF},
	{0x1300 & 0xFF, 0x1310 & 0xFF},
	{0x1312 & 0xFF, 0x1315 & 0xFF},
	{0x1318 & 0xFF, 0x135a & 0xFF},
	{0x135d & 0xFF, 0x135f & 0xFF},
	{0x1369 & 0xFF, 0x1371 & 0xFF},
	{0x1380 & 0xFF, 0x138f & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1401 & 0xFF, 0x14ff & 0xFF},
	{0x1500 & 0xFF, 0x15ff & 0xFF},
	{0x1600 & 0xFF, 0x166c & 0xFF},
	{0x166f & 0xFF, 0x167f & 0xFF},
	{0x1681 & 0xFF, 0x169a & 0xFF},
	{0x16a0 & 0xFF, 0x16ea & 0xFF},
	{0x16ee & 0xFF, 0x16f8 & 0xFF},
	{0x1700 & 0xFF, 0x1715 & 0xFF},
	{0x171f & 0xFF, 0x1734 & 0xFF},
	{0x1740 & 0xFF, 0x1753 & 0xFF},
	{0x1760 & 0xFF, 0x176c & 0xFF},
	{0x176e & 0xFF, 0x1770 & 0xFF},
	{0x1772 & 0xFF, 0x1773 & 0xFF},
	{0x1780 & 0xFF, 0x17d3 & 0xFF},
	{0x17d7 & 0xFF, 0x17d7 & 0xFF},
	{0x17dc & 0xFF, 0x17dd & 0xFF},
	{0x17e0 & 0xFF, 0x17e9 & 0xFF},
	{0x180b & 0xFF, 0x180d & 0xFF},
	{0x180f & 0xFF, 0x1819 & 0xFF},
	{0x1820 & 0xFF, 0x1878 & 0xFF},
	{0x1880 & 0xFF, 0x18aa & 0xFF},
	{0x18b0 & 0xFF, 0x18f5 & 0xFF},
	{0x1900 & 0xFF, 0x191e & 0xFF},
	{0x1920 & 0xFF, 0x192b & 0xFF},
	{0x1930 & 0xFF, 0x193b & 0xFF},
	{0x1946 & 0xFF, 0x196d & 0xFF},
	{0x1970 & 0xFF, 0x1974 & 0xFF},
	{0x1980 & 0xFF, 0x19ab & 0xFF},
	{0x19b0 & 0xFF, 0x19c9 & 0xFF},
	{0x19d0 & 0xFF, 0x19da & 0xFF},
	{0x1a00 & 0xFF, 0x1a1b & 0xFF},
	{0x1a20 & 0xFF, 0x1a5e & 0xFF},
	{0x1a60 & 0xFF, 0x1a7c & 0xFF},
	{0x1a7f & 0xFF, 0x1a89 & 0xFF},
	{0x1a90 & 0xFF, 0x1a99 & 0xFF},
	{0x1aa7 & 0xFF, 0x1aa7 & 0xFF},
	{0x1ab0 & 0xFF, 0x1abd & 0xFF},
	{0x1abf & 0xFF, 0x1ace & 0xFF},
	{0x1b00 & 0xFF, 0x1b4c & 0xFF},
	{0x1b50 & 0xFF, 0x1b59 & 0xFF},
	{0x1b6b & 0xFF, 0x1b73 & 0xFF},
	{0x1b80 & 0xFF, 0x1bf3 & 0xFF},
	{0x1c00 & 0xFF, 0x1c37 & 0xFF},
	{0x1c40 & 0xFF, 0x1c49 & 0xFF},
	{0x1c4d & 0xFF, 0x1c7d & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1cd0 & 0xFF, 0x1cd2 & 0xFF},
	{0x1cd4 & 0xFF, 0x1cfa & 0xFF},
	{0x1d00 & 0xFF, 0x1dff & 0xFF},
	{0x1e00 & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f15 & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f20 & 0xFF, 0x1f45 & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fbc & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fcc & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe0 & 0xFF, 0x1fec & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ffc & 0xFF},
	{0x200c & 0xFF, 0x200d & 0xFF},
	{0x203f & 0xFF, 0x2040 & 0xFF},
	{0x2054 & 0xFF, 0x2054 & 0xFF},
	{0x2071 & 0xFF, 0x2071 & 0xFF},
	{0x207f & 0xFF, 0x207f & 0xFF},
	{0x2090 & 0xFF, 0x209c & 0xFF},
	{0x20d0 & 0xFF, 0x20dc & 0xFF},
	{0x20e1 & 0xFF, 0x20e1 & 0xFF},
	{0x20e5 & 0xFF, 0x20f0 & 0xFF},
	{0x2102 & 0xFF, 0x2102 & 0xFF},
	{0x2107 & 0xFF, 0x2107 & 0xFF},
	{0x210a & 0xFF, 0x2113 & 0xFF},
	{0x2115 & 0xFF, 0x2115 & 0xFF},
	{0x2118 & 0xFF, 0x211d & 0xFF},
	{0x2124 & 0xFF, 0x2124 & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x2128 & 0xFF, 0x2128 & 0xFF},
	{0x212a & 0xFF, 0x2139 & 0xFF},
	{0x213c & 0xFF, 0x213f & 0xFF},
	{0x2145 & 0xFF, 0x2149 & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2160 & 0xFF, 0x2188 & 0xFF},
	{0x2c00 & 0xFF, 0x2ce4 & 0xFF},
	{0x2ceb & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0x2d30 & 0xFF, 0x2d67 & 0xFF},
	{0x2d6f & 0xFF, 0x2d6f & 0xFF},
	{0x2d7f & 0xFF, 0x2d96 & 0xFF},
	{0x2da0 & 0xFF, 0x2da6 & 0xFF},
	{0x2da8 & 0xFF, 0x2dae & 0xFF},
	{0x2db0 & 0xFF, 0x2db6 & 0xFF},
	{0x2db8 & 0xFF, 0x2dbe & 0xFF},
	{0x2dc0 & 0xFF, 0x2dc6 & 0xFF},
	{0x2dc8 & 0xFF, 0x2dce & 0xFF},
	{0x2dd0 & 0xFF, 0x2dd6 & 0xFF},
	{0x2dd8 & 0xFF, 0x2dde & 0xFF},
	{0x2de0 & 0xFF, 0x2dff & 0xFF},
	{0x3005 & 0xFF, 0x3007 & 0xFF},
	{0x3021 & 0xFF, 0x302f & 0xFF},
	{0x3031 & 0xFF, 0x3035 & 0xFF},
	{0x3038 & 0xFF, 0x303c & 0xFF},
	{0x3041 & 0xFF, 0x3096 & 0xFF},
	{0x3099 & 0xFF, 0x309a & 0xFF},
	{0x309d & 0xFF, 0x309f & 0xFF},
	{0x30a1 & 0xFF, 0x30ff & 0xFF},
	{0x3105 & 0xFF, 0x312f & 0xFF},
	{0x3131 & 0xFF, 0x318e & 0xFF},
	{0x31a0 & 0xFF, 0x31bf & 0xFF},
	{0x31f0 & 0xFF, 0x31ff & 0xFF},
	{0x3400 & 0xFF, 0x34ff & 0xFF},
	{0x3500 & 0xFF, 0x35ff & 0xFF},
	{0x3600 & 0xFF, 0x36ff & 0xFF},
	{0x3700 & 0xFF, 0x37ff & 0xFF},
	{0x3800 & 0xFF, 0x38ff & 0xFF},
	{0x3900 & 0xFF, 0x39ff & 0xFF},
	{0x3a00 & 0xFF, 0x3aff & 0xFF},
	{0x3b00 & 0xFF, 0x3bff & 0xFF},
	{0x3c00 & 0xFF, 0x3cff & 0xFF},
	{0x3d00 & 0xFF, 0x3dff & 0xFF},
	{0x3e00 & 0xFF, 0x3eff & 0xFF},
	{0x3f00 & 0xFF, 0x3fff & 0xFF},
	{0x4000 & 0xFF, 0x40ff & 0xFF},
	{0x4100 & 0xFF, 0x41ff & 0xFF},
	{0x4200 & 0xFF, 0x42ff & 0xFF},
	{0x4300 & 0xFF, 0x43ff & 0xFF},
	{0x4400 & 0xFF, 0x44ff & 0xFF},
	{0x4500 & 0xFF, 0x45ff & 0xFF},
	{0x4600 & 0xFF, 0x46ff & 0xFF},
	{0x4700 & 0xFF, 0x47ff & 0xFF},
	{0x4800 & 0xFF, 0x48ff & 0xFF},
	{0x4900 & 0xFF, 0x49ff & 0xFF},
	{0x4a00 & 0xFF, 0x4aff & 0xFF},
	{0x4b00 & 0xFF, 0x4bff & 0xFF},
	{0x4c00 & 0xFF, 0x4cff & 0xFF},
	{0x4d00 & 0xFF, 0x4dbf & 0xFF},
	{0x4e00 & 0xFF, 0x4eff & 0xFF},
	{0x4f00 & 0xFF, 0x4fff & 0xFF},
	{0x5000 & 0xFF, 0x50ff & 0xFF},
	{0x5100 & 0xFF, 0x51ff & 0xFF},
	{0x5200 & 0xFF, 0x52ff & 0xFF},
	{0x5300 & 0xFF, 0x53ff & 0xFF},
	{0x5400 & 0xFF, 0x54ff & 0xFF},
	{0x5500 & 0xFF, 0x55ff & 0xFF},
	{0x5600 & 0xFF, 0x56ff & 0xFF},
	{0x5700 & 0xFF, 0x57ff & 0xFF},
	{0x5800 & 0xFF, 0x58ff & 0xFF},
	{0x5900 & 0xFF, 0x59ff & 0xFF},
	{0x5a00 & 0xFF, 0x5aff & 0xFF},
	{0x5b00 & 0xFF, 0x5bff & 0xFF},
	{0x5c00 & 0xFF, 0x5cff & 0xFF},
	{0x5d00 & 0xFF, 0x5dff & 0xFF},
	{0x5e00 & 0xFF, 0x5eff & 0xFF},
	{0x5f00 & 0xFF, 0x5fff & 0xFF},
	{0x6000 & 0xFF, 0x60ff & 0xFF},
	{0x6100 & 0xFF, 0x61ff & 0xFF},
	{0x6200 & 0xFF, 0x62ff & 0xFF},
	{0x6300 & 0xFF, 0x63ff & 0xFF},
	{0x6400 & 0xFF, 0x64ff & 0xFF},
	{0x6500 & 0xFF, 0x65ff & 0xFF},
	{0x6600 & 0xFF, 0x66ff & 0xFF},
	{0x6700 & 0xFF, 0x67ff & 0xFF},
	{0x6800 & 0xFF, 0x68ff & 0xFF},
	{0x6900 & 0xFF, 0x69ff & 0xFF},
	{0x6a00 & 0xFF, 0x6aff & 0xFF},
	{0x6b00 & 0xFF, 0x6bff & 0xFF},
	{0x6c00 & 0xFF, 0x6cff & 0xFF},
	{0x6d00 & 0xFF, 0x6dff & 0xFF},
	{0x6e00 & 0xFF, 0x6eff & 0xFF},
	{0x6f00 & 0xFF, 0x6fff & 0xFF},
	{0x7000 & 0xFF, 0x70ff & 0xFF},
	{0x7100 & 0xFF, 0x71ff & 0xFF},
	{0x7200 & 0xFF, 0x72ff & 0xFF},
	{0x7300 & 0xFF, 0x73ff & 0xFF},
	{0x7400 & 0xFF, 0x74ff & 0xFF},
	{0x7500 & 0xFF, 0x75ff & 0xFF},
	{0x7600 & 0xFF, 0x76ff & 0xFF},
	{0x7700 & 0xFF, 0x77ff & 0xFF},
	{0x7800 & 0xFF, 0x78ff & 0xFF},
	{0x7900 & 0xFF, 0x79ff & 0xFF},
	{0x7a00 & 0xFF, 0x7aff & 0xFF},
	{0x7b00 & 0xFF, 0x7bff & 0xFF},
	{0x7c00 & 0xFF, 0x7cff & 0xFF},
	{0x7d00 & 0xFF, 0x7dff & 0xFF},
	{0x7e00 & 0xFF, 0x7eff & 0xFF},
	{0x7f00 & 0xFF, 0x7fff & 0xFF},
	{0x8000 & 0xFF, 0x80ff & 0xFF},
	{0x8100 & 0xFF, 0x81ff & 0xFF},
	{0x8200 & 0xFF, 0x82ff & 0xFF},
	{0x8300 & 0xFF, 0x83ff & 0xFF},
	{0x8400 & 0xFF, 0x84ff & 0xFF},
	{0x8500 & 0xFF, 0x85ff & 0xFF},
	{0x8600 & 0xFF, 0x86ff & 0xFF},
	{0x8700 & 0xFF, 0x87ff & 0xFF},
	{0x8800 & 0xFF, 0x88ff & 0xFF},
	{0x8900 & 0xFF, 0x89ff & 0xFF},
	{0x8a00 & 0xFF, 0x8aff & 0xFF},
	{0x8b00 & 0xFF, 0x8bff & 0xFF},
	{0x8c00 & 0xFF, 0x8cff & 0xFF},
	{0x8d00 & 0xFF, 0x8dff & 0xFF},
	{0x8e00 & 0xFF, 0x8eff & 0xFF},
	{0x8f00 & 0xFF, 0x8fff & 0xFF},
	{0x9000 & 0xFF, 0x90ff & 0xFF},
	{0x9100 & 0xFF, 0x91ff & 0xFF},
	{0x9200 & 0xFF, 0x92ff & 0xFF},
	{0x9300 & 0xFF, 0x93ff & 0xFF},
	{0x9400 & 0xFF, 0x94ff & 0xFF},
	{0x9500 & 0xFF, 0x95ff & 0xFF},
	{0x9600 & 0xFF, 0x96ff & 0xFF},
	{0x9700 & 0xFF, 0x97ff & 0xFF},
	{0x9800 & 0xFF, 0x98ff & 0xFF},
	{0x9900 & 0xFF, 0x99ff & 0xFF},
	{0x9a00 & 0xFF, 0x9aff & 0xFF},
	{0x9b00 & 0xFF, 0x9bff & 0xFF},
	{0x9c00 & 0xFF, 0x9cff & 0xFF},
	{0x9d00 & 0xFF, 0x9dff & 0xFF},
	{0x9e00 & 0xFF, 0x9eff & 0xFF},
	{0x9f00 & 0xFF, 0x9fff & 0xFF},
	{0xa000 & 0xFF, 0xa0ff & 0xFF},
	{0xa100 & 0xFF, 0xa1ff & 0xFF},
	{0xa200 & 0xFF, 0xa2ff & 0xFF},
	{0xa300 & 0xFF, 0xa3ff & 0xFF},
	{0xa400 & 0xFF, 0xa48c & 0xFF},
	{0xa4d0 & 0xFF, 0xa4fd & 0xFF},
	{0xa500 & 0xFF, 0xa5ff & 0xFF},
	{0xa600 & 0xFF, 0xa60c & 0xFF},
	{0xa610 & 0xFF, 0xa62b & 0xFF},
	{0xa640 & 0xFF, 0xa66f & 0xFF},
	{0xa674 & 0xFF, 0xa67d & 0xFF},
	{0xa67f & 0xFF, 0xa6f1 & 0xFF},
	{0xa717 & 0xFF, 0xa71f & 0xFF},
	{0xa722 & 0xFF, 0xa788 & 0xFF},
	{0xa78b & 0xFF, 0xa7ca & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d3 & 0xFF, 0xa7d3 & 0xFF},
	{0xa7d5 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f2 & 0xFF, 0xa7ff & 0xFF},
	{0xa800 & 0xFF, 0xa827 & 0xFF},
	{0xa82c & 0xFF, 0xa82c & 0xFF},
	{0xa840 & 0xFF, 0xa873 & 0xFF},
	{0xa880 & 0xFF, 0xa8c5 & 0xFF},
	{0xa8d0 & 0xFF, 0xa8d9 & 0xFF},
	{0xa8e0 & 0xFF, 0xa8f7 & 0xFF},
	{0xa8fb & 0xFF, 0xa8fb & 0xFF},
	{0xa8fd & 0xFF, 0xa8ff & 0xFF},
	{0xa900 & 0xFF, 0xa92d & 0xFF},
	{0xa930 & 0xFF, 0xa953 & 0xFF},
	{0xa960 & 0xFF, 0xa97c & 0xFF},
	{0xa980 & 0xFF, 0xa9c0 & 0xFF},
	{0xa9cf & 0xFF, 0xa9d9 & 0xFF},
	{0xa9e0 & 0xFF, 0xa9fe & 0xFF},
	{0xaa00 & 0xFF, 0xaa36 & 0xFF},
	{0xaa40 & 0xFF, 0xaa4d & 0xFF},
	{0xaa50 & 0xFF, 0xaa59 & 0xFF},
	{0xaa60 & 0xFF, 0xaa76 & 0xFF},
	{0xaa7a & 0xFF, 0xaac2 & 0xFF},
	{0xaadb & 0xFF, 0xaadd & 0xFF},
	{0xaae0 & 0xFF, 0xaaef & 0xFF},
	{0xaaf2 & 0xFF, 0xaaf6 & 0xFF},
	{0xab01 & 0xFF, 0xab06 & 0xFF},
	{0xab09 & 0xFF, 0xab0e & 0xFF},
	{0xab11 & 0xFF, 0xab16 & 0xFF},
	{0xab20 & 0xFF, 0xab26 & 0xFF},
	{0xab28 & 0xFF, 0xab2e & 0xFF},
	{0xab30 & 0xFF, 0xab5a & 0xFF},
	{0xab5c & 0xFF, 0xab69 & 0xFF},
	{0xab70 & 0xFF, 0xabea & 0xFF},
	{0xabec & 0xFF, 0xabed & 0xFF},
	{0xabf0 & 0xFF, 0xabf9 & 0xFF},
	{0xac00 & 0xFF, 0xacff & 0xFF},
	{0xad00 & 0xFF, 0xadff & 0xFF},
	{0xae00 & 0xFF, 0xaeff & 0xFF},
	{0xaf00 & 0xFF, 0xafff & 0xFF},
	{0xb000 & 0xFF, 0xb0ff & 0xFF},
	{0xb100 & 0xFF, 0xb1ff & 0xFF},
	{0xb200 & 0xFF, 0xb2ff & 0xFF},
	{0xb300 & 0xFF, 0xb3ff & 0xFF},
	{0xb400 & 0xFF, 0xb4ff & 0xFF},
	{0xb500 & 0xFF, 0xb5ff & 0xFF},
	{0xb600 & 0xFF, 0xb6ff & 0xFF},
	{0xb700 & 0xFF, 0xb7ff & 0xFF},
	{0xb800 & 0xFF, 0xb8ff & 0xFF},
	{0xb900 & 0xFF, 0xb9ff & 0xFF},
	{0xba00 & 0xFF, 0xbaff & 0xFF},
	{0xbb00 & 0xFF, 0xbbff & 0xFF},
	{0xbc00 & 0xFF, 0xbcff & 0xFF},
	{0xbd00 & 0xFF, 0xbdff & 0xFF},
	{0xbe00 & 0xFF, 0xbeff & 0xFF},
	{0xbf00 & 0xFF, 0xbfff & 0xFF},
	{0xc000 & 0xFF, 0xc0ff & 0xFF},
	{0xc100 & 0xFF, 0xc1ff & 0xFF},
	{0xc200 & 0xFF, 0xc2ff & 0xFF},
	{0xc300 & 0xFF, 0xc3ff & 0xFF},
	{0xc400 & 0xFF, 0xc4ff & 0xFF},
	{0xc500 & 0xFF, 0xc5ff & 0xFF},
	{0xc600 & 0xFF, 0xc6ff & 0xFF},
	{0xc700 & 0xFF, 0xc7ff & 0xFF},
	{0xc800 & 0xFF, 0xc8ff & 0xFF},
	{0xc900 & 0xFF, 0xc9ff & 0xFF},
	{0xca00 & 0xFF, 0xcaff & 0xFF},
	{0xcb00 & 0xFF, 0xcbff & 0xFF},
	{0xcc00 & 0xFF, 0xccff & 0xFF},
	{0xcd00 & 0xFF, 0xcdff & 0xFF},
	{0xce00 & 0xFF, 0xceff & 0xFF},
	{0xcf00 & 0xFF, 0xcfff & 0xFF},
	{0xd000 & 0xFF, 0xd0ff & 0xFF},
	{0xd100 & 0xFF, 0xd1ff & 0xFF},
	{0xd200 & 0xFF, 0xd2ff & 0xFF},
	{0xd300 & 0xFF, 0xd3ff & 0xFF},
	{0xd400 & 0xFF, 0xd4ff & 0xFF},
	{0xd500 & 0xFF, 0xd5ff & 0xFF},
	{0xd600 & 0xFF, 0xd6ff & 0xFF},
	{0xd700 & 0xFF, 0xd7a3 & 0xFF},
	{0xd7b0 & 0xFF, 0xd7c6 & 0xFF},
	{0xd7cb & 0xFF, 0xd7fb & 0xFF},
	{0xf900 & 0xFF, 0xf9ff & 0xFF},
	{0xfa00 & 0xFF, 0xfa6d & 0xFF},
	{0xfa70 & 0xFF, 0xfad9 & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xfb1d & 0xFF, 0xfb28 & 0xFF},
	{0xfb2a & 0xFF, 0xfb36 & 0xFF},
	{0xfb38 & 0xFF, 0xfb3c & 0xFF},
	{0xfb3e & 0xFF, 0xfb3e & 0xFF},
	{0xfb40 & 0xFF, 0xfb41 & 0xFF},
	{0xfb43 & 0xFF, 0xfb44 & 0xFF},
	{0xfb46 & 0xFF, 0xfbb1 & 0xFF},
	{0xfbd3 & 0xFF, 0xfbff & 0xFF},
	{0xfc00 & 0xFF, 0xfc5d & 0xFF},
	{0xfc64 & 0xFF, 0xfcff & 0xFF},
	{0xfd00 & 0xFF, 0xfd3d & 0xFF},
	{0xfd50 & 0xFF, 0xfd8f & 0xFF},
	{0xfd92 & 0xFF, 0xfdc7 & 0xFF},
	{0xfdf0 & 0xFF, 0xfdf9 & 0xFF},
	{0xfe00 & 0xFF, 0xfe0f & 0xFF},
	{0xfe20 & 0xFF, 0xfe2f & 0xFF},
	{0xfe33 & 0xFF, 0xfe34 & 0xFF},
	{0xfe4d & 0xFF, 0xfe4f & 0xFF},
	{0xfe71 & 0xFF, 0xfe71 & 0xFF},
	{0xfe73 & 0xFF, 0xfe73 & 0xFF},
	{0xfe77 & 0xFF, 0xfe77 & 0xFF},
	{0xfe79 & 0xFF, 0xfe79 & 0xFF},
	{0xfe7b & 0xFF, 0xfe7b & 0xFF},
	{0xfe7d & 0xFF, 0xfe7d & 0xFF},
	{0xfe7f & 0xFF, 0xfefc & 0xFF},
	{0xff10 & 0xFF, 0xff19 & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0xff3f & 0xFF, 0xff3f & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0xff65 & 0xFF, 0xffbe & 0xFF},
	{0xffc2 & 0xFF, 0xffc7 & 0xFF},
	{0xffca & 0xFF, 0xffcf & 0xFF},
	{0xffd2 & 0xFF, 0xffd7 & 0xFF},
	{0xffda & 0xFF, 0xffdc & 0xFF},
	{0x10000 & 0xFF, 0x1000b & 0xFF},
	{0x1000d & 0xFF, 0x10026 & 0xFF},
	{0x10028 & 0xFF, 0x1003a & 0xFF},
	{0x1003c & 0xFF, 0x1003d & 0xFF},
	{0x1003f & 0xFF, 0x1004d & 0xFF},
	{0x10050 & 0xFF, 0x1005d & 0xFF},
	{0x10080 & 0xFF, 0x100fa & 0xFF},
	{0x10140 & 0xFF, 0x10174 & 0xFF},
	{0x101fd & 0xFF, 0x101fd & 0xFF},
	{0x10280 & 0xFF, 0x1029c & 0xFF},
	{0x102a0 & 0xFF, 0x102d0 & 0xFF},
	{0x102e0 & 0xFF, 0x102e0 & 0xFF},
	{0x10300 & 0xFF, 0x1031f & 0xFF},
	{0x1032d & 0xFF, 0x1034a & 0xFF},
	{0x10350 & 0xFF, 0x1037a & 0xFF},
	{0x10380 & 0xFF, 0x1039d & 0xFF},
	{0x103a0 & 0xFF, 0x103c3 & 0xFF},
	{0x103c8 & 0xFF, 0x103cf & 0xFF},
	{0x103d1 & 0xFF, 0x103d5 & 0xFF},
	{0x10400 & 0xFF, 0x1049d & 0xFF},
	{0x104a0 & 0xFF, 0x104a9 & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10500 & 0xFF, 0x10527 & 0xFF},
	{0x10530 & 0xFF, 0x10563 & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10600 & 0xFF, 0x106ff & 0xFF},
	{0x10700 & 0xFF, 0x10736 & 0xFF},
	{0x10740 & 0xFF, 0x10755 & 0xFF},
	{0x10760 & 0xFF, 0x10767 & 0xFF},
	{0x10780 & 0xFF, 0x10785 & 0xFF},
	{0x10787 & 0xFF, 0x107b0 & 0xFF},
	{0x107b2 & 0xFF, 0x107ba & 0xFF},
	{0x10800 & 0xFF, 0x10805 & 0xFF},
	{0x10808 & 0xFF, 0x10808 & 0xFF},
	{0x1080a & 0xFF, 0x10835 & 0xFF},
	{0x10837 & 0xFF, 0x10838 & 0xFF},
	{0x1083c & 0xFF, 0x1083c & 0xFF},
	{0x1083f & 0xFF, 0x10855 & 0xFF},
	{0x10860 & 0xFF, 0x10876 & 0xFF},
	{0x10880 & 0xFF, 0x1089e & 0xFF},
	{0x108e0 & 0xFF, 0x108f2 & 0xFF},
	{0x108f4 & 0xFF, 0x108f5 & 0xFF},
	{0x10900 & 0xFF, 0x10915 & 0xFF},
	{0x10920 & 0xFF, 0x10939 & 0xFF},
	{0x10980 & 0xFF, 0x109b7 & 0xFF},
	{0x109be & 0xFF, 0x109bf & 0xFF},
	{0x10a00 & 0xFF, 0x10a03 & 0xFF},
	{0x10a05 & 0xFF, 0x10a06 & 0xFF},
	{0x10a0c & 0xFF, 0x10a13 & 0xFF},
	{0x10a15 & 0xFF, 0x10a17 & 0xFF},
	{0x10a19 & 0xFF, 0x10a35 & 0xFF},
	{0x10a38 & 0xFF, 0x10a3a & 0xFF},
	{0x10a3f & 0xFF, 0x10a3f & 0xFF},
	{0x10a60 & 0xFF, 0x10a7c & 0xFF},
	{0x10a80 & 0xFF, 0x10a9c & 0xFF},
	{0x10ac0 & 0xFF, 0x10ac7 & 0xFF},
	{0x10ac9 & 0xFF, 0x10ae6 & 0xFF},
	{0x10b00 & 0xFF, 0x10b35 & 0xFF},
	{0x10b40 & 0xFF, 0x10b55 & 0xFF},
	{0x10b60 & 0xFF, 0x10b72 & 0xFF},
	{0x10b80 & 0xFF, 0x10b91 & 0xFF},
	{0x10c00 & 0xFF, 0x10c48 & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x10d00 & 0xFF, 0x10d27 & 0xFF},
	{0x10d30 & 0xFF, 0x10d39 & 0xFF},
	{0x10e80 & 0xFF, 0x10ea9 & 0xFF},
	{0x10eab & 0xFF, 0x10eac & 0xFF},
	{0x10eb0 & 0xFF, 0x10eb1 & 0xFF},
	{0x10efd & 0xFF, 0x10eff & 0xFF},
	{0x10f00 & 0xFF, 0x10f1c & 0xFF},
	{0x10f27 & 0xFF, 0x10f27 & 0xFF},
	{0x10f30 & 0xFF, 0x10f50 & 0xFF},
	{0x10f70 & 0xFF, 0x10f85 & 0xFF},
	{0x10fb0 & 0xFF, 0x10fc4 & 0xFF},
	{0x10fe0 & 0xFF, 0x10ff6 & 0xFF},
	{0x11000 & 0xFF, 0x11046 & 0xFF},
	{0x11066 & 0xFF, 0x11075 & 0xFF},
	{0x1107f & 0xFF, 0x110ba & 0xFF},
	{0x110c2 & 0xFF, 0x110c2 & 0xFF},
	{0x110d0 & 0xFF, 0x110e8 & 0xFF},
	{0x110f0 & 0xFF, 0x110f9 & 0xFF},
	{0x11100 & 0xFF, 0x11134 & 0xFF},
	{0x11136 & 0xFF, 0x1113f & 0xFF},
	{0x11144 & 0xFF, 0x11147 & 0xFF},
	{0x11150 & 0xFF, 0x11173 & 0xFF},
	{0x11176 & 0xFF, 0x11176 & 0xFF},
	{0x11180 & 0xFF, 0x111c4 & 0xFF},
	{0x111c9 & 0xFF, 0x111cc & 0xFF},
	{0x111ce & 0xFF, 0x111da & 0xFF},
	{0x111dc & 0xFF, 0x111dc & 0xFF},
	{0x11200 & 0xFF, 0x11211 & 0xFF},
	{0x11213 & 0xFF, 0x11237 & 0xFF},
	{0x1123e & 0xFF, 0x11241 & 0xFF},
	{0x11280 & 0xFF, 0x11286 & 0xFF},
	{0x11288 & 0xFF, 0x11288 & 0xFF},
	{0x1128a & 0xFF, 0x1128d & 0xFF},
	{0x1128f & 0xFF, 0x1129d & 0xFF},
	{0x1129f & 0xFF, 0x112a8 & 0xFF},
	{0x112b0 & 0xFF, 0x112ea & 0xFF},
	{0x112f0 & 0xFF, 0x112f9 & 0xFF},
	{0x11300 & 0xFF, 0x11303 & 0xFF},
	{0x11305 & 0xFF, 0x1130c & 0xFF},
	{0x1130f & 0xFF, 0x11310 & 0xFF},
	{0x11313 & 0xFF, 0x11328 & 0xFF},
	{0x1132a & 0xFF, 0x11330 & 0xFF},
	{0x11332 & 0xFF, 0x11333 & 0xFF},
	{0x11335 & 0xFF, 0x11339 & 0xFF},
	{0x1133b & 0xFF, 0x11344 & 0xFF},
	{0x11347 & 0xFF, 0x11348 & 0xFF},
	{0x1134b & 0xFF, 0x1134d & 0xFF},
	{0x11350 & 0xFF, 0x11350 & 0xFF},
	{0x11357 & 0xFF, 0x11357 & 0xFF},
	{0x1135d & 0xFF, 0x11363 & 0xFF},
	{0x11366 & 0xFF, 0x1136c & 0xFF},
	{0x11370 & 0xFF, 0x11374 & 0xFF},
	{0x11400 & 0xFF, 0x1144a & 0xFF},
	{0x11450 & 0xFF, 0x11459 & 0xFF},
	{0x1145e & 0xFF, 0x11461 & 0xFF},
	{0x11480 & 0xFF, 0x114c5 & 0xFF},
	{0x114c7 & 0xFF, 0x114c7 & 0xFF},
	{0x114d0 & 0xFF, 0x114d9 & 0xFF},
	{0x11580 & 0xFF, 0x115b5 & 0xFF},
	{0x115b8 & 0xFF, 0x115c0 & 0xFF},
	{0x115d8 & 0xFF, 0x115dd & 0xFF},
	{0x11600 & 0xFF, 0x11640 & 0xFF},
	{0x11644 & 0xFF, 0x11644 & 0xFF},
	{0x11650 & 0xFF, 0x11659 & 0xFF},
	{0x11680 & 0xFF, 0x116b8 & 0xFF},
	{0x116c0 & 0xFF, 0x116c9 & 0xFF},
	{0x11700 & 0xFF, 0x1171a & 0xFF},
	{0x1171d & 0xFF, 0x1172b & 0xFF},
	{0x11730 & 0xFF, 0x11739 & 0xFF},
	{0x11740 & 0xFF, 0x11746 & 0xFF},
	{0x11800 & 0xFF, 0x1183a & 0xFF},
	{0x118a0 & 0xFF, 0x118e9 & 0xFF},
	{0x118ff & 0xFF, 0x118ff & 0xFF},
	{0x11900 & 0xFF, 0x11906 & 0xFF},
	{0x11909 & 0xFF, 0x11909 & 0xFF},
	{0x1190c & 0xFF, 0x11913 & 0xFF},
	{0x11915 & 0xFF, 0x11916 & 0xFF},
	{0x11918 & 0xFF, 0x11935 & 0xFF},
	{0x11937 & 0xFF, 0x11938 & 0xFF},
	{0x1193b & 0xFF, 0x11943 & 0xFF},
	{0x11950 & 0xFF, 0x11959 & 0xFF},
	{0x119a0 & 0xFF, 0x119a7 & 0xFF},
	{0x119aa & 0xFF, 0x119d7 & 0xFF},
	{0x119da & 0xFF, 0x119e1 & 0xFF},
	{0x119e3 & 0xFF, 0x119e4 & 0xFF},
	{0x11a00 & 0xFF, 0x11a3e & 0xFF},
	{0x11a47 & 0xFF, 0x11a47 & 0xFF},
	{0x11a50 & 0xFF, 0x11a99 & 0xFF},
	{0x11a9d & 0xFF, 0x11a9d & 0xFF},
	{0x11ab0 & 0xFF, 0x11af8 & 0xFF},
	{0x11c00 & 0xFF, 0x11c08 & 0xFF},
	{0x11c0a & 0xFF, 0x11c36 & 0xFF},
	{0x11c38 & 0xFF, 0x11c40 & 0xFF},
	{0x11c50 & 0xFF, 0x11c59 & 0xFF},
	{0x11c72 & 0xFF, 0x11c8f & 0xFF},
	{0x11c92 & 0xFF, 0x11ca7 & 0xFF},
	{0x11ca9 & 0xFF, 0x11cb6 & 0xFF},
	{0x11d00 & 0xFF, 0x11d06 & 0xFF},
	{0x11d08 & 0xFF, 0x11d09 & 0xFF},
	{0x11d0b & 0xFF, 0x11d36 & 0xFF},
	{0x11d3a & 0xFF, 0x11d3a & 0xFF},
	{0x11d3c & 0xFF, 0x11d3d & 0xFF},
	{0x11d3f & 0xFF, 0x11d47 & 0xFF},
	{0x11d50 & 0xFF, 0x11d59 & 0xFF},
	{0x11d60 & 0xFF, 0x11d65 & 0xFF},
	{0x11d67 & 0xFF, 0x11d68 & 0xFF},
	{0x11d6a & 0xFF, 0x11d8e & 0xFF},
	{0x11d90 & 0xFF, 0x11d91 & 0xFF},
	{0x11d93 & 0xFF, 0x11d98 & 0xFF},
	{0x11da0 & 0xFF, 0x11da9 & 0xFF},
	{0x11ee0 & 0xFF, 0x11ef6 & 0xFF},
	{0x11f00 & 0xFF, 0x11f10 & 0xFF},
	{0x11f12 & 0xFF, 0x11f3a & 0xFF},
	{0x11f3e & 0xFF, 0x11f42 & 0xFF},
	{0x11f50 & 0xFF, 0x11f59 & 0xFF},
	{0x11fb0 & 0xFF, 0x11fb0 & 0xFF},
	{0x12000 & 0xFF, 0x120ff & 0xFF},
	{0x12100 & 0xFF, 0x121ff & 0xFF},
	{0x12200 & 0xFF, 0x122ff & 0xFF},
	{0x12300 & 0xFF, 0x12399 & 0xFF},
	{0x12400 & 0xFF, 0x1246e & 0xFF},
	{0x12480 & 0xFF, 0x124ff & 0xFF},
	{0x12500 & 0xFF, 0x12543 & 0xFF},
	{0x12f90 & 0xFF, 0x12ff0 & 0xFF},
	{0x13000 & 0xFF, 0x130ff & 0xFF},
	{0x13100 & 0xFF, 0x131ff & 0xFF},
	{0x13200 & 0xFF, 0x132ff & 0xFF},
	{0x13300 & 0xFF, 0x133ff & 0xFF},
	{0x13400 & 0xFF, 0x1342f & 0xFF},
	{0x13440 & 0xFF, 0x13455 & 0xFF},
	{0x14400 & 0xFF, 0x144ff & 0xFF},
	{0x14500 & 0xFF, 0x145ff & 0xFF},
	{0x14600 & 0xFF, 0x14646 & 0xFF},
	{0x16800 & 0xFF, 0x168ff & 0xFF},
	{0x16900 & 0xFF, 0x169ff & 0xFF},
	{0x16a00 & 0xFF, 0x16a38 & 0xFF},
	{0x16a40 & 0xFF, 0x16a5e & 0xFF},
	{0x16a60 & 0xFF, 0x16a69 & 0xFF},
	{0x16a70 & 0xFF, 0x16abe & 0xFF},
	{0x16ac0 & 0xFF, 0x16ac9 & 0xFF},
	{0x16ad0 & 0xFF, 0x16aed & 0xFF},
	{0x16af0 & 0xFF, 0x16af4 & 0xFF},
	{0x16b00 & 0xFF, 0x16b36 & 0xFF},
	{0x16b40 & 0xFF, 0x16b43 & 0xFF},
	{0x16b50 & 0xFF, 0x16b59 & 0xFF},
	{0x16b63 & 0xFF, 0x16b77 & 0xFF},
	{0x16b7d & 0xFF, 0x16b8f & 0xFF},
	{0x16e40 & 0xFF, 0x16e7f & 0xFF},
	{0x16f00 & 0xFF, 0x16f4a & 0xFF},
	{0x16f4f & 0xFF, 0x16f87 & 0xFF},
	{0x16f8f & 0xFF, 0x16f9f & 0xFF},
	{0x16fe0 & 0xFF, 0x16fe1 & 0xFF},
	{0x16fe3 & 0xFF, 0x16fe4 & 0xFF},
	{0x16ff0 & 0xFF, 0x16ff1 & 0xFF},
	{0x17000 & 0xFF, 0x170ff & 0xFF},
	{0x17100 & 0xFF, 0x171ff & 0xFF},
	{0x17200 & 0xFF, 0x172ff & 0xFF},
	{0x17300 & 0xFF, 0x173ff & 0xFF},
	{0x17400 & 0xFF, 0x174ff & 0xFF},
	{0x17500 & 0xFF, 0x175ff & 0xFF},
	{0x17600 & 0xFF, 0x176ff & 0xFF},
	{0x17700 & 0xFF, 0x177ff & 0xFF},
	{0x17800 & 0xFF, 0x178ff & 0xFF},
	{0x17900 & 0xFF, 0x179ff & 0xFF},
	{0x17a00 & 0xFF, 0x17aff & 0xFF},
	{0x17b00 & 0xFF, 0x17bff & 0xFF},
	{0x17c00 & 0xFF, 0x17cff & 0xFF},
	{0x17d00 & 0xFF, 0x17dff & 0xFF},
	{0x17e00 & 0xFF, 0x17eff & 0xFF},
	{0x17f00 & 0xFF, 0x17fff & 0xFF},
	{0x18000 & 0xFF, 0x180ff & 0xFF},
	{0x18100 & 0xFF, 0x181ff & 0xFF},
	{0x18200 & 0xFF, 0x182ff & 0xFF},
	{0x18300 & 0xFF, 0x183ff & 0xFF},
	{0x18400 & 0xFF, 0x184ff & 0xFF},
	{0x18500 & 0xFF, 0x185ff & 0xFF},
	{0x18600 & 0xFF, 0x186ff & 0xFF},
	{0x18700 & 0xFF, 0x187f7 & 0xFF},
	{0x18800 & 0xFF, 0x188ff & 0xFF},
	{0x18900 & 0xFF, 0x189ff & 0xFF},
	{0x18a00 & 0xFF, 0x18aff & 0xFF},
	{0x18b00 & 0xFF, 0x18bff & 0xFF},
	{0x18c00 & 0xFF, 0x18cd5 & 0xFF},
	{0x18d00 & 0xFF, 0x18d08 & 0xFF},
	{0x1aff0 & 0xFF, 0x1aff3 & 0xFF},
	{0x1aff5 & 0xFF, 0x1affb & 0xFF},
	{0x1affd & 0xFF, 0x1affe & 0xFF},
	{0x1b000 & 0xFF, 0x1b0ff & 0xFF},
	{0x1b100 & 0xFF, 0x1b122 & 0xFF},
	{0x1b132 & 0xFF, 0x1b132 & 0xFF},
	{0x1b150 & 0xFF, 0x1b152 & 0xFF},
	{0x1b155 & 0xFF, 0x1b155 & 0xFF},
	{0x1b164 & 0xFF, 0x1b167 & 0xFF},
	{0x1b170 & 0xFF, 0x1b1ff & 0xFF},
	{0x1b200 & 0xFF, 0x1b2fb & 0xFF},
	{0x1bc00 & 0xFF, 0x1bc6a & 0xFF},
	{0x1bc70 & 0xFF, 0x1bc7c & 0xFF},
	{0x1bc80 & 0xFF, 0x1bc88 & 0xFF},
	{0x1bc90 & 0xFF, 0x1bc99 & 0xFF},
	{0x1bc9d & 0xFF, 0x1bc9e & 0xFF},
	{0x1cf00 & 0xFF, 0x1cf2d & 0xFF},
	{0x1cf30 & 0xFF, 0x1cf46 & 0xFF},
	{0x1d165 & 0xFF, 0x1d169 & 0xFF},
	{0x1d16d & 0xFF, 0x1d172 & 0xFF},
	{0x1d17b & 0xFF, 0x1d182 & 0xFF},
	{0x1d185 & 0xFF, 0x1d18b & 0xFF},
	{0x1d1aa & 0xFF, 0x1d1ad & 0xFF},
	{0x1d242 & 0xFF, 0x1d244 & 0xFF},
	{0x1d400 & 0xFF, 0x1d454 & 0xFF},
	{0x1d456 & 0xFF, 0x1d49c & 0xFF},
	{0x1d49e & 0xFF, 0x1d49f & 0xFF},
	{0x1d4a2 & 0xFF, 0x1d4a2 & 0xFF},
	{0x1d4a5 & 0xFF, 0x1d4a6 & 0xFF},
	{0x1d4a9 & 0xFF, 0x1d4ac & 0xFF},
	{0x1d4ae & 0xFF, 0x1d4b9 & 0xFF},
	{0x1d4bb & 0xFF, 0x1d4bb & 0xFF},
	{0x1d4bd & 0xFF, 0x1d4c3 & 0xFF},
	{0x1d4c5 & 0xFF, 0x1d4ff & 0xFF},
	{0x1d500 & 0xFF, 0x1d505 & 0xFF},
	{0x1d507 & 0xFF, 0x1d50a & 0xFF},
	{0x1d50d & 0xFF, 0x1d514 & 0xFF},
	{0x1d516 & 0xFF, 0x1d51c & 0xFF},
	{0x1d51e & 0xFF, 0x1d539 & 0xFF},
	{0x1d53b & 0xFF, 0x1d53e & 0xFF},
	{0x1d540 & 0xFF, 0x1d544 & 0xFF},
	{0x1d546 & 0xFF, 0x1d546 & 0xFF},
	{0x1d54a & 0xFF, 0x1d550 & 0xFF},
	{0x1d552 & 0xFF, 0x1d5ff & 0xFF},
	{0x1d600 & 0xFF, 0x1d6a5 & 0xFF},
	{0x1d6a8 & 0xFF, 0x1d6c0 & 0xFF},
	{0x1d6c2 & 0xFF, 0x1d6da & 0xFF},
	{0x1d6dc & 0xFF, 0x1d6fa & 0xFF},
	{0x1d6fc & 0xFF, 0x1d6ff & 0xFF},
	{0x1d700 & 0xFF, 0x1d714 & 0xFF},
	{0x1d716 & 0xFF, 0x1d734 & 0xFF},
	{0x1d736 & 0xFF, 0x1d74e & 0xFF},
	{0x1d750 & 0xFF, 0x1d76e & 0xFF},
	{0x1d770 & 0xFF, 0x1d788 & 0xFF},
	{0x1d78a & 0xFF, 0x1d7a8 & 0xFF},
	{0x1d7aa & 0xFF, 0x1d7c2 & 0xFF},
	{0x1d7c4 & 0xFF, 0x1d7cb & 0xFF},
	{0x1d7ce & 0xFF, 0x1d7ff & 0xFF},
	{0x1da00 & 0xFF, 0x1da36 & 0xFF},
	{0x1da3b & 0xFF, 0x1da6c & 0xFF},
	{0x1da75 & 0xFF, 0x1da75 & 0xFF},
	{0x1da84 & 0xFF, 0x1da84 & 0xFF},
	{0x1da9b & 0xFF, 0x1da9f & 0xFF},
	{0x1daa1 & 0xFF, 0x1daaf & 0xFF},
	{0x1df00 & 0xFF, 0x1df1e & 0xFF},
	{0x1df25 & 0xFF, 0x1df2a & 0xFF},
	{0x1e000 & 0xFF, 0x1e006 & 0xFF},
	{0x1e008 & 0xFF, 0x1e018 & 0xFF},
	{0x1e01b & 0xFF, 0x1e021 & 0xFF},
	{0x1e023 & 0xFF, 0x1e024 & 0xFF},
	{0x1e026 & 0xFF, 0x1e02a & 0xFF},
	{0x1e030 & 0xFF, 0x1e06d & 0xFF},
	{0x1e08f & 0xFF, 0x1e08f & 0xFF},
	{0x1e100 & 0xFF, 0x1e12c & 0xFF},
	{0x1e130 & 0xFF, 0x1e13d & 0xFF},
	{0x1e140 & 0xFF, 0x1e149 & 0xFF},
	{0x1e14e & 0xFF, 0x1e14e & 0xFF},
	{0x1e290 & 0xFF, 0x1e2ae & 0xFF},
	{0x1e2c0 & 0xFF, 0x1e2f9 & 0xFF},
	{0x1e4d0 & 0xFF, 0x1e4f9 & 0xFF},
	{0x1e7e0 & 0xFF, 0x1e7e6 & 0xFF},
	{0x1e7e8 & 0xFF, 0x1e7eb & 0xFF},
	{0x1e7ed & 0xFF, 0x1e7ee & 0xFF},
	{0x1e7f0 & 0xFF, 0x1e7fe & 0xFF},
	{0x1e800 & 0xFF, 0x1e8c4 & 0xFF},
	{0x1e8d0 & 0xFF, 0x1e8d6 & 0xFF},
	{0x1e900 & 0xFF, 0x1e94b & 0xFF},
	{0x1e950 & 0xFF, 0x1e959 & 0xFF},
	{0x1ee00 & 0xFF, 0x1ee03 & 0xFF},
	{0x1ee05 & 0xFF, 0x1ee1f & 0xFF},
	{0x1ee21 & 0xFF, 0x1ee22 & 0xFF},
	{0x1ee24 & 0xFF, 0x1ee24 & 0xFF},
	{0x1ee27 & 0xFF, 0x1ee27 & 0xFF},
	{0x1ee29 & 0xFF, 0x1ee32 & 0xFF},
	{0x1ee34 & 0xFF, 0x1ee37 & 0xFF},
	{0x1ee39 & 0xFF, 0x1ee39 & 0xFF},
	{0x1ee3b & 0xFF, 0x1ee3b & 0xFF},
	{0x1ee42 & 0xFF, 0x1ee42 & 0xFF},
	{0x1ee47 & 0xFF, 0x1ee47 & 0xFF},
	{0x1ee49 & 0xFF, 0x1ee49 & 0xFF},
	{0x1ee4b & 0xFF, 0x1ee4b & 0xFF},
	{0x1ee4d & 0xFF, 0x1ee4f & 0xFF},
	{0x1ee51 & 0xFF, 0x1ee52 & 0xFF},
	{0x1ee54 & 0xFF, 0x1ee54 & 0xFF},
	{0x1ee57 & 0xFF, 0x1ee57 & 0xFF},
	{0x1ee59 & 0xFF, 0x1ee59 & 0xFF},
	{0x1ee5b & 0xFF, 0x1ee5b & 0xFF},
	{0x1ee5d & 0xFF, 0x1ee5d & 0xFF},
	{0x1ee5f & 0xFF, 0x1ee5f & 0xFF},
	{0x1ee61 & 0xFF, 0x1ee62 & 0xFF},
	{0x1ee64 & 0xFF, 0x1ee64 & 0xFF},
	{0x1ee67 & 0xFF, 0x1ee6a & 0xFF},
	{0x1ee6c & 0xFF, 0x1ee72 & 0xFF},
	{0x1ee74 & 0xFF, 0x1ee77 & 0xFF},
	{0x1ee79 & 0xFF, 0x1ee7c & 0xFF},
	{0x1ee7e & 0xFF, 0x1ee7e & 0xFF},
	{0x1ee80 & 0xFF, 0x1ee89 & 0xFF},
	{0x1ee8b & 0xFF, 0x1ee9b & 0xFF},
	{0x1eea1 & 0xFF, 0x1eea3 & 0xFF},
	{0x1eea5 & 0xFF, 0x1eea9 & 0xFF},
	{0x1eeab & 0xFF, 0x1eebb & 0xFF},
	{0x1fbf0 & 0xFF, 0x1fbf9 & 0xFF},
	{0x20000 & 0xFF, 0x200ff & 0xFF},
	{0x20100 & 0xFF, 0x201ff & 0xFF},
	{0x20200 & 0xFF, 0x202ff & 0xFF},
	{0x20300 & 0xFF, 0x203ff & 0xFF},
	{0x20400 & 0xFF, 0x204ff & 0xFF},
	{0x20500 & 0xFF, 0x205ff & 0xFF},
	{0x20600 & 0xFF, 0x206ff & 0xFF},
	{0x20700 & 0xFF, 0x207ff & 0xFF},
	{0x20800 & 0xFF, 0x208ff & 0xFF},
	{0x20900 & 0xFF, 0x209ff & 0xFF},
	{0x20a00 & 0xFF, 0x20aff & 0xFF},
	{0x20b00 & 0xFF, 0x20bff & 0xFF},
	{0x20c00 & 0xFF, 0x20cff & 0xFF},
	{0x20d00 & 0xFF, 0x20dff & 0xFF},
	{0x20e00 & 0xFF, 0x20eff & 0xFF},
	{0x20f00 & 0xFF, 0x20fff & 0xFF},
	{0x21000 & 0xFF, 0x210ff & 0xFF},
	{0x21100 & 0xFF, 0x211ff & 0xFF},
	{0x21200 & 0xFF, 0x212ff & 0xFF},
	{0x21300 & 0xFF, 0x213ff & 0xFF},
	{0x21400 & 0xFF, 0x214ff & 0xFF},
	{0x21500 & 0xFF, 0x215ff & 0xFF},
	{0x21600 & 0xFF, 0x216ff & 0xFF},
	{0x21700 & 0xFF, 0x217ff & 0xFF},
	{0x21800 & 0xFF, 0x218ff & 0xFF},
	{0x21900 & 0xFF, 0x219ff & 0xFF},
	{0x21a00 & 0xFF, 0x21aff & 0xFF},
	{0x21b00 & 0xFF, 0x21bff & 0xFF},
	{0x21c00 & 0xFF, 0x21cff & 0xFF},
	{0x21d00 & 0xFF, 0x21dff & 0xFF},
	{0x21e00 & 0xFF, 0x21eff & 0xFF},
	{0x21f00 & 0xFF, 0x21fff & 0xFF},
	{0x22000 & 0xFF, 0x220ff & 0xFF},
	{0x22100 & 0xFF, 0x221ff & 0xFF},
	{0x22200 & 0xFF, 0x222ff & 0xFF},
	{0x22300 & 0xFF, 0x223ff & 0xFF},
	{0x22400 & 0xFF, 0x224ff & 0xFF},
	{0x22500 & 0xFF, 0x225ff & 0xFF},
	{0x22600 & 0xFF, 0x226ff & 0xFF},
	{0x22700 & 0xFF, 0x227ff & 0xFF},
	{0x22800 & 0xFF, 0x228ff & 0xFF},
	{0x22900 & 0xFF, 0x229ff & 0xFF},
	{0x22a00 & 0xFF, 0x22aff & 0xFF},
	{0x22b00 & 0xFF, 0x22bff & 0xFF},
	{0x22c00 & 0xFF, 0x22cff & 0xFF},
	{0x22d00 & 0xFF, 0x22dff & 0xFF},
	{0x22e00 & 0xFF, 0x22eff & 0xFF},
	{0x22f00 & 0xFF, 0x22fff & 0xFF},
	{0x23000 & 0xFF, 0x230ff & 0xFF},
	{0x23100 & 0xFF, 0x231ff & 0xFF},
	{0x23200 & 0xFF, 0x232ff & 0xFF},
	{0x23300 & 0xFF, 0x233ff & 0xFF},
	{0x23400 & 0xFF, 0x234ff & 0xFF},
	{0x23500 & 0xFF, 0x235ff & 0xFF},
	{0x23600 & 0xFF, 0x236ff & 0xFF},
	{0x23700 & 0xFF, 0x237ff & 0xFF},
	{0x23800 & 0xFF, 0x238ff & 0xFF},
	{0x23900 & 0xFF, 0x239ff & 0xFF},
	{0x23a00 & 0xFF, 0x23aff & 0xFF},
	{0x23b00 & 0xFF, 0x23bff & 0xFF},
	{0x23c00 & 0xFF, 0x23cff & 0xFF},
	{0x23d00 & 0xFF, 0x23dff & 0xFF},
	{0x23e00 & 0xFF, 0x23eff & 0xFF},
	{0x23f00 & 0xFF, 0x23fff & 0xFF},
	{0x24000 & 0xFF, 0x240ff & 0xFF},
	{0x24100 & 0xFF, 0x241ff & 0xFF},
	{0x24200 & 0xFF, 0x242ff & 0xFF},
	{0x24300 & 0xFF, 0x243ff & 0xFF},
	{0x24400 & 0xFF, 0x244ff & 0xFF},
	{0x24500 & 0xFF, 0x245ff & 0xFF},
	{0x24600 & 0xFF, 0x246ff & 0xFF},
	{0x24700 & 0xFF, 0x247ff & 0xFF},
	{0x24800 & 0xFF, 0x248ff & 0xFF},
	{0x24900 & 0xFF, 0x249ff & 0xFF},
	{0x24a00 & 0xFF, 0x24aff & 0xFF},
	{0x24b00 & 0xFF, 0x24bff & 0xFF},
	{0x24c00 & 0xFF, 0x24cff & 0xFF},
	{0x24d00 & 0xFF, 0x24dff & 0xFF},
	{0x24e00 & 0xFF, 0x24eff & 0xFF},
	{0x24f00 & 0xFF, 0x24fff & 0xFF},
	{0x25000 & 0xFF, 0x250ff & 0xFF},
	{0x25100 & 0xFF, 0x251ff & 0xFF},
	{0x25200 & 0xFF, 0x252ff & 0xFF},
	{0x25300 & 0xFF, 0x253ff & 0xFF},
	{0x25400 & 0xFF, 0x254ff & 0xFF},
	{0x25500 & 0xFF, 0x255ff & 0xFF},
	{0x25600 & 0xFF, 0x256ff & 0xFF},
	{0x25700 & 0xFF, 0x257ff & 0xFF},
	{0x25800 & 0xFF, 0x258ff & 0xFF},
	{0x25900 & 0xFF, 0x259ff & 0xFF},
	{0x25a00 & 0xFF, 0x25aff & 0xFF},
	{0x25b00 & 0xFF, 0x25bff & 0xFF},
	{0x25c00 & 0xFF, 0x25cff & 0xFF},
	{0x25d00 & 0xFF, 0x25dff & 0xFF},
	{0x25e00 & 0xFF, 0x25eff & 0xFF},
	{0x25f00 & 0xFF, 0x25fff & 0xFF},
	{0x26000 & 0xFF, 0x260ff & 0xFF},
	{0x26100 & 0xFF, 0x261ff & 0xFF},
	{0x26200 & 0xFF, 0x262ff & 0xFF},
	{0x26300 & 0xFF, 0x263ff & 0xFF},
	{0x26400 & 0xFF, 0x264ff & 0xFF},
	{0x26500 & 0xFF, 0x265ff & 0xFF},
	{0x26600 & 0xFF, 0x266ff & 0xFF},
	{0x26700 & 0xFF, 0x267ff & 0xFF},
	{0x26800 & 0xFF, 0x268ff & 0xFF},
	{0x26900 & 0xFF, 0x269ff & 0xFF},
	{0x26a00 & 0xFF, 0x26aff & 0xFF},
	{0x26b00 & 0xFF, 0x26bff & 0xFF},
	{0x26c00 & 0xFF, 0x26cff & 0xFF},
	{0x26d00 & 0xFF, 0x26dff & 0xFF},
	{0x26e00 & 0xFF, 0x26eff & 0xFF},
	{0x26f00 & 0xFF, 0x26fff & 0xFF},
	{0x27000 & 0xFF, 0x270ff & 0xFF},
	{0x27100 & 0xFF, 0x271ff & 0xFF},
	{0x27200 & 0xFF, 0x272ff & 0xFF},
	{0x27300 & 0xFF, 0x273ff & 0xFF},
	{0x27400 & 0xFF, 0x274ff & 0xFF},
	{0x27500 & 0xFF, 0x275ff & 0xFF},
	{0x27600 & 0xFF, 0x276ff & 0xFF},
	{0x27700 & 0xFF, 0x277ff & 0xFF},
	{0x27800 & 0xFF, 0x278ff & 0xFF},
	{0x27900 & 0xFF, 0x279ff & 0xFF},
	{0x27a00 & 0xFF, 0x27aff & 0xFF},
	{0x27b00 & 0xFF, 0x27bff & 0xFF},
	{0x27c00 & 0xFF, 0x27cff & 0xFF},
	{0x27d00 & 0xFF, 0x27dff & 0xFF},
	{0x27e00 & 0xFF, 0x27eff & 0xFF},
	{0x27f00 & 0xFF, 0x27fff & 0xFF},
	{0x28000 & 0xFF, 0x280ff & 0xFF},
	{0x28100 & 0xFF, 0x281ff & 0xFF},
	{0x28200 & 0xFF, 0x282ff & 0xFF},
	{0x28300 & 0xFF, 0x283ff & 0xFF},
	{0x28400 & 0xFF, 0x284ff & 0xFF},
	{0x28500 & 0xFF, 0x285ff & 0xFF},
	{0x28600 & 0xFF, 0x286ff & 0xFF},
	{0x28700 & 0xFF, 0x287ff & 0xFF},
	{0x28800 & 0xFF, 0x288ff & 0xFF},
	{0x28900 & 0xFF, 0x289ff & 0xFF},
	{0x28a00 & 0xFF, 0x28aff & 0xFF},
	{0x28b00 & 0xFF, 0x28bff & 0xFF},
	{0x28c00 & 0xFF, 0x28cff & 0xFF},
	{0x28d00 & 0xFF, 0x28dff & 0xFF},
	{0x28e00 & 0xFF, 0x28eff & 0xFF},
	{0x28f00 & 0xFF, 0x28fff & 0xFF},
	{0x29000 & 0xFF, 0x290ff & 0xFF},
	{0x29100 & 0xFF, 0x291ff & 0xFF},
	{0x29200 & 0xFF, 0x292ff & 0xFF},
	{0x29300 & 0xFF, 0x293ff & 0xFF},
	{0x29400 & 0xFF, 0x294ff & 0xFF},
	{0x29500 & 0xFF, 0x295ff & 0xFF},
	{0x29600 & 0xFF, 0x296ff & 0xFF},
	{0x29700 & 0xFF, 0x297ff & 0xFF},
	{0x29800 & 0xFF, 0x298ff & 0xFF},
	{0x29900 & 0xFF, 0x299ff & 0xFF},
	{0x29a00 & 0xFF, 0x29aff & 0xFF},
	{0x29b00 & 0xFF, 0x29bff & 0xFF},
	{0x29c00 & 0xFF, 0x29cff & 0xFF},
	{0x29d00 & 0xFF, 0x29dff & 0xFF},
	{0x29e00 & 0xFF, 0x29eff & 0xFF},
	{0x29f00 & 0xFF, 0x29fff & 0xFF},
	{0x2a000 & 0xFF, 0x2a0ff & 0xFF},
	{0x2a100 & 0xFF, 0x2a1ff & 0xFF},
	{0x2a200 & 0xFF, 0x2a2ff & 0xFF},
	{0x2a300 & 0xFF, 0x2a3ff & 0xFF},
	{0x2a400 & 0xFF, 0x2a4ff & 0xFF},
	{0x2a500 & 0xFF, 0x2a5ff & 0xFF},
	{0x2a600 & 0xFF, 0x2a6df & 0xFF},
	{0x2a700 & 0xFF, 0x2a7ff & 0xFF},
	{0x2a800 & 0xFF, 0x2a8ff & 0xFF},
	{0x2a900 & 0xFF, 0x2a9ff & 0xFF},
	{0x2aa00 & 0xFF, 0x2aaff & 0xFF},
	{0x2ab00 & 0xFF, 0x2abff & 0xFF},
	{0x2ac00 & 0xFF, 0x2acff & 0xFF},
	{0x2ad00 & 0xFF, 0x2adff & 0xFF},
	{0x2ae00 & 0xFF, 0x2aeff & 0xFF},
	{0x2af00 & 0xFF, 0x2afff & 0xFF},
	{0x2b000 & 0xFF, 0x2b0ff & 0xFF},
	{0x2b100 & 0xFF, 0x2b1ff & 0xFF},
	{0x2b200 & 0xFF, 0x2b2ff & 0xFF},
	{0x2b300 & 0xFF, 0x2b3ff & 0xFF},
	{0x2b400 & 0xFF, 0x2b4ff & 0xFF},
	{0x2b500 & 0xFF, 0x2b5ff & 0xFF},
	{0x2b600 & 0xFF, 0x2b6ff & 0xFF},
	{0x2b700 & 0xFF, 0x2b739 & 0xFF},
	{0x2b740 & 0xFF, 0x2b7ff & 0xFF},
	{0x2b800 & 0xFF, 0x2b81d & 0xFF},
	{0x2b820 & 0xFF, 0x2b8ff & 0xFF},
	{0x2b900 & 0xFF, 0x2b9ff & 0xFF},
	{0x2ba00 & 0xFF, 0x2baff & 0xFF},
	{0x2bb00 & 0xFF, 0x2bbff & 0xFF},
	{0x2bc00 & 0xFF, 0x2bcff & 0xFF},
	{0x2bd00 & 0xFF, 0x2bdff & 0xFF},
	{0x2be00 & 0xFF, 0x2beff & 0xFF},
	{0x2bf00 & 0xFF, 0x2bfff & 0xFF},
	{0x2c000 & 0xFF, 0x2c0ff & 0xFF},
	{0x2c100 & 0xFF, 0x2c1ff & 0xFF},
	{0x2c200 & 0xFF, 0x2c2ff & 0xFF},
	{0x2c300 & 0xFF, 0x2c3ff & 0xFF},
	{0x2c400 & 0xFF, 0x2c4ff & 0xFF},
	{0x2c500 & 0xFF, 0x2c5ff & 0xFF},
	{0x2c600 & 0xFF, 0x2c6ff & 0xFF},
	{0x2c700 & 0xFF, 0x2c7ff & 0xFF},
	{0x2c800 & 0xFF, 0x2c8ff & 0xFF},
	{0x2c900 & 0xFF, 0x2c9ff & 0xFF},
	{0x2ca00 & 0xFF, 0x2caff & 0xFF},
	{0x2cb00 & 0xFF, 0x2cbff & 0xFF},
	{0x2cc00 & 0xFF, 0x2ccff & 0xFF},
	{0x2cd00 & 0xFF, 0x2cdff & 0xFF},
	{0x2ce00 & 0xFF, 0x2cea1 & 0xFF},
	{0x2ceb0 & 0xFF, 0x2ceff & 0xFF},
	{0x2cf00 & 0xFF, 0x2cfff & 0xFF},
	{0x2d000 & 0xFF, 0x2d0ff & 0xFF},
	{0x2d100 & 0xFF, 0x2d1ff & 0xFF},
	{0x2d200 & 0xFF, 0x2d2ff & 0xFF},
	{0x2d300 & 0xFF, 0x2d3ff & 0xFF},
	{0x2d400 & 0xFF, 0x2d4ff & 0xFF},
	{0x2d500 & 0xFF, 0x2d5ff & 0xFF},
	{0x2d600 & 0xFF, 0x2d6ff & 0xFF},
	{0x2d700 & 0xFF, 0x2d7ff & 0xFF},
	{0x2d800 & 0xFF, 0x2d8ff & 0xFF},
	{0x2d900 & 0xFF, 0x2d9ff & 0xFF},
	{0x2da00 & 0xFF, 0x2daff & 0xFF},
	{0x2db00 & 0xFF, 0x2dbff & 0xFF},
	{0x2dc00 & 0xFF, 0x2dcff & 0xFF},
	{0x2dd00 & 0xFF, 0x2ddff & 0xFF},
	{0x2de00 & 0xFF, 0x2deff & 0xFF},
	{0x2df00 & 0xFF, 0x2dfff & 0xFF},
	{0x2e000 & 0xFF, 0x2e0ff & 0xFF},
	{0x2e100 & 0xFF, 0x2e1ff & 0xFF},
	{0x2e200 & 0xFF, 0x2e2ff & 0xFF},
	{0x2e300 & 0xFF, 0x2e3ff & 0xFF},
	{0x2e400 & 0xFF, 0x2e4ff & 0xFF},
	{0x2e500 & 0xFF, 0x2e5ff & 0xFF},
	{0x2e600 & 0xFF, 0x2e6ff & 0xFF},
	{0x2e700 & 0xFF, 0x2e7ff & 0xFF},
	{0x2e800 & 0xFF, 0x2e8ff & 0xFF},
	{0x2e900 & 0xFF, 0x2e9ff & 0xFF},
	{0x2ea00 & 0xFF, 0x2eaff & 0xFF},
	{0x2eb00 & 0xFF, 0x2ebe0 & 0xFF},
	{0x2ebf0 & 0xFF, 0x2ebff & 0xFF},
	{0x2ec00 & 0xFF, 0x2ecff & 0xFF},
	{0x2ed00 & 0xFF, 0x2edff & 0xFF},
	{0x2ee00 & 0xFF, 0x2ee5d & 0xFF},
	{0x2f800 & 0xFF, 0x2f8ff & 0xFF},
	{0x2f900 & 0xFF, 0x2f9ff & 0xFF},
	{0x2fa00 & 0xFF, 0x2fa1d & 0xFF},
	{0x30000 & 0xFF, 0x300ff & 0xFF},
	{0x30100 & 0xFF, 0x301ff & 0xFF},
	{0x30200 & 0xFF, 0x302ff & 0xFF},
	{0x30300 & 0xFF, 0x303ff & 0xFF},
	{0x30400 & 0xFF, 0x304ff & 0xFF},
	{0x30500 & 0xFF, 0x305ff & 0xFF},
	{0x30600 & 0xFF, 0x306ff & 0xFF},
	{0x30700 & 0xFF, 0x307ff & 0xFF},
	{0x30800 & 0xFF, 0x308ff & 0xFF},
	{0x30900 & 0xFF, 0x309ff & 0xFF},
	{0x30a00 & 0xFF, 0x30aff & 0xFF},
	{0x30b00 & 0xFF, 0x30bff & 0xFF},
	{0x30c00 & 0xFF, 0x30cff & 0xFF},
	{0x30d00 & 0xFF, 0x30dff & 0xFF},
	{0x30e00 & 0xFF, 0x30eff & 0xFF},
	{0x30f00 & 0xFF, 0x30fff & 0xFF},
	{0x31000 & 0xFF, 0x310ff & 0xFF},
	{0x31100 & 0xFF, 0x311ff & 0xFF},
	{0x31200 & 0xFF, 0x312ff & 0xFF},
	{0x31300 & 0xFF, 0x3134a & 0xFF},
	{0x31350 & 0xFF, 0x313ff & 0xFF},
	{0x31400 & 0xFF, 0x314ff & 0xFF},
	{0x31500 & 0xFF, 0x315ff & 0xFF},
	{0x31600 & 0xFF, 0x316ff & 0xFF},
	{0x31700 & 0xFF, 0x317ff & 0xFF},
	{0x31800 & 0xFF, 0x318ff & 0xFF},
	{0x31900 & 0xFF, 0x319ff & 0xFF},
	{0x31a00 & 0xFF, 0x31aff & 0xFF},
	{0x31b00 & 0xFF, 0x31bff & 0xFF},
	{0x31c00 & 0xFF, 0x31cff & 0xFF},
	{0x31d00 & 0xFF, 0x31dff & 0xFF},
	{0x31e00 & 0xFF, 0x31eff & 0xFF},
	{0x31f00 & 0xFF, 0x31fff & 0xFF},
	{0x32000 & 0xFF, 0x320ff & 0xFF},
	{0x32100 & 0xFF, 0x321ff & 0xFF},
	{0x32200 & 0xFF, 0x322ff & 0xFF},
	{0x32300 & 0xFF, 0x323af & 0xFF},
	{0xe0100 & 0xFF, 0xe01ef & 0xFF}};

static const size_t XID_Continue_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	30,
	31,
	32,
	33,
	44,
	45,
	48,
	49,
	52,
	53,
	54,
	55,
	56,
	57,
	58,
	59,
	60,
	61,
	62,
	63,
	64,
	65,
	66,
	67,
	68,
	69,
	70,
	71,
	72,
	73,
	74,
	75,
	76,
	77,
	78,
	79,
	80,
	81,
	82,
	83,
	84,
	85,
	86,
	87,
	88,
	89,
	90,
	91,
	92,
	93,
	94,
	95,
	96,
	97,
	98,
	99,
	100,
	101,
	102,
	103,
	104,
	105,
	106,
	107,
	108,
	109,
	110,
	111,
	112,
	113,
	114,
	115,
	116,
	117,
	118,
	119,
	120,
	121,
	122,
	123,
	124,
	125,
	126,
	127,
	128,
	129,
	130,
	131,
	132,
	133,
	134,
	135,
	136,
	137,
	138,
	139,
	140,
	141,
	142,
	143,
	144,
	145,
	146,
	147,
	148,
	149,
	150,
	151,
	152,
	153,
	154,
	155,
	156,
	157,
	158,
	159,
	160,
	161,
	162,
	163,
	164,
	165,
	166,
	167,
	168,
	169,
	170,
	171,
	172,
	173,
	174,
	175,
	176,
	177,
	178,
	179,
	180,
	181,
	182,
	183,
	184,
	185,
	186,
	187,
	188,
	189,
	190,
	191,
	192,
	193,
	194,
	195,
	196,
	197,
	198,
	199,
	200,
	201,
	202,
	203,
	204,
	205,
	206,
	207,
	208,
	209,
	210,
	211,
	212,
	213,
	214,
	215,
	249,
	250,
	251,
	252,
	253,
	254,
	255,
	256,
	257,
	258,
	259,
	260,
	261,
	262,
	263,
	264,
	265,
	266,
	267,
	268,
	269,
	270,
	271,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	284,
	285,
	286,
	287,
	288,
	289,
	290,
	291,
	292,
	293,
	303,
	304,
	305,
	306,
	307,
	308,
	324,
	325,
	326,
	360,
	361,
	362,
	363,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	431,
	432,
	433,
	434,
	444,
	463,
	465,
	466,
	468,
	469,
	470,
	471,
	474,
	479,
	480,
	481,
	482,
	484,
	487,
	488,
	489,
	494,
	507,
	512,
	513,
	514,
	515,
	516,
	517,
	518,
	519,
	520,
	521,
	522,
	523,
	524,
	525,
	526,
	527,
	528,
	529,
	530,
	531,
	532,
	533,
	534,
	535,
	536,
	537,
	538,
	539,
	540,
	541,
	542,
	543,
	544,
	545,
	546,
	547,
	548,
	549,
	550,
	551,
	552,
	553,
	554,
	555,
	556,
	557,
	558,
	559,
	560,
	561,
	562,
	563,
	564,
	565,
	566,
	567,
	568,
	569,
	570,
	571,
	572,
	573,
	574,
	575,
	576,
	577,
	578,
	579,
	580,
	581,
	582,
	583,
	584,
	585,
	586,
	587,
	588,
	589,
	590,
	591,
	592,
	593,
	594,
	595,
	596,
	597,
	598,
	599,
	600,
	601,
	602,
	603,
	604,
	605,
	606,
	607,
	608,
	609,
	610,
	611,
	612,
	613,
	614,
	615,
	616,
	617,
	618,
	619,
	620,
	621,
	622,
	623,
	624,
	625,
	626,
	627,
	628,
	629,
	630,
	631,
	632,
	633,
	634,
	635,
	636,
	637,
	638,
	639,
	640,
	641,
	642,
	643,
	644,
	645,
	646,
	647,
	648,
	649,
	650,
	651,
	652,
	653,
	654,
	655,
	656,
	657,
	658,
	659,
	660,
	661,
	662,
	663,
	664,
	665,
	666,
	667,
	668,
	669,
	670,
	671,
	672,
	673,
	674,
	675,
	676,
	677,
	678,
	679,
	680,
	681,
	682,
	683,
	684,
	685,
	686,
	687,
	688,
	689,
	690,
	691,
	692,
	693,
	694,
	695,
	696,
	697,
	698,
	699,
	700,
	701,
	702,
	703,
	704,
	705,
	706,
	707,
	708,
	709,
	710,
	711,
	712,
	713,
	714,
	715,
	716,
	717,
	718,
	719,
	720,
	721,
	722,
	723,
	724,
	725,
	726,
	727,
	728,
	729,
	730,
	731,
	732,
	733,
	734,
	735,
	736,
	737,
	738,
	739,
	740,
	741,
	742,
	743,
	744,
	745,
	746,
	747,
	748,
	749,
	750,
	760,
	761,
	762,
	768,
	769,
	770,
	771,
	772,
	773,
	774,
	775,
	776,
	777,
	778,
	779,
	780,
	781,
	782,
	783,
	784,
	785,
	786,
	787,
	788,
	789,
	790,
	791,
	792,
	793,
	794,
	795,
	796,
	797,
	798,
	799,
	800,
	801,
	802,
	803,
	3585
};

static const char32_t XID_Continue_starting_pagetab[]={
	0,
	11,
	12,
	17,
	26,
	29,
	40,
	47,
	52,
	59,
	77,
	107,
	138,
	164,
	185,
	199,
	211,
	218,
	219,
	233,
	241,
	242,
	243,
	248,
	258,
	263,
	271,
	279,
	283,
	291,
	292,
	293,
	312,
	321,
	334,
	336,
	351,
	359,
	363,
	364,
	365,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	398,
	399,
	400,
	401,
	402,
	403,
	404,
	405,
	406,
	407,
	408,
	409,
	410,
	411,
	412,
	413,
	414,
	415,
	416,
	417,
	418,
	419,
	420,
	421,
	422,
	423,
	424,
	425,
	426,
	427,
	428,
	429,
	430,
	431,
	432,
	433,
	434,
	435,
	436,
	437,
	438,
	439,
	440,
	441,
	442,
	443,
	444,
	445,
	446,
	447,
	448,
	449,
	450,
	451,
	452,
	453,
	454,
	455,
	456,
	457,
	458,
	459,
	460,
	461,
	462,
	463,
	464,
	465,
	466,
	467,
	468,
	469,
	470,
	471,
	472,
	473,
	474,
	475,
	477,
	478,
	483,
	490,
	498,
	504,
	512,
	522,
	523,
	524,
	525,
	526,
	527,
	528,
	529,
	530,
	531,
	532,
	533,
	534,
	535,
	536,
	537,
	538,
	539,
	540,
	541,
	542,
	543,
	544,
	545,
	546,
	547,
	548,
	549,
	550,
	551,
	552,
	553,
	554,
	555,
	556,
	557,
	558,
	559,
	560,
	561,
	562,
	563,
	564,
	565,
	568,
	569,
	571,
	581,
	583,
	587,
	598,
	607,
	614,
	616,
	619,
	626,
	630,
	640,
	641,
	647,
	657,
	661,
	672,
	676,
	679,
	681,
	685,
	691,
	697,
	706,
	716,
	731,
	737,
	740,
	745,
	749,
	752,
	764,
	769,
	776,
	789,
	790,
	795,
	796,
	797,
	798,
	799,
	801,
	802,
	803,
	804,
	805,
	806,
	807,
	809,
	810,
	811,
	812,
	813,
	814,
	821,
	826,
	827,
	833,
	834,
	835,
	836,
	837,
	838,
	839,
	840,
	841,
	842,
	843,
	844,
	845,
	846,
	847,
	848,
	849,
	850,
	851,
	852,
	853,
	854,
	855,
	856,
	857,
	858,
	859,
	860,
	861,
	862,
	863,
	866,
	867,
	873,
	874,
	879,
	881,
	886,
	887,
	897,
	907,
	912,
	921,
	927,
	929,
	936,
	940,
	942,
	943,
	947,
	949,
	951,
	984,
	985,
	986,
	987,
	988,
	989,
	990,
	991,
	992,
	993,
	994,
	995,
	996,
	997,
	998,
	999,
	1000,
	1001,
	1002,
	1003,
	1004,
	1005,
	1006,
	1007,
	1008,
	1009,
	1010,
	1011,
	1012,
	1013,
	1014,
	1015,
	1016,
	1017,
	1018,
	1019,
	1020,
	1021,
	1022,
	1023,
	1024,
	1025,
	1026,
	1027,
	1028,
	1029,
	1030,
	1031,
	1032,
	1033,
	1034,
	1035,
	1036,
	1037,
	1038,
	1039,
	1040,
	1041,
	1042,
	1043,
	1044,
	1045,
	1046,
	1047,
	1048,
	1049,
	1050,
	1051,
	1052,
	1053,
	1054,
	1055,
	1056,
	1057,
	1058,
	1059,
	1060,
	1061,
	1062,
	1063,
	1064,
	1065,
	1066,
	1067,
	1068,
	1069,
	1070,
	1071,
	1072,
	1073,
	1074,
	1075,
	1076,
	1077,
	1078,
	1079,
	1080,
	1081,
	1082,
	1083,
	1084,
	1085,
	1086,
	1087,
	1088,
	1089,
	1090,
	1091,
	1092,
	1093,
	1094,
	1095,
	1096,
	1097,
	1098,
	1099,
	1100,
	1101,
	1102,
	1103,
	1104,
	1105,
	1106,
	1107,
	1108,
	1109,
	1110,
	1111,
	1112,
	1113,
	1114,
	1115,
	1116,
	1117,
	1118,
	1119,
	1120,
	1121,
	1122,
	1123,
	1124,
	1125,
	1126,
	1127,
	1128,
	1129,
	1130,
	1131,
	1132,
	1133,
	1134,
	1135,
	1136,
	1137,
	1138,
	1139,
	1140,
	1141,
	1142,
	1143,
	1144,
	1145,
	1146,
	1147,
	1148,
	1149,
	1150,
	1151,
	1152,
	1153,
	1154,
	1155,
	1156,
	1157,
	1158,
	1159,
	1160,
	1161,
	1162,
	1163,
	1164,
	1165,
	1166,
	1167,
	1168,
	1170,
	1172,
	1173,
	1174,
	1175,
	1176,
	1177,
	1178,
	1179,
	1180,
	1181,
	1182,
	1183,
	1184,
	1185,
	1186,
	1187,
	1188,
	1189,
	1190,
	1191,
	1192,
	1193,
	1195,
	1196,
	1197,
	1198,
	1199,
	1200,
	1201,
	1202,
	1203,
	1204,
	1205,
	1206,
	1207,
	1208,
	1209,
	1210,
	1211,
	1212,
	1213,
	1214,
	1215,
	1216,
	1217,
	1218,
	1219,
	1220,
	1221,
	1222,
	1223,
	1225,
	1226,
	1227,
	1228,
	1229,
	1230,
	1231,
	1232,
	1233,
	1234,
	1235,
	1236,
	1237,
	1238,
	1239,
	1240,
	1241,
	1242,
	1243,
	1244,
	1245,
	1246,
	1247,
	1248,
	1249,
	1250,
	1252,
	1253,
	1254,
	1255,
	1256,
	1257,
	1258,
	1259,
	1260,
	1261,
	1262,
	1263,
	1264,
	1265,
	1266,
	1267,
	1268
};

static const uint8_t XID_Start_rangetab[][2]={
	{0x0041 & 0xFF, 0x005a & 0xFF},
	{0x0061 & 0xFF, 0x007a & 0xFF},
	{0x00aa & 0xFF, 0x00aa & 0xFF},
	{0x00b5 & 0xFF, 0x00b5 & 0xFF},
	{0x00ba & 0xFF, 0x00ba & 0xFF},
	{0x00c0 & 0xFF, 0x00d6 & 0xFF},
	{0x00d8 & 0xFF, 0x00f6 & 0xFF},
	{0x00f8 & 0xFF, 0x00ff & 0xFF},
	{0x0100 & 0xFF, 0x01ff & 0xFF},
	{0x0200 & 0xFF, 0x02c1 & 0xFF},
	{0x02c6 & 0xFF, 0x02d1 & 0xFF},
	{0x02e0 & 0xFF, 0x02e4 & 0xFF},
	{0x02ec & 0xFF, 0x02ec & 0xFF},
	{0x02ee & 0xFF, 0x02ee & 0xFF},
	{0x0370 & 0xFF, 0x0374 & 0xFF},
	{0x0376 & 0xFF, 0x0377 & 0xFF},
	{0x037b & 0xFF, 0x037d & 0xFF},
	{0x037f & 0xFF, 0x037f & 0xFF},
	{0x0386 & 0xFF, 0x0386 & 0xFF},
	{0x0388 & 0xFF, 0x038a & 0xFF},
	{0x038c & 0xFF, 0x038c & 0xFF},
	{0x038e & 0xFF, 0x03a1 & 0xFF},
	{0x03a3 & 0xFF, 0x03f5 & 0xFF},
	{0x03f7 & 0xFF, 0x03ff & 0xFF},
	{0x0400 & 0xFF, 0x0481 & 0xFF},
	{0x048a & 0xFF, 0x04ff & 0xFF},
	{0x0500 & 0xFF, 0x052f & 0xFF},
	{0x0531 & 0xFF, 0x0556 & 0xFF},
	{0x0559 & 0xFF, 0x0559 & 0xFF},
	{0x0560 & 0xFF, 0x0588 & 0xFF},
	{0x05d0 & 0xFF, 0x05ea & 0xFF},
	{0x05ef & 0xFF, 0x05f2 & 0xFF},
	{0x0620 & 0xFF, 0x064a & 0xFF},
	{0x066e & 0xFF, 0x066f & 0xFF},
	{0x0671 & 0xFF, 0x06d3 & 0xFF},
	{0x06d5 & 0xFF, 0x06d5 & 0xFF},
	{0x06e5 & 0xFF, 0x06e6 & 0xFF},
	{0x06ee & 0xFF, 0x06ef & 0xFF},
	{0x06fa & 0xFF, 0x06fc & 0xFF},
	{0x06ff & 0xFF, 0x06ff & 0xFF},
	{0x0710 & 0xFF, 0x0710 & 0xFF},
	{0x0712 & 0xFF, 0x072f & 0xFF},
	{0x074d & 0xFF, 0x07a5 & 0xFF},
	{0x07b1 & 0xFF, 0x07b1 & 0xFF},
	{0x07ca & 0xFF, 0x07ea & 0xFF},
	{0x07f4 & 0xFF, 0x07f5 & 0xFF},
	{0x07fa & 0xFF, 0x07fa & 0xFF},
	{0x0800 & 0xFF, 0x0815 & 0xFF},
	{0x081a & 0xFF, 0x081a & 0xFF},
	{0x0824 & 0xFF, 0x0824 & 0xFF},
	{0x0828 & 0xFF, 0x0828 & 0xFF},
	{0x0840 & 0xFF, 0x0858 & 0xFF},
	{0x0860 & 0xFF, 0x086a & 0xFF},
	{0x0870 & 0xFF, 0x0887 & 0xFF},
	{0x0889 & 0xFF, 0x088e & 0xFF},
	{0x08a0 & 0xFF, 0x08c9 & 0xFF},
	{0x0904 & 0xFF, 0x0939 & 0xFF},
	{0x093d & 0xFF, 0x093d & 0xFF},
	{0x0950 & 0xFF, 0x0950 & 0xFF},
	{0x0958 & 0xFF, 0x0961 & 0xFF},
	{0x0971 & 0xFF, 0x0980 & 0xFF},
	{0x0985 & 0xFF, 0x098c & 0xFF},
	{0x098f & 0xFF, 0x0990 & 0xFF},
	{0x0993 & 0xFF, 0x09a8 & 0xFF},
	{0x09aa & 0xFF, 0x09b0 & 0xFF},
	{0x09b2 & 0xFF, 0x09b2 & 0xFF},
	{0x09b6 & 0xFF, 0x09b9 & 0xFF},
	{0x09bd & 0xFF, 0x09bd & 0xFF},
	{0x09ce & 0xFF, 0x09ce & 0xFF},
	{0x09dc & 0xFF, 0x09dd & 0xFF},
	{0x09df & 0xFF, 0x09e1 & 0xFF},
	{0x09f0 & 0xFF, 0x09f1 & 0xFF},
	{0x09fc & 0xFF, 0x09fc & 0xFF},
	{0x0a05 & 0xFF, 0x0a0a & 0xFF},
	{0x0a0f & 0xFF, 0x0a10 & 0xFF},
	{0x0a13 & 0xFF, 0x0a28 & 0xFF},
	{0x0a2a & 0xFF, 0x0a30 & 0xFF},
	{0x0a32 & 0xFF, 0x0a33 & 0xFF},
	{0x0a35 & 0xFF, 0x0a36 & 0xFF},
	{0x0a38 & 0xFF, 0x0a39 & 0xFF},
	{0x0a59 & 0xFF, 0x0a5c & 0xFF},
	{0x0a5e & 0xFF, 0x0a5e & 0xFF},
	{0x0a72 & 0xFF, 0x0a74 & 0xFF},
	{0x0a85 & 0xFF, 0x0a8d & 0xFF},
	{0x0a8f & 0xFF, 0x0a91 & 0xFF},
	{0x0a93 & 0xFF, 0x0aa8 & 0xFF},
	{0x0aaa & 0xFF, 0x0ab0 & 0xFF},
	{0x0ab2 & 0xFF, 0x0ab3 & 0xFF},
	{0x0ab5 & 0xFF, 0x0ab9 & 0xFF},
	{0x0abd & 0xFF, 0x0abd & 0xFF},
	{0x0ad0 & 0xFF, 0x0ad0 & 0xFF},
	{0x0ae0 & 0xFF, 0x0ae1 & 0xFF},
	{0x0af9 & 0xFF, 0x0af9 & 0xFF},
	{0x0b05 & 0xFF, 0x0b0c & 0xFF},
	{0x0b0f & 0xFF, 0x0b10 & 0xFF},
	{0x0b13 & 0xFF, 0x0b28 & 0xFF},
	{0x0b2a & 0xFF, 0x0b30 & 0xFF},
	{0x0b32 & 0xFF, 0x0b33 & 0xFF},
	{0x0b35 & 0xFF, 0x0b39 & 0xFF},
	{0x0b3d & 0xFF, 0x0b3d & 0xFF},
	{0x0b5c & 0xFF, 0x0b5d & 0xFF},
	{0x0b5f & 0xFF, 0x0b61 & 0xFF},
	{0x0b71 & 0xFF, 0x0b71 & 0xFF},
	{0x0b83 & 0xFF, 0x0b83 & 0xFF},
	{0x0b85 & 0xFF, 0x0b8a & 0xFF},
	{0x0b8e & 0xFF, 0x0b90 & 0xFF},
	{0x0b92 & 0xFF, 0x0b95 & 0xFF},
	{0x0b99 & 0xFF, 0x0b9a & 0xFF},
	{0x0b9c & 0xFF, 0x0b9c & 0xFF},
	{0x0b9e & 0xFF, 0x0b9f & 0xFF},
	{0x0ba3 & 0xFF, 0x0ba4 & 0xFF},
	{0x0ba8 & 0xFF, 0x0baa & 0xFF},
	{0x0bae & 0xFF, 0x0bb9 & 0xFF},
	{0x0bd0 & 0xFF, 0x0bd0 & 0xFF},
	{0x0c05 & 0xFF, 0x0c0c & 0xFF},
	{0x0c0e & 0xFF, 0x0c10 & 0xFF},
	{0x0c12 & 0xFF, 0x0c28 & 0xFF},
	{0x0c2a & 0xFF, 0x0c39 & 0xFF},
	{0x0c3d & 0xFF, 0x0c3d & 0xFF},
	{0x0c58 & 0xFF, 0x0c5a & 0xFF},
	{0x0c5d & 0xFF, 0x0c5d & 0xFF},
	{0x0c60 & 0xFF, 0x0c61 & 0xFF},
	{0x0c80 & 0xFF, 0x0c80 & 0xFF},
	{0x0c85 & 0xFF, 0x0c8c & 0xFF},
	{0x0c8e & 0xFF, 0x0c90 & 0xFF},
	{0x0c92 & 0xFF, 0x0ca8 & 0xFF},
	{0x0caa & 0xFF, 0x0cb3 & 0xFF},
	{0x0cb5 & 0xFF, 0x0cb9 & 0xFF},
	{0x0cbd & 0xFF, 0x0cbd & 0xFF},
	{0x0cdd & 0xFF, 0x0cde & 0xFF},
	{0x0ce0 & 0xFF, 0x0ce1 & 0xFF},
	{0x0cf1 & 0xFF, 0x0cf2 & 0xFF},
	{0x0d04 & 0xFF, 0x0d0c & 0xFF},
	{0x0d0e & 0xFF, 0x0d10 & 0xFF},
	{0x0d12 & 0xFF, 0x0d3a & 0xFF},
	{0x0d3d & 0xFF, 0x0d3d & 0xFF},
	{0x0d4e & 0xFF, 0x0d4e & 0xFF},
	{0x0d54 & 0xFF, 0x0d56 & 0xFF},
	{0x0d5f & 0xFF, 0x0d61 & 0xFF},
	{0x0d7a & 0xFF, 0x0d7f & 0xFF},
	{0x0d85 & 0xFF, 0x0d96 & 0xFF},
	{0x0d9a & 0xFF, 0x0db1 & 0xFF},
	{0x0db3 & 0xFF, 0x0dbb & 0xFF},
	{0x0dbd & 0xFF, 0x0dbd & 0xFF},
	{0x0dc0 & 0xFF, 0x0dc6 & 0xFF},
	{0x0e01 & 0xFF, 0x0e30 & 0xFF},
	{0x0e32 & 0xFF, 0x0e32 & 0xFF},
	{0x0e40 & 0xFF, 0x0e46 & 0xFF},
	{0x0e81 & 0xFF, 0x0e82 & 0xFF},
	{0x0e84 & 0xFF, 0x0e84 & 0xFF},
	{0x0e86 & 0xFF, 0x0e8a & 0xFF},
	{0x0e8c & 0xFF, 0x0ea3 & 0xFF},
	{0x0ea5 & 0xFF, 0x0ea5 & 0xFF},
	{0x0ea7 & 0xFF, 0x0eb0 & 0xFF},
	{0x0eb2 & 0xFF, 0x0eb2 & 0xFF},
	{0x0ebd & 0xFF, 0x0ebd & 0xFF},
	{0x0ec0 & 0xFF, 0x0ec4 & 0xFF},
	{0x0ec6 & 0xFF, 0x0ec6 & 0xFF},
	{0x0edc & 0xFF, 0x0edf & 0xFF},
	{0x0f00 & 0xFF, 0x0f00 & 0xFF},
	{0x0f40 & 0xFF, 0x0f47 & 0xFF},
	{0x0f49 & 0xFF, 0x0f6c & 0xFF},
	{0x0f88 & 0xFF, 0x0f8c & 0xFF},
	{0x1000 & 0xFF, 0x102a & 0xFF},
	{0x103f & 0xFF, 0x103f & 0xFF},
	{0x1050 & 0xFF, 0x1055 & 0xFF},
	{0x105a & 0xFF, 0x105d & 0xFF},
	{0x1061 & 0xFF, 0x1061 & 0xFF},
	{0x1065 & 0xFF, 0x1066 & 0xFF},
	{0x106e & 0xFF, 0x1070 & 0xFF},
	{0x1075 & 0xFF, 0x1081 & 0xFF},
	{0x108e & 0xFF, 0x108e & 0xFF},
	{0x10a0 & 0xFF, 0x10c5 & 0xFF},
	{0x10c7 & 0xFF, 0x10c7 & 0xFF},
	{0x10cd & 0xFF, 0x10cd & 0xFF},
	{0x10d0 & 0xFF, 0x10fa & 0xFF},
	{0x10fc & 0xFF, 0x10ff & 0xFF},
	{0x1100 & 0xFF, 0x11ff & 0xFF},
	{0x1200 & 0xFF, 0x1248 & 0xFF},
	{0x124a & 0xFF, 0x124d & 0xFF},
	{0x1250 & 0xFF, 0x1256 & 0xFF},
	{0x1258 & 0xFF, 0x1258 & 0xFF},
	{0x125a & 0xFF, 0x125d & 0xFF},
	{0x1260 & 0xFF, 0x1288 & 0xFF},
	{0x128a & 0xFF, 0x128d & 0xFF},
	{0x1290 & 0xFF, 0x12b0 & 0xFF},
	{0x12b2 & 0xFF, 0x12b5 & 0xFF},
	{0x12b8 & 0xFF, 0x12be & 0xFF},
	{0x12c0 & 0xFF, 0x12c0 & 0xFF},
	{0x12c2 & 0xFF, 0x12c5 & 0xFF},
	{0x12c8 & 0xFF, 0x12d6 & 0xFF},
	{0x12d8 & 0xFF, 0x12ff & 0xFF},
	{0x1300 & 0xFF, 0x1310 & 0xFF},
	{0x1312 & 0xFF, 0x1315 & 0xFF},
	{0x1318 & 0xFF, 0x135a & 0xFF},
	{0x1380 & 0xFF, 0x138f & 0xFF},
	{0x13a0 & 0xFF, 0x13f5 & 0xFF},
	{0x13f8 & 0xFF, 0x13fd & 0xFF},
	{0x1401 & 0xFF, 0x14ff & 0xFF},
	{0x1500 & 0xFF, 0x15ff & 0xFF},
	{0x1600 & 0xFF, 0x166c & 0xFF},
	{0x166f & 0xFF, 0x167f & 0xFF},
	{0x1681 & 0xFF, 0x169a & 0xFF},
	{0x16a0 & 0xFF, 0x16ea & 0xFF},
	{0x16ee & 0xFF, 0x16f8 & 0xFF},
	{0x1700 & 0xFF, 0x1711 & 0xFF},
	{0x171f & 0xFF, 0x1731 & 0xFF},
	{0x1740 & 0xFF, 0x1751 & 0xFF},
	{0x1760 & 0xFF, 0x176c & 0xFF},
	{0x176e & 0xFF, 0x1770 & 0xFF},
	{0x1780 & 0xFF, 0x17b3 & 0xFF},
	{0x17d7 & 0xFF, 0x17d7 & 0xFF},
	{0x17dc & 0xFF, 0x17dc & 0xFF},
	{0x1820 & 0xFF, 0x1878 & 0xFF},
	{0x1880 & 0xFF, 0x18a8 & 0xFF},
	{0x18aa & 0xFF, 0x18aa & 0xFF},
	{0x18b0 & 0xFF, 0x18f5 & 0xFF},
	{0x1900 & 0xFF, 0x191e & 0xFF},
	{0x1950 & 0xFF, 0x196d & 0xFF},
	{0x1970 & 0xFF, 0x1974 & 0xFF},
	{0x1980 & 0xFF, 0x19ab & 0xFF},
	{0x19b0 & 0xFF, 0x19c9 & 0xFF},
	{0x1a00 & 0xFF, 0x1a16 & 0xFF},
	{0x1a20 & 0xFF, 0x1a54 & 0xFF},
	{0x1aa7 & 0xFF, 0x1aa7 & 0xFF},
	{0x1b05 & 0xFF, 0x1b33 & 0xFF},
	{0x1b45 & 0xFF, 0x1b4c & 0xFF},
	{0x1b83 & 0xFF, 0x1ba0 & 0xFF},
	{0x1bae & 0xFF, 0x1baf & 0xFF},
	{0x1bba & 0xFF, 0x1be5 & 0xFF},
	{0x1c00 & 0xFF, 0x1c23 & 0xFF},
	{0x1c4d & 0xFF, 0x1c4f & 0xFF},
	{0x1c5a & 0xFF, 0x1c7d & 0xFF},
	{0x1c80 & 0xFF, 0x1c88 & 0xFF},
	{0x1c90 & 0xFF, 0x1cba & 0xFF},
	{0x1cbd & 0xFF, 0x1cbf & 0xFF},
	{0x1ce9 & 0xFF, 0x1cec & 0xFF},
	{0x1cee & 0xFF, 0x1cf3 & 0xFF},
	{0x1cf5 & 0xFF, 0x1cf6 & 0xFF},
	{0x1cfa & 0xFF, 0x1cfa & 0xFF},
	{0x1d00 & 0xFF, 0x1dbf & 0xFF},
	{0x1e00 & 0xFF, 0x1eff & 0xFF},
	{0x1f00 & 0xFF, 0x1f15 & 0xFF},
	{0x1f18 & 0xFF, 0x1f1d & 0xFF},
	{0x1f20 & 0xFF, 0x1f45 & 0xFF},
	{0x1f48 & 0xFF, 0x1f4d & 0xFF},
	{0x1f50 & 0xFF, 0x1f57 & 0xFF},
	{0x1f59 & 0xFF, 0x1f59 & 0xFF},
	{0x1f5b & 0xFF, 0x1f5b & 0xFF},
	{0x1f5d & 0xFF, 0x1f5d & 0xFF},
	{0x1f5f & 0xFF, 0x1f7d & 0xFF},
	{0x1f80 & 0xFF, 0x1fb4 & 0xFF},
	{0x1fb6 & 0xFF, 0x1fbc & 0xFF},
	{0x1fbe & 0xFF, 0x1fbe & 0xFF},
	{0x1fc2 & 0xFF, 0x1fc4 & 0xFF},
	{0x1fc6 & 0xFF, 0x1fcc & 0xFF},
	{0x1fd0 & 0xFF, 0x1fd3 & 0xFF},
	{0x1fd6 & 0xFF, 0x1fdb & 0xFF},
	{0x1fe0 & 0xFF, 0x1fec & 0xFF},
	{0x1ff2 & 0xFF, 0x1ff4 & 0xFF},
	{0x1ff6 & 0xFF, 0x1ffc & 0xFF},
	{0x2071 & 0xFF, 0x2071 & 0xFF},
	{0x207f & 0xFF, 0x207f & 0xFF},
	{0x2090 & 0xFF, 0x209c & 0xFF},
	{0x2102 & 0xFF, 0x2102 & 0xFF},
	{0x2107 & 0xFF, 0x2107 & 0xFF},
	{0x210a & 0xFF, 0x2113 & 0xFF},
	{0x2115 & 0xFF, 0x2115 & 0xFF},
	{0x2118 & 0xFF, 0x211d & 0xFF},
	{0x2124 & 0xFF, 0x2124 & 0xFF},
	{0x2126 & 0xFF, 0x2126 & 0xFF},
	{0x2128 & 0xFF, 0x2128 & 0xFF},
	{0x212a & 0xFF, 0x2139 & 0xFF},
	{0x213c & 0xFF, 0x213f & 0xFF},
	{0x2145 & 0xFF, 0x2149 & 0xFF},
	{0x214e & 0xFF, 0x214e & 0xFF},
	{0x2160 & 0xFF, 0x2188 & 0xFF},
	{0x2c00 & 0xFF, 0x2ce4 & 0xFF},
	{0x2ceb & 0xFF, 0x2cee & 0xFF},
	{0x2cf2 & 0xFF, 0x2cf3 & 0xFF},
	{0x2d00 & 0xFF, 0x2d25 & 0xFF},
	{0x2d27 & 0xFF, 0x2d27 & 0xFF},
	{0x2d2d & 0xFF, 0x2d2d & 0xFF},
	{0x2d30 & 0xFF, 0x2d67 & 0xFF},
	{0x2d6f & 0xFF, 0x2d6f & 0xFF},
	{0x2d80 & 0xFF, 0x2d96 & 0xFF},
	{0x2da0 & 0xFF, 0x2da6 & 0xFF},
	{0x2da8 & 0xFF, 0x2dae & 0xFF},
	{0x2db0 & 0xFF, 0x2db6 & 0xFF},
	{0x2db8 & 0xFF, 0x2dbe & 0xFF},
	{0x2dc0 & 0xFF, 0x2dc6 & 0xFF},
	{0x2dc8 & 0xFF, 0x2dce & 0xFF},
	{0x2dd0 & 0xFF, 0x2dd6 & 0xFF},
	{0x2dd8 & 0xFF, 0x2dde & 0xFF},
	{0x3005 & 0xFF, 0x3007 & 0xFF},
	{0x3021 & 0xFF, 0x3029 & 0xFF},
	{0x3031 & 0xFF, 0x3035 & 0xFF},
	{0x3038 & 0xFF, 0x303c & 0xFF},
	{0x3041 & 0xFF, 0x3096 & 0xFF},
	{0x309d & 0xFF, 0x309f & 0xFF},
	{0x30a1 & 0xFF, 0x30fa & 0xFF},
	{0x30fc & 0xFF, 0x30ff & 0xFF},
	{0x3105 & 0xFF, 0x312f & 0xFF},
	{0x3131 & 0xFF, 0x318e & 0xFF},
	{0x31a0 & 0xFF, 0x31bf & 0xFF},
	{0x31f0 & 0xFF, 0x31ff & 0xFF},
	{0x3400 & 0xFF, 0x34ff & 0xFF},
	{0x3500 & 0xFF, 0x35ff & 0xFF},
	{0x3600 & 0xFF, 0x36ff & 0xFF},
	{0x3700 & 0xFF, 0x37ff & 0xFF},
	{0x3800 & 0xFF, 0x38ff & 0xFF},
	{0x3900 & 0xFF, 0x39ff & 0xFF},
	{0x3a00 & 0xFF, 0x3aff & 0xFF},
	{0x3b00 & 0xFF, 0x3bff & 0xFF},
	{0x3c00 & 0xFF, 0x3cff & 0xFF},
	{0x3d00 & 0xFF, 0x3dff & 0xFF},
	{0x3e00 & 0xFF, 0x3eff & 0xFF},
	{0x3f00 & 0xFF, 0x3fff & 0xFF},
	{0x4000 & 0xFF, 0x40ff & 0xFF},
	{0x4100 & 0xFF, 0x41ff & 0xFF},
	{0x4200 & 0xFF, 0x42ff & 0xFF},
	{0x4300 & 0xFF, 0x43ff & 0xFF},
	{0x4400 & 0xFF, 0x44ff & 0xFF},
	{0x4500 & 0xFF, 0x45ff & 0xFF},
	{0x4600 & 0xFF, 0x46ff & 0xFF},
	{0x4700 & 0xFF, 0x47ff & 0xFF},
	{0x4800 & 0xFF, 0x48ff & 0xFF},
	{0x4900 & 0xFF, 0x49ff & 0xFF},
	{0x4a00 & 0xFF, 0x4aff & 0xFF},
	{0x4b00 & 0xFF, 0x4bff & 0xFF},
	{0x4c00 & 0xFF, 0x4cff & 0xFF},
	{0x4d00 & 0xFF, 0x4dbf & 0xFF},
	{0x4e00 & 0xFF, 0x4eff & 0xFF},
	{0x4f00 & 0xFF, 0x4fff & 0xFF},
	{0x5000 & 0xFF, 0x50ff & 0xFF},
	{0x5100 & 0xFF, 0x51ff & 0xFF},
	{0x5200 & 0xFF, 0x52ff & 0xFF},
	{0x5300 & 0xFF, 0x53ff & 0xFF},
	{0x5400 & 0xFF, 0x54ff & 0xFF},
	{0x5500 & 0xFF, 0x55ff & 0xFF},
	{0x5600 & 0xFF, 0x56ff & 0xFF},
	{0x5700 & 0xFF, 0x57ff & 0xFF},
	{0x5800 & 0xFF, 0x58ff & 0xFF},
	{0x5900 & 0xFF, 0x59ff & 0xFF},
	{0x5a00 & 0xFF, 0x5aff & 0xFF},
	{0x5b00 & 0xFF, 0x5bff & 0xFF},
	{0x5c00 & 0xFF, 0x5cff & 0xFF},
	{0x5d00 & 0xFF, 0x5dff & 0xFF},
	{0x5e00 & 0xFF, 0x5eff & 0xFF},
	{0x5f00 & 0xFF, 0x5fff & 0xFF},
	{0x6000 & 0xFF, 0x60ff & 0xFF},
	{0x6100 & 0xFF, 0x61ff & 0xFF},
	{0x6200 & 0xFF, 0x62ff & 0xFF},
	{0x6300 & 0xFF, 0x63ff & 0xFF},
	{0x6400 & 0xFF, 0x64ff & 0xFF},
	{0x6500 & 0xFF, 0x65ff & 0xFF},
	{0x6600 & 0xFF, 0x66ff & 0xFF},
	{0x6700 & 0xFF, 0x67ff & 0xFF},
	{0x6800 & 0xFF, 0x68ff & 0xFF},
	{0x6900 & 0xFF, 0x69ff & 0xFF},
	{0x6a00 & 0xFF, 0x6aff & 0xFF},
	{0x6b00 & 0xFF, 0x6bff & 0xFF},
	{0x6c00 & 0xFF, 0x6cff & 0xFF},
	{0x6d00 & 0xFF, 0x6dff & 0xFF},
	{0x6e00 & 0xFF, 0x6eff & 0xFF},
	{0x6f00 & 0xFF, 0x6fff & 0xFF},
	{0x7000 & 0xFF, 0x70ff & 0xFF},
	{0x7100 & 0xFF, 0x71ff & 0xFF},
	{0x7200 & 0xFF, 0x72ff & 0xFF},
	{0x7300 & 0xFF, 0x73ff & 0xFF},
	{0x7400 & 0xFF, 0x74ff & 0xFF},
	{0x7500 & 0xFF, 0x75ff & 0xFF},
	{0x7600 & 0xFF, 0x76ff & 0xFF},
	{0x7700 & 0xFF, 0x77ff & 0xFF},
	{0x7800 & 0xFF, 0x78ff & 0xFF},
	{0x7900 & 0xFF, 0x79ff & 0xFF},
	{0x7a00 & 0xFF, 0x7aff & 0xFF},
	{0x7b00 & 0xFF, 0x7bff & 0xFF},
	{0x7c00 & 0xFF, 0x7cff & 0xFF},
	{0x7d00 & 0xFF, 0x7dff & 0xFF},
	{0x7e00 & 0xFF, 0x7eff & 0xFF},
	{0x7f00 & 0xFF, 0x7fff & 0xFF},
	{0x8000 & 0xFF, 0x80ff & 0xFF},
	{0x8100 & 0xFF, 0x81ff & 0xFF},
	{0x8200 & 0xFF, 0x82ff & 0xFF},
	{0x8300 & 0xFF, 0x83ff & 0xFF},
	{0x8400 & 0xFF, 0x84ff & 0xFF},
	{0x8500 & 0xFF, 0x85ff & 0xFF},
	{0x8600 & 0xFF, 0x86ff & 0xFF},
	{0x8700 & 0xFF, 0x87ff & 0xFF},
	{0x8800 & 0xFF, 0x88ff & 0xFF},
	{0x8900 & 0xFF, 0x89ff & 0xFF},
	{0x8a00 & 0xFF, 0x8aff & 0xFF},
	{0x8b00 & 0xFF, 0x8bff & 0xFF},
	{0x8c00 & 0xFF, 0x8cff & 0xFF},
	{0x8d00 & 0xFF, 0x8dff & 0xFF},
	{0x8e00 & 0xFF, 0x8eff & 0xFF},
	{0x8f00 & 0xFF, 0x8fff & 0xFF},
	{0x9000 & 0xFF, 0x90ff & 0xFF},
	{0x9100 & 0xFF, 0x91ff & 0xFF},
	{0x9200 & 0xFF, 0x92ff & 0xFF},
	{0x9300 & 0xFF, 0x93ff & 0xFF},
	{0x9400 & 0xFF, 0x94ff & 0xFF},
	{0x9500 & 0xFF, 0x95ff & 0xFF},
	{0x9600 & 0xFF, 0x96ff & 0xFF},
	{0x9700 & 0xFF, 0x97ff & 0xFF},
	{0x9800 & 0xFF, 0x98ff & 0xFF},
	{0x9900 & 0xFF, 0x99ff & 0xFF},
	{0x9a00 & 0xFF, 0x9aff & 0xFF},
	{0x9b00 & 0xFF, 0x9bff & 0xFF},
	{0x9c00 & 0xFF, 0x9cff & 0xFF},
	{0x9d00 & 0xFF, 0x9dff & 0xFF},
	{0x9e00 & 0xFF, 0x9eff & 0xFF},
	{0x9f00 & 0xFF, 0x9fff & 0xFF},
	{0xa000 & 0xFF, 0xa0ff & 0xFF},
	{0xa100 & 0xFF, 0xa1ff & 0xFF},
	{0xa200 & 0xFF, 0xa2ff & 0xFF},
	{0xa300 & 0xFF, 0xa3ff & 0xFF},
	{0xa400 & 0xFF, 0xa48c & 0xFF},
	{0xa4d0 & 0xFF, 0xa4fd & 0xFF},
	{0xa500 & 0xFF, 0xa5ff & 0xFF},
	{0xa600 & 0xFF, 0xa60c & 0xFF},
	{0xa610 & 0xFF, 0xa61f & 0xFF},
	{0xa62a & 0xFF, 0xa62b & 0xFF},
	{0xa640 & 0xFF, 0xa66e & 0xFF},
	{0xa67f & 0xFF, 0xa69d & 0xFF},
	{0xa6a0 & 0xFF, 0xa6ef & 0xFF},
	{0xa717 & 0xFF, 0xa71f & 0xFF},
	{0xa722 & 0xFF, 0xa788 & 0xFF},
	{0xa78b & 0xFF, 0xa7ca & 0xFF},
	{0xa7d0 & 0xFF, 0xa7d1 & 0xFF},
	{0xa7d3 & 0xFF, 0xa7d3 & 0xFF},
	{0xa7d5 & 0xFF, 0xa7d9 & 0xFF},
	{0xa7f2 & 0xFF, 0xa7ff & 0xFF},
	{0xa800 & 0xFF, 0xa801 & 0xFF},
	{0xa803 & 0xFF, 0xa805 & 0xFF},
	{0xa807 & 0xFF, 0xa80a & 0xFF},
	{0xa80c & 0xFF, 0xa822 & 0xFF},
	{0xa840 & 0xFF, 0xa873 & 0xFF},
	{0xa882 & 0xFF, 0xa8b3 & 0xFF},
	{0xa8f2 & 0xFF, 0xa8f7 & 0xFF},
	{0xa8fb & 0xFF, 0xa8fb & 0xFF},
	{0xa8fd & 0xFF, 0xa8fe & 0xFF},
	{0xa90a & 0xFF, 0xa925 & 0xFF},
	{0xa930 & 0xFF, 0xa946 & 0xFF},
	{0xa960 & 0xFF, 0xa97c & 0xFF},
	{0xa984 & 0xFF, 0xa9b2 & 0xFF},
	{0xa9cf & 0xFF, 0xa9cf & 0xFF},
	{0xa9e0 & 0xFF, 0xa9e4 & 0xFF},
	{0xa9e6 & 0xFF, 0xa9ef & 0xFF},
	{0xa9fa & 0xFF, 0xa9fe & 0xFF},
	{0xaa00 & 0xFF, 0xaa28 & 0xFF},
	{0xaa40 & 0xFF, 0xaa42 & 0xFF},
	{0xaa44 & 0xFF, 0xaa4b & 0xFF},
	{0xaa60 & 0xFF, 0xaa76 & 0xFF},
	{0xaa7a & 0xFF, 0xaa7a & 0xFF},
	{0xaa7e & 0xFF, 0xaaaf & 0xFF},
	{0xaab1 & 0xFF, 0xaab1 & 0xFF},
	{0xaab5 & 0xFF, 0xaab6 & 0xFF},
	{0xaab9 & 0xFF, 0xaabd & 0xFF},
	{0xaac0 & 0xFF, 0xaac0 & 0xFF},
	{0xaac2 & 0xFF, 0xaac2 & 0xFF},
	{0xaadb & 0xFF, 0xaadd & 0xFF},
	{0xaae0 & 0xFF, 0xaaea & 0xFF},
	{0xaaf2 & 0xFF, 0xaaf4 & 0xFF},
	{0xab01 & 0xFF, 0xab06 & 0xFF},
	{0xab09 & 0xFF, 0xab0e & 0xFF},
	{0xab11 & 0xFF, 0xab16 & 0xFF},
	{0xab20 & 0xFF, 0xab26 & 0xFF},
	{0xab28 & 0xFF, 0xab2e & 0xFF},
	{0xab30 & 0xFF, 0xab5a & 0xFF},
	{0xab5c & 0xFF, 0xab69 & 0xFF},
	{0xab70 & 0xFF, 0xabe2 & 0xFF},
	{0xac00 & 0xFF, 0xacff & 0xFF},
	{0xad00 & 0xFF, 0xadff & 0xFF},
	{0xae00 & 0xFF, 0xaeff & 0xFF},
	{0xaf00 & 0xFF, 0xafff & 0xFF},
	{0xb000 & 0xFF, 0xb0ff & 0xFF},
	{0xb100 & 0xFF, 0xb1ff & 0xFF},
	{0xb200 & 0xFF, 0xb2ff & 0xFF},
	{0xb300 & 0xFF, 0xb3ff & 0xFF},
	{0xb400 & 0xFF, 0xb4ff & 0xFF},
	{0xb500 & 0xFF, 0xb5ff & 0xFF},
	{0xb600 & 0xFF, 0xb6ff & 0xFF},
	{0xb700 & 0xFF, 0xb7ff & 0xFF},
	{0xb800 & 0xFF, 0xb8ff & 0xFF},
	{0xb900 & 0xFF, 0xb9ff & 0xFF},
	{0xba00 & 0xFF, 0xbaff & 0xFF},
	{0xbb00 & 0xFF, 0xbbff & 0xFF},
	{0xbc00 & 0xFF, 0xbcff & 0xFF},
	{0xbd00 & 0xFF, 0xbdff & 0xFF},
	{0xbe00 & 0xFF, 0xbeff & 0xFF},
	{0xbf00 & 0xFF, 0xbfff & 0xFF},
	{0xc000 & 0xFF, 0xc0ff & 0xFF},
	{0xc100 & 0xFF, 0xc1ff & 0xFF},
	{0xc200 & 0xFF, 0xc2ff & 0xFF},
	{0xc300 & 0xFF, 0xc3ff & 0xFF},
	{0xc400 & 0xFF, 0xc4ff & 0xFF},
	{0xc500 & 0xFF, 0xc5ff & 0xFF},
	{0xc600 & 0xFF, 0xc6ff & 0xFF},
	{0xc700 & 0xFF, 0xc7ff & 0xFF},
	{0xc800 & 0xFF, 0xc8ff & 0xFF},
	{0xc900 & 0xFF, 0xc9ff & 0xFF},
	{0xca00 & 0xFF, 0xcaff & 0xFF},
	{0xcb00 & 0xFF, 0xcbff & 0xFF},
	{0xcc00 & 0xFF, 0xccff & 0xFF},
	{0xcd00 & 0xFF, 0xcdff & 0xFF},
	{0xce00 & 0xFF, 0xceff & 0xFF},
	{0xcf00 & 0xFF, 0xcfff & 0xFF},
	{0xd000 & 0xFF, 0xd0ff & 0xFF},
	{0xd100 & 0xFF, 0xd1ff & 0xFF},
	{0xd200 & 0xFF, 0xd2ff & 0xFF},
	{0xd300 & 0xFF, 0xd3ff & 0xFF},
	{0xd400 & 0xFF, 0xd4ff & 0xFF},
	{0xd500 & 0xFF, 0xd5ff & 0xFF},
	{0xd600 & 0xFF, 0xd6ff & 0xFF},
	{0xd700 & 0xFF, 0xd7a3 & 0xFF},
	{0xd7b0 & 0xFF, 0xd7c6 & 0xFF},
	{0xd7cb & 0xFF, 0xd7fb & 0xFF},
	{0xf900 & 0xFF, 0xf9ff & 0xFF},
	{0xfa00 & 0xFF, 0xfa6d & 0xFF},
	{0xfa70 & 0xFF, 0xfad9 & 0xFF},
	{0xfb00 & 0xFF, 0xfb06 & 0xFF},
	{0xfb13 & 0xFF, 0xfb17 & 0xFF},
	{0xfb1d & 0xFF, 0xfb1d & 0xFF},
	{0xfb1f & 0xFF, 0xfb28 & 0xFF},
	{0xfb2a & 0xFF, 0xfb36 & 0xFF},
	{0xfb38 & 0xFF, 0xfb3c & 0xFF},
	{0xfb3e & 0xFF, 0xfb3e & 0xFF},
	{0xfb40 & 0xFF, 0xfb41 & 0xFF},
	{0xfb43 & 0xFF, 0xfb44 & 0xFF},
	{0xfb46 & 0xFF, 0xfbb1 & 0xFF},
	{0xfbd3 & 0xFF, 0xfbff & 0xFF},
	{0xfc00 & 0xFF, 0xfc5d & 0xFF},
	{0xfc64 & 0xFF, 0xfcff & 0xFF},
	{0xfd00 & 0xFF, 0xfd3d & 0xFF},
	{0xfd50 & 0xFF, 0xfd8f & 0xFF},
	{0xfd92 & 0xFF, 0xfdc7 & 0xFF},
	{0xfdf0 & 0xFF, 0xfdf9 & 0xFF},
	{0xfe71 & 0xFF, 0xfe71 & 0xFF},
	{0xfe73 & 0xFF, 0xfe73 & 0xFF},
	{0xfe77 & 0xFF, 0xfe77 & 0xFF},
	{0xfe79 & 0xFF, 0xfe79 & 0xFF},
	{0xfe7b & 0xFF, 0xfe7b & 0xFF},
	{0xfe7d & 0xFF, 0xfe7d & 0xFF},
	{0xfe7f & 0xFF, 0xfefc & 0xFF},
	{0xff21 & 0xFF, 0xff3a & 0xFF},
	{0xff41 & 0xFF, 0xff5a & 0xFF},
	{0xff66 & 0xFF, 0xff9d & 0xFF},
	{0xffa0 & 0xFF, 0xffbe & 0xFF},
	{0xffc2 & 0xFF, 0xffc7 & 0xFF},
	{0xffca & 0xFF, 0xffcf & 0xFF},
	{0xffd2 & 0xFF, 0xffd7 & 0xFF},
	{0xffda & 0xFF, 0xffdc & 0xFF},
	{0x10000 & 0xFF, 0x1000b & 0xFF},
	{0x1000d & 0xFF, 0x10026 & 0xFF},
	{0x10028 & 0xFF, 0x1003a & 0xFF},
	{0x1003c & 0xFF, 0x1003d & 0xFF},
	{0x1003f & 0xFF, 0x1004d & 0xFF},
	{0x10050 & 0xFF, 0x1005d & 0xFF},
	{0x10080 & 0xFF, 0x100fa & 0xFF},
	{0x10140 & 0xFF, 0x10174 & 0xFF},
	{0x10280 & 0xFF, 0x1029c & 0xFF},
	{0x102a0 & 0xFF, 0x102d0 & 0xFF},
	{0x10300 & 0xFF, 0x1031f & 0xFF},
	{0x1032d & 0xFF, 0x1034a & 0xFF},
	{0x10350 & 0xFF, 0x10375 & 0xFF},
	{0x10380 & 0xFF, 0x1039d & 0xFF},
	{0x103a0 & 0xFF, 0x103c3 & 0xFF},
	{0x103c8 & 0xFF, 0x103cf & 0xFF},
	{0x103d1 & 0xFF, 0x103d5 & 0xFF},
	{0x10400 & 0xFF, 0x1049d & 0xFF},
	{0x104b0 & 0xFF, 0x104d3 & 0xFF},
	{0x104d8 & 0xFF, 0x104fb & 0xFF},
	{0x10500 & 0xFF, 0x10527 & 0xFF},
	{0x10530 & 0xFF, 0x10563 & 0xFF},
	{0x10570 & 0xFF, 0x1057a & 0xFF},
	{0x1057c & 0xFF, 0x1058a & 0xFF},
	{0x1058c & 0xFF, 0x10592 & 0xFF},
	{0x10594 & 0xFF, 0x10595 & 0xFF},
	{0x10597 & 0xFF, 0x105a1 & 0xFF},
	{0x105a3 & 0xFF, 0x105b1 & 0xFF},
	{0x105b3 & 0xFF, 0x105b9 & 0xFF},
	{0x105bb & 0xFF, 0x105bc & 0xFF},
	{0x10600 & 0xFF, 0x106ff & 0xFF},
	{0x10700 & 0xFF, 0x10736 & 0xFF},
	{0x10740 & 0xFF, 0x10755 & 0xFF},
	{0x10760 & 0xFF, 0x10767 & 0xFF},
	{0x10780 & 0xFF, 0x10785 & 0xFF},
	{0x10787 & 0xFF, 0x107b0 & 0xFF},
	{0x107b2 & 0xFF, 0x107ba & 0xFF},
	{0x10800 & 0xFF, 0x10805 & 0xFF},
	{0x10808 & 0xFF, 0x10808 & 0xFF},
	{0x1080a & 0xFF, 0x10835 & 0xFF},
	{0x10837 & 0xFF, 0x10838 & 0xFF},
	{0x1083c & 0xFF, 0x1083c & 0xFF},
	{0x1083f & 0xFF, 0x10855 & 0xFF},
	{0x10860 & 0xFF, 0x10876 & 0xFF},
	{0x10880 & 0xFF, 0x1089e & 0xFF},
	{0x108e0 & 0xFF, 0x108f2 & 0xFF},
	{0x108f4 & 0xFF, 0x108f5 & 0xFF},
	{0x10900 & 0xFF, 0x10915 & 0xFF},
	{0x10920 & 0xFF, 0x10939 & 0xFF},
	{0x10980 & 0xFF, 0x109b7 & 0xFF},
	{0x109be & 0xFF, 0x109bf & 0xFF},
	{0x10a00 & 0xFF, 0x10a00 & 0xFF},
	{0x10a10 & 0xFF, 0x10a13 & 0xFF},
	{0x10a15 & 0xFF, 0x10a17 & 0xFF},
	{0x10a19 & 0xFF, 0x10a35 & 0xFF},
	{0x10a60 & 0xFF, 0x10a7c & 0xFF},
	{0x10a80 & 0xFF, 0x10a9c & 0xFF},
	{0x10ac0 & 0xFF, 0x10ac7 & 0xFF},
	{0x10ac9 & 0xFF, 0x10ae4 & 0xFF},
	{0x10b00 & 0xFF, 0x10b35 & 0xFF},
	{0x10b40 & 0xFF, 0x10b55 & 0xFF},
	{0x10b60 & 0xFF, 0x10b72 & 0xFF},
	{0x10b80 & 0xFF, 0x10b91 & 0xFF},
	{0x10c00 & 0xFF, 0x10c48 & 0xFF},
	{0x10c80 & 0xFF, 0x10cb2 & 0xFF},
	{0x10cc0 & 0xFF, 0x10cf2 & 0xFF},
	{0x10d00 & 0xFF, 0x10d23 & 0xFF},
	{0x10e80 & 0xFF, 0x10ea9 & 0xFF},
	{0x10eb0 & 0xFF, 0x10eb1 & 0xFF},
	{0x10f00 & 0xFF, 0x10f1c & 0xFF},
	{0x10f27 & 0xFF, 0x10f27 & 0xFF},
	{0x10f30 & 0xFF, 0x10f45 & 0xFF},
	{0x10f70 & 0xFF, 0x10f81 & 0xFF},
	{0x10fb0 & 0xFF, 0x10fc4 & 0xFF},
	{0x10fe0 & 0xFF, 0x10ff6 & 0xFF},
	{0x11003 & 0xFF, 0x11037 & 0xFF},
	{0x11071 & 0xFF, 0x11072 & 0xFF},
	{0x11075 & 0xFF, 0x11075 & 0xFF},
	{0x11083 & 0xFF, 0x110af & 0xFF},
	{0x110d0 & 0xFF, 0x110e8 & 0xFF},
	{0x11103 & 0xFF, 0x11126 & 0xFF},
	{0x11144 & 0xFF, 0x11144 & 0xFF},
	{0x11147 & 0xFF, 0x11147 & 0xFF},
	{0x11150 & 0xFF, 0x11172 & 0xFF},
	{0x11176 & 0xFF, 0x11176 & 0xFF},
	{0x11183 & 0xFF, 0x111b2 & 0xFF},
	{0x111c1 & 0xFF, 0x111c4 & 0xFF},
	{0x111da & 0xFF, 0x111da & 0xFF},
	{0x111dc & 0xFF, 0x111dc & 0xFF},
	{0x11200 & 0xFF, 0x11211 & 0xFF},
	{0x11213 & 0xFF, 0x1122b & 0xFF},
	{0x1123f & 0xFF, 0x11240 & 0xFF},
	{0x11280 & 0xFF, 0x11286 & 0xFF},
	{0x11288 & 0xFF, 0x11288 & 0xFF},
	{0x1128a & 0xFF, 0x1128d & 0xFF},
	{0x1128f & 0xFF, 0x1129d & 0xFF},
	{0x1129f & 0xFF, 0x112a8 & 0xFF},
	{0x112b0 & 0xFF, 0x112de & 0xFF},
	{0x11305 & 0xFF, 0x1130c & 0xFF},
	{0x1130f & 0xFF, 0x11310 & 0xFF},
	{0x11313 & 0xFF, 0x11328 & 0xFF},
	{0x1132a & 0xFF, 0x11330 & 0xFF},
	{0x11332 & 0xFF, 0x11333 & 0xFF},
	{0x11335 & 0xFF, 0x11339 & 0xFF},
	{0x1133d & 0xFF, 0x1133d & 0xFF},
	{0x11350 & 0xFF, 0x11350 & 0xFF},
	{0x1135d & 0xFF, 0x11361 & 0xFF},
	{0x11400 & 0xFF, 0x11434 & 0xFF},
	{0x11447 & 0xFF, 0x1144a & 0xFF},
	{0x1145f & 0xFF, 0x11461 & 0xFF},
	{0x11480 & 0xFF, 0x114af & 0xFF},
	{0x114c4 & 0xFF, 0x114c5 & 0xFF},
	{0x114c7 & 0xFF, 0x114c7 & 0xFF},
	{0x11580 & 0xFF, 0x115ae & 0xFF},
	{0x115d8 & 0xFF, 0x115db & 0xFF},
	{0x11600 & 0xFF, 0x1162f & 0xFF},
	{0x11644 & 0xFF, 0x11644 & 0xFF},
	{0x11680 & 0xFF, 0x116aa & 0xFF},
	{0x116b8 & 0xFF, 0x116b8 & 0xFF},
	{0x11700 & 0xFF, 0x1171a & 0xFF},
	{0x11740 & 0xFF, 0x11746 & 0xFF},
	{0x11800 & 0xFF, 0x1182b & 0xFF},
	{0x118a0 & 0xFF, 0x118df & 0xFF},
	{0x118ff & 0xFF, 0x118ff & 0xFF},
	{0x11900 & 0xFF, 0x11906 & 0xFF},
	{0x11909 & 0xFF, 0x11909 & 0xFF},
	{0x1190c & 0xFF, 0x11913 & 0xFF},
	{0x11915 & 0xFF, 0x11916 & 0xFF},
	{0x11918 & 0xFF, 0x1192f & 0xFF},
	{0x1193f & 0xFF, 0x1193f & 0xFF},
	{0x11941 & 0xFF, 0x11941 & 0xFF},
	{0x119a0 & 0xFF, 0x119a7 & 0xFF},
	{0x119aa & 0xFF, 0x119d0 & 0xFF},
	{0x119e1 & 0xFF, 0x119e1 & 0xFF},
	{0x119e3 & 0xFF, 0x119e3 & 0xFF},
	{0x11a00 & 0xFF, 0x11a00 & 0xFF},
	{0x11a0b & 0xFF, 0x11a32 & 0xFF},
	{0x11a3a & 0xFF, 0x11a3a & 0xFF},
	{0x11a50 & 0xFF, 0x11a50 & 0xFF},
	{0x11a5c & 0xFF, 0x11a89 & 0xFF},
	{0x11a9d & 0xFF, 0x11a9d & 0xFF},
	{0x11ab0 & 0xFF, 0x11af8 & 0xFF},
	{0x11c00 & 0xFF, 0x11c08 & 0xFF},
	{0x11c0a & 0xFF, 0x11c2e & 0xFF},
	{0x11c40 & 0xFF, 0x11c40 & 0xFF},
	{0x11c72 & 0xFF, 0x11c8f & 0xFF},
	{0x11d00 & 0xFF, 0x11d06 & 0xFF},
	{0x11d08 & 0xFF, 0x11d09 & 0xFF},
	{0x11d0b & 0xFF, 0x11d30 & 0xFF},
	{0x11d46 & 0xFF, 0x11d46 & 0xFF},
	{0x11d60 & 0xFF, 0x11d65 & 0xFF},
	{0x11d67 & 0xFF, 0x11d68 & 0xFF},
	{0x11d6a & 0xFF, 0x11d89 & 0xFF},
	{0x11d98 & 0xFF, 0x11d98 & 0xFF},
	{0x11ee0 & 0xFF, 0x11ef2 & 0xFF},
	{0x11f02 & 0xFF, 0x11f02 & 0xFF},
	{0x11f04 & 0xFF, 0x11f10 & 0xFF},
	{0x11f12 & 0xFF, 0x11f33 & 0xFF},
	{0x11fb0 & 0xFF, 0x11fb0 & 0xFF},
	{0x12000 & 0xFF, 0x120ff & 0xFF},
	{0x12100 & 0xFF, 0x121ff & 0xFF},
	{0x12200 & 0xFF, 0x122ff & 0xFF},
	{0x12300 & 0xFF, 0x12399 & 0xFF},
	{0x12400 & 0xFF, 0x1246e & 0xFF},
	{0x12480 & 0xFF, 0x124ff & 0xFF},
	{0x12500 & 0xFF, 0x12543 & 0xFF},
	{0x12f90 & 0xFF, 0x12ff0 & 0xFF},
	{0x13000 & 0xFF, 0x130ff & 0xFF},
	{0x13100 & 0xFF, 0x131ff & 0xFF},
	{0x13200 & 0xFF, 0x132ff & 0xFF},
	{0x13300 & 0xFF, 0x133ff & 0xFF},
	{0x13400 & 0xFF, 0x1342f & 0xFF},
	{0x13441 & 0xFF, 0x13446 & 0xFF},
	{0x14400 & 0xFF, 0x144ff & 0xFF},
	{0x14500 & 0xFF, 0x145ff & 0xFF},
	{0x14600 & 0xFF, 0x14646 & 0xFF},
	{0x16800 & 0xFF, 0x168ff & 0xFF},
	{0x16900 & 0xFF, 0x169ff & 0xFF},
	{0x16a00 & 0xFF, 0x16a38 & 0xFF},
	{0x16a40 & 0xFF, 0x16a5e & 0xFF},
	{0x16a70 & 0xFF, 0x16abe & 0xFF},
	{0x16ad0 & 0xFF, 0x16aed & 0xFF},
	{0x16b00 & 0xFF, 0x16b2f & 0xFF},
	{0x16b40 & 0xFF, 0x16b43 & 0xFF},
	{0x16b63 & 0xFF, 0x16b77 & 0xFF},
	{0x16b7d & 0xFF, 0x16b8f & 0xFF},
	{0x16e40 & 0xFF, 0x16e7f & 0xFF},
	{0x16f00 & 0xFF, 0x16f4a & 0xFF},
	{0x16f50 & 0xFF, 0x16f50 & 0xFF},
	{0x16f93 & 0xFF, 0x16f9f & 0xFF},
	{0x16fe0 & 0xFF, 0x16fe1 & 0xFF},
	{0x16fe3 & 0xFF, 0x16fe3 & 0xFF},
	{0x17000 & 0xFF, 0x170ff & 0xFF},
	{0x17100 & 0xFF, 0x171ff & 0xFF},
	{0x17200 & 0xFF, 0x172ff & 0xFF},
	{0x17300 & 0xFF, 0x173ff & 0xFF},
	{0x17400 & 0xFF, 0x174ff & 0xFF},
	{0x17500 & 0xFF, 0x175ff & 0xFF},
	{0x17600 & 0xFF, 0x176ff & 0xFF},
	{0x17700 & 0xFF, 0x177ff & 0xFF},
	{0x17800 & 0xFF, 0x178ff & 0xFF},
	{0x17900 & 0xFF, 0x179ff & 0xFF},
	{0x17a00 & 0xFF, 0x17aff & 0xFF},
	{0x17b00 & 0xFF, 0x17bff & 0xFF},
	{0x17c00 & 0xFF, 0x17cff & 0xFF},
	{0x17d00 & 0xFF, 0x17dff & 0xFF},
	{0x17e00 & 0xFF, 0x17eff & 0xFF},
	{0x17f00 & 0xFF, 0x17fff & 0xFF},
	{0x18000 & 0xFF, 0x180ff & 0xFF},
	{0x18100 & 0xFF, 0x181ff & 0xFF},
	{0x18200 & 0xFF, 0x182ff & 0xFF},
	{0x18300 & 0xFF, 0x183ff & 0xFF},
	{0x18400 & 0xFF, 0x184ff & 0xFF},
	{0x18500 & 0xFF, 0x185ff & 0xFF},
	{0x18600 & 0xFF, 0x186ff & 0xFF},
	{0x18700 & 0xFF, 0x187f7 & 0xFF},
	{0x18800 & 0xFF, 0x188ff & 0xFF},
	{0x18900 & 0xFF, 0x189ff & 0xFF},
	{0x18a00 & 0xFF, 0x18aff & 0xFF},
	{0x18b00 & 0xFF, 0x18bff & 0xFF},
	{0x18c00 & 0xFF, 0x18cd5 & 0xFF},
	{0x18d00 & 0xFF, 0x18d08 & 0xFF},
	{0x1aff0 & 0xFF, 0x1aff3 & 0xFF},
	{0x1aff5 & 0xFF, 0x1affb & 0xFF},
	{0x1affd & 0xFF, 0x1affe & 0xFF},
	{0x1b000 & 0xFF, 0x1b0ff & 0xFF},
	{0x1b100 & 0xFF, 0x1b122 & 0xFF},
	{0x1b132 & 0xFF, 0x1b132 & 0xFF},
	{0x1b150 & 0xFF, 0x1b152 & 0xFF},
	{0x1b155 & 0xFF, 0x1b155 & 0xFF},
	{0x1b164 & 0xFF, 0x1b167 & 0xFF},
	{0x1b170 & 0xFF, 0x1b1ff & 0xFF},
	{0x1b200 & 0xFF, 0x1b2fb & 0xFF},
	{0x1bc00 & 0xFF, 0x1bc6a & 0xFF},
	{0x1bc70 & 0xFF, 0x1bc7c & 0xFF},
	{0x1bc80 & 0xFF, 0x1bc88 & 0xFF},
	{0x1bc90 & 0xFF, 0x1bc99 & 0xFF},
	{0x1d400 & 0xFF, 0x1d454 & 0xFF},
	{0x1d456 & 0xFF, 0x1d49c & 0xFF},
	{0x1d49e & 0xFF, 0x1d49f & 0xFF},
	{0x1d4a2 & 0xFF, 0x1d4a2 & 0xFF},
	{0x1d4a5 & 0xFF, 0x1d4a6 & 0xFF},
	{0x1d4a9 & 0xFF, 0x1d4ac & 0xFF},
	{0x1d4ae & 0xFF, 0x1d4b9 & 0xFF},
	{0x1d4bb & 0xFF, 0x1d4bb & 0xFF},
	{0x1d4bd & 0xFF, 0x1d4c3 & 0xFF},
	{0x1d4c5 & 0xFF, 0x1d4ff & 0xFF},
	{0x1d500 & 0xFF, 0x1d505 & 0xFF},
	{0x1d507 & 0xFF, 0x1d50a & 0xFF},
	{0x1d50d & 0xFF, 0x1d514 & 0xFF},
	{0x1d516 & 0xFF, 0x1d51c & 0xFF},
	{0x1d51e & 0xFF, 0x1d539 & 0xFF},
	{0x1d53b & 0xFF, 0x1d53e & 0xFF},
	{0x1d540 & 0xFF, 0x1d544 & 0xFF},
	{0x1d546 & 0xFF, 0x1d546 & 0xFF},
	{0x1d54a & 0xFF, 0x1d550 & 0xFF},
	{0x1d552 & 0xFF, 0x1d5ff & 0xFF},
	{0x1d600 & 0xFF, 0x1d6a5 & 0xFF},
	{0x1d6a8 & 0xFF, 0x1d6c0 & 0xFF},
	{0x1d6c2 & 0xFF, 0x1d6da & 0xFF},
	{0x1d6dc & 0xFF, 0x1d6fa & 0xFF},
	{0x1d6fc & 0xFF, 0x1d6ff & 0xFF},
	{0x1d700 & 0xFF, 0x1d714 & 0xFF},
	{0x1d716 & 0xFF, 0x1d734 & 0xFF},
	{0x1d736 & 0xFF, 0x1d74e & 0xFF},
	{0x1d750 & 0xFF, 0x1d76e & 0xFF},
	{0x1d770 & 0xFF, 0x1d788 & 0xFF},
	{0x1d78a & 0xFF, 0x1d7a8 & 0xFF},
	{0x1d7aa & 0xFF, 0x1d7c2 & 0xFF},
	{0x1d7c4 & 0xFF, 0x1d7cb & 0xFF},
	{0x1df00 & 0xFF, 0x1df1e & 0xFF},
	{0x1df25 & 0xFF, 0x1df2a & 0xFF},
	{0x1e030 & 0xFF, 0x1e06d & 0xFF},
	{0x1e100 & 0xFF, 0x1e12c & 0xFF},
	{0x1e137 & 0xFF, 0x1e13d & 0xFF},
	{0x1e14e & 0xFF, 0x1e14e & 0xFF},
	{0x1e290 & 0xFF, 0x1e2ad & 0xFF},
	{0x1e2c0 & 0xFF, 0x1e2eb & 0xFF},
	{0x1e4d0 & 0xFF, 0x1e4eb & 0xFF},
	{0x1e7e0 & 0xFF, 0x1e7e6 & 0xFF},
	{0x1e7e8 & 0xFF, 0x1e7eb & 0xFF},
	{0x1e7ed & 0xFF, 0x1e7ee & 0xFF},
	{0x1e7f0 & 0xFF, 0x1e7fe & 0xFF},
	{0x1e800 & 0xFF, 0x1e8c4 & 0xFF},
	{0x1e900 & 0xFF, 0x1e943 & 0xFF},
	{0x1e94b & 0xFF, 0x1e94b & 0xFF},
	{0x1ee00 & 0xFF, 0x1ee03 & 0xFF},
	{0x1ee05 & 0xFF, 0x1ee1f & 0xFF},
	{0x1ee21 & 0xFF, 0x1ee22 & 0xFF},
	{0x1ee24 & 0xFF, 0x1ee24 & 0xFF},
	{0x1ee27 & 0xFF, 0x1ee27 & 0xFF},
	{0x1ee29 & 0xFF, 0x1ee32 & 0xFF},
	{0x1ee34 & 0xFF, 0x1ee37 & 0xFF},
	{0x1ee39 & 0xFF, 0x1ee39 & 0xFF},
	{0x1ee3b & 0xFF, 0x1ee3b & 0xFF},
	{0x1ee42 & 0xFF, 0x1ee42 & 0xFF},
	{0x1ee47 & 0xFF, 0x1ee47 & 0xFF},
	{0x1ee49 & 0xFF, 0x1ee49 & 0xFF},
	{0x1ee4b & 0xFF, 0x1ee4b & 0xFF},
	{0x1ee4d & 0xFF, 0x1ee4f & 0xFF},
	{0x1ee51 & 0xFF, 0x1ee52 & 0xFF},
	{0x1ee54 & 0xFF, 0x1ee54 & 0xFF},
	{0x1ee57 & 0xFF, 0x1ee57 & 0xFF},
	{0x1ee59 & 0xFF, 0x1ee59 & 0xFF},
	{0x1ee5b & 0xFF, 0x1ee5b & 0xFF},
	{0x1ee5d & 0xFF, 0x1ee5d & 0xFF},
	{0x1ee5f & 0xFF, 0x1ee5f & 0xFF},
	{0x1ee61 & 0xFF, 0x1ee62 & 0xFF},
	{0x1ee64 & 0xFF, 0x1ee64 & 0xFF},
	{0x1ee67 & 0xFF, 0x1ee6a & 0xFF},
	{0x1ee6c & 0xFF, 0x1ee72 & 0xFF},
	{0x1ee74 & 0xFF, 0x1ee77 & 0xFF},
	{0x1ee79 & 0xFF, 0x1ee7c & 0xFF},
	{0x1ee7e & 0xFF, 0x1ee7e & 0xFF},
	{0x1ee80 & 0xFF, 0x1ee89 & 0xFF},
	{0x1ee8b & 0xFF, 0x1ee9b & 0xFF},
	{0x1eea1 & 0xFF, 0x1eea3 & 0xFF},
	{0x1eea5 & 0xFF, 0x1eea9 & 0xFF},
	{0x1eeab & 0xFF, 0x1eebb & 0xFF},
	{0x20000 & 0xFF, 0x200ff & 0xFF},
	{0x20100 & 0xFF, 0x201ff & 0xFF},
	{0x20200 & 0xFF, 0x202ff & 0xFF},
	{0x20300 & 0xFF, 0x203ff & 0xFF},
	{0x20400 & 0xFF, 0x204ff & 0xFF},
	{0x20500 & 0xFF, 0x205ff & 0xFF},
	{0x20600 & 0xFF, 0x206ff & 0xFF},
	{0x20700 & 0xFF, 0x207ff & 0xFF},
	{0x20800 & 0xFF, 0x208ff & 0xFF},
	{0x20900 & 0xFF, 0x209ff & 0xFF},
	{0x20a00 & 0xFF, 0x20aff & 0xFF},
	{0x20b00 & 0xFF, 0x20bff & 0xFF},
	{0x20c00 & 0xFF, 0x20cff & 0xFF},
	{0x20d00 & 0xFF, 0x20dff & 0xFF},
	{0x20e00 & 0xFF, 0x20eff & 0xFF},
	{0x20f00 & 0xFF, 0x20fff & 0xFF},
	{0x21000 & 0xFF, 0x210ff & 0xFF},
	{0x21100 & 0xFF, 0x211ff & 0xFF},
	{0x21200 & 0xFF, 0x212ff & 0xFF},
	{0x21300 & 0xFF, 0x213ff & 0xFF},
	{0x21400 & 0xFF, 0x214ff & 0xFF},
	{0x21500 & 0xFF, 0x215ff & 0xFF},
	{0x21600 & 0xFF, 0x216ff & 0xFF},
	{0x21700 & 0xFF, 0x217ff & 0xFF},
	{0x21800 & 0xFF, 0x218ff & 0xFF},
	{0x21900 & 0xFF, 0x219ff & 0xFF},
	{0x21a00 & 0xFF, 0x21aff & 0xFF},
	{0x21b00 & 0xFF, 0x21bff & 0xFF},
	{0x21c00 & 0xFF, 0x21cff & 0xFF},
	{0x21d00 & 0xFF, 0x21dff & 0xFF},
	{0x21e00 & 0xFF, 0x21eff & 0xFF},
	{0x21f00 & 0xFF, 0x21fff & 0xFF},
	{0x22000 & 0xFF, 0x220ff & 0xFF},
	{0x22100 & 0xFF, 0x221ff & 0xFF},
	{0x22200 & 0xFF, 0x222ff & 0xFF},
	{0x22300 & 0xFF, 0x223ff & 0xFF},
	{0x22400 & 0xFF, 0x224ff & 0xFF},
	{0x22500 & 0xFF, 0x225ff & 0xFF},
	{0x22600 & 0xFF, 0x226ff & 0xFF},
	{0x22700 & 0xFF, 0x227ff & 0xFF},
	{0x22800 & 0xFF, 0x228ff & 0xFF},
	{0x22900 & 0xFF, 0x229ff & 0xFF},
	{0x22a00 & 0xFF, 0x22aff & 0xFF},
	{0x22b00 & 0xFF, 0x22bff & 0xFF},
	{0x22c00 & 0xFF, 0x22cff & 0xFF},
	{0x22d00 & 0xFF, 0x22dff & 0xFF},
	{0x22e00 & 0xFF, 0x22eff & 0xFF},
	{0x22f00 & 0xFF, 0x22fff & 0xFF},
	{0x23000 & 0xFF, 0x230ff & 0xFF},
	{0x23100 & 0xFF, 0x231ff & 0xFF},
	{0x23200 & 0xFF, 0x232ff & 0xFF},
	{0x23300 & 0xFF, 0x233ff & 0xFF},
	{0x23400 & 0xFF, 0x234ff & 0xFF},
	{0x23500 & 0xFF, 0x235ff & 0xFF},
	{0x23600 & 0xFF, 0x236ff & 0xFF},
	{0x23700 & 0xFF, 0x237ff & 0xFF},
	{0x23800 & 0xFF, 0x238ff & 0xFF},
	{0x23900 & 0xFF, 0x239ff & 0xFF},
	{0x23a00 & 0xFF, 0x23aff & 0xFF},
	{0x23b00 & 0xFF, 0x23bff & 0xFF},
	{0x23c00 & 0xFF, 0x23cff & 0xFF},
	{0x23d00 & 0xFF, 0x23dff & 0xFF},
	{0x23e00 & 0xFF, 0x23eff & 0xFF},
	{0x23f00 & 0xFF, 0x23fff & 0xFF},
	{0x24000 & 0xFF, 0x240ff & 0xFF},
	{0x24100 & 0xFF, 0x241ff & 0xFF},
	{0x24200 & 0xFF, 0x242ff & 0xFF},
	{0x24300 & 0xFF, 0x243ff & 0xFF},
	{0x24400 & 0xFF, 0x244ff & 0xFF},
	{0x24500 & 0xFF, 0x245ff & 0xFF},
	{0x24600 & 0xFF, 0x246ff & 0xFF},
	{0x24700 & 0xFF, 0x247ff & 0xFF},
	{0x24800 & 0xFF, 0x248ff & 0xFF},
	{0x24900 & 0xFF, 0x249ff & 0xFF},
	{0x24a00 & 0xFF, 0x24aff & 0xFF},
	{0x24b00 & 0xFF, 0x24bff & 0xFF},
	{0x24c00 & 0xFF, 0x24cff & 0xFF},
	{0x24d00 & 0xFF, 0x24dff & 0xFF},
	{0x24e00 & 0xFF, 0x24eff & 0xFF},
	{0x24f00 & 0xFF, 0x24fff & 0xFF},
	{0x25000 & 0xFF, 0x250ff & 0xFF},
	{0x25100 & 0xFF, 0x251ff & 0xFF},
	{0x25200 & 0xFF, 0x252ff & 0xFF},
	{0x25300 & 0xFF, 0x253ff & 0xFF},
	{0x25400 & 0xFF, 0x254ff & 0xFF},
	{0x25500 & 0xFF, 0x255ff & 0xFF},
	{0x25600 & 0xFF, 0x256ff & 0xFF},
	{0x25700 & 0xFF, 0x257ff & 0xFF},
	{0x25800 & 0xFF, 0x258ff & 0xFF},
	{0x25900 & 0xFF, 0x259ff & 0xFF},
	{0x25a00 & 0xFF, 0x25aff & 0xFF},
	{0x25b00 & 0xFF, 0x25bff & 0xFF},
	{0x25c00 & 0xFF, 0x25cff & 0xFF},
	{0x25d00 & 0xFF, 0x25dff & 0xFF},
	{0x25e00 & 0xFF, 0x25eff & 0xFF},
	{0x25f00 & 0xFF, 0x25fff & 0xFF},
	{0x26000 & 0xFF, 0x260ff & 0xFF},
	{0x26100 & 0xFF, 0x261ff & 0xFF},
	{0x26200 & 0xFF, 0x262ff & 0xFF},
	{0x26300 & 0xFF, 0x263ff & 0xFF},
	{0x26400 & 0xFF, 0x264ff & 0xFF},
	{0x26500 & 0xFF, 0x265ff & 0xFF},
	{0x26600 & 0xFF, 0x266ff & 0xFF},
	{0x26700 & 0xFF, 0x267ff & 0xFF},
	{0x26800 & 0xFF, 0x268ff & 0xFF},
	{0x26900 & 0xFF, 0x269ff & 0xFF},
	{0x26a00 & 0xFF, 0x26aff & 0xFF},
	{0x26b00 & 0xFF, 0x26bff & 0xFF},
	{0x26c00 & 0xFF, 0x26cff & 0xFF},
	{0x26d00 & 0xFF, 0x26dff & 0xFF},
	{0x26e00 & 0xFF, 0x26eff & 0xFF},
	{0x26f00 & 0xFF, 0x26fff & 0xFF},
	{0x27000 & 0xFF, 0x270ff & 0xFF},
	{0x27100 & 0xFF, 0x271ff & 0xFF},
	{0x27200 & 0xFF, 0x272ff & 0xFF},
	{0x27300 & 0xFF, 0x273ff & 0xFF},
	{0x27400 & 0xFF, 0x274ff & 0xFF},
	{0x27500 & 0xFF, 0x275ff & 0xFF},
	{0x27600 & 0xFF, 0x276ff & 0xFF},
	{0x27700 & 0xFF, 0x277ff & 0xFF},
	{0x27800 & 0xFF, 0x278ff & 0xFF},
	{0x27900 & 0xFF, 0x279ff & 0xFF},
	{0x27a00 & 0xFF, 0x27aff & 0xFF},
	{0x27b00 & 0xFF, 0x27bff & 0xFF},
	{0x27c00 & 0xFF, 0x27cff & 0xFF},
	{0x27d00 & 0xFF, 0x27dff & 0xFF},
	{0x27e00 & 0xFF, 0x27eff & 0xFF},
	{0x27f00 & 0xFF, 0x27fff & 0xFF},
	{0x28000 & 0xFF, 0x280ff & 0xFF},
	{0x28100 & 0xFF, 0x281ff & 0xFF},
	{0x28200 & 0xFF, 0x282ff & 0xFF},
	{0x28300 & 0xFF, 0x283ff & 0xFF},
	{0x28400 & 0xFF, 0x284ff & 0xFF},
	{0x28500 & 0xFF, 0x285ff & 0xFF},
	{0x28600 & 0xFF, 0x286ff & 0xFF},
	{0x28700 & 0xFF, 0x287ff & 0xFF},
	{0x28800 & 0xFF, 0x288ff & 0xFF},
	{0x28900 & 0xFF, 0x289ff & 0xFF},
	{0x28a00 & 0xFF, 0x28aff & 0xFF},
	{0x28b00 & 0xFF, 0x28bff & 0xFF},
	{0x28c00 & 0xFF, 0x28cff & 0xFF},
	{0x28d00 & 0xFF, 0x28dff & 0xFF},
	{0x28e00 & 0xFF, 0x28eff & 0xFF},
	{0x28f00 & 0xFF, 0x28fff & 0xFF},
	{0x29000 & 0xFF, 0x290ff & 0xFF},
	{0x29100 & 0xFF, 0x291ff & 0xFF},
	{0x29200 & 0xFF, 0x292ff & 0xFF},
	{0x29300 & 0xFF, 0x293ff & 0xFF},
	{0x29400 & 0xFF, 0x294ff & 0xFF},
	{0x29500 & 0xFF, 0x295ff & 0xFF},
	{0x29600 & 0xFF, 0x296ff & 0xFF},
	{0x29700 & 0xFF, 0x297ff & 0xFF},
	{0x29800 & 0xFF, 0x298ff & 0xFF},
	{0x29900 & 0xFF, 0x299ff & 0xFF},
	{0x29a00 & 0xFF, 0x29aff & 0xFF},
	{0x29b00 & 0xFF, 0x29bff & 0xFF},
	{0x29c00 & 0xFF, 0x29cff & 0xFF},
	{0x29d00 & 0xFF, 0x29dff & 0xFF},
	{0x29e00 & 0xFF, 0x29eff & 0xFF},
	{0x29f00 & 0xFF, 0x29fff & 0xFF},
	{0x2a000 & 0xFF, 0x2a0ff & 0xFF},
	{0x2a100 & 0xFF, 0x2a1ff & 0xFF},
	{0x2a200 & 0xFF, 0x2a2ff & 0xFF},
	{0x2a300 & 0xFF, 0x2a3ff & 0xFF},
	{0x2a400 & 0xFF, 0x2a4ff & 0xFF},
	{0x2a500 & 0xFF, 0x2a5ff & 0xFF},
	{0x2a600 & 0xFF, 0x2a6df & 0xFF},
	{0x2a700 & 0xFF, 0x2a7ff & 0xFF},
	{0x2a800 & 0xFF, 0x2a8ff & 0xFF},
	{0x2a900 & 0xFF, 0x2a9ff & 0xFF},
	{0x2aa00 & 0xFF, 0x2aaff & 0xFF},
	{0x2ab00 & 0xFF, 0x2abff & 0xFF},
	{0x2ac00 & 0xFF, 0x2acff & 0xFF},
	{0x2ad00 & 0xFF, 0x2adff & 0xFF},
	{0x2ae00 & 0xFF, 0x2aeff & 0xFF},
	{0x2af00 & 0xFF, 0x2afff & 0xFF},
	{0x2b000 & 0xFF, 0x2b0ff & 0xFF},
	{0x2b100 & 0xFF, 0x2b1ff & 0xFF},
	{0x2b200 & 0xFF, 0x2b2ff & 0xFF},
	{0x2b300 & 0xFF, 0x2b3ff & 0xFF},
	{0x2b400 & 0xFF, 0x2b4ff & 0xFF},
	{0x2b500 & 0xFF, 0x2b5ff & 0xFF},
	{0x2b600 & 0xFF, 0x2b6ff & 0xFF},
	{0x2b700 & 0xFF, 0x2b739 & 0xFF},
	{0x2b740 & 0xFF, 0x2b7ff & 0xFF},
	{0x2b800 & 0xFF, 0x2b81d & 0xFF},
	{0x2b820 & 0xFF, 0x2b8ff & 0xFF},
	{0x2b900 & 0xFF, 0x2b9ff & 0xFF},
	{0x2ba00 & 0xFF, 0x2baff & 0xFF},
	{0x2bb00 & 0xFF, 0x2bbff & 0xFF},
	{0x2bc00 & 0xFF, 0x2bcff & 0xFF},
	{0x2bd00 & 0xFF, 0x2bdff & 0xFF},
	{0x2be00 & 0xFF, 0x2beff & 0xFF},
	{0x2bf00 & 0xFF, 0x2bfff & 0xFF},
	{0x2c000 & 0xFF, 0x2c0ff & 0xFF},
	{0x2c100 & 0xFF, 0x2c1ff & 0xFF},
	{0x2c200 & 0xFF, 0x2c2ff & 0xFF},
	{0x2c300 & 0xFF, 0x2c3ff & 0xFF},
	{0x2c400 & 0xFF, 0x2c4ff & 0xFF},
	{0x2c500 & 0xFF, 0x2c5ff & 0xFF},
	{0x2c600 & 0xFF, 0x2c6ff & 0xFF},
	{0x2c700 & 0xFF, 0x2c7ff & 0xFF},
	{0x2c800 & 0xFF, 0x2c8ff & 0xFF},
	{0x2c900 & 0xFF, 0x2c9ff & 0xFF},
	{0x2ca00 & 0xFF, 0x2caff & 0xFF},
	{0x2cb00 & 0xFF, 0x2cbff & 0xFF},
	{0x2cc00 & 0xFF, 0x2ccff & 0xFF},
	{0x2cd00 & 0xFF, 0x2cdff & 0xFF},
	{0x2ce00 & 0xFF, 0x2cea1 & 0xFF},
	{0x2ceb0 & 0xFF, 0x2ceff & 0xFF},
	{0x2cf00 & 0xFF, 0x2cfff & 0xFF},
	{0x2d000 & 0xFF, 0x2d0ff & 0xFF},
	{0x2d100 & 0xFF, 0x2d1ff & 0xFF},
	{0x2d200 & 0xFF, 0x2d2ff & 0xFF},
	{0x2d300 & 0xFF, 0x2d3ff & 0xFF},
	{0x2d400 & 0xFF, 0x2d4ff & 0xFF},
	{0x2d500 & 0xFF, 0x2d5ff & 0xFF},
	{0x2d600 & 0xFF, 0x2d6ff & 0xFF},
	{0x2d700 & 0xFF, 0x2d7ff & 0xFF},
	{0x2d800 & 0xFF, 0x2d8ff & 0xFF},
	{0x2d900 & 0xFF, 0x2d9ff & 0xFF},
	{0x2da00 & 0xFF, 0x2daff & 0xFF},
	{0x2db00 & 0xFF, 0x2dbff & 0xFF},
	{0x2dc00 & 0xFF, 0x2dcff & 0xFF},
	{0x2dd00 & 0xFF, 0x2ddff & 0xFF},
	{0x2de00 & 0xFF, 0x2deff & 0xFF},
	{0x2df00 & 0xFF, 0x2dfff & 0xFF},
	{0x2e000 & 0xFF, 0x2e0ff & 0xFF},
	{0x2e100 & 0xFF, 0x2e1ff & 0xFF},
	{0x2e200 & 0xFF, 0x2e2ff & 0xFF},
	{0x2e300 & 0xFF, 0x2e3ff & 0xFF},
	{0x2e400 & 0xFF, 0x2e4ff & 0xFF},
	{0x2e500 & 0xFF, 0x2e5ff & 0xFF},
	{0x2e600 & 0xFF, 0x2e6ff & 0xFF},
	{0x2e700 & 0xFF, 0x2e7ff & 0xFF},
	{0x2e800 & 0xFF, 0x2e8ff & 0xFF},
	{0x2e900 & 0xFF, 0x2e9ff & 0xFF},
	{0x2ea00 & 0xFF, 0x2eaff & 0xFF},
	{0x2eb00 & 0xFF, 0x2ebe0 & 0xFF},
	{0x2ebf0 & 0xFF, 0x2ebff & 0xFF},
	{0x2ec00 & 0xFF, 0x2ecff & 0xFF},
	{0x2ed00 & 0xFF, 0x2edff & 0xFF},
	{0x2ee00 & 0xFF, 0x2ee5d & 0xFF},
	{0x2f800 & 0xFF, 0x2f8ff & 0xFF},
	{0x2f900 & 0xFF, 0x2f9ff & 0xFF},
	{0x2fa00 & 0xFF, 0x2fa1d & 0xFF},
	{0x30000 & 0xFF, 0x300ff & 0xFF},
	{0x30100 & 0xFF, 0x301ff & 0xFF},
	{0x30200 & 0xFF, 0x302ff & 0xFF},
	{0x30300 & 0xFF, 0x303ff & 0xFF},
	{0x30400 & 0xFF, 0x304ff & 0xFF},
	{0x30500 & 0xFF, 0x305ff & 0xFF},
	{0x30600 & 0xFF, 0x306ff & 0xFF},
	{0x30700 & 0xFF, 0x307ff & 0xFF},
	{0x30800 & 0xFF, 0x308ff & 0xFF},
	{0x30900 & 0xFF, 0x309ff & 0xFF},
	{0x30a00 & 0xFF, 0x30aff & 0xFF},
	{0x30b00 & 0xFF, 0x30bff & 0xFF},
	{0x30c00 & 0xFF, 0x30cff & 0xFF},
	{0x30d00 & 0xFF, 0x30dff & 0xFF},
	{0x30e00 & 0xFF, 0x30eff & 0xFF},
	{0x30f00 & 0xFF, 0x30fff & 0xFF},
	{0x31000 & 0xFF, 0x310ff & 0xFF},
	{0x31100 & 0xFF, 0x311ff & 0xFF},
	{0x31200 & 0xFF, 0x312ff & 0xFF},
	{0x31300 & 0xFF, 0x3134a & 0xFF},
	{0x31350 & 0xFF, 0x313ff & 0xFF},
	{0x31400 & 0xFF, 0x314ff & 0xFF},
	{0x31500 & 0xFF, 0x315ff & 0xFF},
	{0x31600 & 0xFF, 0x316ff & 0xFF},
	{0x31700 & 0xFF, 0x317ff & 0xFF},
	{0x31800 & 0xFF, 0x318ff & 0xFF},
	{0x31900 & 0xFF, 0x319ff & 0xFF},
	{0x31a00 & 0xFF, 0x31aff & 0xFF},
	{0x31b00 & 0xFF, 0x31bff & 0xFF},
	{0x31c00 & 0xFF, 0x31cff & 0xFF},
	{0x31d00 & 0xFF, 0x31dff & 0xFF},
	{0x31e00 & 0xFF, 0x31eff & 0xFF},
	{0x31f00 & 0xFF, 0x31fff & 0xFF},
	{0x32000 & 0xFF, 0x320ff & 0xFF},
	{0x32100 & 0xFF, 0x321ff & 0xFF},
	{0x32200 & 0xFF, 0x322ff & 0xFF},
	{0x32300 & 0xFF, 0x323af & 0xFF}};

static const size_t XID_Start_starting_indextab[]={
	0,
	1,
	2,
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	30,
	31,
	32,
	33,
	44,
	45,
	48,
	49,
	52,
	53,
	54,
	55,
	56,
	57,
	58,
	59,
	60,
	61,
	62,
	63,
	64,
	65,
	66,
	67,
	68,
	69,
	70,
	71,
	72,
	73,
	74,
	75,
	76,
	77,
	78,
	79,
	80,
	81,
	82,
	83,
	84,
	85,
	86,
	87,
	88,
	89,
	90,
	91,
	92,
	93,
	94,
	95,
	96,
	97,
	98,
	99,
	100,
	101,
	102,
	103,
	104,
	105,
	106,
	107,
	108,
	109,
	110,
	111,
	112,
	113,
	114,
	115,
	116,
	117,
	118,
	119,
	120,
	121,
	122,
	123,
	124,
	125,
	126,
	127,
	128,
	129,
	130,
	131,
	132,
	133,
	134,
	135,
	136,
	137,
	138,
	139,
	140,
	141,
	142,
	143,
	144,
	145,
	146,
	147,
	148,
	149,
	150,
	151,
	152,
	153,
	154,
	155,
	156,
	157,
	158,
	159,
	160,
	161,
	162,
	163,
	164,
	165,
	166,
	167,
	168,
	169,
	170,
	171,
	172,
	173,
	174,
	175,
	176,
	177,
	178,
	179,
	180,
	181,
	182,
	183,
	184,
	185,
	186,
	187,
	188,
	189,
	190,
	191,
	192,
	193,
	194,
	195,
	196,
	197,
	198,
	199,
	200,
	201,
	202,
	203,
	204,
	205,
	206,
	207,
	208,
	209,
	210,
	211,
	212,
	213,
	214,
	215,
	249,
	250,
	251,
	252,
	253,
	254,
	255,
	256,
	257,
	258,
	259,
	260,
	261,
	262,
	263,
	264,
	265,
	266,
	267,
	268,
	269,
	270,
	271,
	272,
	273,
	274,
	275,
	276,
	277,
	278,
	279,
	280,
	281,
	282,
	284,
	285,
	286,
	287,
	288,
	289,
	290,
	291,
	292,
	293,
	303,
	304,
	305,
	306,
	307,
	308,
	324,
	325,
	326,
	360,
	361,
	362,
	363,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	431,
	432,
	433,
	434,
	444,
	468,
	469,
	470,
	471,
	479,
	480,
	481,
	482,
	484,
	487,
	488,
	489,
	494,
	512,
	513,
	514,
	515,
	516,
	517,
	518,
	519,
	520,
	521,
	522,
	523,
	524,
	525,
	526,
	527,
	528,
	529,
	530,
	531,
	532,
	533,
	534,
	535,
	536,
	537,
	538,
	539,
	540,
	541,
	542,
	543,
	544,
	545,
	546,
	547,
	548,
	549,
	550,
	551,
	552,
	553,
	554,
	555,
	556,
	557,
	558,
	559,
	560,
	561,
	562,
	563,
	564,
	565,
	566,
	567,
	568,
	569,
	570,
	571,
	572,
	573,
	574,
	575,
	576,
	577,
	578,
	579,
	580,
	581,
	582,
	583,
	584,
	585,
	586,
	587,
	588,
	589,
	590,
	591,
	592,
	593,
	594,
	595,
	596,
	597,
	598,
	599,
	600,
	601,
	602,
	603,
	604,
	605,
	606,
	607,
	608,
	609,
	610,
	611,
	612,
	613,
	614,
	615,
	616,
	617,
	618,
	619,
	620,
	621,
	622,
	623,
	624,
	625,
	626,
	627,
	628,
	629,
	630,
	631,
	632,
	633,
	634,
	635,
	636,
	637,
	638,
	639,
	640,
	641,
	642,
	643,
	644,
	645,
	646,
	647,
	648,
	649,
	650,
	651,
	652,
	653,
	654,
	655,
	656,
	657,
	658,
	659,
	660,
	661,
	662,
	663,
	664,
	665,
	666,
	667,
	668,
	669,
	670,
	671,
	672,
	673,
	674,
	675,
	676,
	677,
	678,
	679,
	680,
	681,
	682,
	683,
	684,
	685,
	686,
	687,
	688,
	689,
	690,
	691,
	692,
	693,
	694,
	695,
	696,
	697,
	698,
	699,
	700,
	701,
	702,
	703,
	704,
	705,
	706,
	707,
	708,
	709,
	710,
	711,
	712,
	713,
	714,
	715,
	716,
	717,
	718,
	719,
	720,
	721,
	722,
	723,
	724,
	725,
	726,
	727,
	728,
	729,
	730,
	731,
	732,
	733,
	734,
	735,
	736,
	737,
	738,
	739,
	740,
	741,
	742,
	743,
	744,
	745,
	746,
	747,
	748,
	749,
	750,
	760,
	761,
	762,
	768,
	769,
	770,
	771,
	772,
	773,
	774,
	775,
	776,
	777,
	778,
	779,
	780,
	781,
	782,
	783,
	784,
	785,
	786,
	787,
	788,
	789,
	790,
	791,
	792,
	793,
	794,
	795,
	796,
	797,
	798,
	799,
	800,
	801,
	802,
	803
};

static const char32_t XID_Start_starting_pagetab[]={
	0,
	8,
	9,
	14,
	24,
	26,
	32,
	40,
	47,
	56,
	73,
	93,
	114,
	132,
	145,
	159,
	163,
	177,
	178,
	192,
	198,
	199,
	200,
	205,
	213,
	217,
	222,
	225,
	230,
	240,
	241,
	242,
	261,
	264,
	277,
	280,
	294,
	302,
	306,
	307,
	308,
	309,
	310,
	311,
	312,
	313,
	314,
	315,
	316,
	317,
	318,
	319,
	320,
	321,
	322,
	323,
	324,
	325,
	326,
	327,
	328,
	329,
	330,
	331,
	332,
	333,
	334,
	335,
	336,
	337,
	338,
	339,
	340,
	341,
	342,
	343,
	344,
	345,
	346,
	347,
	348,
	349,
	350,
	351,
	352,
	353,
	354,
	355,
	356,
	357,
	358,
	359,
	360,
	361,
	362,
	363,
	364,
	365,
	366,
	367,
	368,
	369,
	370,
	371,
	372,
	373,
	374,
	375,
	376,
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390,
	391,
	392,
	393,
	394,
	395,
	396,
	397,
	398,
	399,
	400,
	401,
	402,
	403,
	404,
	405,
	406,
	407,
	408,
	409,
	410,
	411,
	412,
	413,
	414,
	415,
	416,
	417,
	418,
	420,
	421,
	427,
	434,
	443,
	451,
	465,
	473,
	474,
	475,
	476,
	477,
	478,
	479,
	480,
	481,
	482,
	483,
	484,
	485,
	486,
	487,
	488,
	489,
	490,
	491,
	492,
	493,
	494,
	495,
	496,
	497,
	498,
	499,
	500,
	501,
	502,
	503,
	504,
	505,
	506,
	507,
	508,
	509,
	510,
	511,
	512,
	513,
	514,
	515,
	516,
	519,
	520,
	522,
	533,
	535,
	539,
	546,
	554,
	561,
	562,
	564,
	571,
	574,
	584,
	585,
	591,
	601,
	605,
	613,
	617,
	620,
	621,
	623,
	629,
	634,
	643,
	652,
	661,
	667,
	669,
	673,
	675,
	678,
	689,
	696,
	700,
	708,
	709,
	713,
	714,
	715,
	716,
	717,
	719,
	720,
	721,
	722,
	723,
	724,
	725,
	727,
	728,
	729,
	730,
	731,
	732,
	736,
	740,
	741,
	746,
	747,
	748,
	749,
	750,
	751,
	752,
	753,
	754,
	755,
	756,
	757,
	758,
	759,
	760,
	761,
	762,
	763,
	764,
	765,
	766,
	767,
	768,
	769,
	770,
	771,
	772,
	773,
	774,
	775,
	776,
	779,
	780,
	786,
	787,
	791,
	801,
	811,
	816,
	824,
	826,
	827,
	830,
	832,
	833,
	837,
	838,
	840,
	873,
	874,
	875,
	876,
	877,
	878,
	879,
	880,
	881,
	882,
	883,
	884,
	885,
	886,
	887,
	888,
	889,
	890,
	891,
	892,
	893,
	894,
	895,
	896,
	897,
	898,
	899,
	900,
	901,
	902,
	903,
	904,
	905,
	906,
	907,
	908,
	909,
	910,
	911,
	912,
	913,
	914,
	915,
	916,
	917,
	918,
	919,
	920,
	921,
	922,
	923,
	924,
	925,
	926,
	927,
	928,
	929,
	930,
	931,
	932,
	933,
	934,
	935,
	936,
	937,
	938,
	939,
	940,
	941,
	942,
	943,
	944,
	945,
	946,
	947,
	948,
	949,
	950,
	951,
	952,
	953,
	954,
	955,
	956,
	957,
	958,
	959,
	960,
	961,
	962,
	963,
	964,
	965,
	966,
	967,
	968,
	969,
	970,
	971,
	972,
	973,
	974,
	975,
	976,
	977,
	978,
	979,
	980,
	981,
	982,
	983,
	984,
	985,
	986,
	987,
	988,
	989,
	990,
	991,
	992,
	993,
	994,
	995,
	996,
	997,
	998,
	999,
	1000,
	1001,
	1002,
	1003,
	1004,
	1005,
	1006,
	1007,
	1008,
	1009,
	1010,
	1011,
	1012,
	1013,
	1014,
	1015,
	1016,
	1017,
	1018,
	1019,
	1020,
	1021,
	1022,
	1023,
	1024,
	1025,
	1026,
	1027,
	1028,
	1029,
	1030,
	1031,
	1032,
	1033,
	1034,
	1035,
	1036,
	1037,
	1038,
	1039,
	1040,
	1041,
	1042,
	1043,
	1044,
	1045,
	1046,
	1047,
	1048,
	1049,
	1050,
	1051,
	1052,
	1053,
	1054,
	1055,
	1056,
	1058,
	1060,
	1061,
	1062,
	1063,
	1064,
	1065,
	1066,
	1067,
	1068,
	1069,
	1070,
	1071,
	1072,
	1073,
	1074,
	1075,
	1076,
	1077,
	1078,
	1079,
	1080,
	1081,
	1083,
	1084,
	1085,
	1086,
	1087,
	1088,
	1089,
	1090,
	1091,
	1092,
	1093,
	1094,
	1095,
	1096,
	1097,
	1098,
	1099,
	1100,
	1101,
	1102,
	1103,
	1104,
	1105,
	1106,
	1107,
	1108,
	1109,
	1110,
	1111,
	1113,
	1114,
	1115,
	1116,
	1117,
	1118,
	1119,
	1120,
	1121,
	1122,
	1123,
	1124,
	1125,
	1126,
	1127,
	1128,
	1129,
	1130,
	1131,
	1132,
	1133,
	1134,
	1135,
	1136,
	1137,
	1138,
	1140,
	1141,
	1142,
	1143,
	1144,
	1145,
	1146,
	1147,
	1148,
	1149,
	1150,
	1151,
	1152,
	1153,
	1154,
	1155
};


int unicode_derived_incb_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        InCB_starting_indextab,
        InCB_starting_pagetab,
        sizeof(InCB_starting_indextab)/
        sizeof(InCB_starting_indextab[0]),
        InCB_rangetab,
        sizeof(InCB_rangetab)/
        sizeof(InCB_rangetab[0]),
        InCB_classtab,
        0
    );
}

int unicode_derived_alphabetic_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Alphabetic_starting_indextab,
        Alphabetic_starting_pagetab,
        sizeof(Alphabetic_starting_indextab)/
        sizeof(Alphabetic_starting_indextab[0]),
        Alphabetic_rangetab,
        sizeof(Alphabetic_rangetab)/
        sizeof(Alphabetic_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_case_ignorable_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Case_Ignorable_starting_indextab,
        Case_Ignorable_starting_pagetab,
        sizeof(Case_Ignorable_starting_indextab)/
        sizeof(Case_Ignorable_starting_indextab[0]),
        Case_Ignorable_rangetab,
        sizeof(Case_Ignorable_rangetab)/
        sizeof(Case_Ignorable_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_cased_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Cased_starting_indextab,
        Cased_starting_pagetab,
        sizeof(Cased_starting_indextab)/
        sizeof(Cased_starting_indextab[0]),
        Cased_rangetab,
        sizeof(Cased_rangetab)/
        sizeof(Cased_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_changes_when_casefolded_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Changes_When_Casefolded_starting_indextab,
        Changes_When_Casefolded_starting_pagetab,
        sizeof(Changes_When_Casefolded_starting_indextab)/
        sizeof(Changes_When_Casefolded_starting_indextab[0]),
        Changes_When_Casefolded_rangetab,
        sizeof(Changes_When_Casefolded_rangetab)/
        sizeof(Changes_When_Casefolded_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_changes_when_casemapped_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Changes_When_Casemapped_starting_indextab,
        Changes_When_Casemapped_starting_pagetab,
        sizeof(Changes_When_Casemapped_starting_indextab)/
        sizeof(Changes_When_Casemapped_starting_indextab[0]),
        Changes_When_Casemapped_rangetab,
        sizeof(Changes_When_Casemapped_rangetab)/
        sizeof(Changes_When_Casemapped_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_changes_when_lowercased_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Changes_When_Lowercased_starting_indextab,
        Changes_When_Lowercased_starting_pagetab,
        sizeof(Changes_When_Lowercased_starting_indextab)/
        sizeof(Changes_When_Lowercased_starting_indextab[0]),
        Changes_When_Lowercased_rangetab,
        sizeof(Changes_When_Lowercased_rangetab)/
        sizeof(Changes_When_Lowercased_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_changes_when_titlecased_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Changes_When_Titlecased_starting_indextab,
        Changes_When_Titlecased_starting_pagetab,
        sizeof(Changes_When_Titlecased_starting_indextab)/
        sizeof(Changes_When_Titlecased_starting_indextab[0]),
        Changes_When_Titlecased_rangetab,
        sizeof(Changes_When_Titlecased_rangetab)/
        sizeof(Changes_When_Titlecased_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_changes_when_uppercased_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Changes_When_Uppercased_starting_indextab,
        Changes_When_Uppercased_starting_pagetab,
        sizeof(Changes_When_Uppercased_starting_indextab)/
        sizeof(Changes_When_Uppercased_starting_indextab[0]),
        Changes_When_Uppercased_rangetab,
        sizeof(Changes_When_Uppercased_rangetab)/
        sizeof(Changes_When_Uppercased_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_default_ignorable_code_point_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Default_Ignorable_Code_Point_starting_indextab,
        Default_Ignorable_Code_Point_starting_pagetab,
        sizeof(Default_Ignorable_Code_Point_starting_indextab)/
        sizeof(Default_Ignorable_Code_Point_starting_indextab[0]),
        Default_Ignorable_Code_Point_rangetab,
        sizeof(Default_Ignorable_Code_Point_rangetab)/
        sizeof(Default_Ignorable_Code_Point_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_grapheme_base_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Grapheme_Base_starting_indextab,
        Grapheme_Base_starting_pagetab,
        sizeof(Grapheme_Base_starting_indextab)/
        sizeof(Grapheme_Base_starting_indextab[0]),
        Grapheme_Base_rangetab,
        sizeof(Grapheme_Base_rangetab)/
        sizeof(Grapheme_Base_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_grapheme_extend_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Grapheme_Extend_starting_indextab,
        Grapheme_Extend_starting_pagetab,
        sizeof(Grapheme_Extend_starting_indextab)/
        sizeof(Grapheme_Extend_starting_indextab[0]),
        Grapheme_Extend_rangetab,
        sizeof(Grapheme_Extend_rangetab)/
        sizeof(Grapheme_Extend_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_grapheme_link_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Grapheme_Link_starting_indextab,
        Grapheme_Link_starting_pagetab,
        sizeof(Grapheme_Link_starting_indextab)/
        sizeof(Grapheme_Link_starting_indextab[0]),
        Grapheme_Link_rangetab,
        sizeof(Grapheme_Link_rangetab)/
        sizeof(Grapheme_Link_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_id_continue_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        ID_Continue_starting_indextab,
        ID_Continue_starting_pagetab,
        sizeof(ID_Continue_starting_indextab)/
        sizeof(ID_Continue_starting_indextab[0]),
        ID_Continue_rangetab,
        sizeof(ID_Continue_rangetab)/
        sizeof(ID_Continue_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_id_start_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        ID_Start_starting_indextab,
        ID_Start_starting_pagetab,
        sizeof(ID_Start_starting_indextab)/
        sizeof(ID_Start_starting_indextab[0]),
        ID_Start_rangetab,
        sizeof(ID_Start_rangetab)/
        sizeof(ID_Start_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_lowercase_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Lowercase_starting_indextab,
        Lowercase_starting_pagetab,
        sizeof(Lowercase_starting_indextab)/
        sizeof(Lowercase_starting_indextab[0]),
        Lowercase_rangetab,
        sizeof(Lowercase_rangetab)/
        sizeof(Lowercase_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_math_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Math_starting_indextab,
        Math_starting_pagetab,
        sizeof(Math_starting_indextab)/
        sizeof(Math_starting_indextab[0]),
        Math_rangetab,
        sizeof(Math_rangetab)/
        sizeof(Math_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_uppercase_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        Uppercase_starting_indextab,
        Uppercase_starting_pagetab,
        sizeof(Uppercase_starting_indextab)/
        sizeof(Uppercase_starting_indextab[0]),
        Uppercase_rangetab,
        sizeof(Uppercase_rangetab)/
        sizeof(Uppercase_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_xid_continue_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        XID_Continue_starting_indextab,
        XID_Continue_starting_pagetab,
        sizeof(XID_Continue_starting_indextab)/
        sizeof(XID_Continue_starting_indextab[0]),
        XID_Continue_rangetab,
        sizeof(XID_Continue_rangetab)/
        sizeof(XID_Continue_rangetab[0]),
        NULL,
        0
    );
}

int unicode_derived_xid_start_lookup(char32_t ch)
{
    return unicode_tab_lookup(
        ch,
        XID_Start_starting_indextab,
        XID_Start_starting_pagetab,
        sizeof(XID_Start_starting_indextab)/
        sizeof(XID_Start_starting_indextab[0]),
        XID_Start_rangetab,
        sizeof(XID_Start_rangetab)/
        sizeof(XID_Start_rangetab[0]),
        NULL,
        0
    );
}
