# GYP file to build unit tests.
{
  'includes': [
    'apptype_console.gypi',
    'common.gypi',
  ],
  'targets': [
    {
      'target_name': 'pixman_test',
      'type': 'executable',
      'mac_bundle' : 1,
      'defines': [
        'HAVE_CONFIG_H',
      ],
      'include_dirs' : [
        '../src/core',
        '../experimental/pixman',
        '../experimental/SimpleCocoaApp', # needed to get SimpleApp.h
      ],
      'sources': [
        '../experimental/pixman/config.h',
        '../experimental/pixman/junk.cpp',
#        '../../../pixman/demos/alpha-test.c',
        '../../../pixman/demos/checkerboard.c',
#        '../../../pixman/demos/clip-in.c',
#        '../../../pixman/demos/clip-test.c',
#        '../../../pixman/demos/composite-test.c',
#        '../../../pixman/demos/convolution-test.c',
#        '../../../pixman/demos/gradient-test.c',
#        '../../../pixman/demos/gtk-utils.c',
#        '../../../pixman/demos/parrot.c',
#        '../../../pixman/demos/quad2quad.c',
#        '../../../pixman/demos/radial-test.c',
#        '../../../pixman/demos/screen-test.c',
#        '../../../pixman/demos/srgb-test.c',
#        '../../../pixman/demos/srgb-trap-test.c',
#        '../../../pixman/demos/trap-test.c',
#        '../../../pixman/demos/tri-test.c',
        '../../../pixman/demos/gtk-utils.h',
#        '../../../pixman/test/a1-trap-test.c',
#        '../../../pixman/test/affine-test.c',
#        '../../../pixman/test/alpha-loop.c',
#        '../../../pixman/test/alphamap.c',
#        '../../../pixman/test/blitters-test.c',
#        '../../../pixman/test/combiner-test.c',
#        '../../../pixman/test/composite-traps-test.c',
#        '../../../pixman/test/composite.c',
#        '../../../pixman/test/fetch-test.c',
#        '../../../pixman/test/glyph-test.c',
#        '../../../pixman/test/gradient-crash-test.c',
#        '../../../pixman/test/infinite-loop.c',
#        '../../../pixman/test/lowlevel-blt-bench.c',
#        '../../../pixman/test/oob-test.c',
#        '../../../pixman/test/pdf-op-test.c',
#        '../../../pixman/test/region-contains-test.c',
#        '../../../pixman/test/region-test.c',
#        '../../../pixman/test/region-translate-test.c',
#        '../../../pixman/test/rotate-test.c',
#        '../../../pixman/test/scaling-crash-test.c',
#        '../../../pixman/test/scaling-helpers-test.c',
#        '../../../pixman/test/scaling-test.c',
#        '../../../pixman/test/stress-test.c',
#        '../../../pixman/test/trap-crasher.c',
        '../../../pixman/test/utils.c',
        '../../../pixman/test/utils.h',
        '../../../pixman/pixman/pixman-access-accessors.c',
        '../../../pixman/pixman/pixman-access.c',
#        '../../../pixman/pixman/pixman-arm-neon.c',
#        '../../../pixman/pixman/pixman-arm-simd.c',
        '../../../pixman/pixman/pixman-arm.c',
        '../../../pixman/pixman/pixman-bits-image.c',
        '../../../pixman/pixman/pixman-combine-float.c',
        '../../../pixman/pixman/pixman-combine32.c',
        '../../../pixman/pixman/pixman-conical-gradient.c',
        '../../../pixman/pixman/pixman-edge-accessors.c',
        '../../../pixman/pixman/pixman-edge.c',
        '../../../pixman/pixman/pixman-fast-path.c',
        '../../../pixman/pixman/pixman-general.c',
        '../../../pixman/pixman/pixman-glyph.c',
        '../../../pixman/pixman/pixman-gradient-walker.c',
        '../../../pixman/pixman/pixman-image.c',
        '../../../pixman/pixman/pixman-implementation.c',
        '../../../pixman/pixman/pixman-linear-gradient.c',
        '../../../pixman/pixman/pixman-matrix.c',
#        '../../../pixman/pixman/pixman-mips-dspr2.c',
        '../../../pixman/pixman/pixman-mips.c',
        '../../../pixman/pixman/pixman-mmx.c',
        '../../../pixman/pixman/pixman-noop.c',
        '../../../pixman/pixman/pixman-ppc.c',
        '../../../pixman/pixman/pixman-radial-gradient.c',
#        '../../../pixman/pixman/pixman-region.c',
        '../../../pixman/pixman/pixman-region16.c',
        '../../../pixman/pixman/pixman-region32.c',
        '../../../pixman/pixman/pixman-solid-fill.c',
        '../../../pixman/pixman/pixman-sse2.c',
        '../../../pixman/pixman/pixman-timer.c',
        '../../../pixman/pixman/pixman-trap.c',
        '../../../pixman/pixman/pixman-utils.c',
#        '../../../pixman/pixman/pixman-vmx.c',
        '../../../pixman/pixman/pixman-x86.c',
        '../../../pixman/pixman/pixman.c',
#        '../../../pixman/pixman/pixman-arm-neon-asm-bilinear.S',
#        '../../../pixman/pixman/pixman-arm-neon-asm.S',
#        '../../../pixman/pixman/pixman-arm-simd-asm.S',
#        '../../../pixman/pixman/pixman-mips-dspr2-asm.S',
#        '../../../pixman/pixman/pixman-mips-memcpy-asm.S',
        '../../../pixman/pixman/loongson-mmintrin.h',
        '../../../pixman/pixman/pixman-accessor.h',
        '../../../pixman/pixman/pixman-arm-common.h',
        '../../../pixman/pixman/pixman-arm-neon-asm.h',
        '../../../pixman/pixman/pixman-combine32.h',
        '../../../pixman/pixman/pixman-compiler.h',
        '../../../pixman/pixman/pixman-edge-imp.h',
        '../../../pixman/pixman/pixman-inlines.h',
        '../../../pixman/pixman/pixman-mips-dspr2-asm.h',
        '../../../pixman/pixman/pixman-mips-dspr2.h',
        '../../../pixman/pixman/pixman-private.h',
        '../../../pixman/pixman/pixman.h',
      ],
      'dependencies': [
        'skia_lib.gyp:skia_lib',
        'experimental.gyp:experimental',
        'pdf.gyp:pdf',
        'views.gyp:views',
        'xml.gyp:xml',
      ],
      'conditions': [
        [ 'skia_os in ["linux", "freebsd", "openbsd", "solaris", "chromeos"]', {
        }],
        [ 'skia_os == "win"', {
        }],
        [ 'skia_os == "mac"', {
          'sources': [

            # Mac files
            '../src/views/mac/SkEventNotifier.h',
            '../src/views/mac/SkEventNotifier.mm',
            '../src/views/mac/skia_mac.mm',
            '../src/views/mac/SkNSView.h',
            '../src/views/mac/SkNSView.mm',
            '../src/views/mac/SkOptionsTableView.h',
            '../src/views/mac/SkOptionsTableView.mm',
            '../src/views/mac/SkOSWindow_Mac.mm',
            '../src/views/mac/SkTextFieldCell.h',
            '../src/views/mac/SkTextFieldCell.m',
          ],
          'libraries': [
            '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
            '$(SDKROOT)/System/Library/Frameworks/OpenGL.framework',
          ],
          'xcode_settings' : {
            'INFOPLIST_FILE' : '../experimental/Intersection/EdgeDemoApp-Info.plist',
          },
          'mac_bundle_resources' : [
            '../experimental/Intersection/EdgeDemoApp.xib',
          ],
        }],
      ],
      'msvs_settings': {
        'VCLinkerTool': {
          'SubSystem': '2',
          'AdditionalDependencies': [
            'd3d9.lib',
          ],
        },
      },
    },
  ],
}

# Local Variables:
# tab-width:2
# indent-tabs-mode:nil
# End:
# vim: set expandtab tabstop=2 shiftwidth=2:
