/*
 * predefined.c --- well-known UUIDs from the RFC-4122 namespace
 *
 * Copyright (C) 2017 Philip Prindeville
 *
 * %Begin-Header%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 * %End-Header%
 */

#include <string.h>
#include "uuid.h"

/*
 * These are time-based UUIDs that are well-known in that they've
 * been canonized as part of RFC-4122, Appendex C.  They are to
 * be used as the namespace (ns) argument to the uuid_generate_md5()
 * and uuid_generate_sha1() functions.
 *
 * See Section 4.3 for the particulars of how namespace UUIDs
 * are combined with seed values to generate new UUIDs.
 */

UUID_DEFINE(NameSpace_DNS,
	0x6b, 0xa7, 0xb8, 0x10, 0x9d, 0xad, 0x11, 0xd1,
	0x80, 0xb4, 0x00, 0xc0, 0x4f, 0xd4, 0x30, 0xc8);

UUID_DEFINE(NameSpace_URL,
	0x6b, 0xa7, 0xb8, 0x11, 0x9d, 0xad, 0x11, 0xd1,
	0x80, 0xb4, 0x00, 0xc0, 0x4f, 0xd4, 0x30, 0xc8);

UUID_DEFINE(NameSpace_OID,
	0x6b, 0xa7, 0xb8, 0x12, 0x9d, 0xad, 0x11, 0xd1,
	0x80, 0xb4, 0x00, 0xc0, 0x4f, 0xd4, 0x30, 0xc8);

UUID_DEFINE(NameSpace_X500,
	0x6b, 0xa7, 0xb8, 0x14, 0x9d, 0xad, 0x11, 0xd1,
	0x80, 0xb4, 0x00, 0xc0, 0x4f, 0xd4, 0x30, 0xc8);

const uuid_t *uuid_get_template(const char *alias)
{
	if (!alias || !*alias)
		return NULL;

	if (!strcmp(alias, "dns"))
		return &NameSpace_DNS;
	else if (!strcmp(alias, "url"))
		return &NameSpace_URL;
	else if (!strcmp(alias, "oid"))
		return &NameSpace_OID;
	else if (!strcmp(alias, "x500") || !strcmp(alias, "x.500"))
		return &NameSpace_X500;
	else
		return NULL;
}

