#############################################################
#
# rarpd
#
#############################################################
ifneq ($(USE_CVS), true)
RARPD_SOURCE:=rarpd.tar.gz
RARPD_CAT:=zcat
endif
RARPD_DIR:=$(BUILD_DIR)/rarpd

RARPD_BINARY:=rarpd
RARPD_TARGET_BINARY:=usr/sbin/rarpd

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(RARPD_SOURCE):

rarpd-source: $(DL_DIR)/$(RARPD_SOURCE)
else
rarpd-source:
endif

RARPD_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d rarpd $(CVS_TAG) $(CVS_PREFIX)rarpd

rarpd-checkout:
	@$(RARPD_CVSCO)

$(RARPD_DIR)/.unpacked: $(DL_DIR)/$(RARPD_SOURCE)
ifneq ($(USE_CVS), true)
	$(RARPD_CAT) $(DL_DIR)/$(RARPD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(RARPD_CVSCO)
endif
	-cat $(SOURCE_DIR)/rarpd.patch | patch -p1 -d $(RARPD_DIR)
	touch  $(RARPD_DIR)/.unpacked

$(RARPD_DIR)/.configured: $(RARPD_DIR)/.unpacked
	touch $(RARPD_DIR)/.configured

$(RARPD_DIR)/$(RARPD_BINARY): $(RARPD_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(RARPD_DIR)

$(TARGET_DIR)/$(RARPD_TARGET_BINARY): $(RARPD_DIR)/$(RARPD_BINARY)
	install $(RARPD_DIR)/$(RARPD_BINARY) $(TARGET_DIR)/$(RARPD_TARGET_BINARY)
	install -m0755 $(RARPD_DIR)/rarpd.init $(TARGET_DIR)/etc/rc.d/init.d/rarpd

rarpd:  uclibc initscripts $(TARGET_DIR)/$(RARPD_TARGET_BINARY)

rarpd-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(RARPD_DIR) uninstall
	-rm -f $(TARGET_DIR)/etc/rc.d/init.d/rarpd
	-$(MAKE) -C $(RARPD_DIR) clean

rarpd-dirclean:
	rm -rf $(RARPD_DIR)

