#############################################################
#
# gawk
#
#############################################################
ifneq ($(USE_CVS),true)
GAWK_SOURCE:=gawk.tar.gz
GAWK_SITE:=ftp://ftp.gnu.org/gnu/gawk
GAWK_CAT:=zcat
GAWK_DIR:=$(BUILD_DIR)/${shell basename $(GAWK_SOURCE) .tar.gz}
else
# using CVS
GAWK_DIR:=$(BUILD_DIR)/gawk
endif
GAWK_PATCH:=$(SOURCE_DIR)/gawk.patch

GAWK_BINARY:=gawk
GAWK_TARGET_BINARY:=usr/bin/gawk

ifneq ($(USE_CVS),true)
gawk-fetch:
	 $(WGET) -P $(DL_DIR) $(GAWK_SITE)/$(GAWK_SOURCE)

gawk-source: $(DL_DIR)/$(GAWK_SOURCE)
else
gawk-source:
endif

GAWK_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d gawk $(CVS_TAG) $(CVS_PREFIX)gawk

gawk-checkout:
	@$(GAWK_CVSCO)

$(GAWK_DIR)/.unpacked: $(DL_DIR)/$(GAWK_SOURCE)
ifneq ($(USE_CVS),true)
	$(GAWK_CAT) $(DL_DIR)/$(GAWK_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(GAWK_CVSCO)
endif
	touch $(GAWK_DIR)/.unpacked

$(GAWK_DIR)/.patched: $(GAWK_DIR)/.unpacked
	cat $(GAWK_PATCH) | patch -d $(GAWK_DIR) -p1
	touch $(GAWK_DIR)/.patched

$(GAWK_DIR)/.configured: $(GAWK_DIR)/.patched
	(cd $(GAWK_DIR); rm -rf config.cache; autoconf; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		ac_cv_func_getpgrp_void=yes \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(GAWK_DIR)/.configured

$(GAWK_DIR)/$(GAWK_BINARY): $(GAWK_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(GAWK_DIR)

$(TARGET_DIR)/$(GAWK_TARGET_BINARY): $(GAWK_DIR)/$(GAWK_BINARY)
	rm -f $(TARGET_DIR)/usr/bin/awk
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(GAWK_DIR) install
	rm -f $(TARGET_DIR)/usr/bin/gawk-*
	(cd $(TARGET_DIR)/usr/bin; ln -sf gawk awk) 
	(cd $(TARGET_DIR)/usr/man/man1; ln -sf gawk.1 awk.1)
	$(STRIP) $(TARGET_DIR)/usr/lib/awk/* > /dev/null 2>&1
	$(STRIP) $(TARGET_DIR)/usr/bin/gawk
	$(STRIP) $(TARGET_DIR)/usr/bin/pgawk
	rm -rf $(TARGET_DIR)/share/locale
	mkdir -p $(DOC_DIR)/doc/gawk
	for f in COPYING LIMITATIONS POSIX.STD README ; do \
	    install -m0644 $(GAWK_DIR)/$$f $(DOC_DIR)/doc/gawk/$$f ; \
	done

gawk: uclibc $(TARGET_DIR)/$(GAWK_TARGET_BINARY)

gawk-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(GAWK_DIR) uninstall
	-$(MAKE) -C $(GAWK_DIR) clean
	-rm -rf $(DOC_DIR)/doc/gawk
	-rm -f $(TARGET_DIR)/usr/info/gawk*

gawk-dirclean:
	rm -rf $(GAWK_DIR)

