/*
** Copyright 2001 Double Precision, Inc.
** See COPYING for distribution information.
**
*/

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <libintl.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif


#include "superfloppy.h"
#include "mkfs.h"

static const char rcsid[]="$Id: mkfs.c,v 1.1 2001/02/13 00:15:38 mrsam Exp $";

static int mkfs(const char *prog, const char **argv, int dump_fd)
{
	pid_t p, p2;
	int waitstat;
	int pipefd[2];
	FILE *fdp;

	signal(SIGCHLD, SIG_DFL);

	if (pipe(pipefd) < 0)
	{
		perror("pipe");
		return (1);
	}

	p=fork();

	if (p == -1)
	{
		perror("fork");
		close(pipefd[0]);
		close(pipefd[1]);
		return (1);
	}

	if (p == 0)
	{
		close(dump_fd);
		dup(pipefd[1]);
		close(pipefd[0]);
		close(pipefd[1]);
		execv(prog, (char **)argv);
		perror(prog);
		exit(1);
	}
	close(pipefd[1]);

	fdp=fdopen(pipefd[0], "r");
	if (!fdp)
		perror("fdopen");
	else	/* First line from mke2fs and mkdosfs is their logo, dump it */
	{
		int c;

		while ((c=getc(fdp)) != '\n' && c != EOF)
			;

		/* Dump the rest to stderr */

		while ((c=getc(fdp)) != EOF)
			putc(c, stderr);
		fclose(fdp);
	}

	while ((p2=wait(&waitstat)) != p && p2 != -1)
		;

	if (p == p2 && WIFEXITED(waitstat))
		return (WEXITSTATUS(waitstat));
	return (1);
}

int mkfs_fat(const char *dev, int flags)
{
	const char *argv[4];

	argv[0]="mkdosfs";
	argv[1]="-I";
	argv[2]=dev;
	argv[3]=NULL;

	return (mkfs(mkdosfs, argv, 1));
}

int mkfs_ext2(const char *dev, int flags)
{
	const char *argv[5];

	argv[0]="mkde2fs";
	argv[1]="-F";
	argv[2]="-q";
	argv[3]=dev;
	argv[4]=NULL;

	return (mkfs(mke2fs, argv, 2));
}
