;; an example of a program which handles exceptions with Guile's
;; catch/throw mechanisms.

;; run this by loading the file with (load "catch-sample").  It will run
;; the program (by running (catch ...).  You just type strings at the
;; program, and see them echoed back.  If you type the word "err" (without
;; quotes), it will (throw ...) an exception, and thus invoke the
;; handler.  If you type "quit", it will exit normally.

(require 'debug)
(require 'scanf)
(require 'line-i/o)

(newline) (newline)

;; an example procedure; it's not particularly exciting: the user types
;; words, and those are echoed back.
;; The exciting thing here is that the procedure does a (throw ...)
;; when the user types the word "err", and thus involves the handler
;; set up by (catch ...).
(define (some-long-running-procedure)
  (begin
    (do ((str "")
	 (i 0 (+ i 1)))
	((equal? str "quit") "done")
      (if (equal? str "err")
	  (throw 'hi))
      (display "prompt> ")
      (set! str (car (scanf "%s")))
      (display "one word was \"") (display str) (display "\"")
      (newline))
    (display "\n\n----------------------------\n")
    (display "we are done with the do loop\n")
    (display "----------------------------\n\n")))

;; use (catch ...) to run our procedure (some-long-running-procedure),
;; so that when it throws an exception, we catch that exception with
;; our handler (the (lambda (key) ...) expression is the handler).
(catch 'hi
       some-long-running-procedure
       (lambda (key)
	 (begin
	   (newline) (newline)
	   (display "-----------------------------------------------\n")
	   (display "This is the HANDLER associated with (catch ...)\n")
	   (display "the key is ") (display key) (newline)
	   (display "-----------------------------------------------\n")
	   (newline) (newline))))
