;;;; 	Copyright (C) 1995 Cygnus Support, Inc.
;;;; 
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;; 

(require 'pretty-print)

(define (get-map-from-files files return)
  (let loop ((files files)
	     (package-name #f)
	     (modules '())
	     (public-interfaces '())
	     (package-interfaces '()))
    (if (null? files)
	(return package-name modules public-interfaces package-interfaces)
	(let ((first-stmt (with-input-from-file (car files) read)))
	  (if (not (and (list? first-stmt) (eq? 'package (car first-stmt))))
	      (throw 'first-statement-not-package (car files))
	      (parse-package-args
	       (cdr first-stmt)
	       (lambda (package module exports public-exports package-exports libraries uses)
		 (if (and package-name package (not (eq? package-name package)))
		     (throw 'wrong-package (car files)))
		 (loop (cdr files)
		       package
		       (acons module (car files) modules)
		       (append! `((,module . ,(car files))
				  . ,(map (lambda (desc) (cons (car desc) (car files))) public-exports))
				public-interfaces)
		       (append! `((,module . ,(car files))
				  . ,(map (lambda (desc) (cons (car desc) (car files))) package-exports))
				package-interfaces)))))))))


(define (write-map-from-files f)
  (get-map-from-files f
		      (lambda (package modules public-interfaces package-interfaces)
			(pretty-print `(in-package ,package))
			(pretty-print `(in-module ,(symbol-append '%%autoload- package)))
			(pretty-print `(use-library guile))
			(pretty-print `(use-interface guile))

			(newline)
			(pretty-print `(define source-path (substring *load-pathname*
								      0
								      (or (string-rindex *load-pathname* #\/)
									  (string-length *load-pathname*)))))
			(pretty-print `(define the-lib
					 (resolve-interface ',package %root-package)))
			(pretty-print `(module-binder-set! the-lib
							   (auto-loader source-path ',public-interfaces)))
			(pretty-print `(module-binder-set! (current-package)
							   (auto-loader source-path ',package-interfaces)))
			(pretty-print `(module-binder-set! (package-modules (current-package))
							   (auto-loader source-path ',modules))))))



(define file-list '())

(define (display-usage-message display-usage)
  (display (car (program-arguments)))
  (display " [OPTIONS] files...\n")
  (display-usage))


(cond
 ((cdr (program-arguments))
  => (usage-lambda
      ((	(:h :help)
		"Display usage help.")

       (display-usage-message %display-usage)
       (quit 0))

      ((normal-arg)

       (set! file-list (cons %arg file-list))
       (%next-arg %new-argv))

      ((usage-error)

       (display-usage-message %display-usage)
       (quit 1))

      ((#f)

       #t)

      (else

       (display-usage-message %display-usage)
       (quit 0))))

 (else #f))

(set! file-list (reverse file-list))
(write-map-from-files file-list)
