% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-defaults.R
\name{update_geom_defaults}
\alias{update_geom_defaults}
\alias{update_stat_defaults}
\title{Modify geom/stat aesthetic defaults for future plots}
\usage{
update_geom_defaults(geom, new)

update_stat_defaults(stat, new)
}
\arguments{
\item{new}{Named list of aesthetics.}

\item{stat, geom}{Name of geom/stat to modify (like \code{"point"} or
\code{"bin"}), or a Geom/Stat object (like \code{GeomPoint} or
\code{StatBin}).}
}
\description{
Modify geom/stat aesthetic defaults for future plots
}
\examples{

# updating a geom's default aesthetic settings
# example: change geom_point()'s default color
GeomPoint$default_aes
update_geom_defaults("point", aes(color = "red"))
GeomPoint$default_aes
ggplot(mtcars, aes(mpg, wt)) + geom_point()

# reset default
update_geom_defaults("point", aes(color = "black"))


# updating a stat's default aesthetic settings
# example: change stat_bin()'s default y-axis to the density scale
StatBin$default_aes
update_stat_defaults("bin", aes(y = after_stat(density)))
StatBin$default_aes
ggplot(data.frame(x = rnorm(1e3)), aes(x)) +
  geom_histogram() +
  geom_function(fun = dnorm, color = "red")

# reset default
update_stat_defaults("bin", aes(y = after_stat(count)))

}
\keyword{internal}
