# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ParticipantConversationList(ListResource):

    def __init__(self, version):
        """
        Initialize the ParticipantConversationList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationList
        :rtype: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationList
        """
        super(ParticipantConversationList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/ParticipantConversations'.format(**self._solution)

    def stream(self, identity=values.unset, address=values.unset, limit=None,
               page_size=None):
        """
        Streams ParticipantConversationInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode identity: A unique string identifier for the conversation participant as Conversation User.
        :param unicode address: A unique string identifier for the conversation participant who's not a Conversation User.
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.conversations.v1.participant_conversation.ParticipantConversationInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(identity=identity, address=address, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, identity=values.unset, address=values.unset, limit=None,
             page_size=None):
        """
        Lists ParticipantConversationInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode identity: A unique string identifier for the conversation participant as Conversation User.
        :param unicode address: A unique string identifier for the conversation participant who's not a Conversation User.
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.conversations.v1.participant_conversation.ParticipantConversationInstance]
        """
        return list(self.stream(identity=identity, address=address, limit=limit, page_size=page_size, ))

    def page(self, identity=values.unset, address=values.unset,
             page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of ParticipantConversationInstance records from the API.
        Request is executed immediately

        :param unicode identity: A unique string identifier for the conversation participant as Conversation User.
        :param unicode address: A unique string identifier for the conversation participant who's not a Conversation User.
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ParticipantConversationInstance
        :rtype: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationPage
        """
        data = values.of({
            'Identity': identity,
            'Address': address,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return ParticipantConversationPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ParticipantConversationInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ParticipantConversationInstance
        :rtype: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ParticipantConversationPage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.ParticipantConversationList>'


class ParticipantConversationPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the ParticipantConversationPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationPage
        :rtype: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationPage
        """
        super(ParticipantConversationPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ParticipantConversationInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationInstance
        :rtype: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationInstance
        """
        return ParticipantConversationInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.ParticipantConversationPage>'


class ParticipantConversationInstance(InstanceResource):

    class State(object):
        INACTIVE = "inactive"
        ACTIVE = "active"
        CLOSED = "closed"

    def __init__(self, version, payload):
        """
        Initialize the ParticipantConversationInstance

        :returns: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationInstance
        :rtype: twilio.rest.conversations.v1.participant_conversation.ParticipantConversationInstance
        """
        super(ParticipantConversationInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'chat_service_sid': payload.get('chat_service_sid'),
            'participant_sid': payload.get('participant_sid'),
            'participant_user_sid': payload.get('participant_user_sid'),
            'participant_identity': payload.get('participant_identity'),
            'participant_messaging_binding': payload.get('participant_messaging_binding'),
            'conversation_sid': payload.get('conversation_sid'),
            'conversation_unique_name': payload.get('conversation_unique_name'),
            'conversation_friendly_name': payload.get('conversation_friendly_name'),
            'conversation_attributes': payload.get('conversation_attributes'),
            'conversation_date_created': deserialize.iso8601_datetime(payload.get('conversation_date_created')),
            'conversation_date_updated': deserialize.iso8601_datetime(payload.get('conversation_date_updated')),
            'conversation_created_by': payload.get('conversation_created_by'),
            'conversation_state': payload.get('conversation_state'),
            'conversation_timers': payload.get('conversation_timers'),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def account_sid(self):
        """
        :returns: The unique ID of the Account responsible for this conversation.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def chat_service_sid(self):
        """
        :returns: The unique ID of the Conversation Service this conversation belongs to.
        :rtype: unicode
        """
        return self._properties['chat_service_sid']

    @property
    def participant_sid(self):
        """
        :returns: The unique ID of the Participant.
        :rtype: unicode
        """
        return self._properties['participant_sid']

    @property
    def participant_user_sid(self):
        """
        :returns: The unique ID for the conversation participant as Conversation User.
        :rtype: unicode
        """
        return self._properties['participant_user_sid']

    @property
    def participant_identity(self):
        """
        :returns: A unique string identifier for the conversation participant as Conversation User.
        :rtype: unicode
        """
        return self._properties['participant_identity']

    @property
    def participant_messaging_binding(self):
        """
        :returns: Information about how this participant exchanges messages with the conversation.
        :rtype: dict
        """
        return self._properties['participant_messaging_binding']

    @property
    def conversation_sid(self):
        """
        :returns: The unique ID of the Conversation this Participant belongs to.
        :rtype: unicode
        """
        return self._properties['conversation_sid']

    @property
    def conversation_unique_name(self):
        """
        :returns: An application-defined string that uniquely identifies the Conversation resource
        :rtype: unicode
        """
        return self._properties['conversation_unique_name']

    @property
    def conversation_friendly_name(self):
        """
        :returns: The human-readable name of this conversation.
        :rtype: unicode
        """
        return self._properties['conversation_friendly_name']

    @property
    def conversation_attributes(self):
        """
        :returns: An optional string metadata field you can use to store any data you wish.
        :rtype: unicode
        """
        return self._properties['conversation_attributes']

    @property
    def conversation_date_created(self):
        """
        :returns: The date that this conversation was created.
        :rtype: datetime
        """
        return self._properties['conversation_date_created']

    @property
    def conversation_date_updated(self):
        """
        :returns: The date that this conversation was last updated.
        :rtype: datetime
        """
        return self._properties['conversation_date_updated']

    @property
    def conversation_created_by(self):
        """
        :returns: Creator of this conversation.
        :rtype: unicode
        """
        return self._properties['conversation_created_by']

    @property
    def conversation_state(self):
        """
        :returns: The current state of this User Conversation
        :rtype: ParticipantConversationInstance.State
        """
        return self._properties['conversation_state']

    @property
    def conversation_timers(self):
        """
        :returns: Timer date values for this conversation.
        :rtype: dict
        """
        return self._properties['conversation_timers']

    @property
    def links(self):
        """
        :returns: Absolute URLs to access the participant and conversation of this Participant Conversation.
        :rtype: unicode
        """
        return self._properties['links']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.ParticipantConversationInstance>'
