--TEST--
Binary type: subtype 0x00 (Zero-length, keys reversed)
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/basic.inc';

$canonicalBson = hex2bin('0D000000057800000000000000');
$canonicalExtJson = '{"x" : { "$binary" : {"base64" : "", "subType" : "00"}}}';
$degenerateExtJson = '{"x" : { "$binary" : {"subType" : "00", "base64" : ""}}}';

// Canonical BSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromBSON($canonicalBson)), "\n";

// Canonical BSON -> BSON object -> Canonical extJSON
echo json_canonicalize(MongoDB\BSON\Document::fromBSON($canonicalBson)->toCanonicalExtendedJSON()), "\n";

// Canonical extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($canonicalExtJson)), "\n";

// Degenerate extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($degenerateExtJson)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
0d000000057800000000000000
{"x":{"$binary":{"base64":"","subType":"00"}}}
0d000000057800000000000000
0d000000057800000000000000
===DONE===