# Guidelines for contributing to this project

Any constructive contributions &ndash; bug reports, pull requests (code or documentation), suggestions for improvements, and more &ndash; are welcome.

## Procedure

Our default branch is **development** which should be used for branching/forking and creating Pull Requests. **NOTE** Create **Draft Pull Request** until you have finished - see note on Testing below.


The **stable** branch reflects the latest release and will only be updated when we create an official release. 

Please fill in the template when creating PRs and link to any issues fixed. Note for the moment these may be [GitHub issues](https://github.com/sbmlteam/libsbml/issues) or [Pivotal Tracker](https://www.pivotaltracker.com/n/projects/248655) issues

### Continuous Integration Testing

Our full CI tests involve several combinations of configuration options. This means they currently take about 7 hours to run. Marking your pull request as *draft* means that any pushes will trigger a reduced test workflow (taking about 30 minutes).

## Conduct

Everyone is asked to read and respect the [code of conduct](CODE_OF_CONDUCT.md) before participating in this project.

## Coordinating work

A quick way to find out what is currently in the near-term plans for this project is to look at the issue trackers mentioned above, but the possibilities are not limited to what you see there &ndash; if you have ideas for new features and enhancements, please feel free to write them up as a new issue or contact the developers directly!

## Submitting contributions

Please feel free to contact the author directly, or even better, jump right in and use the standard GitHub approach of forking the repo and creating a pull request.  When committing code changes and submitting pull requests, please write a clear log message for your commits.
