/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1998
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1998
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */

#include "Antlr/Parser.hpp"

#include "Antlr/BitSet.hpp"
#include "Antlr/TokenBuffer.hpp"
#include "Antlr/MismatchedTokenException.hpp"
//#include "Antlr/ASTFactory.hpp"
#include <iostream>
#include <cstdlib>

/**A generic ANTLR parser (LL(k) for k>=1) containing a bunch of
 * utility routines useful at any lookahead depth.  We distinguish between
 * the LL(1) and LL(k) parsers because of efficiency.  This may not be
 * necessary in the near future.
 *
 * Each parser object contains the state of the parse including a lookahead
 * cache (the form of which is determined by the subclass), whether or
 * not the parser is in guess mode, where tokens come from, etc...
 *
 * <p>
 * During <b>guess</b> mode, the current lookahead token(s) and token type(s)
 * cache must be saved because the token stream may not have been informed
 * to save the token (via <tt>mark</tt>) before the <tt>try</tt> block.
 * Guessing is started by:
 * <ol>
 * <li>saving the lookahead cache.
 * <li>marking the current position in the TokenBuffer.
 * <li>increasing the guessing level.
 * </ol>
 *
 * After guessing, the parser state is restored by:
 * <ol>
 * <li>restoring the lookahead cache.
 * <li>rewinding the TokenBuffer.
 * <li>decreasing the guessing level.
 * </ol>
 *
 * @see antlr.Token
 * @see antlr.TokenBuffer
 * @see antlr.TokenStream
 * @see antlr.LL1Parser
 * @see antlr.LLkParser
 */

bool DEBUG_PARSER=false;

Parser::Parser(TokenBuffer& input)
: inputState(new ParserInputState(input))
{
}

Parser::Parser(TokenBuffer* input)
: inputState(new ParserInputState(input))
{
}

Parser::Parser(const ParserSharedInputState& state)
: inputState(state)
{
}

Parser::~Parser()
{
}

void Parser::setTokenNames(const char** tokenNames_)
{
	while (*tokenNames_) {
		tokenNames.push_back(*(tokenNames_++));
	}
}

/** Consume tokens until one matches the given token */
void Parser::consumeUntil(int tokenType)
{
	while (LA(1) != Token::EOF_TYPE && LA(1) != tokenType)
		consume();
}

/** Consume tokens until one matches the given token set */
void Parser::consumeUntil(const BitSet& set)
{
	while (LA(1) != Token::EOF_TYPE && !set.member(LA(1)))
		consume();
}

/** Get the AST return value squirreled away in the parser */
RefAST Parser::getAST()
{
	return returnAST;
}

ASTFactory& Parser::getASTFactory()
{
	return astFactory;
}

std::string Parser::getFilename() const
{
	return inputState->filename;
}

ParserSharedInputState Parser::getInputState() const
{
	return inputState;
}

std::string Parser::getTokenName(int num) const
{
	return tokenNames[num];
}

std::vector<std::string> Parser::getTokenNames() const
{
	return tokenNames;
}

// Forwarded to TokenBuffer
int Parser::mark()
{
	return inputState->getInput().mark();
}

/**Make sure current lookahead symbol matches token type <tt>t</tt>.
 * Throw an exception upon mismatch, which is catch by either the
 * error handler or by the syntactic predicate.
 */
void Parser::match(int t)
{
	if ( DEBUG_PARSER )
		std::cout << "enter match(" << t << ") with LA(1)=" << LA(1) << std::endl;
	if ( LA(1)!=t ) {
		if ( DEBUG_PARSER )
			std::cout << "token mismatch: " << LA(1) << "!=" << t << std::endl;
		throw MismatchedTokenException(tokenNames, LT(1), t, false);
	} else {
		// mark token as consumed -- fetch next token deferred until LA/LT
		consume();
	}
}

/**Make sure current lookahead symbol matches the given set
 * Throw an exception upon mismatch, which is catch by either the
 * error handler or by the syntactic predicate.
 */
void Parser::match(const BitSet& b)
{
	if ( DEBUG_PARSER )
		std::cout << "enter match(" << "bitset" /*b.toString()*/
			  << ") with LA(1)=" << LA(1) << std::endl;
	if ( !b.member(LA(1)) ) {
		if ( DEBUG_PARSER )
			std::cout << "token mismatch: " << LA(1) << " not member of "
				  << "bitset" /*b.toString()*/ << std::endl;
		throw MismatchedTokenException(tokenNames, LT(1), b, false);
	} else {
		// mark token as consumed -- fetch next token deferred until LA/LT
		consume();
	}
}

void Parser::matchNot(int t)
{
	if ( LA(1)==t ) {
		// Throws inverted-sense exception
		throw MismatchedTokenException(tokenNames, LT(1), t, true);
	} else {
		// mark token as consumed -- fetch next token deferred until LA/LT
		consume();
	}
}

void Parser::panic()
{
	std::cerr << "Parser: panic" << std::endl;
	exit(1);
}

/** Parser error-reporting function can be overridden in subclass */
void Parser::reportError(const ParserException& ex)
{
	if ( getFilename()=="" )
		std::cout << "Error: " << ex.toString() << std::endl;
	else
		std::cout << "Error in " << getFilename() << ": " << ex.toString() << std::endl;
}

/** Parser error-reporting function can be overridden in subclass */
void Parser::reportError(const std::string& s)
{
	if ( getFilename()=="" )
		std::cout << "Error: " << s << std::endl;
	else
		std::cout << "Error in " << getFilename() << ": " << s << std::endl;
}

/** Parser warning-reporting function can be overridden in subclass */
void Parser::reportWarning(const std::string& s)
{
	if ( getFilename()=="" )
		std::cout << "Warning: " << s << std::endl;
	else
		std::cout << "Warning in " << getFilename() << ": " << s << std::endl;
}

void Parser::rewind(int pos)
{
	inputState->getInput().rewind(pos);
}

/** Set the object used to generate ASTs */
//	void setASTFactory(ASTFactory astFactory_);

/** Specify the type of node to create during tree building */
void Parser::setASTNodeFactory(ASTFactory::factory_type factory)
{
	astFactory.setASTNodeFactory(factory);
}

void Parser::setFilename(const std::string& f)
{
	inputState->filename = f;
}

/** Set or change the input token buffer */
//	void setTokenBuffer(TokenBuffer<Token>* t);

void Parser::traceIn(const std::string& rname)
{
	std::cout << "enter " << rname << "; LA(1)==" << LT(1)->getText() <<
			((inputState->guessing>0)?" [guessing]":"") << std::endl;
}

void Parser::traceOut(const std::string& rname)
{
	std::cout << "exit " << rname << "; LA(1)==" << LT(1)->getText() <<
			((inputState->guessing>0)?" [guessing]":"") << std::endl;
}

