if(NOT CMAKE_CROSSCOMPILING)
  find_package(PkgConfig QUIET)
  pkg_check_modules(PC_WEBSOCKETS libwebsockets)
endif()

set_extra_dirs_lib(WEBSOCKETS websockets)
find_library(WEBSOCKETS_LIBRARY
  NAMES websockets websockets.17
  HINTS ${HINTS_WEBSOCKETS_LIBDIR} ${PC_WEBSOCKETS_LIBDIR} ${PC_WEBSOCKETS_LIBRARY_DIRS}
  PATHS ${PATHS_WEBSOCKETS_LIBDIR}
  ${CROSSCOMPILING_NO_CMAKE_SYSTEM_PATH}
)
set_extra_dirs_include(WEBSOCKETS websockets "${WEBSOCKETS_LIBRARY}")
find_path(WEBSOCKETS_INCLUDEDIR
  NAMES libwebsockets.h
  HINTS ${HINTS_WEBSOCKETS_INCLUDEDIR} ${PC_WEBSOCKETS_INCLUDEDIR} ${PC_WEBSOCKETS_INCLUDE_DIRS}
  PATHS ${PATHS_WEBSOCKETS_INCLUDEDIR}
  ${CROSSCOMPILING_NO_CMAKE_SYSTEM_PATH}
)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(Websockets DEFAULT_MSG WEBSOCKETS_LIBRARY WEBSOCKETS_INCLUDEDIR)

mark_as_advanced(WEBSOCKETS_LIBRARY WEBSOCKETS_INCLUDEDIR)

if(WEBSOCKETS_FOUND)
  set(WEBSOCKETS_LIBRARIES ${WEBSOCKETS_LIBRARY})
  set(WEBSOCKETS_INCLUDE_DIRS ${WEBSOCKETS_INCLUDEDIR})

  is_bundled(WEBSOCKETS_BUNDLED "${WEBSOCKETS_LIBRARY}")
  if(WEBSOCKETS_BUNDLED AND TARGET_OS STREQUAL "windows")
  set(WEBSOCKETS_COPY_FILES
    "${EXTRA_WEBSOCKETS_LIBDIR}/libwebsockets.dll"
  )
  else()
    set(WEBSOCKETS_COPY_FILES)
  endif()
endif()
