!-------------------------------------------------
!  SLpack module
!-------------------------------------------------
module slpack
  use dcl_common
  interface DclSetFrameSize
    subroutine slsize(size)  !1ե졼κ
      character(len=3), intent(in) :: size  !ե졼礭ȸ
    end subroutine

    subroutine slform(width,height)  !1ե졼κ
      real,      intent(in) :: width       !ե졼β,ĤμĹ, ñcm
      real,      intent(in) :: height
    end subroutine
  end interface

  contains
!-----------------------------------------------------------------------
!ץ롼

    subroutine DclDivideFrame(direction,x_num,y_num) !ե졼ʬ
      character(len=1), intent(in) :: direction  !
      integer,   intent(in) :: x_num          !X, Yʬ
      integer,   intent(in) :: y_num

      call prcopn('DclDivideFrame')
      call sldiv(direction,x_num,y_num)
      call prccls('DclDivideFrame')
    end subroutine

    subroutine DclSetFrameMargin(left, right, bottom, top)   !ޡꡥ 
      real,      intent(in) :: left, right, bottom, top

      call prcopn('DclSetFrameMargin')
      call slmgn(left, right, bottom, top)
      call prccls('DclSetFrameMargin')
    end subroutine

    subroutine DclSetAspectRatio(x,y)  !Ĳꡥ   
      real, intent(in)           :: x  !ե졼νĲͿ
      real, intent(in), optional :: y  !ե졼νĲͿ

      call prcopn('DclSetAspectRatio')
      if(present(y)) then
        yy = y
      else
        yy = 1.
      end if

      call slrat(x,yy)
      call prccls('DclSetAspectRatio')
    end subroutine

    subroutine DclSetFrameTitle(title,side,x_position,y_position,height,num)
      character(len=*),  intent(in) :: title
      character(len=1),  intent(in) :: side
      real,              intent(in) :: x_position, y_position 
      real,              intent(in) :: height
      integer, optional, intent(in) :: num         !ܤʸ󤫤ꤹ

      call prcopn('DclSetFrameTitle')
      if(present(num)) then
        nt = num
      else
        nt = 1
      end if
      call slsttl(title,side,x_position,y_position,height,nt) 
      call prccls('DclSetFrameTitle')
    end subroutine
!--------------------------------------------------------------------
!趭
    subroutine DclDrawViewPortFrame(index)  !ӥ塼ݡȤȤ
      integer,   intent(in) :: index  !ʬΥ饤󥤥ǥ 

      call sgoopn('DclDrawViewPortFrame', ' ')
      call slpvpr(index)
      call sgocls('DclDrawViewPortFrame')
    end subroutine

    subroutine DclDrawDeviceWindowFrame(index)  !ɥȤ
      integer,   intent(in) :: index  !ʬΥ饤󥤥ǥ 

      call sgoopn('DclDrawDeviceWindowFrame', ' ')
      call slpwwr(index)
      call sgocls('DclDrawDeviceWindowFrame')
    end subroutine

    subroutine DclDrawDeviceViewPortFrame(index)  !ΰȤ
      integer,   intent(in) :: index    !ʬΥ饤󥤥ǥ 

      call sgoopn('DclDrawDeviceViewPortFrame', ' ')
      call slpwvr(index) 
      call sgocls('DclDrawDeviceViewPortFrame')
    end subroutine

    subroutine DclDrawViewPortCorner(index,size)  !ӥ塼ݡȤΥʡޡ
      integer,   intent(in) :: index    !ʬΥ饤󥤥ǥ 
      real,      intent(in) :: size    !ʡޡĹ

      call sgoopn('DclDrawViewPortCorner', ' ')
      call slpvpc(index,size)
      call sgocls('DclDrawViewPortCorner')
    end subroutine                             

    subroutine DclDrawDeviceWindowCorner(index,size)  !ɥΥʡޡ
      integer,   intent(in) :: index    !ʬΥ饤󥤥ǥ 
      real,      intent(in) :: size     !ʡޡĹ

      call sgoopn('DclDrawDeviceWindowCorner', ' ')
      call slpwwc(index,size)
      call sgocls('DclDrawDeviceWindowCorner')
    end subroutine

    subroutine DclDrawDeviceViewPortCorner(index,size) 
      integer,   intent(in) :: index  !ʬΥ饤󥤥ǥ 
      real,      intent(in) :: size    !ʡޡĹ

      call sgoopn('DclDrawDeviceViewPortCorner', ' ')
      call slpwvc(index,size)
      call sgocls('DclDrawDeviceViewPortCorner')
    end subroutine

end module

