/*
 * myname.c - determine the current username and get the passwd entry
 *
 * Copyright (C) 1996 Marek Michalkiewicz <marekm@i17linuxb.ists.pwr.wroc.pl>
 *
 * This code may be freely used, modified and distributed for any purpose.
 * There is no warranty, if it breaks you have to keep both pieces, etc.
 * If you improve it, please send me your changes.  Thanks!
 */

#include "internal.h"

#include <pwd.h>
#include <unistd.h>

extern struct passwd *get_my_pwent(void)
{
  /* EDR this used to rely upon getlogin(), but that provides a security
     hole. */
	unsigned short ruid = getuid();

	return getpwuid(ruid);
}
