/*
 * Utility routines.
 *
 * Copyright (C) tons of folks.  Tracking down who wrote what
 * isn't something I'm going to worry about...  If you wrote something
 * here, please feel free to acknowledge your work.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include "internal.h"
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <crypt.h>


/* volatile so gcc knows this is the end of the line */
extern void usage(const char *usage)
{
    fprintf(stderr, "TinyLogin v%s (%s) multi-call binary -- GPL2\n\n", TLG_VER, TLG_BT);
    fprintf(stderr, "Usage: %s\n", usage);
    exit(FALSE);
}

#if defined TLG_LOGIN || defined TLG_SULOGIN || defined TLG_PASSWD
extern char*
pw_encrypt(const char *clear, const char *salt)
{
    static char cipher[128];
    char *cp;

    if (strncmp(salt, "$1$", 3) == 0) {
//    return md5_crypt(clear, salt);
    }
    cp = (char *) crypt(clear, salt);
    if (strlen(cp) != 13) {
	return cp;		/* nonstandard crypt, better bail */
    }
    strcpy(cipher, cp);
    return cipher;
}
#endif

/* END CODE */









