# $Id: proftpd.spec.in,v 1.4 2000/01/18 03:14:49 macgyver Exp $
#
Summary:	ProFTPd -- Professional FTP Server.
Name:      proftpd
Version:   1.2.0
Release:   1
Copyright: GPL
Group:     System Environment/Daemons
Packager:  MacGyver (aka Habeeb J. Dihu) <macgyver@tos.net>
Vendor:		The ProFTPd Group
URL:		http://www.proftpd.net/
Source:		ftp://ftp.proftpd.net/pub/proftpd/%{name}-%{version}.tar.gz
Prefix:		/usr
BuildRoot:	%{_builddir}/%{name}-%{version}-root

%description
ProFTPd is an enhanced FTP server with a focus toward simplicity, security,
and ease of configuration.  It features a very Apache-like configuration
syntax, and a highly customizable server infrastructure, including support for
multiple 'virtual' FTP servers, anonymous FTP, and permission-based directory
visibility.

%changelog
* Thu Oct 3 1999 O.Elliyasa <osman@Cable.EU.org>
- Multi package creation.
  Created core, standalone, inetd (&doc) package creations.
  Added startup script for init.d
  Need to make the "standalone & inetd" packages being created as "noarch"
- Added URL.
- Added prefix to make the package relocatable.

* Wed Sep 8 1999 O.Elliyasa <osman@Cable.EU.org>
- Corrected inetd.conf line addition/change logic.

* Sat Jul 24 1999 MacGyver <macgyver@tos.net>
- Initial import of spec.

%package core
Summary:	ProFTPd -- Professional FTP Server binaries.
Group:		System Environment/Daemons
Requires:  pam >= 0.59
Provides:  ftpserver
Prereq:    fileutils

%description core
ProFTPd is an enhanced FTP server with a focus toward simplicity, security,
and ease of configuration.  It features a very Apache-like configuration
syntax, and a highly customizable server infrastructure, including support for
multiple 'virtual' FTP servers, anonymous FTP, and permission-based directory
visibility.
There are two other packages you can use to setup for inetd or standalone operation.

%package standalone
Summary:	ProFTPd -- Setup for standalone operation.
Group:		System Environment/Daemons
Requires:	proftpd-core chkconfig
Obsoletes:	proftpd-inetd

%description standalone
This package is neccesary to setup ProFTPd in standalone operation.

%package inetd
Summary:	ProFTPd -- Setup for inetd operation.
Group:		System Environment/Daemons
Requires:	proftpd-core
Obsoletes:	proftpd-standalone

%description inetd
This package is neccesary to setup ProFTPd to run from inetd.

%prep
%setup -q
  ./configure --prefix=%{prefix} --sysconfdir=/etc --localstatedir=/var/run --with-modules=mod_linuxprivs:mod_ratio:mod_readme

%build
  make CFLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
  make prefix=$RPM_BUILD_ROOT%{prefix} localstatedir=$RPM_BUILD_ROOT/var/run rundir=$RPM_BUILD_ROOT/var/run/proftpd sysconfdir=$RPM_BUILD_ROOT/etc install
mkdir -p $RPM_BUILD_ROOT/home/ftp
  mkdir -p $RPM_BUILD_ROOT/etc/pam.d
install -m 644 contrib/dist/rpm/ftp.pamd $RPM_BUILD_ROOT/etc/pam.d/ftp
  install -m 644 sample-configurations/basic.conf $RPM_BUILD_ROOT/etc/proftpd.conf
touch $RPM_BUILD_ROOT/etc/ftpusers
  mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
  sed	-e '/FTPSHUT=/c\' \
	-e 'FTPSHUT=%{prefix}/sbin/ftpshut' \
	contrib/dist/rpm/proftpd.init.d \
  > contrib/dist/rpm/proftpd.init.d.tmp
  mv --force contrib/dist/rpm/proftpd.init.d.tmp contrib/dist/rpm/proftpd.init.d
  install contrib/dist/rpm/proftpd.init.d $RPM_BUILD_ROOT/etc/rc.d/init.d/proftpd

%prein core
  if [ ! -f /etc/ftpusers ]; then
  	touch /etc/ftpusers
  	IFS=":"; cat /etc/passwd | \
  	while { read username nu nu gid }; do \
		if [ $gid -le 100 -a "$username" != "ftp" ]; then
			echo $username >> /etc/ftpusers
		fi
  	done
  fi

%preun core
  if [ -d /var/run/proftpd ]; then
	rm -rf /var/run/proftpd/*
  fi

%post standalone
  /sbin/chkconfig --add proftpd
  # Force the "ServerType" directive for this operation type.
  tmpfile=/tmp/proftpd-conf.$$
  sed	-e '/ServerType/c\' \
	-e 'ServerType	standalone' \
	/etc/proftpd.conf \
  > $tmpfile
  mv $tmpfile /etc/proftpd.conf

%preun standalone
  /sbin/chkconfig --del proftpd

%post inetd
  # Force the "ServerType" directive for this operation type.
  tmpfile=/tmp/proftpd-conf.$$
  sed	-e '/ServerType/c\' \
	-e 'ServerType	inetd' \
	/etc/proftpd.conf \
  > $tmpfile
  mv $tmpfile /etc/proftpd.conf

# Look if there is already an entry for 'ftp' service even when commented.
grep '^[#[:space:]]*ftp' /etc/inetd.conf > /dev/null
errcode=$?
if [ $errcode -eq 0 ]; then
# Found, replace the 'in.ftpd' with 'in.proftpd'
	tmpfile=/tmp/proftpd-inetd.$$
	sed	-e '/^[#[:space:]]*ftp/{' \
		-e 's^in.ftpd.*$^in.proftpd^' \
		-e '}' \
		/etc/inetd.conf \
	> $tmpfile
	mv $tmpfile /etc/inetd.conf
else
# Not found, append a new entry.
	echo 'ftp      stream  tcp     nowait  root    /usr/sbin/tcpd  in.proftpd' >> /etc/inetd.conf
fi
# Reread 'inetd.conf' file.
killall -HUP inetd || :

%postun inetd
    # Remove ProFTPD entry from /etc/inetd.conf
    tmpfile=/tmp/proftpd-inetd.$$
    sed -e '/^.*proftpd.*$/d' /etc/inetd.conf > $tmpfile
    mv $tmpfile /etc/inetd.conf
    killall -HUP inetd || :

%clean
rm -rf $RPM_BUILD_ROOT

%files core
/usr/sbin/*
/usr/bin/*
%dir /var/run/proftpd
%dir /home/ftp
%config(noreplace) /etc/ftpusers
%config(noreplace) /etc/pam.d/ftp

%doc README README.* doc/*
%doc contrib/README contrib/README.* contrib/xferstats.holger-preiss
%doc sample-configurations/*
/usr/man/*/*

%files standalone
/etc/rc.d/init.d/proftpd
%config(noreplace) /etc/proftpd.conf

%files inetd
%config(noreplace) /etc/proftpd.conf
