Summary: Process monitoring utilities
Name: procps
%define version 1.2.9
Version: %{version}
Release: 1
Copyright: GPL
Group: Utilities/System
Source: ftp://tsx-11.mit.edu/pub/linux/sources/usr.bin/procps-%{version}.tar.gz
BuildRoot: /var/tmp/procps-root

%package X11
Group: X11/Utilities
Summary: X-based process monitoring utilities

%description
A package of utilities which report on the state of the system,
including the states of running processes, amount of memory available,
and currently-logged-in users.

%description X11
A package of X-based utilities which report on the state of the system.
These utilities generally provide graphical presentations of information
available from tools in the procps suite.

%prep
%setup

%build
PATH=/usr/X11R6/bin:$PATH

make CC="gcc $RPM_OPT_FLAGS" LDFLAGS=-s

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/bin $RPM_BUILD_ROOT/usr/bin $RPM_BUILD_ROOT/usr/sbin
mkdir -p $RPM_BUILD_ROOT/usr/man/man1 $RPM_BUILD_ROOT/usr/man/man8
mkdir -p $RPM_BUILD_ROOT/lib

make DESTDIR=$RPM_BUILD_ROOT install

# Since this is specific to Red Hat now, we'll leave this in the spec file.
# If others decide they like wmconfig, we'll move it to the install phase
# of the Makefile.
mkdir -p $RPM_BUILD_ROOT/etc/X11/wmconfig
install -m 644 top.wmconfig $RPM_BUILD_ROOT/etc/X11/wmconfig/top

%clean
rm -rf $RPM_BUILD_ROOT

%post
# add libproc to the cache
/sbin/ldconfig
# ask ps to set up /etc/psdevtab if /proc is mounted
if [ -f /proc/uptime ] ; then
  /bin/ps </dev/null >/dev/null 2>&1
fi

%files
%attr(0644,root,root) %config(missingok) /etc/X11/wmconfig/top
%attr(0644,root,root) %doc NEWS BUGS TODO
%attr(755,root,root) /lib/libproc.so.1.2.6
%attr(555,root,root) /bin/ps
%attr(555,root,root) /usr/bin/uptime
%attr(555,root,root) /usr/bin/tload
%attr(555,root,root) /usr/bin/free
%attr(555,root,root) /usr/bin/w
%attr(555,root,root) /usr/bin/top
%attr(555,root,root) /usr/bin/vmstat
%attr(555,root,root) /usr/bin/sessreg
%attr(555,root,root) /usr/bin/watch

%attr(755,root,root) /usr/bin/skill
%attr(755,root,root) /usr/bin/snice

%attr(0644,root,root) /usr/man/man1/free.1
%attr(0644,root,root) /usr/man/man1/ps.1
%attr(0644,root,root) /usr/man/man1/sessreg.1
%attr(0644,root,root) /usr/man/man1/skill.1
%attr(0644,root,root) /usr/man/man1/snice.1
%attr(0644,root,root) /usr/man/man1/tload.1
%attr(0644,root,root) /usr/man/man1/top.1
%attr(0644,root,root) /usr/man/man1/uptime.1
%attr(0644,root,root) /usr/man/man1/w.1
%attr(0644,root,root) /usr/man/man1/watch.1
%attr(0644,root,root) /usr/man/man8/vmstat.8

%files X11
%attr(4755,root,root) /usr/X11R6/bin/XConsole
