###############################################################################
# Auto configuration bypass  (Say NO to use this file)
###############################################################################
DIRECT_SETTINGS_ONLY=NO

###############################################################################
# Default Settings
###############################################################################

VERBOSE=YES
MAX_LOOP=15
DHCP_SLEEP=15

IPFWDING_KERNEL=YES
IPFWDING_FW=YES

IPMASQ_DLOOSE=YES

CONFIG_HOSTNAME=YES

CONFIG_HOSTSFILE=YES

CONFIG_DNS=NO

###############################################################################
# Interfaces
###############################################################################

IF0_IFNAME=eth0
IF0_IPADDR=dhcp
IF0_NETMASK=255.255.255.255
IF0_BROADCAST=255.255.255.255
IF0_IP_SPOOF=YES

IF1_IFNAME=eth1
IF1_IPADDR=192.168.0.20
IF1_NETMASK=255.255.255.0
IF1_BROADCAST=192.168.0.255
IF1_IP_SPOOF=YES

IF2_IFNAME=eth1:0
IF2_IPADDR=192.168.0.1
IF2_NETMASK=$IF1_NETMASK
IF2_BROADCAST=$IF1_BROADCAST
IF2_IP_SPOOF=NO

###############################################################################
# Hosts
###############################################################################

#HOST0_IPADDR=192.168.7.123
HOST0_GATEWAY_IF=default
HOST0_GATEWAY_IP=192.168.1.200
HOST0_IPMASQ=NO
HOST0_IPMASQ_IF=default

###############################################################################
# Networks
###############################################################################

NET0_NETADDR=192.168.0.0
NET0_NETMASK=$IF1_NETMASK
NET0_GATEWAY_IF=$IF1_IFNAME
NET0_GATEWAY_IP=default
NET0_IPMASQ=YES
NET0_IPMASQ_IF=$IF0_IFNAME

###############################################################################
# Gateways (Default Routes)
###############################################################################

#GW0_IPADDR=$HOST0_IPADDR
GW0_IFNAME=$IF0_NAME
GW0_METRIC=1

###############################################################################
# Port Fowarding
###############################################################################
PF0_IFNAME=$IF0_IFNAME
PF0_DESTIP=192.168.0.10
PF0_TPORTS=53:5353,80:80,25:25,110:110,21:21,20:20,22:22
PF0_UPORTS=53:5353


###############################################################################
# Hostname					Requires: CONFIG_HOSTNAME=YES
###############################################################################
HOSTNAME=tourettes

###############################################################################
# Hosts file (Static domainname entires)	Requires: CONFIG_HOSTSFILE=YES
###############################################################################
#	IP		FQDN				hostname alias1 alias2..
HOSTS0="$IF1_IPADDR	$HOSTNAME.psychosis.com		$HOSTNAME t"

###############################################################################
# Domain Search Order and Name Servers		Requires: CONFIG_DNS=YES
###############################################################################

DOMAINS="psychosis.com linkscape.net"

DNS0=192.168.0.8
DNS1=192.168.0.9


###############################################################################
# Brief instructions for this file
###############################################################################
#
# DIRECT_SETTINGS_ONLY=(YES/NO)		Default: YES 
# Bypass automatic configuration using this file's settings, 
# and only execute the commands in /etc/network_direct.conf
#
# VERBOSE=(YES/NO)			Default: Yes
# Be verbose about settings.
#
# MAX_LOOP=(int)			Default: 10
# Maximum number of incrementable entries to search for.
# IE: If you create a DNS7=, and MAX_LOOP=7, it will not be reached.
# (DNS0 - DNS7 == 8 entires)
# Setting this value too high will decrease the speed of the configuation
# system.
#
# IPFWDING_KERNEL=(YES/NO)		Default: NO
# Enable IP forwarding in the kernel.
#
# IPFWDING_FW=(YES/NO)			Default: NO
# Set firewall forwarding policy to 'allow'.
#
# CONFIG_HOSTNAME=(YES/NO)		Default: NO
# Create /etc/hostname file using HOSTNAME entry.
# Any current hostname file will be **OVERWRITTEN**
#
# CONFIG_HOSTSFILE=(YES/NO)		Default: NO
# Create /etc/hosts file using HOSTSx entries.
# Any current hosts file will be **OVERWRITTEN**
#
# CONFIG_DNS=(YES/NO)		Default: NO
# Create /etc/resolv.conf file using DOMAINS and DNSx entries.
# Any current resolv.conf file will be **OVERWRITTEN**
#
###############################################################################
# End
###############################################################################
