/*
 * public domain -- Dave 'Kill a Cop' Cinege <dcinege@psychosis.com>
 * 
 * makedevs
 * Make ranges of device files quickly. 
 * known bugs: can't deal with alpha ranges
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#define VERSION "0.01"

//function prototypes
void usage (void);
int makedevs (const char *basedev, const char* type, int major, int Sminor, int S, int E, int sbase);


int main(int argc, char *argv[])
{

	if ( argc < 7 ) {
		usage();
		exit(1);
	}
	
	return ( makedevs (argv[1], argv[2] , atoi(argv[3]), atoi(argv[4]),
		  atoi(argv[5]), atoi(argv[6]), argc >= 8 ? 1 : 0) );
}


int makedevs (const char *basedev, const char* type, int major, int Sminor, int S, int E, int sbase)
{

mode_t mode = 0;
dev_t dev = 0;
char devname[255];
char buf[255];

	switch (type[0]) {
		case 'c':
			mode = S_IFCHR; break;
		case 'b':
			mode = S_IFBLK; break;
		case 'f':
			mode = S_IFIFO; break;
		default:
			usage();
			return 2;
	}       
	mode |= 0660; 

	while ( S <= E ) {
			
		if (type[0] != 'f')
			dev = (major << 8) | Sminor;
		strcpy(devname, basedev);
		
		if (sbase == 0) {
			sprintf(buf, "%d", S); 
			strcat(devname, buf);
		} else {
			sbase = 0;
		}
				
		if (mknod (devname, mode, dev))
			printf("Failed to create: %s\n", devname);		
	
		S++; Sminor++;
	}

return 0;
}

void usage ()
{
	printf(	"makedevs v%s -- Create an entire range of device files\n\n"
		"makedevs /dev/ttyS c 4 64 0 63        (ttyS0-ttyS63)\n"
		"makedevs /dev/hda b 3 0 0 8 s         (hda,hda1-hda8)\n", VERSION);
}


/*
And this is what this program replaces. The shell is too slow!

makedev () {
local basedev=$1; local S=$2; local E=$3
local major=$4; local Sminor=$5; local type=$6
local sbase=$7

	if [ ! "$sbase" = "" ]; then
		mknod "$basedev" $type $major $Sminor
		S=`expr $S + 1`
		Sminor=`expr $Sminor + 1`
	fi

	while [ $S -le $E ]; do
		mknod "$basedev$S" $type $major $Sminor
		S=`expr $S + 1`
		Sminor=`expr $Sminor + 1`
	done
}
*/
