/* misc. universal things
 * Copyright (C) 1997 Angelos D. Keromytis.
 * Copyright (C) 1998, 1999  D. Hugh Redelmeier.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: defs.h,v 1.15 1999/04/11 00:44:17 dhr Exp $
 */

/* GCC magic! */
#ifdef GCC_LINT
# define PRINTF_LIKE(n) __attribute__ ((format(printf, n, n+1)))
# define NEVER_RETURNS __attribute__ ((noreturn))
# define BLANK_FORMAT " "	/* GCC_LINT whines about empty formats */
#else
# define PRINTF_LIKE(n)	/* ignore */
# define NEVER_RETURNS /* ignore */
# define BLANK_FORMAT ""
#endif

/* our version of assert: log result */
#define passert(pred) { if (!(pred)) passert_fail(#pred, __FILE__, __LINE__); }
extern void passert_fail(const char *pred_str
    , const char *file_str, unsigned long line_no) NEVER_RETURNS;

/* type of serial number of a state object
 * Needed in connections.h and state.h; here to simplify dependencies.
 */
typedef unsigned long so_serial_t;
#define SOS_NOBODY  0	/* null serial number */


/* memory allocation */

extern void *alloc_bytes(size_t size, const char *name);
#define alloc_thing(thing, name) (alloc_bytes(sizeof(thing), (name)))

extern void *clone_bytes(const void *orig, size_t size, const char *name);
#define clone_thing(orig, name) clone_bytes((void *)&(orig), sizeof(orig), (name))

#ifdef LEAK_DETECTIVE
  extern void pfree(void *ptr);
  extern void report_leaks(void);
#else
# define pfree(ptr) free(ptr)	/* ordinary stdc free */
#endif
#define pfreeany(p) { if ((p) != NULL) pfree(p); }
#define replace(p, q) { pfreeany(p); (p) = (q); }

/* make a struct sockaddr_in */

#define mksin(/*struct sockaddr_in*/ sin, /*in_addr_t*/ addr, /*u_int16_t*/ port) { \
	memset(&(sin), '\0', sizeof(sin)); \
	(sin).sin_family = AF_INET; \
	(sin).sin_addr.s_addr = (addr); \
	(sin).sin_port = htons(port); \
    }

/* cleanly exit Pluto */

extern void exit_pluto(int /*status*/) NEVER_RETURNS;
