RCSID $Id: net.ipv4.protocol.c,v 1.5 1999/04/06 04:54:31 rgb Exp $
--- ./net/ipv4/protocol.c.preipsec	Tue Apr  8 11:47:47 1997
+++ ./net/ipv4/protocol.c	Mon Apr  5 05:26:30 1999
@@ -44,79 +44,125 @@
 #include <net/udp.h>
 #include <net/ipip.h>
 #include <linux/igmp.h>
+#ifdef CONFIG_IPSEC
+# include <../net/ipsec/ipsec_rcv.h>
+#ifdef CONFIG_IPSEC_AH_
+# include <../net/ipsec/ipsec_ah.h>
+#endif /* CONFIG_IPSEC_AH */
+#ifdef CONFIG_IPSEC_ESP_
+# include <../net/ipsec/ipsec_esp.h>
+#endif /* CONFIG_IPSEC_ESP */
+#endif /* CONFIG_IPSEC */
 
+#define NEXT_PROTO NULL
 
-#ifdef CONFIG_NET_IPIP
-
-static struct inet_protocol ipip_protocol = 
+static struct inet_protocol icmp_protocol = 
 {
-	ipip_rcv,             /* IPIP handler          */
-	NULL,                 /* TUNNEL error control    */
-	0,                    /* next                 */
-	IPPROTO_IPIP,         /* protocol ID          */
-	0,                    /* copy                 */
-	NULL,                 /* data                 */
-	"IPIP"                /* name                 */
+	icmp_rcv,		/* ICMP handler		*/
+	NULL,			/* ICMP error control	*/
+	NEXT_PROTO,		/* next                 */
+#undef NEXT_PROTO
+#define NEXT_PROTO &icmp_protocol
+	IPPROTO_ICMP,		/* protocol ID		*/
+	0,			/* copy			*/
+	NULL,			/* data			*/
+	"ICMP"			/* name			*/
 };
 
+#ifdef CONFIG_IP_MULTICAST
+static struct inet_protocol igmp_protocol = 
+{
+	igmp_rcv,		/* IGMP handler		*/
+	NULL,			/* IGMP error control	*/
+	NEXT_PROTO,		/* next                 */
+#undef NEXT_PROTO
+#define NEXT_PROTO &igmp_protocol
+	IPPROTO_IGMP,		/* protocol ID		*/
+	0,			/* copy			*/
+	NULL,			/* data			*/
+	"IGMP"			/* name			*/
+};
+#endif /* CONFIG_IP_MULTICAST */
 
-#endif
+#ifdef CONFIG_NET_IPIP
+static struct inet_protocol ipip_protocol = 
+{
+	ipip_rcv,		/* IPIP handler          */
+	NULL,			/* TUNNEL error control    */
+	NEXT_PROTO,		/* next                 */
+#undef NEXT_PROTO
+#define NEXT_PROTO &ipip_protocol
+	IPPROTO_IPIP,		/* protocol ID          */
+	0,			/* copy                 */
+	NULL,			/* data                 */
+	"IPIP"			/* name                 */
+};
+#endif /* CONFIG_NET_IPIP */
 
 static struct inet_protocol tcp_protocol = 
 {
 	tcp_rcv,		/* TCP handler		*/
 	tcp_err,		/* TCP error control	*/  
-#if defined(CONFIG_NET_IPIP)
-	&ipip_protocol,
-#else  
-	NULL,			/* next			*/
-#endif  
+	NEXT_PROTO,		/* next                 */
+#undef NEXT_PROTO
+#define NEXT_PROTO &tcp_protocol
 	IPPROTO_TCP,		/* protocol ID		*/
 	0,			/* copy			*/
 	NULL,			/* data			*/
 	"TCP"			/* name			*/
 };
 
-
 static struct inet_protocol udp_protocol = 
 {
 	udp_rcv,		/* UDP handler		*/
 	udp_err,		/* UDP error control	*/
-	&tcp_protocol,		/* next			*/
+	NEXT_PROTO,		/* next                 */
+#undef NEXT_PROTO
+#define NEXT_PROTO &udp_protocol
 	IPPROTO_UDP,		/* protocol ID		*/
 	0,			/* copy			*/
 	NULL,			/* data			*/
 	"UDP"			/* name			*/
 };
 
-
-static struct inet_protocol icmp_protocol = 
-{
-	icmp_rcv,		/* ICMP handler		*/
-	NULL,			/* ICMP error control	*/
-	&udp_protocol,		/* next			*/
-	IPPROTO_ICMP,		/* protocol ID		*/
-	0,			/* copy			*/
-	NULL,			/* data			*/
-	"ICMP"			/* name			*/
+#ifdef CONFIG_IPSEC
+#ifdef CONFIG_IPSEC_ESP
+struct inet_protocol esp_protocol = {
+	ipsec_rcv,		/* ESP handler          */
+#if 0
+	NULL,			/* Will be UDP fraglist handler */
+#endif
+	NULL,			/* TUNNEL error control */
+	NEXT_PROTO,		/* next                 */
+#undef NEXT_PROTO
+#define NEXT_PROTO &esp_protocol
+	IPPROTO_ESP,		/* protocol ID */
+	0,			/* copy */
+	NULL,			/* data */
+	"ESP"			/* name */
 };
+#endif /* CONFIG_IPSEC_ESP */
 
-#ifndef CONFIG_IP_MULTICAST
-struct inet_protocol *inet_protocol_base = &icmp_protocol;
-#else
-static struct inet_protocol igmp_protocol = 
-{
-	igmp_rcv,		/* IGMP handler		*/
-	NULL,			/* IGMP error control	*/
-	&icmp_protocol,		/* next			*/
-	IPPROTO_IGMP,		/* protocol ID		*/
-	0,			/* copy			*/
-	NULL,			/* data			*/
-	"IGMP"			/* name			*/
+#ifdef CONFIG_IPSEC_AH
+struct inet_protocol ah_protocol = {
+	ipsec_rcv,			/* AH handler */
+#if 0
+	NULL,			/* Will be UDP fraglist handler */
+#endif
+	NULL,			/* TUNNEL error control */
+	NEXT_PROTO,		/* next                 */
+#undef NEXT_PROTO
+#define NEXT_PROTO &ah_protocol
+	IPPROTO_AH,		/* protocol ID */
+	0,			/* copy */
+	NULL,			/* data */
+	"AH"			/* name */
 };
+#endif /* CONFIG_IPSEC_AH */
+#endif /* CONFIG_IPSEC */
+
+struct inet_protocol *inet_protocol_base = NEXT_PROTO;
 
-struct inet_protocol *inet_protocol_base = &igmp_protocol;
-#endif
 
 struct inet_protocol *inet_protos[MAX_INET_PROTOS] = 
 {
