RCSID $Id: net.ipv4.af_inet.c,v 1.3 1999/04/06 04:54:30 rgb Exp $
--- ./net/ipv4/af_inet.c.preipsec	Wed Jun  3 18:17:50 1998
+++ ./net/ipv4/af_inet.c	Mon Apr  5 05:26:30 1999
@@ -108,6 +108,9 @@
 #ifdef CONFIG_NET_RADIO
 #include <linux/wireless.h>
 #endif	/* CONFIG_NET_RADIO */
+#ifdef CONFIG_IPSEC
+#include <../net/ipsec/ipsec_tunnel.h>
+#endif CONFIG_IPSEC
 
 #define min(a,b)	((a)<(b)?(a):(b))
 
@@ -1146,6 +1149,14 @@
 	ip_alias_init();
 #endif
 
+#if defined(CONFIG_IPSEC)
+	/*
+	 *  Initialise AF_INET ESP and AH protocol support including 
+	 *  e-routing and SA tables
+	 */
+	ipsec_init();
+#endif CONFIG_IPSEC
+
 #ifdef CONFIG_INET_RARP
 	rarp_ioctl_hook = rarp_ioctl;
 #endif
@@ -1206,5 +1217,14 @@
 		0, &proc_net_inode_operations,
 		rt_cache_get_info
 	});
+#if defined(CONFIG_IPSEC)
+	proc_net_register(&ipsec_eroute);
+	proc_net_register(&ipsec_spi);
+	proc_net_register(&ipsec_spigrp);
+	proc_net_register(&ipsec_tncfg);
+	proc_net_register(&ipsec_spinew);
+	proc_net_register(&ipsec_version);
+#endif CONFIG_IPSEC
+
 #endif		/* CONFIG_PROC_FS */
 }
