#############################################################
#### DO NOT REMOVE #### DO NOT REMOVE #### DO NOT REMOVE ####
#############################################################
#
#  This header is the only compensation I receive for this
#  script.  Please do not remove it.
#
#############################################################
# Program:	curses.sh
#               Copyright 1995
#
# Description:	Bourne Shell Curses
#               This module defines the "curses" functions in
#		Korn shell script.
#
# Author:	Dana French (dfrench@juno.com)
#		Applied Intelligence Group
#		(405) 341-7700
#
# Date:		10/25/95
#
#############################################################
#### DO NOT REMOVE #### DO NOT REMOVE #### DO NOT REMOVE ####
#############################################################
# Modifications:
#		
# 5/29/97	Version: 1.12
#               Added no tput command capabilities
#		
# 12/13/95	Version: 1.11
#               Added <ESC>[%i%d;%dH translation to initscr sed script.
#		Thanks to Don Peterson (donp@donp.boi.hp.com) for 
#               helping debug this.
#		
# 11/20/95	Version: 1.11
#		Added ksh shortcuts to demo program
#		
# 10/27/95	Version: 1.10
#		added registry return information
#		
# 10/27/95	Version: 1.9
#		restructured terminal support around "tput"
#		command output.
#		
# 10/26/95	Version: 1.8
#		added reverse row/column terminal support
#		to tput definitions
#		
# 10/26/95	Version: 1.7
#		added standard error redirection to /dev/null
#		to tput definitions
#		
# 10/26/95	Version: 1.6
#		added ibm3151 and at386 terminal support
#		
# 10/25/95	Version: 1.4
#		added various "tput cup" sed script replacements
#		
# 10/25/95	added generic "tput cup" command replacing 
#		%p1%d w/ ${1} and %p2%d w/ ${2} for the move command
#		
# 10/10/95	Version: 1.0
#		Original Code
#############################################################
tputfunc()
{
	case "_${1}" in
		"_cup" ) echo "[%i%p1%d;%p2%dH";;
		"_clear") echo "[H[J24";;
		"_lines") echo "24";;
		"_cols") echo "80";;
		"_el") echo "[K";;
		"_el1") echo "[1K";;
		"_ed") echo "[J";;
		"_rev") echo "[7m";;
		"_blink") echo "[5m";;
		"_sgr0") echo "[m";;
		"_bel") echo "";;
	esac
}
#############################################################
initscr()
{
    PGMNAME="${PGMNAME:='Bourne Shell Curses demo'}"
    DEV_NULL="/dev/null"
# Determine the Terminal "tput" command
    tput cup > /dev/null 2>&1 && CMD_TPUT="tput" || CMD_TPUT="tputfunc"

    if [ "_${CMD_TPUT}" = "_tputfunc" ]
    then
        echo "Invalid TERM type or unable to locate \"tput\" command."
	echo "Defaulting to VT100 emulation..."
	sleep 3
    fi

    eval CMD_MOVE=\`echo \"`${CMD_TPUT} cup`\" \| sed \\\
-e \"s/%p1%d/\\\\\${1}/g\" \\\
-e \"s/%p2%d/\\\\\${2}/g\" \\\
-e \"s/%p1%02d/\\\\\${1}/g\" \\\
-e \"s/%p2%02d/\\\\\${2}/g\" \\\
-e \"s/%p1%03d/\\\\\${1}/g\" \\\
-e \"s/%p2%03d/\\\\\${2}/g\" \\\
-e \"s/%p1%03d/\\\\\${1}/g\" \\\
-e \"s/%d\\\;%dH/\\\\\${1}\\\;\\\\\${2}H/g\" \\\
-e \"s/%p1%c/'\\\\\\\`echo \\\\\\\${1} P | dc\\\\\\\`'/g\" \\\
-e \"s/%p2%c/'\\\\\\\`echo \\\\\\\${2} P | dc\\\\\\\`'/g\" \\\
-e \"s/%p1%\' \'%+%c/'\\\\\\\`echo \\\\\\\${1} 32 + P | dc\\\\\\\`'/g\" \\\
-e \"s/%p2%\' \'%+%c/'\\\\\\\`echo \\\\\\\${2} 32 + P | dc\\\\\\\`'/g\" \\\
-e \"s/%p1%\'@\'%+%c/'\\\\\\\`echo \\\\\\\${1} 100 + P | dc\\\\\\\`'/g\" \\\
-e \"s/%p2%\'@\'%+%c/'\\\\\\\`echo \\\\\\\${2} 100 + P | dc\\\\\\\`'/g\" \\\
-e \"s/%i//g\;s/%n//g\"\`

    CMD_CLEAR=`${CMD_TPUT} clear 2>${DEV_NULL}`	  # Clear display
    CMD_LINES=`${CMD_TPUT} lines 2>${DEV_NULL}`	  # Number of lines on display
    CMD_COLS=`${CMD_TPUT} cols 2>${DEV_NULL}`	  # Number of columns on display
    CMD_CLRTOEOL=`${CMD_TPUT} el 2>${DEV_NULL}`	  # Clear to end of line
    CMD_CLRTOBGN=`${CMD_TPUT} el1 2>${DEV_NULL}`  # Clear to beginning of line
    CMD_CLRTOEOD=`${CMD_TPUT} ed 2>${DEV_NULL}`	  # Clear to end of display
    CMD_DELCH=`${CMD_TPUT} dch1 2>${DEV_NULL}`	  # Delete current character
    CMD_DELETELN=`${CMD_TPUT} dl1 2>${DEV_NULL}`  # Delete current line
    CMD_INSCH=`${CMD_TPUT} ich1 2>${DEV_NULL}`	  # Insert 1 character
    CMD_INSERTLN=`${CMD_TPUT} il1 2>${DEV_NULL}`  # Insert 1 Line
    CMD_ATTROFF=`${CMD_TPUT} sgr0 2>${DEV_NULL}`  # All Attributes OFF
    CMD_ATTRSET="${CMD_TPUT}"			  # requires arg ( rev, blink, etc )
    CMD_BEEP=`${CMD_TPUT} bel 2>${DEV_NULL}`	  # ring bell
    CMD_LISTER="cat"
    CMD_PAGER="more"
    CMD_SYMLNK="ln -s"
    CMD_ECHO="echo"
    CMD_MAIL="mail"
    WHOAMI="${LOGNAME}@`uname -n`"
    WRITER="dfrench@juno.com"
    CMD_NOTIFY="\${CMD_ECHO} \"\${PGMNAME} - \${WHOAMI} - \`date\`\" | \${CMD_MAIL} \${WRITER}"
    ERROR_PAUSE="sleep 2"
    
    case "_`uname -s`" in
        "_Windows_NT") ${DEV_NULL}="NUL";
                       CMD_SYMLNK="cp";;
             "_Linux") CMD_ECHO="echo -e";;
    esac
    
    IFS_CR="
    "
    IFS_NORM=" 	
    "
    MAC_TIME="TIMESTAMP=\`date +\"%y:%m:%d:%H:%M:%S\"\`"

    eval MAX_LINES=\`expr ${CMD_LINES} - 1\`
    eval MAX_COLS=\`expr ${CMD_COLS} - 1\`
    BUF_SCREEN=""
    BUF_TOT=""

    return 0
}
################################
endwin()
{
    unset MAX_LINES
    unset MAX_COLS
    unset BUF_SCREEN
    return ${?}
}
################################
refresh()
{
    if [ "_${1}" != "_" ]
    then
# DLF        eval \${CMD_ECHO} \"\${${1}}\\c\" > /dev/tty
        eval \${CMD_ECHO} \"\${${1}}\\c\"
    else
# DLF        ${CMD_ECHO} "${BUF_SCREEN}\c" > /dev/tty
        ${CMD_ECHO} "${BUF_SCREEN}\c"
        BUF_TOT="${BUF_TOT}${BUF_SCREEN}"
        BUF_SCREEN=""
    fi
    return 0
}
################################
savescr()
{
    [ "_${DEV_NULL}" != "_${1}" ] && eval ${1}="\"\${BUF_TOT}\""
    BUF_TOT=""
    return ${?}
}
################################
clear()
{
    addstr "${CMD_CLEAR}"
    return ${?}
}
################################
move()
{
#     chklines "${0}" "${1}" \
#     && chkcols "${0}" "${2}" \
#
################################################################
# HEATH-KIT MOVE COMMAND
#    addstr "Y${1} ${2}"
# VT100 MOVE COMMAND
#    addstr "[${1};${2}H"
# TPUT MOVE COMMAND
      eval addstr \"${CMD_MOVE}\"
# HP TERMINAL MOVE COMMAND
#   addstr "&a${1}y${2}C"
################################################################
#  add your move command below this line

    return ${?}
}
################################
mvcur()
{
    chklines "${0}" "${1}" \
    && chkcols "${0}" "${2}" \
    && eval \"${CMD_MOVE}\"
    return ${?}
}
################################
addch()
{
    addstr "`${CMD_ECHO} ${1} | cut -c1`"
    return ${?}
}
################################
addstr()
{
    [ "_${1}" != "_" ] && BUF_SCREEN="${BUF_SCREEN}${1}"
    return ${?}
}
################################
mvaddch()
{
    move "${1}" "${2}" \
    && addch "${3}"
    return ${?}
}
################################
mvaddstr()
{
    move "${1}" "${2}" \
    && addstr "${3}"
    return ${?}
}
################################
clrtoeol()
{
    addstr "${CMD_CLRTOEOL}"
    return ${?}
}
################################
mvclrtoeol()
{
    move "${1}" "${2}" \
    && clrtoeol
    return ${?}
}
################################
clrtobol()
{
    addstr "${CMD_CLRTOBOL}"
    return ${?}
}
################################
mvclrtobol()
{
    move "${1}" "${2}" \
    && clrtobol
    return ${?}
}
################################
clrtobot()
{
    addstr "${CMD_CLRTOEOD}"
    return ${?}
}
################################
mvclrtobot()
{
    move "${1}" "${2}" \
    && clrtobot
    return ${?}
}
################################
getch()
{
    read TMP_GETCH
    STATUS="${?}"
    ${CMD_ECHO} "${TMP_GETCH}"
    return ${STATUS}
}
################################
getwd()
{
    getch
    return ${?}
}
################################
getstr()
{
    IFS="${IFS_CR}"
    getch
    STATUS="${?}"
    IFS="${IFS_NORM}"
    return ${STATUS}
}
################################
insch()
{
    addstr "${CMD_INSCH}"
    return ${?}
}
################################
mvinsch()
{
    move "${1}" "${2}" \
    && addstr "${CMD_INSCH}"
    return ${?}
}
################################
insertln()
{
    addstr "${CMD_INSERTLN}"
    return ${?}
}
################################
delch()
{
    addstr "${CMD_DELCH}"
    return ${?}
}
################################
mvdelch()
{
    move "${1}" "${2}" \
    && addstr "${CMD_DELCH}"
    return ${?}
}
################################
deleteln()
{
    addstr "${CMD_DELETELN}"
    return ${?}
}
################################
attroff()
{
    addstr "${CMD_ATTROFF}"
    return ${?}
}
################################
attron()
{
    return 0
}
################################
attrset()
{
    addstr "`${CMD_ATTRSET} ${1}`"
    return ${?}
}
################################
beep()
{
    addstr "${CMD_BEEP}"
    return ${?}
}
################################
chkparm()
{
    [ "_${2}" = "_" ] \
    && move 24 1 \
    && clrtoeol \
    && addstr "${1}: Missing parameter" >&2 \
    && refresh \
    && ${ERROR_PAUSE} \
    && move 24 1 \
    && clrtoeol \
    && return 1

    return 0
}
################################
chkint()
{
    expr ${2} + 0 > ${DEV_NULL} 2>&1 \
    && return 0

    ROW_NBR="24"
    COL_NBR="1"

    eval addstr \"${CMD_MOVE}\" \
    && clrtoeol \
    && addstr "${1}: argument not a number" >&2 \
    && refresh \
    && ${ERROR_PAUSE} \
    && eval addstr \"${CMD_MOVE}\" \
    && clrtoeol \
    && refresh

    return 1
}
################################
chklines()
{
    chkint ${1} ${2} \
    && [ ${2} -ge 0 -a ${2} -le ${MAX_LINES} ] \
    && return 0

    ROW_NBR="24"
    COL_NBR="1"

    eval addstr \"${CMD_MOVE}\" \
    && clrtoeol \
    && addstr "${1}: Invalid line number" >&2 \
    && refresh \
    && ${ERROR_PAUSE} \
    && eval addstr \"${CMD_MOVE}\" \
    && clrtoeol \
    && refresh

    return 1
}
################################
chkcols()
{
    chkint ${1} ${2} \
    && [ ${2} -ge 0 -a ${2} -le ${MAX_COLS} ] \
    && return 0

    ROW_NBR="24"
    COL_NBR="1"

    eval addstr \"${CMD_MOVE}\" \
    && clrtoeol \
    && addstr "${1}: Invalid column number" >&2 \
    && refresh \
    && ${ERROR_PAUSE} \
    && eval addstr \"${CMD_MOVE}\" \
    && clrtoeol \
    && refresh

    return 1
}
################################


