#include <sys/stat.h>
/* #include <sys/types.h> is included from "ctar.h" */
#include <dirent.h>
#include <stdio.h>
#include <string.h>

#include "ctar.h"

int dump_file(char *name, struct stat *statBuf)
{
#ifdef VERBOSE
  extern unsigned counter;
#endif
  FILE *f;
  char buf[BLOCKSIZE];
  register int count, i;
  
  if((f=fopen(name, "rb"))!=NULL) {
/* ok, read file in BLOCKSIZE chunks and dump out */
/* last chunk is padded with 0's */
/* we should handle short reads here, something like this:
    sizeleft = statBuf->st_size % BLOCKSIZE;
    count = statBuf->st_size / BLOCKSIZE;
    for(i=0;i<count;i++) 
      if((j=fread(buf,(size_t) 1, (size_t) BLOCKSIZE, f)) < BLOCKSIZE)
that can wait, though */
    
    while((count=fread(buf,(size_t) 1, (size_t) BLOCKSIZE, f)) == BLOCKSIZE)
      fwrite(buf,(size_t) 1, (size_t) BLOCKSIZE, stdout);
    if((count<BLOCKSIZE)&&(count>0)) {
      fwrite(buf,(size_t) 1, (size_t) count, stdout);
      for(i=0;i<(BLOCKSIZE-count);i++) fputc(0, stdout);
    }
  }
  else return(E_FOPEN);
#ifdef VERBOSE
  counter++;
  fprintf(stderr,"%d adding %s\n",counter,name);
#endif
  fclose(f);
  return(0);
}

int dump_dir(char *name)
{
      DIR *directory;
      struct dirent *direntry;
      char fname[NAME_FIELD_SIZE], *tmp;
      register int i;
      
      if(!(directory = opendir(name))) return(E_OPENDIR);
      while((direntry = readdir(directory)) != NULL) {
        for(i=0; i<NAME_FIELD_SIZE; i++) fname[i] = '\0';
        if((strlen(direntry->d_name) + strlen(name)) >= NAME_FIELD_SIZE) continue;
/* skip ".", ".." and leading "./" */
	if((strcmp(direntry->d_name,"..") == 0) || (strcmp(direntry->d_name,".") == 0))
	  continue;
	tmp = direntry->d_name;
        if((tmp[0] == '.') && (tmp[1] == '/')) {
	  tmp+=2;
	}
	sprintf(fname, "%s/%s", name, tmp);
#ifdef DEBUG
fprintf(stderr,"Processing dir entry %s\nfname = %s\n",direntry->d_name,fname);
#endif
/*
 * recursive call to create()
 */
	if((i=create(fname)) != 0) return(i);
      }
      closedir(directory);
      return(0);
}
