#ifndef _CTAR_H_
#define _CTAR_H_

#include <sys/types.h>

#define TRUE 		1
#define FALSE 		0
#define E_NAMETOOLONG	1
#define E_CANNOTSTAT	2
#define E_READLINK	3
#define E_SHORTWRITE	4
#define E_FOPEN		5
#define E_MALLOC	6
#define E_OPENDIR	7
#define E_WRONG_FTYPE	8
#define E_STRANGE_ERR	9

/*
 * #define major(dev) (((dev) >> 8) & 0xFF)
 * #define minor(dev) ((dev) & 0xFF) 
 */

/* Some defines from GNU tar-1.12 */

#define	BLOCKSIZE	512

/* Some constants from POSIX are given names  */
#define NAME_FIELD_SIZE   100
#define PREFIX_FIELD_SIZE 155
#define UNAME_FIELD_SIZE   32
#define GNAME_FIELD_SIZE   32

#define TMAGIC   "ustar "	/* ustar and a null */
#define TMAGLEN  6
#define TVERSION " \0"		/* 00 and no null */
#define TVERSLEN 2
/* The checksum field is filled with this while the checksum is computed.  */
#define CHKBLANKS	"        "
/* Values used in typeflag field  */
#define REGTYPE	 '0'		/* regular file */
#define AREGTYPE '\0'		/* regular file */
#define LNKTYPE  '1'		/* hard link */
#define SYMTYPE  '2'		/* symlink */
#define CHRTYPE  '3'		/* character special */
#define BLKTYPE  '4'		/* block special */
#define DIRTYPE  '5'		/* directory */
#define FIFOTYPE '6'		/* FIFO special */
#define CONTTYPE '7'		/* reserved */

/* Bits used in the mode field, values in octal.  */
#define TSUID    04000		/* set UID on execution */
#define TSGID    02000		/* set GID on execution */
#define TSVTX    01000		/* reserved */
				/* file permissions */
#define TUREAD   00400		/* read by owner */
#define TUWRITE  00200		/* write by owner */
#define TUEXEC   00100		/* execute/search by owner */
#define TGREAD   00040		/* read by group */
#define TGWRITE  00020		/* write by group */
#define TGEXEC   00010		/* execute/search by group */
#define TOREAD   00004		/* read by other */
#define TOWRITE  00002		/* write by other */
#define TOEXEC   00001		/* execute/search by other */

/* POSIX header  */
struct fileHeader
{					/* byte offset */
  char name[NAME_FIELD_SIZE];		/*   0 */
  char mode[8];				/* 100 */
  char uid[8];				/* 108 */
  char gid[8];				/* 116 */
  char size[12];			/* 124 */
  char mtime[12];			/* 136 */
  char chksum[8];			/* 148 */
  char typeflag;			/* 156 */
  char linkname[NAME_FIELD_SIZE];	/* 157 */
  char magic[TMAGLEN];			/* 257 */
  char version[TVERSLEN];		/* 263 */
  char uname[UNAME_FIELD_SIZE];		/* 265 */
  char gname[GNAME_FIELD_SIZE];		/* 297 */
  char devmajor[8];			/* 329 */
  char devminor[8];			/* 337 */
  char prefix[PREFIX_FIELD_SIZE];	/* 345 */
					/* 500 */
};

union TarInfo 
{
  char buf[BLOCKSIZE]; /* sizeof(union TarInfo) HAS to be at least BLOCKSIZE */
  struct fileHeader header;
};
typedef union TarInfo	TarInfo;


int create(char *);
void to_oct(long, int, char *);
int dump_file(char *name, struct stat *statBuf);
int dump_dir(char *name);
void uid_to_uname(uid_t uid, char uname[]);
void gid_to_gname(gid_t gid, char uname[]);
int doubleslashdot(char *, char *);

void *xmalloc (size_t);

#endif /* _CTAR_H_ */
