#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <unistd.h>

#include "ctar.h"
#define isdir S_ISDIR(statBuf.st_mode)
#define islnk S_ISLNK(statBuf.st_mode)
#define ischr S_ISCHR(statBuf.st_mode)
#define isblk S_ISBLK(statBuf.st_mode)
#define isfifo (S_ISFIFO(statBuf.st_mode)|S_ISSOCK(statBuf.st_mode))
#define isreg S_ISREG(statBuf.st_mode)


int create(char *dnameBuf)
{
    struct stat statBuf;
    union TarInfo tarInfo;
    int nameLen;
    char nameBuf[NAME_FIELD_SIZE];
    char fname[NAME_FIELD_SIZE];
    extern char **exclude, **hrdlink;
    extern ino_t *inode;
    extern int numXfiles, numHlinks;
    char *p;
    register int i, ec, len, linkidx=0;
    int ishlnk=FALSE;
    
/* skip "." and ".." */ /* done by dump_dir !!!! */
//      if ((strcmp(fname,"..") == 0) || (strcmp(fname,".") == 0)) {
//        return(0);
//      }
/* zero the buffers and save a copy of file name */
      memset(nameBuf,0,(size_t) NAME_FIELD_SIZE);
      memset(&tarInfo,0,(size_t) BLOCKSIZE);
      memset(fname,0,(size_t) NAME_FIELD_SIZE);
/* here we "canonify" the name- strip repeated, initial and leading '/' and '/.'
*/
#ifdef DEBUG
fprintf(stderr,"create(): dnameBuf=%s fname=%s;1\n",dnameBuf,fname);
#endif
      doubleslashdot(dnameBuf,fname);
#ifdef DEBUG
fprintf(stderr,"create(): dnameBuf=%s fname=%s;2\n",dnameBuf,fname);
#endif
/* return if name is in the exclude list */
      for(i=0;i<numXfiles;i++) {
#ifdef DEBUG
fprintf(stderr,"create(): comparing file %s with excluded file %s\n",fname,exclude[i]);
#endif
        if(strcmp(fname,exclude[i]) == 0) {
#ifdef DEBUG
fprintf(stderr,"create(): skipping excluded file %s\n",exclude[i]);
#endif
	  return(0);
        }
      }
/* return if name > 99 chars */
      if ((nameLen=strlen(fname)) >= NAME_FIELD_SIZE) return(E_NAMETOOLONG);
/* stat the file */
      if(lstat(dnameBuf,&statBuf) != 0) {
#ifdef DEBUG
fprintf(stderr,"create(): lstat'ing %s\n",dnameBuf);
#endif
        perror("Can't stat");
	return(E_CANNOTSTAT);
      }
/* if filename was just '/' fname is an empty string now */
      if(!*fname) {
        if(S_ISDIR(statBuf.st_mode)) {	/* make sure it's '/' */
          return(dump_dir(dnameBuf)); /* we should exit on success and error */
	}
	else return(E_STRANGE_ERR);
      }
/* see if there's more than 1 link to this file */      
#ifdef DEBUG
fprintf(stderr,"create(79): file %s has %d hardlinks\n",fname,(int)statBuf.st_nlink);
fprintf(stderr,"create(80): num hlinks = %d, hlinks = %p\n", numHlinks, hrdlink);
#endif
      if(((int)statBuf.st_nlink > 1) && (!S_ISDIR(statBuf.st_mode))){
/* if list of hardlinks is not empty */
        ishlnk = FALSE;
        if(numHlinks > 0) {
          for(i=0;i<numHlinks;i++) { 
#ifdef DEBUG
fprintf(stderr,"create(87): comparing possible hardlink %s with file %s\n",fname,hrdlink[i]);
fprintf(stderr,"create(88): hardlink[%d] at %p is %s\n",i,hrdlink[i], hrdlink[i]);
#endif
            if(inode[i] == statBuf.st_ino)
	    {
#ifdef DEBUG
fprintf(stderr,"create(): adding file %s as hardlink to %s (hrdlink[%d])\n",fname,hrdlink[i],i);
#endif
              ishlnk=TRUE;
	      linkidx = i;
            }
	  }
        }
        if(!ishlnk) { /* i.e. not found in the list */
#ifdef DEBUG
fprintf(stderr,"create(): adding file %s to list of hardlinks(%d)\n",fname,numHlinks);
#endif
          len = strlen(fname);
          if((hrdlink=(char **)realloc(hrdlink,(size_t)((numHlinks+1)*sizeof(char *)))) == NULL || (hrdlink[numHlinks]=(char *)malloc((size_t)((len + 1)*sizeof(char *)))) == NULL)
          {
            fprintf(stderr,"malloc() error in create(), hrdlink[%d]",numHlinks);
            exit(1);
          }
	  if((inode=(ino_t *)realloc(inode,(size_t)(numHlinks + 1)*sizeof(ino_t))) == NULL)
	  {
            fprintf(stderr,"realloc() error in create(), inode[%d]",numHlinks);
            exit(1);
          }
          strncpy(hrdlink[numHlinks],fname,len);
	  hrdlink[numHlinks][len] = '\0';
          inode[numHlinks] = statBuf.st_ino; 
	  numHlinks++;
        }
      }

/* ok, fun part.  We have to fill in the fields of tar header in order,
 * otherwise the header gets corrupted.  I suspect we've gcc's optimizations
 * to thank for that...  or maybe I'm just mising something obvious.
 */
/*sorry, no diagnostics      else*/ /* WTF ?  return(E_WRONG_FTYPE); */

      if(isdir) {
/* make sure we have single '/' after the name */
        strncpy(nameBuf, fname, (size_t) nameLen);
	i=nameLen;
	while(nameBuf[i] == '\0') i--;
	while(nameBuf[i] == '/') i--;
	nameBuf[++i] = '/';
#ifdef DEBUG
fprintf(stderr,"create(): fname=%s, nameBuf = %s, nameLen = %d, dnameBuf = %s\n",fname,nameBuf,nameLen,dnameBuf);
#endif
/*
 * at this point we have path without leading '/' in const char *fname
 * -- we can't edit fname without turning -fwritable-strings on,
 * same with single trailing '/' in string nameBuf -- that's the path we 
 * _store_in_the_header, and original path with single trailing '/' in 
 * dnameBuf -- need that to handle absolute paths -- that's the path we 
 * _pass_to_either dump_file() or dump_dir()
 */
        strncpy(tarInfo.header.name,nameBuf,(size_t)NAME_FIELD_SIZE);
      }
      else strncpy(tarInfo.header.name,fname,(size_t)NAME_FIELD_SIZE);
      to_oct ((long) statBuf.st_mode, 8, tarInfo.header.mode);
      to_oct ((long) statBuf.st_uid, 8, tarInfo.header.uid);
      to_oct ((long) statBuf.st_gid, 8, tarInfo.header.gid);
      if((isdir) || (islnk) || (ishlnk)) statBuf.st_size = 0;
      to_oct ((long) statBuf.st_size, 1 + 12, tarInfo.header.size);
      to_oct ((long) statBuf.st_mtime, 1 + 12, tarInfo.header.mtime);
      memcpy (tarInfo.header.chksum, CHKBLANKS, sizeof (tarInfo.header.chksum));
      if(!ishlnk) {
        if(isreg) tarInfo.header.typeflag=REGTYPE; 
        else if(isdir) tarInfo.header.typeflag=DIRTYPE;
        else if(ischr) tarInfo.header.typeflag=CHRTYPE;
        else if(isblk) tarInfo.header.typeflag=BLKTYPE;
        else if(isfifo) tarInfo.header.typeflag=FIFOTYPE;
        else if(islnk) tarInfo.header.typeflag=SYMTYPE;
      }
      else tarInfo.header.typeflag=LNKTYPE;
      if(islnk) {
#ifdef DEBUG
fprintf(stderr,"create(): reading link %s\n",dnameBuf);
#endif
        if((ec=readlink(dnameBuf, nameBuf, NAME_FIELD_SIZE)) < 0) {
          perror("readlink() failed");
          return(E_READLINK);
        }
        if(ec >= NAME_FIELD_SIZE) return(E_NAMETOOLONG);
	nameBuf[ec++]='\0';
        strncpy(tarInfo.header.linkname, nameBuf, (size_t) NAME_FIELD_SIZE);
      }
      if(ishlnk) strcpy(tarInfo.header.linkname, hrdlink[linkidx]);
      strncpy (tarInfo.header.magic, TMAGIC, TMAGLEN);
      strncpy (tarInfo.header.version, TVERSION, TVERSLEN);
      uid_to_uname (statBuf.st_uid, tarInfo.header.uname);
      gid_to_gname (statBuf.st_gid, tarInfo.header.gname);
      if((ischr) || (isblk)) {
        to_oct ((long)major(statBuf.st_rdev), 8, tarInfo.header.devmajor);
        to_oct ((long)minor(statBuf.st_rdev), 8, tarInfo.header.devminor);
      }
        
/* compute checksum */  
      memcpy (tarInfo.header.chksum, CHKBLANKS, sizeof (tarInfo.header.chksum));
      p = tarInfo.buf;
      for (ec=0, i = sizeof (tarInfo); --i >= 0; ) ec += 0xFF & *p++;
      sprintf(tarInfo.header.chksum, "%6o", ec);  
      
/* dump it */      
      if(fwrite(tarInfo.buf, (size_t) 1, (size_t) BLOCKSIZE, stdout) < BLOCKSIZE) 
        return(E_SHORTWRITE);
      if(!ishlnk) {
        if(isreg)
          if((ec=dump_file(dnameBuf,&statBuf)) != 0) return(ec);
        if(isdir) {
          if((ec=dump_dir(dnameBuf)) != 0) return(ec);
        }
      }
      return(0);
}


