/*
 * Kernel assertions
 */

#ifndef __LINUX_ASSERT_H_
#define __LINUX_ASSERT_H_

#ifdef NO_ASSERT
#define assert(x)
#else
#ifdef __cplusplus
#define assert(x)							\
	if(!(x))							\
	{								\
		printk("Assertion failed in %s:%d: %s\n",		\
		       __FILE__, __LINE__, #x);		\
	}
#else
#define assert(x)							\
	if(!(x))							\
	{								\
		printk("Assertion failed in %s:%d (%s): %s\n",		\
		       __FILE__, __LINE__, __FUNCTION__, #x);		\
	}
#endif /* __cplusplus */
#endif /* NO_ASSERT */

#endif /* __LINUX_ASSERT_H_ */
