/*
 *	Test icmp upper layer notification 
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <errno.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netinet6/in6.h>
#include <net/if.h>

#define SERV_PORT	2000


void handler(int sig)
{
	exit(1);
}

int main(int argc, char *argv[])
{
	char buf1[4096];
	char buf2[4096];
	int sk;
	int err;
	struct sockaddr_in6 usin;
	struct sockaddr_in6 srv;
	int addr_len;

	fprintf(stderr, "starting\n");

	signal(SIGALRM, handler);

	sk = socket(AF_INET6, SOCK_DGRAM, 0);
	
	if (sk < 0)
	{
		perror("sys_socket");
		return -1;
	}

	memset(&usin, 0, sizeof(struct sockaddr_in6));

	usin.sin6_family = AF_INET6;
	usin.sin6_port = htons(SERV_PORT);

	/* ::127.0.0.1 */
	usin.sin6_addr.s6_addr32[3] = inet_addr("127.0.0.1");


	addr_len = sizeof(struct sockaddr_in6);

			
	err = sendto(sk, buf1, 256, 0, (struct sockaddr *)&usin, 
		     sizeof(struct sockaddr_in6));
	
	if (err < 0)
	{
		perror("sendto");
		return -1;
	}

	fprintf(stderr, "snd ok\n");

	alarm(10);

	err = recvfrom(sk, buf2, 4096, 0,(struct sockaddr *) &srv, 
		       &addr_len);
	if (err < 0)
	{
		perror("recvfrom");
		return -1;
	}

	return 0;
}

/*
 * Local variables:
 *  compile-command: "gcc -Wall -m486 -c -o port_unreach.o port_unreach.c"
 * End:
 */

