#ifndef RDISC_H
#define RDISC_H

#include <net/if.h>
#include "timer.h"

#define CONFIG_FILE	"/etc/ipv6rt.conf"

struct AdvPrefix;

struct Interface {
	char			Name[IFNAMSIZ];		/* interface name */

	struct in6_addr		if_addr;
	int			if_index;

	int			AdvSendAdvert;
	int			MaxRtrAdvInterval;
	int			MinRtrAdvInterval;
	int			AdvManagedFlag;
	int			AdvOtherConfigFlag;
	int			AdvLinkMTU;
	int			AdvReachableTime;
	int			AdvRetransTimer;
	int			AdvCurHopLimit;
	int			AdvDefaultLifetime;

	struct AdvPrefix	*AdvPrefixList;
	struct timer_lst	tm;
	unsigned long		tstamp;
	struct Interface	*next;
};

struct AdvPrefix {
	struct in6_addr		Prefix;
	int			PrefixLen;
	
	int			AdvOnLinkFlag;
	int			AdvAutonomousFlag;
	__u32			AdvValidLifetime;
	__u32			AdvPreferedLifetime;

	struct AdvPrefix	*next;
};

#endif
