/*
 * caller.p - kernel and demon processes for active opens
 *
 * Written 1996 by Werner Almesberger, EPFL-LRC
 */


#define QSIZE 10	/* kernel to demon queue size - we actually only have
			   very few messages in flight */

mtype = { bind,connect,close,okay,error };


/*
 * kernel establishes an outbound connection, "uses" it, and finally closes it
 * or accepts closing from the demon.
 */

proctype kernel(chan in;chan out)
{
    do
    :: out!bind ->		/* binding is optional */
	if
	:: in?okay
	:: in?error
	fi
    :: out!connect -> break	/* request to the demon ... */
    od;
    if
    :: in?error			/* demon says "no" */
    :: out!close ->		/* we get impatient and abort */
	if
	:: in?okay ->
	    in?close
	:: in?error
	:: in?close
	fi
    :: in?okay ->		/* connection is ready now */
	if
	:: out!close ->
	    in?close
	:: in?close ->
	    out!close
	fi
    fi
}


/*
 * demon handles requests for outbound connections from the kernel
 */

proctype demon(chan in;chan out)
{
    do
    :: in?bind ->		/* kernel wants to bind */
	if
	:: out!okay
	:: out!error
	fi
    :: in?connect -> break	/* kernel requests connection establishment */
    od;
    if
    :: out!error ->		/* demon refuses */
	do
	:: nempty(in) ->	/* handle one stray close */
	    in?close;
	    break
	:: empty(in) -> break
	od
    :: in?close ->		/* kernel drops the call before completion */
	out!close
    :: out!okay ->		/* connection established ! */
	if
	:: out!close ->
	    in?close
	:: in?close ->
	    out!close
	fi
    fi;
}


init
{
    chan k = [0] of { mtype };	/* kernel's input port (synchronous) */
    chan d = [QSIZE] of { mtype }; /* demon's input queue */

    run demon(d,k);
    run kernel(k,d)
}
