/*
 *	AX.25 release 029
 *
 *	This is ALPHA test software. This code may break your machine, randomly fail to work with new 
 *	releases, misbehave and/or generally screw up. It might even work. 
 *
 *	This code REQUIRES 1.2.1 or higher/ NET3.029
 *
 *	This module:
 *		This module is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 *	History
 *	AX.25 028a	Jonathan(G4KLX)	New state machine based on SDL diagrams.
 *	AX.25 029	Alan(GW4PTS) Switched to KA9Q constant names.
 *
 */

#include <linux/config.h>
#ifdef CONFIG_AX25
#include <linux/errno.h>
#include <linux/types.h>
#include <linux/socket.h>
#include <linux/in.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/string.h>
#include <linux/sockios.h>
#include <linux/net.h>
#include "ax25.h"
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include "sock.h"
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/fcntl.h>
#include <linux/mm.h>
#include <linux/interrupt.h>

static void ax25_timer(unsigned long);

/*
 *	Linux set/reset timer routines
 */
void ax25_set_timer(ax25_socket *sk)
{
	unsigned long flags;
	
	save_flags(flags);
	cli();
	sk->timeout=0;
	del_timer(&sk->timer);
	restore_flags(flags);

	sk->timer.next     = sk->timer.prev = NULL;	
	sk->timer.data     = (unsigned long)sk;
	sk->timer.function = &ax25_timer;

	sk->timeout       = 0;
	sk->timer.expires = 10;
	add_timer(&sk->timer);
}

static void ax25_reset_timer(ax25_socket *sk)
{
	unsigned long flags;
	
	save_flags(flags);
	cli();
	sk->timeout = 0;
	del_timer(&sk->timer);
	restore_flags(flags);

	sk->timer.data     = (unsigned long)sk;
	sk->timer.function = &ax25_timer;
	sk->timeout        = 0;
	sk->timer.expires  = 10;
	add_timer(&sk->timer);
}

/*
 *	AX.25 TIMER 
 *
 *	This routine is called every 500ms. Decrement timer by this
 *	amount - if expired then process the event.
 */
 
static void ax25_timer(unsigned long param)
{
	ax25_socket *sk = (ax25_socket *)param;

	switch (sk->ax25_state) 
	{
		case AX25_STATE_0:
			/* Magic here: If we listen() and a new link dies before it
			   is accepted() it isnt 'dead' so doesnt get removed. */
			if (sk->dead) 
			{
				if (sk->debug)
					printk("S0: destroying socket\n");
				KILL_TIMER(sk);
				ax25_destroy_socket(sk);
				return;
			}
			break;

		case AX25_STATE_3:
		case AX25_STATE_4:
			/*
			 * Check for the state of the receive buffer.
			 */
			if (sk->rmem_alloc >= sk->rcvbuf && !(sk->ax25_condition & OWN_RX_BUSY_CONDITION)) {
				if (sk->debug)
					printk("S%d: going to RNR state\n", sk->ax25_state);
				sk->ax25_condition |=  OWN_RX_BUSY_CONDITION;
				if (sk->debug)
					printk("S%d: sending RNR\n", sk->ax25_state);
				ax25_send_control(sk, RNR, C_RESPONSE);
				sk->ax25_condition &= ~ACK_PENDING_CONDITION;
				break;
			}
			if (sk->rmem_alloc < sk->rcvbuf && (sk->ax25_condition & OWN_RX_BUSY_CONDITION)) {
				if (sk->debug)
					printk("S%d: going to RR state\n", sk->ax25_state);
				sk->ax25_condition &= ~OWN_RX_BUSY_CONDITION;
				if (sk->debug)
					printk("S%d: sending RR\n", sk->ax25_state);
				ax25_send_control(sk, RR, C_RESPONSE);
				sk->ax25_condition &= ~ACK_PENDING_CONDITION;
				break;
			}
			/*
			 * Check for frames to transmit.
			 */
			ax25_kick(sk);
			break;

		default:
			break;
	}

	if (sk->ax25_t2timer > 0 && --sk->ax25_t2timer == 0) 
	{
		if (sk->ax25_state == AX25_STATE_3 || sk->ax25_state == AX25_STATE_4) 
		{
			if (sk->debug)
				printk("S%d: timer t2 expired\n", sk->ax25_state);
			if (sk->ax25_condition & ACK_PENDING_CONDITION) {
				sk->ax25_condition &= ~ACK_PENDING_CONDITION;
				ax25_enquiry_response(sk);
			}
		}
	}

	if (sk->ax25_t3timer > 0 && --sk->ax25_t3timer == 0) 
	{
		if (sk->ax25_state == AX25_STATE_3) 
		{
			if (sk->debug)
				printk("S3: timer t3 expired\n");
			sk->ax25_n2count = 0;
			ax25_transmit_enquiry(sk);
			if (sk->debug)
				printk("S3: going to state 4\n");
			sk->ax25_state   = AX25_STATE_4;
		}
		sk->ax25_t3timer = sk->ax25_t3;
	}

	if (sk->ax25_t1timer == 0 || --sk->ax25_t1timer > 0) 
	{
		ax25_reset_timer(sk);
		return;
	}

	if (sk->debug)
		printk("S%d: timer t1 expired\n", sk->ax25_state);

	switch (sk->ax25_state) 
	{
		case AX25_STATE_1: 
			if (sk->ax25_n2count == sk->ax25_n2) 
			{
				ax25_clear_tx_queue(sk);
				sk->state        = TCP_CLOSE;
				sk->err          = ETIMEDOUT;
				if (!sk->dead)
					sk->state_change(sk);
				if (sk->debug)
					printk("S1: going to state 0\n");
				sk->ax25_state   = AX25_STATE_0;
				sk->dead         = 1;
			} else {
				sk->ax25_n2count++;
				if (sk->debug)
					printk("S1: sending SABM(P) N2=%d\n", sk->ax25_n2count);
				ax25_send_control(sk, SABM|PF, C_COMMAND);
			}
			break;

		case AX25_STATE_2:
			if (sk->ax25_n2count == sk->ax25_n2) 
			{
				sk->state        = TCP_CLOSE;
				sk->err          = ETIMEDOUT;
				if (!sk->dead)
					sk->state_change(sk);
				if (sk->debug)
					printk("S2: going to state 0\n");
				sk->ax25_state   = AX25_STATE_0;
				sk->dead         = 1;
			} else {
				sk->ax25_n2count++;
				if (sk->debug)
					printk("S2: sending DISC(P) N2=%d\n", sk->ax25_n2count);
				ax25_send_control(sk, DISC|PF, C_COMMAND);
			}
			break;

		case AX25_STATE_3: 
			sk->ax25_n2count = 1;
			ax25_transmit_enquiry(sk);
			if (sk->debug)
				printk("S3: going to state 4\n");
			sk->ax25_state = AX25_STATE_4;
			break;

		case AX25_STATE_4:
			if (sk->ax25_n2count == sk->ax25_n2) 
			{
				ax25_clear_tx_queue(sk);
				sk->state        = TCP_CLOSE;
				sk->err          = ETIMEDOUT;
				if (!sk->dead)
					sk->state_change(sk);
				if (sk->debug)
					printk("S4: sending DM(F)\n");
				ax25_send_control(sk, DM|PF, C_RESPONSE);
				if (sk->debug)
					printk("S4: going to state 0\n");
				sk->ax25_state   = AX25_STATE_0;
				sk->dead         = 1;
			} else {
				sk->ax25_n2count++;
				ax25_transmit_enquiry(sk);
			}
			break;
	}

	sk->ax25_t1timer = sk->ax25_t1;

	ax25_set_timer(sk);
}

#endif
