#
#	MN_info.pl
#
#	Mail-Net information server.
#
#	Created: Sat Feb 29 01:23:27 1992
#	Last modified: Sat Jan 23 05:19:55 1993
#
#	@ arl // 1992
#

require		"$ARGV[0]/MN_config.pl";
require		"$ARGV[0]/MN_lib.pl";
require		"$ARGV[0]/MN_global.pl";

sub
InfoUser
{
	local($ListName)	= pop(@_);
	local($User)		= pop(@_);

	local($counter)		= 0;
	local($Handle);
	local($ChannelName)	= '';
	local($InfoFileName)	= '';
	local($UserFileName)	= '';

	&OpenChannelFile( "<" );

	&ReadChannelFile();

	&CloseChannelFile();

	&do_from( $SendBackAddress );	# Hmmm.

	$Handle = &ReturnMailOpen( $Address'address,
			"Your request for user", $ListName );

	while ( length(@ChannelList[$counter]) > 0 )
	{
		$ChannelName  = @ChannelList[$counter++];
		$InfoFileName = @ChannelList[$counter++];
		$UserFileName = @ChannelList[$counter++];

		open( USERFILE, "<" . $UserFileName );
		while ( <USERFILE> )
		{
			if ( index( $_, $User ) > -1 )
			{
				&ReturnMailWrite( $Handle, $ChannelName );
				&ReturnMailWrite( $Handle, " >\t" );
				&ReturnMailWrite( $Handle, $_ );
				&ReturnMailWrite( $Handle, "\n" );
			}
		}
		close( USERFILE );
	}

	&ReturnMailWrite( $Handle, "\n===End of Listing===\n" );

	&ReturnMailClose( $Handle );

	&WriteLog( $LOG_FILENAME, $0, "sent user info",
		$User, $Address'address );

	return 0;
}

sub
InfoChannel
{
	local($ListName)	= pop(@_);
	local($Channel)		= pop(@_);


	local($counter)		= 0;
	local($Handle);
	local($ChannelName)	= '';
	local($InfoFileName)	= '';
	local($UserFileName)	= '';

	&OpenChannelFile( "<" );

	&ReadChannelFile();

	&CloseChannelFile();

	&do_from( $SendBackAddress );	# Hmmm.

	$Handle = &ReturnMailOpen( $Address'address,
			"Your request for channel", $ListName );

	&ReturnMailWrite( $Handle, "Here is the list of channels on " .
		$ListName . " mailing list:\n" );
	&ReturnMailWrite( $Handle, "================================" );
	&ReturnMailWrite( $Handle, "^" x length($ListName) );
	&ReturnMailWrite( $Handle, "==============\n\n" );

	while ( length(@ChannelList[$counter]) > 0 )
	{
		$ChannelName  = @ChannelList[$counter++];
		$InfoFileName = @ChannelList[$counter++];
		$UserFileName = @ChannelList[$counter++];

		&ReturnMailWrite( $Handle, "Channel: " );
		&ReturnMailWrite( $Handle, $ChannelName );
		&ReturnMailWrite( $Handle, "\n" );
		&ReturnMailWrite( $Handle, "---------" );
		&ReturnMailWrite( $Handle, "-" x length($ChannelName) );
		&ReturnMailWrite( $Handle, "\n\n" );

		open( INFOFILE, "<" . $InfoFileName );
#		Skipping over mail headers.
		while ( <INFOFILE> )
		{
			if ( length($_) == 1 )
			{
				last;
			}
		}
		while ( <INFOFILE> )
		{
			if ( index( $_, "\t" ) ne 0 )
			{
				&ReturnMailWrite( $Handle, "\t" );
			}
			&ReturnMailWrite( $Handle, $_ );
		}
		close( INFOFILE );
		&ReturnMailWrite( $Handle, "\n" );
	}

	&ReturnMailWrite( $Handle, "\n===End of Listing===\n" );

	&ReturnMailClose( $Handle );

	&WriteLog( $LOG_FILENAME, $0, "sent channel info",
		$Address'address );

	return 0;
}

#
#	main
#

chdir( @ARGV[1] );

$GL_WhoAmI = @ARGV[2];

#open( tempf, "<" . @ARGV[$#ARGV] ) || do
open( tempf, "<" . @ARGV[3] ) || do
{
	$DEBUG && print "$0: Could not open file:", @ARGV[$#ARGV], "\n";
	exit(1);
};

$header = 1;
$NoCommand = 1;
while (<tempf>)
{
	@TheMail .= $_;

	if ( $header == 1 )
	{
		if ( length($_) == 1 )
		{
			$header = 0;
			next;
		}

#		Remove the eol newline.
		chop;

		if ( /^From:/ )
		{
			($dummy,$FromAddress) = split(/[:]/o);
			next;
		}
		if ( /^Reply-To:/ )
		{
			($dummy,$ReplyToAddress) = split(/[:]/o);
			next;
		}
		if ( /^Sender:/ )
		{
			($dummy,$SenderAddress) = split(/[:]/o);
			next;
		}

		if ( ( /^X-Mn/ || /^Mn/ ) && $NoCommand )
		{
			($dummy,$InfoCommand) = split(/[:]/o);
			$DEBUG && print "Line=\"",$_,
				"\" infocommand=\"",$InfoCommand,"\"\n";
			$NoCommand = 0;
			next;
		}
	}
}

close( tempf );

if ( $ReplyToAddress )
{
	$SendBackAddress = $ReplyToAddress;
}
else
{
	$SendBackAddress = $FromAddress;
}

&do_from( $FromAddress );

$DEBUG && print "$0: Info command =\"", $InfoCommand, "\"\n";

#
#	Parsing the command out.
#
@Commands = ();
$dummy = ( @Commands = split(' ', $InfoCommand ) );

if ( @Commands[0] eq "user" )
{
	&InfoUser( @Commands[1], @ARGV[2] );
}
elsif ( @Commands[0] eq "channel" )
{
	&InfoChannel( @Commands[1], @ARGV[2] );
}
else
{
	&WriteLog( $LOG_FILENAME, $0, "unknown command",
		$InfoCommand );

	&SendMail( $Address'address, $InfoCommand, "MN-INFO: ERROR:" .
		" unknown command" );
}

link( @ARGV[3], &tmpfile( $DONE_TMPFILE ) );
unlink( @ARGV[3] );

exit( 0 );
