#
#	MN_global.pl
#
#	Mail-Net internal global functions.
#		* sending mail.
#		* file handling and locking.
#
#	Created: Fri Feb 28 20:02:02 1992
#	Last modified: Thu Dec 17 03:58:38 1992
#
#	@ arl // 1992
#

sub
OpenChannelFile
{
	local($mode)	= pop(@_);
#	local($result)	= 0;

	$ChannelLockFile = $ChannelFileName . ".lock";

#
#	Try to open lock.
#

	while ( 1 )
	{
		if ( -f $ChannelLockFile )
		{
			$DEBUG && print "OpenChannelFile: waiting for lock\n";
#			We should check the file, if untouched
#			for 1 minute, holder must have died.
			sleep( 5 );
			next;
		}
		else
		{
			last;
		}
	}

	open( ChannelLockFile, ">" . $ChannelLockFile ) || do
	{
#		Error .. could not open lock file
		return -1;	    
	};

	print ChannelLockFile sprintf( "%d.%ld\n", $$, time );
	close( ChannelLockFile );
 
	if ( -f $ChannelFileName )
	{
		open(ChannelFile, $mode . $ChannelFileName) || do
		{
			&WriteLog( $LOG_FILENAME, $0,
				"could not open channel file",
				$ChannelFileName );
			return -2;
		};
	}
	else
	{
		if ( -f $ChannelFileName . ".save" )
		{
			&WriteLog( $LOG_FILENAME, $0,
				"no channel file", "save file exists" );
		}

		link( $ChannelFileName . ".save", $ChannelFileName ) || do
		{
			return -3;
		};

		&WriteLog( $LOG_FILENAME, $0,
			"linked save file to channel file" );

		if ( -f $ChannelFileName )
		{
			unlink( $ChannelFileName . ".save" );
		}

		open(ChannelFile, $mode . $ChannelFileName) || do
		{
			&WriteLog( $LOG_FILENAME, $0,
				"could not open channel file",
				$ChannelFileName );
			return -4;
		};
	}

#	$result;
	return 0;

}

sub
ReadChannelFile
{
	if ( $#ChannelList ne -1 )
	{
		$DEBUG && print "ReadChannelFile: \$\#ChannelList = ",
				$#ChannelList,"\n";
		&WriteLog( $LOG_FILENAME, $0, "ChannelList != NULL",
			"**Exiting" );
		exit(-2);
	}

	while (<ChannelFile>)
	{
		chop;
		push( @ChannelList, $_ );
		$DEBUG && print "ReadChannelFile: line = \"",$_,"\"\n";
	}

	return 1;
}

sub
CheckIfChannelThere
{
	local($ChannelName)	= pop(@_);
	local($counter)		= 0;
	local($result)		= 0;
	local($CheckName)	= '';

	$ChannelName =~ y/[a-z]/[A-Z]/;

	$DEBUG && print "CheckIfChannelThere: channel = \"",
			$ChannelName, "\"\n";
	$DEBUG && print "  item = ", @ChannelList[$counter], "\n";
	while ( length(@ChannelList[$counter]) > 0 )
	{
		$CheckName = @ChannelList[$counter];
		$CheckName =~ y/[a-z]/[A-Z]/;
		$DEBUG && print "   checkname = \"", $CheckName, "\"\n";
		if ( $ChannelName eq $CheckName )
		{
			@CurrentChannel = ();
			push( @CurrentChannel, @ChannelList[$counter++] );
			push( @CurrentChannel, @ChannelList[$counter++] );
			push( @CurrentChannel, @ChannelList[$counter++] );
			return 1;
#			last;
		}
		$counter += 3;
	}
	return 0;
#	$result;
}

sub
AddToChannelFile
{
	local($Creator)		= pop(@_);
	local($FileName)	= pop(@_);
	local($Channel)		= pop(@_);
	local($InfoFileName)	= '';
	local($UserFileName)	= '';
#	local($result)		= 0;

	$DEBUG && print "AddToChannelFile: user = \"",
			$Creator,"\" filename = \"",
	$FileName,"\" channel = \"",$Channel,"\"\n";

#
#	Create INFO file.
#
	$InfoFileName = "LISTS/" . $Channel . ".info";

	if ( -f $InfoFileName )
	{
#		If we have already infofile, make newer one with time.
		$InfoFileName = sprintf("%s.%ld", $InfoFileName, time );
	}

	link( $FileName, $InfoFileName ) || do
	{
		&WriteLog( $LOG_FILENAME, $0, "could not link",
			$FileName, $InfoFileName ); ### errno
		return -1;
	};

#
#	Create USER file.
#
	$UserFileName = "LISTS/" . $Channel . ".user";

	if ( -f $UserFileName )
	{
#		Really weird .. and should never happen .. but still
		link( $UserFileName, $UserFileName . time . $$ );
		unlink( $UserFileName );
	}

	open( UserFile, ">" . $UserFileName ) || do
	{
		&WriteLog( $LOG_FILENAME, $0, "could not open USER file",
			$UserFileName ); ### errno
		return -3;
	};

	print UserFile $Creator,"\n";

	close( UserFile );

	$Channel =~ y/[a-z]/[A-Z]/;
	push(@ChannelList, $Channel );
	push(@ChannelList, $InfoFileName );
	push(@ChannelList, $UserFileName );

	return 0;
}

sub
SaveChannelFile
{

	link( $ChannelFileName, $ChannelFileName . ".save" ) || do
	{
		return -1;
	};

	close( ChannelFile );

	unlink( $ChannelFileName ) || do
	{
		return -2;
	};

	open( ChannelFile, ">" . $ChannelFileName ) || do
	{
		return -3;
	};

	foreach (@ChannelList)
	{
		print ChannelFile $_,"\n";
	}

	close( ChannelFile );

	unlink( $ChannelFileName . ".save" );

	return 0;

}

sub
CloseChannelFile
{

#	Remove the lock file.
	unlink( $ChannelFileName . ".lock" );
	return 0;
}

#
#	Handling user files.
#

sub
UserFileOpen
{
	local($mode)		= pop(@_);
	local($filename)	= pop(@_);

#print "UserFileOpen: filename = $filename \n";

	if ( ! -f $filename )
	{
#print "UserFileOpen: no such file = ", $filename, "\n";
#print `pwd`;
	}

	open( UserFile, $mode . $filename ) || do
	{
		&WriteLog( $LOG_FILENAME, $0, "could not open USER file",
			$filename ); ### errno
	};

#	Without the following we can't return files.
	return $kludge=UserFile;
}

sub
AddToUserFile
{
	local($User)	= pop(@_);
	local($Channel)	= pop(@_);

	$UserFile = &UserFileOpen( @CurrentChannel[2], ">>" );

	print $UserFile $User,"\n";

	&UserFileClose( $UserFile );

	return 0;
}

sub
TakeFromUserFile
{
	local($User)		= pop(@_);
	local($Channel)		= pop(@_);
	local($Address)		= $Address'address;
	local($Found)		= 0;
	local(@NewUsers)	= ();

#	&do_from( $User );

	$UserFile = &UserFileOpen( @CurrentChannel[2], "<" );

	while ( <$UserFile> )
	{
		chop;
		&do_from($_);

#		if ( $Address'address eq '^@' )
#		{
#			@nic.funet.fi: addressing.
#			( $dummy, $Address'address ) =
#				split( /[:]/, $Address'address );
#		}
		if ( $Address eq $Address'address )
		{
			$Found = 1;
		}
		else
		{
			push( @NewUsers, $_ );
		}
	}

	&UserFileClose( $UserFile );

	if ( $Found == 1 )
	{
		if ( -f @CurrentChannel[2] . ".bak" )
		{
			unlink( @CurrentChannel[2] . ".bak" );
		}

		link( @CurrentChannel[2], @CurrentChannel[2] . ".bak" ) || do
		{
#			Error!
		};
		unlink( @CurrentChannel[2] ) || do
		{
#			Error!
		};
		$UserFile = &UserFileOpen( @CurrentChannel[2], ">" ) || do
		{
#			Error!
		};

		foreach (@NewUsers)
		{
			print $UserFile $_,"\n";
		}

		&UserFileClose( $UserFile );
	}

	$Found;
}

sub
UserFileClose
{
	local($File)	= pop(@_);

	close( $File );

	return 0;
}

#
#	Sending mail.
#

sub
SendFileToChannel
{
	local($WhoAmI)			= pop(@_);
	local($message_filename)	= pop(@_);
	local($Channel)			= pop(@_);
	local(@Users)			= ();
	local(@LUsers)			= ();
	local($counter)			= 0;
	local($index)			= 0;
	local($Finito)			= 0;
#	local($UserFile);

#print "SendFileToChannel: WhoAmI = ", $WhoAmI, "\n";
#print "SendFileToChannel: Channel = ", $Channel, "\n";
#print "SendFileToChannel: File = ", $message_filename, "\n";

	$UserFile = &UserFileOpen( @CurrentChannel[2], "<" );

	while ( <$UserFile> )
	{
		chop;
		&do_from( $_ );
		push( @Users, $Address'address );
	}

	&UserFileClose( $UserFile );

	if ( $#Users eq -1 )
	{
		$DEBUG && print "Users have 0 items\n";
		return 0;
	}

	open( message_file, "<" . $message_filename ) || do
	{
#		Error!
		$DEBUG && print "SendFileToChannel: could not open = ",
				$message_filename, "\n";
		return 0;
	};

#	foreach ( @Users )
	while ( 1 )
	{
		for ( $counter = 0; $counter < $MAIL_LIMIT; $counter++ )
		{
			if ( $index > $#Users )
			{
				$Finito = 1;
				last;
			}
			push( @LUsers, @Users[$index] );
			$index++;
		}

		open( SENDMAIL,
			"|$SENDMAIL_BINARY -bm -fowner-" .
			"$WhoAmI @LUsers" ) || do
		{
#			Error!
			return -1;
		};

		seek( message_file, 0, 0 );
		while ( <message_file> )
		{
			print SENDMAIL $_;
		}
		close( SENDMAIL );

#		should write to some file how many we have sent.
#		XXXXXXXXXXX

		@LUsers = ();

		sleep( $MAIL_SLEEP );

		if ( $Finito eq 1 )
		{
			close( message_file );
			return 1;
		}
	}
}

sub
SendMail
{
	local(@Message)		= pop(@_);
	local($Channel)		= pop(@_);
	local($Creator)		= pop(@_);
#	We should not use file!
	local(@errortxt)	= ();
	local($error_filename)	= '';

	$DEBUG && print "SendMail: to = \"",$Creator,"\" channel = \"",
			$Channel, "\" message = \"",@Message,"\"\n";

	&do_from( $Creator );

	$error_filename = &tmpfile( $ERROR_MAILFILE );

	open( errorf, "+>" . $error_filename ) || do
	{
#		Error!
		return -1;
	};

	print errorf "From: \"Mail-Net server\" <", $GL_WhoAmI,
		"@niksula.hut.fi>\n";
	print errorf "To: ", $Address'address, "\n";
	print errorf "Sender: owner-", $GL_WhoAmI, "@niksula.hut.fi\n";
	print errorf "Subject: ", @Message[1], "\n";
	print errorf "\n";

	print errorf "Mail-Net Server notify:\n";
	print errorf "\n";
	print errorf "\t", @Message, ": ", $Channel, "\n";
	print errorf "\n\n";

#	close( errorf );
	seek( errorf, 0, 0 );

	open( SENDMAIL, "|" . $SENDMAIL_BINARY .
		" -bm " . $Address'address ) || do
	{
#		Error!
		return -2;
	};

	while ( <errorf> )
	{
		print SENDMAIL $_;
	}

	close( errorf );
	close( SENDMAIL );

	link( $error_filename, &tmpfile( $DONE_TMPFILE ) );
	unlink( $error_filename );

	return 0;
}

sub
SendFileToUser
{
	local($WhoAmI)			= pop(@_);
	local($message_filename)	= pop(@_);
	local($User)			= pop(@_);
	local($Handle);

	$Handle = &ReturnMailOpen( $User, "Your request to " .
		$WhoAmI . "-request", $WhoAmI );

	open( MESSAGEF, "<" . $message_filename ) || do
	{
		&WriteLog( $LOG_FILENAME, $0,
			"could not send file to user",
			$message_filename, $User );
		return 1;
	};

	while ( <MESSAGEF> )
	{
		&ReturnMailWrite( $Handle, $_ );
	}

	&ReturnMailClose( $Handle );

	return 0;
}

#
#	ReturnMail object ..
#

@ReturnMailStack	= ( "dummy" );

sub
ReturnMailOpen
{
	local($WhoAmI)	= pop(@_);
	local($Info)	= pop(@_);
	local($To)	= pop(@_);

	local($NewFP);
	local($NewFName)	= &tmpfile( $RETURN_TMPFILE );
	local($result)		= 0;

	open( NewFP, "+>" . $NewFName ) || do
	{
#		Could not open return mail file .. aargh.
		return 0;
	};

	$NewFP = NewFP;

	print $NewFP "From: \"Mail-Net server request handler\" ",
		"\<", $WhoAmI, "-request@niksula.hut.fi\>\n";
	print $NewFP "To: ", $To, "\n";
	print $NewFP "Sender: owner-", $WhoAmI, "@niksula.hut.fi\n";
	print $NewFP "Subject: ", $Info, "\n";
	print $NewFP "\n\n";

	push( @ReturnMailStack, $NewFP );
	$result = $#ReturnMailStack;
	push( @ReturnMailStack, $NewFName );
	push( @ReturnMailStack, $WhoAmI );
	push( @ReturnMailStack, $To );

	return $result;
}

sub
ReturnMailWrite
{
	local($Message)		= pop(@_);
	local($ReturnMail)	= pop(@_);
	local($OurFP)		= @ReturnMailStack[$ReturnMail];

	print $OurFP $Message;

	1;
}

sub
ReturnMailClose
{
	local($ReturnMail)	= pop(@_);
	local($OurFP)		= @ReturnMailStack[$ReturnMail];
	local($OurFName)	= @ReturnMailStack[$ReturnMail+1];
	local($From)		= @ReturnMailStack[$ReturnMail+2];
	local($To)		= @ReturnMailStack[$ReturnMail+3];

	$DEBUG && print "ReturnMailClose: our file name = ", $OurFName, "\n";

	open( TOSENDMAIL,
		"|$SENDMAIL_BINARY -bm -fowner-$From $Address'address" ) || do
	{
		close( $OurFP );
		&WriteLog( $LOG_FILENAME, $0, "could not mail",
			$To, $OurFName );
		return 0;
	};

	seek( $OurFP, 0, 0 );

	while ( <$OurFP> )
	{
		print TOSENDMAIL $_;
	}

	close( $OurFP );

	close( TOSENDMAIL ) || do
	{
		return 0;
	};

	unlink( $OurFName );
	
	1;
}

1;
