# SPDX-License-Identifier: GPL-2.0

# fmt: off
wacom_pth660_v145 = [
    0x05, 0x01,                     # . Usage Page (Desktop),
    0x09, 0x02,                     # . Usage (Mouse),
    0xA1, 0x01,                     # . Collection (Application),
    0x85, 0x01,                     # .     Report ID (1),
    0x09, 0x01,                     # .     Usage (Pointer),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x05, 0x09,                     # .         Usage Page (Button),
    0x19, 0x01,                     # .         Usage Minimum (01h),
    0x29, 0x03,                     # .         Usage Maximum (03h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x03,                     # .         Report Count (3),
    0x81, 0x02,                     # .         Input (Variable),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x05,                     # .         Report Count (5),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x05, 0x01,                     # .         Usage Page (Desktop),
    0x09, 0x30,                     # .         Usage (X),
    0x09, 0x31,                     # .         Usage (Y),
    0x15, 0x81,                     # .         Logical Minimum (-127),
    0x25, 0x7F,                     # .         Logical Maximum (127),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x02,                     # .         Report Count (2),
    0x81, 0x06,                     # .         Input (Variable, Relative),
    0xC0,                           # .     End Collection,
    0xC0,                           # . End Collection,
    0x06, 0x0D, 0xFF,               # . Usage Page (FF0Dh),
    0x09, 0x01,                     # . Usage (01h),
    0xA1, 0x01,                     # . Collection (Application),
    0x85, 0x10,                     # .     Report ID (16),
    0x09, 0x20,                     # .     Usage (20h),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x09, 0x42,                     # .         Usage (42h),
    0x09, 0x44,                     # .         Usage (44h),
    0x09, 0x5A,                     # .         Usage (5Ah),
    0x09, 0x45,                     # .         Usage (45h),
    0x09, 0x3C,                     # .         Usage (3Ch),
    0x09, 0x32,                     # .         Usage (32h),
    0x09, 0x36,                     # .         Usage (36h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x07,                     # .         Report Count (7),
    0x81, 0x02,                     # .         Input (Variable),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x0A, 0x30, 0x01,               # .         Usage (0130h),
    0x65, 0x11,                     # .         Unit (Centimeter),
    0x55, 0x0D,                     # .         Unit Exponent (13),
    0x35, 0x00,                     # .         Physical Minimum (0),
    0x47, 0x80, 0x57, 0x00, 0x00,   # .         Physical Maximum (22400),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x27, 0x00, 0xAF, 0x00, 0x00,   # .         Logical Maximum (44800),
    0x75, 0x18,                     # .         Report Size (24),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x31, 0x01,               # .         Usage (0131h),
    0x47, 0xD0, 0x39, 0x00, 0x00,   # .         Physical Maximum (14800),
    0x27, 0xA0, 0x73, 0x00, 0x00,   # .         Logical Maximum (29600),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x30,                     # .         Usage (30h),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x65, 0x00,                     # .         Unit,
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x1F,               # .         Logical Maximum (8191),         # !!! Errata: Missing Physical Max = 0
    0x75, 0x10,                     # .         Report Size (16),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x3D,                     # .         Usage (3Dh),
    0x09, 0x3E,                     # .         Usage (3Eh),
    0x65, 0x14,                     # .         Unit (Degrees),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x35, 0xC0,                     # .         Physical Minimum (-64),
    0x45, 0x3F,                     # .         Physical Maximum (63),
    0x15, 0xC0,                     # .         Logical Minimum (-64),
    0x25, 0x3F,                     # .         Logical Maximum (63),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x02,                     # .         Report Count (2),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x41,                     # .         Usage (41h),
    0x65, 0x14,                     # .         Unit (Degrees),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x36, 0x4C, 0xFF,               # .         Physical Minimum (-180),
    0x46, 0xB3, 0x00,               # .         Physical Maximum (179),
    0x16, 0x7C, 0xFC,               # .         Logical Minimum (-900),
    0x26, 0x83, 0x03,               # .         Logical Maximum (899),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x0A,                     # .         Input (Variable, Wrap),
    0x0A, 0x03, 0x0D,               # .         Usage (0D03h),
    0x65, 0x00,                     # .         Unit,
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x07,               # .         Logical Maximum (2047),         # !!! Errata: Missing Physical Min/Max = 0
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x32, 0x01,               # .         Usage (0132h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x3F,                     # .         Logical Maximum (63),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x5B,                     # .         Usage (5Bh),
    0x09, 0x5C,                     # .         Usage (5Ch),
    0x17, 0x00, 0x00, 0x00, 0x80,   # .         Logical Minimum (-2147483648),
    0x27, 0xFF, 0xFF, 0xFF, 0x7F,   # .         Logical Maximum (2147483647),
    0x75, 0x20,                     # .         Report Size (32),
    0x95, 0x02,                     # .         Report Count (2),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x77,                     # .         Usage (77h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x0F,               # .         Logical Maximum (4095),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0xC0,                           # .     End Collection,
    0x85, 0x11,                     # .     Report ID (17),
    0x09, 0x39,                     # .     Usage (39h),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x1A, 0x10, 0x09,               # .         Usage Minimum (0910h),
    0x2A, 0x17, 0x09,               # .         Usage Maximum (0917h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x08,                     # .         Report Count (8),
    0x81, 0x02,                     # .         Input (Variable),
    0x1A, 0x40, 0x09,               # .         Usage Minimum (0940h),
    0x2A, 0x47, 0x09,               # .         Usage Maximum (0947h),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x95, 0x09,               # .         Usage (0995h),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x95, 0x07,                     # .         Report Count (7),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x0A, 0x38, 0x01,               # .         Usage (0138h),
    0x65, 0x14,                     # .         Unit (Degrees),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x35, 0x00,                     # .         Physical Minimum (0),
    0x46, 0x67, 0x01,               # .         Physical Maximum (359),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x47,                     # .         Logical Maximum (71),
    0x75, 0x07,                     # .         Report Size (7),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x0A,                     # .         Input (Variable, Wrap),
    0x0A, 0x39, 0x01,               # .         Usage (0139h),
    0x65, 0x00,                     # .         Unit,
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x25, 0x01,                     # .         Logical Maximum (1),            # !!! Errata: Missing Physical Max = 0
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x04,                     # .         Report Count (4),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0xC0,                           # .     End Collection,
    0x85, 0x13,                     # .     Report ID (19),
    0x0A, 0x13, 0x10,               # .     Usage (1013h),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x0A, 0x3B, 0x04,               # .         Usage (043Bh),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x64,                     # .         Logical Maximum (100),
    0x75, 0x07,                     # .         Report Size (7),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x04, 0x04,               # .         Usage (0404h),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x52, 0x04,               # .         Usage (0452h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x95, 0x06,                     # .         Report Count (6),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x0A, 0x54, 0x04,               # .         Usage (0454h),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x06,                     # .         Report Count (6),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0xC0,                           # .     End Collection,
    0x09, 0x0E,                     # .     Usage (0Eh),
    0xA1, 0x02,                     # .     Collection (Logical),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x85, 0x02,                     # .         Report ID (2),
    0x09, 0x01,                     # .         Usage (01h),
    0x75, 0x08,                     # .         Report Size (8),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x03,                     # .         Report ID (3),
    0x0A, 0x03, 0x10,               # .         Usage (1003h),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x04,                     # .         Report ID (4),
    0x0A, 0x04, 0x10,               # .         Usage (1004h),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x07,                     # .         Report ID (7),
    0x0A, 0x09, 0x10,               # .         Usage (1009h),
    0x25, 0x02,                     # .         Logical Maximum (2),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x03,                     # .         Feature (Constant, Variable),
    0x0A, 0x07, 0x10,               # .         Usage (1007h),
    0x09, 0x00,                     # .         Usage (00h),
    0x0A, 0x08, 0x10,               # .         Usage (1008h),
    0x09, 0x00,                     # .         Usage (00h),
    0x09, 0x00,                     # .         Usage (00h),
    0x09, 0x00,                     # .         Usage (00h),
    0x27, 0xFF, 0xFF, 0x00, 0x00,   # .         Logical Maximum (65535),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x06,                     # .         Report Count (6),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x03,                     # .         Feature (Constant, Variable),
    0x85, 0x0C,                     # .         Report ID (12),
    0x0A, 0x30, 0x0D,               # .         Usage (0D30h),
    0x0A, 0x31, 0x0D,               # .         Usage (0D31h),
    0x0A, 0x32, 0x0D,               # .         Usage (0D32h),
    0x0A, 0x33, 0x0D,               # .         Usage (0D33h),                  # !!! Errata: Missing Non-zero Physical Max
    0x65, 0x11,                     # .         Unit (Centimeter),
    0x55, 0x0D,                     # .         Unit Exponent (13),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x03,                     # .         Feature (Constant, Variable),
    0x85, 0x0D,                     # .         Report ID (13),
    0x65, 0x00,                     # .         Unit,
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x0A, 0x0D, 0x10,               # .         Usage (100Dh),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x14,                     # .         Report ID (20),
    0x0A, 0x14, 0x10,               # .         Usage (1014h),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x0D,                     # .         Report Count (13),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x31,                     # .         Report ID (49),
    0x0A, 0x31, 0x10,               # .         Usage (1031h),
    0x25, 0x64,                     # .         Logical Maximum (100),
    0x95, 0x05,                     # .         Report Count (5),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x32,                     # .         Report ID (50),
    0x0A, 0x31, 0x10,               # .         Usage (1031h),
    0x25, 0x64,                     # .         Logical Maximum (100),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x0A, 0x32, 0x10,               # .         Usage (1032h),
    0x25, 0x03,                     # .         Logical Maximum (3),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x34,                     # .         Report ID (52),
    0x0A, 0x34, 0x10,               # .         Usage (1034h),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x35,                     # .         Report ID (53),
    0x0A, 0x35, 0x10,               # .         Usage (1035h),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x0A,                     # .         Report Count (10),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x36,                     # .         Report ID (54),
    0x0A, 0x35, 0x10,               # .         Usage (1035h),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x96, 0x01, 0x01,               # .         Report Count (257),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0xCC,                     # .         Report ID (204),
    0x0A, 0xCC, 0x10,               # .         Usage (10CCh),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x02,                     # .         Report Count (2),
    0xB1, 0x02,                     # .         Feature (Variable),
    0xC0,                           # .     End Collection,
    0x0A, 0xAC, 0x10,               # .     Usage (10ACh),
    0xA1, 0x02,                     # .     Collection (Logical),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x75, 0x08,                     # .         Report Size (8),
    0x85, 0xAC,                     # .         Report ID (172),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0xBF,                     # .         Report Count (191),
    0x81, 0x02,                     # .         Input (Variable),
    0x85, 0x33,                     # .         Report ID (51),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x12,                     # .         Report Count (18),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x64,                     # .         Report ID (100),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0C,                     # .         Report Count (12),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x15,                     # .         Report ID (21),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0E,                     # .         Report Count (14),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x12,                     # .         Report ID (18),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x16,                     # .         Report ID (22),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0E,                     # .         Report Count (14),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x40,                     # .         Report ID (64),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x41,                     # .         Report ID (65),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x42,                     # .         Report ID (66),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x43,                     # .         Report ID (67),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0D,                     # .         Report Count (13),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x44,                     # .         Report ID (68),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3F,                     # .         Report Count (63),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x45,                     # .         Report ID (69),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x20,                     # .         Report Count (32),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x60,                     # .         Report ID (96),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3F,                     # .         Report Count (63),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x61,                     # .         Report ID (97),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3E,                     # .         Report Count (62),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x62,                     # .         Report ID (98),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3E,                     # .         Report Count (62),
    0xB1, 0x02,                     # .         Feature (Variable),
    0xC0,                           # .     End Collection,
    0x85, 0xD0,                     # .     Report ID (208),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x08, 0x00,               # .     Report Count (8),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD1,                     # .     Report ID (209),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x01,               # .     Report Count (260),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD2,                     # .     Report ID (210),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x01,               # .     Report Count (260),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD3,                     # .     Report ID (211),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD4,                     # .     Report ID (212),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD5,                     # .     Report ID (213),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD6,                     # .     Report ID (214),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD7,                     # .     Report ID (215),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x08, 0x00,               # .     Report Count (8),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD8,                     # .     Report ID (216),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x0C, 0x00,               # .     Report Count (12),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD9,                     # .     Report ID (217),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x00, 0x0A,               # .     Report Count (2560),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDA,                     # .     Report ID (218),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x04,               # .     Report Count (1028),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDB,                     # .     Report ID (219),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x06, 0x00,               # .     Report Count (6),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDC,                     # .     Report ID (220),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDD,                     # .     Report ID (221),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDE,                     # .     Report ID (222),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDF,                     # .     Report ID (223),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x22, 0x00,               # .     Report Count (34),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE0,                     # .     Report ID (224),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x01, 0x00,               # .     Report Count (1),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE1,                     # .     Report ID (225),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE2,                     # .     Report ID (226),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE3,                     # .     Report ID (227),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE4,                     # .     Report ID (228),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0xFF, 0x01,               # .     Report Count (511),
    0xB1, 0x02,                     # .     Feature (Variable),
    0xC0                            # . End Collection
]
# fmt: on

# Report ID (20), Usage (1014h), Report Count (13) -> 15
wacom_pth660_v150 = wacom_pth660_v145.copy()
wacom_pth660_v150[0x2CB] = 0x0F

# fmt: off
wacom_pth860_v145 = [
    0x05, 0x01,                     # . Usage Page (Desktop),
    0x09, 0x02,                     # . Usage (Mouse),
    0xA1, 0x01,                     # . Collection (Application),
    0x85, 0x01,                     # .     Report ID (1),
    0x09, 0x01,                     # .     Usage (Pointer),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x05, 0x09,                     # .         Usage Page (Button),
    0x19, 0x01,                     # .         Usage Minimum (01h),
    0x29, 0x03,                     # .         Usage Maximum (03h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x03,                     # .         Report Count (3),
    0x81, 0x02,                     # .         Input (Variable),
    0x95, 0x05,                     # .         Report Count (5),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x05, 0x01,                     # .         Usage Page (Desktop),
    0x09, 0x30,                     # .         Usage (X),
    0x09, 0x31,                     # .         Usage (Y),
    0x15, 0x80,                     # .         Logical Minimum (-128),
    0x25, 0x7F,                     # .         Logical Maximum (127),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x02,                     # .         Report Count (2),
    0x81, 0x06,                     # .         Input (Variable, Relative),
    0xC0,                           # .     End Collection,
    0xC0,                           # . End Collection,
    0x06, 0x0D, 0xFF,               # . Usage Page (FF0Dh),
    0x09, 0x01,                     # . Usage (01h),
    0xA1, 0x01,                     # . Collection (Application),
    0x85, 0x10,                     # .     Report ID (16),
    0x09, 0x20,                     # .     Usage (20h),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x09, 0x42,                     # .         Usage (42h),
    0x09, 0x44,                     # .         Usage (44h),
    0x09, 0x5A,                     # .         Usage (5Ah),
    0x09, 0x45,                     # .         Usage (45h),
    0x09, 0x3C,                     # .         Usage (3Ch),
    0x09, 0x32,                     # .         Usage (32h),
    0x09, 0x36,                     # .         Usage (36h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x07,                     # .         Report Count (7),
    0x81, 0x02,                     # .         Input (Variable),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x0A, 0x30, 0x01,               # .         Usage (0130h),
    0x65, 0x11,                     # .         Unit (Centimeter),
    0x55, 0x0D,                     # .         Unit Exponent (13),
    0x35, 0x00,                     # .         Physical Minimum (0),
    0x47, 0x7C, 0x79, 0x00, 0x00,   # .         Physical Maximum (31100),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x27, 0xF8, 0xF2, 0x00, 0x00,   # .         Logical Maximum (62200),
    0x75, 0x18,                     # .         Report Size (24),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x31, 0x01,               # .         Usage (0131h),
    0x47, 0x60, 0x54, 0x00, 0x00,   # .         Physical Maximum (21600),
    0x27, 0xC0, 0xA8, 0x00, 0x00,   # .         Logical Maximum (43200),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x30,                     # .         Usage (30h),                    # !!! Errata: Missing Physical Max = 0
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x65, 0x00,                     # .         Unit,
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x1F,               # .         Logical Maximum (8191),
    0x75, 0x10,                     # .         Report Size (16),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x3D,                     # .         Usage (3Dh),
    0x09, 0x3E,                     # .         Usage (3Eh),
    0x65, 0x14,                     # .         Unit (Degrees),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x35, 0xC0,                     # .         Physical Minimum (-64),
    0x45, 0x3F,                     # .         Physical Maximum (63),
    0x15, 0xC0,                     # .         Logical Minimum (-64),
    0x25, 0x3F,                     # .         Logical Maximum (63),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x02,                     # .         Report Count (2),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x41,                     # .         Usage (41h),
    0x65, 0x14,                     # .         Unit (Degrees),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x36, 0x4C, 0xFF,               # .         Physical Minimum (-180),
    0x46, 0xB3, 0x00,               # .         Physical Maximum (179),
    0x16, 0x7C, 0xFC,               # .         Logical Minimum (-900),
    0x26, 0x83, 0x03,               # .         Logical Maximum (899),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x0A,                     # .         Input (Variable, Wrap),
    0x0A, 0x03, 0x0D,               # .         Usage (0D03h),
    0x65, 0x00,                     # .         Unit,
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x07,               # .         Logical Maximum (2047),         # !!! Errata: Missing Physical Min/Max = 0
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x32, 0x01,               # .         Usage (0132h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x3F,                     # .         Logical Maximum (63),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x5B,                     # .         Usage (5Bh),
    0x09, 0x5C,                     # .         Usage (5Ch),
    0x17, 0x00, 0x00, 0x00, 0x80,   # .         Logical Minimum (-2147483648),
    0x27, 0xFF, 0xFF, 0xFF, 0x7F,   # .         Logical Maximum (2147483647),
    0x75, 0x20,                     # .         Report Size (32),
    0x95, 0x02,                     # .         Report Count (2),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x77,                     # .         Usage (77h),
    0x16, 0x00, 0x00,               # .         Logical Minimum (0),
    0x26, 0xFF, 0x0F,               # .         Logical Maximum (4095),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0xC0,                           # .     End Collection,
    0x85, 0x11,                     # .     Report ID (17),
    0x09, 0x39,                     # .     Usage (39h),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x1A, 0x10, 0x09,               # .         Usage Minimum (0910h),
    0x2A, 0x17, 0x09,               # .         Usage Maximum (0917h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x08,                     # .         Report Count (8),
    0x81, 0x02,                     # .         Input (Variable),
    0x1A, 0x40, 0x09,               # .         Usage Minimum (0940h),
    0x2A, 0x47, 0x09,               # .         Usage Maximum (0947h),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x95, 0x09,               # .         Usage (0995h),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x95, 0x07,                     # .         Report Count (7),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x0A, 0x38, 0x01,               # .         Usage (0138h),
    0x65, 0x14,                     # .         Unit (Degrees),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x35, 0x00,                     # .         Physical Minimum (0),
    0x46, 0x67, 0x01,               # .         Physical Maximum (359),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x47,                     # .         Logical Maximum (71),
    0x75, 0x07,                     # .         Report Size (7),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x0A,                     # .         Input (Variable, Wrap),
    0x0A, 0x39, 0x01,               # .         Usage (0139h),
    0x65, 0x00,                     # .         Unit,
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x25, 0x01,                     # .         Logical Maximum (1),            # !!! Errata: Missing Physical Max = 0
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x04,                     # .         Report Count (4),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0xC0,                           # .     End Collection,
    0x85, 0x13,                     # .     Report ID (19),
    0x0A, 0x13, 0x10,               # .     Usage (1013h),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x0A, 0x3B, 0x04,               # .         Usage (043Bh),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x64,                     # .         Logical Maximum (100),
    0x75, 0x07,                     # .         Report Size (7),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x04, 0x04,               # .         Usage (0404h),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x52, 0x04,               # .         Usage (0452h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x95, 0x06,                     # .         Report Count (6),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x0A, 0x54, 0x04,               # .         Usage (0454h),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x06,                     # .         Report Count (6),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0xC0,                           # .     End Collection,
    0x09, 0x0E,                     # .     Usage (0Eh),
    0xA1, 0x02,                     # .     Collection (Logical),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x85, 0x02,                     # .         Report ID (2),
    0x09, 0x01,                     # .         Usage (01h),
    0x75, 0x08,                     # .         Report Size (8),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x03,                     # .         Report ID (3),
    0x0A, 0x03, 0x10,               # .         Usage (1003h),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x04,                     # .         Report ID (4),
    0x0A, 0x04, 0x10,               # .         Usage (1004h),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x07,                     # .         Report ID (7),
    0x0A, 0x09, 0x10,               # .         Usage (1009h),
    0x25, 0x02,                     # .         Logical Maximum (2),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x03,                     # .         Feature (Constant, Variable),
    0x0A, 0x07, 0x10,               # .         Usage (1007h),
    0x09, 0x00,                     # .         Usage (00h),
    0x0A, 0x08, 0x10,               # .         Usage (1008h),
    0x09, 0x00,                     # .         Usage (00h),
    0x09, 0x00,                     # .         Usage (00h),
    0x09, 0x00,                     # .         Usage (00h),
    0x27, 0xFF, 0xFF, 0x00, 0x00,   # .         Logical Maximum (65535),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x06,                     # .         Report Count (6),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x03,                     # .         Feature (Constant, Variable),
    0x85, 0x0C,                     # .         Report ID (12),
    0x0A, 0x30, 0x0D,               # .         Usage (0D30h),
    0x0A, 0x31, 0x0D,               # .         Usage (0D31h),
    0x0A, 0x32, 0x0D,               # .         Usage (0D32h),
    0x0A, 0x33, 0x0D,               # .         Usage (0D33h),                  # !!! Errata: Missing Non-zero Physical Max
    0x65, 0x11,                     # .         Unit (Centimeter),
    0x55, 0x0D,                     # .         Unit Exponent (13),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x03,                     # .         Feature (Constant, Variable),
    0x85, 0x0D,                     # .         Report ID (13),
    0x65, 0x00,                     # .         Unit,
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x0A, 0x0D, 0x10,               # .         Usage (100Dh),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x14,                     # .         Report ID (20),
    0x0A, 0x14, 0x10,               # .         Usage (1014h),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x0D,                     # .         Report Count (13),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x31,                     # .         Report ID (49),
    0x0A, 0x31, 0x10,               # .         Usage (1031h),
    0x25, 0x64,                     # .         Logical Maximum (100),
    0x95, 0x05,                     # .         Report Count (5),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x32,                     # .         Report ID (50),
    0x0A, 0x31, 0x10,               # .         Usage (1031h),
    0x25, 0x64,                     # .         Logical Maximum (100),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x0A, 0x32, 0x10,               # .         Usage (1032h),
    0x25, 0x03,                     # .         Logical Maximum (3),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x34,                     # .         Report ID (52),
    0x0A, 0x34, 0x10,               # .         Usage (1034h),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x35,                     # .         Report ID (53),
    0x0A, 0x35, 0x10,               # .         Usage (1035h),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x0A,                     # .         Report Count (10),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x36,                     # .         Report ID (54),
    0x0A, 0x35, 0x10,               # .         Usage (1035h),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x96, 0x01, 0x01,               # .         Report Count (257),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0xCC,                     # .         Report ID (204),
    0x0A, 0xCC, 0x10,               # .         Usage (10CCh),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x02,                     # .         Report Count (2),
    0xB1, 0x02,                     # .         Feature (Variable),
    0xC0,                           # .     End Collection,
    0x0A, 0xAC, 0x10,               # .     Usage (10ACh),
    0xA1, 0x02,                     # .     Collection (Logical),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x75, 0x08,                     # .         Report Size (8),
    0x85, 0xAC,                     # .         Report ID (172),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0xBF,                     # .         Report Count (191),
    0x81, 0x02,                     # .         Input (Variable),
    0x85, 0x33,                     # .         Report ID (51),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x12,                     # .         Report Count (18),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x64,                     # .         Report ID (100),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0C,                     # .         Report Count (12),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x15,                     # .         Report ID (21),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0E,                     # .         Report Count (14),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x12,                     # .         Report ID (18),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x16,                     # .         Report ID (22),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0E,                     # .         Report Count (14),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x40,                     # .         Report ID (64),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x41,                     # .         Report ID (65),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x42,                     # .         Report ID (66),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x43,                     # .         Report ID (67),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0D,                     # .         Report Count (13),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x44,                     # .         Report ID (68),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3F,                     # .         Report Count (63),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x45,                     # .         Report ID (69),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x20,                     # .         Report Count (32),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x60,                     # .         Report ID (96),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3F,                     # .         Report Count (63),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x61,                     # .         Report ID (97),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3E,                     # .         Report Count (62),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x62,                     # .         Report ID (98),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3E,                     # .         Report Count (62),
    0xB1, 0x02,                     # .         Feature (Variable),
    0xC0,                           # .     End Collection,
    0x85, 0xD0,                     # .     Report ID (208),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x08, 0x00,               # .     Report Count (8),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD1,                     # .     Report ID (209),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x01,               # .     Report Count (260),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD2,                     # .     Report ID (210),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x01,               # .     Report Count (260),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD3,                     # .     Report ID (211),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD4,                     # .     Report ID (212),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD5,                     # .     Report ID (213),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD6,                     # .     Report ID (214),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD7,                     # .     Report ID (215),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x08, 0x00,               # .     Report Count (8),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD8,                     # .     Report ID (216),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x0C, 0x00,               # .     Report Count (12),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD9,                     # .     Report ID (217),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x00, 0x0A,               # .     Report Count (2560),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDA,                     # .     Report ID (218),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x04,               # .     Report Count (1028),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDB,                     # .     Report ID (219),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x06, 0x00,               # .     Report Count (6),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDC,                     # .     Report ID (220),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDD,                     # .     Report ID (221),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDE,                     # .     Report ID (222),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDF,                     # .     Report ID (223),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x22, 0x00,               # .     Report Count (34),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE0,                     # .     Report ID (224),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x01, 0x00,               # .     Report Count (1),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE1,                     # .     Report ID (225),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE2,                     # .     Report ID (226),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE3,                     # .     Report ID (227),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE4,                     # .     Report ID (228),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0xFF, 0x01,               # .     Report Count (511),
    0xB1, 0x02,                     # .     Feature (Variable),
    0xC0                            # . End Collection
]
# fmt: on

# Report ID (20), Usage (1014h), Report Count (13) -> 15
wacom_pth860_v150 = wacom_pth860_v145.copy()
wacom_pth860_v150[0x2CA] = 0x0F

# fmt: off
wacom_pth460_v105 = [
    0x06, 0x0D, 0xFF,               # . Usage Page (FF0Dh),
    0x09, 0x01,                     # . Usage (01h),
    0xA1, 0x01,                     # . Collection (Application),
    0x85, 0x10,                     # .     Report ID (16),
    0x09, 0x20,                     # .     Usage (20h),
    0x35, 0x00,                     # .     Physical Minimum (0),
    0x45, 0x00,                     # .     Physical Maximum (0),
    0x15, 0x00,                     # .     Logical Minimum (0),
    0x25, 0x01,                     # .     Logical Maximum (1),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x09, 0x42,                     # .         Usage (42h),
    0x09, 0x44,                     # .         Usage (44h),
    0x09, 0x5A,                     # .         Usage (5Ah),
    0x09, 0x45,                     # .         Usage (45h),
    0x09, 0x3C,                     # .         Usage (3Ch),
    0x09, 0x32,                     # .         Usage (32h),
    0x09, 0x36,                     # .         Usage (36h),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x01,                     # .         Report Size (1),
    0x95, 0x07,                     # .         Report Count (7),
    0x81, 0x02,                     # .         Input (Variable),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x0A, 0x30, 0x01,               # .         Usage (0130h),
    0x65, 0x11,                     # .         Unit (Centimeter),
    0x55, 0x0D,                     # .         Unit Exponent (13),
    0x47, 0x58, 0x3E, 0x00, 0x00,   # .         Physical Maximum (15960),
    0x27, 0xB0, 0x7C, 0x00, 0x00,   # .         Logical Maximum (31920),
    0x75, 0x18,                     # .         Report Size (24),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x31, 0x01,               # .         Usage (0131h),
    0x47, 0xF7, 0x26, 0x00, 0x00,   # .         Physical Maximum (9975),
    0x27, 0xEE, 0x4D, 0x00, 0x00,   # .         Logical Maximum (19950),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x30,                     # .         Usage (30h),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x65, 0x00,                     # .         Unit,
    0x26, 0xFF, 0x1F,               # .         Logical Maximum (8191),         # !!! Errata: Missing Physical Max = 0
    0x75, 0x10,                     # .         Report Size (16),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x3D,                     # .         Usage (3Dh),
    0x09, 0x3E,                     # .         Usage (3Eh),
    0x65, 0x14,                     # .         Unit (Degrees),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x35, 0xC0,                     # .         Physical Minimum (-64),
    0x45, 0x3F,                     # .         Physical Maximum (63),
    0x15, 0xC0,                     # .         Logical Minimum (-64),
    0x25, 0x3F,                     # .         Logical Maximum (63),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x02,                     # .         Report Count (2),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x41,                     # .         Usage (41h),
    0x65, 0x14,                     # .         Unit (Degrees),
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x36, 0x4C, 0xFF,               # .         Physical Minimum (-180),
    0x46, 0xB3, 0x00,               # .         Physical Maximum (179),
    0x16, 0x7C, 0xFC,               # .         Logical Minimum (-900),
    0x26, 0x83, 0x03,               # .         Logical Maximum (899),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x0A,                     # .         Input (Variable, Wrap),
    0x0A, 0x03, 0x0D,               # .         Usage (0D03h),
    0x65, 0x00,                     # .         Unit,
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x35, 0x00,                     # .         Physical Minimum (0),
    0x45, 0x00,                     # .         Physical Maximum (0),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x07,               # .         Logical Maximum (2047),
    0x81, 0x02,                     # .         Input (Variable),
    0x0A, 0x32, 0x01,               # .         Usage (0132h),
    0x25, 0x3F,                     # .         Logical Maximum (63),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x5B,                     # .         Usage (5Bh),
    0x09, 0x5C,                     # .         Usage (5Ch),
    0x17, 0x00, 0x00, 0x00, 0x80,   # .         Logical Minimum (-2147483648),
    0x27, 0xFF, 0xFF, 0xFF, 0x7F,   # .         Logical Maximum (2147483647),
    0x75, 0x20,                     # .         Report Size (32),
    0x95, 0x02,                     # .         Report Count (2),
    0x81, 0x02,                     # .         Input (Variable),
    0x09, 0x77,                     # .         Usage (77h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x0F,               # .         Logical Maximum (4095),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x02,                     # .         Input (Variable),
    0xC0,                           # .     End Collection,
    0x85, 0x11,                     # .     Report ID (17),
    0x65, 0x00,                     # .     Unit,
    0x55, 0x00,                     # .     Unit Exponent (0),
    0x35, 0x00,                     # .     Physical Minimum (0),
    0x45, 0x00,                     # .     Physical Maximum (0),
    0x09, 0x39,                     # .     Usage (39h),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x09, 0x39,                     # .         Usage (39h),
    0xA1, 0x00,                     # .         Collection (Physical),
    0x35, 0x00,                     # .             Physical Minimum (0),
    0x45, 0x00,                     # .             Physical Maximum (0),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x1A, 0x10, 0x09,               # .             Usage Minimum (0910h),
    0x2A, 0x15, 0x09,               # .             Usage Maximum (0915h),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x25, 0x01,                     # .             Logical Maximum (1),
    0x75, 0x01,                     # .             Report Size (1),
    0x95, 0x06,                     # .             Report Count (6),
    0x81, 0x02,                     # .             Input (Variable),
    0x95, 0x02,                     # .             Report Count (2),
    0x81, 0x03,                     # .             Input (Constant, Variable),
    0xC0,                           # .         End Collection,
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0x09, 0x39,                     # .         Usage (39h),
    0xA1, 0x00,                     # .         Collection (Physical),
    0x35, 0x00,                     # .             Physical Minimum (0),
    0x45, 0x00,                     # .             Physical Maximum (0),
    0x0A, 0x95, 0x09,               # .             Usage (0995h),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x25, 0x01,                     # .             Logical Maximum (1),
    0x75, 0x01,                     # .             Report Size (1),
    0x95, 0x01,                     # .             Report Count (1),
    0x81, 0x02,                     # .             Input (Variable),
    0x95, 0x07,                     # .             Report Count (7),
    0x81, 0x03,                     # .             Input (Constant, Variable),
    0xC0,                           # .         End Collection,
    0x09, 0x39,                     # .         Usage (39h),
    0xA1, 0x00,                     # .         Collection (Physical),
    0x35, 0x00,                     # .             Physical Minimum (0),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x0A, 0x38, 0x01,               # .             Usage (0138h),
    0x65, 0x14,                     # .             Unit (Degrees),
    0x55, 0x00,                     # .             Unit Exponent (0),
    0x35, 0x00,                     # .             Physical Minimum (0),
    0x46, 0x67, 0x01,               # .             Physical Maximum (359),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x25, 0x47,                     # .             Logical Maximum (71),
    0x75, 0x07,                     # .             Report Size (7),
    0x95, 0x01,                     # .             Report Count (1),
    0x81, 0x4A,                     # .             Input (Variable, Wrap, Null State),
    0x0A, 0x39, 0x01,               # .             Usage (0139h),
    0x65, 0x00,                     # .             Unit,
    0x55, 0x00,                     # .             Unit Exponent (0),
    0x45, 0x00,                     # .             Physical Maximum (0),
    0x25, 0x01,                     # .             Logical Maximum (1),
    0x75, 0x01,                     # .             Report Size (1),
    0x95, 0x01,                     # .             Report Count (1),
    0x81, 0x02,                     # .             Input (Variable),
    0xC0,                           # .         End Collection,
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x04,                     # .         Report Count (4),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0xC0,                           # .     End Collection,
    0x85, 0x13,                     # .     Report ID (19),
    0x65, 0x00,                     # .     Unit,
    0x55, 0x00,                     # .     Unit Exponent (0),
    0x35, 0x00,                     # .     Physical Minimum (0),
    0x45, 0x00,                     # .     Physical Maximum (0),
    0x0A, 0x13, 0x10,               # .     Usage (1013h),
    0xA1, 0x00,                     # .     Collection (Physical),
    0x0A, 0x13, 0x10,               # .         Usage (1013h),
    0xA1, 0x00,                     # .         Collection (Physical),
    0x35, 0x00,                     # .             Physical Minimum (0),
    0x45, 0x00,                     # .             Physical Maximum (0),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x0A, 0x3B, 0x04,               # .             Usage (043Bh),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x25, 0x64,                     # .             Logical Maximum (100),
    0x75, 0x07,                     # .             Report Size (7),
    0x95, 0x01,                     # .             Report Count (1),
    0x81, 0x02,                     # .             Input (Variable),
    0x0A, 0x04, 0x04,               # .             Usage (0404h),
    0x25, 0x01,                     # .             Logical Maximum (1),
    0x75, 0x01,                     # .             Report Size (1),
    0x81, 0x02,                     # .             Input (Variable),
    0xC0,                           # .         End Collection,
    0x0A, 0x13, 0x10,               # .         Usage (1013h),
    0xA1, 0x00,                     # .         Collection (Physical),
    0x35, 0x00,                     # .             Physical Minimum (0),
    0x45, 0x00,                     # .             Physical Maximum (0),
    0x0A, 0x52, 0x04,               # .             Usage (0452h),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x25, 0x01,                     # .             Logical Maximum (1),
    0x75, 0x01,                     # .             Report Size (1),
    0x95, 0x01,                     # .             Report Count (1),
    0x81, 0x02,                     # .             Input (Variable),
    0x0A, 0x41, 0x04,               # .             Usage (0441h),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x25, 0x07,                     # .             Logical Maximum (7),
    0x75, 0x03,                     # .             Report Size (3),
    0x95, 0x02,                     # .             Report Count (2),
    0x81, 0x02,                     # .             Input (Variable),
    0x0A, 0x54, 0x04,               # .             Usage (0454h),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x25, 0x01,                     # .             Logical Maximum (1),
    0x75, 0x01,                     # .             Report Size (1),
    0x95, 0x01,                     # .             Report Count (1),
    0x81, 0x02,                     # .             Input (Variable),
    0xC0,                           # .         End Collection,
    0x0A, 0x13, 0x10,               # .         Usage (1013h),
    0xA1, 0x00,                     # .         Collection (Physical),
    0x35, 0x00,                     # .             Physical Minimum (0),
    0x45, 0x00,                     # .             Physical Maximum (0),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x0A, 0x3C, 0x04,               # .             Usage (043Ch),
    0x55, 0x00,                     # .             Unit Exponent (0),
    0x65, 0x00,                     # .             Unit,
    0x15, 0xFB,                     # .             Logical Minimum (-5),
    0x25, 0x32,                     # .             Logical Maximum (50),
    0x75, 0x08,                     # .             Report Size (8),
    0x95, 0x01,                     # .             Report Count (1),
    0x81, 0x02,                     # .             Input (Variable),
    0xC0,                           # .         End Collection,
    0x0A, 0x13, 0x10,               # .         Usage (1013h),
    0xA1, 0x00,                     # .         Collection (Physical),
    0x35, 0x00,                     # .             Physical Minimum (0),
    0x45, 0x00,                     # .             Physical Maximum (0),
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x0A, 0x3D, 0x04,               # .             Usage (043Dh),
    0x55, 0x00,                     # .             Unit Exponent (0),
    0x65, 0x00,                     # .             Unit,
    0x15, 0x00,                     # .             Logical Minimum (0),
    0x26, 0xFF, 0x0F,               # .             Logical Maximum (4095),
    0x75, 0x10,                     # .             Report Size (16),
    0x95, 0x01,                     # .             Report Count (1),
    0x81, 0x02,                     # .             Input (Variable),
    0xC0,                           # .         End Collection,
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x03,                     # .         Report Count (3),
    0x81, 0x03,                     # .         Input (Constant, Variable),
    0xC0,                           # .     End Collection,
    0x09, 0x0E,                     # .     Usage (0Eh),
    0xA1, 0x02,                     # .     Collection (Logical),
    0x85, 0x02,                     # .         Report ID (2),
    0x0A, 0x02, 0x10,               # .         Usage (1002h),
    0x15, 0x02,                     # .         Logical Minimum (2),
    0x25, 0x02,                     # .         Logical Maximum (2),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x03,                     # .         Report ID (3),
    0x0A, 0x03, 0x10,               # .         Usage (1003h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x04,                     # .         Report ID (4),
    0x0A, 0x04, 0x10,               # .         Usage (1004h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x07,                     # .         Report ID (7),
    0x0A, 0x09, 0x10,               # .         Usage (1009h),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0xB1, 0x03,                     # .         Feature (Constant, Variable),
    0x0A, 0x07, 0x10,               # .         Usage (1007h),
    0x09, 0x00,                     # .         Usage (00h),
    0x0A, 0x08, 0x10,               # .         Usage (1008h),
    0x09, 0x00,                     # .         Usage (00h),
    0x09, 0x00,                     # .         Usage (00h),
    0x09, 0x00,                     # .         Usage (00h),
    0x27, 0xFF, 0xFF, 0x00, 0x00,   # .         Logical Maximum (65535),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x06,                     # .         Report Count (6),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x09, 0x00,                     # .         Usage (00h),
    0x25, 0x00,                     # .         Logical Maximum (0),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x03,                     # .         Feature (Constant, Variable),
    0x85, 0x0C,                     # .         Report ID (12),
    0x0A, 0x30, 0x0D,               # .         Usage (0D30h),
    0x0A, 0x31, 0x0D,               # .         Usage (0D31h),
    0x0A, 0x32, 0x0D,               # .         Usage (0D32h),
    0x0A, 0x33, 0x0D,               # .         Usage (0D33h),
    0x65, 0x11,                     # .         Unit (Centimeter),
    0x55, 0x0D,                     # .         Unit Exponent (13),
    0x35, 0x00,                     # .         Physical Minimum (0),
    0x46, 0xC8, 0x00,               # .         Physical Maximum (200),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0x90, 0x01,               # .         Logical Maximum (400),
    0x75, 0x10,                     # .         Report Size (16),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x0D,                     # .         Report ID (13),
    0x0A, 0x0D, 0x10,               # .         Usage (100Dh),
    0x65, 0x00,                     # .         Unit,
    0x55, 0x00,                     # .         Unit Exponent (0),
    0x45, 0x00,                     # .         Physical Maximum (0),
    0x25, 0x01,                     # .         Logical Maximum (1),
    0x75, 0x08,                     # .         Report Size (8),
    0x95, 0x01,                     # .         Report Count (1),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x14,                     # .         Report ID (20),
    0x0A, 0x14, 0x10,               # .         Usage (1014h),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x95, 0x0D,                     # .         Report Count (13),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0xCC,                     # .         Report ID (204),
    0x0A, 0xCC, 0x10,               # .         Usage (10CCh),
    0x95, 0x02,                     # .         Report Count (2),
    0xB1, 0x02,                     # .         Feature (Variable),
    0xC0,                           # .     End Collection,
    0x09, 0x0E,                     # .     Usage (0Eh),
    0xA1, 0x02,                     # .     Collection (Logical),
    0x85, 0x31,                     # .         Report ID (49),
    0x0A, 0x31, 0x10,               # .         Usage (1031h),
    0x25, 0x64,                     # .         Logical Maximum (100),
    0x95, 0x03,                     # .         Report Count (3),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x95, 0x02,                     # .         Report Count (2),
    0xB1, 0x03,                     # .         Feature (Constant, Variable),
    0xC0,                           # .     End Collection,
    0x0A, 0xAC, 0x10,               # .     Usage (10ACh),
    0xA1, 0x02,                     # .     Collection (Logical),
    0x15, 0x00,                     # .         Logical Minimum (0),
    0x26, 0xFF, 0x00,               # .         Logical Maximum (255),
    0x75, 0x08,                     # .         Report Size (8),
    0x85, 0xAC,                     # .         Report ID (172),
    0x09, 0x00,                     # .         Usage (00h),
    0x96, 0xBF, 0x00,               # .         Report Count (191),
    0x81, 0x02,                     # .         Input (Variable),
    0x85, 0x15,                     # .         Report ID (21),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0E,                     # .         Report Count (14),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x33,                     # .         Report ID (51),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x12,                     # .         Report Count (18),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x44,                     # .         Report ID (68),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x45,                     # .         Report ID (69),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x20,                     # .         Report Count (32),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x60,                     # .         Report ID (96),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3F,                     # .         Report Count (63),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x61,                     # .         Report ID (97),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3E,                     # .         Report Count (62),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x62,                     # .         Report ID (98),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3E,                     # .         Report Count (62),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x65,                     # .         Report ID (101),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x66,                     # .         Report ID (102),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x67,                     # .         Report ID (103),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x04,                     # .         Report Count (4),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x68,                     # .         Report ID (104),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x11,                     # .         Report Count (17),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x6F,                     # .         Report ID (111),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x3E,                     # .         Report Count (62),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0xCD,                     # .         Report ID (205),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x02,                     # .         Report Count (2),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x16,                     # .         Report ID (22),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0E,                     # .         Report Count (14),
    0xB1, 0x02,                     # .         Feature (Variable),
    0x85, 0x35,                     # .         Report ID (53),
    0x09, 0x00,                     # .         Usage (00h),
    0x95, 0x0A,                     # .         Report Count (10),
    0xB1, 0x02,                     # .         Feature (Variable),
    0xC0,                           # .     End Collection,
    0x85, 0xD1,                     # .     Report ID (209),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x01,               # .     Report Count (260),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD2,                     # .     Report ID (210),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x01,               # .     Report Count (260),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD3,                     # .     Report ID (211),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD4,                     # .     Report ID (212),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD5,                     # .     Report ID (213),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD6,                     # .     Report ID (214),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD7,                     # .     Report ID (215),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x08, 0x00,               # .     Report Count (8),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD8,                     # .     Report ID (216),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x0C, 0x00,               # .     Report Count (12),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xD9,                     # .     Report ID (217),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x00, 0x0A,               # .     Report Count (2560),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDA,                     # .     Report ID (218),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x04,               # .     Report Count (1028),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDB,                     # .     Report ID (219),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x06, 0x00,               # .     Report Count (6),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDC,                     # .     Report ID (220),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDD,                     # .     Report ID (221),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDE,                     # .     Report ID (222),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x04, 0x00,               # .     Report Count (4),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xDF,                     # .     Report ID (223),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x22, 0x00,               # .     Report Count (34),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE0,                     # .     Report ID (224),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x01, 0x00,               # .     Report Count (1),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE1,                     # .     Report ID (225),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE2,                     # .     Report ID (226),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE3,                     # .     Report ID (227),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x02, 0x00,               # .     Report Count (2),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xE4,                     # .     Report ID (228),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0xFF, 0x01,               # .     Report Count (511),
    0xB1, 0x02,                     # .     Feature (Variable),
    0x85, 0xCB,                     # .     Report ID (203),
    0x09, 0x01,                     # .     Usage (01h),
    0x96, 0x1F, 0x00,               # .     Report Count (31),
    0xB1, 0x02,                     # .     Feature (Variable),
    0xC0                            # . End Collection
]
# fmt: on
