// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2016 Freescale Semiconductor, Inc.
 * Copyright 2017-2018 NXP
 * Copyright (C) 2018 Pengutronix, Lucas Stach <kernel@pengutronix.de>
 */

#include <linux/err.h>
#include <linux/init.h>
#include <linux/io.h>
#include <linux/module.h>
#include <linux/of.h>
#include <linux/of_device.h>
#include <linux/pinctrl/pinctrl.h>

#include "pinctrl-imx.h"

enum imx8mq_pads {
	MX8MQ_PAD_RESERVE0 = 0,
	MX8MQ_PAD_RESERVE1 = 1,
	MX8MQ_PAD_RESERVE2 = 2,
	MX8MQ_PAD_RESERVE3 = 3,
	MX8MQ_PAD_RESERVE4 = 4,
	MX8MQ_IOMUXC_PMIC_STBY_REQ_CCMSRCGPCMIX = 5,
	MX8MQ_IOMUXC_PMIC_ON_REQ_SNVSMIX = 6,
	MX8MQ_IOMUXC_ONOFF_SNVSMIX = 7,
	MX8MQ_IOMUXC_POR_B_SNVSMIX = 8,
	MX8MQ_IOMUXC_RTC_RESET_B_SNVSMIX = 9,
	MX8MQ_IOMUXC_GPIO1_IO00 = 10,
	MX8MQ_IOMUXC_GPIO1_IO01 = 11,
	MX8MQ_IOMUXC_GPIO1_IO02 = 12,
	MX8MQ_IOMUXC_GPIO1_IO03 = 13,
	MX8MQ_IOMUXC_GPIO1_IO04 = 14,
	MX8MQ_IOMUXC_GPIO1_IO05 = 15,
	MX8MQ_IOMUXC_GPIO1_IO06 = 16,
	MX8MQ_IOMUXC_GPIO1_IO07 = 17,
	MX8MQ_IOMUXC_GPIO1_IO08 = 18,
	MX8MQ_IOMUXC_GPIO1_IO09 = 19,
	MX8MQ_IOMUXC_GPIO1_IO10 = 20,
	MX8MQ_IOMUXC_GPIO1_IO11 = 21,
	MX8MQ_IOMUXC_GPIO1_IO12 = 22,
	MX8MQ_IOMUXC_GPIO1_IO13 = 23,
	MX8MQ_IOMUXC_GPIO1_IO14 = 24,
	MX8MQ_IOMUXC_GPIO1_IO15 = 25,
	MX8MQ_IOMUXC_ENET_MDC = 26,
	MX8MQ_IOMUXC_ENET_MDIO = 27,
	MX8MQ_IOMUXC_ENET_TD3 = 28,
	MX8MQ_IOMUXC_ENET_TD2 = 29,
	MX8MQ_IOMUXC_ENET_TD1 = 30,
	MX8MQ_IOMUXC_ENET_TD0 = 31,
	MX8MQ_IOMUXC_ENET_TX_CTL = 32,
	MX8MQ_IOMUXC_ENET_TXC = 33,
	MX8MQ_IOMUXC_ENET_RX_CTL = 34,
	MX8MQ_IOMUXC_ENET_RXC = 35,
	MX8MQ_IOMUXC_ENET_RD0 = 36,
	MX8MQ_IOMUXC_ENET_RD1 = 37,
	MX8MQ_IOMUXC_ENET_RD2 = 38,
	MX8MQ_IOMUXC_ENET_RD3 = 39,
	MX8MQ_IOMUXC_SD1_CLK = 40,
	MX8MQ_IOMUXC_SD1_CMD = 41,
	MX8MQ_IOMUXC_SD1_DATA0 = 42,
	MX8MQ_IOMUXC_SD1_DATA1 = 43,
	MX8MQ_IOMUXC_SD1_DATA2 = 44,
	MX8MQ_IOMUXC_SD1_DATA3 = 45,
	MX8MQ_IOMUXC_SD1_DATA4 = 46,
	MX8MQ_IOMUXC_SD1_DATA5 = 47,
	MX8MQ_IOMUXC_SD1_DATA6 = 48,
	MX8MQ_IOMUXC_SD1_DATA7 = 49,
	MX8MQ_IOMUXC_SD1_RESET_B = 50,
	MX8MQ_IOMUXC_SD1_STROBE = 51,
	MX8MQ_IOMUXC_SD2_CD_B = 52,
	MX8MQ_IOMUXC_SD2_CLK = 53,
	MX8MQ_IOMUXC_SD2_CMD = 54,
	MX8MQ_IOMUXC_SD2_DATA0 = 55,
	MX8MQ_IOMUXC_SD2_DATA1 = 56,
	MX8MQ_IOMUXC_SD2_DATA2 = 57,
	MX8MQ_IOMUXC_SD2_DATA3 = 58,
	MX8MQ_IOMUXC_SD2_RESET_B = 59,
	MX8MQ_IOMUXC_SD2_WP = 60,
	MX8MQ_IOMUXC_NAND_ALE = 61,
	MX8MQ_IOMUXC_NAND_CE0_B = 62,
	MX8MQ_IOMUXC_NAND_CE1_B = 63,
	MX8MQ_IOMUXC_NAND_CE2_B = 64,
	MX8MQ_IOMUXC_NAND_CE3_B = 65,
	MX8MQ_IOMUXC_NAND_CLE = 66,
	MX8MQ_IOMUXC_NAND_DATA00 = 67,
	MX8MQ_IOMUXC_NAND_DATA01 = 68,
	MX8MQ_IOMUXC_NAND_DATA02 = 69,
	MX8MQ_IOMUXC_NAND_DATA03 = 70,
	MX8MQ_IOMUXC_NAND_DATA04 = 71,
	MX8MQ_IOMUXC_NAND_DATA05 = 72,
	MX8MQ_IOMUXC_NAND_DATA06 = 73,
	MX8MQ_IOMUXC_NAND_DATA07 = 74,
	MX8MQ_IOMUXC_NAND_DQS = 75,
	MX8MQ_IOMUXC_NAND_RE_B = 76,
	MX8MQ_IOMUXC_NAND_READY_B = 77,
	MX8MQ_IOMUXC_NAND_WE_B = 78,
	MX8MQ_IOMUXC_NAND_WP_B = 79,
	MX8MQ_IOMUXC_SAI5_RXFS = 80,
	MX8MQ_IOMUXC_SAI5_RXC = 81,
	MX8MQ_IOMUXC_SAI5_RXD0 = 82,
	MX8MQ_IOMUXC_SAI5_RXD1 = 83,
	MX8MQ_IOMUXC_SAI5_RXD2 = 84,
	MX8MQ_IOMUXC_SAI5_RXD3 = 85,
	MX8MQ_IOMUXC_SAI5_MCLK = 86,
	MX8MQ_IOMUXC_SAI1_RXFS = 87,
	MX8MQ_IOMUXC_SAI1_RXC = 88,
	MX8MQ_IOMUXC_SAI1_RXD0 = 89,
	MX8MQ_IOMUXC_SAI1_RXD1 = 90,
	MX8MQ_IOMUXC_SAI1_RXD2 = 91,
	MX8MQ_IOMUXC_SAI1_RXD3 = 92,
	MX8MQ_IOMUXC_SAI1_RXD4 = 93,
	MX8MQ_IOMUXC_SAI1_RXD5 = 94,
	MX8MQ_IOMUXC_SAI1_RXD6 = 95,
	MX8MQ_IOMUXC_SAI1_RXD7 = 96,
	MX8MQ_IOMUXC_SAI1_TXFS = 97,
	MX8MQ_IOMUXC_SAI1_TXC = 98,
	MX8MQ_IOMUXC_SAI1_TXD0 = 99,
	MX8MQ_IOMUXC_SAI1_TXD1 = 100,
	MX8MQ_IOMUXC_SAI1_TXD2 = 101,
	MX8MQ_IOMUXC_SAI1_TXD3 = 102,
	MX8MQ_IOMUXC_SAI1_TXD4 = 103,
	MX8MQ_IOMUXC_SAI1_TXD5 = 104,
	MX8MQ_IOMUXC_SAI1_TXD6 = 105,
	MX8MQ_IOMUXC_SAI1_TXD7 = 106,
	MX8MQ_IOMUXC_SAI1_MCLK = 107,
	MX8MQ_IOMUXC_SAI2_RXFS = 108,
	MX8MQ_IOMUXC_SAI2_RXC = 109,
	MX8MQ_IOMUXC_SAI2_RXD0 = 110,
	MX8MQ_IOMUXC_SAI2_TXFS = 111,
	MX8MQ_IOMUXC_SAI2_TXC = 112,
	MX8MQ_IOMUXC_SAI2_TXD0 = 113,
	MX8MQ_IOMUXC_SAI2_MCLK = 114,
	MX8MQ_IOMUXC_SAI3_RXFS = 115,
	MX8MQ_IOMUXC_SAI3_RXC = 116,
	MX8MQ_IOMUXC_SAI3_RXD = 117,
	MX8MQ_IOMUXC_SAI3_TXFS = 118,
	MX8MQ_IOMUXC_SAI3_TXC = 119,
	MX8MQ_IOMUXC_SAI3_TXD = 120,
	MX8MQ_IOMUXC_SAI3_MCLK = 121,
	MX8MQ_IOMUXC_SPDIF_TX = 122,
	MX8MQ_IOMUXC_SPDIF_RX = 123,
	MX8MQ_IOMUXC_SPDIF_EXT_CLK = 124,
	MX8MQ_IOMUXC_ECSPI1_SCLK = 125,
	MX8MQ_IOMUXC_ECSPI1_MOSI = 126,
	MX8MQ_IOMUXC_ECSPI1_MISO = 127,
	MX8MQ_IOMUXC_ECSPI1_SS0 = 128,
	MX8MQ_IOMUXC_ECSPI2_SCLK = 129,
	MX8MQ_IOMUXC_ECSPI2_MOSI = 130,
	MX8MQ_IOMUXC_ECSPI2_MISO = 131,
	MX8MQ_IOMUXC_ECSPI2_SS0 = 132,
	MX8MQ_IOMUXC_I2C1_SCL = 133,
	MX8MQ_IOMUXC_I2C1_SDA = 134,
	MX8MQ_IOMUXC_I2C2_SCL = 135,
	MX8MQ_IOMUXC_I2C2_SDA = 136,
	MX8MQ_IOMUXC_I2C3_SCL = 137,
	MX8MQ_IOMUXC_I2C3_SDA = 138,
	MX8MQ_IOMUXC_I2C4_SCL = 139,
	MX8MQ_IOMUXC_I2C4_SDA = 140,
	MX8MQ_IOMUXC_UART1_RXD = 141,
	MX8MQ_IOMUXC_UART1_TXD = 142,
	MX8MQ_IOMUXC_UART2_RXD = 143,
	MX8MQ_IOMUXC_UART2_TXD = 144,
	MX8MQ_IOMUXC_UART3_RXD = 145,
	MX8MQ_IOMUXC_UART3_TXD = 146,
	MX8MQ_IOMUXC_UART4_RXD = 147,
	MX8MQ_IOMUXC_UART4_TXD = 148,
};

/* Pad names for the pinmux subsystem */
static const struct pinctrl_pin_desc imx8mq_pinctrl_pads[] = {
	IMX_PINCTRL_PIN(MX8MQ_PAD_RESERVE0),
	IMX_PINCTRL_PIN(MX8MQ_PAD_RESERVE1),
	IMX_PINCTRL_PIN(MX8MQ_PAD_RESERVE2),
	IMX_PINCTRL_PIN(MX8MQ_PAD_RESERVE3),
	IMX_PINCTRL_PIN(MX8MQ_PAD_RESERVE4),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_PMIC_STBY_REQ_CCMSRCGPCMIX),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_PMIC_ON_REQ_SNVSMIX),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ONOFF_SNVSMIX),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_POR_B_SNVSMIX),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_RTC_RESET_B_SNVSMIX),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO00),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO01),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO02),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO03),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO04),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO05),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO06),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO07),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO08),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO09),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO10),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO11),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO12),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO13),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO14),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_GPIO1_IO15),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_MDC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_MDIO),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_TD3),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_TD2),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_TD1),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_TD0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_TX_CTL),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_TXC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_RX_CTL),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_RXC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_RD0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_RD1),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_RD2),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ENET_RD3),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_CLK),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_CMD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_DATA0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_DATA1),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_DATA2),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_DATA3),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_DATA4),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_DATA5),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_DATA6),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_DATA7),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_RESET_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD1_STROBE),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD2_CD_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD2_CLK),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD2_CMD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD2_DATA0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD2_DATA1),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD2_DATA2),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD2_DATA3),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD2_RESET_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SD2_WP),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_ALE),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_CE0_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_CE1_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_CE2_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_CE3_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_CLE),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_DATA00),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_DATA01),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_DATA02),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_DATA03),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_DATA04),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_DATA05),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_DATA06),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_DATA07),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_DQS),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_RE_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_READY_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_WE_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_NAND_WP_B),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI5_RXFS),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI5_RXC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI5_RXD0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI5_RXD1),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI5_RXD2),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI5_RXD3),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI5_MCLK),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXFS),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXD0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXD1),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXD2),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXD3),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXD4),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXD5),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXD6),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_RXD7),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXFS),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXD0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXD1),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXD2),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXD3),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXD4),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXD5),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXD6),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_TXD7),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI1_MCLK),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI2_RXFS),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI2_RXC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI2_RXD0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI2_TXFS),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI2_TXC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI2_TXD0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI2_MCLK),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI3_RXFS),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI3_RXC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI3_RXD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI3_TXFS),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI3_TXC),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI3_TXD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SAI3_MCLK),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SPDIF_TX),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SPDIF_RX),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_SPDIF_EXT_CLK),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ECSPI1_SCLK),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ECSPI1_MOSI),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ECSPI1_MISO),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ECSPI1_SS0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ECSPI2_SCLK),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ECSPI2_MOSI),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ECSPI2_MISO),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_ECSPI2_SS0),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_I2C1_SCL),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_I2C1_SDA),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_I2C2_SCL),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_I2C2_SDA),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_I2C3_SCL),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_I2C3_SDA),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_I2C4_SCL),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_I2C4_SDA),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_UART1_RXD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_UART1_TXD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_UART2_RXD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_UART2_TXD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_UART3_RXD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_UART3_TXD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_UART4_RXD),
	IMX_PINCTRL_PIN(MX8MQ_IOMUXC_UART4_TXD),
};

static const struct imx_pinctrl_soc_info imx8mq_pinctrl_info = {
	.pins = imx8mq_pinctrl_pads,
	.npins = ARRAY_SIZE(imx8mq_pinctrl_pads),
	.gpr_compatible = "fsl,imx8mq-iomuxc-gpr",
};

static const struct of_device_id imx8mq_pinctrl_of_match[] = {
	{ .compatible = "fsl,imx8mq-iomuxc", .data = &imx8mq_pinctrl_info, },
	{ /* sentinel */ }
};
MODULE_DEVICE_TABLE(of, imx8mq_pinctrl_of_match);

static int imx8mq_pinctrl_probe(struct platform_device *pdev)
{
	return imx_pinctrl_probe(pdev, &imx8mq_pinctrl_info);
}

static struct platform_driver imx8mq_pinctrl_driver = {
	.driver = {
		.name = "imx8mq-pinctrl",
		.of_match_table = imx8mq_pinctrl_of_match,
		.pm = &imx_pinctrl_pm_ops,
		.suppress_bind_attrs = true,
	},
	.probe = imx8mq_pinctrl_probe,
};

static int __init imx8mq_pinctrl_init(void)
{
	return platform_driver_register(&imx8mq_pinctrl_driver);
}
arch_initcall(imx8mq_pinctrl_init);

MODULE_AUTHOR("Lucas Stach <l.stach@pengutronix.de>");
MODULE_DESCRIPTION("NXP i.MX8MQ pinctrl driver");
MODULE_LICENSE("GPL v2");
