#ifndef __PINCTRL_MTK_MT8127_H
#define __PINCTRL_MTK_MT8127_H

#include <linux/pinctrl/pinctrl.h>
#include "pinctrl-mtk-common.h"

static const struct mtk_desc_pin mtk_pins_mt8127[] = {
	MTK_PIN(
		PINCTRL_PIN(0, "PWRAP_SPI0_MI"),
		"P22", "mt8127",
		MTK_EINT_FUNCTION(0, 22),
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "PWRAP_SPIDO"),
		MTK_FUNCTION(2, "PWRAP_SPIDI")
	),
	MTK_PIN(
		PINCTRL_PIN(1, "PWRAP_SPI0_MO"),
		"M22", "mt8127",
		MTK_EINT_FUNCTION(0, 23),
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "PWRAP_SPIDI"),
		MTK_FUNCTION(2, "PWRAP_SPIDO")
	),
	MTK_PIN(
		PINCTRL_PIN(2, "PWRAP_INT"),
		"L23", "mt8127",
		MTK_EINT_FUNCTION(0, 24),
		MTK_FUNCTION(0, "GPIO2")
	),
	MTK_PIN(
		PINCTRL_PIN(3, "PWRAP_SPI0_CK"),
		"N23", "mt8127",
		MTK_EINT_FUNCTION(0, 25),
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "PWRAP_SPICK_I")
	),
	MTK_PIN(
		PINCTRL_PIN(4, "PWRAP_SPI0_CSN"),
		"N22", "mt8127",
		MTK_EINT_FUNCTION(0, 26),
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "PWRAP_SPICS_B_I")
	),
	MTK_PIN(
		PINCTRL_PIN(5, "PWRAP_SPI0_CK2"),
		"L19", "mt8127",
		MTK_EINT_FUNCTION(0, 27),
		MTK_FUNCTION(0, "GPIO5"),
		MTK_FUNCTION(1, "PWRAP_SPICK2_I"),
		MTK_FUNCTION(2, "ANT_SEL1"),
		MTK_FUNCTION(3, "VDEC_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_B[0]")
	),
	MTK_PIN(
		PINCTRL_PIN(6, "PWRAP_SPI0_CSN2"),
		"M23", "mt8127",
		MTK_EINT_FUNCTION(0, 28),
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "PWRAP_SPICS2_B_I"),
		MTK_FUNCTION(2, "ANT_SEL0"),
		MTK_FUNCTION(3, "MM_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_B[1]")
	),
	MTK_PIN(
		PINCTRL_PIN(7, "AUD_CLK_MOSI"),
		"K23", "mt8127",
		MTK_EINT_FUNCTION(0, 29),
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(1, "AUD_CLK"),
		MTK_FUNCTION(2, "ADC_CK")
	),
	MTK_PIN(
		PINCTRL_PIN(8, "AUD_DAT_MISO"),
		"K24", "mt8127",
		MTK_EINT_FUNCTION(0, 30),
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(1, "AUD_MISO"),
		MTK_FUNCTION(2, "ADC_DAT_IN"),
		MTK_FUNCTION(3, "AUD_MOSI")
	),
	MTK_PIN(
		PINCTRL_PIN(9, "AUD_DAT_MOSI"),
		"K22", "mt8127",
		MTK_EINT_FUNCTION(0, 31),
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(1, "AUD_MOSI"),
		MTK_FUNCTION(2, "ADC_WS"),
		MTK_FUNCTION(3, "AUD_MISO")
	),
	MTK_PIN(
		PINCTRL_PIN(10, "RTC32K_CK"),
		"R21", "mt8127",
		MTK_EINT_FUNCTION(0, 32),
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(1, "RTC32K_CK")
	),
	MTK_PIN(
		PINCTRL_PIN(11, "WATCHDOG"),
		"P24", "mt8127",
		MTK_EINT_FUNCTION(0, 33),
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(1, "WATCHDOG")
	),
	MTK_PIN(
		PINCTRL_PIN(12, "SRCLKENA"),
		"R22", "mt8127",
		MTK_EINT_FUNCTION(0, 34),
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(1, "SRCLKENA")
	),
	MTK_PIN(
		PINCTRL_PIN(13, "SRCLKENAI"),
		"P23", "mt8127",
		MTK_EINT_FUNCTION(0, 35),
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "SRCLKENAI")
	),
	MTK_PIN(
		PINCTRL_PIN(14, "URXD2"),
		"U19", "mt8127",
		MTK_EINT_FUNCTION(0, 36),
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "URXD2"),
		MTK_FUNCTION(2, "DPI_D5"),
		MTK_FUNCTION(3, "UTXD2"),
		MTK_FUNCTION(5, "SRCCLKENAI2"),
		MTK_FUNCTION(6, "KROW4")
	),
	MTK_PIN(
		PINCTRL_PIN(15, "UTXD2"),
		"U20", "mt8127",
		MTK_EINT_FUNCTION(0, 37),
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "UTXD2"),
		MTK_FUNCTION(2, "DPI_HSYNC"),
		MTK_FUNCTION(3, "URXD2"),
		MTK_FUNCTION(6, "KROW5")
	),
	MTK_PIN(
		PINCTRL_PIN(16, "URXD3"),
		"U18", "mt8127",
		MTK_EINT_FUNCTION(0, 38),
		MTK_FUNCTION(0, "GPIO16"),
		MTK_FUNCTION(1, "URXD3"),
		MTK_FUNCTION(2, "DPI_DE"),
		MTK_FUNCTION(3, "UTXD3"),
		MTK_FUNCTION(4, "UCTS2"),
		MTK_FUNCTION(5, "PWM3"),
		MTK_FUNCTION(6, "KROW6")
	),
	MTK_PIN(
		PINCTRL_PIN(17, "UTXD3"),
		"R18", "mt8127",
		MTK_EINT_FUNCTION(0, 39),
		MTK_FUNCTION(0, "GPIO17"),
		MTK_FUNCTION(1, "UTXD3"),
		MTK_FUNCTION(2, "DPI_VSYNC"),
		MTK_FUNCTION(3, "URXD3"),
		MTK_FUNCTION(4, "URTS2"),
		MTK_FUNCTION(5, "PWM4"),
		MTK_FUNCTION(6, "KROW7")
	),
	MTK_PIN(
		PINCTRL_PIN(18, "PCM_CLK"),
		"U22", "mt8127",
		MTK_EINT_FUNCTION(0, 40),
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "PCM_CLK0"),
		MTK_FUNCTION(2, "DPI_D4"),
		MTK_FUNCTION(3, "I2SIN1_BCK0"),
		MTK_FUNCTION(4, "I2SOUT_BCK"),
		MTK_FUNCTION(5, "CONN_DSP_JCK"),
		MTK_FUNCTION(6, "IR"),
		MTK_FUNCTION(7, "DBG_MON_A[0]")
	),
	MTK_PIN(
		PINCTRL_PIN(19, "PCM_SYNC"),
		"U23", "mt8127",
		MTK_EINT_FUNCTION(0, 41),
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "PCM_SYNC"),
		MTK_FUNCTION(2, "DPI_D3"),
		MTK_FUNCTION(3, "I2SIN1_LRCK"),
		MTK_FUNCTION(4, "I2SOUT_LRCK"),
		MTK_FUNCTION(5, "CONN_DSP_JINTP"),
		MTK_FUNCTION(6, "EXT_COL"),
		MTK_FUNCTION(7, "DBG_MON_A[1]")
	),
	MTK_PIN(
		PINCTRL_PIN(20, "PCM_RX"),
		"V22", "mt8127",
		MTK_EINT_FUNCTION(0, 42),
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "PCM_RX"),
		MTK_FUNCTION(2, "DPI_D1"),
		MTK_FUNCTION(3, "I2SIN1_DATA_IN"),
		MTK_FUNCTION(4, "PCM_TX"),
		MTK_FUNCTION(5, "CONN_DSP_JDI"),
		MTK_FUNCTION(6, "EXT_MDIO"),
		MTK_FUNCTION(7, "DBG_MON_A[2]")
	),
	MTK_PIN(
		PINCTRL_PIN(21, "PCM_TX"),
		"U21", "mt8127",
		MTK_EINT_FUNCTION(0, 43),
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "PCM_TX"),
		MTK_FUNCTION(2, "DPI_D2"),
		MTK_FUNCTION(3, "I2SOUT_DATA_OUT"),
		MTK_FUNCTION(4, "PCM_RX"),
		MTK_FUNCTION(5, "CONN_DSP_JMS"),
		MTK_FUNCTION(6, "EXT_MDC"),
		MTK_FUNCTION(7, "DBG_MON_A[3]")
	),
	MTK_PIN(
		PINCTRL_PIN(22, "EINT0"),
		"AB19", "mt8127",
		MTK_EINT_FUNCTION(0, 0),
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "PWM1"),
		MTK_FUNCTION(2, "DPI_CK"),
		MTK_FUNCTION(4, "EXT_TXD0"),
		MTK_FUNCTION(5, "CONN_DSP_JDO"),
		MTK_FUNCTION(7, "DBG_MON_A[4]")
	),
	MTK_PIN(
		PINCTRL_PIN(23, "EINT1"),
		"AA21", "mt8127",
		MTK_EINT_FUNCTION(0, 1),
		MTK_FUNCTION(0, "GPIO23"),
		MTK_FUNCTION(1, "PWM2"),
		MTK_FUNCTION(2, "DPI_D12"),
		MTK_FUNCTION(4, "EXT_TXD1"),
		MTK_FUNCTION(5, "CONN_MCU_TDO"),
		MTK_FUNCTION(7, "DBG_MON_A[5]")
	),
	MTK_PIN(
		PINCTRL_PIN(24, "EINT2"),
		"AA19", "mt8127",
		MTK_EINT_FUNCTION(0, 2),
		MTK_FUNCTION(0, "GPIO24"),
		MTK_FUNCTION(1, "CLKM0"),
		MTK_FUNCTION(2, "DPI_D13"),
		MTK_FUNCTION(4, "EXT_TXD2"),
		MTK_FUNCTION(5, "CONN_MCU_DBGACK_N"),
		MTK_FUNCTION(6, "KCOL4"),
		MTK_FUNCTION(7, "DBG_MON_A[6]")
	),
	MTK_PIN(
		PINCTRL_PIN(25, "EINT3"),
		"Y19", "mt8127",
		MTK_EINT_FUNCTION(0, 3),
		MTK_FUNCTION(0, "GPIO25"),
		MTK_FUNCTION(1, "CLKM1"),
		MTK_FUNCTION(2, "DPI_D14"),
		MTK_FUNCTION(3, "SPI_MI"),
		MTK_FUNCTION(4, "EXT_TXD3"),
		MTK_FUNCTION(5, "CONN_MCU_DBGI_N"),
		MTK_FUNCTION(6, "KCOL5"),
		MTK_FUNCTION(7, "DBG_MON_A[7]")
	),
	MTK_PIN(
		PINCTRL_PIN(26, "EINT4"),
		"V21", "mt8127",
		MTK_EINT_FUNCTION(0, 4),
		MTK_FUNCTION(0, "GPIO26"),
		MTK_FUNCTION(1, "CLKM2"),
		MTK_FUNCTION(2, "DPI_D15"),
		MTK_FUNCTION(3, "SPI_MO"),
		MTK_FUNCTION(4, "EXT_TXC"),
		MTK_FUNCTION(5, "CONN_MCU_TCK0"),
		MTK_FUNCTION(6, "CONN_MCU_AICE_JCKC"),
		MTK_FUNCTION(7, "DBG_MON_A[8]")
	),
	MTK_PIN(
		PINCTRL_PIN(27, "EINT5"),
		"AB22", "mt8127",
		MTK_EINT_FUNCTION(0, 5),
		MTK_FUNCTION(0, "GPIO27"),
		MTK_FUNCTION(1, "UCTS2"),
		MTK_FUNCTION(2, "DPI_D16"),
		MTK_FUNCTION(3, "SPI_CS"),
		MTK_FUNCTION(4, "EXT_RXER"),
		MTK_FUNCTION(5, "CONN_MCU_TDI"),
		MTK_FUNCTION(6, "KCOL6"),
		MTK_FUNCTION(7, "DBG_MON_A[9]")
	),
	MTK_PIN(
		PINCTRL_PIN(28, "EINT6"),
		"AA23", "mt8127",
		MTK_EINT_FUNCTION(0, 6),
		MTK_FUNCTION(0, "GPIO28"),
		MTK_FUNCTION(1, "URTS2"),
		MTK_FUNCTION(2, "DPI_D17"),
		MTK_FUNCTION(3, "SPI_CK"),
		MTK_FUNCTION(4, "EXT_RXC"),
		MTK_FUNCTION(5, "CONN_MCU_TRST_B"),
		MTK_FUNCTION(6, "KCOL7"),
		MTK_FUNCTION(7, "DBG_MON_A[10]")
	),
	MTK_PIN(
		PINCTRL_PIN(29, "EINT7"),
		"Y23", "mt8127",
		MTK_EINT_FUNCTION(0, 7),
		MTK_FUNCTION(0, "GPIO29"),
		MTK_FUNCTION(1, "UCTS3"),
		MTK_FUNCTION(2, "DPI_D6"),
		MTK_FUNCTION(3, "SDA1"),
		MTK_FUNCTION(4, "EXT_RXDV"),
		MTK_FUNCTION(5, "CONN_MCU_TMS"),
		MTK_FUNCTION(6, "CONN_MCU_AICE_JMSC"),
		MTK_FUNCTION(7, "DBG_MON_A[11]")
	),
	MTK_PIN(
		PINCTRL_PIN(30, "EINT8"),
		"Y24", "mt8127",
		MTK_EINT_FUNCTION(0, 8),
		MTK_FUNCTION(0, "GPIO30"),
		MTK_FUNCTION(1, "URTS3"),
		MTK_FUNCTION(2, "CLKM3"),
		MTK_FUNCTION(3, "SCL1"),
		MTK_FUNCTION(4, "EXT_RXD0"),
		MTK_FUNCTION(5, "ANT_SEL0"),
		MTK_FUNCTION(6, "DPI_D7"),
		MTK_FUNCTION(7, "DBG_MON_B[2]")
	),
	MTK_PIN(
		PINCTRL_PIN(31, "EINT9"),
		"W23", "mt8127",
		MTK_EINT_FUNCTION(0, 9),
		MTK_FUNCTION(0, "GPIO31"),
		MTK_FUNCTION(1, "CLKM4"),
		MTK_FUNCTION(2, "SDA2"),
		MTK_FUNCTION(3, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(4, "EXT_RXD1"),
		MTK_FUNCTION(5, "ANT_SEL1"),
		MTK_FUNCTION(6, "DPI_D8"),
		MTK_FUNCTION(7, "DBG_MON_B[3]")
	),
	MTK_PIN(
		PINCTRL_PIN(32, "EINT10"),
		"W24", "mt8127",
		MTK_EINT_FUNCTION(0, 10),
		MTK_FUNCTION(0, "GPIO32"),
		MTK_FUNCTION(1, "CLKM5"),
		MTK_FUNCTION(2, "SCL2"),
		MTK_FUNCTION(3, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(4, "EXT_RXD2"),
		MTK_FUNCTION(5, "ANT_SEL2"),
		MTK_FUNCTION(6, "DPI_D9"),
		MTK_FUNCTION(7, "DBG_MON_B[4]")
	),
	MTK_PIN(
		PINCTRL_PIN(33, "KPROW0"),
		"AB24", "mt8127",
		MTK_EINT_FUNCTION(0, 44),
		MTK_FUNCTION(0, "GPIO33"),
		MTK_FUNCTION(1, "KROW0"),
		MTK_FUNCTION(4, "IMG_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_A[12]")
	),
	MTK_PIN(
		PINCTRL_PIN(34, "KPROW1"),
		"AC24", "mt8127",
		MTK_EINT_FUNCTION(0, 45),
		MTK_FUNCTION(0, "GPIO34"),
		MTK_FUNCTION(1, "KROW1"),
		MTK_FUNCTION(2, "IDDIG"),
		MTK_FUNCTION(3, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(4, "MFG_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_B[5]")
	),
	MTK_PIN(
		PINCTRL_PIN(35, "KPROW2"),
		"AD24", "mt8127",
		MTK_EINT_FUNCTION(0, 46),
		MTK_FUNCTION(0, "GPIO35"),
		MTK_FUNCTION(1, "KROW2"),
		MTK_FUNCTION(2, "DRV_VBUS"),
		MTK_FUNCTION(3, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(4, "CONN_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_B[6]")
	),
	MTK_PIN(
		PINCTRL_PIN(36, "KPCOL0"),
		"AB23", "mt8127",
		MTK_EINT_FUNCTION(0, 47),
		MTK_FUNCTION(0, "GPIO36"),
		MTK_FUNCTION(1, "KCOL0"),
		MTK_FUNCTION(7, "DBG_MON_A[13]")
	),
	MTK_PIN(
		PINCTRL_PIN(37, "KPCOL1"),
		"AC22", "mt8127",
		MTK_EINT_FUNCTION(0, 48),
		MTK_FUNCTION(0, "GPIO37"),
		MTK_FUNCTION(1, "KCOL1"),
		MTK_FUNCTION(7, "DBG_MON_B[7]")
	),
	MTK_PIN(
		PINCTRL_PIN(38, "KPCOL2"),
		"AC23", "mt8127",
		MTK_EINT_FUNCTION(0, 49),
		MTK_FUNCTION(0, "GPIO38"),
		MTK_FUNCTION(1, "KCOL2"),
		MTK_FUNCTION(2, "IDDIG"),
		MTK_FUNCTION(3, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_B[8]")
	),
	MTK_PIN(
		PINCTRL_PIN(39, "JTMS"),
		"V18", "mt8127",
		MTK_EINT_FUNCTION(0, 50),
		MTK_FUNCTION(0, "GPIO39"),
		MTK_FUNCTION(1, "JTMS"),
		MTK_FUNCTION(2, "CONN_MCU_TMS"),
		MTK_FUNCTION(3, "CONN_MCU_AICE_JMSC")
	),
	MTK_PIN(
		PINCTRL_PIN(40, "JTCK"),
		"AA18", "mt8127",
		MTK_EINT_FUNCTION(0, 51),
		MTK_FUNCTION(0, "GPIO40"),
		MTK_FUNCTION(1, "JTCK"),
		MTK_FUNCTION(2, "CONN_MCU_TCK1"),
		MTK_FUNCTION(3, "CONN_MCU_AICE_JCKC")
	),
	MTK_PIN(
		PINCTRL_PIN(41, "JTDI"),
		"W18", "mt8127",
		MTK_EINT_FUNCTION(0, 52),
		MTK_FUNCTION(0, "GPIO41"),
		MTK_FUNCTION(1, "JTDI"),
		MTK_FUNCTION(2, "CONN_MCU_TDI")
	),
	MTK_PIN(
		PINCTRL_PIN(42, "JTDO"),
		"Y18", "mt8127",
		MTK_EINT_FUNCTION(0, 53),
		MTK_FUNCTION(0, "GPIO42"),
		MTK_FUNCTION(1, "JTDO"),
		MTK_FUNCTION(2, "CONN_MCU_TDO")
	),
	MTK_PIN(
		PINCTRL_PIN(43, "EINT11"),
		"W22", "mt8127",
		MTK_EINT_FUNCTION(0, 11),
		MTK_FUNCTION(0, "GPIO43"),
		MTK_FUNCTION(1, "CLKM4"),
		MTK_FUNCTION(2, "PWM2"),
		MTK_FUNCTION(3, "KROW3"),
		MTK_FUNCTION(4, "ANT_SEL3"),
		MTK_FUNCTION(5, "DPI_D10"),
		MTK_FUNCTION(6, "EXT_RXD3"),
		MTK_FUNCTION(7, "DBG_MON_B[9]")
	),
	MTK_PIN(
		PINCTRL_PIN(44, "EINT12"),
		"V23", "mt8127",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO44"),
		MTK_FUNCTION(1, "CLKM5"),
		MTK_FUNCTION(2, "PWM0"),
		MTK_FUNCTION(3, "KCOL3"),
		MTK_FUNCTION(4, "ANT_SEL4"),
		MTK_FUNCTION(5, "DPI_D11"),
		MTK_FUNCTION(6, "EXT_TXEN"),
		MTK_FUNCTION(7, "DBG_MON_B[10]")
	),
	MTK_PIN(
		PINCTRL_PIN(45, "EINT13"),
		"Y21", "mt8127",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO45"),
		MTK_FUNCTION(4, "ANT_SEL5"),
		MTK_FUNCTION(5, "DPI_D0"),
		MTK_FUNCTION(6, "SPDIF"),
		MTK_FUNCTION(7, "DBG_MON_B[11]")
	),
	MTK_PIN(
		PINCTRL_PIN(46, "EINT14"),
		"F23", "mt8127",
		MTK_EINT_FUNCTION(0, 14),
		MTK_FUNCTION(0, "GPIO46"),
		MTK_FUNCTION(2, "DAC_DAT_OUT"),
		MTK_FUNCTION(4, "ANT_SEL1"),
		MTK_FUNCTION(5, "CONN_MCU_DBGACK_N"),
		MTK_FUNCTION(6, "NCLE"),
		MTK_FUNCTION(7, "DBG_MON_A[14]")
	),
	MTK_PIN(
		PINCTRL_PIN(47, "EINT15"),
		"G23", "mt8127",
		MTK_EINT_FUNCTION(0, 15),
		MTK_FUNCTION(0, "GPIO47"),
		MTK_FUNCTION(2, "DAC_WS"),
		MTK_FUNCTION(4, "ANT_SEL2"),
		MTK_FUNCTION(5, "CONN_MCU_DBGI_N"),
		MTK_FUNCTION(6, "NCEB1"),
		MTK_FUNCTION(7, "DBG_MON_A[15]")
	),
	MTK_PIN(
		PINCTRL_PIN(48, "EINT16"),
		"H23", "mt8127",
		MTK_EINT_FUNCTION(0, 16),
		MTK_FUNCTION(0, "GPIO48"),
		MTK_FUNCTION(2, "DAC_CK"),
		MTK_FUNCTION(4, "ANT_SEL3"),
		MTK_FUNCTION(5, "CONN_MCU_TRST_B"),
		MTK_FUNCTION(6, "NCEB0"),
		MTK_FUNCTION(7, "DBG_MON_A[16]")
	),
	MTK_PIN(
		PINCTRL_PIN(49, "EINT17"),
		"J22", "mt8127",
		MTK_EINT_FUNCTION(0, 17),
		MTK_FUNCTION(0, "GPIO49"),
		MTK_FUNCTION(1, "UCTS0"),
		MTK_FUNCTION(3, "CLKM0"),
		MTK_FUNCTION(4, "IDDIG"),
		MTK_FUNCTION(5, "ANT_SEL4"),
		MTK_FUNCTION(6, "NREB"),
		MTK_FUNCTION(7, "DBG_MON_A[17]")
	),
	MTK_PIN(
		PINCTRL_PIN(50, "EINT18"),
		"AD20", "mt8127",
		MTK_EINT_FUNCTION(0, 18),
		MTK_FUNCTION(0, "GPIO50"),
		MTK_FUNCTION(1, "URTS0"),
		MTK_FUNCTION(2, "CLKM3"),
		MTK_FUNCTION(3, "I2SOUT_LRCK"),
		MTK_FUNCTION(4, "DRV_VBUS"),
		MTK_FUNCTION(5, "ANT_SEL3"),
		MTK_FUNCTION(6, "ADC_CK"),
		MTK_FUNCTION(7, "DBG_MON_B[12]")
	),
	MTK_PIN(
		PINCTRL_PIN(51, "EINT19"),
		"AC21", "mt8127",
		MTK_EINT_FUNCTION(0, 19),
		MTK_FUNCTION(0, "GPIO51"),
		MTK_FUNCTION(1, "UCTS1"),
		MTK_FUNCTION(3, "I2SOUT_BCK"),
		MTK_FUNCTION(4, "CLKM1"),
		MTK_FUNCTION(5, "ANT_SEL4"),
		MTK_FUNCTION(6, "ADC_DAT_IN"),
		MTK_FUNCTION(7, "DBG_MON_B[13]")
	),
	MTK_PIN(
		PINCTRL_PIN(52, "EINT20"),
		"V20", "mt8127",
		MTK_EINT_FUNCTION(0, 20),
		MTK_FUNCTION(0, "GPIO52"),
		MTK_FUNCTION(1, "URTS1"),
		MTK_FUNCTION(2, "PCM_TX"),
		MTK_FUNCTION(3, "I2SOUT_DATA_OUT"),
		MTK_FUNCTION(4, "CLKM2"),
		MTK_FUNCTION(5, "ANT_SEL5"),
		MTK_FUNCTION(6, "ADC_WS"),
		MTK_FUNCTION(7, "DBG_MON_B[14]")
	),
	MTK_PIN(
		PINCTRL_PIN(53, "SPI_CS"),
		"AD19", "mt8127",
		MTK_EINT_FUNCTION(0, 54),
		MTK_FUNCTION(0, "GPIO53"),
		MTK_FUNCTION(1, "SPI_CS"),
		MTK_FUNCTION(3, "I2SIN1_DATA_IN"),
		MTK_FUNCTION(4, "ADC_CK"),
		MTK_FUNCTION(7, "DBG_MON_B[15]")
	),
	MTK_PIN(
		PINCTRL_PIN(54, "SPI_CK"),
		"AC18", "mt8127",
		MTK_EINT_FUNCTION(0, 55),
		MTK_FUNCTION(0, "GPIO54"),
		MTK_FUNCTION(1, "SPI_CK"),
		MTK_FUNCTION(3, "I2SIN1_LRCK"),
		MTK_FUNCTION(4, "ADC_DAT_IN"),
		MTK_FUNCTION(7, "DBG_MON_B[16]")
	),
	MTK_PIN(
		PINCTRL_PIN(55, "SPI_MI"),
		"AC19", "mt8127",
		MTK_EINT_FUNCTION(0, 56),
		MTK_FUNCTION(0, "GPIO55"),
		MTK_FUNCTION(1, "SPI_MI"),
		MTK_FUNCTION(2, "SPI_MO"),
		MTK_FUNCTION(3, "I2SIN1_BCK1"),
		MTK_FUNCTION(4, "ADC_WS"),
		MTK_FUNCTION(7, "DBG_MON_B[17]")
	),
	MTK_PIN(
		PINCTRL_PIN(56, "SPI_MO"),
		"AD18", "mt8127",
		MTK_EINT_FUNCTION(0, 57),
		MTK_FUNCTION(0, "GPIO56"),
		MTK_FUNCTION(1, "SPI_MO"),
		MTK_FUNCTION(2, "SPI_MI"),
		MTK_FUNCTION(7, "DBG_MON_B[18]")
	),
	MTK_PIN(
		PINCTRL_PIN(57, "SDA1"),
		"AE23", "mt8127",
		MTK_EINT_FUNCTION(0, 58),
		MTK_FUNCTION(0, "GPIO57"),
		MTK_FUNCTION(1, "SDA1")
	),
	MTK_PIN(
		PINCTRL_PIN(58, "SCL1"),
		"AD23", "mt8127",
		MTK_EINT_FUNCTION(0, 59),
		MTK_FUNCTION(0, "GPIO58"),
		MTK_FUNCTION(1, "SCL1")
	),
	MTK_PIN(
		PINCTRL_PIN(59, "DISP_PWM"),
		"AC20", "mt8127",
		MTK_EINT_FUNCTION(0, 60),
		MTK_FUNCTION(0, "GPIO59"),
		MTK_FUNCTION(1, "DISP_PWM"),
		MTK_FUNCTION(2, "PWM1"),
		MTK_FUNCTION(7, "DBG_MON_A[18]")
	),
	MTK_PIN(
		PINCTRL_PIN(60, "WB_RSTB"),
		"AD7", "mt8127",
		MTK_EINT_FUNCTION(0, 61),
		MTK_FUNCTION(0, "GPIO60"),
		MTK_FUNCTION(1, "WB_RSTB"),
		MTK_FUNCTION(7, "DBG_MON_A[19]")
	),
	MTK_PIN(
		PINCTRL_PIN(61, "F2W_DATA"),
		"Y10", "mt8127",
		MTK_EINT_FUNCTION(0, 62),
		MTK_FUNCTION(0, "GPIO61"),
		MTK_FUNCTION(1, "F2W_DATA"),
		MTK_FUNCTION(7, "DBG_MON_A[20]")
	),
	MTK_PIN(
		PINCTRL_PIN(62, "F2W_CLK"),
		"W10", "mt8127",
		MTK_EINT_FUNCTION(0, 63),
		MTK_FUNCTION(0, "GPIO62"),
		MTK_FUNCTION(1, "F2W_CK"),
		MTK_FUNCTION(7, "DBG_MON_A[21]")
	),
	MTK_PIN(
		PINCTRL_PIN(63, "WB_SCLK"),
		"AB7", "mt8127",
		MTK_EINT_FUNCTION(0, 64),
		MTK_FUNCTION(0, "GPIO63"),
		MTK_FUNCTION(1, "WB_SCLK"),
		MTK_FUNCTION(7, "DBG_MON_A[22]")
	),
	MTK_PIN(
		PINCTRL_PIN(64, "WB_SDATA"),
		"AA7", "mt8127",
		MTK_EINT_FUNCTION(0, 65),
		MTK_FUNCTION(0, "GPIO64"),
		MTK_FUNCTION(1, "WB_SDATA"),
		MTK_FUNCTION(7, "DBG_MON_A[23]")
	),
	MTK_PIN(
		PINCTRL_PIN(65, "WB_SEN"),
		"Y7", "mt8127",
		MTK_EINT_FUNCTION(0, 66),
		MTK_FUNCTION(0, "GPIO65"),
		MTK_FUNCTION(1, "WB_SEN"),
		MTK_FUNCTION(7, "DBG_MON_A[24]")
	),
	MTK_PIN(
		PINCTRL_PIN(66, "WB_CRTL0"),
		"AA1", "mt8127",
		MTK_EINT_FUNCTION(0, 67),
		MTK_FUNCTION(0, "GPIO66"),
		MTK_FUNCTION(1, "WB_CRTL0"),
		MTK_FUNCTION(2, "DFD_NTRST_XI"),
		MTK_FUNCTION(7, "DBG_MON_A[25]")
	),
	MTK_PIN(
		PINCTRL_PIN(67, "WB_CRTL1"),
		"AA2", "mt8127",
		MTK_EINT_FUNCTION(0, 68),
		MTK_FUNCTION(0, "GPIO67"),
		MTK_FUNCTION(1, "WB_CRTL1"),
		MTK_FUNCTION(2, "DFD_TMS_XI"),
		MTK_FUNCTION(7, "DBG_MON_A[26]")
	),
	MTK_PIN(
		PINCTRL_PIN(68, "WB_CRTL2"),
		"Y1", "mt8127",
		MTK_EINT_FUNCTION(0, 69),
		MTK_FUNCTION(0, "GPIO68"),
		MTK_FUNCTION(1, "WB_CRTL2"),
		MTK_FUNCTION(2, "DFD_TCK_XI"),
		MTK_FUNCTION(7, "DBG_MON_A[27]")
	),
	MTK_PIN(
		PINCTRL_PIN(69, "WB_CRTL3"),
		"Y2", "mt8127",
		MTK_EINT_FUNCTION(0, 70),
		MTK_FUNCTION(0, "GPIO69"),
		MTK_FUNCTION(1, "WB_CRTL3"),
		MTK_FUNCTION(2, "DFD_TDI_XI"),
		MTK_FUNCTION(7, "DBG_MON_A[28]")
	),
	MTK_PIN(
		PINCTRL_PIN(70, "WB_CRTL4"),
		"Y3", "mt8127",
		MTK_EINT_FUNCTION(0, 71),
		MTK_FUNCTION(0, "GPIO70"),
		MTK_FUNCTION(1, "WB_CRTL4"),
		MTK_FUNCTION(2, "DFD_TDO"),
		MTK_FUNCTION(7, "DBG_MON_A[29]")
	),
	MTK_PIN(
		PINCTRL_PIN(71, "WB_CRTL5"),
		"Y4", "mt8127",
		MTK_EINT_FUNCTION(0, 72),
		MTK_FUNCTION(0, "GPIO71"),
		MTK_FUNCTION(1, "WB_CRTL5"),
		MTK_FUNCTION(7, "DBG_MON_A[30]")
	),
	MTK_PIN(
		PINCTRL_PIN(72, "I2S_DATA_IN"),
		"K21", "mt8127",
		MTK_EINT_FUNCTION(0, 73),
		MTK_FUNCTION(0, "GPIO72"),
		MTK_FUNCTION(1, "I2SIN1_DATA_IN"),
		MTK_FUNCTION(2, "PCM_RX"),
		MTK_FUNCTION(3, "I2SOUT_DATA_OUT"),
		MTK_FUNCTION(4, "DAC_DAT_OUT"),
		MTK_FUNCTION(5, "PWM0"),
		MTK_FUNCTION(6, "ADC_CK"),
		MTK_FUNCTION(7, "DBG_MON_B[19]")
	),
	MTK_PIN(
		PINCTRL_PIN(73, "I2S_LRCK"),
		"L21", "mt8127",
		MTK_EINT_FUNCTION(0, 74),
		MTK_FUNCTION(0, "GPIO73"),
		MTK_FUNCTION(1, "I2SIN1_LRCK"),
		MTK_FUNCTION(2, "PCM_SYNC"),
		MTK_FUNCTION(3, "I2SOUT_LRCK"),
		MTK_FUNCTION(4, "DAC_WS"),
		MTK_FUNCTION(5, "PWM3"),
		MTK_FUNCTION(6, "ADC_DAT_IN"),
		MTK_FUNCTION(7, "DBG_MON_B[20]")
	),
	MTK_PIN(
		PINCTRL_PIN(74, "I2S_BCK"),
		"L20", "mt8127",
		MTK_EINT_FUNCTION(0, 75),
		MTK_FUNCTION(0, "GPIO74"),
		MTK_FUNCTION(1, "I2SIN1_BCK2"),
		MTK_FUNCTION(2, "PCM_CLK1"),
		MTK_FUNCTION(3, "I2SOUT_BCK"),
		MTK_FUNCTION(4, "DAC_CK"),
		MTK_FUNCTION(5, "PWM4"),
		MTK_FUNCTION(6, "ADC_WS"),
		MTK_FUNCTION(7, "DBG_MON_B[21]")
	),
	MTK_PIN(
		PINCTRL_PIN(75, "SDA0"),
		"W3", "mt8127",
		MTK_EINT_FUNCTION(0, 76),
		MTK_FUNCTION(0, "GPIO75"),
		MTK_FUNCTION(1, "SDA0")
	),
	MTK_PIN(
		PINCTRL_PIN(76, "SCL0"),
		"W4", "mt8127",
		MTK_EINT_FUNCTION(0, 77),
		MTK_FUNCTION(0, "GPIO76"),
		MTK_FUNCTION(1, "SCL0")
	),
	MTK_PIN(
		PINCTRL_PIN(77, "SDA2"),
		"K19", "mt8127",
		MTK_EINT_FUNCTION(0, 78),
		MTK_FUNCTION(0, "GPIO77"),
		MTK_FUNCTION(1, "SDA2"),
		MTK_FUNCTION(2, "PWM1")
	),
	MTK_PIN(
		PINCTRL_PIN(78, "SCL2"),
		"K20", "mt8127",
		MTK_EINT_FUNCTION(0, 79),
		MTK_FUNCTION(0, "GPIO78"),
		MTK_FUNCTION(1, "SCL2"),
		MTK_FUNCTION(2, "PWM2")
	),
	MTK_PIN(
		PINCTRL_PIN(79, "URXD0"),
		"K18", "mt8127",
		MTK_EINT_FUNCTION(0, 80),
		MTK_FUNCTION(0, "GPIO79"),
		MTK_FUNCTION(1, "URXD0"),
		MTK_FUNCTION(2, "UTXD0")
	),
	MTK_PIN(
		PINCTRL_PIN(80, "UTXD0"),
		"K17", "mt8127",
		MTK_EINT_FUNCTION(0, 81),
		MTK_FUNCTION(0, "GPIO80"),
		MTK_FUNCTION(1, "UTXD0"),
		MTK_FUNCTION(2, "URXD0")
	),
	MTK_PIN(
		PINCTRL_PIN(81, "URXD1"),
		"L17", "mt8127",
		MTK_EINT_FUNCTION(0, 82),
		MTK_FUNCTION(0, "GPIO81"),
		MTK_FUNCTION(1, "URXD1"),
		MTK_FUNCTION(2, "UTXD1")
	),
	MTK_PIN(
		PINCTRL_PIN(82, "UTXD1"),
		"L18", "mt8127",
		MTK_EINT_FUNCTION(0, 83),
		MTK_FUNCTION(0, "GPIO82"),
		MTK_FUNCTION(1, "UTXD1"),
		MTK_FUNCTION(2, "URXD1")
	),
	MTK_PIN(
		PINCTRL_PIN(83, "LCM_RST"),
		"W5", "mt8127",
		MTK_EINT_FUNCTION(0, 84),
		MTK_FUNCTION(0, "GPIO83"),
		MTK_FUNCTION(1, "LCM_RST"),
		MTK_FUNCTION(2, "VDAC_CK_XI"),
		MTK_FUNCTION(7, "DBG_MON_A[31]")
	),
	MTK_PIN(
		PINCTRL_PIN(84, "DSI_TE"),
		"W6", "mt8127",
		MTK_EINT_FUNCTION(0, 85),
		MTK_FUNCTION(0, "GPIO84"),
		MTK_FUNCTION(1, "DSI_TE"),
		MTK_FUNCTION(7, "DBG_MON_A[32]")
	),
	MTK_PIN(
		PINCTRL_PIN(85, "MSDC2_CMD"),
		"U7", "mt8127",
		MTK_EINT_FUNCTION(0, 86),
		MTK_FUNCTION(0, "GPIO85"),
		MTK_FUNCTION(1, "MSDC2_CMD"),
		MTK_FUNCTION(2, "ANT_SEL0"),
		MTK_FUNCTION(3, "SDA1"),
		MTK_FUNCTION(6, "I2SOUT_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B[22]")
	),
	MTK_PIN(
		PINCTRL_PIN(86, "MSDC2_CLK"),
		"T8", "mt8127",
		MTK_EINT_FUNCTION(0, 87),
		MTK_FUNCTION(0, "GPIO86"),
		MTK_FUNCTION(1, "MSDC2_CLK"),
		MTK_FUNCTION(2, "ANT_SEL1"),
		MTK_FUNCTION(3, "SCL1"),
		MTK_FUNCTION(6, "I2SOUT_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_B[23]")
	),
	MTK_PIN(
		PINCTRL_PIN(87, "MSDC2_DAT0"),
		"V3", "mt8127",
		MTK_EINT_FUNCTION(0, 88),
		MTK_FUNCTION(0, "GPIO87"),
		MTK_FUNCTION(1, "MSDC2_DAT0"),
		MTK_FUNCTION(2, "ANT_SEL2"),
		MTK_FUNCTION(5, "UTXD0"),
		MTK_FUNCTION(6, "I2SOUT_DATA_OUT"),
		MTK_FUNCTION(7, "DBG_MON_B[24]")
	),
	MTK_PIN(
		PINCTRL_PIN(88, "MSDC2_DAT1"),
		"V4", "mt8127",
		MTK_EINT_FUNCTION(0, 89),
		MTK_FUNCTION(0, "GPIO88"),
		MTK_FUNCTION(1, "MSDC2_DAT1"),
		MTK_FUNCTION(2, "ANT_SEL3"),
		MTK_FUNCTION(3, "PWM0"),
		MTK_FUNCTION(5, "URXD0"),
		MTK_FUNCTION(6, "PWM1"),
		MTK_FUNCTION(7, "DBG_MON_B[25]")
	),
	MTK_PIN(
		PINCTRL_PIN(89, "MSDC2_DAT2"),
		"U5", "mt8127",
		MTK_EINT_FUNCTION(0, 90),
		MTK_FUNCTION(0, "GPIO89"),
		MTK_FUNCTION(1, "MSDC2_DAT2"),
		MTK_FUNCTION(2, "ANT_SEL4"),
		MTK_FUNCTION(3, "SDA2"),
		MTK_FUNCTION(5, "UTXD1"),
		MTK_FUNCTION(6, "PWM2"),
		MTK_FUNCTION(7, "DBG_MON_B[26]")
	),
	MTK_PIN(
		PINCTRL_PIN(90, "MSDC2_DAT3"),
		"U6", "mt8127",
		MTK_EINT_FUNCTION(0, 91),
		MTK_FUNCTION(0, "GPIO90"),
		MTK_FUNCTION(1, "MSDC2_DAT3"),
		MTK_FUNCTION(2, "ANT_SEL5"),
		MTK_FUNCTION(3, "SCL2"),
		MTK_FUNCTION(4, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(5, "URXD1"),
		MTK_FUNCTION(6, "PWM3"),
		MTK_FUNCTION(7, "DBG_MON_B[27]")
	),
	MTK_PIN(
		PINCTRL_PIN(91, "TDN3"),
		"U2", "mt8127",
		MTK_EINT_FUNCTION(0, 92),
		MTK_FUNCTION(0, "GPI91"),
		MTK_FUNCTION(1, "TDN3")
	),
	MTK_PIN(
		PINCTRL_PIN(92, "TDP3"),
		"U1", "mt8127",
		MTK_EINT_FUNCTION(0, 93),
		MTK_FUNCTION(0, "GPI92"),
		MTK_FUNCTION(1, "TDP3")
	),
	MTK_PIN(
		PINCTRL_PIN(93, "TDN2"),
		"T2", "mt8127",
		MTK_EINT_FUNCTION(0, 94),
		MTK_FUNCTION(0, "GPI93"),
		MTK_FUNCTION(1, "TDN2")
	),
	MTK_PIN(
		PINCTRL_PIN(94, "TDP2"),
		"T1", "mt8127",
		MTK_EINT_FUNCTION(0, 95),
		MTK_FUNCTION(0, "GPI94"),
		MTK_FUNCTION(1, "TDP2")
	),
	MTK_PIN(
		PINCTRL_PIN(95, "TCN"),
		"R5", "mt8127",
		MTK_EINT_FUNCTION(0, 96),
		MTK_FUNCTION(0, "GPI95"),
		MTK_FUNCTION(1, "TCN")
	),
	MTK_PIN(
		PINCTRL_PIN(96, "TCP"),
		"R4", "mt8127",
		MTK_EINT_FUNCTION(0, 97),
		MTK_FUNCTION(0, "GPI96"),
		MTK_FUNCTION(1, "TCP")
	),
	MTK_PIN(
		PINCTRL_PIN(97, "TDN1"),
		"R3", "mt8127",
		MTK_EINT_FUNCTION(0, 98),
		MTK_FUNCTION(0, "GPI97"),
		MTK_FUNCTION(1, "TDN1")
	),
	MTK_PIN(
		PINCTRL_PIN(98, "TDP1"),
		"R2", "mt8127",
		MTK_EINT_FUNCTION(0, 99),
		MTK_FUNCTION(0, "GPI98"),
		MTK_FUNCTION(1, "TDP1")
	),
	MTK_PIN(
		PINCTRL_PIN(99, "TDN0"),
		"P3", "mt8127",
		MTK_EINT_FUNCTION(0, 100),
		MTK_FUNCTION(0, "GPI99"),
		MTK_FUNCTION(1, "TDN0")
	),
	MTK_PIN(
		PINCTRL_PIN(100, "TDP0"),
		"P2", "mt8127",
		MTK_EINT_FUNCTION(0, 101),
		MTK_FUNCTION(0, "GPI100"),
		MTK_FUNCTION(1, "TDP0")
	),
	MTK_PIN(
		PINCTRL_PIN(101, "RDN0"),
		"K1", "mt8127",
		MTK_EINT_FUNCTION(0, 102),
		MTK_FUNCTION(0, "GPI101"),
		MTK_FUNCTION(1, "RDN0")
	),
	MTK_PIN(
		PINCTRL_PIN(102, "RDP0"),
		"K2", "mt8127",
		MTK_EINT_FUNCTION(0, 103),
		MTK_FUNCTION(0, "GPI102"),
		MTK_FUNCTION(1, "RDP0")
	),
	MTK_PIN(
		PINCTRL_PIN(103, "RDN1"),
		"L2", "mt8127",
		MTK_EINT_FUNCTION(0, 104),
		MTK_FUNCTION(0, "GPI103"),
		MTK_FUNCTION(1, "RDN1")
	),
	MTK_PIN(
		PINCTRL_PIN(104, "RDP1"),
		"L3", "mt8127",
		MTK_EINT_FUNCTION(0, 105),
		MTK_FUNCTION(0, "GPI104"),
		MTK_FUNCTION(1, "RDP1")
	),
	MTK_PIN(
		PINCTRL_PIN(105, "RCN"),
		"M4", "mt8127",
		MTK_EINT_FUNCTION(0, 106),
		MTK_FUNCTION(0, "GPI105"),
		MTK_FUNCTION(1, "RCN")
	),
	MTK_PIN(
		PINCTRL_PIN(106, "RCP"),
		"M5", "mt8127",
		MTK_EINT_FUNCTION(0, 107),
		MTK_FUNCTION(0, "GPI106"),
		MTK_FUNCTION(1, "RCP")
	),
	MTK_PIN(
		PINCTRL_PIN(107, "RDN2"),
		"M2", "mt8127",
		MTK_EINT_FUNCTION(0, 108),
		MTK_FUNCTION(0, "GPI107"),
		MTK_FUNCTION(1, "RDN2"),
		MTK_FUNCTION(2, "CMDAT8")
	),
	MTK_PIN(
		PINCTRL_PIN(108, "RDP2"),
		"M3", "mt8127",
		MTK_EINT_FUNCTION(0, 109),
		MTK_FUNCTION(0, "GPI108"),
		MTK_FUNCTION(1, "RDP2"),
		MTK_FUNCTION(2, "CMDAT9")
	),
	MTK_PIN(
		PINCTRL_PIN(109, "RDN3"),
		"N2", "mt8127",
		MTK_EINT_FUNCTION(0, 110),
		MTK_FUNCTION(0, "GPI109"),
		MTK_FUNCTION(1, "RDN3"),
		MTK_FUNCTION(2, "CMDAT4")
	),
	MTK_PIN(
		PINCTRL_PIN(110, "RDP3"),
		"N3", "mt8127",
		MTK_EINT_FUNCTION(0, 111),
		MTK_FUNCTION(0, "GPI110"),
		MTK_FUNCTION(1, "RDP3"),
		MTK_FUNCTION(2, "CMDAT5")
	),
	MTK_PIN(
		PINCTRL_PIN(111, "RCN_A"),
		"J5", "mt8127",
		MTK_EINT_FUNCTION(0, 112),
		MTK_FUNCTION(0, "GPI111"),
		MTK_FUNCTION(1, "RCN_A"),
		MTK_FUNCTION(2, "CMDAT6")
	),
	MTK_PIN(
		PINCTRL_PIN(112, "RCP_A"),
		"J4", "mt8127",
		MTK_EINT_FUNCTION(0, 113),
		MTK_FUNCTION(0, "GPI112"),
		MTK_FUNCTION(1, "RCP_A"),
		MTK_FUNCTION(2, "CMDAT7")
	),
	MTK_PIN(
		PINCTRL_PIN(113, "RDN1_A"),
		"J2", "mt8127",
		MTK_EINT_FUNCTION(0, 114),
		MTK_FUNCTION(0, "GPI113"),
		MTK_FUNCTION(1, "RDN1_A"),
		MTK_FUNCTION(2, "CMDAT2"),
		MTK_FUNCTION(3, "CMCSD2")
	),
	MTK_PIN(
		PINCTRL_PIN(114, "RDP1_A"),
		"J3", "mt8127",
		MTK_EINT_FUNCTION(0, 115),
		MTK_FUNCTION(0, "GPI114"),
		MTK_FUNCTION(1, "RDP1_A"),
		MTK_FUNCTION(2, "CMDAT3"),
		MTK_FUNCTION(3, "CMCSD3")
	),
	MTK_PIN(
		PINCTRL_PIN(115, "RDN0_A"),
		"H2", "mt8127",
		MTK_EINT_FUNCTION(0, 116),
		MTK_FUNCTION(0, "GPI115"),
		MTK_FUNCTION(1, "RDN0_A"),
		MTK_FUNCTION(2, "CMHSYNC")
	),
	MTK_PIN(
		PINCTRL_PIN(116, "RDP0_A"),
		"H3", "mt8127",
		MTK_EINT_FUNCTION(0, 117),
		MTK_FUNCTION(0, "GPI116"),
		MTK_FUNCTION(1, "RDP0_A"),
		MTK_FUNCTION(2, "CMVSYNC")
	),
	MTK_PIN(
		PINCTRL_PIN(117, "CMDAT0"),
		"G5", "mt8127",
		MTK_EINT_FUNCTION(0, 118),
		MTK_FUNCTION(0, "GPIO117"),
		MTK_FUNCTION(1, "CMDAT0"),
		MTK_FUNCTION(2, "CMCSD0"),
		MTK_FUNCTION(3, "ANT_SEL2"),
		MTK_FUNCTION(7, "DBG_MON_B[28]")
	),
	MTK_PIN(
		PINCTRL_PIN(118, "CMDAT1"),
		"G4", "mt8127",
		MTK_EINT_FUNCTION(0, 119),
		MTK_FUNCTION(0, "GPIO118"),
		MTK_FUNCTION(1, "CMDAT1"),
		MTK_FUNCTION(2, "CMCSD1"),
		MTK_FUNCTION(3, "ANT_SEL3"),
		MTK_FUNCTION(7, "DBG_MON_B[29]")
	),
	MTK_PIN(
		PINCTRL_PIN(119, "CMMCLK"),
		"F3", "mt8127",
		MTK_EINT_FUNCTION(0, 120),
		MTK_FUNCTION(0, "GPIO119"),
		MTK_FUNCTION(1, "CMMCLK"),
		MTK_FUNCTION(3, "ANT_SEL4"),
		MTK_FUNCTION(7, "DBG_MON_B[30]")
	),
	MTK_PIN(
		PINCTRL_PIN(120, "CMPCLK"),
		"G6", "mt8127",
		MTK_EINT_FUNCTION(0, 121),
		MTK_FUNCTION(0, "GPIO120"),
		MTK_FUNCTION(1, "CMPCLK"),
		MTK_FUNCTION(2, "CMCSK"),
		MTK_FUNCTION(3, "ANT_SEL5"),
		MTK_FUNCTION(7, "DBG_MON_B[31]")
	),
	MTK_PIN(
		PINCTRL_PIN(121, "MSDC1_CMD"),
		"E3", "mt8127",
		MTK_EINT_FUNCTION(0, 122),
		MTK_FUNCTION(0, "GPIO121"),
		MTK_FUNCTION(1, "MSDC1_CMD")
	),
	MTK_PIN(
		PINCTRL_PIN(122, "MSDC1_CLK"),
		"D1", "mt8127",
		MTK_EINT_FUNCTION(0, 123),
		MTK_FUNCTION(0, "GPIO122"),
		MTK_FUNCTION(1, "MSDC1_CLK")
	),
	MTK_PIN(
		PINCTRL_PIN(123, "MSDC1_DAT0"),
		"D2", "mt8127",
		MTK_EINT_FUNCTION(0, 124),
		MTK_FUNCTION(0, "GPIO123"),
		MTK_FUNCTION(1, "MSDC1_DAT0")
	),
	MTK_PIN(
		PINCTRL_PIN(124, "MSDC1_DAT1"),
		"D3", "mt8127",
		MTK_EINT_FUNCTION(0, 125),
		MTK_FUNCTION(0, "GPIO124"),
		MTK_FUNCTION(1, "MSDC1_DAT1")
	),
	MTK_PIN(
		PINCTRL_PIN(125, "MSDC1_DAT2"),
		"F2", "mt8127",
		MTK_EINT_FUNCTION(0, 126),
		MTK_FUNCTION(0, "GPIO125"),
		MTK_FUNCTION(1, "MSDC1_DAT2")
	),
	MTK_PIN(
		PINCTRL_PIN(126, "MSDC1_DAT3"),
		"E2", "mt8127",
		MTK_EINT_FUNCTION(0, 127),
		MTK_FUNCTION(0, "GPIO126"),
		MTK_FUNCTION(1, "MSDC1_DAT3")
	),
	MTK_PIN(
		PINCTRL_PIN(127, "MSDC0_DAT7"),
		"C23", "mt8127",
		MTK_EINT_FUNCTION(0, 128),
		MTK_FUNCTION(0, "GPIO127"),
		MTK_FUNCTION(1, "MSDC0_DAT7"),
		MTK_FUNCTION(4, "NLD7")
	),
	MTK_PIN(
		PINCTRL_PIN(128, "MSDC0_DAT6"),
		"C24", "mt8127",
		MTK_EINT_FUNCTION(0, 129),
		MTK_FUNCTION(0, "GPIO128"),
		MTK_FUNCTION(1, "MSDC0_DAT6"),
		MTK_FUNCTION(4, "NLD6")
	),
	MTK_PIN(
		PINCTRL_PIN(129, "MSDC0_DAT5"),
		"D22", "mt8127",
		MTK_EINT_FUNCTION(0, 130),
		MTK_FUNCTION(0, "GPIO129"),
		MTK_FUNCTION(1, "MSDC0_DAT5"),
		MTK_FUNCTION(4, "NLD4")
	),
	MTK_PIN(
		PINCTRL_PIN(130, "MSDC0_DAT4"),
		"D24", "mt8127",
		MTK_EINT_FUNCTION(0, 131),
		MTK_FUNCTION(0, "GPIO130"),
		MTK_FUNCTION(1, "MSDC0_DAT4"),
		MTK_FUNCTION(4, "NLD3")
	),
	MTK_PIN(
		PINCTRL_PIN(131, "MSDC0_RSTB"),
		"F24", "mt8127",
		MTK_EINT_FUNCTION(0, 132),
		MTK_FUNCTION(0, "GPIO131"),
		MTK_FUNCTION(1, "MSDC0_RSTB"),
		MTK_FUNCTION(4, "NLD0")
	),
	MTK_PIN(
		PINCTRL_PIN(132, "MSDC0_CMD"),
		"G20", "mt8127",
		MTK_EINT_FUNCTION(0, 133),
		MTK_FUNCTION(0, "GPIO132"),
		MTK_FUNCTION(1, "MSDC0_CMD"),
		MTK_FUNCTION(4, "NALE")
	),
	MTK_PIN(
		PINCTRL_PIN(133, "MSDC0_CLK"),
		"G21", "mt8127",
		MTK_EINT_FUNCTION(0, 134),
		MTK_FUNCTION(0, "GPIO133"),
		MTK_FUNCTION(1, "MSDC0_CLK"),
		MTK_FUNCTION(4, "NWEB")
	),
	MTK_PIN(
		PINCTRL_PIN(134, "MSDC0_DAT3"),
		"D23", "mt8127",
		MTK_EINT_FUNCTION(0, 135),
		MTK_FUNCTION(0, "GPIO134"),
		MTK_FUNCTION(1, "MSDC0_DAT3"),
		MTK_FUNCTION(4, "NLD1")
	),
	MTK_PIN(
		PINCTRL_PIN(135, "MSDC0_DAT2"),
		"E22", "mt8127",
		MTK_EINT_FUNCTION(0, 136),
		MTK_FUNCTION(0, "GPIO135"),
		MTK_FUNCTION(1, "MSDC0_DAT2"),
		MTK_FUNCTION(4, "NLD5")
	),
	MTK_PIN(
		PINCTRL_PIN(136, "MSDC0_DAT1"),
		"E23", "mt8127",
		MTK_EINT_FUNCTION(0, 137),
		MTK_FUNCTION(0, "GPIO136"),
		MTK_FUNCTION(1, "MSDC0_DAT1"),
		MTK_FUNCTION(4, "NLD8")
	),
	MTK_PIN(
		PINCTRL_PIN(137, "MSDC0_DAT0"),
		"F22", "mt8127",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO137"),
		MTK_FUNCTION(1, "MSDC0_DAT0"),
		MTK_FUNCTION(4, "WATCHDOG"),
		MTK_FUNCTION(5, "NLD2")
	),
	MTK_PIN(
		PINCTRL_PIN(138, "CEC"),
		"AE21", "mt8127",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO138"),
		MTK_FUNCTION(1, "CEC")
	),
	MTK_PIN(
		PINCTRL_PIN(139, "HTPLG"),
		"AD21", "mt8127",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO139"),
		MTK_FUNCTION(1, "HTPLG")
	),
	MTK_PIN(
		PINCTRL_PIN(140, "HDMISCK"),
		"AE22", "mt8127",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO140"),
		MTK_FUNCTION(1, "HDMISCK")
	),
	MTK_PIN(
		PINCTRL_PIN(141, "HDMISD"),
		"AD22", "mt8127",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO141"),
		MTK_FUNCTION(1, "HDMISD")
	),
	MTK_PIN(
		PINCTRL_PIN(142, "EINT21"),
		"J23", "mt8127",
		MTK_EINT_FUNCTION(0, 21),
		MTK_FUNCTION(0, "GPIO142"),
		MTK_FUNCTION(1, "NRNB"),
		MTK_FUNCTION(2, "ANT_SEL0"),
		MTK_FUNCTION(7, "DBG_MON_B[32]")
	),
};

#endif /* __PINCTRL_MTK_MT8127_H */
