/*
 * r8a7794/r8a7745 processor support - PFC hardware block.
 *
 * Copyright (C) 2014-2015 Renesas Electronics Corporation
 * Copyright (C) 2015 Renesas Solutions Corp.
 * Copyright (C) 2015-2017 Cogent Embedded, Inc. <source@cogentembedded.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 */

#include <linux/kernel.h>

#include "core.h"
#include "sh_pfc.h"

#define CPU_ALL_PORT(fn, sfx)						\
	PORT_GP_32(0, fn, sfx),						\
	PORT_GP_26(1, fn, sfx),						\
	PORT_GP_32(2, fn, sfx),						\
	PORT_GP_32(3, fn, sfx),						\
	PORT_GP_32(4, fn, sfx),						\
	PORT_GP_28(5, fn, sfx),						\
	PORT_GP_CFG_24(6, fn, sfx, SH_PFC_PIN_CFG_IO_VOLTAGE),		\
	PORT_GP_1(6, 24, fn, sfx),					\
	PORT_GP_1(6, 25, fn, sfx)

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	GP_ALL(DATA),
	PINMUX_DATA_END,

	PINMUX_FUNCTION_BEGIN,
	GP_ALL(FN),

	/* GPSR0 */
	FN_IP0_23_22, FN_IP0_24, FN_IP0_25, FN_IP0_27_26, FN_IP0_29_28,
	FN_IP0_31_30, FN_IP1_1_0, FN_IP1_3_2, FN_IP1_5_4, FN_IP1_7_6,
	FN_IP1_10_8, FN_IP1_12_11, FN_IP1_14_13, FN_IP1_17_15, FN_IP1_19_18,
	FN_IP1_21_20, FN_IP1_23_22, FN_IP1_24, FN_A2, FN_IP1_26, FN_IP1_27,
	FN_IP1_29_28, FN_IP1_31_30, FN_IP2_1_0, FN_IP2_3_2, FN_IP2_5_4,
	FN_IP2_7_6, FN_IP2_9_8, FN_IP2_11_10, FN_IP2_13_12, FN_IP2_15_14,
	FN_IP2_17_16,

	/* GPSR1 */
	FN_IP2_20_18, FN_IP2_23_21, FN_IP2_26_24, FN_IP2_29_27, FN_IP2_31_30,
	FN_IP3_1_0, FN_IP3_3_2, FN_IP3_5_4, FN_IP3_7_6, FN_IP3_9_8, FN_IP3_10,
	FN_IP3_11, FN_IP3_12, FN_IP3_14_13, FN_IP3_17_15, FN_IP3_20_18,
	FN_IP3_23_21, FN_IP3_26_24, FN_IP3_29_27, FN_IP3_30, FN_IP3_31,
	FN_WE0_N, FN_WE1_N, FN_IP4_1_0 , FN_IP7_31, FN_DACK0,

	/* GPSR2 */
	FN_IP4_4_2, FN_IP4_7_5, FN_IP4_9_8, FN_IP4_11_10, FN_IP4_13_12,
	FN_IP4_15_14, FN_IP4_17_16, FN_IP4_19_18, FN_IP4_22_20, FN_IP4_25_23,
	FN_IP4_27_26, FN_IP4_29_28, FN_IP4_31_30, FN_IP5_1_0, FN_IP5_3_2,
	FN_IP5_5_4, FN_IP5_8_6, FN_IP5_11_9, FN_IP5_13_12, FN_IP5_15_14,
	FN_IP5_17_16, FN_IP5_19_18, FN_IP5_21_20, FN_IP5_23_22, FN_IP5_25_24,
	FN_IP5_27_26, FN_IP5_29_28, FN_IP5_31_30, FN_IP6_1_0, FN_IP6_3_2,
	FN_IP6_5_4, FN_IP6_7_6,

	/* GPSR3 */
	FN_IP6_8, FN_IP6_9, FN_IP6_10, FN_IP6_11, FN_IP6_12, FN_IP6_13,
	FN_IP6_14, FN_IP6_15, FN_IP6_16, FN_IP6_19_17, FN_IP6_22_20,
	FN_IP6_25_23, FN_IP6_28_26, FN_IP6_31_29, FN_IP7_2_0, FN_IP7_5_3,
	FN_IP7_8_6, FN_IP7_11_9, FN_IP7_14_12, FN_IP7_17_15, FN_IP7_20_18,
	FN_IP7_23_21, FN_IP7_26_24, FN_IP7_29_27, FN_IP8_2_0, FN_IP8_5_3,
	FN_IP8_8_6, FN_IP8_11_9, FN_IP8_14_12, FN_IP8_16_15, FN_IP8_19_17,
	FN_IP8_22_20,

	/* GPSR4 */
	FN_IP8_25_23, FN_IP8_28_26, FN_IP8_31_29, FN_IP9_2_0, FN_IP9_5_3,
	FN_IP9_8_6, FN_IP9_11_9, FN_IP9_14_12, FN_IP9_16_15, FN_IP9_18_17,
	FN_IP9_21_19, FN_IP9_24_22, FN_IP9_27_25, FN_IP9_30_28, FN_IP10_2_0,
	FN_IP10_5_3, FN_IP10_8_6, FN_IP10_11_9, FN_IP10_14_12, FN_IP10_17_15,
	FN_IP10_20_18, FN_IP10_23_21, FN_IP10_26_24, FN_IP10_29_27,
	FN_IP10_31_30, FN_IP11_2_0, FN_IP11_5_3, FN_IP11_7_6, FN_IP11_10_8,
	FN_IP11_13_11, FN_IP11_15_14, FN_IP11_17_16,

	/* GPSR5 */
	FN_IP11_20_18, FN_IP11_23_21, FN_IP11_26_24, FN_IP11_29_27, FN_IP12_2_0,
	FN_IP12_5_3, FN_IP12_8_6, FN_IP12_10_9, FN_IP12_12_11, FN_IP12_14_13,
	FN_IP12_17_15, FN_IP12_20_18, FN_IP12_23_21, FN_IP12_26_24,
	FN_IP12_29_27, FN_IP13_2_0, FN_IP13_5_3, FN_IP13_8_6, FN_IP13_11_9,
	FN_IP13_14_12, FN_IP13_17_15, FN_IP13_20_18, FN_IP13_23_21,
	FN_IP13_26_24, FN_USB0_PWEN, FN_USB0_OVC, FN_USB1_PWEN, FN_USB1_OVC,

	/* GPSR6 */
	FN_SD0_CLK, FN_SD0_CMD, FN_SD0_DATA0, FN_SD0_DATA1, FN_SD0_DATA2,
	FN_SD0_DATA3, FN_SD0_CD, FN_SD0_WP, FN_SD1_CLK, FN_SD1_CMD,
	FN_SD1_DATA0, FN_SD1_DATA1, FN_SD1_DATA2, FN_SD1_DATA3, FN_IP0_0,
	FN_IP0_9_8, FN_IP0_10, FN_IP0_11, FN_IP0_12, FN_IP0_13, FN_IP0_14,
	FN_IP0_15, FN_IP0_16, FN_IP0_17, FN_IP0_19_18, FN_IP0_21_20,

	/* IPSR0 */
	FN_SD1_CD, FN_CAN0_RX, FN_SD1_WP, FN_IRQ7, FN_CAN0_TX, FN_MMC_CLK,
	FN_SD2_CLK, FN_MMC_CMD, FN_SD2_CMD, FN_MMC_D0, FN_SD2_DATA0, FN_MMC_D1,
	FN_SD2_DATA1, FN_MMC_D2, FN_SD2_DATA2, FN_MMC_D3, FN_SD2_DATA3,
	FN_MMC_D4, FN_SD2_CD, FN_MMC_D5, FN_SD2_WP, FN_MMC_D6, FN_SCIF0_RXD,
	FN_I2C2_SCL_B, FN_CAN1_RX, FN_MMC_D7, FN_SCIF0_TXD, FN_I2C2_SDA_B,
	FN_CAN1_TX, FN_D0, FN_SCIFA3_SCK_B, FN_IRQ4, FN_D1, FN_SCIFA3_RXD_B,
	FN_D2, FN_SCIFA3_TXD_B, FN_D3, FN_I2C3_SCL_B, FN_SCIF5_RXD_B, FN_D4,
	FN_I2C3_SDA_B, FN_SCIF5_TXD_B, FN_D5, FN_SCIF4_RXD_B, FN_I2C0_SCL_D,

	/* IPSR1 */
	FN_D6, FN_SCIF4_TXD_B, FN_I2C0_SDA_D,
	FN_D7, FN_IRQ3, FN_TCLK1, FN_PWM6_B,
	FN_D8, FN_HSCIF2_HRX, FN_I2C1_SCL_B,
	FN_D9, FN_HSCIF2_HTX, FN_I2C1_SDA_B,
	FN_D10, FN_HSCIF2_HSCK, FN_SCIF1_SCK_C, FN_IRQ6, FN_PWM5_C,
	FN_D11, FN_HSCIF2_HCTS_N, FN_SCIF1_RXD_C, FN_I2C1_SCL_D,
	FN_D12, FN_HSCIF2_HRTS_N, FN_SCIF1_TXD_C, FN_I2C1_SDA_D,
	FN_D13, FN_SCIFA1_SCK, FN_PWM2_C, FN_TCLK2_B,
	FN_D14, FN_SCIFA1_RXD, FN_I2C5_SCL_B,
	FN_D15, FN_SCIFA1_TXD, FN_I2C5_SDA_B,
	FN_A0, FN_SCIFB1_SCK, FN_PWM3_B,
	FN_A1, FN_SCIFB1_TXD,
	FN_A3, FN_SCIFB0_SCK,
	FN_A4, FN_SCIFB0_TXD,
	FN_A5, FN_SCIFB0_RXD, FN_PWM4_B, FN_TPUTO3_C,
	FN_A6, FN_SCIFB0_CTS_N, FN_SCIFA4_RXD_B, FN_TPUTO2_C,

	/* IPSR2 */
	FN_A7, FN_SCIFB0_RTS_N, FN_SCIFA4_TXD_B,
	FN_A8, FN_MSIOF1_RXD, FN_SCIFA0_RXD_B,
	FN_A9, FN_MSIOF1_TXD, FN_SCIFA0_TXD_B,
	FN_A10, FN_MSIOF1_SCK, FN_IIC0_SCL_B,
	FN_A11, FN_MSIOF1_SYNC, FN_IIC0_SDA_B,
	FN_A12, FN_MSIOF1_SS1, FN_SCIFA5_RXD_B,
	FN_A13, FN_MSIOF1_SS2, FN_SCIFA5_TXD_B,
	FN_A14, FN_MSIOF2_RXD, FN_HSCIF0_HRX_B, FN_DREQ1_N,
	FN_A15, FN_MSIOF2_TXD, FN_HSCIF0_HTX_B, FN_DACK1,
	FN_A16, FN_MSIOF2_SCK, FN_HSCIF0_HSCK_B, FN_SPEEDIN, FN_CAN_CLK_C,
	FN_TPUTO2_B,
	FN_A17, FN_MSIOF2_SYNC, FN_SCIF4_RXD_E, FN_CAN1_RX_B,
	FN_A18, FN_MSIOF2_SS1, FN_SCIF4_TXD_E, FN_CAN1_TX_B,
	FN_A19, FN_MSIOF2_SS2, FN_PWM4, FN_TPUTO2,
	FN_A20, FN_SPCLK,

	/* IPSR3 */
	FN_A21, FN_MOSI_IO0,
	FN_A22, FN_MISO_IO1, FN_ATADIR1_N,
	FN_A23, FN_IO2, FN_ATAWR1_N,
	FN_A24, FN_IO3, FN_EX_WAIT2,
	FN_A25, FN_SSL, FN_ATARD1_N,
	FN_CS0_N, FN_VI1_DATA8,
	FN_CS1_N_A26, FN_VI1_DATA9,
	FN_EX_CS0_N, FN_VI1_DATA10,
	FN_EX_CS1_N, FN_TPUTO3_B, FN_SCIFB2_RXD, FN_VI1_DATA11,
	FN_EX_CS2_N, FN_PWM0, FN_SCIF4_RXD_C, FN_TS_SDATA_B, FN_TPUTO3,
	FN_SCIFB2_TXD,
	FN_EX_CS3_N, FN_SCIFA2_SCK, FN_SCIF4_TXD_C, FN_TS_SCK_B, FN_BPFCLK,
	FN_SCIFB2_SCK,
	FN_EX_CS4_N, FN_SCIFA2_RXD, FN_I2C2_SCL_E, FN_TS_SDEN_B, FN_FMCLK,
	FN_SCIFB2_CTS_N,
	FN_EX_CS5_N, FN_SCIFA2_TXD, FN_I2C2_SDA_E, FN_TS_SPSYNC_B, FN_FMIN,
	FN_SCIFB2_RTS_N,
	FN_BS_N, FN_DRACK0, FN_PWM1_C, FN_TPUTO0_C, FN_ATACS01_N,
	FN_RD_N, FN_ATACS11_N,
	FN_RD_WR_N, FN_ATAG1_N,

	/* IPSR4 */
	FN_EX_WAIT0, FN_CAN_CLK_B, FN_SCIF_CLK,
	FN_DU0_DR0, FN_LCDOUT16, FN_SCIF5_RXD_C, FN_I2C2_SCL_D,
	FN_DU0_DR1, FN_LCDOUT17, FN_SCIF5_TXD_C, FN_I2C2_SDA_D,
	FN_DU0_DR2, FN_LCDOUT18,
	FN_DU0_DR3, FN_LCDOUT19,
	FN_DU0_DR4, FN_LCDOUT20,
	FN_DU0_DR5, FN_LCDOUT21,
	FN_DU0_DR6, FN_LCDOUT22,
	FN_DU0_DR7, FN_LCDOUT23,
	FN_DU0_DG0, FN_LCDOUT8, FN_SCIFA0_RXD_C, FN_I2C3_SCL_D,
	FN_DU0_DG1, FN_LCDOUT9, FN_SCIFA0_TXD_C, FN_I2C3_SDA_D,
	FN_DU0_DG2, FN_LCDOUT10,
	FN_DU0_DG3, FN_LCDOUT11,
	FN_DU0_DG4, FN_LCDOUT12,

	/* IPSR5 */
	FN_DU0_DG5, FN_LCDOUT13,
	FN_DU0_DG6, FN_LCDOUT14,
	FN_DU0_DG7, FN_LCDOUT15,
	FN_DU0_DB0, FN_LCDOUT0, FN_SCIFA4_RXD_C, FN_I2C4_SCL_D, FN_CAN0_RX_C,
	FN_DU0_DB1, FN_LCDOUT1, FN_SCIFA4_TXD_C, FN_I2C4_SDA_D, FN_CAN0_TX_C,
	FN_DU0_DB2, FN_LCDOUT2,
	FN_DU0_DB3, FN_LCDOUT3,
	FN_DU0_DB4, FN_LCDOUT4,
	FN_DU0_DB5, FN_LCDOUT5,
	FN_DU0_DB6, FN_LCDOUT6,
	FN_DU0_DB7, FN_LCDOUT7,
	FN_DU0_DOTCLKIN, FN_QSTVA_QVS,
	FN_DU0_DOTCLKOUT0, FN_QCLK,
	FN_DU0_DOTCLKOUT1, FN_QSTVB_QVE,
	FN_DU0_EXHSYNC_DU0_HSYNC, FN_QSTH_QHS,

	/* IPSR6 */
	FN_DU0_EXVSYNC_DU0_VSYNC, FN_QSTB_QHE,
	FN_DU0_EXODDF_DU0_ODDF_DISP_CDE, FN_QCPV_QDE,
	FN_DU0_DISP, FN_QPOLA,
	FN_DU0_CDE, FN_QPOLB,
	FN_VI0_CLK, FN_AVB_RX_CLK,
	FN_VI0_DATA0_VI0_B0, FN_AVB_RX_DV,
	FN_VI0_DATA1_VI0_B1, FN_AVB_RXD0,
	FN_VI0_DATA2_VI0_B2, FN_AVB_RXD1,
	FN_VI0_DATA3_VI0_B3, FN_AVB_RXD2,
	FN_VI0_DATA4_VI0_B4, FN_AVB_RXD3,
	FN_VI0_DATA5_VI0_B5, FN_AVB_RXD4,
	FN_VI0_DATA6_VI0_B6, FN_AVB_RXD5,
	FN_VI0_DATA7_VI0_B7, FN_AVB_RXD6,
	FN_VI0_CLKENB, FN_I2C3_SCL, FN_SCIFA5_RXD_C, FN_IETX_C, FN_AVB_RXD7,
	FN_VI0_FIELD, FN_I2C3_SDA, FN_SCIFA5_TXD_C, FN_IECLK_C, FN_AVB_RX_ER,
	FN_VI0_HSYNC_N, FN_SCIF0_RXD_B, FN_I2C0_SCL_C, FN_IERX_C, FN_AVB_COL,
	FN_VI0_VSYNC_N, FN_SCIF0_TXD_B, FN_I2C0_SDA_C, FN_AUDIO_CLKOUT_B,
	FN_AVB_TX_EN,
	FN_ETH_MDIO, FN_VI0_G0, FN_MSIOF2_RXD_B, FN_I2C5_SCL_D, FN_AVB_TX_CLK,
	FN_ADIDATA,

	/* IPSR7 */
	FN_ETH_CRS_DV, FN_VI0_G1, FN_MSIOF2_TXD_B, FN_I2C5_SDA_D, FN_AVB_TXD0,
	FN_ADICS_SAMP,
	FN_ETH_RX_ER, FN_VI0_G2, FN_MSIOF2_SCK_B, FN_CAN0_RX_B, FN_AVB_TXD1,
	FN_ADICLK,
	FN_ETH_RXD0, FN_VI0_G3,	FN_MSIOF2_SYNC_B, FN_CAN0_TX_B, FN_AVB_TXD2,
	FN_ADICHS0,
	FN_ETH_RXD1, FN_VI0_G4, FN_MSIOF2_SS1_B, FN_SCIF4_RXD_D, FN_AVB_TXD3,
	FN_ADICHS1,
	FN_ETH_LINK, FN_VI0_G5, FN_MSIOF2_SS2_B, FN_SCIF4_TXD_D, FN_AVB_TXD4,
	FN_ADICHS2,
	FN_ETH_REFCLK, FN_VI0_G6, FN_SCIF2_SCK_C, FN_AVB_TXD5, FN_SSI_SCK5_B,
	FN_ETH_TXD1, FN_VI0_G7, FN_SCIF2_RXD_C, FN_IIC0_SCL_D, FN_AVB_TXD6,
	FN_SSI_WS5_B,
	FN_ETH_TX_EN, FN_VI0_R0, FN_SCIF2_TXD_C, FN_IIC0_SDA_D, FN_AVB_TXD7,
	FN_SSI_SDATA5_B,
	FN_ETH_MAGIC, FN_VI0_R1, FN_SCIF3_SCK_B, FN_AVB_TX_ER, FN_SSI_SCK6_B,
	FN_ETH_TXD0, FN_VI0_R2, FN_SCIF3_RXD_B, FN_I2C4_SCL_E, FN_AVB_GTX_CLK,
	FN_SSI_WS6_B,
	FN_DREQ0_N, FN_SCIFB1_RXD,

	/* IPSR8 */
	FN_ETH_MDC, FN_VI0_R3, FN_SCIF3_TXD_B, FN_I2C4_SDA_E, FN_AVB_MDC,
	FN_SSI_SDATA6_B,
	FN_HSCIF0_HRX, FN_VI0_R4, FN_I2C1_SCL_C, FN_AUDIO_CLKA_B, FN_AVB_MDIO,
	FN_SSI_SCK78_B,
	FN_HSCIF0_HTX, FN_VI0_R5, FN_I2C1_SDA_C, FN_AUDIO_CLKB_B, FN_AVB_LINK,
	FN_SSI_WS78_B,
	FN_HSCIF0_HCTS_N, FN_VI0_R6, FN_SCIF0_RXD_D, FN_I2C0_SCL_E,
	FN_AVB_MAGIC, FN_SSI_SDATA7_B,
	FN_HSCIF0_HRTS_N, FN_VI0_R7, FN_SCIF0_TXD_D, FN_I2C0_SDA_E,
	FN_AVB_PHY_INT, FN_SSI_SDATA8_B,
	FN_HSCIF0_HSCK, FN_SCIF_CLK_B, FN_AVB_CRS, FN_AUDIO_CLKC_B,
	FN_I2C0_SCL, FN_SCIF0_RXD_C, FN_PWM5, FN_TCLK1_B, FN_AVB_GTXREFCLK,
	FN_CAN1_RX_D, FN_TPUTO0_B,
	FN_I2C0_SDA, FN_SCIF0_TXD_C, FN_TPUTO0, FN_CAN_CLK, FN_DVC_MUTE,
	FN_CAN1_TX_D,
	FN_I2C1_SCL, FN_SCIF4_RXD, FN_PWM5_B, FN_DU1_DR0, FN_TS_SDATA_D,
	FN_TPUTO1_B,
	FN_I2C1_SDA, FN_SCIF4_TXD, FN_IRQ5, FN_DU1_DR1, FN_TS_SCK_D,
	FN_BPFCLK_C,
	FN_MSIOF0_RXD, FN_SCIF5_RXD, FN_I2C2_SCL_C, FN_DU1_DR2, FN_TS_SDEN_D,
	FN_FMCLK_C,

	/* IPSR9 */
	FN_MSIOF0_TXD, FN_SCIF5_TXD, FN_I2C2_SDA_C, FN_DU1_DR3, FN_TS_SPSYNC_D,
	FN_FMIN_C,
	FN_MSIOF0_SCK, FN_IRQ0, FN_TS_SDATA, FN_DU1_DR4, FN_TPUTO1_C,
	FN_MSIOF0_SYNC, FN_PWM1, FN_TS_SCK, FN_DU1_DR5, FN_BPFCLK_B,
	FN_MSIOF0_SS1, FN_SCIFA0_RXD, FN_TS_SDEN, FN_DU1_DR6, FN_FMCLK_B,
	FN_MSIOF0_SS2, FN_SCIFA0_TXD, FN_TS_SPSYNC, FN_DU1_DR7, FN_FMIN_B,
	FN_HSCIF1_HRX, FN_I2C4_SCL, FN_PWM6, FN_DU1_DG0,
	FN_HSCIF1_HTX, FN_I2C4_SDA, FN_TPUTO1, FN_DU1_DG1,
	FN_HSCIF1_HSCK, FN_PWM2, FN_IETX, FN_DU1_DG2, FN_REMOCON_B,
	FN_SPEEDIN_B,
	FN_HSCIF1_HCTS_N, FN_SCIFA4_RXD, FN_IECLK, FN_DU1_DG3, FN_SSI_SCK1_B,
	FN_HSCIF1_HRTS_N, FN_SCIFA4_TXD, FN_IERX, FN_DU1_DG4, FN_SSI_WS1_B,
	FN_SCIF1_SCK, FN_PWM3, FN_TCLK2, FN_DU1_DG5, FN_SSI_SDATA1_B,

	/* IPSR10 */
	FN_SCIF1_RXD, FN_I2C5_SCL, FN_DU1_DG6, FN_SSI_SCK2_B,
	FN_SCIF1_TXD, FN_I2C5_SDA, FN_DU1_DG7, FN_SSI_WS2_B,
	FN_SCIF2_RXD, FN_IIC0_SCL, FN_DU1_DB0, FN_SSI_SDATA2_B,
	FN_SCIF2_TXD, FN_IIC0_SDA, FN_DU1_DB1, FN_SSI_SCK9_B,
	FN_SCIF2_SCK, FN_IRQ1, FN_DU1_DB2, FN_SSI_WS9_B,
	FN_SCIF3_SCK, FN_IRQ2, FN_BPFCLK_D, FN_DU1_DB3, FN_SSI_SDATA9_B,
	FN_SCIF3_RXD, FN_I2C1_SCL_E, FN_FMCLK_D, FN_DU1_DB4, FN_AUDIO_CLKA_C,
	FN_SSI_SCK4_B,
	FN_SCIF3_TXD, FN_I2C1_SDA_E, FN_FMIN_D, FN_DU1_DB5, FN_AUDIO_CLKB_C,
	FN_SSI_WS4_B,
	FN_I2C2_SCL, FN_SCIFA5_RXD, FN_DU1_DB6, FN_AUDIO_CLKC_C,
	FN_SSI_SDATA4_B,
	FN_I2C2_SDA, FN_SCIFA5_TXD, FN_DU1_DB7, FN_AUDIO_CLKOUT_C,
	FN_SSI_SCK5, FN_SCIFA3_SCK, FN_DU1_DOTCLKIN,

	/* IPSR11 */
	FN_SSI_WS5, FN_SCIFA3_RXD, FN_I2C3_SCL_C, FN_DU1_DOTCLKOUT0,
	FN_SSI_SDATA5, FN_SCIFA3_TXD, FN_I2C3_SDA_C, FN_DU1_DOTCLKOUT1,
	FN_SSI_SCK6, FN_SCIFA1_SCK_B, FN_DU1_EXHSYNC_DU1_HSYNC,
	FN_SSI_WS6, FN_SCIFA1_RXD_B, FN_I2C4_SCL_C, FN_DU1_EXVSYNC_DU1_VSYNC,
	FN_SSI_SDATA6, FN_SCIFA1_TXD_B, FN_I2C4_SDA_C,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE,
	FN_SSI_SCK78, FN_SCIFA2_SCK_B, FN_I2C5_SDA_C, FN_DU1_DISP,
	FN_SSI_WS78, FN_SCIFA2_RXD_B, FN_I2C5_SCL_C, FN_DU1_CDE,
	FN_SSI_SDATA7, FN_SCIFA2_TXD_B, FN_IRQ8, FN_AUDIO_CLKA_D, FN_CAN_CLK_D,
	FN_SSI_SCK0129, FN_MSIOF1_RXD_B, FN_SCIF5_RXD_D, FN_ADIDATA_B,
	FN_SSI_WS0129, FN_MSIOF1_TXD_B, FN_SCIF5_TXD_D, FN_ADICS_SAMP_B,
	FN_SSI_SDATA0, FN_MSIOF1_SCK_B, FN_PWM0_B, FN_ADICLK_B,

	/* IPSR12 */
	FN_SSI_SCK34, FN_MSIOF1_SYNC_B, FN_SCIFA1_SCK_C, FN_ADICHS0_B,
	FN_DREQ1_N_B,
	FN_SSI_WS34, FN_MSIOF1_SS1_B, FN_SCIFA1_RXD_C, FN_ADICHS1_B,
	FN_CAN1_RX_C, FN_DACK1_B,
	FN_SSI_SDATA3, FN_MSIOF1_SS2_B, FN_SCIFA1_TXD_C, FN_ADICHS2_B,
	FN_CAN1_TX_C, FN_DREQ2_N,
	FN_SSI_SCK4, FN_MLB_CLK, FN_IETX_B, FN_SSI_WS4, FN_MLB_SIG, FN_IECLK_B,
	FN_SSI_SDATA4, FN_MLB_DAT, FN_IERX_B,
	FN_SSI_SDATA8, FN_SCIF1_SCK_B, FN_PWM1_B, FN_IRQ9, FN_REMOCON,
	FN_DACK2, FN_ETH_MDIO_B,
	FN_SSI_SCK1, FN_SCIF1_RXD_B, FN_IIC0_SCL_C, FN_VI1_CLK, FN_CAN0_RX_D,
	FN_ETH_CRS_DV_B,
	FN_SSI_WS1, FN_SCIF1_TXD_B, FN_IIC0_SDA_C, FN_VI1_DATA0, FN_CAN0_TX_D,
	FN_ETH_RX_ER_B,
	FN_SSI_SDATA1, FN_HSCIF1_HRX_B, FN_VI1_DATA1, FN_ATAWR0_N,
	FN_ETH_RXD0_B,
	FN_SSI_SCK2, FN_HSCIF1_HTX_B, FN_VI1_DATA2, FN_ATAG0_N, FN_ETH_RXD1_B,

	/* IPSR13 */
	FN_SSI_WS2, FN_HSCIF1_HCTS_N_B, FN_SCIFA0_RXD_D, FN_VI1_DATA3,
	FN_ATACS00_N, FN_ETH_LINK_B,
	FN_SSI_SDATA2, FN_HSCIF1_HRTS_N_B, FN_SCIFA0_TXD_D, FN_VI1_DATA4,
	FN_ATACS10_N, FN_ETH_REFCLK_B,
	FN_SSI_SCK9, FN_SCIF2_SCK_B, FN_PWM2_B, FN_VI1_DATA5, FN_EX_WAIT1,
	FN_ETH_TXD1_B,
	FN_SSI_WS9, FN_SCIF2_RXD_B, FN_I2C3_SCL_E, FN_VI1_DATA6, FN_ATARD0_N,
	FN_ETH_TX_EN_B,
	FN_SSI_SDATA9, FN_SCIF2_TXD_B, FN_I2C3_SDA_E, FN_VI1_DATA7,
	FN_ATADIR0_N, FN_ETH_MAGIC_B,
	FN_AUDIO_CLKA, FN_I2C0_SCL_B, FN_SCIFA4_RXD_D, FN_VI1_CLKENB,
	FN_TS_SDATA_C, FN_ETH_TXD0_B,
	FN_AUDIO_CLKB, FN_I2C0_SDA_B, FN_SCIFA4_TXD_D, FN_VI1_FIELD,
	FN_TS_SCK_C, FN_BPFCLK_E, FN_ETH_MDC_B,
	FN_AUDIO_CLKC, FN_I2C4_SCL_B, FN_SCIFA5_RXD_D, FN_VI1_HSYNC_N,
	FN_TS_SDEN_C, FN_FMCLK_E,
	FN_AUDIO_CLKOUT, FN_I2C4_SDA_B, FN_SCIFA5_TXD_D, FN_VI1_VSYNC_N,
	FN_TS_SPSYNC_C, FN_FMIN_E,

	/* MOD_SEL */
	FN_SEL_ADG_0, FN_SEL_ADG_1, FN_SEL_ADG_2, FN_SEL_ADG_3,
	FN_SEL_CAN_0, FN_SEL_CAN_1, FN_SEL_CAN_2, FN_SEL_CAN_3,
	FN_SEL_DARC_0, FN_SEL_DARC_1, FN_SEL_DARC_2, FN_SEL_DARC_3,
	FN_SEL_DARC_4,
	FN_SEL_ETH_0, FN_SEL_ETH_1,
	FN_SEL_I2C00_0, FN_SEL_I2C00_1, FN_SEL_I2C00_2,	FN_SEL_I2C00_3,
	FN_SEL_I2C00_4,
	FN_SEL_I2C01_0, FN_SEL_I2C01_1,	FN_SEL_I2C01_2, FN_SEL_I2C01_3,
	FN_SEL_I2C01_4,
	FN_SEL_I2C02_0, FN_SEL_I2C02_1, FN_SEL_I2C02_2, FN_SEL_I2C02_3,
	FN_SEL_I2C02_4,
	FN_SEL_I2C03_0, FN_SEL_I2C03_1, FN_SEL_I2C03_2, FN_SEL_I2C03_3,
	FN_SEL_I2C03_4,
	FN_SEL_I2C04_0, FN_SEL_I2C04_1, FN_SEL_I2C04_2,	FN_SEL_I2C04_3,
	FN_SEL_I2C04_4,
	FN_SEL_I2C05_0, FN_SEL_I2C05_1,	FN_SEL_I2C05_2, FN_SEL_I2C05_3,

	/* MOD_SEL2 */
	FN_SEL_IEB_0, FN_SEL_IEB_1, FN_SEL_IEB_2,
	FN_SEL_IIC0_0, FN_SEL_IIC0_1, FN_SEL_IIC0_2, FN_SEL_IIC0_3,
	FN_SEL_LBS_0, FN_SEL_LBS_1, FN_SEL_MSI1_0, FN_SEL_MSI1_1,
	FN_SEL_MSI2_0, FN_SEL_MSI2_1, FN_SEL_RAD_0, FN_SEL_RAD_1,
	FN_SEL_RCN_0, FN_SEL_RCN_1, FN_SEL_RSP_0, FN_SEL_RSP_1,
	FN_SEL_SCIFA0_0, FN_SEL_SCIFA0_1, FN_SEL_SCIFA0_2, FN_SEL_SCIFA0_3,
	FN_SEL_SCIFA1_0, FN_SEL_SCIFA1_1, FN_SEL_SCIFA1_2,
	FN_SEL_SCIFA2_0, FN_SEL_SCIFA2_1, FN_SEL_SCIFA3_0, FN_SEL_SCIFA3_1,
	FN_SEL_SCIFA4_0, FN_SEL_SCIFA4_1, FN_SEL_SCIFA4_2, FN_SEL_SCIFA4_3,
	FN_SEL_SCIFA5_0, FN_SEL_SCIFA5_1, FN_SEL_SCIFA5_2, FN_SEL_SCIFA5_3,
	FN_SEL_TMU_0, FN_SEL_TMU_1,
	FN_SEL_TSIF0_0, FN_SEL_TSIF0_1, FN_SEL_TSIF0_2, FN_SEL_TSIF0_3,
	FN_SEL_CAN0_0, FN_SEL_CAN0_1, FN_SEL_CAN0_2, FN_SEL_CAN0_3,
	FN_SEL_CAN1_0, FN_SEL_CAN1_1, FN_SEL_CAN1_2, FN_SEL_CAN1_3,
	FN_SEL_HSCIF0_0, FN_SEL_HSCIF0_1, FN_SEL_HSCIF1_0, FN_SEL_HSCIF1_1,

	/* MOD_SEL3 */
	FN_SEL_SCIF0_0, FN_SEL_SCIF0_1, FN_SEL_SCIF0_2, FN_SEL_SCIF0_3,
	FN_SEL_SCIF1_0, FN_SEL_SCIF1_1, FN_SEL_SCIF1_2, FN_SEL_SCIF2_0,
	FN_SEL_SCIF2_1, FN_SEL_SCIF2_2, FN_SEL_SCIF3_0, FN_SEL_SCIF3_1,
	FN_SEL_SCIF4_0, FN_SEL_SCIF4_1, FN_SEL_SCIF4_2, FN_SEL_SCIF4_3,
	FN_SEL_SCIF4_4, FN_SEL_SCIF5_0, FN_SEL_SCIF5_1, FN_SEL_SCIF5_2,
	FN_SEL_SCIF5_3, FN_SEL_SSI1_0, FN_SEL_SSI1_1, FN_SEL_SSI2_0,
	FN_SEL_SSI2_1, FN_SEL_SSI4_0, FN_SEL_SSI4_1, FN_SEL_SSI5_0,
	FN_SEL_SSI5_1, FN_SEL_SSI6_0, FN_SEL_SSI6_1, FN_SEL_SSI7_0,
	FN_SEL_SSI7_1, FN_SEL_SSI8_0, FN_SEL_SSI8_1, FN_SEL_SSI9_0,
	FN_SEL_SSI9_1,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	A2_MARK, WE0_N_MARK, WE1_N_MARK, DACK0_MARK,

	USB0_PWEN_MARK, USB0_OVC_MARK, USB1_PWEN_MARK, USB1_OVC_MARK,

	SD0_CLK_MARK, SD0_CMD_MARK, SD0_DATA0_MARK, SD0_DATA1_MARK,
	SD0_DATA2_MARK, SD0_DATA3_MARK, SD0_CD_MARK, SD0_WP_MARK,

	SD1_CLK_MARK, SD1_CMD_MARK, SD1_DATA0_MARK, SD1_DATA1_MARK,
	SD1_DATA2_MARK, SD1_DATA3_MARK,

	/* IPSR0 */
	SD1_CD_MARK, CAN0_RX_MARK, SD1_WP_MARK, IRQ7_MARK, CAN0_TX_MARK,
	MMC_CLK_MARK, SD2_CLK_MARK, MMC_CMD_MARK, SD2_CMD_MARK, MMC_D0_MARK,
	SD2_DATA0_MARK, MMC_D1_MARK, SD2_DATA1_MARK, MMC_D2_MARK,
	SD2_DATA2_MARK, MMC_D3_MARK, SD2_DATA3_MARK, MMC_D4_MARK, SD2_CD_MARK,
	MMC_D5_MARK, SD2_WP_MARK, MMC_D6_MARK, SCIF0_RXD_MARK, I2C2_SCL_B_MARK,
	CAN1_RX_MARK, MMC_D7_MARK, SCIF0_TXD_MARK, I2C2_SDA_B_MARK,
	CAN1_TX_MARK, D0_MARK, SCIFA3_SCK_B_MARK, IRQ4_MARK, D1_MARK,
	SCIFA3_RXD_B_MARK, D2_MARK, SCIFA3_TXD_B_MARK, D3_MARK, I2C3_SCL_B_MARK,
	SCIF5_RXD_B_MARK, D4_MARK, I2C3_SDA_B_MARK, SCIF5_TXD_B_MARK, D5_MARK,
	SCIF4_RXD_B_MARK, I2C0_SCL_D_MARK,

	/* IPSR1 */
	D6_MARK, SCIF4_TXD_B_MARK, I2C0_SDA_D_MARK,
	D7_MARK, IRQ3_MARK, TCLK1_MARK, PWM6_B_MARK,
	D8_MARK, HSCIF2_HRX_MARK, I2C1_SCL_B_MARK,
	D9_MARK, HSCIF2_HTX_MARK, I2C1_SDA_B_MARK,
	D10_MARK, HSCIF2_HSCK_MARK, SCIF1_SCK_C_MARK, IRQ6_MARK, PWM5_C_MARK,
	D11_MARK, HSCIF2_HCTS_N_MARK, SCIF1_RXD_C_MARK, I2C1_SCL_D_MARK,
	D12_MARK, HSCIF2_HRTS_N_MARK, SCIF1_TXD_C_MARK, I2C1_SDA_D_MARK,
	D13_MARK, SCIFA1_SCK_MARK, PWM2_C_MARK, TCLK2_B_MARK,
	D14_MARK, SCIFA1_RXD_MARK, I2C5_SCL_B_MARK,
	D15_MARK, SCIFA1_TXD_MARK, I2C5_SDA_B_MARK,
	A0_MARK, SCIFB1_SCK_MARK, PWM3_B_MARK,
	A1_MARK, SCIFB1_TXD_MARK,
	A3_MARK, SCIFB0_SCK_MARK,
	A4_MARK, SCIFB0_TXD_MARK,
	A5_MARK, SCIFB0_RXD_MARK, PWM4_B_MARK, TPUTO3_C_MARK,
	A6_MARK, SCIFB0_CTS_N_MARK, SCIFA4_RXD_B_MARK, TPUTO2_C_MARK,

	/* IPSR2 */
	A7_MARK, SCIFB0_RTS_N_MARK, SCIFA4_TXD_B_MARK,
	A8_MARK, MSIOF1_RXD_MARK, SCIFA0_RXD_B_MARK,
	A9_MARK, MSIOF1_TXD_MARK, SCIFA0_TXD_B_MARK,
	A10_MARK, MSIOF1_SCK_MARK, IIC0_SCL_B_MARK,
	A11_MARK, MSIOF1_SYNC_MARK, IIC0_SDA_B_MARK,
	A12_MARK, MSIOF1_SS1_MARK, SCIFA5_RXD_B_MARK,
	A13_MARK, MSIOF1_SS2_MARK, SCIFA5_TXD_B_MARK,
	A14_MARK, MSIOF2_RXD_MARK, HSCIF0_HRX_B_MARK, DREQ1_N_MARK,
	A15_MARK, MSIOF2_TXD_MARK, HSCIF0_HTX_B_MARK, DACK1_MARK,
	A16_MARK, MSIOF2_SCK_MARK, HSCIF0_HSCK_B_MARK, SPEEDIN_MARK,
	CAN_CLK_C_MARK, TPUTO2_B_MARK,
	A17_MARK, MSIOF2_SYNC_MARK, SCIF4_RXD_E_MARK, CAN1_RX_B_MARK,
	A18_MARK, MSIOF2_SS1_MARK, SCIF4_TXD_E_MARK, CAN1_TX_B_MARK,
	A19_MARK, MSIOF2_SS2_MARK, PWM4_MARK, TPUTO2_MARK,
	A20_MARK, SPCLK_MARK,

	/* IPSR3 */
	A21_MARK, MOSI_IO0_MARK,
	A22_MARK, MISO_IO1_MARK, ATADIR1_N_MARK,
	A23_MARK, IO2_MARK, ATAWR1_N_MARK,
	A24_MARK, IO3_MARK, EX_WAIT2_MARK,
	A25_MARK, SSL_MARK, ATARD1_N_MARK,
	CS0_N_MARK, VI1_DATA8_MARK,
	CS1_N_A26_MARK, VI1_DATA9_MARK,
	EX_CS0_N_MARK, VI1_DATA10_MARK,
	EX_CS1_N_MARK, TPUTO3_B_MARK, SCIFB2_RXD_MARK, VI1_DATA11_MARK,
	EX_CS2_N_MARK, PWM0_MARK, SCIF4_RXD_C_MARK, TS_SDATA_B_MARK,
	TPUTO3_MARK, SCIFB2_TXD_MARK,
	EX_CS3_N_MARK, SCIFA2_SCK_MARK, SCIF4_TXD_C_MARK, TS_SCK_B_MARK,
	BPFCLK_MARK, SCIFB2_SCK_MARK,
	EX_CS4_N_MARK, SCIFA2_RXD_MARK, I2C2_SCL_E_MARK, TS_SDEN_B_MARK,
	FMCLK_MARK, SCIFB2_CTS_N_MARK,
	EX_CS5_N_MARK, SCIFA2_TXD_MARK, I2C2_SDA_E_MARK, TS_SPSYNC_B_MARK,
	FMIN_MARK, SCIFB2_RTS_N_MARK,
	BS_N_MARK, DRACK0_MARK, PWM1_C_MARK, TPUTO0_C_MARK, ATACS01_N_MARK,
	RD_N_MARK, ATACS11_N_MARK,
	RD_WR_N_MARK, ATAG1_N_MARK,

	/* IPSR4 */
	EX_WAIT0_MARK, CAN_CLK_B_MARK, SCIF_CLK_MARK,
	DU0_DR0_MARK, LCDOUT16_MARK, SCIF5_RXD_C_MARK, I2C2_SCL_D_MARK,
	DU0_DR1_MARK, LCDOUT17_MARK, SCIF5_TXD_C_MARK, I2C2_SDA_D_MARK,
	DU0_DR2_MARK, LCDOUT18_MARK,
	DU0_DR3_MARK, LCDOUT19_MARK,
	DU0_DR4_MARK, LCDOUT20_MARK,
	DU0_DR5_MARK, LCDOUT21_MARK,
	DU0_DR6_MARK, LCDOUT22_MARK,
	DU0_DR7_MARK, LCDOUT23_MARK,
	DU0_DG0_MARK, LCDOUT8_MARK, SCIFA0_RXD_C_MARK, I2C3_SCL_D_MARK,
	DU0_DG1_MARK, LCDOUT9_MARK, SCIFA0_TXD_C_MARK, I2C3_SDA_D_MARK,
	DU0_DG2_MARK, LCDOUT10_MARK,
	DU0_DG3_MARK, LCDOUT11_MARK,
	DU0_DG4_MARK, LCDOUT12_MARK,

	/* IPSR5 */
	DU0_DG5_MARK, LCDOUT13_MARK,
	DU0_DG6_MARK, LCDOUT14_MARK,
	DU0_DG7_MARK, LCDOUT15_MARK,
	DU0_DB0_MARK, LCDOUT0_MARK, SCIFA4_RXD_C_MARK, I2C4_SCL_D_MARK,
	CAN0_RX_C_MARK,
	DU0_DB1_MARK, LCDOUT1_MARK, SCIFA4_TXD_C_MARK, I2C4_SDA_D_MARK,
	CAN0_TX_C_MARK,
	DU0_DB2_MARK, LCDOUT2_MARK,
	DU0_DB3_MARK, LCDOUT3_MARK,
	DU0_DB4_MARK, LCDOUT4_MARK,
	DU0_DB5_MARK, LCDOUT5_MARK,
	DU0_DB6_MARK, LCDOUT6_MARK,
	DU0_DB7_MARK, LCDOUT7_MARK,
	DU0_DOTCLKIN_MARK, QSTVA_QVS_MARK,
	DU0_DOTCLKOUT0_MARK, QCLK_MARK,
	DU0_DOTCLKOUT1_MARK, QSTVB_QVE_MARK,
	DU0_EXHSYNC_DU0_HSYNC_MARK, QSTH_QHS_MARK,

	/* IPSR6 */
	DU0_EXVSYNC_DU0_VSYNC_MARK, QSTB_QHE_MARK,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK, QCPV_QDE_MARK,
	DU0_DISP_MARK, QPOLA_MARK, DU0_CDE_MARK, QPOLB_MARK,
	VI0_CLK_MARK, AVB_RX_CLK_MARK, VI0_DATA0_VI0_B0_MARK, AVB_RX_DV_MARK,
	VI0_DATA1_VI0_B1_MARK, AVB_RXD0_MARK,
	VI0_DATA2_VI0_B2_MARK, AVB_RXD1_MARK,
	VI0_DATA3_VI0_B3_MARK, AVB_RXD2_MARK,
	VI0_DATA4_VI0_B4_MARK, AVB_RXD3_MARK,
	VI0_DATA5_VI0_B5_MARK, AVB_RXD4_MARK,
	VI0_DATA6_VI0_B6_MARK, AVB_RXD5_MARK,
	VI0_DATA7_VI0_B7_MARK, AVB_RXD6_MARK,
	VI0_CLKENB_MARK, I2C3_SCL_MARK, SCIFA5_RXD_C_MARK, IETX_C_MARK,
	AVB_RXD7_MARK,
	VI0_FIELD_MARK, I2C3_SDA_MARK, SCIFA5_TXD_C_MARK, IECLK_C_MARK,
	AVB_RX_ER_MARK,
	VI0_HSYNC_N_MARK, SCIF0_RXD_B_MARK, I2C0_SCL_C_MARK, IERX_C_MARK,
	AVB_COL_MARK,
	VI0_VSYNC_N_MARK, SCIF0_TXD_B_MARK, I2C0_SDA_C_MARK,
	AUDIO_CLKOUT_B_MARK, AVB_TX_EN_MARK,
	ETH_MDIO_MARK, VI0_G0_MARK, MSIOF2_RXD_B_MARK, I2C5_SCL_D_MARK,
	AVB_TX_CLK_MARK, ADIDATA_MARK,

	/* IPSR7 */
	ETH_CRS_DV_MARK, VI0_G1_MARK, MSIOF2_TXD_B_MARK, I2C5_SDA_D_MARK,
	AVB_TXD0_MARK, ADICS_SAMP_MARK,
	ETH_RX_ER_MARK, VI0_G2_MARK, MSIOF2_SCK_B_MARK, CAN0_RX_B_MARK,
	AVB_TXD1_MARK, ADICLK_MARK,
	ETH_RXD0_MARK, VI0_G3_MARK, MSIOF2_SYNC_B_MARK, CAN0_TX_B_MARK,
	AVB_TXD2_MARK, ADICHS0_MARK,
	ETH_RXD1_MARK, VI0_G4_MARK, MSIOF2_SS1_B_MARK, SCIF4_RXD_D_MARK,
	AVB_TXD3_MARK, ADICHS1_MARK,
	ETH_LINK_MARK, VI0_G5_MARK, MSIOF2_SS2_B_MARK, SCIF4_TXD_D_MARK,
	AVB_TXD4_MARK, ADICHS2_MARK,
	ETH_REFCLK_MARK, VI0_G6_MARK, SCIF2_SCK_C_MARK, AVB_TXD5_MARK,
	SSI_SCK5_B_MARK,
	ETH_TXD1_MARK, VI0_G7_MARK, SCIF2_RXD_C_MARK, IIC0_SCL_D_MARK,
	AVB_TXD6_MARK, SSI_WS5_B_MARK,
	ETH_TX_EN_MARK, VI0_R0_MARK, SCIF2_TXD_C_MARK, IIC0_SDA_D_MARK,
	AVB_TXD7_MARK, SSI_SDATA5_B_MARK,
	ETH_MAGIC_MARK, VI0_R1_MARK, SCIF3_SCK_B_MARK, AVB_TX_ER_MARK,
	SSI_SCK6_B_MARK,
	ETH_TXD0_MARK, VI0_R2_MARK, SCIF3_RXD_B_MARK, I2C4_SCL_E_MARK,
	AVB_GTX_CLK_MARK, SSI_WS6_B_MARK,
	DREQ0_N_MARK, SCIFB1_RXD_MARK,

	/* IPSR8 */
	ETH_MDC_MARK, VI0_R3_MARK, SCIF3_TXD_B_MARK, I2C4_SDA_E_MARK,
	AVB_MDC_MARK, SSI_SDATA6_B_MARK, HSCIF0_HRX_MARK, VI0_R4_MARK,
	I2C1_SCL_C_MARK, AUDIO_CLKA_B_MARK, AVB_MDIO_MARK, SSI_SCK78_B_MARK,
	HSCIF0_HTX_MARK, VI0_R5_MARK, I2C1_SDA_C_MARK, AUDIO_CLKB_B_MARK,
	AVB_LINK_MARK, SSI_WS78_B_MARK, HSCIF0_HCTS_N_MARK, VI0_R6_MARK,
	SCIF0_RXD_D_MARK, I2C0_SCL_E_MARK, AVB_MAGIC_MARK, SSI_SDATA7_B_MARK,
	HSCIF0_HRTS_N_MARK, VI0_R7_MARK, SCIF0_TXD_D_MARK, I2C0_SDA_E_MARK,
	AVB_PHY_INT_MARK, SSI_SDATA8_B_MARK,
	HSCIF0_HSCK_MARK, SCIF_CLK_B_MARK, AVB_CRS_MARK, AUDIO_CLKC_B_MARK,
	I2C0_SCL_MARK, SCIF0_RXD_C_MARK, PWM5_MARK, TCLK1_B_MARK,
	AVB_GTXREFCLK_MARK, CAN1_RX_D_MARK, TPUTO0_B_MARK, I2C0_SDA_MARK,
	SCIF0_TXD_C_MARK, TPUTO0_MARK, CAN_CLK_MARK, DVC_MUTE_MARK,
	CAN1_TX_D_MARK,
	I2C1_SCL_MARK, SCIF4_RXD_MARK, PWM5_B_MARK, DU1_DR0_MARK,
	TS_SDATA_D_MARK, TPUTO1_B_MARK,
	I2C1_SDA_MARK, SCIF4_TXD_MARK, IRQ5_MARK, DU1_DR1_MARK,	TS_SCK_D_MARK,
	BPFCLK_C_MARK,
	MSIOF0_RXD_MARK, SCIF5_RXD_MARK, I2C2_SCL_C_MARK, DU1_DR2_MARK,
	TS_SDEN_D_MARK, FMCLK_C_MARK,

	/* IPSR9 */
	MSIOF0_TXD_MARK, SCIF5_TXD_MARK, I2C2_SDA_C_MARK, DU1_DR3_MARK,
	TS_SPSYNC_D_MARK, FMIN_C_MARK,
	MSIOF0_SCK_MARK, IRQ0_MARK, TS_SDATA_MARK, DU1_DR4_MARK, TPUTO1_C_MARK,
	MSIOF0_SYNC_MARK, PWM1_MARK, TS_SCK_MARK, DU1_DR5_MARK, BPFCLK_B_MARK,
	MSIOF0_SS1_MARK, SCIFA0_RXD_MARK, TS_SDEN_MARK, DU1_DR6_MARK,
	FMCLK_B_MARK,
	MSIOF0_SS2_MARK, SCIFA0_TXD_MARK, TS_SPSYNC_MARK, DU1_DR7_MARK,
	FMIN_B_MARK,
	HSCIF1_HRX_MARK, I2C4_SCL_MARK, PWM6_MARK, DU1_DG0_MARK,
	HSCIF1_HTX_MARK, I2C4_SDA_MARK, TPUTO1_MARK, DU1_DG1_MARK,
	HSCIF1_HSCK_MARK, PWM2_MARK, IETX_MARK, DU1_DG2_MARK, REMOCON_B_MARK,
	SPEEDIN_B_MARK,
	HSCIF1_HCTS_N_MARK, SCIFA4_RXD_MARK, IECLK_MARK, DU1_DG3_MARK,
	SSI_SCK1_B_MARK,
	HSCIF1_HRTS_N_MARK, SCIFA4_TXD_MARK, IERX_MARK, DU1_DG4_MARK,
	SSI_WS1_B_MARK,
	SCIF1_SCK_MARK, PWM3_MARK, TCLK2_MARK, DU1_DG5_MARK, SSI_SDATA1_B_MARK,
	CAN_TXCLK_MARK,

	/* IPSR10 */
	SCIF1_RXD_MARK, I2C5_SCL_MARK, DU1_DG6_MARK, SSI_SCK2_B_MARK,
	SCIF1_TXD_MARK, I2C5_SDA_MARK, DU1_DG7_MARK, SSI_WS2_B_MARK,
	SCIF2_RXD_MARK, IIC0_SCL_MARK, DU1_DB0_MARK, SSI_SDATA2_B_MARK,
	SCIF2_TXD_MARK, IIC0_SDA_MARK, DU1_DB1_MARK, SSI_SCK9_B_MARK,
	SCIF2_SCK_MARK, IRQ1_MARK, DU1_DB2_MARK, SSI_WS9_B_MARK,
	SCIF3_SCK_MARK, IRQ2_MARK, BPFCLK_D_MARK, DU1_DB3_MARK,
	SSI_SDATA9_B_MARK,
	SCIF3_RXD_MARK, I2C1_SCL_E_MARK, FMCLK_D_MARK, DU1_DB4_MARK,
	AUDIO_CLKA_C_MARK, SSI_SCK4_B_MARK,
	SCIF3_TXD_MARK, I2C1_SDA_E_MARK, FMIN_D_MARK, DU1_DB5_MARK,
	AUDIO_CLKB_C_MARK, SSI_WS4_B_MARK,
	I2C2_SCL_MARK, SCIFA5_RXD_MARK, DU1_DB6_MARK, AUDIO_CLKC_C_MARK,
	SSI_SDATA4_B_MARK,
	I2C2_SDA_MARK, SCIFA5_TXD_MARK, DU1_DB7_MARK, AUDIO_CLKOUT_C_MARK,
	SSI_SCK5_MARK, SCIFA3_SCK_MARK, DU1_DOTCLKIN_MARK,

	/* IPSR11 */
	SSI_WS5_MARK, SCIFA3_RXD_MARK, I2C3_SCL_C_MARK, DU1_DOTCLKOUT0_MARK,
	SSI_SDATA5_MARK, SCIFA3_TXD_MARK, I2C3_SDA_C_MARK, DU1_DOTCLKOUT1_MARK,
	SSI_SCK6_MARK, SCIFA1_SCK_B_MARK, DU1_EXHSYNC_DU1_HSYNC_MARK,
	SSI_WS6_MARK, SCIFA1_RXD_B_MARK, I2C4_SCL_C_MARK,
	DU1_EXVSYNC_DU1_VSYNC_MARK,
	SSI_SDATA6_MARK, SCIFA1_TXD_B_MARK, I2C4_SDA_C_MARK,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK,
	SSI_SCK78_MARK, SCIFA2_SCK_B_MARK, I2C5_SDA_C_MARK, DU1_DISP_MARK,
	SSI_WS78_MARK, SCIFA2_RXD_B_MARK, I2C5_SCL_C_MARK, DU1_CDE_MARK,
	SSI_SDATA7_MARK, SCIFA2_TXD_B_MARK, IRQ8_MARK, AUDIO_CLKA_D_MARK,
	CAN_CLK_D_MARK,
	SSI_SCK0129_MARK, MSIOF1_RXD_B_MARK, SCIF5_RXD_D_MARK, ADIDATA_B_MARK,
	SSI_WS0129_MARK, MSIOF1_TXD_B_MARK, SCIF5_TXD_D_MARK, ADICS_SAMP_B_MARK,
	SSI_SDATA0_MARK, MSIOF1_SCK_B_MARK, PWM0_B_MARK, ADICLK_B_MARK,

	/* IPSR12 */
	SSI_SCK34_MARK, MSIOF1_SYNC_B_MARK, SCIFA1_SCK_C_MARK, ADICHS0_B_MARK,
	DREQ1_N_B_MARK,
	SSI_WS34_MARK, MSIOF1_SS1_B_MARK, SCIFA1_RXD_C_MARK, ADICHS1_B_MARK,
	CAN1_RX_C_MARK, DACK1_B_MARK,
	SSI_SDATA3_MARK, MSIOF1_SS2_B_MARK, SCIFA1_TXD_C_MARK, ADICHS2_B_MARK,
	CAN1_TX_C_MARK, DREQ2_N_MARK,
	SSI_SCK4_MARK, MLB_CLK_MARK, IETX_B_MARK,
	SSI_WS4_MARK, MLB_SIG_MARK, IECLK_B_MARK,
	SSI_SDATA4_MARK, MLB_DAT_MARK, IERX_B_MARK,
	SSI_SDATA8_MARK, SCIF1_SCK_B_MARK, PWM1_B_MARK, IRQ9_MARK, REMOCON_MARK,
	DACK2_MARK, ETH_MDIO_B_MARK,
	SSI_SCK1_MARK, SCIF1_RXD_B_MARK, IIC0_SCL_C_MARK, VI1_CLK_MARK,
	CAN0_RX_D_MARK, ETH_CRS_DV_B_MARK,
	SSI_WS1_MARK, SCIF1_TXD_B_MARK, IIC0_SDA_C_MARK, VI1_DATA0_MARK,
	CAN0_TX_D_MARK, ETH_RX_ER_B_MARK,
	SSI_SDATA1_MARK, HSCIF1_HRX_B_MARK, VI1_DATA1_MARK, ATAWR0_N_MARK,
	ETH_RXD0_B_MARK,
	SSI_SCK2_MARK, HSCIF1_HTX_B_MARK, VI1_DATA2_MARK, ATAG0_N_MARK,
	ETH_RXD1_B_MARK,

	/* IPSR13 */
	SSI_WS2_MARK, HSCIF1_HCTS_N_B_MARK, SCIFA0_RXD_D_MARK, VI1_DATA3_MARK,
	ATACS00_N_MARK, ETH_LINK_B_MARK,
	SSI_SDATA2_MARK, HSCIF1_HRTS_N_B_MARK, SCIFA0_TXD_D_MARK,
	VI1_DATA4_MARK, ATACS10_N_MARK, ETH_REFCLK_B_MARK,
	SSI_SCK9_MARK, SCIF2_SCK_B_MARK, PWM2_B_MARK, VI1_DATA5_MARK,
	EX_WAIT1_MARK, ETH_TXD1_B_MARK,
	SSI_WS9_MARK, SCIF2_RXD_B_MARK, I2C3_SCL_E_MARK, VI1_DATA6_MARK,
	ATARD0_N_MARK, ETH_TX_EN_B_MARK,
	SSI_SDATA9_MARK, SCIF2_TXD_B_MARK, I2C3_SDA_E_MARK, VI1_DATA7_MARK,
	ATADIR0_N_MARK, ETH_MAGIC_B_MARK,
	AUDIO_CLKA_MARK, I2C0_SCL_B_MARK, SCIFA4_RXD_D_MARK, VI1_CLKENB_MARK,
	TS_SDATA_C_MARK, ETH_TXD0_B_MARK,
	AUDIO_CLKB_MARK, I2C0_SDA_B_MARK, SCIFA4_TXD_D_MARK, VI1_FIELD_MARK,
	TS_SCK_C_MARK, BPFCLK_E_MARK, ETH_MDC_B_MARK,
	AUDIO_CLKC_MARK, I2C4_SCL_B_MARK, SCIFA5_RXD_D_MARK, VI1_HSYNC_N_MARK,
	TS_SDEN_C_MARK, FMCLK_E_MARK,
	AUDIO_CLKOUT_MARK, I2C4_SDA_B_MARK, SCIFA5_TXD_D_MARK, VI1_VSYNC_N_MARK,
	TS_SPSYNC_C_MARK, FMIN_E_MARK,
	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	PINMUX_DATA_GP_ALL(), /* PINMUX_DATA(GP_M_N_DATA, GP_M_N_FN...), */

	PINMUX_SINGLE(A2),
	PINMUX_SINGLE(WE0_N),
	PINMUX_SINGLE(WE1_N),
	PINMUX_SINGLE(DACK0),
	PINMUX_SINGLE(USB0_PWEN),
	PINMUX_SINGLE(USB0_OVC),
	PINMUX_SINGLE(USB1_PWEN),
	PINMUX_SINGLE(USB1_OVC),
	PINMUX_SINGLE(SD0_CLK),
	PINMUX_SINGLE(SD0_CMD),
	PINMUX_SINGLE(SD0_DATA0),
	PINMUX_SINGLE(SD0_DATA1),
	PINMUX_SINGLE(SD0_DATA2),
	PINMUX_SINGLE(SD0_DATA3),
	PINMUX_SINGLE(SD0_CD),
	PINMUX_SINGLE(SD0_WP),
	PINMUX_SINGLE(SD1_CLK),
	PINMUX_SINGLE(SD1_CMD),
	PINMUX_SINGLE(SD1_DATA0),
	PINMUX_SINGLE(SD1_DATA1),
	PINMUX_SINGLE(SD1_DATA2),
	PINMUX_SINGLE(SD1_DATA3),

	/* IPSR0 */
	PINMUX_IPSR_GPSR(IP0_0, SD1_CD),
	PINMUX_IPSR_MSEL(IP0_0, CAN0_RX, SEL_CAN0_0),
	PINMUX_IPSR_GPSR(IP0_9_8, SD1_WP),
	PINMUX_IPSR_GPSR(IP0_9_8, IRQ7),
	PINMUX_IPSR_MSEL(IP0_9_8, CAN0_TX, SEL_CAN0_0),
	PINMUX_IPSR_GPSR(IP0_10, MMC_CLK),
	PINMUX_IPSR_GPSR(IP0_10, SD2_CLK),
	PINMUX_IPSR_GPSR(IP0_11, MMC_CMD),
	PINMUX_IPSR_GPSR(IP0_11, SD2_CMD),
	PINMUX_IPSR_GPSR(IP0_12, MMC_D0),
	PINMUX_IPSR_GPSR(IP0_12, SD2_DATA0),
	PINMUX_IPSR_GPSR(IP0_13, MMC_D1),
	PINMUX_IPSR_GPSR(IP0_13, SD2_DATA1),
	PINMUX_IPSR_GPSR(IP0_14, MMC_D2),
	PINMUX_IPSR_GPSR(IP0_14, SD2_DATA2),
	PINMUX_IPSR_GPSR(IP0_15, MMC_D3),
	PINMUX_IPSR_GPSR(IP0_15, SD2_DATA3),
	PINMUX_IPSR_GPSR(IP0_16, MMC_D4),
	PINMUX_IPSR_GPSR(IP0_16, SD2_CD),
	PINMUX_IPSR_GPSR(IP0_17, MMC_D5),
	PINMUX_IPSR_GPSR(IP0_17, SD2_WP),
	PINMUX_IPSR_GPSR(IP0_19_18, MMC_D6),
	PINMUX_IPSR_MSEL(IP0_19_18, SCIF0_RXD, SEL_SCIF0_0),
	PINMUX_IPSR_MSEL(IP0_19_18, I2C2_SCL_B, SEL_I2C02_1),
	PINMUX_IPSR_MSEL(IP0_19_18, CAN1_RX, SEL_CAN1_0),
	PINMUX_IPSR_GPSR(IP0_21_20, MMC_D7),
	PINMUX_IPSR_MSEL(IP0_21_20, SCIF0_TXD, SEL_SCIF0_0),
	PINMUX_IPSR_MSEL(IP0_21_20, I2C2_SDA_B, SEL_I2C02_1),
	PINMUX_IPSR_MSEL(IP0_21_20, CAN1_TX, SEL_CAN1_0),
	PINMUX_IPSR_GPSR(IP0_23_22, D0),
	PINMUX_IPSR_MSEL(IP0_23_22, SCIFA3_SCK_B, SEL_SCIFA3_1),
	PINMUX_IPSR_GPSR(IP0_23_22, IRQ4),
	PINMUX_IPSR_GPSR(IP0_24, D1),
	PINMUX_IPSR_MSEL(IP0_24, SCIFA3_RXD_B, SEL_SCIFA3_1),
	PINMUX_IPSR_GPSR(IP0_25, D2),
	PINMUX_IPSR_MSEL(IP0_25, SCIFA3_TXD_B, SEL_SCIFA3_1),
	PINMUX_IPSR_GPSR(IP0_27_26, D3),
	PINMUX_IPSR_MSEL(IP0_27_26, I2C3_SCL_B, SEL_I2C03_1),
	PINMUX_IPSR_MSEL(IP0_27_26, SCIF5_RXD_B, SEL_SCIF5_1),
	PINMUX_IPSR_GPSR(IP0_29_28, D4),
	PINMUX_IPSR_MSEL(IP0_29_28, I2C3_SDA_B, SEL_I2C03_1),
	PINMUX_IPSR_MSEL(IP0_29_28, SCIF5_TXD_B, SEL_SCIF5_1),
	PINMUX_IPSR_GPSR(IP0_31_30, D5),
	PINMUX_IPSR_MSEL(IP0_31_30, SCIF4_RXD_B, SEL_SCIF4_1),
	PINMUX_IPSR_MSEL(IP0_31_30, I2C0_SCL_D, SEL_I2C00_3),

	/* IPSR1 */
	PINMUX_IPSR_GPSR(IP1_1_0, D6),
	PINMUX_IPSR_MSEL(IP1_1_0, SCIF4_TXD_B, SEL_SCIF4_1),
	PINMUX_IPSR_MSEL(IP1_1_0, I2C0_SDA_D, SEL_I2C00_3),
	PINMUX_IPSR_GPSR(IP1_3_2, D7),
	PINMUX_IPSR_GPSR(IP1_3_2, IRQ3),
	PINMUX_IPSR_MSEL(IP1_3_2, TCLK1, SEL_TMU_0),
	PINMUX_IPSR_GPSR(IP1_3_2, PWM6_B),
	PINMUX_IPSR_GPSR(IP1_5_4, D8),
	PINMUX_IPSR_GPSR(IP1_5_4, HSCIF2_HRX),
	PINMUX_IPSR_MSEL(IP1_5_4, I2C1_SCL_B, SEL_I2C01_1),
	PINMUX_IPSR_GPSR(IP1_7_6, D9),
	PINMUX_IPSR_GPSR(IP1_7_6, HSCIF2_HTX),
	PINMUX_IPSR_MSEL(IP1_7_6, I2C1_SDA_B, SEL_I2C01_1),
	PINMUX_IPSR_GPSR(IP1_10_8, D10),
	PINMUX_IPSR_GPSR(IP1_10_8, HSCIF2_HSCK),
	PINMUX_IPSR_MSEL(IP1_10_8, SCIF1_SCK_C, SEL_SCIF1_2),
	PINMUX_IPSR_GPSR(IP1_10_8, IRQ6),
	PINMUX_IPSR_GPSR(IP1_10_8, PWM5_C),
	PINMUX_IPSR_GPSR(IP1_12_11, D11),
	PINMUX_IPSR_GPSR(IP1_12_11, HSCIF2_HCTS_N),
	PINMUX_IPSR_MSEL(IP1_12_11, SCIF1_RXD_C, SEL_SCIF1_2),
	PINMUX_IPSR_MSEL(IP1_12_11, I2C1_SCL_D, SEL_I2C01_3),
	PINMUX_IPSR_GPSR(IP1_14_13, D12),
	PINMUX_IPSR_GPSR(IP1_14_13, HSCIF2_HRTS_N),
	PINMUX_IPSR_MSEL(IP1_14_13, SCIF1_TXD_C, SEL_SCIF1_2),
	PINMUX_IPSR_MSEL(IP1_14_13, I2C1_SDA_D, SEL_I2C01_3),
	PINMUX_IPSR_GPSR(IP1_17_15, D13),
	PINMUX_IPSR_MSEL(IP1_17_15, SCIFA1_SCK, SEL_SCIFA1_0),
	PINMUX_IPSR_GPSR(IP1_17_15, PWM2_C),
	PINMUX_IPSR_MSEL(IP1_17_15, TCLK2_B, SEL_TMU_1),
	PINMUX_IPSR_GPSR(IP1_19_18, D14),
	PINMUX_IPSR_MSEL(IP1_19_18, SCIFA1_RXD, SEL_SCIFA1_0),
	PINMUX_IPSR_MSEL(IP1_19_18, I2C5_SCL_B, SEL_I2C05_1),
	PINMUX_IPSR_GPSR(IP1_21_20, D15),
	PINMUX_IPSR_MSEL(IP1_21_20, SCIFA1_TXD, SEL_SCIFA1_0),
	PINMUX_IPSR_MSEL(IP1_21_20, I2C5_SDA_B, SEL_I2C05_1),
	PINMUX_IPSR_GPSR(IP1_23_22, A0),
	PINMUX_IPSR_GPSR(IP1_23_22, SCIFB1_SCK),
	PINMUX_IPSR_GPSR(IP1_23_22, PWM3_B),
	PINMUX_IPSR_GPSR(IP1_24, A1),
	PINMUX_IPSR_GPSR(IP1_24, SCIFB1_TXD),
	PINMUX_IPSR_GPSR(IP1_26, A3),
	PINMUX_IPSR_GPSR(IP1_26, SCIFB0_SCK),
	PINMUX_IPSR_GPSR(IP1_27, A4),
	PINMUX_IPSR_GPSR(IP1_27, SCIFB0_TXD),
	PINMUX_IPSR_GPSR(IP1_29_28, A5),
	PINMUX_IPSR_GPSR(IP1_29_28, SCIFB0_RXD),
	PINMUX_IPSR_GPSR(IP1_29_28, PWM4_B),
	PINMUX_IPSR_GPSR(IP1_29_28, TPUTO3_C),
	PINMUX_IPSR_GPSR(IP1_31_30, A6),
	PINMUX_IPSR_GPSR(IP1_31_30, SCIFB0_CTS_N),
	PINMUX_IPSR_MSEL(IP1_31_30, SCIFA4_RXD_B, SEL_SCIFA4_1),
	PINMUX_IPSR_GPSR(IP1_31_30, TPUTO2_C),

	/* IPSR2 */
	PINMUX_IPSR_GPSR(IP2_1_0, A7),
	PINMUX_IPSR_GPSR(IP2_1_0, SCIFB0_RTS_N),
	PINMUX_IPSR_MSEL(IP2_1_0, SCIFA4_TXD_B, SEL_SCIFA4_1),
	PINMUX_IPSR_GPSR(IP2_3_2, A8),
	PINMUX_IPSR_MSEL(IP2_3_2, MSIOF1_RXD, SEL_MSI1_0),
	PINMUX_IPSR_MSEL(IP2_3_2, SCIFA0_RXD_B, SEL_SCIFA0_1),
	PINMUX_IPSR_GPSR(IP2_5_4, A9),
	PINMUX_IPSR_MSEL(IP2_5_4, MSIOF1_TXD, SEL_MSI1_0),
	PINMUX_IPSR_MSEL(IP2_5_4, SCIFA0_TXD_B, SEL_SCIFA0_1),
	PINMUX_IPSR_GPSR(IP2_7_6, A10),
	PINMUX_IPSR_MSEL(IP2_7_6, MSIOF1_SCK, SEL_MSI1_0),
	PINMUX_IPSR_MSEL(IP2_7_6, IIC0_SCL_B, SEL_IIC0_1),
	PINMUX_IPSR_GPSR(IP2_9_8, A11),
	PINMUX_IPSR_MSEL(IP2_9_8, MSIOF1_SYNC, SEL_MSI1_0),
	PINMUX_IPSR_MSEL(IP2_9_8, IIC0_SDA_B, SEL_IIC0_1),
	PINMUX_IPSR_GPSR(IP2_11_10, A12),
	PINMUX_IPSR_MSEL(IP2_11_10, MSIOF1_SS1, SEL_MSI1_0),
	PINMUX_IPSR_MSEL(IP2_11_10, SCIFA5_RXD_B, SEL_SCIFA5_1),
	PINMUX_IPSR_GPSR(IP2_13_12, A13),
	PINMUX_IPSR_MSEL(IP2_13_12, MSIOF1_SS2, SEL_MSI1_0),
	PINMUX_IPSR_MSEL(IP2_13_12, SCIFA5_TXD_B, SEL_SCIFA5_1),
	PINMUX_IPSR_GPSR(IP2_15_14, A14),
	PINMUX_IPSR_MSEL(IP2_15_14, MSIOF2_RXD, SEL_MSI2_0),
	PINMUX_IPSR_MSEL(IP2_15_14, HSCIF0_HRX_B, SEL_HSCIF0_1),
	PINMUX_IPSR_MSEL(IP2_15_14, DREQ1_N, SEL_LBS_0),
	PINMUX_IPSR_GPSR(IP2_17_16, A15),
	PINMUX_IPSR_MSEL(IP2_17_16, MSIOF2_TXD, SEL_MSI2_0),
	PINMUX_IPSR_MSEL(IP2_17_16, HSCIF0_HTX_B, SEL_HSCIF0_1),
	PINMUX_IPSR_MSEL(IP2_17_16, DACK1, SEL_LBS_0),
	PINMUX_IPSR_GPSR(IP2_20_18, A16),
	PINMUX_IPSR_MSEL(IP2_20_18, MSIOF2_SCK, SEL_MSI2_0),
	PINMUX_IPSR_MSEL(IP2_20_18, HSCIF0_HSCK_B, SEL_HSCIF0_1),
	PINMUX_IPSR_MSEL(IP2_20_18, SPEEDIN, SEL_RSP_0),
	PINMUX_IPSR_MSEL(IP2_20_18, CAN_CLK_C, SEL_CAN_2),
	PINMUX_IPSR_GPSR(IP2_20_18, TPUTO2_B),
	PINMUX_IPSR_GPSR(IP2_23_21, A17),
	PINMUX_IPSR_MSEL(IP2_23_21, MSIOF2_SYNC, SEL_MSI2_0),
	PINMUX_IPSR_MSEL(IP2_23_21, SCIF4_RXD_E, SEL_SCIF4_4),
	PINMUX_IPSR_MSEL(IP2_23_21, CAN1_RX_B, SEL_CAN1_1),
	PINMUX_IPSR_GPSR(IP2_26_24, A18),
	PINMUX_IPSR_MSEL(IP2_26_24, MSIOF2_SS1, SEL_MSI2_0),
	PINMUX_IPSR_MSEL(IP2_26_24, SCIF4_TXD_E, SEL_SCIF4_4),
	PINMUX_IPSR_MSEL(IP2_26_24, CAN1_TX_B, SEL_CAN1_1),
	PINMUX_IPSR_GPSR(IP2_29_27, A19),
	PINMUX_IPSR_MSEL(IP2_29_27, MSIOF2_SS2, SEL_MSI2_0),
	PINMUX_IPSR_GPSR(IP2_29_27, PWM4),
	PINMUX_IPSR_GPSR(IP2_29_27, TPUTO2),
	PINMUX_IPSR_GPSR(IP2_31_30, A20),
	PINMUX_IPSR_GPSR(IP2_31_30, SPCLK),

	/* IPSR3 */
	PINMUX_IPSR_GPSR(IP3_1_0, A21),
	PINMUX_IPSR_GPSR(IP3_1_0, MOSI_IO0),
	PINMUX_IPSR_GPSR(IP3_3_2, A22),
	PINMUX_IPSR_GPSR(IP3_3_2, MISO_IO1),
	PINMUX_IPSR_GPSR(IP3_3_2, ATADIR1_N),
	PINMUX_IPSR_GPSR(IP3_5_4, A23),
	PINMUX_IPSR_GPSR(IP3_5_4, IO2),
	PINMUX_IPSR_GPSR(IP3_5_4, ATAWR1_N),
	PINMUX_IPSR_GPSR(IP3_7_6, A24),
	PINMUX_IPSR_GPSR(IP3_7_6, IO3),
	PINMUX_IPSR_GPSR(IP3_7_6, EX_WAIT2),
	PINMUX_IPSR_GPSR(IP3_9_8, A25),
	PINMUX_IPSR_GPSR(IP3_9_8, SSL),
	PINMUX_IPSR_GPSR(IP3_9_8, ATARD1_N),
	PINMUX_IPSR_GPSR(IP3_10, CS0_N),
	PINMUX_IPSR_GPSR(IP3_10, VI1_DATA8),
	PINMUX_IPSR_GPSR(IP3_11, CS1_N_A26),
	PINMUX_IPSR_GPSR(IP3_11, VI1_DATA9),
	PINMUX_IPSR_GPSR(IP3_12, EX_CS0_N),
	PINMUX_IPSR_GPSR(IP3_12, VI1_DATA10),
	PINMUX_IPSR_GPSR(IP3_14_13, EX_CS1_N),
	PINMUX_IPSR_GPSR(IP3_14_13, TPUTO3_B),
	PINMUX_IPSR_GPSR(IP3_14_13, SCIFB2_RXD),
	PINMUX_IPSR_GPSR(IP3_14_13, VI1_DATA11),
	PINMUX_IPSR_GPSR(IP3_17_15, EX_CS2_N),
	PINMUX_IPSR_GPSR(IP3_17_15, PWM0),
	PINMUX_IPSR_MSEL(IP3_17_15, SCIF4_RXD_C, SEL_SCIF4_2),
	PINMUX_IPSR_MSEL(IP3_17_15, TS_SDATA_B, SEL_TSIF0_1),
	PINMUX_IPSR_GPSR(IP3_17_15, TPUTO3),
	PINMUX_IPSR_GPSR(IP3_17_15, SCIFB2_TXD),
	PINMUX_IPSR_GPSR(IP3_20_18, EX_CS3_N),
	PINMUX_IPSR_MSEL(IP3_20_18, SCIFA2_SCK, SEL_SCIFA2_0),
	PINMUX_IPSR_MSEL(IP3_20_18, SCIF4_TXD_C, SEL_SCIF4_2),
	PINMUX_IPSR_MSEL(IP3_20_18, TS_SCK_B, SEL_TSIF0_1),
	PINMUX_IPSR_MSEL(IP3_20_18, BPFCLK, SEL_DARC_0),
	PINMUX_IPSR_GPSR(IP3_20_18, SCIFB2_SCK),
	PINMUX_IPSR_GPSR(IP3_23_21, EX_CS4_N),
	PINMUX_IPSR_MSEL(IP3_23_21, SCIFA2_RXD, SEL_SCIFA2_0),
	PINMUX_IPSR_MSEL(IP3_23_21, I2C2_SCL_E, SEL_I2C02_4),
	PINMUX_IPSR_MSEL(IP3_23_21, TS_SDEN_B, SEL_TSIF0_1),
	PINMUX_IPSR_MSEL(IP3_23_21, FMCLK, SEL_DARC_0),
	PINMUX_IPSR_GPSR(IP3_23_21, SCIFB2_CTS_N),
	PINMUX_IPSR_GPSR(IP3_26_24, EX_CS5_N),
	PINMUX_IPSR_MSEL(IP3_26_24, SCIFA2_TXD, SEL_SCIFA2_0),
	PINMUX_IPSR_MSEL(IP3_26_24, I2C2_SDA_E, SEL_I2C02_4),
	PINMUX_IPSR_MSEL(IP3_26_24, TS_SPSYNC_B, SEL_TSIF0_1),
	PINMUX_IPSR_MSEL(IP3_26_24, FMIN, SEL_DARC_0),
	PINMUX_IPSR_GPSR(IP3_26_24, SCIFB2_RTS_N),
	PINMUX_IPSR_GPSR(IP3_29_27, BS_N),
	PINMUX_IPSR_GPSR(IP3_29_27, DRACK0),
	PINMUX_IPSR_GPSR(IP3_29_27, PWM1_C),
	PINMUX_IPSR_GPSR(IP3_29_27, TPUTO0_C),
	PINMUX_IPSR_GPSR(IP3_29_27, ATACS01_N),
	PINMUX_IPSR_GPSR(IP3_30, RD_N),
	PINMUX_IPSR_GPSR(IP3_30, ATACS11_N),
	PINMUX_IPSR_GPSR(IP3_31, RD_WR_N),
	PINMUX_IPSR_GPSR(IP3_31, ATAG1_N),

	/* IPSR4 */
	PINMUX_IPSR_GPSR(IP4_1_0, EX_WAIT0),
	PINMUX_IPSR_MSEL(IP4_1_0, CAN_CLK_B, SEL_CAN_1),
	PINMUX_IPSR_MSEL(IP4_1_0, SCIF_CLK, SEL_SCIF0_0),
	PINMUX_IPSR_GPSR(IP4_4_2, DU0_DR0),
	PINMUX_IPSR_GPSR(IP4_4_2, LCDOUT16),
	PINMUX_IPSR_MSEL(IP4_4_2, SCIF5_RXD_C, SEL_SCIF5_2),
	PINMUX_IPSR_MSEL(IP4_4_2, I2C2_SCL_D, SEL_I2C02_3),
	PINMUX_IPSR_GPSR(IP4_7_5, DU0_DR1),
	PINMUX_IPSR_GPSR(IP4_7_5, LCDOUT17),
	PINMUX_IPSR_MSEL(IP4_7_5, SCIF5_TXD_C, SEL_SCIF5_2),
	PINMUX_IPSR_MSEL(IP4_7_5, I2C2_SDA_D, SEL_I2C02_3),
	PINMUX_IPSR_GPSR(IP4_9_8, DU0_DR2),
	PINMUX_IPSR_GPSR(IP4_9_8, LCDOUT18),
	PINMUX_IPSR_GPSR(IP4_11_10, DU0_DR3),
	PINMUX_IPSR_GPSR(IP4_11_10, LCDOUT19),
	PINMUX_IPSR_GPSR(IP4_13_12, DU0_DR4),
	PINMUX_IPSR_GPSR(IP4_13_12, LCDOUT20),
	PINMUX_IPSR_GPSR(IP4_15_14, DU0_DR5),
	PINMUX_IPSR_GPSR(IP4_15_14, LCDOUT21),
	PINMUX_IPSR_GPSR(IP4_17_16, DU0_DR6),
	PINMUX_IPSR_GPSR(IP4_17_16, LCDOUT22),
	PINMUX_IPSR_GPSR(IP4_19_18, DU0_DR7),
	PINMUX_IPSR_GPSR(IP4_19_18, LCDOUT23),
	PINMUX_IPSR_GPSR(IP4_22_20, DU0_DG0),
	PINMUX_IPSR_GPSR(IP4_22_20, LCDOUT8),
	PINMUX_IPSR_MSEL(IP4_22_20, SCIFA0_RXD_C, SEL_SCIFA0_2),
	PINMUX_IPSR_MSEL(IP4_22_20, I2C3_SCL_D, SEL_I2C03_3),
	PINMUX_IPSR_GPSR(IP4_25_23, DU0_DG1),
	PINMUX_IPSR_GPSR(IP4_25_23, LCDOUT9),
	PINMUX_IPSR_MSEL(IP4_25_23, SCIFA0_TXD_C, SEL_SCIFA0_2),
	PINMUX_IPSR_MSEL(IP4_25_23, I2C3_SDA_D, SEL_I2C03_3),
	PINMUX_IPSR_GPSR(IP4_27_26, DU0_DG2),
	PINMUX_IPSR_GPSR(IP4_27_26, LCDOUT10),
	PINMUX_IPSR_GPSR(IP4_29_28, DU0_DG3),
	PINMUX_IPSR_GPSR(IP4_29_28, LCDOUT11),
	PINMUX_IPSR_GPSR(IP4_31_30, DU0_DG4),
	PINMUX_IPSR_GPSR(IP4_31_30, LCDOUT12),

	/* IPSR5 */
	PINMUX_IPSR_GPSR(IP5_1_0, DU0_DG5),
	PINMUX_IPSR_GPSR(IP5_1_0, LCDOUT13),
	PINMUX_IPSR_GPSR(IP5_3_2, DU0_DG6),
	PINMUX_IPSR_GPSR(IP5_3_2, LCDOUT14),
	PINMUX_IPSR_GPSR(IP5_5_4, DU0_DG7),
	PINMUX_IPSR_GPSR(IP5_5_4, LCDOUT15),
	PINMUX_IPSR_GPSR(IP5_8_6, DU0_DB0),
	PINMUX_IPSR_GPSR(IP5_8_6, LCDOUT0),
	PINMUX_IPSR_MSEL(IP5_8_6, SCIFA4_RXD_C, SEL_SCIFA4_2),
	PINMUX_IPSR_MSEL(IP5_8_6, I2C4_SCL_D, SEL_I2C04_3),
	PINMUX_IPSR_MSEL(IP7_8_6, CAN0_RX_C, SEL_CAN0_2),
	PINMUX_IPSR_GPSR(IP5_11_9, DU0_DB1),
	PINMUX_IPSR_GPSR(IP5_11_9, LCDOUT1),
	PINMUX_IPSR_MSEL(IP5_11_9, SCIFA4_TXD_C, SEL_SCIFA4_2),
	PINMUX_IPSR_MSEL(IP5_11_9, I2C4_SDA_D, SEL_I2C04_3),
	PINMUX_IPSR_MSEL(IP5_11_9, CAN0_TX_C, SEL_CAN0_2),
	PINMUX_IPSR_GPSR(IP5_13_12, DU0_DB2),
	PINMUX_IPSR_GPSR(IP5_13_12, LCDOUT2),
	PINMUX_IPSR_GPSR(IP5_15_14, DU0_DB3),
	PINMUX_IPSR_GPSR(IP5_15_14, LCDOUT3),
	PINMUX_IPSR_GPSR(IP5_17_16, DU0_DB4),
	PINMUX_IPSR_GPSR(IP5_17_16, LCDOUT4),
	PINMUX_IPSR_GPSR(IP5_19_18, DU0_DB5),
	PINMUX_IPSR_GPSR(IP5_19_18, LCDOUT5),
	PINMUX_IPSR_GPSR(IP5_21_20, DU0_DB6),
	PINMUX_IPSR_GPSR(IP5_21_20, LCDOUT6),
	PINMUX_IPSR_GPSR(IP5_23_22, DU0_DB7),
	PINMUX_IPSR_GPSR(IP5_23_22, LCDOUT7),
	PINMUX_IPSR_GPSR(IP5_25_24, DU0_DOTCLKIN),
	PINMUX_IPSR_GPSR(IP5_25_24, QSTVA_QVS),
	PINMUX_IPSR_GPSR(IP5_27_26, DU0_DOTCLKOUT0),
	PINMUX_IPSR_GPSR(IP5_27_26, QCLK),
	PINMUX_IPSR_GPSR(IP5_29_28, DU0_DOTCLKOUT1),
	PINMUX_IPSR_GPSR(IP5_29_28, QSTVB_QVE),
	PINMUX_IPSR_GPSR(IP5_31_30, DU0_EXHSYNC_DU0_HSYNC),
	PINMUX_IPSR_GPSR(IP5_31_30, QSTH_QHS),

	/* IPSR6 */
	PINMUX_IPSR_GPSR(IP6_1_0, DU0_EXVSYNC_DU0_VSYNC),
	PINMUX_IPSR_GPSR(IP6_1_0, QSTB_QHE),
	PINMUX_IPSR_GPSR(IP6_3_2, DU0_EXODDF_DU0_ODDF_DISP_CDE),
	PINMUX_IPSR_GPSR(IP6_3_2, QCPV_QDE),
	PINMUX_IPSR_GPSR(IP6_5_4, DU0_DISP),
	PINMUX_IPSR_GPSR(IP6_5_4, QPOLA),
	PINMUX_IPSR_GPSR(IP6_7_6, DU0_CDE),
	PINMUX_IPSR_GPSR(IP6_7_6, QPOLB),
	PINMUX_IPSR_GPSR(IP6_8, VI0_CLK),
	PINMUX_IPSR_GPSR(IP6_8, AVB_RX_CLK),
	PINMUX_IPSR_GPSR(IP6_9, VI0_DATA0_VI0_B0),
	PINMUX_IPSR_GPSR(IP6_9, AVB_RX_DV),
	PINMUX_IPSR_GPSR(IP6_10, VI0_DATA1_VI0_B1),
	PINMUX_IPSR_GPSR(IP6_10, AVB_RXD0),
	PINMUX_IPSR_GPSR(IP6_11, VI0_DATA2_VI0_B2),
	PINMUX_IPSR_GPSR(IP6_11, AVB_RXD1),
	PINMUX_IPSR_GPSR(IP6_12, VI0_DATA3_VI0_B3),
	PINMUX_IPSR_GPSR(IP6_12, AVB_RXD2),
	PINMUX_IPSR_GPSR(IP6_13, VI0_DATA4_VI0_B4),
	PINMUX_IPSR_GPSR(IP6_13, AVB_RXD3),
	PINMUX_IPSR_GPSR(IP6_14, VI0_DATA5_VI0_B5),
	PINMUX_IPSR_GPSR(IP6_14, AVB_RXD4),
	PINMUX_IPSR_GPSR(IP6_15, VI0_DATA6_VI0_B6),
	PINMUX_IPSR_GPSR(IP6_15, AVB_RXD5),
	PINMUX_IPSR_GPSR(IP6_16, VI0_DATA7_VI0_B7),
	PINMUX_IPSR_GPSR(IP6_16, AVB_RXD6),
	PINMUX_IPSR_GPSR(IP6_19_17, VI0_CLKENB),
	PINMUX_IPSR_MSEL(IP6_19_17, I2C3_SCL, SEL_I2C03_0),
	PINMUX_IPSR_MSEL(IP6_19_17, SCIFA5_RXD_C, SEL_SCIFA5_2),
	PINMUX_IPSR_MSEL(IP6_19_17, IETX_C, SEL_IEB_2),
	PINMUX_IPSR_GPSR(IP6_19_17, AVB_RXD7),
	PINMUX_IPSR_GPSR(IP6_22_20, VI0_FIELD),
	PINMUX_IPSR_MSEL(IP6_22_20, I2C3_SDA, SEL_I2C03_0),
	PINMUX_IPSR_MSEL(IP6_22_20, SCIFA5_TXD_C, SEL_SCIFA5_2),
	PINMUX_IPSR_MSEL(IP6_22_20, IECLK_C, SEL_IEB_2),
	PINMUX_IPSR_GPSR(IP6_22_20, AVB_RX_ER),
	PINMUX_IPSR_GPSR(IP6_25_23, VI0_HSYNC_N),
	PINMUX_IPSR_MSEL(IP6_25_23, SCIF0_RXD_B, SEL_SCIF0_1),
	PINMUX_IPSR_MSEL(IP6_25_23, I2C0_SCL_C, SEL_I2C00_2),
	PINMUX_IPSR_MSEL(IP6_25_23, IERX_C, SEL_IEB_2),
	PINMUX_IPSR_GPSR(IP6_25_23, AVB_COL),
	PINMUX_IPSR_GPSR(IP6_28_26, VI0_VSYNC_N),
	PINMUX_IPSR_MSEL(IP6_28_26, SCIF0_TXD_B, SEL_SCIF0_1),
	PINMUX_IPSR_MSEL(IP6_28_26, I2C0_SDA_C, SEL_I2C00_2),
	PINMUX_IPSR_MSEL(IP6_28_26, AUDIO_CLKOUT_B, SEL_ADG_1),
	PINMUX_IPSR_GPSR(IP6_28_26, AVB_TX_EN),
	PINMUX_IPSR_MSEL(IP6_31_29, ETH_MDIO, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP6_31_29, VI0_G0),
	PINMUX_IPSR_MSEL(IP6_31_29, MSIOF2_RXD_B, SEL_MSI2_1),
	PINMUX_IPSR_MSEL(IP6_31_29, I2C5_SCL_D, SEL_I2C05_3),
	PINMUX_IPSR_GPSR(IP6_31_29, AVB_TX_CLK),
	PINMUX_IPSR_MSEL(IP6_31_29, ADIDATA, SEL_RAD_0),

	/* IPSR7 */
	PINMUX_IPSR_MSEL(IP7_2_0, ETH_CRS_DV, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_2_0, VI0_G1),
	PINMUX_IPSR_MSEL(IP7_2_0, MSIOF2_TXD_B, SEL_MSI2_1),
	PINMUX_IPSR_MSEL(IP7_2_0, I2C5_SDA_D, SEL_I2C05_3),
	PINMUX_IPSR_GPSR(IP7_2_0, AVB_TXD0),
	PINMUX_IPSR_MSEL(IP7_2_0, ADICS_SAMP, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP7_5_3, ETH_RX_ER, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_5_3, VI0_G2),
	PINMUX_IPSR_MSEL(IP7_5_3, MSIOF2_SCK_B, SEL_MSI2_1),
	PINMUX_IPSR_MSEL(IP7_5_3, CAN0_RX_B, SEL_CAN0_1),
	PINMUX_IPSR_GPSR(IP7_5_3, AVB_TXD1),
	PINMUX_IPSR_MSEL(IP7_5_3, ADICLK, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP7_8_6, ETH_RXD0, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_8_6, VI0_G3),
	PINMUX_IPSR_MSEL(IP7_8_6, MSIOF2_SYNC_B, SEL_MSI2_1),
	PINMUX_IPSR_MSEL(IP7_8_6, CAN0_TX_B, SEL_CAN0_1),
	PINMUX_IPSR_GPSR(IP7_8_6, AVB_TXD2),
	PINMUX_IPSR_MSEL(IP7_8_6, ADICHS0, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP7_11_9, ETH_RXD1, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_11_9, VI0_G4),
	PINMUX_IPSR_MSEL(IP7_11_9, MSIOF2_SS1_B, SEL_MSI2_1),
	PINMUX_IPSR_MSEL(IP7_11_9, SCIF4_RXD_D, SEL_SCIF4_3),
	PINMUX_IPSR_GPSR(IP7_11_9, AVB_TXD3),
	PINMUX_IPSR_MSEL(IP7_11_9, ADICHS1, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP7_14_12, ETH_LINK, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_14_12, VI0_G5),
	PINMUX_IPSR_MSEL(IP7_14_12, MSIOF2_SS2_B, SEL_MSI2_1),
	PINMUX_IPSR_MSEL(IP7_14_12, SCIF4_TXD_D, SEL_SCIF4_3),
	PINMUX_IPSR_GPSR(IP7_14_12, AVB_TXD4),
	PINMUX_IPSR_MSEL(IP7_14_12, ADICHS2, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP7_17_15, ETH_REFCLK, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_17_15, VI0_G6),
	PINMUX_IPSR_MSEL(IP7_17_15, SCIF2_SCK_C, SEL_SCIF2_2),
	PINMUX_IPSR_GPSR(IP7_17_15, AVB_TXD5),
	PINMUX_IPSR_MSEL(IP7_17_15, SSI_SCK5_B, SEL_SSI5_1),
	PINMUX_IPSR_MSEL(IP7_20_18, ETH_TXD1, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_20_18, VI0_G7),
	PINMUX_IPSR_MSEL(IP7_20_18, SCIF2_RXD_C, SEL_SCIF2_2),
	PINMUX_IPSR_MSEL(IP7_20_18, IIC0_SCL_D, SEL_IIC0_3),
	PINMUX_IPSR_GPSR(IP7_20_18, AVB_TXD6),
	PINMUX_IPSR_MSEL(IP7_20_18, SSI_WS5_B, SEL_SSI5_1),
	PINMUX_IPSR_MSEL(IP7_23_21, ETH_TX_EN, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_23_21, VI0_R0),
	PINMUX_IPSR_MSEL(IP7_23_21, SCIF2_TXD_C, SEL_SCIF2_2),
	PINMUX_IPSR_MSEL(IP7_23_21, IIC0_SDA_D, SEL_IIC0_3),
	PINMUX_IPSR_GPSR(IP7_23_21, AVB_TXD7),
	PINMUX_IPSR_MSEL(IP7_23_21, SSI_SDATA5_B, SEL_SSI5_1),
	PINMUX_IPSR_MSEL(IP7_26_24, ETH_MAGIC, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_26_24, VI0_R1),
	PINMUX_IPSR_MSEL(IP7_26_24, SCIF3_SCK_B, SEL_SCIF3_1),
	PINMUX_IPSR_GPSR(IP7_26_24, AVB_TX_ER),
	PINMUX_IPSR_MSEL(IP7_26_24, SSI_SCK6_B, SEL_SSI6_1),
	PINMUX_IPSR_MSEL(IP7_29_27, ETH_TXD0, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP7_29_27, VI0_R2),
	PINMUX_IPSR_MSEL(IP7_29_27, SCIF3_RXD_B, SEL_SCIF3_1),
	PINMUX_IPSR_MSEL(IP7_29_27, I2C4_SCL_E, SEL_I2C04_4),
	PINMUX_IPSR_GPSR(IP7_29_27, AVB_GTX_CLK),
	PINMUX_IPSR_MSEL(IP7_29_27, SSI_WS6_B, SEL_SSI6_1),
	PINMUX_IPSR_GPSR(IP7_31, DREQ0_N),
	PINMUX_IPSR_GPSR(IP7_31, SCIFB1_RXD),

	/* IPSR8 */
	PINMUX_IPSR_MSEL(IP8_2_0, ETH_MDC, SEL_ETH_0),
	PINMUX_IPSR_GPSR(IP8_2_0, VI0_R3),
	PINMUX_IPSR_MSEL(IP8_2_0, SCIF3_TXD_B, SEL_SCIF3_1),
	PINMUX_IPSR_MSEL(IP8_2_0, I2C4_SDA_E, SEL_I2C04_4),
	PINMUX_IPSR_GPSR(IP8_2_0, AVB_MDC),
	PINMUX_IPSR_MSEL(IP8_2_0, SSI_SDATA6_B, SEL_SSI6_1),
	PINMUX_IPSR_MSEL(IP8_5_3, HSCIF0_HRX, SEL_HSCIF0_0),
	PINMUX_IPSR_GPSR(IP8_5_3, VI0_R4),
	PINMUX_IPSR_MSEL(IP8_5_3, I2C1_SCL_C, SEL_I2C01_2),
	PINMUX_IPSR_MSEL(IP8_5_3, AUDIO_CLKA_B, SEL_ADG_1),
	PINMUX_IPSR_GPSR(IP8_5_3, AVB_MDIO),
	PINMUX_IPSR_MSEL(IP8_5_3, SSI_SCK78_B, SEL_SSI7_1),
	PINMUX_IPSR_MSEL(IP8_8_6, HSCIF0_HTX, SEL_HSCIF0_0),
	PINMUX_IPSR_GPSR(IP8_8_6, VI0_R5),
	PINMUX_IPSR_MSEL(IP8_8_6, I2C1_SDA_C, SEL_I2C01_2),
	PINMUX_IPSR_MSEL(IP8_8_6, AUDIO_CLKB_B, SEL_ADG_1),
	PINMUX_IPSR_GPSR(IP8_5_3, AVB_LINK),
	PINMUX_IPSR_MSEL(IP8_8_6, SSI_WS78_B, SEL_SSI7_1),
	PINMUX_IPSR_GPSR(IP8_11_9, HSCIF0_HCTS_N),
	PINMUX_IPSR_GPSR(IP8_11_9, VI0_R6),
	PINMUX_IPSR_MSEL(IP8_11_9, SCIF0_RXD_D, SEL_SCIF0_3),
	PINMUX_IPSR_MSEL(IP8_11_9, I2C0_SCL_E, SEL_I2C00_4),
	PINMUX_IPSR_GPSR(IP8_11_9, AVB_MAGIC),
	PINMUX_IPSR_MSEL(IP8_11_9, SSI_SDATA7_B, SEL_SSI7_1),
	PINMUX_IPSR_GPSR(IP8_14_12, HSCIF0_HRTS_N),
	PINMUX_IPSR_GPSR(IP8_14_12, VI0_R7),
	PINMUX_IPSR_MSEL(IP8_14_12, SCIF0_TXD_D, SEL_SCIF0_3),
	PINMUX_IPSR_MSEL(IP8_14_12, I2C0_SDA_E, SEL_I2C00_4),
	PINMUX_IPSR_GPSR(IP8_14_12, AVB_PHY_INT),
	PINMUX_IPSR_MSEL(IP8_14_12, SSI_SDATA8_B, SEL_SSI8_1),
	PINMUX_IPSR_MSEL(IP8_16_15, HSCIF0_HSCK, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP8_16_15, SCIF_CLK_B, SEL_SCIF0_1),
	PINMUX_IPSR_GPSR(IP8_16_15, AVB_CRS),
	PINMUX_IPSR_MSEL(IP8_16_15, AUDIO_CLKC_B, SEL_ADG_1),
	PINMUX_IPSR_MSEL(IP8_19_17, I2C0_SCL, SEL_I2C00_0),
	PINMUX_IPSR_MSEL(IP8_19_17, SCIF0_RXD_C, SEL_SCIF0_2),
	PINMUX_IPSR_GPSR(IP8_19_17, PWM5),
	PINMUX_IPSR_MSEL(IP8_19_17, TCLK1_B, SEL_TMU_1),
	PINMUX_IPSR_GPSR(IP8_19_17, AVB_GTXREFCLK),
	PINMUX_IPSR_MSEL(IP8_19_17, CAN1_RX_D, SEL_CAN1_3),
	PINMUX_IPSR_GPSR(IP8_19_17, TPUTO0_B),
	PINMUX_IPSR_MSEL(IP8_22_20, I2C0_SDA, SEL_I2C00_0),
	PINMUX_IPSR_MSEL(IP8_22_20, SCIF0_TXD_C, SEL_SCIF0_2),
	PINMUX_IPSR_GPSR(IP8_22_20, TPUTO0),
	PINMUX_IPSR_MSEL(IP8_22_20, CAN_CLK, SEL_CAN_0),
	PINMUX_IPSR_GPSR(IP8_22_20, DVC_MUTE),
	PINMUX_IPSR_MSEL(IP8_22_20, CAN1_TX_D, SEL_CAN1_3),
	PINMUX_IPSR_MSEL(IP8_25_23, I2C1_SCL, SEL_I2C01_0),
	PINMUX_IPSR_MSEL(IP8_25_23, SCIF4_RXD, SEL_SCIF4_0),
	PINMUX_IPSR_GPSR(IP8_25_23, PWM5_B),
	PINMUX_IPSR_GPSR(IP8_25_23, DU1_DR0),
	PINMUX_IPSR_MSEL(IP8_25_23, TS_SDATA_D, SEL_TSIF0_3),
	PINMUX_IPSR_GPSR(IP8_25_23, TPUTO1_B),
	PINMUX_IPSR_MSEL(IP8_28_26, I2C1_SDA, SEL_I2C01_0),
	PINMUX_IPSR_MSEL(IP8_28_26, SCIF4_TXD, SEL_SCIF4_0),
	PINMUX_IPSR_GPSR(IP8_28_26, IRQ5),
	PINMUX_IPSR_GPSR(IP8_28_26, DU1_DR1),
	PINMUX_IPSR_MSEL(IP8_28_26, TS_SCK_D, SEL_TSIF0_3),
	PINMUX_IPSR_MSEL(IP8_28_26, BPFCLK_C, SEL_DARC_2),
	PINMUX_IPSR_GPSR(IP8_31_29, MSIOF0_RXD),
	PINMUX_IPSR_MSEL(IP8_31_29, SCIF5_RXD, SEL_SCIF5_0),
	PINMUX_IPSR_MSEL(IP8_31_29, I2C2_SCL_C, SEL_I2C02_2),
	PINMUX_IPSR_GPSR(IP8_31_29, DU1_DR2),
	PINMUX_IPSR_MSEL(IP8_31_29, TS_SDEN_D, SEL_TSIF0_3),
	PINMUX_IPSR_MSEL(IP8_31_29, FMCLK_C, SEL_DARC_2),

	/* IPSR9 */
	PINMUX_IPSR_GPSR(IP9_2_0, MSIOF0_TXD),
	PINMUX_IPSR_MSEL(IP9_2_0, SCIF5_TXD, SEL_SCIF5_0),
	PINMUX_IPSR_MSEL(IP9_2_0, I2C2_SDA_C, SEL_I2C02_2),
	PINMUX_IPSR_GPSR(IP9_2_0, DU1_DR3),
	PINMUX_IPSR_MSEL(IP9_2_0, TS_SPSYNC_D, SEL_TSIF0_3),
	PINMUX_IPSR_MSEL(IP9_2_0, FMIN_C, SEL_DARC_2),
	PINMUX_IPSR_GPSR(IP9_5_3, MSIOF0_SCK),
	PINMUX_IPSR_GPSR(IP9_5_3, IRQ0),
	PINMUX_IPSR_MSEL(IP9_5_3, TS_SDATA, SEL_TSIF0_0),
	PINMUX_IPSR_GPSR(IP9_5_3, DU1_DR4),
	PINMUX_IPSR_GPSR(IP9_5_3, TPUTO1_C),
	PINMUX_IPSR_GPSR(IP9_8_6, MSIOF0_SYNC),
	PINMUX_IPSR_GPSR(IP9_8_6, PWM1),
	PINMUX_IPSR_MSEL(IP9_8_6, TS_SCK, SEL_TSIF0_0),
	PINMUX_IPSR_GPSR(IP9_8_6, DU1_DR5),
	PINMUX_IPSR_MSEL(IP9_8_6, BPFCLK_B, SEL_DARC_1),
	PINMUX_IPSR_GPSR(IP9_11_9, MSIOF0_SS1),
	PINMUX_IPSR_MSEL(IP9_11_9, SCIFA0_RXD, SEL_SCIFA0_0),
	PINMUX_IPSR_MSEL(IP9_11_9, TS_SDEN, SEL_TSIF0_0),
	PINMUX_IPSR_GPSR(IP9_11_9, DU1_DR6),
	PINMUX_IPSR_MSEL(IP9_11_9, FMCLK_B, SEL_DARC_1),
	PINMUX_IPSR_GPSR(IP9_14_12, MSIOF0_SS2),
	PINMUX_IPSR_MSEL(IP9_14_12, SCIFA0_TXD, SEL_SCIFA0_0),
	PINMUX_IPSR_MSEL(IP9_14_12, TS_SPSYNC, SEL_TSIF0_0),
	PINMUX_IPSR_GPSR(IP9_14_12, DU1_DR7),
	PINMUX_IPSR_MSEL(IP9_14_12, FMIN_B, SEL_DARC_1),
	PINMUX_IPSR_MSEL(IP9_16_15, HSCIF1_HRX, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP9_16_15, I2C4_SCL, SEL_I2C04_0),
	PINMUX_IPSR_GPSR(IP9_16_15, PWM6),
	PINMUX_IPSR_GPSR(IP9_16_15, DU1_DG0),
	PINMUX_IPSR_MSEL(IP9_18_17, HSCIF1_HTX, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP9_18_17, I2C4_SDA, SEL_I2C04_0),
	PINMUX_IPSR_GPSR(IP9_18_17, TPUTO1),
	PINMUX_IPSR_GPSR(IP9_18_17, DU1_DG1),
	PINMUX_IPSR_GPSR(IP9_21_19, HSCIF1_HSCK),
	PINMUX_IPSR_GPSR(IP9_21_19, PWM2),
	PINMUX_IPSR_MSEL(IP9_21_19, IETX, SEL_IEB_0),
	PINMUX_IPSR_GPSR(IP9_21_19, DU1_DG2),
	PINMUX_IPSR_MSEL(IP9_21_19, REMOCON_B, SEL_RCN_1),
	PINMUX_IPSR_MSEL(IP9_21_19, SPEEDIN_B, SEL_RSP_1),
	PINMUX_IPSR_MSEL(IP9_24_22, HSCIF1_HCTS_N, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP9_24_22, SCIFA4_RXD, SEL_SCIFA4_0),
	PINMUX_IPSR_MSEL(IP9_24_22, IECLK, SEL_IEB_0),
	PINMUX_IPSR_GPSR(IP9_24_22, DU1_DG3),
	PINMUX_IPSR_MSEL(IP9_24_22, SSI_SCK1_B, SEL_SSI1_1),
	PINMUX_IPSR_MSEL(IP9_27_25, HSCIF1_HRTS_N, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP9_27_25, SCIFA4_TXD, SEL_SCIFA4_0),
	PINMUX_IPSR_MSEL(IP9_27_25, IERX, SEL_IEB_0),
	PINMUX_IPSR_GPSR(IP9_27_25, DU1_DG4),
	PINMUX_IPSR_MSEL(IP9_27_25, SSI_WS1_B, SEL_SSI1_1),
	PINMUX_IPSR_MSEL(IP9_30_28, SCIF1_SCK, SEL_SCIF1_0),
	PINMUX_IPSR_GPSR(IP9_30_28, PWM3),
	PINMUX_IPSR_MSEL(IP9_30_28, TCLK2, SEL_TMU_0),
	PINMUX_IPSR_GPSR(IP9_30_28, DU1_DG5),
	PINMUX_IPSR_MSEL(IP9_30_28, SSI_SDATA1_B, SEL_SSI1_1),

	/* IPSR10 */
	PINMUX_IPSR_MSEL(IP10_2_0, SCIF1_RXD, SEL_SCIF1_0),
	PINMUX_IPSR_MSEL(IP10_2_0, I2C5_SCL, SEL_I2C05_0),
	PINMUX_IPSR_GPSR(IP10_2_0, DU1_DG6),
	PINMUX_IPSR_MSEL(IP10_2_0, SSI_SCK2_B, SEL_SSI2_1),
	PINMUX_IPSR_MSEL(IP10_5_3, SCIF1_TXD, SEL_SCIF1_0),
	PINMUX_IPSR_MSEL(IP10_5_3, I2C5_SDA, SEL_I2C05_0),
	PINMUX_IPSR_GPSR(IP10_5_3, DU1_DG7),
	PINMUX_IPSR_MSEL(IP10_5_3, SSI_WS2_B, SEL_SSI2_1),
	PINMUX_IPSR_MSEL(IP10_8_6, SCIF2_RXD, SEL_SCIF2_0),
	PINMUX_IPSR_MSEL(IP10_8_6, IIC0_SCL, SEL_IIC0_0),
	PINMUX_IPSR_GPSR(IP10_8_6, DU1_DB0),
	PINMUX_IPSR_MSEL(IP10_8_6, SSI_SDATA2_B, SEL_SSI2_1),
	PINMUX_IPSR_MSEL(IP10_11_9, SCIF2_TXD, SEL_SCIF2_0),
	PINMUX_IPSR_MSEL(IP10_11_9, IIC0_SDA, SEL_IIC0_0),
	PINMUX_IPSR_GPSR(IP10_11_9, DU1_DB1),
	PINMUX_IPSR_MSEL(IP10_11_9, SSI_SCK9_B, SEL_SSI9_1),
	PINMUX_IPSR_MSEL(IP10_14_12, SCIF2_SCK, SEL_SCIF2_0),
	PINMUX_IPSR_GPSR(IP10_14_12, IRQ1),
	PINMUX_IPSR_GPSR(IP10_14_12, DU1_DB2),
	PINMUX_IPSR_MSEL(IP10_14_12, SSI_WS9_B, SEL_SSI9_1),
	PINMUX_IPSR_MSEL(IP10_17_15, SCIF3_SCK, SEL_SCIF3_0),
	PINMUX_IPSR_GPSR(IP10_17_15, IRQ2),
	PINMUX_IPSR_MSEL(IP10_17_15, BPFCLK_D, SEL_DARC_3),
	PINMUX_IPSR_GPSR(IP10_17_15, DU1_DB3),
	PINMUX_IPSR_MSEL(IP10_17_15, SSI_SDATA9_B, SEL_SSI9_1),
	PINMUX_IPSR_MSEL(IP10_20_18, SCIF3_RXD, SEL_SCIF3_0),
	PINMUX_IPSR_MSEL(IP10_20_18, I2C1_SCL_E, SEL_I2C01_4),
	PINMUX_IPSR_MSEL(IP10_20_18, FMCLK_D, SEL_DARC_3),
	PINMUX_IPSR_GPSR(IP10_20_18, DU1_DB4),
	PINMUX_IPSR_MSEL(IP10_20_18, AUDIO_CLKA_C, SEL_ADG_2),
	PINMUX_IPSR_MSEL(IP10_20_18, SSI_SCK4_B, SEL_SSI4_1),
	PINMUX_IPSR_MSEL(IP10_23_21, SCIF3_TXD, SEL_SCIF3_0),
	PINMUX_IPSR_MSEL(IP10_23_21, I2C1_SDA_E, SEL_I2C01_4),
	PINMUX_IPSR_MSEL(IP10_23_21, FMIN_D, SEL_DARC_3),
	PINMUX_IPSR_GPSR(IP10_23_21, DU1_DB5),
	PINMUX_IPSR_MSEL(IP10_23_21, AUDIO_CLKB_C, SEL_ADG_2),
	PINMUX_IPSR_MSEL(IP10_23_21, SSI_WS4_B, SEL_SSI4_1),
	PINMUX_IPSR_MSEL(IP10_26_24, I2C2_SCL, SEL_I2C02_0),
	PINMUX_IPSR_MSEL(IP10_26_24, SCIFA5_RXD, SEL_SCIFA5_0),
	PINMUX_IPSR_GPSR(IP10_26_24, DU1_DB6),
	PINMUX_IPSR_MSEL(IP10_26_24, AUDIO_CLKC_C, SEL_ADG_2),
	PINMUX_IPSR_MSEL(IP10_26_24, SSI_SDATA4_B, SEL_SSI4_1),
	PINMUX_IPSR_MSEL(IP10_29_27, I2C2_SDA, SEL_I2C02_0),
	PINMUX_IPSR_MSEL(IP10_29_27, SCIFA5_TXD, SEL_SCIFA5_0),
	PINMUX_IPSR_GPSR(IP10_29_27, DU1_DB7),
	PINMUX_IPSR_MSEL(IP10_29_27, AUDIO_CLKOUT_C, SEL_ADG_2),
	PINMUX_IPSR_MSEL(IP10_31_30, SSI_SCK5, SEL_SSI5_0),
	PINMUX_IPSR_MSEL(IP10_31_30, SCIFA3_SCK, SEL_SCIFA3_0),
	PINMUX_IPSR_GPSR(IP10_31_30, DU1_DOTCLKIN),

	/* IPSR11 */
	PINMUX_IPSR_MSEL(IP11_2_0, SSI_WS5, SEL_SSI5_0),
	PINMUX_IPSR_MSEL(IP11_2_0, SCIFA3_RXD, SEL_SCIFA3_0),
	PINMUX_IPSR_MSEL(IP11_2_0, I2C3_SCL_C, SEL_I2C03_2),
	PINMUX_IPSR_GPSR(IP11_2_0, DU1_DOTCLKOUT0),
	PINMUX_IPSR_MSEL(IP11_5_3, SSI_SDATA5, SEL_SSI5_0),
	PINMUX_IPSR_MSEL(IP11_5_3, SCIFA3_TXD, SEL_SCIFA3_0),
	PINMUX_IPSR_MSEL(IP11_5_3, I2C3_SDA_C, SEL_I2C03_2),
	PINMUX_IPSR_GPSR(IP11_5_3, DU1_DOTCLKOUT1),
	PINMUX_IPSR_MSEL(IP11_7_6, SSI_SCK6, SEL_SSI6_0),
	PINMUX_IPSR_MSEL(IP11_7_6, SCIFA1_SCK_B, SEL_SCIFA1_1),
	PINMUX_IPSR_GPSR(IP11_7_6, DU1_EXHSYNC_DU1_HSYNC),
	PINMUX_IPSR_MSEL(IP11_10_8, SSI_WS6, SEL_SSI6_0),
	PINMUX_IPSR_MSEL(IP11_10_8, SCIFA1_RXD_B, SEL_SCIFA1_1),
	PINMUX_IPSR_MSEL(IP11_10_8, I2C4_SCL_C, SEL_I2C04_2),
	PINMUX_IPSR_GPSR(IP11_10_8, DU1_EXVSYNC_DU1_VSYNC),
	PINMUX_IPSR_MSEL(IP11_13_11, SSI_SDATA6, SEL_SSI6_0),
	PINMUX_IPSR_MSEL(IP11_13_11, SCIFA1_TXD_B, SEL_SCIFA1_1),
	PINMUX_IPSR_MSEL(IP11_13_11, I2C4_SDA_C, SEL_I2C04_2),
	PINMUX_IPSR_GPSR(IP11_13_11, DU1_EXODDF_DU1_ODDF_DISP_CDE),
	PINMUX_IPSR_MSEL(IP11_15_14, SSI_SCK78, SEL_SSI7_0),
	PINMUX_IPSR_MSEL(IP11_15_14, SCIFA2_SCK_B, SEL_SCIFA2_1),
	PINMUX_IPSR_MSEL(IP11_15_14, I2C5_SDA_C, SEL_I2C05_2),
	PINMUX_IPSR_GPSR(IP11_15_14, DU1_DISP),
	PINMUX_IPSR_MSEL(IP11_17_16, SSI_WS78, SEL_SSI7_0),
	PINMUX_IPSR_MSEL(IP11_17_16, SCIFA2_RXD_B, SEL_SCIFA2_1),
	PINMUX_IPSR_MSEL(IP11_17_16, I2C5_SCL_C, SEL_I2C05_2),
	PINMUX_IPSR_GPSR(IP11_17_16, DU1_CDE),
	PINMUX_IPSR_MSEL(IP11_20_18, SSI_SDATA7, SEL_SSI7_0),
	PINMUX_IPSR_MSEL(IP11_20_18, SCIFA2_TXD_B, SEL_SCIFA2_1),
	PINMUX_IPSR_GPSR(IP11_20_18, IRQ8),
	PINMUX_IPSR_MSEL(IP11_20_18, AUDIO_CLKA_D, SEL_ADG_3),
	PINMUX_IPSR_MSEL(IP11_20_18, CAN_CLK_D, SEL_CAN_3),
	PINMUX_IPSR_GPSR(IP11_23_21, SSI_SCK0129),
	PINMUX_IPSR_MSEL(IP11_23_21, MSIOF1_RXD_B, SEL_MSI1_1),
	PINMUX_IPSR_MSEL(IP11_23_21, SCIF5_RXD_D, SEL_SCIF5_3),
	PINMUX_IPSR_MSEL(IP11_23_21, ADIDATA_B, SEL_RAD_1),
	PINMUX_IPSR_GPSR(IP11_26_24, SSI_WS0129),
	PINMUX_IPSR_MSEL(IP11_26_24, MSIOF1_TXD_B, SEL_MSI1_1),
	PINMUX_IPSR_MSEL(IP11_26_24, SCIF5_TXD_D, SEL_SCIF5_3),
	PINMUX_IPSR_MSEL(IP11_26_24, ADICS_SAMP_B, SEL_RAD_1),
	PINMUX_IPSR_GPSR(IP11_29_27, SSI_SDATA0),
	PINMUX_IPSR_MSEL(IP11_29_27, MSIOF1_SCK_B, SEL_MSI1_1),
	PINMUX_IPSR_GPSR(IP11_29_27, PWM0_B),
	PINMUX_IPSR_MSEL(IP11_29_27, ADICLK_B, SEL_RAD_1),

	/* IPSR12 */
	PINMUX_IPSR_GPSR(IP12_2_0, SSI_SCK34),
	PINMUX_IPSR_MSEL(IP12_2_0, MSIOF1_SYNC_B, SEL_MSI1_1),
	PINMUX_IPSR_MSEL(IP12_2_0, SCIFA1_SCK_C, SEL_SCIFA1_2),
	PINMUX_IPSR_MSEL(IP12_2_0, ADICHS0_B, SEL_RAD_1),
	PINMUX_IPSR_MSEL(IP12_2_0, DREQ1_N_B, SEL_LBS_1),
	PINMUX_IPSR_GPSR(IP12_5_3, SSI_WS34),
	PINMUX_IPSR_MSEL(IP12_5_3, MSIOF1_SS1_B, SEL_MSI1_1),
	PINMUX_IPSR_MSEL(IP12_5_3, SCIFA1_RXD_C, SEL_SCIFA1_2),
	PINMUX_IPSR_MSEL(IP12_5_3, ADICHS1_B, SEL_RAD_1),
	PINMUX_IPSR_MSEL(IP12_5_3, CAN1_RX_C, SEL_CAN1_2),
	PINMUX_IPSR_MSEL(IP12_5_3, DACK1_B, SEL_LBS_1),
	PINMUX_IPSR_GPSR(IP12_8_6, SSI_SDATA3),
	PINMUX_IPSR_MSEL(IP12_8_6, MSIOF1_SS2_B, SEL_MSI1_1),
	PINMUX_IPSR_MSEL(IP12_8_6, SCIFA1_TXD_C, SEL_SCIFA1_2),
	PINMUX_IPSR_MSEL(IP12_8_6, ADICHS2_B, SEL_RAD_1),
	PINMUX_IPSR_MSEL(IP12_8_6, CAN1_TX_C, SEL_CAN1_2),
	PINMUX_IPSR_GPSR(IP12_8_6, DREQ2_N),
	PINMUX_IPSR_MSEL(IP12_10_9, SSI_SCK4, SEL_SSI4_0),
	PINMUX_IPSR_GPSR(IP12_10_9, MLB_CLK),
	PINMUX_IPSR_MSEL(IP12_10_9, IETX_B, SEL_IEB_1),
	PINMUX_IPSR_MSEL(IP12_12_11, SSI_WS4, SEL_SSI4_0),
	PINMUX_IPSR_GPSR(IP12_12_11, MLB_SIG),
	PINMUX_IPSR_MSEL(IP12_12_11, IECLK_B, SEL_IEB_1),
	PINMUX_IPSR_MSEL(IP12_14_13, SSI_SDATA4, SEL_SSI4_0),
	PINMUX_IPSR_GPSR(IP12_14_13, MLB_DAT),
	PINMUX_IPSR_MSEL(IP12_14_13, IERX_B, SEL_IEB_1),
	PINMUX_IPSR_MSEL(IP12_17_15, SSI_SDATA8, SEL_SSI8_0),
	PINMUX_IPSR_MSEL(IP12_17_15, SCIF1_SCK_B, SEL_SCIF1_1),
	PINMUX_IPSR_GPSR(IP12_17_15, PWM1_B),
	PINMUX_IPSR_GPSR(IP12_17_15, IRQ9),
	PINMUX_IPSR_MSEL(IP12_17_15, REMOCON, SEL_RCN_0),
	PINMUX_IPSR_GPSR(IP12_17_15, DACK2),
	PINMUX_IPSR_MSEL(IP12_17_15, ETH_MDIO_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP12_20_18, SSI_SCK1, SEL_SSI1_0),
	PINMUX_IPSR_MSEL(IP12_20_18, SCIF1_RXD_B, SEL_SCIF1_1),
	PINMUX_IPSR_MSEL(IP12_20_18, IIC0_SCL_C, SEL_IIC0_2),
	PINMUX_IPSR_GPSR(IP12_20_18, VI1_CLK),
	PINMUX_IPSR_MSEL(IP12_20_18, CAN0_RX_D, SEL_CAN0_3),
	PINMUX_IPSR_MSEL(IP12_20_18, ETH_CRS_DV_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP12_23_21, SSI_WS1, SEL_SSI1_0),
	PINMUX_IPSR_MSEL(IP12_23_21, SCIF1_TXD_B, SEL_SCIF1_1),
	PINMUX_IPSR_MSEL(IP12_23_21, IIC0_SDA_C, SEL_IIC0_2),
	PINMUX_IPSR_GPSR(IP12_23_21, VI1_DATA0),
	PINMUX_IPSR_MSEL(IP12_23_21, CAN0_TX_D, SEL_CAN0_3),
	PINMUX_IPSR_MSEL(IP12_23_21, ETH_RX_ER_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP12_26_24, SSI_SDATA1, SEL_SSI1_0),
	PINMUX_IPSR_MSEL(IP12_26_24, HSCIF1_HRX_B, SEL_HSCIF1_1),
	PINMUX_IPSR_GPSR(IP12_26_24, VI1_DATA1),
	PINMUX_IPSR_GPSR(IP12_26_24, ATAWR0_N),
	PINMUX_IPSR_MSEL(IP12_26_24, ETH_RXD0_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP12_29_27, SSI_SCK2, SEL_SSI2_0),
	PINMUX_IPSR_MSEL(IP12_29_27, HSCIF1_HTX_B, SEL_HSCIF1_1),
	PINMUX_IPSR_GPSR(IP12_29_27, VI1_DATA2),
	PINMUX_IPSR_GPSR(IP12_29_27, ATAG0_N),
	PINMUX_IPSR_MSEL(IP12_29_27, ETH_RXD1_B, SEL_ETH_1),

	/* IPSR13 */
	PINMUX_IPSR_MSEL(IP13_2_0, SSI_WS2, SEL_SSI2_0),
	PINMUX_IPSR_MSEL(IP13_2_0, HSCIF1_HCTS_N_B, SEL_HSCIF1_1),
	PINMUX_IPSR_MSEL(IP13_2_0, SCIFA0_RXD_D, SEL_SCIFA0_3),
	PINMUX_IPSR_GPSR(IP13_2_0, VI1_DATA3),
	PINMUX_IPSR_GPSR(IP13_2_0, ATACS00_N),
	PINMUX_IPSR_MSEL(IP13_2_0, ETH_LINK_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP13_5_3, SSI_SDATA2, SEL_SSI2_0),
	PINMUX_IPSR_MSEL(IP13_5_3, HSCIF1_HRTS_N_B, SEL_HSCIF1_1),
	PINMUX_IPSR_MSEL(IP13_5_3, SCIFA0_TXD_D, SEL_SCIFA0_3),
	PINMUX_IPSR_GPSR(IP13_5_3, VI1_DATA4),
	PINMUX_IPSR_GPSR(IP13_5_3, ATACS10_N),
	PINMUX_IPSR_MSEL(IP13_5_3, ETH_REFCLK_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP13_8_6, SSI_SCK9, SEL_SSI9_0),
	PINMUX_IPSR_MSEL(IP13_8_6, SCIF2_SCK_B, SEL_SCIF2_1),
	PINMUX_IPSR_GPSR(IP13_8_6, PWM2_B),
	PINMUX_IPSR_GPSR(IP13_8_6, VI1_DATA5),
	PINMUX_IPSR_GPSR(IP13_8_6, EX_WAIT1),
	PINMUX_IPSR_MSEL(IP13_8_6, ETH_TXD1_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP13_11_9, SSI_WS9, SEL_SSI9_0),
	PINMUX_IPSR_MSEL(IP13_11_9, SCIF2_RXD_B, SEL_SCIF2_1),
	PINMUX_IPSR_MSEL(IP13_11_9, I2C3_SCL_E, SEL_I2C03_4),
	PINMUX_IPSR_GPSR(IP13_11_9, VI1_DATA6),
	PINMUX_IPSR_GPSR(IP13_11_9, ATARD0_N),
	PINMUX_IPSR_MSEL(IP13_11_9, ETH_TX_EN_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP13_14_12, SSI_SDATA9, SEL_SSI9_0),
	PINMUX_IPSR_MSEL(IP13_14_12, SCIF2_TXD_B, SEL_SCIF2_1),
	PINMUX_IPSR_MSEL(IP13_14_12, I2C3_SDA_E, SEL_I2C03_4),
	PINMUX_IPSR_GPSR(IP13_14_12, VI1_DATA7),
	PINMUX_IPSR_GPSR(IP13_14_12, ATADIR0_N),
	PINMUX_IPSR_MSEL(IP13_14_12, ETH_MAGIC_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP13_17_15, AUDIO_CLKA, SEL_ADG_0),
	PINMUX_IPSR_MSEL(IP13_17_15, I2C0_SCL_B, SEL_I2C00_1),
	PINMUX_IPSR_MSEL(IP13_17_15, SCIFA4_RXD_D, SEL_SCIFA4_3),
	PINMUX_IPSR_GPSR(IP13_17_15, VI1_CLKENB),
	PINMUX_IPSR_MSEL(IP13_17_15, TS_SDATA_C, SEL_TSIF0_2),
	PINMUX_IPSR_MSEL(IP13_17_15, ETH_TXD0_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP13_20_18, AUDIO_CLKB, SEL_ADG_0),
	PINMUX_IPSR_MSEL(IP13_20_18, I2C0_SDA_B, SEL_I2C00_1),
	PINMUX_IPSR_MSEL(IP13_20_18, SCIFA4_TXD_D, SEL_SCIFA4_3),
	PINMUX_IPSR_GPSR(IP13_20_18, VI1_FIELD),
	PINMUX_IPSR_MSEL(IP13_20_18, TS_SCK_C, SEL_TSIF0_2),
	PINMUX_IPSR_MSEL(IP13_20_18, BPFCLK_E, SEL_DARC_4),
	PINMUX_IPSR_MSEL(IP13_20_18, ETH_MDC_B, SEL_ETH_1),
	PINMUX_IPSR_MSEL(IP13_23_21, AUDIO_CLKC, SEL_ADG_0),
	PINMUX_IPSR_MSEL(IP13_23_21, I2C4_SCL_B, SEL_I2C04_1),
	PINMUX_IPSR_MSEL(IP13_23_21, SCIFA5_RXD_D, SEL_SCIFA5_3),
	PINMUX_IPSR_GPSR(IP13_23_21, VI1_HSYNC_N),
	PINMUX_IPSR_MSEL(IP13_23_21, TS_SDEN_C, SEL_TSIF0_2),
	PINMUX_IPSR_MSEL(IP13_23_21, FMCLK_E, SEL_DARC_4),
	PINMUX_IPSR_MSEL(IP13_26_24, AUDIO_CLKOUT, SEL_ADG_0),
	PINMUX_IPSR_MSEL(IP13_26_24, I2C4_SDA_B, SEL_I2C04_1),
	PINMUX_IPSR_MSEL(IP13_26_24, SCIFA5_TXD_D, SEL_SCIFA5_3),
	PINMUX_IPSR_GPSR(IP13_26_24, VI1_VSYNC_N),
	PINMUX_IPSR_MSEL(IP13_26_24, TS_SPSYNC_C, SEL_TSIF0_2),
	PINMUX_IPSR_MSEL(IP13_26_24, FMIN_E, SEL_DARC_4),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	PINMUX_GPIO_GP_ALL(),
};

/* - Audio Clock ------------------------------------------------------------ */
static const unsigned int audio_clka_pins[] = {
	/* CLKA */
	RCAR_GP_PIN(5, 20),
};
static const unsigned int audio_clka_mux[] = {
	AUDIO_CLKA_MARK,
};
static const unsigned int audio_clka_b_pins[] = {
	/* CLKA */
	RCAR_GP_PIN(3, 25),
};
static const unsigned int audio_clka_b_mux[] = {
	AUDIO_CLKA_B_MARK,
};
static const unsigned int audio_clka_c_pins[] = {
	/* CLKA */
	RCAR_GP_PIN(4, 20),
};
static const unsigned int audio_clka_c_mux[] = {
	AUDIO_CLKA_C_MARK,
};
static const unsigned int audio_clka_d_pins[] = {
	/* CLKA */
	RCAR_GP_PIN(5, 0),
};
static const unsigned int audio_clka_d_mux[] = {
	AUDIO_CLKA_D_MARK,
};
static const unsigned int audio_clkb_pins[] = {
	/* CLKB */
	RCAR_GP_PIN(5, 21),
};
static const unsigned int audio_clkb_mux[] = {
	AUDIO_CLKB_MARK,
};
static const unsigned int audio_clkb_b_pins[] = {
	/* CLKB */
	RCAR_GP_PIN(3, 26),
};
static const unsigned int audio_clkb_b_mux[] = {
	AUDIO_CLKB_B_MARK,
};
static const unsigned int audio_clkb_c_pins[] = {
	/* CLKB */
	RCAR_GP_PIN(4, 21),
};
static const unsigned int audio_clkb_c_mux[] = {
	AUDIO_CLKB_C_MARK,
};
static const unsigned int audio_clkc_pins[] = {
	/* CLKC */
	RCAR_GP_PIN(5, 22),
};
static const unsigned int audio_clkc_mux[] = {
	AUDIO_CLKC_MARK,
};
static const unsigned int audio_clkc_b_pins[] = {
	/* CLKC */
	RCAR_GP_PIN(3, 29),
};
static const unsigned int audio_clkc_b_mux[] = {
	AUDIO_CLKC_B_MARK,
};
static const unsigned int audio_clkc_c_pins[] = {
	/* CLKC */
	RCAR_GP_PIN(4, 22),
};
static const unsigned int audio_clkc_c_mux[] = {
	AUDIO_CLKC_C_MARK,
};
static const unsigned int audio_clkout_pins[] = {
	/* CLKOUT */
	RCAR_GP_PIN(5, 23),
};
static const unsigned int audio_clkout_mux[] = {
	AUDIO_CLKOUT_MARK,
};
static const unsigned int audio_clkout_b_pins[] = {
	/* CLKOUT */
	RCAR_GP_PIN(3, 12),
};
static const unsigned int audio_clkout_b_mux[] = {
	AUDIO_CLKOUT_B_MARK,
};
static const unsigned int audio_clkout_c_pins[] = {
	/* CLKOUT */
	RCAR_GP_PIN(4, 23),
};
static const unsigned int audio_clkout_c_mux[] = {
	AUDIO_CLKOUT_C_MARK,
};
/* - AVB -------------------------------------------------------------------- */
static const unsigned int avb_link_pins[] = {
	RCAR_GP_PIN(3, 26),
};
static const unsigned int avb_link_mux[] = {
	AVB_LINK_MARK,
};
static const unsigned int avb_magic_pins[] = {
	RCAR_GP_PIN(3, 27),
};
static const unsigned int avb_magic_mux[] = {
	AVB_MAGIC_MARK,
};
static const unsigned int avb_phy_int_pins[] = {
	RCAR_GP_PIN(3, 28),
};
static const unsigned int avb_phy_int_mux[] = {
	AVB_PHY_INT_MARK,
};
static const unsigned int avb_mdio_pins[] = {
	RCAR_GP_PIN(3, 24), RCAR_GP_PIN(3, 25),
};
static const unsigned int avb_mdio_mux[] = {
	AVB_MDC_MARK, AVB_MDIO_MARK,
};
static const unsigned int avb_mii_pins[] = {
	RCAR_GP_PIN(3, 14), RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 16),
	RCAR_GP_PIN(3, 17),

	RCAR_GP_PIN(3, 2), RCAR_GP_PIN(3, 3), RCAR_GP_PIN(3, 4),
	RCAR_GP_PIN(3, 5),

	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 0), RCAR_GP_PIN(3, 1),
	RCAR_GP_PIN(3, 29), RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 22),
	RCAR_GP_PIN(3, 13), RCAR_GP_PIN(3, 11),
};
static const unsigned int avb_mii_mux[] = {
	AVB_TXD0_MARK, AVB_TXD1_MARK, AVB_TXD2_MARK,
	AVB_TXD3_MARK,

	AVB_RXD0_MARK, AVB_RXD1_MARK, AVB_RXD2_MARK,
	AVB_RXD3_MARK,

	AVB_RX_ER_MARK, AVB_RX_CLK_MARK, AVB_RX_DV_MARK,
	AVB_CRS_MARK, AVB_TX_EN_MARK, AVB_TX_ER_MARK,
	AVB_TX_CLK_MARK, AVB_COL_MARK,
};
static const unsigned int avb_gmii_pins[] = {
	RCAR_GP_PIN(3, 14), RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 16),
	RCAR_GP_PIN(3, 17), RCAR_GP_PIN(3, 18), RCAR_GP_PIN(3, 19),
	RCAR_GP_PIN(3, 20), RCAR_GP_PIN(3, 21),

	RCAR_GP_PIN(3, 2), RCAR_GP_PIN(3, 3), RCAR_GP_PIN(3, 4),
	RCAR_GP_PIN(3, 5), RCAR_GP_PIN(3, 6), RCAR_GP_PIN(3, 7),
	RCAR_GP_PIN(3, 8), RCAR_GP_PIN(3, 9),

	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 0), RCAR_GP_PIN(3, 1),
	RCAR_GP_PIN(3, 29), RCAR_GP_PIN(3, 23), RCAR_GP_PIN(3, 30),
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 22), RCAR_GP_PIN(3, 13),
	RCAR_GP_PIN(3, 11),
};
static const unsigned int avb_gmii_mux[] = {
	AVB_TXD0_MARK, AVB_TXD1_MARK, AVB_TXD2_MARK,
	AVB_TXD3_MARK, AVB_TXD4_MARK, AVB_TXD5_MARK,
	AVB_TXD6_MARK, AVB_TXD7_MARK,

	AVB_RXD0_MARK, AVB_RXD1_MARK, AVB_RXD2_MARK,
	AVB_RXD3_MARK, AVB_RXD4_MARK, AVB_RXD5_MARK,
	AVB_RXD6_MARK, AVB_RXD7_MARK,

	AVB_RX_ER_MARK, AVB_RX_CLK_MARK, AVB_RX_DV_MARK,
	AVB_CRS_MARK, AVB_GTX_CLK_MARK, AVB_GTXREFCLK_MARK,
	AVB_TX_EN_MARK, AVB_TX_ER_MARK, AVB_TX_CLK_MARK,
	AVB_COL_MARK,
};

/* - CAN -------------------------------------------------------------------- */
static const unsigned int can0_data_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(6, 15), RCAR_GP_PIN(6, 14),
};

static const unsigned int can0_data_mux[] = {
	CAN0_TX_MARK, CAN0_RX_MARK,
};

static const unsigned int can0_data_b_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(3, 16), RCAR_GP_PIN(3, 15),
};

static const unsigned int can0_data_b_mux[] = {
	CAN0_TX_B_MARK, CAN0_RX_B_MARK,
};

static const unsigned int can0_data_c_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(2, 17), RCAR_GP_PIN(2, 16),
};

static const unsigned int can0_data_c_mux[] = {
	CAN0_TX_C_MARK, CAN0_RX_C_MARK,
};

static const unsigned int can0_data_d_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(5, 12), RCAR_GP_PIN(5, 11),
};

static const unsigned int can0_data_d_mux[] = {
	CAN0_TX_D_MARK, CAN0_RX_D_MARK,
};

static const unsigned int can1_data_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(6, 25), RCAR_GP_PIN(6, 24),
};

static const unsigned int can1_data_mux[] = {
	CAN1_TX_MARK, CAN1_RX_MARK,
};

static const unsigned int can1_data_b_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(1, 2), RCAR_GP_PIN(1, 1),
};

static const unsigned int can1_data_b_mux[] = {
	CAN1_TX_B_MARK, CAN1_RX_B_MARK,
};

static const unsigned int can1_data_c_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(5, 6), RCAR_GP_PIN(5, 5),
};

static const unsigned int can1_data_c_mux[] = {
	CAN1_TX_C_MARK, CAN1_RX_C_MARK,
};

static const unsigned int can1_data_d_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(3, 31), RCAR_GP_PIN(3, 30),
};

static const unsigned int can1_data_d_mux[] = {
	CAN1_TX_D_MARK, CAN1_RX_D_MARK,
};

static const unsigned int can_clk_pins[] = {
	/* CLK */
	RCAR_GP_PIN(3, 31),
};

static const unsigned int can_clk_mux[] = {
	CAN_CLK_MARK,
};

static const unsigned int can_clk_b_pins[] = {
	/* CLK */
	RCAR_GP_PIN(1, 23),
};

static const unsigned int can_clk_b_mux[] = {
	CAN_CLK_B_MARK,
};

static const unsigned int can_clk_c_pins[] = {
	/* CLK */
	RCAR_GP_PIN(1, 0),
};

static const unsigned int can_clk_c_mux[] = {
	CAN_CLK_C_MARK,
};

static const unsigned int can_clk_d_pins[] = {
	/* CLK */
	RCAR_GP_PIN(5, 0),
};

static const unsigned int can_clk_d_mux[] = {
	CAN_CLK_D_MARK,
};

/* - DU --------------------------------------------------------------------- */
static const unsigned int du0_rgb666_pins[] = {
	/* R[7:2], G[7:2], B[7:2] */
	RCAR_GP_PIN(2, 7),  RCAR_GP_PIN(2, 6),  RCAR_GP_PIN(2, 5),
	RCAR_GP_PIN(2, 4),  RCAR_GP_PIN(2, 3),  RCAR_GP_PIN(2, 2),
	RCAR_GP_PIN(2, 15), RCAR_GP_PIN(2, 14), RCAR_GP_PIN(2, 13),
	RCAR_GP_PIN(2, 12), RCAR_GP_PIN(2, 11), RCAR_GP_PIN(2, 10),
	RCAR_GP_PIN(2, 23), RCAR_GP_PIN(2, 22), RCAR_GP_PIN(2, 21),
	RCAR_GP_PIN(2, 20), RCAR_GP_PIN(2, 19), RCAR_GP_PIN(2, 18),
};
static const unsigned int du0_rgb666_mux[] = {
	DU0_DR7_MARK, DU0_DR6_MARK, DU0_DR5_MARK, DU0_DR4_MARK,
	DU0_DR3_MARK, DU0_DR2_MARK,
	DU0_DG7_MARK, DU0_DG6_MARK, DU0_DG5_MARK, DU0_DG4_MARK,
	DU0_DG3_MARK, DU0_DG2_MARK,
	DU0_DB7_MARK, DU0_DB6_MARK, DU0_DB5_MARK, DU0_DB4_MARK,
	DU0_DB3_MARK, DU0_DB2_MARK,
};
static const unsigned int du0_rgb888_pins[] = {
	/* R[7:0], G[7:0], B[7:0] */
	RCAR_GP_PIN(2, 7),  RCAR_GP_PIN(2, 6),  RCAR_GP_PIN(2, 5),
	RCAR_GP_PIN(2, 4),  RCAR_GP_PIN(2, 3),  RCAR_GP_PIN(2, 2),
	RCAR_GP_PIN(2, 1),  RCAR_GP_PIN(2, 0),
	RCAR_GP_PIN(2, 15), RCAR_GP_PIN(2, 14), RCAR_GP_PIN(2, 13),
	RCAR_GP_PIN(2, 12), RCAR_GP_PIN(2, 11), RCAR_GP_PIN(2, 10),
	RCAR_GP_PIN(2, 9),  RCAR_GP_PIN(2, 8),
	RCAR_GP_PIN(2, 23), RCAR_GP_PIN(2, 22), RCAR_GP_PIN(2, 21),
	RCAR_GP_PIN(2, 20), RCAR_GP_PIN(2, 19), RCAR_GP_PIN(2, 18),
	RCAR_GP_PIN(2, 17), RCAR_GP_PIN(2, 16),
};
static const unsigned int du0_rgb888_mux[] = {
	DU0_DR7_MARK, DU0_DR6_MARK, DU0_DR5_MARK, DU0_DR4_MARK,
	DU0_DR3_MARK, DU0_DR2_MARK, DU0_DR1_MARK, DU0_DR0_MARK,
	DU0_DG7_MARK, DU0_DG6_MARK, DU0_DG5_MARK, DU0_DG4_MARK,
	DU0_DG3_MARK, DU0_DG2_MARK, DU0_DG1_MARK, DU0_DG0_MARK,
	DU0_DB7_MARK, DU0_DB6_MARK, DU0_DB5_MARK, DU0_DB4_MARK,
	DU0_DB3_MARK, DU0_DB2_MARK, DU0_DB1_MARK, DU0_DB0_MARK,
};
static const unsigned int du0_clk0_out_pins[] = {
	/* DOTCLKOUT0 */
	RCAR_GP_PIN(2, 25),
};
static const unsigned int du0_clk0_out_mux[] = {
	DU0_DOTCLKOUT0_MARK
};
static const unsigned int du0_clk1_out_pins[] = {
	/* DOTCLKOUT1 */
	RCAR_GP_PIN(2, 26),
};
static const unsigned int du0_clk1_out_mux[] = {
	DU0_DOTCLKOUT1_MARK
};
static const unsigned int du0_clk_in_pins[] = {
	/* CLKIN */
	RCAR_GP_PIN(2, 24),
};
static const unsigned int du0_clk_in_mux[] = {
	DU0_DOTCLKIN_MARK
};
static const unsigned int du0_sync_pins[] = {
	/* EXVSYNC/VSYNC, EXHSYNC/HSYNC */
	RCAR_GP_PIN(2, 28), RCAR_GP_PIN(2, 27),
};
static const unsigned int du0_sync_mux[] = {
	DU0_EXVSYNC_DU0_VSYNC_MARK, DU0_EXHSYNC_DU0_HSYNC_MARK
};
static const unsigned int du0_oddf_pins[] = {
	/* EXODDF/ODDF/DISP/CDE */
	RCAR_GP_PIN(2, 29),
};
static const unsigned int du0_oddf_mux[] = {
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK,
};
static const unsigned int du0_cde_pins[] = {
	/* CDE */
	RCAR_GP_PIN(2, 31),
};
static const unsigned int du0_cde_mux[] = {
	DU0_CDE_MARK,
};
static const unsigned int du0_disp_pins[] = {
	/* DISP */
	RCAR_GP_PIN(2, 30),
};
static const unsigned int du0_disp_mux[] = {
	DU0_DISP_MARK
};
static const unsigned int du1_rgb666_pins[] = {
	/* R[7:2], G[7:2], B[7:2] */
	RCAR_GP_PIN(4, 7),  RCAR_GP_PIN(4, 6),  RCAR_GP_PIN(4, 5),
	RCAR_GP_PIN(4, 4),  RCAR_GP_PIN(4, 3),  RCAR_GP_PIN(4, 2),
	RCAR_GP_PIN(4, 15), RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 13),
	RCAR_GP_PIN(4, 12), RCAR_GP_PIN(4, 11), RCAR_GP_PIN(4, 10),
	RCAR_GP_PIN(4, 23), RCAR_GP_PIN(4, 22), RCAR_GP_PIN(4, 21),
	RCAR_GP_PIN(4, 20), RCAR_GP_PIN(4, 19), RCAR_GP_PIN(4, 18),
};
static const unsigned int du1_rgb666_mux[] = {
	DU1_DR7_MARK, DU1_DR6_MARK, DU1_DR5_MARK, DU1_DR4_MARK,
	DU1_DR3_MARK, DU1_DR2_MARK,
	DU1_DG7_MARK, DU1_DG6_MARK, DU1_DG5_MARK, DU1_DG4_MARK,
	DU1_DG3_MARK, DU1_DG2_MARK,
	DU1_DB7_MARK, DU1_DB6_MARK, DU1_DB5_MARK, DU1_DB4_MARK,
	DU1_DB3_MARK, DU1_DB2_MARK,
};
static const unsigned int du1_rgb888_pins[] = {
	/* R[7:0], G[7:0], B[7:0] */
	RCAR_GP_PIN(4, 7),  RCAR_GP_PIN(4, 6),  RCAR_GP_PIN(4, 5),
	RCAR_GP_PIN(4, 4),  RCAR_GP_PIN(4, 3),  RCAR_GP_PIN(4, 2),
	RCAR_GP_PIN(4, 1),  RCAR_GP_PIN(4, 0),
	RCAR_GP_PIN(4, 15), RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 13),
	RCAR_GP_PIN(4, 12), RCAR_GP_PIN(4, 11), RCAR_GP_PIN(4, 10),
	RCAR_GP_PIN(4, 9),  RCAR_GP_PIN(4, 8),
	RCAR_GP_PIN(4, 23), RCAR_GP_PIN(4, 22), RCAR_GP_PIN(4, 21),
	RCAR_GP_PIN(4, 20), RCAR_GP_PIN(4, 19), RCAR_GP_PIN(4, 18),
	RCAR_GP_PIN(4, 17), RCAR_GP_PIN(4, 16),
};
static const unsigned int du1_rgb888_mux[] = {
	DU1_DR7_MARK, DU1_DR6_MARK, DU1_DR5_MARK, DU1_DR4_MARK,
	DU1_DR3_MARK, DU1_DR2_MARK, DU1_DR1_MARK, DU1_DR0_MARK,
	DU1_DG7_MARK, DU1_DG6_MARK, DU1_DG5_MARK, DU1_DG4_MARK,
	DU1_DG3_MARK, DU1_DG2_MARK, DU1_DG1_MARK, DU1_DG0_MARK,
	DU1_DB7_MARK, DU1_DB6_MARK, DU1_DB5_MARK, DU1_DB4_MARK,
	DU1_DB3_MARK, DU1_DB2_MARK, DU1_DB1_MARK, DU1_DB0_MARK,
};
static const unsigned int du1_clk0_out_pins[] = {
	/* DOTCLKOUT0 */
	RCAR_GP_PIN(4, 25),
};
static const unsigned int du1_clk0_out_mux[] = {
	DU1_DOTCLKOUT0_MARK
};
static const unsigned int du1_clk1_out_pins[] = {
	/* DOTCLKOUT1 */
	RCAR_GP_PIN(4, 26),
};
static const unsigned int du1_clk1_out_mux[] = {
	DU1_DOTCLKOUT1_MARK
};
static const unsigned int du1_clk_in_pins[] = {
	/* DOTCLKIN */
	RCAR_GP_PIN(4, 24),
};
static const unsigned int du1_clk_in_mux[] = {
	DU1_DOTCLKIN_MARK
};
static const unsigned int du1_sync_pins[] = {
	/* EXVSYNC/VSYNC, EXHSYNC/HSYNC */
	RCAR_GP_PIN(4, 28), RCAR_GP_PIN(4, 27),
};
static const unsigned int du1_sync_mux[] = {
	DU1_EXVSYNC_DU1_VSYNC_MARK, DU1_EXHSYNC_DU1_HSYNC_MARK
};
static const unsigned int du1_oddf_pins[] = {
	/* EXODDF/ODDF/DISP/CDE */
	RCAR_GP_PIN(4, 29),
};
static const unsigned int du1_oddf_mux[] = {
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK,
};
static const unsigned int du1_cde_pins[] = {
	/* CDE */
	RCAR_GP_PIN(4, 31),
};
static const unsigned int du1_cde_mux[] = {
	DU1_CDE_MARK
};
static const unsigned int du1_disp_pins[] = {
	/* DISP */
	RCAR_GP_PIN(4, 30),
};
static const unsigned int du1_disp_mux[] = {
	DU1_DISP_MARK
};
/* - ETH -------------------------------------------------------------------- */
static const unsigned int eth_link_pins[] = {
	/* LINK */
	RCAR_GP_PIN(3, 18),
};
static const unsigned int eth_link_mux[] = {
	ETH_LINK_MARK,
};
static const unsigned int eth_magic_pins[] = {
	/* MAGIC */
	RCAR_GP_PIN(3, 22),
};
static const unsigned int eth_magic_mux[] = {
	ETH_MAGIC_MARK,
};
static const unsigned int eth_mdio_pins[] = {
	/* MDC, MDIO */
	RCAR_GP_PIN(3, 24), RCAR_GP_PIN(3, 13),
};
static const unsigned int eth_mdio_mux[] = {
	ETH_MDC_MARK, ETH_MDIO_MARK,
};
static const unsigned int eth_rmii_pins[] = {
	/* RXD[0:1], RX_ER, CRS_DV, TXD[0:1], TX_EN, REF_CLK */
	RCAR_GP_PIN(3, 16), RCAR_GP_PIN(3, 17), RCAR_GP_PIN(3, 15),
	RCAR_GP_PIN(3, 14), RCAR_GP_PIN(3, 23), RCAR_GP_PIN(3, 20),
	RCAR_GP_PIN(3, 21), RCAR_GP_PIN(3, 19),
};
static const unsigned int eth_rmii_mux[] = {
	ETH_RXD0_MARK, ETH_RXD1_MARK, ETH_RX_ER_MARK, ETH_CRS_DV_MARK,
	ETH_TXD0_MARK, ETH_TXD1_MARK, ETH_TX_EN_MARK, ETH_REFCLK_MARK,
};
static const unsigned int eth_link_b_pins[] = {
	/* LINK */
	RCAR_GP_PIN(5, 15),
};
static const unsigned int eth_link_b_mux[] = {
	ETH_LINK_B_MARK,
};
static const unsigned int eth_magic_b_pins[] = {
	/* MAGIC */
	RCAR_GP_PIN(5, 19),
};
static const unsigned int eth_magic_b_mux[] = {
	ETH_MAGIC_B_MARK,
};
static const unsigned int eth_mdio_b_pins[] = {
	/* MDC, MDIO */
	RCAR_GP_PIN(5, 21), RCAR_GP_PIN(5, 10),
};
static const unsigned int eth_mdio_b_mux[] = {
	ETH_MDC_B_MARK, ETH_MDIO_B_MARK,
};
static const unsigned int eth_rmii_b_pins[] = {
	/* RXD[0:1], RX_ER, CRS_DV, TXD[0:1], TX_EN, REF_CLK */
	RCAR_GP_PIN(5, 13), RCAR_GP_PIN(5, 14), RCAR_GP_PIN(5, 12),
	RCAR_GP_PIN(5, 11), RCAR_GP_PIN(5, 20), RCAR_GP_PIN(5, 17),
	RCAR_GP_PIN(5, 18), RCAR_GP_PIN(5, 16),
};
static const unsigned int eth_rmii_b_mux[] = {
	ETH_RXD0_B_MARK, ETH_RXD1_B_MARK, ETH_RX_ER_B_MARK, ETH_CRS_DV_B_MARK,
	ETH_TXD0_B_MARK, ETH_TXD1_B_MARK, ETH_TX_EN_B_MARK, ETH_REFCLK_B_MARK,
};
/* - HSCIF0 ----------------------------------------------------------------- */
static const unsigned int hscif0_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 25), RCAR_GP_PIN(3, 26),
};
static const unsigned int hscif0_data_mux[] = {
	HSCIF0_HRX_MARK, HSCIF0_HTX_MARK,
};
static const unsigned int hscif0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 29),
};
static const unsigned int hscif0_clk_mux[] = {
	HSCIF0_HSCK_MARK,
};
static const unsigned int hscif0_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(3, 28), RCAR_GP_PIN(3, 27),
};
static const unsigned int hscif0_ctrl_mux[] = {
	HSCIF0_HRTS_N_MARK, HSCIF0_HCTS_N_MARK,
};
static const unsigned int hscif0_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(0, 30), RCAR_GP_PIN(0, 31),
};
static const unsigned int hscif0_data_b_mux[] = {
	HSCIF0_HRX_B_MARK, HSCIF0_HTX_B_MARK,
};
static const unsigned int hscif0_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 0),
};
static const unsigned int hscif0_clk_b_mux[] = {
	HSCIF0_HSCK_B_MARK,
};
/* - HSCIF1 ----------------------------------------------------------------- */
static const unsigned int hscif1_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 8), RCAR_GP_PIN(4, 9),
};
static const unsigned int hscif1_data_mux[] = {
	HSCIF1_HRX_MARK, HSCIF1_HTX_MARK,
};
static const unsigned int hscif1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 10),
};
static const unsigned int hscif1_clk_mux[] = {
	HSCIF1_HSCK_MARK,
};
static const unsigned int hscif1_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(4, 12), RCAR_GP_PIN(4, 11),
};
static const unsigned int hscif1_ctrl_mux[] = {
	HSCIF1_HRTS_N_MARK, HSCIF1_HCTS_N_MARK,
};
static const unsigned int hscif1_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(5, 13), RCAR_GP_PIN(5, 14),
};
static const unsigned int hscif1_data_b_mux[] = {
	HSCIF1_HRX_B_MARK, HSCIF1_HTX_B_MARK,
};
static const unsigned int hscif1_ctrl_b_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(5, 16), RCAR_GP_PIN(5, 15),
};
static const unsigned int hscif1_ctrl_b_mux[] = {
	HSCIF1_HRTS_N_B_MARK, HSCIF1_HCTS_N_B_MARK,
};
/* - HSCIF2 ----------------------------------------------------------------- */
static const unsigned int hscif2_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(0, 8), RCAR_GP_PIN(0, 9),
};
static const unsigned int hscif2_data_mux[] = {
	HSCIF2_HRX_MARK, HSCIF2_HTX_MARK,
};
static const unsigned int hscif2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 10),
};
static const unsigned int hscif2_clk_mux[] = {
	HSCIF2_HSCK_MARK,
};
static const unsigned int hscif2_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(0, 12), RCAR_GP_PIN(0, 11),
};
static const unsigned int hscif2_ctrl_mux[] = {
	HSCIF2_HRTS_N_MARK, HSCIF2_HCTS_N_MARK,
};
/* - I2C0 ------------------------------------------------------------------- */
static const unsigned int i2c0_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(3, 30), RCAR_GP_PIN(3, 31),
};
static const unsigned int i2c0_mux[] = {
	I2C0_SCL_MARK, I2C0_SDA_MARK,
};
static const unsigned int i2c0_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(5, 20), RCAR_GP_PIN(5, 21),
};
static const unsigned int i2c0_b_mux[] = {
	I2C0_SCL_B_MARK, I2C0_SDA_B_MARK,
};
static const unsigned int i2c0_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(3, 11), RCAR_GP_PIN(3, 12),
};
static const unsigned int i2c0_c_mux[] = {
	I2C0_SCL_C_MARK, I2C0_SDA_C_MARK,
};
static const unsigned int i2c0_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(0, 5), RCAR_GP_PIN(0, 6),
};
static const unsigned int i2c0_d_mux[] = {
	I2C0_SCL_D_MARK, I2C0_SDA_D_MARK,
};
static const unsigned int i2c0_e_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(3, 27), RCAR_GP_PIN(3, 28),
};
static const unsigned int i2c0_e_mux[] = {
	I2C0_SCL_E_MARK, I2C0_SDA_E_MARK,
};
/* - I2C1 ------------------------------------------------------------------- */
static const unsigned int i2c1_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 0), RCAR_GP_PIN(4, 1),
};
static const unsigned int i2c1_mux[] = {
	I2C1_SCL_MARK, I2C1_SDA_MARK,
};
static const unsigned int i2c1_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(0, 8), RCAR_GP_PIN(0, 9),
};
static const unsigned int i2c1_b_mux[] = {
	I2C1_SCL_B_MARK, I2C1_SDA_B_MARK,
};
static const unsigned int i2c1_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(3, 25), RCAR_GP_PIN(3, 26),
};
static const unsigned int i2c1_c_mux[] = {
	I2C1_SCL_C_MARK, I2C1_SDA_C_MARK,
};
static const unsigned int i2c1_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(0, 11), RCAR_GP_PIN(0, 12),
};
static const unsigned int i2c1_d_mux[] = {
	I2C1_SCL_D_MARK, I2C1_SDA_D_MARK,
};
static const unsigned int i2c1_e_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 20), RCAR_GP_PIN(4, 21),
};
static const unsigned int i2c1_e_mux[] = {
	I2C1_SCL_E_MARK, I2C1_SDA_E_MARK,
};
/* - I2C2 ------------------------------------------------------------------- */
static const unsigned int i2c2_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 22), RCAR_GP_PIN(4, 23),
};
static const unsigned int i2c2_mux[] = {
	I2C2_SCL_MARK, I2C2_SDA_MARK,
};
static const unsigned int i2c2_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(6, 24), RCAR_GP_PIN(6, 25),
};
static const unsigned int i2c2_b_mux[] = {
	I2C2_SCL_B_MARK, I2C2_SDA_B_MARK,
};
static const unsigned int i2c2_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 2), RCAR_GP_PIN(4, 3),
};
static const unsigned int i2c2_c_mux[] = {
	I2C2_SCL_C_MARK, I2C2_SDA_C_MARK,
};
static const unsigned int i2c2_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(2, 0), RCAR_GP_PIN(2, 1),
};
static const unsigned int i2c2_d_mux[] = {
	I2C2_SCL_D_MARK, I2C2_SDA_D_MARK,
};
static const unsigned int i2c2_e_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(1, 16), RCAR_GP_PIN(1, 17),
};
static const unsigned int i2c2_e_mux[] = {
	I2C2_SCL_E_MARK, I2C2_SDA_E_MARK,
};
/* - I2C3 ------------------------------------------------------------------- */
static const unsigned int i2c3_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(3, 9), RCAR_GP_PIN(3, 10),
};
static const unsigned int i2c3_mux[] = {
	I2C3_SCL_MARK, I2C3_SDA_MARK,
};
static const unsigned int i2c3_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(0, 3), RCAR_GP_PIN(0, 4),
};
static const unsigned int i2c3_b_mux[] = {
	I2C3_SCL_B_MARK, I2C3_SDA_B_MARK,
};
static const unsigned int i2c3_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 25), RCAR_GP_PIN(4, 26),
};
static const unsigned int i2c3_c_mux[] = {
	I2C3_SCL_C_MARK, I2C3_SDA_C_MARK,
};
static const unsigned int i2c3_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(2, 8), RCAR_GP_PIN(2, 9),
};
static const unsigned int i2c3_d_mux[] = {
	I2C3_SCL_D_MARK, I2C3_SDA_D_MARK,
};
static const unsigned int i2c3_e_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(5, 18), RCAR_GP_PIN(5, 19),
};
static const unsigned int i2c3_e_mux[] = {
	I2C3_SCL_E_MARK, I2C3_SDA_E_MARK,
};
/* - I2C4 ------------------------------------------------------------------- */
static const unsigned int i2c4_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 8), RCAR_GP_PIN(4, 9),
};
static const unsigned int i2c4_mux[] = {
	I2C4_SCL_MARK, I2C4_SDA_MARK,
};
static const unsigned int i2c4_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(5, 22), RCAR_GP_PIN(5, 23),
};
static const unsigned int i2c4_b_mux[] = {
	I2C4_SCL_B_MARK, I2C4_SDA_B_MARK,
};
static const unsigned int i2c4_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 28), RCAR_GP_PIN(4, 29),
};
static const unsigned int i2c4_c_mux[] = {
	I2C4_SCL_C_MARK, I2C4_SDA_C_MARK,
};
static const unsigned int i2c4_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(2, 16), RCAR_GP_PIN(2, 17),
};
static const unsigned int i2c4_d_mux[] = {
	I2C4_SCL_D_MARK, I2C4_SDA_D_MARK,
};
static const unsigned int i2c4_e_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(3, 23), RCAR_GP_PIN(3, 24),
};
static const unsigned int i2c4_e_mux[] = {
	I2C4_SCL_E_MARK, I2C4_SDA_E_MARK,
};
/* - I2C5 ------------------------------------------------------------------- */
static const unsigned int i2c5_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 15),
};
static const unsigned int i2c5_mux[] = {
	I2C5_SCL_MARK, I2C5_SDA_MARK,
};
static const unsigned int i2c5_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(0, 14), RCAR_GP_PIN(0, 15),
};
static const unsigned int i2c5_b_mux[] = {
	I2C5_SCL_B_MARK, I2C5_SDA_B_MARK,
};
static const unsigned int i2c5_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 31), RCAR_GP_PIN(4, 30),
};
static const unsigned int i2c5_c_mux[] = {
	I2C5_SCL_C_MARK, I2C5_SDA_C_MARK,
};
static const unsigned int i2c5_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(3, 13), RCAR_GP_PIN(3, 14),
};
static const unsigned int i2c5_d_mux[] = {
	I2C5_SCL_D_MARK, I2C5_SDA_D_MARK,
};
/* - INTC ------------------------------------------------------------------- */
static const unsigned int intc_irq0_pins[] = {
	/* IRQ0 */
	RCAR_GP_PIN(4, 4),
};
static const unsigned int intc_irq0_mux[] = {
	IRQ0_MARK,
};
static const unsigned int intc_irq1_pins[] = {
	/* IRQ1 */
	RCAR_GP_PIN(4, 18),
};
static const unsigned int intc_irq1_mux[] = {
	IRQ1_MARK,
};
static const unsigned int intc_irq2_pins[] = {
	/* IRQ2 */
	RCAR_GP_PIN(4, 19),
};
static const unsigned int intc_irq2_mux[] = {
	IRQ2_MARK,
};
static const unsigned int intc_irq3_pins[] = {
	/* IRQ3 */
	RCAR_GP_PIN(0, 7),
};
static const unsigned int intc_irq3_mux[] = {
	IRQ3_MARK,
};
static const unsigned int intc_irq4_pins[] = {
	/* IRQ4 */
	RCAR_GP_PIN(0, 0),
};
static const unsigned int intc_irq4_mux[] = {
	IRQ4_MARK,
};
static const unsigned int intc_irq5_pins[] = {
	/* IRQ5 */
	RCAR_GP_PIN(4, 1),
};
static const unsigned int intc_irq5_mux[] = {
	IRQ5_MARK,
};
static const unsigned int intc_irq6_pins[] = {
	/* IRQ6 */
	RCAR_GP_PIN(0, 10),
};
static const unsigned int intc_irq6_mux[] = {
	IRQ6_MARK,
};
static const unsigned int intc_irq7_pins[] = {
	/* IRQ7 */
	RCAR_GP_PIN(6, 15),
};
static const unsigned int intc_irq7_mux[] = {
	IRQ7_MARK,
};
static const unsigned int intc_irq8_pins[] = {
	/* IRQ8 */
	RCAR_GP_PIN(5, 0),
};
static const unsigned int intc_irq8_mux[] = {
	IRQ8_MARK,
};
static const unsigned int intc_irq9_pins[] = {
	/* IRQ9 */
	RCAR_GP_PIN(5, 10),
};
static const unsigned int intc_irq9_mux[] = {
	IRQ9_MARK,
};
/* - MMCIF ------------------------------------------------------------------ */
static const unsigned int mmc_data1_pins[] = {
	/* D[0] */
	RCAR_GP_PIN(6, 18),
};
static const unsigned int mmc_data1_mux[] = {
	MMC_D0_MARK,
};
static const unsigned int mmc_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(6, 18), RCAR_GP_PIN(6, 19),
	RCAR_GP_PIN(6, 20), RCAR_GP_PIN(6, 21),
};
static const unsigned int mmc_data4_mux[] = {
	MMC_D0_MARK, MMC_D1_MARK, MMC_D2_MARK, MMC_D3_MARK,
};
static const unsigned int mmc_data8_pins[] = {
	/* D[0:7] */
	RCAR_GP_PIN(6, 18), RCAR_GP_PIN(6, 19),
	RCAR_GP_PIN(6, 20), RCAR_GP_PIN(6, 21),
	RCAR_GP_PIN(6, 22), RCAR_GP_PIN(6, 23),
	RCAR_GP_PIN(6, 24), RCAR_GP_PIN(6, 25),
};
static const unsigned int mmc_data8_mux[] = {
	MMC_D0_MARK, MMC_D1_MARK, MMC_D2_MARK, MMC_D3_MARK,
	MMC_D4_MARK, MMC_D5_MARK, MMC_D6_MARK, MMC_D7_MARK,
};
static const unsigned int mmc_ctrl_pins[] = {
	/* CLK, CMD */
	RCAR_GP_PIN(6, 16), RCAR_GP_PIN(6, 17),
};
static const unsigned int mmc_ctrl_mux[] = {
	MMC_CLK_MARK, MMC_CMD_MARK,
};
/* - MSIOF0 ----------------------------------------------------------------- */
static const unsigned int msiof0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 4),
};
static const unsigned int msiof0_clk_mux[] = {
	MSIOF0_SCK_MARK,
};
static const unsigned int msiof0_sync_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(4, 5),
};
static const unsigned int msiof0_sync_mux[] = {
	MSIOF0_SYNC_MARK,
};
static const unsigned int msiof0_ss1_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(4, 6),
};
static const unsigned int msiof0_ss1_mux[] = {
	MSIOF0_SS1_MARK,
};
static const unsigned int msiof0_ss2_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(4, 7),
};
static const unsigned int msiof0_ss2_mux[] = {
	MSIOF0_SS2_MARK,
};
static const unsigned int msiof0_rx_pins[] = {
	/* RXD */
	RCAR_GP_PIN(4, 2),
};
static const unsigned int msiof0_rx_mux[] = {
	MSIOF0_RXD_MARK,
};
static const unsigned int msiof0_tx_pins[] = {
	/* TXD */
	RCAR_GP_PIN(4, 3),
};
static const unsigned int msiof0_tx_mux[] = {
	MSIOF0_TXD_MARK,
};
/* - MSIOF1 ----------------------------------------------------------------- */
static const unsigned int msiof1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 26),
};
static const unsigned int msiof1_clk_mux[] = {
	MSIOF1_SCK_MARK,
};
static const unsigned int msiof1_sync_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(0, 27),
};
static const unsigned int msiof1_sync_mux[] = {
	MSIOF1_SYNC_MARK,
};
static const unsigned int msiof1_ss1_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(0, 28),
};
static const unsigned int msiof1_ss1_mux[] = {
	MSIOF1_SS1_MARK,
};
static const unsigned int msiof1_ss2_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(0, 29),
};
static const unsigned int msiof1_ss2_mux[] = {
	MSIOF1_SS2_MARK,
};
static const unsigned int msiof1_rx_pins[] = {
	/* RXD */
	RCAR_GP_PIN(0, 24),
};
static const unsigned int msiof1_rx_mux[] = {
	MSIOF1_RXD_MARK,
};
static const unsigned int msiof1_tx_pins[] = {
	/* TXD */
	RCAR_GP_PIN(0, 25),
};
static const unsigned int msiof1_tx_mux[] = {
	MSIOF1_TXD_MARK,
};
static const unsigned int msiof1_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 3),
};
static const unsigned int msiof1_clk_b_mux[] = {
	MSIOF1_SCK_B_MARK,
};
static const unsigned int msiof1_sync_b_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(5, 4),
};
static const unsigned int msiof1_sync_b_mux[] = {
	MSIOF1_SYNC_B_MARK,
};
static const unsigned int msiof1_ss1_b_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(5, 5),
};
static const unsigned int msiof1_ss1_b_mux[] = {
	MSIOF1_SS1_B_MARK,
};
static const unsigned int msiof1_ss2_b_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(5, 6),
};
static const unsigned int msiof1_ss2_b_mux[] = {
	MSIOF1_SS2_B_MARK,
};
static const unsigned int msiof1_rx_b_pins[] = {
	/* RXD */
	RCAR_GP_PIN(5, 1),
};
static const unsigned int msiof1_rx_b_mux[] = {
	MSIOF1_RXD_B_MARK,
};
static const unsigned int msiof1_tx_b_pins[] = {
	/* TXD */
	RCAR_GP_PIN(5, 2),
};
static const unsigned int msiof1_tx_b_mux[] = {
	MSIOF1_TXD_B_MARK,
};
/* - MSIOF2 ----------------------------------------------------------------- */
static const unsigned int msiof2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 0),
};
static const unsigned int msiof2_clk_mux[] = {
	MSIOF2_SCK_MARK,
};
static const unsigned int msiof2_sync_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(1, 1),
};
static const unsigned int msiof2_sync_mux[] = {
	MSIOF2_SYNC_MARK,
};
static const unsigned int msiof2_ss1_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(1, 2),
};
static const unsigned int msiof2_ss1_mux[] = {
	MSIOF2_SS1_MARK,
};
static const unsigned int msiof2_ss2_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(1, 3),
};
static const unsigned int msiof2_ss2_mux[] = {
	MSIOF2_SS2_MARK,
};
static const unsigned int msiof2_rx_pins[] = {
	/* RXD */
	RCAR_GP_PIN(0, 30),
};
static const unsigned int msiof2_rx_mux[] = {
	MSIOF2_RXD_MARK,
};
static const unsigned int msiof2_tx_pins[] = {
	/* TXD */
	RCAR_GP_PIN(0, 31),
};
static const unsigned int msiof2_tx_mux[] = {
	MSIOF2_TXD_MARK,
};
static const unsigned int msiof2_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 15),
};
static const unsigned int msiof2_clk_b_mux[] = {
	MSIOF2_SCK_B_MARK,
};
static const unsigned int msiof2_sync_b_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(3, 16),
};
static const unsigned int msiof2_sync_b_mux[] = {
	MSIOF2_SYNC_B_MARK,
};
static const unsigned int msiof2_ss1_b_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(3, 17),
};
static const unsigned int msiof2_ss1_b_mux[] = {
	MSIOF2_SS1_B_MARK,
};
static const unsigned int msiof2_ss2_b_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(3, 18),
};
static const unsigned int msiof2_ss2_b_mux[] = {
	MSIOF2_SS2_B_MARK,
};
static const unsigned int msiof2_rx_b_pins[] = {
	/* RXD */
	RCAR_GP_PIN(3, 13),
};
static const unsigned int msiof2_rx_b_mux[] = {
	MSIOF2_RXD_B_MARK,
};
static const unsigned int msiof2_tx_b_pins[] = {
	/* TXD */
	RCAR_GP_PIN(3, 14),
};
static const unsigned int msiof2_tx_b_mux[] = {
	MSIOF2_TXD_B_MARK,
};
/* - PWM -------------------------------------------------------------------- */
static const unsigned int pwm0_pins[] = {
	RCAR_GP_PIN(1, 14),
};
static const unsigned int pwm0_mux[] = {
	PWM0_MARK,
};
static const unsigned int pwm0_b_pins[] = {
	RCAR_GP_PIN(5, 3),
};
static const unsigned int pwm0_b_mux[] = {
	PWM0_B_MARK,
};
static const unsigned int pwm1_pins[] = {
	RCAR_GP_PIN(4, 5),
};
static const unsigned int pwm1_mux[] = {
	PWM1_MARK,
};
static const unsigned int pwm1_b_pins[] = {
	RCAR_GP_PIN(5, 10),
};
static const unsigned int pwm1_b_mux[] = {
	PWM1_B_MARK,
};
static const unsigned int pwm1_c_pins[] = {
	RCAR_GP_PIN(1, 18),
};
static const unsigned int pwm1_c_mux[] = {
	PWM1_C_MARK,
};
static const unsigned int pwm2_pins[] = {
	RCAR_GP_PIN(4, 10),
};
static const unsigned int pwm2_mux[] = {
	PWM2_MARK,
};
static const unsigned int pwm2_b_pins[] = {
	RCAR_GP_PIN(5, 17),
};
static const unsigned int pwm2_b_mux[] = {
	PWM2_B_MARK,
};
static const unsigned int pwm2_c_pins[] = {
	RCAR_GP_PIN(0, 13),
};
static const unsigned int pwm2_c_mux[] = {
	PWM2_C_MARK,
};
static const unsigned int pwm3_pins[] = {
	RCAR_GP_PIN(4, 13),
};
static const unsigned int pwm3_mux[] = {
	PWM3_MARK,
};
static const unsigned int pwm3_b_pins[] = {
	RCAR_GP_PIN(0, 16),
};
static const unsigned int pwm3_b_mux[] = {
	PWM3_B_MARK,
};
static const unsigned int pwm4_pins[] = {
	RCAR_GP_PIN(1, 3),
};
static const unsigned int pwm4_mux[] = {
	PWM4_MARK,
};
static const unsigned int pwm4_b_pins[] = {
	RCAR_GP_PIN(0, 21),
};
static const unsigned int pwm4_b_mux[] = {
	PWM4_B_MARK,
};
static const unsigned int pwm5_pins[] = {
	RCAR_GP_PIN(3, 30),
};
static const unsigned int pwm5_mux[] = {
	PWM5_MARK,
};
static const unsigned int pwm5_b_pins[] = {
	RCAR_GP_PIN(4, 0),
};
static const unsigned int pwm5_b_mux[] = {
	PWM5_B_MARK,
};
static const unsigned int pwm5_c_pins[] = {
	RCAR_GP_PIN(0, 10),
};
static const unsigned int pwm5_c_mux[] = {
	PWM5_C_MARK,
};
static const unsigned int pwm6_pins[] = {
	RCAR_GP_PIN(4, 8),
};
static const unsigned int pwm6_mux[] = {
	PWM6_MARK,
};
static const unsigned int pwm6_b_pins[] = {
	RCAR_GP_PIN(0, 7),
};
static const unsigned int pwm6_b_mux[] = {
	PWM6_B_MARK,
};
/* - QSPI ------------------------------------------------------------------- */
static const unsigned int qspi_ctrl_pins[] = {
	/* SPCLK, SSL */
	RCAR_GP_PIN(1, 4), RCAR_GP_PIN(1, 9),
};
static const unsigned int qspi_ctrl_mux[] = {
	SPCLK_MARK, SSL_MARK,
};
static const unsigned int qspi_data2_pins[] = {
	/* MOSI_IO0, MISO_IO1 */
	RCAR_GP_PIN(1, 5), RCAR_GP_PIN(1, 6),
};
static const unsigned int qspi_data2_mux[] = {
	MOSI_IO0_MARK, MISO_IO1_MARK,
};
static const unsigned int qspi_data4_pins[] = {
	/* MOSI_IO0, MISO_IO1, IO2, IO3 */
	RCAR_GP_PIN(1, 5), RCAR_GP_PIN(1, 6), RCAR_GP_PIN(1, 7),
	RCAR_GP_PIN(1, 8),
};
static const unsigned int qspi_data4_mux[] = {
	MOSI_IO0_MARK, MISO_IO1_MARK, IO2_MARK, IO3_MARK,
};
/* - SCIF0 ------------------------------------------------------------------ */
static const unsigned int scif0_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(6, 24), RCAR_GP_PIN(6, 25),
};
static const unsigned int scif0_data_mux[] = {
	SCIF0_RXD_MARK, SCIF0_TXD_MARK,
};
static const unsigned int scif0_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 11), RCAR_GP_PIN(3, 12),
};
static const unsigned int scif0_data_b_mux[] = {
	SCIF0_RXD_B_MARK, SCIF0_TXD_B_MARK,
};
static const unsigned int scif0_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 30), RCAR_GP_PIN(3, 31),
};
static const unsigned int scif0_data_c_mux[] = {
	SCIF0_RXD_C_MARK, SCIF0_TXD_C_MARK,
};
static const unsigned int scif0_data_d_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 27), RCAR_GP_PIN(3, 28),
};
static const unsigned int scif0_data_d_mux[] = {
	SCIF0_RXD_D_MARK, SCIF0_TXD_D_MARK,
};
/* - SCIF1 ------------------------------------------------------------------ */
static const unsigned int scif1_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 15),
};
static const unsigned int scif1_data_mux[] = {
	SCIF1_RXD_MARK, SCIF1_TXD_MARK,
};
static const unsigned int scif1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 13),
};
static const unsigned int scif1_clk_mux[] = {
	SCIF1_SCK_MARK,
};
static const unsigned int scif1_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(5, 11), RCAR_GP_PIN(5, 12),
};
static const unsigned int scif1_data_b_mux[] = {
	SCIF1_RXD_B_MARK, SCIF1_TXD_B_MARK,
};
static const unsigned int scif1_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 10),
};
static const unsigned int scif1_clk_b_mux[] = {
	SCIF1_SCK_B_MARK,
};
static const unsigned int scif1_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(0, 11), RCAR_GP_PIN(0, 12),
};
static const unsigned int scif1_data_c_mux[] = {
	SCIF1_RXD_C_MARK, SCIF1_TXD_C_MARK,
};
static const unsigned int scif1_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 10),
};
static const unsigned int scif1_clk_c_mux[] = {
	SCIF1_SCK_C_MARK,
};
/* - SCIF2 ------------------------------------------------------------------ */
static const unsigned int scif2_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 16), RCAR_GP_PIN(4, 17),
};
static const unsigned int scif2_data_mux[] = {
	SCIF2_RXD_MARK, SCIF2_TXD_MARK,
};
static const unsigned int scif2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 18),
};
static const unsigned int scif2_clk_mux[] = {
	SCIF2_SCK_MARK,
};
static const unsigned int scif2_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(5, 18), RCAR_GP_PIN(5, 19),
};
static const unsigned int scif2_data_b_mux[] = {
	SCIF2_RXD_B_MARK, SCIF2_TXD_B_MARK,
};
static const unsigned int scif2_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 17),
};
static const unsigned int scif2_clk_b_mux[] = {
	SCIF2_SCK_B_MARK,
};
static const unsigned int scif2_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 20), RCAR_GP_PIN(3, 21),
};
static const unsigned int scif2_data_c_mux[] = {
	SCIF2_RXD_C_MARK, SCIF2_TXD_C_MARK,
};
static const unsigned int scif2_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 19),
};
static const unsigned int scif2_clk_c_mux[] = {
	SCIF2_SCK_C_MARK,
};
/* - SCIF3 ------------------------------------------------------------------ */
static const unsigned int scif3_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 20), RCAR_GP_PIN(4, 21),
};
static const unsigned int scif3_data_mux[] = {
	SCIF3_RXD_MARK, SCIF3_TXD_MARK,
};
static const unsigned int scif3_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 19),
};
static const unsigned int scif3_clk_mux[] = {
	SCIF3_SCK_MARK,
};
static const unsigned int scif3_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 23), RCAR_GP_PIN(3, 24),
};
static const unsigned int scif3_data_b_mux[] = {
	SCIF3_RXD_B_MARK, SCIF3_TXD_B_MARK,
};
static const unsigned int scif3_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 22),
};
static const unsigned int scif3_clk_b_mux[] = {
	SCIF3_SCK_B_MARK,
};
/* - SCIF4 ------------------------------------------------------------------ */
static const unsigned int scif4_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 0), RCAR_GP_PIN(4, 1),
};
static const unsigned int scif4_data_mux[] = {
	SCIF4_RXD_MARK, SCIF4_TXD_MARK,
};
static const unsigned int scif4_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(0, 5), RCAR_GP_PIN(0, 6),
};
static const unsigned int scif4_data_b_mux[] = {
	SCIF4_RXD_B_MARK, SCIF4_TXD_B_MARK,
};
static const unsigned int scif4_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(1, 14), RCAR_GP_PIN(1, 15),
};
static const unsigned int scif4_data_c_mux[] = {
	SCIF4_RXD_C_MARK, SCIF4_TXD_C_MARK,
};
static const unsigned int scif4_data_d_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 17), RCAR_GP_PIN(3, 18),
};
static const unsigned int scif4_data_d_mux[] = {
	SCIF4_RXD_D_MARK, SCIF4_TXD_D_MARK,
};
static const unsigned int scif4_data_e_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(1, 1), RCAR_GP_PIN(1, 2),
};
static const unsigned int scif4_data_e_mux[] = {
	SCIF4_RXD_E_MARK, SCIF4_TXD_E_MARK,
};
/* - SCIF5 ------------------------------------------------------------------ */
static const unsigned int scif5_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 2), RCAR_GP_PIN(4, 3),
};
static const unsigned int scif5_data_mux[] = {
	SCIF5_RXD_MARK, SCIF5_TXD_MARK,
};
static const unsigned int scif5_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(0, 3), RCAR_GP_PIN(0, 4),
};
static const unsigned int scif5_data_b_mux[] = {
	SCIF5_RXD_B_MARK, SCIF5_TXD_B_MARK,
};
static const unsigned int scif5_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(2, 0), RCAR_GP_PIN(2, 11),
};
static const unsigned int scif5_data_c_mux[] = {
	SCIF5_RXD_C_MARK, SCIF5_TXD_C_MARK,
};
static const unsigned int scif5_data_d_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(5, 1), RCAR_GP_PIN(5, 2),
};
static const unsigned int scif5_data_d_mux[] = {
	SCIF5_RXD_D_MARK, SCIF5_TXD_D_MARK,
};
/* - SCIFA0 ----------------------------------------------------------------- */
static const unsigned int scifa0_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 6), RCAR_GP_PIN(4, 7),
};
static const unsigned int scifa0_data_mux[] = {
	SCIFA0_RXD_MARK, SCIFA0_TXD_MARK,
};
static const unsigned int scifa0_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 24), RCAR_GP_PIN(0, 25),
};
static const unsigned int scifa0_data_b_mux[] = {
	SCIFA0_RXD_B_MARK, SCIFA0_TXD_B_MARK
};
static const unsigned int scifa0_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(2, 8), RCAR_GP_PIN(2, 9),
};
static const unsigned int scifa0_data_c_mux[] = {
	SCIFA0_RXD_C_MARK, SCIFA0_TXD_C_MARK
};
static const unsigned int scifa0_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(5, 15), RCAR_GP_PIN(5, 16),
};
static const unsigned int scifa0_data_d_mux[] = {
	SCIFA0_RXD_D_MARK, SCIFA0_TXD_D_MARK
};
/* - SCIFA1 ----------------------------------------------------------------- */
static const unsigned int scifa1_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 14), RCAR_GP_PIN(0, 15),
};
static const unsigned int scifa1_data_mux[] = {
	SCIFA1_RXD_MARK, SCIFA1_TXD_MARK,
};
static const unsigned int scifa1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 13),
};
static const unsigned int scifa1_clk_mux[] = {
	SCIFA1_SCK_MARK,
};
static const unsigned int scifa1_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 28), RCAR_GP_PIN(4, 29),
};
static const unsigned int scifa1_data_b_mux[] = {
	SCIFA1_RXD_B_MARK, SCIFA1_TXD_B_MARK,
};
static const unsigned int scifa1_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 27),
};
static const unsigned int scifa1_clk_b_mux[] = {
	SCIFA1_SCK_B_MARK,
};
static const unsigned int scifa1_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(5, 5), RCAR_GP_PIN(5, 6),
};
static const unsigned int scifa1_data_c_mux[] = {
	SCIFA1_RXD_C_MARK, SCIFA1_TXD_C_MARK,
};
static const unsigned int scifa1_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 4),
};
static const unsigned int scifa1_clk_c_mux[] = {
	SCIFA1_SCK_C_MARK,
};
/* - SCIFA2 ----------------------------------------------------------------- */
static const unsigned int scifa2_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 16), RCAR_GP_PIN(1, 17),
};
static const unsigned int scifa2_data_mux[] = {
	SCIFA2_RXD_MARK, SCIFA2_TXD_MARK,
};
static const unsigned int scifa2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 15),
};
static const unsigned int scifa2_clk_mux[] = {
	SCIFA2_SCK_MARK,
};
static const unsigned int scifa2_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 31), RCAR_GP_PIN(5, 0),
};
static const unsigned int scifa2_data_b_mux[] = {
	SCIFA2_RXD_B_MARK, SCIFA2_TXD_B_MARK,
};
static const unsigned int scifa2_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 30),
};
static const unsigned int scifa2_clk_b_mux[] = {
	SCIFA2_SCK_B_MARK,
};
/* - SCIFA3 ----------------------------------------------------------------- */
static const unsigned int scifa3_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 25), RCAR_GP_PIN(4, 26),
};
static const unsigned int scifa3_data_mux[] = {
	SCIFA3_RXD_MARK, SCIFA3_TXD_MARK,
};
static const unsigned int scifa3_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 24),
};
static const unsigned int scifa3_clk_mux[] = {
	SCIFA3_SCK_MARK,
};
static const unsigned int scifa3_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 1), RCAR_GP_PIN(0, 2),
};
static const unsigned int scifa3_data_b_mux[] = {
	SCIFA3_RXD_B_MARK, SCIFA3_TXD_B_MARK,
};
static const unsigned int scifa3_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 0),
};
static const unsigned int scifa3_clk_b_mux[] = {
	SCIFA3_SCK_B_MARK,
};
/* - SCIFA4 ----------------------------------------------------------------- */
static const unsigned int scifa4_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 12), RCAR_GP_PIN(4, 12),
};
static const unsigned int scifa4_data_mux[] = {
	SCIFA4_RXD_MARK, SCIFA4_TXD_MARK,
};
static const unsigned int scifa4_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 22), RCAR_GP_PIN(0, 23),
};
static const unsigned int scifa4_data_b_mux[] = {
	SCIFA4_RXD_B_MARK, SCIFA4_TXD_B_MARK,
};
static const unsigned int scifa4_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(2, 16), RCAR_GP_PIN(2, 17),
};
static const unsigned int scifa4_data_c_mux[] = {
	SCIFA4_RXD_C_MARK, SCIFA4_TXD_C_MARK,
};
static const unsigned int scifa4_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(5, 20), RCAR_GP_PIN(5, 21),
};
static const unsigned int scifa4_data_d_mux[] = {
	SCIFA4_RXD_D_MARK, SCIFA4_TXD_D_MARK,
};
/* - SCIFA5 ----------------------------------------------------------------- */
static const unsigned int scifa5_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 22), RCAR_GP_PIN(4, 23),
};
static const unsigned int scifa5_data_mux[] = {
	SCIFA5_RXD_MARK, SCIFA5_TXD_MARK,
};
static const unsigned int scifa5_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 28), RCAR_GP_PIN(0, 29),
};
static const unsigned int scifa5_data_b_mux[] = {
	SCIFA5_RXD_B_MARK, SCIFA5_TXD_B_MARK,
};
static const unsigned int scifa5_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 9), RCAR_GP_PIN(3, 10),
};
static const unsigned int scifa5_data_c_mux[] = {
	SCIFA5_RXD_C_MARK, SCIFA5_TXD_C_MARK,
};
static const unsigned int scifa5_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(5, 22), RCAR_GP_PIN(5, 23),
};
static const unsigned int scifa5_data_d_mux[] = {
	SCIFA5_RXD_D_MARK, SCIFA5_TXD_D_MARK,
};
/* - SCIFB0 ----------------------------------------------------------------- */
static const unsigned int scifb0_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(0, 21), RCAR_GP_PIN(0, 20),
};
static const unsigned int scifb0_data_mux[] = {
	SCIFB0_RXD_MARK, SCIFB0_TXD_MARK,
};
static const unsigned int scifb0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 19),
};
static const unsigned int scifb0_clk_mux[] = {
	SCIFB0_SCK_MARK,
};
static const unsigned int scifb0_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(0, 23), RCAR_GP_PIN(0, 22),
};
static const unsigned int scifb0_ctrl_mux[] = {
	SCIFB0_RTS_N_MARK, SCIFB0_CTS_N_MARK,
};
/* - SCIFB1 ----------------------------------------------------------------- */
static const unsigned int scifb1_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 24), RCAR_GP_PIN(0, 17),
};
static const unsigned int scifb1_data_mux[] = {
	SCIFB1_RXD_MARK, SCIFB1_TXD_MARK,
};
static const unsigned int scifb1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 16),
};
static const unsigned int scifb1_clk_mux[] = {
	SCIFB1_SCK_MARK,
};
/* - SCIFB2 ----------------------------------------------------------------- */
static const unsigned int scifb2_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 13), RCAR_GP_PIN(1, 14),
};
static const unsigned int scifb2_data_mux[] = {
	SCIFB2_RXD_MARK, SCIFB2_TXD_MARK,
};
static const unsigned int scifb2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 15),
};
static const unsigned int scifb2_clk_mux[] = {
	SCIFB2_SCK_MARK,
};
static const unsigned int scifb2_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(1, 17), RCAR_GP_PIN(1, 16),
};
static const unsigned int scifb2_ctrl_mux[] = {
	SCIFB2_RTS_N_MARK, SCIFB2_CTS_N_MARK,
};
/* - SCIF Clock ------------------------------------------------------------- */
static const unsigned int scif_clk_pins[] = {
	/* SCIF_CLK */
	RCAR_GP_PIN(1, 23),
};
static const unsigned int scif_clk_mux[] = {
	SCIF_CLK_MARK,
};
static const unsigned int scif_clk_b_pins[] = {
	/* SCIF_CLK */
	RCAR_GP_PIN(3, 29),
};
static const unsigned int scif_clk_b_mux[] = {
	SCIF_CLK_B_MARK,
};
/* - SDHI0 ------------------------------------------------------------------ */
static const unsigned int sdhi0_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(6, 2),
};
static const unsigned int sdhi0_data1_mux[] = {
	SD0_DATA0_MARK,
};
static const unsigned int sdhi0_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(6, 2), RCAR_GP_PIN(6, 3),
	RCAR_GP_PIN(6, 4), RCAR_GP_PIN(6, 5),
};
static const unsigned int sdhi0_data4_mux[] = {
	SD0_DATA0_MARK, SD0_DATA1_MARK, SD0_DATA2_MARK, SD0_DATA3_MARK,
};
static const unsigned int sdhi0_ctrl_pins[] = {
	/* CLK, CMD */
	RCAR_GP_PIN(6, 0), RCAR_GP_PIN(6, 1),
};
static const unsigned int sdhi0_ctrl_mux[] = {
	SD0_CLK_MARK, SD0_CMD_MARK,
};
static const unsigned int sdhi0_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(6, 6),
};
static const unsigned int sdhi0_cd_mux[] = {
	SD0_CD_MARK,
};
static const unsigned int sdhi0_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(6, 7),
};
static const unsigned int sdhi0_wp_mux[] = {
	SD0_WP_MARK,
};
/* - SDHI1 ------------------------------------------------------------------ */
static const unsigned int sdhi1_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(6, 10),
};
static const unsigned int sdhi1_data1_mux[] = {
	SD1_DATA0_MARK,
};
static const unsigned int sdhi1_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(6, 10), RCAR_GP_PIN(6, 11),
	RCAR_GP_PIN(6, 12), RCAR_GP_PIN(6, 13),
};
static const unsigned int sdhi1_data4_mux[] = {
	SD1_DATA0_MARK, SD1_DATA1_MARK, SD1_DATA2_MARK, SD1_DATA3_MARK,
};
static const unsigned int sdhi1_ctrl_pins[] = {
	/* CLK, CMD */
	RCAR_GP_PIN(6, 8), RCAR_GP_PIN(6, 9),
};
static const unsigned int sdhi1_ctrl_mux[] = {
	SD1_CLK_MARK, SD1_CMD_MARK,
};
static const unsigned int sdhi1_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(6, 14),
};
static const unsigned int sdhi1_cd_mux[] = {
	SD1_CD_MARK,
};
static const unsigned int sdhi1_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(6, 15),
};
static const unsigned int sdhi1_wp_mux[] = {
	SD1_WP_MARK,
};
/* - SDHI2 ------------------------------------------------------------------ */
static const unsigned int sdhi2_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(6, 18),
};
static const unsigned int sdhi2_data1_mux[] = {
	SD2_DATA0_MARK,
};
static const unsigned int sdhi2_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(6, 18), RCAR_GP_PIN(6, 19),
	RCAR_GP_PIN(6, 20), RCAR_GP_PIN(6, 21),
};
static const unsigned int sdhi2_data4_mux[] = {
	SD2_DATA0_MARK, SD2_DATA1_MARK, SD2_DATA2_MARK, SD2_DATA3_MARK,
};
static const unsigned int sdhi2_ctrl_pins[] = {
	/* CLK, CMD */
	RCAR_GP_PIN(6, 16), RCAR_GP_PIN(6, 17),
};
static const unsigned int sdhi2_ctrl_mux[] = {
	SD2_CLK_MARK, SD2_CMD_MARK,
};
static const unsigned int sdhi2_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(6, 22),
};
static const unsigned int sdhi2_cd_mux[] = {
	SD2_CD_MARK,
};
static const unsigned int sdhi2_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(6, 23),
};
static const unsigned int sdhi2_wp_mux[] = {
	SD2_WP_MARK,
};
/* - SSI -------------------------------------------------------------------- */
static const unsigned int ssi0_data_pins[] = {
	/* SDATA0 */
	RCAR_GP_PIN(5, 3),
};
static const unsigned int ssi0_data_mux[] = {
	SSI_SDATA0_MARK,
};
static const unsigned int ssi0129_ctrl_pins[] = {
	/* SCK0129, WS0129 */
	RCAR_GP_PIN(5, 1), RCAR_GP_PIN(5, 2),
};
static const unsigned int ssi0129_ctrl_mux[] = {
	SSI_SCK0129_MARK, SSI_WS0129_MARK,
};
static const unsigned int ssi1_data_pins[] = {
	/* SDATA1 */
	RCAR_GP_PIN(5, 13),
};
static const unsigned int ssi1_data_mux[] = {
	SSI_SDATA1_MARK,
};
static const unsigned int ssi1_ctrl_pins[] = {
	/* SCK1, WS1 */
	RCAR_GP_PIN(5, 11), RCAR_GP_PIN(5, 12),
};
static const unsigned int ssi1_ctrl_mux[] = {
	SSI_SCK1_MARK, SSI_WS1_MARK,
};
static const unsigned int ssi1_data_b_pins[] = {
	/* SDATA1 */
	RCAR_GP_PIN(4, 13),
};
static const unsigned int ssi1_data_b_mux[] = {
	SSI_SDATA1_B_MARK,
};
static const unsigned int ssi1_ctrl_b_pins[] = {
	/* SCK1, WS1 */
	RCAR_GP_PIN(4, 11), RCAR_GP_PIN(4, 12),
};
static const unsigned int ssi1_ctrl_b_mux[] = {
	SSI_SCK1_B_MARK, SSI_WS1_B_MARK,
};
static const unsigned int ssi2_data_pins[] = {
	/* SDATA2 */
	RCAR_GP_PIN(5, 16),
};
static const unsigned int ssi2_data_mux[] = {
	SSI_SDATA2_MARK,
};
static const unsigned int ssi2_ctrl_pins[] = {
	/* SCK2, WS2 */
	RCAR_GP_PIN(5, 14), RCAR_GP_PIN(5, 15),
};
static const unsigned int ssi2_ctrl_mux[] = {
	SSI_SCK2_MARK, SSI_WS2_MARK,
};
static const unsigned int ssi2_data_b_pins[] = {
	/* SDATA2 */
	RCAR_GP_PIN(4, 16),
};
static const unsigned int ssi2_data_b_mux[] = {
	SSI_SDATA2_B_MARK,
};
static const unsigned int ssi2_ctrl_b_pins[] = {
	/* SCK2, WS2 */
	RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 15),
};
static const unsigned int ssi2_ctrl_b_mux[] = {
	SSI_SCK2_B_MARK, SSI_WS2_B_MARK,
};
static const unsigned int ssi3_data_pins[] = {
	/* SDATA3 */
	RCAR_GP_PIN(5, 6),
};
static const unsigned int ssi3_data_mux[] = {
	SSI_SDATA3_MARK
};
static const unsigned int ssi34_ctrl_pins[] = {
	/* SCK34, WS34 */
	RCAR_GP_PIN(5, 4), RCAR_GP_PIN(5, 5),
};
static const unsigned int ssi34_ctrl_mux[] = {
	SSI_SCK34_MARK, SSI_WS34_MARK,
};
static const unsigned int ssi4_data_pins[] = {
	/* SDATA4 */
	RCAR_GP_PIN(5, 9),
};
static const unsigned int ssi4_data_mux[] = {
	SSI_SDATA4_MARK,
};
static const unsigned int ssi4_ctrl_pins[] = {
	/* SCK4, WS4 */
	RCAR_GP_PIN(5, 7), RCAR_GP_PIN(5, 8),
};
static const unsigned int ssi4_ctrl_mux[] = {
	SSI_SCK4_MARK, SSI_WS4_MARK,
};
static const unsigned int ssi4_data_b_pins[] = {
	/* SDATA4 */
	RCAR_GP_PIN(4, 22),
};
static const unsigned int ssi4_data_b_mux[] = {
	SSI_SDATA4_B_MARK,
};
static const unsigned int ssi4_ctrl_b_pins[] = {
	/* SCK4, WS4 */
	RCAR_GP_PIN(4, 20), RCAR_GP_PIN(4, 21),
};
static const unsigned int ssi4_ctrl_b_mux[] = {
	SSI_SCK4_B_MARK, SSI_WS4_B_MARK,
};
static const unsigned int ssi5_data_pins[] = {
	/* SDATA5 */
	RCAR_GP_PIN(4, 26),
};
static const unsigned int ssi5_data_mux[] = {
	SSI_SDATA5_MARK,
};
static const unsigned int ssi5_ctrl_pins[] = {
	/* SCK5, WS5 */
	RCAR_GP_PIN(4, 24), RCAR_GP_PIN(4, 25),
};
static const unsigned int ssi5_ctrl_mux[] = {
	SSI_SCK5_MARK, SSI_WS5_MARK,
};
static const unsigned int ssi5_data_b_pins[] = {
	/* SDATA5 */
	RCAR_GP_PIN(3, 21),
};
static const unsigned int ssi5_data_b_mux[] = {
	SSI_SDATA5_B_MARK,
};
static const unsigned int ssi5_ctrl_b_pins[] = {
	/* SCK5, WS5 */
	RCAR_GP_PIN(3, 19), RCAR_GP_PIN(3, 20),
};
static const unsigned int ssi5_ctrl_b_mux[] = {
	SSI_SCK5_B_MARK, SSI_WS5_B_MARK,
};
static const unsigned int ssi6_data_pins[] = {
	/* SDATA6 */
	RCAR_GP_PIN(4, 29),
};
static const unsigned int ssi6_data_mux[] = {
	SSI_SDATA6_MARK,
};
static const unsigned int ssi6_ctrl_pins[] = {
	/* SCK6, WS6 */
	RCAR_GP_PIN(4, 27), RCAR_GP_PIN(4, 28),
};
static const unsigned int ssi6_ctrl_mux[] = {
	SSI_SCK6_MARK, SSI_WS6_MARK,
};
static const unsigned int ssi6_data_b_pins[] = {
	/* SDATA6 */
	RCAR_GP_PIN(3, 24),
};
static const unsigned int ssi6_data_b_mux[] = {
	SSI_SDATA6_B_MARK,
};
static const unsigned int ssi6_ctrl_b_pins[] = {
	/* SCK6, WS6 */
	RCAR_GP_PIN(3, 22), RCAR_GP_PIN(3, 23),
};
static const unsigned int ssi6_ctrl_b_mux[] = {
	SSI_SCK6_B_MARK, SSI_WS6_B_MARK,
};
static const unsigned int ssi7_data_pins[] = {
	/* SDATA7 */
	RCAR_GP_PIN(5, 0),
};
static const unsigned int ssi7_data_mux[] = {
	SSI_SDATA7_MARK,
};
static const unsigned int ssi78_ctrl_pins[] = {
	/* SCK78, WS78 */
	RCAR_GP_PIN(4, 30), RCAR_GP_PIN(4, 31),
};
static const unsigned int ssi78_ctrl_mux[] = {
	SSI_SCK78_MARK, SSI_WS78_MARK,
};
static const unsigned int ssi7_data_b_pins[] = {
	/* SDATA7 */
	RCAR_GP_PIN(3, 27),
};
static const unsigned int ssi7_data_b_mux[] = {
	SSI_SDATA7_B_MARK,
};
static const unsigned int ssi78_ctrl_b_pins[] = {
	/* SCK78, WS78 */
	RCAR_GP_PIN(3, 25), RCAR_GP_PIN(3, 26),
};
static const unsigned int ssi78_ctrl_b_mux[] = {
	SSI_SCK78_B_MARK, SSI_WS78_B_MARK,
};
static const unsigned int ssi8_data_pins[] = {
	/* SDATA8 */
	RCAR_GP_PIN(5, 10),
};
static const unsigned int ssi8_data_mux[] = {
	SSI_SDATA8_MARK,
};
static const unsigned int ssi8_data_b_pins[] = {
	/* SDATA8 */
	RCAR_GP_PIN(3, 28),
};
static const unsigned int ssi8_data_b_mux[] = {
	SSI_SDATA8_B_MARK,
};
static const unsigned int ssi9_data_pins[] = {
	/* SDATA9 */
	RCAR_GP_PIN(5, 19),
};
static const unsigned int ssi9_data_mux[] = {
	SSI_SDATA9_MARK,
};
static const unsigned int ssi9_ctrl_pins[] = {
	/* SCK9, WS9 */
	RCAR_GP_PIN(5, 17), RCAR_GP_PIN(5, 18),
};
static const unsigned int ssi9_ctrl_mux[] = {
	SSI_SCK9_MARK, SSI_WS9_MARK,
};
static const unsigned int ssi9_data_b_pins[] = {
	/* SDATA9 */
	RCAR_GP_PIN(4, 19),
};
static const unsigned int ssi9_data_b_mux[] = {
	SSI_SDATA9_B_MARK,
};
static const unsigned int ssi9_ctrl_b_pins[] = {
	/* SCK9, WS9 */
	RCAR_GP_PIN(4, 17), RCAR_GP_PIN(4, 18),
};
static const unsigned int ssi9_ctrl_b_mux[] = {
	SSI_SCK9_B_MARK, SSI_WS9_B_MARK,
};
/* - TPU -------------------------------------------------------------------- */
static const unsigned int tpu_to0_pins[] = {
	RCAR_GP_PIN(3, 31),
};
static const unsigned int tpu_to0_mux[] = {
	TPUTO0_MARK,
};
static const unsigned int tpu_to0_b_pins[] = {
	RCAR_GP_PIN(3, 30),
};
static const unsigned int tpu_to0_b_mux[] = {
	TPUTO0_B_MARK,
};
static const unsigned int tpu_to0_c_pins[] = {
	RCAR_GP_PIN(1, 18),
};
static const unsigned int tpu_to0_c_mux[] = {
	TPUTO0_C_MARK,
};
static const unsigned int tpu_to1_pins[] = {
	RCAR_GP_PIN(4, 9),
};
static const unsigned int tpu_to1_mux[] = {
	TPUTO1_MARK,
};
static const unsigned int tpu_to1_b_pins[] = {
	RCAR_GP_PIN(4, 0),
};
static const unsigned int tpu_to1_b_mux[] = {
	TPUTO1_B_MARK,
};
static const unsigned int tpu_to1_c_pins[] = {
	RCAR_GP_PIN(4, 4),
};
static const unsigned int tpu_to1_c_mux[] = {
	TPUTO1_C_MARK,
};
static const unsigned int tpu_to2_pins[] = {
	RCAR_GP_PIN(1, 3),
};
static const unsigned int tpu_to2_mux[] = {
	TPUTO2_MARK,
};
static const unsigned int tpu_to2_b_pins[] = {
	RCAR_GP_PIN(1, 0),
};
static const unsigned int tpu_to2_b_mux[] = {
	TPUTO2_B_MARK,
};
static const unsigned int tpu_to2_c_pins[] = {
	RCAR_GP_PIN(0, 22),
};
static const unsigned int tpu_to2_c_mux[] = {
	TPUTO2_C_MARK,
};
static const unsigned int tpu_to3_pins[] = {
	RCAR_GP_PIN(1, 14),
};
static const unsigned int tpu_to3_mux[] = {
	TPUTO3_MARK,
};
static const unsigned int tpu_to3_b_pins[] = {
	RCAR_GP_PIN(1, 13),
};
static const unsigned int tpu_to3_b_mux[] = {
	TPUTO3_B_MARK,
};
static const unsigned int tpu_to3_c_pins[] = {
	RCAR_GP_PIN(0, 21),
};
static const unsigned int tpu_to3_c_mux[] = {
	TPUTO3_C_MARK,
};
/* - USB0 ------------------------------------------------------------------- */
static const unsigned int usb0_pins[] = {
	RCAR_GP_PIN(5, 24), /* PWEN */
	RCAR_GP_PIN(5, 25), /* OVC */
};
static const unsigned int usb0_mux[] = {
	USB0_PWEN_MARK,
	USB0_OVC_MARK,
};
/* - USB1 ------------------------------------------------------------------- */
static const unsigned int usb1_pins[] = {
	RCAR_GP_PIN(5, 26), /* PWEN */
	RCAR_GP_PIN(5, 27), /* OVC */
};
static const unsigned int usb1_mux[] = {
	USB1_PWEN_MARK,
	USB1_OVC_MARK,
};
/* - VIN0 ------------------------------------------------------------------- */
static const union vin_data vin0_data_pins = {
	.data24 = {
		/* B */
		RCAR_GP_PIN(3, 1), RCAR_GP_PIN(3, 2),
		RCAR_GP_PIN(3, 3), RCAR_GP_PIN(3, 4),
		RCAR_GP_PIN(3, 5), RCAR_GP_PIN(3, 6),
		RCAR_GP_PIN(3, 7), RCAR_GP_PIN(3, 8),
		/* G */
		RCAR_GP_PIN(3, 13), RCAR_GP_PIN(3, 14),
		RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 16),
		RCAR_GP_PIN(3, 17), RCAR_GP_PIN(3, 18),
		RCAR_GP_PIN(3, 19), RCAR_GP_PIN(3, 20),
		/* R */
		RCAR_GP_PIN(3, 21), RCAR_GP_PIN(3, 22),
		RCAR_GP_PIN(3, 23), RCAR_GP_PIN(3, 24),
		RCAR_GP_PIN(3, 25), RCAR_GP_PIN(3, 26),
		RCAR_GP_PIN(3, 27), RCAR_GP_PIN(3, 28),
	},
};
static const union vin_data vin0_data_mux = {
	.data24 = {
		/* B */
		VI0_DATA0_VI0_B0_MARK, VI0_DATA1_VI0_B1_MARK,
		VI0_DATA2_VI0_B2_MARK, VI0_DATA3_VI0_B3_MARK,
		VI0_DATA4_VI0_B4_MARK, VI0_DATA5_VI0_B5_MARK,
		VI0_DATA6_VI0_B6_MARK, VI0_DATA7_VI0_B7_MARK,
		/* G */
		VI0_G0_MARK, VI0_G1_MARK,
		VI0_G2_MARK, VI0_G3_MARK,
		VI0_G4_MARK, VI0_G5_MARK,
		VI0_G6_MARK, VI0_G7_MARK,
		/* R */
		VI0_R0_MARK, VI0_R1_MARK,
		VI0_R2_MARK, VI0_R3_MARK,
		VI0_R4_MARK, VI0_R5_MARK,
		VI0_R6_MARK, VI0_R7_MARK,
	},
};
static const unsigned int vin0_data18_pins[] = {
	/* B */
	RCAR_GP_PIN(3, 3), RCAR_GP_PIN(3, 4),
	RCAR_GP_PIN(3, 5), RCAR_GP_PIN(3, 6),
	RCAR_GP_PIN(3, 7), RCAR_GP_PIN(3, 8),
	/* G */
	RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 16),
	RCAR_GP_PIN(3, 17), RCAR_GP_PIN(3, 18),
	RCAR_GP_PIN(3, 19), RCAR_GP_PIN(3, 20),
	/* R */
	RCAR_GP_PIN(3, 23), RCAR_GP_PIN(3, 24),
	RCAR_GP_PIN(3, 25), RCAR_GP_PIN(3, 26),
	RCAR_GP_PIN(3, 27), RCAR_GP_PIN(3, 28),
};
static const unsigned int vin0_data18_mux[] = {
	/* B */
	VI0_DATA2_VI0_B2_MARK, VI0_DATA3_VI0_B3_MARK,
	VI0_DATA4_VI0_B4_MARK, VI0_DATA5_VI0_B5_MARK,
	VI0_DATA6_VI0_B6_MARK, VI0_DATA7_VI0_B7_MARK,
	/* G */
	VI0_G2_MARK, VI0_G3_MARK,
	VI0_G4_MARK, VI0_G5_MARK,
	VI0_G6_MARK, VI0_G7_MARK,
	/* R */
	VI0_R2_MARK, VI0_R3_MARK,
	VI0_R4_MARK, VI0_R5_MARK,
	VI0_R6_MARK, VI0_R7_MARK,
};
static const unsigned int vin0_sync_pins[] = {
	RCAR_GP_PIN(3, 11), /* HSYNC */
	RCAR_GP_PIN(3, 12), /* VSYNC */
};
static const unsigned int vin0_sync_mux[] = {
	VI0_HSYNC_N_MARK,
	VI0_VSYNC_N_MARK,
};
static const unsigned int vin0_field_pins[] = {
	RCAR_GP_PIN(3, 10),
};
static const unsigned int vin0_field_mux[] = {
	VI0_FIELD_MARK,
};
static const unsigned int vin0_clkenb_pins[] = {
	RCAR_GP_PIN(3, 9),
};
static const unsigned int vin0_clkenb_mux[] = {
	VI0_CLKENB_MARK,
};
static const unsigned int vin0_clk_pins[] = {
	RCAR_GP_PIN(3, 0),
};
static const unsigned int vin0_clk_mux[] = {
	VI0_CLK_MARK,
};
/* - VIN1 ------------------------------------------------------------------- */
static const union vin_data vin1_data_pins = {
	.data12 = {
		RCAR_GP_PIN(5, 12), RCAR_GP_PIN(5, 13),
		RCAR_GP_PIN(5, 14), RCAR_GP_PIN(5, 15),
		RCAR_GP_PIN(5, 16), RCAR_GP_PIN(5, 17),
		RCAR_GP_PIN(5, 18), RCAR_GP_PIN(5, 19),
		RCAR_GP_PIN(1, 10), RCAR_GP_PIN(1, 11),
		RCAR_GP_PIN(1, 12), RCAR_GP_PIN(1, 13),
	},
};
static const union vin_data vin1_data_mux = {
	.data12 = {
		VI1_DATA0_MARK, VI1_DATA1_MARK,
		VI1_DATA2_MARK, VI1_DATA3_MARK,
		VI1_DATA4_MARK, VI1_DATA5_MARK,
		VI1_DATA6_MARK, VI1_DATA7_MARK,
		VI1_DATA8_MARK, VI1_DATA9_MARK,
		VI1_DATA10_MARK, VI1_DATA11_MARK,
	},
};
static const unsigned int vin1_sync_pins[] = {
	RCAR_GP_PIN(5, 22), /* HSYNC */
	RCAR_GP_PIN(5, 23), /* VSYNC */
};
static const unsigned int vin1_sync_mux[] = {
	VI1_HSYNC_N_MARK,
	VI1_VSYNC_N_MARK,
};
static const unsigned int vin1_field_pins[] = {
	RCAR_GP_PIN(5, 21),
};
static const unsigned int vin1_field_mux[] = {
	VI1_FIELD_MARK,
};
static const unsigned int vin1_clkenb_pins[] = {
	RCAR_GP_PIN(5, 20),
};
static const unsigned int vin1_clkenb_mux[] = {
	VI1_CLKENB_MARK,
};
static const unsigned int vin1_clk_pins[] = {
	RCAR_GP_PIN(5, 11),
};
static const unsigned int vin1_clk_mux[] = {
	VI1_CLK_MARK,
};

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(audio_clka),
	SH_PFC_PIN_GROUP(audio_clka_b),
	SH_PFC_PIN_GROUP(audio_clka_c),
	SH_PFC_PIN_GROUP(audio_clka_d),
	SH_PFC_PIN_GROUP(audio_clkb),
	SH_PFC_PIN_GROUP(audio_clkb_b),
	SH_PFC_PIN_GROUP(audio_clkb_c),
	SH_PFC_PIN_GROUP(audio_clkc),
	SH_PFC_PIN_GROUP(audio_clkc_b),
	SH_PFC_PIN_GROUP(audio_clkc_c),
	SH_PFC_PIN_GROUP(audio_clkout),
	SH_PFC_PIN_GROUP(audio_clkout_b),
	SH_PFC_PIN_GROUP(audio_clkout_c),
	SH_PFC_PIN_GROUP(avb_link),
	SH_PFC_PIN_GROUP(avb_magic),
	SH_PFC_PIN_GROUP(avb_phy_int),
	SH_PFC_PIN_GROUP(avb_mdio),
	SH_PFC_PIN_GROUP(avb_mii),
	SH_PFC_PIN_GROUP(avb_gmii),
	SH_PFC_PIN_GROUP(can0_data),
	SH_PFC_PIN_GROUP(can0_data_b),
	SH_PFC_PIN_GROUP(can0_data_c),
	SH_PFC_PIN_GROUP(can0_data_d),
	SH_PFC_PIN_GROUP(can1_data),
	SH_PFC_PIN_GROUP(can1_data_b),
	SH_PFC_PIN_GROUP(can1_data_c),
	SH_PFC_PIN_GROUP(can1_data_d),
	SH_PFC_PIN_GROUP(can_clk),
	SH_PFC_PIN_GROUP(can_clk_b),
	SH_PFC_PIN_GROUP(can_clk_c),
	SH_PFC_PIN_GROUP(can_clk_d),
	SH_PFC_PIN_GROUP(du0_rgb666),
	SH_PFC_PIN_GROUP(du0_rgb888),
	SH_PFC_PIN_GROUP(du0_clk0_out),
	SH_PFC_PIN_GROUP(du0_clk1_out),
	SH_PFC_PIN_GROUP(du0_clk_in),
	SH_PFC_PIN_GROUP(du0_sync),
	SH_PFC_PIN_GROUP(du0_oddf),
	SH_PFC_PIN_GROUP(du0_cde),
	SH_PFC_PIN_GROUP(du0_disp),
	SH_PFC_PIN_GROUP(du1_rgb666),
	SH_PFC_PIN_GROUP(du1_rgb888),
	SH_PFC_PIN_GROUP(du1_clk0_out),
	SH_PFC_PIN_GROUP(du1_clk1_out),
	SH_PFC_PIN_GROUP(du1_clk_in),
	SH_PFC_PIN_GROUP(du1_sync),
	SH_PFC_PIN_GROUP(du1_oddf),
	SH_PFC_PIN_GROUP(du1_cde),
	SH_PFC_PIN_GROUP(du1_disp),
	SH_PFC_PIN_GROUP(eth_link),
	SH_PFC_PIN_GROUP(eth_magic),
	SH_PFC_PIN_GROUP(eth_mdio),
	SH_PFC_PIN_GROUP(eth_rmii),
	SH_PFC_PIN_GROUP(eth_link_b),
	SH_PFC_PIN_GROUP(eth_magic_b),
	SH_PFC_PIN_GROUP(eth_mdio_b),
	SH_PFC_PIN_GROUP(eth_rmii_b),
	SH_PFC_PIN_GROUP(hscif0_data),
	SH_PFC_PIN_GROUP(hscif0_clk),
	SH_PFC_PIN_GROUP(hscif0_ctrl),
	SH_PFC_PIN_GROUP(hscif0_data_b),
	SH_PFC_PIN_GROUP(hscif0_clk_b),
	SH_PFC_PIN_GROUP(hscif1_data),
	SH_PFC_PIN_GROUP(hscif1_clk),
	SH_PFC_PIN_GROUP(hscif1_ctrl),
	SH_PFC_PIN_GROUP(hscif1_data_b),
	SH_PFC_PIN_GROUP(hscif1_ctrl_b),
	SH_PFC_PIN_GROUP(hscif2_data),
	SH_PFC_PIN_GROUP(hscif2_clk),
	SH_PFC_PIN_GROUP(hscif2_ctrl),
	SH_PFC_PIN_GROUP(i2c0),
	SH_PFC_PIN_GROUP(i2c0_b),
	SH_PFC_PIN_GROUP(i2c0_c),
	SH_PFC_PIN_GROUP(i2c0_d),
	SH_PFC_PIN_GROUP(i2c0_e),
	SH_PFC_PIN_GROUP(i2c1),
	SH_PFC_PIN_GROUP(i2c1_b),
	SH_PFC_PIN_GROUP(i2c1_c),
	SH_PFC_PIN_GROUP(i2c1_d),
	SH_PFC_PIN_GROUP(i2c1_e),
	SH_PFC_PIN_GROUP(i2c2),
	SH_PFC_PIN_GROUP(i2c2_b),
	SH_PFC_PIN_GROUP(i2c2_c),
	SH_PFC_PIN_GROUP(i2c2_d),
	SH_PFC_PIN_GROUP(i2c2_e),
	SH_PFC_PIN_GROUP(i2c3),
	SH_PFC_PIN_GROUP(i2c3_b),
	SH_PFC_PIN_GROUP(i2c3_c),
	SH_PFC_PIN_GROUP(i2c3_d),
	SH_PFC_PIN_GROUP(i2c3_e),
	SH_PFC_PIN_GROUP(i2c4),
	SH_PFC_PIN_GROUP(i2c4_b),
	SH_PFC_PIN_GROUP(i2c4_c),
	SH_PFC_PIN_GROUP(i2c4_d),
	SH_PFC_PIN_GROUP(i2c4_e),
	SH_PFC_PIN_GROUP(i2c5),
	SH_PFC_PIN_GROUP(i2c5_b),
	SH_PFC_PIN_GROUP(i2c5_c),
	SH_PFC_PIN_GROUP(i2c5_d),
	SH_PFC_PIN_GROUP(intc_irq0),
	SH_PFC_PIN_GROUP(intc_irq1),
	SH_PFC_PIN_GROUP(intc_irq2),
	SH_PFC_PIN_GROUP(intc_irq3),
	SH_PFC_PIN_GROUP(intc_irq4),
	SH_PFC_PIN_GROUP(intc_irq5),
	SH_PFC_PIN_GROUP(intc_irq6),
	SH_PFC_PIN_GROUP(intc_irq7),
	SH_PFC_PIN_GROUP(intc_irq8),
	SH_PFC_PIN_GROUP(intc_irq9),
	SH_PFC_PIN_GROUP(mmc_data1),
	SH_PFC_PIN_GROUP(mmc_data4),
	SH_PFC_PIN_GROUP(mmc_data8),
	SH_PFC_PIN_GROUP(mmc_ctrl),
	SH_PFC_PIN_GROUP(msiof0_clk),
	SH_PFC_PIN_GROUP(msiof0_sync),
	SH_PFC_PIN_GROUP(msiof0_ss1),
	SH_PFC_PIN_GROUP(msiof0_ss2),
	SH_PFC_PIN_GROUP(msiof0_rx),
	SH_PFC_PIN_GROUP(msiof0_tx),
	SH_PFC_PIN_GROUP(msiof1_clk),
	SH_PFC_PIN_GROUP(msiof1_sync),
	SH_PFC_PIN_GROUP(msiof1_ss1),
	SH_PFC_PIN_GROUP(msiof1_ss2),
	SH_PFC_PIN_GROUP(msiof1_rx),
	SH_PFC_PIN_GROUP(msiof1_tx),
	SH_PFC_PIN_GROUP(msiof1_clk_b),
	SH_PFC_PIN_GROUP(msiof1_sync_b),
	SH_PFC_PIN_GROUP(msiof1_ss1_b),
	SH_PFC_PIN_GROUP(msiof1_ss2_b),
	SH_PFC_PIN_GROUP(msiof1_rx_b),
	SH_PFC_PIN_GROUP(msiof1_tx_b),
	SH_PFC_PIN_GROUP(msiof2_clk),
	SH_PFC_PIN_GROUP(msiof2_sync),
	SH_PFC_PIN_GROUP(msiof2_ss1),
	SH_PFC_PIN_GROUP(msiof2_ss2),
	SH_PFC_PIN_GROUP(msiof2_rx),
	SH_PFC_PIN_GROUP(msiof2_tx),
	SH_PFC_PIN_GROUP(msiof2_clk_b),
	SH_PFC_PIN_GROUP(msiof2_sync_b),
	SH_PFC_PIN_GROUP(msiof2_ss1_b),
	SH_PFC_PIN_GROUP(msiof2_ss2_b),
	SH_PFC_PIN_GROUP(msiof2_rx_b),
	SH_PFC_PIN_GROUP(msiof2_tx_b),
	SH_PFC_PIN_GROUP(pwm0),
	SH_PFC_PIN_GROUP(pwm0_b),
	SH_PFC_PIN_GROUP(pwm1),
	SH_PFC_PIN_GROUP(pwm1_b),
	SH_PFC_PIN_GROUP(pwm1_c),
	SH_PFC_PIN_GROUP(pwm2),
	SH_PFC_PIN_GROUP(pwm2_b),
	SH_PFC_PIN_GROUP(pwm2_c),
	SH_PFC_PIN_GROUP(pwm3),
	SH_PFC_PIN_GROUP(pwm3_b),
	SH_PFC_PIN_GROUP(pwm4),
	SH_PFC_PIN_GROUP(pwm4_b),
	SH_PFC_PIN_GROUP(pwm5),
	SH_PFC_PIN_GROUP(pwm5_b),
	SH_PFC_PIN_GROUP(pwm5_c),
	SH_PFC_PIN_GROUP(pwm6),
	SH_PFC_PIN_GROUP(pwm6_b),
	SH_PFC_PIN_GROUP(qspi_ctrl),
	SH_PFC_PIN_GROUP(qspi_data2),
	SH_PFC_PIN_GROUP(qspi_data4),
	SH_PFC_PIN_GROUP(scif0_data),
	SH_PFC_PIN_GROUP(scif0_data_b),
	SH_PFC_PIN_GROUP(scif0_data_c),
	SH_PFC_PIN_GROUP(scif0_data_d),
	SH_PFC_PIN_GROUP(scif1_data),
	SH_PFC_PIN_GROUP(scif1_clk),
	SH_PFC_PIN_GROUP(scif1_data_b),
	SH_PFC_PIN_GROUP(scif1_clk_b),
	SH_PFC_PIN_GROUP(scif1_data_c),
	SH_PFC_PIN_GROUP(scif1_clk_c),
	SH_PFC_PIN_GROUP(scif2_data),
	SH_PFC_PIN_GROUP(scif2_clk),
	SH_PFC_PIN_GROUP(scif2_data_b),
	SH_PFC_PIN_GROUP(scif2_clk_b),
	SH_PFC_PIN_GROUP(scif2_data_c),
	SH_PFC_PIN_GROUP(scif2_clk_c),
	SH_PFC_PIN_GROUP(scif3_data),
	SH_PFC_PIN_GROUP(scif3_clk),
	SH_PFC_PIN_GROUP(scif3_data_b),
	SH_PFC_PIN_GROUP(scif3_clk_b),
	SH_PFC_PIN_GROUP(scif4_data),
	SH_PFC_PIN_GROUP(scif4_data_b),
	SH_PFC_PIN_GROUP(scif4_data_c),
	SH_PFC_PIN_GROUP(scif4_data_d),
	SH_PFC_PIN_GROUP(scif4_data_e),
	SH_PFC_PIN_GROUP(scif5_data),
	SH_PFC_PIN_GROUP(scif5_data_b),
	SH_PFC_PIN_GROUP(scif5_data_c),
	SH_PFC_PIN_GROUP(scif5_data_d),
	SH_PFC_PIN_GROUP(scifa0_data),
	SH_PFC_PIN_GROUP(scifa0_data_b),
	SH_PFC_PIN_GROUP(scifa0_data_c),
	SH_PFC_PIN_GROUP(scifa0_data_d),
	SH_PFC_PIN_GROUP(scifa1_data),
	SH_PFC_PIN_GROUP(scifa1_clk),
	SH_PFC_PIN_GROUP(scifa1_data_b),
	SH_PFC_PIN_GROUP(scifa1_clk_b),
	SH_PFC_PIN_GROUP(scifa1_data_c),
	SH_PFC_PIN_GROUP(scifa1_clk_c),
	SH_PFC_PIN_GROUP(scifa2_data),
	SH_PFC_PIN_GROUP(scifa2_clk),
	SH_PFC_PIN_GROUP(scifa2_data_b),
	SH_PFC_PIN_GROUP(scifa2_clk_b),
	SH_PFC_PIN_GROUP(scifa3_data),
	SH_PFC_PIN_GROUP(scifa3_clk),
	SH_PFC_PIN_GROUP(scifa3_data_b),
	SH_PFC_PIN_GROUP(scifa3_clk_b),
	SH_PFC_PIN_GROUP(scifa4_data),
	SH_PFC_PIN_GROUP(scifa4_data_b),
	SH_PFC_PIN_GROUP(scifa4_data_c),
	SH_PFC_PIN_GROUP(scifa4_data_d),
	SH_PFC_PIN_GROUP(scifa5_data),
	SH_PFC_PIN_GROUP(scifa5_data_b),
	SH_PFC_PIN_GROUP(scifa5_data_c),
	SH_PFC_PIN_GROUP(scifa5_data_d),
	SH_PFC_PIN_GROUP(scifb0_data),
	SH_PFC_PIN_GROUP(scifb0_clk),
	SH_PFC_PIN_GROUP(scifb0_ctrl),
	SH_PFC_PIN_GROUP(scifb1_data),
	SH_PFC_PIN_GROUP(scifb1_clk),
	SH_PFC_PIN_GROUP(scifb2_data),
	SH_PFC_PIN_GROUP(scifb2_clk),
	SH_PFC_PIN_GROUP(scifb2_ctrl),
	SH_PFC_PIN_GROUP(scif_clk),
	SH_PFC_PIN_GROUP(scif_clk_b),
	SH_PFC_PIN_GROUP(sdhi0_data1),
	SH_PFC_PIN_GROUP(sdhi0_data4),
	SH_PFC_PIN_GROUP(sdhi0_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_cd),
	SH_PFC_PIN_GROUP(sdhi0_wp),
	SH_PFC_PIN_GROUP(sdhi1_data1),
	SH_PFC_PIN_GROUP(sdhi1_data4),
	SH_PFC_PIN_GROUP(sdhi1_ctrl),
	SH_PFC_PIN_GROUP(sdhi1_cd),
	SH_PFC_PIN_GROUP(sdhi1_wp),
	SH_PFC_PIN_GROUP(sdhi2_data1),
	SH_PFC_PIN_GROUP(sdhi2_data4),
	SH_PFC_PIN_GROUP(sdhi2_ctrl),
	SH_PFC_PIN_GROUP(sdhi2_cd),
	SH_PFC_PIN_GROUP(sdhi2_wp),
	SH_PFC_PIN_GROUP(ssi0_data),
	SH_PFC_PIN_GROUP(ssi0129_ctrl),
	SH_PFC_PIN_GROUP(ssi1_data),
	SH_PFC_PIN_GROUP(ssi1_ctrl),
	SH_PFC_PIN_GROUP(ssi1_data_b),
	SH_PFC_PIN_GROUP(ssi1_ctrl_b),
	SH_PFC_PIN_GROUP(ssi2_data),
	SH_PFC_PIN_GROUP(ssi2_ctrl),
	SH_PFC_PIN_GROUP(ssi2_data_b),
	SH_PFC_PIN_GROUP(ssi2_ctrl_b),
	SH_PFC_PIN_GROUP(ssi3_data),
	SH_PFC_PIN_GROUP(ssi34_ctrl),
	SH_PFC_PIN_GROUP(ssi4_data),
	SH_PFC_PIN_GROUP(ssi4_ctrl),
	SH_PFC_PIN_GROUP(ssi4_data_b),
	SH_PFC_PIN_GROUP(ssi4_ctrl_b),
	SH_PFC_PIN_GROUP(ssi5_data),
	SH_PFC_PIN_GROUP(ssi5_ctrl),
	SH_PFC_PIN_GROUP(ssi5_data_b),
	SH_PFC_PIN_GROUP(ssi5_ctrl_b),
	SH_PFC_PIN_GROUP(ssi6_data),
	SH_PFC_PIN_GROUP(ssi6_ctrl),
	SH_PFC_PIN_GROUP(ssi6_data_b),
	SH_PFC_PIN_GROUP(ssi6_ctrl_b),
	SH_PFC_PIN_GROUP(ssi7_data),
	SH_PFC_PIN_GROUP(ssi78_ctrl),
	SH_PFC_PIN_GROUP(ssi7_data_b),
	SH_PFC_PIN_GROUP(ssi78_ctrl_b),
	SH_PFC_PIN_GROUP(ssi8_data),
	SH_PFC_PIN_GROUP(ssi8_data_b),
	SH_PFC_PIN_GROUP(ssi9_data),
	SH_PFC_PIN_GROUP(ssi9_ctrl),
	SH_PFC_PIN_GROUP(ssi9_data_b),
	SH_PFC_PIN_GROUP(ssi9_ctrl_b),
	SH_PFC_PIN_GROUP(tpu_to0),
	SH_PFC_PIN_GROUP(tpu_to0_b),
	SH_PFC_PIN_GROUP(tpu_to0_c),
	SH_PFC_PIN_GROUP(tpu_to1),
	SH_PFC_PIN_GROUP(tpu_to1_b),
	SH_PFC_PIN_GROUP(tpu_to1_c),
	SH_PFC_PIN_GROUP(tpu_to2),
	SH_PFC_PIN_GROUP(tpu_to2_b),
	SH_PFC_PIN_GROUP(tpu_to2_c),
	SH_PFC_PIN_GROUP(tpu_to3),
	SH_PFC_PIN_GROUP(tpu_to3_b),
	SH_PFC_PIN_GROUP(tpu_to3_c),
	SH_PFC_PIN_GROUP(usb0),
	SH_PFC_PIN_GROUP(usb1),
	VIN_DATA_PIN_GROUP(vin0_data, 24),
	VIN_DATA_PIN_GROUP(vin0_data, 20),
	SH_PFC_PIN_GROUP(vin0_data18),
	VIN_DATA_PIN_GROUP(vin0_data, 16),
	VIN_DATA_PIN_GROUP(vin0_data, 12),
	VIN_DATA_PIN_GROUP(vin0_data, 10),
	VIN_DATA_PIN_GROUP(vin0_data, 8),
	SH_PFC_PIN_GROUP(vin0_sync),
	SH_PFC_PIN_GROUP(vin0_field),
	SH_PFC_PIN_GROUP(vin0_clkenb),
	SH_PFC_PIN_GROUP(vin0_clk),
	VIN_DATA_PIN_GROUP(vin1_data, 12),
	VIN_DATA_PIN_GROUP(vin1_data, 10),
	VIN_DATA_PIN_GROUP(vin1_data, 8),
	SH_PFC_PIN_GROUP(vin1_sync),
	SH_PFC_PIN_GROUP(vin1_field),
	SH_PFC_PIN_GROUP(vin1_clkenb),
	SH_PFC_PIN_GROUP(vin1_clk),
};

static const char * const audio_clk_groups[] = {
	"audio_clka",
	"audio_clka_b",
	"audio_clka_c",
	"audio_clka_d",
	"audio_clkb",
	"audio_clkb_b",
	"audio_clkb_c",
	"audio_clkc",
	"audio_clkc_b",
	"audio_clkc_c",
	"audio_clkout",
	"audio_clkout_b",
	"audio_clkout_c",
};

static const char * const avb_groups[] = {
	"avb_link",
	"avb_magic",
	"avb_phy_int",
	"avb_mdio",
	"avb_mii",
	"avb_gmii",
};

static const char * const can0_groups[] = {
	"can0_data",
	"can0_data_b",
	"can0_data_c",
	"can0_data_d",
	/*
	 * Retained for backwards compatibility, use can_clk_groups in new
	 * designs.
	 */
	"can_clk",
	"can_clk_b",
	"can_clk_c",
	"can_clk_d",
};

static const char * const can1_groups[] = {
	"can1_data",
	"can1_data_b",
	"can1_data_c",
	"can1_data_d",
	/*
	 * Retained for backwards compatibility, use can_clk_groups in new
	 * designs.
	 */
	"can_clk",
	"can_clk_b",
	"can_clk_c",
	"can_clk_d",
};

/*
 * can_clk_groups allows for independent configuration, use can_clk function
 * in new designs.
 */
static const char * const can_clk_groups[] = {
	"can_clk",
	"can_clk_b",
	"can_clk_c",
	"can_clk_d",
};

static const char * const du0_groups[] = {
	"du0_rgb666",
	"du0_rgb888",
	"du0_clk0_out",
	"du0_clk1_out",
	"du0_clk_in",
	"du0_sync",
	"du0_oddf",
	"du0_cde",
	"du0_disp",
};

static const char * const du1_groups[] = {
	"du1_rgb666",
	"du1_rgb888",
	"du1_clk0_out",
	"du1_clk1_out",
	"du1_clk_in",
	"du1_sync",
	"du1_oddf",
	"du1_cde",
	"du1_disp",
};

static const char * const eth_groups[] = {
	"eth_link",
	"eth_magic",
	"eth_mdio",
	"eth_rmii",
	"eth_link_b",
	"eth_magic_b",
	"eth_mdio_b",
	"eth_rmii_b",
};

static const char * const hscif0_groups[] = {
	"hscif0_data",
	"hscif0_clk",
	"hscif0_ctrl",
	"hscif0_data_b",
	"hscif0_clk_b",
};

static const char * const hscif1_groups[] = {
	"hscif1_data",
	"hscif1_clk",
	"hscif1_ctrl",
	"hscif1_data_b",
	"hscif1_ctrl_b",
};

static const char * const hscif2_groups[] = {
	"hscif2_data",
	"hscif2_clk",
	"hscif2_ctrl",
};

static const char * const i2c0_groups[] = {
	"i2c0",
	"i2c0_b",
	"i2c0_c",
	"i2c0_d",
	"i2c0_e",
};

static const char * const i2c1_groups[] = {
	"i2c1",
	"i2c1_b",
	"i2c1_c",
	"i2c1_d",
	"i2c1_e",
};

static const char * const i2c2_groups[] = {
	"i2c2",
	"i2c2_b",
	"i2c2_c",
	"i2c2_d",
	"i2c2_e",
};

static const char * const i2c3_groups[] = {
	"i2c3",
	"i2c3_b",
	"i2c3_c",
	"i2c3_d",
	"i2c3_e",
};

static const char * const i2c4_groups[] = {
	"i2c4",
	"i2c4_b",
	"i2c4_c",
	"i2c4_d",
	"i2c4_e",
};

static const char * const i2c5_groups[] = {
	"i2c5",
	"i2c5_b",
	"i2c5_c",
	"i2c5_d",
};

static const char * const intc_groups[] = {
	"intc_irq0",
	"intc_irq1",
	"intc_irq2",
	"intc_irq3",
	"intc_irq4",
	"intc_irq5",
	"intc_irq6",
	"intc_irq7",
	"intc_irq8",
	"intc_irq9",
};

static const char * const mmc_groups[] = {
	"mmc_data1",
	"mmc_data4",
	"mmc_data8",
	"mmc_ctrl",
};

static const char * const msiof0_groups[] = {
	"msiof0_clk",
	"msiof0_sync",
	"msiof0_ss1",
	"msiof0_ss2",
	"msiof0_rx",
	"msiof0_tx",
};

static const char * const msiof1_groups[] = {
	"msiof1_clk",
	"msiof1_sync",
	"msiof1_ss1",
	"msiof1_ss2",
	"msiof1_rx",
	"msiof1_tx",
	"msiof1_clk_b",
	"msiof1_sync_b",
	"msiof1_ss1_b",
	"msiof1_ss2_b",
	"msiof1_rx_b",
	"msiof1_tx_b",
};

static const char * const msiof2_groups[] = {
	"msiof2_clk",
	"msiof2_sync",
	"msiof2_ss1",
	"msiof2_ss2",
	"msiof2_rx",
	"msiof2_tx",
	"msiof2_clk_b",
	"msiof2_sync_b",
	"msiof2_ss1_b",
	"msiof2_ss2_b",
	"msiof2_rx_b",
	"msiof2_tx_b",
};

static const char * const pwm0_groups[] = {
	"pwm0",
	"pwm0_b",
};

static const char * const pwm1_groups[] = {
	"pwm1",
	"pwm1_b",
	"pwm1_c",
};

static const char * const pwm2_groups[] = {
	"pwm2",
	"pwm2_b",
	"pwm2_c",
};

static const char * const pwm3_groups[] = {
	"pwm3",
	"pwm3_b",
};

static const char * const pwm4_groups[] = {
	"pwm4",
	"pwm4_b",
};

static const char * const pwm5_groups[] = {
	"pwm5",
	"pwm5_b",
	"pwm5_c",
};

static const char * const pwm6_groups[] = {
	"pwm6",
	"pwm6_b",
};

static const char * const qspi_groups[] = {
	"qspi_ctrl",
	"qspi_data2",
	"qspi_data4",
};

static const char * const scif0_groups[] = {
	"scif0_data",
	"scif0_data_b",
	"scif0_data_c",
	"scif0_data_d",
};

static const char * const scif1_groups[] = {
	"scif1_data",
	"scif1_clk",
	"scif1_data_b",
	"scif1_clk_b",
	"scif1_data_c",
	"scif1_clk_c",
};

static const char * const scif2_groups[] = {
	"scif2_data",
	"scif2_clk",
	"scif2_data_b",
	"scif2_clk_b",
	"scif2_data_c",
	"scif2_clk_c",
};

static const char * const scif3_groups[] = {
	"scif3_data",
	"scif3_clk",
	"scif3_data_b",
	"scif3_clk_b",
};

static const char * const scif4_groups[] = {
	"scif4_data",
	"scif4_data_b",
	"scif4_data_c",
	"scif4_data_d",
	"scif4_data_e",
};

static const char * const scif5_groups[] = {
	"scif5_data",
	"scif5_data_b",
	"scif5_data_c",
	"scif5_data_d",
};

static const char * const scifa0_groups[] = {
	"scifa0_data",
	"scifa0_data_b",
	"scifa0_data_c",
	"scifa0_data_d",
};

static const char * const scifa1_groups[] = {
	"scifa1_data",
	"scifa1_clk",
	"scifa1_data_b",
	"scifa1_clk_b",
	"scifa1_data_c",
	"scifa1_clk_c",
};

static const char * const scifa2_groups[] = {
	"scifa2_data",
	"scifa2_clk",
	"scifa2_data_b",
	"scifa2_clk_b",
};

static const char * const scifa3_groups[] = {
	"scifa3_data",
	"scifa3_clk",
	"scifa3_data_b",
	"scifa3_clk_b",
};

static const char * const scifa4_groups[] = {
	"scifa4_data",
	"scifa4_data_b",
	"scifa4_data_c",
	"scifa4_data_d",
};

static const char * const scifa5_groups[] = {
	"scifa5_data",
	"scifa5_data_b",
	"scifa5_data_c",
	"scifa5_data_d",
};

static const char * const scifb0_groups[] = {
	"scifb0_data",
	"scifb0_clk",
	"scifb0_ctrl",
};

static const char * const scifb1_groups[] = {
	"scifb1_data",
	"scifb1_clk",
};

static const char * const scifb2_groups[] = {
	"scifb2_data",
	"scifb2_clk",
	"scifb2_ctrl",
};

static const char * const scif_clk_groups[] = {
	"scif_clk",
	"scif_clk_b",
};

static const char * const sdhi0_groups[] = {
	"sdhi0_data1",
	"sdhi0_data4",
	"sdhi0_ctrl",
	"sdhi0_cd",
	"sdhi0_wp",
};

static const char * const sdhi1_groups[] = {
	"sdhi1_data1",
	"sdhi1_data4",
	"sdhi1_ctrl",
	"sdhi1_cd",
	"sdhi1_wp",
};

static const char * const sdhi2_groups[] = {
	"sdhi2_data1",
	"sdhi2_data4",
	"sdhi2_ctrl",
	"sdhi2_cd",
	"sdhi2_wp",
};

static const char * const ssi_groups[] = {
	"ssi0_data",
	"ssi0129_ctrl",
	"ssi1_data",
	"ssi1_ctrl",
	"ssi1_data_b",
	"ssi1_ctrl_b",
	"ssi2_data",
	"ssi2_ctrl",
	"ssi2_data_b",
	"ssi2_ctrl_b",
	"ssi3_data",
	"ssi34_ctrl",
	"ssi4_data",
	"ssi4_ctrl",
	"ssi4_data_b",
	"ssi4_ctrl_b",
	"ssi5_data",
	"ssi5_ctrl",
	"ssi5_data_b",
	"ssi5_ctrl_b",
	"ssi6_data",
	"ssi6_ctrl",
	"ssi6_data_b",
	"ssi6_ctrl_b",
	"ssi7_data",
	"ssi78_ctrl",
	"ssi7_data_b",
	"ssi78_ctrl_b",
	"ssi8_data",
	"ssi8_data_b",
	"ssi9_data",
	"ssi9_ctrl",
	"ssi9_data_b",
	"ssi9_ctrl_b",
};

static const char * const tpu_groups[] = {
	"tpu_to0",
	"tpu_to0_b",
	"tpu_to0_c",
	"tpu_to1",
	"tpu_to1_b",
	"tpu_to1_c",
	"tpu_to2",
	"tpu_to2_b",
	"tpu_to2_c",
	"tpu_to3",
	"tpu_to3_b",
	"tpu_to3_c",
};

static const char * const usb0_groups[] = {
	"usb0",
};

static const char * const usb1_groups[] = {
	"usb1",
};

static const char * const vin0_groups[] = {
	"vin0_data24",
	"vin0_data20",
	"vin0_data18",
	"vin0_data16",
	"vin0_data12",
	"vin0_data10",
	"vin0_data8",
	"vin0_sync",
	"vin0_field",
	"vin0_clkenb",
	"vin0_clk",
};

static const char * const vin1_groups[] = {
	"vin1_data12",
	"vin1_data10",
	"vin1_data8",
	"vin1_sync",
	"vin1_field",
	"vin1_clkenb",
	"vin1_clk",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(audio_clk),
	SH_PFC_FUNCTION(avb),
	SH_PFC_FUNCTION(can0),
	SH_PFC_FUNCTION(can1),
	SH_PFC_FUNCTION(can_clk),
	SH_PFC_FUNCTION(du0),
	SH_PFC_FUNCTION(du1),
	SH_PFC_FUNCTION(eth),
	SH_PFC_FUNCTION(hscif0),
	SH_PFC_FUNCTION(hscif1),
	SH_PFC_FUNCTION(hscif2),
	SH_PFC_FUNCTION(i2c0),
	SH_PFC_FUNCTION(i2c1),
	SH_PFC_FUNCTION(i2c2),
	SH_PFC_FUNCTION(i2c3),
	SH_PFC_FUNCTION(i2c4),
	SH_PFC_FUNCTION(i2c5),
	SH_PFC_FUNCTION(intc),
	SH_PFC_FUNCTION(mmc),
	SH_PFC_FUNCTION(msiof0),
	SH_PFC_FUNCTION(msiof1),
	SH_PFC_FUNCTION(msiof2),
	SH_PFC_FUNCTION(pwm0),
	SH_PFC_FUNCTION(pwm1),
	SH_PFC_FUNCTION(pwm2),
	SH_PFC_FUNCTION(pwm3),
	SH_PFC_FUNCTION(pwm4),
	SH_PFC_FUNCTION(pwm5),
	SH_PFC_FUNCTION(pwm6),
	SH_PFC_FUNCTION(qspi),
	SH_PFC_FUNCTION(scif0),
	SH_PFC_FUNCTION(scif1),
	SH_PFC_FUNCTION(scif2),
	SH_PFC_FUNCTION(scif3),
	SH_PFC_FUNCTION(scif4),
	SH_PFC_FUNCTION(scif5),
	SH_PFC_FUNCTION(scifa0),
	SH_PFC_FUNCTION(scifa1),
	SH_PFC_FUNCTION(scifa2),
	SH_PFC_FUNCTION(scifa3),
	SH_PFC_FUNCTION(scifa4),
	SH_PFC_FUNCTION(scifa5),
	SH_PFC_FUNCTION(scifb0),
	SH_PFC_FUNCTION(scifb1),
	SH_PFC_FUNCTION(scifb2),
	SH_PFC_FUNCTION(scif_clk),
	SH_PFC_FUNCTION(sdhi0),
	SH_PFC_FUNCTION(sdhi1),
	SH_PFC_FUNCTION(sdhi2),
	SH_PFC_FUNCTION(ssi),
	SH_PFC_FUNCTION(tpu),
	SH_PFC_FUNCTION(usb0),
	SH_PFC_FUNCTION(usb1),
	SH_PFC_FUNCTION(vin0),
	SH_PFC_FUNCTION(vin1),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("GPSR0", 0xE6060004, 32, 1) {
		GP_0_31_FN, FN_IP2_17_16,
		GP_0_30_FN, FN_IP2_15_14,
		GP_0_29_FN, FN_IP2_13_12,
		GP_0_28_FN, FN_IP2_11_10,
		GP_0_27_FN, FN_IP2_9_8,
		GP_0_26_FN, FN_IP2_7_6,
		GP_0_25_FN, FN_IP2_5_4,
		GP_0_24_FN, FN_IP2_3_2,
		GP_0_23_FN, FN_IP2_1_0,
		GP_0_22_FN, FN_IP1_31_30,
		GP_0_21_FN, FN_IP1_29_28,
		GP_0_20_FN, FN_IP1_27,
		GP_0_19_FN, FN_IP1_26,
		GP_0_18_FN, FN_A2,
		GP_0_17_FN, FN_IP1_24,
		GP_0_16_FN, FN_IP1_23_22,
		GP_0_15_FN, FN_IP1_21_20,
		GP_0_14_FN, FN_IP1_19_18,
		GP_0_13_FN, FN_IP1_17_15,
		GP_0_12_FN, FN_IP1_14_13,
		GP_0_11_FN, FN_IP1_12_11,
		GP_0_10_FN, FN_IP1_10_8,
		GP_0_9_FN, FN_IP1_7_6,
		GP_0_8_FN, FN_IP1_5_4,
		GP_0_7_FN, FN_IP1_3_2,
		GP_0_6_FN, FN_IP1_1_0,
		GP_0_5_FN, FN_IP0_31_30,
		GP_0_4_FN, FN_IP0_29_28,
		GP_0_3_FN, FN_IP0_27_26,
		GP_0_2_FN, FN_IP0_25,
		GP_0_1_FN, FN_IP0_24,
		GP_0_0_FN, FN_IP0_23_22, }
	},
	{ PINMUX_CFG_REG("GPSR1", 0xE6060008, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_1_25_FN, FN_DACK0,
		GP_1_24_FN, FN_IP7_31,
		GP_1_23_FN, FN_IP4_1_0,
		GP_1_22_FN, FN_WE1_N,
		GP_1_21_FN, FN_WE0_N,
		GP_1_20_FN, FN_IP3_31,
		GP_1_19_FN, FN_IP3_30,
		GP_1_18_FN, FN_IP3_29_27,
		GP_1_17_FN, FN_IP3_26_24,
		GP_1_16_FN, FN_IP3_23_21,
		GP_1_15_FN, FN_IP3_20_18,
		GP_1_14_FN, FN_IP3_17_15,
		GP_1_13_FN, FN_IP3_14_13,
		GP_1_12_FN, FN_IP3_12,
		GP_1_11_FN, FN_IP3_11,
		GP_1_10_FN, FN_IP3_10,
		GP_1_9_FN, FN_IP3_9_8,
		GP_1_8_FN, FN_IP3_7_6,
		GP_1_7_FN, FN_IP3_5_4,
		GP_1_6_FN, FN_IP3_3_2,
		GP_1_5_FN, FN_IP3_1_0,
		GP_1_4_FN, FN_IP2_31_30,
		GP_1_3_FN, FN_IP2_29_27,
		GP_1_2_FN, FN_IP2_26_24,
		GP_1_1_FN, FN_IP2_23_21,
		GP_1_0_FN, FN_IP2_20_18, }
	},
	{ PINMUX_CFG_REG("GPSR2", 0xE606000C, 32, 1) {
		GP_2_31_FN, FN_IP6_7_6,
		GP_2_30_FN, FN_IP6_5_4,
		GP_2_29_FN, FN_IP6_3_2,
		GP_2_28_FN, FN_IP6_1_0,
		GP_2_27_FN, FN_IP5_31_30,
		GP_2_26_FN, FN_IP5_29_28,
		GP_2_25_FN, FN_IP5_27_26,
		GP_2_24_FN, FN_IP5_25_24,
		GP_2_23_FN, FN_IP5_23_22,
		GP_2_22_FN, FN_IP5_21_20,
		GP_2_21_FN, FN_IP5_19_18,
		GP_2_20_FN, FN_IP5_17_16,
		GP_2_19_FN, FN_IP5_15_14,
		GP_2_18_FN, FN_IP5_13_12,
		GP_2_17_FN, FN_IP5_11_9,
		GP_2_16_FN, FN_IP5_8_6,
		GP_2_15_FN, FN_IP5_5_4,
		GP_2_14_FN, FN_IP5_3_2,
		GP_2_13_FN, FN_IP5_1_0,
		GP_2_12_FN, FN_IP4_31_30,
		GP_2_11_FN, FN_IP4_29_28,
		GP_2_10_FN, FN_IP4_27_26,
		GP_2_9_FN, FN_IP4_25_23,
		GP_2_8_FN, FN_IP4_22_20,
		GP_2_7_FN, FN_IP4_19_18,
		GP_2_6_FN, FN_IP4_17_16,
		GP_2_5_FN, FN_IP4_15_14,
		GP_2_4_FN, FN_IP4_13_12,
		GP_2_3_FN, FN_IP4_11_10,
		GP_2_2_FN, FN_IP4_9_8,
		GP_2_1_FN, FN_IP4_7_5,
		GP_2_0_FN, FN_IP4_4_2 }
	},
	{ PINMUX_CFG_REG("GPSR3", 0xE6060010, 32, 1) {
		GP_3_31_FN, FN_IP8_22_20,
		GP_3_30_FN, FN_IP8_19_17,
		GP_3_29_FN, FN_IP8_16_15,
		GP_3_28_FN, FN_IP8_14_12,
		GP_3_27_FN, FN_IP8_11_9,
		GP_3_26_FN, FN_IP8_8_6,
		GP_3_25_FN, FN_IP8_5_3,
		GP_3_24_FN, FN_IP8_2_0,
		GP_3_23_FN, FN_IP7_29_27,
		GP_3_22_FN, FN_IP7_26_24,
		GP_3_21_FN, FN_IP7_23_21,
		GP_3_20_FN, FN_IP7_20_18,
		GP_3_19_FN, FN_IP7_17_15,
		GP_3_18_FN, FN_IP7_14_12,
		GP_3_17_FN, FN_IP7_11_9,
		GP_3_16_FN, FN_IP7_8_6,
		GP_3_15_FN, FN_IP7_5_3,
		GP_3_14_FN, FN_IP7_2_0,
		GP_3_13_FN, FN_IP6_31_29,
		GP_3_12_FN, FN_IP6_28_26,
		GP_3_11_FN, FN_IP6_25_23,
		GP_3_10_FN, FN_IP6_22_20,
		GP_3_9_FN, FN_IP6_19_17,
		GP_3_8_FN, FN_IP6_16,
		GP_3_7_FN, FN_IP6_15,
		GP_3_6_FN, FN_IP6_14,
		GP_3_5_FN, FN_IP6_13,
		GP_3_4_FN, FN_IP6_12,
		GP_3_3_FN, FN_IP6_11,
		GP_3_2_FN, FN_IP6_10,
		GP_3_1_FN, FN_IP6_9,
		GP_3_0_FN, FN_IP6_8 }
	},
	{ PINMUX_CFG_REG("GPSR4", 0xE6060014, 32, 1) {
		GP_4_31_FN, FN_IP11_17_16,
		GP_4_30_FN, FN_IP11_15_14,
		GP_4_29_FN, FN_IP11_13_11,
		GP_4_28_FN, FN_IP11_10_8,
		GP_4_27_FN, FN_IP11_7_6,
		GP_4_26_FN, FN_IP11_5_3,
		GP_4_25_FN, FN_IP11_2_0,
		GP_4_24_FN, FN_IP10_31_30,
		GP_4_23_FN, FN_IP10_29_27,
		GP_4_22_FN, FN_IP10_26_24,
		GP_4_21_FN, FN_IP10_23_21,
		GP_4_20_FN, FN_IP10_20_18,
		GP_4_19_FN, FN_IP10_17_15,
		GP_4_18_FN, FN_IP10_14_12,
		GP_4_17_FN, FN_IP10_11_9,
		GP_4_16_FN, FN_IP10_8_6,
		GP_4_15_FN, FN_IP10_5_3,
		GP_4_14_FN, FN_IP10_2_0,
		GP_4_13_FN, FN_IP9_30_28,
		GP_4_12_FN, FN_IP9_27_25,
		GP_4_11_FN, FN_IP9_24_22,
		GP_4_10_FN, FN_IP9_21_19,
		GP_4_9_FN, FN_IP9_18_17,
		GP_4_8_FN, FN_IP9_16_15,
		GP_4_7_FN, FN_IP9_14_12,
		GP_4_6_FN, FN_IP9_11_9,
		GP_4_5_FN, FN_IP9_8_6,
		GP_4_4_FN, FN_IP9_5_3,
		GP_4_3_FN, FN_IP9_2_0,
		GP_4_2_FN, FN_IP8_31_29,
		GP_4_1_FN, FN_IP8_28_26,
		GP_4_0_FN, FN_IP8_25_23 }
	},
	{ PINMUX_CFG_REG("GPSR5", 0xE6060018, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_5_27_FN, FN_USB1_OVC,
		GP_5_26_FN, FN_USB1_PWEN,
		GP_5_25_FN, FN_USB0_OVC,
		GP_5_24_FN, FN_USB0_PWEN,
		GP_5_23_FN, FN_IP13_26_24,
		GP_5_22_FN, FN_IP13_23_21,
		GP_5_21_FN, FN_IP13_20_18,
		GP_5_20_FN, FN_IP13_17_15,
		GP_5_19_FN, FN_IP13_14_12,
		GP_5_18_FN, FN_IP13_11_9,
		GP_5_17_FN, FN_IP13_8_6,
		GP_5_16_FN, FN_IP13_5_3,
		GP_5_15_FN, FN_IP13_2_0,
		GP_5_14_FN, FN_IP12_29_27,
		GP_5_13_FN, FN_IP12_26_24,
		GP_5_12_FN, FN_IP12_23_21,
		GP_5_11_FN, FN_IP12_20_18,
		GP_5_10_FN, FN_IP12_17_15,
		GP_5_9_FN, FN_IP12_14_13,
		GP_5_8_FN, FN_IP12_12_11,
		GP_5_7_FN, FN_IP12_10_9,
		GP_5_6_FN, FN_IP12_8_6,
		GP_5_5_FN, FN_IP12_5_3,
		GP_5_4_FN, FN_IP12_2_0,
		GP_5_3_FN, FN_IP11_29_27,
		GP_5_2_FN, FN_IP11_26_24,
		GP_5_1_FN, FN_IP11_23_21,
		GP_5_0_FN, FN_IP11_20_18 }
	},
	{ PINMUX_CFG_REG("GPSR6", 0xE606001C, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_6_25_FN, FN_IP0_21_20,
		GP_6_24_FN, FN_IP0_19_18,
		GP_6_23_FN, FN_IP0_17,
		GP_6_22_FN, FN_IP0_16,
		GP_6_21_FN, FN_IP0_15,
		GP_6_20_FN, FN_IP0_14,
		GP_6_19_FN, FN_IP0_13,
		GP_6_18_FN, FN_IP0_12,
		GP_6_17_FN, FN_IP0_11,
		GP_6_16_FN, FN_IP0_10,
		GP_6_15_FN, FN_IP0_9_8,
		GP_6_14_FN, FN_IP0_0,
		GP_6_13_FN, FN_SD1_DATA3,
		GP_6_12_FN, FN_SD1_DATA2,
		GP_6_11_FN, FN_SD1_DATA1,
		GP_6_10_FN, FN_SD1_DATA0,
		GP_6_9_FN, FN_SD1_CMD,
		GP_6_8_FN, FN_SD1_CLK,
		GP_6_7_FN, FN_SD0_WP,
		GP_6_6_FN, FN_SD0_CD,
		GP_6_5_FN, FN_SD0_DATA3,
		GP_6_4_FN, FN_SD0_DATA2,
		GP_6_3_FN, FN_SD0_DATA1,
		GP_6_2_FN, FN_SD0_DATA0,
		GP_6_1_FN, FN_SD0_CMD,
		GP_6_0_FN, FN_SD0_CLK }
	},
	{ PINMUX_CFG_REG_VAR("IPSR0", 0xE6060020, 32,
			     2, 2, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
			     2, 1, 1, 1, 1, 1, 1, 1, 1) {
		/* IP0_31_30 [2] */
		FN_D5, FN_SCIF4_RXD_B, FN_I2C0_SCL_D, 0,
		/* IP0_29_28 [2] */
		FN_D4, FN_I2C3_SDA_B, FN_SCIF5_TXD_B, 0,
		/* IP0_27_26 [2] */
		FN_D3, FN_I2C3_SCL_B, FN_SCIF5_RXD_B, 0,
		/* IP0_25 [1] */
		FN_D2, FN_SCIFA3_TXD_B,
		/* IP0_24 [1] */
		FN_D1, FN_SCIFA3_RXD_B,
		/* IP0_23_22 [2] */
		FN_D0, FN_SCIFA3_SCK_B, FN_IRQ4, 0,
		/* IP0_21_20 [2] */
		FN_MMC_D7, FN_SCIF0_TXD, FN_I2C2_SDA_B, FN_CAN1_TX,
		/* IP0_19_18 [2] */
		FN_MMC_D6, FN_SCIF0_RXD, FN_I2C2_SCL_B,	FN_CAN1_RX,
		/* IP0_17 [1] */
		FN_MMC_D5, FN_SD2_WP,
		/* IP0_16 [1] */
		FN_MMC_D4, FN_SD2_CD,
		/* IP0_15 [1] */
		FN_MMC_D3, FN_SD2_DATA3,
		/* IP0_14 [1] */
		FN_MMC_D2, FN_SD2_DATA2,
		/* IP0_13 [1] */
		FN_MMC_D1, FN_SD2_DATA1,
		/* IP0_12 [1] */
		FN_MMC_D0, FN_SD2_DATA0,
		/* IP0_11 [1] */
		FN_MMC_CMD, FN_SD2_CMD,
		/* IP0_10 [1] */
		FN_MMC_CLK, FN_SD2_CLK,
		/* IP0_9_8 [2] */
		FN_SD1_WP, FN_IRQ7, FN_CAN0_TX, 0,
		/* IP0_7 [1] */
		0, 0,
		/* IP0_6 [1] */
		0, 0,
		/* IP0_5 [1] */
		0, 0,
		/* IP0_4 [1] */
		0, 0,
		/* IP0_3 [1] */
		0, 0,
		/* IP0_2 [1] */
		0, 0,
		/* IP0_1 [1] */
		0, 0,
		/* IP0_0 [1] */
		FN_SD1_CD, FN_CAN0_RX, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR1", 0xE6060024, 32,
			     2, 2, 1, 1, 1, 1, 2, 2, 2, 3, 2, 2, 3, 2, 2,
			     2, 2) {
		/* IP1_31_30 [2] */
		FN_A6, FN_SCIFB0_CTS_N, FN_SCIFA4_RXD_B, FN_TPUTO2_C,
		/* IP1_29_28 [2] */
		FN_A5, FN_SCIFB0_RXD, FN_PWM4_B, FN_TPUTO3_C,
		/* IP1_27 [1] */
		FN_A4, FN_SCIFB0_TXD,
		/* IP1_26 [1] */
		FN_A3, FN_SCIFB0_SCK,
		/* IP1_25 [1] */
		0, 0,
		/* IP1_24 [1] */
		FN_A1, FN_SCIFB1_TXD,
		/* IP1_23_22 [2] */
		FN_A0, FN_SCIFB1_SCK, FN_PWM3_B, 0,
		/* IP1_21_20 [2] */
		FN_D15, FN_SCIFA1_TXD, FN_I2C5_SDA_B, 0,
		/* IP1_19_18 [2] */
		FN_D14, FN_SCIFA1_RXD, FN_I2C5_SCL_B, 0,
		/* IP1_17_15 [3] */
		FN_D13, FN_SCIFA1_SCK, 0, FN_PWM2_C, FN_TCLK2_B,
		0, 0, 0,
		/* IP1_14_13 [2] */
		FN_D12, FN_HSCIF2_HRTS_N, FN_SCIF1_TXD_C, FN_I2C1_SDA_D,
		/* IP1_12_11 [2] */
		FN_D11, FN_HSCIF2_HCTS_N, FN_SCIF1_RXD_C, FN_I2C1_SCL_D,
		/* IP1_10_8 [3] */
		FN_D10, FN_HSCIF2_HSCK, FN_SCIF1_SCK_C, FN_IRQ6, FN_PWM5_C,
		0, 0, 0,
		/* IP1_7_6 [2] */
		FN_D9, FN_HSCIF2_HTX, FN_I2C1_SDA_B, 0,
		/* IP1_5_4 [2] */
		FN_D8, FN_HSCIF2_HRX, FN_I2C1_SCL_B, 0,
		/* IP1_3_2 [2] */
		FN_D7, FN_IRQ3, FN_TCLK1, FN_PWM6_B,
		/* IP1_1_0 [2] */
		FN_D6, FN_SCIF4_TXD_B, FN_I2C0_SDA_D, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR2", 0xE6060028, 32,
			     2, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2) {
		/* IP2_31_30 [2] */
		FN_A20, FN_SPCLK, 0, 0,
		/* IP2_29_27 [3] */
		FN_A19, FN_MSIOF2_SS2, FN_PWM4, FN_TPUTO2,
		0, 0, 0, 0,
		/* IP2_26_24 [3] */
		FN_A18, FN_MSIOF2_SS1, FN_SCIF4_TXD_E, FN_CAN1_TX_B,
		0, 0, 0, 0,
		/* IP2_23_21 [3] */
		FN_A17, FN_MSIOF2_SYNC, FN_SCIF4_RXD_E, FN_CAN1_RX_B,
		0, 0, 0, 0,
		/* IP2_20_18 [3] */
		FN_A16, FN_MSIOF2_SCK, FN_HSCIF0_HSCK_B, FN_SPEEDIN,
		0, FN_CAN_CLK_C, FN_TPUTO2_B, 0,
		/* IP2_17_16 [2] */
		FN_A15, FN_MSIOF2_TXD, FN_HSCIF0_HTX_B, FN_DACK1,
		/* IP2_15_14 [2] */
		FN_A14, FN_MSIOF2_RXD, FN_HSCIF0_HRX_B, FN_DREQ1_N,
		/* IP2_13_12 [2] */
		FN_A13, FN_MSIOF1_SS2, FN_SCIFA5_TXD_B, 0,
		/* IP2_11_10 [2] */
		FN_A12, FN_MSIOF1_SS1, FN_SCIFA5_RXD_B, 0,
		/* IP2_9_8 [2] */
		FN_A11, FN_MSIOF1_SYNC, FN_IIC0_SDA_B, 0,
		/* IP2_7_6 [2] */
		FN_A10, FN_MSIOF1_SCK, FN_IIC0_SCL_B, 0,
		/* IP2_5_4 [2] */
		FN_A9, FN_MSIOF1_TXD, FN_SCIFA0_TXD_B, 0,
		/* IP2_3_2 [2] */
		FN_A8, FN_MSIOF1_RXD, FN_SCIFA0_RXD_B, 0,
		/* IP2_1_0 [2] */
		FN_A7, FN_SCIFB0_RTS_N, FN_SCIFA4_TXD_B, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR3", 0xE606002C, 32,
			     1, 1, 3, 3, 3, 3, 3, 2, 1, 1, 1, 2, 2, 2, 2, 2) {
		/* IP3_31 [1] */
		FN_RD_WR_N, FN_ATAG1_N,
		/* IP3_30 [1] */
		FN_RD_N, FN_ATACS11_N,
		/* IP3_29_27 [3] */
		FN_BS_N, FN_DRACK0, FN_PWM1_C, FN_TPUTO0_C, FN_ATACS01_N,
		0, 0, 0,
		/* IP3_26_24 [3] */
		FN_EX_CS5_N, FN_SCIFA2_TXD, FN_I2C2_SDA_E, FN_TS_SPSYNC_B,
		0, FN_FMIN, FN_SCIFB2_RTS_N, 0,
		/* IP3_23_21 [3] */
		FN_EX_CS4_N, FN_SCIFA2_RXD, FN_I2C2_SCL_E, FN_TS_SDEN_B,
		0, FN_FMCLK, FN_SCIFB2_CTS_N, 0,
		/* IP3_20_18 [3] */
		FN_EX_CS3_N, FN_SCIFA2_SCK, FN_SCIF4_TXD_C, FN_TS_SCK_B,
		0, FN_BPFCLK, FN_SCIFB2_SCK, 0,
		/* IP3_17_15 [3] */
		FN_EX_CS2_N, FN_PWM0, FN_SCIF4_RXD_C, FN_TS_SDATA_B,
		0, FN_TPUTO3, FN_SCIFB2_TXD, 0,
		/* IP3_14_13 [2] */
		FN_EX_CS1_N, FN_TPUTO3_B, FN_SCIFB2_RXD, FN_VI1_DATA11,
		/* IP3_12 [1] */
		FN_EX_CS0_N, FN_VI1_DATA10,
		/* IP3_11 [1] */
		FN_CS1_N_A26, FN_VI1_DATA9,
		/* IP3_10 [1] */
		FN_CS0_N, FN_VI1_DATA8,
		/* IP3_9_8 [2] */
		FN_A25, FN_SSL, FN_ATARD1_N, 0,
		/* IP3_7_6 [2] */
		FN_A24, FN_IO3, FN_EX_WAIT2, 0,
		/* IP3_5_4 [2] */
		FN_A23, FN_IO2, 0, FN_ATAWR1_N,
		/* IP3_3_2 [2] */
		FN_A22, FN_MISO_IO1, 0, FN_ATADIR1_N,
		/* IP3_1_0 [2] */
		FN_A21, FN_MOSI_IO0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR4", 0xE6060030, 32,
			     2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 3, 3, 2) {
		/* IP4_31_30 [2] */
		FN_DU0_DG4, FN_LCDOUT12, 0, 0,
		/* IP4_29_28 [2] */
		FN_DU0_DG3, FN_LCDOUT11, 0, 0,
		/* IP4_27_26 [2] */
		FN_DU0_DG2, FN_LCDOUT10, 0, 0,
		/* IP4_25_23 [3] */
		FN_DU0_DG1, FN_LCDOUT9, FN_SCIFA0_TXD_C, FN_I2C3_SDA_D,
		0, 0, 0, 0,
		/* IP4_22_20 [3] */
		FN_DU0_DG0, FN_LCDOUT8, FN_SCIFA0_RXD_C, FN_I2C3_SCL_D,
		0, 0, 0, 0,
		/* IP4_19_18 [2] */
		FN_DU0_DR7, FN_LCDOUT23, 0, 0,
		/* IP4_17_16 [2] */
		FN_DU0_DR6, FN_LCDOUT22, 0, 0,
		/* IP4_15_14 [2] */
		FN_DU0_DR5, FN_LCDOUT21, 0, 0,
		/* IP4_13_12 [2] */
		FN_DU0_DR4, FN_LCDOUT20, 0, 0,
		/* IP4_11_10 [2] */
		FN_DU0_DR3, FN_LCDOUT19, 0, 0,
		/* IP4_9_8 [2] */
		FN_DU0_DR2, FN_LCDOUT18, 0, 0,
		/* IP4_7_5 [3] */
		FN_DU0_DR1, FN_LCDOUT17, FN_SCIF5_TXD_C, FN_I2C2_SDA_D,
		0, 0, 0, 0,
		/* IP4_4_2 [3] */
		FN_DU0_DR0, FN_LCDOUT16, FN_SCIF5_RXD_C, FN_I2C2_SCL_D,
		0, 0, 0, 0,
		/* IP4_1_0 [2] */
		FN_EX_WAIT0, FN_CAN_CLK_B, FN_SCIF_CLK, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR5", 0xE6060034, 32,
			     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2) {
		/* IP5_31_30 [2] */
		FN_DU0_EXHSYNC_DU0_HSYNC, FN_QSTH_QHS, 0, 0,
		/* IP5_29_28 [2] */
		FN_DU0_DOTCLKOUT1, FN_QSTVB_QVE, 0, 0,
		/* IP5_27_26 [2] */
		FN_DU0_DOTCLKOUT0, FN_QCLK, 0, 0,
		/* IP5_25_24 [2] */
		FN_DU0_DOTCLKIN, FN_QSTVA_QVS, 0, 0,
		/* IP5_23_22 [2] */
		FN_DU0_DB7, FN_LCDOUT7, 0, 0,
		/* IP5_21_20 [2] */
		FN_DU0_DB6, FN_LCDOUT6, 0, 0,
		/* IP5_19_18 [2] */
		FN_DU0_DB5, FN_LCDOUT5, 0, 0,
		/* IP5_17_16 [2] */
		FN_DU0_DB4, FN_LCDOUT4, 0, 0,
		/* IP5_15_14 [2] */
		FN_DU0_DB3, FN_LCDOUT3, 0, 0,
		/* IP5_13_12 [2] */
		FN_DU0_DB2, FN_LCDOUT2, 0, 0,
		/* IP5_11_9 [3] */
		FN_DU0_DB1, FN_LCDOUT1, FN_SCIFA4_TXD_C, FN_I2C4_SDA_D,
		FN_CAN0_TX_C, 0, 0, 0,
		/* IP5_8_6 [3] */
		FN_DU0_DB0, FN_LCDOUT0, FN_SCIFA4_RXD_C, FN_I2C4_SCL_D,
		FN_CAN0_RX_C, 0, 0, 0,
		/* IP5_5_4 [2] */
		FN_DU0_DG7, FN_LCDOUT15, 0, 0,
		/* IP5_3_2 [2] */
		FN_DU0_DG6, FN_LCDOUT14, 0, 0,
		/* IP5_1_0 [2] */
		FN_DU0_DG5, FN_LCDOUT13, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR6", 0xE6060038, 32,
			     3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
			     2, 2) {
		/* IP6_31_29 [3] */
		FN_ETH_MDIO, FN_VI0_G0, FN_MSIOF2_RXD_B, FN_I2C5_SCL_D,
		FN_AVB_TX_CLK, FN_ADIDATA, 0, 0,
		/* IP6_28_26 [3] */
		FN_VI0_VSYNC_N, FN_SCIF0_TXD_B, FN_I2C0_SDA_C,
		FN_AUDIO_CLKOUT_B, FN_AVB_TX_EN, 0, 0, 0,
		/* IP6_25_23 [3] */
		FN_VI0_HSYNC_N, FN_SCIF0_RXD_B, FN_I2C0_SCL_C, FN_IERX_C,
		FN_AVB_COL, 0, 0, 0,
		/* IP6_22_20 [3] */
		FN_VI0_FIELD, FN_I2C3_SDA, FN_SCIFA5_TXD_C, FN_IECLK_C,
		FN_AVB_RX_ER, 0, 0, 0,
		/* IP6_19_17 [3] */
		FN_VI0_CLKENB, FN_I2C3_SCL, FN_SCIFA5_RXD_C, FN_IETX_C,
		FN_AVB_RXD7, 0, 0, 0,
		/* IP6_16 [1] */
		FN_VI0_DATA7_VI0_B7, FN_AVB_RXD6,
		/* IP6_15 [1] */
		FN_VI0_DATA6_VI0_B6, FN_AVB_RXD5,
		/* IP6_14 [1] */
		FN_VI0_DATA5_VI0_B5, FN_AVB_RXD4,
		/* IP6_13 [1] */
		FN_VI0_DATA4_VI0_B4, FN_AVB_RXD3,
		/* IP6_12 [1] */
		FN_VI0_DATA3_VI0_B3, FN_AVB_RXD2,
		/* IP6_11 [1] */
		FN_VI0_DATA2_VI0_B2, FN_AVB_RXD1,
		/* IP6_10 [1] */
		FN_VI0_DATA1_VI0_B1, FN_AVB_RXD0,
		/* IP6_9 [1] */
		FN_VI0_DATA0_VI0_B0, FN_AVB_RX_DV,
		/* IP6_8 [1] */
		FN_VI0_CLK, FN_AVB_RX_CLK,
		/* IP6_7_6 [2] */
		FN_DU0_CDE, FN_QPOLB, 0, 0,
		/* IP6_5_4 [2] */
		FN_DU0_DISP, FN_QPOLA, 0, 0,
		/* IP6_3_2 [2] */
		FN_DU0_EXODDF_DU0_ODDF_DISP_CDE, FN_QCPV_QDE, 0,
		0,
		/* IP6_1_0 [2] */
		FN_DU0_EXVSYNC_DU0_VSYNC, FN_QSTB_QHE, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR7", 0xE606003C, 32,
			     1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3) {
		/* IP7_31 [1] */
		FN_DREQ0_N, FN_SCIFB1_RXD,
		/* IP7_30 [1] */
		0, 0,
		/* IP7_29_27 [3] */
		FN_ETH_TXD0, FN_VI0_R2, FN_SCIF3_RXD_B, FN_I2C4_SCL_E,
		FN_AVB_GTX_CLK, FN_SSI_WS6_B, 0, 0,
		/* IP7_26_24 [3] */
		FN_ETH_MAGIC, FN_VI0_R1, FN_SCIF3_SCK_B, FN_AVB_TX_ER,
		FN_SSI_SCK6_B, 0, 0, 0,
		/* IP7_23_21 [3] */
		FN_ETH_TX_EN, FN_VI0_R0, FN_SCIF2_TXD_C, FN_IIC0_SDA_D,
		FN_AVB_TXD7, FN_SSI_SDATA5_B, 0, 0,
		/* IP7_20_18 [3] */
		FN_ETH_TXD1, FN_VI0_G7, FN_SCIF2_RXD_C, FN_IIC0_SCL_D,
		FN_AVB_TXD6, FN_SSI_WS5_B, 0, 0,
		/* IP7_17_15 [3] */
		FN_ETH_REFCLK, FN_VI0_G6, FN_SCIF2_SCK_C, FN_AVB_TXD5,
		FN_SSI_SCK5_B, 0, 0, 0,
		/* IP7_14_12 [3] */
		FN_ETH_LINK, FN_VI0_G5, FN_MSIOF2_SS2_B, FN_SCIF4_TXD_D,
		FN_AVB_TXD4, FN_ADICHS2, 0, 0,
		/* IP7_11_9 [3] */
		FN_ETH_RXD1, FN_VI0_G4, FN_MSIOF2_SS1_B, FN_SCIF4_RXD_D,
		FN_AVB_TXD3, FN_ADICHS1, 0, 0,
		/* IP7_8_6 [3] */
		FN_ETH_RXD0, FN_VI0_G3, FN_MSIOF2_SYNC_B, FN_CAN0_TX_B,
		FN_AVB_TXD2, FN_ADICHS0, 0, 0,
		/* IP7_5_3 [3] */
		FN_ETH_RX_ER, FN_VI0_G2, FN_MSIOF2_SCK_B, FN_CAN0_RX_B,
		FN_AVB_TXD1, FN_ADICLK, 0, 0,
		/* IP7_2_0 [3] */
		FN_ETH_CRS_DV, FN_VI0_G1, FN_MSIOF2_TXD_B, FN_I2C5_SDA_D,
		FN_AVB_TXD0, FN_ADICS_SAMP, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR8", 0xE6060040, 32,
			     3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 3) {
		/* IP8_31_29 [3] */
		FN_MSIOF0_RXD, FN_SCIF5_RXD, FN_I2C2_SCL_C, FN_DU1_DR2,
		0, FN_TS_SDEN_D, FN_FMCLK_C, 0,
		/* IP8_28_26 [3] */
		FN_I2C1_SDA, FN_SCIF4_TXD, FN_IRQ5, FN_DU1_DR1,
		0, FN_TS_SCK_D, FN_BPFCLK_C, 0,
		/* IP8_25_23 [3] */
		FN_I2C1_SCL, FN_SCIF4_RXD, FN_PWM5_B, FN_DU1_DR0,
		0, FN_TS_SDATA_D, FN_TPUTO1_B, 0,
		/* IP8_22_20 [3] */
		FN_I2C0_SDA, FN_SCIF0_TXD_C, FN_TPUTO0, FN_CAN_CLK,
		FN_DVC_MUTE, FN_CAN1_TX_D, 0, 0,
		/* IP8_19_17 [3] */
		FN_I2C0_SCL, FN_SCIF0_RXD_C, FN_PWM5, FN_TCLK1_B,
		FN_AVB_GTXREFCLK, FN_CAN1_RX_D, FN_TPUTO0_B, 0,
		/* IP8_16_15 [2] */
		FN_HSCIF0_HSCK, FN_SCIF_CLK_B, FN_AVB_CRS, FN_AUDIO_CLKC_B,
		/* IP8_14_12 [3] */
		FN_HSCIF0_HRTS_N, FN_VI0_R7, FN_SCIF0_TXD_D, FN_I2C0_SDA_E,
		FN_AVB_PHY_INT, FN_SSI_SDATA8_B, 0, 0,
		/* IP8_11_9 [3] */
		FN_HSCIF0_HCTS_N, FN_VI0_R6, FN_SCIF0_RXD_D, FN_I2C0_SCL_E,
		FN_AVB_MAGIC, FN_SSI_SDATA7_B, 0, 0,
		/* IP8_8_6 [3] */
		FN_HSCIF0_HTX, FN_VI0_R5, FN_I2C1_SDA_C, FN_AUDIO_CLKB_B,
		FN_AVB_LINK, FN_SSI_WS78_B, 0, 0,
		/* IP8_5_3 [3] */
		FN_HSCIF0_HRX, FN_VI0_R4, FN_I2C1_SCL_C, FN_AUDIO_CLKA_B,
		FN_AVB_MDIO, FN_SSI_SCK78_B, 0, 0,
		/* IP8_2_0 [3] */
		FN_ETH_MDC, FN_VI0_R3, FN_SCIF3_TXD_B, FN_I2C4_SDA_E,
		FN_AVB_MDC, FN_SSI_SDATA6_B, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR9", 0xE6060044, 32,
			     1, 3, 3, 3, 3, 2, 2, 3, 3, 3, 3, 3, 3) {
		/* IP9_31 [1] */
		0, 0,
		/* IP9_30_28 [3] */
		FN_SCIF1_SCK, FN_PWM3, FN_TCLK2, FN_DU1_DG5,
		FN_SSI_SDATA1_B, 0, 0, 0,
		/* IP9_27_25 [3] */
		FN_HSCIF1_HRTS_N, FN_SCIFA4_TXD, FN_IERX, FN_DU1_DG4,
		FN_SSI_WS1_B, 0, 0, 0,
		/* IP9_24_22 [3] */
		FN_HSCIF1_HCTS_N, FN_SCIFA4_RXD, FN_IECLK, FN_DU1_DG3,
		FN_SSI_SCK1_B, 0, 0, 0,
		/* IP9_21_19 [3] */
		FN_HSCIF1_HSCK, FN_PWM2, FN_IETX, FN_DU1_DG2,
		FN_REMOCON_B, FN_SPEEDIN_B, 0, 0,
		/* IP9_18_17 [2] */
		FN_HSCIF1_HTX, FN_I2C4_SDA, FN_TPUTO1, FN_DU1_DG1,
		/* IP9_16_15 [2] */
		FN_HSCIF1_HRX, FN_I2C4_SCL, FN_PWM6, FN_DU1_DG0,
		/* IP9_14_12 [3] */
		FN_MSIOF0_SS2, FN_SCIFA0_TXD, FN_TS_SPSYNC, FN_DU1_DR7,
		0, FN_FMIN_B, 0, 0,
		/* IP9_11_9 [3] */
		FN_MSIOF0_SS1, FN_SCIFA0_RXD, FN_TS_SDEN, FN_DU1_DR6,
		0, FN_FMCLK_B, 0, 0,
		/* IP9_8_6 [3] */
		FN_MSIOF0_SYNC, FN_PWM1, FN_TS_SCK, FN_DU1_DR5,
		0, FN_BPFCLK_B, 0, 0,
		/* IP9_5_3 [3] */
		FN_MSIOF0_SCK, FN_IRQ0, FN_TS_SDATA, FN_DU1_DR4,
		0, FN_TPUTO1_C, 0, 0,
		/* IP9_2_0 [3] */
		FN_MSIOF0_TXD, FN_SCIF5_TXD, FN_I2C2_SDA_C, FN_DU1_DR3,
		0, FN_TS_SPSYNC_D, FN_FMIN_C, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR10", 0xE6060048, 32,
			     2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3) {
		/* IP10_31_30 [2] */
		FN_SSI_SCK5, FN_SCIFA3_SCK, FN_DU1_DOTCLKIN, 0,
		/* IP10_29_27 [3] */
		FN_I2C2_SDA, FN_SCIFA5_TXD, FN_DU1_DB7, FN_AUDIO_CLKOUT_C,
		0, 0, 0, 0,
		/* IP10_26_24 [3] */
		FN_I2C2_SCL, FN_SCIFA5_RXD, FN_DU1_DB6, FN_AUDIO_CLKC_C,
		FN_SSI_SDATA4_B, 0, 0, 0,
		/* IP10_23_21 [3] */
		FN_SCIF3_TXD, FN_I2C1_SDA_E, FN_FMIN_D, FN_DU1_DB5,
		FN_AUDIO_CLKB_C, FN_SSI_WS4_B, 0, 0,
		/* IP10_20_18 [3] */
		FN_SCIF3_RXD, FN_I2C1_SCL_E, FN_FMCLK_D, FN_DU1_DB4,
		FN_AUDIO_CLKA_C, FN_SSI_SCK4_B, 0, 0,
		/* IP10_17_15 [3] */
		FN_SCIF3_SCK, FN_IRQ2, FN_BPFCLK_D, FN_DU1_DB3,
		FN_SSI_SDATA9_B, 0, 0, 0,
		/* IP10_14_12 [3] */
		FN_SCIF2_SCK, FN_IRQ1, FN_DU1_DB2, FN_SSI_WS9_B,
		0, 0, 0, 0,
		/* IP10_11_9 [3] */
		FN_SCIF2_TXD, FN_IIC0_SDA, FN_DU1_DB1, FN_SSI_SCK9_B,
		0, 0, 0, 0,
		/* IP10_8_6 [3] */
		FN_SCIF2_RXD, FN_IIC0_SCL, FN_DU1_DB0, FN_SSI_SDATA2_B,
		0, 0, 0, 0,
		/* IP10_5_3 [3] */
		FN_SCIF1_TXD, FN_I2C5_SDA, FN_DU1_DG7, FN_SSI_WS2_B,
		0, 0, 0, 0,
		/* IP10_2_0 [3] */
		FN_SCIF1_RXD, FN_I2C5_SCL, FN_DU1_DG6, FN_SSI_SCK2_B,
		0, 0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR11", 0xE606004C, 32,
			     2, 3, 3, 3, 3, 2, 2, 3, 3, 2, 3, 3) {
		/* IP11_31_30 [2] */
		0, 0, 0, 0,
		/* IP11_29_27 [3] */
		FN_SSI_SDATA0, FN_MSIOF1_SCK_B, FN_PWM0_B, FN_ADICLK_B,
		0, 0, 0, 0,
		/* IP11_26_24 [3] */
		FN_SSI_WS0129, FN_MSIOF1_TXD_B, FN_SCIF5_TXD_D, FN_ADICS_SAMP_B,
		0, 0, 0, 0,
		/* IP11_23_21 [3] */
		FN_SSI_SCK0129, FN_MSIOF1_RXD_B, FN_SCIF5_RXD_D, FN_ADIDATA_B,
		0, 0, 0, 0,
		/* IP11_20_18 [3] */
		FN_SSI_SDATA7, FN_SCIFA2_TXD_B, FN_IRQ8, FN_AUDIO_CLKA_D,
		FN_CAN_CLK_D, 0, 0, 0,
		/* IP11_17_16 [2] */
		FN_SSI_WS78, FN_SCIFA2_RXD_B, FN_I2C5_SCL_C, FN_DU1_CDE,
		/* IP11_15_14 [2] */
		FN_SSI_SCK78, FN_SCIFA2_SCK_B, FN_I2C5_SDA_C, FN_DU1_DISP,
		/* IP11_13_11 [3] */
		FN_SSI_SDATA6, FN_SCIFA1_TXD_B, FN_I2C4_SDA_C,
		FN_DU1_EXODDF_DU1_ODDF_DISP_CDE, 0, 0, 0, 0,
		/* IP11_10_8 [3] */
		FN_SSI_WS6, FN_SCIFA1_RXD_B, FN_I2C4_SCL_C,
		FN_DU1_EXVSYNC_DU1_VSYNC, 0, 0, 0, 0,
		/* IP11_7_6 [2] */
		FN_SSI_SCK6, FN_SCIFA1_SCK_B, FN_DU1_EXHSYNC_DU1_HSYNC, 0,
		/* IP11_5_3 [3] */
		FN_SSI_SDATA5, FN_SCIFA3_TXD, FN_I2C3_SDA_C, FN_DU1_DOTCLKOUT1,
		0, 0, 0, 0,
		/* IP11_2_0 [3] */
		FN_SSI_WS5, FN_SCIFA3_RXD, FN_I2C3_SCL_C, FN_DU1_DOTCLKOUT0,
		0, 0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR12", 0xE6060050, 32,
			     2, 3, 3, 3, 3, 3, 2, 2, 2, 3, 3, 3) {
		/* IP12_31_30 [2] */
		0, 0, 0, 0,
		/* IP12_29_27 [3] */
		FN_SSI_SCK2, FN_HSCIF1_HTX_B, FN_VI1_DATA2, 0,
		FN_ATAG0_N, FN_ETH_RXD1_B, 0, 0,
		/* IP12_26_24 [3] */
		FN_SSI_SDATA1, FN_HSCIF1_HRX_B, FN_VI1_DATA1, 0,
		FN_ATAWR0_N, FN_ETH_RXD0_B, 0, 0,
		/* IP12_23_21 [3] */
		FN_SSI_WS1, FN_SCIF1_TXD_B, FN_IIC0_SDA_C, FN_VI1_DATA0,
		FN_CAN0_TX_D, 0, FN_ETH_RX_ER_B, 0,
		/* IP12_20_18 [3] */
		FN_SSI_SCK1, FN_SCIF1_RXD_B, FN_IIC0_SCL_C, FN_VI1_CLK,
		FN_CAN0_RX_D, 0, FN_ETH_CRS_DV_B, 0,
		/* IP12_17_15 [3] */
		FN_SSI_SDATA8, FN_SCIF1_SCK_B, FN_PWM1_B, FN_IRQ9,
		FN_REMOCON, FN_DACK2, FN_ETH_MDIO_B, 0,
		/* IP12_14_13 [2] */
		FN_SSI_SDATA4, FN_MLB_DAT, FN_IERX_B, 0,
		/* IP12_12_11 [2] */
		FN_SSI_WS4, FN_MLB_SIG, FN_IECLK_B, 0,
		/* IP12_10_9 [2] */
		FN_SSI_SCK4, FN_MLB_CLK, FN_IETX_B, 0,
		/* IP12_8_6 [3] */
		FN_SSI_SDATA3, FN_MSIOF1_SS2_B, FN_SCIFA1_TXD_C, FN_ADICHS2_B,
		FN_CAN1_TX_C, FN_DREQ2_N, 0, 0,
		/* IP12_5_3 [3] */
		FN_SSI_WS34, FN_MSIOF1_SS1_B, FN_SCIFA1_RXD_C, FN_ADICHS1_B,
		FN_CAN1_RX_C, FN_DACK1_B, 0, 0,
		/* IP12_2_0 [3] */
		FN_SSI_SCK34, FN_MSIOF1_SYNC_B, FN_SCIFA1_SCK_C, FN_ADICHS0_B,
		0, FN_DREQ1_N_B, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR13", 0xE6060054, 32,
			     1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3) {
		/* IP13_31 [1] */
		0, 0,
		/* IP13_30 [1] */
		0, 0,
		/* IP13_29 [1] */
		0, 0,
		/* IP13_28 [1] */
		0, 0,
		/* IP13_27 [1] */
		0, 0,
		/* IP13_26_24 [3] */
		FN_AUDIO_CLKOUT, FN_I2C4_SDA_B, FN_SCIFA5_TXD_D, FN_VI1_VSYNC_N,
		FN_TS_SPSYNC_C, 0, FN_FMIN_E, 0,
		/* IP13_23_21 [3] */
		FN_AUDIO_CLKC, FN_I2C4_SCL_B, FN_SCIFA5_RXD_D, FN_VI1_HSYNC_N,
		FN_TS_SDEN_C, 0, FN_FMCLK_E, 0,
		/* IP13_20_18 [3] */
		FN_AUDIO_CLKB, FN_I2C0_SDA_B, FN_SCIFA4_TXD_D, FN_VI1_FIELD,
		FN_TS_SCK_C, 0, FN_BPFCLK_E, FN_ETH_MDC_B,
		/* IP13_17_15 [3] */
		FN_AUDIO_CLKA, FN_I2C0_SCL_B, FN_SCIFA4_RXD_D, FN_VI1_CLKENB,
		FN_TS_SDATA_C, 0, FN_ETH_TXD0_B, 0,
		/* IP13_14_12 [3] */
		FN_SSI_SDATA9, FN_SCIF2_TXD_B, FN_I2C3_SDA_E, FN_VI1_DATA7,
		FN_ATADIR0_N, FN_ETH_MAGIC_B, 0, 0,
		/* IP13_11_9 [3] */
		FN_SSI_WS9, FN_SCIF2_RXD_B, FN_I2C3_SCL_E, FN_VI1_DATA6,
		FN_ATARD0_N, FN_ETH_TX_EN_B, 0, 0,
		/* IP13_8_6 [3] */
		FN_SSI_SCK9, FN_SCIF2_SCK_B, FN_PWM2_B, FN_VI1_DATA5,
		0, FN_EX_WAIT1, FN_ETH_TXD1_B, 0,
		/* IP13_5_3 [2] */
		FN_SSI_SDATA2, FN_HSCIF1_HRTS_N_B, FN_SCIFA0_TXD_D,
		FN_VI1_DATA4, 0, FN_ATACS10_N, FN_ETH_REFCLK_B, 0,
		/* IP13_2_0 [3] */
		FN_SSI_WS2, FN_HSCIF1_HCTS_N_B, FN_SCIFA0_RXD_D, FN_VI1_DATA3,
		0, FN_ATACS00_N, FN_ETH_LINK_B, 0, }
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL", 0xE6060090, 32,
			     2, 1, 2, 3, 4, 1, 1, 3, 3, 3, 3, 3,
			     2, 1) {
		/* SEL_ADG [2] */
		FN_SEL_ADG_0, FN_SEL_ADG_1, FN_SEL_ADG_2, FN_SEL_ADG_3,
		/* RESERVED [1] */
		0, 0,
		/* SEL_CAN [2] */
		FN_SEL_CAN_0, FN_SEL_CAN_1, FN_SEL_CAN_2, FN_SEL_CAN_3,
		/* SEL_DARC [3] */
		FN_SEL_DARC_0, FN_SEL_DARC_1, FN_SEL_DARC_2, FN_SEL_DARC_3,
		FN_SEL_DARC_4, 0, 0, 0,
		/* RESERVED [4] */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		/* SEL_ETH [1] */
		FN_SEL_ETH_0, FN_SEL_ETH_1,
		/* RESERVED [1] */
		0, 0,
		/* SEL_IC200 [3] */
		FN_SEL_I2C00_0, FN_SEL_I2C00_1, FN_SEL_I2C00_2, FN_SEL_I2C00_3,
		FN_SEL_I2C00_4, 0, 0, 0,
		/* SEL_I2C01 [3] */
		FN_SEL_I2C01_0, FN_SEL_I2C01_1, FN_SEL_I2C01_2, FN_SEL_I2C01_3,
		FN_SEL_I2C01_4, 0, 0, 0,
		/* SEL_I2C02 [3] */
		FN_SEL_I2C02_0, FN_SEL_I2C02_1, FN_SEL_I2C02_2, FN_SEL_I2C02_3,
		FN_SEL_I2C02_4, 0, 0, 0,
		/* SEL_I2C03 [3] */
		FN_SEL_I2C03_0, FN_SEL_I2C03_1, FN_SEL_I2C03_2, FN_SEL_I2C03_3,
		FN_SEL_I2C03_4, 0, 0, 0,
		/* SEL_I2C04 [3] */
		FN_SEL_I2C04_0, FN_SEL_I2C04_1, FN_SEL_I2C04_2, FN_SEL_I2C04_3,
		FN_SEL_I2C04_4, 0, 0, 0,
		/* SEL_I2C05 [2] */
		FN_SEL_I2C05_0, FN_SEL_I2C05_1, FN_SEL_I2C05_2, FN_SEL_I2C05_3,
		/* RESERVED [1] */
		0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL2", 0xE6060094, 32,
			     2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1,
			     2, 2, 2, 1, 1, 2) {
		/* SEL_IEB [2] */
		FN_SEL_IEB_0, FN_SEL_IEB_1, FN_SEL_IEB_2, 0,
		/* SEL_IIC0 [2] */
		FN_SEL_IIC0_0, FN_SEL_IIC0_1, FN_SEL_IIC0_2, FN_SEL_IIC0_3,
		/* SEL_LBS [1] */
		FN_SEL_LBS_0, FN_SEL_LBS_1,
		/* SEL_MSI1 [1] */
		FN_SEL_MSI1_0, FN_SEL_MSI1_1,
		/* SEL_MSI2 [1] */
		FN_SEL_MSI2_0, FN_SEL_MSI2_1,
		/* SEL_RAD [1] */
		FN_SEL_RAD_0, FN_SEL_RAD_1,
		/* SEL_RCN [1] */
		FN_SEL_RCN_0, FN_SEL_RCN_1,
		/* SEL_RSP [1] */
		FN_SEL_RSP_0, FN_SEL_RSP_1,
		/* SEL_SCIFA0 [2] */
		FN_SEL_SCIFA0_0, FN_SEL_SCIFA0_1, FN_SEL_SCIFA0_2,
		FN_SEL_SCIFA0_3,
		/* SEL_SCIFA1 [2] */
		FN_SEL_SCIFA1_0, FN_SEL_SCIFA1_1, FN_SEL_SCIFA1_2, 0,
		/* SEL_SCIFA2 [1] */
		FN_SEL_SCIFA2_0, FN_SEL_SCIFA2_1,
		/* SEL_SCIFA3 [1] */
		FN_SEL_SCIFA3_0, FN_SEL_SCIFA3_1,
		/* SEL_SCIFA4 [2] */
		FN_SEL_SCIFA4_0, FN_SEL_SCIFA4_1, FN_SEL_SCIFA4_2,
		FN_SEL_SCIFA4_3,
		/* SEL_SCIFA5 [2] */
		FN_SEL_SCIFA5_0, FN_SEL_SCIFA5_1, FN_SEL_SCIFA5_2,
		FN_SEL_SCIFA5_3,
		/* RESERVED [1] */
		0, 0,
		/* SEL_TMU [1] */
		FN_SEL_TMU_0, FN_SEL_TMU_1,
		/* SEL_TSIF0 [2] */
		FN_SEL_TSIF0_0, FN_SEL_TSIF0_1, FN_SEL_TSIF0_2, FN_SEL_TSIF0_3,
		/* SEL_CAN0 [2] */
		FN_SEL_CAN0_0, FN_SEL_CAN0_1, FN_SEL_CAN0_2, FN_SEL_CAN0_3,
		/* SEL_CAN1 [2] */
		FN_SEL_CAN1_0, FN_SEL_CAN1_1, FN_SEL_CAN1_2, FN_SEL_CAN1_3,
		/* SEL_HSCIF0 [1] */
		FN_SEL_HSCIF0_0, FN_SEL_HSCIF0_1,
		/* SEL_HSCIF1 [1] */
		FN_SEL_HSCIF1_0, FN_SEL_HSCIF1_1,
		/* RESERVED [2] */
		0, 0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL3", 0xE6060098, 32,
			     2, 2, 2, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1) {
		/* SEL_SCIF0 [2] */
		FN_SEL_SCIF0_0, FN_SEL_SCIF0_1, FN_SEL_SCIF0_2, FN_SEL_SCIF0_3,
		/* SEL_SCIF1 [2] */
		FN_SEL_SCIF1_0, FN_SEL_SCIF1_1, FN_SEL_SCIF1_2, 0,
		/* SEL_SCIF2 [2] */
		FN_SEL_SCIF2_0, FN_SEL_SCIF2_1, FN_SEL_SCIF2_2, 0,
		/* SEL_SCIF3 [1] */
		FN_SEL_SCIF3_0, FN_SEL_SCIF3_1,
		/* SEL_SCIF4 [3] */
		FN_SEL_SCIF4_0, FN_SEL_SCIF4_1, FN_SEL_SCIF4_2, FN_SEL_SCIF4_3,
		FN_SEL_SCIF4_4, 0, 0, 0,
		/* SEL_SCIF5 [2] */
		FN_SEL_SCIF5_0, FN_SEL_SCIF5_1, FN_SEL_SCIF5_2, FN_SEL_SCIF5_3,
		/* SEL_SSI1 [1] */
		FN_SEL_SSI1_0, FN_SEL_SSI1_1,
		/* SEL_SSI2 [1] */
		FN_SEL_SSI2_0, FN_SEL_SSI2_1,
		/* SEL_SSI4 [1] */
		FN_SEL_SSI4_0, FN_SEL_SSI4_1,
		/* SEL_SSI5 [1] */
		FN_SEL_SSI5_0, FN_SEL_SSI5_1,
		/* SEL_SSI6 [1] */
		FN_SEL_SSI6_0, FN_SEL_SSI6_1,
		/* SEL_SSI7 [1] */
		FN_SEL_SSI7_0, FN_SEL_SSI7_1,
		/* SEL_SSI8 [1] */
		FN_SEL_SSI8_0, FN_SEL_SSI8_1,
		/* SEL_SSI9 [1] */
		FN_SEL_SSI9_0, FN_SEL_SSI9_1,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0,
		/* RESERVED [1] */
		0, 0, }
	},
	{ },
};

static int r8a7794_pin_to_pocctrl(struct sh_pfc *pfc, unsigned int pin, u32 *pocctrl)
{
	*pocctrl = 0xe606006c;

	switch (pin & 0x1f) {
	case 6: return 23;
	case 7: return 16;
	case 14: return 15;
	case 15: return 8;
	case 0 ... 5:
	case 8 ... 13:
		return 22 - (pin & 0x1f);
	case 16 ... 23:
		return 47 - (pin & 0x1f);
	}

	return -EINVAL;
}

static const struct sh_pfc_soc_operations r8a7794_pinmux_ops = {
	.pin_to_pocctrl = r8a7794_pin_to_pocctrl,
};

#ifdef CONFIG_PINCTRL_PFC_R8A7745
const struct sh_pfc_soc_info r8a7745_pinmux_info = {
	.name = "r8a77450_pfc",
	.ops = &r8a7794_pinmux_ops,
	.unlock_reg = 0xe6060000, /* PMMR */

	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
#endif

#ifdef CONFIG_PINCTRL_PFC_R8A7794
const struct sh_pfc_soc_info r8a7794_pinmux_info = {
	.name = "r8a77940_pfc",
	.ops = &r8a7794_pinmux_ops,
	.unlock_reg = 0xe6060000, /* PMMR */

	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
#endif
