/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _DT_BINDINGS_STM32F746_PINFUNC_H
#define _DT_BINDINGS_STM32F746_PINFUNC_H

#define STM32F746_PA0_FUNC_GPIO 0x0
#define STM32F746_PA0_FUNC_TIM2_CH1_TIM2_ETR 0x2
#define STM32F746_PA0_FUNC_TIM5_CH1 0x3
#define STM32F746_PA0_FUNC_TIM8_ETR 0x4
#define STM32F746_PA0_FUNC_USART2_CTS 0x8
#define STM32F746_PA0_FUNC_UART4_TX 0x9
#define STM32F746_PA0_FUNC_SAI2_SD_B 0xb
#define STM32F746_PA0_FUNC_ETH_MII_CRS 0xc
#define STM32F746_PA0_FUNC_EVENTOUT 0x10
#define STM32F746_PA0_FUNC_ANALOG 0x11

#define STM32F746_PA1_FUNC_GPIO 0x100
#define STM32F746_PA1_FUNC_TIM2_CH2 0x102
#define STM32F746_PA1_FUNC_TIM5_CH2 0x103
#define STM32F746_PA1_FUNC_USART2_RTS 0x108
#define STM32F746_PA1_FUNC_UART4_RX 0x109
#define STM32F746_PA1_FUNC_QUADSPI_BK1_IO3 0x10a
#define STM32F746_PA1_FUNC_SAI2_MCLK_B 0x10b
#define STM32F746_PA1_FUNC_ETH_MII_RX_CLK_ETH_RMII_REF_CLK 0x10c
#define STM32F746_PA1_FUNC_LCD_R2 0x10f
#define STM32F746_PA1_FUNC_EVENTOUT 0x110
#define STM32F746_PA1_FUNC_ANALOG 0x111

#define STM32F746_PA2_FUNC_GPIO 0x200
#define STM32F746_PA2_FUNC_TIM2_CH3 0x202
#define STM32F746_PA2_FUNC_TIM5_CH3 0x203
#define STM32F746_PA2_FUNC_TIM9_CH1 0x204
#define STM32F746_PA2_FUNC_USART2_TX 0x208
#define STM32F746_PA2_FUNC_SAI2_SCK_B 0x209
#define STM32F746_PA2_FUNC_ETH_MDIO 0x20c
#define STM32F746_PA2_FUNC_LCD_R1 0x20f
#define STM32F746_PA2_FUNC_EVENTOUT 0x210
#define STM32F746_PA2_FUNC_ANALOG 0x211

#define STM32F746_PA3_FUNC_GPIO 0x300
#define STM32F746_PA3_FUNC_TIM2_CH4 0x302
#define STM32F746_PA3_FUNC_TIM5_CH4 0x303
#define STM32F746_PA3_FUNC_TIM9_CH2 0x304
#define STM32F746_PA3_FUNC_USART2_RX 0x308
#define STM32F746_PA3_FUNC_OTG_HS_ULPI_D0 0x30b
#define STM32F746_PA3_FUNC_ETH_MII_COL 0x30c
#define STM32F746_PA3_FUNC_LCD_B5 0x30f
#define STM32F746_PA3_FUNC_EVENTOUT 0x310
#define STM32F746_PA3_FUNC_ANALOG 0x311

#define STM32F746_PA4_FUNC_GPIO 0x400
#define STM32F746_PA4_FUNC_SPI1_NSS_I2S1_WS 0x406
#define STM32F746_PA4_FUNC_SPI3_NSS_I2S3_WS 0x407
#define STM32F746_PA4_FUNC_USART2_CK 0x408
#define STM32F746_PA4_FUNC_OTG_HS_SOF 0x40d
#define STM32F746_PA4_FUNC_DCMI_HSYNC 0x40e
#define STM32F746_PA4_FUNC_LCD_VSYNC 0x40f
#define STM32F746_PA4_FUNC_EVENTOUT 0x410
#define STM32F746_PA4_FUNC_ANALOG 0x411

#define STM32F746_PA5_FUNC_GPIO 0x500
#define STM32F746_PA5_FUNC_TIM2_CH1_TIM2_ETR 0x502
#define STM32F746_PA5_FUNC_TIM8_CH1N 0x504
#define STM32F746_PA5_FUNC_SPI1_SCK_I2S1_CK 0x506
#define STM32F746_PA5_FUNC_OTG_HS_ULPI_CK 0x50b
#define STM32F746_PA5_FUNC_LCD_R4 0x50f
#define STM32F746_PA5_FUNC_EVENTOUT 0x510
#define STM32F746_PA5_FUNC_ANALOG 0x511

#define STM32F746_PA6_FUNC_GPIO 0x600
#define STM32F746_PA6_FUNC_TIM1_BKIN 0x602
#define STM32F746_PA6_FUNC_TIM3_CH1 0x603
#define STM32F746_PA6_FUNC_TIM8_BKIN 0x604
#define STM32F746_PA6_FUNC_SPI1_MISO 0x606
#define STM32F746_PA6_FUNC_TIM13_CH1 0x60a
#define STM32F746_PA6_FUNC_DCMI_PIXCLK 0x60e
#define STM32F746_PA6_FUNC_LCD_G2 0x60f
#define STM32F746_PA6_FUNC_EVENTOUT 0x610
#define STM32F746_PA6_FUNC_ANALOG 0x611

#define STM32F746_PA7_FUNC_GPIO 0x700
#define STM32F746_PA7_FUNC_TIM1_CH1N 0x702
#define STM32F746_PA7_FUNC_TIM3_CH2 0x703
#define STM32F746_PA7_FUNC_TIM8_CH1N 0x704
#define STM32F746_PA7_FUNC_SPI1_MOSI_I2S1_SD 0x706
#define STM32F746_PA7_FUNC_TIM14_CH1 0x70a
#define STM32F746_PA7_FUNC_ETH_MII_RX_DV_ETH_RMII_CRS_DV 0x70c
#define STM32F746_PA7_FUNC_FMC_SDNWE 0x70d
#define STM32F746_PA7_FUNC_EVENTOUT 0x710
#define STM32F746_PA7_FUNC_ANALOG 0x711

#define STM32F746_PA8_FUNC_GPIO 0x800
#define STM32F746_PA8_FUNC_MCO1 0x801
#define STM32F746_PA8_FUNC_TIM1_CH1 0x802
#define STM32F746_PA8_FUNC_TIM8_BKIN2 0x804
#define STM32F746_PA8_FUNC_I2C3_SCL 0x805
#define STM32F746_PA8_FUNC_USART1_CK 0x808
#define STM32F746_PA8_FUNC_OTG_FS_SOF 0x80b
#define STM32F746_PA8_FUNC_LCD_R6 0x80f
#define STM32F746_PA8_FUNC_EVENTOUT 0x810
#define STM32F746_PA8_FUNC_ANALOG 0x811

#define STM32F746_PA9_FUNC_GPIO 0x900
#define STM32F746_PA9_FUNC_TIM1_CH2 0x902
#define STM32F746_PA9_FUNC_I2C3_SMBA 0x905
#define STM32F746_PA9_FUNC_SPI2_SCK_I2S2_CK 0x906
#define STM32F746_PA9_FUNC_USART1_TX 0x908
#define STM32F746_PA9_FUNC_DCMI_D0 0x90e
#define STM32F746_PA9_FUNC_EVENTOUT 0x910
#define STM32F746_PA9_FUNC_ANALOG 0x911

#define STM32F746_PA10_FUNC_GPIO 0xa00
#define STM32F746_PA10_FUNC_TIM1_CH3 0xa02
#define STM32F746_PA10_FUNC_USART1_RX 0xa08
#define STM32F746_PA10_FUNC_OTG_FS_ID 0xa0b
#define STM32F746_PA10_FUNC_DCMI_D1 0xa0e
#define STM32F746_PA10_FUNC_EVENTOUT 0xa10
#define STM32F746_PA10_FUNC_ANALOG 0xa11

#define STM32F746_PA11_FUNC_GPIO 0xb00
#define STM32F746_PA11_FUNC_TIM1_CH4 0xb02
#define STM32F746_PA11_FUNC_USART1_CTS 0xb08
#define STM32F746_PA11_FUNC_CAN1_RX 0xb0a
#define STM32F746_PA11_FUNC_OTG_FS_DM 0xb0b
#define STM32F746_PA11_FUNC_LCD_R4 0xb0f
#define STM32F746_PA11_FUNC_EVENTOUT 0xb10
#define STM32F746_PA11_FUNC_ANALOG 0xb11

#define STM32F746_PA12_FUNC_GPIO 0xc00
#define STM32F746_PA12_FUNC_TIM1_ETR 0xc02
#define STM32F746_PA12_FUNC_USART1_RTS 0xc08
#define STM32F746_PA12_FUNC_SAI2_FS_B 0xc09
#define STM32F746_PA12_FUNC_CAN1_TX 0xc0a
#define STM32F746_PA12_FUNC_OTG_FS_DP 0xc0b
#define STM32F746_PA12_FUNC_LCD_R5 0xc0f
#define STM32F746_PA12_FUNC_EVENTOUT 0xc10
#define STM32F746_PA12_FUNC_ANALOG 0xc11

#define STM32F746_PA13_FUNC_GPIO 0xd00
#define STM32F746_PA13_FUNC_JTMS_SWDIO 0xd01
#define STM32F746_PA13_FUNC_EVENTOUT 0xd10
#define STM32F746_PA13_FUNC_ANALOG 0xd11

#define STM32F746_PA14_FUNC_GPIO 0xe00
#define STM32F746_PA14_FUNC_JTCK_SWCLK 0xe01
#define STM32F746_PA14_FUNC_EVENTOUT 0xe10
#define STM32F746_PA14_FUNC_ANALOG 0xe11

#define STM32F746_PA15_FUNC_GPIO 0xf00
#define STM32F746_PA15_FUNC_JTDI 0xf01
#define STM32F746_PA15_FUNC_TIM2_CH1_TIM2_ETR 0xf02
#define STM32F746_PA15_FUNC_HDMI_CEC 0xf05
#define STM32F746_PA15_FUNC_SPI1_NSS_I2S1_WS 0xf06
#define STM32F746_PA15_FUNC_SPI3_NSS_I2S3_WS 0xf07
#define STM32F746_PA15_FUNC_UART4_RTS 0xf09
#define STM32F746_PA15_FUNC_EVENTOUT 0xf10
#define STM32F746_PA15_FUNC_ANALOG 0xf11


#define STM32F746_PB0_FUNC_GPIO 0x1000
#define STM32F746_PB0_FUNC_TIM1_CH2N 0x1002
#define STM32F746_PB0_FUNC_TIM3_CH3 0x1003
#define STM32F746_PB0_FUNC_TIM8_CH2N 0x1004
#define STM32F746_PB0_FUNC_UART4_CTS 0x1009
#define STM32F746_PB0_FUNC_LCD_R3 0x100a
#define STM32F746_PB0_FUNC_OTG_HS_ULPI_D1 0x100b
#define STM32F746_PB0_FUNC_ETH_MII_RXD2 0x100c
#define STM32F746_PB0_FUNC_EVENTOUT 0x1010
#define STM32F746_PB0_FUNC_ANALOG 0x1011

#define STM32F746_PB1_FUNC_GPIO 0x1100
#define STM32F746_PB1_FUNC_TIM1_CH3N 0x1102
#define STM32F746_PB1_FUNC_TIM3_CH4 0x1103
#define STM32F746_PB1_FUNC_TIM8_CH3N 0x1104
#define STM32F746_PB1_FUNC_LCD_R6 0x110a
#define STM32F746_PB1_FUNC_OTG_HS_ULPI_D2 0x110b
#define STM32F746_PB1_FUNC_ETH_MII_RXD3 0x110c
#define STM32F746_PB1_FUNC_EVENTOUT 0x1110
#define STM32F746_PB1_FUNC_ANALOG 0x1111

#define STM32F746_PB2_FUNC_GPIO 0x1200
#define STM32F746_PB2_FUNC_SAI1_SD_A 0x1207
#define STM32F746_PB2_FUNC_SPI3_MOSI_I2S3_SD 0x1208
#define STM32F746_PB2_FUNC_QUADSPI_CLK 0x120a
#define STM32F746_PB2_FUNC_EVENTOUT 0x1210
#define STM32F746_PB2_FUNC_ANALOG 0x1211

#define STM32F746_PB3_FUNC_GPIO 0x1300
#define STM32F746_PB3_FUNC_JTDO_TRACESWO 0x1301
#define STM32F746_PB3_FUNC_TIM2_CH2 0x1302
#define STM32F746_PB3_FUNC_SPI1_SCK_I2S1_CK 0x1306
#define STM32F746_PB3_FUNC_SPI3_SCK_I2S3_CK 0x1307
#define STM32F746_PB3_FUNC_EVENTOUT 0x1310
#define STM32F746_PB3_FUNC_ANALOG 0x1311

#define STM32F746_PB4_FUNC_GPIO 0x1400
#define STM32F746_PB4_FUNC_NJTRST 0x1401
#define STM32F746_PB4_FUNC_TIM3_CH1 0x1403
#define STM32F746_PB4_FUNC_SPI1_MISO 0x1406
#define STM32F746_PB4_FUNC_SPI3_MISO 0x1407
#define STM32F746_PB4_FUNC_SPI2_NSS_I2S2_WS 0x1408
#define STM32F746_PB4_FUNC_EVENTOUT 0x1410
#define STM32F746_PB4_FUNC_ANALOG 0x1411

#define STM32F746_PB5_FUNC_GPIO 0x1500
#define STM32F746_PB5_FUNC_TIM3_CH2 0x1503
#define STM32F746_PB5_FUNC_I2C1_SMBA 0x1505
#define STM32F746_PB5_FUNC_SPI1_MOSI_I2S1_SD 0x1506
#define STM32F746_PB5_FUNC_SPI3_MOSI_I2S3_SD 0x1507
#define STM32F746_PB5_FUNC_CAN2_RX 0x150a
#define STM32F746_PB5_FUNC_OTG_HS_ULPI_D7 0x150b
#define STM32F746_PB5_FUNC_ETH_PPS_OUT 0x150c
#define STM32F746_PB5_FUNC_FMC_SDCKE1 0x150d
#define STM32F746_PB5_FUNC_DCMI_D10 0x150e
#define STM32F746_PB5_FUNC_EVENTOUT 0x1510
#define STM32F746_PB5_FUNC_ANALOG 0x1511

#define STM32F746_PB6_FUNC_GPIO 0x1600
#define STM32F746_PB6_FUNC_TIM4_CH1 0x1603
#define STM32F746_PB6_FUNC_HDMI_CEC 0x1604
#define STM32F746_PB6_FUNC_I2C1_SCL 0x1605
#define STM32F746_PB6_FUNC_USART1_TX 0x1608
#define STM32F746_PB6_FUNC_CAN2_TX 0x160a
#define STM32F746_PB6_FUNC_QUADSPI_BK1_NCS 0x160b
#define STM32F746_PB6_FUNC_FMC_SDNE1 0x160d
#define STM32F746_PB6_FUNC_DCMI_D5 0x160e
#define STM32F746_PB6_FUNC_EVENTOUT 0x1610
#define STM32F746_PB6_FUNC_ANALOG 0x1611

#define STM32F746_PB7_FUNC_GPIO 0x1700
#define STM32F746_PB7_FUNC_TIM4_CH2 0x1703
#define STM32F746_PB7_FUNC_I2C1_SDA 0x1705
#define STM32F746_PB7_FUNC_USART1_RX 0x1708
#define STM32F746_PB7_FUNC_FMC_NL 0x170d
#define STM32F746_PB7_FUNC_DCMI_VSYNC 0x170e
#define STM32F746_PB7_FUNC_EVENTOUT 0x1710
#define STM32F746_PB7_FUNC_ANALOG 0x1711

#define STM32F746_PB8_FUNC_GPIO 0x1800
#define STM32F746_PB8_FUNC_TIM4_CH3 0x1803
#define STM32F746_PB8_FUNC_TIM10_CH1 0x1804
#define STM32F746_PB8_FUNC_I2C1_SCL 0x1805
#define STM32F746_PB8_FUNC_CAN1_RX 0x180a
#define STM32F746_PB8_FUNC_ETH_MII_TXD3 0x180c
#define STM32F746_PB8_FUNC_SDMMC1_D4 0x180d
#define STM32F746_PB8_FUNC_DCMI_D6 0x180e
#define STM32F746_PB8_FUNC_LCD_B6 0x180f
#define STM32F746_PB8_FUNC_EVENTOUT 0x1810
#define STM32F746_PB8_FUNC_ANALOG 0x1811

#define STM32F746_PB9_FUNC_GPIO 0x1900
#define STM32F746_PB9_FUNC_TIM4_CH4 0x1903
#define STM32F746_PB9_FUNC_TIM11_CH1 0x1904
#define STM32F746_PB9_FUNC_I2C1_SDA 0x1905
#define STM32F746_PB9_FUNC_SPI2_NSS_I2S2_WS 0x1906
#define STM32F746_PB9_FUNC_CAN1_TX 0x190a
#define STM32F746_PB9_FUNC_SDMMC1_D5 0x190d
#define STM32F746_PB9_FUNC_DCMI_D7 0x190e
#define STM32F746_PB9_FUNC_LCD_B7 0x190f
#define STM32F746_PB9_FUNC_EVENTOUT 0x1910
#define STM32F746_PB9_FUNC_ANALOG 0x1911

#define STM32F746_PB10_FUNC_GPIO 0x1a00
#define STM32F746_PB10_FUNC_TIM2_CH3 0x1a02
#define STM32F746_PB10_FUNC_I2C2_SCL 0x1a05
#define STM32F746_PB10_FUNC_SPI2_SCK_I2S2_CK 0x1a06
#define STM32F746_PB10_FUNC_USART3_TX 0x1a08
#define STM32F746_PB10_FUNC_OTG_HS_ULPI_D3 0x1a0b
#define STM32F746_PB10_FUNC_ETH_MII_RX_ER 0x1a0c
#define STM32F746_PB10_FUNC_LCD_G4 0x1a0f
#define STM32F746_PB10_FUNC_EVENTOUT 0x1a10
#define STM32F746_PB10_FUNC_ANALOG 0x1a11

#define STM32F746_PB11_FUNC_GPIO 0x1b00
#define STM32F746_PB11_FUNC_TIM2_CH4 0x1b02
#define STM32F746_PB11_FUNC_I2C2_SDA 0x1b05
#define STM32F746_PB11_FUNC_USART3_RX 0x1b08
#define STM32F746_PB11_FUNC_OTG_HS_ULPI_D4 0x1b0b
#define STM32F746_PB11_FUNC_ETH_MII_TX_EN_ETH_RMII_TX_EN 0x1b0c
#define STM32F746_PB11_FUNC_LCD_G5 0x1b0f
#define STM32F746_PB11_FUNC_EVENTOUT 0x1b10
#define STM32F746_PB11_FUNC_ANALOG 0x1b11

#define STM32F746_PB12_FUNC_GPIO 0x1c00
#define STM32F746_PB12_FUNC_TIM1_BKIN 0x1c02
#define STM32F746_PB12_FUNC_I2C2_SMBA 0x1c05
#define STM32F746_PB12_FUNC_SPI2_NSS_I2S2_WS 0x1c06
#define STM32F746_PB12_FUNC_USART3_CK 0x1c08
#define STM32F746_PB12_FUNC_CAN2_RX 0x1c0a
#define STM32F746_PB12_FUNC_OTG_HS_ULPI_D5 0x1c0b
#define STM32F746_PB12_FUNC_ETH_MII_TXD0_ETH_RMII_TXD0 0x1c0c
#define STM32F746_PB12_FUNC_OTG_HS_ID 0x1c0d
#define STM32F746_PB12_FUNC_EVENTOUT 0x1c10
#define STM32F746_PB12_FUNC_ANALOG 0x1c11

#define STM32F746_PB13_FUNC_GPIO 0x1d00
#define STM32F746_PB13_FUNC_TIM1_CH1N 0x1d02
#define STM32F746_PB13_FUNC_SPI2_SCK_I2S2_CK 0x1d06
#define STM32F746_PB13_FUNC_USART3_CTS 0x1d08
#define STM32F746_PB13_FUNC_CAN2_TX 0x1d0a
#define STM32F746_PB13_FUNC_OTG_HS_ULPI_D6 0x1d0b
#define STM32F746_PB13_FUNC_ETH_MII_TXD1_ETH_RMII_TXD1 0x1d0c
#define STM32F746_PB13_FUNC_EVENTOUT 0x1d10
#define STM32F746_PB13_FUNC_ANALOG 0x1d11

#define STM32F746_PB14_FUNC_GPIO 0x1e00
#define STM32F746_PB14_FUNC_TIM1_CH2N 0x1e02
#define STM32F746_PB14_FUNC_TIM8_CH2N 0x1e04
#define STM32F746_PB14_FUNC_SPI2_MISO 0x1e06
#define STM32F746_PB14_FUNC_USART3_RTS 0x1e08
#define STM32F746_PB14_FUNC_TIM12_CH1 0x1e0a
#define STM32F746_PB14_FUNC_OTG_HS_DM 0x1e0d
#define STM32F746_PB14_FUNC_EVENTOUT 0x1e10
#define STM32F746_PB14_FUNC_ANALOG 0x1e11

#define STM32F746_PB15_FUNC_GPIO 0x1f00
#define STM32F746_PB15_FUNC_RTC_REFIN 0x1f01
#define STM32F746_PB15_FUNC_TIM1_CH3N 0x1f02
#define STM32F746_PB15_FUNC_TIM8_CH3N 0x1f04
#define STM32F746_PB15_FUNC_SPI2_MOSI_I2S2_SD 0x1f06
#define STM32F746_PB15_FUNC_TIM12_CH2 0x1f0a
#define STM32F746_PB15_FUNC_OTG_HS_DP 0x1f0d
#define STM32F746_PB15_FUNC_EVENTOUT 0x1f10
#define STM32F746_PB15_FUNC_ANALOG 0x1f11


#define STM32F746_PC0_FUNC_GPIO 0x2000
#define STM32F746_PC0_FUNC_SAI2_FS_B 0x2009
#define STM32F746_PC0_FUNC_OTG_HS_ULPI_STP 0x200b
#define STM32F746_PC0_FUNC_FMC_SDNWE 0x200d
#define STM32F746_PC0_FUNC_LCD_R5 0x200f
#define STM32F746_PC0_FUNC_EVENTOUT 0x2010
#define STM32F746_PC0_FUNC_ANALOG 0x2011

#define STM32F746_PC1_FUNC_GPIO 0x2100
#define STM32F746_PC1_FUNC_TRACED0 0x2101
#define STM32F746_PC1_FUNC_SPI2_MOSI_I2S2_SD 0x2106
#define STM32F746_PC1_FUNC_SAI1_SD_A 0x2107
#define STM32F746_PC1_FUNC_ETH_MDC 0x210c
#define STM32F746_PC1_FUNC_EVENTOUT 0x2110
#define STM32F746_PC1_FUNC_ANALOG 0x2111

#define STM32F746_PC2_FUNC_GPIO 0x2200
#define STM32F746_PC2_FUNC_SPI2_MISO 0x2206
#define STM32F746_PC2_FUNC_OTG_HS_ULPI_DIR 0x220b
#define STM32F746_PC2_FUNC_ETH_MII_TXD2 0x220c
#define STM32F746_PC2_FUNC_FMC_SDNE0 0x220d
#define STM32F746_PC2_FUNC_EVENTOUT 0x2210
#define STM32F746_PC2_FUNC_ANALOG 0x2211

#define STM32F746_PC3_FUNC_GPIO 0x2300
#define STM32F746_PC3_FUNC_SPI2_MOSI_I2S2_SD 0x2306
#define STM32F746_PC3_FUNC_OTG_HS_ULPI_NXT 0x230b
#define STM32F746_PC3_FUNC_ETH_MII_TX_CLK 0x230c
#define STM32F746_PC3_FUNC_FMC_SDCKE0 0x230d
#define STM32F746_PC3_FUNC_EVENTOUT 0x2310
#define STM32F746_PC3_FUNC_ANALOG 0x2311

#define STM32F746_PC4_FUNC_GPIO 0x2400
#define STM32F746_PC4_FUNC_I2S1_MCK 0x2406
#define STM32F746_PC4_FUNC_SPDIFRX_IN2 0x2409
#define STM32F746_PC4_FUNC_ETH_MII_RXD0_ETH_RMII_RXD0 0x240c
#define STM32F746_PC4_FUNC_FMC_SDNE0 0x240d
#define STM32F746_PC4_FUNC_EVENTOUT 0x2410
#define STM32F746_PC4_FUNC_ANALOG 0x2411

#define STM32F746_PC5_FUNC_GPIO 0x2500
#define STM32F746_PC5_FUNC_SPDIFRX_IN3 0x2509
#define STM32F746_PC5_FUNC_ETH_MII_RXD1_ETH_RMII_RXD1 0x250c
#define STM32F746_PC5_FUNC_FMC_SDCKE0 0x250d
#define STM32F746_PC5_FUNC_EVENTOUT 0x2510
#define STM32F746_PC5_FUNC_ANALOG 0x2511

#define STM32F746_PC6_FUNC_GPIO 0x2600
#define STM32F746_PC6_FUNC_TIM3_CH1 0x2603
#define STM32F746_PC6_FUNC_TIM8_CH1 0x2604
#define STM32F746_PC6_FUNC_I2S2_MCK 0x2606
#define STM32F746_PC6_FUNC_USART6_TX 0x2609
#define STM32F746_PC6_FUNC_SDMMC1_D6 0x260d
#define STM32F746_PC6_FUNC_DCMI_D0 0x260e
#define STM32F746_PC6_FUNC_LCD_HSYNC 0x260f
#define STM32F746_PC6_FUNC_EVENTOUT 0x2610
#define STM32F746_PC6_FUNC_ANALOG 0x2611

#define STM32F746_PC7_FUNC_GPIO 0x2700
#define STM32F746_PC7_FUNC_TIM3_CH2 0x2703
#define STM32F746_PC7_FUNC_TIM8_CH2 0x2704
#define STM32F746_PC7_FUNC_I2S3_MCK 0x2707
#define STM32F746_PC7_FUNC_USART6_RX 0x2709
#define STM32F746_PC7_FUNC_SDMMC1_D7 0x270d
#define STM32F746_PC7_FUNC_DCMI_D1 0x270e
#define STM32F746_PC7_FUNC_LCD_G6 0x270f
#define STM32F746_PC7_FUNC_EVENTOUT 0x2710
#define STM32F746_PC7_FUNC_ANALOG 0x2711

#define STM32F746_PC8_FUNC_GPIO 0x2800
#define STM32F746_PC8_FUNC_TRACED1 0x2801
#define STM32F746_PC8_FUNC_TIM3_CH3 0x2803
#define STM32F746_PC8_FUNC_TIM8_CH3 0x2804
#define STM32F746_PC8_FUNC_UART5_RTS 0x2808
#define STM32F746_PC8_FUNC_USART6_CK 0x2809
#define STM32F746_PC8_FUNC_SDMMC1_D0 0x280d
#define STM32F746_PC8_FUNC_DCMI_D2 0x280e
#define STM32F746_PC8_FUNC_EVENTOUT 0x2810
#define STM32F746_PC8_FUNC_ANALOG 0x2811

#define STM32F746_PC9_FUNC_GPIO 0x2900
#define STM32F746_PC9_FUNC_MCO2 0x2901
#define STM32F746_PC9_FUNC_TIM3_CH4 0x2903
#define STM32F746_PC9_FUNC_TIM8_CH4 0x2904
#define STM32F746_PC9_FUNC_I2C3_SDA 0x2905
#define STM32F746_PC9_FUNC_I2S_CKIN 0x2906
#define STM32F746_PC9_FUNC_UART5_CTS 0x2908
#define STM32F746_PC9_FUNC_QUADSPI_BK1_IO0 0x290a
#define STM32F746_PC9_FUNC_SDMMC1_D1 0x290d
#define STM32F746_PC9_FUNC_DCMI_D3 0x290e
#define STM32F746_PC9_FUNC_EVENTOUT 0x2910
#define STM32F746_PC9_FUNC_ANALOG 0x2911

#define STM32F746_PC10_FUNC_GPIO 0x2a00
#define STM32F746_PC10_FUNC_SPI3_SCK_I2S3_CK 0x2a07
#define STM32F746_PC10_FUNC_USART3_TX 0x2a08
#define STM32F746_PC10_FUNC_UART4_TX 0x2a09
#define STM32F746_PC10_FUNC_QUADSPI_BK1_IO1 0x2a0a
#define STM32F746_PC10_FUNC_SDMMC1_D2 0x2a0d
#define STM32F746_PC10_FUNC_DCMI_D8 0x2a0e
#define STM32F746_PC10_FUNC_LCD_R2 0x2a0f
#define STM32F746_PC10_FUNC_EVENTOUT 0x2a10
#define STM32F746_PC10_FUNC_ANALOG 0x2a11

#define STM32F746_PC11_FUNC_GPIO 0x2b00
#define STM32F746_PC11_FUNC_SPI3_MISO 0x2b07
#define STM32F746_PC11_FUNC_USART3_RX 0x2b08
#define STM32F746_PC11_FUNC_UART4_RX 0x2b09
#define STM32F746_PC11_FUNC_QUADSPI_BK2_NCS 0x2b0a
#define STM32F746_PC11_FUNC_SDMMC1_D3 0x2b0d
#define STM32F746_PC11_FUNC_DCMI_D4 0x2b0e
#define STM32F746_PC11_FUNC_EVENTOUT 0x2b10
#define STM32F746_PC11_FUNC_ANALOG 0x2b11

#define STM32F746_PC12_FUNC_GPIO 0x2c00
#define STM32F746_PC12_FUNC_TRACED3 0x2c01
#define STM32F746_PC12_FUNC_SPI3_MOSI_I2S3_SD 0x2c07
#define STM32F746_PC12_FUNC_USART3_CK 0x2c08
#define STM32F746_PC12_FUNC_UART5_TX 0x2c09
#define STM32F746_PC12_FUNC_SDMMC1_CK 0x2c0d
#define STM32F746_PC12_FUNC_DCMI_D9 0x2c0e
#define STM32F746_PC12_FUNC_EVENTOUT 0x2c10
#define STM32F746_PC12_FUNC_ANALOG 0x2c11

#define STM32F746_PC13_FUNC_GPIO 0x2d00
#define STM32F746_PC13_FUNC_EVENTOUT 0x2d10
#define STM32F746_PC13_FUNC_ANALOG 0x2d11

#define STM32F746_PC14_FUNC_GPIO 0x2e00
#define STM32F746_PC14_FUNC_EVENTOUT 0x2e10
#define STM32F746_PC14_FUNC_ANALOG 0x2e11

#define STM32F746_PC15_FUNC_GPIO 0x2f00
#define STM32F746_PC15_FUNC_EVENTOUT 0x2f10
#define STM32F746_PC15_FUNC_ANALOG 0x2f11


#define STM32F746_PD0_FUNC_GPIO 0x3000
#define STM32F746_PD0_FUNC_CAN1_RX 0x300a
#define STM32F746_PD0_FUNC_FMC_D2 0x300d
#define STM32F746_PD0_FUNC_EVENTOUT 0x3010
#define STM32F746_PD0_FUNC_ANALOG 0x3011

#define STM32F746_PD1_FUNC_GPIO 0x3100
#define STM32F746_PD1_FUNC_CAN1_TX 0x310a
#define STM32F746_PD1_FUNC_FMC_D3 0x310d
#define STM32F746_PD1_FUNC_EVENTOUT 0x3110
#define STM32F746_PD1_FUNC_ANALOG 0x3111

#define STM32F746_PD2_FUNC_GPIO 0x3200
#define STM32F746_PD2_FUNC_TRACED2 0x3201
#define STM32F746_PD2_FUNC_TIM3_ETR 0x3203
#define STM32F746_PD2_FUNC_UART5_RX 0x3209
#define STM32F746_PD2_FUNC_SDMMC1_CMD 0x320d
#define STM32F746_PD2_FUNC_DCMI_D11 0x320e
#define STM32F746_PD2_FUNC_EVENTOUT 0x3210
#define STM32F746_PD2_FUNC_ANALOG 0x3211

#define STM32F746_PD3_FUNC_GPIO 0x3300
#define STM32F746_PD3_FUNC_SPI2_SCK_I2S2_CK 0x3306
#define STM32F746_PD3_FUNC_USART2_CTS 0x3308
#define STM32F746_PD3_FUNC_FMC_CLK 0x330d
#define STM32F746_PD3_FUNC_DCMI_D5 0x330e
#define STM32F746_PD3_FUNC_LCD_G7 0x330f
#define STM32F746_PD3_FUNC_EVENTOUT 0x3310
#define STM32F746_PD3_FUNC_ANALOG 0x3311

#define STM32F746_PD4_FUNC_GPIO 0x3400
#define STM32F746_PD4_FUNC_USART2_RTS 0x3408
#define STM32F746_PD4_FUNC_FMC_NOE 0x340d
#define STM32F746_PD4_FUNC_EVENTOUT 0x3410
#define STM32F746_PD4_FUNC_ANALOG 0x3411

#define STM32F746_PD5_FUNC_GPIO 0x3500
#define STM32F746_PD5_FUNC_USART2_TX 0x3508
#define STM32F746_PD5_FUNC_FMC_NWE 0x350d
#define STM32F746_PD5_FUNC_EVENTOUT 0x3510
#define STM32F746_PD5_FUNC_ANALOG 0x3511

#define STM32F746_PD6_FUNC_GPIO 0x3600
#define STM32F746_PD6_FUNC_SPI3_MOSI_I2S3_SD 0x3606
#define STM32F746_PD6_FUNC_SAI1_SD_A 0x3607
#define STM32F746_PD6_FUNC_USART2_RX 0x3608
#define STM32F746_PD6_FUNC_FMC_NWAIT 0x360d
#define STM32F746_PD6_FUNC_DCMI_D10 0x360e
#define STM32F746_PD6_FUNC_LCD_B2 0x360f
#define STM32F746_PD6_FUNC_EVENTOUT 0x3610
#define STM32F746_PD6_FUNC_ANALOG 0x3611

#define STM32F746_PD7_FUNC_GPIO 0x3700
#define STM32F746_PD7_FUNC_USART2_CK 0x3708
#define STM32F746_PD7_FUNC_SPDIFRX_IN0 0x3709
#define STM32F746_PD7_FUNC_FMC_NE1 0x370d
#define STM32F746_PD7_FUNC_EVENTOUT 0x3710
#define STM32F746_PD7_FUNC_ANALOG 0x3711

#define STM32F746_PD8_FUNC_GPIO 0x3800
#define STM32F746_PD8_FUNC_USART3_TX 0x3808
#define STM32F746_PD8_FUNC_SPDIFRX_IN1 0x3809
#define STM32F746_PD8_FUNC_FMC_D13 0x380d
#define STM32F746_PD8_FUNC_EVENTOUT 0x3810
#define STM32F746_PD8_FUNC_ANALOG 0x3811

#define STM32F746_PD9_FUNC_GPIO 0x3900
#define STM32F746_PD9_FUNC_USART3_RX 0x3908
#define STM32F746_PD9_FUNC_FMC_D14 0x390d
#define STM32F746_PD9_FUNC_EVENTOUT 0x3910
#define STM32F746_PD9_FUNC_ANALOG 0x3911

#define STM32F746_PD10_FUNC_GPIO 0x3a00
#define STM32F746_PD10_FUNC_USART3_CK 0x3a08
#define STM32F746_PD10_FUNC_FMC_D15 0x3a0d
#define STM32F746_PD10_FUNC_LCD_B3 0x3a0f
#define STM32F746_PD10_FUNC_EVENTOUT 0x3a10
#define STM32F746_PD10_FUNC_ANALOG 0x3a11

#define STM32F746_PD11_FUNC_GPIO 0x3b00
#define STM32F746_PD11_FUNC_I2C4_SMBA 0x3b05
#define STM32F746_PD11_FUNC_USART3_CTS 0x3b08
#define STM32F746_PD11_FUNC_QUADSPI_BK1_IO0 0x3b0a
#define STM32F746_PD11_FUNC_SAI2_SD_A 0x3b0b
#define STM32F746_PD11_FUNC_FMC_A16_FMC_CLE 0x3b0d
#define STM32F746_PD11_FUNC_EVENTOUT 0x3b10
#define STM32F746_PD11_FUNC_ANALOG 0x3b11

#define STM32F746_PD12_FUNC_GPIO 0x3c00
#define STM32F746_PD12_FUNC_TIM4_CH1 0x3c03
#define STM32F746_PD12_FUNC_LPTIM1_IN1 0x3c04
#define STM32F746_PD12_FUNC_I2C4_SCL 0x3c05
#define STM32F746_PD12_FUNC_USART3_RTS 0x3c08
#define STM32F746_PD12_FUNC_QUADSPI_BK1_IO1 0x3c0a
#define STM32F746_PD12_FUNC_SAI2_FS_A 0x3c0b
#define STM32F746_PD12_FUNC_FMC_A17_FMC_ALE 0x3c0d
#define STM32F746_PD12_FUNC_EVENTOUT 0x3c10
#define STM32F746_PD12_FUNC_ANALOG 0x3c11

#define STM32F746_PD13_FUNC_GPIO 0x3d00
#define STM32F746_PD13_FUNC_TIM4_CH2 0x3d03
#define STM32F746_PD13_FUNC_LPTIM1_OUT 0x3d04
#define STM32F746_PD13_FUNC_I2C4_SDA 0x3d05
#define STM32F746_PD13_FUNC_QUADSPI_BK1_IO3 0x3d0a
#define STM32F746_PD13_FUNC_SAI2_SCK_A 0x3d0b
#define STM32F746_PD13_FUNC_FMC_A18 0x3d0d
#define STM32F746_PD13_FUNC_EVENTOUT 0x3d10
#define STM32F746_PD13_FUNC_ANALOG 0x3d11

#define STM32F746_PD14_FUNC_GPIO 0x3e00
#define STM32F746_PD14_FUNC_TIM4_CH3 0x3e03
#define STM32F746_PD14_FUNC_UART8_CTS 0x3e09
#define STM32F746_PD14_FUNC_FMC_D0 0x3e0d
#define STM32F746_PD14_FUNC_EVENTOUT 0x3e10
#define STM32F746_PD14_FUNC_ANALOG 0x3e11

#define STM32F746_PD15_FUNC_GPIO 0x3f00
#define STM32F746_PD15_FUNC_TIM4_CH4 0x3f03
#define STM32F746_PD15_FUNC_UART8_RTS 0x3f09
#define STM32F746_PD15_FUNC_FMC_D1 0x3f0d
#define STM32F746_PD15_FUNC_EVENTOUT 0x3f10
#define STM32F746_PD15_FUNC_ANALOG 0x3f11


#define STM32F746_PE0_FUNC_GPIO 0x4000
#define STM32F746_PE0_FUNC_TIM4_ETR 0x4003
#define STM32F746_PE0_FUNC_LPTIM1_ETR 0x4004
#define STM32F746_PE0_FUNC_UART8_RX 0x4009
#define STM32F746_PE0_FUNC_SAI2_MCLK_A 0x400b
#define STM32F746_PE0_FUNC_FMC_NBL0 0x400d
#define STM32F746_PE0_FUNC_DCMI_D2 0x400e
#define STM32F746_PE0_FUNC_EVENTOUT 0x4010
#define STM32F746_PE0_FUNC_ANALOG 0x4011

#define STM32F746_PE1_FUNC_GPIO 0x4100
#define STM32F746_PE1_FUNC_LPTIM1_IN2 0x4104
#define STM32F746_PE1_FUNC_UART8_TX 0x4109
#define STM32F746_PE1_FUNC_FMC_NBL1 0x410d
#define STM32F746_PE1_FUNC_DCMI_D3 0x410e
#define STM32F746_PE1_FUNC_EVENTOUT 0x4110
#define STM32F746_PE1_FUNC_ANALOG 0x4111

#define STM32F746_PE2_FUNC_GPIO 0x4200
#define STM32F746_PE2_FUNC_TRACECLK 0x4201
#define STM32F746_PE2_FUNC_SPI4_SCK 0x4206
#define STM32F746_PE2_FUNC_SAI1_MCLK_A 0x4207
#define STM32F746_PE2_FUNC_QUADSPI_BK1_IO2 0x420a
#define STM32F746_PE2_FUNC_ETH_MII_TXD3 0x420c
#define STM32F746_PE2_FUNC_FMC_A23 0x420d
#define STM32F746_PE2_FUNC_EVENTOUT 0x4210
#define STM32F746_PE2_FUNC_ANALOG 0x4211

#define STM32F746_PE3_FUNC_GPIO 0x4300
#define STM32F746_PE3_FUNC_TRACED0 0x4301
#define STM32F746_PE3_FUNC_SAI1_SD_B 0x4307
#define STM32F746_PE3_FUNC_FMC_A19 0x430d
#define STM32F746_PE3_FUNC_EVENTOUT 0x4310
#define STM32F746_PE3_FUNC_ANALOG 0x4311

#define STM32F746_PE4_FUNC_GPIO 0x4400
#define STM32F746_PE4_FUNC_TRACED1 0x4401
#define STM32F746_PE4_FUNC_SPI4_NSS 0x4406
#define STM32F746_PE4_FUNC_SAI1_FS_A 0x4407
#define STM32F746_PE4_FUNC_FMC_A20 0x440d
#define STM32F746_PE4_FUNC_DCMI_D4 0x440e
#define STM32F746_PE4_FUNC_LCD_B0 0x440f
#define STM32F746_PE4_FUNC_EVENTOUT 0x4410
#define STM32F746_PE4_FUNC_ANALOG 0x4411

#define STM32F746_PE5_FUNC_GPIO 0x4500
#define STM32F746_PE5_FUNC_TRACED2 0x4501
#define STM32F746_PE5_FUNC_TIM9_CH1 0x4504
#define STM32F746_PE5_FUNC_SPI4_MISO 0x4506
#define STM32F746_PE5_FUNC_SAI1_SCK_A 0x4507
#define STM32F746_PE5_FUNC_FMC_A21 0x450d
#define STM32F746_PE5_FUNC_DCMI_D6 0x450e
#define STM32F746_PE5_FUNC_LCD_G0 0x450f
#define STM32F746_PE5_FUNC_EVENTOUT 0x4510
#define STM32F746_PE5_FUNC_ANALOG 0x4511

#define STM32F746_PE6_FUNC_GPIO 0x4600
#define STM32F746_PE6_FUNC_TRACED3 0x4601
#define STM32F746_PE6_FUNC_TIM1_BKIN2 0x4602
#define STM32F746_PE6_FUNC_TIM9_CH2 0x4604
#define STM32F746_PE6_FUNC_SPI4_MOSI 0x4606
#define STM32F746_PE6_FUNC_SAI1_SD_A 0x4607
#define STM32F746_PE6_FUNC_SAI2_MCLK_B 0x460b
#define STM32F746_PE6_FUNC_FMC_A22 0x460d
#define STM32F746_PE6_FUNC_DCMI_D7 0x460e
#define STM32F746_PE6_FUNC_LCD_G1 0x460f
#define STM32F746_PE6_FUNC_EVENTOUT 0x4610
#define STM32F746_PE6_FUNC_ANALOG 0x4611

#define STM32F746_PE7_FUNC_GPIO 0x4700
#define STM32F746_PE7_FUNC_TIM1_ETR 0x4702
#define STM32F746_PE7_FUNC_UART7_RX 0x4709
#define STM32F746_PE7_FUNC_QUADSPI_BK2_IO0 0x470b
#define STM32F746_PE7_FUNC_FMC_D4 0x470d
#define STM32F746_PE7_FUNC_EVENTOUT 0x4710
#define STM32F746_PE7_FUNC_ANALOG 0x4711

#define STM32F746_PE8_FUNC_GPIO 0x4800
#define STM32F746_PE8_FUNC_TIM1_CH1N 0x4802
#define STM32F746_PE8_FUNC_UART7_TX 0x4809
#define STM32F746_PE8_FUNC_QUADSPI_BK2_IO1 0x480b
#define STM32F746_PE8_FUNC_FMC_D5 0x480d
#define STM32F746_PE8_FUNC_EVENTOUT 0x4810
#define STM32F746_PE8_FUNC_ANALOG 0x4811

#define STM32F746_PE9_FUNC_GPIO 0x4900
#define STM32F746_PE9_FUNC_TIM1_CH1 0x4902
#define STM32F746_PE9_FUNC_UART7_RTS 0x4909
#define STM32F746_PE9_FUNC_QUADSPI_BK2_IO2 0x490b
#define STM32F746_PE9_FUNC_FMC_D6 0x490d
#define STM32F746_PE9_FUNC_EVENTOUT 0x4910
#define STM32F746_PE9_FUNC_ANALOG 0x4911

#define STM32F746_PE10_FUNC_GPIO 0x4a00
#define STM32F746_PE10_FUNC_TIM1_CH2N 0x4a02
#define STM32F746_PE10_FUNC_UART7_CTS 0x4a09
#define STM32F746_PE10_FUNC_QUADSPI_BK2_IO3 0x4a0b
#define STM32F746_PE10_FUNC_FMC_D7 0x4a0d
#define STM32F746_PE10_FUNC_EVENTOUT 0x4a10
#define STM32F746_PE10_FUNC_ANALOG 0x4a11

#define STM32F746_PE11_FUNC_GPIO 0x4b00
#define STM32F746_PE11_FUNC_TIM1_CH2 0x4b02
#define STM32F746_PE11_FUNC_SPI4_NSS 0x4b06
#define STM32F746_PE11_FUNC_SAI2_SD_B 0x4b0b
#define STM32F746_PE11_FUNC_FMC_D8 0x4b0d
#define STM32F746_PE11_FUNC_LCD_G3 0x4b0f
#define STM32F746_PE11_FUNC_EVENTOUT 0x4b10
#define STM32F746_PE11_FUNC_ANALOG 0x4b11

#define STM32F746_PE12_FUNC_GPIO 0x4c00
#define STM32F746_PE12_FUNC_TIM1_CH3N 0x4c02
#define STM32F746_PE12_FUNC_SPI4_SCK 0x4c06
#define STM32F746_PE12_FUNC_SAI2_SCK_B 0x4c0b
#define STM32F746_PE12_FUNC_FMC_D9 0x4c0d
#define STM32F746_PE12_FUNC_LCD_B4 0x4c0f
#define STM32F746_PE12_FUNC_EVENTOUT 0x4c10
#define STM32F746_PE12_FUNC_ANALOG 0x4c11

#define STM32F746_PE13_FUNC_GPIO 0x4d00
#define STM32F746_PE13_FUNC_TIM1_CH3 0x4d02
#define STM32F746_PE13_FUNC_SPI4_MISO 0x4d06
#define STM32F746_PE13_FUNC_SAI2_FS_B 0x4d0b
#define STM32F746_PE13_FUNC_FMC_D10 0x4d0d
#define STM32F746_PE13_FUNC_LCD_DE 0x4d0f
#define STM32F746_PE13_FUNC_EVENTOUT 0x4d10
#define STM32F746_PE13_FUNC_ANALOG 0x4d11

#define STM32F746_PE14_FUNC_GPIO 0x4e00
#define STM32F746_PE14_FUNC_TIM1_CH4 0x4e02
#define STM32F746_PE14_FUNC_SPI4_MOSI 0x4e06
#define STM32F746_PE14_FUNC_SAI2_MCLK_B 0x4e0b
#define STM32F746_PE14_FUNC_FMC_D11 0x4e0d
#define STM32F746_PE14_FUNC_LCD_CLK 0x4e0f
#define STM32F746_PE14_FUNC_EVENTOUT 0x4e10
#define STM32F746_PE14_FUNC_ANALOG 0x4e11

#define STM32F746_PE15_FUNC_GPIO 0x4f00
#define STM32F746_PE15_FUNC_TIM1_BKIN 0x4f02
#define STM32F746_PE15_FUNC_FMC_D12 0x4f0d
#define STM32F746_PE15_FUNC_LCD_R7 0x4f0f
#define STM32F746_PE15_FUNC_EVENTOUT 0x4f10
#define STM32F746_PE15_FUNC_ANALOG 0x4f11


#define STM32F746_PF0_FUNC_GPIO 0x5000
#define STM32F746_PF0_FUNC_I2C2_SDA 0x5005
#define STM32F746_PF0_FUNC_FMC_A0 0x500d
#define STM32F746_PF0_FUNC_EVENTOUT 0x5010
#define STM32F746_PF0_FUNC_ANALOG 0x5011

#define STM32F746_PF1_FUNC_GPIO 0x5100
#define STM32F746_PF1_FUNC_I2C2_SCL 0x5105
#define STM32F746_PF1_FUNC_FMC_A1 0x510d
#define STM32F746_PF1_FUNC_EVENTOUT 0x5110
#define STM32F746_PF1_FUNC_ANALOG 0x5111

#define STM32F746_PF2_FUNC_GPIO 0x5200
#define STM32F746_PF2_FUNC_I2C2_SMBA 0x5205
#define STM32F746_PF2_FUNC_FMC_A2 0x520d
#define STM32F746_PF2_FUNC_EVENTOUT 0x5210
#define STM32F746_PF2_FUNC_ANALOG 0x5211

#define STM32F746_PF3_FUNC_GPIO 0x5300
#define STM32F746_PF3_FUNC_FMC_A3 0x530d
#define STM32F746_PF3_FUNC_EVENTOUT 0x5310
#define STM32F746_PF3_FUNC_ANALOG 0x5311

#define STM32F746_PF4_FUNC_GPIO 0x5400
#define STM32F746_PF4_FUNC_FMC_A4 0x540d
#define STM32F746_PF4_FUNC_EVENTOUT 0x5410
#define STM32F746_PF4_FUNC_ANALOG 0x5411

#define STM32F746_PF5_FUNC_GPIO 0x5500
#define STM32F746_PF5_FUNC_FMC_A5 0x550d
#define STM32F746_PF5_FUNC_EVENTOUT 0x5510
#define STM32F746_PF5_FUNC_ANALOG 0x5511

#define STM32F746_PF6_FUNC_GPIO 0x5600
#define STM32F746_PF6_FUNC_TIM10_CH1 0x5604
#define STM32F746_PF6_FUNC_SPI5_NSS 0x5606
#define STM32F746_PF6_FUNC_SAI1_SD_B 0x5607
#define STM32F746_PF6_FUNC_UART7_RX 0x5609
#define STM32F746_PF6_FUNC_QUADSPI_BK1_IO3 0x560a
#define STM32F746_PF6_FUNC_EVENTOUT 0x5610
#define STM32F746_PF6_FUNC_ANALOG 0x5611

#define STM32F746_PF7_FUNC_GPIO 0x5700
#define STM32F746_PF7_FUNC_TIM11_CH1 0x5704
#define STM32F746_PF7_FUNC_SPI5_SCK 0x5706
#define STM32F746_PF7_FUNC_SAI1_MCLK_B 0x5707
#define STM32F746_PF7_FUNC_UART7_TX 0x5709
#define STM32F746_PF7_FUNC_QUADSPI_BK1_IO2 0x570a
#define STM32F746_PF7_FUNC_EVENTOUT 0x5710
#define STM32F746_PF7_FUNC_ANALOG 0x5711

#define STM32F746_PF8_FUNC_GPIO 0x5800
#define STM32F746_PF8_FUNC_SPI5_MISO 0x5806
#define STM32F746_PF8_FUNC_SAI1_SCK_B 0x5807
#define STM32F746_PF8_FUNC_UART7_RTS 0x5809
#define STM32F746_PF8_FUNC_TIM13_CH1 0x580a
#define STM32F746_PF8_FUNC_QUADSPI_BK1_IO0 0x580b
#define STM32F746_PF8_FUNC_EVENTOUT 0x5810
#define STM32F746_PF8_FUNC_ANALOG 0x5811

#define STM32F746_PF9_FUNC_GPIO 0x5900
#define STM32F746_PF9_FUNC_SPI5_MOSI 0x5906
#define STM32F746_PF9_FUNC_SAI1_FS_B 0x5907
#define STM32F746_PF9_FUNC_UART7_CTS 0x5909
#define STM32F746_PF9_FUNC_TIM14_CH1 0x590a
#define STM32F746_PF9_FUNC_QUADSPI_BK1_IO1 0x590b
#define STM32F746_PF9_FUNC_EVENTOUT 0x5910
#define STM32F746_PF9_FUNC_ANALOG 0x5911

#define STM32F746_PF10_FUNC_GPIO 0x5a00
#define STM32F746_PF10_FUNC_DCMI_D11 0x5a0e
#define STM32F746_PF10_FUNC_LCD_DE 0x5a0f
#define STM32F746_PF10_FUNC_EVENTOUT 0x5a10
#define STM32F746_PF10_FUNC_ANALOG 0x5a11

#define STM32F746_PF11_FUNC_GPIO 0x5b00
#define STM32F746_PF11_FUNC_SPI5_MOSI 0x5b06
#define STM32F746_PF11_FUNC_SAI2_SD_B 0x5b0b
#define STM32F746_PF11_FUNC_FMC_SDNRAS 0x5b0d
#define STM32F746_PF11_FUNC_DCMI_D12 0x5b0e
#define STM32F746_PF11_FUNC_EVENTOUT 0x5b10
#define STM32F746_PF11_FUNC_ANALOG 0x5b11

#define STM32F746_PF12_FUNC_GPIO 0x5c00
#define STM32F746_PF12_FUNC_FMC_A6 0x5c0d
#define STM32F746_PF12_FUNC_EVENTOUT 0x5c10
#define STM32F746_PF12_FUNC_ANALOG 0x5c11

#define STM32F746_PF13_FUNC_GPIO 0x5d00
#define STM32F746_PF13_FUNC_I2C4_SMBA 0x5d05
#define STM32F746_PF13_FUNC_FMC_A7 0x5d0d
#define STM32F746_PF13_FUNC_EVENTOUT 0x5d10
#define STM32F746_PF13_FUNC_ANALOG 0x5d11

#define STM32F746_PF14_FUNC_GPIO 0x5e00
#define STM32F746_PF14_FUNC_I2C4_SCL 0x5e05
#define STM32F746_PF14_FUNC_FMC_A8 0x5e0d
#define STM32F746_PF14_FUNC_EVENTOUT 0x5e10
#define STM32F746_PF14_FUNC_ANALOG 0x5e11

#define STM32F746_PF15_FUNC_GPIO 0x5f00
#define STM32F746_PF15_FUNC_I2C4_SDA 0x5f05
#define STM32F746_PF15_FUNC_FMC_A9 0x5f0d
#define STM32F746_PF15_FUNC_EVENTOUT 0x5f10
#define STM32F746_PF15_FUNC_ANALOG 0x5f11


#define STM32F746_PG0_FUNC_GPIO 0x6000
#define STM32F746_PG0_FUNC_FMC_A10 0x600d
#define STM32F746_PG0_FUNC_EVENTOUT 0x6010
#define STM32F746_PG0_FUNC_ANALOG 0x6011

#define STM32F746_PG1_FUNC_GPIO 0x6100
#define STM32F746_PG1_FUNC_FMC_A11 0x610d
#define STM32F746_PG1_FUNC_EVENTOUT 0x6110
#define STM32F746_PG1_FUNC_ANALOG 0x6111

#define STM32F746_PG2_FUNC_GPIO 0x6200
#define STM32F746_PG2_FUNC_FMC_A12 0x620d
#define STM32F746_PG2_FUNC_EVENTOUT 0x6210
#define STM32F746_PG2_FUNC_ANALOG 0x6211

#define STM32F746_PG3_FUNC_GPIO 0x6300
#define STM32F746_PG3_FUNC_FMC_A13 0x630d
#define STM32F746_PG3_FUNC_EVENTOUT 0x6310
#define STM32F746_PG3_FUNC_ANALOG 0x6311

#define STM32F746_PG4_FUNC_GPIO 0x6400
#define STM32F746_PG4_FUNC_FMC_A14_FMC_BA0 0x640d
#define STM32F746_PG4_FUNC_EVENTOUT 0x6410
#define STM32F746_PG4_FUNC_ANALOG 0x6411

#define STM32F746_PG5_FUNC_GPIO 0x6500
#define STM32F746_PG5_FUNC_FMC_A15_FMC_BA1 0x650d
#define STM32F746_PG5_FUNC_EVENTOUT 0x6510
#define STM32F746_PG5_FUNC_ANALOG 0x6511

#define STM32F746_PG6_FUNC_GPIO 0x6600
#define STM32F746_PG6_FUNC_DCMI_D12 0x660e
#define STM32F746_PG6_FUNC_LCD_R7 0x660f
#define STM32F746_PG6_FUNC_EVENTOUT 0x6610
#define STM32F746_PG6_FUNC_ANALOG 0x6611

#define STM32F746_PG7_FUNC_GPIO 0x6700
#define STM32F746_PG7_FUNC_USART6_CK 0x6709
#define STM32F746_PG7_FUNC_FMC_INT 0x670d
#define STM32F746_PG7_FUNC_DCMI_D13 0x670e
#define STM32F746_PG7_FUNC_LCD_CLK 0x670f
#define STM32F746_PG7_FUNC_EVENTOUT 0x6710
#define STM32F746_PG7_FUNC_ANALOG 0x6711

#define STM32F746_PG8_FUNC_GPIO 0x6800
#define STM32F746_PG8_FUNC_SPI6_NSS 0x6806
#define STM32F746_PG8_FUNC_SPDIFRX_IN2 0x6808
#define STM32F746_PG8_FUNC_USART6_RTS 0x6809
#define STM32F746_PG8_FUNC_ETH_PPS_OUT 0x680c
#define STM32F746_PG8_FUNC_FMC_SDCLK 0x680d
#define STM32F746_PG8_FUNC_EVENTOUT 0x6810
#define STM32F746_PG8_FUNC_ANALOG 0x6811

#define STM32F746_PG9_FUNC_GPIO 0x6900
#define STM32F746_PG9_FUNC_SPDIFRX_IN3 0x6908
#define STM32F746_PG9_FUNC_USART6_RX 0x6909
#define STM32F746_PG9_FUNC_QUADSPI_BK2_IO2 0x690a
#define STM32F746_PG9_FUNC_SAI2_FS_B 0x690b
#define STM32F746_PG9_FUNC_FMC_NE2_FMC_NCE 0x690d
#define STM32F746_PG9_FUNC_DCMI_VSYNC 0x690e
#define STM32F746_PG9_FUNC_EVENTOUT 0x6910
#define STM32F746_PG9_FUNC_ANALOG 0x6911

#define STM32F746_PG10_FUNC_GPIO 0x6a00
#define STM32F746_PG10_FUNC_LCD_G3 0x6a0a
#define STM32F746_PG10_FUNC_SAI2_SD_B 0x6a0b
#define STM32F746_PG10_FUNC_FMC_NE3 0x6a0d
#define STM32F746_PG10_FUNC_DCMI_D2 0x6a0e
#define STM32F746_PG10_FUNC_LCD_B2 0x6a0f
#define STM32F746_PG10_FUNC_EVENTOUT 0x6a10
#define STM32F746_PG10_FUNC_ANALOG 0x6a11

#define STM32F746_PG11_FUNC_GPIO 0x6b00
#define STM32F746_PG11_FUNC_SPDIFRX_IN0 0x6b08
#define STM32F746_PG11_FUNC_ETH_MII_TX_EN_ETH_RMII_TX_EN 0x6b0c
#define STM32F746_PG11_FUNC_DCMI_D3 0x6b0e
#define STM32F746_PG11_FUNC_LCD_B3 0x6b0f
#define STM32F746_PG11_FUNC_EVENTOUT 0x6b10
#define STM32F746_PG11_FUNC_ANALOG 0x6b11

#define STM32F746_PG12_FUNC_GPIO 0x6c00
#define STM32F746_PG12_FUNC_LPTIM1_IN1 0x6c04
#define STM32F746_PG12_FUNC_SPI6_MISO 0x6c06
#define STM32F746_PG12_FUNC_SPDIFRX_IN1 0x6c08
#define STM32F746_PG12_FUNC_USART6_RTS 0x6c09
#define STM32F746_PG12_FUNC_LCD_B4 0x6c0a
#define STM32F746_PG12_FUNC_FMC_NE4 0x6c0d
#define STM32F746_PG12_FUNC_LCD_B1 0x6c0f
#define STM32F746_PG12_FUNC_EVENTOUT 0x6c10
#define STM32F746_PG12_FUNC_ANALOG 0x6c11

#define STM32F746_PG13_FUNC_GPIO 0x6d00
#define STM32F746_PG13_FUNC_TRACED0 0x6d01
#define STM32F746_PG13_FUNC_LPTIM1_OUT 0x6d04
#define STM32F746_PG13_FUNC_SPI6_SCK 0x6d06
#define STM32F746_PG13_FUNC_USART6_CTS 0x6d09
#define STM32F746_PG13_FUNC_ETH_MII_TXD0_ETH_RMII_TXD0 0x6d0c
#define STM32F746_PG13_FUNC_FMC_A24 0x6d0d
#define STM32F746_PG13_FUNC_LCD_R0 0x6d0f
#define STM32F746_PG13_FUNC_EVENTOUT 0x6d10
#define STM32F746_PG13_FUNC_ANALOG 0x6d11

#define STM32F746_PG14_FUNC_GPIO 0x6e00
#define STM32F746_PG14_FUNC_TRACED1 0x6e01
#define STM32F746_PG14_FUNC_LPTIM1_ETR 0x6e04
#define STM32F746_PG14_FUNC_SPI6_MOSI 0x6e06
#define STM32F746_PG14_FUNC_USART6_TX 0x6e09
#define STM32F746_PG14_FUNC_QUADSPI_BK2_IO3 0x6e0a
#define STM32F746_PG14_FUNC_ETH_MII_TXD1_ETH_RMII_TXD1 0x6e0c
#define STM32F746_PG14_FUNC_FMC_A25 0x6e0d
#define STM32F746_PG14_FUNC_LCD_B0 0x6e0f
#define STM32F746_PG14_FUNC_EVENTOUT 0x6e10
#define STM32F746_PG14_FUNC_ANALOG 0x6e11

#define STM32F746_PG15_FUNC_GPIO 0x6f00
#define STM32F746_PG15_FUNC_USART6_CTS 0x6f09
#define STM32F746_PG15_FUNC_FMC_SDNCAS 0x6f0d
#define STM32F746_PG15_FUNC_DCMI_D13 0x6f0e
#define STM32F746_PG15_FUNC_EVENTOUT 0x6f10
#define STM32F746_PG15_FUNC_ANALOG 0x6f11


#define STM32F746_PH0_FUNC_GPIO 0x7000
#define STM32F746_PH0_FUNC_EVENTOUT 0x7010
#define STM32F746_PH0_FUNC_ANALOG 0x7011

#define STM32F746_PH1_FUNC_GPIO 0x7100
#define STM32F746_PH1_FUNC_EVENTOUT 0x7110
#define STM32F746_PH1_FUNC_ANALOG 0x7111

#define STM32F746_PH2_FUNC_GPIO 0x7200
#define STM32F746_PH2_FUNC_LPTIM1_IN2 0x7204
#define STM32F746_PH2_FUNC_QUADSPI_BK2_IO0 0x720a
#define STM32F746_PH2_FUNC_SAI2_SCK_B 0x720b
#define STM32F746_PH2_FUNC_ETH_MII_CRS 0x720c
#define STM32F746_PH2_FUNC_FMC_SDCKE0 0x720d
#define STM32F746_PH2_FUNC_LCD_R0 0x720f
#define STM32F746_PH2_FUNC_EVENTOUT 0x7210
#define STM32F746_PH2_FUNC_ANALOG 0x7211

#define STM32F746_PH3_FUNC_GPIO 0x7300
#define STM32F746_PH3_FUNC_QUADSPI_BK2_IO1 0x730a
#define STM32F746_PH3_FUNC_SAI2_MCLK_B 0x730b
#define STM32F746_PH3_FUNC_ETH_MII_COL 0x730c
#define STM32F746_PH3_FUNC_FMC_SDNE0 0x730d
#define STM32F746_PH3_FUNC_LCD_R1 0x730f
#define STM32F746_PH3_FUNC_EVENTOUT 0x7310
#define STM32F746_PH3_FUNC_ANALOG 0x7311

#define STM32F746_PH4_FUNC_GPIO 0x7400
#define STM32F746_PH4_FUNC_I2C2_SCL 0x7405
#define STM32F746_PH4_FUNC_OTG_HS_ULPI_NXT 0x740b
#define STM32F746_PH4_FUNC_EVENTOUT 0x7410
#define STM32F746_PH4_FUNC_ANALOG 0x7411

#define STM32F746_PH5_FUNC_GPIO 0x7500
#define STM32F746_PH5_FUNC_I2C2_SDA 0x7505
#define STM32F746_PH5_FUNC_SPI5_NSS 0x7506
#define STM32F746_PH5_FUNC_FMC_SDNWE 0x750d
#define STM32F746_PH5_FUNC_EVENTOUT 0x7510
#define STM32F746_PH5_FUNC_ANALOG 0x7511

#define STM32F746_PH6_FUNC_GPIO 0x7600
#define STM32F746_PH6_FUNC_I2C2_SMBA 0x7605
#define STM32F746_PH6_FUNC_SPI5_SCK 0x7606
#define STM32F746_PH6_FUNC_TIM12_CH1 0x760a
#define STM32F746_PH6_FUNC_ETH_MII_RXD2 0x760c
#define STM32F746_PH6_FUNC_FMC_SDNE1 0x760d
#define STM32F746_PH6_FUNC_DCMI_D8 0x760e
#define STM32F746_PH6_FUNC_EVENTOUT 0x7610
#define STM32F746_PH6_FUNC_ANALOG 0x7611

#define STM32F746_PH7_FUNC_GPIO 0x7700
#define STM32F746_PH7_FUNC_I2C3_SCL 0x7705
#define STM32F746_PH7_FUNC_SPI5_MISO 0x7706
#define STM32F746_PH7_FUNC_ETH_MII_RXD3 0x770c
#define STM32F746_PH7_FUNC_FMC_SDCKE1 0x770d
#define STM32F746_PH7_FUNC_DCMI_D9 0x770e
#define STM32F746_PH7_FUNC_EVENTOUT 0x7710
#define STM32F746_PH7_FUNC_ANALOG 0x7711

#define STM32F746_PH8_FUNC_GPIO 0x7800
#define STM32F746_PH8_FUNC_I2C3_SDA 0x7805
#define STM32F746_PH8_FUNC_FMC_D16 0x780d
#define STM32F746_PH8_FUNC_DCMI_HSYNC 0x780e
#define STM32F746_PH8_FUNC_LCD_R2 0x780f
#define STM32F746_PH8_FUNC_EVENTOUT 0x7810
#define STM32F746_PH8_FUNC_ANALOG 0x7811

#define STM32F746_PH9_FUNC_GPIO 0x7900
#define STM32F746_PH9_FUNC_I2C3_SMBA 0x7905
#define STM32F746_PH9_FUNC_TIM12_CH2 0x790a
#define STM32F746_PH9_FUNC_FMC_D17 0x790d
#define STM32F746_PH9_FUNC_DCMI_D0 0x790e
#define STM32F746_PH9_FUNC_LCD_R3 0x790f
#define STM32F746_PH9_FUNC_EVENTOUT 0x7910
#define STM32F746_PH9_FUNC_ANALOG 0x7911

#define STM32F746_PH10_FUNC_GPIO 0x7a00
#define STM32F746_PH10_FUNC_TIM5_CH1 0x7a03
#define STM32F746_PH10_FUNC_I2C4_SMBA 0x7a05
#define STM32F746_PH10_FUNC_FMC_D18 0x7a0d
#define STM32F746_PH10_FUNC_DCMI_D1 0x7a0e
#define STM32F746_PH10_FUNC_LCD_R4 0x7a0f
#define STM32F746_PH10_FUNC_EVENTOUT 0x7a10
#define STM32F746_PH10_FUNC_ANALOG 0x7a11

#define STM32F746_PH11_FUNC_GPIO 0x7b00
#define STM32F746_PH11_FUNC_TIM5_CH2 0x7b03
#define STM32F746_PH11_FUNC_I2C4_SCL 0x7b05
#define STM32F746_PH11_FUNC_FMC_D19 0x7b0d
#define STM32F746_PH11_FUNC_DCMI_D2 0x7b0e
#define STM32F746_PH11_FUNC_LCD_R5 0x7b0f
#define STM32F746_PH11_FUNC_EVENTOUT 0x7b10
#define STM32F746_PH11_FUNC_ANALOG 0x7b11

#define STM32F746_PH12_FUNC_GPIO 0x7c00
#define STM32F746_PH12_FUNC_TIM5_CH3 0x7c03
#define STM32F746_PH12_FUNC_I2C4_SDA 0x7c05
#define STM32F746_PH12_FUNC_FMC_D20 0x7c0d
#define STM32F746_PH12_FUNC_DCMI_D3 0x7c0e
#define STM32F746_PH12_FUNC_LCD_R6 0x7c0f
#define STM32F746_PH12_FUNC_EVENTOUT 0x7c10
#define STM32F746_PH12_FUNC_ANALOG 0x7c11

#define STM32F746_PH13_FUNC_GPIO 0x7d00
#define STM32F746_PH13_FUNC_TIM8_CH1N 0x7d04
#define STM32F746_PH13_FUNC_CAN1_TX 0x7d0a
#define STM32F746_PH13_FUNC_FMC_D21 0x7d0d
#define STM32F746_PH13_FUNC_LCD_G2 0x7d0f
#define STM32F746_PH13_FUNC_EVENTOUT 0x7d10
#define STM32F746_PH13_FUNC_ANALOG 0x7d11

#define STM32F746_PH14_FUNC_GPIO 0x7e00
#define STM32F746_PH14_FUNC_TIM8_CH2N 0x7e04
#define STM32F746_PH14_FUNC_FMC_D22 0x7e0d
#define STM32F746_PH14_FUNC_DCMI_D4 0x7e0e
#define STM32F746_PH14_FUNC_LCD_G3 0x7e0f
#define STM32F746_PH14_FUNC_EVENTOUT 0x7e10
#define STM32F746_PH14_FUNC_ANALOG 0x7e11

#define STM32F746_PH15_FUNC_GPIO 0x7f00
#define STM32F746_PH15_FUNC_TIM8_CH3N 0x7f04
#define STM32F746_PH15_FUNC_FMC_D23 0x7f0d
#define STM32F746_PH15_FUNC_DCMI_D11 0x7f0e
#define STM32F746_PH15_FUNC_LCD_G4 0x7f0f
#define STM32F746_PH15_FUNC_EVENTOUT 0x7f10
#define STM32F746_PH15_FUNC_ANALOG 0x7f11


#define STM32F746_PI0_FUNC_GPIO 0x8000
#define STM32F746_PI0_FUNC_TIM5_CH4 0x8003
#define STM32F746_PI0_FUNC_SPI2_NSS_I2S2_WS 0x8006
#define STM32F746_PI0_FUNC_FMC_D24 0x800d
#define STM32F746_PI0_FUNC_DCMI_D13 0x800e
#define STM32F746_PI0_FUNC_LCD_G5 0x800f
#define STM32F746_PI0_FUNC_EVENTOUT 0x8010
#define STM32F746_PI0_FUNC_ANALOG 0x8011

#define STM32F746_PI1_FUNC_GPIO 0x8100
#define STM32F746_PI1_FUNC_TIM8_BKIN2 0x8104
#define STM32F746_PI1_FUNC_SPI2_SCK_I2S2_CK 0x8106
#define STM32F746_PI1_FUNC_FMC_D25 0x810d
#define STM32F746_PI1_FUNC_DCMI_D8 0x810e
#define STM32F746_PI1_FUNC_LCD_G6 0x810f
#define STM32F746_PI1_FUNC_EVENTOUT 0x8110
#define STM32F746_PI1_FUNC_ANALOG 0x8111

#define STM32F746_PI2_FUNC_GPIO 0x8200
#define STM32F746_PI2_FUNC_TIM8_CH4 0x8204
#define STM32F746_PI2_FUNC_SPI2_MISO 0x8206
#define STM32F746_PI2_FUNC_FMC_D26 0x820d
#define STM32F746_PI2_FUNC_DCMI_D9 0x820e
#define STM32F746_PI2_FUNC_LCD_G7 0x820f
#define STM32F746_PI2_FUNC_EVENTOUT 0x8210
#define STM32F746_PI2_FUNC_ANALOG 0x8211

#define STM32F746_PI3_FUNC_GPIO 0x8300
#define STM32F746_PI3_FUNC_TIM8_ETR 0x8304
#define STM32F746_PI3_FUNC_SPI2_MOSI_I2S2_SD 0x8306
#define STM32F746_PI3_FUNC_FMC_D27 0x830d
#define STM32F746_PI3_FUNC_DCMI_D10 0x830e
#define STM32F746_PI3_FUNC_EVENTOUT 0x8310
#define STM32F746_PI3_FUNC_ANALOG 0x8311

#define STM32F746_PI4_FUNC_GPIO 0x8400
#define STM32F746_PI4_FUNC_TIM8_BKIN 0x8404
#define STM32F746_PI4_FUNC_SAI2_MCLK_A 0x840b
#define STM32F746_PI4_FUNC_FMC_NBL2 0x840d
#define STM32F746_PI4_FUNC_DCMI_D5 0x840e
#define STM32F746_PI4_FUNC_LCD_B4 0x840f
#define STM32F746_PI4_FUNC_EVENTOUT 0x8410
#define STM32F746_PI4_FUNC_ANALOG 0x8411

#define STM32F746_PI5_FUNC_GPIO 0x8500
#define STM32F746_PI5_FUNC_TIM8_CH1 0x8504
#define STM32F746_PI5_FUNC_SAI2_SCK_A 0x850b
#define STM32F746_PI5_FUNC_FMC_NBL3 0x850d
#define STM32F746_PI5_FUNC_DCMI_VSYNC 0x850e
#define STM32F746_PI5_FUNC_LCD_B5 0x850f
#define STM32F746_PI5_FUNC_EVENTOUT 0x8510
#define STM32F746_PI5_FUNC_ANALOG 0x8511

#define STM32F746_PI6_FUNC_GPIO 0x8600
#define STM32F746_PI6_FUNC_TIM8_CH2 0x8604
#define STM32F746_PI6_FUNC_SAI2_SD_A 0x860b
#define STM32F746_PI6_FUNC_FMC_D28 0x860d
#define STM32F746_PI6_FUNC_DCMI_D6 0x860e
#define STM32F746_PI6_FUNC_LCD_B6 0x860f
#define STM32F746_PI6_FUNC_EVENTOUT 0x8610
#define STM32F746_PI6_FUNC_ANALOG 0x8611

#define STM32F746_PI7_FUNC_GPIO 0x8700
#define STM32F746_PI7_FUNC_TIM8_CH3 0x8704
#define STM32F746_PI7_FUNC_SAI2_FS_A 0x870b
#define STM32F746_PI7_FUNC_FMC_D29 0x870d
#define STM32F746_PI7_FUNC_DCMI_D7 0x870e
#define STM32F746_PI7_FUNC_LCD_B7 0x870f
#define STM32F746_PI7_FUNC_EVENTOUT 0x8710
#define STM32F746_PI7_FUNC_ANALOG 0x8711

#define STM32F746_PI8_FUNC_GPIO 0x8800
#define STM32F746_PI8_FUNC_EVENTOUT 0x8810
#define STM32F746_PI8_FUNC_ANALOG 0x8811

#define STM32F746_PI9_FUNC_GPIO 0x8900
#define STM32F746_PI9_FUNC_CAN1_RX 0x890a
#define STM32F746_PI9_FUNC_FMC_D30 0x890d
#define STM32F746_PI9_FUNC_LCD_VSYNC 0x890f
#define STM32F746_PI9_FUNC_EVENTOUT 0x8910
#define STM32F746_PI9_FUNC_ANALOG 0x8911

#define STM32F746_PI10_FUNC_GPIO 0x8a00
#define STM32F746_PI10_FUNC_ETH_MII_RX_ER 0x8a0c
#define STM32F746_PI10_FUNC_FMC_D31 0x8a0d
#define STM32F746_PI10_FUNC_LCD_HSYNC 0x8a0f
#define STM32F746_PI10_FUNC_EVENTOUT 0x8a10
#define STM32F746_PI10_FUNC_ANALOG 0x8a11

#define STM32F746_PI11_FUNC_GPIO 0x8b00
#define STM32F746_PI11_FUNC_OTG_HS_ULPI_DIR 0x8b0b
#define STM32F746_PI11_FUNC_EVENTOUT 0x8b10
#define STM32F746_PI11_FUNC_ANALOG 0x8b11

#define STM32F746_PI12_FUNC_GPIO 0x8c00
#define STM32F746_PI12_FUNC_LCD_HSYNC 0x8c0f
#define STM32F746_PI12_FUNC_EVENTOUT 0x8c10
#define STM32F746_PI12_FUNC_ANALOG 0x8c11

#define STM32F746_PI13_FUNC_GPIO 0x8d00
#define STM32F746_PI13_FUNC_LCD_VSYNC 0x8d0f
#define STM32F746_PI13_FUNC_EVENTOUT 0x8d10
#define STM32F746_PI13_FUNC_ANALOG 0x8d11

#define STM32F746_PI14_FUNC_GPIO 0x8e00
#define STM32F746_PI14_FUNC_LCD_CLK 0x8e0f
#define STM32F746_PI14_FUNC_EVENTOUT 0x8e10
#define STM32F746_PI14_FUNC_ANALOG 0x8e11

#define STM32F746_PI15_FUNC_GPIO 0x8f00
#define STM32F746_PI15_FUNC_LCD_R0 0x8f0f
#define STM32F746_PI15_FUNC_EVENTOUT 0x8f10
#define STM32F746_PI15_FUNC_ANALOG 0x8f11


#define STM32F746_PJ0_FUNC_GPIO 0x9000
#define STM32F746_PJ0_FUNC_LCD_R1 0x900f
#define STM32F746_PJ0_FUNC_EVENTOUT 0x9010
#define STM32F746_PJ0_FUNC_ANALOG 0x9011

#define STM32F746_PJ1_FUNC_GPIO 0x9100
#define STM32F746_PJ1_FUNC_LCD_R2 0x910f
#define STM32F746_PJ1_FUNC_EVENTOUT 0x9110
#define STM32F746_PJ1_FUNC_ANALOG 0x9111

#define STM32F746_PJ2_FUNC_GPIO 0x9200
#define STM32F746_PJ2_FUNC_LCD_R3 0x920f
#define STM32F746_PJ2_FUNC_EVENTOUT 0x9210
#define STM32F746_PJ2_FUNC_ANALOG 0x9211

#define STM32F746_PJ3_FUNC_GPIO 0x9300
#define STM32F746_PJ3_FUNC_LCD_R4 0x930f
#define STM32F746_PJ3_FUNC_EVENTOUT 0x9310
#define STM32F746_PJ3_FUNC_ANALOG 0x9311

#define STM32F746_PJ4_FUNC_GPIO 0x9400
#define STM32F746_PJ4_FUNC_LCD_R5 0x940f
#define STM32F746_PJ4_FUNC_EVENTOUT 0x9410
#define STM32F746_PJ4_FUNC_ANALOG 0x9411

#define STM32F746_PJ5_FUNC_GPIO 0x9500
#define STM32F746_PJ5_FUNC_LCD_R6 0x950f
#define STM32F746_PJ5_FUNC_EVENTOUT 0x9510
#define STM32F746_PJ5_FUNC_ANALOG 0x9511

#define STM32F746_PJ6_FUNC_GPIO 0x9600
#define STM32F746_PJ6_FUNC_LCD_R7 0x960f
#define STM32F746_PJ6_FUNC_EVENTOUT 0x9610
#define STM32F746_PJ6_FUNC_ANALOG 0x9611

#define STM32F746_PJ7_FUNC_GPIO 0x9700
#define STM32F746_PJ7_FUNC_LCD_G0 0x970f
#define STM32F746_PJ7_FUNC_EVENTOUT 0x9710
#define STM32F746_PJ7_FUNC_ANALOG 0x9711

#define STM32F746_PJ8_FUNC_GPIO 0x9800
#define STM32F746_PJ8_FUNC_LCD_G1 0x980f
#define STM32F746_PJ8_FUNC_EVENTOUT 0x9810
#define STM32F746_PJ8_FUNC_ANALOG 0x9811

#define STM32F746_PJ9_FUNC_GPIO 0x9900
#define STM32F746_PJ9_FUNC_LCD_G2 0x990f
#define STM32F746_PJ9_FUNC_EVENTOUT 0x9910
#define STM32F746_PJ9_FUNC_ANALOG 0x9911

#define STM32F746_PJ10_FUNC_GPIO 0x9a00
#define STM32F746_PJ10_FUNC_LCD_G3 0x9a0f
#define STM32F746_PJ10_FUNC_EVENTOUT 0x9a10
#define STM32F746_PJ10_FUNC_ANALOG 0x9a11

#define STM32F746_PJ11_FUNC_GPIO 0x9b00
#define STM32F746_PJ11_FUNC_LCD_G4 0x9b0f
#define STM32F746_PJ11_FUNC_EVENTOUT 0x9b10
#define STM32F746_PJ11_FUNC_ANALOG 0x9b11

#define STM32F746_PJ12_FUNC_GPIO 0x9c00
#define STM32F746_PJ12_FUNC_LCD_B0 0x9c0f
#define STM32F746_PJ12_FUNC_EVENTOUT 0x9c10
#define STM32F746_PJ12_FUNC_ANALOG 0x9c11

#define STM32F746_PJ13_FUNC_GPIO 0x9d00
#define STM32F746_PJ13_FUNC_LCD_B1 0x9d0f
#define STM32F746_PJ13_FUNC_EVENTOUT 0x9d10
#define STM32F746_PJ13_FUNC_ANALOG 0x9d11

#define STM32F746_PJ14_FUNC_GPIO 0x9e00
#define STM32F746_PJ14_FUNC_LCD_B2 0x9e0f
#define STM32F746_PJ14_FUNC_EVENTOUT 0x9e10
#define STM32F746_PJ14_FUNC_ANALOG 0x9e11

#define STM32F746_PJ15_FUNC_GPIO 0x9f00
#define STM32F746_PJ15_FUNC_LCD_B3 0x9f0f
#define STM32F746_PJ15_FUNC_EVENTOUT 0x9f10
#define STM32F746_PJ15_FUNC_ANALOG 0x9f11


#define STM32F746_PK0_FUNC_GPIO 0xa000
#define STM32F746_PK0_FUNC_LCD_G5 0xa00f
#define STM32F746_PK0_FUNC_EVENTOUT 0xa010
#define STM32F746_PK0_FUNC_ANALOG 0xa011

#define STM32F746_PK1_FUNC_GPIO 0xa100
#define STM32F746_PK1_FUNC_LCD_G6 0xa10f
#define STM32F746_PK1_FUNC_EVENTOUT 0xa110
#define STM32F746_PK1_FUNC_ANALOG 0xa111

#define STM32F746_PK2_FUNC_GPIO 0xa200
#define STM32F746_PK2_FUNC_LCD_G7 0xa20f
#define STM32F746_PK2_FUNC_EVENTOUT 0xa210
#define STM32F746_PK2_FUNC_ANALOG 0xa211

#define STM32F746_PK3_FUNC_GPIO 0xa300
#define STM32F746_PK3_FUNC_LCD_B4 0xa30f
#define STM32F746_PK3_FUNC_EVENTOUT 0xa310
#define STM32F746_PK3_FUNC_ANALOG 0xa311

#define STM32F746_PK4_FUNC_GPIO 0xa400
#define STM32F746_PK4_FUNC_LCD_B5 0xa40f
#define STM32F746_PK4_FUNC_EVENTOUT 0xa410
#define STM32F746_PK4_FUNC_ANALOG 0xa411

#define STM32F746_PK5_FUNC_GPIO 0xa500
#define STM32F746_PK5_FUNC_LCD_B6 0xa50f
#define STM32F746_PK5_FUNC_EVENTOUT 0xa510
#define STM32F746_PK5_FUNC_ANALOG 0xa511

#define STM32F746_PK6_FUNC_GPIO 0xa600
#define STM32F746_PK6_FUNC_LCD_B7 0xa60f
#define STM32F746_PK6_FUNC_EVENTOUT 0xa610
#define STM32F746_PK6_FUNC_ANALOG 0xa611

#define STM32F746_PK7_FUNC_GPIO 0xa700
#define STM32F746_PK7_FUNC_LCD_DE 0xa70f
#define STM32F746_PK7_FUNC_EVENTOUT 0xa710
#define STM32F746_PK7_FUNC_ANALOG 0xa711

#endif /* _DT_BINDINGS_STM32F746_PINFUNC_H */
