/*
 * OMAP44xx PRM instance offset macros
 *
 * Copyright (C) 2009-2010 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * XXX This file needs to be updated to align on one of "OMAP4", "OMAP44XX",
 *     or "OMAP4430".
 */

#ifndef __ARCH_ARM_MACH_OMAP2_PRM44XX_H
#define __ARCH_ARM_MACH_OMAP2_PRM44XX_H

#include "prcm-common.h"
#include "prm.h"

#define OMAP4430_PRM_BASE		0x4a306000

#define OMAP44XX_PRM_REGADDR(inst, reg)				\
	OMAP2_L4_IO_ADDRESS(OMAP4430_PRM_BASE + (inst) + (reg))


/* PRM instances */
#define OMAP4430_PRM_OCP_SOCKET_INST	0x0000
#define OMAP4430_PRM_CKGEN_INST		0x0100
#define OMAP4430_PRM_MPU_INST		0x0300
#define OMAP4430_PRM_TESLA_INST		0x0400
#define OMAP4430_PRM_ABE_INST		0x0500
#define OMAP4430_PRM_ALWAYS_ON_INST	0x0600
#define OMAP4430_PRM_CORE_INST		0x0700
#define OMAP4430_PRM_IVAHD_INST		0x0f00
#define OMAP4430_PRM_CAM_INST		0x1000
#define OMAP4430_PRM_DSS_INST		0x1100
#define OMAP4430_PRM_GFX_INST		0x1200
#define OMAP4430_PRM_L3INIT_INST	0x1300
#define OMAP4430_PRM_L4PER_INST		0x1400
#define OMAP4430_PRM_CEFUSE_INST	0x1600
#define OMAP4430_PRM_WKUP_INST		0x1700
#define OMAP4430_PRM_WKUP_CM_INST	0x1800
#define OMAP4430_PRM_EMU_INST		0x1900
#define OMAP4430_PRM_EMU_CM_INST	0x1a00
#define OMAP4430_PRM_DEVICE_INST	0x1b00
#define OMAP4430_PRM_INSTR_INST		0x1f00

/* PRM clockdomain register offsets (from instance start) */
#define OMAP4430_PRM_WKUP_CM_WKUP_CDOFFS	0x0000
#define OMAP4430_PRM_EMU_CM_EMU_CDOFFS		0x0000

/* OMAP4 specific register offsets */
#define OMAP4_RM_RSTCTRL				0x0000
#define OMAP4_RM_RSTTIME				0x0004
#define OMAP4_RM_RSTST					0x0008
#define OMAP4_PM_PWSTCTRL				0x0000
#define OMAP4_PM_PWSTST					0x0004


/* PRM */

/* PRM.OCP_SOCKET_PRM register offsets */
#define OMAP4_REVISION_PRM_OFFSET			0x0000
#define OMAP4430_REVISION_PRM				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0000)
#define OMAP4_PRM_IRQSTATUS_MPU_OFFSET			0x0010
#define OMAP4430_PRM_IRQSTATUS_MPU			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0010)
#define OMAP4_PRM_IRQSTATUS_MPU_2_OFFSET		0x0014
#define OMAP4430_PRM_IRQSTATUS_MPU_2			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0014)
#define OMAP4_PRM_IRQENABLE_MPU_OFFSET			0x0018
#define OMAP4430_PRM_IRQENABLE_MPU			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0018)
#define OMAP4_PRM_IRQENABLE_MPU_2_OFFSET		0x001c
#define OMAP4430_PRM_IRQENABLE_MPU_2			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x001c)
#define OMAP4_PRM_IRQSTATUS_DUCATI_OFFSET		0x0020
#define OMAP4430_PRM_IRQSTATUS_DUCATI			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0020)
#define OMAP4_PRM_IRQENABLE_DUCATI_OFFSET		0x0028
#define OMAP4430_PRM_IRQENABLE_DUCATI			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0028)
#define OMAP4_PRM_IRQSTATUS_TESLA_OFFSET		0x0030
#define OMAP4430_PRM_IRQSTATUS_TESLA			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0030)
#define OMAP4_PRM_IRQENABLE_TESLA_OFFSET		0x0038
#define OMAP4430_PRM_IRQENABLE_TESLA			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0038)
#define OMAP4_CM_PRM_PROFILING_CLKCTRL_OFFSET		0x0040
#define OMAP4430_CM_PRM_PROFILING_CLKCTRL		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0040)

/* PRM.CKGEN_PRM register offsets */
#define OMAP4_CM_ABE_DSS_SYS_CLKSEL_OFFSET		0x0000
#define OMAP4430_CM_ABE_DSS_SYS_CLKSEL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CKGEN_INST, 0x0000)
#define OMAP4_CM_L4_WKUP_CLKSEL_OFFSET			0x0008
#define OMAP4430_CM_L4_WKUP_CLKSEL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CKGEN_INST, 0x0008)
#define OMAP4_CM_ABE_PLL_REF_CLKSEL_OFFSET		0x000c
#define OMAP4430_CM_ABE_PLL_REF_CLKSEL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CKGEN_INST, 0x000c)
#define OMAP4_CM_SYS_CLKSEL_OFFSET			0x0010
#define OMAP4430_CM_SYS_CLKSEL				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CKGEN_INST, 0x0010)

/* PRM.MPU_PRM register offsets */
#define OMAP4_PM_MPU_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_MPU_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_MPU_INST, 0x0000)
#define OMAP4_PM_MPU_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_MPU_PWRSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_MPU_INST, 0x0004)
#define OMAP4_RM_MPU_RSTST_OFFSET			0x0014
#define OMAP4430_RM_MPU_RSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_MPU_INST, 0x0014)
#define OMAP4_RM_MPU_MPU_CONTEXT_OFFSET			0x0024
#define OMAP4430_RM_MPU_MPU_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_MPU_INST, 0x0024)

/* PRM.TESLA_PRM register offsets */
#define OMAP4_PM_TESLA_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_TESLA_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_TESLA_INST, 0x0000)
#define OMAP4_PM_TESLA_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_TESLA_PWRSTST			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_TESLA_INST, 0x0004)
#define OMAP4_RM_TESLA_RSTCTRL_OFFSET			0x0010
#define OMAP4430_RM_TESLA_RSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_TESLA_INST, 0x0010)
#define OMAP4_RM_TESLA_RSTST_OFFSET			0x0014
#define OMAP4430_RM_TESLA_RSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_TESLA_INST, 0x0014)
#define OMAP4_RM_TESLA_TESLA_CONTEXT_OFFSET		0x0024
#define OMAP4430_RM_TESLA_TESLA_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_TESLA_INST, 0x0024)

/* PRM.ABE_PRM register offsets */
#define OMAP4_PM_ABE_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_ABE_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0000)
#define OMAP4_PM_ABE_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_ABE_PWRSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0004)
#define OMAP4_RM_ABE_AESS_CONTEXT_OFFSET		0x002c
#define OMAP4430_RM_ABE_AESS_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x002c)
#define OMAP4_PM_ABE_PDM_WKDEP_OFFSET			0x0030
#define OMAP4430_PM_ABE_PDM_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0030)
#define OMAP4_RM_ABE_PDM_CONTEXT_OFFSET			0x0034
#define OMAP4430_RM_ABE_PDM_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0034)
#define OMAP4_PM_ABE_DMIC_WKDEP_OFFSET			0x0038
#define OMAP4430_PM_ABE_DMIC_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0038)
#define OMAP4_RM_ABE_DMIC_CONTEXT_OFFSET		0x003c
#define OMAP4430_RM_ABE_DMIC_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x003c)
#define OMAP4_PM_ABE_MCASP_WKDEP_OFFSET			0x0040
#define OMAP4430_PM_ABE_MCASP_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0040)
#define OMAP4_RM_ABE_MCASP_CONTEXT_OFFSET		0x0044
#define OMAP4430_RM_ABE_MCASP_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0044)
#define OMAP4_PM_ABE_MCBSP1_WKDEP_OFFSET		0x0048
#define OMAP4430_PM_ABE_MCBSP1_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0048)
#define OMAP4_RM_ABE_MCBSP1_CONTEXT_OFFSET		0x004c
#define OMAP4430_RM_ABE_MCBSP1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x004c)
#define OMAP4_PM_ABE_MCBSP2_WKDEP_OFFSET		0x0050
#define OMAP4430_PM_ABE_MCBSP2_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0050)
#define OMAP4_RM_ABE_MCBSP2_CONTEXT_OFFSET		0x0054
#define OMAP4430_RM_ABE_MCBSP2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0054)
#define OMAP4_PM_ABE_MCBSP3_WKDEP_OFFSET		0x0058
#define OMAP4430_PM_ABE_MCBSP3_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0058)
#define OMAP4_RM_ABE_MCBSP3_CONTEXT_OFFSET		0x005c
#define OMAP4430_RM_ABE_MCBSP3_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x005c)
#define OMAP4_PM_ABE_SLIMBUS_WKDEP_OFFSET		0x0060
#define OMAP4430_PM_ABE_SLIMBUS_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0060)
#define OMAP4_RM_ABE_SLIMBUS_CONTEXT_OFFSET		0x0064
#define OMAP4430_RM_ABE_SLIMBUS_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0064)
#define OMAP4_PM_ABE_TIMER5_WKDEP_OFFSET		0x0068
#define OMAP4430_PM_ABE_TIMER5_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0068)
#define OMAP4_RM_ABE_TIMER5_CONTEXT_OFFSET		0x006c
#define OMAP4430_RM_ABE_TIMER5_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x006c)
#define OMAP4_PM_ABE_TIMER6_WKDEP_OFFSET		0x0070
#define OMAP4430_PM_ABE_TIMER6_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0070)
#define OMAP4_RM_ABE_TIMER6_CONTEXT_OFFSET		0x0074
#define OMAP4430_RM_ABE_TIMER6_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0074)
#define OMAP4_PM_ABE_TIMER7_WKDEP_OFFSET		0x0078
#define OMAP4430_PM_ABE_TIMER7_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0078)
#define OMAP4_RM_ABE_TIMER7_CONTEXT_OFFSET		0x007c
#define OMAP4430_RM_ABE_TIMER7_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x007c)
#define OMAP4_PM_ABE_TIMER8_WKDEP_OFFSET		0x0080
#define OMAP4430_PM_ABE_TIMER8_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0080)
#define OMAP4_RM_ABE_TIMER8_CONTEXT_OFFSET		0x0084
#define OMAP4430_RM_ABE_TIMER8_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0084)
#define OMAP4_PM_ABE_WDT3_WKDEP_OFFSET			0x0088
#define OMAP4430_PM_ABE_WDT3_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x0088)
#define OMAP4_RM_ABE_WDT3_CONTEXT_OFFSET		0x008c
#define OMAP4430_RM_ABE_WDT3_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ABE_INST, 0x008c)

/* PRM.ALWAYS_ON_PRM register offsets */
#define OMAP4_RM_ALWON_MDMINTC_CONTEXT_OFFSET		0x0024
#define OMAP4430_RM_ALWON_MDMINTC_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ALWAYS_ON_INST, 0x0024)
#define OMAP4_PM_ALWON_SR_MPU_WKDEP_OFFSET		0x0028
#define OMAP4430_PM_ALWON_SR_MPU_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ALWAYS_ON_INST, 0x0028)
#define OMAP4_RM_ALWON_SR_MPU_CONTEXT_OFFSET		0x002c
#define OMAP4430_RM_ALWON_SR_MPU_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ALWAYS_ON_INST, 0x002c)
#define OMAP4_PM_ALWON_SR_IVA_WKDEP_OFFSET		0x0030
#define OMAP4430_PM_ALWON_SR_IVA_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ALWAYS_ON_INST, 0x0030)
#define OMAP4_RM_ALWON_SR_IVA_CONTEXT_OFFSET		0x0034
#define OMAP4430_RM_ALWON_SR_IVA_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ALWAYS_ON_INST, 0x0034)
#define OMAP4_PM_ALWON_SR_CORE_WKDEP_OFFSET		0x0038
#define OMAP4430_PM_ALWON_SR_CORE_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ALWAYS_ON_INST, 0x0038)
#define OMAP4_RM_ALWON_SR_CORE_CONTEXT_OFFSET		0x003c
#define OMAP4430_RM_ALWON_SR_CORE_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_ALWAYS_ON_INST, 0x003c)

/* PRM.CORE_PRM register offsets */
#define OMAP4_PM_CORE_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_CORE_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0000)
#define OMAP4_PM_CORE_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_CORE_PWRSTST			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0004)
#define OMAP4_RM_L3_1_L3_1_CONTEXT_OFFSET		0x0024
#define OMAP4430_RM_L3_1_L3_1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0024)
#define OMAP4_RM_L3_2_L3_2_CONTEXT_OFFSET		0x0124
#define OMAP4430_RM_L3_2_L3_2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0124)
#define OMAP4_RM_L3_2_GPMC_CONTEXT_OFFSET		0x012c
#define OMAP4430_RM_L3_2_GPMC_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x012c)
#define OMAP4_RM_L3_2_OCMC_RAM_CONTEXT_OFFSET		0x0134
#define OMAP4430_RM_L3_2_OCMC_RAM_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0134)
#define OMAP4_RM_DUCATI_RSTCTRL_OFFSET			0x0210
#define OMAP4430_RM_DUCATI_RSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0210)
#define OMAP4_RM_DUCATI_RSTST_OFFSET			0x0214
#define OMAP4430_RM_DUCATI_RSTST			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0214)
#define OMAP4_RM_DUCATI_DUCATI_CONTEXT_OFFSET		0x0224
#define OMAP4430_RM_DUCATI_DUCATI_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0224)
#define OMAP4_RM_SDMA_SDMA_CONTEXT_OFFSET		0x0324
#define OMAP4430_RM_SDMA_SDMA_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0324)
#define OMAP4_RM_MEMIF_DMM_CONTEXT_OFFSET		0x0424
#define OMAP4430_RM_MEMIF_DMM_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0424)
#define OMAP4_RM_MEMIF_EMIF_FW_CONTEXT_OFFSET		0x042c
#define OMAP4430_RM_MEMIF_EMIF_FW_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x042c)
#define OMAP4_RM_MEMIF_EMIF_1_CONTEXT_OFFSET		0x0434
#define OMAP4430_RM_MEMIF_EMIF_1_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0434)
#define OMAP4_RM_MEMIF_EMIF_2_CONTEXT_OFFSET		0x043c
#define OMAP4430_RM_MEMIF_EMIF_2_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x043c)
#define OMAP4_RM_MEMIF_DLL_CONTEXT_OFFSET		0x0444
#define OMAP4430_RM_MEMIF_DLL_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0444)
#define OMAP4_RM_MEMIF_EMIF_H1_CONTEXT_OFFSET		0x0454
#define OMAP4430_RM_MEMIF_EMIF_H1_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0454)
#define OMAP4_RM_MEMIF_EMIF_H2_CONTEXT_OFFSET		0x045c
#define OMAP4430_RM_MEMIF_EMIF_H2_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x045c)
#define OMAP4_RM_MEMIF_DLL_H_CONTEXT_OFFSET		0x0464
#define OMAP4430_RM_MEMIF_DLL_H_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0464)
#define OMAP4_RM_D2D_SAD2D_CONTEXT_OFFSET		0x0524
#define OMAP4430_RM_D2D_SAD2D_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0524)
#define OMAP4_RM_D2D_MODEM_ICR_CONTEXT_OFFSET		0x052c
#define OMAP4430_RM_D2D_MODEM_ICR_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x052c)
#define OMAP4_RM_D2D_SAD2D_FW_CONTEXT_OFFSET		0x0534
#define OMAP4430_RM_D2D_SAD2D_FW_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0534)
#define OMAP4_RM_L4CFG_L4_CFG_CONTEXT_OFFSET		0x0624
#define OMAP4430_RM_L4CFG_L4_CFG_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0624)
#define OMAP4_RM_L4CFG_HW_SEM_CONTEXT_OFFSET		0x062c
#define OMAP4430_RM_L4CFG_HW_SEM_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x062c)
#define OMAP4_RM_L4CFG_MAILBOX_CONTEXT_OFFSET		0x0634
#define OMAP4430_RM_L4CFG_MAILBOX_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0634)
#define OMAP4_RM_L4CFG_SAR_ROM_CONTEXT_OFFSET		0x063c
#define OMAP4430_RM_L4CFG_SAR_ROM_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x063c)
#define OMAP4_RM_L3INSTR_L3_3_CONTEXT_OFFSET		0x0724
#define OMAP4430_RM_L3INSTR_L3_3_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0724)
#define OMAP4_RM_L3INSTR_L3_INSTR_CONTEXT_OFFSET	0x072c
#define OMAP4430_RM_L3INSTR_L3_INSTR_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x072c)
#define OMAP4_RM_L3INSTR_OCP_WP1_CONTEXT_OFFSET		0x0744
#define OMAP4430_RM_L3INSTR_OCP_WP1_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CORE_INST, 0x0744)

/* PRM.IVAHD_PRM register offsets */
#define OMAP4_PM_IVAHD_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_IVAHD_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_IVAHD_INST, 0x0000)
#define OMAP4_PM_IVAHD_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_IVAHD_PWRSTST			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_IVAHD_INST, 0x0004)
#define OMAP4_RM_IVAHD_RSTCTRL_OFFSET			0x0010
#define OMAP4430_RM_IVAHD_RSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_IVAHD_INST, 0x0010)
#define OMAP4_RM_IVAHD_RSTST_OFFSET			0x0014
#define OMAP4430_RM_IVAHD_RSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_IVAHD_INST, 0x0014)
#define OMAP4_RM_IVAHD_IVAHD_CONTEXT_OFFSET		0x0024
#define OMAP4430_RM_IVAHD_IVAHD_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_IVAHD_INST, 0x0024)
#define OMAP4_RM_IVAHD_SL2_CONTEXT_OFFSET		0x002c
#define OMAP4430_RM_IVAHD_SL2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_IVAHD_INST, 0x002c)

/* PRM.CAM_PRM register offsets */
#define OMAP4_PM_CAM_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_CAM_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CAM_INST, 0x0000)
#define OMAP4_PM_CAM_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_CAM_PWRSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CAM_INST, 0x0004)
#define OMAP4_RM_CAM_ISS_CONTEXT_OFFSET			0x0024
#define OMAP4430_RM_CAM_ISS_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CAM_INST, 0x0024)
#define OMAP4_RM_CAM_FDIF_CONTEXT_OFFSET		0x002c
#define OMAP4430_RM_CAM_FDIF_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CAM_INST, 0x002c)

/* PRM.DSS_PRM register offsets */
#define OMAP4_PM_DSS_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_DSS_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DSS_INST, 0x0000)
#define OMAP4_PM_DSS_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_DSS_PWRSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DSS_INST, 0x0004)
#define OMAP4_PM_DSS_DSS_WKDEP_OFFSET			0x0020
#define OMAP4430_PM_DSS_DSS_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DSS_INST, 0x0020)
#define OMAP4_RM_DSS_DSS_CONTEXT_OFFSET			0x0024
#define OMAP4430_RM_DSS_DSS_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DSS_INST, 0x0024)
#define OMAP4_RM_DSS_DEISS_CONTEXT_OFFSET		0x002c
#define OMAP4430_RM_DSS_DEISS_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DSS_INST, 0x002c)

/* PRM.GFX_PRM register offsets */
#define OMAP4_PM_GFX_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_GFX_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_GFX_INST, 0x0000)
#define OMAP4_PM_GFX_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_GFX_PWRSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_GFX_INST, 0x0004)
#define OMAP4_RM_GFX_GFX_CONTEXT_OFFSET			0x0024
#define OMAP4430_RM_GFX_GFX_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_GFX_INST, 0x0024)

/* PRM.L3INIT_PRM register offsets */
#define OMAP4_PM_L3INIT_PWRSTCTRL_OFFSET		0x0000
#define OMAP4430_PM_L3INIT_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0000)
#define OMAP4_PM_L3INIT_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_L3INIT_PWRSTST			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0004)
#define OMAP4_PM_L3INIT_MMC1_WKDEP_OFFSET		0x0028
#define OMAP4430_PM_L3INIT_MMC1_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0028)
#define OMAP4_RM_L3INIT_MMC1_CONTEXT_OFFSET		0x002c
#define OMAP4430_RM_L3INIT_MMC1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x002c)
#define OMAP4_PM_L3INIT_MMC2_WKDEP_OFFSET		0x0030
#define OMAP4430_PM_L3INIT_MMC2_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0030)
#define OMAP4_RM_L3INIT_MMC2_CONTEXT_OFFSET		0x0034
#define OMAP4430_RM_L3INIT_MMC2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0034)
#define OMAP4_PM_L3INIT_HSI_WKDEP_OFFSET		0x0038
#define OMAP4430_PM_L3INIT_HSI_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0038)
#define OMAP4_RM_L3INIT_HSI_CONTEXT_OFFSET		0x003c
#define OMAP4430_RM_L3INIT_HSI_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x003c)
#define OMAP4_PM_L3INIT_UNIPRO1_WKDEP_OFFSET		0x0040
#define OMAP4430_PM_L3INIT_UNIPRO1_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0040)
#define OMAP4_RM_L3INIT_UNIPRO1_CONTEXT_OFFSET		0x0044
#define OMAP4430_RM_L3INIT_UNIPRO1_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0044)
#define OMAP4_PM_L3INIT_USB_HOST_WKDEP_OFFSET		0x0058
#define OMAP4430_PM_L3INIT_USB_HOST_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0058)
#define OMAP4_RM_L3INIT_USB_HOST_CONTEXT_OFFSET		0x005c
#define OMAP4430_RM_L3INIT_USB_HOST_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x005c)
#define OMAP4_PM_L3INIT_USB_OTG_WKDEP_OFFSET		0x0060
#define OMAP4430_PM_L3INIT_USB_OTG_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0060)
#define OMAP4_RM_L3INIT_USB_OTG_CONTEXT_OFFSET		0x0064
#define OMAP4430_RM_L3INIT_USB_OTG_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0064)
#define OMAP4_PM_L3INIT_USB_TLL_WKDEP_OFFSET		0x0068
#define OMAP4430_PM_L3INIT_USB_TLL_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0068)
#define OMAP4_RM_L3INIT_USB_TLL_CONTEXT_OFFSET		0x006c
#define OMAP4430_RM_L3INIT_USB_TLL_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x006c)
#define OMAP4_RM_L3INIT_P1500_CONTEXT_OFFSET		0x007c
#define OMAP4430_RM_L3INIT_P1500_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x007c)
#define OMAP4_RM_L3INIT_EMAC_CONTEXT_OFFSET		0x0084
#define OMAP4430_RM_L3INIT_EMAC_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0084)
#define OMAP4_PM_L3INIT_SATA_WKDEP_OFFSET		0x0088
#define OMAP4430_PM_L3INIT_SATA_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0088)
#define OMAP4_RM_L3INIT_SATA_CONTEXT_OFFSET		0x008c
#define OMAP4430_RM_L3INIT_SATA_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x008c)
#define OMAP4_RM_L3INIT_TPPSS_CONTEXT_OFFSET		0x0094
#define OMAP4430_RM_L3INIT_TPPSS_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0094)
#define OMAP4_PM_L3INIT_PCIESS_WKDEP_OFFSET		0x0098
#define OMAP4430_PM_L3INIT_PCIESS_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x0098)
#define OMAP4_RM_L3INIT_PCIESS_CONTEXT_OFFSET		0x009c
#define OMAP4430_RM_L3INIT_PCIESS_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x009c)
#define OMAP4_RM_L3INIT_CCPTX_CONTEXT_OFFSET		0x00ac
#define OMAP4430_RM_L3INIT_CCPTX_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x00ac)
#define OMAP4_PM_L3INIT_XHPI_WKDEP_OFFSET		0x00c0
#define OMAP4430_PM_L3INIT_XHPI_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x00c0)
#define OMAP4_RM_L3INIT_XHPI_CONTEXT_OFFSET		0x00c4
#define OMAP4430_RM_L3INIT_XHPI_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x00c4)
#define OMAP4_PM_L3INIT_MMC6_WKDEP_OFFSET		0x00c8
#define OMAP4430_PM_L3INIT_MMC6_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x00c8)
#define OMAP4_RM_L3INIT_MMC6_CONTEXT_OFFSET		0x00cc
#define OMAP4430_RM_L3INIT_MMC6_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x00cc)
#define OMAP4_PM_L3INIT_USB_HOST_FS_WKDEP_OFFSET	0x00d0
#define OMAP4430_PM_L3INIT_USB_HOST_FS_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x00d0)
#define OMAP4_RM_L3INIT_USB_HOST_FS_CONTEXT_OFFSET	0x00d4
#define OMAP4430_RM_L3INIT_USB_HOST_FS_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x00d4)
#define OMAP4_RM_L3INIT_USBPHYOCP2SCP_CONTEXT_OFFSET	0x00e4
#define OMAP4430_RM_L3INIT_USBPHYOCP2SCP_CONTEXT	OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L3INIT_INST, 0x00e4)

/* PRM.L4PER_PRM register offsets */
#define OMAP4_PM_L4PER_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_L4PER_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0000)
#define OMAP4_PM_L4PER_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_L4PER_PWRSTST			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0004)
#define OMAP4_RM_L4PER_ADC_CONTEXT_OFFSET		0x0024
#define OMAP4430_RM_L4PER_ADC_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0024)
#define OMAP4_PM_L4PER_DMTIMER10_WKDEP_OFFSET		0x0028
#define OMAP4430_PM_L4PER_DMTIMER10_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0028)
#define OMAP4_RM_L4PER_DMTIMER10_CONTEXT_OFFSET		0x002c
#define OMAP4430_RM_L4PER_DMTIMER10_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x002c)
#define OMAP4_PM_L4PER_DMTIMER11_WKDEP_OFFSET		0x0030
#define OMAP4430_PM_L4PER_DMTIMER11_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0030)
#define OMAP4_RM_L4PER_DMTIMER11_CONTEXT_OFFSET		0x0034
#define OMAP4430_RM_L4PER_DMTIMER11_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0034)
#define OMAP4_PM_L4PER_DMTIMER2_WKDEP_OFFSET		0x0038
#define OMAP4430_PM_L4PER_DMTIMER2_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0038)
#define OMAP4_RM_L4PER_DMTIMER2_CONTEXT_OFFSET		0x003c
#define OMAP4430_RM_L4PER_DMTIMER2_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x003c)
#define OMAP4_PM_L4PER_DMTIMER3_WKDEP_OFFSET		0x0040
#define OMAP4430_PM_L4PER_DMTIMER3_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0040)
#define OMAP4_RM_L4PER_DMTIMER3_CONTEXT_OFFSET		0x0044
#define OMAP4430_RM_L4PER_DMTIMER3_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0044)
#define OMAP4_PM_L4PER_DMTIMER4_WKDEP_OFFSET		0x0048
#define OMAP4430_PM_L4PER_DMTIMER4_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0048)
#define OMAP4_RM_L4PER_DMTIMER4_CONTEXT_OFFSET		0x004c
#define OMAP4430_RM_L4PER_DMTIMER4_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x004c)
#define OMAP4_PM_L4PER_DMTIMER9_WKDEP_OFFSET		0x0050
#define OMAP4430_PM_L4PER_DMTIMER9_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0050)
#define OMAP4_RM_L4PER_DMTIMER9_CONTEXT_OFFSET		0x0054
#define OMAP4430_RM_L4PER_DMTIMER9_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0054)
#define OMAP4_RM_L4PER_ELM_CONTEXT_OFFSET		0x005c
#define OMAP4430_RM_L4PER_ELM_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x005c)
#define OMAP4_PM_L4PER_GPIO2_WKDEP_OFFSET		0x0060
#define OMAP4430_PM_L4PER_GPIO2_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0060)
#define OMAP4_RM_L4PER_GPIO2_CONTEXT_OFFSET		0x0064
#define OMAP4430_RM_L4PER_GPIO2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0064)
#define OMAP4_PM_L4PER_GPIO3_WKDEP_OFFSET		0x0068
#define OMAP4430_PM_L4PER_GPIO3_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0068)
#define OMAP4_RM_L4PER_GPIO3_CONTEXT_OFFSET		0x006c
#define OMAP4430_RM_L4PER_GPIO3_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x006c)
#define OMAP4_PM_L4PER_GPIO4_WKDEP_OFFSET		0x0070
#define OMAP4430_PM_L4PER_GPIO4_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0070)
#define OMAP4_RM_L4PER_GPIO4_CONTEXT_OFFSET		0x0074
#define OMAP4430_RM_L4PER_GPIO4_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0074)
#define OMAP4_PM_L4PER_GPIO5_WKDEP_OFFSET		0x0078
#define OMAP4430_PM_L4PER_GPIO5_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0078)
#define OMAP4_RM_L4PER_GPIO5_CONTEXT_OFFSET		0x007c
#define OMAP4430_RM_L4PER_GPIO5_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x007c)
#define OMAP4_PM_L4PER_GPIO6_WKDEP_OFFSET		0x0080
#define OMAP4430_PM_L4PER_GPIO6_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0080)
#define OMAP4_RM_L4PER_GPIO6_CONTEXT_OFFSET		0x0084
#define OMAP4430_RM_L4PER_GPIO6_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0084)
#define OMAP4_RM_L4PER_HDQ1W_CONTEXT_OFFSET		0x008c
#define OMAP4430_RM_L4PER_HDQ1W_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x008c)
#define OMAP4_PM_L4PER_HECC1_WKDEP_OFFSET		0x0090
#define OMAP4430_PM_L4PER_HECC1_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0090)
#define OMAP4_RM_L4PER_HECC1_CONTEXT_OFFSET		0x0094
#define OMAP4430_RM_L4PER_HECC1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0094)
#define OMAP4_PM_L4PER_HECC2_WKDEP_OFFSET		0x0098
#define OMAP4430_PM_L4PER_HECC2_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0098)
#define OMAP4_RM_L4PER_HECC2_CONTEXT_OFFSET		0x009c
#define OMAP4430_RM_L4PER_HECC2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x009c)
#define OMAP4_PM_L4PER_I2C1_WKDEP_OFFSET		0x00a0
#define OMAP4430_PM_L4PER_I2C1_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00a0)
#define OMAP4_RM_L4PER_I2C1_CONTEXT_OFFSET		0x00a4
#define OMAP4430_RM_L4PER_I2C1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00a4)
#define OMAP4_PM_L4PER_I2C2_WKDEP_OFFSET		0x00a8
#define OMAP4430_PM_L4PER_I2C2_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00a8)
#define OMAP4_RM_L4PER_I2C2_CONTEXT_OFFSET		0x00ac
#define OMAP4430_RM_L4PER_I2C2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00ac)
#define OMAP4_PM_L4PER_I2C3_WKDEP_OFFSET		0x00b0
#define OMAP4430_PM_L4PER_I2C3_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00b0)
#define OMAP4_RM_L4PER_I2C3_CONTEXT_OFFSET		0x00b4
#define OMAP4430_RM_L4PER_I2C3_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00b4)
#define OMAP4_PM_L4PER_I2C4_WKDEP_OFFSET		0x00b8
#define OMAP4430_PM_L4PER_I2C4_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00b8)
#define OMAP4_RM_L4PER_I2C4_CONTEXT_OFFSET		0x00bc
#define OMAP4430_RM_L4PER_I2C4_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00bc)
#define OMAP4_RM_L4PER_L4_PER_CONTEXT_OFFSET		0x00c0
#define OMAP4430_RM_L4PER_L4_PER_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00c0)
#define OMAP4_PM_L4PER_MCASP2_WKDEP_OFFSET		0x00d0
#define OMAP4430_PM_L4PER_MCASP2_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00d0)
#define OMAP4_RM_L4PER_MCASP2_CONTEXT_OFFSET		0x00d4
#define OMAP4430_RM_L4PER_MCASP2_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00d4)
#define OMAP4_PM_L4PER_MCASP3_WKDEP_OFFSET		0x00d8
#define OMAP4430_PM_L4PER_MCASP3_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00d8)
#define OMAP4_RM_L4PER_MCASP3_CONTEXT_OFFSET		0x00dc
#define OMAP4430_RM_L4PER_MCASP3_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00dc)
#define OMAP4_PM_L4PER_MCBSP4_WKDEP_OFFSET		0x00e0
#define OMAP4430_PM_L4PER_MCBSP4_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00e0)
#define OMAP4_RM_L4PER_MCBSP4_CONTEXT_OFFSET		0x00e4
#define OMAP4430_RM_L4PER_MCBSP4_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00e4)
#define OMAP4_RM_L4PER_MGATE_CONTEXT_OFFSET		0x00ec
#define OMAP4430_RM_L4PER_MGATE_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00ec)
#define OMAP4_PM_L4PER_MCSPI1_WKDEP_OFFSET		0x00f0
#define OMAP4430_PM_L4PER_MCSPI1_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00f0)
#define OMAP4_RM_L4PER_MCSPI1_CONTEXT_OFFSET		0x00f4
#define OMAP4430_RM_L4PER_MCSPI1_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00f4)
#define OMAP4_PM_L4PER_MCSPI2_WKDEP_OFFSET		0x00f8
#define OMAP4430_PM_L4PER_MCSPI2_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00f8)
#define OMAP4_RM_L4PER_MCSPI2_CONTEXT_OFFSET		0x00fc
#define OMAP4430_RM_L4PER_MCSPI2_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x00fc)
#define OMAP4_PM_L4PER_MCSPI3_WKDEP_OFFSET		0x0100
#define OMAP4430_PM_L4PER_MCSPI3_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0100)
#define OMAP4_RM_L4PER_MCSPI3_CONTEXT_OFFSET		0x0104
#define OMAP4430_RM_L4PER_MCSPI3_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0104)
#define OMAP4_PM_L4PER_MCSPI4_WKDEP_OFFSET		0x0108
#define OMAP4430_PM_L4PER_MCSPI4_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0108)
#define OMAP4_RM_L4PER_MCSPI4_CONTEXT_OFFSET		0x010c
#define OMAP4430_RM_L4PER_MCSPI4_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x010c)
#define OMAP4_PM_L4PER_MMCSD3_WKDEP_OFFSET		0x0120
#define OMAP4430_PM_L4PER_MMCSD3_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0120)
#define OMAP4_RM_L4PER_MMCSD3_CONTEXT_OFFSET		0x0124
#define OMAP4430_RM_L4PER_MMCSD3_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0124)
#define OMAP4_PM_L4PER_MMCSD4_WKDEP_OFFSET		0x0128
#define OMAP4430_PM_L4PER_MMCSD4_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0128)
#define OMAP4_RM_L4PER_MMCSD4_CONTEXT_OFFSET		0x012c
#define OMAP4430_RM_L4PER_MMCSD4_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x012c)
#define OMAP4_RM_L4PER_MSPROHG_CONTEXT_OFFSET		0x0134
#define OMAP4430_RM_L4PER_MSPROHG_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0134)
#define OMAP4_PM_L4PER_SLIMBUS2_WKDEP_OFFSET		0x0138
#define OMAP4430_PM_L4PER_SLIMBUS2_WKDEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0138)
#define OMAP4_RM_L4PER_SLIMBUS2_CONTEXT_OFFSET		0x013c
#define OMAP4430_RM_L4PER_SLIMBUS2_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x013c)
#define OMAP4_PM_L4PER_UART1_WKDEP_OFFSET		0x0140
#define OMAP4430_PM_L4PER_UART1_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0140)
#define OMAP4_RM_L4PER_UART1_CONTEXT_OFFSET		0x0144
#define OMAP4430_RM_L4PER_UART1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0144)
#define OMAP4_PM_L4PER_UART2_WKDEP_OFFSET		0x0148
#define OMAP4430_PM_L4PER_UART2_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0148)
#define OMAP4_RM_L4PER_UART2_CONTEXT_OFFSET		0x014c
#define OMAP4430_RM_L4PER_UART2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x014c)
#define OMAP4_PM_L4PER_UART3_WKDEP_OFFSET		0x0150
#define OMAP4430_PM_L4PER_UART3_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0150)
#define OMAP4_RM_L4PER_UART3_CONTEXT_OFFSET		0x0154
#define OMAP4430_RM_L4PER_UART3_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0154)
#define OMAP4_PM_L4PER_UART4_WKDEP_OFFSET		0x0158
#define OMAP4430_PM_L4PER_UART4_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0158)
#define OMAP4_RM_L4PER_UART4_CONTEXT_OFFSET		0x015c
#define OMAP4430_RM_L4PER_UART4_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x015c)
#define OMAP4_PM_L4PER_MMCSD5_WKDEP_OFFSET		0x0160
#define OMAP4430_PM_L4PER_MMCSD5_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0160)
#define OMAP4_RM_L4PER_MMCSD5_CONTEXT_OFFSET		0x0164
#define OMAP4430_RM_L4PER_MMCSD5_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0164)
#define OMAP4_PM_L4PER_I2C5_WKDEP_OFFSET		0x0168
#define OMAP4430_PM_L4PER_I2C5_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x0168)
#define OMAP4_RM_L4PER_I2C5_CONTEXT_OFFSET		0x016c
#define OMAP4430_RM_L4PER_I2C5_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x016c)
#define OMAP4_RM_L4SEC_AES1_CONTEXT_OFFSET		0x01a4
#define OMAP4430_RM_L4SEC_AES1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x01a4)
#define OMAP4_RM_L4SEC_AES2_CONTEXT_OFFSET		0x01ac
#define OMAP4430_RM_L4SEC_AES2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x01ac)
#define OMAP4_RM_L4SEC_DES3DES_CONTEXT_OFFSET		0x01b4
#define OMAP4430_RM_L4SEC_DES3DES_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x01b4)
#define OMAP4_RM_L4SEC_PKAEIP29_CONTEXT_OFFSET		0x01bc
#define OMAP4430_RM_L4SEC_PKAEIP29_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x01bc)
#define OMAP4_RM_L4SEC_RNG_CONTEXT_OFFSET		0x01c4
#define OMAP4430_RM_L4SEC_RNG_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x01c4)
#define OMAP4_RM_L4SEC_SHA2MD51_CONTEXT_OFFSET		0x01cc
#define OMAP4430_RM_L4SEC_SHA2MD51_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x01cc)
#define OMAP4_RM_L4SEC_CRYPTODMA_CONTEXT_OFFSET		0x01dc
#define OMAP4430_RM_L4SEC_CRYPTODMA_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_L4PER_INST, 0x01dc)

/* PRM.CEFUSE_PRM register offsets */
#define OMAP4_PM_CEFUSE_PWRSTCTRL_OFFSET		0x0000
#define OMAP4430_PM_CEFUSE_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CEFUSE_INST, 0x0000)
#define OMAP4_PM_CEFUSE_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_CEFUSE_PWRSTST			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CEFUSE_INST, 0x0004)
#define OMAP4_RM_CEFUSE_CEFUSE_CONTEXT_OFFSET		0x0024
#define OMAP4430_RM_CEFUSE_CEFUSE_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_CEFUSE_INST, 0x0024)

/* PRM.WKUP_PRM register offsets */
#define OMAP4_RM_WKUP_L4WKUP_CONTEXT_OFFSET		0x0024
#define OMAP4430_RM_WKUP_L4WKUP_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0024)
#define OMAP4_RM_WKUP_WDT1_CONTEXT_OFFSET		0x002c
#define OMAP4430_RM_WKUP_WDT1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x002c)
#define OMAP4_PM_WKUP_WDT2_WKDEP_OFFSET			0x0030
#define OMAP4430_PM_WKUP_WDT2_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0030)
#define OMAP4_RM_WKUP_WDT2_CONTEXT_OFFSET		0x0034
#define OMAP4430_RM_WKUP_WDT2_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0034)
#define OMAP4_PM_WKUP_GPIO1_WKDEP_OFFSET		0x0038
#define OMAP4430_PM_WKUP_GPIO1_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0038)
#define OMAP4_RM_WKUP_GPIO1_CONTEXT_OFFSET		0x003c
#define OMAP4430_RM_WKUP_GPIO1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x003c)
#define OMAP4_PM_WKUP_TIMER1_WKDEP_OFFSET		0x0040
#define OMAP4430_PM_WKUP_TIMER1_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0040)
#define OMAP4_RM_WKUP_TIMER1_CONTEXT_OFFSET		0x0044
#define OMAP4430_RM_WKUP_TIMER1_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0044)
#define OMAP4_PM_WKUP_TIMER12_WKDEP_OFFSET		0x0048
#define OMAP4430_PM_WKUP_TIMER12_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0048)
#define OMAP4_RM_WKUP_TIMER12_CONTEXT_OFFSET		0x004c
#define OMAP4430_RM_WKUP_TIMER12_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x004c)
#define OMAP4_RM_WKUP_SYNCTIMER_CONTEXT_OFFSET		0x0054
#define OMAP4430_RM_WKUP_SYNCTIMER_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0054)
#define OMAP4_PM_WKUP_USIM_WKDEP_OFFSET			0x0058
#define OMAP4430_PM_WKUP_USIM_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0058)
#define OMAP4_RM_WKUP_USIM_CONTEXT_OFFSET		0x005c
#define OMAP4430_RM_WKUP_USIM_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x005c)
#define OMAP4_RM_WKUP_SARRAM_CONTEXT_OFFSET		0x0064
#define OMAP4430_RM_WKUP_SARRAM_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0064)
#define OMAP4_PM_WKUP_KEYBOARD_WKDEP_OFFSET		0x0078
#define OMAP4430_PM_WKUP_KEYBOARD_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0078)
#define OMAP4_RM_WKUP_KEYBOARD_CONTEXT_OFFSET		0x007c
#define OMAP4430_RM_WKUP_KEYBOARD_CONTEXT		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x007c)
#define OMAP4_PM_WKUP_RTC_WKDEP_OFFSET			0x0080
#define OMAP4430_PM_WKUP_RTC_WKDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0080)
#define OMAP4_RM_WKUP_RTC_CONTEXT_OFFSET		0x0084
#define OMAP4430_RM_WKUP_RTC_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_INST, 0x0084)

/* PRM.WKUP_CM register offsets */
#define OMAP4_CM_WKUP_CLKSTCTRL_OFFSET			0x0000
#define OMAP4430_CM_WKUP_CLKSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0000)
#define OMAP4_CM_WKUP_L4WKUP_CLKCTRL_OFFSET		0x0020
#define OMAP4430_CM_WKUP_L4WKUP_CLKCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0020)
#define OMAP4_CM_WKUP_WDT1_CLKCTRL_OFFSET		0x0028
#define OMAP4430_CM_WKUP_WDT1_CLKCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0028)
#define OMAP4_CM_WKUP_WDT2_CLKCTRL_OFFSET		0x0030
#define OMAP4430_CM_WKUP_WDT2_CLKCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0030)
#define OMAP4_CM_WKUP_GPIO1_CLKCTRL_OFFSET		0x0038
#define OMAP4430_CM_WKUP_GPIO1_CLKCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0038)
#define OMAP4_CM_WKUP_TIMER1_CLKCTRL_OFFSET		0x0040
#define OMAP4430_CM_WKUP_TIMER1_CLKCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0040)
#define OMAP4_CM_WKUP_TIMER12_CLKCTRL_OFFSET		0x0048
#define OMAP4430_CM_WKUP_TIMER12_CLKCTRL		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0048)
#define OMAP4_CM_WKUP_SYNCTIMER_CLKCTRL_OFFSET		0x0050
#define OMAP4430_CM_WKUP_SYNCTIMER_CLKCTRL		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0050)
#define OMAP4_CM_WKUP_USIM_CLKCTRL_OFFSET		0x0058
#define OMAP4430_CM_WKUP_USIM_CLKCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0058)
#define OMAP4_CM_WKUP_SARRAM_CLKCTRL_OFFSET		0x0060
#define OMAP4430_CM_WKUP_SARRAM_CLKCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0060)
#define OMAP4_CM_WKUP_KEYBOARD_CLKCTRL_OFFSET		0x0078
#define OMAP4430_CM_WKUP_KEYBOARD_CLKCTRL		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0078)
#define OMAP4_CM_WKUP_RTC_CLKCTRL_OFFSET		0x0080
#define OMAP4430_CM_WKUP_RTC_CLKCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0080)
#define OMAP4_CM_WKUP_BANDGAP_CLKCTRL_OFFSET		0x0088
#define OMAP4430_CM_WKUP_BANDGAP_CLKCTRL		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_WKUP_CM_INST, 0x0088)

/* PRM.EMU_PRM register offsets */
#define OMAP4_PM_EMU_PWRSTCTRL_OFFSET			0x0000
#define OMAP4430_PM_EMU_PWRSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_EMU_INST, 0x0000)
#define OMAP4_PM_EMU_PWRSTST_OFFSET			0x0004
#define OMAP4430_PM_EMU_PWRSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_EMU_INST, 0x0004)
#define OMAP4_RM_EMU_DEBUGSS_CONTEXT_OFFSET		0x0024
#define OMAP4430_RM_EMU_DEBUGSS_CONTEXT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_EMU_INST, 0x0024)

/* PRM.EMU_CM register offsets */
#define OMAP4_CM_EMU_CLKSTCTRL_OFFSET			0x0000
#define OMAP4430_CM_EMU_CLKSTCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_EMU_CM_INST, 0x0000)
#define OMAP4_CM_EMU_DYNAMICDEP_OFFSET			0x0008
#define OMAP4430_CM_EMU_DYNAMICDEP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_EMU_CM_INST, 0x0008)
#define OMAP4_CM_EMU_DEBUGSS_CLKCTRL_OFFSET		0x0020
#define OMAP4430_CM_EMU_DEBUGSS_CLKCTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_EMU_CM_INST, 0x0020)

/* PRM.DEVICE_PRM register offsets */
#define OMAP4_PRM_RSTCTRL_OFFSET			0x0000
#define OMAP4430_PRM_RSTCTRL				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0000)
#define OMAP4_PRM_RSTST_OFFSET				0x0004
#define OMAP4430_PRM_RSTST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0004)
#define OMAP4_PRM_RSTTIME_OFFSET			0x0008
#define OMAP4430_PRM_RSTTIME				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0008)
#define OMAP4_PRM_CLKREQCTRL_OFFSET			0x000c
#define OMAP4430_PRM_CLKREQCTRL				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x000c)
#define OMAP4_PRM_VOLTCTRL_OFFSET			0x0010
#define OMAP4430_PRM_VOLTCTRL				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0010)
#define OMAP4_PRM_PWRREQCTRL_OFFSET			0x0014
#define OMAP4430_PRM_PWRREQCTRL				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0014)
#define OMAP4_PRM_PSCON_COUNT_OFFSET			0x0018
#define OMAP4430_PRM_PSCON_COUNT			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0018)
#define OMAP4_PRM_IO_COUNT_OFFSET			0x001c
#define OMAP4430_PRM_IO_COUNT				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x001c)
#define OMAP4_PRM_IO_PMCTRL_OFFSET			0x0020
#define OMAP4430_PRM_IO_PMCTRL				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0020)
#define OMAP4_PRM_VOLTSETUP_WARMRESET_OFFSET		0x0024
#define OMAP4430_PRM_VOLTSETUP_WARMRESET		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0024)
#define OMAP4_PRM_VOLTSETUP_CORE_OFF_OFFSET		0x0028
#define OMAP4430_PRM_VOLTSETUP_CORE_OFF			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0028)
#define OMAP4_PRM_VOLTSETUP_MPU_OFF_OFFSET		0x002c
#define OMAP4430_PRM_VOLTSETUP_MPU_OFF			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x002c)
#define OMAP4_PRM_VOLTSETUP_IVA_OFF_OFFSET		0x0030
#define OMAP4430_PRM_VOLTSETUP_IVA_OFF			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0030)
#define OMAP4_PRM_VOLTSETUP_CORE_RET_SLEEP_OFFSET	0x0034
#define OMAP4430_PRM_VOLTSETUP_CORE_RET_SLEEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0034)
#define OMAP4_PRM_VOLTSETUP_MPU_RET_SLEEP_OFFSET	0x0038
#define OMAP4430_PRM_VOLTSETUP_MPU_RET_SLEEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0038)
#define OMAP4_PRM_VOLTSETUP_IVA_RET_SLEEP_OFFSET	0x003c
#define OMAP4430_PRM_VOLTSETUP_IVA_RET_SLEEP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x003c)
#define OMAP4_PRM_VP_CORE_CONFIG_OFFSET			0x0040
#define OMAP4430_PRM_VP_CORE_CONFIG			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0040)
#define OMAP4_PRM_VP_CORE_STATUS_OFFSET			0x0044
#define OMAP4430_PRM_VP_CORE_STATUS			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0044)
#define OMAP4_PRM_VP_CORE_VLIMITTO_OFFSET		0x0048
#define OMAP4430_PRM_VP_CORE_VLIMITTO			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0048)
#define OMAP4_PRM_VP_CORE_VOLTAGE_OFFSET		0x004c
#define OMAP4430_PRM_VP_CORE_VOLTAGE			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x004c)
#define OMAP4_PRM_VP_CORE_VSTEPMAX_OFFSET		0x0050
#define OMAP4430_PRM_VP_CORE_VSTEPMAX			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0050)
#define OMAP4_PRM_VP_CORE_VSTEPMIN_OFFSET		0x0054
#define OMAP4430_PRM_VP_CORE_VSTEPMIN			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0054)
#define OMAP4_PRM_VP_MPU_CONFIG_OFFSET			0x0058
#define OMAP4430_PRM_VP_MPU_CONFIG			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0058)
#define OMAP4_PRM_VP_MPU_STATUS_OFFSET			0x005c
#define OMAP4430_PRM_VP_MPU_STATUS			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x005c)
#define OMAP4_PRM_VP_MPU_VLIMITTO_OFFSET		0x0060
#define OMAP4430_PRM_VP_MPU_VLIMITTO			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0060)
#define OMAP4_PRM_VP_MPU_VOLTAGE_OFFSET			0x0064
#define OMAP4430_PRM_VP_MPU_VOLTAGE			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0064)
#define OMAP4_PRM_VP_MPU_VSTEPMAX_OFFSET		0x0068
#define OMAP4430_PRM_VP_MPU_VSTEPMAX			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0068)
#define OMAP4_PRM_VP_MPU_VSTEPMIN_OFFSET		0x006c
#define OMAP4430_PRM_VP_MPU_VSTEPMIN			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x006c)
#define OMAP4_PRM_VP_IVA_CONFIG_OFFSET			0x0070
#define OMAP4430_PRM_VP_IVA_CONFIG			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0070)
#define OMAP4_PRM_VP_IVA_STATUS_OFFSET			0x0074
#define OMAP4430_PRM_VP_IVA_STATUS			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0074)
#define OMAP4_PRM_VP_IVA_VLIMITTO_OFFSET		0x0078
#define OMAP4430_PRM_VP_IVA_VLIMITTO			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0078)
#define OMAP4_PRM_VP_IVA_VOLTAGE_OFFSET			0x007c
#define OMAP4430_PRM_VP_IVA_VOLTAGE			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x007c)
#define OMAP4_PRM_VP_IVA_VSTEPMAX_OFFSET		0x0080
#define OMAP4430_PRM_VP_IVA_VSTEPMAX			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0080)
#define OMAP4_PRM_VP_IVA_VSTEPMIN_OFFSET		0x0084
#define OMAP4430_PRM_VP_IVA_VSTEPMIN			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0084)
#define OMAP4_PRM_VC_SMPS_SA_OFFSET			0x0088
#define OMAP4430_PRM_VC_SMPS_SA				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0088)
#define OMAP4_PRM_VC_VAL_SMPS_RA_VOL_OFFSET		0x008c
#define OMAP4430_PRM_VC_VAL_SMPS_RA_VOL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x008c)
#define OMAP4_PRM_VC_VAL_SMPS_RA_CMD_OFFSET		0x0090
#define OMAP4430_PRM_VC_VAL_SMPS_RA_CMD			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0090)
#define OMAP4_PRM_VC_VAL_CMD_VDD_CORE_L_OFFSET		0x0094
#define OMAP4430_PRM_VC_VAL_CMD_VDD_CORE_L		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0094)
#define OMAP4_PRM_VC_VAL_CMD_VDD_MPU_L_OFFSET		0x0098
#define OMAP4430_PRM_VC_VAL_CMD_VDD_MPU_L		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x0098)
#define OMAP4_PRM_VC_VAL_CMD_VDD_IVA_L_OFFSET		0x009c
#define OMAP4430_PRM_VC_VAL_CMD_VDD_IVA_L		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x009c)
#define OMAP4_PRM_VC_VAL_BYPASS_OFFSET			0x00a0
#define OMAP4430_PRM_VC_VAL_BYPASS			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00a0)
#define OMAP4_PRM_VC_CFG_CHANNEL_OFFSET			0x00a4
#define OMAP4430_PRM_VC_CFG_CHANNEL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00a4)
#define OMAP4_PRM_VC_CFG_I2C_MODE_OFFSET		0x00a8
#define OMAP4430_PRM_VC_CFG_I2C_MODE			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00a8)
#define OMAP4_PRM_VC_CFG_I2C_CLK_OFFSET			0x00ac
#define OMAP4430_PRM_VC_CFG_I2C_CLK			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00ac)
#define OMAP4_PRM_SRAM_COUNT_OFFSET			0x00b0
#define OMAP4430_PRM_SRAM_COUNT				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00b0)
#define OMAP4_PRM_SRAM_WKUP_SETUP_OFFSET		0x00b4
#define OMAP4430_PRM_SRAM_WKUP_SETUP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00b4)
#define OMAP4_PRM_LDO_SRAM_CORE_SETUP_OFFSET		0x00b8
#define OMAP4430_PRM_LDO_SRAM_CORE_SETUP		OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00b8)
#define OMAP4_PRM_LDO_SRAM_CORE_CTRL_OFFSET		0x00bc
#define OMAP4430_PRM_LDO_SRAM_CORE_CTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00bc)
#define OMAP4_PRM_LDO_SRAM_MPU_SETUP_OFFSET		0x00c0
#define OMAP4430_PRM_LDO_SRAM_MPU_SETUP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00c0)
#define OMAP4_PRM_LDO_SRAM_MPU_CTRL_OFFSET		0x00c4
#define OMAP4430_PRM_LDO_SRAM_MPU_CTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00c4)
#define OMAP4_PRM_LDO_SRAM_IVA_SETUP_OFFSET		0x00c8
#define OMAP4430_PRM_LDO_SRAM_IVA_SETUP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00c8)
#define OMAP4_PRM_LDO_SRAM_IVA_CTRL_OFFSET		0x00cc
#define OMAP4430_PRM_LDO_SRAM_IVA_CTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00cc)
#define OMAP4_PRM_LDO_ABB_MPU_SETUP_OFFSET		0x00d0
#define OMAP4430_PRM_LDO_ABB_MPU_SETUP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00d0)
#define OMAP4_PRM_LDO_ABB_MPU_CTRL_OFFSET		0x00d4
#define OMAP4430_PRM_LDO_ABB_MPU_CTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00d4)
#define OMAP4_PRM_LDO_ABB_IVA_SETUP_OFFSET		0x00d8
#define OMAP4430_PRM_LDO_ABB_IVA_SETUP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00d8)
#define OMAP4_PRM_LDO_ABB_IVA_CTRL_OFFSET		0x00dc
#define OMAP4430_PRM_LDO_ABB_IVA_CTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00dc)
#define OMAP4_PRM_LDO_BANDGAP_SETUP_OFFSET		0x00e0
#define OMAP4430_PRM_LDO_BANDGAP_SETUP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00e0)
#define OMAP4_PRM_DEVICE_OFF_CTRL_OFFSET		0x00e4
#define OMAP4430_PRM_DEVICE_OFF_CTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00e4)
#define OMAP4_PRM_PHASE1_CNDP_OFFSET			0x00e8
#define OMAP4430_PRM_PHASE1_CNDP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00e8)
#define OMAP4_PRM_PHASE2A_CNDP_OFFSET			0x00ec
#define OMAP4430_PRM_PHASE2A_CNDP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00ec)
#define OMAP4_PRM_PHASE2B_CNDP_OFFSET			0x00f0
#define OMAP4430_PRM_PHASE2B_CNDP			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00f0)
#define OMAP4_PRM_MODEM_IF_CTRL_OFFSET			0x00f4
#define OMAP4430_PRM_MODEM_IF_CTRL			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00f4)
#define OMAP4_PRM_VC_ERRST_OFFSET			0x00f8
#define OMAP4430_PRM_VC_ERRST				OMAP44XX_PRM_REGADDR(OMAP4430_PRM_DEVICE_INST, 0x00f8)

/* Function prototypes */
# ifndef __ASSEMBLER__

extern u32 omap4_prm_read_inst_reg(s16 inst, u16 idx);
extern void omap4_prm_write_inst_reg(u32 val, s16 inst, u16 idx);
extern u32 omap4_prm_rmw_inst_reg_bits(u32 mask, u32 bits, s16 inst, s16 idx);

/* OMAP4-specific VP functions */
u32 omap4_prm_vp_check_txdone(u8 vp_id);
void omap4_prm_vp_clear_txdone(u8 vp_id);

/*
 * OMAP4 access functions for voltage controller (VC) and
 * voltage proccessor (VP) in the PRM.
 */
extern u32 omap4_prm_vcvp_read(u8 offset);
extern void omap4_prm_vcvp_write(u32 val, u8 offset);
extern u32 omap4_prm_vcvp_rmw(u32 mask, u32 bits, u8 offset);

# endif

#endif
