#ifndef __MACH_MX51_H__
#define __MACH_MX51_H__

/*
 * IROM
 */
#define MX51_IROM_BASE_ADDR		0x0
#define MX51_IROM_SIZE			SZ_64K

/*
 * IRAM
 */
#define MX51_IRAM_BASE_ADDR		0x1ffe0000	/* internal ram */
#define MX51_IRAM_PARTITIONS		16
#define MX51_IRAM_SIZE		(MX51_IRAM_PARTITIONS * SZ_8K)	/* 128KB */

#define MX51_GPU_BASE_ADDR		0x20000000
#define MX51_GPU_CTRL_BASE_ADDR		0x30000000
#define MX51_IPU_CTRL_BASE_ADDR		0x40000000

/*
 * SPBA global module enabled #0
 */
#define MX51_SPBA0_BASE_ADDR		0x70000000
#define MX51_SPBA0_SIZE			SZ_1M

#define MX51_ESDHC1_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x04000)
#define MX51_ESDHC2_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x08000)
#define MX51_UART3_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x0c000)
#define MX51_ECSPI1_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x10000)
#define MX51_SSI2_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x14000)
#define MX51_ESDHC3_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x20000)
#define MX51_ESDHC4_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x24000)
#define MX51_SPDIF_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x28000)
#define MX51_ATA_DMA_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x30000)
#define MX51_SLIM_DMA_BASE_ADDR		(MX51_SPBA0_BASE_ADDR + 0x34000)
#define MX51_HSI2C_DMA_BASE_ADDR	(MX51_SPBA0_BASE_ADDR + 0x38000)
#define MX51_SPBA_CTRL_BASE_ADDR	(MX51_SPBA0_BASE_ADDR + 0x3c000)

/*
 * AIPS 1
 */
#define MX51_AIPS1_BASE_ADDR		0x73f00000
#define MX51_AIPS1_SIZE			SZ_1M

#define MX51_USB_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0x80000)
#define MX51_USB_OTG_BASE_ADDR		(MX51_USB_BASE_ADDR + 0x0000)
#define MX51_USB_HS1_BASE_ADDR		(MX51_USB_BASE_ADDR + 0x0200)
#define MX51_USB_HS2_BASE_ADDR		(MX51_USB_BASE_ADDR + 0x0400)
#define MX51_GPIO1_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0x84000)
#define MX51_GPIO2_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0x88000)
#define MX51_GPIO3_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0x8c000)
#define MX51_GPIO4_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0x90000)
#define MX51_KPP_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0x94000)
#define MX51_WDOG1_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0x98000)
#define MX51_WDOG2_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0x9c000)
#define MX51_GPT1_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xa0000)
#define MX51_SRTC_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xa4000)
#define MX51_IOMUXC_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xa8000)
#define MX51_EPIT1_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xac000)
#define MX51_EPIT2_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xb0000)
#define MX51_PWM1_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xb4000)
#define MX51_PWM2_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xb8000)
#define MX51_UART1_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xbc000)
#define MX51_UART2_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xc0000)
#define MX51_SRC_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xd0000)
#define MX51_CCM_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xd4000)
#define MX51_GPC_BASE_ADDR		(MX51_AIPS1_BASE_ADDR + 0xd8000)

/*
 * AIPS 2
 */
#define MX51_AIPS2_BASE_ADDR		0x83f00000
#define MX51_AIPS2_SIZE			SZ_1M

#define MX51_PLL1_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0x80000)
#define MX51_PLL2_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0x84000)
#define MX51_PLL3_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0x88000)
#define MX51_AHBMAX_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0x94000)
#define MX51_IIM_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0x98000)
#define MX51_CSU_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0x9c000)
#define MX51_ARM_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xa0000)
#define MX51_OWIRE_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xa4000)
#define MX51_FIRI_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xa8000)
#define MX51_ECSPI2_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xac000)
#define MX51_SDMA_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xb0000)
#define MX51_SCC_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xb4000)
#define MX51_ROMCP_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xb8000)
#define MX51_RTIC_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xbc000)
#define MX51_CSPI_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xc0000)
#define MX51_I2C2_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xc4000)
#define MX51_I2C1_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xc8000)
#define MX51_SSI1_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xcc000)
#define MX51_AUDMUX_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xd0000)
#define MX51_M4IF_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xd8000)
#define MX51_ESDCTL_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xd9000)
#define MX51_WEIM_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xda000)
#define MX51_NFC_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xdb000)
#define MX51_EMI_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xdbf00)
#define MX51_MIPI_HSC_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xdc000)
#define MX51_ATA_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xe0000)
#define MX51_SIM_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xe4000)
#define MX51_SSI3_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xe8000)
#define MX51_FEC_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xec000)
#define MX51_TVE_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xf0000)
#define MX51_VPU_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xf4000)
#define MX51_SAHARA_BASE_ADDR		(MX51_AIPS2_BASE_ADDR + 0xf8000)

#define MX51_CSD0_BASE_ADDR		0x90000000
#define MX51_CSD1_BASE_ADDR		0xa0000000
#define MX51_CS0_BASE_ADDR		0xb0000000
#define MX51_CS1_BASE_ADDR		0xb8000000
#define MX51_CS2_BASE_ADDR		0xc0000000
#define MX51_CS3_BASE_ADDR		0xc8000000
#define MX51_CS4_BASE_ADDR		0xcc000000
#define MX51_CS5_BASE_ADDR		0xce000000

/*
 * NFC
 */
#define MX51_NFC_AXI_BASE_ADDR		0xcfff0000	/* NAND flash AXI */
#define MX51_NFC_AXI_SIZE		SZ_64K

#define MX51_GPU2D_BASE_ADDR		0xd0000000
#define MX51_TZIC_BASE_ADDR		0xe0000000
#define MX51_TZIC_SIZE			SZ_16K

#define MX51_IO_P2V(x)			IMX_IO_P2V(x)
#define MX51_IO_ADDRESS(x)		IOMEM(MX51_IO_P2V(x))

/*
 * defines for SPBA modules
 */
#define MX51_SPBA_SDHC1	0x04
#define MX51_SPBA_SDHC2	0x08
#define MX51_SPBA_UART3	0x0c
#define MX51_SPBA_CSPI1	0x10
#define MX51_SPBA_SSI2	0x14
#define MX51_SPBA_SDHC3	0x20
#define MX51_SPBA_SDHC4	0x24
#define MX51_SPBA_SPDIF	0x28
#define MX51_SPBA_ATA	0x30
#define MX51_SPBA_SLIM	0x34
#define MX51_SPBA_HSI2C	0x38
#define MX51_SPBA_CTRL	0x3c

/*
 * Defines for modules using static and dynamic DMA channels
 */
#define MX51_MXC_DMA_CHANNEL_IRAM	30
#define MX51_MXC_DMA_CHANNEL_SPDIF_TX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_UART1_RX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_UART1_TX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_UART2_RX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_UART2_TX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_UART3_RX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_UART3_TX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_MMC1	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_MMC2	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_SSI1_RX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_SSI1_TX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_SSI2_RX	MXC_DMA_DYNAMIC_CHANNEL
#ifdef CONFIG_SDMA_IRAM
#define MX51_MXC_DMA_CHANNEL_SSI2_TX	(MX51_MXC_DMA_CHANNEL_IRAM + 1)
#else				/*CONFIG_SDMA_IRAM */
#define MX51_MXC_DMA_CHANNEL_SSI2_TX	MXC_DMA_DYNAMIC_CHANNEL
#endif				/*CONFIG_SDMA_IRAM */
#define MX51_MXC_DMA_CHANNEL_CSPI1_RX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_CSPI1_TX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_CSPI2_RX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_CSPI2_TX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_CSPI3_RX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_CSPI3_TX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_ATA_RX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_ATA_TX	MXC_DMA_DYNAMIC_CHANNEL
#define MX51_MXC_DMA_CHANNEL_MEMORY	MXC_DMA_DYNAMIC_CHANNEL

#define MX51_IS_MEM_DEVICE_NONSHARED(x)		0

/*
 * DMA request assignments
 */
#define MX51_DMA_REQ_VPU		0
#define MX51_DMA_REQ_GPC		1
#define MX51_DMA_REQ_ATA_RX		2
#define MX51_DMA_REQ_ATA_TX		3
#define MX51_DMA_REQ_ATA_TX_END		4
#define MX51_DMA_REQ_SLIM_B		5
#define MX51_DMA_REQ_CSPI1_RX		6
#define MX51_DMA_REQ_CSPI1_TX		7
#define MX51_DMA_REQ_CSPI2_RX		8
#define MX51_DMA_REQ_CSPI2_TX		9
#define MX51_DMA_REQ_HS_I2C_TX		10
#define MX51_DMA_REQ_HS_I2C_RX		11
#define MX51_DMA_REQ_FIRI_RX		12
#define MX51_DMA_REQ_FIRI_TX		13
#define MX51_DMA_REQ_EXTREQ1		14
#define MX51_DMA_REQ_GPU		15
#define MX51_DMA_REQ_UART2_RX		16
#define MX51_DMA_REQ_UART2_TX		17
#define MX51_DMA_REQ_UART1_RX		18
#define MX51_DMA_REQ_UART1_TX		19
#define MX51_DMA_REQ_SDHC1		20
#define MX51_DMA_REQ_SDHC2		21
#define MX51_DMA_REQ_SSI2_RX1		22
#define MX51_DMA_REQ_SSI2_TX1		23
#define MX51_DMA_REQ_SSI2_RX0		24
#define MX51_DMA_REQ_SSI2_TX0		25
#define MX51_DMA_REQ_SSI1_RX1		26
#define MX51_DMA_REQ_SSI1_TX1		27
#define MX51_DMA_REQ_SSI1_RX0		28
#define MX51_DMA_REQ_SSI1_TX0		29
#define MX51_DMA_REQ_EMI_RD		30
#define MX51_DMA_REQ_CTI2_0		31
#define MX51_DMA_REQ_EMI_WR		32
#define MX51_DMA_REQ_CTI2_1		33
#define MX51_DMA_REQ_EPIT2		34
#define MX51_DMA_REQ_SSI3_RX1		35
#define MX51_DMA_REQ_IPU		36
#define MX51_DMA_REQ_SSI3_TX1		37
#define MX51_DMA_REQ_CSPI_RX		38
#define MX51_DMA_REQ_CSPI_TX		39
#define MX51_DMA_REQ_SDHC3		40
#define MX51_DMA_REQ_SDHC4		41
#define MX51_DMA_REQ_SLIM_B_TX		42
#define MX51_DMA_REQ_UART3_RX		43
#define MX51_DMA_REQ_UART3_TX		44
#define MX51_DMA_REQ_SPDIF		45
#define MX51_DMA_REQ_SSI3_RX0		46
#define MX51_DMA_REQ_SSI3_TX0		47

/*
 * Interrupt numbers
 */
#include <asm/irq.h>
#define MX51_INT_BASE			(NR_IRQS_LEGACY + 0)
#define MX51_INT_RESV0			(NR_IRQS_LEGACY + 0)
#define MX51_INT_ESDHC1			(NR_IRQS_LEGACY + 1)
#define MX51_INT_ESDHC2			(NR_IRQS_LEGACY + 2)
#define MX51_INT_ESDHC3			(NR_IRQS_LEGACY + 3)
#define MX51_INT_ESDHC4			(NR_IRQS_LEGACY + 4)
#define MX51_INT_RESV5			(NR_IRQS_LEGACY + 5)
#define MX51_INT_SDMA			(NR_IRQS_LEGACY + 6)
#define MX51_INT_IOMUX			(NR_IRQS_LEGACY + 7)
#define MX51_INT_NFC			(NR_IRQS_LEGACY + 8)
#define MX51_INT_VPU			(NR_IRQS_LEGACY + 9)
#define MX51_INT_IPU_ERR		(NR_IRQS_LEGACY + 10)
#define MX51_INT_IPU_SYN		(NR_IRQS_LEGACY + 11)
#define MX51_INT_GPU			(NR_IRQS_LEGACY + 12)
#define MX51_INT_RESV13			(NR_IRQS_LEGACY + 13)
#define MX51_INT_USB_HS1		(NR_IRQS_LEGACY + 14)
#define MX51_INT_EMI			(NR_IRQS_LEGACY + 15)
#define MX51_INT_USB_HS2		(NR_IRQS_LEGACY + 16)
#define MX51_INT_USB_HS3		(NR_IRQS_LEGACY + 17)
#define MX51_INT_USB_OTG		(NR_IRQS_LEGACY + 18)
#define MX51_INT_SAHARA_H0		(NR_IRQS_LEGACY + 19)
#define MX51_INT_SAHARA_H1		(NR_IRQS_LEGACY + 20)
#define MX51_INT_SCC_SMN		(NR_IRQS_LEGACY + 21)
#define MX51_INT_SCC_STZ		(NR_IRQS_LEGACY + 22)
#define MX51_INT_SCC_SCM		(NR_IRQS_LEGACY + 23)
#define MX51_INT_SRTC_NTZ		(NR_IRQS_LEGACY + 24)
#define MX51_INT_SRTC_TZ		(NR_IRQS_LEGACY + 25)
#define MX51_INT_RTIC			(NR_IRQS_LEGACY + 26)
#define MX51_INT_CSU			(NR_IRQS_LEGACY + 27)
#define MX51_INT_SLIM_B			(NR_IRQS_LEGACY + 28)
#define MX51_INT_SSI1			(NR_IRQS_LEGACY + 29)
#define MX51_INT_SSI2			(NR_IRQS_LEGACY + 30)
#define MX51_INT_UART1			(NR_IRQS_LEGACY + 31)
#define MX51_INT_UART2			(NR_IRQS_LEGACY + 32)
#define MX51_INT_UART3			(NR_IRQS_LEGACY + 33)
#define MX51_INT_RESV34			(NR_IRQS_LEGACY + 34)
#define MX51_INT_RESV35			(NR_IRQS_LEGACY + 35)
#define MX51_INT_ECSPI1			(NR_IRQS_LEGACY + 36)
#define MX51_INT_ECSPI2			(NR_IRQS_LEGACY + 37)
#define MX51_INT_CSPI			(NR_IRQS_LEGACY + 38)
#define MX51_INT_GPT			(NR_IRQS_LEGACY + 39)
#define MX51_INT_EPIT1			(NR_IRQS_LEGACY + 40)
#define MX51_INT_EPIT2			(NR_IRQS_LEGACY + 41)
#define MX51_INT_GPIO1_INT7		(NR_IRQS_LEGACY + 42)
#define MX51_INT_GPIO1_INT6		(NR_IRQS_LEGACY + 43)
#define MX51_INT_GPIO1_INT5		(NR_IRQS_LEGACY + 44)
#define MX51_INT_GPIO1_INT4		(NR_IRQS_LEGACY + 45)
#define MX51_INT_GPIO1_INT3		(NR_IRQS_LEGACY + 46)
#define MX51_INT_GPIO1_INT2		(NR_IRQS_LEGACY + 47)
#define MX51_INT_GPIO1_INT1		(NR_IRQS_LEGACY + 48)
#define MX51_INT_GPIO1_INT0		(NR_IRQS_LEGACY + 49)
#define MX51_INT_GPIO1_LOW		(NR_IRQS_LEGACY + 50)
#define MX51_INT_GPIO1_HIGH		(NR_IRQS_LEGACY + 51)
#define MX51_INT_GPIO2_LOW		(NR_IRQS_LEGACY + 52)
#define MX51_INT_GPIO2_HIGH		(NR_IRQS_LEGACY + 53)
#define MX51_INT_GPIO3_LOW		(NR_IRQS_LEGACY + 54)
#define MX51_INT_GPIO3_HIGH		(NR_IRQS_LEGACY + 55)
#define MX51_INT_GPIO4_LOW		(NR_IRQS_LEGACY + 56)
#define MX51_INT_GPIO4_HIGH		(NR_IRQS_LEGACY + 57)
#define MX51_INT_WDOG1			(NR_IRQS_LEGACY + 58)
#define MX51_INT_WDOG2			(NR_IRQS_LEGACY + 59)
#define MX51_INT_KPP			(NR_IRQS_LEGACY + 60)
#define MX51_INT_PWM1			(NR_IRQS_LEGACY + 61)
#define MX51_INT_I2C1			(NR_IRQS_LEGACY + 62)
#define MX51_INT_I2C2			(NR_IRQS_LEGACY + 63)
#define MX51_INT_HS_I2C			(NR_IRQS_LEGACY + 64)
#define MX51_INT_RESV65			(NR_IRQS_LEGACY + 65)
#define MX51_INT_RESV66			(NR_IRQS_LEGACY + 66)
#define MX51_INT_SIM_IPB		(NR_IRQS_LEGACY + 67)
#define MX51_INT_SIM_DAT		(NR_IRQS_LEGACY + 68)
#define MX51_INT_IIM			(NR_IRQS_LEGACY + 69)
#define MX51_INT_ATA			(NR_IRQS_LEGACY + 70)
#define MX51_INT_CCM1			(NR_IRQS_LEGACY + 71)
#define MX51_INT_CCM2			(NR_IRQS_LEGACY + 72)
#define MX51_INT_GPC1			(NR_IRQS_LEGACY + 73)
#define MX51_INT_GPC2			(NR_IRQS_LEGACY + 74)
#define MX51_INT_SRC			(NR_IRQS_LEGACY + 75)
#define MX51_INT_NM			(NR_IRQS_LEGACY + 76)
#define MX51_INT_PMU			(NR_IRQS_LEGACY + 77)
#define MX51_INT_CTI_IRQ		(NR_IRQS_LEGACY + 78)
#define MX51_INT_CTI1_TG0		(NR_IRQS_LEGACY + 79)
#define MX51_INT_CTI1_TG1		(NR_IRQS_LEGACY + 80)
#define MX51_INT_MCG_ERR		(NR_IRQS_LEGACY + 81)
#define MX51_INT_MCG_TMR		(NR_IRQS_LEGACY + 82)
#define MX51_INT_MCG_FUNC		(NR_IRQS_LEGACY + 83)
#define MX51_INT_GPU2_IRQ		(NR_IRQS_LEGACY + 84)
#define MX51_INT_GPU2_BUSY		(NR_IRQS_LEGACY + 85)
#define MX51_INT_RESV86			(NR_IRQS_LEGACY + 86)
#define MX51_INT_FEC			(NR_IRQS_LEGACY + 87)
#define MX51_INT_OWIRE			(NR_IRQS_LEGACY + 88)
#define MX51_INT_CTI1_TG2		(NR_IRQS_LEGACY + 89)
#define MX51_INT_SJC			(NR_IRQS_LEGACY + 90)
#define MX51_INT_SPDIF			(NR_IRQS_LEGACY + 91)
#define MX51_INT_TVE			(NR_IRQS_LEGACY + 92)
#define MX51_INT_FIRI			(NR_IRQS_LEGACY + 93)
#define MX51_INT_PWM2			(NR_IRQS_LEGACY + 94)
#define MX51_INT_SLIM_EXP		(NR_IRQS_LEGACY + 95)
#define MX51_INT_SSI3			(NR_IRQS_LEGACY + 96)
#define MX51_INT_EMI_BOOT		(NR_IRQS_LEGACY + 97)
#define MX51_INT_CTI1_TG3		(NR_IRQS_LEGACY + 98)
#define MX51_INT_SMC_RX			(NR_IRQS_LEGACY + 99)
#define MX51_INT_VPU_IDLE		(NR_IRQS_LEGACY + 100)
#define MX51_INT_EMI_NFC		(NR_IRQS_LEGACY + 101)
#define MX51_INT_GPU_IDLE		(NR_IRQS_LEGACY + 102)

#if !defined(__ASSEMBLY__) && !defined(__MXC_BOOT_UNCOMPRESS)
extern int mx51_revision(void);
extern void mx51_display_revision(void);
#endif

#endif	/* ifndef __MACH_MX51_H__ */
