/*
 * Copyright 2007-2008 Analog Devices Inc.
 *
 * Licensed under the GPL-2 or later.
 */

#ifndef _CDEF_BF54X_H
#define _CDEF_BF54X_H

#include <asm/blackfin.h>

#include "defBF54x_base.h"

/* ************************************************************** */
/* SYSTEM & MMR ADDRESS DEFINITIONS COMMON TO ALL ADSP-BF54x    */
/* ************************************************************** */

/* PLL Registers */

#define bfin_read_PLL_CTL()		bfin_read16(PLL_CTL)
#define bfin_read_PLL_DIV()		bfin_read16(PLL_DIV)
#define bfin_write_PLL_DIV(val)		bfin_write16(PLL_DIV, val)
#define bfin_read_VR_CTL()		bfin_read16(VR_CTL)
#define bfin_read_PLL_STAT()		bfin_read16(PLL_STAT)
#define bfin_write_PLL_STAT(val)	bfin_write16(PLL_STAT, val)
#define bfin_read_PLL_LOCKCNT()		bfin_read16(PLL_LOCKCNT)
#define bfin_write_PLL_LOCKCNT(val)	bfin_write16(PLL_LOCKCNT, val)

/* Debug/MP/Emulation Registers (0xFFC00014 - 0xFFC00014) */

#define bfin_read_CHIPID()		bfin_read32(CHIPID)
#define bfin_write_CHIPID(val)		bfin_write32(CHIPID, val)

/* System Reset and Interrubfin_read_()t Controller (0xFFC00100 - 0xFFC00104) */

#define bfin_read_SWRST()		bfin_read16(SWRST)
#define bfin_write_SWRST(val)		bfin_write16(SWRST, val)
#define bfin_read_SYSCR()		bfin_read16(SYSCR)
#define bfin_write_SYSCR(val)		bfin_write16(SYSCR, val)

/* SIC Registers */

#define bfin_read_SIC_IMASK0()		bfin_read32(SIC_IMASK0)
#define bfin_write_SIC_IMASK0(val)	bfin_write32(SIC_IMASK0, val)
#define bfin_read_SIC_IMASK1()		bfin_read32(SIC_IMASK1)
#define bfin_write_SIC_IMASK1(val)	bfin_write32(SIC_IMASK1, val)
#define bfin_read_SIC_IMASK2()		bfin_read32(SIC_IMASK2)
#define bfin_write_SIC_IMASK2(val)	bfin_write32(SIC_IMASK2, val)
#define bfin_read_SIC_IMASK(x)		bfin_read32(SIC_IMASK0 + (x << 2))
#define bfin_write_SIC_IMASK(x, val)	bfin_write32((SIC_IMASK0 + (x << 2)), val)

#define bfin_read_SIC_ISR0()		bfin_read32(SIC_ISR0)
#define bfin_write_SIC_ISR0(val)	bfin_write32(SIC_ISR0, val)
#define bfin_read_SIC_ISR1()		bfin_read32(SIC_ISR1)
#define bfin_write_SIC_ISR1(val)	bfin_write32(SIC_ISR1, val)
#define bfin_read_SIC_ISR2()		bfin_read32(SIC_ISR2)
#define bfin_write_SIC_ISR2(val)	bfin_write32(SIC_ISR2, val)
#define bfin_read_SIC_ISR(x)		bfin_read32(SIC_ISR0 + (x << 2))
#define bfin_write_SIC_ISR(x, val)	bfin_write32((SIC_ISR0 + (x << 2)), val)

#define bfin_read_SIC_IWR0()		bfin_read32(SIC_IWR0)
#define bfin_write_SIC_IWR0(val)	bfin_write32(SIC_IWR0, val)
#define bfin_read_SIC_IWR1()		bfin_read32(SIC_IWR1)
#define bfin_write_SIC_IWR1(val)	bfin_write32(SIC_IWR1, val)
#define bfin_read_SIC_IWR2()		bfin_read32(SIC_IWR2)
#define bfin_write_SIC_IWR2(val)	bfin_write32(SIC_IWR2, val)
#define bfin_read_SIC_IAR0()		bfin_read32(SIC_IAR0)
#define bfin_write_SIC_IAR0(val)	bfin_write32(SIC_IAR0, val)
#define bfin_read_SIC_IAR1()		bfin_read32(SIC_IAR1)
#define bfin_write_SIC_IAR1(val)	bfin_write32(SIC_IAR1, val)
#define bfin_read_SIC_IAR2()		bfin_read32(SIC_IAR2)
#define bfin_write_SIC_IAR2(val)	bfin_write32(SIC_IAR2, val)
#define bfin_read_SIC_IAR3()		bfin_read32(SIC_IAR3)
#define bfin_write_SIC_IAR3(val)	bfin_write32(SIC_IAR3, val)
#define bfin_read_SIC_IAR4()		bfin_read32(SIC_IAR4)
#define bfin_write_SIC_IAR4(val)	bfin_write32(SIC_IAR4, val)
#define bfin_read_SIC_IAR5()		bfin_read32(SIC_IAR5)
#define bfin_write_SIC_IAR5(val)	bfin_write32(SIC_IAR5, val)
#define bfin_read_SIC_IAR6()		bfin_read32(SIC_IAR6)
#define bfin_write_SIC_IAR6(val)	bfin_write32(SIC_IAR6, val)
#define bfin_read_SIC_IAR7()		bfin_read32(SIC_IAR7)
#define bfin_write_SIC_IAR7(val)	bfin_write32(SIC_IAR7, val)
#define bfin_read_SIC_IAR8()		bfin_read32(SIC_IAR8)
#define bfin_write_SIC_IAR8(val)	bfin_write32(SIC_IAR8, val)
#define bfin_read_SIC_IAR9()		bfin_read32(SIC_IAR9)
#define bfin_write_SIC_IAR9(val)	bfin_write32(SIC_IAR9, val)
#define bfin_read_SIC_IAR10()		bfin_read32(SIC_IAR10)
#define bfin_write_SIC_IAR10(val)	bfin_write32(SIC_IAR10, val)
#define bfin_read_SIC_IAR11()		bfin_read32(SIC_IAR11)
#define bfin_write_SIC_IAR11(val)	bfin_write32(SIC_IAR11, val)

/* Watchdog Timer Registers */

#define bfin_read_WDOG_CTL()		bfin_read16(WDOG_CTL)
#define bfin_write_WDOG_CTL(val)	bfin_write16(WDOG_CTL, val)
#define bfin_read_WDOG_CNT()		bfin_read32(WDOG_CNT)
#define bfin_write_WDOG_CNT(val)	bfin_write32(WDOG_CNT, val)
#define bfin_read_WDOG_STAT()		bfin_read32(WDOG_STAT)
#define bfin_write_WDOG_STAT(val)	bfin_write32(WDOG_STAT, val)

/* RTC Registers */

#define bfin_read_RTC_STAT()		bfin_read32(RTC_STAT)
#define bfin_write_RTC_STAT(val)	bfin_write32(RTC_STAT, val)
#define bfin_read_RTC_ICTL()		bfin_read16(RTC_ICTL)
#define bfin_write_RTC_ICTL(val)	bfin_write16(RTC_ICTL, val)
#define bfin_read_RTC_ISTAT()		bfin_read16(RTC_ISTAT)
#define bfin_write_RTC_ISTAT(val)	bfin_write16(RTC_ISTAT, val)
#define bfin_read_RTC_SWCNT()		bfin_read16(RTC_SWCNT)
#define bfin_write_RTC_SWCNT(val)	bfin_write16(RTC_SWCNT, val)
#define bfin_read_RTC_ALARM()		bfin_read32(RTC_ALARM)
#define bfin_write_RTC_ALARM(val)	bfin_write32(RTC_ALARM, val)
#define bfin_read_RTC_PREN()		bfin_read16(RTC_PREN)
#define bfin_write_RTC_PREN(val)	bfin_write16(RTC_PREN, val)

/* UART0 Registers */

#define bfin_read_UART0_DLL()		bfin_read16(UART0_DLL)
#define bfin_write_UART0_DLL(val)	bfin_write16(UART0_DLL, val)
#define bfin_read_UART0_DLH()		bfin_read16(UART0_DLH)
#define bfin_write_UART0_DLH(val)	bfin_write16(UART0_DLH, val)
#define bfin_read_UART0_GCTL()		bfin_read16(UART0_GCTL)
#define bfin_write_UART0_GCTL(val)	bfin_write16(UART0_GCTL, val)
#define bfin_read_UART0_LCR()		bfin_read16(UART0_LCR)
#define bfin_write_UART0_LCR(val)	bfin_write16(UART0_LCR, val)
#define bfin_read_UART0_MCR()		bfin_read16(UART0_MCR)
#define bfin_write_UART0_MCR(val)	bfin_write16(UART0_MCR, val)
#define bfin_read_UART0_LSR()		bfin_read16(UART0_LSR)
#define bfin_write_UART0_LSR(val)	bfin_write16(UART0_LSR, val)
#define bfin_read_UART0_MSR()		bfin_read16(UART0_MSR)
#define bfin_write_UART0_MSR(val)	bfin_write16(UART0_MSR, val)
#define bfin_read_UART0_SCR()		bfin_read16(UART0_SCR)
#define bfin_write_UART0_SCR(val)	bfin_write16(UART0_SCR, val)
#define bfin_read_UART0_IER_SET()	bfin_read16(UART0_IER_SET)
#define bfin_write_UART0_IER_SET(val)	bfin_write16(UART0_IER_SET, val)
#define bfin_read_UART0_IER_CLEAR()	bfin_read16(UART0_IER_CLEAR)
#define bfin_write_UART0_IER_CLEAR(val)	bfin_write16(UART0_IER_CLEAR, val)
#define bfin_read_UART0_THR()		bfin_read16(UART0_THR)
#define bfin_write_UART0_THR(val)	bfin_write16(UART0_THR, val)
#define bfin_read_UART0_RBR()		bfin_read16(UART0_RBR)
#define bfin_write_UART0_RBR(val)	bfin_write16(UART0_RBR, val)

/* SPI0 Registers */

#define bfin_read_SPI0_CTL()		bfin_read16(SPI0_CTL)
#define bfin_write_SPI0_CTL(val)	bfin_write16(SPI0_CTL, val)
#define bfin_read_SPI0_FLG()		bfin_read16(SPI0_FLG)
#define bfin_write_SPI0_FLG(val)	bfin_write16(SPI0_FLG, val)
#define bfin_read_SPI0_STAT()		bfin_read16(SPI0_STAT)
#define bfin_write_SPI0_STAT(val)	bfin_write16(SPI0_STAT, val)
#define bfin_read_SPI0_TDBR()		bfin_read16(SPI0_TDBR)
#define bfin_write_SPI0_TDBR(val)	bfin_write16(SPI0_TDBR, val)
#define bfin_read_SPI0_RDBR()		bfin_read16(SPI0_RDBR)
#define bfin_write_SPI0_RDBR(val)	bfin_write16(SPI0_RDBR, val)
#define bfin_read_SPI0_BAUD()		bfin_read16(SPI0_BAUD)
#define bfin_write_SPI0_BAUD(val)	bfin_write16(SPI0_BAUD, val)
#define bfin_read_SPI0_SHADOW()		bfin_read16(SPI0_SHADOW)
#define bfin_write_SPI0_SHADOW(val)	bfin_write16(SPI0_SHADOW, val)

/* Timer Groubfin_read_() of 3 registers are not defined in the shared file because they are not available on the ADSP-BF542 processor */

/* Two Wire Interface Registers (TWI0) */

/* SPORT0 is not defined in the shared file because it is not available on the ADSP-BF542 and ADSP-BF544 bfin_read_()rocessors */

/* SPORT1 Registers */

#define bfin_read_SPORT1_TCR1()		bfin_read16(SPORT1_TCR1)
#define bfin_write_SPORT1_TCR1(val)	bfin_write16(SPORT1_TCR1, val)
#define bfin_read_SPORT1_TCR2()		bfin_read16(SPORT1_TCR2)
#define bfin_write_SPORT1_TCR2(val)	bfin_write16(SPORT1_TCR2, val)
#define bfin_read_SPORT1_TCLKDIV()	bfin_read16(SPORT1_TCLKDIV)
#define bfin_write_SPORT1_TCLKDIV(val)	bfin_write16(SPORT1_TCLKDIV, val)
#define bfin_read_SPORT1_TFSDIV()	bfin_read16(SPORT1_TFSDIV)
#define bfin_write_SPORT1_TFSDIV(val)	bfin_write16(SPORT1_TFSDIV, val)
#define bfin_read_SPORT1_TX()		bfin_read32(SPORT1_TX)
#define bfin_write_SPORT1_TX(val)	bfin_write32(SPORT1_TX, val)
#define bfin_read_SPORT1_RX()		bfin_read32(SPORT1_RX)
#define bfin_write_SPORT1_RX(val)	bfin_write32(SPORT1_RX, val)
#define bfin_read_SPORT1_RCR1()		bfin_read16(SPORT1_RCR1)
#define bfin_write_SPORT1_RCR1(val)	bfin_write16(SPORT1_RCR1, val)
#define bfin_read_SPORT1_RCR2()		bfin_read16(SPORT1_RCR2)
#define bfin_write_SPORT1_RCR2(val)	bfin_write16(SPORT1_RCR2, val)
#define bfin_read_SPORT1_RCLKDIV()	bfin_read16(SPORT1_RCLKDIV)
#define bfin_write_SPORT1_RCLKDIV(val)	bfin_write16(SPORT1_RCLKDIV, val)
#define bfin_read_SPORT1_RFSDIV()	bfin_read16(SPORT1_RFSDIV)
#define bfin_write_SPORT1_RFSDIV(val)	bfin_write16(SPORT1_RFSDIV, val)
#define bfin_read_SPORT1_STAT()		bfin_read16(SPORT1_STAT)
#define bfin_write_SPORT1_STAT(val)	bfin_write16(SPORT1_STAT, val)
#define bfin_read_SPORT1_CHNL()		bfin_read16(SPORT1_CHNL)
#define bfin_write_SPORT1_CHNL(val)	bfin_write16(SPORT1_CHNL, val)
#define bfin_read_SPORT1_MCMC1()	bfin_read16(SPORT1_MCMC1)
#define bfin_write_SPORT1_MCMC1(val)	bfin_write16(SPORT1_MCMC1, val)
#define bfin_read_SPORT1_MCMC2()	bfin_read16(SPORT1_MCMC2)
#define bfin_write_SPORT1_MCMC2(val)	bfin_write16(SPORT1_MCMC2, val)
#define bfin_read_SPORT1_MTCS0()	bfin_read32(SPORT1_MTCS0)
#define bfin_write_SPORT1_MTCS0(val)	bfin_write32(SPORT1_MTCS0, val)
#define bfin_read_SPORT1_MTCS1()	bfin_read32(SPORT1_MTCS1)
#define bfin_write_SPORT1_MTCS1(val)	bfin_write32(SPORT1_MTCS1, val)
#define bfin_read_SPORT1_MTCS2()	bfin_read32(SPORT1_MTCS2)
#define bfin_write_SPORT1_MTCS2(val)	bfin_write32(SPORT1_MTCS2, val)
#define bfin_read_SPORT1_MTCS3()	bfin_read32(SPORT1_MTCS3)
#define bfin_write_SPORT1_MTCS3(val)	bfin_write32(SPORT1_MTCS3, val)
#define bfin_read_SPORT1_MRCS0()	bfin_read32(SPORT1_MRCS0)
#define bfin_write_SPORT1_MRCS0(val)	bfin_write32(SPORT1_MRCS0, val)
#define bfin_read_SPORT1_MRCS1()	bfin_read32(SPORT1_MRCS1)
#define bfin_write_SPORT1_MRCS1(val)	bfin_write32(SPORT1_MRCS1, val)
#define bfin_read_SPORT1_MRCS2()	bfin_read32(SPORT1_MRCS2)
#define bfin_write_SPORT1_MRCS2(val)	bfin_write32(SPORT1_MRCS2, val)
#define bfin_read_SPORT1_MRCS3()	bfin_read32(SPORT1_MRCS3)
#define bfin_write_SPORT1_MRCS3(val)	bfin_write32(SPORT1_MRCS3, val)

/* Asynchronous Memory Control Registers */

#define bfin_read_EBIU_AMGCTL()		bfin_read16(EBIU_AMGCTL)
#define bfin_write_EBIU_AMGCTL(val)	bfin_write16(EBIU_AMGCTL, val)
#define bfin_read_EBIU_AMBCTL0()	bfin_read32(EBIU_AMBCTL0)
#define bfin_write_EBIU_AMBCTL0(val)	bfin_write32(EBIU_AMBCTL0, val)
#define bfin_read_EBIU_AMBCTL1()	bfin_read32(EBIU_AMBCTL1)
#define bfin_write_EBIU_AMBCTL1(val)	bfin_write32(EBIU_AMBCTL1, val)
#define bfin_read_EBIU_MBSCTL()		bfin_read16(EBIU_MBSCTL)
#define bfin_write_EBIU_MBSCTL(val)	bfin_write16(EBIU_MBSCTL, val)
#define bfin_read_EBIU_ARBSTAT()	bfin_read32(EBIU_ARBSTAT)
#define bfin_write_EBIU_ARBSTAT(val)	bfin_write32(EBIU_ARBSTAT, val)
#define bfin_read_EBIU_MODE()		bfin_read32(EBIU_MODE)
#define bfin_write_EBIU_MODE(val)	bfin_write32(EBIU_MODE, val)
#define bfin_read_EBIU_FCTL()		bfin_read16(EBIU_FCTL)
#define bfin_write_EBIU_FCTL(val)	bfin_write16(EBIU_FCTL, val)

/* DDR Memory Control Registers */

#define bfin_read_EBIU_DDRCTL0()	bfin_read32(EBIU_DDRCTL0)
#define bfin_write_EBIU_DDRCTL0(val)	bfin_write32(EBIU_DDRCTL0, val)
#define bfin_read_EBIU_DDRCTL1()	bfin_read32(EBIU_DDRCTL1)
#define bfin_write_EBIU_DDRCTL1(val)	bfin_write32(EBIU_DDRCTL1, val)
#define bfin_read_EBIU_DDRCTL2()	bfin_read32(EBIU_DDRCTL2)
#define bfin_write_EBIU_DDRCTL2(val)	bfin_write32(EBIU_DDRCTL2, val)
#define bfin_read_EBIU_DDRCTL3()	bfin_read32(EBIU_DDRCTL3)
#define bfin_write_EBIU_DDRCTL3(val)	bfin_write32(EBIU_DDRCTL3, val)
#define bfin_read_EBIU_DDRQUE()		bfin_read32(EBIU_DDRQUE)
#define bfin_write_EBIU_DDRQUE(val)	bfin_write32(EBIU_DDRQUE, val)
#define bfin_read_EBIU_ERRADD() 	bfin_read32(EBIU_ERRADD)
#define bfin_write_EBIU_ERRADD(val) 	bfin_write32(EBIU_ERRADD, val)
#define bfin_read_EBIU_ERRMST()		bfin_read16(EBIU_ERRMST)
#define bfin_write_EBIU_ERRMST(val)	bfin_write16(EBIU_ERRMST, val)
#define bfin_read_EBIU_RSTCTL()		bfin_read16(EBIU_RSTCTL)
#define bfin_write_EBIU_RSTCTL(val)	bfin_write16(EBIU_RSTCTL, val)

/* DDR BankRead and Write Count Registers */

#define bfin_read_EBIU_DDRBRC0()	bfin_read32(EBIU_DDRBRC0)
#define bfin_write_EBIU_DDRBRC0(val)	bfin_write32(EBIU_DDRBRC0, val)
#define bfin_read_EBIU_DDRBRC1()	bfin_read32(EBIU_DDRBRC1)
#define bfin_write_EBIU_DDRBRC1(val)	bfin_write32(EBIU_DDRBRC1, val)
#define bfin_read_EBIU_DDRBRC2()	bfin_read32(EBIU_DDRBRC2)
#define bfin_write_EBIU_DDRBRC2(val)	bfin_write32(EBIU_DDRBRC2, val)
#define bfin_read_EBIU_DDRBRC3()	bfin_read32(EBIU_DDRBRC3)
#define bfin_write_EBIU_DDRBRC3(val)	bfin_write32(EBIU_DDRBRC3, val)
#define bfin_read_EBIU_DDRBRC4()	bfin_read32(EBIU_DDRBRC4)
#define bfin_write_EBIU_DDRBRC4(val)	bfin_write32(EBIU_DDRBRC4, val)
#define bfin_read_EBIU_DDRBRC5()	bfin_read32(EBIU_DDRBRC5)
#define bfin_write_EBIU_DDRBRC5(val)	bfin_write32(EBIU_DDRBRC5, val)
#define bfin_read_EBIU_DDRBRC6()	bfin_read32(EBIU_DDRBRC6)
#define bfin_write_EBIU_DDRBRC6(val)	bfin_write32(EBIU_DDRBRC6, val)
#define bfin_read_EBIU_DDRBRC7()	bfin_read32(EBIU_DDRBRC7)
#define bfin_write_EBIU_DDRBRC7(val)	bfin_write32(EBIU_DDRBRC7, val)
#define bfin_read_EBIU_DDRBWC0()	bfin_read32(EBIU_DDRBWC0)
#define bfin_write_EBIU_DDRBWC0(val)	bfin_write32(EBIU_DDRBWC0, val)
#define bfin_read_EBIU_DDRBWC1()	bfin_read32(EBIU_DDRBWC1)
#define bfin_write_EBIU_DDRBWC1(val)	bfin_write32(EBIU_DDRBWC1, val)
#define bfin_read_EBIU_DDRBWC2()	bfin_read32(EBIU_DDRBWC2)
#define bfin_write_EBIU_DDRBWC2(val)	bfin_write32(EBIU_DDRBWC2, val)
#define bfin_read_EBIU_DDRBWC3()	bfin_read32(EBIU_DDRBWC3)
#define bfin_write_EBIU_DDRBWC3(val)	bfin_write32(EBIU_DDRBWC3, val)
#define bfin_read_EBIU_DDRBWC4()	bfin_read32(EBIU_DDRBWC4)
#define bfin_write_EBIU_DDRBWC4(val)	bfin_write32(EBIU_DDRBWC4, val)
#define bfin_read_EBIU_DDRBWC5()	bfin_read32(EBIU_DDRBWC5)
#define bfin_write_EBIU_DDRBWC5(val)	bfin_write32(EBIU_DDRBWC5, val)
#define bfin_read_EBIU_DDRBWC6()	bfin_read32(EBIU_DDRBWC6)
#define bfin_write_EBIU_DDRBWC6(val)	bfin_write32(EBIU_DDRBWC6, val)
#define bfin_read_EBIU_DDRBWC7()	bfin_read32(EBIU_DDRBWC7)
#define bfin_write_EBIU_DDRBWC7(val)	bfin_write32(EBIU_DDRBWC7, val)
#define bfin_read_EBIU_DDRACCT()	bfin_read32(EBIU_DDRACCT)
#define bfin_write_EBIU_DDRACCT(val)	bfin_write32(EBIU_DDRACCT, val)
#define bfin_read_EBIU_DDRTACT()	bfin_read32(EBIU_DDRTACT)
#define bfin_write_EBIU_DDRTACT(val)	bfin_write32(EBIU_DDRTACT, val)
#define bfin_read_EBIU_DDRARCT()	bfin_read32(EBIU_DDRARCT)
#define bfin_write_EBIU_DDRARCT(val)	bfin_write32(EBIU_DDRARCT, val)
#define bfin_read_EBIU_DDRGC0()		bfin_read32(EBIU_DDRGC0)
#define bfin_write_EBIU_DDRGC0(val)	bfin_write32(EBIU_DDRGC0, val)
#define bfin_read_EBIU_DDRGC1()		bfin_read32(EBIU_DDRGC1)
#define bfin_write_EBIU_DDRGC1(val)	bfin_write32(EBIU_DDRGC1, val)
#define bfin_read_EBIU_DDRGC2()		bfin_read32(EBIU_DDRGC2)
#define bfin_write_EBIU_DDRGC2(val)	bfin_write32(EBIU_DDRGC2, val)
#define bfin_read_EBIU_DDRGC3()		bfin_read32(EBIU_DDRGC3)
#define bfin_write_EBIU_DDRGC3(val)	bfin_write32(EBIU_DDRGC3, val)
#define bfin_read_EBIU_DDRMCEN()	bfin_read32(EBIU_DDRMCEN)
#define bfin_write_EBIU_DDRMCEN(val)	bfin_write32(EBIU_DDRMCEN, val)
#define bfin_read_EBIU_DDRMCCL()	bfin_read32(EBIU_DDRMCCL)
#define bfin_write_EBIU_DDRMCCL(val)	bfin_write32(EBIU_DDRMCCL, val)

/* DMAC0 Registers */

#define bfin_read_DMAC0_TC_PER()		bfin_read16(DMAC0_TC_PER)
#define bfin_write_DMAC0_TC_PER(val)	bfin_write16(DMAC0_TC_PER, val)
#define bfin_read_DMAC0_TC_CNT()		bfin_read16(DMAC0_TC_CNT)
#define bfin_write_DMAC0_TC_CNT(val)	bfin_write16(DMAC0_TC_CNT, val)

/* DMA Channel 0 Registers */

#define bfin_read_DMA0_NEXT_DESC_PTR() 		bfin_read32(DMA0_NEXT_DESC_PTR)
#define bfin_write_DMA0_NEXT_DESC_PTR(val) 	bfin_write32(DMA0_NEXT_DESC_PTR, val)
#define bfin_read_DMA0_START_ADDR() 		bfin_read32(DMA0_START_ADDR)
#define bfin_write_DMA0_START_ADDR(val) 	bfin_write32(DMA0_START_ADDR, val)
#define bfin_read_DMA0_CONFIG()			bfin_read16(DMA0_CONFIG)
#define bfin_write_DMA0_CONFIG(val)		bfin_write16(DMA0_CONFIG, val)
#define bfin_read_DMA0_X_COUNT()		bfin_read16(DMA0_X_COUNT)
#define bfin_write_DMA0_X_COUNT(val)		bfin_write16(DMA0_X_COUNT, val)
#define bfin_read_DMA0_X_MODIFY()		bfin_read16(DMA0_X_MODIFY)
#define bfin_write_DMA0_X_MODIFY(val) 		bfin_write16(DMA0_X_MODIFY, val)
#define bfin_read_DMA0_Y_COUNT()		bfin_read16(DMA0_Y_COUNT)
#define bfin_write_DMA0_Y_COUNT(val)		bfin_write16(DMA0_Y_COUNT, val)
#define bfin_read_DMA0_Y_MODIFY()		bfin_read16(DMA0_Y_MODIFY)
#define bfin_write_DMA0_Y_MODIFY(val) 		bfin_write16(DMA0_Y_MODIFY, val)
#define bfin_read_DMA0_CURR_DESC_PTR() 		bfin_read32(DMA0_CURR_DESC_PTR)
#define bfin_write_DMA0_CURR_DESC_PTR(val) 	bfin_write32(DMA0_CURR_DESC_PTR, val)
#define bfin_read_DMA0_CURR_ADDR() 		bfin_read32(DMA0_CURR_ADDR)
#define bfin_write_DMA0_CURR_ADDR(val) 		bfin_write32(DMA0_CURR_ADDR, val)
#define bfin_read_DMA0_IRQ_STATUS()		bfin_read16(DMA0_IRQ_STATUS)
#define bfin_write_DMA0_IRQ_STATUS(val)		bfin_write16(DMA0_IRQ_STATUS, val)
#define bfin_read_DMA0_PERIPHERAL_MAP()		bfin_read16(DMA0_PERIPHERAL_MAP)
#define bfin_write_DMA0_PERIPHERAL_MAP(val)	bfin_write16(DMA0_PERIPHERAL_MAP, val)
#define bfin_read_DMA0_CURR_X_COUNT()		bfin_read16(DMA0_CURR_X_COUNT)
#define bfin_write_DMA0_CURR_X_COUNT(val)	bfin_write16(DMA0_CURR_X_COUNT, val)
#define bfin_read_DMA0_CURR_Y_COUNT()		bfin_read16(DMA0_CURR_Y_COUNT)
#define bfin_write_DMA0_CURR_Y_COUNT(val)	bfin_write16(DMA0_CURR_Y_COUNT, val)

/* DMA Channel 1 Registers */

#define bfin_read_DMA1_NEXT_DESC_PTR() 		bfin_read32(DMA1_NEXT_DESC_PTR)
#define bfin_write_DMA1_NEXT_DESC_PTR(val) 	bfin_write32(DMA1_NEXT_DESC_PTR, val)
#define bfin_read_DMA1_START_ADDR() 		bfin_read32(DMA1_START_ADDR)
#define bfin_write_DMA1_START_ADDR(val) 	bfin_write32(DMA1_START_ADDR, val)
#define bfin_read_DMA1_CONFIG()			bfin_read16(DMA1_CONFIG)
#define bfin_write_DMA1_CONFIG(val)		bfin_write16(DMA1_CONFIG, val)
#define bfin_read_DMA1_X_COUNT()		bfin_read16(DMA1_X_COUNT)
#define bfin_write_DMA1_X_COUNT(val)		bfin_write16(DMA1_X_COUNT, val)
#define bfin_read_DMA1_X_MODIFY()		bfin_read16(DMA1_X_MODIFY)
#define bfin_write_DMA1_X_MODIFY(val) 		bfin_write16(DMA1_X_MODIFY, val)
#define bfin_read_DMA1_Y_COUNT()		bfin_read16(DMA1_Y_COUNT)
#define bfin_write_DMA1_Y_COUNT(val)		bfin_write16(DMA1_Y_COUNT, val)
#define bfin_read_DMA1_Y_MODIFY()		bfin_read16(DMA1_Y_MODIFY)
#define bfin_write_DMA1_Y_MODIFY(val) 		bfin_write16(DMA1_Y_MODIFY, val)
#define bfin_read_DMA1_CURR_DESC_PTR() 		bfin_read32(DMA1_CURR_DESC_PTR)
#define bfin_write_DMA1_CURR_DESC_PTR(val) 	bfin_write32(DMA1_CURR_DESC_PTR, val)
#define bfin_read_DMA1_CURR_ADDR() 		bfin_read32(DMA1_CURR_ADDR)
#define bfin_write_DMA1_CURR_ADDR(val) 		bfin_write32(DMA1_CURR_ADDR, val)
#define bfin_read_DMA1_IRQ_STATUS()		bfin_read16(DMA1_IRQ_STATUS)
#define bfin_write_DMA1_IRQ_STATUS(val)		bfin_write16(DMA1_IRQ_STATUS, val)
#define bfin_read_DMA1_PERIPHERAL_MAP()		bfin_read16(DMA1_PERIPHERAL_MAP)
#define bfin_write_DMA1_PERIPHERAL_MAP(val)	bfin_write16(DMA1_PERIPHERAL_MAP, val)
#define bfin_read_DMA1_CURR_X_COUNT()		bfin_read16(DMA1_CURR_X_COUNT)
#define bfin_write_DMA1_CURR_X_COUNT(val)	bfin_write16(DMA1_CURR_X_COUNT, val)
#define bfin_read_DMA1_CURR_Y_COUNT()		bfin_read16(DMA1_CURR_Y_COUNT)
#define bfin_write_DMA1_CURR_Y_COUNT(val)	bfin_write16(DMA1_CURR_Y_COUNT, val)

/* DMA Channel 2 Registers */

#define bfin_read_DMA2_NEXT_DESC_PTR() 		bfin_read32(DMA2_NEXT_DESC_PTR)
#define bfin_write_DMA2_NEXT_DESC_PTR(val) 	bfin_write32(DMA2_NEXT_DESC_PTR, val)
#define bfin_read_DMA2_START_ADDR() 		bfin_read32(DMA2_START_ADDR)
#define bfin_write_DMA2_START_ADDR(val) 	bfin_write32(DMA2_START_ADDR, val)
#define bfin_read_DMA2_CONFIG()			bfin_read16(DMA2_CONFIG)
#define bfin_write_DMA2_CONFIG(val)		bfin_write16(DMA2_CONFIG, val)
#define bfin_read_DMA2_X_COUNT()		bfin_read16(DMA2_X_COUNT)
#define bfin_write_DMA2_X_COUNT(val)		bfin_write16(DMA2_X_COUNT, val)
#define bfin_read_DMA2_X_MODIFY()		bfin_read16(DMA2_X_MODIFY)
#define bfin_write_DMA2_X_MODIFY(val) 		bfin_write16(DMA2_X_MODIFY, val)
#define bfin_read_DMA2_Y_COUNT()		bfin_read16(DMA2_Y_COUNT)
#define bfin_write_DMA2_Y_COUNT(val)		bfin_write16(DMA2_Y_COUNT, val)
#define bfin_read_DMA2_Y_MODIFY()		bfin_read16(DMA2_Y_MODIFY)
#define bfin_write_DMA2_Y_MODIFY(val) 		bfin_write16(DMA2_Y_MODIFY, val)
#define bfin_read_DMA2_CURR_DESC_PTR() 		bfin_read32(DMA2_CURR_DESC_PTR)
#define bfin_write_DMA2_CURR_DESC_PTR(val) 	bfin_write32(DMA2_CURR_DESC_PTR, val)
#define bfin_read_DMA2_CURR_ADDR() 		bfin_read32(DMA2_CURR_ADDR)
#define bfin_write_DMA2_CURR_ADDR(val) 		bfin_write32(DMA2_CURR_ADDR, val)
#define bfin_read_DMA2_IRQ_STATUS()		bfin_read16(DMA2_IRQ_STATUS)
#define bfin_write_DMA2_IRQ_STATUS(val)		bfin_write16(DMA2_IRQ_STATUS, val)
#define bfin_read_DMA2_PERIPHERAL_MAP()		bfin_read16(DMA2_PERIPHERAL_MAP)
#define bfin_write_DMA2_PERIPHERAL_MAP(val)	bfin_write16(DMA2_PERIPHERAL_MAP, val)
#define bfin_read_DMA2_CURR_X_COUNT()		bfin_read16(DMA2_CURR_X_COUNT)
#define bfin_write_DMA2_CURR_X_COUNT(val)	bfin_write16(DMA2_CURR_X_COUNT, val)
#define bfin_read_DMA2_CURR_Y_COUNT()		bfin_read16(DMA2_CURR_Y_COUNT)
#define bfin_write_DMA2_CURR_Y_COUNT(val)	bfin_write16(DMA2_CURR_Y_COUNT, val)

/* DMA Channel 3 Registers */

#define bfin_read_DMA3_NEXT_DESC_PTR() 		bfin_read32(DMA3_NEXT_DESC_PTR)
#define bfin_write_DMA3_NEXT_DESC_PTR(val) 	bfin_write32(DMA3_NEXT_DESC_PTR, val)
#define bfin_read_DMA3_START_ADDR() 		bfin_read32(DMA3_START_ADDR)
#define bfin_write_DMA3_START_ADDR(val) 	bfin_write32(DMA3_START_ADDR, val)
#define bfin_read_DMA3_CONFIG()			bfin_read16(DMA3_CONFIG)
#define bfin_write_DMA3_CONFIG(val)		bfin_write16(DMA3_CONFIG, val)
#define bfin_read_DMA3_X_COUNT()		bfin_read16(DMA3_X_COUNT)
#define bfin_write_DMA3_X_COUNT(val)		bfin_write16(DMA3_X_COUNT, val)
#define bfin_read_DMA3_X_MODIFY()		bfin_read16(DMA3_X_MODIFY)
#define bfin_write_DMA3_X_MODIFY(val) 		bfin_write16(DMA3_X_MODIFY, val)
#define bfin_read_DMA3_Y_COUNT()		bfin_read16(DMA3_Y_COUNT)
#define bfin_write_DMA3_Y_COUNT(val)		bfin_write16(DMA3_Y_COUNT, val)
#define bfin_read_DMA3_Y_MODIFY()		bfin_read16(DMA3_Y_MODIFY)
#define bfin_write_DMA3_Y_MODIFY(val) 		bfin_write16(DMA3_Y_MODIFY, val)
#define bfin_read_DMA3_CURR_DESC_PTR() 		bfin_read32(DMA3_CURR_DESC_PTR)
#define bfin_write_DMA3_CURR_DESC_PTR(val) 	bfin_write32(DMA3_CURR_DESC_PTR, val)
#define bfin_read_DMA3_CURR_ADDR() 		bfin_read32(DMA3_CURR_ADDR)
#define bfin_write_DMA3_CURR_ADDR(val) 		bfin_write32(DMA3_CURR_ADDR, val)
#define bfin_read_DMA3_IRQ_STATUS()		bfin_read16(DMA3_IRQ_STATUS)
#define bfin_write_DMA3_IRQ_STATUS(val)		bfin_write16(DMA3_IRQ_STATUS, val)
#define bfin_read_DMA3_PERIPHERAL_MAP()		bfin_read16(DMA3_PERIPHERAL_MAP)
#define bfin_write_DMA3_PERIPHERAL_MAP(val)	bfin_write16(DMA3_PERIPHERAL_MAP, val)
#define bfin_read_DMA3_CURR_X_COUNT()		bfin_read16(DMA3_CURR_X_COUNT)
#define bfin_write_DMA3_CURR_X_COUNT(val)	bfin_write16(DMA3_CURR_X_COUNT, val)
#define bfin_read_DMA3_CURR_Y_COUNT()		bfin_read16(DMA3_CURR_Y_COUNT)
#define bfin_write_DMA3_CURR_Y_COUNT(val)	bfin_write16(DMA3_CURR_Y_COUNT, val)

/* DMA Channel 4 Registers */

#define bfin_read_DMA4_NEXT_DESC_PTR() 		bfin_read32(DMA4_NEXT_DESC_PTR)
#define bfin_write_DMA4_NEXT_DESC_PTR(val) 	bfin_write32(DMA4_NEXT_DESC_PTR, val)
#define bfin_read_DMA4_START_ADDR() 		bfin_read32(DMA4_START_ADDR)
#define bfin_write_DMA4_START_ADDR(val) 	bfin_write32(DMA4_START_ADDR, val)
#define bfin_read_DMA4_CONFIG()			bfin_read16(DMA4_CONFIG)
#define bfin_write_DMA4_CONFIG(val)		bfin_write16(DMA4_CONFIG, val)
#define bfin_read_DMA4_X_COUNT()		bfin_read16(DMA4_X_COUNT)
#define bfin_write_DMA4_X_COUNT(val)		bfin_write16(DMA4_X_COUNT, val)
#define bfin_read_DMA4_X_MODIFY()		bfin_read16(DMA4_X_MODIFY)
#define bfin_write_DMA4_X_MODIFY(val) 		bfin_write16(DMA4_X_MODIFY, val)
#define bfin_read_DMA4_Y_COUNT()		bfin_read16(DMA4_Y_COUNT)
#define bfin_write_DMA4_Y_COUNT(val)		bfin_write16(DMA4_Y_COUNT, val)
#define bfin_read_DMA4_Y_MODIFY()		bfin_read16(DMA4_Y_MODIFY)
#define bfin_write_DMA4_Y_MODIFY(val) 		bfin_write16(DMA4_Y_MODIFY, val)
#define bfin_read_DMA4_CURR_DESC_PTR() 		bfin_read32(DMA4_CURR_DESC_PTR)
#define bfin_write_DMA4_CURR_DESC_PTR(val) 	bfin_write32(DMA4_CURR_DESC_PTR, val)
#define bfin_read_DMA4_CURR_ADDR() 		bfin_read32(DMA4_CURR_ADDR)
#define bfin_write_DMA4_CURR_ADDR(val) 		bfin_write32(DMA4_CURR_ADDR, val)
#define bfin_read_DMA4_IRQ_STATUS()		bfin_read16(DMA4_IRQ_STATUS)
#define bfin_write_DMA4_IRQ_STATUS(val)		bfin_write16(DMA4_IRQ_STATUS, val)
#define bfin_read_DMA4_PERIPHERAL_MAP()		bfin_read16(DMA4_PERIPHERAL_MAP)
#define bfin_write_DMA4_PERIPHERAL_MAP(val)	bfin_write16(DMA4_PERIPHERAL_MAP, val)
#define bfin_read_DMA4_CURR_X_COUNT()		bfin_read16(DMA4_CURR_X_COUNT)
#define bfin_write_DMA4_CURR_X_COUNT(val)	bfin_write16(DMA4_CURR_X_COUNT, val)
#define bfin_read_DMA4_CURR_Y_COUNT()		bfin_read16(DMA4_CURR_Y_COUNT)
#define bfin_write_DMA4_CURR_Y_COUNT(val)	bfin_write16(DMA4_CURR_Y_COUNT, val)

/* DMA Channel 5 Registers */

#define bfin_read_DMA5_NEXT_DESC_PTR() 		bfin_read32(DMA5_NEXT_DESC_PTR)
#define bfin_write_DMA5_NEXT_DESC_PTR(val) 	bfin_write32(DMA5_NEXT_DESC_PTR, val)
#define bfin_read_DMA5_START_ADDR() 		bfin_read32(DMA5_START_ADDR)
#define bfin_write_DMA5_START_ADDR(val) 	bfin_write32(DMA5_START_ADDR, val)
#define bfin_read_DMA5_CONFIG()			bfin_read16(DMA5_CONFIG)
#define bfin_write_DMA5_CONFIG(val)		bfin_write16(DMA5_CONFIG, val)
#define bfin_read_DMA5_X_COUNT()		bfin_read16(DMA5_X_COUNT)
#define bfin_write_DMA5_X_COUNT(val)		bfin_write16(DMA5_X_COUNT, val)
#define bfin_read_DMA5_X_MODIFY()		bfin_read16(DMA5_X_MODIFY)
#define bfin_write_DMA5_X_MODIFY(val) 		bfin_write16(DMA5_X_MODIFY, val)
#define bfin_read_DMA5_Y_COUNT()		bfin_read16(DMA5_Y_COUNT)
#define bfin_write_DMA5_Y_COUNT(val)		bfin_write16(DMA5_Y_COUNT, val)
#define bfin_read_DMA5_Y_MODIFY()		bfin_read16(DMA5_Y_MODIFY)
#define bfin_write_DMA5_Y_MODIFY(val) 		bfin_write16(DMA5_Y_MODIFY, val)
#define bfin_read_DMA5_CURR_DESC_PTR() 		bfin_read32(DMA5_CURR_DESC_PTR)
#define bfin_write_DMA5_CURR_DESC_PTR(val) 	bfin_write32(DMA5_CURR_DESC_PTR, val)
#define bfin_read_DMA5_CURR_ADDR() 		bfin_read32(DMA5_CURR_ADDR)
#define bfin_write_DMA5_CURR_ADDR(val) 		bfin_write32(DMA5_CURR_ADDR, val)
#define bfin_read_DMA5_IRQ_STATUS()		bfin_read16(DMA5_IRQ_STATUS)
#define bfin_write_DMA5_IRQ_STATUS(val)		bfin_write16(DMA5_IRQ_STATUS, val)
#define bfin_read_DMA5_PERIPHERAL_MAP()		bfin_read16(DMA5_PERIPHERAL_MAP)
#define bfin_write_DMA5_PERIPHERAL_MAP(val)	bfin_write16(DMA5_PERIPHERAL_MAP, val)
#define bfin_read_DMA5_CURR_X_COUNT()		bfin_read16(DMA5_CURR_X_COUNT)
#define bfin_write_DMA5_CURR_X_COUNT(val)	bfin_write16(DMA5_CURR_X_COUNT, val)
#define bfin_read_DMA5_CURR_Y_COUNT()		bfin_read16(DMA5_CURR_Y_COUNT)
#define bfin_write_DMA5_CURR_Y_COUNT(val)	bfin_write16(DMA5_CURR_Y_COUNT, val)

/* DMA Channel 6 Registers */

#define bfin_read_DMA6_NEXT_DESC_PTR() 		bfin_read32(DMA6_NEXT_DESC_PTR)
#define bfin_write_DMA6_NEXT_DESC_PTR(val) 	bfin_write32(DMA6_NEXT_DESC_PTR, val)
#define bfin_read_DMA6_START_ADDR() 		bfin_read32(DMA6_START_ADDR)
#define bfin_write_DMA6_START_ADDR(val) 	bfin_write32(DMA6_START_ADDR, val)
#define bfin_read_DMA6_CONFIG()			bfin_read16(DMA6_CONFIG)
#define bfin_write_DMA6_CONFIG(val)		bfin_write16(DMA6_CONFIG, val)
#define bfin_read_DMA6_X_COUNT()		bfin_read16(DMA6_X_COUNT)
#define bfin_write_DMA6_X_COUNT(val)		bfin_write16(DMA6_X_COUNT, val)
#define bfin_read_DMA6_X_MODIFY()		bfin_read16(DMA6_X_MODIFY)
#define bfin_write_DMA6_X_MODIFY(val) 		bfin_write16(DMA6_X_MODIFY, val)
#define bfin_read_DMA6_Y_COUNT()		bfin_read16(DMA6_Y_COUNT)
#define bfin_write_DMA6_Y_COUNT(val)		bfin_write16(DMA6_Y_COUNT, val)
#define bfin_read_DMA6_Y_MODIFY()		bfin_read16(DMA6_Y_MODIFY)
#define bfin_write_DMA6_Y_MODIFY(val) 		bfin_write16(DMA6_Y_MODIFY, val)
#define bfin_read_DMA6_CURR_DESC_PTR() 		bfin_read32(DMA6_CURR_DESC_PTR)
#define bfin_write_DMA6_CURR_DESC_PTR(val) 	bfin_write32(DMA6_CURR_DESC_PTR, val)
#define bfin_read_DMA6_CURR_ADDR() 		bfin_read32(DMA6_CURR_ADDR)
#define bfin_write_DMA6_CURR_ADDR(val) 		bfin_write32(DMA6_CURR_ADDR, val)
#define bfin_read_DMA6_IRQ_STATUS()		bfin_read16(DMA6_IRQ_STATUS)
#define bfin_write_DMA6_IRQ_STATUS(val)		bfin_write16(DMA6_IRQ_STATUS, val)
#define bfin_read_DMA6_PERIPHERAL_MAP()		bfin_read16(DMA6_PERIPHERAL_MAP)
#define bfin_write_DMA6_PERIPHERAL_MAP(val)	bfin_write16(DMA6_PERIPHERAL_MAP, val)
#define bfin_read_DMA6_CURR_X_COUNT()		bfin_read16(DMA6_CURR_X_COUNT)
#define bfin_write_DMA6_CURR_X_COUNT(val)	bfin_write16(DMA6_CURR_X_COUNT, val)
#define bfin_read_DMA6_CURR_Y_COUNT()		bfin_read16(DMA6_CURR_Y_COUNT)
#define bfin_write_DMA6_CURR_Y_COUNT(val)	bfin_write16(DMA6_CURR_Y_COUNT, val)

/* DMA Channel 7 Registers */

#define bfin_read_DMA7_NEXT_DESC_PTR() 		bfin_read32(DMA7_NEXT_DESC_PTR)
#define bfin_write_DMA7_NEXT_DESC_PTR(val) 	bfin_write32(DMA7_NEXT_DESC_PTR, val)
#define bfin_read_DMA7_START_ADDR() 		bfin_read32(DMA7_START_ADDR)
#define bfin_write_DMA7_START_ADDR(val) 	bfin_write32(DMA7_START_ADDR, val)
#define bfin_read_DMA7_CONFIG()			bfin_read16(DMA7_CONFIG)
#define bfin_write_DMA7_CONFIG(val)		bfin_write16(DMA7_CONFIG, val)
#define bfin_read_DMA7_X_COUNT()		bfin_read16(DMA7_X_COUNT)
#define bfin_write_DMA7_X_COUNT(val)		bfin_write16(DMA7_X_COUNT, val)
#define bfin_read_DMA7_X_MODIFY()		bfin_read16(DMA7_X_MODIFY)
#define bfin_write_DMA7_X_MODIFY(val) 		bfin_write16(DMA7_X_MODIFY, val)
#define bfin_read_DMA7_Y_COUNT()		bfin_read16(DMA7_Y_COUNT)
#define bfin_write_DMA7_Y_COUNT(val)		bfin_write16(DMA7_Y_COUNT, val)
#define bfin_read_DMA7_Y_MODIFY()		bfin_read16(DMA7_Y_MODIFY)
#define bfin_write_DMA7_Y_MODIFY(val) 		bfin_write16(DMA7_Y_MODIFY, val)
#define bfin_read_DMA7_CURR_DESC_PTR() 		bfin_read32(DMA7_CURR_DESC_PTR)
#define bfin_write_DMA7_CURR_DESC_PTR(val) 	bfin_write32(DMA7_CURR_DESC_PTR, val)
#define bfin_read_DMA7_CURR_ADDR() 		bfin_read32(DMA7_CURR_ADDR)
#define bfin_write_DMA7_CURR_ADDR(val) 		bfin_write32(DMA7_CURR_ADDR, val)
#define bfin_read_DMA7_IRQ_STATUS()		bfin_read16(DMA7_IRQ_STATUS)
#define bfin_write_DMA7_IRQ_STATUS(val)		bfin_write16(DMA7_IRQ_STATUS, val)
#define bfin_read_DMA7_PERIPHERAL_MAP()		bfin_read16(DMA7_PERIPHERAL_MAP)
#define bfin_write_DMA7_PERIPHERAL_MAP(val)	bfin_write16(DMA7_PERIPHERAL_MAP, val)
#define bfin_read_DMA7_CURR_X_COUNT()		bfin_read16(DMA7_CURR_X_COUNT)
#define bfin_write_DMA7_CURR_X_COUNT(val)	bfin_write16(DMA7_CURR_X_COUNT, val)
#define bfin_read_DMA7_CURR_Y_COUNT()		bfin_read16(DMA7_CURR_Y_COUNT)
#define bfin_write_DMA7_CURR_Y_COUNT(val)	bfin_write16(DMA7_CURR_Y_COUNT, val)

/* DMA Channel 8 Registers */

#define bfin_read_DMA8_NEXT_DESC_PTR() 		bfin_read32(DMA8_NEXT_DESC_PTR)
#define bfin_write_DMA8_NEXT_DESC_PTR(val) 	bfin_write32(DMA8_NEXT_DESC_PTR, val)
#define bfin_read_DMA8_START_ADDR() 		bfin_read32(DMA8_START_ADDR)
#define bfin_write_DMA8_START_ADDR(val) 	bfin_write32(DMA8_START_ADDR, val)
#define bfin_read_DMA8_CONFIG()			bfin_read16(DMA8_CONFIG)
#define bfin_write_DMA8_CONFIG(val)		bfin_write16(DMA8_CONFIG, val)
#define bfin_read_DMA8_X_COUNT()		bfin_read16(DMA8_X_COUNT)
#define bfin_write_DMA8_X_COUNT(val)		bfin_write16(DMA8_X_COUNT, val)
#define bfin_read_DMA8_X_MODIFY()		bfin_read16(DMA8_X_MODIFY)
#define bfin_write_DMA8_X_MODIFY(val) 		bfin_write16(DMA8_X_MODIFY, val)
#define bfin_read_DMA8_Y_COUNT()		bfin_read16(DMA8_Y_COUNT)
#define bfin_write_DMA8_Y_COUNT(val)		bfin_write16(DMA8_Y_COUNT, val)
#define bfin_read_DMA8_Y_MODIFY()		bfin_read16(DMA8_Y_MODIFY)
#define bfin_write_DMA8_Y_MODIFY(val) 		bfin_write16(DMA8_Y_MODIFY, val)
#define bfin_read_DMA8_CURR_DESC_PTR() 		bfin_read32(DMA8_CURR_DESC_PTR)
#define bfin_write_DMA8_CURR_DESC_PTR(val) 	bfin_write32(DMA8_CURR_DESC_PTR, val)
#define bfin_read_DMA8_CURR_ADDR() 		bfin_read32(DMA8_CURR_ADDR)
#define bfin_write_DMA8_CURR_ADDR(val) 		bfin_write32(DMA8_CURR_ADDR, val)
#define bfin_read_DMA8_IRQ_STATUS()		bfin_read16(DMA8_IRQ_STATUS)
#define bfin_write_DMA8_IRQ_STATUS(val)		bfin_write16(DMA8_IRQ_STATUS, val)
#define bfin_read_DMA8_PERIPHERAL_MAP()		bfin_read16(DMA8_PERIPHERAL_MAP)
#define bfin_write_DMA8_PERIPHERAL_MAP(val)	bfin_write16(DMA8_PERIPHERAL_MAP, val)
#define bfin_read_DMA8_CURR_X_COUNT()		bfin_read16(DMA8_CURR_X_COUNT)
#define bfin_write_DMA8_CURR_X_COUNT(val)	bfin_write16(DMA8_CURR_X_COUNT, val)
#define bfin_read_DMA8_CURR_Y_COUNT()		bfin_read16(DMA8_CURR_Y_COUNT)
#define bfin_write_DMA8_CURR_Y_COUNT(val)	bfin_write16(DMA8_CURR_Y_COUNT, val)

/* DMA Channel 9 Registers */

#define bfin_read_DMA9_NEXT_DESC_PTR() 		bfin_read32(DMA9_NEXT_DESC_PTR)
#define bfin_write_DMA9_NEXT_DESC_PTR(val) 	bfin_write32(DMA9_NEXT_DESC_PTR, val)
#define bfin_read_DMA9_START_ADDR() 		bfin_read32(DMA9_START_ADDR)
#define bfin_write_DMA9_START_ADDR(val) 	bfin_write32(DMA9_START_ADDR, val)
#define bfin_read_DMA9_CONFIG()			bfin_read16(DMA9_CONFIG)
#define bfin_write_DMA9_CONFIG(val)		bfin_write16(DMA9_CONFIG, val)
#define bfin_read_DMA9_X_COUNT()		bfin_read16(DMA9_X_COUNT)
#define bfin_write_DMA9_X_COUNT(val)		bfin_write16(DMA9_X_COUNT, val)
#define bfin_read_DMA9_X_MODIFY()		bfin_read16(DMA9_X_MODIFY)
#define bfin_write_DMA9_X_MODIFY(val) 		bfin_write16(DMA9_X_MODIFY, val)
#define bfin_read_DMA9_Y_COUNT()		bfin_read16(DMA9_Y_COUNT)
#define bfin_write_DMA9_Y_COUNT(val)		bfin_write16(DMA9_Y_COUNT, val)
#define bfin_read_DMA9_Y_MODIFY()		bfin_read16(DMA9_Y_MODIFY)
#define bfin_write_DMA9_Y_MODIFY(val) 		bfin_write16(DMA9_Y_MODIFY, val)
#define bfin_read_DMA9_CURR_DESC_PTR() 		bfin_read32(DMA9_CURR_DESC_PTR)
#define bfin_write_DMA9_CURR_DESC_PTR(val) 	bfin_write32(DMA9_CURR_DESC_PTR, val)
#define bfin_read_DMA9_CURR_ADDR() 		bfin_read32(DMA9_CURR_ADDR)
#define bfin_write_DMA9_CURR_ADDR(val) 		bfin_write32(DMA9_CURR_ADDR, val)
#define bfin_read_DMA9_IRQ_STATUS()		bfin_read16(DMA9_IRQ_STATUS)
#define bfin_write_DMA9_IRQ_STATUS(val)		bfin_write16(DMA9_IRQ_STATUS, val)
#define bfin_read_DMA9_PERIPHERAL_MAP()		bfin_read16(DMA9_PERIPHERAL_MAP)
#define bfin_write_DMA9_PERIPHERAL_MAP(val)	bfin_write16(DMA9_PERIPHERAL_MAP, val)
#define bfin_read_DMA9_CURR_X_COUNT()		bfin_read16(DMA9_CURR_X_COUNT)
#define bfin_write_DMA9_CURR_X_COUNT(val)	bfin_write16(DMA9_CURR_X_COUNT, val)
#define bfin_read_DMA9_CURR_Y_COUNT()		bfin_read16(DMA9_CURR_Y_COUNT)
#define bfin_write_DMA9_CURR_Y_COUNT(val)	bfin_write16(DMA9_CURR_Y_COUNT, val)

/* DMA Channel 10 Registers */

#define bfin_read_DMA10_NEXT_DESC_PTR() 	bfin_read32(DMA10_NEXT_DESC_PTR)
#define bfin_write_DMA10_NEXT_DESC_PTR(val) 	bfin_write32(DMA10_NEXT_DESC_PTR, val)
#define bfin_read_DMA10_START_ADDR() 		bfin_read32(DMA10_START_ADDR)
#define bfin_write_DMA10_START_ADDR(val) 	bfin_write32(DMA10_START_ADDR, val)
#define bfin_read_DMA10_CONFIG()		bfin_read16(DMA10_CONFIG)
#define bfin_write_DMA10_CONFIG(val)		bfin_write16(DMA10_CONFIG, val)
#define bfin_read_DMA10_X_COUNT()		bfin_read16(DMA10_X_COUNT)
#define bfin_write_DMA10_X_COUNT(val)		bfin_write16(DMA10_X_COUNT, val)
#define bfin_read_DMA10_X_MODIFY()		bfin_read16(DMA10_X_MODIFY)
#define bfin_write_DMA10_X_MODIFY(val) 		bfin_write16(DMA10_X_MODIFY, val)
#define bfin_read_DMA10_Y_COUNT()		bfin_read16(DMA10_Y_COUNT)
#define bfin_write_DMA10_Y_COUNT(val)		bfin_write16(DMA10_Y_COUNT, val)
#define bfin_read_DMA10_Y_MODIFY()		bfin_read16(DMA10_Y_MODIFY)
#define bfin_write_DMA10_Y_MODIFY(val) 		bfin_write16(DMA10_Y_MODIFY, val)
#define bfin_read_DMA10_CURR_DESC_PTR() 	bfin_read32(DMA10_CURR_DESC_PTR)
#define bfin_write_DMA10_CURR_DESC_PTR(val) 	bfin_write32(DMA10_CURR_DESC_PTR, val)
#define bfin_read_DMA10_CURR_ADDR() 		bfin_read32(DMA10_CURR_ADDR)
#define bfin_write_DMA10_CURR_ADDR(val) 	bfin_write32(DMA10_CURR_ADDR, val)
#define bfin_read_DMA10_IRQ_STATUS()		bfin_read16(DMA10_IRQ_STATUS)
#define bfin_write_DMA10_IRQ_STATUS(val)	bfin_write16(DMA10_IRQ_STATUS, val)
#define bfin_read_DMA10_PERIPHERAL_MAP()	bfin_read16(DMA10_PERIPHERAL_MAP)
#define bfin_write_DMA10_PERIPHERAL_MAP(val)	bfin_write16(DMA10_PERIPHERAL_MAP, val)
#define bfin_read_DMA10_CURR_X_COUNT()		bfin_read16(DMA10_CURR_X_COUNT)
#define bfin_write_DMA10_CURR_X_COUNT(val)	bfin_write16(DMA10_CURR_X_COUNT, val)
#define bfin_read_DMA10_CURR_Y_COUNT()		bfin_read16(DMA10_CURR_Y_COUNT)
#define bfin_write_DMA10_CURR_Y_COUNT(val)	bfin_write16(DMA10_CURR_Y_COUNT, val)

/* DMA Channel 11 Registers */

#define bfin_read_DMA11_NEXT_DESC_PTR() 	bfin_read32(DMA11_NEXT_DESC_PTR)
#define bfin_write_DMA11_NEXT_DESC_PTR(val) 	bfin_write32(DMA11_NEXT_DESC_PTR, val)
#define bfin_read_DMA11_START_ADDR() 		bfin_read32(DMA11_START_ADDR)
#define bfin_write_DMA11_START_ADDR(val) 	bfin_write32(DMA11_START_ADDR, val)
#define bfin_read_DMA11_CONFIG()		bfin_read16(DMA11_CONFIG)
#define bfin_write_DMA11_CONFIG(val)		bfin_write16(DMA11_CONFIG, val)
#define bfin_read_DMA11_X_COUNT()		bfin_read16(DMA11_X_COUNT)
#define bfin_write_DMA11_X_COUNT(val)		bfin_write16(DMA11_X_COUNT, val)
#define bfin_read_DMA11_X_MODIFY()		bfin_read16(DMA11_X_MODIFY)
#define bfin_write_DMA11_X_MODIFY(val) 		bfin_write16(DMA11_X_MODIFY, val)
#define bfin_read_DMA11_Y_COUNT()		bfin_read16(DMA11_Y_COUNT)
#define bfin_write_DMA11_Y_COUNT(val)		bfin_write16(DMA11_Y_COUNT, val)
#define bfin_read_DMA11_Y_MODIFY()		bfin_read16(DMA11_Y_MODIFY)
#define bfin_write_DMA11_Y_MODIFY(val) 		bfin_write16(DMA11_Y_MODIFY, val)
#define bfin_read_DMA11_CURR_DESC_PTR() 	bfin_read32(DMA11_CURR_DESC_PTR)
#define bfin_write_DMA11_CURR_DESC_PTR(val) 	bfin_write32(DMA11_CURR_DESC_PTR, val)
#define bfin_read_DMA11_CURR_ADDR() 		bfin_read32(DMA11_CURR_ADDR)
#define bfin_write_DMA11_CURR_ADDR(val) 	bfin_write32(DMA11_CURR_ADDR, val)
#define bfin_read_DMA11_IRQ_STATUS()		bfin_read16(DMA11_IRQ_STATUS)
#define bfin_write_DMA11_IRQ_STATUS(val)	bfin_write16(DMA11_IRQ_STATUS, val)
#define bfin_read_DMA11_PERIPHERAL_MAP()	bfin_read16(DMA11_PERIPHERAL_MAP)
#define bfin_write_DMA11_PERIPHERAL_MAP(val)	bfin_write16(DMA11_PERIPHERAL_MAP, val)
#define bfin_read_DMA11_CURR_X_COUNT()		bfin_read16(DMA11_CURR_X_COUNT)
#define bfin_write_DMA11_CURR_X_COUNT(val)	bfin_write16(DMA11_CURR_X_COUNT, val)
#define bfin_read_DMA11_CURR_Y_COUNT()		bfin_read16(DMA11_CURR_Y_COUNT)
#define bfin_write_DMA11_CURR_Y_COUNT(val)	bfin_write16(DMA11_CURR_Y_COUNT, val)

/* MDMA Stream 0 Registers */

#define bfin_read_MDMA_D0_NEXT_DESC_PTR() 	bfin_read32(MDMA_D0_NEXT_DESC_PTR)
#define bfin_write_MDMA_D0_NEXT_DESC_PTR(val) 	bfin_write32(MDMA_D0_NEXT_DESC_PTR, val)
#define bfin_read_MDMA_D0_START_ADDR() 		bfin_read32(MDMA_D0_START_ADDR)
#define bfin_write_MDMA_D0_START_ADDR(val) 	bfin_write32(MDMA_D0_START_ADDR, val)
#define bfin_read_MDMA_D0_CONFIG()		bfin_read16(MDMA_D0_CONFIG)
#define bfin_write_MDMA_D0_CONFIG(val)		bfin_write16(MDMA_D0_CONFIG, val)
#define bfin_read_MDMA_D0_X_COUNT()		bfin_read16(MDMA_D0_X_COUNT)
#define bfin_write_MDMA_D0_X_COUNT(val)		bfin_write16(MDMA_D0_X_COUNT, val)
#define bfin_read_MDMA_D0_X_MODIFY()		bfin_read16(MDMA_D0_X_MODIFY)
#define bfin_write_MDMA_D0_X_MODIFY(val) 	bfin_write16(MDMA_D0_X_MODIFY, val)
#define bfin_read_MDMA_D0_Y_COUNT()		bfin_read16(MDMA_D0_Y_COUNT)
#define bfin_write_MDMA_D0_Y_COUNT(val)		bfin_write16(MDMA_D0_Y_COUNT, val)
#define bfin_read_MDMA_D0_Y_MODIFY()		bfin_read16(MDMA_D0_Y_MODIFY)
#define bfin_write_MDMA_D0_Y_MODIFY(val) 	bfin_write16(MDMA_D0_Y_MODIFY, val)
#define bfin_read_MDMA_D0_CURR_DESC_PTR() 	bfin_read32(MDMA_D0_CURR_DESC_PTR)
#define bfin_write_MDMA_D0_CURR_DESC_PTR(val) 	bfin_write32(MDMA_D0_CURR_DESC_PTR, val)
#define bfin_read_MDMA_D0_CURR_ADDR() 		bfin_read32(MDMA_D0_CURR_ADDR)
#define bfin_write_MDMA_D0_CURR_ADDR(val) 	bfin_write32(MDMA_D0_CURR_ADDR, val)
#define bfin_read_MDMA_D0_IRQ_STATUS()		bfin_read16(MDMA_D0_IRQ_STATUS)
#define bfin_write_MDMA_D0_IRQ_STATUS(val)	bfin_write16(MDMA_D0_IRQ_STATUS, val)
#define bfin_read_MDMA_D0_PERIPHERAL_MAP()	bfin_read16(MDMA_D0_PERIPHERAL_MAP)
#define bfin_write_MDMA_D0_PERIPHERAL_MAP(val)	bfin_write16(MDMA_D0_PERIPHERAL_MAP, val)
#define bfin_read_MDMA_D0_CURR_X_COUNT()	bfin_read16(MDMA_D0_CURR_X_COUNT)
#define bfin_write_MDMA_D0_CURR_X_COUNT(val)	bfin_write16(MDMA_D0_CURR_X_COUNT, val)
#define bfin_read_MDMA_D0_CURR_Y_COUNT()	bfin_read16(MDMA_D0_CURR_Y_COUNT)
#define bfin_write_MDMA_D0_CURR_Y_COUNT(val)	bfin_write16(MDMA_D0_CURR_Y_COUNT, val)
#define bfin_read_MDMA_S0_NEXT_DESC_PTR() 	bfin_read32(MDMA_S0_NEXT_DESC_PTR)
#define bfin_write_MDMA_S0_NEXT_DESC_PTR(val) 	bfin_write32(MDMA_S0_NEXT_DESC_PTR, val)
#define bfin_read_MDMA_S0_START_ADDR() 		bfin_read32(MDMA_S0_START_ADDR)
#define bfin_write_MDMA_S0_START_ADDR(val) 	bfin_write32(MDMA_S0_START_ADDR, val)
#define bfin_read_MDMA_S0_CONFIG()		bfin_read16(MDMA_S0_CONFIG)
#define bfin_write_MDMA_S0_CONFIG(val)		bfin_write16(MDMA_S0_CONFIG, val)
#define bfin_read_MDMA_S0_X_COUNT()		bfin_read16(MDMA_S0_X_COUNT)
#define bfin_write_MDMA_S0_X_COUNT(val)		bfin_write16(MDMA_S0_X_COUNT, val)
#define bfin_read_MDMA_S0_X_MODIFY()		bfin_read16(MDMA_S0_X_MODIFY)
#define bfin_write_MDMA_S0_X_MODIFY(val) 	bfin_write16(MDMA_S0_X_MODIFY, val)
#define bfin_read_MDMA_S0_Y_COUNT()		bfin_read16(MDMA_S0_Y_COUNT)
#define bfin_write_MDMA_S0_Y_COUNT(val)		bfin_write16(MDMA_S0_Y_COUNT, val)
#define bfin_read_MDMA_S0_Y_MODIFY()		bfin_read16(MDMA_S0_Y_MODIFY)
#define bfin_write_MDMA_S0_Y_MODIFY(val) 	bfin_write16(MDMA_S0_Y_MODIFY, val)
#define bfin_read_MDMA_S0_CURR_DESC_PTR() 	bfin_read32(MDMA_S0_CURR_DESC_PTR)
#define bfin_write_MDMA_S0_CURR_DESC_PTR(val) 	bfin_write32(MDMA_S0_CURR_DESC_PTR, val)
#define bfin_read_MDMA_S0_CURR_ADDR() 		bfin_read32(MDMA_S0_CURR_ADDR)
#define bfin_write_MDMA_S0_CURR_ADDR(val) 	bfin_write32(MDMA_S0_CURR_ADDR, val)
#define bfin_read_MDMA_S0_IRQ_STATUS()		bfin_read16(MDMA_S0_IRQ_STATUS)
#define bfin_write_MDMA_S0_IRQ_STATUS(val)	bfin_write16(MDMA_S0_IRQ_STATUS, val)
#define bfin_read_MDMA_S0_PERIPHERAL_MAP()	bfin_read16(MDMA_S0_PERIPHERAL_MAP)
#define bfin_write_MDMA_S0_PERIPHERAL_MAP(val)	bfin_write16(MDMA_S0_PERIPHERAL_MAP, val)
#define bfin_read_MDMA_S0_CURR_X_COUNT()	bfin_read16(MDMA_S0_CURR_X_COUNT)
#define bfin_write_MDMA_S0_CURR_X_COUNT(val)	bfin_write16(MDMA_S0_CURR_X_COUNT, val)
#define bfin_read_MDMA_S0_CURR_Y_COUNT()	bfin_read16(MDMA_S0_CURR_Y_COUNT)
#define bfin_write_MDMA_S0_CURR_Y_COUNT(val)	bfin_write16(MDMA_S0_CURR_Y_COUNT, val)

/* MDMA Stream 1 Registers */

#define bfin_read_MDMA_D1_NEXT_DESC_PTR() 	bfin_read32(MDMA_D1_NEXT_DESC_PTR)
#define bfin_write_MDMA_D1_NEXT_DESC_PTR(val) 	bfin_write32(MDMA_D1_NEXT_DESC_PTR, val)
#define bfin_read_MDMA_D1_START_ADDR() 		bfin_read32(MDMA_D1_START_ADDR)
#define bfin_write_MDMA_D1_START_ADDR(val) 	bfin_write32(MDMA_D1_START_ADDR, val)
#define bfin_read_MDMA_D1_CONFIG()		bfin_read16(MDMA_D1_CONFIG)
#define bfin_write_MDMA_D1_CONFIG(val)		bfin_write16(MDMA_D1_CONFIG, val)
#define bfin_read_MDMA_D1_X_COUNT()		bfin_read16(MDMA_D1_X_COUNT)
#define bfin_write_MDMA_D1_X_COUNT(val)		bfin_write16(MDMA_D1_X_COUNT, val)
#define bfin_read_MDMA_D1_X_MODIFY()		bfin_read16(MDMA_D1_X_MODIFY)
#define bfin_write_MDMA_D1_X_MODIFY(val) 	bfin_write16(MDMA_D1_X_MODIFY, val)
#define bfin_read_MDMA_D1_Y_COUNT()		bfin_read16(MDMA_D1_Y_COUNT)
#define bfin_write_MDMA_D1_Y_COUNT(val)		bfin_write16(MDMA_D1_Y_COUNT, val)
#define bfin_read_MDMA_D1_Y_MODIFY()		bfin_read16(MDMA_D1_Y_MODIFY)
#define bfin_write_MDMA_D1_Y_MODIFY(val) 	bfin_write16(MDMA_D1_Y_MODIFY, val)
#define bfin_read_MDMA_D1_CURR_DESC_PTR() 	bfin_read32(MDMA_D1_CURR_DESC_PTR)
#define bfin_write_MDMA_D1_CURR_DESC_PTR(val) 	bfin_write32(MDMA_D1_CURR_DESC_PTR, val)
#define bfin_read_MDMA_D1_CURR_ADDR() 		bfin_read32(MDMA_D1_CURR_ADDR)
#define bfin_write_MDMA_D1_CURR_ADDR(val) 	bfin_write32(MDMA_D1_CURR_ADDR, val)
#define bfin_read_MDMA_D1_IRQ_STATUS()		bfin_read16(MDMA_D1_IRQ_STATUS)
#define bfin_write_MDMA_D1_IRQ_STATUS(val)	bfin_write16(MDMA_D1_IRQ_STATUS, val)
#define bfin_read_MDMA_D1_PERIPHERAL_MAP()	bfin_read16(MDMA_D1_PERIPHERAL_MAP)
#define bfin_write_MDMA_D1_PERIPHERAL_MAP(val)	bfin_write16(MDMA_D1_PERIPHERAL_MAP, val)
#define bfin_read_MDMA_D1_CURR_X_COUNT()	bfin_read16(MDMA_D1_CURR_X_COUNT)
#define bfin_write_MDMA_D1_CURR_X_COUNT(val)	bfin_write16(MDMA_D1_CURR_X_COUNT, val)
#define bfin_read_MDMA_D1_CURR_Y_COUNT()	bfin_read16(MDMA_D1_CURR_Y_COUNT)
#define bfin_write_MDMA_D1_CURR_Y_COUNT(val)	bfin_write16(MDMA_D1_CURR_Y_COUNT, val)
#define bfin_read_MDMA_S1_NEXT_DESC_PTR() 	bfin_read32(MDMA_S1_NEXT_DESC_PTR)
#define bfin_write_MDMA_S1_NEXT_DESC_PTR(val) 	bfin_write32(MDMA_S1_NEXT_DESC_PTR, val)
#define bfin_read_MDMA_S1_START_ADDR() 		bfin_read32(MDMA_S1_START_ADDR)
#define bfin_write_MDMA_S1_START_ADDR(val) 	bfin_write32(MDMA_S1_START_ADDR, val)
#define bfin_read_MDMA_S1_CONFIG()		bfin_read16(MDMA_S1_CONFIG)
#define bfin_write_MDMA_S1_CONFIG(val)		bfin_write16(MDMA_S1_CONFIG, val)
#define bfin_read_MDMA_S1_X_COUNT()		bfin_read16(MDMA_S1_X_COUNT)
#define bfin_write_MDMA_S1_X_COUNT(val)		bfin_write16(MDMA_S1_X_COUNT, val)
#define bfin_read_MDMA_S1_X_MODIFY()		bfin_read16(MDMA_S1_X_MODIFY)
#define bfin_write_MDMA_S1_X_MODIFY(val) 	bfin_write16(MDMA_S1_X_MODIFY, val)
#define bfin_read_MDMA_S1_Y_COUNT()		bfin_read16(MDMA_S1_Y_COUNT)
#define bfin_write_MDMA_S1_Y_COUNT(val)		bfin_write16(MDMA_S1_Y_COUNT, val)
#define bfin_read_MDMA_S1_Y_MODIFY()		bfin_read16(MDMA_S1_Y_MODIFY)
#define bfin_write_MDMA_S1_Y_MODIFY(val) 	bfin_write16(MDMA_S1_Y_MODIFY, val)
#define bfin_read_MDMA_S1_CURR_DESC_PTR() 	bfin_read32(MDMA_S1_CURR_DESC_PTR)
#define bfin_write_MDMA_S1_CURR_DESC_PTR(val) 	bfin_write32(MDMA_S1_CURR_DESC_PTR, val)
#define bfin_read_MDMA_S1_CURR_ADDR() 		bfin_read32(MDMA_S1_CURR_ADDR)
#define bfin_write_MDMA_S1_CURR_ADDR(val) 	bfin_write32(MDMA_S1_CURR_ADDR, val)
#define bfin_read_MDMA_S1_IRQ_STATUS()		bfin_read16(MDMA_S1_IRQ_STATUS)
#define bfin_write_MDMA_S1_IRQ_STATUS(val)	bfin_write16(MDMA_S1_IRQ_STATUS, val)
#define bfin_read_MDMA_S1_PERIPHERAL_MAP()	bfin_read16(MDMA_S1_PERIPHERAL_MAP)
#define bfin_write_MDMA_S1_PERIPHERAL_MAP(val)	bfin_write16(MDMA_S1_PERIPHERAL_MAP, val)
#define bfin_read_MDMA_S1_CURR_X_COUNT()	bfin_read16(MDMA_S1_CURR_X_COUNT)
#define bfin_write_MDMA_S1_CURR_X_COUNT(val)	bfin_write16(MDMA_S1_CURR_X_COUNT, val)
#define bfin_read_MDMA_S1_CURR_Y_COUNT()	bfin_read16(MDMA_S1_CURR_Y_COUNT)
#define bfin_write_MDMA_S1_CURR_Y_COUNT(val)	bfin_write16(MDMA_S1_CURR_Y_COUNT, val)

/* EPPI1 Registers */

#define bfin_read_EPPI1_STATUS()		bfin_read16(EPPI1_STATUS)
#define bfin_write_EPPI1_STATUS(val)		bfin_write16(EPPI1_STATUS, val)
#define bfin_read_EPPI1_HCOUNT()		bfin_read16(EPPI1_HCOUNT)
#define bfin_write_EPPI1_HCOUNT(val)		bfin_write16(EPPI1_HCOUNT, val)
#define bfin_read_EPPI1_HDELAY()		bfin_read16(EPPI1_HDELAY)
#define bfin_write_EPPI1_HDELAY(val)		bfin_write16(EPPI1_HDELAY, val)
#define bfin_read_EPPI1_VCOUNT()		bfin_read16(EPPI1_VCOUNT)
#define bfin_write_EPPI1_VCOUNT(val)		bfin_write16(EPPI1_VCOUNT, val)
#define bfin_read_EPPI1_VDELAY()		bfin_read16(EPPI1_VDELAY)
#define bfin_write_EPPI1_VDELAY(val)		bfin_write16(EPPI1_VDELAY, val)
#define bfin_read_EPPI1_FRAME()			bfin_read16(EPPI1_FRAME)
#define bfin_write_EPPI1_FRAME(val)		bfin_write16(EPPI1_FRAME, val)
#define bfin_read_EPPI1_LINE()			bfin_read16(EPPI1_LINE)
#define bfin_write_EPPI1_LINE(val)		bfin_write16(EPPI1_LINE, val)
#define bfin_read_EPPI1_CLKDIV()		bfin_read16(EPPI1_CLKDIV)
#define bfin_write_EPPI1_CLKDIV(val)		bfin_write16(EPPI1_CLKDIV, val)
#define bfin_read_EPPI1_CONTROL()		bfin_read32(EPPI1_CONTROL)
#define bfin_write_EPPI1_CONTROL(val)		bfin_write32(EPPI1_CONTROL, val)
#define bfin_read_EPPI1_FS1W_HBL()		bfin_read32(EPPI1_FS1W_HBL)
#define bfin_write_EPPI1_FS1W_HBL(val)		bfin_write32(EPPI1_FS1W_HBL, val)
#define bfin_read_EPPI1_FS1P_AVPL()		bfin_read32(EPPI1_FS1P_AVPL)
#define bfin_write_EPPI1_FS1P_AVPL(val)		bfin_write32(EPPI1_FS1P_AVPL, val)
#define bfin_read_EPPI1_FS2W_LVB()		bfin_read32(EPPI1_FS2W_LVB)
#define bfin_write_EPPI1_FS2W_LVB(val)		bfin_write32(EPPI1_FS2W_LVB, val)
#define bfin_read_EPPI1_FS2P_LAVF()		bfin_read32(EPPI1_FS2P_LAVF)
#define bfin_write_EPPI1_FS2P_LAVF(val)		bfin_write32(EPPI1_FS2P_LAVF, val)
#define bfin_read_EPPI1_CLIP()			bfin_read32(EPPI1_CLIP)
#define bfin_write_EPPI1_CLIP(val)		bfin_write32(EPPI1_CLIP, val)

/* Port Interrubfin_read_()t 0 Registers (32-bit) */

#define bfin_read_PINT0_MASK_SET()		bfin_read32(PINT0_MASK_SET)
#define bfin_write_PINT0_MASK_SET(val)		bfin_write32(PINT0_MASK_SET, val)
#define bfin_read_PINT0_MASK_CLEAR()		bfin_read32(PINT0_MASK_CLEAR)
#define bfin_write_PINT0_MASK_CLEAR(val)	bfin_write32(PINT0_MASK_CLEAR, val)
#define bfin_read_PINT0_REQUEST()		bfin_read32(PINT0_REQUEST)
#define bfin_write_PINT0_REQUEST(val)		bfin_write32(PINT0_REQUEST, val)
#define bfin_read_PINT0_ASSIGN()		bfin_read32(PINT0_ASSIGN)
#define bfin_write_PINT0_ASSIGN(val)		bfin_write32(PINT0_ASSIGN, val)
#define bfin_read_PINT0_EDGE_SET()		bfin_read32(PINT0_EDGE_SET)
#define bfin_write_PINT0_EDGE_SET(val)		bfin_write32(PINT0_EDGE_SET, val)
#define bfin_read_PINT0_EDGE_CLEAR()		bfin_read32(PINT0_EDGE_CLEAR)
#define bfin_write_PINT0_EDGE_CLEAR(val)	bfin_write32(PINT0_EDGE_CLEAR, val)
#define bfin_read_PINT0_INVERT_SET()		bfin_read32(PINT0_INVERT_SET)
#define bfin_write_PINT0_INVERT_SET(val)	bfin_write32(PINT0_INVERT_SET, val)
#define bfin_read_PINT0_INVERT_CLEAR()		bfin_read32(PINT0_INVERT_CLEAR)
#define bfin_write_PINT0_INVERT_CLEAR(val)	bfin_write32(PINT0_INVERT_CLEAR, val)
#define bfin_read_PINT0_PINSTATE()		bfin_read32(PINT0_PINSTATE)
#define bfin_write_PINT0_PINSTATE(val)		bfin_write32(PINT0_PINSTATE, val)
#define bfin_read_PINT0_LATCH()			bfin_read32(PINT0_LATCH)
#define bfin_write_PINT0_LATCH(val)		bfin_write32(PINT0_LATCH, val)

/* Port Interrubfin_read_()t 1 Registers (32-bit) */

#define bfin_read_PINT1_MASK_SET()		bfin_read32(PINT1_MASK_SET)
#define bfin_write_PINT1_MASK_SET(val)		bfin_write32(PINT1_MASK_SET, val)
#define bfin_read_PINT1_MASK_CLEAR()		bfin_read32(PINT1_MASK_CLEAR)
#define bfin_write_PINT1_MASK_CLEAR(val)	bfin_write32(PINT1_MASK_CLEAR, val)
#define bfin_read_PINT1_REQUEST()		bfin_read32(PINT1_REQUEST)
#define bfin_write_PINT1_REQUEST(val)		bfin_write32(PINT1_REQUEST, val)
#define bfin_read_PINT1_ASSIGN()		bfin_read32(PINT1_ASSIGN)
#define bfin_write_PINT1_ASSIGN(val)		bfin_write32(PINT1_ASSIGN, val)
#define bfin_read_PINT1_EDGE_SET()		bfin_read32(PINT1_EDGE_SET)
#define bfin_write_PINT1_EDGE_SET(val)		bfin_write32(PINT1_EDGE_SET, val)
#define bfin_read_PINT1_EDGE_CLEAR()		bfin_read32(PINT1_EDGE_CLEAR)
#define bfin_write_PINT1_EDGE_CLEAR(val)	bfin_write32(PINT1_EDGE_CLEAR, val)
#define bfin_read_PINT1_INVERT_SET()		bfin_read32(PINT1_INVERT_SET)
#define bfin_write_PINT1_INVERT_SET(val)	bfin_write32(PINT1_INVERT_SET, val)
#define bfin_read_PINT1_INVERT_CLEAR()		bfin_read32(PINT1_INVERT_CLEAR)
#define bfin_write_PINT1_INVERT_CLEAR(val)	bfin_write32(PINT1_INVERT_CLEAR, val)
#define bfin_read_PINT1_PINSTATE()		bfin_read32(PINT1_PINSTATE)
#define bfin_write_PINT1_PINSTATE(val)		bfin_write32(PINT1_PINSTATE, val)
#define bfin_read_PINT1_LATCH()			bfin_read32(PINT1_LATCH)
#define bfin_write_PINT1_LATCH(val)		bfin_write32(PINT1_LATCH, val)

/* Port Interrubfin_read_()t 2 Registers (32-bit) */

#define bfin_read_PINT2_MASK_SET()		bfin_read32(PINT2_MASK_SET)
#define bfin_write_PINT2_MASK_SET(val)		bfin_write32(PINT2_MASK_SET, val)
#define bfin_read_PINT2_MASK_CLEAR()		bfin_read32(PINT2_MASK_CLEAR)
#define bfin_write_PINT2_MASK_CLEAR(val)	bfin_write32(PINT2_MASK_CLEAR, val)
#define bfin_read_PINT2_REQUEST()		bfin_read32(PINT2_REQUEST)
#define bfin_write_PINT2_REQUEST(val)		bfin_write32(PINT2_REQUEST, val)
#define bfin_read_PINT2_ASSIGN()		bfin_read32(PINT2_ASSIGN)
#define bfin_write_PINT2_ASSIGN(val)		bfin_write32(PINT2_ASSIGN, val)
#define bfin_read_PINT2_EDGE_SET()		bfin_read32(PINT2_EDGE_SET)
#define bfin_write_PINT2_EDGE_SET(val)		bfin_write32(PINT2_EDGE_SET, val)
#define bfin_read_PINT2_EDGE_CLEAR()		bfin_read32(PINT2_EDGE_CLEAR)
#define bfin_write_PINT2_EDGE_CLEAR(val)	bfin_write32(PINT2_EDGE_CLEAR, val)
#define bfin_read_PINT2_INVERT_SET()		bfin_read32(PINT2_INVERT_SET)
#define bfin_write_PINT2_INVERT_SET(val)	bfin_write32(PINT2_INVERT_SET, val)
#define bfin_read_PINT2_INVERT_CLEAR()		bfin_read32(PINT2_INVERT_CLEAR)
#define bfin_write_PINT2_INVERT_CLEAR(val)	bfin_write32(PINT2_INVERT_CLEAR, val)
#define bfin_read_PINT2_PINSTATE()		bfin_read32(PINT2_PINSTATE)
#define bfin_write_PINT2_PINSTATE(val)		bfin_write32(PINT2_PINSTATE, val)
#define bfin_read_PINT2_LATCH()			bfin_read32(PINT2_LATCH)
#define bfin_write_PINT2_LATCH(val)		bfin_write32(PINT2_LATCH, val)

/* Port Interrubfin_read_()t 3 Registers (32-bit) */

#define bfin_read_PINT3_MASK_SET()		bfin_read32(PINT3_MASK_SET)
#define bfin_write_PINT3_MASK_SET(val)		bfin_write32(PINT3_MASK_SET, val)
#define bfin_read_PINT3_MASK_CLEAR()		bfin_read32(PINT3_MASK_CLEAR)
#define bfin_write_PINT3_MASK_CLEAR(val)	bfin_write32(PINT3_MASK_CLEAR, val)
#define bfin_read_PINT3_REQUEST()		bfin_read32(PINT3_REQUEST)
#define bfin_write_PINT3_REQUEST(val)		bfin_write32(PINT3_REQUEST, val)
#define bfin_read_PINT3_ASSIGN()		bfin_read32(PINT3_ASSIGN)
#define bfin_write_PINT3_ASSIGN(val)		bfin_write32(PINT3_ASSIGN, val)
#define bfin_read_PINT3_EDGE_SET()		bfin_read32(PINT3_EDGE_SET)
#define bfin_write_PINT3_EDGE_SET(val)		bfin_write32(PINT3_EDGE_SET, val)
#define bfin_read_PINT3_EDGE_CLEAR()		bfin_read32(PINT3_EDGE_CLEAR)
#define bfin_write_PINT3_EDGE_CLEAR(val)	bfin_write32(PINT3_EDGE_CLEAR, val)
#define bfin_read_PINT3_INVERT_SET()		bfin_read32(PINT3_INVERT_SET)
#define bfin_write_PINT3_INVERT_SET(val)	bfin_write32(PINT3_INVERT_SET, val)
#define bfin_read_PINT3_INVERT_CLEAR()		bfin_read32(PINT3_INVERT_CLEAR)
#define bfin_write_PINT3_INVERT_CLEAR(val)	bfin_write32(PINT3_INVERT_CLEAR, val)
#define bfin_read_PINT3_PINSTATE()		bfin_read32(PINT3_PINSTATE)
#define bfin_write_PINT3_PINSTATE(val)		bfin_write32(PINT3_PINSTATE, val)
#define bfin_read_PINT3_LATCH()			bfin_read32(PINT3_LATCH)
#define bfin_write_PINT3_LATCH(val)		bfin_write32(PINT3_LATCH, val)

/* Port A Registers */

#define bfin_read_PORTA_FER()		bfin_read16(PORTA_FER)
#define bfin_write_PORTA_FER(val)	bfin_write16(PORTA_FER, val)
#define bfin_read_PORTA()		bfin_read16(PORTA)
#define bfin_write_PORTA(val)		bfin_write16(PORTA, val)
#define bfin_read_PORTA_SET()		bfin_read16(PORTA_SET)
#define bfin_write_PORTA_SET(val)	bfin_write16(PORTA_SET, val)
#define bfin_read_PORTA_CLEAR()		bfin_read16(PORTA_CLEAR)
#define bfin_write_PORTA_CLEAR(val)	bfin_write16(PORTA_CLEAR, val)
#define bfin_read_PORTA_DIR_SET()	bfin_read16(PORTA_DIR_SET)
#define bfin_write_PORTA_DIR_SET(val)	bfin_write16(PORTA_DIR_SET, val)
#define bfin_read_PORTA_DIR_CLEAR()	bfin_read16(PORTA_DIR_CLEAR)
#define bfin_write_PORTA_DIR_CLEAR(val)	bfin_write16(PORTA_DIR_CLEAR, val)
#define bfin_read_PORTA_INEN()		bfin_read16(PORTA_INEN)
#define bfin_write_PORTA_INEN(val)	bfin_write16(PORTA_INEN, val)
#define bfin_read_PORTA_MUX()		bfin_read32(PORTA_MUX)
#define bfin_write_PORTA_MUX(val)	bfin_write32(PORTA_MUX, val)

/* Port B Registers */

#define bfin_read_PORTB_FER()		bfin_read16(PORTB_FER)
#define bfin_write_PORTB_FER(val)	bfin_write16(PORTB_FER, val)
#define bfin_read_PORTB()		bfin_read16(PORTB)
#define bfin_write_PORTB(val)		bfin_write16(PORTB, val)
#define bfin_read_PORTB_SET()		bfin_read16(PORTB_SET)
#define bfin_write_PORTB_SET(val)	bfin_write16(PORTB_SET, val)
#define bfin_read_PORTB_CLEAR()		bfin_read16(PORTB_CLEAR)
#define bfin_write_PORTB_CLEAR(val)	bfin_write16(PORTB_CLEAR, val)
#define bfin_read_PORTB_DIR_SET()	bfin_read16(PORTB_DIR_SET)
#define bfin_write_PORTB_DIR_SET(val)	bfin_write16(PORTB_DIR_SET, val)
#define bfin_read_PORTB_DIR_CLEAR()	bfin_read16(PORTB_DIR_CLEAR)
#define bfin_write_PORTB_DIR_CLEAR(val)	bfin_write16(PORTB_DIR_CLEAR, val)
#define bfin_read_PORTB_INEN()		bfin_read16(PORTB_INEN)
#define bfin_write_PORTB_INEN(val)	bfin_write16(PORTB_INEN, val)
#define bfin_read_PORTB_MUX()		bfin_read32(PORTB_MUX)
#define bfin_write_PORTB_MUX(val)	bfin_write32(PORTB_MUX, val)

/* Port C Registers */

#define bfin_read_PORTC_FER()		bfin_read16(PORTC_FER)
#define bfin_write_PORTC_FER(val)	bfin_write16(PORTC_FER, val)
#define bfin_read_PORTC()		bfin_read16(PORTC)
#define bfin_write_PORTC(val)		bfin_write16(PORTC, val)
#define bfin_read_PORTC_SET()		bfin_read16(PORTC_SET)
#define bfin_write_PORTC_SET(val)	bfin_write16(PORTC_SET, val)
#define bfin_read_PORTC_CLEAR()		bfin_read16(PORTC_CLEAR)
#define bfin_write_PORTC_CLEAR(val)	bfin_write16(PORTC_CLEAR, val)
#define bfin_read_PORTC_DIR_SET()	bfin_read16(PORTC_DIR_SET)
#define bfin_write_PORTC_DIR_SET(val)	bfin_write16(PORTC_DIR_SET, val)
#define bfin_read_PORTC_DIR_CLEAR()	bfin_read16(PORTC_DIR_CLEAR)
#define bfin_write_PORTC_DIR_CLEAR(val)	bfin_write16(PORTC_DIR_CLEAR, val)
#define bfin_read_PORTC_INEN()		bfin_read16(PORTC_INEN)
#define bfin_write_PORTC_INEN(val)	bfin_write16(PORTC_INEN, val)
#define bfin_read_PORTC_MUX()		bfin_read32(PORTC_MUX)
#define bfin_write_PORTC_MUX(val)	bfin_write32(PORTC_MUX, val)

/* Port D Registers */

#define bfin_read_PORTD_FER()		bfin_read16(PORTD_FER)
#define bfin_write_PORTD_FER(val)	bfin_write16(PORTD_FER, val)
#define bfin_read_PORTD()		bfin_read16(PORTD)
#define bfin_write_PORTD(val)		bfin_write16(PORTD, val)
#define bfin_read_PORTD_SET()		bfin_read16(PORTD_SET)
#define bfin_write_PORTD_SET(val)	bfin_write16(PORTD_SET, val)
#define bfin_read_PORTD_CLEAR()		bfin_read16(PORTD_CLEAR)
#define bfin_write_PORTD_CLEAR(val)	bfin_write16(PORTD_CLEAR, val)
#define bfin_read_PORTD_DIR_SET()	bfin_read16(PORTD_DIR_SET)
#define bfin_write_PORTD_DIR_SET(val)	bfin_write16(PORTD_DIR_SET, val)
#define bfin_read_PORTD_DIR_CLEAR()	bfin_read16(PORTD_DIR_CLEAR)
#define bfin_write_PORTD_DIR_CLEAR(val)	bfin_write16(PORTD_DIR_CLEAR, val)
#define bfin_read_PORTD_INEN()		bfin_read16(PORTD_INEN)
#define bfin_write_PORTD_INEN(val)	bfin_write16(PORTD_INEN, val)
#define bfin_read_PORTD_MUX()		bfin_read32(PORTD_MUX)
#define bfin_write_PORTD_MUX(val)	bfin_write32(PORTD_MUX, val)

/* Port E Registers */

#define bfin_read_PORTE_FER()		bfin_read16(PORTE_FER)
#define bfin_write_PORTE_FER(val)	bfin_write16(PORTE_FER, val)
#define bfin_read_PORTE()		bfin_read16(PORTE)
#define bfin_write_PORTE(val)		bfin_write16(PORTE, val)
#define bfin_read_PORTE_SET()		bfin_read16(PORTE_SET)
#define bfin_write_PORTE_SET(val)	bfin_write16(PORTE_SET, val)
#define bfin_read_PORTE_CLEAR()		bfin_read16(PORTE_CLEAR)
#define bfin_write_PORTE_CLEAR(val)	bfin_write16(PORTE_CLEAR, val)
#define bfin_read_PORTE_DIR_SET()	bfin_read16(PORTE_DIR_SET)
#define bfin_write_PORTE_DIR_SET(val)	bfin_write16(PORTE_DIR_SET, val)
#define bfin_read_PORTE_DIR_CLEAR()	bfin_read16(PORTE_DIR_CLEAR)
#define bfin_write_PORTE_DIR_CLEAR(val)	bfin_write16(PORTE_DIR_CLEAR, val)
#define bfin_read_PORTE_INEN()		bfin_read16(PORTE_INEN)
#define bfin_write_PORTE_INEN(val)	bfin_write16(PORTE_INEN, val)
#define bfin_read_PORTE_MUX()		bfin_read32(PORTE_MUX)
#define bfin_write_PORTE_MUX(val)	bfin_write32(PORTE_MUX, val)

/* Port F Registers */

#define bfin_read_PORTF_FER()		bfin_read16(PORTF_FER)
#define bfin_write_PORTF_FER(val)	bfin_write16(PORTF_FER, val)
#define bfin_read_PORTF()		bfin_read16(PORTF)
#define bfin_write_PORTF(val)		bfin_write16(PORTF, val)
#define bfin_read_PORTF_SET()		bfin_read16(PORTF_SET)
#define bfin_write_PORTF_SET(val)	bfin_write16(PORTF_SET, val)
#define bfin_read_PORTF_CLEAR()		bfin_read16(PORTF_CLEAR)
#define bfin_write_PORTF_CLEAR(val)	bfin_write16(PORTF_CLEAR, val)
#define bfin_read_PORTF_DIR_SET()	bfin_read16(PORTF_DIR_SET)
#define bfin_write_PORTF_DIR_SET(val)	bfin_write16(PORTF_DIR_SET, val)
#define bfin_read_PORTF_DIR_CLEAR()	bfin_read16(PORTF_DIR_CLEAR)
#define bfin_write_PORTF_DIR_CLEAR(val)	bfin_write16(PORTF_DIR_CLEAR, val)
#define bfin_read_PORTF_INEN()		bfin_read16(PORTF_INEN)
#define bfin_write_PORTF_INEN(val)	bfin_write16(PORTF_INEN, val)
#define bfin_read_PORTF_MUX()		bfin_read32(PORTF_MUX)
#define bfin_write_PORTF_MUX(val)	bfin_write32(PORTF_MUX, val)

/* Port G Registers */

#define bfin_read_PORTG_FER()		bfin_read16(PORTG_FER)
#define bfin_write_PORTG_FER(val)	bfin_write16(PORTG_FER, val)
#define bfin_read_PORTG()		bfin_read16(PORTG)
#define bfin_write_PORTG(val)		bfin_write16(PORTG, val)
#define bfin_read_PORTG_SET()		bfin_read16(PORTG_SET)
#define bfin_write_PORTG_SET(val)	bfin_write16(PORTG_SET, val)
#define bfin_read_PORTG_CLEAR()		bfin_read16(PORTG_CLEAR)
#define bfin_write_PORTG_CLEAR(val)	bfin_write16(PORTG_CLEAR, val)
#define bfin_read_PORTG_DIR_SET()	bfin_read16(PORTG_DIR_SET)
#define bfin_write_PORTG_DIR_SET(val)	bfin_write16(PORTG_DIR_SET, val)
#define bfin_read_PORTG_DIR_CLEAR()	bfin_read16(PORTG_DIR_CLEAR)
#define bfin_write_PORTG_DIR_CLEAR(val)	bfin_write16(PORTG_DIR_CLEAR, val)
#define bfin_read_PORTG_INEN()		bfin_read16(PORTG_INEN)
#define bfin_write_PORTG_INEN(val)	bfin_write16(PORTG_INEN, val)
#define bfin_read_PORTG_MUX()		bfin_read32(PORTG_MUX)
#define bfin_write_PORTG_MUX(val)	bfin_write32(PORTG_MUX, val)

/* Port H Registers */

#define bfin_read_PORTH_FER()		bfin_read16(PORTH_FER)
#define bfin_write_PORTH_FER(val)	bfin_write16(PORTH_FER, val)
#define bfin_read_PORTH()		bfin_read16(PORTH)
#define bfin_write_PORTH(val)		bfin_write16(PORTH, val)
#define bfin_read_PORTH_SET()		bfin_read16(PORTH_SET)
#define bfin_write_PORTH_SET(val)	bfin_write16(PORTH_SET, val)
#define bfin_read_PORTH_CLEAR()		bfin_read16(PORTH_CLEAR)
#define bfin_write_PORTH_CLEAR(val)	bfin_write16(PORTH_CLEAR, val)
#define bfin_read_PORTH_DIR_SET()	bfin_read16(PORTH_DIR_SET)
#define bfin_write_PORTH_DIR_SET(val)	bfin_write16(PORTH_DIR_SET, val)
#define bfin_read_PORTH_DIR_CLEAR()	bfin_read16(PORTH_DIR_CLEAR)
#define bfin_write_PORTH_DIR_CLEAR(val)	bfin_write16(PORTH_DIR_CLEAR, val)
#define bfin_read_PORTH_INEN()		bfin_read16(PORTH_INEN)
#define bfin_write_PORTH_INEN(val)	bfin_write16(PORTH_INEN, val)
#define bfin_read_PORTH_MUX()		bfin_read32(PORTH_MUX)
#define bfin_write_PORTH_MUX(val)	bfin_write32(PORTH_MUX, val)

/* Port I Registers */

#define bfin_read_PORTI_FER()		bfin_read16(PORTI_FER)
#define bfin_write_PORTI_FER(val)	bfin_write16(PORTI_FER, val)
#define bfin_read_PORTI()		bfin_read16(PORTI)
#define bfin_write_PORTI(val)		bfin_write16(PORTI, val)
#define bfin_read_PORTI_SET()		bfin_read16(PORTI_SET)
#define bfin_write_PORTI_SET(val)	bfin_write16(PORTI_SET, val)
#define bfin_read_PORTI_CLEAR()		bfin_read16(PORTI_CLEAR)
#define bfin_write_PORTI_CLEAR(val)	bfin_write16(PORTI_CLEAR, val)
#define bfin_read_PORTI_DIR_SET()	bfin_read16(PORTI_DIR_SET)
#define bfin_write_PORTI_DIR_SET(val)	bfin_write16(PORTI_DIR_SET, val)
#define bfin_read_PORTI_DIR_CLEAR()	bfin_read16(PORTI_DIR_CLEAR)
#define bfin_write_PORTI_DIR_CLEAR(val)	bfin_write16(PORTI_DIR_CLEAR, val)
#define bfin_read_PORTI_INEN()		bfin_read16(PORTI_INEN)
#define bfin_write_PORTI_INEN(val)	bfin_write16(PORTI_INEN, val)
#define bfin_read_PORTI_MUX()		bfin_read32(PORTI_MUX)
#define bfin_write_PORTI_MUX(val)	bfin_write32(PORTI_MUX, val)

/* Port J Registers */

#define bfin_read_PORTJ_FER()		bfin_read16(PORTJ_FER)
#define bfin_write_PORTJ_FER(val)	bfin_write16(PORTJ_FER, val)
#define bfin_read_PORTJ()		bfin_read16(PORTJ)
#define bfin_write_PORTJ(val)		bfin_write16(PORTJ, val)
#define bfin_read_PORTJ_SET()		bfin_read16(PORTJ_SET)
#define bfin_write_PORTJ_SET(val)	bfin_write16(PORTJ_SET, val)
#define bfin_read_PORTJ_CLEAR()		bfin_read16(PORTJ_CLEAR)
#define bfin_write_PORTJ_CLEAR(val)	bfin_write16(PORTJ_CLEAR, val)
#define bfin_read_PORTJ_DIR_SET()	bfin_read16(PORTJ_DIR_SET)
#define bfin_write_PORTJ_DIR_SET(val)	bfin_write16(PORTJ_DIR_SET, val)
#define bfin_read_PORTJ_DIR_CLEAR()	bfin_read16(PORTJ_DIR_CLEAR)
#define bfin_write_PORTJ_DIR_CLEAR(val)	bfin_write16(PORTJ_DIR_CLEAR, val)
#define bfin_read_PORTJ_INEN()		bfin_read16(PORTJ_INEN)
#define bfin_write_PORTJ_INEN(val)	bfin_write16(PORTJ_INEN, val)
#define bfin_read_PORTJ_MUX()		bfin_read32(PORTJ_MUX)
#define bfin_write_PORTJ_MUX(val)	bfin_write32(PORTJ_MUX, val)

/* PWM Timer Registers */

#define bfin_read_TIMER0_CONFIG()		bfin_read16(TIMER0_CONFIG)
#define bfin_write_TIMER0_CONFIG(val)		bfin_write16(TIMER0_CONFIG, val)
#define bfin_read_TIMER0_COUNTER()		bfin_read32(TIMER0_COUNTER)
#define bfin_write_TIMER0_COUNTER(val)		bfin_write32(TIMER0_COUNTER, val)
#define bfin_read_TIMER0_PERIOD()		bfin_read32(TIMER0_PERIOD)
#define bfin_write_TIMER0_PERIOD(val)		bfin_write32(TIMER0_PERIOD, val)
#define bfin_read_TIMER0_WIDTH()		bfin_read32(TIMER0_WIDTH)
#define bfin_write_TIMER0_WIDTH(val)		bfin_write32(TIMER0_WIDTH, val)
#define bfin_read_TIMER1_CONFIG()		bfin_read16(TIMER1_CONFIG)
#define bfin_write_TIMER1_CONFIG(val)		bfin_write16(TIMER1_CONFIG, val)
#define bfin_read_TIMER1_COUNTER()		bfin_read32(TIMER1_COUNTER)
#define bfin_write_TIMER1_COUNTER(val)		bfin_write32(TIMER1_COUNTER, val)
#define bfin_read_TIMER1_PERIOD()		bfin_read32(TIMER1_PERIOD)
#define bfin_write_TIMER1_PERIOD(val)		bfin_write32(TIMER1_PERIOD, val)
#define bfin_read_TIMER1_WIDTH()		bfin_read32(TIMER1_WIDTH)
#define bfin_write_TIMER1_WIDTH(val)		bfin_write32(TIMER1_WIDTH, val)
#define bfin_read_TIMER2_CONFIG()		bfin_read16(TIMER2_CONFIG)
#define bfin_write_TIMER2_CONFIG(val)		bfin_write16(TIMER2_CONFIG, val)
#define bfin_read_TIMER2_COUNTER()		bfin_read32(TIMER2_COUNTER)
#define bfin_write_TIMER2_COUNTER(val)		bfin_write32(TIMER2_COUNTER, val)
#define bfin_read_TIMER2_PERIOD()		bfin_read32(TIMER2_PERIOD)
#define bfin_write_TIMER2_PERIOD(val)		bfin_write32(TIMER2_PERIOD, val)
#define bfin_read_TIMER2_WIDTH()		bfin_read32(TIMER2_WIDTH)
#define bfin_write_TIMER2_WIDTH(val)		bfin_write32(TIMER2_WIDTH, val)
#define bfin_read_TIMER3_CONFIG()		bfin_read16(TIMER3_CONFIG)
#define bfin_write_TIMER3_CONFIG(val)		bfin_write16(TIMER3_CONFIG, val)
#define bfin_read_TIMER3_COUNTER()		bfin_read32(TIMER3_COUNTER)
#define bfin_write_TIMER3_COUNTER(val)		bfin_write32(TIMER3_COUNTER, val)
#define bfin_read_TIMER3_PERIOD()		bfin_read32(TIMER3_PERIOD)
#define bfin_write_TIMER3_PERIOD(val)		bfin_write32(TIMER3_PERIOD, val)
#define bfin_read_TIMER3_WIDTH()		bfin_read32(TIMER3_WIDTH)
#define bfin_write_TIMER3_WIDTH(val)		bfin_write32(TIMER3_WIDTH, val)
#define bfin_read_TIMER4_CONFIG()		bfin_read16(TIMER4_CONFIG)
#define bfin_write_TIMER4_CONFIG(val)		bfin_write16(TIMER4_CONFIG, val)
#define bfin_read_TIMER4_COUNTER()		bfin_read32(TIMER4_COUNTER)
#define bfin_write_TIMER4_COUNTER(val)		bfin_write32(TIMER4_COUNTER, val)
#define bfin_read_TIMER4_PERIOD()		bfin_read32(TIMER4_PERIOD)
#define bfin_write_TIMER4_PERIOD(val)		bfin_write32(TIMER4_PERIOD, val)
#define bfin_read_TIMER4_WIDTH()		bfin_read32(TIMER4_WIDTH)
#define bfin_write_TIMER4_WIDTH(val)		bfin_write32(TIMER4_WIDTH, val)
#define bfin_read_TIMER5_CONFIG()		bfin_read16(TIMER5_CONFIG)
#define bfin_write_TIMER5_CONFIG(val)		bfin_write16(TIMER5_CONFIG, val)
#define bfin_read_TIMER5_COUNTER()		bfin_read32(TIMER5_COUNTER)
#define bfin_write_TIMER5_COUNTER(val)		bfin_write32(TIMER5_COUNTER, val)
#define bfin_read_TIMER5_PERIOD()		bfin_read32(TIMER5_PERIOD)
#define bfin_write_TIMER5_PERIOD(val)		bfin_write32(TIMER5_PERIOD, val)
#define bfin_read_TIMER5_WIDTH()		bfin_read32(TIMER5_WIDTH)
#define bfin_write_TIMER5_WIDTH(val)		bfin_write32(TIMER5_WIDTH, val)
#define bfin_read_TIMER6_CONFIG()		bfin_read16(TIMER6_CONFIG)
#define bfin_write_TIMER6_CONFIG(val)		bfin_write16(TIMER6_CONFIG, val)
#define bfin_read_TIMER6_COUNTER()		bfin_read32(TIMER6_COUNTER)
#define bfin_write_TIMER6_COUNTER(val)		bfin_write32(TIMER6_COUNTER, val)
#define bfin_read_TIMER6_PERIOD()		bfin_read32(TIMER6_PERIOD)
#define bfin_write_TIMER6_PERIOD(val)		bfin_write32(TIMER6_PERIOD, val)
#define bfin_read_TIMER6_WIDTH()		bfin_read32(TIMER6_WIDTH)
#define bfin_write_TIMER6_WIDTH(val)		bfin_write32(TIMER6_WIDTH, val)
#define bfin_read_TIMER7_CONFIG()		bfin_read16(TIMER7_CONFIG)
#define bfin_write_TIMER7_CONFIG(val)		bfin_write16(TIMER7_CONFIG, val)
#define bfin_read_TIMER7_COUNTER()		bfin_read32(TIMER7_COUNTER)
#define bfin_write_TIMER7_COUNTER(val)		bfin_write32(TIMER7_COUNTER, val)
#define bfin_read_TIMER7_PERIOD()		bfin_read32(TIMER7_PERIOD)
#define bfin_write_TIMER7_PERIOD(val)		bfin_write32(TIMER7_PERIOD, val)
#define bfin_read_TIMER7_WIDTH()		bfin_read32(TIMER7_WIDTH)
#define bfin_write_TIMER7_WIDTH(val)		bfin_write32(TIMER7_WIDTH, val)

/* Timer Groubfin_read_() of 8 */

#define bfin_read_TIMER_ENABLE0()		bfin_read16(TIMER_ENABLE0)
#define bfin_write_TIMER_ENABLE0(val)		bfin_write16(TIMER_ENABLE0, val)
#define bfin_read_TIMER_DISABLE0()		bfin_read16(TIMER_DISABLE0)
#define bfin_write_TIMER_DISABLE0(val)		bfin_write16(TIMER_DISABLE0, val)
#define bfin_read_TIMER_STATUS0()		bfin_read32(TIMER_STATUS0)
#define bfin_write_TIMER_STATUS0(val)		bfin_write32(TIMER_STATUS0, val)

/* DMAC1 Registers */

#define bfin_read_DMAC1_TC_PER()			bfin_read16(DMAC1_TC_PER)
#define bfin_write_DMAC1_TC_PER(val)		bfin_write16(DMAC1_TC_PER, val)
#define bfin_read_DMAC1_TC_CNT()			bfin_read16(DMAC1_TC_CNT)
#define bfin_write_DMAC1_TC_CNT(val)		bfin_write16(DMAC1_TC_CNT, val)

/* DMA Channel 12 Registers */

#define bfin_read_DMA12_NEXT_DESC_PTR() 	bfin_read32(DMA12_NEXT_DESC_PTR)
#define bfin_write_DMA12_NEXT_DESC_PTR(val) 	bfin_write32(DMA12_NEXT_DESC_PTR, val)
#define bfin_read_DMA12_START_ADDR() 		bfin_read32(DMA12_START_ADDR)
#define bfin_write_DMA12_START_ADDR(val) 	bfin_write32(DMA12_START_ADDR, val)
#define bfin_read_DMA12_CONFIG()		bfin_read16(DMA12_CONFIG)
#define bfin_write_DMA12_CONFIG(val)		bfin_write16(DMA12_CONFIG, val)
#define bfin_read_DMA12_X_COUNT()		bfin_read16(DMA12_X_COUNT)
#define bfin_write_DMA12_X_COUNT(val)		bfin_write16(DMA12_X_COUNT, val)
#define bfin_read_DMA12_X_MODIFY()		bfin_read16(DMA12_X_MODIFY)
#define bfin_write_DMA12_X_MODIFY(val) 		bfin_write16(DMA12_X_MODIFY, val)
#define bfin_read_DMA12_Y_COUNT()		bfin_read16(DMA12_Y_COUNT)
#define bfin_write_DMA12_Y_COUNT(val)		bfin_write16(DMA12_Y_COUNT, val)
#define bfin_read_DMA12_Y_MODIFY()		bfin_read16(DMA12_Y_MODIFY)
#define bfin_write_DMA12_Y_MODIFY(val) 		bfin_write16(DMA12_Y_MODIFY, val)
#define bfin_read_DMA12_CURR_DESC_PTR() 	bfin_read32(DMA12_CURR_DESC_PTR)
#define bfin_write_DMA12_CURR_DESC_PTR(val) 	bfin_write32(DMA12_CURR_DESC_PTR, val)
#define bfin_read_DMA12_CURR_ADDR() 		bfin_read32(DMA12_CURR_ADDR)
#define bfin_write_DMA12_CURR_ADDR(val) 	bfin_write32(DMA12_CURR_ADDR, val)
#define bfin_read_DMA12_IRQ_STATUS()		bfin_read16(DMA12_IRQ_STATUS)
#define bfin_write_DMA12_IRQ_STATUS(val)	bfin_write16(DMA12_IRQ_STATUS, val)
#define bfin_read_DMA12_PERIPHERAL_MAP()	bfin_read16(DMA12_PERIPHERAL_MAP)
#define bfin_write_DMA12_PERIPHERAL_MAP(val)	bfin_write16(DMA12_PERIPHERAL_MAP, val)
#define bfin_read_DMA12_CURR_X_COUNT()		bfin_read16(DMA12_CURR_X_COUNT)
#define bfin_write_DMA12_CURR_X_COUNT(val)	bfin_write16(DMA12_CURR_X_COUNT, val)
#define bfin_read_DMA12_CURR_Y_COUNT()		bfin_read16(DMA12_CURR_Y_COUNT)
#define bfin_write_DMA12_CURR_Y_COUNT(val)	bfin_write16(DMA12_CURR_Y_COUNT, val)

/* DMA Channel 13 Registers */

#define bfin_read_DMA13_NEXT_DESC_PTR() 	bfin_read32(DMA13_NEXT_DESC_PTR)
#define bfin_write_DMA13_NEXT_DESC_PTR(val) 	bfin_write32(DMA13_NEXT_DESC_PTR, val)
#define bfin_read_DMA13_START_ADDR() 		bfin_read32(DMA13_START_ADDR)
#define bfin_write_DMA13_START_ADDR(val) 	bfin_write32(DMA13_START_ADDR, val)
#define bfin_read_DMA13_CONFIG()		bfin_read16(DMA13_CONFIG)
#define bfin_write_DMA13_CONFIG(val)		bfin_write16(DMA13_CONFIG, val)
#define bfin_read_DMA13_X_COUNT()		bfin_read16(DMA13_X_COUNT)
#define bfin_write_DMA13_X_COUNT(val)		bfin_write16(DMA13_X_COUNT, val)
#define bfin_read_DMA13_X_MODIFY()		bfin_read16(DMA13_X_MODIFY)
#define bfin_write_DMA13_X_MODIFY(val) 		bfin_write16(DMA13_X_MODIFY, val)
#define bfin_read_DMA13_Y_COUNT()		bfin_read16(DMA13_Y_COUNT)
#define bfin_write_DMA13_Y_COUNT(val)		bfin_write16(DMA13_Y_COUNT, val)
#define bfin_read_DMA13_Y_MODIFY()		bfin_read16(DMA13_Y_MODIFY)
#define bfin_write_DMA13_Y_MODIFY(val) 		bfin_write16(DMA13_Y_MODIFY, val)
#define bfin_read_DMA13_CURR_DESC_PTR() 	bfin_read32(DMA13_CURR_DESC_PTR)
#define bfin_write_DMA13_CURR_DESC_PTR(val) 	bfin_write32(DMA13_CURR_DESC_PTR, val)
#define bfin_read_DMA13_CURR_ADDR() 		bfin_read32(DMA13_CURR_ADDR)
#define bfin_write_DMA13_CURR_ADDR(val) 	bfin_write32(DMA13_CURR_ADDR, val)
#define bfin_read_DMA13_IRQ_STATUS()		bfin_read16(DMA13_IRQ_STATUS)
#define bfin_write_DMA13_IRQ_STATUS(val)	bfin_write16(DMA13_IRQ_STATUS, val)
#define bfin_read_DMA13_PERIPHERAL_MAP()	bfin_read16(DMA13_PERIPHERAL_MAP)
#define bfin_write_DMA13_PERIPHERAL_MAP(val)	bfin_write16(DMA13_PERIPHERAL_MAP, val)
#define bfin_read_DMA13_CURR_X_COUNT()		bfin_read16(DMA13_CURR_X_COUNT)
#define bfin_write_DMA13_CURR_X_COUNT(val)	bfin_write16(DMA13_CURR_X_COUNT, val)
#define bfin_read_DMA13_CURR_Y_COUNT()		bfin_read16(DMA13_CURR_Y_COUNT)
#define bfin_write_DMA13_CURR_Y_COUNT(val)	bfin_write16(DMA13_CURR_Y_COUNT, val)

/* DMA Channel 14 Registers */

#define bfin_read_DMA14_NEXT_DESC_PTR() 	bfin_read32(DMA14_NEXT_DESC_PTR)
#define bfin_write_DMA14_NEXT_DESC_PTR(val) 	bfin_write32(DMA14_NEXT_DESC_PTR, val)
#define bfin_read_DMA14_START_ADDR() 		bfin_read32(DMA14_START_ADDR)
#define bfin_write_DMA14_START_ADDR(val) 	bfin_write32(DMA14_START_ADDR, val)
#define bfin_read_DMA14_CONFIG()		bfin_read16(DMA14_CONFIG)
#define bfin_write_DMA14_CONFIG(val)		bfin_write16(DMA14_CONFIG, val)
#define bfin_read_DMA14_X_COUNT()		bfin_read16(DMA14_X_COUNT)
#define bfin_write_DMA14_X_COUNT(val)		bfin_write16(DMA14_X_COUNT, val)
#define bfin_read_DMA14_X_MODIFY()		bfin_read16(DMA14_X_MODIFY)
#define bfin_write_DMA14_X_MODIFY(val) 		bfin_write16(DMA14_X_MODIFY, val)
#define bfin_read_DMA14_Y_COUNT()		bfin_read16(DMA14_Y_COUNT)
#define bfin_write_DMA14_Y_COUNT(val)		bfin_write16(DMA14_Y_COUNT, val)
#define bfin_read_DMA14_Y_MODIFY()		bfin_read16(DMA14_Y_MODIFY)
#define bfin_write_DMA14_Y_MODIFY(val) 		bfin_write16(DMA14_Y_MODIFY, val)
#define bfin_read_DMA14_CURR_DESC_PTR() 	bfin_read32(DMA14_CURR_DESC_PTR)
#define bfin_write_DMA14_CURR_DESC_PTR(val) 	bfin_write32(DMA14_CURR_DESC_PTR, val)
#define bfin_read_DMA14_CURR_ADDR() 		bfin_read32(DMA14_CURR_ADDR)
#define bfin_write_DMA14_CURR_ADDR(val) 	bfin_write32(DMA14_CURR_ADDR, val)
#define bfin_read_DMA14_IRQ_STATUS()		bfin_read16(DMA14_IRQ_STATUS)
#define bfin_write_DMA14_IRQ_STATUS(val)	bfin_write16(DMA14_IRQ_STATUS, val)
#define bfin_read_DMA14_PERIPHERAL_MAP()	bfin_read16(DMA14_PERIPHERAL_MAP)
#define bfin_write_DMA14_PERIPHERAL_MAP(val)	bfin_write16(DMA14_PERIPHERAL_MAP, val)
#define bfin_read_DMA14_CURR_X_COUNT()		bfin_read16(DMA14_CURR_X_COUNT)
#define bfin_write_DMA14_CURR_X_COUNT(val)	bfin_write16(DMA14_CURR_X_COUNT, val)
#define bfin_read_DMA14_CURR_Y_COUNT()		bfin_read16(DMA14_CURR_Y_COUNT)
#define bfin_write_DMA14_CURR_Y_COUNT(val)	bfin_write16(DMA14_CURR_Y_COUNT, val)

/* DMA Channel 15 Registers */

#define bfin_read_DMA15_NEXT_DESC_PTR() 	bfin_read32(DMA15_NEXT_DESC_PTR)
#define bfin_write_DMA15_NEXT_DESC_PTR(val) 	bfin_write32(DMA15_NEXT_DESC_PTR, val)
#define bfin_read_DMA15_START_ADDR() 		bfin_read32(DMA15_START_ADDR)
#define bfin_write_DMA15_START_ADDR(val) 	bfin_write32(DMA15_START_ADDR, val)
#define bfin_read_DMA15_CONFIG()		bfin_read16(DMA15_CONFIG)
#define bfin_write_DMA15_CONFIG(val)		bfin_write16(DMA15_CONFIG, val)
#define bfin_read_DMA15_X_COUNT()		bfin_read16(DMA15_X_COUNT)
#define bfin_write_DMA15_X_COUNT(val)		bfin_write16(DMA15_X_COUNT, val)
#define bfin_read_DMA15_X_MODIFY()		bfin_read16(DMA15_X_MODIFY)
#define bfin_write_DMA15_X_MODIFY(val) 		bfin_write16(DMA15_X_MODIFY, val)
#define bfin_read_DMA15_Y_COUNT()		bfin_read16(DMA15_Y_COUNT)
#define bfin_write_DMA15_Y_COUNT(val)		bfin_write16(DMA15_Y_COUNT, val)
#define bfin_read_DMA15_Y_MODIFY()		bfin_read16(DMA15_Y_MODIFY)
#define bfin_write_DMA15_Y_MODIFY(val) 		bfin_write16(DMA15_Y_MODIFY, val)
#define bfin_read_DMA15_CURR_DESC_PTR() 	bfin_read32(DMA15_CURR_DESC_PTR)
#define bfin_write_DMA15_CURR_DESC_PTR(val) 	bfin_write32(DMA15_CURR_DESC_PTR, val)
#define bfin_read_DMA15_CURR_ADDR() 		bfin_read32(DMA15_CURR_ADDR)
#define bfin_write_DMA15_CURR_ADDR(val) 	bfin_write32(DMA15_CURR_ADDR, val)
#define bfin_read_DMA15_IRQ_STATUS()		bfin_read16(DMA15_IRQ_STATUS)
#define bfin_write_DMA15_IRQ_STATUS(val)	bfin_write16(DMA15_IRQ_STATUS, val)
#define bfin_read_DMA15_PERIPHERAL_MAP()	bfin_read16(DMA15_PERIPHERAL_MAP)
#define bfin_write_DMA15_PERIPHERAL_MAP(val)	bfin_write16(DMA15_PERIPHERAL_MAP, val)
#define bfin_read_DMA15_CURR_X_COUNT()		bfin_read16(DMA15_CURR_X_COUNT)
#define bfin_write_DMA15_CURR_X_COUNT(val)	bfin_write16(DMA15_CURR_X_COUNT, val)
#define bfin_read_DMA15_CURR_Y_COUNT()		bfin_read16(DMA15_CURR_Y_COUNT)
#define bfin_write_DMA15_CURR_Y_COUNT(val)	bfin_write16(DMA15_CURR_Y_COUNT, val)

/* DMA Channel 16 Registers */

#define bfin_read_DMA16_NEXT_DESC_PTR() 	bfin_read32(DMA16_NEXT_DESC_PTR)
#define bfin_write_DMA16_NEXT_DESC_PTR(val) 	bfin_write32(DMA16_NEXT_DESC_PTR, val)
#define bfin_read_DMA16_START_ADDR() 		bfin_read32(DMA16_START_ADDR)
#define bfin_write_DMA16_START_ADDR(val) 	bfin_write32(DMA16_START_ADDR, val)
#define bfin_read_DMA16_CONFIG()		bfin_read16(DMA16_CONFIG)
#define bfin_write_DMA16_CONFIG(val)		bfin_write16(DMA16_CONFIG, val)
#define bfin_read_DMA16_X_COUNT()		bfin_read16(DMA16_X_COUNT)
#define bfin_write_DMA16_X_COUNT(val)		bfin_write16(DMA16_X_COUNT, val)
#define bfin_read_DMA16_X_MODIFY()		bfin_read16(DMA16_X_MODIFY)
#define bfin_write_DMA16_X_MODIFY(val) 		bfin_write16(DMA16_X_MODIFY, val)
#define bfin_read_DMA16_Y_COUNT()		bfin_read16(DMA16_Y_COUNT)
#define bfin_write_DMA16_Y_COUNT(val)		bfin_write16(DMA16_Y_COUNT, val)
#define bfin_read_DMA16_Y_MODIFY()		bfin_read16(DMA16_Y_MODIFY)
#define bfin_write_DMA16_Y_MODIFY(val) 		bfin_write16(DMA16_Y_MODIFY, val)
#define bfin_read_DMA16_CURR_DESC_PTR() 	bfin_read32(DMA16_CURR_DESC_PTR)
#define bfin_write_DMA16_CURR_DESC_PTR(val) 	bfin_write32(DMA16_CURR_DESC_PTR, val)
#define bfin_read_DMA16_CURR_ADDR() 		bfin_read32(DMA16_CURR_ADDR)
#define bfin_write_DMA16_CURR_ADDR(val) 	bfin_write32(DMA16_CURR_ADDR, val)
#define bfin_read_DMA16_IRQ_STATUS()		bfin_read16(DMA16_IRQ_STATUS)
#define bfin_write_DMA16_IRQ_STATUS(val)	bfin_write16(DMA16_IRQ_STATUS, val)
#define bfin_read_DMA16_PERIPHERAL_MAP()	bfin_read16(DMA16_PERIPHERAL_MAP)
#define bfin_write_DMA16_PERIPHERAL_MAP(val)	bfin_write16(DMA16_PERIPHERAL_MAP, val)
#define bfin_read_DMA16_CURR_X_COUNT()		bfin_read16(DMA16_CURR_X_COUNT)
#define bfin_write_DMA16_CURR_X_COUNT(val)	bfin_write16(DMA16_CURR_X_COUNT, val)
#define bfin_read_DMA16_CURR_Y_COUNT()		bfin_read16(DMA16_CURR_Y_COUNT)
#define bfin_write_DMA16_CURR_Y_COUNT(val)	bfin_write16(DMA16_CURR_Y_COUNT, val)

/* DMA Channel 17 Registers */

#define bfin_read_DMA17_NEXT_DESC_PTR() 	bfin_read32(DMA17_NEXT_DESC_PTR)
#define bfin_write_DMA17_NEXT_DESC_PTR(val) 	bfin_write32(DMA17_NEXT_DESC_PTR, val)
#define bfin_read_DMA17_START_ADDR() 		bfin_read32(DMA17_START_ADDR)
#define bfin_write_DMA17_START_ADDR(val) 	bfin_write32(DMA17_START_ADDR, val)
#define bfin_read_DMA17_CONFIG()		bfin_read16(DMA17_CONFIG)
#define bfin_write_DMA17_CONFIG(val)		bfin_write16(DMA17_CONFIG, val)
#define bfin_read_DMA17_X_COUNT()		bfin_read16(DMA17_X_COUNT)
#define bfin_write_DMA17_X_COUNT(val)		bfin_write16(DMA17_X_COUNT, val)
#define bfin_read_DMA17_X_MODIFY()		bfin_read16(DMA17_X_MODIFY)
#define bfin_write_DMA17_X_MODIFY(val) 		bfin_write16(DMA17_X_MODIFY, val)
#define bfin_read_DMA17_Y_COUNT()		bfin_read16(DMA17_Y_COUNT)
#define bfin_write_DMA17_Y_COUNT(val)		bfin_write16(DMA17_Y_COUNT, val)
#define bfin_read_DMA17_Y_MODIFY()		bfin_read16(DMA17_Y_MODIFY)
#define bfin_write_DMA17_Y_MODIFY(val) 		bfin_write16(DMA17_Y_MODIFY, val)
#define bfin_read_DMA17_CURR_DESC_PTR() 	bfin_read32(DMA17_CURR_DESC_PTR)
#define bfin_write_DMA17_CURR_DESC_PTR(val) 	bfin_write32(DMA17_CURR_DESC_PTR, val)
#define bfin_read_DMA17_CURR_ADDR() 		bfin_read32(DMA17_CURR_ADDR)
#define bfin_write_DMA17_CURR_ADDR(val) 	bfin_write32(DMA17_CURR_ADDR, val)
#define bfin_read_DMA17_IRQ_STATUS()		bfin_read16(DMA17_IRQ_STATUS)
#define bfin_write_DMA17_IRQ_STATUS(val)	bfin_write16(DMA17_IRQ_STATUS, val)
#define bfin_read_DMA17_PERIPHERAL_MAP()	bfin_read16(DMA17_PERIPHERAL_MAP)
#define bfin_write_DMA17_PERIPHERAL_MAP(val)	bfin_write16(DMA17_PERIPHERAL_MAP, val)
#define bfin_read_DMA17_CURR_X_COUNT()		bfin_read16(DMA17_CURR_X_COUNT)
#define bfin_write_DMA17_CURR_X_COUNT(val)	bfin_write16(DMA17_CURR_X_COUNT, val)
#define bfin_read_DMA17_CURR_Y_COUNT()		bfin_read16(DMA17_CURR_Y_COUNT)
#define bfin_write_DMA17_CURR_Y_COUNT(val)	bfin_write16(DMA17_CURR_Y_COUNT, val)

/* DMA Channel 18 Registers */

#define bfin_read_DMA18_NEXT_DESC_PTR() 	bfin_read32(DMA18_NEXT_DESC_PTR)
#define bfin_write_DMA18_NEXT_DESC_PTR(val) 	bfin_write32(DMA18_NEXT_DESC_PTR, val)
#define bfin_read_DMA18_START_ADDR() 		bfin_read32(DMA18_START_ADDR)
#define bfin_write_DMA18_START_ADDR(val) 	bfin_write32(DMA18_START_ADDR, val)
#define bfin_read_DMA18_CONFIG()		bfin_read16(DMA18_CONFIG)
#define bfin_write_DMA18_CONFIG(val)		bfin_write16(DMA18_CONFIG, val)
#define bfin_read_DMA18_X_COUNT()		bfin_read16(DMA18_X_COUNT)
#define bfin_write_DMA18_X_COUNT(val)		bfin_write16(DMA18_X_COUNT, val)
#define bfin_read_DMA18_X_MODIFY()		bfin_read16(DMA18_X_MODIFY)
#define bfin_write_DMA18_X_MODIFY(val) 		bfin_write16(DMA18_X_MODIFY, val)
#define bfin_read_DMA18_Y_COUNT()		bfin_read16(DMA18_Y_COUNT)
#define bfin_write_DMA18_Y_COUNT(val)		bfin_write16(DMA18_Y_COUNT, val)
#define bfin_read_DMA18_Y_MODIFY()		bfin_read16(DMA18_Y_MODIFY)
#define bfin_write_DMA18_Y_MODIFY(val) 		bfin_write16(DMA18_Y_MODIFY, val)
#define bfin_read_DMA18_CURR_DESC_PTR() 	bfin_read32(DMA18_CURR_DESC_PTR)
#define bfin_write_DMA18_CURR_DESC_PTR(val) 	bfin_write32(DMA18_CURR_DESC_PTR, val)
#define bfin_read_DMA18_CURR_ADDR() 		bfin_read32(DMA18_CURR_ADDR)
#define bfin_write_DMA18_CURR_ADDR(val) 	bfin_write32(DMA18_CURR_ADDR, val)
#define bfin_read_DMA18_IRQ_STATUS()		bfin_read16(DMA18_IRQ_STATUS)
#define bfin_write_DMA18_IRQ_STATUS(val)	bfin_write16(DMA18_IRQ_STATUS, val)
#define bfin_read_DMA18_PERIPHERAL_MAP()	bfin_read16(DMA18_PERIPHERAL_MAP)
#define bfin_write_DMA18_PERIPHERAL_MAP(val)	bfin_write16(DMA18_PERIPHERAL_MAP, val)
#define bfin_read_DMA18_CURR_X_COUNT()		bfin_read16(DMA18_CURR_X_COUNT)
#define bfin_write_DMA18_CURR_X_COUNT(val)	bfin_write16(DMA18_CURR_X_COUNT, val)
#define bfin_read_DMA18_CURR_Y_COUNT()		bfin_read16(DMA18_CURR_Y_COUNT)
#define bfin_write_DMA18_CURR_Y_COUNT(val)	bfin_write16(DMA18_CURR_Y_COUNT, val)

/* DMA Channel 19 Registers */

#define bfin_read_DMA19_NEXT_DESC_PTR() 	bfin_read32(DMA19_NEXT_DESC_PTR)
#define bfin_write_DMA19_NEXT_DESC_PTR(val) 	bfin_write32(DMA19_NEXT_DESC_PTR, val)
#define bfin_read_DMA19_START_ADDR() 		bfin_read32(DMA19_START_ADDR)
#define bfin_write_DMA19_START_ADDR(val) 	bfin_write32(DMA19_START_ADDR, val)
#define bfin_read_DMA19_CONFIG()		bfin_read16(DMA19_CONFIG)
#define bfin_write_DMA19_CONFIG(val)		bfin_write16(DMA19_CONFIG, val)
#define bfin_read_DMA19_X_COUNT()		bfin_read16(DMA19_X_COUNT)
#define bfin_write_DMA19_X_COUNT(val)		bfin_write16(DMA19_X_COUNT, val)
#define bfin_read_DMA19_X_MODIFY()		bfin_read16(DMA19_X_MODIFY)
#define bfin_write_DMA19_X_MODIFY(val) 		bfin_write16(DMA19_X_MODIFY, val)
#define bfin_read_DMA19_Y_COUNT()		bfin_read16(DMA19_Y_COUNT)
#define bfin_write_DMA19_Y_COUNT(val)		bfin_write16(DMA19_Y_COUNT, val)
#define bfin_read_DMA19_Y_MODIFY()		bfin_read16(DMA19_Y_MODIFY)
#define bfin_write_DMA19_Y_MODIFY(val) 		bfin_write16(DMA19_Y_MODIFY, val)
#define bfin_read_DMA19_CURR_DESC_PTR() 	bfin_read32(DMA19_CURR_DESC_PTR)
#define bfin_write_DMA19_CURR_DESC_PTR(val) 	bfin_write32(DMA19_CURR_DESC_PTR, val)
#define bfin_read_DMA19_CURR_ADDR() 		bfin_read32(DMA19_CURR_ADDR)
#define bfin_write_DMA19_CURR_ADDR(val) 	bfin_write32(DMA19_CURR_ADDR, val)
#define bfin_read_DMA19_IRQ_STATUS()		bfin_read16(DMA19_IRQ_STATUS)
#define bfin_write_DMA19_IRQ_STATUS(val)	bfin_write16(DMA19_IRQ_STATUS, val)
#define bfin_read_DMA19_PERIPHERAL_MAP()	bfin_read16(DMA19_PERIPHERAL_MAP)
#define bfin_write_DMA19_PERIPHERAL_MAP(val)	bfin_write16(DMA19_PERIPHERAL_MAP, val)
#define bfin_read_DMA19_CURR_X_COUNT()		bfin_read16(DMA19_CURR_X_COUNT)
#define bfin_write_DMA19_CURR_X_COUNT(val)	bfin_write16(DMA19_CURR_X_COUNT, val)
#define bfin_read_DMA19_CURR_Y_COUNT()		bfin_read16(DMA19_CURR_Y_COUNT)
#define bfin_write_DMA19_CURR_Y_COUNT(val)	bfin_write16(DMA19_CURR_Y_COUNT, val)

/* DMA Channel 20 Registers */

#define bfin_read_DMA20_NEXT_DESC_PTR() 	bfin_read32(DMA20_NEXT_DESC_PTR)
#define bfin_write_DMA20_NEXT_DESC_PTR(val) 	bfin_write32(DMA20_NEXT_DESC_PTR, val)
#define bfin_read_DMA20_START_ADDR() 		bfin_read32(DMA20_START_ADDR)
#define bfin_write_DMA20_START_ADDR(val) 	bfin_write32(DMA20_START_ADDR, val)
#define bfin_read_DMA20_CONFIG()		bfin_read16(DMA20_CONFIG)
#define bfin_write_DMA20_CONFIG(val)		bfin_write16(DMA20_CONFIG, val)
#define bfin_read_DMA20_X_COUNT()		bfin_read16(DMA20_X_COUNT)
#define bfin_write_DMA20_X_COUNT(val)		bfin_write16(DMA20_X_COUNT, val)
#define bfin_read_DMA20_X_MODIFY()		bfin_read16(DMA20_X_MODIFY)
#define bfin_write_DMA20_X_MODIFY(val) 		bfin_write16(DMA20_X_MODIFY, val)
#define bfin_read_DMA20_Y_COUNT()		bfin_read16(DMA20_Y_COUNT)
#define bfin_write_DMA20_Y_COUNT(val)		bfin_write16(DMA20_Y_COUNT, val)
#define bfin_read_DMA20_Y_MODIFY()		bfin_read16(DMA20_Y_MODIFY)
#define bfin_write_DMA20_Y_MODIFY(val) 		bfin_write16(DMA20_Y_MODIFY, val)
#define bfin_read_DMA20_CURR_DESC_PTR() 	bfin_read32(DMA20_CURR_DESC_PTR)
#define bfin_write_DMA20_CURR_DESC_PTR(val) 	bfin_write32(DMA20_CURR_DESC_PTR, val)
#define bfin_read_DMA20_CURR_ADDR() 		bfin_read32(DMA20_CURR_ADDR)
#define bfin_write_DMA20_CURR_ADDR(val) 	bfin_write32(DMA20_CURR_ADDR, val)
#define bfin_read_DMA20_IRQ_STATUS()		bfin_read16(DMA20_IRQ_STATUS)
#define bfin_write_DMA20_IRQ_STATUS(val)	bfin_write16(DMA20_IRQ_STATUS, val)
#define bfin_read_DMA20_PERIPHERAL_MAP()	bfin_read16(DMA20_PERIPHERAL_MAP)
#define bfin_write_DMA20_PERIPHERAL_MAP(val)	bfin_write16(DMA20_PERIPHERAL_MAP, val)
#define bfin_read_DMA20_CURR_X_COUNT()		bfin_read16(DMA20_CURR_X_COUNT)
#define bfin_write_DMA20_CURR_X_COUNT(val)	bfin_write16(DMA20_CURR_X_COUNT, val)
#define bfin_read_DMA20_CURR_Y_COUNT()		bfin_read16(DMA20_CURR_Y_COUNT)
#define bfin_write_DMA20_CURR_Y_COUNT(val)	bfin_write16(DMA20_CURR_Y_COUNT, val)

/* DMA Channel 21 Registers */

#define bfin_read_DMA21_NEXT_DESC_PTR() 	bfin_read32(DMA21_NEXT_DESC_PTR)
#define bfin_write_DMA21_NEXT_DESC_PTR(val) 	bfin_write32(DMA21_NEXT_DESC_PTR, val)
#define bfin_read_DMA21_START_ADDR() 		bfin_read32(DMA21_START_ADDR)
#define bfin_write_DMA21_START_ADDR(val) 	bfin_write32(DMA21_START_ADDR, val)
#define bfin_read_DMA21_CONFIG()		bfin_read16(DMA21_CONFIG)
#define bfin_write_DMA21_CONFIG(val)		bfin_write16(DMA21_CONFIG, val)
#define bfin_read_DMA21_X_COUNT()		bfin_read16(DMA21_X_COUNT)
#define bfin_write_DMA21_X_COUNT(val)		bfin_write16(DMA21_X_COUNT, val)
#define bfin_read_DMA21_X_MODIFY()		bfin_read16(DMA21_X_MODIFY)
#define bfin_write_DMA21_X_MODIFY(val) 		bfin_write16(DMA21_X_MODIFY, val)
#define bfin_read_DMA21_Y_COUNT()		bfin_read16(DMA21_Y_COUNT)
#define bfin_write_DMA21_Y_COUNT(val)		bfin_write16(DMA21_Y_COUNT, val)
#define bfin_read_DMA21_Y_MODIFY()		bfin_read16(DMA21_Y_MODIFY)
#define bfin_write_DMA21_Y_MODIFY(val) 		bfin_write16(DMA21_Y_MODIFY, val)
#define bfin_read_DMA21_CURR_DESC_PTR() 	bfin_read32(DMA21_CURR_DESC_PTR)
#define bfin_write_DMA21_CURR_DESC_PTR(val) 	bfin_write32(DMA21_CURR_DESC_PTR, val)
#define bfin_read_DMA21_CURR_ADDR() 		bfin_read32(DMA21_CURR_ADDR)
#define bfin_write_DMA21_CURR_ADDR(val) 	bfin_write32(DMA21_CURR_ADDR, val)
#define bfin_read_DMA21_IRQ_STATUS()		bfin_read16(DMA21_IRQ_STATUS)
#define bfin_write_DMA21_IRQ_STATUS(val)	bfin_write16(DMA21_IRQ_STATUS, val)
#define bfin_read_DMA21_PERIPHERAL_MAP()	bfin_read16(DMA21_PERIPHERAL_MAP)
#define bfin_write_DMA21_PERIPHERAL_MAP(val)	bfin_write16(DMA21_PERIPHERAL_MAP, val)
#define bfin_read_DMA21_CURR_X_COUNT()		bfin_read16(DMA21_CURR_X_COUNT)
#define bfin_write_DMA21_CURR_X_COUNT(val)	bfin_write16(DMA21_CURR_X_COUNT, val)
#define bfin_read_DMA21_CURR_Y_COUNT()		bfin_read16(DMA21_CURR_Y_COUNT)
#define bfin_write_DMA21_CURR_Y_COUNT(val)	bfin_write16(DMA21_CURR_Y_COUNT, val)

/* DMA Channel 22 Registers */

#define bfin_read_DMA22_NEXT_DESC_PTR() 	bfin_read32(DMA22_NEXT_DESC_PTR)
#define bfin_write_DMA22_NEXT_DESC_PTR(val) 	bfin_write32(DMA22_NEXT_DESC_PTR, val)
#define bfin_read_DMA22_START_ADDR() 		bfin_read32(DMA22_START_ADDR)
#define bfin_write_DMA22_START_ADDR(val) 	bfin_write32(DMA22_START_ADDR, val)
#define bfin_read_DMA22_CONFIG()		bfin_read16(DMA22_CONFIG)
#define bfin_write_DMA22_CONFIG(val)		bfin_write16(DMA22_CONFIG, val)
#define bfin_read_DMA22_X_COUNT()		bfin_read16(DMA22_X_COUNT)
#define bfin_write_DMA22_X_COUNT(val)		bfin_write16(DMA22_X_COUNT, val)
#define bfin_read_DMA22_X_MODIFY()		bfin_read16(DMA22_X_MODIFY)
#define bfin_write_DMA22_X_MODIFY(val) 		bfin_write16(DMA22_X_MODIFY, val)
#define bfin_read_DMA22_Y_COUNT()		bfin_read16(DMA22_Y_COUNT)
#define bfin_write_DMA22_Y_COUNT(val)		bfin_write16(DMA22_Y_COUNT, val)
#define bfin_read_DMA22_Y_MODIFY()		bfin_read16(DMA22_Y_MODIFY)
#define bfin_write_DMA22_Y_MODIFY(val) 		bfin_write16(DMA22_Y_MODIFY, val)
#define bfin_read_DMA22_CURR_DESC_PTR() 	bfin_read32(DMA22_CURR_DESC_PTR)
#define bfin_write_DMA22_CURR_DESC_PTR(val) 	bfin_write32(DMA22_CURR_DESC_PTR, val)
#define bfin_read_DMA22_CURR_ADDR() 		bfin_read32(DMA22_CURR_ADDR)
#define bfin_write_DMA22_CURR_ADDR(val) 	bfin_write32(DMA22_CURR_ADDR, val)
#define bfin_read_DMA22_IRQ_STATUS()		bfin_read16(DMA22_IRQ_STATUS)
#define bfin_write_DMA22_IRQ_STATUS(val)	bfin_write16(DMA22_IRQ_STATUS, val)
#define bfin_read_DMA22_PERIPHERAL_MAP()	bfin_read16(DMA22_PERIPHERAL_MAP)
#define bfin_write_DMA22_PERIPHERAL_MAP(val)	bfin_write16(DMA22_PERIPHERAL_MAP, val)
#define bfin_read_DMA22_CURR_X_COUNT()		bfin_read16(DMA22_CURR_X_COUNT)
#define bfin_write_DMA22_CURR_X_COUNT(val)	bfin_write16(DMA22_CURR_X_COUNT, val)
#define bfin_read_DMA22_CURR_Y_COUNT()		bfin_read16(DMA22_CURR_Y_COUNT)
#define bfin_write_DMA22_CURR_Y_COUNT(val)	bfin_write16(DMA22_CURR_Y_COUNT, val)

/* DMA Channel 23 Registers */

#define bfin_read_DMA23_NEXT_DESC_PTR() 		bfin_read32(DMA23_NEXT_DESC_PTR)
#define bfin_write_DMA23_NEXT_DESC_PTR(val) 		bfin_write32(DMA23_NEXT_DESC_PTR, val)
#define bfin_read_DMA23_START_ADDR() 			bfin_read32(DMA23_START_ADDR)
#define bfin_write_DMA23_START_ADDR(val) 		bfin_write32(DMA23_START_ADDR, val)
#define bfin_read_DMA23_CONFIG()			bfin_read16(DMA23_CONFIG)
#define bfin_write_DMA23_CONFIG(val)			bfin_write16(DMA23_CONFIG, val)
#define bfin_read_DMA23_X_COUNT()			bfin_read16(DMA23_X_COUNT)
#define bfin_write_DMA23_X_COUNT(val)			bfin_write16(DMA23_X_COUNT, val)
#define bfin_read_DMA23_X_MODIFY()			bfin_read16(DMA23_X_MODIFY)
#define bfin_write_DMA23_X_MODIFY(val) 			bfin_write16(DMA23_X_MODIFY, val)
#define bfin_read_DMA23_Y_COUNT()			bfin_read16(DMA23_Y_COUNT)
#define bfin_write_DMA23_Y_COUNT(val)			bfin_write16(DMA23_Y_COUNT, val)
#define bfin_read_DMA23_Y_MODIFY()			bfin_read16(DMA23_Y_MODIFY)
#define bfin_write_DMA23_Y_MODIFY(val) 			bfin_write16(DMA23_Y_MODIFY, val)
#define bfin_read_DMA23_CURR_DESC_PTR() 		bfin_read32(DMA23_CURR_DESC_PTR)
#define bfin_write_DMA23_CURR_DESC_PTR(val) 		bfin_write32(DMA23_CURR_DESC_PTR, val)
#define bfin_read_DMA23_CURR_ADDR() 			bfin_read32(DMA23_CURR_ADDR)
#define bfin_write_DMA23_CURR_ADDR(val) 		bfin_write32(DMA23_CURR_ADDR, val)
#define bfin_read_DMA23_IRQ_STATUS()			bfin_read16(DMA23_IRQ_STATUS)
#define bfin_write_DMA23_IRQ_STATUS(val)		bfin_write16(DMA23_IRQ_STATUS, val)
#define bfin_read_DMA23_PERIPHERAL_MAP()		bfin_read16(DMA23_PERIPHERAL_MAP)
#define bfin_write_DMA23_PERIPHERAL_MAP(val)		bfin_write16(DMA23_PERIPHERAL_MAP, val)
#define bfin_read_DMA23_CURR_X_COUNT()			bfin_read16(DMA23_CURR_X_COUNT)
#define bfin_write_DMA23_CURR_X_COUNT(val)		bfin_write16(DMA23_CURR_X_COUNT, val)
#define bfin_read_DMA23_CURR_Y_COUNT()			bfin_read16(DMA23_CURR_Y_COUNT)
#define bfin_write_DMA23_CURR_Y_COUNT(val)		bfin_write16(DMA23_CURR_Y_COUNT, val)

/* MDMA Stream 2 Registers */

#define bfin_read_MDMA_D2_NEXT_DESC_PTR() 		bfin_read32(MDMA_D2_NEXT_DESC_PTR)
#define bfin_write_MDMA_D2_NEXT_DESC_PTR(val) 		bfin_write32(MDMA_D2_NEXT_DESC_PTR, val)
#define bfin_read_MDMA_D2_START_ADDR() 			bfin_read32(MDMA_D2_START_ADDR)
#define bfin_write_MDMA_D2_START_ADDR(val) 		bfin_write32(MDMA_D2_START_ADDR, val)
#define bfin_read_MDMA_D2_CONFIG()			bfin_read16(MDMA_D2_CONFIG)
#define bfin_write_MDMA_D2_CONFIG(val)			bfin_write16(MDMA_D2_CONFIG, val)
#define bfin_read_MDMA_D2_X_COUNT()			bfin_read16(MDMA_D2_X_COUNT)
#define bfin_write_MDMA_D2_X_COUNT(val)			bfin_write16(MDMA_D2_X_COUNT, val)
#define bfin_read_MDMA_D2_X_MODIFY()			bfin_read16(MDMA_D2_X_MODIFY)
#define bfin_write_MDMA_D2_X_MODIFY(val) 		bfin_write16(MDMA_D2_X_MODIFY, val)
#define bfin_read_MDMA_D2_Y_COUNT()			bfin_read16(MDMA_D2_Y_COUNT)
#define bfin_write_MDMA_D2_Y_COUNT(val)			bfin_write16(MDMA_D2_Y_COUNT, val)
#define bfin_read_MDMA_D2_Y_MODIFY()			bfin_read16(MDMA_D2_Y_MODIFY)
#define bfin_write_MDMA_D2_Y_MODIFY(val) 		bfin_write16(MDMA_D2_Y_MODIFY, val)
#define bfin_read_MDMA_D2_CURR_DESC_PTR() 		bfin_read32(MDMA_D2_CURR_DESC_PTR)
#define bfin_write_MDMA_D2_CURR_DESC_PTR(val) 		bfin_write32(MDMA_D2_CURR_DESC_PTR, val)
#define bfin_read_MDMA_D2_CURR_ADDR() 			bfin_read32(MDMA_D2_CURR_ADDR)
#define bfin_write_MDMA_D2_CURR_ADDR(val) 		bfin_write32(MDMA_D2_CURR_ADDR, val)
#define bfin_read_MDMA_D2_IRQ_STATUS()			bfin_read16(MDMA_D2_IRQ_STATUS)
#define bfin_write_MDMA_D2_IRQ_STATUS(val)		bfin_write16(MDMA_D2_IRQ_STATUS, val)
#define bfin_read_MDMA_D2_PERIPHERAL_MAP()		bfin_read16(MDMA_D2_PERIPHERAL_MAP)
#define bfin_write_MDMA_D2_PERIPHERAL_MAP(val)		bfin_write16(MDMA_D2_PERIPHERAL_MAP, val)
#define bfin_read_MDMA_D2_CURR_X_COUNT()		bfin_read16(MDMA_D2_CURR_X_COUNT)
#define bfin_write_MDMA_D2_CURR_X_COUNT(val)		bfin_write16(MDMA_D2_CURR_X_COUNT, val)
#define bfin_read_MDMA_D2_CURR_Y_COUNT()		bfin_read16(MDMA_D2_CURR_Y_COUNT)
#define bfin_write_MDMA_D2_CURR_Y_COUNT(val)		bfin_write16(MDMA_D2_CURR_Y_COUNT, val)
#define bfin_read_MDMA_S2_NEXT_DESC_PTR() 		bfin_read32(MDMA_S2_NEXT_DESC_PTR)
#define bfin_write_MDMA_S2_NEXT_DESC_PTR(val) 		bfin_write32(MDMA_S2_NEXT_DESC_PTR, val)
#define bfin_read_MDMA_S2_START_ADDR() 			bfin_read32(MDMA_S2_START_ADDR)
#define bfin_write_MDMA_S2_START_ADDR(val) 		bfin_write32(MDMA_S2_START_ADDR, val)
#define bfin_read_MDMA_S2_CONFIG()			bfin_read16(MDMA_S2_CONFIG)
#define bfin_write_MDMA_S2_CONFIG(val)			bfin_write16(MDMA_S2_CONFIG, val)
#define bfin_read_MDMA_S2_X_COUNT()			bfin_read16(MDMA_S2_X_COUNT)
#define bfin_write_MDMA_S2_X_COUNT(val)			bfin_write16(MDMA_S2_X_COUNT, val)
#define bfin_read_MDMA_S2_X_MODIFY()			bfin_read16(MDMA_S2_X_MODIFY)
#define bfin_write_MDMA_S2_X_MODIFY(val) 		bfin_write16(MDMA_S2_X_MODIFY, val)
#define bfin_read_MDMA_S2_Y_COUNT()			bfin_read16(MDMA_S2_Y_COUNT)
#define bfin_write_MDMA_S2_Y_COUNT(val)			bfin_write16(MDMA_S2_Y_COUNT, val)
#define bfin_read_MDMA_S2_Y_MODIFY()			bfin_read16(MDMA_S2_Y_MODIFY)
#define bfin_write_MDMA_S2_Y_MODIFY(val) 		bfin_write16(MDMA_S2_Y_MODIFY, val)
#define bfin_read_MDMA_S2_CURR_DESC_PTR() 		bfin_read32(MDMA_S2_CURR_DESC_PTR)
#define bfin_write_MDMA_S2_CURR_DESC_PTR(val) 		bfin_write32(MDMA_S2_CURR_DESC_PTR, val)
#define bfin_read_MDMA_S2_CURR_ADDR() 			bfin_read32(MDMA_S2_CURR_ADDR)
#define bfin_write_MDMA_S2_CURR_ADDR(val) 		bfin_write32(MDMA_S2_CURR_ADDR, val)
#define bfin_read_MDMA_S2_IRQ_STATUS()			bfin_read16(MDMA_S2_IRQ_STATUS)
#define bfin_write_MDMA_S2_IRQ_STATUS(val)		bfin_write16(MDMA_S2_IRQ_STATUS, val)
#define bfin_read_MDMA_S2_PERIPHERAL_MAP()		bfin_read16(MDMA_S2_PERIPHERAL_MAP)
#define bfin_write_MDMA_S2_PERIPHERAL_MAP(val)		bfin_write16(MDMA_S2_PERIPHERAL_MAP, val)
#define bfin_read_MDMA_S2_CURR_X_COUNT()		bfin_read16(MDMA_S2_CURR_X_COUNT)
#define bfin_write_MDMA_S2_CURR_X_COUNT(val)		bfin_write16(MDMA_S2_CURR_X_COUNT, val)
#define bfin_read_MDMA_S2_CURR_Y_COUNT()		bfin_read16(MDMA_S2_CURR_Y_COUNT)
#define bfin_write_MDMA_S2_CURR_Y_COUNT(val)		bfin_write16(MDMA_S2_CURR_Y_COUNT, val)

/* MDMA Stream 3 Registers */

#define bfin_read_MDMA_D3_NEXT_DESC_PTR() 		bfin_read32(MDMA_D3_NEXT_DESC_PTR)
#define bfin_write_MDMA_D3_NEXT_DESC_PTR(val) 		bfin_write32(MDMA_D3_NEXT_DESC_PTR, val)
#define bfin_read_MDMA_D3_START_ADDR() 			bfin_read32(MDMA_D3_START_ADDR)
#define bfin_write_MDMA_D3_START_ADDR(val) 		bfin_write32(MDMA_D3_START_ADDR, val)
#define bfin_read_MDMA_D3_CONFIG()			bfin_read16(MDMA_D3_CONFIG)
#define bfin_write_MDMA_D3_CONFIG(val)			bfin_write16(MDMA_D3_CONFIG, val)
#define bfin_read_MDMA_D3_X_COUNT()			bfin_read16(MDMA_D3_X_COUNT)
#define bfin_write_MDMA_D3_X_COUNT(val)			bfin_write16(MDMA_D3_X_COUNT, val)
#define bfin_read_MDMA_D3_X_MODIFY()			bfin_read16(MDMA_D3_X_MODIFY)
#define bfin_write_MDMA_D3_X_MODIFY(val) 		bfin_write16(MDMA_D3_X_MODIFY, val)
#define bfin_read_MDMA_D3_Y_COUNT()			bfin_read16(MDMA_D3_Y_COUNT)
#define bfin_write_MDMA_D3_Y_COUNT(val)			bfin_write16(MDMA_D3_Y_COUNT, val)
#define bfin_read_MDMA_D3_Y_MODIFY()			bfin_read16(MDMA_D3_Y_MODIFY)
#define bfin_write_MDMA_D3_Y_MODIFY(val) 		bfin_write16(MDMA_D3_Y_MODIFY, val)
#define bfin_read_MDMA_D3_CURR_DESC_PTR() 		bfin_read32(MDMA_D3_CURR_DESC_PTR)
#define bfin_write_MDMA_D3_CURR_DESC_PTR(val) 		bfin_write32(MDMA_D3_CURR_DESC_PTR, val)
#define bfin_read_MDMA_D3_CURR_ADDR() 			bfin_read32(MDMA_D3_CURR_ADDR)
#define bfin_write_MDMA_D3_CURR_ADDR(val) 		bfin_write32(MDMA_D3_CURR_ADDR, val)
#define bfin_read_MDMA_D3_IRQ_STATUS()			bfin_read16(MDMA_D3_IRQ_STATUS)
#define bfin_write_MDMA_D3_IRQ_STATUS(val)		bfin_write16(MDMA_D3_IRQ_STATUS, val)
#define bfin_read_MDMA_D3_PERIPHERAL_MAP()		bfin_read16(MDMA_D3_PERIPHERAL_MAP)
#define bfin_write_MDMA_D3_PERIPHERAL_MAP(val)		bfin_write16(MDMA_D3_PERIPHERAL_MAP, val)
#define bfin_read_MDMA_D3_CURR_X_COUNT()		bfin_read16(MDMA_D3_CURR_X_COUNT)
#define bfin_write_MDMA_D3_CURR_X_COUNT(val)		bfin_write16(MDMA_D3_CURR_X_COUNT, val)
#define bfin_read_MDMA_D3_CURR_Y_COUNT()		bfin_read16(MDMA_D3_CURR_Y_COUNT)
#define bfin_write_MDMA_D3_CURR_Y_COUNT(val)		bfin_write16(MDMA_D3_CURR_Y_COUNT, val)
#define bfin_read_MDMA_S3_NEXT_DESC_PTR() 		bfin_read32(MDMA_S3_NEXT_DESC_PTR)
#define bfin_write_MDMA_S3_NEXT_DESC_PTR(val) 		bfin_write32(MDMA_S3_NEXT_DESC_PTR, val)
#define bfin_read_MDMA_S3_START_ADDR() 			bfin_read32(MDMA_S3_START_ADDR)
#define bfin_write_MDMA_S3_START_ADDR(val) 		bfin_write32(MDMA_S3_START_ADDR, val)
#define bfin_read_MDMA_S3_CONFIG()			bfin_read16(MDMA_S3_CONFIG)
#define bfin_write_MDMA_S3_CONFIG(val)			bfin_write16(MDMA_S3_CONFIG, val)
#define bfin_read_MDMA_S3_X_COUNT()			bfin_read16(MDMA_S3_X_COUNT)
#define bfin_write_MDMA_S3_X_COUNT(val)			bfin_write16(MDMA_S3_X_COUNT, val)
#define bfin_read_MDMA_S3_X_MODIFY()			bfin_read16(MDMA_S3_X_MODIFY)
#define bfin_write_MDMA_S3_X_MODIFY(val) 		bfin_write16(MDMA_S3_X_MODIFY, val)
#define bfin_read_MDMA_S3_Y_COUNT()			bfin_read16(MDMA_S3_Y_COUNT)
#define bfin_write_MDMA_S3_Y_COUNT(val)			bfin_write16(MDMA_S3_Y_COUNT, val)
#define bfin_read_MDMA_S3_Y_MODIFY()			bfin_read16(MDMA_S3_Y_MODIFY)
#define bfin_write_MDMA_S3_Y_MODIFY(val) 		bfin_write16(MDMA_S3_Y_MODIFY, val)
#define bfin_read_MDMA_S3_CURR_DESC_PTR() 		bfin_read32(MDMA_S3_CURR_DESC_PTR)
#define bfin_write_MDMA_S3_CURR_DESC_PTR(val) 		bfin_write32(MDMA_S3_CURR_DESC_PTR, val)
#define bfin_read_MDMA_S3_CURR_ADDR() 			bfin_read32(MDMA_S3_CURR_ADDR)
#define bfin_write_MDMA_S3_CURR_ADDR(val) 		bfin_write32(MDMA_S3_CURR_ADDR, val)
#define bfin_read_MDMA_S3_IRQ_STATUS()			bfin_read16(MDMA_S3_IRQ_STATUS)
#define bfin_write_MDMA_S3_IRQ_STATUS(val)		bfin_write16(MDMA_S3_IRQ_STATUS, val)
#define bfin_read_MDMA_S3_PERIPHERAL_MAP()		bfin_read16(MDMA_S3_PERIPHERAL_MAP)
#define bfin_write_MDMA_S3_PERIPHERAL_MAP(val)		bfin_write16(MDMA_S3_PERIPHERAL_MAP, val)
#define bfin_read_MDMA_S3_CURR_X_COUNT()		bfin_read16(MDMA_S3_CURR_X_COUNT)
#define bfin_write_MDMA_S3_CURR_X_COUNT(val)		bfin_write16(MDMA_S3_CURR_X_COUNT, val)
#define bfin_read_MDMA_S3_CURR_Y_COUNT()		bfin_read16(MDMA_S3_CURR_Y_COUNT)
#define bfin_write_MDMA_S3_CURR_Y_COUNT(val)		bfin_write16(MDMA_S3_CURR_Y_COUNT, val)

/* UART1 Registers */

#define bfin_read_UART1_DLL()			bfin_read16(UART1_DLL)
#define bfin_write_UART1_DLL(val)		bfin_write16(UART1_DLL, val)
#define bfin_read_UART1_DLH()			bfin_read16(UART1_DLH)
#define bfin_write_UART1_DLH(val)		bfin_write16(UART1_DLH, val)
#define bfin_read_UART1_GCTL()			bfin_read16(UART1_GCTL)
#define bfin_write_UART1_GCTL(val)		bfin_write16(UART1_GCTL, val)
#define bfin_read_UART1_LCR()			bfin_read16(UART1_LCR)
#define bfin_write_UART1_LCR(val)		bfin_write16(UART1_LCR, val)
#define bfin_read_UART1_MCR()			bfin_read16(UART1_MCR)
#define bfin_write_UART1_MCR(val)		bfin_write16(UART1_MCR, val)
#define bfin_read_UART1_LSR()			bfin_read16(UART1_LSR)
#define bfin_write_UART1_LSR(val)		bfin_write16(UART1_LSR, val)
#define bfin_read_UART1_MSR()			bfin_read16(UART1_MSR)
#define bfin_write_UART1_MSR(val)		bfin_write16(UART1_MSR, val)
#define bfin_read_UART1_SCR()			bfin_read16(UART1_SCR)
#define bfin_write_UART1_SCR(val)		bfin_write16(UART1_SCR, val)
#define bfin_read_UART1_IER_SET()		bfin_read16(UART1_IER_SET)
#define bfin_write_UART1_IER_SET(val)		bfin_write16(UART1_IER_SET, val)
#define bfin_read_UART1_IER_CLEAR()		bfin_read16(UART1_IER_CLEAR)
#define bfin_write_UART1_IER_CLEAR(val)		bfin_write16(UART1_IER_CLEAR, val)
#define bfin_read_UART1_THR()			bfin_read16(UART1_THR)
#define bfin_write_UART1_THR(val)		bfin_write16(UART1_THR, val)
#define bfin_read_UART1_RBR()			bfin_read16(UART1_RBR)
#define bfin_write_UART1_RBR(val)		bfin_write16(UART1_RBR, val)

/* UART2 is not defined in the shared file because it is not available on the ADSP-BF542 and ADSP-BF544 bfin_read_()rocessors */

/* SPI1 Registers */

#define bfin_read_SPI1_CTL()			bfin_read16(SPI1_CTL)
#define bfin_write_SPI1_CTL(val)		bfin_write16(SPI1_CTL, val)
#define bfin_read_SPI1_FLG()			bfin_read16(SPI1_FLG)
#define bfin_write_SPI1_FLG(val)		bfin_write16(SPI1_FLG, val)
#define bfin_read_SPI1_STAT()			bfin_read16(SPI1_STAT)
#define bfin_write_SPI1_STAT(val)		bfin_write16(SPI1_STAT, val)
#define bfin_read_SPI1_TDBR()			bfin_read16(SPI1_TDBR)
#define bfin_write_SPI1_TDBR(val)		bfin_write16(SPI1_TDBR, val)
#define bfin_read_SPI1_RDBR()			bfin_read16(SPI1_RDBR)
#define bfin_write_SPI1_RDBR(val)		bfin_write16(SPI1_RDBR, val)
#define bfin_read_SPI1_BAUD()			bfin_read16(SPI1_BAUD)
#define bfin_write_SPI1_BAUD(val)		bfin_write16(SPI1_BAUD, val)
#define bfin_read_SPI1_SHADOW()			bfin_read16(SPI1_SHADOW)
#define bfin_write_SPI1_SHADOW(val)		bfin_write16(SPI1_SHADOW, val)

/* SPORT2 Registers */

#define bfin_read_SPORT2_TCR1()			bfin_read16(SPORT2_TCR1)
#define bfin_write_SPORT2_TCR1(val)		bfin_write16(SPORT2_TCR1, val)
#define bfin_read_SPORT2_TCR2()			bfin_read16(SPORT2_TCR2)
#define bfin_write_SPORT2_TCR2(val)		bfin_write16(SPORT2_TCR2, val)
#define bfin_read_SPORT2_TCLKDIV()		bfin_read16(SPORT2_TCLKDIV)
#define bfin_write_SPORT2_TCLKDIV(val)		bfin_write16(SPORT2_TCLKDIV, val)
#define bfin_read_SPORT2_TFSDIV()		bfin_read16(SPORT2_TFSDIV)
#define bfin_write_SPORT2_TFSDIV(val)		bfin_write16(SPORT2_TFSDIV, val)
#define bfin_read_SPORT2_TX()			bfin_read32(SPORT2_TX)
#define bfin_write_SPORT2_TX(val)		bfin_write32(SPORT2_TX, val)
#define bfin_read_SPORT2_RX()			bfin_read32(SPORT2_RX)
#define bfin_write_SPORT2_RX(val)		bfin_write32(SPORT2_RX, val)
#define bfin_read_SPORT2_RCR1()			bfin_read16(SPORT2_RCR1)
#define bfin_write_SPORT2_RCR1(val)		bfin_write16(SPORT2_RCR1, val)
#define bfin_read_SPORT2_RCR2()			bfin_read16(SPORT2_RCR2)
#define bfin_write_SPORT2_RCR2(val)		bfin_write16(SPORT2_RCR2, val)
#define bfin_read_SPORT2_RCLKDIV()		bfin_read16(SPORT2_RCLKDIV)
#define bfin_write_SPORT2_RCLKDIV(val)		bfin_write16(SPORT2_RCLKDIV, val)
#define bfin_read_SPORT2_RFSDIV()		bfin_read16(SPORT2_RFSDIV)
#define bfin_write_SPORT2_RFSDIV(val)		bfin_write16(SPORT2_RFSDIV, val)
#define bfin_read_SPORT2_STAT()			bfin_read16(SPORT2_STAT)
#define bfin_write_SPORT2_STAT(val)		bfin_write16(SPORT2_STAT, val)
#define bfin_read_SPORT2_CHNL()			bfin_read16(SPORT2_CHNL)
#define bfin_write_SPORT2_CHNL(val)		bfin_write16(SPORT2_CHNL, val)
#define bfin_read_SPORT2_MCMC1()		bfin_read16(SPORT2_MCMC1)
#define bfin_write_SPORT2_MCMC1(val)		bfin_write16(SPORT2_MCMC1, val)
#define bfin_read_SPORT2_MCMC2()		bfin_read16(SPORT2_MCMC2)
#define bfin_write_SPORT2_MCMC2(val)		bfin_write16(SPORT2_MCMC2, val)
#define bfin_read_SPORT2_MTCS0()		bfin_read32(SPORT2_MTCS0)
#define bfin_write_SPORT2_MTCS0(val)		bfin_write32(SPORT2_MTCS0, val)
#define bfin_read_SPORT2_MTCS1()		bfin_read32(SPORT2_MTCS1)
#define bfin_write_SPORT2_MTCS1(val)		bfin_write32(SPORT2_MTCS1, val)
#define bfin_read_SPORT2_MTCS2()		bfin_read32(SPORT2_MTCS2)
#define bfin_write_SPORT2_MTCS2(val)		bfin_write32(SPORT2_MTCS2, val)
#define bfin_read_SPORT2_MTCS3()		bfin_read32(SPORT2_MTCS3)
#define bfin_write_SPORT2_MTCS3(val)		bfin_write32(SPORT2_MTCS3, val)
#define bfin_read_SPORT2_MRCS0()		bfin_read32(SPORT2_MRCS0)
#define bfin_write_SPORT2_MRCS0(val)		bfin_write32(SPORT2_MRCS0, val)
#define bfin_read_SPORT2_MRCS1()		bfin_read32(SPORT2_MRCS1)
#define bfin_write_SPORT2_MRCS1(val)		bfin_write32(SPORT2_MRCS1, val)
#define bfin_read_SPORT2_MRCS2()		bfin_read32(SPORT2_MRCS2)
#define bfin_write_SPORT2_MRCS2(val)		bfin_write32(SPORT2_MRCS2, val)
#define bfin_read_SPORT2_MRCS3()		bfin_read32(SPORT2_MRCS3)
#define bfin_write_SPORT2_MRCS3(val)		bfin_write32(SPORT2_MRCS3, val)

/* SPORT3 Registers */

#define bfin_read_SPORT3_TCR1()			bfin_read16(SPORT3_TCR1)
#define bfin_write_SPORT3_TCR1(val)		bfin_write16(SPORT3_TCR1, val)
#define bfin_read_SPORT3_TCR2()			bfin_read16(SPORT3_TCR2)
#define bfin_write_SPORT3_TCR2(val)		bfin_write16(SPORT3_TCR2, val)
#define bfin_read_SPORT3_TCLKDIV()		bfin_read16(SPORT3_TCLKDIV)
#define bfin_write_SPORT3_TCLKDIV(val)		bfin_write16(SPORT3_TCLKDIV, val)
#define bfin_read_SPORT3_TFSDIV()		bfin_read16(SPORT3_TFSDIV)
#define bfin_write_SPORT3_TFSDIV(val)		bfin_write16(SPORT3_TFSDIV, val)
#define bfin_read_SPORT3_TX()			bfin_read32(SPORT3_TX)
#define bfin_write_SPORT3_TX(val)		bfin_write32(SPORT3_TX, val)
#define bfin_read_SPORT3_RX()			bfin_read32(SPORT3_RX)
#define bfin_write_SPORT3_RX(val)		bfin_write32(SPORT3_RX, val)
#define bfin_read_SPORT3_RCR1()			bfin_read16(SPORT3_RCR1)
#define bfin_write_SPORT3_RCR1(val)		bfin_write16(SPORT3_RCR1, val)
#define bfin_read_SPORT3_RCR2()			bfin_read16(SPORT3_RCR2)
#define bfin_write_SPORT3_RCR2(val)		bfin_write16(SPORT3_RCR2, val)
#define bfin_read_SPORT3_RCLKDIV()		bfin_read16(SPORT3_RCLKDIV)
#define bfin_write_SPORT3_RCLKDIV(val)		bfin_write16(SPORT3_RCLKDIV, val)
#define bfin_read_SPORT3_RFSDIV()		bfin_read16(SPORT3_RFSDIV)
#define bfin_write_SPORT3_RFSDIV(val)		bfin_write16(SPORT3_RFSDIV, val)
#define bfin_read_SPORT3_STAT()			bfin_read16(SPORT3_STAT)
#define bfin_write_SPORT3_STAT(val)		bfin_write16(SPORT3_STAT, val)
#define bfin_read_SPORT3_CHNL()			bfin_read16(SPORT3_CHNL)
#define bfin_write_SPORT3_CHNL(val)		bfin_write16(SPORT3_CHNL, val)
#define bfin_read_SPORT3_MCMC1()		bfin_read16(SPORT3_MCMC1)
#define bfin_write_SPORT3_MCMC1(val)		bfin_write16(SPORT3_MCMC1, val)
#define bfin_read_SPORT3_MCMC2()		bfin_read16(SPORT3_MCMC2)
#define bfin_write_SPORT3_MCMC2(val)		bfin_write16(SPORT3_MCMC2, val)
#define bfin_read_SPORT3_MTCS0()		bfin_read32(SPORT3_MTCS0)
#define bfin_write_SPORT3_MTCS0(val)		bfin_write32(SPORT3_MTCS0, val)
#define bfin_read_SPORT3_MTCS1()		bfin_read32(SPORT3_MTCS1)
#define bfin_write_SPORT3_MTCS1(val)		bfin_write32(SPORT3_MTCS1, val)
#define bfin_read_SPORT3_MTCS2()		bfin_read32(SPORT3_MTCS2)
#define bfin_write_SPORT3_MTCS2(val)		bfin_write32(SPORT3_MTCS2, val)
#define bfin_read_SPORT3_MTCS3()		bfin_read32(SPORT3_MTCS3)
#define bfin_write_SPORT3_MTCS3(val)		bfin_write32(SPORT3_MTCS3, val)
#define bfin_read_SPORT3_MRCS0()		bfin_read32(SPORT3_MRCS0)
#define bfin_write_SPORT3_MRCS0(val)		bfin_write32(SPORT3_MRCS0, val)
#define bfin_read_SPORT3_MRCS1()		bfin_read32(SPORT3_MRCS1)
#define bfin_write_SPORT3_MRCS1(val)		bfin_write32(SPORT3_MRCS1, val)
#define bfin_read_SPORT3_MRCS2()		bfin_read32(SPORT3_MRCS2)
#define bfin_write_SPORT3_MRCS2(val)		bfin_write32(SPORT3_MRCS2, val)
#define bfin_read_SPORT3_MRCS3()		bfin_read32(SPORT3_MRCS3)
#define bfin_write_SPORT3_MRCS3(val)		bfin_write32(SPORT3_MRCS3, val)

/* EPPI2 Registers */

#define bfin_read_EPPI2_STATUS()		bfin_read16(EPPI2_STATUS)
#define bfin_write_EPPI2_STATUS(val)		bfin_write16(EPPI2_STATUS, val)
#define bfin_read_EPPI2_HCOUNT()		bfin_read16(EPPI2_HCOUNT)
#define bfin_write_EPPI2_HCOUNT(val)		bfin_write16(EPPI2_HCOUNT, val)
#define bfin_read_EPPI2_HDELAY()		bfin_read16(EPPI2_HDELAY)
#define bfin_write_EPPI2_HDELAY(val)		bfin_write16(EPPI2_HDELAY, val)
#define bfin_read_EPPI2_VCOUNT()		bfin_read16(EPPI2_VCOUNT)
#define bfin_write_EPPI2_VCOUNT(val)		bfin_write16(EPPI2_VCOUNT, val)
#define bfin_read_EPPI2_VDELAY()		bfin_read16(EPPI2_VDELAY)
#define bfin_write_EPPI2_VDELAY(val)		bfin_write16(EPPI2_VDELAY, val)
#define bfin_read_EPPI2_FRAME()			bfin_read16(EPPI2_FRAME)
#define bfin_write_EPPI2_FRAME(val)		bfin_write16(EPPI2_FRAME, val)
#define bfin_read_EPPI2_LINE()			bfin_read16(EPPI2_LINE)
#define bfin_write_EPPI2_LINE(val)		bfin_write16(EPPI2_LINE, val)
#define bfin_read_EPPI2_CLKDIV()		bfin_read16(EPPI2_CLKDIV)
#define bfin_write_EPPI2_CLKDIV(val)		bfin_write16(EPPI2_CLKDIV, val)
#define bfin_read_EPPI2_CONTROL()		bfin_read32(EPPI2_CONTROL)
#define bfin_write_EPPI2_CONTROL(val)		bfin_write32(EPPI2_CONTROL, val)
#define bfin_read_EPPI2_FS1W_HBL()		bfin_read32(EPPI2_FS1W_HBL)
#define bfin_write_EPPI2_FS1W_HBL(val)		bfin_write32(EPPI2_FS1W_HBL, val)
#define bfin_read_EPPI2_FS1P_AVPL()		bfin_read32(EPPI2_FS1P_AVPL)
#define bfin_write_EPPI2_FS1P_AVPL(val)		bfin_write32(EPPI2_FS1P_AVPL, val)
#define bfin_read_EPPI2_FS2W_LVB()		bfin_read32(EPPI2_FS2W_LVB)
#define bfin_write_EPPI2_FS2W_LVB(val)		bfin_write32(EPPI2_FS2W_LVB, val)
#define bfin_read_EPPI2_FS2P_LAVF()		bfin_read32(EPPI2_FS2P_LAVF)
#define bfin_write_EPPI2_FS2P_LAVF(val)		bfin_write32(EPPI2_FS2P_LAVF, val)
#define bfin_read_EPPI2_CLIP()			bfin_read32(EPPI2_CLIP)
#define bfin_write_EPPI2_CLIP(val)		bfin_write32(EPPI2_CLIP, val)

/* CAN Controller 0 Config 1 Registers */

#define bfin_read_CAN0_MC1()		bfin_read16(CAN0_MC1)
#define bfin_write_CAN0_MC1(val)	bfin_write16(CAN0_MC1, val)
#define bfin_read_CAN0_MD1()		bfin_read16(CAN0_MD1)
#define bfin_write_CAN0_MD1(val)	bfin_write16(CAN0_MD1, val)
#define bfin_read_CAN0_TRS1()		bfin_read16(CAN0_TRS1)
#define bfin_write_CAN0_TRS1(val)	bfin_write16(CAN0_TRS1, val)
#define bfin_read_CAN0_TRR1()		bfin_read16(CAN0_TRR1)
#define bfin_write_CAN0_TRR1(val)	bfin_write16(CAN0_TRR1, val)
#define bfin_read_CAN0_TA1()		bfin_read16(CAN0_TA1)
#define bfin_write_CAN0_TA1(val)	bfin_write16(CAN0_TA1, val)
#define bfin_read_CAN0_AA1()		bfin_read16(CAN0_AA1)
#define bfin_write_CAN0_AA1(val)	bfin_write16(CAN0_AA1, val)
#define bfin_read_CAN0_RMP1()		bfin_read16(CAN0_RMP1)
#define bfin_write_CAN0_RMP1(val)	bfin_write16(CAN0_RMP1, val)
#define bfin_read_CAN0_RML1()		bfin_read16(CAN0_RML1)
#define bfin_write_CAN0_RML1(val)	bfin_write16(CAN0_RML1, val)
#define bfin_read_CAN0_MBTIF1()		bfin_read16(CAN0_MBTIF1)
#define bfin_write_CAN0_MBTIF1(val)	bfin_write16(CAN0_MBTIF1, val)
#define bfin_read_CAN0_MBRIF1()		bfin_read16(CAN0_MBRIF1)
#define bfin_write_CAN0_MBRIF1(val)	bfin_write16(CAN0_MBRIF1, val)
#define bfin_read_CAN0_MBIM1()		bfin_read16(CAN0_MBIM1)
#define bfin_write_CAN0_MBIM1(val)	bfin_write16(CAN0_MBIM1, val)
#define bfin_read_CAN0_RFH1()		bfin_read16(CAN0_RFH1)
#define bfin_write_CAN0_RFH1(val)	bfin_write16(CAN0_RFH1, val)
#define bfin_read_CAN0_OPSS1()		bfin_read16(CAN0_OPSS1)
#define bfin_write_CAN0_OPSS1(val)	bfin_write16(CAN0_OPSS1, val)

/* CAN Controller 0 Config 2 Registers */

#define bfin_read_CAN0_MC2()		bfin_read16(CAN0_MC2)
#define bfin_write_CAN0_MC2(val)	bfin_write16(CAN0_MC2, val)
#define bfin_read_CAN0_MD2()		bfin_read16(CAN0_MD2)
#define bfin_write_CAN0_MD2(val)	bfin_write16(CAN0_MD2, val)
#define bfin_read_CAN0_TRS2()		bfin_read16(CAN0_TRS2)
#define bfin_write_CAN0_TRS2(val)	bfin_write16(CAN0_TRS2, val)
#define bfin_read_CAN0_TRR2()		bfin_read16(CAN0_TRR2)
#define bfin_write_CAN0_TRR2(val)	bfin_write16(CAN0_TRR2, val)
#define bfin_read_CAN0_TA2()		bfin_read16(CAN0_TA2)
#define bfin_write_CAN0_TA2(val)	bfin_write16(CAN0_TA2, val)
#define bfin_read_CAN0_AA2()		bfin_read16(CAN0_AA2)
#define bfin_write_CAN0_AA2(val)	bfin_write16(CAN0_AA2, val)
#define bfin_read_CAN0_RMP2()		bfin_read16(CAN0_RMP2)
#define bfin_write_CAN0_RMP2(val)	bfin_write16(CAN0_RMP2, val)
#define bfin_read_CAN0_RML2()		bfin_read16(CAN0_RML2)
#define bfin_write_CAN0_RML2(val)	bfin_write16(CAN0_RML2, val)
#define bfin_read_CAN0_MBTIF2()		bfin_read16(CAN0_MBTIF2)
#define bfin_write_CAN0_MBTIF2(val)	bfin_write16(CAN0_MBTIF2, val)
#define bfin_read_CAN0_MBRIF2()		bfin_read16(CAN0_MBRIF2)
#define bfin_write_CAN0_MBRIF2(val)	bfin_write16(CAN0_MBRIF2, val)
#define bfin_read_CAN0_MBIM2()		bfin_read16(CAN0_MBIM2)
#define bfin_write_CAN0_MBIM2(val)	bfin_write16(CAN0_MBIM2, val)
#define bfin_read_CAN0_RFH2()		bfin_read16(CAN0_RFH2)
#define bfin_write_CAN0_RFH2(val)	bfin_write16(CAN0_RFH2, val)
#define bfin_read_CAN0_OPSS2()		bfin_read16(CAN0_OPSS2)
#define bfin_write_CAN0_OPSS2(val)	bfin_write16(CAN0_OPSS2, val)

/* CAN Controller 0 Clock/Interrubfin_read_()t/Counter Registers */

#define bfin_read_CAN0_CLOCK()		bfin_read16(CAN0_CLOCK)
#define bfin_write_CAN0_CLOCK(val)	bfin_write16(CAN0_CLOCK, val)
#define bfin_read_CAN0_TIMING()		bfin_read16(CAN0_TIMING)
#define bfin_write_CAN0_TIMING(val)	bfin_write16(CAN0_TIMING, val)
#define bfin_read_CAN0_DEBUG()		bfin_read16(CAN0_DEBUG)
#define bfin_write_CAN0_DEBUG(val)	bfin_write16(CAN0_DEBUG, val)
#define bfin_read_CAN0_STATUS()		bfin_read16(CAN0_STATUS)
#define bfin_write_CAN0_STATUS(val)	bfin_write16(CAN0_STATUS, val)
#define bfin_read_CAN0_CEC()		bfin_read16(CAN0_CEC)
#define bfin_write_CAN0_CEC(val)	bfin_write16(CAN0_CEC, val)
#define bfin_read_CAN0_GIS()		bfin_read16(CAN0_GIS)
#define bfin_write_CAN0_GIS(val)	bfin_write16(CAN0_GIS, val)
#define bfin_read_CAN0_GIM()		bfin_read16(CAN0_GIM)
#define bfin_write_CAN0_GIM(val)	bfin_write16(CAN0_GIM, val)
#define bfin_read_CAN0_GIF()		bfin_read16(CAN0_GIF)
#define bfin_write_CAN0_GIF(val)	bfin_write16(CAN0_GIF, val)
#define bfin_read_CAN0_CONTROL()	bfin_read16(CAN0_CONTROL)
#define bfin_write_CAN0_CONTROL(val)	bfin_write16(CAN0_CONTROL, val)
#define bfin_read_CAN0_INTR()		bfin_read16(CAN0_INTR)
#define bfin_write_CAN0_INTR(val)	bfin_write16(CAN0_INTR, val)
#define bfin_read_CAN0_MBTD()		bfin_read16(CAN0_MBTD)
#define bfin_write_CAN0_MBTD(val)	bfin_write16(CAN0_MBTD, val)
#define bfin_read_CAN0_EWR()		bfin_read16(CAN0_EWR)
#define bfin_write_CAN0_EWR(val)	bfin_write16(CAN0_EWR, val)
#define bfin_read_CAN0_ESR()		bfin_read16(CAN0_ESR)
#define bfin_write_CAN0_ESR(val)	bfin_write16(CAN0_ESR, val)
#define bfin_read_CAN0_UCCNT()		bfin_read16(CAN0_UCCNT)
#define bfin_write_CAN0_UCCNT(val)	bfin_write16(CAN0_UCCNT, val)
#define bfin_read_CAN0_UCRC()		bfin_read16(CAN0_UCRC)
#define bfin_write_CAN0_UCRC(val)	bfin_write16(CAN0_UCRC, val)
#define bfin_read_CAN0_UCCNF()		bfin_read16(CAN0_UCCNF)
#define bfin_write_CAN0_UCCNF(val)	bfin_write16(CAN0_UCCNF, val)

/* CAN Controller 0 Accebfin_read_()tance Registers */

#define bfin_read_CAN0_AM00L()		bfin_read16(CAN0_AM00L)
#define bfin_write_CAN0_AM00L(val)	bfin_write16(CAN0_AM00L, val)
#define bfin_read_CAN0_AM00H()		bfin_read16(CAN0_AM00H)
#define bfin_write_CAN0_AM00H(val)	bfin_write16(CAN0_AM00H, val)
#define bfin_read_CAN0_AM01L()		bfin_read16(CAN0_AM01L)
#define bfin_write_CAN0_AM01L(val)	bfin_write16(CAN0_AM01L, val)
#define bfin_read_CAN0_AM01H()		bfin_read16(CAN0_AM01H)
#define bfin_write_CAN0_AM01H(val)	bfin_write16(CAN0_AM01H, val)
#define bfin_read_CAN0_AM02L()		bfin_read16(CAN0_AM02L)
#define bfin_write_CAN0_AM02L(val)	bfin_write16(CAN0_AM02L, val)
#define bfin_read_CAN0_AM02H()		bfin_read16(CAN0_AM02H)
#define bfin_write_CAN0_AM02H(val)	bfin_write16(CAN0_AM02H, val)
#define bfin_read_CAN0_AM03L()		bfin_read16(CAN0_AM03L)
#define bfin_write_CAN0_AM03L(val)	bfin_write16(CAN0_AM03L, val)
#define bfin_read_CAN0_AM03H()		bfin_read16(CAN0_AM03H)
#define bfin_write_CAN0_AM03H(val)	bfin_write16(CAN0_AM03H, val)
#define bfin_read_CAN0_AM04L()		bfin_read16(CAN0_AM04L)
#define bfin_write_CAN0_AM04L(val)	bfin_write16(CAN0_AM04L, val)
#define bfin_read_CAN0_AM04H()		bfin_read16(CAN0_AM04H)
#define bfin_write_CAN0_AM04H(val)	bfin_write16(CAN0_AM04H, val)
#define bfin_read_CAN0_AM05L()		bfin_read16(CAN0_AM05L)
#define bfin_write_CAN0_AM05L(val)	bfin_write16(CAN0_AM05L, val)
#define bfin_read_CAN0_AM05H()		bfin_read16(CAN0_AM05H)
#define bfin_write_CAN0_AM05H(val)	bfin_write16(CAN0_AM05H, val)
#define bfin_read_CAN0_AM06L()		bfin_read16(CAN0_AM06L)
#define bfin_write_CAN0_AM06L(val)	bfin_write16(CAN0_AM06L, val)
#define bfin_read_CAN0_AM06H()		bfin_read16(CAN0_AM06H)
#define bfin_write_CAN0_AM06H(val)	bfin_write16(CAN0_AM06H, val)
#define bfin_read_CAN0_AM07L()		bfin_read16(CAN0_AM07L)
#define bfin_write_CAN0_AM07L(val)	bfin_write16(CAN0_AM07L, val)
#define bfin_read_CAN0_AM07H()		bfin_read16(CAN0_AM07H)
#define bfin_write_CAN0_AM07H(val)	bfin_write16(CAN0_AM07H, val)
#define bfin_read_CAN0_AM08L()		bfin_read16(CAN0_AM08L)
#define bfin_write_CAN0_AM08L(val)	bfin_write16(CAN0_AM08L, val)
#define bfin_read_CAN0_AM08H()		bfin_read16(CAN0_AM08H)
#define bfin_write_CAN0_AM08H(val)	bfin_write16(CAN0_AM08H, val)
#define bfin_read_CAN0_AM09L()		bfin_read16(CAN0_AM09L)
#define bfin_write_CAN0_AM09L(val)	bfin_write16(CAN0_AM09L, val)
#define bfin_read_CAN0_AM09H()		bfin_read16(CAN0_AM09H)
#define bfin_write_CAN0_AM09H(val)	bfin_write16(CAN0_AM09H, val)
#define bfin_read_CAN0_AM10L()		bfin_read16(CAN0_AM10L)
#define bfin_write_CAN0_AM10L(val)	bfin_write16(CAN0_AM10L, val)
#define bfin_read_CAN0_AM10H()		bfin_read16(CAN0_AM10H)
#define bfin_write_CAN0_AM10H(val)	bfin_write16(CAN0_AM10H, val)
#define bfin_read_CAN0_AM11L()		bfin_read16(CAN0_AM11L)
#define bfin_write_CAN0_AM11L(val)	bfin_write16(CAN0_AM11L, val)
#define bfin_read_CAN0_AM11H()		bfin_read16(CAN0_AM11H)
#define bfin_write_CAN0_AM11H(val)	bfin_write16(CAN0_AM11H, val)
#define bfin_read_CAN0_AM12L()		bfin_read16(CAN0_AM12L)
#define bfin_write_CAN0_AM12L(val)	bfin_write16(CAN0_AM12L, val)
#define bfin_read_CAN0_AM12H()		bfin_read16(CAN0_AM12H)
#define bfin_write_CAN0_AM12H(val)	bfin_write16(CAN0_AM12H, val)
#define bfin_read_CAN0_AM13L()		bfin_read16(CAN0_AM13L)
#define bfin_write_CAN0_AM13L(val)	bfin_write16(CAN0_AM13L, val)
#define bfin_read_CAN0_AM13H()		bfin_read16(CAN0_AM13H)
#define bfin_write_CAN0_AM13H(val)	bfin_write16(CAN0_AM13H, val)
#define bfin_read_CAN0_AM14L()		bfin_read16(CAN0_AM14L)
#define bfin_write_CAN0_AM14L(val)	bfin_write16(CAN0_AM14L, val)
#define bfin_read_CAN0_AM14H()		bfin_read16(CAN0_AM14H)
#define bfin_write_CAN0_AM14H(val)	bfin_write16(CAN0_AM14H, val)
#define bfin_read_CAN0_AM15L()		bfin_read16(CAN0_AM15L)
#define bfin_write_CAN0_AM15L(val)	bfin_write16(CAN0_AM15L, val)
#define bfin_read_CAN0_AM15H()		bfin_read16(CAN0_AM15H)
#define bfin_write_CAN0_AM15H(val)	bfin_write16(CAN0_AM15H, val)

/* CAN Controller 0 Accebfin_read_()tance Registers */

#define bfin_read_CAN0_AM16L()		bfin_read16(CAN0_AM16L)
#define bfin_write_CAN0_AM16L(val)	bfin_write16(CAN0_AM16L, val)
#define bfin_read_CAN0_AM16H()		bfin_read16(CAN0_AM16H)
#define bfin_write_CAN0_AM16H(val)	bfin_write16(CAN0_AM16H, val)
#define bfin_read_CAN0_AM17L()		bfin_read16(CAN0_AM17L)
#define bfin_write_CAN0_AM17L(val)	bfin_write16(CAN0_AM17L, val)
#define bfin_read_CAN0_AM17H()		bfin_read16(CAN0_AM17H)
#define bfin_write_CAN0_AM17H(val)	bfin_write16(CAN0_AM17H, val)
#define bfin_read_CAN0_AM18L()		bfin_read16(CAN0_AM18L)
#define bfin_write_CAN0_AM18L(val)	bfin_write16(CAN0_AM18L, val)
#define bfin_read_CAN0_AM18H()		bfin_read16(CAN0_AM18H)
#define bfin_write_CAN0_AM18H(val)	bfin_write16(CAN0_AM18H, val)
#define bfin_read_CAN0_AM19L()		bfin_read16(CAN0_AM19L)
#define bfin_write_CAN0_AM19L(val)	bfin_write16(CAN0_AM19L, val)
#define bfin_read_CAN0_AM19H()		bfin_read16(CAN0_AM19H)
#define bfin_write_CAN0_AM19H(val)	bfin_write16(CAN0_AM19H, val)
#define bfin_read_CAN0_AM20L()		bfin_read16(CAN0_AM20L)
#define bfin_write_CAN0_AM20L(val)	bfin_write16(CAN0_AM20L, val)
#define bfin_read_CAN0_AM20H()		bfin_read16(CAN0_AM20H)
#define bfin_write_CAN0_AM20H(val)	bfin_write16(CAN0_AM20H, val)
#define bfin_read_CAN0_AM21L()		bfin_read16(CAN0_AM21L)
#define bfin_write_CAN0_AM21L(val)	bfin_write16(CAN0_AM21L, val)
#define bfin_read_CAN0_AM21H()		bfin_read16(CAN0_AM21H)
#define bfin_write_CAN0_AM21H(val)	bfin_write16(CAN0_AM21H, val)
#define bfin_read_CAN0_AM22L()		bfin_read16(CAN0_AM22L)
#define bfin_write_CAN0_AM22L(val)	bfin_write16(CAN0_AM22L, val)
#define bfin_read_CAN0_AM22H()		bfin_read16(CAN0_AM22H)
#define bfin_write_CAN0_AM22H(val)	bfin_write16(CAN0_AM22H, val)
#define bfin_read_CAN0_AM23L()		bfin_read16(CAN0_AM23L)
#define bfin_write_CAN0_AM23L(val)	bfin_write16(CAN0_AM23L, val)
#define bfin_read_CAN0_AM23H()		bfin_read16(CAN0_AM23H)
#define bfin_write_CAN0_AM23H(val)	bfin_write16(CAN0_AM23H, val)
#define bfin_read_CAN0_AM24L()		bfin_read16(CAN0_AM24L)
#define bfin_write_CAN0_AM24L(val)	bfin_write16(CAN0_AM24L, val)
#define bfin_read_CAN0_AM24H()		bfin_read16(CAN0_AM24H)
#define bfin_write_CAN0_AM24H(val)	bfin_write16(CAN0_AM24H, val)
#define bfin_read_CAN0_AM25L()		bfin_read16(CAN0_AM25L)
#define bfin_write_CAN0_AM25L(val)	bfin_write16(CAN0_AM25L, val)
#define bfin_read_CAN0_AM25H()		bfin_read16(CAN0_AM25H)
#define bfin_write_CAN0_AM25H(val)	bfin_write16(CAN0_AM25H, val)
#define bfin_read_CAN0_AM26L()		bfin_read16(CAN0_AM26L)
#define bfin_write_CAN0_AM26L(val)	bfin_write16(CAN0_AM26L, val)
#define bfin_read_CAN0_AM26H()		bfin_read16(CAN0_AM26H)
#define bfin_write_CAN0_AM26H(val)	bfin_write16(CAN0_AM26H, val)
#define bfin_read_CAN0_AM27L()		bfin_read16(CAN0_AM27L)
#define bfin_write_CAN0_AM27L(val)	bfin_write16(CAN0_AM27L, val)
#define bfin_read_CAN0_AM27H()		bfin_read16(CAN0_AM27H)
#define bfin_write_CAN0_AM27H(val)	bfin_write16(CAN0_AM27H, val)
#define bfin_read_CAN0_AM28L()		bfin_read16(CAN0_AM28L)
#define bfin_write_CAN0_AM28L(val)	bfin_write16(CAN0_AM28L, val)
#define bfin_read_CAN0_AM28H()		bfin_read16(CAN0_AM28H)
#define bfin_write_CAN0_AM28H(val)	bfin_write16(CAN0_AM28H, val)
#define bfin_read_CAN0_AM29L()		bfin_read16(CAN0_AM29L)
#define bfin_write_CAN0_AM29L(val)	bfin_write16(CAN0_AM29L, val)
#define bfin_read_CAN0_AM29H()		bfin_read16(CAN0_AM29H)
#define bfin_write_CAN0_AM29H(val)	bfin_write16(CAN0_AM29H, val)
#define bfin_read_CAN0_AM30L()		bfin_read16(CAN0_AM30L)
#define bfin_write_CAN0_AM30L(val)	bfin_write16(CAN0_AM30L, val)
#define bfin_read_CAN0_AM30H()		bfin_read16(CAN0_AM30H)
#define bfin_write_CAN0_AM30H(val)	bfin_write16(CAN0_AM30H, val)
#define bfin_read_CAN0_AM31L()		bfin_read16(CAN0_AM31L)
#define bfin_write_CAN0_AM31L(val)	bfin_write16(CAN0_AM31L, val)
#define bfin_read_CAN0_AM31H()		bfin_read16(CAN0_AM31H)
#define bfin_write_CAN0_AM31H(val)	bfin_write16(CAN0_AM31H, val)

/* CAN Controller 0 Mailbox Data Registers */

#define bfin_read_CAN0_MB00_DATA0()		bfin_read16(CAN0_MB00_DATA0)
#define bfin_write_CAN0_MB00_DATA0(val)		bfin_write16(CAN0_MB00_DATA0, val)
#define bfin_read_CAN0_MB00_DATA1()		bfin_read16(CAN0_MB00_DATA1)
#define bfin_write_CAN0_MB00_DATA1(val)		bfin_write16(CAN0_MB00_DATA1, val)
#define bfin_read_CAN0_MB00_DATA2()		bfin_read16(CAN0_MB00_DATA2)
#define bfin_write_CAN0_MB00_DATA2(val)		bfin_write16(CAN0_MB00_DATA2, val)
#define bfin_read_CAN0_MB00_DATA3()		bfin_read16(CAN0_MB00_DATA3)
#define bfin_write_CAN0_MB00_DATA3(val)		bfin_write16(CAN0_MB00_DATA3, val)
#define bfin_read_CAN0_MB00_LENGTH()		bfin_read16(CAN0_MB00_LENGTH)
#define bfin_write_CAN0_MB00_LENGTH(val)	bfin_write16(CAN0_MB00_LENGTH, val)
#define bfin_read_CAN0_MB00_TIMESTAMP()		bfin_read16(CAN0_MB00_TIMESTAMP)
#define bfin_write_CAN0_MB00_TIMESTAMP(val)	bfin_write16(CAN0_MB00_TIMESTAMP, val)
#define bfin_read_CAN0_MB00_ID0()		bfin_read16(CAN0_MB00_ID0)
#define bfin_write_CAN0_MB00_ID0(val)		bfin_write16(CAN0_MB00_ID0, val)
#define bfin_read_CAN0_MB00_ID1()		bfin_read16(CAN0_MB00_ID1)
#define bfin_write_CAN0_MB00_ID1(val)		bfin_write16(CAN0_MB00_ID1, val)
#define bfin_read_CAN0_MB01_DATA0()		bfin_read16(CAN0_MB01_DATA0)
#define bfin_write_CAN0_MB01_DATA0(val)		bfin_write16(CAN0_MB01_DATA0, val)
#define bfin_read_CAN0_MB01_DATA1()		bfin_read16(CAN0_MB01_DATA1)
#define bfin_write_CAN0_MB01_DATA1(val)		bfin_write16(CAN0_MB01_DATA1, val)
#define bfin_read_CAN0_MB01_DATA2()		bfin_read16(CAN0_MB01_DATA2)
#define bfin_write_CAN0_MB01_DATA2(val)		bfin_write16(CAN0_MB01_DATA2, val)
#define bfin_read_CAN0_MB01_DATA3()		bfin_read16(CAN0_MB01_DATA3)
#define bfin_write_CAN0_MB01_DATA3(val)		bfin_write16(CAN0_MB01_DATA3, val)
#define bfin_read_CAN0_MB01_LENGTH()		bfin_read16(CAN0_MB01_LENGTH)
#define bfin_write_CAN0_MB01_LENGTH(val)	bfin_write16(CAN0_MB01_LENGTH, val)
#define bfin_read_CAN0_MB01_TIMESTAMP()		bfin_read16(CAN0_MB01_TIMESTAMP)
#define bfin_write_CAN0_MB01_TIMESTAMP(val)	bfin_write16(CAN0_MB01_TIMESTAMP, val)
#define bfin_read_CAN0_MB01_ID0()		bfin_read16(CAN0_MB01_ID0)
#define bfin_write_CAN0_MB01_ID0(val)		bfin_write16(CAN0_MB01_ID0, val)
#define bfin_read_CAN0_MB01_ID1()		bfin_read16(CAN0_MB01_ID1)
#define bfin_write_CAN0_MB01_ID1(val)		bfin_write16(CAN0_MB01_ID1, val)
#define bfin_read_CAN0_MB02_DATA0()		bfin_read16(CAN0_MB02_DATA0)
#define bfin_write_CAN0_MB02_DATA0(val)		bfin_write16(CAN0_MB02_DATA0, val)
#define bfin_read_CAN0_MB02_DATA1()		bfin_read16(CAN0_MB02_DATA1)
#define bfin_write_CAN0_MB02_DATA1(val)		bfin_write16(CAN0_MB02_DATA1, val)
#define bfin_read_CAN0_MB02_DATA2()		bfin_read16(CAN0_MB02_DATA2)
#define bfin_write_CAN0_MB02_DATA2(val)		bfin_write16(CAN0_MB02_DATA2, val)
#define bfin_read_CAN0_MB02_DATA3()		bfin_read16(CAN0_MB02_DATA3)
#define bfin_write_CAN0_MB02_DATA3(val)		bfin_write16(CAN0_MB02_DATA3, val)
#define bfin_read_CAN0_MB02_LENGTH()		bfin_read16(CAN0_MB02_LENGTH)
#define bfin_write_CAN0_MB02_LENGTH(val)	bfin_write16(CAN0_MB02_LENGTH, val)
#define bfin_read_CAN0_MB02_TIMESTAMP()		bfin_read16(CAN0_MB02_TIMESTAMP)
#define bfin_write_CAN0_MB02_TIMESTAMP(val)	bfin_write16(CAN0_MB02_TIMESTAMP, val)
#define bfin_read_CAN0_MB02_ID0()		bfin_read16(CAN0_MB02_ID0)
#define bfin_write_CAN0_MB02_ID0(val)		bfin_write16(CAN0_MB02_ID0, val)
#define bfin_read_CAN0_MB02_ID1()		bfin_read16(CAN0_MB02_ID1)
#define bfin_write_CAN0_MB02_ID1(val)		bfin_write16(CAN0_MB02_ID1, val)
#define bfin_read_CAN0_MB03_DATA0()		bfin_read16(CAN0_MB03_DATA0)
#define bfin_write_CAN0_MB03_DATA0(val)		bfin_write16(CAN0_MB03_DATA0, val)
#define bfin_read_CAN0_MB03_DATA1()		bfin_read16(CAN0_MB03_DATA1)
#define bfin_write_CAN0_MB03_DATA1(val)		bfin_write16(CAN0_MB03_DATA1, val)
#define bfin_read_CAN0_MB03_DATA2()		bfin_read16(CAN0_MB03_DATA2)
#define bfin_write_CAN0_MB03_DATA2(val)		bfin_write16(CAN0_MB03_DATA2, val)
#define bfin_read_CAN0_MB03_DATA3()		bfin_read16(CAN0_MB03_DATA3)
#define bfin_write_CAN0_MB03_DATA3(val)		bfin_write16(CAN0_MB03_DATA3, val)
#define bfin_read_CAN0_MB03_LENGTH()		bfin_read16(CAN0_MB03_LENGTH)
#define bfin_write_CAN0_MB03_LENGTH(val)	bfin_write16(CAN0_MB03_LENGTH, val)
#define bfin_read_CAN0_MB03_TIMESTAMP()		bfin_read16(CAN0_MB03_TIMESTAMP)
#define bfin_write_CAN0_MB03_TIMESTAMP(val)	bfin_write16(CAN0_MB03_TIMESTAMP, val)
#define bfin_read_CAN0_MB03_ID0()		bfin_read16(CAN0_MB03_ID0)
#define bfin_write_CAN0_MB03_ID0(val)		bfin_write16(CAN0_MB03_ID0, val)
#define bfin_read_CAN0_MB03_ID1()		bfin_read16(CAN0_MB03_ID1)
#define bfin_write_CAN0_MB03_ID1(val)		bfin_write16(CAN0_MB03_ID1, val)
#define bfin_read_CAN0_MB04_DATA0()		bfin_read16(CAN0_MB04_DATA0)
#define bfin_write_CAN0_MB04_DATA0(val)		bfin_write16(CAN0_MB04_DATA0, val)
#define bfin_read_CAN0_MB04_DATA1()		bfin_read16(CAN0_MB04_DATA1)
#define bfin_write_CAN0_MB04_DATA1(val)		bfin_write16(CAN0_MB04_DATA1, val)
#define bfin_read_CAN0_MB04_DATA2()		bfin_read16(CAN0_MB04_DATA2)
#define bfin_write_CAN0_MB04_DATA2(val)		bfin_write16(CAN0_MB04_DATA2, val)
#define bfin_read_CAN0_MB04_DATA3()		bfin_read16(CAN0_MB04_DATA3)
#define bfin_write_CAN0_MB04_DATA3(val)		bfin_write16(CAN0_MB04_DATA3, val)
#define bfin_read_CAN0_MB04_LENGTH()		bfin_read16(CAN0_MB04_LENGTH)
#define bfin_write_CAN0_MB04_LENGTH(val)	bfin_write16(CAN0_MB04_LENGTH, val)
#define bfin_read_CAN0_MB04_TIMESTAMP()		bfin_read16(CAN0_MB04_TIMESTAMP)
#define bfin_write_CAN0_MB04_TIMESTAMP(val)	bfin_write16(CAN0_MB04_TIMESTAMP, val)
#define bfin_read_CAN0_MB04_ID0()		bfin_read16(CAN0_MB04_ID0)
#define bfin_write_CAN0_MB04_ID0(val)		bfin_write16(CAN0_MB04_ID0, val)
#define bfin_read_CAN0_MB04_ID1()		bfin_read16(CAN0_MB04_ID1)
#define bfin_write_CAN0_MB04_ID1(val)		bfin_write16(CAN0_MB04_ID1, val)
#define bfin_read_CAN0_MB05_DATA0()		bfin_read16(CAN0_MB05_DATA0)
#define bfin_write_CAN0_MB05_DATA0(val)		bfin_write16(CAN0_MB05_DATA0, val)
#define bfin_read_CAN0_MB05_DATA1()		bfin_read16(CAN0_MB05_DATA1)
#define bfin_write_CAN0_MB05_DATA1(val)		bfin_write16(CAN0_MB05_DATA1, val)
#define bfin_read_CAN0_MB05_DATA2()		bfin_read16(CAN0_MB05_DATA2)
#define bfin_write_CAN0_MB05_DATA2(val)		bfin_write16(CAN0_MB05_DATA2, val)
#define bfin_read_CAN0_MB05_DATA3()		bfin_read16(CAN0_MB05_DATA3)
#define bfin_write_CAN0_MB05_DATA3(val)		bfin_write16(CAN0_MB05_DATA3, val)
#define bfin_read_CAN0_MB05_LENGTH()		bfin_read16(CAN0_MB05_LENGTH)
#define bfin_write_CAN0_MB05_LENGTH(val)	bfin_write16(CAN0_MB05_LENGTH, val)
#define bfin_read_CAN0_MB05_TIMESTAMP()		bfin_read16(CAN0_MB05_TIMESTAMP)
#define bfin_write_CAN0_MB05_TIMESTAMP(val)	bfin_write16(CAN0_MB05_TIMESTAMP, val)
#define bfin_read_CAN0_MB05_ID0()		bfin_read16(CAN0_MB05_ID0)
#define bfin_write_CAN0_MB05_ID0(val)		bfin_write16(CAN0_MB05_ID0, val)
#define bfin_read_CAN0_MB05_ID1()		bfin_read16(CAN0_MB05_ID1)
#define bfin_write_CAN0_MB05_ID1(val)		bfin_write16(CAN0_MB05_ID1, val)
#define bfin_read_CAN0_MB06_DATA0()		bfin_read16(CAN0_MB06_DATA0)
#define bfin_write_CAN0_MB06_DATA0(val)		bfin_write16(CAN0_MB06_DATA0, val)
#define bfin_read_CAN0_MB06_DATA1()		bfin_read16(CAN0_MB06_DATA1)
#define bfin_write_CAN0_MB06_DATA1(val)		bfin_write16(CAN0_MB06_DATA1, val)
#define bfin_read_CAN0_MB06_DATA2()		bfin_read16(CAN0_MB06_DATA2)
#define bfin_write_CAN0_MB06_DATA2(val)		bfin_write16(CAN0_MB06_DATA2, val)
#define bfin_read_CAN0_MB06_DATA3()		bfin_read16(CAN0_MB06_DATA3)
#define bfin_write_CAN0_MB06_DATA3(val)		bfin_write16(CAN0_MB06_DATA3, val)
#define bfin_read_CAN0_MB06_LENGTH()		bfin_read16(CAN0_MB06_LENGTH)
#define bfin_write_CAN0_MB06_LENGTH(val)	bfin_write16(CAN0_MB06_LENGTH, val)
#define bfin_read_CAN0_MB06_TIMESTAMP()		bfin_read16(CAN0_MB06_TIMESTAMP)
#define bfin_write_CAN0_MB06_TIMESTAMP(val)	bfin_write16(CAN0_MB06_TIMESTAMP, val)
#define bfin_read_CAN0_MB06_ID0()		bfin_read16(CAN0_MB06_ID0)
#define bfin_write_CAN0_MB06_ID0(val)		bfin_write16(CAN0_MB06_ID0, val)
#define bfin_read_CAN0_MB06_ID1()		bfin_read16(CAN0_MB06_ID1)
#define bfin_write_CAN0_MB06_ID1(val)		bfin_write16(CAN0_MB06_ID1, val)
#define bfin_read_CAN0_MB07_DATA0()		bfin_read16(CAN0_MB07_DATA0)
#define bfin_write_CAN0_MB07_DATA0(val)		bfin_write16(CAN0_MB07_DATA0, val)
#define bfin_read_CAN0_MB07_DATA1()		bfin_read16(CAN0_MB07_DATA1)
#define bfin_write_CAN0_MB07_DATA1(val)		bfin_write16(CAN0_MB07_DATA1, val)
#define bfin_read_CAN0_MB07_DATA2()		bfin_read16(CAN0_MB07_DATA2)
#define bfin_write_CAN0_MB07_DATA2(val)		bfin_write16(CAN0_MB07_DATA2, val)
#define bfin_read_CAN0_MB07_DATA3()		bfin_read16(CAN0_MB07_DATA3)
#define bfin_write_CAN0_MB07_DATA3(val)		bfin_write16(CAN0_MB07_DATA3, val)
#define bfin_read_CAN0_MB07_LENGTH()		bfin_read16(CAN0_MB07_LENGTH)
#define bfin_write_CAN0_MB07_LENGTH(val)	bfin_write16(CAN0_MB07_LENGTH, val)
#define bfin_read_CAN0_MB07_TIMESTAMP()		bfin_read16(CAN0_MB07_TIMESTAMP)
#define bfin_write_CAN0_MB07_TIMESTAMP(val)	bfin_write16(CAN0_MB07_TIMESTAMP, val)
#define bfin_read_CAN0_MB07_ID0()		bfin_read16(CAN0_MB07_ID0)
#define bfin_write_CAN0_MB07_ID0(val)		bfin_write16(CAN0_MB07_ID0, val)
#define bfin_read_CAN0_MB07_ID1()		bfin_read16(CAN0_MB07_ID1)
#define bfin_write_CAN0_MB07_ID1(val)		bfin_write16(CAN0_MB07_ID1, val)
#define bfin_read_CAN0_MB08_DATA0()		bfin_read16(CAN0_MB08_DATA0)
#define bfin_write_CAN0_MB08_DATA0(val)		bfin_write16(CAN0_MB08_DATA0, val)
#define bfin_read_CAN0_MB08_DATA1()		bfin_read16(CAN0_MB08_DATA1)
#define bfin_write_CAN0_MB08_DATA1(val)		bfin_write16(CAN0_MB08_DATA1, val)
#define bfin_read_CAN0_MB08_DATA2()		bfin_read16(CAN0_MB08_DATA2)
#define bfin_write_CAN0_MB08_DATA2(val)		bfin_write16(CAN0_MB08_DATA2, val)
#define bfin_read_CAN0_MB08_DATA3()		bfin_read16(CAN0_MB08_DATA3)
#define bfin_write_CAN0_MB08_DATA3(val)		bfin_write16(CAN0_MB08_DATA3, val)
#define bfin_read_CAN0_MB08_LENGTH()		bfin_read16(CAN0_MB08_LENGTH)
#define bfin_write_CAN0_MB08_LENGTH(val)	bfin_write16(CAN0_MB08_LENGTH, val)
#define bfin_read_CAN0_MB08_TIMESTAMP()		bfin_read16(CAN0_MB08_TIMESTAMP)
#define bfin_write_CAN0_MB08_TIMESTAMP(val)	bfin_write16(CAN0_MB08_TIMESTAMP, val)
#define bfin_read_CAN0_MB08_ID0()		bfin_read16(CAN0_MB08_ID0)
#define bfin_write_CAN0_MB08_ID0(val)		bfin_write16(CAN0_MB08_ID0, val)
#define bfin_read_CAN0_MB08_ID1()		bfin_read16(CAN0_MB08_ID1)
#define bfin_write_CAN0_MB08_ID1(val)		bfin_write16(CAN0_MB08_ID1, val)
#define bfin_read_CAN0_MB09_DATA0()		bfin_read16(CAN0_MB09_DATA0)
#define bfin_write_CAN0_MB09_DATA0(val)		bfin_write16(CAN0_MB09_DATA0, val)
#define bfin_read_CAN0_MB09_DATA1()		bfin_read16(CAN0_MB09_DATA1)
#define bfin_write_CAN0_MB09_DATA1(val)		bfin_write16(CAN0_MB09_DATA1, val)
#define bfin_read_CAN0_MB09_DATA2()		bfin_read16(CAN0_MB09_DATA2)
#define bfin_write_CAN0_MB09_DATA2(val)		bfin_write16(CAN0_MB09_DATA2, val)
#define bfin_read_CAN0_MB09_DATA3()		bfin_read16(CAN0_MB09_DATA3)
#define bfin_write_CAN0_MB09_DATA3(val)		bfin_write16(CAN0_MB09_DATA3, val)
#define bfin_read_CAN0_MB09_LENGTH()		bfin_read16(CAN0_MB09_LENGTH)
#define bfin_write_CAN0_MB09_LENGTH(val)	bfin_write16(CAN0_MB09_LENGTH, val)
#define bfin_read_CAN0_MB09_TIMESTAMP()		bfin_read16(CAN0_MB09_TIMESTAMP)
#define bfin_write_CAN0_MB09_TIMESTAMP(val)	bfin_write16(CAN0_MB09_TIMESTAMP, val)
#define bfin_read_CAN0_MB09_ID0()		bfin_read16(CAN0_MB09_ID0)
#define bfin_write_CAN0_MB09_ID0(val)		bfin_write16(CAN0_MB09_ID0, val)
#define bfin_read_CAN0_MB09_ID1()		bfin_read16(CAN0_MB09_ID1)
#define bfin_write_CAN0_MB09_ID1(val)		bfin_write16(CAN0_MB09_ID1, val)
#define bfin_read_CAN0_MB10_DATA0()		bfin_read16(CAN0_MB10_DATA0)
#define bfin_write_CAN0_MB10_DATA0(val)		bfin_write16(CAN0_MB10_DATA0, val)
#define bfin_read_CAN0_MB10_DATA1()		bfin_read16(CAN0_MB10_DATA1)
#define bfin_write_CAN0_MB10_DATA1(val)		bfin_write16(CAN0_MB10_DATA1, val)
#define bfin_read_CAN0_MB10_DATA2()		bfin_read16(CAN0_MB10_DATA2)
#define bfin_write_CAN0_MB10_DATA2(val)		bfin_write16(CAN0_MB10_DATA2, val)
#define bfin_read_CAN0_MB10_DATA3()		bfin_read16(CAN0_MB10_DATA3)
#define bfin_write_CAN0_MB10_DATA3(val)		bfin_write16(CAN0_MB10_DATA3, val)
#define bfin_read_CAN0_MB10_LENGTH()		bfin_read16(CAN0_MB10_LENGTH)
#define bfin_write_CAN0_MB10_LENGTH(val)	bfin_write16(CAN0_MB10_LENGTH, val)
#define bfin_read_CAN0_MB10_TIMESTAMP()		bfin_read16(CAN0_MB10_TIMESTAMP)
#define bfin_write_CAN0_MB10_TIMESTAMP(val)	bfin_write16(CAN0_MB10_TIMESTAMP, val)
#define bfin_read_CAN0_MB10_ID0()		bfin_read16(CAN0_MB10_ID0)
#define bfin_write_CAN0_MB10_ID0(val)		bfin_write16(CAN0_MB10_ID0, val)
#define bfin_read_CAN0_MB10_ID1()		bfin_read16(CAN0_MB10_ID1)
#define bfin_write_CAN0_MB10_ID1(val)		bfin_write16(CAN0_MB10_ID1, val)
#define bfin_read_CAN0_MB11_DATA0()		bfin_read16(CAN0_MB11_DATA0)
#define bfin_write_CAN0_MB11_DATA0(val)		bfin_write16(CAN0_MB11_DATA0, val)
#define bfin_read_CAN0_MB11_DATA1()		bfin_read16(CAN0_MB11_DATA1)
#define bfin_write_CAN0_MB11_DATA1(val)		bfin_write16(CAN0_MB11_DATA1, val)
#define bfin_read_CAN0_MB11_DATA2()		bfin_read16(CAN0_MB11_DATA2)
#define bfin_write_CAN0_MB11_DATA2(val)		bfin_write16(CAN0_MB11_DATA2, val)
#define bfin_read_CAN0_MB11_DATA3()		bfin_read16(CAN0_MB11_DATA3)
#define bfin_write_CAN0_MB11_DATA3(val)		bfin_write16(CAN0_MB11_DATA3, val)
#define bfin_read_CAN0_MB11_LENGTH()		bfin_read16(CAN0_MB11_LENGTH)
#define bfin_write_CAN0_MB11_LENGTH(val)	bfin_write16(CAN0_MB11_LENGTH, val)
#define bfin_read_CAN0_MB11_TIMESTAMP()		bfin_read16(CAN0_MB11_TIMESTAMP)
#define bfin_write_CAN0_MB11_TIMESTAMP(val)	bfin_write16(CAN0_MB11_TIMESTAMP, val)
#define bfin_read_CAN0_MB11_ID0()		bfin_read16(CAN0_MB11_ID0)
#define bfin_write_CAN0_MB11_ID0(val)		bfin_write16(CAN0_MB11_ID0, val)
#define bfin_read_CAN0_MB11_ID1()		bfin_read16(CAN0_MB11_ID1)
#define bfin_write_CAN0_MB11_ID1(val)		bfin_write16(CAN0_MB11_ID1, val)
#define bfin_read_CAN0_MB12_DATA0()		bfin_read16(CAN0_MB12_DATA0)
#define bfin_write_CAN0_MB12_DATA0(val)		bfin_write16(CAN0_MB12_DATA0, val)
#define bfin_read_CAN0_MB12_DATA1()		bfin_read16(CAN0_MB12_DATA1)
#define bfin_write_CAN0_MB12_DATA1(val)		bfin_write16(CAN0_MB12_DATA1, val)
#define bfin_read_CAN0_MB12_DATA2()		bfin_read16(CAN0_MB12_DATA2)
#define bfin_write_CAN0_MB12_DATA2(val)		bfin_write16(CAN0_MB12_DATA2, val)
#define bfin_read_CAN0_MB12_DATA3()		bfin_read16(CAN0_MB12_DATA3)
#define bfin_write_CAN0_MB12_DATA3(val)		bfin_write16(CAN0_MB12_DATA3, val)
#define bfin_read_CAN0_MB12_LENGTH()		bfin_read16(CAN0_MB12_LENGTH)
#define bfin_write_CAN0_MB12_LENGTH(val)	bfin_write16(CAN0_MB12_LENGTH, val)
#define bfin_read_CAN0_MB12_TIMESTAMP()		bfin_read16(CAN0_MB12_TIMESTAMP)
#define bfin_write_CAN0_MB12_TIMESTAMP(val)	bfin_write16(CAN0_MB12_TIMESTAMP, val)
#define bfin_read_CAN0_MB12_ID0()		bfin_read16(CAN0_MB12_ID0)
#define bfin_write_CAN0_MB12_ID0(val)		bfin_write16(CAN0_MB12_ID0, val)
#define bfin_read_CAN0_MB12_ID1()		bfin_read16(CAN0_MB12_ID1)
#define bfin_write_CAN0_MB12_ID1(val)		bfin_write16(CAN0_MB12_ID1, val)
#define bfin_read_CAN0_MB13_DATA0()		bfin_read16(CAN0_MB13_DATA0)
#define bfin_write_CAN0_MB13_DATA0(val)		bfin_write16(CAN0_MB13_DATA0, val)
#define bfin_read_CAN0_MB13_DATA1()		bfin_read16(CAN0_MB13_DATA1)
#define bfin_write_CAN0_MB13_DATA1(val)		bfin_write16(CAN0_MB13_DATA1, val)
#define bfin_read_CAN0_MB13_DATA2()		bfin_read16(CAN0_MB13_DATA2)
#define bfin_write_CAN0_MB13_DATA2(val)		bfin_write16(CAN0_MB13_DATA2, val)
#define bfin_read_CAN0_MB13_DATA3()		bfin_read16(CAN0_MB13_DATA3)
#define bfin_write_CAN0_MB13_DATA3(val)		bfin_write16(CAN0_MB13_DATA3, val)
#define bfin_read_CAN0_MB13_LENGTH()		bfin_read16(CAN0_MB13_LENGTH)
#define bfin_write_CAN0_MB13_LENGTH(val)	bfin_write16(CAN0_MB13_LENGTH, val)
#define bfin_read_CAN0_MB13_TIMESTAMP()		bfin_read16(CAN0_MB13_TIMESTAMP)
#define bfin_write_CAN0_MB13_TIMESTAMP(val)	bfin_write16(CAN0_MB13_TIMESTAMP, val)
#define bfin_read_CAN0_MB13_ID0()		bfin_read16(CAN0_MB13_ID0)
#define bfin_write_CAN0_MB13_ID0(val)		bfin_write16(CAN0_MB13_ID0, val)
#define bfin_read_CAN0_MB13_ID1()		bfin_read16(CAN0_MB13_ID1)
#define bfin_write_CAN0_MB13_ID1(val)		bfin_write16(CAN0_MB13_ID1, val)
#define bfin_read_CAN0_MB14_DATA0()		bfin_read16(CAN0_MB14_DATA0)
#define bfin_write_CAN0_MB14_DATA0(val)		bfin_write16(CAN0_MB14_DATA0, val)
#define bfin_read_CAN0_MB14_DATA1()		bfin_read16(CAN0_MB14_DATA1)
#define bfin_write_CAN0_MB14_DATA1(val)		bfin_write16(CAN0_MB14_DATA1, val)
#define bfin_read_CAN0_MB14_DATA2()		bfin_read16(CAN0_MB14_DATA2)
#define bfin_write_CAN0_MB14_DATA2(val)		bfin_write16(CAN0_MB14_DATA2, val)
#define bfin_read_CAN0_MB14_DATA3()		bfin_read16(CAN0_MB14_DATA3)
#define bfin_write_CAN0_MB14_DATA3(val)		bfin_write16(CAN0_MB14_DATA3, val)
#define bfin_read_CAN0_MB14_LENGTH()		bfin_read16(CAN0_MB14_LENGTH)
#define bfin_write_CAN0_MB14_LENGTH(val)	bfin_write16(CAN0_MB14_LENGTH, val)
#define bfin_read_CAN0_MB14_TIMESTAMP()		bfin_read16(CAN0_MB14_TIMESTAMP)
#define bfin_write_CAN0_MB14_TIMESTAMP(val)	bfin_write16(CAN0_MB14_TIMESTAMP, val)
#define bfin_read_CAN0_MB14_ID0()		bfin_read16(CAN0_MB14_ID0)
#define bfin_write_CAN0_MB14_ID0(val)		bfin_write16(CAN0_MB14_ID0, val)
#define bfin_read_CAN0_MB14_ID1()		bfin_read16(CAN0_MB14_ID1)
#define bfin_write_CAN0_MB14_ID1(val)		bfin_write16(CAN0_MB14_ID1, val)
#define bfin_read_CAN0_MB15_DATA0()		bfin_read16(CAN0_MB15_DATA0)
#define bfin_write_CAN0_MB15_DATA0(val)		bfin_write16(CAN0_MB15_DATA0, val)
#define bfin_read_CAN0_MB15_DATA1()		bfin_read16(CAN0_MB15_DATA1)
#define bfin_write_CAN0_MB15_DATA1(val)		bfin_write16(CAN0_MB15_DATA1, val)
#define bfin_read_CAN0_MB15_DATA2()		bfin_read16(CAN0_MB15_DATA2)
#define bfin_write_CAN0_MB15_DATA2(val)		bfin_write16(CAN0_MB15_DATA2, val)
#define bfin_read_CAN0_MB15_DATA3()		bfin_read16(CAN0_MB15_DATA3)
#define bfin_write_CAN0_MB15_DATA3(val)		bfin_write16(CAN0_MB15_DATA3, val)
#define bfin_read_CAN0_MB15_LENGTH()		bfin_read16(CAN0_MB15_LENGTH)
#define bfin_write_CAN0_MB15_LENGTH(val)	bfin_write16(CAN0_MB15_LENGTH, val)
#define bfin_read_CAN0_MB15_TIMESTAMP()		bfin_read16(CAN0_MB15_TIMESTAMP)
#define bfin_write_CAN0_MB15_TIMESTAMP(val)	bfin_write16(CAN0_MB15_TIMESTAMP, val)
#define bfin_read_CAN0_MB15_ID0()		bfin_read16(CAN0_MB15_ID0)
#define bfin_write_CAN0_MB15_ID0(val)		bfin_write16(CAN0_MB15_ID0, val)
#define bfin_read_CAN0_MB15_ID1()		bfin_read16(CAN0_MB15_ID1)
#define bfin_write_CAN0_MB15_ID1(val)		bfin_write16(CAN0_MB15_ID1, val)

/* CAN Controller 0 Mailbox Data Registers */

#define bfin_read_CAN0_MB16_DATA0()		bfin_read16(CAN0_MB16_DATA0)
#define bfin_write_CAN0_MB16_DATA0(val)		bfin_write16(CAN0_MB16_DATA0, val)
#define bfin_read_CAN0_MB16_DATA1()		bfin_read16(CAN0_MB16_DATA1)
#define bfin_write_CAN0_MB16_DATA1(val)		bfin_write16(CAN0_MB16_DATA1, val)
#define bfin_read_CAN0_MB16_DATA2()		bfin_read16(CAN0_MB16_DATA2)
#define bfin_write_CAN0_MB16_DATA2(val)		bfin_write16(CAN0_MB16_DATA2, val)
#define bfin_read_CAN0_MB16_DATA3()		bfin_read16(CAN0_MB16_DATA3)
#define bfin_write_CAN0_MB16_DATA3(val)		bfin_write16(CAN0_MB16_DATA3, val)
#define bfin_read_CAN0_MB16_LENGTH()		bfin_read16(CAN0_MB16_LENGTH)
#define bfin_write_CAN0_MB16_LENGTH(val)	bfin_write16(CAN0_MB16_LENGTH, val)
#define bfin_read_CAN0_MB16_TIMESTAMP()		bfin_read16(CAN0_MB16_TIMESTAMP)
#define bfin_write_CAN0_MB16_TIMESTAMP(val)	bfin_write16(CAN0_MB16_TIMESTAMP, val)
#define bfin_read_CAN0_MB16_ID0()		bfin_read16(CAN0_MB16_ID0)
#define bfin_write_CAN0_MB16_ID0(val)		bfin_write16(CAN0_MB16_ID0, val)
#define bfin_read_CAN0_MB16_ID1()		bfin_read16(CAN0_MB16_ID1)
#define bfin_write_CAN0_MB16_ID1(val)		bfin_write16(CAN0_MB16_ID1, val)
#define bfin_read_CAN0_MB17_DATA0()		bfin_read16(CAN0_MB17_DATA0)
#define bfin_write_CAN0_MB17_DATA0(val)		bfin_write16(CAN0_MB17_DATA0, val)
#define bfin_read_CAN0_MB17_DATA1()		bfin_read16(CAN0_MB17_DATA1)
#define bfin_write_CAN0_MB17_DATA1(val)		bfin_write16(CAN0_MB17_DATA1, val)
#define bfin_read_CAN0_MB17_DATA2()		bfin_read16(CAN0_MB17_DATA2)
#define bfin_write_CAN0_MB17_DATA2(val)		bfin_write16(CAN0_MB17_DATA2, val)
#define bfin_read_CAN0_MB17_DATA3()		bfin_read16(CAN0_MB17_DATA3)
#define bfin_write_CAN0_MB17_DATA3(val)		bfin_write16(CAN0_MB17_DATA3, val)
#define bfin_read_CAN0_MB17_LENGTH()		bfin_read16(CAN0_MB17_LENGTH)
#define bfin_write_CAN0_MB17_LENGTH(val)	bfin_write16(CAN0_MB17_LENGTH, val)
#define bfin_read_CAN0_MB17_TIMESTAMP()		bfin_read16(CAN0_MB17_TIMESTAMP)
#define bfin_write_CAN0_MB17_TIMESTAMP(val)	bfin_write16(CAN0_MB17_TIMESTAMP, val)
#define bfin_read_CAN0_MB17_ID0()		bfin_read16(CAN0_MB17_ID0)
#define bfin_write_CAN0_MB17_ID0(val)		bfin_write16(CAN0_MB17_ID0, val)
#define bfin_read_CAN0_MB17_ID1()		bfin_read16(CAN0_MB17_ID1)
#define bfin_write_CAN0_MB17_ID1(val)		bfin_write16(CAN0_MB17_ID1, val)
#define bfin_read_CAN0_MB18_DATA0()		bfin_read16(CAN0_MB18_DATA0)
#define bfin_write_CAN0_MB18_DATA0(val)		bfin_write16(CAN0_MB18_DATA0, val)
#define bfin_read_CAN0_MB18_DATA1()		bfin_read16(CAN0_MB18_DATA1)
#define bfin_write_CAN0_MB18_DATA1(val)		bfin_write16(CAN0_MB18_DATA1, val)
#define bfin_read_CAN0_MB18_DATA2()		bfin_read16(CAN0_MB18_DATA2)
#define bfin_write_CAN0_MB18_DATA2(val)		bfin_write16(CAN0_MB18_DATA2, val)
#define bfin_read_CAN0_MB18_DATA3()		bfin_read16(CAN0_MB18_DATA3)
#define bfin_write_CAN0_MB18_DATA3(val)		bfin_write16(CAN0_MB18_DATA3, val)
#define bfin_read_CAN0_MB18_LENGTH()		bfin_read16(CAN0_MB18_LENGTH)
#define bfin_write_CAN0_MB18_LENGTH(val)	bfin_write16(CAN0_MB18_LENGTH, val)
#define bfin_read_CAN0_MB18_TIMESTAMP()		bfin_read16(CAN0_MB18_TIMESTAMP)
#define bfin_write_CAN0_MB18_TIMESTAMP(val)	bfin_write16(CAN0_MB18_TIMESTAMP, val)
#define bfin_read_CAN0_MB18_ID0()		bfin_read16(CAN0_MB18_ID0)
#define bfin_write_CAN0_MB18_ID0(val)		bfin_write16(CAN0_MB18_ID0, val)
#define bfin_read_CAN0_MB18_ID1()		bfin_read16(CAN0_MB18_ID1)
#define bfin_write_CAN0_MB18_ID1(val)		bfin_write16(CAN0_MB18_ID1, val)
#define bfin_read_CAN0_MB19_DATA0()		bfin_read16(CAN0_MB19_DATA0)
#define bfin_write_CAN0_MB19_DATA0(val)		bfin_write16(CAN0_MB19_DATA0, val)
#define bfin_read_CAN0_MB19_DATA1()		bfin_read16(CAN0_MB19_DATA1)
#define bfin_write_CAN0_MB19_DATA1(val)		bfin_write16(CAN0_MB19_DATA1, val)
#define bfin_read_CAN0_MB19_DATA2()		bfin_read16(CAN0_MB19_DATA2)
#define bfin_write_CAN0_MB19_DATA2(val)		bfin_write16(CAN0_MB19_DATA2, val)
#define bfin_read_CAN0_MB19_DATA3()		bfin_read16(CAN0_MB19_DATA3)
#define bfin_write_CAN0_MB19_DATA3(val)		bfin_write16(CAN0_MB19_DATA3, val)
#define bfin_read_CAN0_MB19_LENGTH()		bfin_read16(CAN0_MB19_LENGTH)
#define bfin_write_CAN0_MB19_LENGTH(val)	bfin_write16(CAN0_MB19_LENGTH, val)
#define bfin_read_CAN0_MB19_TIMESTAMP()		bfin_read16(CAN0_MB19_TIMESTAMP)
#define bfin_write_CAN0_MB19_TIMESTAMP(val)	bfin_write16(CAN0_MB19_TIMESTAMP, val)
#define bfin_read_CAN0_MB19_ID0()		bfin_read16(CAN0_MB19_ID0)
#define bfin_write_CAN0_MB19_ID0(val)		bfin_write16(CAN0_MB19_ID0, val)
#define bfin_read_CAN0_MB19_ID1()		bfin_read16(CAN0_MB19_ID1)
#define bfin_write_CAN0_MB19_ID1(val)		bfin_write16(CAN0_MB19_ID1, val)
#define bfin_read_CAN0_MB20_DATA0()		bfin_read16(CAN0_MB20_DATA0)
#define bfin_write_CAN0_MB20_DATA0(val)		bfin_write16(CAN0_MB20_DATA0, val)
#define bfin_read_CAN0_MB20_DATA1()		bfin_read16(CAN0_MB20_DATA1)
#define bfin_write_CAN0_MB20_DATA1(val)		bfin_write16(CAN0_MB20_DATA1, val)
#define bfin_read_CAN0_MB20_DATA2()		bfin_read16(CAN0_MB20_DATA2)
#define bfin_write_CAN0_MB20_DATA2(val)		bfin_write16(CAN0_MB20_DATA2, val)
#define bfin_read_CAN0_MB20_DATA3()		bfin_read16(CAN0_MB20_DATA3)
#define bfin_write_CAN0_MB20_DATA3(val)		bfin_write16(CAN0_MB20_DATA3, val)
#define bfin_read_CAN0_MB20_LENGTH()		bfin_read16(CAN0_MB20_LENGTH)
#define bfin_write_CAN0_MB20_LENGTH(val)	bfin_write16(CAN0_MB20_LENGTH, val)
#define bfin_read_CAN0_MB20_TIMESTAMP()		bfin_read16(CAN0_MB20_TIMESTAMP)
#define bfin_write_CAN0_MB20_TIMESTAMP(val)	bfin_write16(CAN0_MB20_TIMESTAMP, val)
#define bfin_read_CAN0_MB20_ID0()		bfin_read16(CAN0_MB20_ID0)
#define bfin_write_CAN0_MB20_ID0(val)		bfin_write16(CAN0_MB20_ID0, val)
#define bfin_read_CAN0_MB20_ID1()		bfin_read16(CAN0_MB20_ID1)
#define bfin_write_CAN0_MB20_ID1(val)		bfin_write16(CAN0_MB20_ID1, val)
#define bfin_read_CAN0_MB21_DATA0()		bfin_read16(CAN0_MB21_DATA0)
#define bfin_write_CAN0_MB21_DATA0(val)		bfin_write16(CAN0_MB21_DATA0, val)
#define bfin_read_CAN0_MB21_DATA1()		bfin_read16(CAN0_MB21_DATA1)
#define bfin_write_CAN0_MB21_DATA1(val)		bfin_write16(CAN0_MB21_DATA1, val)
#define bfin_read_CAN0_MB21_DATA2()		bfin_read16(CAN0_MB21_DATA2)
#define bfin_write_CAN0_MB21_DATA2(val)		bfin_write16(CAN0_MB21_DATA2, val)
#define bfin_read_CAN0_MB21_DATA3()		bfin_read16(CAN0_MB21_DATA3)
#define bfin_write_CAN0_MB21_DATA3(val)		bfin_write16(CAN0_MB21_DATA3, val)
#define bfin_read_CAN0_MB21_LENGTH()		bfin_read16(CAN0_MB21_LENGTH)
#define bfin_write_CAN0_MB21_LENGTH(val)	bfin_write16(CAN0_MB21_LENGTH, val)
#define bfin_read_CAN0_MB21_TIMESTAMP()		bfin_read16(CAN0_MB21_TIMESTAMP)
#define bfin_write_CAN0_MB21_TIMESTAMP(val)	bfin_write16(CAN0_MB21_TIMESTAMP, val)
#define bfin_read_CAN0_MB21_ID0()		bfin_read16(CAN0_MB21_ID0)
#define bfin_write_CAN0_MB21_ID0(val)		bfin_write16(CAN0_MB21_ID0, val)
#define bfin_read_CAN0_MB21_ID1()		bfin_read16(CAN0_MB21_ID1)
#define bfin_write_CAN0_MB21_ID1(val)		bfin_write16(CAN0_MB21_ID1, val)
#define bfin_read_CAN0_MB22_DATA0()		bfin_read16(CAN0_MB22_DATA0)
#define bfin_write_CAN0_MB22_DATA0(val)		bfin_write16(CAN0_MB22_DATA0, val)
#define bfin_read_CAN0_MB22_DATA1()		bfin_read16(CAN0_MB22_DATA1)
#define bfin_write_CAN0_MB22_DATA1(val)		bfin_write16(CAN0_MB22_DATA1, val)
#define bfin_read_CAN0_MB22_DATA2()		bfin_read16(CAN0_MB22_DATA2)
#define bfin_write_CAN0_MB22_DATA2(val)		bfin_write16(CAN0_MB22_DATA2, val)
#define bfin_read_CAN0_MB22_DATA3()		bfin_read16(CAN0_MB22_DATA3)
#define bfin_write_CAN0_MB22_DATA3(val)		bfin_write16(CAN0_MB22_DATA3, val)
#define bfin_read_CAN0_MB22_LENGTH()		bfin_read16(CAN0_MB22_LENGTH)
#define bfin_write_CAN0_MB22_LENGTH(val)	bfin_write16(CAN0_MB22_LENGTH, val)
#define bfin_read_CAN0_MB22_TIMESTAMP()		bfin_read16(CAN0_MB22_TIMESTAMP)
#define bfin_write_CAN0_MB22_TIMESTAMP(val)	bfin_write16(CAN0_MB22_TIMESTAMP, val)
#define bfin_read_CAN0_MB22_ID0()		bfin_read16(CAN0_MB22_ID0)
#define bfin_write_CAN0_MB22_ID0(val)		bfin_write16(CAN0_MB22_ID0, val)
#define bfin_read_CAN0_MB22_ID1()		bfin_read16(CAN0_MB22_ID1)
#define bfin_write_CAN0_MB22_ID1(val)		bfin_write16(CAN0_MB22_ID1, val)
#define bfin_read_CAN0_MB23_DATA0()		bfin_read16(CAN0_MB23_DATA0)
#define bfin_write_CAN0_MB23_DATA0(val)		bfin_write16(CAN0_MB23_DATA0, val)
#define bfin_read_CAN0_MB23_DATA1()		bfin_read16(CAN0_MB23_DATA1)
#define bfin_write_CAN0_MB23_DATA1(val)		bfin_write16(CAN0_MB23_DATA1, val)
#define bfin_read_CAN0_MB23_DATA2()		bfin_read16(CAN0_MB23_DATA2)
#define bfin_write_CAN0_MB23_DATA2(val)		bfin_write16(CAN0_MB23_DATA2, val)
#define bfin_read_CAN0_MB23_DATA3()		bfin_read16(CAN0_MB23_DATA3)
#define bfin_write_CAN0_MB23_DATA3(val)		bfin_write16(CAN0_MB23_DATA3, val)
#define bfin_read_CAN0_MB23_LENGTH()		bfin_read16(CAN0_MB23_LENGTH)
#define bfin_write_CAN0_MB23_LENGTH(val)	bfin_write16(CAN0_MB23_LENGTH, val)
#define bfin_read_CAN0_MB23_TIMESTAMP()		bfin_read16(CAN0_MB23_TIMESTAMP)
#define bfin_write_CAN0_MB23_TIMESTAMP(val)	bfin_write16(CAN0_MB23_TIMESTAMP, val)
#define bfin_read_CAN0_MB23_ID0()		bfin_read16(CAN0_MB23_ID0)
#define bfin_write_CAN0_MB23_ID0(val)		bfin_write16(CAN0_MB23_ID0, val)
#define bfin_read_CAN0_MB23_ID1()		bfin_read16(CAN0_MB23_ID1)
#define bfin_write_CAN0_MB23_ID1(val)		bfin_write16(CAN0_MB23_ID1, val)
#define bfin_read_CAN0_MB24_DATA0()		bfin_read16(CAN0_MB24_DATA0)
#define bfin_write_CAN0_MB24_DATA0(val)		bfin_write16(CAN0_MB24_DATA0, val)
#define bfin_read_CAN0_MB24_DATA1()		bfin_read16(CAN0_MB24_DATA1)
#define bfin_write_CAN0_MB24_DATA1(val)		bfin_write16(CAN0_MB24_DATA1, val)
#define bfin_read_CAN0_MB24_DATA2()		bfin_read16(CAN0_MB24_DATA2)
#define bfin_write_CAN0_MB24_DATA2(val)		bfin_write16(CAN0_MB24_DATA2, val)
#define bfin_read_CAN0_MB24_DATA3()		bfin_read16(CAN0_MB24_DATA3)
#define bfin_write_CAN0_MB24_DATA3(val)		bfin_write16(CAN0_MB24_DATA3, val)
#define bfin_read_CAN0_MB24_LENGTH()		bfin_read16(CAN0_MB24_LENGTH)
#define bfin_write_CAN0_MB24_LENGTH(val)	bfin_write16(CAN0_MB24_LENGTH, val)
#define bfin_read_CAN0_MB24_TIMESTAMP()		bfin_read16(CAN0_MB24_TIMESTAMP)
#define bfin_write_CAN0_MB24_TIMESTAMP(val)	bfin_write16(CAN0_MB24_TIMESTAMP, val)
#define bfin_read_CAN0_MB24_ID0()		bfin_read16(CAN0_MB24_ID0)
#define bfin_write_CAN0_MB24_ID0(val)		bfin_write16(CAN0_MB24_ID0, val)
#define bfin_read_CAN0_MB24_ID1()		bfin_read16(CAN0_MB24_ID1)
#define bfin_write_CAN0_MB24_ID1(val)		bfin_write16(CAN0_MB24_ID1, val)
#define bfin_read_CAN0_MB25_DATA0()		bfin_read16(CAN0_MB25_DATA0)
#define bfin_write_CAN0_MB25_DATA0(val)		bfin_write16(CAN0_MB25_DATA0, val)
#define bfin_read_CAN0_MB25_DATA1()		bfin_read16(CAN0_MB25_DATA1)
#define bfin_write_CAN0_MB25_DATA1(val)		bfin_write16(CAN0_MB25_DATA1, val)
#define bfin_read_CAN0_MB25_DATA2()		bfin_read16(CAN0_MB25_DATA2)
#define bfin_write_CAN0_MB25_DATA2(val)		bfin_write16(CAN0_MB25_DATA2, val)
#define bfin_read_CAN0_MB25_DATA3()		bfin_read16(CAN0_MB25_DATA3)
#define bfin_write_CAN0_MB25_DATA3(val)		bfin_write16(CAN0_MB25_DATA3, val)
#define bfin_read_CAN0_MB25_LENGTH()		bfin_read16(CAN0_MB25_LENGTH)
#define bfin_write_CAN0_MB25_LENGTH(val)	bfin_write16(CAN0_MB25_LENGTH, val)
#define bfin_read_CAN0_MB25_TIMESTAMP()		bfin_read16(CAN0_MB25_TIMESTAMP)
#define bfin_write_CAN0_MB25_TIMESTAMP(val)	bfin_write16(CAN0_MB25_TIMESTAMP, val)
#define bfin_read_CAN0_MB25_ID0()		bfin_read16(CAN0_MB25_ID0)
#define bfin_write_CAN0_MB25_ID0(val)		bfin_write16(CAN0_MB25_ID0, val)
#define bfin_read_CAN0_MB25_ID1()		bfin_read16(CAN0_MB25_ID1)
#define bfin_write_CAN0_MB25_ID1(val)		bfin_write16(CAN0_MB25_ID1, val)
#define bfin_read_CAN0_MB26_DATA0()		bfin_read16(CAN0_MB26_DATA0)
#define bfin_write_CAN0_MB26_DATA0(val)		bfin_write16(CAN0_MB26_DATA0, val)
#define bfin_read_CAN0_MB26_DATA1()		bfin_read16(CAN0_MB26_DATA1)
#define bfin_write_CAN0_MB26_DATA1(val)		bfin_write16(CAN0_MB26_DATA1, val)
#define bfin_read_CAN0_MB26_DATA2()		bfin_read16(CAN0_MB26_DATA2)
#define bfin_write_CAN0_MB26_DATA2(val)		bfin_write16(CAN0_MB26_DATA2, val)
#define bfin_read_CAN0_MB26_DATA3()		bfin_read16(CAN0_MB26_DATA3)
#define bfin_write_CAN0_MB26_DATA3(val)		bfin_write16(CAN0_MB26_DATA3, val)
#define bfin_read_CAN0_MB26_LENGTH()		bfin_read16(CAN0_MB26_LENGTH)
#define bfin_write_CAN0_MB26_LENGTH(val)	bfin_write16(CAN0_MB26_LENGTH, val)
#define bfin_read_CAN0_MB26_TIMESTAMP()		bfin_read16(CAN0_MB26_TIMESTAMP)
#define bfin_write_CAN0_MB26_TIMESTAMP(val)	bfin_write16(CAN0_MB26_TIMESTAMP, val)
#define bfin_read_CAN0_MB26_ID0()		bfin_read16(CAN0_MB26_ID0)
#define bfin_write_CAN0_MB26_ID0(val)		bfin_write16(CAN0_MB26_ID0, val)
#define bfin_read_CAN0_MB26_ID1()		bfin_read16(CAN0_MB26_ID1)
#define bfin_write_CAN0_MB26_ID1(val)		bfin_write16(CAN0_MB26_ID1, val)
#define bfin_read_CAN0_MB27_DATA0()		bfin_read16(CAN0_MB27_DATA0)
#define bfin_write_CAN0_MB27_DATA0(val)		bfin_write16(CAN0_MB27_DATA0, val)
#define bfin_read_CAN0_MB27_DATA1()		bfin_read16(CAN0_MB27_DATA1)
#define bfin_write_CAN0_MB27_DATA1(val)		bfin_write16(CAN0_MB27_DATA1, val)
#define bfin_read_CAN0_MB27_DATA2()		bfin_read16(CAN0_MB27_DATA2)
#define bfin_write_CAN0_MB27_DATA2(val)		bfin_write16(CAN0_MB27_DATA2, val)
#define bfin_read_CAN0_MB27_DATA3()		bfin_read16(CAN0_MB27_DATA3)
#define bfin_write_CAN0_MB27_DATA3(val)		bfin_write16(CAN0_MB27_DATA3, val)
#define bfin_read_CAN0_MB27_LENGTH()		bfin_read16(CAN0_MB27_LENGTH)
#define bfin_write_CAN0_MB27_LENGTH(val)	bfin_write16(CAN0_MB27_LENGTH, val)
#define bfin_read_CAN0_MB27_TIMESTAMP()		bfin_read16(CAN0_MB27_TIMESTAMP)
#define bfin_write_CAN0_MB27_TIMESTAMP(val)	bfin_write16(CAN0_MB27_TIMESTAMP, val)
#define bfin_read_CAN0_MB27_ID0()		bfin_read16(CAN0_MB27_ID0)
#define bfin_write_CAN0_MB27_ID0(val)		bfin_write16(CAN0_MB27_ID0, val)
#define bfin_read_CAN0_MB27_ID1()		bfin_read16(CAN0_MB27_ID1)
#define bfin_write_CAN0_MB27_ID1(val)		bfin_write16(CAN0_MB27_ID1, val)
#define bfin_read_CAN0_MB28_DATA0()		bfin_read16(CAN0_MB28_DATA0)
#define bfin_write_CAN0_MB28_DATA0(val)		bfin_write16(CAN0_MB28_DATA0, val)
#define bfin_read_CAN0_MB28_DATA1()		bfin_read16(CAN0_MB28_DATA1)
#define bfin_write_CAN0_MB28_DATA1(val)		bfin_write16(CAN0_MB28_DATA1, val)
#define bfin_read_CAN0_MB28_DATA2()		bfin_read16(CAN0_MB28_DATA2)
#define bfin_write_CAN0_MB28_DATA2(val)		bfin_write16(CAN0_MB28_DATA2, val)
#define bfin_read_CAN0_MB28_DATA3()		bfin_read16(CAN0_MB28_DATA3)
#define bfin_write_CAN0_MB28_DATA3(val)		bfin_write16(CAN0_MB28_DATA3, val)
#define bfin_read_CAN0_MB28_LENGTH()		bfin_read16(CAN0_MB28_LENGTH)
#define bfin_write_CAN0_MB28_LENGTH(val)	bfin_write16(CAN0_MB28_LENGTH, val)
#define bfin_read_CAN0_MB28_TIMESTAMP()		bfin_read16(CAN0_MB28_TIMESTAMP)
#define bfin_write_CAN0_MB28_TIMESTAMP(val)	bfin_write16(CAN0_MB28_TIMESTAMP, val)
#define bfin_read_CAN0_MB28_ID0()		bfin_read16(CAN0_MB28_ID0)
#define bfin_write_CAN0_MB28_ID0(val)		bfin_write16(CAN0_MB28_ID0, val)
#define bfin_read_CAN0_MB28_ID1()		bfin_read16(CAN0_MB28_ID1)
#define bfin_write_CAN0_MB28_ID1(val)		bfin_write16(CAN0_MB28_ID1, val)
#define bfin_read_CAN0_MB29_DATA0()		bfin_read16(CAN0_MB29_DATA0)
#define bfin_write_CAN0_MB29_DATA0(val)		bfin_write16(CAN0_MB29_DATA0, val)
#define bfin_read_CAN0_MB29_DATA1()		bfin_read16(CAN0_MB29_DATA1)
#define bfin_write_CAN0_MB29_DATA1(val)		bfin_write16(CAN0_MB29_DATA1, val)
#define bfin_read_CAN0_MB29_DATA2()		bfin_read16(CAN0_MB29_DATA2)
#define bfin_write_CAN0_MB29_DATA2(val)		bfin_write16(CAN0_MB29_DATA2, val)
#define bfin_read_CAN0_MB29_DATA3()		bfin_read16(CAN0_MB29_DATA3)
#define bfin_write_CAN0_MB29_DATA3(val)		bfin_write16(CAN0_MB29_DATA3, val)
#define bfin_read_CAN0_MB29_LENGTH()		bfin_read16(CAN0_MB29_LENGTH)
#define bfin_write_CAN0_MB29_LENGTH(val)	bfin_write16(CAN0_MB29_LENGTH, val)
#define bfin_read_CAN0_MB29_TIMESTAMP()		bfin_read16(CAN0_MB29_TIMESTAMP)
#define bfin_write_CAN0_MB29_TIMESTAMP(val)	bfin_write16(CAN0_MB29_TIMESTAMP, val)
#define bfin_read_CAN0_MB29_ID0()		bfin_read16(CAN0_MB29_ID0)
#define bfin_write_CAN0_MB29_ID0(val)		bfin_write16(CAN0_MB29_ID0, val)
#define bfin_read_CAN0_MB29_ID1()		bfin_read16(CAN0_MB29_ID1)
#define bfin_write_CAN0_MB29_ID1(val)		bfin_write16(CAN0_MB29_ID1, val)
#define bfin_read_CAN0_MB30_DATA0()		bfin_read16(CAN0_MB30_DATA0)
#define bfin_write_CAN0_MB30_DATA0(val)		bfin_write16(CAN0_MB30_DATA0, val)
#define bfin_read_CAN0_MB30_DATA1()		bfin_read16(CAN0_MB30_DATA1)
#define bfin_write_CAN0_MB30_DATA1(val)		bfin_write16(CAN0_MB30_DATA1, val)
#define bfin_read_CAN0_MB30_DATA2()		bfin_read16(CAN0_MB30_DATA2)
#define bfin_write_CAN0_MB30_DATA2(val)		bfin_write16(CAN0_MB30_DATA2, val)
#define bfin_read_CAN0_MB30_DATA3()		bfin_read16(CAN0_MB30_DATA3)
#define bfin_write_CAN0_MB30_DATA3(val)		bfin_write16(CAN0_MB30_DATA3, val)
#define bfin_read_CAN0_MB30_LENGTH()		bfin_read16(CAN0_MB30_LENGTH)
#define bfin_write_CAN0_MB30_LENGTH(val)	bfin_write16(CAN0_MB30_LENGTH, val)
#define bfin_read_CAN0_MB30_TIMESTAMP()		bfin_read16(CAN0_MB30_TIMESTAMP)
#define bfin_write_CAN0_MB30_TIMESTAMP(val)	bfin_write16(CAN0_MB30_TIMESTAMP, val)
#define bfin_read_CAN0_MB30_ID0()		bfin_read16(CAN0_MB30_ID0)
#define bfin_write_CAN0_MB30_ID0(val)		bfin_write16(CAN0_MB30_ID0, val)
#define bfin_read_CAN0_MB30_ID1()		bfin_read16(CAN0_MB30_ID1)
#define bfin_write_CAN0_MB30_ID1(val)		bfin_write16(CAN0_MB30_ID1, val)
#define bfin_read_CAN0_MB31_DATA0()		bfin_read16(CAN0_MB31_DATA0)
#define bfin_write_CAN0_MB31_DATA0(val)		bfin_write16(CAN0_MB31_DATA0, val)
#define bfin_read_CAN0_MB31_DATA1()		bfin_read16(CAN0_MB31_DATA1)
#define bfin_write_CAN0_MB31_DATA1(val)		bfin_write16(CAN0_MB31_DATA1, val)
#define bfin_read_CAN0_MB31_DATA2()		bfin_read16(CAN0_MB31_DATA2)
#define bfin_write_CAN0_MB31_DATA2(val)		bfin_write16(CAN0_MB31_DATA2, val)
#define bfin_read_CAN0_MB31_DATA3()		bfin_read16(CAN0_MB31_DATA3)
#define bfin_write_CAN0_MB31_DATA3(val)		bfin_write16(CAN0_MB31_DATA3, val)
#define bfin_read_CAN0_MB31_LENGTH()		bfin_read16(CAN0_MB31_LENGTH)
#define bfin_write_CAN0_MB31_LENGTH(val)	bfin_write16(CAN0_MB31_LENGTH, val)
#define bfin_read_CAN0_MB31_TIMESTAMP()		bfin_read16(CAN0_MB31_TIMESTAMP)
#define bfin_write_CAN0_MB31_TIMESTAMP(val)	bfin_write16(CAN0_MB31_TIMESTAMP, val)
#define bfin_read_CAN0_MB31_ID0()		bfin_read16(CAN0_MB31_ID0)
#define bfin_write_CAN0_MB31_ID0(val)		bfin_write16(CAN0_MB31_ID0, val)
#define bfin_read_CAN0_MB31_ID1()		bfin_read16(CAN0_MB31_ID1)
#define bfin_write_CAN0_MB31_ID1(val)		bfin_write16(CAN0_MB31_ID1, val)

/* UART3 Registers */

#define bfin_read_UART3_DLL()		bfin_read16(UART3_DLL)
#define bfin_write_UART3_DLL(val)	bfin_write16(UART3_DLL, val)
#define bfin_read_UART3_DLH()		bfin_read16(UART3_DLH)
#define bfin_write_UART3_DLH(val)	bfin_write16(UART3_DLH, val)
#define bfin_read_UART3_GCTL()		bfin_read16(UART3_GCTL)
#define bfin_write_UART3_GCTL(val)	bfin_write16(UART3_GCTL, val)
#define bfin_read_UART3_LCR()		bfin_read16(UART3_LCR)
#define bfin_write_UART3_LCR(val)	bfin_write16(UART3_LCR, val)
#define bfin_read_UART3_MCR()		bfin_read16(UART3_MCR)
#define bfin_write_UART3_MCR(val)	bfin_write16(UART3_MCR, val)
#define bfin_read_UART3_LSR()		bfin_read16(UART3_LSR)
#define bfin_write_UART3_LSR(val)	bfin_write16(UART3_LSR, val)
#define bfin_read_UART3_MSR()		bfin_read16(UART3_MSR)
#define bfin_write_UART3_MSR(val)	bfin_write16(UART3_MSR, val)
#define bfin_read_UART3_SCR()		bfin_read16(UART3_SCR)
#define bfin_write_UART3_SCR(val)	bfin_write16(UART3_SCR, val)
#define bfin_read_UART3_IER_SET()	bfin_read16(UART3_IER_SET)
#define bfin_write_UART3_IER_SET(val)	bfin_write16(UART3_IER_SET, val)
#define bfin_read_UART3_IER_CLEAR()	bfin_read16(UART3_IER_CLEAR)
#define bfin_write_UART3_IER_CLEAR(val)	bfin_write16(UART3_IER_CLEAR, val)
#define bfin_read_UART3_THR()		bfin_read16(UART3_THR)
#define bfin_write_UART3_THR(val)	bfin_write16(UART3_THR, val)
#define bfin_read_UART3_RBR()		bfin_read16(UART3_RBR)
#define bfin_write_UART3_RBR(val)	bfin_write16(UART3_RBR, val)

/* NFC Registers */

#define bfin_read_NFC_CTL()		bfin_read16(NFC_CTL)
#define bfin_write_NFC_CTL(val)		bfin_write16(NFC_CTL, val)
#define bfin_read_NFC_STAT()		bfin_read16(NFC_STAT)
#define bfin_write_NFC_STAT(val)	bfin_write16(NFC_STAT, val)
#define bfin_read_NFC_IRQSTAT()		bfin_read16(NFC_IRQSTAT)
#define bfin_write_NFC_IRQSTAT(val)	bfin_write16(NFC_IRQSTAT, val)
#define bfin_read_NFC_IRQMASK()		bfin_read16(NFC_IRQMASK)
#define bfin_write_NFC_IRQMASK(val)	bfin_write16(NFC_IRQMASK, val)
#define bfin_read_NFC_ECC0()		bfin_read16(NFC_ECC0)
#define bfin_write_NFC_ECC0(val)	bfin_write16(NFC_ECC0, val)
#define bfin_read_NFC_ECC1()		bfin_read16(NFC_ECC1)
#define bfin_write_NFC_ECC1(val)	bfin_write16(NFC_ECC1, val)
#define bfin_read_NFC_ECC2()		bfin_read16(NFC_ECC2)
#define bfin_write_NFC_ECC2(val)	bfin_write16(NFC_ECC2, val)
#define bfin_read_NFC_ECC3()		bfin_read16(NFC_ECC3)
#define bfin_write_NFC_ECC3(val)	bfin_write16(NFC_ECC3, val)
#define bfin_read_NFC_COUNT()		bfin_read16(NFC_COUNT)
#define bfin_write_NFC_COUNT(val)	bfin_write16(NFC_COUNT, val)
#define bfin_read_NFC_RST()		bfin_read16(NFC_RST)
#define bfin_write_NFC_RST(val)		bfin_write16(NFC_RST, val)
#define bfin_read_NFC_PGCTL()		bfin_read16(NFC_PGCTL)
#define bfin_write_NFC_PGCTL(val)	bfin_write16(NFC_PGCTL, val)
#define bfin_read_NFC_READ()		bfin_read16(NFC_READ)
#define bfin_write_NFC_READ(val)	bfin_write16(NFC_READ, val)
#define bfin_read_NFC_ADDR()		bfin_read16(NFC_ADDR)
#define bfin_write_NFC_ADDR(val)	bfin_write16(NFC_ADDR, val)
#define bfin_read_NFC_CMD()		bfin_read16(NFC_CMD)
#define bfin_write_NFC_CMD(val)		bfin_write16(NFC_CMD, val)
#define bfin_read_NFC_DATA_WR()		bfin_read16(NFC_DATA_WR)
#define bfin_write_NFC_DATA_WR(val)	bfin_write16(NFC_DATA_WR, val)
#define bfin_read_NFC_DATA_RD()		bfin_read16(NFC_DATA_RD)
#define bfin_write_NFC_DATA_RD(val)	bfin_write16(NFC_DATA_RD, val)

/* Counter Registers */

#define bfin_read_CNT_CONFIG()		bfin_read16(CNT_CONFIG)
#define bfin_write_CNT_CONFIG(val)	bfin_write16(CNT_CONFIG, val)
#define bfin_read_CNT_IMASK()		bfin_read16(CNT_IMASK)
#define bfin_write_CNT_IMASK(val)	bfin_write16(CNT_IMASK, val)
#define bfin_read_CNT_STATUS()		bfin_read16(CNT_STATUS)
#define bfin_write_CNT_STATUS(val)	bfin_write16(CNT_STATUS, val)
#define bfin_read_CNT_COMMAND()		bfin_read16(CNT_COMMAND)
#define bfin_write_CNT_COMMAND(val)	bfin_write16(CNT_COMMAND, val)
#define bfin_read_CNT_DEBOUNCE()	bfin_read16(CNT_DEBOUNCE)
#define bfin_write_CNT_DEBOUNCE(val)	bfin_write16(CNT_DEBOUNCE, val)
#define bfin_read_CNT_COUNTER()		bfin_read32(CNT_COUNTER)
#define bfin_write_CNT_COUNTER(val)	bfin_write32(CNT_COUNTER, val)
#define bfin_read_CNT_MAX()		bfin_read32(CNT_MAX)
#define bfin_write_CNT_MAX(val)		bfin_write32(CNT_MAX, val)
#define bfin_read_CNT_MIN()		bfin_read32(CNT_MIN)
#define bfin_write_CNT_MIN(val)		bfin_write32(CNT_MIN, val)

/* Security Registers */

#define bfin_read_SECURE_SYSSWT()	bfin_read32(SECURE_SYSSWT)
#define bfin_write_SECURE_SYSSWT(val)	bfin_write32(SECURE_SYSSWT, val)
#define bfin_read_SECURE_CONTROL()	bfin_read16(SECURE_CONTROL)
#define bfin_write_SECURE_CONTROL(val)	bfin_write16(SECURE_CONTROL, val)
#define bfin_read_SECURE_STATUS()	bfin_read16(SECURE_STATUS)
#define bfin_write_SECURE_STATUS(val)	bfin_write16(SECURE_STATUS, val)

/* DMA Peribfin_read_()heral Mux Register */

#define bfin_read_DMAC1_PERIMUX()	bfin_read16(DMAC1_PERIMUX)
#define bfin_write_DMAC1_PERIMUX(val)	bfin_write16(DMAC1_PERIMUX, val)

/* Handshake MDMA is not defined in the shared file because it is not available on the ADSP-BF542 bfin_read_()rocessor */

/* legacy definitions */
#define bfin_read_EBIU_AMCBCTL0		bfin_read_EBIU_AMBCTL0
#define bfin_write_EBIU_AMCBCTL0	bfin_write_EBIU_AMBCTL0
#define bfin_read_EBIU_AMCBCTL1		bfin_read_EBIU_AMBCTL1
#define bfin_write_EBIU_AMCBCTL1	bfin_write_EBIU_AMBCTL1
#define bfin_read_PINT0_IRQ		bfin_read_PINT0_REQUEST
#define bfin_write_PINT0_IRQ		bfin_write_PINT0_REQUEST
#define bfin_read_PINT1_IRQ		bfin_read_PINT1_REQUEST
#define bfin_write_PINT1_IRQ		bfin_write_PINT1_REQUEST
#define bfin_read_PINT2_IRQ		bfin_read_PINT2_REQUEST
#define bfin_write_PINT2_IRQ		bfin_write_PINT2_REQUEST
#define bfin_read_PINT3_IRQ		bfin_read_PINT3_REQUEST
#define bfin_write_PINT3_IRQ		bfin_write_PINT3_REQUEST

/* These need to be last due to the cdef/linux inter-dependencies */
#include <asm/irq.h>

/* Writing to PLL_CTL initiates a PLL relock sequence. */
static __inline__ void bfin_write_PLL_CTL(unsigned int val)
{
	unsigned long flags, iwr0, iwr1, iwr2;

	if (val == bfin_read_PLL_CTL())
		return;

	local_irq_save_hw(flags);
	/* Enable the PLL Wakeup bit in SIC IWR */
	iwr0 = bfin_read32(SIC_IWR0);
	iwr1 = bfin_read32(SIC_IWR1);
	iwr2 = bfin_read32(SIC_IWR2);
	/* Only allow PPL Wakeup) */
	bfin_write32(SIC_IWR0, IWR_ENABLE(0));
	bfin_write32(SIC_IWR1, 0);
	bfin_write32(SIC_IWR2, 0);

	bfin_write16(PLL_CTL, val);
	SSYNC();
	asm("IDLE;");

	bfin_write32(SIC_IWR0, iwr0);
	bfin_write32(SIC_IWR1, iwr1);
	bfin_write32(SIC_IWR2, iwr2);
	local_irq_restore_hw(flags);
}

/* Writing to VR_CTL initiates a PLL relock sequence. */
static __inline__ void bfin_write_VR_CTL(unsigned int val)
{
	unsigned long flags, iwr0, iwr1, iwr2;

	if (val == bfin_read_VR_CTL())
		return;

	local_irq_save_hw(flags);
	/* Enable the PLL Wakeup bit in SIC IWR */
	iwr0 = bfin_read32(SIC_IWR0);
	iwr1 = bfin_read32(SIC_IWR1);
	iwr2 = bfin_read32(SIC_IWR2);
	/* Only allow PPL Wakeup) */
	bfin_write32(SIC_IWR0, IWR_ENABLE(0));
	bfin_write32(SIC_IWR1, 0);
	bfin_write32(SIC_IWR2, 0);

	bfin_write16(VR_CTL, val);
	SSYNC();
	asm("IDLE;");

	bfin_write32(SIC_IWR0, iwr0);
	bfin_write32(SIC_IWR1, iwr1);
	bfin_write32(SIC_IWR2, iwr2);
	local_irq_restore_hw(flags);
}

#endif /* _CDEF_BF54X_H */

